// Contours.fx
//
// Copyright Outerspace Software, all rights reserved

string description = "A contours effect";

float4x4	WorldViewProjection;
float4		DiffuseCol;
float4		TextureResolution0 = float4(256,256,1,0);


float4 Prop0
<
string UIName="Line Width";
float UIMin=1;
float UIMax=5;
float3 UIDefault=float3(1,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(1,0,0,0);

float4 Prop1
<
string UIName="Contrast";
float UIMin=0;
float UIMax=5;
float3 UIDefault=float3(2,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(2,0,0,0);


texture MyTexture0;
sampler Samp = sampler_state{
    Texture   = (MyTexture0);
    AddressU  = CLAMP;
    AddressV  = CLAMP;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float2 tex:			TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;	
	output.position	=	mul(input.position,WorldViewProjection);
    output.tex		=	input.tex;     
    return output;
}



float d[5] = {-2,-1,0,1,2};

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;
	
	float xr = 1.0/TextureResolution0.x;
	float yr = 1.0/TextureResolution0.y;
	
	float4 min=float4(1,1,1,1);
	float4 max=float4(0,0,0,1);

	int k=Prop0.x;

	for(int i=0; i<5; i++){
	if(i>k) continue;
	for(int j=0; j<5; j++){
		if(j>k) continue;

		float4 c = tex2D(Samp,input.tex + float2(i*xr,j*yr));
		c.xyz*=c.w;

		if(c.x<min.x) min.x=c.x;
		if(c.y<min.y) min.y=c.y;
		if(c.z<min.z) min.z=c.z;

		if(c.x>max.x) max.x=c.x;
		if(c.y>max.y) max.y=c.y;
		if(c.z>max.z) max.z=c.z;
	}
	}

	float f = (max.x-min.x) + (max.y-min.y) + (max.z-min.z);

	f=1-saturate(f);

	f=0.5 + Prop1.x*(f-0.5);	
	f=1-saturate(f);

	output.color = float4(f,f,f,f);
	output.color *= DiffuseCol;
	return output;
}

technique pixels{
    pass p0{   
		Alphablendenable	= TRUE;
		SRCBLEND		= SRCALPHA;
		DESTBLEND		= INVSRCALPHA;

		VertexShader = compile vs_3_0 VS();
		PixelShader  = compile ps_3_0 PS();
    }
}



