// Distorting Mirror Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This effect filters the first texture. The second texture is not used.";
bool optimization=false;


float4x4	WorldViewProjection;
float		Time;
float4		DiffuseCol;
float4		UVBounds0;


float PI=3.14159;

float4 Prop0
<
string UIName="Period";
float UIMin=0;
float UIMax=10;
float3 UIDefault=float3(3,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(3,0,0,0);


float4 Prop1
<
string UIName="Centre";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0.5,0.5,0);
int UISliders=2;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0.5,0.5,0,0);


float4 Prop2
<
string UIName="Amplitude";
float UIMin=0;
float UIMax=2;
float3 UIDefault=float3(1,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(1,0,0,0);




texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
   Texture = <MyTexture0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
    float4 position:	POSITION;
    float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:	COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	output.position = mul(input.position, WorldViewProjection);
	output.tex = input.tex.xy;
	return output;
}

float2 Normal2UVBounds(float2 inUV){
	inUV.x = UVBounds0.x + inUV.x*(UVBounds0.y-UVBounds0.x);
	inUV.y = UVBounds0.z + inUV.y*(UVBounds0.w-UVBounds0.z);
	return inUV;
}

float2 UVBounds2Normal(float2 inUV){
	inUV.x = (inUV.x-UVBounds0.x)/(UVBounds0.y-UVBounds0.x);
	inUV.y = (inUV.y-UVBounds0.z)/(UVBounds0.w-UVBounds0.z);
	return inUV;
}

float2 GetUV(float2 inUV){
	float2 UV=UVBounds2Normal(inUV);

	float2 c = Prop1.xy;
	float d=(UV.x-c.x)*(UV.x-c.x) + (UV.y-c.y)*(UV.y-c.y);
	if(d>0 && d<0.25){
	
		d=0.25-d;
		d=-d;
	
		float2 v = (UV-c) * d;
		
		v=sin((Time*PI*2)/Prop0.x)*v*Prop2.x;

		UV -= c;
		UV += v;
		UV += c;
	}

	return Normal2UVBounds(UV);
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

	float2 UV=GetUV(input.tex);

	output.color = tex2D(MyTextureSampler0, UV);
	output.color.w *= DiffuseCol.w;
	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_3_0 VS();
        PixelShader  = compile ps_3_0 PS();
    }
}

