// Double Vision Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This effect filters the first texture. The second texture is not used.";
bool optimization=false;

float4x4	WorldViewProjection;
float4		DiffuseCol;
float4		TextureResolution0 = float4(256,256,1,0);


float4 Prop0
<
string UIName="Displacement";
float UIMin=0;
float UIMax=5;
float3 UIDefault=float3(1,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(1,0,0,0);



texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
   Texture = <MyTexture0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Clamp;
   AddressV  = Clamp;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

struct VS_OUTPUT{
    float4 position:	POSITION;
    float2 tex:			TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	output.position = mul(input.position, WorldViewProjection);
	output.tex = input.tex.xy;
	return output;
}


PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

	float d=Prop0.x / TextureResolution0.x;

   
    float4 c = tex2D(MyTextureSampler0, input.tex);
    c += tex2D(MyTextureSampler0, input.tex + float2(d*8,0)) * 0.8;
    c += tex2D(MyTextureSampler0, input.tex + float2(d*16,0)) * 0.6;
    c += tex2D(MyTextureSampler0, input.tex + float2(d*24,0)) * 0.4;
    c += tex2D(MyTextureSampler0, input.tex + float2(d*32,0)) * 0.2;
    
    c /= 3.0f;
    
    output.color = c;
    output.color.w *= DiffuseCol.w;

    return output;
}


technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}
