// EternalZoom.fx
//
// Copyright Outerspace Software, all rights reserved

string description = "Eternal Zoom Animation";
bool optimization=false;


float4x4	WorldViewProjection;
float 		Time;
float4		DiffuseCol;

//Tweakables
float	Res=64;
float	Period=6;
float 	P = 2;  	// P^Period=Res

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

VS_OUTPUT VS0(VS_INPUT input){
	VS_OUTPUT output;	
	float t = Time % Period;

	float2 uv = input.tex;

	uv -= float2(0.5,0.5);
	uv /= pow(P,t);
	uv += float2(0.5,0.5);

	output.position = mul(input.position,WorldViewProjection);
	output.diffuse	= float4(1,1,1,DiffuseCol.w);
	output.tex 	= uv;
	return output;
}

VS_OUTPUT VS1(VS_INPUT input){
	VS_OUTPUT output;	
	float t = Time % Period;

	float2 uv = input.tex;

	uv -= float2(0.5,0.5);
	uv /= pow(P,t);
	uv += float2(0.5,0.5);

	uv += float2(0.5,0.5) / Res;
	uv *= Res;

	output.position = mul(input.position,WorldViewProjection);

	float a = (DiffuseCol.w*t)/Period;

	output.diffuse	= float4(1,1,1,a);
	output.tex 	= uv;
	return output;
}

technique pixels{

	pass p0{
		ADDRESSU[0] = WRAP;
		ADDRESSV[0] = WRAP;    

		VertexShader = compile vs_1_1 VS0();
	} 

	pass p1{
		ADDRESSU[0] = WRAP;
		ADDRESSV[0] = WRAP;    

//		ALPHAARG1[0]=DIFFUSE;
//		ALPHAOP[0]=SELECTARG1;

		ALPHAARG1[0]=TEXTURE;
		ALPHAARG2[0]=DIFFUSE;
		ALPHAOP[0]=MODULATE;

//		ZFunc			= LESSEQUAL;
		ZFunc			= ALWAYS;

		Alphablendenable	= TRUE;
		SRCBLEND		= SRCALPHA;
		DESTBLEND		= INVSRCALPHA;

	        VertexShader = compile vs_1_1 VS1();
	}

}
