// FilmGrain.fx
//
// Copyright Outerspace Software, all rights reserved

string description = "Film Grain Filter Effect. This effect makes your texture look as if it's seen through frosted glass.";

float4x4	WorldViewProjection;
float4		DiffuseCol;
float		Time;
float		PI2=2*3.14159;

texture MyTexture0;
sampler MyTextureSampler0 = sampler_state{
    Texture   = (MyTexture0);
    AddressU  = CLAMP;
    AddressV  = CLAMP;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;		
	output.position = mul(input.position,WorldViewProjection);
	output.tex = input.tex;	
	return output;
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;
	
	int dirty = 10;
	
	float2 t = input.tex;		
	float x=t.x*t.y*123456;
	x=fmod(x,13) * fmod(x,123);	
	
	float dx = fmod(x,0.01);
	float dy = fmod(x,0.012);
	float4 c=tex2D(MyTextureSampler0, t+float2(dx,dy));		
		
	output.color = DiffuseCol*c;    
	return output;
}

technique pixels{
    pass p0
    {   
	VertexShader = compile vs_1_0 VS();
	PixelShader  = compile ps_2_0 PS();
    }
}

