// LineArt.fx
//
// Copyright Outerspace Software, all rights reserved

string description = "This shader renders a texture as vertical lines. The thickness of the line depends on the brightness.";

float4x4	WorldViewProjection;
float4		DiffuseCol;

float4 Prop0
<
string UIName="Lines";
float UIMin=0;
float UIMax=60;
float3 UIDefault=float3(40,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=true;
int UIWidget=0;
> = float4(40,0,0,0);

texture MyTexture0;
sampler Samp = sampler_state{
    Texture   = (MyTexture0);
    AddressU  = CLAMP;
    AddressV  = CLAMP;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;	
	output.position = mul(input.position,WorldViewProjection);
    output.tex		= input.tex;     
    return output;
}


float4 GetColour(float2 inUV){
    float x = inUV.x;
    
    int xi = x*Prop0.x;
    float x2 = ((float)xi)  / Prop0.x;
    
    float f = (x-x2) * Prop0.x;      
    if(f>0.5) f=1-f;
    
    float4 r = tex2D(Samp,float2(x2,inUV.y));       
    float g = (r.x+r.y+r.z)/3;

    g*=0.5;
      
    if(f>0.45)
	g=1;
    else if(f<0.5-g)
	g=0;
    else{
	f=0.45-f;
	g=1-f/g;
    }	

    r.xyz=g*DiffuseCol.xyz + (1-g)*(1-DiffuseCol.xyz);
    r.w*=DiffuseCol.w * g;    
    return r;
}

PS_OUTPUT PS(VS_OUTPUT input){
    PS_OUTPUT output;
    output.color=GetColour(input.tex);
    return output;
}

technique pixels{
    pass p0{   
	VertexShader = compile vs_2_0 VS();
	PixelShader  = compile ps_2_0 PS();
    }
}

