// Median.fx
//
// Copyright Outerspace Software, all rights reserved

string description = "Median Filter";
bool optimization=false;

float4x4	WorldViewProjection;
float4		DiffuseCol;
float4		TextureResolution0 = float4(256,256,1,0);


float4 Prop0
<
string UIName="Median Radius";
float UIMin=0;
float UIMax=10;
float3 UIDefault=float3(1,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(1,0,0,0);


texture MyTexture0;
sampler Samp = sampler_state{
    Texture   = (MyTexture0);
    AddressU  = CLAMP;
    AddressV  = CLAMP;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;		
	output.position = mul(input.position,WorldViewProjection);
	output.tex = input.tex;	
	return output;
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

	float xr = Prop0.x/TextureResolution0.x;
	float yr = Prop0.x/TextureResolution0.y;
	
	float4 r[9];
	for(int i=0; i<9; i++){
		r[i] = float4(0,0,0,1); 
	}

	int t=0;
	for(int i=-1; i<=1; i++){
	for(int j=-1; j<=1; j++){
		r[t] = tex2D(Samp,input.tex + float2(i*xr,j*yr));
		r[t].xyz *= r[t].w;
		t++;
	}
	}

	float4 c = float4(0,0,0,1);
	
	int vmin=100;
	for(int i=0; i<9; i++){
		int v=0;
		for(int j=0; j<9; j++){
			if(i==j) continue;
			if(r[j].x > r[i].x) v++;

			if(r[j].y > r[i].y) v++;

			if(r[j].z > r[i].z) v++;
		}

		v=abs(v-4);

		if(v<vmin){
			c=r[i];
			vmin=v;
		}
	}


	output.color = c;

	output.color *= DiffuseCol;
	return output;
}

technique pixels{
    pass p0{
	VertexShader = compile vs_3_0 VS();
	PixelShader  = compile ps_3_0 PS();
    }
}
