// Model Repeat Mask Shader
//
// Copyright Outerspace Software, all rights reserved

string description = "Use this effect with the picture layer. In most cases you want the 'FX Model Repeat' property to match the 'Model Repeat' property.";

float4x4	World;
float4x4	ViewProjection;
float4x4	WorldInverseTranspose;
float4		LightPos;
float4		EyePos;

float4		AmbientCol;
float4		DiffuseCol;
float4		SpecularCol;
float		Power = 100;

float4		CharacterIndex;
float4		UVBounds0 = float4(0,1,0,1);

float4 Prop0
<
string UIName="Model Repeat";
float UIMin=1;
float UIMax=10;
float3 UIDefault=float3(3,3,0);
int UISliders=2;
float UIScale=1;
bool UIInteger=true;
int UIWidget=0;
> = float4(3,3,0,0);

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;      

	float4 WorldPos = mul(input.position, World);
	output.position = mul(WorldPos, ViewProjection);

	float3 NormalVector		= normalize(mul(input.normal,WorldInverseTranspose));
	float3 LightVector		= normalize(LightPos - WorldPos);
	float3 EyeVector		= normalize(EyePos   - WorldPos);
	float3 LightReflectionVector	= -reflect(LightVector,NormalVector);

	//ambient component
	output.diffuse = AmbientCol;

	//diffuse component
	output.diffuse += DiffuseCol * saturate(dot(NormalVector, LightVector));
	
	//specular component	
	output.diffuse += SpecularCol * pow(saturate(dot(EyeVector, LightReflectionVector)),Power);
	
	output.diffuse.w = DiffuseCol.w;

	int ci=CharacterIndex.x;
	int mrx=Prop0.x;
	int mry=Prop0.y;
	
	int dx=0;
	int dy=0;
	if(mrx>1 || mry>1){
		dy=ci/mrx;
		dx=ci-dy*mrx; // dx=ci%mrx; gaat soms fout. hele vreemde bug...
	}

	float2 uv=input.tex;
	uv.x=UVBounds0.x + ((UVBounds0.y-UVBounds0.x)*dx + uv.x-UVBounds0.x)/mrx;
	uv.y=UVBounds0.z + ((UVBounds0.w-UVBounds0.z)*dy + uv.y-UVBounds0.z)/mry;

	output.tex = uv;

	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_2_0 VS();
        PixelShader  = NULL;
    }
}
