// PixelBeams.fx
//
// Copyright Outerspace Software, all rights reserved

string description = "PixelBeams";

float4x4	WorldViewProjection;
float4		DiffuseCol;
float4 		UVBounds0;


float4 Prop0
<
string UIName="Radiation";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0.6,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0.6,0,0,0);

float4 Prop1
<
string UIName="Centre";
float UIMin=-1;
float UIMax=1;
float3 UIDefault=float3(0,0,0);
int UISliders=2;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0,0,0,0);


texture MyTexture0;
sampler Samp = sampler_state{
    Texture   = (MyTexture0);
    AddressU  = CLAMP;
    AddressV  = CLAMP;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	output.position = mul(input.position,WorldViewProjection);
	output.tex	= input.tex;
	return output;
}

float4 GetColour(float2 inUV){
	float2 P = inUV;

	float2 C;
	C.x = (UVBounds0.x+UVBounds0.y)*0.5;
	C.y = (UVBounds0.z+UVBounds0.w)*0.5;
	
	C += Prop1.xy;

	
	float Radiation = 1-Prop0.x;


	float2 V=P-C;

	float L=length(V);
	V/=L;

	float f=0;
	if(L>Radiation && L-Radiation<0.1){
		f=1 - (L-Radiation)/0.1;
	}

	if(L > Radiation) L=Radiation;

	float2 P2=C+V*L;		
	
	float4 r = f*tex2D(Samp,P) + (1-f)*tex2D(Samp,P2);
	r.w*=DiffuseCol.w;

	return r;
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;
	
	float4 r = GetColour(input.tex);
       
	output.color=r;
	return output;
}

technique pixels{
    pass p0{
	VertexShader = compile vs_1_0 VS();
	PixelShader  = compile ps_2_0 PS();
    }
}

