// Pixelizer.fx
//
// Copyright Outerspace Software, all rights reserved

string description = "Pixelizer";

float4x4	WorldViewProjection;
float4		DiffuseCol;
float4		ImageResolution0=float4(1,1,1,1);
float4		TextureResolution0=float4(256,256,1,1);
float4		UVBounds0=float4(1,1,1,1);

const float PI=3.14159;

float4 Prop0
<
string UIName="Resolution";
float UIMin=0;
float UIMax=100;
float3 UIDefault=float3(20,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=true;
int UIWidget=0;
> = float4(20,0,0,0);

float4 Prop1
<
string UIName="Rotation";
float UIMin=0;
float UIMax=1.57;
float3 UIDefault=float3(0,0,0);
int UISliders=1;
float UIScale=57.33;
bool UIInteger=false;
int UIWidget=0;
> = float4(0,0,0,0);

float4 Prop2
<
string UIName="Border Size";
float UIMin=0;
float UIMax=0.5;
float3 UIDefault=float3(0.1,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0.1,0,0,0);

float4 Prop3
<
string UIName="Border Contrast";
float UIMin=1;
float UIMax=4;
float3 UIDefault=float3(1.2,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(1.2,0,0,0);

texture MyTexture0;
sampler Samp = sampler_state{
    Texture   = <MyTexture0>;
    AddressU  = CLAMP;
    AddressV  = CLAMP;
    MipFilter = NONE;
    MinFilter = NONE;
    MagFilter = NONE;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;	
	output.position = mul(input.position,WorldViewProjection);
	output.tex = input.tex;     
	return output;
}

float Smooth(float2 p, float l, float r, float f0, float f1){
	float f=1;
	if(p.x>l && p.x<r) f*=f0+((p.x-l)*(f1-f0))/(r-l);
	if(p.y>l && p.y<r) f*=f0+((p.y-l)*(f1-f0))/(r-l);
	return f;
}

float4 GetColour(float2 inUV){

        float ar=ImageResolution0.x/ImageResolution0.y;

	ar *= (UVBounds0.w-UVBounds0.z)/(UVBounds0.y-UVBounds0.x);
    	if(ar<0) ar=-ar;

    	inUV.x*=ar;

	float2 P = inUV;
	float2 P2;

	float sa=sin(Prop1.x);
	float ca=cos(Prop1.x);
	
    	P2.x = P.x*ca - P.y*sa;
    	P2.y = P.x*sa + P.y*ca;    
	
	//pixelize
	float2 P3=P2;
    	int2 Q = P2*Prop0.x;
    	P2 = Q / Prop0.x;   
   
    	P.x = P2.x*ca + P2.y*sa;
    	P.y = -P2.x*sa+ P2.y*ca;

	P3-=P2;	

	//add hilight and shadow	
	const float g1=Prop2.x/Prop0.x;
	const float g2=(1-Prop2.x)/Prop0.x;
	const float g3=1.0/Prop0.x;

	if(P3.x<0) P3.x+=g3;

	float f=1;
	f*=Smooth(P3,	0,		g1*0.5,		1.0/Prop3.x,	Prop3.x);
	f*=Smooth(P3,	g1*0.5,		g1,		Prop3.x,	1);	
	f*=Smooth(P3,	g2,		g3,		1,		1.0/Prop3.x);	

	P.x/=ar;
	float4 ret=tex2D(Samp,P);
	ret.xyz*=f;
	return ret;
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;     
	output.color=GetColour(input.tex)*DiffuseCol;
	return output;
}

technique pixels{
    pass p0{   
	VertexShader = compile vs_3_0 VS();
	PixelShader  = compile ps_3_0 PS();
    }
}

