// Stripes Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This effect filters the first texture. The second texture is not used.";

float4x4	WorldViewProjection;
float4		DiffuseCol;


float4 Prop0
<
string UIName="Density";
float UIMin=0;
float UIMax=20;
float3 UIDefault=float3(5,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(5,0,0,0);

float4 Prop1
<
string UIName="First Colour";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0,0,0);
int UISliders=3;
float UIScale=255;
bool UIInteger=true;
int UIWidget=2;
> = float4(0,0,0,1);

float4 Prop2
<
string UIName="Second Colour";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(1,1,1);
int UISliders=3;
float UIScale=255;
bool UIInteger=true;
int UIWidget=2;
> = float4(1,1,1,1);



texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
   Texture = <MyTexture0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

struct VS_OUTPUT{
    float4 position:	POSITION;
    float2 tex:			TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	output.position = mul(input.position, WorldViewProjection);
	output.tex = input.tex.xy;
	return output;
}


PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

	float4 k0=float4(0,0,0,0);
	float4 k1=float4(1,1,1,1);
   
   	float4 c = tex2D(MyTextureSampler0, input.tex);
	float f=c.x + c.y + c.z;

	f=0.5*(1+sin(f*Prop0.x));
	
	output.color = Prop1+f*(Prop2-Prop1);

	output.color.w = c.w*DiffuseCol.w;

	return output;
}


technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}

