// White Border Effect
//
// Copyright Outerspace Software, all rights reserved

string description = "This effect adds a white border to your textures";

float4x4	WorldViewProjection;	
float4		UVBounds0 = float4(0,1,0,1);
float4		DiffuseCol;


float4 Prop0
<
string UIName="Border Size";
float UIMin=0;
float UIMax=0.2;
float3 UIDefault=float3(0.05,0,0);
int UISliders=1;
float UIScale=5;
bool UIInteger=false;
int UIWidget=0;
> = float4(0.05,0,0,0);

float4 Prop1
<
string UIName="Border Colour";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(1,1,1);
int UISliders=3;
float UIScale=255;
bool UIInteger=true;
int UIWidget=2;
> = float4(1,1,1,1);


texture MyTexture0;
sampler MyTextureSampler0 = sampler_state{
    Texture   = (MyTexture0);
    AddressU  = CLAMP;
    AddressV  = CLAMP;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;      
	output.position = mul(input.position, WorldViewProjection);
	output.tex = input.tex;
	return output;
}

float4 GetColour(float2 inUV){

	float2 t=inUV;

	float b=Prop0.x;
	float s=b*0.01;	//antialiasing

	float d=1;

	float vmin = min(UVBounds0.x,UVBounds0.y);
	float vmax = max(UVBounds0.x,UVBounds0.y);

	if(t.x<vmin+b){
		d=0;
		t.x=vmin;
	}
	else if(t.x<vmax-b){
		d+=min(abs(t.x-(vmin+b)),abs(t.x-(vmax-b)));

		t.x=vmin + ((t.x-b)*(vmax-vmin))/(vmax-vmin-2*b);
	}
	else{
		d=0;
		t.x=vmax;
	}

	vmin = min(UVBounds0.z,UVBounds0.w);
	vmax = max(UVBounds0.z,UVBounds0.w);

	if(t.y<vmin+b){
		d=0;
		t.y=vmin;
	}
	else if(t.y<vmax-b){
		if(d!=0)
			d+=min(abs(t.y-(vmin+b)),abs(t.y-(vmax-b)));

		t.y=vmin + ((t.y-b)*(vmax-vmin))/(vmax-vmin-2*b);
	}
	else{
		d=0;
		t.y=vmax;
	}


	float a=1;
	if(d<s) a=d/s;
		
	return (a * tex2D(MyTextureSampler0, t) + (1-a) * Prop1);    
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

	float4 c=GetColour(input.tex);
	c*=DiffuseCol;
	
	output.color=c;
	return output;
}

technique Shader
{
    pass P0
    {   
	VertexShader		= compile vs_1_1 VS();
	PixelShader		= compile ps_2_0 PS();
    }
}

