// Invisible Shader
//
// Copyright Outerspace Software, all rights reserved

string description = "This effect makes your layer invisible.";

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;      
	output.position=float4(0,0,0,1);
	output.diffuse=float4(0,0,0,1);
	output.tex=float2(0,0);
	return output;
}

technique Shader
{
    pass P0
    {
    	ZWriteEnable	= FALSE;
	Alphablendenable= TRUE;
	SrcBlend	= ONE;
	DestBlend	= ONE;
	CullMode	= NONE;
    
        VertexShader = compile vs_1_1 VS();
        PixelShader  = NULL;
    }
}