// Lighting Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "A shader featuring ambient, diffuse and specular lighting.";

float4x4	World;
float4x4	ViewProjection;
float4x4	WorldViewProjection;
float4x4	WorldInverseTranspose;
float4		LightPos;
float4		EyePos;

float4		AmbientCol;
float4		DiffuseCol;
float4		SpecularCol;
float		Power = 100;

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;

	float4 Pos=mul(input.position, World);
	output.position = mul(Pos, ViewProjection);

	float3 NormalVector		= normalize(mul(input.normal,WorldInverseTranspose));
	float3 LightVector		= normalize(LightPos - Pos);
	float3 EyeVector		= normalize(EyePos   - Pos);
	float3 LightReflectionVector	= -reflect(LightVector,NormalVector);
	
	//ambient component
	output.diffuse = AmbientCol;

	//diffuse component
	output.diffuse += DiffuseCol * saturate(dot(NormalVector, LightVector));
	
	//specular component	
	output.diffuse += SpecularCol * pow(saturate(dot(EyeVector, LightReflectionVector)),Power);
	
	output.diffuse.w = DiffuseCol.w;

	output.tex = input.tex;
	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = NULL;
    }
}

