// Masked Shader
//
// Copyright Outerspace Software, all rights reserved

string description = "This effect makes the object a window to a fullscreen 2D textured background";

// the UV coordinates are adjusted in such a way that a
// vertex with projected position (-1,-1) has a UV position (0,0)
// and the vertex with projected position (1,1) has a UV position (1,1)
// this way the 3D model is a window through which you can see the 2D textured background

float4x4	WorldViewProjection;	
float4		UVBounds0 = float4(0,1,0,1);
float4		DiffuseCol;

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;      
	output.position = mul(input.position, WorldViewProjection);

	output.tex.x = (1 + output.position.x / output.position.w)/2;
	output.tex.y = 1-(1 + output.position.y / output.position.w)/2;
	
	output.tex.x = UVBounds0.x + output.tex.x * (UVBounds0.y-UVBounds0.x);
	output.tex.y = UVBounds0.z + output.tex.y * (UVBounds0.w-UVBounds0.z);

	output.diffuse=DiffuseCol;
	return output;
}

technique Shader
{
    pass P0
    {
	Alphablendenable	=FALSE;
        VertexShader = compile vs_1_1 VS();
        PixelShader  = NULL;
    }
}
