// BlowUp Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This effect file blows up your mesh. Use the TRANSPARENCY property to control the effect.";
bool optimized=false;

float4x4	WorldViewProjection;
float4		LightPosModelSpace;
float4		EyePosModelSpace;

float4		AmbientCol;
float4		DiffuseCol;
float4		SpecularCol;
float		Power = 100;

float4 Prop0
<
string UIName="Morphing Stage";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0,0,0,0);

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;      

	float B = Prop0.x;

	float4 P = input.position;
	float L=length(P);

	if(L>0){
		float f=1+(125*B)/L - B;
		P.w/=f;
	}
	output.position = mul(P, WorldViewProjection);

	float3 N = input.normal;
	if(L>0){
		float3 T = input.position.xyz / L;
		N=N+B*(T-N);
	}
	float3 NormalVector		= normalize(N);

	float3 LightVector		= normalize(LightPosModelSpace - input.position);
	float3 EyeVector		= normalize(EyePosModelSpace   - input.position);
	float3 LightReflectionVector	= -reflect(LightVector,NormalVector);
	
	//ambient component
	output.diffuse = AmbientCol;

	//diffuse component
	output.diffuse += DiffuseCol * saturate(dot(NormalVector, LightVector));
	
	//specular component	
	output.diffuse += SpecularCol * pow(saturate(dot(EyeVector, LightReflectionVector)),Power);
	
	output.diffuse.w = DiffuseCol.w;

	output.tex = input.tex;
	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = NULL;
    }
}
