// Plane 2 Cube Shader
//
// Copyright Outerspace Software, all rights reserved

string description = "This effect morphs a plane into a cube. It supports transparency. Use the first slider of the COLOUR property (red) to animate the effect."; 
bool optimization=false;

float4x4	WorldViewProjection;	
float4		DiffuseCol;
float4		LightPosModelSpace;
float4		UVBounds0 = float4(0,1,0,1);

//constants
float PI = 3.14159;
float R = 125;

float4 Prop0
<
string UIName="Morphing Stage";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0,0,0,0);


struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

float4 GetPos(float2 inUV, float4x4 inMatrix, float2 inCentre){

	inUV.x = (inUV.x-UVBounds0.x)/(UVBounds0.y-UVBounds0.x);
	inUV.y = (inUV.y-UVBounds0.z)/(UVBounds0.w-UVBounds0.z);
	
	float4 pos;
	pos.x = -R + inUV.x * R * 2;
	pos.y = R  - inUV.y * R * 2;
	pos.z = 0;
	pos.w = 1;

	pos.x+=inCentre.x;
	pos.y+=inCentre.y;

	pos=mul(inMatrix,pos);

	return pos;
}

//achter
VS_OUTPUT VS0(VS_INPUT input, bool inAlphaChannel){
	VS_OUTPUT output;

	float4x4 M;
	M[0]=float4(1,0,0,0);
	M[1]=float4(0,1,0,0);
	M[2]=float4(0,0,1,R);
	M[3]=float4(0,0,0,1);
	
	float4 pos=GetPos(input.tex,M,float2(0,0));

	float3 NormalVector;
	NormalVector.x=0;
	NormalVector.y=0;
	NormalVector.z=1;
	if(input.normal.z<0){
		NormalVector.xyz *= -1;
	}
     
	output.position = mul(pos, WorldViewProjection);
	float3 LightVector	= normalize(LightPosModelSpace- pos);
	output.diffuse 		= DiffuseCol * saturate(dot(NormalVector, LightVector));
	output.diffuse.w=DiffuseCol.w;
	output.tex	= input.tex;

	if(inAlphaChannel) output.diffuse=DiffuseCol;
	return output;
}

//links
VS_OUTPUT VS1(VS_INPUT input, bool inAlphaChannel){
	VS_OUTPUT output;

	float a=Prop0.x*PI*0.5/0.2;
	if(a>PI*0.5) a=PI*0.5;

	float4x4 M;
	M[0]=float4(cos(a),0,-sin(a),-R);
	M[1]=float4(0,1,0,0);
	M[2]=float4(sin(a),0,cos(a),R);
	M[3]=float4(0,0,0,1);
	
	float4 pos=GetPos(input.tex,M,float2(-R,0));

	float3 NormalVector;
	NormalVector.x=-sin(a);
	NormalVector.y=0;
	NormalVector.z=cos(a);
	if(input.normal.z<0){
		NormalVector.xyz *= -1;
	}
     
	output.position = mul(pos, WorldViewProjection);
	float3 LightVector	= normalize(LightPosModelSpace- pos);
	output.diffuse 		= DiffuseCol * saturate(dot(NormalVector, LightVector));
	output.diffuse.w=DiffuseCol.w;
	output.tex	= input.tex;

	if(inAlphaChannel) output.diffuse=DiffuseCol;
	return output;
}

//boven
VS_OUTPUT VS2(VS_INPUT input, bool inAlphaChannel){
	VS_OUTPUT output;

	float a=(Prop0.x-0.2)*PI*0.5/0.2;
	if(a<0) a=0;
	if(a>PI*0.5) a=PI*0.5;

	float4x4 M;
	M[0]=float4(1,0,0,0);
	M[1]=float4(0,cos(-a),-sin(-a),R);
	M[2]=float4(0,sin(-a),cos(-a),R);
	M[3]=float4(0,0,0,1);
	
	float4 pos=GetPos(input.tex,M,float2(0,R));

	float3 NormalVector;
	NormalVector.x=0;
	NormalVector.y=sin(a);
	NormalVector.z=cos(a);
	if(input.normal.z<0){
		NormalVector.xyz *= -1;
	}
     
	output.position = mul(pos, WorldViewProjection);
	float3 LightVector	= normalize(LightPosModelSpace- pos);
	output.diffuse 		= DiffuseCol * saturate(dot(NormalVector, LightVector));
	output.diffuse.w=DiffuseCol.w;
	output.tex	= input.tex;

	if(inAlphaChannel) output.diffuse=DiffuseCol;
	return output;
}

//rechts
VS_OUTPUT VS3(VS_INPUT input, bool inAlphaChannel){
	VS_OUTPUT output;

	float a=(Prop0.x-0.4)*PI*0.5/0.2;	
	if(a<0) a=0;
	if(a>PI*0.5) a=PI*0.5;

	float4x4 M;
	M[0]=float4(cos(-a),0,-sin(-a),R);
	M[1]=float4(0,1,0,0);
	M[2]=float4(sin(-a),0,cos(-a),R);
	M[3]=float4(0,0,0,1);
	
	float4 pos=GetPos(input.tex,M,float2(R,0));

	float3 NormalVector;
	NormalVector.x=-sin(-a);
	NormalVector.y=0;
	NormalVector.z=cos(-a);
	if(input.normal.z<0){
		NormalVector.xyz *= -1;
	}
     
	output.position = mul(pos, WorldViewProjection);
	float3 LightVector	= normalize(LightPosModelSpace- pos);
	output.diffuse 		= DiffuseCol * saturate(dot(NormalVector, LightVector));
	output.diffuse.w=DiffuseCol.w;
	output.tex	= input.tex;

	if(inAlphaChannel) output.diffuse=DiffuseCol;
	return output;
}

//onder
VS_OUTPUT VS4(VS_INPUT input, bool inAlphaChannel){
	VS_OUTPUT output;

	float a=(Prop0.x-0.6)*PI*0.5/0.2;
	if(a<0) a=0;
	if(a>PI*0.5) a=PI*0.5;

	float4x4 M;
	M[0]=float4(1,0,0,0);
	M[1]=float4(0,cos(a),-sin(a),-R);
	M[2]=float4(0,sin(a),cos(a),R);
	M[3]=float4(0,0,0,1);
	
	float4 pos=GetPos(input.tex,M,float2(0,-R));
     
	float3 NormalVector;
	NormalVector.x=0;
	NormalVector.y=sin(-a);
	NormalVector.z=cos(-a);
	if(input.normal.z<0){
		NormalVector.xyz *= -1;
	}
     
	output.position = mul(pos, WorldViewProjection);
	float3 LightVector	= normalize(LightPosModelSpace- pos);
	output.diffuse 		= DiffuseCol * saturate(dot(NormalVector, LightVector));
	output.diffuse.w=DiffuseCol.w;
	output.tex	= input.tex;

	if(inAlphaChannel) output.diffuse=DiffuseCol;
	return output;
}

//voor
VS_OUTPUT VS5(VS_INPUT input, bool inAlphaChannel){
	VS_OUTPUT output;

	float a=(Prop0.x-0.6)*PI*0.5/0.2;
	if(a<0) a=0;
	float a2=a;
	if(a2>PI*0.5) a2=PI*0.5;

	float DY=-R-cos(a2)*2*R;
	float DZ=R-sin(a2)*2*R;

	float4x4 M;
	M[0]=float4(1,0,0,0);
	M[1]=float4(0,cos(a),-sin(a),DY);
	M[2]=float4(0,sin(a),cos(a),DZ);
	M[3]=float4(0,0,0,1);
	
	float4 pos=GetPos(input.tex,M,float2(0,-R));
 
	float3 NormalVector;
	NormalVector.x=0;
	NormalVector.y=sin(-a);
	NormalVector.z=cos(-a);
	if(input.normal.z<0){
		NormalVector.xyz *= -1;
	}
    
	output.position = mul(pos, WorldViewProjection);
	float3 LightVector	= normalize(LightPosModelSpace- pos);
	output.diffuse 		= DiffuseCol * saturate(dot(NormalVector, LightVector));
	output.diffuse.w=DiffuseCol.w;
	output.tex	= input.tex;

	if(inAlphaChannel) output.diffuse=DiffuseCol;
	return output;
}

VS_OUTPUT VS0_N(VS_INPUT input){ return VS0(input,false); }
VS_OUTPUT VS1_N(VS_INPUT input){ return VS1(input,false); }
VS_OUTPUT VS2_N(VS_INPUT input){ return VS2(input,false); }
VS_OUTPUT VS3_N(VS_INPUT input){ return VS3(input,false); }
VS_OUTPUT VS4_N(VS_INPUT input){ return VS4(input,false); }
VS_OUTPUT VS5_N(VS_INPUT input){ return VS5(input,false); }

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_2_0 VS0_N();
        PixelShader  = NULL;
    }
    pass P1
    {
        VertexShader = compile vs_2_0 VS1_N();
        PixelShader  = NULL;
    }
    pass P2
    {
	VertexShader = compile vs_2_0 VS2_N();
        PixelShader  = NULL;
    }
    pass P3
    {
	VertexShader = compile vs_2_0 VS3_N();
        PixelShader  = NULL;
    }
    pass P4
    {
	VertexShader = compile vs_2_0 VS4_N();
        PixelShader  = NULL;
    }
    pass P5
    {
	VertexShader = compile vs_2_0 VS5_N();
        PixelShader  = NULL;
    }
}

