// Plane 2 Cylinder Shader
//
// Copyright Outerspace Software, all rights reserved

string description = "This effect morphs a plane into a cylinder. It supports transparency. Use the first slider of the COLOUR property (red) to animate the effect."; 
bool optimization=false;

float4x4	WorldViewProjection;	
float4		DiffuseCol;
float4		LightPosModelSpace;
float4		ImageResolution0 = float4(256,256,1,0);
float4		UVBounds0 = float4(0,1,0,1);

//constants
float PI = 3.14159;
float cMinAngle = 0.01;

float4 Prop0
<
string UIName="Morphing Stage";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0,0,0,0);

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;

	float height = 126.25;
	float width  = (ImageResolution0.x * height)/ImageResolution0.y;

	float2 uv = input.tex;
	uv.x = (uv.x-UVBounds0.x)/(UVBounds0.y-UVBounds0.x);
	uv.y = (uv.y-UVBounds0.z)/(UVBounds0.w-UVBounds0.z);
	
	float4 pos;
	pos.x = -width + uv.x * width * 2;
	pos.y = height - uv.y * height * 2;
	pos.z = 0;
	pos.w = 1;

	float3 NormalVector = normalize(input.normal);

	float alfa= Prop0.x * PI;
	if(alfa>cMinAngle){

		float r = width/alfa;

		float a = -alfa + uv.x*2*alfa;
		pos.x = sin(a)*r;
		pos.z = cos(a)*r - cos(alfa*0.5)*r; // zet z in het midden

		NormalVector.x = sin(a);
		NormalVector.z = cos(a);

		if(input.normal.z<0){
			NormalVector.xyz *= -1;
		}
	}

	output.position = mul(pos, WorldViewProjection);

	float3 LightVector	= normalize(LightPosModelSpace- pos);
	output.diffuse 		= DiffuseCol * saturate(dot(NormalVector, LightVector));
	output.diffuse.w	= DiffuseCol.w;
	output.tex		= input.tex;

	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_2_0 VS();
        PixelShader  = NULL;
    }
}

