// Plane 2 Sphere Shader
//
// Copyright Outerspace Software, all rights reserved

string description = "This effect morphs a plane into a sphere. It supports transparency. Use the first slider of the COLOUR property (red) to animate the effect.";
bool optimization=false;

float4x4	WorldViewProjection;
float4		DiffuseCol;
float4		LightPosModelSpace;
float4		ImageResolution0;
float4		UVBounds0 = float4(0,1,0,1);

//constants
float PI = 3.14159;
float cMinAngle = 0.01;


float4 Prop0
<
string UIName="Morphing Stage";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0,0,0,0);


struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;

	float height = 126.25;
	float width  = (ImageResolution0.x * height)/ImageResolution0.y;

	float2 uv = input.tex;
	uv.x = (uv.x-UVBounds0.x)/(UVBounds0.y-UVBounds0.x);
	uv.y = (uv.y-UVBounds0.z)/(UVBounds0.w-UVBounds0.z);

	float4 pos;
	pos.x = -width + uv.x * width * 2;
	pos.y = height - uv.y * height * 2;
	pos.z = 0;
	pos.w = 1;

	float alfa=2*Prop0.x * PI;
	if(alfa>PI) alfa=PI;

	float r=0;
	if(alfa>cMinAngle) r = width/alfa;

	float3 NormalVector = normalize(input.normal);

	float a;
	float b;

	if(alfa>cMinAngle){
		a = -alfa + uv.x*2*alfa;

		NormalVector.x = sin(a);
		NormalVector.z = -cos(a);

		pos.x = NormalVector.x*r;
		pos.z = NormalVector.z*r + cos(alfa*0.5)*r; // zet z in het midden
	}

	if(Prop0.x > 0.5){
		a += PI*0.5;
		b = -PI + PI*uv.y;

		float3 nt;
		nt.x = cos(a)*sin(b);
		nt.y = -cos(b);
		nt.z = sin(a)*sin(b);

		float f=2.0*(Prop0.x-0.5);
		pos.x += f*(nt.x*height-pos.x);
		pos.y += f*(nt.y*height-pos.y);
		pos.z += f*(nt.z*height-pos.z);

		nt -= NormalVector;
		NormalVector += f*nt;
	}

	if(input.normal.z>0){
		NormalVector.xyz *= -1;
	}
     
	output.position = mul(pos, WorldViewProjection);

	float3 LightVector	= normalize(LightPosModelSpace- pos);
	output.diffuse 		= DiffuseCol * saturate(dot(NormalVector, LightVector));
	output.diffuse.w	= DiffuseCol.w;
	output.tex		= input.tex;
	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_2_0 VS();
        PixelShader  = NULL;
    }
}

