// ColourMap + BumpMap (NormalMap) Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This effect combines colourmapping with bumpmapping. It takes the colours from the first texture and the bumps from the second.";

float4x4	WorldViewProjection;
float4		EyePosModelSpace;
float4		LightPosModelSpace;
float4		AmbientCol;	
float4		DiffuseCol;
float4		SpecularCol;
float		Power = 100;

texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
   Texture = <MyTexture0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

texture MyTexture1;
sampler MyTextureSampler1 = sampler_state
{
   Texture = <MyTexture1>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
	float3 tangent:		TANGENT;
};

struct VS_OUTPUT{
    float4 position:	POSITION;
    float2 tex:			TEXCOORD0;
    float3 light:		TEXCOORD1;
    float3 eye:			TEXCOORD2;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	output.position = mul(input.position, WorldViewProjection);
	output.tex = input.tex.xy;
	
	float3 n = normalize(input.normal);
			
	float3x3 M;
    M[0] = input.tangent;
    M[1] = cross(input.tangent, n);
    M[2] = n;

	float3 Light = LightPosModelSpace - input.position; 
	output.light.xyz = mul(M, Light);
	
	float3 Eye	= EyePosModelSpace   - input.position;
	output.eye.xyz = mul(M, Eye);	

	return output;
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;
	
    float4 colour		= tex2D(MyTextureSampler0, input.tex);
    float3 bumpNormal	= 2 * (tex2D(MyTextureSampler1, input.tex) - 0.5);
    	
    float3 LightDir = normalize(input.light);
    float3 ViewDir  = normalize(input.eye);
    
    //ambient component
    output.color.xyz = AmbientCol;
        
	//diffuse component         
    float4 diff = saturate(dot(bumpNormal, LightDir));
    output.color.xyz += colour*diff*DiffuseCol;
    
    // specular component
	if(diff.x>0){
		float3 Reflect = normalize(2*diff*bumpNormal - LightDir);
		float4 spec = pow(saturate(dot(Reflect, ViewDir)), Power);
		output.color.xyz += saturate(SpecularCol*spec);
	}
	
    output.color.w=DiffuseCol.w;
	return output;
}


technique Shader
{
    pass P0
    {  
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}

