// ColourMap + CartoonMap Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This effect takes the colours from the second texture as a lookup table for the brightness of the first texture. The first texture is used as a colour map, the second as a cartoon map.";
bool optimization=false;

float4x4	WorldViewProjection;
float4		DiffuseCol;

texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
   Texture = <MyTexture0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

texture MyTexture1;
sampler MyTextureSampler1 = sampler_state
{
   Texture = <MyTexture1>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;      
	output.position = mul(input.position, WorldViewProjection);
	output.diffuse	= DiffuseCol;
	output.tex	= input.tex;
	return output;
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

	float4 colour = tex2D(MyTextureSampler0, input.tex);
	float g=(colour.x+colour.y+colour.z)/3;

	output.color	= tex2D(MyTextureSampler1,float2(g,0));
	output.color.w	= colour.w * DiffuseCol.w;
	return output;
}


technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}

