// ColourMap + ColourMap Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This effect renders the second texture transparently over the first texture. Note that the first texture is invisible if the second texture does not have an alpha channel.";

float4x4	WorldViewProjection;
float4		LightPosModelSpace;
float4		EyePosModelSpace;
float		AmbientCol;
float4		DiffuseCol;
float4		SpecularCol;
float		Power = 100;

texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
   Texture = <MyTexture0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

texture MyTexture1;
sampler MyTextureSampler1 = sampler_state
{
   Texture = <MyTexture1>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;      
	output.position = mul(input.position, WorldViewProjection);

	float3 NormalVector				= normalize(input.normal);
	float3 LightVector				= normalize(LightPosModelSpace - input.position);
	float3 EyeVector				= normalize(EyePosModelSpace   - input.position);
	float3 LightReflectionVector	= -reflect(LightVector,NormalVector);
	
	//ambient component
	output.diffuse = AmbientCol;

	//diffuse component
	output.diffuse += DiffuseCol * saturate(dot(NormalVector, LightVector));
	
	//specular component	
	output.diffuse += SpecularCol * pow(saturate(dot(EyeVector, LightReflectionVector)),Power);
	
	output.diffuse.w = DiffuseCol.w;

	output.tex = input.tex;
	return output;
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;
	
    float4 colour0		= tex2D(MyTextureSampler0, input.tex);
    float4 colour1		= tex2D(MyTextureSampler1, input.tex);
    
    float3 colour = colour0*(1-colour1.w) + colour1*colour1.w;
	
    output.color.xyz	= input.diffuse*colour;
    output.color.w		= DiffuseCol.w;
	return output;
}


technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}

