// ColourMap + Tonal Art Map Shader (realtime hatching)
// 
// Copyright Outerspace Software, all rights reserved

string description = "This filter combines colourmapping with tonal art mapping. It uses the first texture as a colourmap and the second as a tonal art map.";

// It uses 4 hatching levels. The first is white, the others are RGB encoded.
// This results in pictures with 3 colours: blue, cyan and white:
// 001 (blue)	only visible in darkest parts
// 011 (cyan)   only visible in darker parts
// 111 (white)	always visible

float TonalArtUVScale = 8;
float Brightness = 1.3;

float4x4	WorldViewProjection;
float4		LightPosModelSpace;
float4		DiffuseCol;

texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
	Texture = <MyTexture0>;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU  = Wrap;
	AddressV  = Wrap;
};

texture MyTexture1;
sampler MyTextureSampler1 = sampler_state
{
   Texture = <MyTexture1>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

struct VS_OUTPUT{
    float4 position:	POSITION;
    float2 tex:			TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};


VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;      
	output.position = mul(input.position, WorldViewProjection);
	output.tex = input.tex;
	return output;
}


PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;
	
	float4 c0 = tex2D(MyTextureSampler0, input.tex);
	float d=(c0.x+c0.y+c0.z)/3.0;
	
	d*=Brightness;

	float3 rgb = tex2D(MyTextureSampler1, input.tex * TonalArtUVScale);
	
	float g0=0;
	float g1=0;
	float f=0;
	
	if(d>=0.666){
		f=(d-0.666)/0.333;
		g1=0;
		g0=rgb.x;
	}
	else if(d>=0.333){
		f=(d-0.333)/0.333;
		g1=rgb.x;
		g0=rgb.y;
	}
	else{
		f=d/0.333;
		g1=rgb.y;
		g0=rgb.z;
	}
	
	float g=g0+f*(g1-g0);
	
	g=1-g;
  
    output.color = float4(g,g,g,c0.w) * DiffuseCol;
	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}

