// Gradient Wipe Effect
//
// Copyright Outerspace Software, all rights reserved

string description = "Gradient Wipe (Alpha Magic) effect. Use this effect in a picture layer. The second texture must be a grayscale picture. Animate the effect with the FX Wipe Stage property.";

float4x4	WorldViewProjection;
float4		DiffuseCol;

float4 Prop0
<
string UIName="Wipe Stage";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0,0,0,0);

float4 Prop1
<
string UIName="Wipe Smooth Factor";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0.1,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0.1,0,0,0);

texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
   Texture = <MyTexture0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

texture MyTexture1;
sampler MyTextureSampler1 = sampler_state
{
   Texture = <MyTexture1>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;

	output.position = mul(input.position, WorldViewProjection);
	output.tex = input.tex;
	return output;
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

	float4 c0=tex2D(MyTextureSampler0, input.tex);
	float4 c1=tex2D(MyTextureSampler1, input.tex);

	float f=1-Prop0.x;

	float W=1;

	if(Prop1.x<=0){
		float f=c1.x-(1-f);
		if(f<0)		W = 0;
		if(f>=0)	W = 1;
	}

	if(Prop1.x>0){
		float d=-Prop1.x+f*(1+2*Prop1.x);
		float f=c1.x-(1-d);
		
		if(f<0)		W = 0;
		if(f>-Prop1.x)	W = (1.0+f/Prop1.x);
		if(f>=0)	W = 1;
	}

	W *= c0.w;
	W *= DiffuseCol.w;
	
	c0.w=W;

	output.color = c0;
	return output;
}

technique Shader
{
	pass P0
	{
	ALPHABLENDENABLE	=	TRUE;
	SRCBLEND		=	SRCALPHA;
	DESTBLEND		=	INVSRCALPHA;
	ALPHATESTENABLE		=	TRUE;
	ALPHAREF		=	1;
	ALPHAFUNC		=	GREATEREQUAL;

	VertexShader = compile vs_1_1 VS();
	PixelShader  = compile ps_2_0 PS();
	}
}
