// Reflection(Spheremap) & BumpMap(NormalMap) Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This effect combines reflectionmapping with bumpmapping. The first texture is used as a reflectionmap (spheremap) and the second as a bumpmap (normalmap).";

float4x4	WorldInverseTranspose;
float4x4	WorldViewProjection;
float4		EyePosModelSpace;
float4		DiffuseCol;
float4		UVBounds0;

texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
   Texture = <MyTexture0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

texture MyTexture1;
sampler MyTextureSampler1 = sampler_state
{
   Texture = <MyTexture1>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
	float3 tangent:		TANGENT;
};

struct VS_OUTPUT{
    float4 position:	POSITION;
    float2 tex:			TEXCOORD0;
    float3 eye:			TEXCOORD1;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

float2 Normal2UVBounds(float2 inUV, float4 inUVBounds){
	inUV.x = inUVBounds.x + inUV.x*(inUVBounds.y-inUVBounds.x);
	inUV.y = inUVBounds.z + inUV.y*(inUVBounds.w-inUVBounds.z);
	return inUV;
}

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	output.position = mul(input.position, WorldViewProjection);
	output.tex = input.tex.xy;

	float3 n = normalize(input.normal);

	float3x3 M;
    	M[0] = input.tangent;
    	M[1] = cross(input.tangent, n);
    	M[2] = n;

	float3 Eye	= EyePosModelSpace - input.position;
	output.eye.xyz = mul(M,Eye);

	return output;
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

	float3 bumpNormal	= 2 * (tex2D(MyTextureSampler1, input.tex) - 0.5);
    	bumpNormal.y = -bumpNormal.y; 

	float3 EyeVector  = normalize(input.eye);

	float3 ReflectionVector = reflect(EyeVector,bumpNormal);
	ReflectionVector = mul(ReflectionVector, WorldInverseTranspose);	

	ReflectionVector.z=abs(ReflectionVector.z);

	ReflectionVector.z+=1;
	float f=2*length(ReflectionVector);
	float2 t = float2(0.5,0.5) + ReflectionVector.xy/f;

	t=Normal2UVBounds(t,UVBounds0);

	output.color.xyz = tex2D(MyTextureSampler0, t);

	output.color.w=DiffuseCol.w;
	return output;
}


technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}

