// NoLighting_NoZWrite Shader
//
// Copyright Outerspace Software, all rights reserved

string description = "This effect turns all lighting off and it does not write into the Z-Buffer.";

float4x4	WorldViewProjection;	
float4		DiffuseCol;

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;      
	output.position = mul(input.position, WorldViewProjection);
	output.diffuse  = DiffuseCol;
	output.tex	= input.tex;
	return output;
}

technique Shader
{
    pass P0
    {
	ZWriteEnable = FALSE;
        VertexShader = compile vs_1_1 VS();
        PixelShader  = NULL;
    }
}
