// NotLightened_Subtractive Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This effect turns all lighting off and renders the object with subtractive blending.";

//VS_OUTPUT heeft een COLOR prop voor grafische kaarten zonder pixel shader

float4x4	WorldViewProjection;	
float4		DiffuseCol;
float4		ImageResolution0;

bool optimization=false;

texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
   Texture = <MyTexture0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
    float4 position:	POSITION;
    float4 diffuse:	COLOR;
    float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:	COLOR;
};

float4 FixColour(float4 c){
	c.xyz*=c.w;
	c.w=c.x;
	if(c.y>c.w) c.w=c.y;
	if(c.z>c.w) c.w=c.z;
	return c;
}

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	output.position = mul(input.position, WorldViewProjection);
	output.diffuse = FixColour(DiffuseCol);
	output.tex = input.tex.xy;
	return output;
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

	float4 c=DiffuseCol;
	if(ImageResolution0.x>0) c*=tex2D(MyTextureSampler0, input.tex);

	output.color=FixColour(c);
	return output;
}

technique Shader
{
    pass P0
    {
	Alphablendenable	=TRUE;
	SrcBlend		=ZERO;
	DestBlend		=INVSRCCOLOR;
	CullMode		=NONE;
	ZWriteEnable		=FALSE;
		
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}
