// Not Textured Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This shader does not use texturing.";

float4x4	WorldViewProjection;
float4		LightPosModelSpace;
float4		EyePosModelSpace;

float		AmbientCol;
float4		DiffuseCol;
float4		SpecularCol;
float		Power = 100;

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;      

	output.position = mul(input.position, WorldViewProjection);

	float3 NormalVector		= normalize(input.normal);
	float3 LightVector		= normalize(LightPosModelSpace - input.position);
	float3 EyeVector		= normalize(EyePosModelSpace   - input.position);
	float3 LightReflectionVector	= -reflect(LightVector,NormalVector);
	
	//ambient component
	output.diffuse = AmbientCol;

	//diffuse component
	output.diffuse += DiffuseCol * saturate(dot(NormalVector, LightVector));
	
	//specular component	
	output.diffuse += SpecularCol * pow(saturate(dot(EyeVector, LightReflectionVector)),Power);
	
	output.diffuse.w = DiffuseCol.w;

	output.tex = input.tex;
	return output;
}

technique Shader
{
    pass P0
    {
	ColorArg1[0]	=DIFFUSE;
	ColorOp[0]	=SELECTARG1;
    
        VertexShader = compile vs_1_1 VS();
        PixelShader  = NULL;
    }
}
