// ReflectionMap / SphereMap Shader
//
// Copyright Outerspace Software, all rights reserved

string description = "A reflectionmapping (spheremap) effect. It uses the first texture as a reflectionmap (spheremap). The second texture is not used.";

float4x4	World;
float4x4	ViewProjection;
float4x4	WorldInverseTranspose;
float4		EyePos;
float4		DiffuseCol;
float4 		UVBounds0;

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

float2 Normal2UVBounds(float2 inUV){
	inUV.x = UVBounds0.x + inUV.x*(UVBounds0.y-UVBounds0.x);
	inUV.y = UVBounds0.z + inUV.y*(UVBounds0.w-UVBounds0.z);
	return inUV;
}

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	float4 Pos=mul(input.position, World);
	output.position = mul(Pos, ViewProjection);

	float3 NormalVector		= normalize(mul(input.normal,WorldInverseTranspose));
	float3 EyeVector		= normalize(EyePos - Pos);

	float3 ReflectionVector = reflect(EyeVector,NormalVector);
	ReflectionVector.z=abs(ReflectionVector.z);

	ReflectionVector.z+=1;
	float f=2*length(ReflectionVector);
	output.tex = float2(0.5,0.5) + ReflectionVector.xy/f;

	output.tex = Normal2UVBounds(output.tex);

	output.diffuse = DiffuseCol;
	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = NULL;
    }
}
