###################################################
# header_operations.py
# This file contains opcode declarations
# DO NOT EDIT THIS FILE!
###################################################

#--------------------------------------------------------------------------
# CONTROL OPERATIONS
#--------------------------------------------------------------------------
call_script       = 1 # (call_script,<script_id>),
end_try           = 3 # deprecated, use try_end instead
try_end           = 3 # (try_end),
try_begin         = 4 # (try_begin),
else_try_begin    = 5 # deprecated, use else_try instead
else_try          = 5 # (else_try),

try_for_range     = 6 # Works like a for loop from lower-bound up to (upper-bound - 1)
		      # (try_for_range,<destination>,<lower_bound>,<upper_bound>),

try_for_range_backwards = 7	# Same as above but starts from (upper-bound - 1) down-to lower bound.
				# (try_for_range_backwards,<destination>,<upper_bound>,<lower_bound>),
try_for_parties   = 11          # (try_for_parties,<destination>),
try_for_agents    = 12		# (try_for_agents,<destination>),

store_script_param_1 = 21       # (store_script_param_1,<destination>),  --(Within a script) stores the first script parameter.
store_script_param_2 = 22       # (store_script_param_2,<destination>),  --(Within a script) stores the second script parameter.
store_script_param   = 23       # (store_script_param,<destination>,<script_param_no>), --(Within a script) stores <script_param_no>th script parameter.

#--------------------------------------------------------------------------
# CONDITION OPERATIONS
#--------------------------------------------------------------------------

ge           = 30  # greater than or equal to -- (ge,<value>,<value>),
eq           = 31  # equal to		      -- (eq,<value>,<value>),
gt           = 32  # greater than	      -- (gt,<value>,<value>),

is_between   = 33  # (is_between,<value>,<lower_bound>,<upper_bound>), #greater than or equal to lower bound and less than upper bound

entering_town   = 36 # (entering_town,<town_id>),
map_free        = 37  # (map_free),
encountered_party_is_attacker     = 39  # (encountered_party_is_attacker),
conversation_screen_is_active     = 42  # (conversation_screen_active), #used in mission template triggers only

in_meta_mission = 44 # deprecated, do not use.

set_player_troop               = 47 # (set_player_troop,<troop_id>),

store_repeat_object            = 50  # stores the index of a repeated dialog option for repeat_for_factions, etc...

set_result_string              = 60  # sets the result string for game scripts that need one (set_result_string, <string_id>),

key_is_down                    = 70  # fails if the key is not currently down (key_is_down, <key_id>),
key_clicked                    = 71  # fails if the key is not clicked on the specific frame (key_clicked, <key_id>),
game_key_is_down               = 72  # fails if the game key is not currently down (key_is_down, <game_key_id>),
game_key_clicked               = 73  # fails if the game key is not clicked on the specific frame (key_clicked, <game_key_id>),
mouse_get_position	       = 75  # (mouse_get_position, <position_no>), #x and y values of position are filled

hero_can_join                  = 101 # (hero_can_join, [party_id]),
hero_can_join_as_prisoner      = 102 # (hero_can_join_as_prisoner, [party_id]),
party_can_join                 = 103 # (party_can_join),
party_can_join_as_prisoner     = 104 # (party_can_join_as_prisoner),
troops_can_join                = 105 # (troops_can_join,<value>),
troops_can_join_as_prisoner    = 106 # (troops_can_join_as_prisoner,<value>),
party_can_join_party           = 107 # (party_can_join_party, <joiner_party_id>, <host_party_id>,[flip_prisoners]),
main_party_has_troop           = 110 # (main_party_has_troop,<troop_id>),
party_is_in_town               = 130 # (party_is_in_town,<party_id_1>,<party_id_2>),
party_is_in_any_town           = 131 # (party_is_in_any_town,<party_id>),
party_is_active                = 132 # (party_is_active,<party_id>),
player_has_item                = 150 # (player_has_item,<item_id>),
troop_has_item_equipped        = 151 # (troop_has_item_equipped,<troop_id>,<item_id>),

check_quest_active             = 200 # (check_quest_active,<quest_id>),
check_quest_finished           = 201 # (check_quest_finished,<quest_id>),
check_quest_succeeded          = 202 # (check_quest_succeeded,<quest_id>),
check_quest_failed             = 203 # (check_quest_failed,<quest_id>),

## Set_slot operations. These assign a value to a slot. 
troop_set_slot                  = 500 # (troop_set_slot,<troop_id>,<slot_no>,<value>),
party_set_slot                  = 501 # (party_set_slot,<party_id>,<slot_no>,<value>),
faction_set_slot                = 502 # (faction_set_slot,<faction_id>,<slot_no>,<value>),
scene_set_slot                  = 503 # (scene_set_slot,<scene_id>,<slot_no>,<value>),
party_template_set_slot         = 504 # (party_template_set_slot,<party_template_id>,<slot_no>,<value>),
agent_set_slot                  = 505 # (agent_set_slot,<agent_id>,<slot_no>,<value>),
quest_set_slot                  = 506 # (quest_set_slot,<quest_id>,<slot_no>,<value>),
item_set_slot                   = 507 # (item_set_slot,<item_id>,<slot_no>,<value>),

## Get_slot operations. These retrieve the value of a slot. 
troop_get_slot                  = 520 # (troop_get_slot,<destination>,<troop_id>,<slot_no>),
party_get_slot                  = 521 # (party_get_slot,<destination>,<party_id>,<slot_no>),
faction_get_slot                = 522 # (faction_get_slot,<destination>,<faction_id>,<slot_no>),
scene_get_slot                  = 523 # (scene_get_slot,<destination>,<scene_id>,<slot_no>),
party_template_get_slot         = 524 # (party_template_get_slot,<destination>,<party_template_id>,<slot_no>),
agent_get_slot                  = 525 # (agent_get_slot,<destination>,<agent_id>,<slot_no>),
quest_get_slot                  = 526 # (quest_get_slot,<destination>,<quest_id>,<slot_no>),
item_get_slot                   = 527 # (item_get_slot,<destination>,<item_id>,<slot_no>),

## slot_eq operations. These check whether the value of a slot is equal to a given value.
troop_slot_eq                   = 540 # (troop_slot_eq,<troop_id>,<slot_no>,<value>),
party_slot_eq                   = 541 # (party_slot_eq,<party_id>,<slot_no>,<value>),
faction_slot_eq                 = 542 # (faction_slot_eq,<faction_id>,<slot_no>,<value>),
scene_slot_eq                   = 543 # (scene_slot_eq,<scene_id>,<slot_no>,<value>),
party_template_slot_eq          = 544 # (party_template_slot_eq,<party_template_id>,<slot_no>,<value>),
agent_slot_eq                   = 545 # (agent_slot_eq,<agent_id>,<slot_no>,<value>),
quest_slot_eq                   = 546 # (quest_slot_eq,<quest_id>,<slot_no>,<value>),
item_slot_eq                    = 547 # (item_slot_eq,<item_id>,<slot_no>,<value>),

## slot_ge operations. These check whether the value of a slot is greater than or equal to a given value.
troop_slot_ge                   = 560 # (troop_slot_ge,<troop_id>,<slot_no>,<value>),
party_slot_ge                   = 561 # (party_slot_ge,<party_id>,<slot_no>,<value>),
faction_slot_ge                 = 562 # (faction_slot_ge,<faction_id>,<slot_no>,<value>),
scene_slot_ge                   = 563 # (scene_slot_ge,<scene_id>,<slot_no>,<value>),
party_template_slot_ge          = 564 # (party_template_slot_ge,<party_template_id>,<slot_no>,<value>),
agent_slot_ge                   = 565 # (agent_slot_ge,<agent_id>,<slot_no>,<value>),
quest_slot_ge                   = 566 # (quest_slot_ge,<quest_id>,<slot_no>,<value>),
item_slot_ge                    = 567 # (item_slot_ge,<item_id>,<slot_no>,<value>),


play_sound                      = 600 # (play_sound,<sound_id>,[options]),
play_track                      = 601 # (play_track,<track_id>),
stop_all_sounds                 = 609 # (stop_all_sounds, [options]), # 0 = default, 1 = fade out current track, 2 = stop current track

copy_position                   = 700 # copies position_no_2 to position_no_1
				      # (copy_position,<position_no_1>,<position_no_2>),
init_position                   = 701 # (init_position,<position_no>),
get_trigger_object_position     = 702 # (get_trigger_object_position,<position_no>),
get_distance_between_positions  = 710 # gets distance in centimeters.
				      # (get_distance_between_positions,<destination>,<position_no_1>,<position_no_2>),
position_is_behind_position     = 713 # (position_is_behind_position,<position_no_1>,<position_no_2>),

position_transform_position_to_parent = 715 # (position_transform_position_to_parent,<dest_position_no>,<position_no>,<position_no_to_be_transformed>),
position_transform_position_to_local  = 716 # (position_transform_position_to_local, <dest_position_no>,<position_no>,<position_no_to_be_transformed>),

position_copy_rotation          = 718 # (position_copy_rotation,<position_no_1>,<position_no_2>), copies rotation of position_no_2 to position_no_1
position_copy_origin            = 719 # (position_copy_origin,<position_no_1>,<position_no_2>), copies origin of position_no_2 to position_no_1
position_move_x                 = 720 # movement is in cms, [0 = local; 1=global]
				      # (position_move_x,<position_no>,<movement>,[value]),
position_move_y                 = 721 # (position_move_y,<position_no>,<movement>,[value]),
position_move_z                 = 722 # (position_move_z,<position_no>,<movement>,[value]),

position_rotate_x               = 723 # (position_rotate_x,<position_no>,<angle>),
position_rotate_y               = 724 # (position_rotate_y,<position_no>,<angle>),
position_rotate_z               = 725 # (position_rotate_z,<position_no>,<angle>),

position_get_x                  = 726 # (position_get_x,<destination_fixed_point>,<position_no>), #x position in meters * fixed point multiplier is returned
position_get_y                  = 727 # (position_get_y,<destination_fixed_point>,<position_no>), #y position in meters * fixed point multiplier is returned
position_get_z                  = 728 # (position_get_z,<destination_fixed_point>,<position_no>), #z position in meters * fixed point multiplier is returned

position_set_x                  = 729 # (position_set_x,<position_no>,<value_fixed_point>), #meters / fixed point multiplier is set
position_set_y                  = 730 # (position_set_y,<position_no>,<value_fixed_point>), #meters / fixed point multiplier is set
position_set_z                  = 731 # (position_set_z,<position_no>,<value_fixed_point>), #meters / fixed point multiplier is set

position_get_scale_x            = 735 # (position_get_scale_x,<destination_fixed_point>,<position_no>), #x scale in meters * fixed point multiplier is returned
position_get_scale_y            = 736 # (position_get_scale_y,<destination_fixed_point>,<position_no>), #y scale in meters * fixed point multiplier is returned
position_get_scale_z            = 737 # (position_get_scale_z,<destination_fixed_point>,<position_no>), #z scale in meters * fixed point multiplier is returned

position_get_rotation_around_z  = 740 # (position_get_rotation_around_z,<destination>,<position_no>), #rotation around z axis is returned as angle

position_set_z_to_ground_level  = 791 # (position_set_z_to_ground_level, <position_no>),

start_presentation		= 900 # (start_presentation, <presentation_id>),
start_background_presentation	= 901 # (start_background_presentation, <presentation_id>), #can only be used in game menus
presentation_set_duration	= 902 # (presentation_set_duration, <duration-in-1/100-seconds>), #there must be an active presentation
create_text_overlay		= 910 # (create_text_overlay, <destination>, <string_id>), #returns overlay id
create_mesh_overlay		= 911 # (create_mesh_overlay, <destination>, <mesh_id>), #returns overlay id
create_button_overlay           = 912 # (create_button_overlay, <destination>, <string_id>), #returns overlay id
create_image_button_overlay	= 913 # (create_image_button_overlay, <destination>, <mesh_id>, <mesh_id>), #returns overlay id. second mesh is the pressed button mesh
create_slider_overlay           = 914 # (create_slider_overlay, <destination>, <min_value>, <max_value>), #returns overlay id
create_progress_overlay		= 915 # (create_progress_overlay, <destination>, <min_value>, <max_value>), #returns overlay id
create_combo_button_overlay	= 916 # (create_combo_button_overlay, <destination>), #returns overlay id
create_text_box_overlay         = 917 # (create_text_box_overlay, <destination>), #returns overlay id
create_check_box_overlay        = 918 # (create_check_box_overlay, <destination>), #returns overlay id
overlay_set_text		= 920 # (overlay_set_text, <overlay_id>, <string_id>),
overlay_set_color		= 921 # (overlay_set_color, <overlay_id>, <color>), #color in RGB format like 0xRRGGBB (put hexadecimal values for RR GG and BB parts)
overlay_set_alpha               = 922 # (overlay_set_alpha, <overlay_id>, <alpha>), #alpha in A format like 0xAA (put hexadecimal values for AA part)
overlay_set_hilight_color	= 923 # (overlay_set_hilight_color, <overlay_id>, <color>), #color in RGB format like 0xRRGGBB (put hexadecimal values for RR GG and BB parts)
overlay_set_hilight_alpha       = 924 # (overlay_set_hilight_alpha, <overlay_id>, <alpha>), #alpha in A format like 0xAA (put hexadecimal values for AA part)
overlay_set_size		= 925 # (overlay_set_size, <overlay_id>, <position_no>), #position's x and y values are used
overlay_set_position    	= 926 # (overlay_set_position, <overlay_id>, <position_no>), #position's x and y values are used
overlay_set_val            	= 927 # (overlay_set_val, <overlay_id>, <value>), #can be used for sliders, combo buttons and check boxes
overlay_set_boundaries         	= 928 # (overlay_set_boundaries, <overlay_id>, <min_value>, <max_value>),
overlay_set_area_size		= 929 # (overlay_set_area_size, <overlay_id>, <position_no>), #position's x and y values are used
overlay_set_mesh_rotation       = 930 # (overlay_set_mesh_rotation, <overlay_id>, <position_no>), #position's rotation values are used for rotations around x, y and z axis
overlay_add_item		= 931 # (overlay_add_item, <overlay_id>, <string_id>), # adds an item to the combo box
overlay_animate_to_color	= 932 # (overlay_animate_to_color, <overlay_id>, <duration-in-1/1000-seconds>, <color>), #alpha value will not be used
overlay_animate_to_alpha	= 933 # (overlay_animate_to_alpha, <overlay_id>, <duration-in-1/1000-seconds>, <color>), #only alpha value will be used
overlay_animate_to_highlight_color = 934 # (overlay_animate_to_highlight_color, <overlay_id>, <duration-in-1/1000-seconds>, <color>), #alpha value will not be used
overlay_animate_to_highlight_alpha = 935 # (overlay_animate_to_highlight_alpha, <overlay_id>, <duration-in-1/1000-seconds>, <color>), #only alpha value will be used
overlay_animate_to_size		= 936 # (overlay_animate_to_size, <overlay_id>, <duration-in-1/1000-seconds>, <position_no>), #position's x and y values are used as
overlay_animate_to_position	= 937 # (overlay_animate_to_position, <overlay_id>, <duration-in-1/1000-seconds>, <position_no>), #position's x and y values are used as

context_menu_add_item       = 980 # (right_mouse_menu_add_item, <string_id>, <value>), #must be called only inside script_game_right_mouse_menu_get_buttons


#-------------------------
# Mission Condition types
#-------------------------
all_enemies_defeated      = 1003 # (all_enemies_defeated),
race_completed_by_player  = 1004 # (race_completed_by_player),
num_active_teams_le       = 1005 # (num_active_teams_le,<value>),
main_hero_fallen          = 1006 # (main_hero_fallen),


#----------------------------
# NEGATIONS
#----------------------------
neg          = 0x80000000	 # (neg|<operation>),
this_or_next = 0x40000000	 # (this_or_next|<operation>),


lt           = neg | ge # less than		-- (lt,<value>,<value>),
neq          = neg | eq # not equal to		-- (neq,<value>,<value>),
le           = neg | gt # less or equal to	-- (le,<value>,<value>),

#-------------------------------------------------------------------------------------------
# CONSEQUENCE OPERATIONS                                                                   -
#-------------------------------------------------------------------------------------------
set_party_battle_mode           = 1020 # (set_party_battle_mode),
set_camera_follow_party         = 1021 # (set_camera_follow_party,<party_id>), #Works on map only.
start_map_conversation          = 1025 # (start_map_conversation,<troop_id>),
rest_for_hours                  = 1030 # (rest_for_hours,<rest_period>,[time_speed],[remain_attackable]),
rest_for_hours_interactive      = 1031 # (rest_for_hours_interactive,<rest_period>,[time_speed],[remain_attackable]),

add_xp_to_troop                 = 1062 # (add_xp_to_troop,<value>,[troop_id]),
add_gold_as_xp                  = 1063 # (add_gold_as_xp,<value>,[troop_id]),
add_xp_as_reward                = 1064 # (add_xp_as_reward,<value>),

add_gold_to_party               = 1070 # party_id should be different from 0
			       # (add_gold_to_party,<value>,<party_id>),

set_party_creation_random_limits= 1080 # (set_party_creation_random_limits, <min_value>, <max_value>), (values should be between 0, 100)
spawn_around_party              = 1100 # ID of spawned party is put into reg(0)
			       # (spawn_around_party,<party_id>,<party_template_id>),
set_spawn_radius                = 1103 # (set_spawn_radius,<value>),

display_log_message             = 1109 # (display_log_message,<string_id>,[hex_colour_code]),
display_message                 = 1110 # (display_message,<string_id>,[hex_colour_code]),
set_show_messages               = 1111 # (set_show_messages,<value>), #0 disables window messages 1 re-enables them.

add_troop_note_from_dialog      = 1114 # (add_troop_note_from_dialog,<troop_id>,<note_slot_no>, <value>), #There are maximum of 8 slots. value = 1 -> shows when the note is added
add_faction_note_from_dialog    = 1115 # (add_faction_note_from_dialog,<faction_id>,<note_slot_no>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
add_party_note_from_dialog      = 1116 # (add_party_note_from_dialog,<party_id>,<note_slot_no>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
add_quest_note_from_dialog      = 1112 # (add_quest_note_from_dialog,<quest_id>,<note_slot_no>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
add_troop_note_from_sreg        = 1117 # (add_troop_note_from_sreg,<troop_id>,<note_slot_no>,<string_id>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
add_faction_note_from_sreg      = 1118 # (add_faction_note_from_sreg,<faction_id>,<note_slot_no>,<string_id>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
add_party_note_from_sreg        = 1119 # (add_party_note_from_sreg,<party_id>,<note_slot_no>,<string_id>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
add_quest_note_from_sreg        = 1113 # (add_quest_note_from_sreg,<quest_id>,<note_slot_no>,<string_id>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added

tutorial_box                    = 1120 # (tutorial_box,<string_id>),
question_box                    = 1121 # (tutorial_box,<string_id>, [<yes_string_id>], [<no_string_id>]),
tutorial_message                = 1122 # (tutorial_message,<string_id>, <color>), #set string_id = -1 for hiding the message

reset_price_rates               = 1170 # (reset_price_rates),
set_price_rate_for_item         = 1171 # (set_price_rate_for_item,<item_id>,<value_percentage>),
set_price_rate_for_item_type    = 1172 # (set_price_rate_for_item_type,<item_type_id>,<value_percentage>),

party_join                      = 1201 		# (party_join),
party_join_as_prisoner          = 1202	# (party_join_as_prisoner),
troop_join                      = 1203		# (troop_join,<troop_id>),
troop_join_as_prisoner          = 1204	# (troop_join_as_prisoner,<troop_id>),

remove_member_from_party        = 1210	# (remove_member_from_party,<troop_id>,[party_id]),
remove_regular_prisoners        = 1211	# (remove_regular_prisoners,<party_id>),
remove_troops_from_companions   = 1215	# (remove_troops_from_companions,<troop_id>,<value>),
remove_troops_from_prisoners    = 1216  # (remove_troops_from_prisoners,<troop_id>,<value>),

heal_party                      = 1225		# (heal_party,<party_id>),

disable_party                   = 1230		# (disable_party,<party_id>),
enable_party                    = 1231		# (enable_party,<party_id>),
remove_party                    = 1232		# (remove_party,<party_id>),
add_companion_party             = 1233	# (add_companion_party,<troop_id_hero>),

add_troop_to_site               = 1250	# (add_troop_to_site,<troop_id>,<scene_id>,<entry_no>),
remove_troop_from_site          = 1251	# (remove_troop_from_site,<troop_id>,<scene_id>),
modify_visitors_at_site         = 1261	# (modify_visitors_at_site,<scene_id>),
reset_visitors                  = 1262		# (reset_visitors),
set_visitor                     = 1263		# (set_visitor,<entry_no>,<troop_id>,[<dna>]),
set_visitors                    = 1264		# (set_visitors,<entry_no>,<troop_id>,<number_of_troops>),

set_relation                    = 1270 # (set_relation,<faction_id>,<faction_id>,<value>),

#Quest stuff
start_quest              = 1280 # (start_quest,<quest_id>),
complete_quest           = 1281 # (complete_quest,<quest_id>),
succeed_quest            = 1282 # (succeed_quest,<quest_id>),
fail_quest               = 1283 # (fail_quest,<quest_id>),
cancel_quest             = 1284 # (cancel_quest,<quest_id>),

set_quest_progression    = 1285 # (set_quest_progression,<quest_id>,<value>),

setup_quest_text         = 1290 # (setup_quest_text,<quest_id>),
setup_quest_giver        = 1291 # (setup_quest_giver,<quest_id>, <string_id>),


#encounter outcomes.
start_encounter            = 1300 # (start_encounter,<party_id>),
leave_encounter            = 1301 # (leave_encounter),
encounter_attack           = 1302 # (encounter_attack),
select_enemy               = 1303 # (select_enemy,<value>),
set_passage_menu           = 1304 # (set_passage_menu,<value>),

#simulate_battle            = 1305 # (simulate_battle,<value>),
end_current_battle         = 1307 # (end_current_battle),



set_mercenary_source_party = 1320 # selects party from which to buy mercenaries
				   # (set_mercenary_source_party,<party_id>),


set_merchandise_modifier_quality = 1490	        # Quality rate in percentage (average quality = 100),
						# (set_merchandise_modifier_quality,<value>),
set_merchandise_max_value = 1491		# (set_merchandise_max_value,<value>),
reset_item_probabilities = 1492		        # (reset_item_probabilities),
set_item_probability_in_merchandise = 1493	# (set_item_probability_in_merchandise,<itm_id>,<value>),

#active Troop
#set_active_troop                       = 10500
troop_set_type                         = 1505	# (troop_set_type,<troop_id>,<gender>),
troop_get_type                         = 1506   # (troop_get_type,<destination>,<troop_id>),
troop_is_hero                          = 1507   # (troop_is_hero,<troop_id>),
troop_is_wounded                       = 1508   # (troop_is_wounded,<troop_id>), #only for heroes!
troop_set_auto_equip                   = 1509   # (troop_set_auto_equip,<troop_id>,<value>),#disables otr enables auto-equipping
troop_ensure_inventory_space           = 1510	# (troop_ensure_inventory_space,<troop_id>,<value>),
troop_add_merchandise                  = 1512	# (troop_add_merchandise,<troop_id>,<item_type_id>,<value>),

troop_raise_attribute                  = 1520	# (troop_raise_attribute,<troop_id>,<attribute_id>,<value>),
troop_raise_skill                      = 1521	# (troop_raise_skill,<troop_id>,<skill_id>,<value>),
troop_raise_proficiency                = 1522	# (troop_raise_proficiency,<troop_id>,<proficiency_no>,<value>),
troop_raise_proficiency_linear         = 1523	# raises weapon proficiencies linearly without being limited by weapon master skill
						# (troop_raise_proficiency,<troop_id>,<proficiency_no>,<value>),

troop_add_proficiency_points           = 1525   # (troop_add_proficiency_points,<troop_id>,<value>),					
troop_add_gold                         = 1528	# (troop_add_gold,<troop_id>,<value>),
troop_remove_gold                      = 1529	# (troop_remove_gold,<troop_id>,<value>),
troop_add_item                         = 1530	# (troop_add_item,<troop_id>,<item_id>,[modifier]),
troop_remove_item                      = 1531	# (troop_remove_item,<troop_id>,<item_id>),
troop_clear_inventory                  = 1532	# (troop_clear_inventory,<troop_id>),
troop_equip_items		       = 1533   # (troop_equip_items,<troop_id>), #equips the items in the inventory automatically
troop_inventory_slot_set_item_amount   = 1534   # (troop_inventory_slot_set_item_amount,<troop_id>,<inventory_slot_no>,<value>),
troop_inventory_slot_get_item_amount   = 1537   # (troop_inventory_slot_get_item_amount,<destination>,<troop_id>,<inventory_slot_no>),
troop_inventory_slot_get_item_max_amount= 1538  # (troop_inventory_slot_get_item_max_amount,<destination>,<troop_id>,<inventory_slot_no>),

troop_add_items                        = 1535	# (troop_add_items,<troop_id>,<item_id>,<number>),
troop_remove_items                     = 1536	# puts cost of items to reg0
					# (troop_add_items,<troop_id>,<item_id>,<number>),
troop_loot_troop                       = 1539	# (troop_loot_troop,<target_troop>,<source_troop_id>,<probability>), 

troop_get_inventory_capacity           = 1540	# (troop_get_inventory_capacity,<destination>,<troop_id>),
troop_get_inventory_slot               = 1541	# (troop_get_inventory_slot,<destination>,<troop_id>,<inventory_slot_no>),
troop_get_inventory_slot_modifier      = 1542	# (troop_get_inventory_slot_modifier,<destination>,<troop_id>,<inventory_slot_no>),
troop_set_inventory_slot               = 1543	# (troop_set_inventory_slot,<troop_id>,<inventory_slot_no>,<value>),
troop_set_inventory_slot_modifier      = 1544	# (troop_set_inventory_slot_modifier,<troop_id>,<inventory_slot_no>,<value>),
troop_set_faction                      = 1550   # (troop_set_faction,<troop_id>,<faction_id>),
troop_set_health                       = 1560	# (troop_set_health,<troop_id>,<relative health (0-100)>),

troop_get_upgrade_troop                = 1561   # (troop_get_upgrade_troop,<destination>,<troop_id>,<upgrade_path>), #upgrade_path can be: 0 = get first node, 1 = get second node (returns -1 if not available)

#Parties...
party_get_num_companions               = 1601	# (party_get_num_companions,<destination>,<party_id>),
party_get_num_prisoners                = 1602	# (party_get_num_prisoners,<destination>,<party_id>),
party_set_flags                        = 1603   # (party_set_flag, <party_id>, <flag>, <clear_or_set>), #sets flags like pf_default_behavior. see header_parties.py for flags.

party_set_extra_text                   = 1605   # (party_set_extra_text,<party_id>, <string>)

party_get_current_terrain              = 1608	# (party_get_current_terrain,<destination>,<party_id>),
party_get_template_id                  = 1609	# (party_get_template_id,<destination>,<party_id>),

party_add_members                      = 1610	# (party_add_members,<party_id>,<troop_id>,<number>), #returns number added in reg0
party_add_prisoners                    = 1611	# (party_add_prisoners,<party_id>,<troop_id>,<number>),#returns number added in reg0
party_add_leader                       = 1612	# (party_add_leader,<party_id>,<troop_id>,[<number>]),
party_force_add_members                = 1613	# (party_force_add_members,<party_id>,<troop_id>,<number>),
party_force_add_prisoners              = 1614	# (party_force_add_prisoners,<party_id>,<troop_id>,<number>),

party_remove_members                   = 1615	# stores number removed to reg0
						# (party_remove_members,<party_id>,<troop_id>,<number>),
party_remove_prisoners                 = 1616	# stores number removed to reg0
						# (party_remove_members,<party_id>,<troop_id>,<number>),
party_clear                            = 1617	# (party_clear,<party_id>),
party_wound_members                    = 1618	# (party_wound_members,<party_id>,<troop_id>,<number>),

party_set_faction                      = 1620	# (party_set_faction,<party_id>,<faction_id>),
party_relocate_near_party              = 1623	# (party_relocate_near_party,<party_id>,<target_party_id>,<value_spawn_radius>),

party_get_position                     = 1625	# (party_get_position,<position_no>,<party_id>),
party_set_position                     = 1626	# (party_set_position,<party_id>,<position_no>),
map_get_random_position_around_position= 1627	# (map_get_random_position_around_position,<dest_position_no>,<source_position_no>,<radius>),
map_get_land_position_around_position  = 1628	# (map_get_land_position_around_position,<dest_position_no>,<source_position_no>,<radius>),
map_get_water_position_around_position = 1629	# (map_get_water_position_around_position,<dest_position_no>,<source_position_no>,<radius>),


party_count_members_of_type            = 1630	# (party_count_members_of_type,<destination>,<party_id>,<troop_id>),
party_count_companions_of_type         = 1631	# (party_count_companions_of_type,<destination>,<party_id>,<troop_id>),
party_count_prisoners_of_type          = 1632	# (party_count_prisoners_of_type,<destination>,<party_id>,<troop_id>),

party_get_free_companions_capacity     = 1633   # (party_get_free_companions_capacity,<destination>,<party_id>),
party_get_free_prisoners_capacity      = 1634   # (party_get_free_prisoners_capacity,<destination>,<party_id>),

party_set_ai_behavior                  = 1640	# (party_set_ai_behavior,<party_id>,<ai_bhvr>),
party_set_ai_object                    = 1641	# (party_set_ai_object,<party_id>,<party_id>),
party_set_ai_target_position           = 1642	# (party_set_ai_target_position,<party_id>,<position_no>),
party_set_ai_patrol_radius             = 1643	# (party_set_ai_patrol_radius,<party_id>,<radius_in_km>),
party_ignore_player                    = 1644   # (party_ignore_player, <party_id>,<duration_in_hours>), #don't pursue player party for this duration

party_get_num_companion_stacks         = 1650   # (party_get_num_companion_stacks,<destination>,<party_id>),
party_get_num_prisoner_stacks          = 1651   # (party_get_num_prisoner_stacks, <destination>,<party_id>),
party_stack_get_troop_id               = 1652   # (party_stack_get_troop_id,      <destination>,<party_id>,<stack_no>),
party_stack_get_size                   = 1653   # (party_stack_get_size,          <destination>,<party_id>,<stack_no>),
party_stack_get_num_wounded            = 1654   # (party_stack_get_num_wounded,   <destination>,<party_id>,<stack_no>),
party_stack_get_troop_dna              = 1655   # (party_stack_get_troop_dna,     <destination>,<party_id>,<stack_no>),
party_prisoner_stack_get_troop_id      = 1656   # (party_get_prisoner_stack_troop,<destination>,<party_id>,<stack_no>),
party_prisoner_stack_get_size          = 1657   # (party_get_prisoner_stack_size, <destination>,<party_id>,<stack_no>),
party_prisoner_stack_get_troop_dna     = 1658   # (party_prisoner_stack_get_troop_dna, <destination>,<party_id>,<stack_no>),

party_attach_to_party                  = 1660   # (party_attach_to_party, <party_id>, <party_id to attach to>),
party_detach                           = 1661   # (party_detach, <party_id>),
party_collect_attachments_to_party     = 1662   # (party_collect_attachments_to_party, <party_id>, <destination party_id>),
party_quick_attach_to_current_battle   = 1663   # (party_quick_attach_to_current_battle, <party_id>, <side (0:players side, 1:enemy side)>),

party_get_cur_town                     = 1665   # (party_get_cur_town, <destination>, <party_id>),

party_leave_cur_battle                 = 1666   # (party_leave_cur_battle, <party_id>),
party_set_next_battle_simulation_time  = 1667   # (party_set_next_battle_simulation_time,<party_id>,<next_simulation_time_in_hours>),

party_set_name                         = 1669   # (party_set_name, <party_id>, <string_no>),

party_get_morale                       = 1671   # (party_get_morale, <destination>,<party_id>),
party_set_morale                       = 1672   # (party_set_morale, <party_id>, <value>), #value is clamped to range [0...100].

party_upgrade_with_xp                  = 1673   # (party_upgrade_with_xp, <party_id>, <xp_amount>, <upgrade_path>), #upgrade_path can be:
                                                                                                                    #0 = choose random, 1 = choose first, 2 = choose second
party_add_xp                           = 1674   # (party_add_xp, <party_id>, <xp_amount>),

party_add_template                     = 1675   # (party_add_template, <party_id>, <party_template_id>, [reverse_prisoner_status]),

party_set_icon                         = 1676   # (party_set_icon, <party_id>, <map_icon_id>),
party_set_banner_icon                  = 1677   # (party_set_banner_icon, <party_id>, <map_icon_id>),
party_add_particle_system              = 1678   # (party_add_particle_system, <party_id>, <particle_system_id>),
party_clear_particle_systems           = 1679   # (party_clear_particle_systems, <party_id>),

party_get_battle_opponent              = 1680   # (party_get_battle_opponent, <destination>, <party_id>)

party_get_skill_level                  = 1685   # (party_get_skill_level, <destination>, <party_id>, <skill_no>),
get_battle_advantage                   = 1690   # (get_battle_advantage, <destination>),
set_battle_advantage                   = 1691   # (set_battle_advantage, <value>),

party_get_attached_to                  = 1694   # (party_get_attached_to, <destination>, <party_id>),
party_get_num_attached_parties         = 1695   # (party_get_num_attached_parties, <destination>, <party_id>),
party_get_attached_party_with_rank     = 1696   # (party_get_attached_party_with_rank, <destination>, <party_id>, <attached_party_no>),

inflict_casualties_to_party_group      = 1697   # (inflict_casualties_to_party, <parent_party_id>, <attack_rounds>, <party_id_to_add_causalties_to>), 
distribute_party_among_party_group     = 1698   # (distribute_party_among_party_group, <party_to_be_distributed>, <group_root_party>),

#Agents
#store_distance_between_positions,
#position_is_behind_poisiton,
get_player_agent_no                    = 1700	# (get_player_agent_no,<destination>),
get_player_agent_kill_count            = 1701	# (get_player_agent_kill_count,<destination>,[get_wounded]), #Set second value to non-zero to get wounded count
agent_is_alive                         = 1702	# (agent_is_alive,<agent_id>),
agent_is_wounded                       = 1703	# (agent_is_wounded,<agent_id>),
agent_is_human                         = 1704	# (agent_is_human,<agent_id>),
get_player_agent_own_troop_kill_count  = 1705   # (get_player_agent_own_troop_kill_count,<destination>,[get_wounded]), #Set second value to non-zero to get wounded count
agent_is_ally                          = 1706	# (agent_is_ally,<agent_id>),
agent_is_defender                      = 1708	# (agent_is_defender,<agent_id>),
agent_get_look_position                = 1709   # (agent_get_look_position, <position_no>, <agent_id>),
agent_get_position                     = 1710	# (agent_get_position,<position_no>,<agent_id>),
agent_set_position                     = 1711	# (agent_set_position,<agent_id>,<position_no>),
agent_get_horse                        = 1714	# (agent_get_horse,<destination>,<agent_id>),
agent_get_rider                        = 1715	# (agent_get_rider,<destination>,<agent_id>),
agent_get_party_id                     = 1716	# (agent_get_party_id,<destination>,<agent_id>),

agent_get_troop_id                     = 1718	# (agent_get_troop_id,<destination>, <agent_id>),
agent_get_item_id                      = 1719	# (agent_get_item_id,<destination>, <agent_id>), (works only for horses, returns -1 otherwise)

store_agent_hit_points                 = 1720	# set absolute to 1 to retrieve actual hps, otherwise will return relative hp in range [0..100]
						# (store_agent_hit_points,<destination>,<agent_id>,[absolute]),
agent_set_hit_points                   = 1721	# set absolute to 1 if value is absolute, otherwise value will be treated as relative number in range [0..100]
						# (agent_set_hit_points,<agent_id>,<value>,[absolute]),
agent_deliver_damage_to_agent          = 1722	# (agent_deliver_damage_to_agent,<agent_id_deliverer>,<agent_id>),
agent_get_wielded_item                 = 1726	# (agent_get_wielded_item,<destination>,<agent_id>,<hand_no>),
agent_get_ammo                         = 1727	# (agent_get_ammo,<destination>,<agent_id>),
agent_refill_ammo                      = 1728	# (agent_refill_ammo,<agent_id>),
agent_has_item_equipped                = 1729	# (agent_has_item_equipped,<agent_id>,<item_id>),

agent_set_scripted_destination         = 1730	# (agent_set_scripted_destination,<agent_id>,<position_no>,<auto_set_z_to_ground_level>), #auto_set_z_to_ground_level can be 0 (false) or 1 (true)
agent_get_scripted_destination         = 1731   # (agent_get_scripted_destination,<position_no>,<agent_id>),
agent_clear_scripted_mode              = 1735	# (agent_clear_scripted_mode,<agent_id>),
agent_set_speed_limit                  = 1736   # (agent_set_speed_limit,<agent_id>,<speed_limit(kilometers/hour)>), #Affects AI only 
agent_ai_set_always_attack_in_melee    = 1737   # (agent_ai_set_always_attack_in_melee, <agent_id>,<value>), #to be used in sieges so that agents don't wait on the ladder.

agent_set_animation                    = 1740   # (agent_set_animation, <agent_id>, <anim_id>),

agent_get_team                         = 1770   # (agent_get_team  ,<destination>, <agent_id>),
agent_set_team                         = 1771   # (agent_set_team  , <agent_id>, <value>),

agent_get_class                        = 1772   # (agent_get_class ,<destination>, <agent_id>),

class_is_listening_order               = 1775   # (class_is_listening_order, <team_no>, <sub_class>),

entry_point_get_position               = 1780	# (entry_point_get_position,<position_no>,<entry_no>),

team_get_movement_order                = 1785   # (team_get_movement_order, <destination>, <team_no>, <sub_class>),
team_get_riding_order                  = 1786   # (team_get_riding_order, <destination>, <team_no>, <sub_class>),
team_get_weapon_usage_order            = 1787   # (team_get_weapon_usage_order, <destination>, <team_no>, <sub_class>),
teams_are_enemies                      = 1788   # (teams_are_enemies, <team_no>, <team_no_2>), 
team_give_order                        = 1790   # (team_give_order, <team_no>, <sub_class>, <order_id>),
team_set_order_position                = 1791   # (team_set_order_position, <team_no>, <sub_class>, <position_no>),
team_get_leader                        = 1792   # (team_get_leader, <destination>, <team_no>),
team_set_leader                        = 1793   # (team_set_leader, <team_no>, <new_leader_agent_id>),
team_get_order_position                = 1794   # (team_get_order_position, <position_no>, <team_no>, <sub_class>),
team_set_order_listener                = 1795   # (team_set_order_listener, <team_no>, <sub_class>),
team_set_relation                      = 1796   # (team_set_relation, <team_no>, <team_no_2>, <value>), # -1 for enemy, 1 for friend, 0 for neutral

set_rain                               = 1797   # (set_rain,<rain-type>,<strength>), (rain_type: 1= rain, 2=snow ; strength: 0 - 100)
set_fog_distance                       = 1798   # (set_fog_distance, <distance_in_meters>, [fog_color]),
get_scene_boundaries                   = 1799   # (get_scene_boundaries, <position_min>, <position_max>),

#Scene_prop_disable no longer works.
#scene_prop_disable                     = 1800	# (scene_prop_disable,<scene_prop_id>),

scene_prop_get_num_instances           = 1810	# (scene_prop_get_num_instances,<destination>, <scene_prop_id>),
scene_prop_get_instance                = 1811	# (scene_prop_get_instance,<destination>, <scene_prop_id>, <instance_no>),

prop_instance_get_position             = 1850	# (prop_instance_get_position,<position_no>,<scene_prop_id>),
prop_instance_get_starting_position    = 1851	# (prop_instance_get_starting_position,<position_no>,<scene_prop_id>),
prop_instance_get_scale                = 1852	# (prop_instance_get_scale,<position_no>,<scene_prop_id>),

prop_instance_set_position             = 1855	# (prop_instance_set_position,<scene_prop_id>,position),
prop_instance_animate_to_position      = 1860	# (prop_instance_animate_to_position,<scene_prop_id>,position,<duration-in-1/100-seconds>),

replace_scene_props                    = 1890   # (replace_scene_props, <old_scene_prop_id>,<new_scene_prop_id>),
#---------------------------
# Mission Consequence types
#---------------------------

set_mission_result                     = 1906	# (set_mission_result,<value>),
finish_mission                         = 1907	# (finish_mission),
jump_to_scene                          = 1910	# (jump_to_scene,<scene_id>,<entry_no>),
set_jump_mission                       = 1911	# (set_jump_mission,<mission_template_id>),
set_jump_entry                         = 1912	# (set_jump_entry,<entry_no>),
start_mission_conversation             = 1920	# (start_mission_conversation,<troop_id>),
add_reinforcements_to_entry            = 1930	# (add_reinforcements_to_entry,<mission_template_entry_no>,<value>),



set_current_color                      = 1950	# red, green, blue: a value of 255 means 100%
					          # (set_current_color,<value>,<value>,<value>),
set_position_delta                     = 1955	# x, y, z
					# (set_position_delta,<value>,<value>,<value>),
add_point_light                        = 1960	# (add_point_light,[flicker_magnitude],[flicker_interval]), #flicker_magnitude between 0 and 100, flicker_interval is in 1/100 seconds
particle_system_add_new                = 1965	# (particle_system_add_new,<par_sys_id>,[position_no]),
particle_system_emit                   = 1968	# (particle_system_emit,<par_sys_id>,<value_num_particles>,<value_period>),
particle_system_burst                  = 1969	# (particle_system_burst,<par_sys_id>,<position_no>,[percentage_burst_strength]),

set_spawn_position                     = 1970   # (set_spawn_position, <position_no>) 
spawn_item                             = 1971   # (spawn_item, <item_kind_id>, <item_modifier>) 
spawn_agent                            = 1972	# (spawn_new_agent,<troop_id>), (stores agent_id in reg0)
spawn_horse                            = 1973	# (spawn_horse,<item_kind_id>, <item_modifier>)  (stores agent_id in reg0)
###spawn_scene_prop                       = 11304    # (spawn_scene_prop, <scene_prop_id>)  (stores prop_instance_id in reg0) not yet.

mission_cam_set_mode                   = 2001   # (mission_cam_set_mode, <mission_cam_mode>)
mission_cam_get_position               = 2010   # (mission_cam_get_position,<position_register_no>)
mission_cam_set_position               = 2011   # (mission_cam_set_position,<position_register_no>)
mission_cam_animate_to_position        = 2012   # (mission_cam_set_position,<position_register_no>)

talk_info_show                         = 2020   # (talk_info_show, <hide_or_show>) :0=hide 1=show
talk_info_set_relation_bar             = 2021   # (talk_info_set_relation_bar, <value>) :set relation bar to a value between -100 to 100, enter an invalid value to hide the bar.
talk_info_set_line                     = 2022   # (talk_info_set_line, <line_no>, <string_no>)

#mesh related
set_background_mesh                    = 2031   # (set_background_mesh, <mesh_id>),

#change_window types.
change_screen_return                   = 2040	# (change_screen_return),
change_screen_loot                     = 2041	# (change_screen_loot, <troop_id>),
change_screen_trade                    = 2042	# (change_screen_trade),
change_screen_exchange_members         = 2043   # (change_screen_exchange_members, [0,1 = exchange_leader]),
change_screen_trade_prisoners          = 2044	# (change_screen_trade_prisoners),
change_screen_buy_mercenaries          = 2045	# (change_screen_buy_mercenaries),
change_screen_view_character           = 2046	# (change_screen_view_character),
change_screen_training                 = 2047	# (change_screen_training),
change_screen_mission                  = 2048	# (change_screen_mission),
change_screen_map_conversation         = 2049   # (change_screen_map_conversation),
change_screen_exchange_with_party      = 2050   # (change_screen_exchange_with_party, <party_id>),
change_screen_equip_other              = 2051	# (change_screen_equip_other, <troop_id>),
change_screen_map                      = 2052
change_screen_notes                    = 2053   # (change_screen_notes, <note_type>, <object_id>), #Note type can be 1 = troops, 2 = factions, 3 = parties, 4 = quests
change_screen_quit                     = 2055   # (change_screen_quit),

jump_to_menu                           = 2060	# (jump_to_menu,<menu_id>),
disable_menu_option                    = 2061   # (disable_menu_option),

store_trigger_param_1  = 2071  # (store_trigger_param_1,<destination>),
store_trigger_param_2  = 2072  # (store_trigger_param_2,<destination>),
set_trigger_result     = 2075  # (set_trigger_result, <value>),

val_add                = 2105	#dest, operand ::       dest = dest + operand
				# (val_add,<destination>,<value>),
val_sub                = 2106	#dest, operand ::       dest = dest + operand
				# (val_sub,<destination>,<value>),
val_mul                = 2107	#dest, operand ::       dest = dest * operand
				# (val_mul,<destination>,<value>),
val_div                = 2108	#dest, operand ::       dest = dest / operand
				# (val_div,<destination>,<value>),
val_mod                = 2109	#dest, operand ::       dest = dest mod operand
				# (val_mod,<destination>,<value>),
val_min                = 2110	#dest, operand ::       dest = min(dest, operand)
				# (val_min,<destination>,<value>),
val_max                = 2111	#dest, operand ::       dest = max(dest, operand)
				# (val_max,<destination>,<value>),
val_clamp              = 2112	#dest, operand ::       dest = max(min(dest,<upper_bound> - 1),<lower_bound>)
				# (val_clamp,<destination>,<lower_bound>, <upper_bound>),
val_abs                = 2113  #dest          ::       dest = abs(dest)
                                # (val_abs,<destination>),

store_add              = 2120	#dest, op1, op2 :      dest = op1 + op2
				# (store_add,<destination>,<value>,<value>),
store_sub              = 2121	#dest, op1, op2 :      dest = op1 - op2
				# (store_sub,<destination>,<value>,<value>),
store_mul              = 2122	#dest, op1, op2 :      dest = op1 * op2
				# (store_mul,<destination>,<value>,<value>),
store_div              = 2123	#dest, op1, op2 :      dest = op1 / op2
				# (store_div,<destination>,<value>,<value>),

set_fixed_point_multiplier      = 2124 # (set_fixed_point_multiplier, <value>),
                                        # sets the precision of the values that are named as value_fixed_point or destination_fixed_point.
                                        # Default is 1 (every fixed point value will be regarded as an integer)

store_sqrt             = 2125  # (store_sqrt, <destination_fixed_point>, <value_fixed_point>), takes square root of the value
store_pow              = 2126  # (store_pow, <destination_fixed_point>, <value_fixed_point>, <value_fixed_point), takes square root of the value
                                #dest, op1, op2 :      dest = op1 ^ op2
store_sin              = 2127  # (store_sin, <destination_fixed_point>, <value_fixed_point>), takes sine of the value that is in degrees
store_cos              = 2128  # (store_cos, <destination_fixed_point>, <value_fixed_point>), takes cosine of the value that is in degrees
store_tan              = 2129  # (store_tan, <destination_fixed_point>, <value_fixed_point>), takes tangent of the value that is in degrees

convert_to_fixed_point = 2130  # (convert_to_fixed_point, <destination_fixed_point>), multiplies the value with the fixed point multiplier
convert_from_fixed_point= 2131 # (convert_from_fixed_point, <destination>), divides the value with the fixed point multiplier

assign                 = 2133	# had to put this here so that it can be called from conditions.
				# (assign,<destination>,<value>),
shuffle_range          = 2134	# (shuffle_range,<reg_no>,<reg_no>),

store_random           = 2135	# deprecated, use store_random_in_range instead.
store_random_in_range  = 2136	# gets random number in range [range_low,range_high] excluding range_high 
				# (store_random_in_range,<destination>,<range_low>,<range_high>),
store_troop_gold       = 2149	# (store_troop_gold,<destination>,<troop_id>),

store_num_free_stacks           = 2154 # (store_num_free_stacks,<destination>,<party_id>),
store_num_free_prisoner_stacks  = 2155 # (store_num_free_prisoner_stacks,<destination>,<party_id>),

store_party_size                = 2156	# (store_party_size,<destination>,[party_id]),
store_party_size_wo_prisoners   = 2157	# (store_party_size_wo_prisoners,<destination>,[party_id]),
store_troop_kind_count          = 2158 # deprecated, use party_count_members_of_type instead
store_num_regular_prisoners     = 2159	# (store_mum_regular_prisoners,<destination>,<party_id>),

store_troop_count_companions    = 2160	# (store_troop_count_companions,<destination>,<troop_id>,[party_id]),
store_troop_count_prisoners     = 2161	# (store_troop_count_prisoners,<destination>,<troop_id>,[party_id]),
store_item_kind_count           = 2165	# (store_item_kind_count,<destination>,<item_id>,[troop_id]),

store_free_inventory_capacity   = 2167	# (store_free_inventory_capacity,<destination>,[troop_id]),

store_skill_level               = 2170	# (store_skill_level,<destination>,<skill_id>,[troop_id]),
store_character_level           = 2171	# (store_character_level,<destination>,[troop_id]),
store_attribute_level           = 2172	# (store_attribute_level,<destination>,<troop_id>,<attribute_id>),

store_troop_faction             = 2173	# (store_troop_faction,<destination>,<troop_id>),
store_troop_health              = 2175	# (store_troop_health,<destination>,<troop_id>,[absolute]),
                                        #set absolute to 1 to get actual health; otherwise this will return percentage health in range (0-100)

store_proficiency_level         = 2176	# (store_proficiency_level,<destination>,<troop_id>,<attribute_id>),

					# (store_troop_health,<destination>,<troop_id>,[absolute]),
store_relation                  = 2190	# (store_relation,<destination>,<faction_id_1>,<faction_id_2>),
store_conversation_troop        = 2200 # (store_conversation_troop,<destination>),
store_partner_faction           = 2201 # (store_partner_faction,<destination>),
store_encountered_party         = 2202 # (store_encountered_party,<destination>),
store_encountered_party2        = 2203 # (store_encountered_party2,<destination>),
store_faction_of_party          = 2204 # (store_faction_of_party,<destination>),


#store_current_town              = 2210 # deprecated, use store_current_scene instead
#store_current_site              = 2211 # deprecated, use store_current_scene instead
store_current_scene             = 2211 # (store_current_scene,<destination>),

store_item_value                = 2230 # (store_item_value,<destination>,<item_id>),
store_troop_value               = 2231 # (store_troop_value,<destination>,<item_id>),

store_partner_quest             = 2240 # (store_partner_quest,<destination>),
store_random_quest_in_range     = 2250 # (store_random_quest_in_range,<destination>,<lower_bound>,<upper_bound>),
store_random_troop_to_raise     = 2251 # (store_random_troop_to_raise,<destination>,<lower_bound>,<upper_bound>),
store_random_troop_to_capture   = 2252	# (store_random_troop_to_capture,<destination>,<lower_bound>,<upper_bound>),
store_random_party_in_range     = 2254	# (store_random_party_in_range,<destination>,<lower_bound>,<upper_bound>),
store01_random_parties_in_range = 2255 # stores two random, different parties in a range to reg0 and reg1.
					# (store01_random_parties_in_range,<lower_bound>,<upper_bound>),
store_random_horse              = 2257	# (store_random_horse,<destination>)
store_random_equipment          = 2258	# (store_random_equipment,<destination>)
store_random_armor              = 2259	# (store_random_armor,<destination>)
store_quest_number              = 2261 # (store_quest_number,<destination>,<quest_id>),
store_quest_item                = 2262	# (store_quest_item,<destination>,<item_id>),
store_quest_troop               = 2263	# (store_quest_troop,<destination>,<troop_id>),

store_current_hours             = 2270 # (store_current_hours,<destination>),
store_time_of_day               = 2271	# (store_time_of_day,<destination>),
store_current_day               = 2272	# (store_current_day,<destination>),
is_currently_night              = 2273	# (is_currently_night),

store_distance_to_party_from_party = 2281	# (store_distance_to_party_from_party,<destination>,<party_id>,<party_id>),

get_party_ai_behavior                 = 2290	# (get_party_ai_behavior,<destination>,<party_id>),
get_party_ai_object                   = 2291	# (get_party_ai_object,<destination>,<party_id>),
party_get_ai_target_position          = 2292	# (party_get_ai_target_position,<position_no>,<party_id>),
get_party_ai_current_behavior         = 2293   # (get_party_ai_current_behavior,<destination>,<party_id>),
get_party_ai_current_object           = 2294	# (get_party_ai_current_object,<destination>,<party_id>),


store_num_parties_created             = 2300	# (store_num_parties_created,<destination>,<party_template_id>),
store_num_parties_destroyed           = 2301	# (store_num_parties_destroyed,<destination>,<party_template_id>),
store_num_parties_destroyed_by_player = 2302	# (store_num_parties_destroyed_by_player,<destination>,<party_template_id>),


# Searching operations.
store_num_parties_of_template   = 2310	# (store_num_parties_of_template,<destination>,<party_template_id>),
store_random_party_of_template  = 2311	# fails if no party exists with tempolate_id (expensive)
					# (store_random_party_of_template,<destination>,<party_template_id>),

str_clear                       = 2319 # (str_clear, <string_register>)
str_store_string                = 2320	# (str_store_string,<string_register>,<string_id>),
str_store_string_reg            = 2321	# (str_store_string,<string_register>,<string_no>), #copies one string register to another.
str_store_troop_name            = 2322	# (str_store_troop_name,<string_register>,<troop_id>),
str_store_troop_name_plural     = 2323	# (str_store_troop_name_plural,<string_register>,<troop_id>),
str_store_troop_name_by_count   = 2324	# (str_store_troop_name_by_count,<string_register>,<troop_id>,<number>),
str_store_item_name             = 2325	# (str_store_item_name,<string_register>,<item_id>),
str_store_item_name_plural      = 2326	# (str_store_item_name_plural,<string_register>,<item_id>),
str_store_item_name_by_count    = 2327	# (str_store_item_name_by_count,<string_register>,<item_id>),
str_store_party_name            = 2330	# (str_store_party_name,<string_register>,<party_id>),
str_store_agent_name            = 2332	# (str_store_agent_name,<string_register>,<agent_id>),
str_store_faction_name          = 2335	# (str_store_faction_name,<string_register>,<faction_id>),
str_store_quest_name            = 2336	# (str_store_quest_name,<string_register>,<quest_id>),
str_store_date                  = 2340 # (str_store_date,<string_register>,<number_of_days_to_add_to_the_current_date>),
str_store_troop_name_link       = 2341 # (str_store_troop_name_link,<string_register>,<troop_id>),
str_store_party_name_link       = 2342 # (str_store_party_name_link,<string_register>,<party_id>),
str_store_faction_name_link     = 2343 # (str_store_faction_name_link,<string_register>,<faction_id>),
str_store_quest_name_link       = 2344 # (str_store_quest_name_link,<string_register>,<faction_id>),

#mission ones:
store_remaining_team_no         = 2360	# (store_remaining_team_no,<destination>),

store_mission_timer_a = 2370	# (store_mission_timer_a,<destination>),
store_mission_timer_b = 2371	# (store_mission_timer_b,<destination>),
store_mission_timer_c = 2372	# (store_mission_timer_c,<destination>),

reset_mission_timer_a = 2375	# (reset_mission_timer_a),
reset_mission_timer_b = 2376	# (reset_mission_timer_b),
reset_mission_timer_c = 2377	# (reset_mission_timer_c),

store_enemy_count     = 2380 # (store_enemy_count,<destination>),
store_friend_count    = 2381 # (store_friend_count,<destination>),
store_ally_count      = 2382 # (store_ally_count,<destination>),
store_defender_count  = 2383 # (store_defender_count,<destination>),
store_attacker_count  = 2384 # (store_attacker_count,<destination>),
store_normalized_team_count = 2385 #(store_normalized_team_count,<destination>, <team_no>), #Counts the number of agents belonging to a team
                                                                                            # and normalizes the result regarding battle_size and advantage.
try_for_heroes = try_for_range,":this_hero","trp_first_npc","trp_last_npc"



#-------------------------------------------


lhs_operations = [try_for_range,
                  try_for_range_backwards,
                  try_for_parties,
                  try_for_agents,
                  store_script_param_1,
                  store_script_param_2,
                  store_script_param,
                  store_repeat_object,
                  troop_get_slot,
                  party_get_slot,
                  faction_get_slot,
                  scene_get_slot,
                  party_template_get_slot,
                  agent_get_slot,
                  quest_get_slot,
                  item_get_slot,
                  get_distance_between_positions,
                  position_get_x,
                  position_get_y,
                  position_get_z,
                  position_get_scale_x,
                  position_get_scale_y,
                  position_get_scale_z,
                  position_get_rotation_around_z,
                  create_text_overlay,
                  create_mesh_overlay,
                  create_button_overlay,
                  create_image_button_overlay,
                  create_slider_overlay,
                  create_progress_overlay,
                  create_combo_button_overlay,
                  create_text_box_overlay,
                  troop_get_type,
                  troop_inventory_slot_get_item_amount,
                  troop_get_inventory_capacity,
                  troop_get_inventory_slot,
                  troop_get_inventory_slot_modifier,
                  troop_get_upgrade_troop,
                  party_get_num_companions,
                  party_get_num_prisoners,
                  party_get_current_terrain,
                  party_get_template_id,
                  party_count_members_of_type,
                  party_count_companions_of_type,
                  party_count_prisoners_of_type,
                  party_get_free_companions_capacity,
                  party_get_free_prisoners_capacity,
                  party_get_num_companion_stacks,
                  party_get_num_prisoner_stacks,
                  party_stack_get_troop_id,
                  party_stack_get_size,
                  party_stack_get_num_wounded,
                  party_stack_get_troop_dna,
                  party_prisoner_stack_get_troop_id,
                  party_prisoner_stack_get_size,
                  party_get_cur_town,
                  party_get_morale,
                  party_get_battle_opponent,
                  party_get_skill_level,
                  get_battle_advantage,
                  party_get_attached_to,
                  party_get_num_attached_parties,
                  party_get_attached_party_with_rank,
                  get_player_agent_no,
                  get_player_agent_kill_count,
                  get_player_agent_own_troop_kill_count,
                  agent_get_position,
                  agent_get_horse,
                  agent_get_rider,
                  agent_get_party_id,
                  agent_get_troop_id,
                  agent_get_item_id,
                  store_agent_hit_points,
                  agent_get_wielded_item,
                  agent_get_ammo,
                  agent_get_team,
                  agent_get_class,
                  team_get_movement_order,
                  team_get_riding_order,
                  team_get_weapon_usage_order,
                  team_get_leader,
                  scene_prop_get_num_instances,
                  scene_prop_get_instance,
                  store_trigger_param_1,
                  store_trigger_param_2,
                  store_add,
                  store_sub,
                  store_mul,
                  store_div,
                  assign,
                  store_random,
                  store_random_in_range,
                  store_troop_gold,
                  store_num_free_stacks,
                  store_num_free_prisoner_stacks,
                  store_party_size,
                  store_party_size_wo_prisoners,
                  store_troop_kind_count,
                  store_num_regular_prisoners,
                  store_troop_count_companions,
                  store_troop_count_prisoners,
                  store_item_kind_count,
                  store_free_inventory_capacity,
                  store_skill_level,
                  store_character_level,
                  store_attribute_level,
                  store_troop_faction,
                  store_troop_health,
                  store_proficiency_level,
                  store_relation,
                  store_conversation_troop,
                  store_partner_faction,
                  store_encountered_party,
                  store_encountered_party2,
                  store_faction_of_party,
                  store_current_scene,
                  store_item_value,
                  store_troop_value,
                  store_partner_quest,
                  store_random_quest_in_range,
                  store_random_troop_to_raise,
                  store_random_troop_to_capture,
                  store_random_party_in_range,
                  store01_random_parties_in_range,
                  store_random_horse,
                  store_random_equipment,
                  store_random_armor,
                  store_quest_number,
                  store_quest_item,
                  store_quest_troop,
                  store_current_hours,
                  store_time_of_day,
                  store_current_day,
                  store_distance_to_party_from_party,
                  get_party_ai_behavior,
                  get_party_ai_object,
                  get_party_ai_current_behavior,
                  get_party_ai_current_object,
                  store_num_parties_created,
                  store_num_parties_destroyed,
                  store_num_parties_destroyed_by_player,
                  store_num_parties_of_template,
                  store_random_party_of_template,
                  store_remaining_team_no,
                  store_mission_timer_a,
                  store_mission_timer_b,
                  store_mission_timer_c,
                  store_enemy_count,
                  store_friend_count,
                  store_ally_count,
                  store_defender_count,
                  store_attacker_count,
                  store_normalized_team_count,
                  ]
global_lhs_operations = [val_add,
                         val_sub,
                         val_mul,
                         val_div,
                         val_max,
                         val_min,
                         val_mod
                         ]

can_fail_operations = [ge,
                       eq,
                       gt,
                       is_between,
                       entering_town,
                       map_free,
                       encountered_party_is_attacker,
                       conversation_screen_is_active,
                       in_meta_mission,
                       troop_is_hero,
                       troop_is_wounded,
                       key_is_down,
                       key_clicked,
                       game_key_is_down,
                       game_key_clicked,
                       hero_can_join,
                       hero_can_join_as_prisoner,
                       party_can_join,
                       party_can_join_as_prisoner,
                       troops_can_join,
                       troops_can_join_as_prisoner,
                       main_party_has_troop,
                       party_is_in_town,
                       party_is_in_any_town,
                       party_is_active,
                       player_has_item,
                       troop_has_item_equipped,
                       check_quest_active,
                       check_quest_finished,
                       check_quest_succeeded,
                       check_quest_failed,
                       troop_slot_eq,
                       party_slot_eq,
                       faction_slot_eq,
                       scene_slot_eq,
                       party_template_slot_eq,
                       agent_slot_eq,
                       quest_slot_eq,
                       troop_slot_ge,
                       party_slot_ge,
                       faction_slot_ge,
                       scene_slot_ge,
                       party_template_slot_ge,
                       agent_slot_ge,
                       quest_slot_ge,
                       position_is_behind_position,
                       all_enemies_defeated,
                       race_completed_by_player,
                       num_active_teams_le,
                       main_hero_fallen,
                       lt,
                       neq,
                       le,
                       teams_are_enemies,
                       agent_is_alive,
                       agent_is_wounded,
                       agent_is_human,
                       agent_is_ally,
                       agent_is_defender,
                       class_is_listening_order,
                       agent_has_item_equipped,
                       map_get_land_position_around_position,
                       map_get_water_position_around_position,
                       is_currently_night
                       ]
