from header_common import *
from header_animations import *

####################################################################################################################
#  There are two animation arrays (one for human and one for horse). Each animation in these arrays contains the following fields:
#  1) Animation id (string): used for referencing animations in other files. The prefix anim_ is automatically added before each animation-id .
#  2) Animation flags: could be anything beginning with acf_ defined in header_animations.py
#  3) Animation sequences (list).
#  3.1) Duration of the sequence.
#  3.2) Name of the animation resource.
#  3.3) Beginning frame of the sequence within the animation resource.
#  3.4) Ending frame of the sequence within the animation resource.
#  3.5) Sequence flags: could be anything beginning with arf_ defined in header_animations.py
# 
####################################################################################################################

#plan : 
# basic movement : walk ride etc. 0 -20000
#  on_foot  : 0     - 10000
#  horse    : 10000 - 20000
# combat         :                20000 - 40000
# fall           :                40000 - 70000
# act            : misc.          70000 - ...

horse_move = 10000
combat     = 20000
defend     = 35000
blow       = 40000

attack_parry_duration = 0.45
defend_parry_duration = 0.3
ready_durn     = 0.35
defend_duration = 0.25
cancel_duration = 0.25

blend_in_defense = arf_blend_in_5
blend_in_ready = arf_blend_in_6
blend_in_release = arf_blend_in_5
blend_in_parry = arf_blend_in_5

#### Animations begin here

# All of the animations are hardcoded. You can change these animations' sequences, resources or times. But each
# animation must stay at the same position, otherwise the game won't run properly. If you want to add a new animation,
# you can change both the ids and values of the animations which are named as unused_human_anim_???
# and unused_horse_anim_??? (??? = any number). You must not change used animations' ids.

human_animations = [
 ["stand", 0,
   [3.0, "anim_human", 50, 52, arf_cyclic|arf_loop_pos_0_25],
   [3.0, "anim_human", 60, 62, arf_cyclic|arf_loop_pos_0_75],
   [3.0, "anim_human", 70, 72, arf_cyclic|arf_loop_pos_0_25],
   [3.0, "anim_human", 80, 82, arf_cyclic|arf_loop_pos_0_5 |arf_two_handed_blade],
 ],
 ["stand_man", 0,
   [3.5, "anim_human", 90, 100, arf_cyclic|arf_loop_pos_0_25],
   [3.5, "anim_human", 110, 120, arf_cyclic|arf_loop_pos_0_25],
 ],
 ["jump", acf_enforce_lowerbody,
   [0.8, "anim_human", 270, 272, arf_blend_in_4],
 ],
 ["jump_end", acf_enforce_lowerbody,
   [0.4, "anim_human", 280, 290, arf_blend_in_3],
 ],
 ["stand_single", 0,
   [3.5, "anim_human", 110, 120, arf_cyclic|arf_loop_pos_0_25],
#   [2.0, "anim_human", 50, 52, arf_cyclic|arf_loop_pos_0_25],  
 ],
 ["stand_greatsword", 0,
   [2.0, "anim_human", 1100, 1120, arf_cyclic|arf_loop_pos_0_25],  
 ],
 ["stand_staff", 0,
   [2.0, "anim_human", 1500, 1520, arf_cyclic|arf_loop_pos_0],  
 ],
 ["walk_forward", acf_enforce_lowerbody,
   [1.0, "anim_human", 6000, 6020, arf_walk,pack2f(0.4,0.9)],
 ],
 ["walk_backward", acf_enforce_lowerbody,
   [1.0, "anim_human", 6020, 6000, arf_phase_odd|arf_walk,pack2f(0.4,0.9)],
 ],
 ["walk_forward_staff", acf_enforce_lowerbody,
   [1.0, "anim_human", 6100, 6120, arf_phase_odd|arf_walk,pack2f(0.4,0.9)],
 ],
 ["walk_backward_staff", acf_enforce_lowerbody,
   [1.0, "anim_human", 6120, 6100, arf_phase_odd|arf_walk,pack2f(0.4,0.9)],
 ],
 ["walk_forward_greatsword", acf_enforce_lowerbody,
   [1.0, "anim_human", 6200, 6220, arf_phase_odd|arf_walk,pack2f(0.4,0.9)],
 ],
 ["walk_backward_greatsword", acf_enforce_lowerbody,
   [1.0, "anim_human", 6220, 6200, arf_phase_odd|arf_walk,pack2f(0.4,0.9)],
 ],
 ["run_forward", acf_enforce_lowerbody,
   [0.8, "anim_human", 7000, 7040, arf_phase_odd|arf_walk|arf_blend_in_3,pack2f(0.4,0.9)], 
 ],
 ["run_backward", acf_enforce_lowerbody,
   [1.0, "anim_human", 7040, 7000, arf_phase_odd|arf_walk|arf_blend_in_3,pack2f(0.4,0.9)],
 ],
 ["run_forward_staff", acf_enforce_lowerbody,
   [0.8, "anim_human", 7100, 7140, arf_phase_odd|arf_walk,pack2f(0.4,0.9)], 
 ],
 ["run_backward_staff", acf_enforce_lowerbody,
   [1.0, "anim_human", 7140, 7100, arf_phase_odd|arf_walk,pack2f(0.4,0.9)],
 ],
 ["run_forward_greatsword", acf_enforce_lowerbody,
   [0.8, "anim_human", 7200, 7240, arf_phase_odd|arf_walk,pack2f(0.4,0.9)], 
 ],
 ["run_backward_greatsword", acf_enforce_lowerbody,
   [1.0, "anim_human", 7240, 7200, arf_phase_odd|arf_walk,pack2f(0.4,0.9)],
 ],
 ["walk_right", acf_enforce_lowerbody,
   [1.0, "anim_human", 8000, 8020, arf_walk,pack2f(0.4,0.9)], 
 ],
 ["walk_left", acf_enforce_lowerbody,
   [1.0, "anim_human", 8500, 8520, arf_phase_odd|arf_cyclic,pack2f(0.4,0.9)],
 ],
 ["run_right", acf_enforce_lowerbody,
   [0.8, "anim_human", 9000, 9020, arf_walk|arf_blend_in_3,pack2f(0.4,0.9)], 
 ],
 ["run_left", acf_enforce_lowerbody,
   [0.8, "anim_human", 9500, 9520, arf_phase_odd|arf_cyclic|arf_blend_in_3,pack2f(0.4,0.9)],  
 ],
 ["ride_0", acf_enforce_lowerbody,
   [10.0, "anim_human", horse_move+2000, horse_move+2100, arf_cyclic],
 ],
 ["ride_1", acf_enforce_lowerbody | acf_synch_with_horse,
   [0.8, "anim_human", horse_move + 160, horse_move+ 200, arf_cyclic],
 ],
 ["lancer_ride_1", acf_enforce_lowerbody | acf_synch_with_horse,
   [0.8, "anim_human", horse_move+210, horse_move+250, arf_cyclic |  arf_blend_in_16],
 ],
 ["lancer_charge_parried",acf_enforce_lowerbody,
   [0.5, "anim_human", horse_move+210, horse_move+220, arf_blend_in_8],
 ],
 ["ride_2", acf_enforce_lowerbody | acf_synch_with_horse,
   [0.8, "anim_human", horse_move+310, horse_move+334, arf_cyclic], 
 ],
 ["ride_3", acf_enforce_lowerbody | acf_synch_with_horse,
   [0.6, "anim_human", horse_move+360, horse_move+400, arf_cyclic], 
 ],
 ["ride_4", acf_enforce_lowerbody | acf_synch_with_horse,
   [0.5, "anim_human", horse_move+430, horse_move+470, arf_cyclic], 
 ],
 ["lancer_ride_4", acf_enforce_lowerbody | acf_synch_with_horse | acf_parallels_for_look_slope,
   [0.5, "anim_human", horse_move+610, horse_move+650, arf_cyclic | arf_blend_in_32], 
 ],
 ["ride_rear", acf_enforce_lowerbody|acf_ignore_slope,
   [1.4, "anim_human", horse_move+820, horse_move+837,  arf_blend_in_16],
 ],
 ["ride_spur", acf_enforce_lowerbody,
   [0.3, "anim_human", horse_move+860, horse_move+865,  arf_blend_in_8],
 ],
 ["ride_jump", acf_enforce_lowerbody,
   [4.0, "anim_human", horse_move+900, horse_move+930,  arf_blend_in_16],
 ],
 ["ride_jump_end", acf_enforce_all,
   [0.1, "anim_human", horse_move+935, horse_move+940,  arf_blend_in_16],
 ],
 ["mount_horse", acf_enforce_all,
   [2.0, "anim_human", horse_move+1000, horse_move+1050,  arf_blend_in_1, 0, (0.0,0,0.0)],
 ],
 ["dismount_horse", acf_enforce_lowerbody|acf_displace_position,
   [2.0, "anim_human", horse_move+1100, horse_move+1150,  arf_blend_in_1, 0, (-0.5,0,0)],
 ],
 ["lancer_ride_0", acf_enforce_lowerbody,
   [4.0, "anim_human", horse_move + 5000, horse_move + 5057, arf_lancer|arf_cyclic],
 ],
 ["equip_sword", 0,
   [0.6, "anim_human", combat+0, combat+20, arf_blend_in_0],
 ],
 ["unequip_sword", 0,
   [0.3, "anim_human", combat+10, combat+0, arf_blend_in_0],
 ],
 ["equip_shield", 0,
   [0.6, "anim_human", combat+30, combat+45, arf_blend_in_0],
 ],
 ["unequip_shield", 0,
   [0.3, "anim_human", combat+40, combat+30, arf_blend_in_0],
 ],
 ["cancel_attack_onehanded", acf_rotate_body,
   [cancel_duration, "anim_human", 110, 111, arf_blend_in_8],
 ],
 ["cancel_attack_twohanded", acf_rotate_body,
   [cancel_duration, "anim_human", 1100, 1100, arf_blend_in_8],
 ],
 ["cancel_attack_polearm", acf_rotate_body,
   [cancel_duration, "anim_human", 1500, 1500, arf_blend_in_8],
 ],
#TODO: ready bow, release javelin and reload crossbow should have the same time 
# duration and controlled via weapon speed.
 ["ready_bow", acf_rotate_body|acf_parallels_for_look_slope,
   [1.5, "anim_human", combat+500, combat+530, blend_in_ready],
 ],
 ["release_bow", acf_rotate_body|acf_parallels_for_look_slope,
   [0.3, "anim_human", combat+530, combat+532, arf_blend_in_2],
 ],
 ["ready_bow_mounted", acf_rotate_body|acf_parallels_for_look_slope,
   [1.5, "anim_human", combat+800, combat+830, blend_in_ready],
 ],
 ["release_bow_mounted", acf_rotate_body|acf_parallels_for_look_slope,
   [0.3, "anim_human", combat+830, combat+832, arf_blend_in_2],
 ],
 ["ready_crossbow", acf_rotate_body|acf_parallels_for_look_slope,
   [1.5, "anim_human", combat+1300, combat+1320, blend_in_ready],
 ],
 ["release_crossbow", acf_rotate_body|acf_parallels_for_look_slope,
   [0.2, "anim_human", combat+1330, combat+1331, arf_blend_in_1],
 ],
 ["reload_crossbow", 0,
   [1.0, "anim_human", combat+1700, combat+1750, arf_blend_in_8],
 ],
 ["reload_crossbow_horseback", 0,
   [1.6, "anim_human", combat+1800, combat+1877, arf_blend_in_8],
 ],
 ["ready_javelin", acf_rotate_body,
   [0.3, "anim_human", combat+2000, combat+2010, blend_in_ready],
 ],
 ["release_javelin", acf_rotate_body,
   [1.0, "anim_human", combat+2010, combat+2025, arf_blend_in_0],
 ],
 ["ready_throwing_knife", acf_rotate_body,
   [0.3, "anim_human", combat+2100, combat+2110, blend_in_ready],
 ],
 ["release_throwing_knife", acf_rotate_body,
   [1.0, "anim_human", combat+2110, combat+2125, arf_blend_in_0],
 ],
 ["ready_throwing_axe", acf_rotate_body,
   [0.3, "anim_human", combat+2100, combat+2110, blend_in_ready],
 ],
 ["release_throwing_axe", acf_rotate_body,
   [1.0, "anim_human", combat+2110, combat+2125, arf_blend_in_0],
 ],
 ["ready_stone", acf_rotate_body,
   [0.3, "anim_human", combat+2200, combat+2210, blend_in_ready],
 ],
 ["release_stone", acf_rotate_body,
   [1.0, "anim_human", combat+2210, combat+2225, arf_blend_in_0],
 ],
 ["ready_pistol", acf_rotate_body|acf_parallels_for_look_slope,
   [0.3, "anim_human", combat+2500, combat+2515, arf_blend_in_8],
 ],
 ["release_pistol", acf_rotate_body|acf_parallels_for_look_slope,
   [0.3, "anim_human", combat+2520, combat+2527, arf_blend_in_1],
 ],
 ["reload_pistol", 0,
   [2.0, "anim_human", combat+2650, combat+2860, arf_blend_in_8],
 ],
 ["ready_musket", acf_rotate_body|acf_parallels_for_look_slope,
   [1.5, "anim_human", combat+1300, combat+1320, blend_in_ready],
 ],
 ["release_musket", acf_rotate_body|acf_parallels_for_look_slope,
   [0.2, "anim_human", combat+1330, combat+1331, arf_blend_in_1],
 ],
 ["reload_musket", 0,
   [2.0, "anim_human", combat+2650, combat+2860, arf_blend_in_8],
 ],



 ["ready_swingright_fist", 0,
   [ready_durn, "anim_human", combat+4000, combat+4000, blend_in_ready], 
 ],
 ["release_swingright_fist", 0,
   [0.5, "anim_human", combat+4000, combat+4035, arf_blend_in_1], 
 ],
 ["parry_swingright_fist", 0,
   [attack_parry_duration, "anim_human", combat+4013, combat+4008, blend_in_parry], 
 ],

 ["ready_swingleft_fist", 0,
   [ready_durn, "anim_human", combat+4300, combat+4300, blend_in_ready], 
 ],
 ["release_swingleft_fist", 0,
   [0.5, "anim_human", combat+4300, combat+4335, arf_blend_in_0], 
 ],
 ["parry_swingleft_fist", 0,
   [attack_parry_duration, "anim_human", combat+4313, combat+4308, blend_in_parry], 
 ],


 ["ready_direct_fist", 0,
   [ready_durn, "anim_human", combat+4600, combat+4600, blend_in_ready], 
 ],
 ["release_direct_fist", 0,
   [0.5, "anim_human", combat+4600, combat+4635, arf_blend_in_0], 
 ],
 ["parry_direct_fist", 0,
   [attack_parry_duration, "anim_human", combat+4613, combat+4608, blend_in_parry], 
 ],
 ["ready_uppercut_fist", 0,
   [ready_durn, "anim_human", combat+4900, combat+4900, blend_in_ready], 
 ],
 ["release_uppercut_fist", 0,
   [0.5, "anim_human", combat+4900, combat+4935, arf_blend_in_0], 
 ],
 ["parry_uppercut_fist", 0,
   [attack_parry_duration, "anim_human", combat+4913, combat+4908, blend_in_parry], 
 ],

 ["defend_fist", acf_rotate_body,
   [defend_duration, "anim_human", combat+4950, combat+4960, blend_in_defense], 
 ],
 ["defend_fist_keep", acf_rotate_body,
   [2.0, "anim_human", combat+4950, combat+4960, arf_blend_in_2|arf_cyclic], 
 ],
 ["defend_fist_parry", acf_rotate_body,
   [0.3, "anim_human", combat+4962, combat+4970, arf_blend_in_0], 
 ],

 ["ready_slashright_twohanded", acf_right_cut|acf_parallels_for_look_slope,
   [ready_durn, "anim_human", combat+5700, combat+5710, blend_in_ready], 
 ],
 ["release_slashright_twohanded", acf_right_cut|acf_parallels_for_look_slope,
   [0.62, "anim_human", combat+5710, combat+5740, blend_in_release], 
 ],
 ["parry_slashright_twohanded", acf_parallels_for_look_slope,
   [attack_parry_duration, "anim_human", combat+5725, combat+5720, blend_in_parry], 
 ],
 ["ready_slashleft_twohanded", acf_right_cut|acf_parallels_for_look_slope,
   [ready_durn, "anim_human", combat+6400, combat+6410, blend_in_ready], 
 ],
 ["release_slashleft_twohanded", acf_right_cut|acf_parallels_for_look_slope,
   [0.62, "anim_human", combat+6410, combat+6436, blend_in_release], 
 ],
 ["parry_slashleft_twohanded", acf_parallels_for_look_slope,
   [attack_parry_duration, "anim_human", combat+6425, combat+6420, blend_in_parry], 
 ],
 ["ready_thrust_twohanded", acf_thrust|acf_parallels_for_look_slope,
   [ready_durn, "anim_human", combat+6000, combat+6010, blend_in_ready], 
 ],
 ["release_thrust_twohanded", acf_thrust|acf_parallels_for_look_slope,
   [0.61, "anim_human", combat+6010, combat+6040, blend_in_release], 
 ],
 ["parry_thrust_twohanded", 0,
   [attack_parry_duration, "anim_human", combat+6015, combat+6016, blend_in_parry], 
 ],
 ["ready_overswing_twohanded", acf_overswing,
   [ready_durn, "anim_human", combat+6200, combat+6210, blend_in_ready], 
 ],
 ["release_overswing_twohanded", acf_overswing,
   [0.63, "anim_human", combat+6210, combat+6241, blend_in_release], 
 ],
 ["parry_overswing_twohanded", 0,
   [attack_parry_duration, "anim_human", combat+6215, combat+6212, blend_in_parry], 
 ],
 ["ready_thrust_onehanded",   acf_thrust|acf_parallels_for_look_slope|acf_rotate_body|acf_enforce_rightside,
   [ready_durn, "anim_human", combat+8500, combat+8510, blend_in_ready], 
 ],
 ["release_thrust_onehanded", acf_thrust|acf_parallels_for_look_slope|acf_rotate_body|acf_enforce_rightside,
   [0.61, "anim_human", combat+8510, combat+8540, blend_in_release], 
 ],
 ["parry_thrust_onehanded", acf_rotate_body|acf_enforce_rightside,
   [attack_parry_duration, "anim_human", combat+8515, combat+8513, blend_in_parry], 
 ],
 ["ready_thrust_onehanded_lance",   acf_thrust|acf_parallels_for_look_slope|acf_rotate_body|acf_enforce_rightside,
   [ready_durn, "anim_human", combat+9500, combat+9510, blend_in_ready], 
 ],
 ["release_thrust_onehanded_lance", acf_thrust|acf_parallels_for_look_slope|acf_rotate_body|acf_enforce_rightside,
   [0.61, "anim_human", combat+9510, combat+9540, blend_in_release], 
 ],
 ["parry_thrust_onehanded_lance", acf_rotate_body|acf_enforce_rightside,
   [attack_parry_duration, "anim_human", combat+9515, combat+9513, blend_in_parry], 
 ],
 ["ready_slashright_onehanded", acf_right_cut| acf_parallels_for_look_slope,
   [ready_durn, "anim_human", combat+8800, combat+8810, blend_in_ready], 
 ],
 ["release_slashright_onehanded", acf_right_cut| acf_parallels_for_look_slope,
   [0.6, "anim_human", combat+8810, combat+8840, blend_in_release], 
 ],
 ["parry_slashright_onehanded", 0,
   [attack_parry_duration, "anim_human", combat+8820, combat+8815, blend_in_parry], 
 ],
 ["ready_slashleft_onehanded", acf_left_cut|acf_parallels_for_look_slope,
   [ready_durn, "anim_human", combat+9100, combat+9110, blend_in_ready], 
 ],
 ["release_slashleft_onehanded", acf_left_cut|acf_parallels_for_look_slope,
   [0.6, "anim_human", combat+9110, combat+9140, blend_in_release], 
 ],
 ["parry_slashleft_onehanded", 0,
   [attack_parry_duration, "anim_human", combat+9120, combat+9115, blend_in_parry], 
 ],
 ["ready_overswing_onehanded", acf_overswing|acf_rotate_body|acf_enforce_rightside,
   [ready_durn, "anim_human", combat+9300, combat+9305, blend_in_ready], 
 ],
 ["release_overswing_onehanded", acf_overswing|acf_rotate_body|acf_enforce_rightside,
   [0.6, "anim_human", combat+9305, combat+9342, blend_in_release], 
 ],
 ["parry_overswing_onehanded", acf_rotate_body|acf_enforce_rightside,
   [attack_parry_duration, "anim_human", combat+9315, combat+9310, blend_in_parry], 
 ],
 ["ready_slash_horseback_right", acf_right_cut|acf_parallels_for_look_slope,
   [ready_durn, "anim_human", combat+10100, combat+10110, blend_in_ready], 
 ],
 ["release_slash_horseback_right", acf_right_cut|acf_parallels_for_look_slope,
   [0.6, "anim_human", combat+10110, combat+10140, blend_in_release], 
 ],
 ["parry_slash_horseback_right", acf_parallels_for_look_slope,
   [attack_parry_duration, "anim_human", combat+10120, combat+10115, blend_in_parry], 
 ],
 ["ready_slash_horseback_left", acf_left_cut|acf_parallels_for_look_slope,
   [ready_durn, "anim_human", combat+10400, combat+10410, blend_in_ready], 
 ],
 ["release_slash_horseback_left", acf_left_cut|acf_parallels_for_look_slope,
   [0.6, "anim_human", combat+10410, combat+10440, blend_in_release], 
 ],
 ["parry_slash_horseback_left", acf_parallels_for_look_slope,
   [attack_parry_duration, "anim_human", combat+10420, combat+10415, blend_in_parry], 
 ],
 ["ready_overswing_staff", acf_overswing,
   [ready_durn, "anim_human", combat+7100, combat+7110, blend_in_ready], 
 ],
 ["release_overswing_staff", acf_overswing,
   [0.6, "anim_human", combat+7110, combat+7140, arf_blend_in_0], 
 ],
 ["parry_overswing_staff", 0,
   [attack_parry_duration, "anim_human", combat+7017, combat+7014, arf_blend_in_2], 
 ],
 ["ready_thrust_staff", acf_thrust|acf_parallels_for_look_slope,
   [ready_durn, "anim_human", combat+7300, combat+7310, blend_in_ready], 
 ],
 ["release_thrust_staff", acf_thrust|acf_parallels_for_look_slope,
   [0.6, "anim_human", combat+7310, combat+7340, arf_blend_in_2], 
 ],
 ["parry_thrust_staff", 0,
   [attack_parry_duration, "anim_human", combat+7316, combat+7313, arf_blend_in_2], 
 ],
 ["ready_slashleft_staff", acf_parallels_for_look_slope,
   [ready_durn, "anim_human", combat+7600, combat+7610, blend_in_ready], 
 ],
 ["release_slashleft_staff", acf_parallels_for_look_slope,
   [0.6, "anim_human", combat+7610, combat+7640, arf_blend_in_0], 
 ],
 ["parry_slashleft_staff", acf_parallels_for_look_slope,
   [attack_parry_duration, "anim_human", combat+7615, combat+7613, arf_blend_in_2], 
 ],
 ["ready_slashright_staff", acf_parallels_for_look_slope,
   [ready_durn, "anim_human", combat+7900, combat+7910, blend_in_ready], 
 ],
 ["release_slashright_staff", acf_parallels_for_look_slope,
   [0.6, "anim_human", combat+7910, combat+7940, arf_blend_in_0], 
 ],
 ["parry_slashright_staff", acf_parallels_for_look_slope,
   [attack_parry_duration, "anim_human", combat+7915, combat+7913, arf_blend_in_2], 
 ],




 ["defend_shield", acf_rotate_body|acf_parallels_for_look_slope,
   [defend_duration, "anim_human", defend+105, defend+120, blend_in_defense], 
 ],
 ["defend_shield_keep", acf_rotate_body|acf_parallels_for_look_slope,
   [2.0, "anim_human", defend+120, defend+120, arf_blend_in_1|arf_cyclic], 
 ],
 ["defend_shield_parry", acf_rotate_body|acf_parallels_for_look_slope,
   [0.5, "anim_human", defend+121, defend+130, arf_blend_in_1], 
 ],
 ["defend_forward_greatsword", acf_rotate_body,
   [defend_duration, "anim_human", defend+310, defend+320, blend_in_defense], 
 ],
 ["defend_forward_greatsword_keep", acf_rotate_body,
   [2.0, "anim_human", defend+320, defend+320, arf_blend_in_3|arf_cyclic], 
 ],
 ["defend_forward_greatsword_parry", acf_rotate_body,
   [0.3, "anim_human", defend+320, defend+330, arf_blend_in_1], 
 ],
 ["defend_up_twohanded", acf_rotate_body,
   [defend_duration, "anim_human", defend+403, defend+410, blend_in_defense], 
 ],
 ["defend_up_twohanded_keep", acf_rotate_body,
   [2.0, "anim_human", defend+410, defend+410, arf_blend_in_3|arf_cyclic], 
 ],
 ["defend_up_twohanded_parry", acf_rotate_body,
   [0.3, "anim_human", defend+411, defend+418, arf_blend_in_1], 
 ],
 ["defend_right_twohanded", acf_rotate_body,
   [defend_duration, "anim_human", defend+510, defend+520, blend_in_defense], 
 ],
 ["defend_right_twohanded_keep", acf_rotate_body,
   [2.0, "anim_human", defend+520, defend+520, arf_blend_in_3|arf_cyclic], 
 ],
 ["defend_right_twohanded_parry", acf_rotate_body,
   [0.3, "anim_human", defend+521, defend+528, arf_blend_in_1], 
 ],
 ["defend_left_twohanded", acf_rotate_body,
   [defend_duration, "anim_human", defend+610, defend+620, blend_in_defense], 
 ],
 ["defend_left_twohanded_keep", acf_rotate_body,
   [2.0, "anim_human", defend+620, defend+620, arf_blend_in_3|arf_cyclic], 
 ],
 ["defend_left_twohanded_parry", acf_rotate_body,
   [0.3, "anim_human", defend+620, defend+630, arf_blend_in_1], 
 ],
 ["defend_forward_onehanded", acf_rotate_body,
   [defend_duration, "anim_human", defend+1010, defend+1020, blend_in_defense], 
 ],
 ["defend_forward_onehanded_keep", acf_rotate_body,
   [2.0, "anim_human", defend+1020, defend+1020, arf_blend_in_3|arf_cyclic], 
 ],
 ["defend_forward_onehanded_parry", acf_rotate_body,
   [0.3, "anim_human", defend+1021, defend+1030, arf_blend_in_1], 
 ],
 ["defend_up_onehanded", acf_rotate_body,
   [defend_duration, "anim_human", defend+1110, defend+1120, blend_in_defense], 
 ],
 ["defend_up_onehanded_keep", acf_rotate_body,
   [2.0, "anim_human", defend+1120, defend+1120, arf_blend_in_3|arf_cyclic], 
 ],
 ["defend_up_onehanded_parry", acf_rotate_body,
   [0.3, "anim_human", defend+1121, defend+1130, arf_blend_in_1], 
 ],
 ["defend_right_onehanded", acf_rotate_body,
   [defend_duration, "anim_human", defend+1210, defend+1220, blend_in_defense], 
 ],
 ["defend_right_onehanded_keep", acf_rotate_body,
   [2.0, "anim_human", defend+1220, defend+1220, arf_blend_in_5|arf_cyclic], 
 ],
 ["defend_right_onehanded_parry", acf_rotate_body,
   [0.3, "anim_human", defend+1221, defend+1230, arf_blend_in_1], 
 ],
 ["defend_left_onehanded", acf_rotate_body,
   [defend_duration, "anim_human", defend+1310, defend+1320, blend_in_defense], 
 ],
 ["defend_left_onehanded_keep", acf_rotate_body,
   [2.0, "anim_human", defend+1320, defend+1320, arf_blend_in_3|arf_cyclic], 
 ],
 ["defend_left_onehanded_parry", acf_rotate_body,
   [0.3, "anim_human", defend+1321, defend+1330, arf_blend_in_1], 
 ],
 ["defend_forward_staff", acf_rotate_body,
   [defend_duration, "anim_human", defend+2010, defend+2020, blend_in_defense], 
 ],
 ["defend_forward_staff_keep", acf_rotate_body,
   [2.0, "anim_human", defend+2020, defend+2020, arf_blend_in_3|arf_cyclic], 
 ],
 ["defend_forward_staff_parry", acf_rotate_body,
   [0.3, "anim_human", defend+2021, defend+2030, arf_blend_in_1], 
 ],
 ["defend_up_staff", acf_rotate_body,
   [defend_duration, "anim_human", defend+2110, defend+2120, blend_in_defense], 
 ],
 ["defend_up_staff_keep", acf_rotate_body,
   [2.0, "anim_human", defend+2120, defend+2120, arf_blend_in_3|arf_cyclic], 
 ],
 ["defend_up_staff_parry", acf_rotate_body,
   [0.3, "anim_human", defend+2121, defend+2130, arf_blend_in_1], 
 ],
 ["defend_right_staff", acf_rotate_body,
   [defend_duration, "anim_human", defend+2210, defend+2220, blend_in_defense], 
 ],
 ["defend_right_staff_keep", acf_rotate_body,
   [2.0, "anim_human", defend+2220, defend+2220, arf_blend_in_3|arf_cyclic], 
 ],
 ["defend_right_staff_parry", acf_rotate_body,
   [0.3, "anim_human", defend+2221, defend+2230, arf_blend_in_1], 
 ],
 ["defend_left_staff", acf_rotate_body,
   [defend_duration, "anim_human", defend+2310, defend+2320, blend_in_defense], 
 ],
 ["defend_left_staff_keep", acf_rotate_body,
   [2.0, "anim_human", defend+2320, defend+2320, arf_blend_in_3|arf_cyclic], 
 ],
 ["defend_left_staff_parry", acf_rotate_body,
   [0.3, "anim_human", defend+2321, defend+2330, arf_blend_in_1], 
 ],
 ["strike_head_front_left", 0,
   [0.55, "anim_human", blow+0, blow+10, arf_blend_in_3], 
 ],
 ["strike_head_front_left_reloc", acf_enforce_all,
   [0.6,  "anim_human", blow+5200, blow+5220, arf_blend_in_3], 
#   [0.6,  "anim_human", blow+5200, blow+5220, arf_blend_in_5,0, (-0.1,-1.5,0)], 
#   [0.6,  "anim_human", blow+5300, blow+5320, arf_blend_in_5,0, (-0.9,-1.4,0)], 
 ],
 ["fall_head_front", acf_enforce_all|acf_align_with_ground|acf_lock_camera,
   [1.2, "anim_human", blow+100, blow+138, arf_blend_in_16], 
#   [1, "die_test", 1, 2, arf_blend_in_1], 
 ],
 ["fall_rider_head_front", acf_enforce_all|acf_lock_camera,
   [2.2, "anim_human", blow+200, blow+275, arf_blend_in_3], 
 ],
 ["horse_fall_in_place", acf_enforce_lowerbody,
   [3.8, "anim_human", blow + 1000, blow + 1075, arf_blend_in_16], 
 ],
 ["horse_fall_right", acf_enforce_all|acf_displace_position,
   [2.2, "anim_human", blow+ 1500, blow+1552,  arf_blend_in_8, 0, (1.1,-0.90,0)],
 ],
 ["horse_fall_roll", acf_enforce_all|acf_displace_position,
   [2.5, "anim_human", blow+ 2000, blow+2084,  arf_blend_in_8, 0, (-0.4,0.2,0)],
 ],
 ["strike_chest_front_stop", acf_enforce_all,
   [0.4, "anim_human", blow+5000, blow+5010, arf_blend_in_3], 
 ],
 ["strike_fall_back_rise", acf_enforce_lowerbody|acf_align_with_ground,
   [2.1, "anim_human", blow+5400, blow+5453, arf_blend_in_2], 
 ],
 ["strike_fall_back_rise_upper", acf_align_with_ground,
   [1.50, "anim_human", blow+5400, blow+5438, arf_blend_in_2], 
 ],

 ["cheer", 0,
   [2.5, "anim_human", 70000, 70045, arf_blend_in_5], 
   [3.0, "anim_human", 70100, 70150, arf_blend_in_5], 
 ],
 ["dance", 0,
   [20.0, "anim_human_temp", 0, 387, arf_blend_in_5], 
#   [10.0, "anim_human_temp", 0, 10, arf_blend_in_5], 
 ],
 ### Unused human animations start from here.
 ["unused_human_anim_1", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_2", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_3", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_4", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_5", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_6", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_7", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_8", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_9", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_10", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_11", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_12", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_13", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_14", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_15", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_16", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_17", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_18", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_19", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_20", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_21", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_22", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_23", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_24", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_25", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_26", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_27", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_28", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_29", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_30", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_31", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_32", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_33", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_34", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_35", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_36", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_37", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_38", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_39", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_40", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_41", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_42", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_43", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_44", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_45", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_46", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_47", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_48", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_49", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_50", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_51", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_52", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_53", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_54", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_55", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_56", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_57", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_58", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_59", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_60", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_61", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_62", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_63", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_64", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_65", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_66", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_67", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_68", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_69", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_70", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_71", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_72", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_73", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_74", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_75", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_76", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_77", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_78", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_79", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_80", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_81", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_82", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_83", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_84", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_85", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_86", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_87", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_88", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_89", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_90", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_91", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_92", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_93", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_94", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_95", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_96", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_97", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_98", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_99", 0, [1.0, "anim_human", 0, 1, 0]],
 ["unused_human_anim_100", 0, [1.0, "anim_human", 0, 1, 0]],

]

horse_animations = [
 ["horse_stand", 0,
   [5.0, "anim_horse", horse_move+2000, horse_move+2100, arf_cyclic], 
   [1.9, "anim_horse", horse_move+2200, horse_move+2250, arf_cyclic], 
   [4.9, "anim_horse", horse_move+2600, horse_move+2650, arf_cyclic], 
   [8.0, "anim_horse", horse_move+2350, horse_move+2500, arf_cyclic], 
 ],
 ["horse_pace_1", acf_enforce_lowerbody,
   [1.0, "anim_horse", horse_move+210, horse_move+250, arf_walk,pack4f(0.37,0.47,0.87,0.97)], 
 ],
 ["horse_pace_2", acf_enforce_lowerbody,
   [0.8, "anim_horse", horse_move+310, horse_move+334, arf_walk,pack4f(0.4,0.41,0.9,0.91)], 
 ],
 ["horse_pace_3", acf_enforce_lowerbody,
   [0.6, "anim_horse", horse_move+360, horse_move+400, arf_walk,pack4f(0.13,0.95,0.35,0.42)], 
 ],
 ["horse_pace_4", acf_enforce_lowerbody,
   [0.5, "anim_horse", horse_move+430, horse_move+470, arf_walk,pack4f(0.06,0.31,0.79,0.94)], 
 ],
 ["walk_backward", acf_enforce_lowerbody,
   [1.0, "anim_horse", horse_move+250, horse_move+210, arf_walk,pack4f(0.07,0.13,0.56,0.63)],
 ],
 ["rear", acf_enforce_lowerbody | acf_ignore_slope,
#   [1.4, "anim_horse_temp", 1, 10,  arf_blend_in_1],
   [1.4, "anim_horse", horse_move+820, horse_move+837,  arf_blend_in_64],
 ],
 ["jump", acf_enforce_lowerbody,
   [1.2, "anim_horse", horse_move+900, horse_move+930,  arf_blend_in_8|arf_end_pos_0_25],
 ],
 ["jump_end", acf_enforce_lowerbody,
   [0.1, "anim_horse", horse_move+930, horse_move+940,  arf_blend_in_16],
 ],

 ["turn_right", 0,
   [1.0, "anim_horse", horse_move+1000, horse_move+1030, arf_cyclic], 
 ],
 ["turn_left", 0,
   [1.0, "anim_horse", horse_move+1060, horse_move+1090, arf_cyclic],
 ],
 ["slow", 0,
   [3.0, "anim_horse", horse_move+170, horse_move+180, arf_cyclic], 
   [1.5, "anim_horse", horse_move+185, horse_move+190, arf_cyclic], 
 ],
 ["horse_fall_in_place", acf_enforce_all|acf_align_with_ground,
   [4.0, "anim_horse", blow + 1000, blow + 1085, arf_blend_in_16], 
 ],
 ["horse_fall_right", acf_enforce_all|acf_align_with_ground,
   [2.2, "anim_horse", blow+ 1500, blow+1552,  arf_blend_in_8],
 ],
 ["horse_fall_roll", acf_enforce_all|acf_align_with_ground,
   [2.5, "anim_horse", blow+ 2000, blow+2084,  arf_blend_in_8],
 ],
 ### Unused horse animations start from here.
 ["unused_horse_anim_1", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_2", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_3", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_4", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_5", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_6", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_7", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_8", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_9", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_10", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_11", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_12", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_13", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_14", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_15", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_16", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_17", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_18", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_19", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_20", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_21", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_22", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_23", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_24", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_25", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_26", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_27", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_28", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_29", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_30", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_31", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_32", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_33", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_34", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_35", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_36", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_37", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_38", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_39", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_40", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_41", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_42", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_43", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_44", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_45", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_46", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_47", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_48", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_49", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_50", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_51", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_52", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_53", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_54", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_55", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_56", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_57", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_58", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_59", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_60", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_61", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_62", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_63", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_64", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_65", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_66", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_67", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_68", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_69", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_70", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_71", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_72", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_73", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_74", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_75", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_76", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_77", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_78", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_79", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_80", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_81", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_82", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_83", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_84", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_85", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_86", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_87", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_88", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_89", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_90", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_91", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_92", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_93", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_94", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_95", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_96", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_97", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_98", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_99", 0, [1.0, "anim_horse", 0, 1, 0]],
 ["unused_horse_anim_100", 0, [1.0, "anim_horse", 0, 1, 0]],
 ]
