from ID_items import *
from ID_quests import *
from ID_troops import *
##############################################################
# These constants are used in various files.
# If you need to define a value that will be used in those files,
# just define it here rather than copying it across each file, so
# that it will be easy to change it if you need to.
##############################################################

##############################################################
# BoW: defined constants
##############################################################
mod_version_num = 3773
smallest_savegame_compatible_mod_version = 3770

proficiency_one_handed = 0
proficiency_two_handed = 1
proficiency_polearm = 2
proficiency_archery = 3
proficiency_crossbow = 4
proficiency_throwing = 5
proficiency_firearm = 6

num_loot_management_menu_heroes = 4

slot_prisoner_agreed = 15

slot_met_before = 17
slot_inn_entry_point = 18
slot_last_level_awarded_extra_profs = 19
slot_upgrade_armor = 20
slot_upgrade_melee = 21
slot_upgrade_horse = 22
slot_upgrade_ranged = 23
slot_random_hash = 24
slot_no_discard_in_auto_loot = 25
slot_no_pickup_backup_equipment = 26
slot_party_current_faction = 60


constant_no = 0
constant_yes = 1
melee_upgrade_one_handed = 1
melee_upgrade_two_handed = 2
melee_upgrade_polearms = 3
melee_upgrade_lances = 4
melee_upgrade_blunts = 5
ranged_upgrade_bows = 1
ranged_upgrade_crossbows = 2
ranged_upgrade_throwing = 3

has_joined_before = 5
has_met_before = 1

battle_profile_all = 0
battle_profile_blunts_only = 1
battle_profile_polearms_preferred = 2
battle_profile_shields_preferred = 3
battle_profile_armor_piercing_preferred = 4

items_horses_start = "itm_sumpter_horse"
items_horses_end = "itm_wooden_shield"
items_wearables_start = "itm_zyshen"
items_wearables_end = "itm_guoflag_wei"
items_gloves_start = "itm_leather_gloves"
items_gloves_end = "itm_wooden_shield"
items_cloth_gloves_start = "itm_leather_gloves"
items_cloth_gloves_end = "itm_mail_mittens"
items_metal_gloves_start = "itm_mail_mittens"
items_metal_gloves_end = "itm_wooden_shield"
items_boots_start = "itm_yinxie"
items_boots_end = "itm_leather_gloves"
items_cloth_boots_start = "itm_caoshoes"
items_cloth_boots_end = "itm_ironshoes"
items_metal_boots_start = "itm_ironshoes"
items_metal_boors_end = "itm_leather_gloves"
items_armor_start = "itm_zyshen"
items_armor_end = "itm_crown"
items_cloth_armor_start = "itm_womancloth2"
items_cloth_armor_end = "itm_ironarmor"
items_metal_armor_begin = "itm_ironarmor"
items_metal_armor_end = "itm_crown"
items_helmets_start = "itm_crown"
items_helmets_end = "itm_yinxie"
items_cloth_helmets_start = "itm_baotou"
items_cloth_helmets_end = "itm_yuling"
items_metal_helmets_start = "itm_yuling"
items_metal_helmets_end = "itm_yinxie"
items_melee_weapons_start = "itm_yuitian"
items_melee_weapons_end = "itm_steelspear"
items_weapons_start = "itm_cixiongswordx"
items_weapons_end = "itm_zyshen"
items_one_handed_start = "itm_yuitian"
items_one_handed_end = "itm_qinglongbardiche"
items_one_handed_piercing_start = "itm_butchering_knife"
items_one_handed_piercing_end = "itm_wooden_stick"
items_one_handed_blunts_start = "itm_wooden_stick"
items_one_handed_blunts_end = "itm_falchion"
items_one_handed_cutting_start = "itm_falchion"
items_one_handed_cutting_end = "itm_qinglongbardiche"
items_two_handed_blunts_start = "itm_quarter_staff"
items_two_handed_blunts_end = "itm_bronzesword"
items_two_handed_start = "itm_qinglongbardiche"
items_two_handed_end = "itm_steelspear"
items_polearms_start = "itm_steelspear"
items_polearms_end = "itm_zyshen"
items_one_handed_polearms_start = "itm_qiuspear"
items_one_handed_polearms_end = "itm_zyshen"
items_polearms_blunts_start = "itm_qiuspear"
items_polearms_blunts_end = "itm_zyshen"
items_shields_start = "itm_wooden_shield"
items_shields_end = "itm_jarid"
items_throwing_start = "itm_jarid"
items_throwing_end = "itm_hunting_bow"
items_bows_start = "itm_hunting_bow"
items_bows_end = "itm_hunting_crossbow"
items_ranged_start = "itm_jarid"
items_ranged_end = "itm_arrows"
items_crossbows_start = "itm_hunting_crossbow"
items_crossbows_end = "itm_arrows"
items_ammo_start = "itm_arrows"
items_ammo_end = "itm_sumpter_horse"


##############################################################
# END BoW
##############################################################

########################################################
##  PARTY SLOTS            #############################
########################################################
slot_party_type              = 0  #spt_caravan, spt_town, spt_castle

slot_party_ai_state          = 4

slot_town_belongs_to_kingdom = 6
slot_town_lord               = 7

slot_town_center        = 10
slot_town_castle        = 11
slot_town_tavern        = 13
slot_town_store         = 14
slot_town_gate          = 15
slot_town_arena         = 16
slot_town_tavernkeeper  = 20
slot_town_weaponsmith   = 21
slot_town_armorer       = 22
slot_town_merchant      = 23
slot_town_mercs         = 40
slot_town_export_good   = 41
slot_town_export_rate   = 42
slot_town_export_good_2 = 43
slot_town_export_rate_2 = 44
slot_town_import_good   = 45
slot_town_import_rate   = 46
slot_town_import_good_2 = 47
slot_town_import_rate_2 = 48

slot_castle_exterior    = 10
slot_castle_interior    = 11

slot_town_arena_melee_mission_tpl = 78
slot_town_arena_torny_mission_tpl = 79
slot_town_arena_melee_1_num_teams = 80
slot_town_arena_melee_1_team_size = 81
slot_town_arena_melee_2_num_teams = 82
slot_town_arena_melee_2_team_size = 83
slot_town_arena_melee_3_num_teams = 84
slot_town_arena_melee_3_team_size = 85
slot_town_arena_melee_cur_tier    = 86
slot_town_arena_template	  = 87

#slot_party_type values
spt_caravan          = 1
spt_castle           = 2
spt_town             = 3
spt_forager          = 4
spt_army             = 5
spt_patrol           = 6
spt_raider           = 7
spt_scout            = 8
spt_kingdom_caravan  = 9

#slot_party_ai_state values
spai_undefined               = -1
spai_besieging_center        = 1
spai_returning_prisoners     = 2
spai_returning               = 3
spai_patrolling              = 4
spai_trading_within_kingdom  = 5
spai_raiding                 = 6


########################################################
##  SCENE SLOTS            #############################
########################################################
slot_scene_visited      = 0


########################################################
##  TROOP SLOTS            #############################
########################################################
#slot_troop_role         = 0  # 10=Kingdom Lord

slot_troop_faction      = 1 
slot_troop_occupation   = 2  # 0 = free, 1 = merchant
slot_troop_duty         = 3  # Kingdom duty, 0 = free
slot_troop_state        = 4  
slot_troop_met          = 5
slot_r            = 6
slot_ps           = 7
slot_a            = 8
slot_pd           = 9
slot_ha           = 10
slot_one          = 11
slot_two          = 12
slot_bow          = 13
slot_cross        = 14
slot_troop_cur_party    = 51
slot_rs           = 52
slot_use_st       = 53

########################################################
##  QUEST SLOTS            #############################
########################################################


########################################################
##  PARTY TEMPLATE SLOTS   #############################
########################################################

########################################################
rel_enemy   = 0
rel_neutral = 1
rel_ally    = 2

# Conversation types
ct_simple_encounter = 0
ct_castle_siege_attack = 1
ct_castle_siege_defend = 2


#Talk contexts
tc_town_talk          = 0
tc_party_encounter    = 1
tc_join_battle_ally   = 2
tc_join_battle_enemy  = 3
tc_castle_commander   = 4
tc_siege_commander    = 5
tc_hero_freed         = 6
tc_hero_defeated      = 7


main_factions_begin = "fac_kingdom_caowei"
main_factions_end   = "fac_force_headyellow"

marnid_inn_entry = 2
borcha_inn_entry = 3
ymira_inn_entry  = 4

lord_quests_begin = "qst_deliver_message"
lord_quests_end   = "qst_escort_merchant_caravan"

light_armor_begin = "itm_ccshen"
light_armor_end = "itm_weiwushen1"

normal_armor_begin = "itm_weiwushen1"
normal_armor_end = "itm_yinjia"

heavy_armor_begin = "itm_yinjia"
heavy_armor_end = "itm_zyshen"

special_armor_begin = "itm_zyshen"
special_armor_end = "itm_pilgrim_hood"

m_armor_begin = "itm_weiwushen1"
m_armor_end = "itm_zyshen"

rider_begin = "trp_shu_horse_solider"
rider_end = "trp_shu_archer_troop"

archer_begin = "trp_shu_archer_troop"
archer_end = "trp_shu_infantry"

footman_begin = "trp_shu_infantry"
footman_end = "trp_hundred_dead_warrior"

horsearcher_begin = "trp_hundred_dead_warrior"
horsearcher_end = "trp_woman"

af_troop_begin = "trp_shu_horse_solider"
af_troop_end = "trp_woman"

governer_quests_begin = "qst_deliver_message"
governer_quests_end   = "qst_escort_merchant_caravan"

merchant_quests_begin  = "qst_escort_merchant_caravan"
merchant_quests_end    = "qst_hunt_down_river_pirates"

towns_begin = "p_xiangping"
towns_end = "p_village_1"

castles_begin = "p_castle_1"
castles_end = "p_castle_8"

centers_begin = towns_begin
centers_end   = castles_end

spawn_points_begin = "p_zendar"
spawn_points_end = "p_spawn_points_end"

governers_begin = "trp_town_1_ruler_a"
governers_end = "trp_town_1_arena_master"

merchants_begin = "trp_zendar_merchant"
merchants_end = "trp_merchants_end"

regular_troops_begin       = "trp_tutorial_trainer"
regular_troops_end         = "trp_peng31"

arena_masters_begin    = "trp_town_1_arena_master"
arena_masters_end      = "trp_zendar_armorer"

armor_merchants_begin  = "trp_zendar_armorer"
armor_merchants_end    = "trp_zendar_weaponsmith"

weapon_merchants_begin = "trp_zendar_weaponsmith"
weapon_merchants_end   = "trp_zendar_tavernkeeper"

tavernkeepers_begin    = "trp_zendar_tavernkeeper"
tavernkeepers_end      = "trp_zendar_merchant"

goods_merchants_begin  = "trp_zendar_merchant"
goods_merchants_end    = "trp_merchants_end"

num_max_river_pirates = 25
num_max_zendar_peasants = 25
num_max_zendar_manhunters = 10

num_max_dp_bandits = 10
num_max_refugees = 10
num_max_deserters = 10

num_max_militia_bands = 15
num_max_armed_bands = 12

num_max_vaegir_punishing_parties = 20
num_max_rebel_peasants = 25

num_max_frightened_farmers = 50
num_max_undead_messengers  = 20

num_forest_bandit_spawn_points = 1
num_mountain_bandit_spawn_points = 1
num_steppe_bandit_spawn_points = 1
num_black_khergit_spawn_points = 1
num_sea_raider_spawn_points = 2

peak_prisoner_trains = 4
peak_kingdom_caravans = 12
#sango
caowei_merc_parties_begin = "p_xiangping_mercs"
caowei_merc_parties_end = "p_jiangxia_mercs"

shu_merc_parties_begin = "p_jiangxia_mercs"
shu_merc_parties_end = "p_jianye_mercs"

wu_merc_parties_begin = "p_jianye_mercs"
wu_merc_parties_end = "p_xiangping"

npc_begin = "trp_jiaxu"
npc_end = "trp_lvbu"
npc_wei_begin = "trp_jiaxu"
npc_wei_end = "trp_pangtong"
npc_shu_begin = "trp_pangtong"
npc_shu_end = "trp_sunquan"
npc_wu_begin = "trp_sunquan"
npc_wu_end = "trp_lvbu"
npcnpc_begin = "trp_lvbu"
npcnpc_end = "trp_gaoshun"
npc_first_begin = "trp_first_npc"
npc_last_end = "trp_last_npc"
npc_special_begin = "trp_gaoshun"
npc_special_end = "trp_last_npc"
town_wei_begin = "p_xiangping"
town_wei_end = "p_jiangxia"
town_shu_begin = "p_jiangxia"
town_shu_end = "p_jianye"
town_wu_begin = "p_jianye"
town_wu_end = "p_village_1"
troop_join_begin = "trp_shu_youth"
troop_join_end = "trp_peng31"
troop_wei_begin = "trp_wei_light_cavalry"
troop_wei_end = "trp_tiger_fighter"
troop_shu_begin = "trp_shu_archer_troop"
troop_shu_end = "trp_western_liang_valiant_calvary"
troop_wu_begin = "trp_wu_trouble_dealing_army"
troop_wu_end = "trp_courage"
scn_tavern_begin = "scn_xiangping_tavern"
scn_tavern_end = "scn_jiaozhi_tavern"

##############################################################
# These constants are used in various files.
# If you need to define a value that will be used in those files,
# just define it here rather than copying it across each file, so
# that it will be easy to change it if you need to.
##############################################################

##############################################################
# BoW: defined constants
##############################################################
mod_version_num = 3773
smallest_savegame_compatible_mod_version = 3770

proficiency_one_handed = 0
proficiency_two_handed = 1
proficiency_polearm = 2
proficiency_archery = 3
proficiency_crossbow = 4
proficiency_throwing = 5
proficiency_firearm = 6

num_loot_management_menu_heroes = 4

slot_prisoner_agreed = 15

slot_met_before = 17
slot_inn_entry_point = 18
slot_last_level_awarded_extra_profs = 19
slot_upgrade_armor = 20
slot_upgrade_melee = 21
slot_upgrade_horse = 22
slot_upgrade_ranged = 23
slot_random_hash = 24
slot_no_discard_in_auto_loot = 25
slot_no_pickup_backup_equipment = 26
slot_party_current_faction = 60


constant_no = 0
constant_yes = 1
melee_upgrade_one_handed = 1
melee_upgrade_two_handed = 2
melee_upgrade_polearms = 3
melee_upgrade_lances = 4
melee_upgrade_blunts = 5
ranged_upgrade_bows = 1
ranged_upgrade_crossbows = 2
ranged_upgrade_throwing = 3

has_joined_before = 5
has_met_before = 1

battle_profile_all = 0
battle_profile_blunts_only = 1
battle_profile_polearms_preferred = 2
battle_profile_shields_preferred = 3
battle_profile_armor_piercing_preferred = 4

items_horses_start = "itm_sumpter_horse"
items_horses_end = "itm_wooden_shield"
items_wearables_start = "itm_zyshen"
items_wearables_end = "itm_guoflag_wei"
items_gloves_start = "itm_leather_gloves"
items_gloves_end = "itm_wooden_shield"
items_cloth_gloves_start = "itm_leather_gloves"
items_cloth_gloves_end = "itm_mail_mittens"
items_metal_gloves_start = "itm_mail_mittens"
items_metal_gloves_end = "itm_wooden_shield"
items_boots_start = "itm_yinxie"
items_boots_end = "itm_leather_gloves"
items_cloth_boots_start = "itm_caoshoes"
items_cloth_boots_end = "itm_ironshoes"
items_metal_boots_start = "itm_ironshoes"
items_metal_boors_end = "itm_leather_gloves"
items_armor_start = "itm_zyshen"
items_armor_end = "itm_crown"
items_cloth_armor_start = "itm_womancloth2"
items_cloth_armor_end = "itm_ironarmor"
items_metal_armor_begin = "itm_ironarmor"
items_metal_armor_end = "itm_crown"
items_helmets_start = "itm_crown"
items_helmets_end = "itm_yinxie"
items_cloth_helmets_start = "itm_baotou"
items_cloth_helmets_end = "itm_yuling"
items_metal_helmets_start = "itm_yuling"
items_metal_helmets_end = "itm_yinxie"
items_melee_weapons_start = "itm_yuitian"
items_melee_weapons_end = "itm_steelspear"
items_weapons_start = "itm_cixiongswordx"
items_weapons_end = "itm_zyshen"
items_one_handed_start = "itm_yuitian"
items_one_handed_end = "itm_qinglongbardiche"
items_one_handed_piercing_start = "itm_butchering_knife"
items_one_handed_piercing_end = "itm_wooden_stick"
items_one_handed_blunts_start = "itm_wooden_stick"
items_one_handed_blunts_end = "itm_falchion"
items_one_handed_cutting_start = "itm_falchion"
items_one_handed_cutting_end = "itm_qinglongbardiche"
items_two_handed_blunts_start = "itm_quarter_staff"
items_two_handed_blunts_end = "itm_bronzesword"
items_two_handed_start = "itm_qinglongbardiche"
items_two_handed_end = "itm_steelspear"
items_polearms_start = "itm_steelspear"
items_polearms_end = "itm_zyshen"
items_one_handed_polearms_start = "itm_qiuspear"
items_one_handed_polearms_end = "itm_zyshen"
items_polearms_blunts_start = "itm_qiuspear"
items_polearms_blunts_end = "itm_zyshen"
items_shields_start = "itm_wooden_shield"
items_shields_end = "itm_jarid"
items_throwing_start = "itm_jarid"
items_throwing_end = "itm_hunting_bow"
items_bows_start = "itm_hunting_bow"
items_bows_end = "itm_hunting_crossbow"
items_ranged_start = "itm_jarid"
items_ranged_end = "itm_arrows"
items_crossbows_start = "itm_hunting_crossbow"
items_crossbows_end = "itm_arrows"
items_ammo_start = "itm_arrows"
items_ammo_end = "itm_sumpter_horse"


##############################################################
# END BoW
##############################################################


########################################################
##  ITEM SLOTS             #############################
########################################################

slot_item_is_checked              = 0
slot_item_food_bonus              = 1

########################################################
##  AGENT SLOTS            #############################
########################################################

slot_agent_target_entry_point     = 0
slot_agent_target_x_pos           = 1
slot_agent_target_y_pos           = 2
slot_agent_is_not_reinforcement   = 5
slot_agent_map_overlay_id         = 10


########################################################
##  FACTION SLOTS          #############################
########################################################
slot_faction_ai_state             = 4
slot_faction_ai_object            = 5

slot_faction_culture              = 9
slot_faction_leader               = 10
slot_faction_vassal_of            = 11

slot_faction_tier_1_troop         = 41
slot_faction_tier_2_troop         = 42
slot_faction_tier_3_troop         = 43
slot_faction_tier_4_troop         = 44
slot_faction_tier_5_troop         = 45
slot_faction_deserter_troop       = 48
slot_faction_guard_troop          = 49
slot_faction_messenger_troop      = 50
slot_faction_prison_guard_troop   = 51
slot_faction_castle_guard_troop   = 52



slot_faction_deserter_party_template       = 62

slot_faction_reinforcements_a        = 77
slot_faction_reinforcements_b        = 78
slot_faction_reinforcements_c        = 79

slot_faction_num_armies              = 80
slot_faction_num_castles             = 81
slot_faction_num_towns               = 82


########################################################
##  PARTY SLOTS            #############################
########################################################
slot_party_type                = 0  #spt_caravan, spt_town, spt_castle

slot_party_retreat_flag        = 2
slot_party_ignore_player_until = 3
slot_party_ai_state            = 4
slot_party_ai_object           = 5

slot_town_belongs_to_kingdom = 6
slot_town_lord               = 7
#slot_town_seneschal          = 8
slot_town_claimed_by_player  = 9

slot_town_center        = 10
slot_town_castle        = 11
slot_town_prison        = 12
slot_town_tavern        = 13
slot_town_store         = 14
slot_town_arena         = 16
slot_town_alley         = 17
slot_center_culture     = 19

slot_town_tavernkeeper  = 20
slot_town_weaponsmith   = 21
slot_town_armorer       = 22
slot_town_merchant      = 23
slot_town_horse_merchant= 24
slot_town_mercs         = 25
slot_center_player_relation = 26

slot_center_siege_with_belfry = 27
slot_center_last_taken_by_troop = 28

# party will follow this party if set:
slot_party_commander_party = 30 #default -1

slot_village_raided_by        = 34
slot_village_state            = 35 #svs_normal, svs_being_raided, svs_looted, svs_recovering, svs_deserted
slot_village_raid_progress    = 36
slot_village_recover_progress = 37
slot_village_smoke_added      = 38

slot_center_accumulated_rents   = 47
slot_center_accumulated_tariffs = 48
slot_town_wealth        = 49
slot_town_player_odds   = 51


slot_party_last_toll_paid_hours = 52
slot_party_food_store           = 53 #used for sieges
slot_center_is_besieged_by      = 54 #used for sieges
slot_center_last_spotted_enemy  = 55


slot_town_reinforcement_party_template = 60

slot_castle_exterior    = 10

slot_town_arena_melee_mission_tpl = 78
slot_town_arena_torny_mission_tpl = 79
slot_town_arena_melee_1_num_teams = 80
slot_town_arena_melee_1_team_size = 81
slot_town_arena_melee_2_num_teams = 82
slot_town_arena_melee_2_team_size = 83
slot_town_arena_melee_3_num_teams = 84
slot_town_arena_melee_3_team_size = 85
slot_town_arena_melee_cur_tier    = 86
slot_town_arena_template	  = 87

slot_center_mercenary_troop_type  = 90
slot_center_mercenary_troop_amount= 91
slot_center_volunteer_troop_type  = 92
slot_center_volunteer_troop_amount= 93

slot_center_companion_candidate   = 94
slot_center_ransom_broker         = 95
slot_center_tavern_traveler       = 96
slot_center_traveler_info_faction = 97
slot_center_tavern_minstrel       = 98

slot_town_siege_days              = 100

num_party_loot_slots    = 5
slot_party_next_looted_item_slot  = 109
slot_party_looted_item_1          = 110
slot_party_looted_item_2          = 111
slot_party_looted_item_3          = 112
slot_party_looted_item_4          = 113
slot_party_looted_item_5          = 114
slot_party_looted_item_1_modifier = 115
slot_party_looted_item_2_modifier = 116
slot_party_looted_item_3_modifier = 117
slot_party_looted_item_4_modifier = 118
slot_party_looted_item_5_modifier = 119

slot_village_bound_center         = 120
slot_village_market_town          = 121
slot_village_farmer_party         = 122
slot_party_home_center            = 123

slot_center_current_improvement   = 124
slot_center_improvement_end_hour  = 125
slot_center_housing_level         = 126
slot_center_irrigation_level      = 127
slot_center_mill_level            = 128

num_trade_goods = itm_siege_supply - itm_smoked_fish
slot_town_trade_good_productions_begin       = 140
slot_town_trade_good_temp_productions_begin  = slot_town_trade_good_productions_begin + num_trade_goods + 1
slot_town_trade_good_prices_begin            = slot_town_trade_good_temp_productions_begin + num_trade_goods + 1
slot_town_entry_no                    = 199



#slot_party_type values
##spt_caravan            = 1
spt_castle             = 2
spt_town               = 3
spt_village            = 4
spt_forager            = 5
spt_war_party          = 6
spt_patrol             = 7
spt_messenger          = 8
spt_raider             = 9
spt_scout              = 10
spt_kingdom_caravan    = 11
spt_prisoner_train     = 12
spt_kingdom_hero_party = 13
##spt_merchant_caravan   = 14
spt_village_farmer     = 15
spt_ship               = 16
spt_deserter           = 20

kingdom_party_types_begin = spt_forager
kingdom_party_types_end = spt_kingdom_hero_party + 1

#slot_faction_ai_state values
sfai_undefined                 = -1
sfai_default                   = 0
sfai_attacking_center          = 1


#slot_party_ai_state values
spai_undefined                  = -1
spai_besieging_center           = 1
spai_patrolling_around_center   = 4
spai_raiding_around_center      = 5
spai_raiding_village            = 6
spai_holding_center             = 7
spai_helping_town_against_siege = 9
spai_engaging_army              = 10
spai_accompanying_army          = 11
spai_trading_with_town          = 13
spai_retreating_to_center       = 14
spai_trading_within_kingdom     = 15

#slot_village_state values
svs_normal                      = 0
svs_being_raided                = 1
svs_looted                      = 2
svs_recovering                  = 3
svs_deserted                    = 4
svs_under_siege                 = 5

#$g_player_icon_state values
pis_normal                      = 0
pis_camping                     = 1
pis_ship                        = 2


########################################################
##  SCENE SLOTS            #############################
########################################################
slot_scene_visited              = 0
slot_scene_belfry_props_begin   = 10


########################################################
##  TROOP SLOTS            #############################
########################################################
#slot_troop_role         = 0  # 10=Kingdom Lord

slot_troop_occupation          = 2  # 0 = free, 1 = merchant
#slot_troop_duty               = 3  # Kingdom duty, 0 = free
slot_troop_state               = 3  
slot_troop_last_talk_time      = 4
slot_troop_met                 = 5
slot_troop_party_template      = 6
#slot_troop_kingdom_rank        = 7

slot_troop_renown              = 7

slot_troop_is_prisoner         = 8  # important for heroes only
#slot_troop_is_player_companion = 9  # important for heroes only:::USE  slot_troop_occupation = slto_player_companion

slot_troop_leaded_party        = 10 # important for kingdom heroes only
slot_troop_wealth              = 11 # important for kingdom heroes only
slot_troop_cur_center          = 12 # important for royal family members only (non-kingdom heroes)

slot_troop_banner_scene_prop   = 13 # important for kingdom heroes and player only

slot_troop_does_not_give_quest = 20
slot_troop_player_debt         = 21
slot_troop_player_relation     = 22
slot_troop_player_favor        = 23
slot_troop_last_quest          = 24
slot_troop_last_quest_betrayed = 25

slot_troop_spouse              = 30
slot_troop_father              = 31
slot_troop_mother              = 32
slot_troop_daughter            = 33
slot_troop_son                 = 34
slot_troop_sibling             = 35
slot_troop_lover               = 36

slot_troop_enemy_1             = 40
slot_troop_enemy_2             = 41
slot_troop_enemy_3             = 42
slot_troop_enemy_4             = 43
slot_troop_enemy_5             = 44

slot_troop_enemies_begin       = 40
slot_troop_enemies_end         = 45

slot_troop_family_begin       = 30
slot_troop_family_end         = 36

slot_troop_honorable          = 50
#slot_troop_merciful          = 51

#Encounter types
enctype_fighting_against_village_raid = 1
enctype_catched_during_village_raid   = 2


### Troop occupations slot_troop_occupation
##slto_merchant           = 1
slto_kingdom_hero       = 2
slto_player_companion   = 3
slto_kingdom_lady       = 4
slto_kingdom_seneschal  = 5
slto_robber_knight      = 6

stl_unassigned          = -1
stl_reserved_for_player = -2
stl_rejected_by_player  = -3


########################################################
##  QUEST SLOTS            #############################
########################################################

slot_quest_target_center            = 1
slot_quest_target_troop             = 2
slot_quest_target_faction           = 3
slot_quest_object_troop             = 4
slot_quest_target_troop_is_prisoner = 5
slot_quest_giver_troop              = 6
slot_quest_object_center            = 7
slot_quest_target_party             = 8
slot_quest_target_party_template    = 9
slot_quest_target_amount            = 10
slot_quest_current_state            = 11
slot_quest_giver_center             = 12

slot_quest_importance               = 20
slot_quest_xp_reward                = 21
slot_quest_gold_reward              = 22


########################################################
##  PARTY TEMPLATE SLOTS   #############################
########################################################

########################################################
rel_enemy   = 0
rel_neutral = 1
rel_ally    = 2


#Talk contexts
tc_town_talk                  = 0
tc_party_encounter            = 1
tc_lord_talk_in_center        = 2
tc_siege_commander            = 3
tc_join_battle_ally           = 4
tc_join_battle_enemy          = 5
tc_castle_commander           = 6
tc_hero_freed                 = 7
tc_hero_defeated              = 8
tc_entering_center_quest_talk = 9
tc_back_alley                 = 10
tc_siege_won_seneschal        = 11
tc_ally_thanks                = 12
tc_tavern_talk                = 13

reinforcement_cost            = 400

merchant_toll_duration        = 72 #Tolls are valid for 72 hours

hero_escape_after_defeat_chance = 100 #TODO: it should be:80
#main_factions_begin = "fac_swadians"
#main_factions_end   = "fac_khergits"

marnid_inn_entry = 2
borcha_inn_entry = 3
ymira_inn_entry  = 4

raid_distance = 4

kingdoms_begin = "fac_kingdom_caowei"
kingdoms_end = "fac_kingdoms_end"

kingdom_ladies_begin = "trp_kingdom_1_lord_wife"
kingdom_ladies_end = "trp_heroes_end"

kingdom_heroes_begin = "trp_jiaxu"
kingdom_heroes_end = "trp_last_npc" #TODO: Change this to kingdom_ladies_begin when ladies are added

heroes_begin = kingdom_heroes_begin
#heroes_end = kingdom_ladies_end
heroes_end = kingdom_heroes_end

companions_begin = "trp_shahongbing"
companions_end = kingdom_heroes_begin

tavern_minstrels_begin = "trp_tavern_minstrel_1"
tavern_minstrels_end   = companions_begin

tavern_travelers_begin = "trp_tavern_traveler_1"
tavern_travelers_end   = tavern_minstrels_begin

ransom_brokers_begin = "trp_ransom_broker_1"
ransom_brokers_end   = tavern_travelers_begin

mercenary_troops_begin = "trp_volunteer"
mercenary_troops_end = "trp_mercenaries_end"

##lord_quests_begin = "qst_deliver_message"
##lord_quests_end   = "qst_escort_merchant_caravan"
##
##enemy_lord_quests_begin = "qst_lend_surgeon"
##enemy_lord_quests_end   = "qst_rescue_lord_by_replace"
##
##lady_quests_begin = "qst_rescue_lord_by_replace"
##lady_quests_end   = "qst_deliver_message_to_prisoner_lord"

merchant_quests_begin  = "qst_escort_merchant_caravan"
merchant_quests_end    = "qst_hunt_down_river_pirates"

all_quests_begin = 0
all_quests_end = "qst_quests_end"

towns_begin = "p_xiangping"
castles_begin = "p_castle_1"
villages_begin = "p_village_1"

towns_end = castles_begin
castles_end = villages_begin
villages_end   = "p_salt_mine"

walled_centers_begin = towns_begin
walled_centers_end   = castles_end

centers_begin = towns_begin
centers_end   = villages_end

scenes_begin = "scn_town_1_center"
scenes_end = "scn_castle_1_exterior"

spawn_points_begin = "p_zendar"
spawn_points_end = "p_spawn_points_end"

regular_troops_begin       = "trp_novice_fighter"
regular_troops_end         = "trp_kidnapped_girl"

swadian_merc_parties_begin = "p_town_1_mercs"
swadian_merc_parties_end   = "p_town_8_mercs"

vaegir_merc_parties_begin  = "p_town_8_mercs"
vaegir_merc_parties_end    = "p_zendar"

arena_masters_begin    = "trp_town_1_arena_master"
arena_masters_end      = "trp_zendar_armorer"

town_walkers_begin = "trp_town_walker_1"
town_walkers_end = "trp_tournament_master"

armor_merchants_begin  = "trp_zendar_armorer"
armor_merchants_end    = "trp_zendar_weaponsmith"

weapon_merchants_begin = "trp_zendar_weaponsmith"
weapon_merchants_end   = "trp_zendar_tavernkeeper"

tavernkeepers_begin    = "trp_zendar_tavernkeeper"
tavernkeepers_end      = "trp_zendar_merchant"

goods_merchants_begin  = "trp_zendar_merchant"
goods_merchants_end    = "trp_zendar_horse_merchant"

horse_merchants_begin  = "trp_zendar_horse_merchant"
horse_merchants_end    = "trp_merchants_end"

average_price_factor = 1000
minimum_price_factor = 100
maximum_price_factor = 10000

#TODO: Change these when items are ordered
trade_goods_begin = "itm_smoked_fish"
trade_goods_end = "itm_siege_supply"
food_begin = "itm_smoked_fish"
food_end = "itm_wine"
morale_boosters_begin = food_begin
morale_boosters_end = "itm_spice"
horses_begin = "itm_sumpter_horse"
horses_end = "itm_arrows"
weapons_begin = "itm_wooden_stick"
weapons_end = "itm_wooden_shield"
ranged_weapons_begin = "itm_jarid"
ranged_weapons_end = "itm_torch"
armors_begin = "itm_leather_gloves"
armors_end = "itm_wooden_stick"
shields_begin = "itm_wooden_shield"
shields_end = "itm_jarid"

# Some constants for merchant invenotries
merchant_inventory_space = 30
num_merchandise_goods = 40

num_max_river_pirates = 25
num_max_zendar_peasants = 25
num_max_zendar_manhunters = 10

num_max_dp_bandits = 10
num_max_refugees = 10
num_max_deserters = 10

num_max_militia_bands = 15
num_max_armed_bands = 12

num_max_vaegir_punishing_parties = 20
num_max_rebel_peasants = 25

num_max_frightened_farmers = 50
num_max_undead_messengers  = 20

num_forest_bandit_spawn_points = 1
num_mountain_bandit_spawn_points = 1
num_steppe_bandit_spawn_points = 1
num_black_khergit_spawn_points = 1
num_sea_raider_spawn_points = 2

peak_prisoner_trains = 4
peak_kingdom_caravans = 12
peak_kingdom_messengers = 3


# Note positions
note_troop_location = 3

#battle tactics
btactic_hold = 1
btactic_follow_leader = 2
btactic_charge = 3
btactic_stand_ground = 4

#default right mouse menu orders
cmenu_move = -7


main_factions_begin = "fac_kingdom_caowei"
main_factions_end   = "fac_force_headyellow"

marnid_inn_entry = 2
borcha_inn_entry = 3
ymira_inn_entry  = 4

lord_quests_begin = "qst_deliver_message"
lord_quests_end   = "qst_escort_merchant_caravan"

governer_quests_begin = "qst_deliver_message"
governer_quests_end   = "qst_escort_merchant_caravan"

merchant_quests_begin  = "qst_escort_merchant_caravan"
merchant_quests_end    = "qst_hunt_down_river_pirates"

towns_begin = "p_xiangping"
towns_end = "p_village_1"

castles_begin = "p_castle_1"
castles_end = "p_castle_8"

centers_begin = towns_begin
centers_end   = castles_end

spawn_points_begin = "p_zendar"
spawn_points_end = "p_spawn_points_end"

governers_begin = "trp_town_1_ruler_a"
governers_end = "trp_town_1_arena_master"

merchants_begin = "trp_zendar_merchant"
merchants_end = "trp_zendar_horse_merchant"

regular_troops_begin       = "trp_tutorial_trainer"
regular_troops_end         = "trp_Galeas"

arena_masters_begin    = "trp_town_1_arena_master"
arena_masters_end      = "trp_zendar_armorer"

armor_merchants_begin  = "trp_zendar_armorer"
armor_merchants_end    = "trp_zendar_weaponsmith"

weapon_merchants_begin = "trp_zendar_weaponsmith"
weapon_merchants_end   = "trp_zendar_tavernkeeper"

tavernkeepers_begin    = "trp_zendar_tavernkeeper"
tavernkeepers_end      = "trp_zendar_merchant"

goods_merchants_begin  = "trp_zendar_merchant"
goods_merchants_end    = "trp_zendar_horse_merchant"

num_max_river_pirates = 25
num_max_zendar_peasants = 25
num_max_zendar_manhunters = 10

num_max_dp_bandits = 10
num_max_refugees = 10
num_max_deserters = 10

num_max_militia_bands = 15
num_max_armed_bands = 12

num_max_vaegir_punishing_parties = 20
num_max_rebel_peasants = 25

num_max_frightened_farmers = 50
num_max_undead_messengers  = 20

num_forest_bandit_spawn_points = 1
num_mountain_bandit_spawn_points = 1
num_steppe_bandit_spawn_points = 1
num_black_khergit_spawn_points = 1
num_sea_raider_spawn_points = 2

peak_prisoner_trains = 4
peak_kingdom_caravans = 12
#sango
caowei_merc_parties_begin = "p_xiangping_mercs"
caowei_merc_parties_end = "p_jiangxia_mercs"

shu_merc_parties_begin = "p_jiangxia_mercs"
shu_merc_parties_end = "p_jianye_mercs"

wu_merc_parties_begin = "p_jianye_mercs"
wu_merc_parties_end = "p_xiangping"

s_pt_begin = "pt_wei_recruit_party"
s_pt_end = "pt_peasant"

npc_begin = "trp_jiaxu"
npc_end = "trp_lvbu"
npc_wei_begin = "trp_jiaxu"
npc_wei_end = "trp_pangtong"
npc_shu_begin = "trp_pangtong"
npc_shu_end = "trp_sunquan"
npc_wu_begin = "trp_sunquan"
npc_wu_end = "trp_lvbu"
npcnpc_begin = "trp_lvbu"
npcnpc_end = "trp_gaoshun"
npc_first_begin = "trp_first_npc"
npc_last_end = "trp_last_npc"
npc_special_begin = "trp_gaoshun"
npc_special_end = "trp_last_npc"
town_wei_begin = "p_xiangping"
town_wei_end = "p_jiangxia"
town_shu_begin = "p_jiangxia"
town_shu_end = "p_jianye"
town_wu_begin = "p_jianye"
town_wu_end = "p_village_1"
troop_join_begin = "trp_shu_youth"
troop_join_end = "trp_peng31"
troop_wei_begin = "trp_wei_light_cavalry"
troop_wei_end = "trp_tiger_fighter"
troop_shu_begin = "trp_shu_archer_troop"
troop_shu_end = "trp_western_liang_valiant_calvary"
troop_wu_begin = "trp_wu_trouble_dealing_army"
troop_wu_end = "trp_courage"
scn_tavern_begin = "scn_xiangping_tavern"
scn_tavern_end = "scn_jiaozhi_tavern"


npc_ine_op=trp_last_npc-trp_first_npc
slot_quest_target_center            = 1
slot_quest_target_troop             = 2
slot_quest_target_faction           = 3
slot_quest_object_troop             = 4
slot_quest_target_troop_is_prisoner = 5
slot_quest_giver_troop              = 6
slot_quest_object_center            = 7
slot_quest_target_party             = 8
slot_quest_target_party_template    = 9
slot_quest_target_amount            = 10
slot_quest_current_state            = 11
slot_quest_giver_center             = 12
slot_quest_target_dna               = 13
slot_quest_target_item              = 14

slot_quest_convince_value           = 19
slot_quest_importance               = 20
slot_quest_xp_reward                = 21
slot_quest_gold_reward              = 22
slot_quest_expiration_days          = 23
slot_quest_dont_give_again_period   = 24
slot_quest_dont_give_again_remaining_days = 25

slot_village_raided_by        = 34
slot_village_state            = 35 #svs_normal, svs_being_raided, svs_looted, svs_recovering, svs_deserted
slot_village_raid_progress    = 36
slot_village_recover_progress = 37
slot_village_smoke_added      = 38

slot_village_infested_by_bandits  = 39

slot_village_land_quality       = 44
slot_village_number_of_cattle   = 45

