# -*- coding: cp1254 -*-
from header_game_menus import *
from header_common import *
from header_dialogs import *
from header_operations import *
from header_parties import *
from header_item_modifiers import *
from header_skills import *
from header_triggers import *
from ID_troops import *
from ID_party_templates import *
from ID_skills import *
from module_constants import *
from setting_sango import *

####################################################################################################################
# During a dialog, the dialog lines are scanned from top to bottom.
# If the dialog-line is spoken by the player, all the matching lines are displayed for the player to pick from.
# If the dialog-line is spoken by another, the first (top-most) matching line is selected.
#
#  Each dialog line contains the following fields:
# 1) Dialogue partner: This should match the person player is talking to.
#    Usually this is a troop-id.
#    You can also use a party-template-id by appending '|party_tpl' to this field.
#    Use the constant 'anyone' if you'd like the line to match anybody.
#    Appending '|plyr' to this field means that the actual line is spoken by the player
#    Appending '|other(troop_id)' means that this line is spoken by a third person on the scene.
#       (You must make sure that this third person is present on the scene)
#
# 2) Starting dialog-state:
#    During a dialog there's always an active Dialog-state.
#    A dialog-line's starting dialog state must be the same as the active dialog state, for the line to be a possible candidate.
#    If the dialog is started by meeting a party on the map, initially, the active dialog state is "start"
#    If the dialog is started by speaking to an NPC in a town, initially, the active dialog state is "start"
#    If the dialog is started by helping a party defeat another party, initially, the active dialog state is "party_relieved"
#    If the dialog is started by liberating a prisoner, initially, the active dialog state is "prisoner_liberated"
#    If the dialog is started by defeating a party led by a hero, initially, the active dialog state is "enemy_defeated"
#    If the dialog is started by a trigger, initially, the active dialog state is "event_triggered"
# 3) Conditions block (list): This must be a valid operation block. See header_operations.py for reference.  
# 4) Dialog Text (string):
# 5) Ending dialog-state:
#    If a dialog line is picked, the active dialog-state will become the picked line's ending dialog-state.
# 6) Consequences block (list): This must be a valid operation block. See header_operations.py for reference.
####################################################################################################################

dialogs = [
  [anyone ,"start", [(store_conversation_troop, "$g_talk_troop"),
                     (store_troop_faction, "$g_talk_troop_faction", "$g_talk_troop"),
                     (troop_get_slot, "$g_talk_troop_relation", "$g_talk_troop", slot_troop_player_relation),
                     (store_relation, "$g_talk_troop_faction_relation", "$g_talk_troop_faction", "fac_player_faction"),
                     
                     (assign, "$g_talk_troop_party", "$g_encountered_party"),
                     (try_begin),
                       (troop_slot_ge, "$g_talk_troop", slot_troop_leaded_party, 1),
                       (troop_get_slot, "$g_talk_troop_party", "$g_talk_troop", slot_troop_leaded_party),
                     (try_end),
                     
#                     (assign, "$g_talk_troop_kingdom_relation", 0),
#                     (try_begin),
#                       (gt, "$players_kingdom", 0),
#                       (store_relation, "$g_talk_troop_kingdom_relation", "$g_talk_troop_faction", "$players_kingdom"),
#                     (try_end),
                     
                     (store_current_hours, "$g_current_hours"),
                     (troop_get_slot, "$g_talk_troop_last_talk_time", "$g_talk_troop", slot_troop_last_talk_time),
                     (troop_set_slot, "$g_talk_troop", slot_troop_last_talk_time, "$g_current_hours"),
                     (store_sub, "$g_time_since_last_talk","$g_current_hours","$g_talk_troop_last_talk_time"),
                     (troop_get_slot, "$g_talk_troop_met", "$g_talk_troop", slot_troop_met),
                     (troop_set_slot, "$g_talk_troop", slot_troop_met, 1),

                     (try_begin),
#                       (this_or_next|eq, "$talk_context", tc_party_encounter),
#                       (this_or_next|eq, "$talk_context", tc_castle_commander),
                       (call_script, "script_party_calculate_strength", "p_collective_enemy"),
                       (assign, "$g_enemy_strength", reg0),
                       (call_script, "script_party_calculate_strength", "p_main_party"),
                       (assign, "$g_ally_strength", reg0),
                       (store_mul, "$g_strength_ratio", "$g_ally_strength", 100),
                       (val_div, "$g_strength_ratio", "$g_enemy_strength"),
                     (try_end),

                     (troop_is_hero, "$g_talk_troop"),
                     (talk_info_show, 1),
                     (call_script, "script_setup_talk_info"),
                     (eq, 1, 0)],
   "Warning: This line is never displayed. It is just for storing conversation variables.", "close_window", []],

##  [trp_tutorial_trainer,"start", [(eq, "$tutorial_quest_award_taken", 1),], "I think you have trained enough. Perhaps you should go to Zendar for the next step of your adventure.", "close_window",[]],
##  [trp_tutorial_trainer,"start", [(store_character_level, ":player_level", "trp_player"),(gt, ":player_level", 1)], "I think you have trained enough. Perhaps you should go to Zendar for the next step of your adventure.", "close_window",[]],
##  [trp_tutorial_trainer,"start", [(eq, "$tutorial_quest_taken", 0),], "Greetings stranger. What's your name?", "tutorial1_1",[]],
##  [trp_tutorial_trainer|plyr, "tutorial1_1", [], "Greetings sir, it's {playername}.", "tutorial1_2", []],
##  [trp_tutorial_trainer, "tutorial1_2", [], "Well {playername}, this place you see is the training ground. Locals come here to practice their combat skills. Since you are here you may have a go as well.", "tutorial1_3", []],
##  [trp_tutorial_trainer|plyr, "tutorial1_3", [], "I'd like that very much sir. Thank you.", "tutorial1_4", []],
##  [trp_tutorial_trainer, "tutorial1_4", [], "You will learn the basics of weapons and riding a horse here.\
##  First you'll begin with melee weapons. Then you'll enter an archery range to test your skills. And finally you'll see a horse waiting for you.\
##  I advise you to train in all these 3 areas. But you can skip some of them, it's up to you.", "tutorial1_6", []],
##  [trp_tutorial_trainer, "tutorial1_6", [], "Tell you what, if you destroy at least 10 dummies while training, I will give you my old knife as a reward. It's a little rusty but it's a good blade.", "tutorial1_7", []],
##  [trp_tutorial_trainer|plyr, "tutorial1_7", [], "Sounds nice, I'm ready for training.", "tutorial1_9", []],
##  [trp_tutorial_trainer, "tutorial1_9", [], "Good. Return to me when you have earned your reward.", "close_window", [(eq, "$tutorial_quest_taken", 0),
##                                                                                                                     (str_store_troop_name, 1, "trp_tutorial_trainer"),
##                                                                                                                     (str_store_party_name, 2, "p_training_ground"),
##                                                                                                                     (setup_quest_giver, "qst_destroy_dummies", "str_given_by_s1_at_s2"),
##                                                                                                                     (str_store_string, s2, "@Trainer ordered you to destroy 10 dummies in the training camp."),
##                                                                                                                     (call_script, "script_start_quest", "qst_destroy_dummies", "$g_talk_troop"),
##                                                                                                                     (assign, "$tutorial_quest_taken", 1)]],
##
##  [trp_tutorial_trainer,"start", [(eq, "$tutorial_quest_taken", 1),
##                                  (eq, "$tutorial_quest_succeeded", 1),], "Well done {playername}. Now you earned this knife. There you go.", "tutorial2_1",[]],
##  [trp_tutorial_trainer|plyr, "tutorial2_1", [], "Thank you master.", "close_window", [(call_script, "script_end_quest", "qst_destroy_dummies"),(assign, "$tutorial_quest_award_taken", 1),(add_xp_to_troop, 100, "trp_player"),(troop_add_item, "trp_player","itm_knife",imod_chipped),]],
##
##  [trp_tutorial_trainer,"start", [(eq, "$tutorial_quest_taken", 1),
##                                  (eq, "$tutorial_quest_succeeded", 1),], "Greetings {playername}. Feel free to train with the targets.", "tutorial2_1",[]],
##
##  [trp_tutorial_trainer,"start", [(eq, "$tutorial_quest_taken", 1),
##                                  (eq, "$tutorial_quest_succeeded", 0),], "I don't see 10 dummies on the floor from here. You haven't earned your reward yet.", "tutorial3_1",[]],
##  [trp_tutorial_trainer|plyr, "tutorial3_1", [], "Alright alright, I was just tired and wanted to talk to you while resting.", "tutorial3_2", []],
##  [trp_tutorial_trainer, "tutorial3_2", [], "Less talk, more work.", "close_window", []],

  

    
  [trp_constable_hareck,"start", [(eq,"$constable_announcement",0)],
 "Hear me, people of Zendar, for I bear a message from our town's lord and protector, Count Arrasies.\
 As you know, bands of river pirates have infested the vicinity of our town.\
 These lawless villains devastate our realm, pillaging, robbing and murdering the innocent.\
 The mischief and suffering caused by these scum has become intolerable.\
 Thus, our good Count has found it necessary to call to arms his honest and law-abiding subjects against these murderous villains.",
   "constable_hareck_introduce_1",[(assign,"$constable_announcement",1)]],
  [trp_constable_hareck,"constable_hareck_introduce_1", [],
 "People of Zendar, our Count invites you to serve him in this cause.\
 Those of you that volunteer now will be equipped with arms and armor at the Count's expense\
 and shall be granted the right to hunt down the river pirates, ending their miserable lives by death or imprisonment,\
 and keeping their ill-gotten gains to yourselves without tax or tribute.\
 Moreover, you will be paid a reward of 20 denars from the Count's treasury for every river pirate group you vanquish.", "close_window",[]],

  [trp_constable_hareck,"start", [], "What do you want?", "constable_hareck_talk",[]],

  [trp_constable_hareck|plyr,"constable_hareck_talk", [(eq,"$quest_accepted_zendar_river_pirates",0)],
 "I want to sign up to hunt down the river pirates.", "constable_hareck_signup_1",[]],
  [trp_constable_hareck,"constable_hareck_signup_1", [], "Have you worked as a manhunter before?", "constable_hareck_signup_2",[]],
  [trp_constable_hareck|plyr,"constable_hareck_signup_2", [], "Yes I have.", "constable_hareck_signup_3",[]],
  [trp_constable_hareck|plyr,"constable_hareck_signup_2", [], "Not really. But I learn quickly", "constable_hareck_signup_3",[]],
  [trp_constable_hareck,"constable_hareck_signup_3", [],
 "That's more than enough for me. Well then. I charge you to hunt down river pirates around Zendar,\
 and give you this shield from the Count's armory.\
 May God make you victorious.", "constable_hareck_signup_4",[(assign,"$quest_accepted_zendar_river_pirates",1),
															 (str_store_string, s2, "@Constable Hareck asked you to hunt down the river pirates that plague the country around Zendar.\
 He promised to pay you 20 denars for each river pirate party you eliminate."),
															 (call_script, "script_start_quest", "qst_hunt_down_river_pirates", "$g_talk_troop"),
															 (troop_add_item, "trp_player","itm_tutorial_sword"),#sango
															 (troop_add_item, "trp_player","itm_tutorial_spear"),
															 (troop_add_item, "trp_player","itm_tutorial_short_bow"),
															 (troop_add_item, "trp_player","itm_tutorial_arrows"),
															 (troop_add_item, "trp_player","itm_tutorial_saddle_horse")]],
  [trp_constable_hareck|plyr,"constable_hareck_signup_4", [], "Is that all?", "constable_hareck_signup_5",[]],
  [trp_constable_hareck,"constable_hareck_signup_5", [], "What else do you want, a good luck kiss?\
 Now stop chattering and go kill some outlaws. You have to work hard to deserve that shield.", "close_window",[]],
  
  [trp_constable_hareck,"sell_prisoner_outlaws_finished", [], "Well done my {boy/girl}. .", "close_window",[]],
  
  [trp_constable_hareck|plyr,"constable_hareck_talk", [
      (store_num_parties_destroyed_by_player, ":num_river_pirates_destroyed", "pt_river_pirates"),
      (val_min,":num_river_pirates_destroyed",num_max_river_pirates),
      (lt,"$river_pirates_paid_for",":num_river_pirates_destroyed")],
   "I have hunted down some river pirates.", "pay_for_river_pirates",[]],
  [trp_constable_hareck,"pay_for_river_pirates", [],
   "Yes, my scouts informed me. That should make them think twice before wandering near Zendar! Anyway, the reward is 20 denars for every river pirate party. Here is your money, as promised.",
   "pay_for_river_pirates_2",[(store_num_parties_destroyed_by_player, ":num_river_pirates_destroyed", "pt_river_pirates"),
                              (val_min,":num_river_pirates_destroyed",num_max_river_pirates),
                              (store_sub,":river_pirate_bounty",":num_river_pirates_destroyed","$river_pirates_paid_for"),
                              (val_mul,":river_pirate_bounty",20),
                              (troop_add_gold,"trp_player",":river_pirate_bounty"),
                              (assign,"$river_pirates_paid_for",":num_river_pirates_destroyed")]],
  [trp_constable_hareck|plyr,"pay_for_river_pirates_2", [],
   "Thank you, sir.", "pay_for_river_pirates_3",[]],
  [trp_constable_hareck,"pay_for_river_pirates_3", [(neq,"$quest_complete_zendar_river_pirates",0),(eq,"$quest_complete_zendar_river_pirates_ack",0)],
 "You certainly deserved your pay. Thanks to hunters like you most of the river pirates have been dealt with.\
 The few remaining do not pose a threat any longer. So I thank you in the name of the town of Zendar. You did a mighty good job.","constable_hareck_reward_1",[[add_xp_as_reward,100],[call_script, "script_end_quest", "qst_hunt_down_river_pirates"],[assign,"$quest_complete_zendar_river_pirates_ack",1]]],
  [trp_constable_hareck|plyr,"constable_hareck_reward_1", [], "Thank you sir. But does that mean you won't be paying any more rewards?", "constable_hareck_reward_2",[]],
  [trp_constable_hareck,"constable_hareck_reward_2", [], "You got that right.\
 The truth is, the count's accountant has found out that rewards cost him more than the pirates do.\
 So, that means no more rewards for those filthy pirates.\
 Nothing is stopping you from taking your own reward from their packs and hideouts, though.", "close_window",[]],
  [trp_constable_hareck,"pay_for_river_pirates_3", [], "Ah, yes... Well... good luck.", "close_window",[]],
  
  [trp_constable_hareck|plyr,"constable_hareck_talk", [], "Nothing. Good-bye.", "close_window",[]],

##  [trp_marnid,"start",[(eq,"$marnid_introduced",0)],"Hello, you are new to the town aren't you. Would you be so kind to have a cup of wine with a fellow traveller?\
## I am here to waste my last five denars and I'd rather have someone help me with that.", "marnid_introduce_1",[[assign,"$marnid_introduced",1]]],
##  [trp_marnid|plyr,"marnid_introduce_1",[],"Your last five denars? It seems that luck has not been at your side lately.", "marnid_introduce_2",[]],
##  [trp_marnid,"marnid_introduce_2",[],"Luck? You know it comes and it goes.\
## Three months ago, I left Geroia with a caravan of goods. I was hoping to sell it all in Harlaushia and make a hefty sum.\
## But, what do you know... we were ambushed by a party of Khergit raiders who rode away with most of the horses and goods.\
## And two weeks later, my own caravan guards ran away with the rest of what I had.","marnid_introduce_3",[]],
##  [trp_marnid|plyr,"marnid_introduce_3",[],"My sympathies friend. I hope your luck turns back soon.", "marnid_introduce_4",[]],
##  [trp_marnid,"marnid_introduce_4",[],"Thanks... Anyway, my name is Marnid Rhaleis.", "marnid_introduce_5",[]],
##  [trp_marnid|plyr,"marnid_introduce_5",[],"{playername}. What are you planning to do now?", "marnid_introduce_6",[]],
##  [trp_marnid,"marnid_introduce_6",[],"Eh. I have no money left, no friends or relatives to ask for help.\
## The only way left for me is to enlist as a soldier and seek my fortune in war.", "marnid_introduce_7",[]],
##  [trp_marnid|plyr,"marnid_introduce_7",[],"Do you have training in combat?", "marnid_introduce_8",[]],
##  [trp_marnid,"marnid_introduce_8",[],"Not really. I guess I will have to learn it all the hard way, through battle.\
## But what worries me really is that I have no armor.\
## If I enlist now, they will surely place me among the peasant levies, and you know what that means.\
## I will be butchered in the first encounter with the enemy.\
## If only I had some serviceable armor, even a suit of padded cloth. Sigh.", "marnid_intro_talk",[]],
##
##  [trp_marnid,"start", [(eq,"$marnid_joined_party",1),
##                        (neg|main_party_has_troop,"trp_marnid"),
##                        (neq, "$g_encountered_party", "p_four_ways_inn"),], "Do you want me to rejoin you?", "member_wilderness_talk",[]],
##  [trp_marnid,"start", [(neg|main_party_has_troop,"trp_marnid"),(eq, "$g_encountered_party", "p_four_ways_inn")], "Do you want me to rejoin you?", "member_inn_talk",[]],
##  [trp_marnid,"member_separate_inn", [], "All right then. I'll meet you at the four ways inn. Good luck.", "close_window",
##   [(store_conversation_troop,reg(0)),(remove_member_from_party,reg(0)),(add_troop_to_site, reg(0), "scn_four_ways_inn",marnid_inn_entry)]],
##
##  [trp_marnid,"start", [], "Hello {playername}.", "marnid_intro_talk",[]],
##  [trp_marnid,"marnid_pre_free", [], "Yes?", "marnid_intro_talk",[]],
##  [trp_marnid|plyr,"marnid_intro_talk", [], "Tell me about yourself.", "marnid_view_char_requested",[]],
##  [trp_marnid,"marnid_view_char_requested", [], "You know, I am a ruined merchant. I know a thing or two about trade, a bit about riding and a few other things.", "marnid_pre_free",[[change_screen_view_character]]],
##   
##  [trp_marnid|plyr,"marnid_intro_talk", [(eq,"$marnid_joined_party")], "Would you fight in my service if I gave you a padded cloth?", "marnid_leather_hauberk_1",[]],
##  [trp_marnid,"marnid_leather_hauberk_1", [(eq,"$marnid_join_party_answered")], "Well... Of course, why not? For all I know, you could be as good a captain as anyone else.\
## Yes I would gladly follow you to battle if you gave me a padded cloth.", "marnid_leather_hauberk_2",[(assign,"$marnid_join_party_answered",1)]],
##  [trp_marnid,"marnid_leather_hauberk_1", [], "Yes, I haven't changed my mind. I would.", "marnid_leather_hauberk_2",[]],
##  [trp_marnid|plyr,"marnid_leather_hauberk_2", [(player_has_item,"itm_padded_cloth")], "Then, take this padded cloth I have. I want you to join me.", "marnid_leather_hauberk_3_cloth",[]],
##  [trp_marnid|plyr,"marnid_leather_hauberk_2", [(player_has_item,"itm_padded_leather"),(neg|player_has_item,"itm_padded_cloth")], "Then, take this padded leather I have. I want you to join me.", "marnid_leather_hauberk_3_leather",[]],
##  [trp_marnid|plyr,"marnid_leather_hauberk_2", [], "Hmm. Let me think about this then.", "close_window",[]],
##  [trp_marnid,"marnid_leather_hauberk_3_cloth", [(neg|hero_can_join,0)], "I would like to, friend. But I am afraid you don't have room for me in your party. Once you make room, let me know. I'm eager to leave this place.", "close_window",[]],
##  [trp_marnid,"marnid_leather_hauberk_3_cloth", [], "Well, look at this. I feel that my luck is starting to turn back after all. I am at your service, friend. Let us hit the road and discover what adventures await us.", "close_window",[
##	(troop_remove_item,0,"itm_padded_cloth"),(troop_add_item,"trp_marnid","itm_padded_cloth"),
##	(troop_join,"trp_marnid"),(remove_troop_from_site,"trp_marnid"),(assign,"$marnid_joined_party",1)]],
##
##  [trp_marnid,"marnid_leather_hauberk_3_leather", [(neg|hero_can_join,0)], "I would like to, friend. But I am afraid you don't have room for me in your party. Once you make room, let me know. I'm eager to leave this place.", "close_window",[]],
##  [trp_marnid,"marnid_leather_hauberk_3_leather", [], "Well, look at this. I feel that my luck is starting to turn back after all. I am at your service, friend. Let us hit the road and discover what adventures await us.", "close_window",[
##	(troop_remove_item,0,"itm_padded_leather"),(troop_add_item,"trp_marnid","itm_padded_leather"),
##	(troop_join,"trp_marnid"),(remove_troop_from_site,"trp_marnid"),(assign,"$marnid_joined_party",1)]],
##
##  [trp_marnid|plyr,"marnid_intro_talk", [], "I must leave now. Good-bye", "close_window",[]],




  [trp_ramun_the_slave_trader, "start", [(eq,"$ramun_introduced")], "Good day to you, {young man/girl}.", "ramun_introduce_1",[[assign,"$ramun_introduced",1]]],
  [trp_ramun_the_slave_trader|plyr, "ramun_introduce_1", [], "Good day, sir. You look like you are here for business. Are you a merchant?", "ramun_introduce_2",[]],
  [trp_ramun_the_slave_trader, "ramun_introduce_2", [], "Merchant? Aye. I am certainly a merchant.\
 But my merchandise is a bit peculiar. It has to be fed twice a day, and tries to run away if I turn my back.", "ramun_introduce_3",[]],
  [trp_ramun_the_slave_trader|plyr, "ramun_introduce_3", [], "Livestock?", "ramun_introduce_4",[]],
  [trp_ramun_the_slave_trader, "ramun_introduce_4", [], "Close enough. You see, most of the ships that come here are run by oars.\
 And they need men to pull those oars. But not free man. No that would be damn expensive.", "ramun_introduce_5",[]],
  [trp_ramun_the_slave_trader|plyr, "ramun_introduce_5", [], "Galley slaves.", "ramun_introduce_6",[]],
  [trp_ramun_the_slave_trader, "ramun_introduce_6", [], "Galley slaves, right. That's what I deal in.\
 The ships lose a few men at every voyage, and they are always short of enough slaves.\
 So they come to me, and they pay well.", "ramun_introduce_7",[]],
  [trp_ramun_the_slave_trader|plyr, "ramun_introduce_7", [], "Where do the slaves come from?", "ramun_introduce_8",[]],
  [trp_ramun_the_slave_trader, "ramun_introduce_8", [], "They are mostly convicted criminals, and prisoners of war.\
 I buy them off the authorities mostly. But I also work with privateers and other 'individuals'.\
 You can't be too picky about your suppliers in my line of work, you know.\
 Why, I would be happy to buy them from you too.", "ramun_introduce_9",[]],
  [trp_ramun_the_slave_trader|plyr, "ramun_introduce_9", [], "Me? ", "ramun_introduce_10",[]],
  [trp_ramun_the_slave_trader, "ramun_introduce_10", [], "You are an adventurer, right?\
 Eventually you are going to cross swords with someone out there, and if God permits, you will be victorious.\
 So while you are at it, why not make some extra money off the whole thing?\
 Capture your enemies alive, bring them to me and I will pay you a twenty denars for every one of them,\
 be they outlaws, or prisoners of war. No questions asked.", "ramun_introduce_11",[]],
  [trp_ramun_the_slave_trader|plyr, "ramun_introduce_11", [], "Hmm I will think about this.", "ramun_introduce_12",[]],
  [trp_ramun_the_slave_trader, "ramun_introduce_12", [], "Do think about it. I am always happy to deal with new suppliers.", "close_window",[]],

  [trp_ramun_the_slave_trader,"start", [], "Hello {playername}.", "ramun_talk",[]],
  [trp_ramun_the_slave_trader,"ramun_pre_talk", [], "Anything else?", "ramun_talk",[]],

  [trp_ramun_the_slave_trader|plyr,"ramun_talk",
   [[store_num_regular_prisoners,reg(0)],[ge,reg(0),1]],
   "I have brought you a few prisoners, Ramun. Would you like to have a look?", "ramun_sell_prisoners",[]],
  [trp_ramun_the_slave_trader,"ramun_sell_prisoners", [],
  "Let me see what you have...", "ramun_sell_prisoners_2",
   [[change_screen_trade_prisoners]]],
  [trp_ramun_the_slave_trader, "ramun_sell_prisoners_2", [], "It's good to do business with you.", "close_window",[]],

  [trp_ramun_the_slave_trader|plyr,"ramun_talk", [[eq,"$ch_explained_prisoners"]], "How do I take somebody as prisoner?", "ramun_ask_about_capturing",[[assign,"$ch_explained_prisoners",1]]],
  [trp_ramun_the_slave_trader|plyr,"ramun_talk", [[neq,"$ch_explained_prisoners"]], "Can you tell me again about capturing prisoners?", "ramun_ask_about_capturing",[]],

  [trp_ramun_the_slave_trader,"ramun_ask_about_capturing", [(eq,"$ramun_tip_given",0)],
 "You don't have much experience there, have you? Let me fill you in on the basics.\
 The basic rule of taking someone prisoner is beating him down with a blunt weapon like a mace or a club.\
 You have a blunt weapon don't you?", "ramun_have_blunt_weapon",[(assign,"$ramun_tip_given",1)]],
  [trp_ramun_the_slave_trader|plyr,"ramun_have_blunt_weapon", [],
 "Yes", "ramun_have_blunt_weapon_yes",[]],
  [trp_ramun_the_slave_trader|plyr,"ramun_have_blunt_weapon", [],
 "No", "ramun_have_blunt_weapon_no",[]],
  [trp_ramun_the_slave_trader,"ramun_have_blunt_weapon_yes", [],
 "Good. Then all you need to do is beat the bugger down with it until he can no longer stand on his feet.\
 Actually leaders and heroes are usually well protected so that what weapon you use does not matter.\
 However, your average rabble or bandit isn't as tough, so if you want to take prisoners from the regulars,\
 you musn't use anything other than blunt weapons.", "ramun_ask_about_capturing_2",[]],
  [trp_ramun_the_slave_trader,"ramun_have_blunt_weapon_no", [],
 "No? Heh, you are lucky then. I was thinking of replacing my old club with a new one.\
 It is not as in good condition as it used to be but it will still be useful to you if you are trying to get prisoners.\
 Here you may have it.","ramun_have_blunt_weapon_no_2",[(troop_add_item, "trp_player","itm_club",imod_cracked)]],
  [trp_ramun_the_slave_trader|plyr,"ramun_have_blunt_weapon_no_2", [],
 "Thanks Ramun. I guess this taking prisoners business will be easier than I expected.", "ramun_ask_about_capturing_3",[]],
  [trp_ramun_the_slave_trader,"ramun_ask_about_capturing", [],
 "Sure let me repeat the basics about capturing to you\
 If you want to capture someone alive you must avoid hitting him with sharp weapons and use a blunt weapon instead.\
 A hammer would do fine, or a blackjack or a good old club.\
 Actually leaders and heroes are usually well protected so that what weapon you use does not matter.\
 However, your average rabble or bandit isn't as tough, so if you want to take prisoners from the regulars, you must use blunt weapons.", "ramun_ask_about_capturing_2",[]],
  [trp_ramun_the_slave_trader|plyr,"ramun_ask_about_capturing_2", [], "Sounds easy enough. What else?", "ramun_ask_about_capturing_3",[]],
  [trp_ramun_the_slave_trader,"ramun_ask_about_capturing_3", [],
 "Actually, it is not that easy. Blunt weapons like clubs do less damage than sharp or edged weapons.\
 And trust me, given the chance, most of the scum you run across will sooner kill you than try to take you alive,\
 so don' t expect any courtesy when you pull out a club instead of a sword.\
 Moreover, having to drag prisoners to and fro will slow down your party.\
 For these reasons, some warriors do not bother to capture prisoners.\
 But of course, they are the ones who can turn down the extra money, right?", "ramun_ask_about_capturing_4",[]],
  [trp_ramun_the_slave_trader|plyr,"ramun_ask_about_capturing_4", [],
 "Is there anything else I need to know?", "ramun_ask_about_capturing_5",[]],
  [trp_ramun_the_slave_trader,"ramun_ask_about_capturing_5", [],
 "One final thing. If you want to capture many prisoners, you should know a thing or two about the skill of prisoner management.\
 Unless you personally know that skill, you cannot drag along prisoners with your party. You wouldn't want your prisoners to escape or stab you in your sleep now, would you?", "ramun_ask_about_capturing_7",[]],
  [trp_ramun_the_slave_trader|plyr,"ramun_ask_about_capturing_7", [],
 "Thanks, I will keep that in mind.", "ramun_pre_talk",[]],

  [trp_ramun_the_slave_trader|plyr,"ramun_talk", [], "I'd better be going.", "ramun_leave",[]],
  [trp_ramun_the_slave_trader,"ramun_leave", [], "Bring your prisoners straight to me. Remember. I pay well.", "close_window",[]],

  [trp_tournament_master,"start", [[neq,"$waiting_for_arena_fight_result"],[eq,"$zendar_arena_join_or_watch",0],[neq,"$arena_fight_won"]],
 "Congratulations champion. You made some pretty good moves out there. Here is your share of share of the prize money, 2 denars.", "arenamaster_fight",
   [[assign,"$waiting_for_arena_fight_result"],[add_xp_to_troop,20],[troop_add_gold, "trp_player",2]]],
  [trp_tournament_master,"start", [[neq,"$waiting_for_arena_fight_result"],[eq,"$zendar_arena_join_or_watch",0]],
 "That's quite the bruise you're sporting. But don't worry; everybody gets trounced once in awhile. The important thing is to pick yourself up, dust yourself off and keep fighting. That's what champions do.", "arenamaster_fight",[[assign,"$waiting_for_arena_fight_result"]]],
  [trp_tournament_master,"start", [[neq,"$waiting_for_arena_fight_result"]],
 "That was exciting wasn't it? Nothing like a good fight to get the blood flowing.", "arenamaster_fight",[[assign,"$waiting_for_arena_fight_result"]]],
  [trp_tournament_master,"start", [[eq, "$arenamaster_introduced"]], "Ah, a new face in the Zendar games. Welcome my {boy/girl}. I am the tournament master. Everything that happens in that arena is my business, and I do love every bit of it. I am the one you should talk to if you want to watch the games, or place a small bet for a little excitement. But wait, you are the kind who would rather participate than watch, right?", "arenamaster_introduce",[[assign,"$arenamaster_introduced",1]]],
  [trp_tournament_master|plyr,"arenamaster_introduce", [], "Can I participate?", "arenamaster_introduce_2",[]],
  [trp_tournament_master,"arenamaster_introduce_2", [], "Not only you can participate, but you should. The tournament ground is the place to be, the heart of Zendar! It is full of excitement and challange, and it is a great place to get experience. And while you are at it, you can make a small fortune by gambling on yourself too.", "arenamaster_introduce_3",[]],
  [trp_tournament_master|plyr,"arenamaster_introduce_3", [], "Sounds good. How do I participate?", "arenamaster_introduce_4",[]],
  [trp_tournament_master,"arenamaster_introduce_4", [], "Have you finished the training?", "arenamaster_introduce_5",[]],
  [trp_tournament_master|plyr,"arenamaster_introduce_5", [[ge,"$novice_training_difficulty",4]], "Yes I have.", "arenamaster_introduce_7a",[]],
  [trp_tournament_master|plyr,"arenamaster_introduce_5", [], "No I haven't.", "arenamaster_introduce_7b",[]],
  [trp_tournament_master,"arenamaster_introduce_7a", [], "Great then. You can participate in the games as you like.", "arenamaster_fight",[]],
  [trp_tournament_master,"arenamaster_introduce_7b", [], "I advise you to work on your skills with the trainer then. He's seen his share of battle and can teach you the basics of combat.\
 Jumping right into the tournament fights may be somewhat rough for you.\
 Of course you are welcome to watch the games whenever you like.", "arenamaster_chat_b",[]],
  [trp_tournament_master|plyr,"arenamaster_chat_b", [], "Maybe I'll just watch then.", "arenamaster_fight",[]],
  
  [trp_tournament_master,"start", [], "Well if it isn't {playername}. Good to see you again.", "arenamaster_fight",[]],

  [trp_tournament_master,"arenamaster_fight",
   [[eq,"$zendar_arena_join_or_watch",1],
    [ge,"$zendar_bet_amount",1],
    [assign,reg(0),"$zendar_winner_team"],[eq,"$zendar_arena_bet_team",reg(0)],
    [assign,reg(5),"$zendar_bet_amount"],[val_mul,reg(5),19],[val_div,reg(5),10]],
 "You've won the bet, eh? Let me see. The sum you have earned amounts to {reg5} denars. Here you go.", "arenamaster_fight",
   [[troop_add_gold, "trp_player",reg(5)],[assign,"$zendar_bet_amount"]]],
  
  [trp_tournament_master,"arenamaster_fight",
   [[eq,"$zendar_arena_join_or_watch",0],
    [ge,"$zendar_bet_amount",1],
    [neq,"$arena_fight_won"],
#    [put_cookie_to_reg,"zendar_winner_team",0],[eq,"zendar_arena_bet_team",reg(0)],
    [assign,reg(5),"$zendar_bet_amount"],
    [val_mul,reg(5),19],
    [val_div,reg(5),10]],
 "And you had the good sense to bet on yourself too. Hmm let me see. You have won yourself some {reg5} denars. Here you are.", "arenamaster_fight",
   [[troop_add_gold, "trp_player",reg(5)],[assign,"$zendar_bet_amount",0]]],

  [trp_tournament_master,"arenamaster_fight", [[eq,"$zendar_arena_game_type",0]], "The next fight will be a two vs. two\
 melee. I still need a fighter for the blue team. Are you interested?", "arenamaster_will_you_fight",
   [
    [assign,reg(10),"trp_regular_fighter"],
    [assign,reg(11),"trp_regular_fighter"],
    [assign,reg(12),"trp_veteran_fighter"],
    [assign,reg(13),"trp_veteran_fighter"],
    [assign,reg(14),"trp_veteran_fighter"],
    [assign,reg(15),"trp_champion_fighter"],
    [assign,reg(16),"trp_champion_fighter"],
    [assign,reg(17),"trp_xerina"],
    [assign,reg(18),"trp_dranton"],
    [assign,reg(19),"trp_kradus"],
    [shuffle_range,10,20],
    [modify_visitors_at_site,"scn_zendar_arena"],[reset_visitors],
#    [store_shuffled_range,8],
    [assign,reg(0),1],[assign,reg(1),2],[assign,reg(2),3],[assign,reg(3),4],[assign,reg(4),5],[assign,reg(5),6],[assign,reg(6),7],[assign,reg(7),8],
    [shuffle_range,0,8],
    [set_visitor,reg(0),reg(10)],
    [set_visitor,reg(1),reg(11)],
    [assign,reg(0),9],[assign,reg(1),10],[assign,reg(2),11],[assign,reg(3),12],[assign,reg(4),13],[assign,reg(5),14],[assign,reg(6),15],[assign,reg(7),16],
    [shuffle_range,0,8],
#    [set_visitor,reg(0),reg(12)],
    [set_visitor,reg(0),0],
    [assign,"$zendar_arena_player_position",reg(0)],
    [set_visitor,reg(1),reg(13)],
   ]],
  [trp_tournament_master,"arenamaster_fight", [[eq,"$zendar_arena_game_type",1]], "The next fight will be a three vs. three\
 melee. I still need a fighter for the red team. Are you interested?", "arenamaster_will_you_fight",
   [
    [assign,reg(10),"trp_regular_fighter"],
    [assign,reg(11),"trp_regular_fighter"],
    [assign,reg(12),"trp_veteran_fighter"],
    [assign,reg(13),"trp_veteran_fighter"],
    [assign,reg(14),"trp_veteran_fighter"],
    [assign,reg(15),"trp_champion_fighter"],
    [assign,reg(16),"trp_champion_fighter"],
    [assign,reg(17),"trp_xerina"],
    [assign,reg(18),"trp_dranton"],
    [assign,reg(19),"trp_kradus"],
    [shuffle_range,10,20],
    [modify_visitors_at_site,"scn_zendar_arena"],[reset_visitors],
    [assign,reg(0),1],[assign,reg(1),2],[assign,reg(2),3],[assign,reg(3),4],[assign,reg(4),5],[assign,reg(5),6],[assign,reg(6),7],[assign,reg(7),8],
    [shuffle_range,0,8],
    [set_visitor,reg(0),0],
    [assign,"$zendar_arena_player_position",reg(0)],
    [set_visitor,reg(1),reg(10)],
    [set_visitor,reg(2),reg(11)],
    [assign,reg(0),9],[assign,reg(1),10],[assign,reg(2),11],[assign,reg(3),12],[assign,reg(4),13],[assign,reg(5),14],[assign,reg(6),15],[assign,reg(7),16],
    [shuffle_range,0,8],
    [set_visitor,reg(0),reg(12)],
    [set_visitor,reg(1),reg(13)],
    [set_visitor,reg(2),reg(14)],
   ]],
#  [tournament_master,"arenamaster_fight", [], "The next fight will start soon. Do you want to participate?", "arenamaster_will_you_fight",[]],
  [trp_tournament_master|plyr,"arenamaster_will_you_fight", [[ge,"$novice_training_difficulty",0]], #should be 4.
   "I want to join the fight.", "arenamaster_we_will_fight",
   [[assign,"$zendar_arena_join_or_watch",0]]],
  [trp_tournament_master|plyr,"arenamaster_will_you_fight", [], "I would like to watch the fight.", "arenamaster_we_will_watch",
   [[assign,"$zendar_arena_join_or_watch",1],
    [set_visitor,"$zendar_arena_player_position","trp_veteran_fighter"],
    [set_visitor,0,0],
  ]],
  [trp_tournament_master|plyr,"arenamaster_will_you_fight", [], "No. perhaps later.", "arenamaster_we_will_fight_not",[]],
  [trp_tournament_master,"arenamaster_we_will_fight_not", [], "All right. Talk to me when you are ready.", "close_window",[]],
  [trp_tournament_master,"arenamaster_we_will_fight", [], "Do you want to place a bet on yourself?", "arenamaster_will_you_bet",
   [[assign,"$zendar_bet_amount"],[assign,"$zendar_arena_bet_team",0],
  ]],
  [trp_tournament_master|plyr,"arenamaster_will_you_bet", [], "No.", "arenamaster_start_fight",[]],
  [trp_tournament_master|plyr,"arenamaster_will_you_bet", [[store_troop_gold,reg(0)],[ge,reg(0),5]], "I want to bet 5 denars.",
   "arenamaster_bet_placed",[[assign,"$zendar_bet_amount",5],[troop_remove_gold, "trp_player",5]]],
  [trp_tournament_master|plyr,"arenamaster_will_you_bet", [[store_troop_gold,reg(0)],[ge,reg(0),15]], "I want to bet 15 denars.",
   "arenamaster_bet_placed",[[assign,"$zendar_bet_amount",15],[troop_remove_gold, "trp_player",15]]],
  [trp_tournament_master|plyr,"arenamaster_will_you_bet", [[store_troop_gold,reg(0)],[ge,reg(0),30]], "I want to bet 30 denars.",
   "arenamaster_bet_placed",[[assign,"$zendar_bet_amount",30],[troop_remove_gold, "trp_player",30]]],
  [trp_tournament_master,"arenamaster_we_will_watch", [[eq,"$watching_tip_given"]],
   "Good. I believe you will enjoy watching the tournament. [Tip: You can press and hold down shift key to zoom in and have a better view of the action while you watch.]", "arenamaster_we_will_watch",[[assign,"$watching_tip_given",1]]],
  [trp_tournament_master,"arenamaster_we_will_watch", [], "Do you want to place a bet?", "arenamaster_will_you_bet",[]],
  [trp_tournament_master,"arenamaster_bet_placed", [[eq,"$zendar_arena_join_or_watch",1]], "Hmm. That's good. And which team do you want to place your bet on.", "arenamaster_select_team",[]],
  [trp_tournament_master|plyr,"arenamaster_select_team", [], "The red team. I have a feeling they will win this one.",
   "arenamaster_start_fight",[[assign,"$zendar_arena_bet_team",0]]],
  [trp_tournament_master|plyr,"arenamaster_select_team", [], "The blue team. They will sweep the ground with the reds.",
   "arenamaster_start_fight",[[assign,"$zendar_arena_bet_team",1]]],
  [trp_tournament_master,"arenamaster_bet_placed", [], "That's good. Let me record that.", "arenamaster_start_fight",[]],
  
  [trp_tournament_master,"arenamaster_start_fight",
   [], "Very well. The fight starts in a moment. Good luck.", "close_window",
   [[assign,"$arena_fight_won"],
    [assign,"$zendar_winner_team",-1],
    [assign,"$waiting_for_arena_fight_result",1],
    [assign,reg(0),"$zendar_arena_game_type"],
    [store_add, reg(0), reg(0),1],
    [val_mod,reg(0),2],
    [assign,"$zendar_arena_game_type",reg(0)],
    [set_jump_mission,"mt_zendar_arena_fight"],
    [jump_to_scene,"scn_zendar_arena"]]],

  [trp_trainer,"start", [[eq,"$novicemaster_introduced"]], "I am the trainer of Zendar. Every new soldier, arena hopeful or mercenary that passes through here talks to me. If you want to take part in the tournaments you'd better finish training with me first. I don't even charge money to newcomers so you don't even need worry about the pay. Train until your muscles ache, I always say, and you will pick the rewards soon enough. What is your name?", "novicemaster_introduce",
   [[assign,"$novicemaster_introduced",1],
    [assign,"$novice_training_difficulty"],
    [assign,"$num_opponents_to_beat_in_a_row",3],
    [assign,"$novicemaster_opponent_troop","trp_novice_fighter"],
  ]],
  [trp_trainer|plyr,"novicemaster_introduce", [], "{playername}.", "novicemaster_introduce_2",[]],
  [trp_trainer,"novicemaster_introduce_2", [], "Well met, {playername}. You want to take part in the tournaments right?", "novicemaster_introduce_3",[]],
  [trp_trainer|plyr,"novicemaster_introduce_3", [], "I guess so.", "novicemaster_introduce_4",[]],
  [trp_trainer,"novicemaster_introduce_4", [], "Good. Then let us start right away. But before you step into the training ground, I want to tell you about the basics of combat. These are going to mean the difference between a stack of denars and a busted skull, so listen carefully.", "novicemaster_introduce_5",[]],
  [trp_trainer|plyr,"novicemaster_introduce_5", [], "I am listening.", "novicemaster_tell_theory",[]],
  [trp_trainer,"novicemaster_tell_theory", [], "Alright. The first thing you should know as a fighter is how to defend yourself. Keeping damage away from yourself is the first rule of combat, and it is much more important than delivering damage to others. Everybody can swing a sword around and hope to cut a few limbs along the way, but only expert defenders live to tell of it.",
	"novicemaster_tell_theory_2",[]],
  [trp_trainer,"novicemaster_tell_theory_2", [], "Now. Defending yourself is easiest if you are equipped with a shield.\
 Just block with your shield. [Hold down the right mouse button to defend yourself with the shield.] In this state, you will be able to deflect all attacks that come from your front. However, you will still be open to strikes from your sides or your back.", "novicemaster_tell_theory_3",[]],
  [trp_trainer|plyr,"novicemaster_tell_theory_3", [], "What if I don't have shield?", "novicemaster_tell_theory_4",[]],
  [trp_trainer,"novicemaster_tell_theory_4", [], "Then you will have to use your weapon to block your opponent. This is a bit more difficult than defending with a shield. Defending with a weapon, you can block against only ONE attack direction.\
 That is, you block against either overhead swings, side swings or thrusts. Therefore you must watch your opponent carefully and start to block AFTER he starts his attack. In this way you will be able to block against the direction of his current attack. If you start to block BEFORE he makes his move, he may just attack in another direction than the one you are blocking against and score a hit.", "novicemaster_tell_theory_5",[]],
  [trp_trainer|plyr,"novicemaster_tell_theory_5", [], "What about attacking?", "novicemaster_tell_theory_6",[]],
  [trp_trainer,"novicemaster_tell_theory_6", [], "The most important thing about attacking is maintaing your control and fighting calmly... [Basically pressing and holding down the left mouse button readies an attack and releasing the left mouse button starts the attack.]", "novicemaster_tell_theory_7",[]],
  [trp_trainer,"novicemaster_tell_theory_7", [], "After all this talking, you must be anxious to fight eh?", "novicemaster_talk",[]],
 
  [trp_trainer,"start", [[neq,"$waiting_for_training_fight_result"],[neq,"$training_fight_won"]],
 "That was a good fight. ", "novicemaster_enter_fight",[[val_add,"$num_opponents_to_beat_in_a_row",-1],[assign,"$waiting_for_training_fight_result"]]],
  [trp_trainer,"start", [[neq,"$waiting_for_training_fight_result"]],
 "Ha! Looks like you've developed a bit of a limp there. Don't worry, even losses have their value, provided you learn from them. Shake the stars out of your eyes and get back in there. There's no other way to win.", "novicemaster_enter_fight",[[assign,"$num_opponents_to_beat_in_a_row",3],[assign,"$waiting_for_training_fight_result"]]],
  [trp_trainer,"start", [], "Hello {playername}. Ready for more training?", "novicemaster_talk",[]],
#  [trainer,"novicemaster_pre_talk", [], "Yes?", "novicemaster_talk",[]],
  [trp_trainer|plyr,"novicemaster_talk", [], "Yes, training is what I need.", "novicemaster_enter_fight",[]],
  [trp_trainer|plyr,"novicemaster_talk", [], "Before that, can you go over the basics of combat once again?", "novicemaster_tell_theory",[]],
  [trp_trainer|plyr,"novicemaster_talk", [], "I need to leave now. I'll train another time.", "novicemaster_not_ready",[]],

  [trp_trainer,"novicemaster_enter_fight", [[eq,"$training_system_explained"]],
 "The training has four tiers, each tougher than the one before.\
 To finish a tier and advance to the next one, you have to win three fights in a row. Good luck.", "novicemaster_enter_fight",[[assign,"$training_system_explained",1]]],
  [trp_trainer,"novicemaster_enter_fight",
   [[ge,"$novice_training_difficulty",4]],
 "You have passed all stages of training. But if you want you can still practice. Are you ready?", "novicemaster_are_you_ready",
   [[assign,"$num_opponents_to_beat_in_a_row",9999]]],
  [trp_trainer,"novicemaster_enter_fight",
   [[eq,"$num_opponents_to_beat_in_a_row",0],[eq,"$novice_training_difficulty",0]],
 "Way to go {lad/lass}. With this victory, you have advanced to the next training level. From now on your opponents will be regular fighters, not the riff-raff off the street, so be on your toes.",
   "novicemaster_enter_fight",
   [[assign,"$num_opponents_to_beat_in_a_row",3],
    [val_add,"$novice_training_difficulty",1],
    [add_xp_to_troop,100],
    [assign,"$novicemaster_opponent_troop","trp_regular_fighter"]]],
  [trp_trainer,"novicemaster_enter_fight",
   [[eq,"$num_opponents_to_beat_in_a_row",0],[eq,"$novice_training_difficulty",1]],
 "Way to go {lad/lass}. Welcome to the third training level. From now on your opponents will be veteran fighters; soldiers and arena regulars and the like. These guys know some dirty tricks, so keep your defense up.",
   "novicemaster_enter_fight",
   [[assign,"$num_opponents_to_beat_in_a_row",3],
    [val_add,"$novice_training_difficulty",1],
    [add_xp_to_troop,100],
    [assign,"$novicemaster_opponent_troop","trp_veteran_fighter"]]],
  [trp_trainer,"novicemaster_enter_fight",
   [[eq,"$num_opponents_to_beat_in_a_row",0],[eq,"$novice_training_difficulty",2]],
 "You've got the heart of a champion, {lad/lass}, and the sword arm to match. From now on your opponents will be champion fighters.\
 These are the cream of crop, the best soldiers and arena title-holders Zendar has to offer. If you can best three of them in a row, you will join their ranks.",
   "novicemaster_enter_fight",
   [[assign,"$num_opponents_to_beat_in_a_row",3],
    [val_add,"$novice_training_difficulty",1],
    [add_xp_to_troop,100],
    [assign,"$novicemaster_opponent_troop","trp_champion_fighter"]]],
  [trp_trainer,"novicemaster_enter_fight",
   [[eq,"$num_opponents_to_beat_in_a_row",0],[eq,"$novice_training_difficulty",3]],
 "It does my heart good to see such a promising talent. You have passed all tiers of training. You can now tell everyone that you have been trained by the trainer of Zendar.",
   "novicemaster_finish_training",
   [[assign,"$num_opponents_to_beat_in_a_row",3],
    [val_add,"$novice_training_difficulty",1],
    [add_xp_to_troop,300]]],
  [trp_trainer|plyr,"novicemaster_finish_training", [], "Thank you master.", "novicemaster_finish_training_2",[]],
  [trp_trainer,"novicemaster_finish_training_2", [], "I wish you good luck in the tournaments. And, don't forget,\
  if you want to practice your swordwork anytime, just come and say the word.", "close_window",[]],
  [trp_trainer,"novicemaster_enter_fight",
   [[assign,reg(8),"$num_opponents_to_beat_in_a_row"],[assign,reg(9),"$novicemaster_opponent_troop"],[str_store_troop_name,9,reg(9)]],
 "Your next opponent will be a {s9}. You need to win {reg8} more\
 fights in a row to advance to the next tier. Are you ready?", "novicemaster_are_you_ready",
   []],
  [trp_trainer|plyr,"novicemaster_are_you_ready", [], "Yes I am.", "novicemaster_ready_to_fight",[]],
  [trp_trainer,"novicemaster_ready_to_fight",
   [[assign,reg(9),"$novicemaster_opponent_troop"]], "Here you go then. Good luck.", "close_window",
   [[assign,"$training_fight_won",0],
    [assign,"$waiting_for_training_fight_result",1],
    [modify_visitors_at_site,"scn_novice_ground"],[reset_visitors],
#    [store_shuffled_range,4],
    [assign,reg(0),0],
    [assign,reg(1),1],
    [assign,reg(2),2],
    [assign,reg(3),3],
    [shuffle_range,0,4],
    [set_visitor,reg(0),0],
    [set_visitor,reg(1),reg(9)],
    [set_jump_mission,"mt_zendar_training_fight"],
    [jump_to_scene,"scn_novice_ground"]]],

  [trp_trainer|plyr,"novicemaster_are_you_ready", [], "Just a minute. I am not ready yet.", "novicemaster_not_ready",[]],
  [trp_trainer,"novicemaster_not_ready", [], "Hey, You will never make it if you don't practice.", "close_window",[]],


  [trp_xerina|plyr,"start", [[eq,"$xerina_introduced"]], "Hello. You are one of the fighters in the games aren't you?", "xerina_introduce",[[assign,"$xerina_introduced",1]]],
  [trp_xerina,"xerina_introduce", [], "Yes. I am Xerina.", "xerina_introduce_2",[]],
  [trp_xerina|plyr,"xerina_introduce_2", [], "I am surprised to see {a/another} woman in the tournaments. It seems to be a men's game.", "xerina_introduce_3",[]],
  [trp_xerina,"xerina_introduce_3", [], "Men's game? I beat the hell out of the men out there {/sweetie}. And the spectators love me for it.", "xerina_introduce_4",[]],
  [trp_xerina|plyr,"xerina_introduce_4", [], "But aren't you worried that you will get injured, or worse killed?", "xerina_introduce_5",[]],
  [trp_xerina,"xerina_introduce_5", [], "The tournament fights are not so dangerous if you do things right.\
 There are physicians that take care of your wounds after the fight, and of course the weapons used are not lethal.\
 They deliver blunt damage only.", "xerina_introduce_6",[]],
  [trp_xerina|plyr,"xerina_introduce_6", [], "Blunt damage? What is that?", "xerina_introduce_7",[]],
  [trp_xerina,"xerina_introduce_7", [], "Weapon damage has three different kinds: Cut, pierce and blunt.\
 Weapons like axes and sabres deliver cut damage. Cutting weapons are the most basic and common.\
 Weapons like spears and lances deliver piercing damage.\
 Piercing damage is more effective against armor than cut damage.\
 Lastly, weapons like clubs deliver blunt damage. Blunt damage will knock an opponent unconscious rather than killing him, which is useful if you have need of him after a fight.\
 Some weapons deliver different kinds of damage with different kind of attacks.\
 For example a long sword will deliver piercing damage when thrust but cut damage when swung.", "xerina_introduce_8",[]],
  [trp_xerina|plyr,"xerina_introduce_8", [], "That was quite helpful. Thanks.", "xerina_introduce_9",[]],
  [trp_xerina,"xerina_introduce_9", [], "See you on the tournament ground. And good luck.\
 You will need it if you face me.", "close_window",[]],

  [trp_xerina,"start",[],"Hello {playername}.","xerina_talk",[]],
  [trp_xerina|plyr,"xerina_talk", [], "Can you repeat what you told me about damage types?", "xerina_introduce_7",[]],
  [trp_xerina|plyr,"xerina_talk", [], "I have to leave now. Good luck to you in the games.", "close_window",[]],

  [trp_dranton,"start",[],"Leave me alone.","close_window",[]],

  [trp_kradus|plyr,"start", [[eq,"$kradus_introduced"]], "Hello. You must be one of the fighters in the games.", "kradus_introduce",[[assign,"$kradus_introduced",1]]],
  [trp_kradus,"kradus_introduce", [], "One of the fighters? I am Kradus. Don't tell me you don't know my name.", "kradus_introduce_2",[]],
  [trp_kradus|plyr,"kradus_introduce_2", [], "Have you been fighting in the tournaments for long?", "kradus_introduce_3",[]],
  [trp_kradus,"kradus_introduce_3", [], "Long? I was a champion when the arena was nothing more than a ring of dirt, and your only spectators were the sorry-looking horses waiting their turn.", "kradus_introduce_4",[]],
  [trp_kradus|plyr,"kradus_introduce_4", [], "Could you give me a few hints about fighting?", "kradus_introduce_5",[]],
  [trp_kradus,"kradus_introduce_5", [], "I suppose there would be no harm in that. After all, what is a champion when there are no decent challengers? My favourite weapon is the lance. Give me a lance and the match is over before it starts. Want to know why?", "kradus_introduce_6",[]],
  [trp_kradus|plyr,"kradus_introduce_6", [], "Sure.", "kradus_introduce_7",[]],
  [trp_kradus,"kradus_introduce_7", [], "The lance is a purely offensive weapon. You can't use it for blocking enemy attacks, but in the right hands, they won't have a chance to swing anyway,\
 as it has a longer reach than any other weapon.\
 The best way to use the lance though is couching it under your arm while charging on horse back.\
 Once your horse gains speed in this state, its full power concentrates on the tip of the lance.\
 Nothing will stand before the destructive power of the couched lance. It will pierce and shatter shields\
 and deliver great damage to anyone unfortunate enough to be on its way.", "kradus_introduce_8",[]],
  [trp_kradus|plyr,"kradus_introduce_8", [], "Sounds powerful indeed. What if you are on the receiving end of the couched lance? What would you do to defend yourself?", "kradus_introduce_9",[]],
  [trp_kradus,"kradus_introduce_9", [], "You cannot block it obviously, neither with a sword nor a shield.\
 The best defense is to stand at a spot where your opponent's horse cannot come to you at a full gallop,\
 like the top of a hill or behind a thick tree. If you are out on the open, the best defensive strategy is to run sideways\
 hoping that your opponent cannot maneuver to hit you.", "kradus_introduce_10",[]],
  [trp_kradus|plyr,"kradus_introduce_10", [], "Well thanks a lot. That was really helpful.", "kradus_introduce_11",[]],
  [trp_kradus,"kradus_introduce_11", [], "Good luck at the tournament ground.", "close_window",[]],

  [trp_kradus,"start", [], "Hello {playername}. I hope you are doing well.", "kradus_talk",[]],
  [trp_kradus|plyr,"kradus_talk", [], "Can you tell me about the couched lance again?", "kradus_introduce_7",[]],
  [trp_kradus|plyr,"kradus_talk", [], "Thanks Kradus. I'll see you later.", "close_window",[]],

##  [party_tpl|pt_peasant,"start", [(eq,"$talk_context",tc_party_encounter)], "Greetings traveller.", "peasant_talk_1",[(play_sound,"snd_encounter_farmers")]],
##  [party_tpl|pt_peasant|plyr,"peasant_talk_1", [[eq,"$quest_accepted_zendar_river_pirates"]], "Greetings to you too.", "close_window",[(assign, "$g_leave_encounter",1)]],
##  [party_tpl|pt_peasant|plyr,"peasant_talk_1", [[neq,"$quest_accepted_zendar_river_pirates"],[eq,"$peasant_misunderstanding_said"]], "I have been charged with hunting down outlaws in this area...", "peasant_talk_2",[[assign,"$peasant_misunderstanding_said",1]]],
##  [party_tpl|pt_peasant|plyr,"peasant_talk_1", [[neq,"$quest_accepted_zendar_river_pirates"],[neq,"$peasant_misunderstanding_said"]], "Greetings. I am hunting outlaws. Have you seen any around here?", "peasant_talk_2b",[]],
##  [party_tpl|pt_peasant,"peasant_talk_2", [], "I swear to God {sir/madam}. I am not an outlaw... I am just a simple peasant. I am taking my goods to the market, see.", "peasant_talk_3",[]],
##  [party_tpl|pt_peasant|plyr,"peasant_talk_3", [], "I was just going to ask if you saw any outlaws around here.", "peasant_talk_4",[]],
##  [party_tpl|pt_peasant,"peasant_talk_4", [], "Oh... phew... yes, outlaws are everywhere. They are making life miserable for us.\
## I pray to God you will kill them all.", "close_window",[(assign, "$g_leave_encounter",1)]],
##  [party_tpl|pt_peasant,"peasant_talk_2b", [], "Outlaws? They are everywhere. They are making life miserable for us.\
## I pray to God you will kill them all.", "close_window",[(assign, "$g_leave_encounter",1)]],

##  [party_tpl|pt_manhunters,"start", [(eq,"$talk_context",tc_party_encounter)], "You seen any outlaws around here?", "manhunter_talk_b",[]],
##  [party_tpl|pt_manhunters|plyr,"manhunter_talk_b", [], "Yes they went this way an hour ago.", "manhunter_talk_b1",[]],
##  [party_tpl|pt_manhunters,"manhunter_talk_b1", [], "Bastards. Come on boys lets go get them. Thanks a lot friend.", "close_window",[(assign, "$g_leave_encounter",1)]],
##  [party_tpl|pt_manhunters|plyr,"manhunter_talk_b", [], "No. Sorry. Haven't seen any outlaws lately.", "manhunter_talk_b2",[]],
##  [party_tpl|pt_manhunters,"manhunter_talk_b2", [], "Those bastards hide from us like little rats.\
## But we'll get them sooner or later.", "close_window",[(assign, "$g_leave_encounter",1)]],
##
##  [party_tpl|pt_manhunters,"start", [(eq,"$talk_context",tc_party_encounter),[store_character_level,reg(1)],[lt,reg(1),4]], "Halt. We are hunting down outlaws in this region.", "manhunter_talk_1",[]],
##  [party_tpl|pt_manhunters|plyr,"manhunter_talk_1", [], "Good luck to you. Now if you'll excuse me I have to leave.", "manhunter_talk_2",[]],
##  [party_tpl|pt_manhunters,"manhunter_talk_2", [], "Stop right there. How do we know that you are not an outlaw?", "manhunter_talk_3",[]],
##  [party_tpl|pt_manhunters|plyr,"manhunter_talk_3", [[lt,"$manhunter_trial",3]], "Please sir, I am not an outlaw... let me go.", "manhunter_talk_4a",[]],
##  [party_tpl|pt_manhunters,"manhunter_talk_4a", [], "A weasel like you can't possibly be an outlaw. Get lost.", "close_window",[(assign, "$g_leave_encounter",1)]],
##  [party_tpl|pt_manhunters|plyr,"manhunter_talk_3", [[eq,"$manhunter_trial",0]], "How do I know you are not an outlaw yourself?", "manhunter_talk_4b",[]],
##  [party_tpl|pt_manhunters|plyr,"manhunter_talk_3", [[eq,"$manhunter_trial",1]], "How you would know anything is a mystery to me.", "manhunter_talk_4b",[]],
##  [party_tpl|pt_manhunters|plyr,"manhunter_talk_3", [[ge,"$manhunter_trial",2]], "If I were an outlaw, I would be running away from you, right?", "manhunter_talk_4c",[]],
##  [party_tpl|pt_manhunters,"manhunter_talk_4b", [], "Are you trying to be smart with me? That's a big mistake. Boys, the {man/girl} is an outlaw. Kill {him/her}.", "close_window",[[add_xp_to_troop,100],[val_add,"$manhunter_trial",1],[encounter_attack]]],
##  [party_tpl|pt_manhunters,"manhunter_talk_4c", [], "Yeah... right. Outlaws run away from us like mad. You can't possibly be an outlaw. Sorry to disturb you friend. You may go.", "close_window",[[val_add,"$manhunter_trial",1],(assign, "$g_leave_encounter",1)]],

  [party_tpl|pt_river_pirates,"start", [(eq,"$talk_context",tc_party_encounter)], "I will have your valuables, or your life. Your choice.", "river_pirates_1",[(play_sound,"snd_encounter_river_pirates")]],
  [party_tpl|pt_river_pirates|plyr,"river_pirates_1", [[store_character_level,reg(1)],[lt,reg(1),4]], "I am not afraid of you. I will fight.", "close_window",
   [[encounter_attack]]],
  [party_tpl|pt_river_pirates|plyr,"river_pirates_1", [[store_character_level,reg(1)],[ge,reg(1),4]], "You will have nothing of mine. Except the tip of my sword... in your heart.", "close_window",
   [[encounter_attack]]],

#diaochan
  [trp_diaochan,"start", [[eq,"$diaochan_introduced",0]], "The woman in the front of you is such a beauty.", "diaochan_introduce",[[assign,"$diaochan_introduced",1]]],
  [trp_diaochan|plyr,"diaochan_introduce", [], "Tell me,why do such a beauty stay in this traven lonely?", "diaochan_introduce_1",[]],
  [trp_diaochan,"diaochan_introduce_1", [], "The life in this era is full of blood and intrigue, either is so dangerous hfor a woman.", "diaochan_introduce_2",[]],
  [trp_diaochan|plyr,"diaochan_introduce_2", [], "I see...", "close_window",[]],
  [trp_diaochan|plyr,"diaochan_introduce_2", [], "To waste your life in such a meanless way? I am the man you can trust in, come with me and let the world know your beauty.", "diaochan_introduce_3",[]],
  [trp_diaochan,"diaochan_introduce_3", [(try_begin),
                                          (ge,"$p_s",1),
                                          (assign,":ch",15),
                                          (assign,"$sw",350),
                                         (else_try),
                                          (ge,"$p_s",2),
                                          (assign,":ch",10),
                                          (assign,"$sw",250),
                                         (else_try),
                                          (assign,":ch",20),
                                          (assign,"$sw",500),
                                         (try_end),
                                         (store_attribute_level,":charm","trp_player", ca_charisma),
                                         (ge,"$quest_prestige","$sw"),
                                         (ge,":charm",":ch"),], "Maybe,please tell me what do you seek in this era, my lord.", "diaochan_introduce_4",[]],
  [trp_diaochan,"diaochan_introduce_3", [], "Sorry, I don't think I can rely on you.", "close_window",[]],
  [trp_diaochan|plyr,"diaochan_introduce_4", [], "For peace", "diaochan_introduce_5",[]],
  [trp_diaochan|plyr,"diaochan_introduce_4", [], "For fame", "diaochan_introduce_5",[]],
  [trp_diaochan|plyr,"diaochan_introduce_4", [], "I follow the path of the era", "diaochan_introduce_6",[]],
  [trp_diaochan,"diaochan_introduce_5", [], "Sorry, I don't think I can rely on you.", "close_window",[(assign,"$diaochan_refuse",1),]],
  [trp_diaochan,"diaochan_introduce_6", [(store_num_free_stacks,reg(0),"p_main_party"),(gt,reg(0),0)], "Maybe you are the man I am searching for.", "close_window",[(store_conversation_troop,reg5),(troop_join,reg5),(remove_troop_from_site,reg5),(val_sub,"$quest_prestige","$sw"),(assign,"$diaochan_join",2)]],
  [trp_diaochan,"diaochan_introduce_6", [(store_num_free_stacks,reg(0),"p_main_party"),(eq,reg(0),0)], "There is no space for me.", "close_window",[(assign,"$diaochan_join",1)]],
  [trp_diaochan,"start", [(eq,"$diaochan_join",1),(store_num_free_stacks,reg(0),"p_main_party"),(gt,reg(0),0)], "I will join you.", "close_window",[(store_conversation_troop,reg5),(troop_join,reg5),(remove_troop_from_site,reg5),(val_sub,"$quest_prestige","$sw"),(assign,"$diaochan_join",2)]],
  [trp_diaochan,"start", [(eq,"$diaochan_join",1),(store_num_free_stacks,reg(0),"p_main_party"),(eq,reg(0),0)], "There is no space for me.", "close_window",[(assign,"$diaochan_join",1)]],
  [trp_diaochan,"start", [(eq,"$diaochan_refuse",1)], "I have nothing to tell you, maybe I can dance for you, my lord.", "close_window",[]],
  [trp_diaochan,"start", [(neq,"$diaochan_refuse",1),(eq,"$diaochan_join",0)], "Yes, my lord.", "diaochan_introduce_1",[]],
  [trp_diaochan,"start", [(eq,"$diaochan_join",2)], "I will back soon.", "close_window",[]],

#lvbu
  [trp_lvbu,"start", [[eq,"$lvbu_introduced",0]], "Hey there, do you want some wine?", "lvbu_introduce",[[assign,"$lvbu_introduced",1]]],
  [trp_lvbu|plyr,"lvbu_introduce", [], "Why not", "lvbu_introduce_1",[]],
  [trp_lvbu,"lvbu_introduce_1", [], "Sit down and take this, you are seeking for chance in the war,aren't you?", "lvbu_introduce_2",[]],
  [trp_lvbu|plyr,"lvbu_introduce_2", [], "Surely, just like what you do in the past.", "lvbu_introduce_3",[]],
  [trp_lvbu,"lvbu_introduce_3", [], "Finally, I haven't absolutely been forgotten. You are right, man, but many people say I am a betryer.", "lvbu_introduce_4",[]],
  [trp_lvbu|plyr,"lvbu_introduce_4", [], "No, I really do not think so.", "lvbu_introduce_5",[]],
  [trp_lvbu|plyr,"lvbu_introduce_4", [(store_attribute_level,":int","trp_player", ca_intelligence),(ge,":int",15)], "Yes, you are, but does that mean any thing?.", "lvbu_introduce_6",[]],
  [trp_lvbu|plyr,"lvbu_introduce_4", [], "I don't have time now.", "close_window",[]],
  [trp_lvbu,"lvbu_introduce_5", [], "No,I am a betryer and I don't like a man with such adulation, get out my sight.","close_window",[(assign,"$lvbu_refuse",1)]],
  [trp_lvbu,"lvbu_introduce_6", [], "What do you mean by that?","lvbu_introduce_7",[]],
  [trp_lvbu|plyr,"lvbu_introduce_7", [], "Instrument means nothing to me, we must seek for our own path to live in the war, I think you are the same", "lvbu_introduce_8",[]],
  [trp_lvbu,"lvbu_introduce_8", [(try_begin),
                                          (ge,"$p_s",1),
                                          (assign,":ch",15),
                                          (assign,"$sw",700),
                                          (assign,":lv",22),
                                         (else_try),
                                          (ge,"$p_s",2),
                                          (assign,":ch",18),
                                          (assign,"$sw",500),
                                          (assign,":lv",20),
                                         (else_try),
                                          (assign,":ch",20),
                                          (assign,"$sw",1000),
                                          (assign,":lv",25),
                                         (try_end),
                                         (store_attribute_level,":charm","trp_player", ca_charisma),
                                         (store_character_level,":level","trp_player"),
                                         (ge,"$quest_prestige","$sw"),
                                         (ge,":charm",":ch"),
                                         (ge,":level",":lv"),], "Yeah, seems we are the same type of person.I really want to see what we can do if we put our power together.", "lvbu_introduce_9",[]],
  [trp_lvbu,"lvbu_introduce_8", [], "It seems you are not strong enough, come back when you have enough power.","close_window",[]],
  [trp_lvbu|plyr,"lvbu_introduce_9", [], "I am looking for it.", "lvbu_introduce_10",[]],
  [trp_lvbu,"lvbu_introduce_10", [(store_num_free_stacks,reg(0),"p_main_party"),(gt,reg(0),0)], "Let's go.","close_window",[(store_conversation_troop,reg5),(troop_join,reg5),(remove_troop_from_site,reg5),(val_sub,"$quest_prestige","$sw"),(assign,"$lvbu_join",2)]],
  [trp_lvbu,"lvbu_introduce_10", [(store_num_free_stacks,reg(0),"p_main_party"),(eq,reg(0),0)], "You should get rid of some stupid.","close_window",[(assign,"$lvbu_join",1)]],
  [trp_lvbu,"start", [(eq,"$lvbu_join",1),(store_num_free_stacks,reg(0),"p_main_party"),(gt,reg(0),0)], "Let's go.", "close_window",[(store_conversation_troop,reg5),(troop_join,reg5),(remove_troop_from_site,reg5),(val_sub,"$quest_prestige","$sw"),(assign,"$lvbu_join",2)]],
  [trp_lvbu,"start", [(eq,"$lvbu_join",1),(store_num_free_stacks,reg(0),"p_main_party"),(eq,reg(0),0)], "You should ge rid of some stupid.", "close_window",[]],
  [trp_lvbu,"start", [(eq,"$lvbu_refuse",1)], "No,I am a betryer and I don't like a man with such adulation, get out my sight.", "close_window",[]],
  [trp_lvbu,"start", [(neq,"$lvbu_refuse",1),(eq,"$lvbu_join",0)], "You come back.", "lvbu_introduce_1",[]],
  [trp_lvbu,"start", [(eq,"$lvbu_join",2)], "Don't waste time.", "close_window",[]],


#NPCNPC
[anyone,"start",[(store_conversation_troop, reg5),(ge,reg5,npcnpc_begin),(lt,reg5,npcnpc_end),(neg|main_party_has_troop,reg5),],"My time has gone,now i can only drink in the poor inn.","npc_talk_join",[]],
[anyone|plyr,"npc_talk_join",[],"Bye.","close_window",[]],
[anyone|plyr,"npc_talk_join",[],"Now there is a new chance for you,let the world know you again.","npc_talk_join_3",[]],
[anyone,"npc_talk_join_3",[(try_begin),
                                          (ge,"$p_s",1),
                                          (assign,"$sw",350),
                                         (else_try),
                                          (ge,"$p_s",2),
                                          (assign,"$sw",250),
                                         (else_try),
                                          (assign,"$sw",500),
                                         (try_end),
                                          (ge,"$quest_prestige","$sw"),(store_num_free_stacks,reg(0),"p_main_party"),(gt,reg(0),0)],"You are right, I trust we can do great work together.","close_window",[(store_conversation_troop,reg5),(troop_join,reg5),
(remove_troop_from_site,reg5),(val_sub,"$quest_prestige","$sw")]],
[anyone,"npc_talk_join_3",[(lt,"$quest_prestige","$sw")],"No, I don't want to work with such a noteless person like you.","close_window",[]],
[anyone,"npc_talk_join_3",[(store_num_free_stacks,reg(0),"p_main_party"),(eq,reg(0),0)],"I would like to, friend. But I am afraid you don't have room for me in your party. Once you make room, let me know. I'm eager to leave this place.","close_window",[]],
[anyone,"start",[(eq, "$talk_context", tc_tavern_talk),(store_conversation_troop, reg5),
                 (troop_is_hero, reg5),(main_party_has_troop,reg5)],"Let's go.","close_window",[]],




##  [trp_kingdom_2_lord_f|plyr,"lord_talk", [[neq,"$borcha_introduced"],[eq,"$borcha_taken_prisoner"]], "About the man in the cell...", "gruham_about_borcha",[]],
##  [anyone,"gruham_about_borcha", [[eq,"$kg_tell_borcha"]],
##   "The prisoner? He's a horse thief. He attempted to steal a pack of my horses, can you believe that?\
## But the fool had been drinking all evening, appearently to build up his courage, and by the time he got to the job, he was pitch drunk.\
## Still he managed to drive the horses out before the guards could close the gate, luckily my men found him passed out under a tree just a few miles off the town.", "gruham_about_borcha_2",[[assign,"$kg_tell_borcha",1]]],
##  [anyone,"gruham_about_borcha", [],
##   "Did you consider my offer?", "gruham_about_borcha_10",[]],
##  [anyone|plyr,"gruham_about_borcha_2", [], "What are you going to do about him?", "gruham_about_borcha_3",[]],
##  [anyone,"gruham_about_borcha_3", [], "Normally I have horse thieves hanged right away, but this one claims that\
## there is a bounty on him in Sargoth and he is wanted alive so that he can be fittingly beaten and tortured before\
## the final punishment. Well in that case hanging him here could harm justice in Sargoth. One could think he made up\
## that story to buy himself a few more days, but of course, a simple horse thief like him can't be making up such elaborate lies.", "gruham_about_borcha_4",[]],
##  [anyone|plyr,"gruham_about_borcha_4", [], "Of course... How much did he say the reward is?", "gruham_about_borcha_5",[]],
##  [anyone,"gruham_about_borcha_5", [], "200 denars. But I cannot send him over to Sargoth myself.\
## We are, after all, at war with the Swadians.\
## Speaking of which, maybe an adventurer like you can help me with him...", "gruham_about_borcha_6",[]],
##  [anyone|plyr,"gruham_about_borcha_6", [], "Me?", "gruham_about_borcha_7",[]],
##  [anyone,"gruham_about_borcha_7", [], "Well, you could take him to Sargoth and claim his bounty.\
## You pay me just 100 denars now for the trouble I have taken and you can keep the bounty money for yourself.\
## You would see that the justice is served and make a nice profit off it along the way.", "gruham_about_borcha_8",[]],
##  [anyone|plyr,"gruham_about_borcha_8", [], "I really don't know.", "gruham_about_borcha_9",[]],
##  [anyone,"gruham_about_borcha_9", [], "All right. just pay me 50, but that's my final offer.", "gruham_about_borcha_10",[]],
##  [anyone|plyr,"gruham_about_borcha_10", [], "Let me think about this for a while.", "gruham_about_borcha_think",[]],
##  [anyone|plyr,"gruham_about_borcha_10", [], "All right, I accept your offer.", "gruham_about_borcha_11", []],
##  [anyone,"gruham_about_borcha_11", [[store_troop_gold,reg(0)],[lt,reg(0),50]], "Hmm. But you don't have 50 denars do you?\
## Why don't you go earn some money? Perhaps you could try catching a few outlaws.", "close_window",[]],
##  [anyone,"gruham_about_borcha_11", [[neg|hero_can_join_as_prisoner]], "Hmm. But you cannot manage any more prisoners at the moment.\
## Perhaps you should work on your prisoner management skill. Anyway, talk to me again when you have solved this.", "close_window",[]],
##  [anyone,"gruham_about_borcha_11", [], "Excellent. I will keep the thief for you until you leave. And be careful on the way.", "close_window",
##   [[troop_remove_gold, "trp_player",50],[assign,"$borcha_taken_prisoner",1],[troop_join_as_prisoner,"trp_borcha"],[remove_troop_from_site,"trp_borcha"]]],
##  [anyone,"gruham_about_borcha_think", [], "It's your call. I'll wait, but don't be surprised if someone else takes up this opportunity in the meantime.", "close_window",[]],
##
##  [trp_borcha,"start", [(eq,"$borcha_freed",1),
##                        (neg|main_party_has_troop,"trp_borcha"),
##                        (neq, "$g_encountered_party", "p_four_ways_inn"),],
##   "Do you want me to rejoin you?", "member_wilderness_talk",[]],
##  [trp_borcha,"start", [(neg|main_party_has_troop,"trp_borcha"),(eq, "$g_encountered_party", "p_four_ways_inn")], "Do you want me to rejoin you?", "member_inn_talk",[]],
##  [trp_borcha,"member_separate_inn", [], "I don't know what you will do without me, but you are the boss. I'll wait for you at the Four Ways inn.", "close_window",
##   [[store_conversation_troop,reg(0)],[remove_member_from_party,reg(0)],[add_troop_to_site, reg(0), "scn_four_ways_inn", borcha_inn_entry]]],
##
##  [trp_borcha,"start", [[eq,"$borcha_introduced"]], "Hello young master. Do you have anything to eat? The guards here think I can live on cold water alone.", "borcha_introduce_1",[[assign,"$borcha_introduced",1]]],
##  [trp_borcha|plyr,"borcha_introduce_1", [], "What crime did you accomplish to end up here?", "borcha_introduce_2",[]],
##  [trp_borcha,"borcha_introduce_2", [], "Crime? I didn't do any crime... The Count's horses looked fat and in need of exercise, so I decided to take them for a ride. Just to put them back into shape a little. But the soldiers caught me and locked me up here.", "borcha_introduce_3",[]],
##  [trp_borcha|plyr,"borcha_introduce_3", [], "Ah, they must have mistaken you for a horse thief.", "borcha_introduce_4",[]],
##  [trp_borcha,"borcha_introduce_4", [], "Yes, it must be that... Well I am sure they will understand their mistake soon.", "borcha_introduce_5",[]],
##  [trp_borcha|plyr,"borcha_introduce_5", [], "Yes, I'm sure they will.", "close_window",[]],
##  [trp_borcha,"start", [], "Yes?", "borcha_cell_talk",[]],
##  [trp_borcha|plyr,"borcha_cell_talk", [], "Nothing. Good-bye.", "close_window",[]],
##
##  [trp_borcha,"event_triggered", [[neq,"$borcha_arrive_sargoth_as_prisoner"]], "Eh, we have arrived at Sargoth.", "borcha_arrive_sargoth",[[assign,"$borcha_arrive_sargoth_as_prisoner"]]],
##  [trp_borcha|plyr,"borcha_arrive_sargoth", [], "Yes it's time to hand you to the authorities and collect my bounty money.", "borcha_arrive_sargoth_2",[]],
##  [trp_borcha,"borcha_arrive_sargoth_2", [], "Boss, I thought you would have let go of the bounty money by now.", "borcha_arrive_sargoth_3",[]],
##  [trp_borcha|plyr,"borcha_arrive_sargoth_3", [], "Let go of it? Is there a prize on your head in Sargoth or is there not?", "borcha_arrive_sargoth_4",[]],
##  [trp_borcha,"borcha_arrive_sargoth_4", [], "I don't know... There has been a long time. Maybe the authorities have forgetten about it.", "borcha_arrive_sargoth_5",[]],
##  [trp_borcha|plyr,"borcha_arrive_sargoth_5", [], "You lying bastard! There was no prize on your head wasn't it. You were making it all up to save your neck you rotten lying thief!", "borcha_arrive_sargoth_6",[]],
##  [trp_borcha,"borcha_arrive_sargoth_6", [], "Calm down boss.", "borcha_arrive_sargoth_7",[]],
##  [trp_borcha|plyr,"borcha_arrive_sargoth_7", [], "Calm down! I lost 100 denars because of you!", "borcha_arrive_sargoth_8",[]],
##  [trp_borcha,"borcha_arrive_sargoth_8", [], "It was just 50. And I can make it up to you. Just take me in your service, give me a chance to repay my debt.", "borcha_prisoner_34",[]],
##
##  [trp_borcha,"event_triggered", [[eq,"$borcha_asked_for_freedom"]], "Hey boss.", "borcha_prisoner_1",[]],
##  [trp_borcha|plyr,"borcha_prisoner_1", [], "I'm not your boss. Now what is it?", "borcha_prisoner_2",[[assign,"$borcha_asked_for_freedom",1]]],
##  [trp_borcha,"borcha_prisoner_2", [], "I was thinking... these mountains are dangerous. Why don't you give me a sword or a knife. I would guard your back.", "borcha_prisoner_3",[]],
##  [trp_borcha|plyr,"borcha_prisoner_3", [], "Guard my back? You would stab me the moment I turned my back to you.", "borcha_prisoner_4",[]],
##  [trp_borcha,"borcha_prisoner_4", [], "Ah, come on now. You saved me from that stinking cell in Rivacheg.\
## Do you think I would repay you like that. I am trying to look out for you.", "borcha_prisoner_5",[]],
##  [trp_borcha|plyr,"borcha_prisoner_5", [], "Well keep doing that. I will deliver you to Sargoth where you will be hanged as you deserve and I will get my bounty money.", "borcha_prisoner_6",[]],
##  [trp_borcha,"borcha_prisoner_6", [], "Oh the bounty money... Yes.", "borcha_prisoner_7",[]],
##  [trp_borcha|plyr,"borcha_prisoner_7", [], "What? Is that a lie too. I can take you right back to Rivacheg if it is.", "borcha_prisoner_8",[]],
##  [trp_borcha,"borcha_prisoner_8", [], "Of course it is not a lie. What do you take me for?... Just.. if it is gold you are after, I can help you make much more than the bounty money.", "borcha_prisoner_9",[]],
##  [trp_borcha|plyr,"borcha_prisoner_9", [], "Yes yes. I am sure you are now planning to steal half of the horses in Calradia, but no thanks, I am not interested.", "borcha_prisoner_10",[]],
##  [trp_borcha,"borcha_prisoner_10", [], "Horses? Who is talking about stealing horses? We could do much bigger things. I know all the paths and shortcuts in these lands. Think of it, you and me together, we could get ourselves a band and...", "borcha_prisoner_11",[]],
##  [trp_borcha|plyr,"borcha_prisoner_11", [], "Ho, slow down there. We are not getting ourselves a band or anything.\
## We will go Sargoth and you will get hanged and that's it.", "borcha_prisoner_12",[]],
##  [trp_borcha,"borcha_prisoner_12", [], "Well then. It's your call. We could become rich. But instead you will walk right into a bandit's trap without a scout's lead, and we will both end up dead. Some barren cliff will be our grave.", "borcha_prisoner_13",[]],
##  [trp_borcha|plyr,"borcha_prisoner_13", [], "Thanks for the cheerful talk. Now shut up. I have enough things to worry about without you blattering.", "close_window",[]],
##
##  [trp_borcha,"event_triggered", [], "Yes boss.", "borcha_prisoner_30",[]],
##  [trp_borcha|plyr,"borcha_prisoner_30", [], "Are you really that good at scouting?", "borcha_prisoner_31",[]],
##  [trp_borcha,"borcha_prisoner_31", [], "Damned good at it. I can smell the wind, read the movements of the birds.\
## I can tell what a man was thinking about by merely glancing at the tracks he left.\
## And I can teach you too.", "borcha_prisoner_32",[]],
##  [trp_borcha|plyr,"borcha_prisoner_32", [], "No kidding.", "borcha_prisoner_33",[]],
##  [trp_borcha,"borcha_prisoner_33", [], "Come on boss. A tough {man/woman} like you and a master scout like me.\
## We could do anything. This land is full of opportunities.", "borcha_prisoner_34",[]],
##  [trp_borcha|plyr,"borcha_prisoner_34", [], "[Set him free]", "borcha_prisoner_34a",[]],
##  [trp_borcha|plyr,"borcha_prisoner_34a", [], "All right, I'll give you a try. But try to do anything stupid and you'll find yourself at the hanging post before you know it.", "borcha_prisoner_set_free",[]],
##  [trp_borcha,"borcha_prisoner_set_free", [(neg|hero_can_join)], "Darn, you can't lead any more troops at the moment boss. But don't forget your promise. Just make some room at the party for me and tell me when you are ready.", "close_window",[]],
##  [trp_borcha,"borcha_prisoner_set_free", [], "Thank you boss, you won't regret this.", "close_window",
##   [(remove_member_from_party,"trp_borcha"),(troop_join,"trp_borcha"),(assign,"$borcha_freed",1)]],
##  [trp_borcha|plyr,"borcha_prisoner_34", [], "[Forget it]", "borcha_prisoner_34b",[]],
##  [trp_borcha|plyr,"borcha_prisoner_34b", [], "You almost made me believe your foolish lies. Now shut up and keep walking.", "close_window",[]],
##
##  [trp_borcha,"prisoner_chat", [], "Yes boss.", "borcha_prisoner_talk",[]],
##  [trp_borcha|plyr,"borcha_prisoner_talk", [[neq,"$borcha_asked_for_freedom"],[eq,"$borcha_freed"]],
##   "Are you really that good at scouting?", "borcha_prisoner_31",[]],
##
##
##  [trp_borcha|plyr,"borcha_prisoner_talk", [], "It's nothing. Keep walking.", "close_window",[]],

#  [trp_ymira,"start", [[eq,"$ymira_introduced",0]], "Please {sir/madam}, you must help me! They are going to kill me if you don't!", "ymira_introduce_1",
#   [[assign,"$ymira_introduced",1]]],
#  [trp_ymira|plyr,"ymira_introduce_1", [], "Easy now. Noone can harm you as long as I am here.", "ymira_introduce_2a",[]],
#  [trp_ymira,"ymira_introduce_2a", [], "Oh, is that true? God bless you {sir/madam}...", "ymira_introduce_2a_1",[]],
#  [trp_ymira|plyr,"ymira_introduce_2a_1", [], "Now calm down and tell me who's after you.", "ymira_introduce_2a_2",[]],
#  [trp_ymira,"ymira_introduce_2a_2", [], "I don't know... bad men... please let me come with you...", "ymira_introduce_2a_3",[]],
#  [trp_ymira|plyr,"ymira_introduce_2a_3", [], "What? Do you want to join my party?", "ymira_introduce_8",[]],
#  [trp_ymira,"ymira_introduce_8", [], "Please, let me come with you {sir/madam}.\
# I will look after your horses, I will wash your clothes... I work very had... and I eat very little...\
# Please, You must let me come with you...", "ymira_ask_join",[]],
#  [trp_ymira|plyr,"ymira_ask_join", [], "All right...", "ymira_ask_join_1",[]],
#  [trp_ymira,"ymira_ask_join_1", [], "Oh, thank you...", "ymira_ask_join_2",[]],
#  [trp_ymira|plyr,"ymira_ask_join_2", [[hero_can_join]], "What is your name?", "ymira_ask_join_3",[]],
#  [trp_ymira,"ymira_ask_join_3", [], "Ymira.", "ymira_ask_join_4",[]],
#  [trp_ymira|plyr,"ymira_ask_join_4", [], "Well Ymira. You can come with me for now.\
# I will decide what to do with you later.", "ymira_ask_join_5",[]],
#  [ymira,"ymira_ask_join_5", [], "Oh, God bless you. Thank you, thank you very much.\
# I will work very hard for you. I promise.", "close_window",
#   [[assign,"ymira_joined_party",1],
#    [remove_party,p_frightened_girl],
#    [troop_join,ymira,1]]],
#
#  [trp_ymira|plyr,"ymira_ask_join_2", [[neg|hero_can_join]], "But unfortunately.\
# My party is full at the moment. I can't take anyone else with me. Wait here, I will think of something.", "ymira_join_decline",[]],
#
#  [trp_ymira|plyr,"ymira_ask_join", [], "No way. This is no life for a girl like you.", "ymira_join_decline",[]],
#  [trp_ymira,"ymira_join_decline", [], "Oh no, please don't leave me here...", "close_window",
#   [[party_set_ai_behavior,p_frightened_girl,ai_bhvr_hold]]],
#
#
#  [trp_ymira|plyr,"ymira_introduce_1", [], "Go find some soldiers to protect you. I don't have time for this.", "ymira_introduce_2b",[]],
#  [trp_ymira,"ymira_introduce_2b", [], "But it is the soldiers that are going to kill me.", "ymira_introduce_2b_1",[]],
#  [trp_ymira|plyr,"ymira_introduce_2b_1", [], "I wouldn't want to cross with any soldiers. Get lost now.", "ymira_join_decline",[]],
#  [trp_ymira|plyr,"ymira_introduce_2b_1", [], "You are running from soldiers? In that case...", "ymira_introduce_8",[]],
#
#  [trp_ymira,"start", [], "Do you want me to rejoin you?", "member_wilderness_talk",[]],
#  [trp_ymira,"start", [[neg|main_party_has_troop,"trp_ymira"]], "Do you want me to rejoin you?", "member_inn_talk",[]],
#  [trp_ymira,"member_separate_inn", [], "I don't know what you will do without me, but you are the boss. I'll wait for you at the Four Ways inn.", "close_window",
#   [[store_conversation_troop,reg(0)],[remove_member_from_party,reg(0)],[add_troop_to_site, reg(0), "scn_four_ways_inn", ymira_inn_entry]]],








### COMPANIONS
  [anyone,"start", [(troop_slot_eq,"$g_talk_troop", slot_troop_occupation, slto_player_companion),
                    (party_slot_eq, "$g_encountered_party", slot_party_type, spt_castle),
                    (party_get_num_companion_stacks, ":num_stacks", "$g_encountered_party"),
                    (ge, ":num_stacks", 1),
                    (party_stack_get_troop_id, ":castle_leader", "$g_encountered_party", 0),
                    (eq, ":castle_leader", "$g_talk_troop"),
                    (eq, "$talk_context", 0)],
   "Well {playername}, anything you want me to do?", "member_castellan_talk",[]],
  
  [anyone,"member_castellan_pretalk", [], "Anything else?", "member_castellan_talk",[]],
  
  [anyone|plyr,"member_castellan_talk", [],
   "I want to review the castle garrison.", "member_review_castle_garrison",[]],
  [anyone,"member_review_castle_garrison", [], "Of course...", "member_castellan_pretalk",[(change_screen_exchange_members,0)]],
  [anyone|plyr,"member_castellan_talk", [],
   "Allow me to check out your equipment.", "member_review_castellan_equipment",[]],
  [anyone,"member_review_castellan_equipment", [], "Of course...", "member_castellan_pretalk",[(change_screen_equip_other)]],
  [anyone|plyr,"member_castellan_talk", [],
   "I want you to abandon the castle and join my party.", "member_castellan_join",[]],
  [anyone,"member_castellan_join", [(party_can_join_party,"$g_encountered_party","p_main_party")],
   "It will sadden me to abandon this castle. But if that's your wish...", "close_window", [
       (assign, "$g_move_heroes", 1),
       (call_script, "script_party_add_party", "p_main_party", "$g_encountered_party"),
       (party_clear, "$g_encountered_party"),
       ]],
  [anyone,"member_castellan_join", [],
   "You do not have enough capacity in your party for us {playername}...", "member_castellan_pretalk",[]],
  
  [anyone|plyr,"member_castellan_talk", [], "[Leave]", "close_window",[]],


  [anyone,"start", [(troop_slot_eq,"$g_talk_troop", slot_troop_occupation, slto_player_companion),
                    (neg|main_party_has_troop,"$g_talk_troop"),
                    (eq, "$talk_context", tc_party_encounter)],
   "Do you want me to rejoin you?", "member_wilderness_talk",[]],
  [anyone,"start", [(neg|main_party_has_troop,"$g_talk_troop"),(eq, "$g_encountered_party", "p_four_ways_inn")], "Do you want me to rejoin you?", "member_inn_talk",[]],
#  [anyone,"member_separate_inn", [], "I don't know what you will do without me, but you are the boss. I'll wait for you at the Four Ways inn.", "close_window",
#  [anyone,"member_separate_inn", [], "All right then. I'll meet you at the four ways inn. Good luck.", "close_window",
#   [(remove_member_from_party,"$g_talk_troop", "p_main_party"),(add_troop_to_site, "$g_talk_troop", "scn_four_ways_inn", borcha_inn_entry)]],


  [anyone,"member_chat", [(store_conversation_troop,"$g_talk_troop"),
                          (troop_is_hero,"$g_talk_troop"),], "Yes?", "member_talk",[]],
  [anyone|plyr,"member_talk", [],
   "Let me check out your equipment...", "member_trade",[]],
  
  [anyone|plyr,"member_talk", [],
   "Cancel counsellor", "close_window",[(assign,"$c_rp",0)]],
  [anyone,"member_trade", [], "Of course. Let me see what you have got.", "do_member_trade",[
#      (change_screen_trade)
      (change_screen_equip_other),
      ]],
  [anyone|plyr,"member_talk", [],
   "I want you to be my counsellor.", "member_counsellor",[]],
  [anyone,"member_counsellor", [],
   "As your wish.", "member_chat",[(store_conversation_troop, reg5),
                                   (store_attribute_level,":int",reg5,ca_intelligence),
                                   (store_attribute_level,":p_int","trp_player",ca_intelligence),
                                   (val_sub,":int",":p_int"),
                                   (val_sub,":int",5),
                                   (val_mul,":int",2),
                                   (store_skill_level,":st",skl_stratagem,reg5),
                                   (store_skill_level,":p_st",skl_stratagem,"trp_player"),
                                   (val_sub,":st",":p_st"),
                                   (val_sub,":st",1),
                                   (val_mul,":st",5),
                                   (store_add,"$c_rp",":st",":int")]],
  [anyone,"member_trade", [], "Of course. Let me see what you have got.", "do_member_trade",[
#      (change_screen_trade)
      (change_screen_equip_other),
      ]],
  [anyone,"do_member_trade", [], "Anything else?", "member_talk",[]],
  [anyone|plyr,"member_talk", [], "Tell me about yourself", "view_member_char_requested",[]],
  [anyone,"view_member_char_requested", [], "All right then, listen to this...", "do_member_view_char",[(change_screen_view_character)]],
  [anyone|plyr,"member_talk", [], "We need to separate for a while.", "member_separate",[]],
  [anyone,"member_separate", [], "Separate? All right. What do you want me to do?", "member_separate_2",[]],
#  [anyone|plyr,"member_separate_2", [], "You go and wait for me at Four Ways Inn. I'll find you there.", "member_separate_inn",[]],
#  [anyone,"member_separate_inn", [], "All right then, I'll meet you at the four ways inn. Good luck.", "close_window",
#   [(remove_member_from_party,"$g_talk_troop","p_main_party"),(add_troop_to_site, "$g_talk_troop", "scn_four_ways_inn", 1)]],
  [anyone|plyr,"member_separate_2", [], "Wait for me right here. I will come back for you.", "member_separate_wilderness",[]],
  [anyone,"member_separate_wilderness", [], "All right then, I'll wait for you. Hey. Don't you forget to come back for me.", "close_window",
   [(remove_member_from_party,"$g_talk_troop"),(add_companion_party,"$g_talk_troop")]],
  [anyone|plyr,"member_separate_2", [], "I changed my mind. You keep following me.", "do_member_trade",[]],
  [anyone,"do_member_view_char", [], "Anything else?", "member_talk",[]],
  [anyone|plyr,"member_talk", [], "Nothing. Let us keep riding.", "close_window",[]],

  [anyone|plyr,"member_wilderness_talk", [], "Yes. Follow me.", "member_wilderness_join",[]],
  [anyone,"member_wilderness_join", [(neg|party_can_join)],
   "Alas, I am afraid you do not have enough room in your party for us. Why don't you try again after fixing that?", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone,"member_wilderness_join", [], "Good. I was beginning to get bored.", "close_window",[(party_join),(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"member_wilderness_talk", [], "No. Stay here for a while longer.", "member_wilderness_no_join",[]],
  [anyone,"member_wilderness_no_join", [], "All right. All right. You go and take care of your important business.\
 Don't even think about me. What job have I got in life other than waiting for you in this God forsaken place?", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"member_wilderness_talk", [], "I want to leave some troops with you.", "member_wilderness_leave_troops",[]],
  [anyone,"member_wilderness_leave_troops", [], "Really? Well, you can trust me. I will command them well.", "member_wilderness_leave_troops_2",[(change_screen_exchange_members,0)]],
  [anyone,"member_wilderness_leave_troops_2", [], "We will be waiting for you here. Be careful.", "close_window",[(assign, "$g_leave_encounter",1)]],

  [anyone|plyr,"member_inn_talk", [], "Yes. Let us ride together again.", "member_inn_join",[]],
  [anyone,"member_inn_join", [(neg|hero_can_join)],
   "Darn. I am afraid you do not have enough capacity in your party for me. Why don't you try again after fixing that?", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone,"member_inn_join", [], "Good. I was beginning to get bored.", "close_window",[(troop_join,"$g_talk_troop"),(remove_troop_from_site,"$g_talk_troop"),(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"member_inn_talk", [], "No. Stay here for a while longer.", "member_inn_no_join",[]],
  [anyone,"member_inn_no_join", [], "All right. All right. You go and take care of your important business.\
 Don't even mind about me. What job have I got in life other than waiting for you in some country inn?", "close_window",[(assign, "$g_leave_encounter",1)]],







# Kingdom Lords:
  [anyone,"start", [(eq, "$talk_context", tc_castle_commander)],
   "What do you want?", "player_siege_castle_commander_1", []],
  [anyone|plyr,"player_siege_castle_commander_1", [],
   "Surrender. Your situation is hopeless!", "player_siege_ask_surrender", []],
  [anyone|plyr,"player_siege_castle_commander_1", [], "Nothing. I'll leave you now.", "close_window", []],

  
  [anyone,"player_siege_ask_surrender", [(lt, "$g_enemy_strength", 100), (store_mul,":required_str","$g_enemy_strength",5),(ge, "$g_ally_strength", ":required_str")],
   "Do you give your word that we'll be treated well?", "player_siege_ask_surrender_treatment", []],
  [anyone,"player_siege_ask_surrender", [(lt, "$g_enemy_strength", 200), (store_mul,":required_str","$g_enemy_strength",3),(ge, "$g_ally_strength", ":required_str")],
   "We are ready to leave this castle to you and march away if you give me your word that you'll let us leave unmolested.", "player_siege_ask_leave_unmolested", []],
  [anyone,"player_siege_ask_surrender", [],
   "Surrender? Hah! We can defend this castle until we grow old.", "close_window", []],

  
  [anyone|plyr,"player_siege_ask_surrender_treatment", [],
   "I give you nothing. Surrender now or prepare to die!", "player_siege_ask_surrender_treatment_reject", []],
  [anyone,"player_siege_ask_surrender_treatment_reject", [],
   "Bastard. We will fight you to the last man!", "close_window", []],
  [anyone|plyr,"player_siege_ask_surrender_treatment", [],
   "You will be ransomed and your soldiers will live. I give you my word.", "player_siege_ask_surrender_treatment_accept", []],
  [anyone,"player_siege_ask_surrender_treatment_accept", [],
   "All right then. We surrender.", "close_window", [(assign,"$g_enemy_surrenders",1)]],

  [anyone|plyr,"player_siege_ask_leave_unmolested", [],
   "You have my word. We will not attack you if you leave the castle.", "player_siege_ask_leave_unmolested_accept", []],
  [anyone,"player_siege_ask_leave_unmolested_accept", [],
   "Very well. Then we leave this castle to you. You have won this day. But we'll meet again.", "close_window", [(assign,"$g_castle_left_to_player",1)]],
  [anyone|plyr,"player_siege_ask_leave_unmolested", [],
   "No. That is not acceptable.", "player_siege_ask_leave_unmolested_reject", []],
  [anyone,"player_siege_ask_leave_unmolested_reject", [],
   "Well, in that case we will defend this castle.", "close_window", []],

  
#After battle texts
  
  [anyone,"start", [(eq, "$talk_context", tc_hero_freed),
                      (troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero)],
   "I am in your debt for freeing me friend.", "freed_lord_answer",
   [(troop_set_slot, "$g_talk_troop", slot_troop_is_prisoner, 0)]],

  [anyone|plyr,"freed_lord_answer", [(lt, "$g_talk_troop_faction_relation", 0)],
   "You're not going anywhere. You'll be my prisoner now!", "freed_lord_answer_1",
   [(troop_set_slot, "$g_talk_troop", slot_troop_is_prisoner, 1),
    (party_force_add_prisoners, "p_main_party", "$g_talk_troop", 1),
    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -30),
    (call_script, "script_change_player_relation_with_faction_ex", "$g_talk_troop_faction", -2),
    ]],#take prisoner

  [anyone,"freed_lord_answer_1", [],
   "Darn. Will my luck never turn back...", "close_window", []],

  [anyone|plyr,"freed_lord_answer", [],
   "You are free to go wherever you want, sir.", "freed_lord_answer_2",
   [(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 20),
    (call_script, "script_change_player_honor", 5),
#    (troop_get_slot, ":cur_rank", "$g_talk_troop", slot_troop_kingdom_rank),
#    (val_mul, ":cur_rank", 1),
    (call_script, "script_change_player_relation_with_faction_ex", "$g_talk_troop_faction", 2)]],

  [anyone,"freed_lord_answer_2", [],
   "Thank you friend. I will not forget this. May good fortune be with you.", "close_window",
   []],

##  [anyone|plyr,"freed_lord_answer", [(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"), #he is not a faction leader!
##                                     (call_script, "script_get_number_of_hero_centers", "$g_talk_troop"),
##                                     (eq, reg0, 0), #he has no castles or towns
##                                     (hero_can_join)],
##   "I need capable men like you. Would you like to join me?", "knight_offer_join",
##   []],
##
##  [anyone,"freed_lord_answer_3", [(store_random_in_range, ":random_no",0,2),(eq, ":random_no", 0)],
##   "Alright I will join you.", "close_window",
##   [
###     (troop_set_slot, "$g_talk_troop", slot_troop_is_player_companion, 1),
##     (troop_set_slot, "$g_talk_troop", slot_troop_occupation, slto_player_companion),
##     (store_conversation_troop, ":cur_troop_id"), 
##     (party_add_members, "p_main_party", ":cur_troop_id", 1),#join hero
##   ]],
##
##  [anyone,"freed_lord_answer_3", [],
##   "No, I want to go on my own.", "close_window", []],

  [anyone,"start", [(eq,"$talk_context",tc_hero_defeated),
                    (troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero)],
   "Damn you for defeating me.", "defeat_lord_answer",
   [(troop_set_slot, "$g_talk_troop", slot_troop_leaded_party, -1)]],

  [anyone|plyr,"defeat_lord_answer", [],
   "You are my prisoner now.", "defeat_lord_answer_1",
   [
     (troop_set_slot, "$g_talk_troop", slot_troop_is_prisoner, 1),
     (party_force_add_prisoners, "p_main_party", "$g_talk_troop", 1),#take prisoner
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -10),
#     (troop_get_slot, ":cur_rank", "$g_talk_troop", slot_troop_kingdom_rank),
#     (val_mul, ":cur_rank", -1),
     (call_script, "script_change_player_relation_with_faction_ex", "$g_talk_troop_faction", -3)]],

  [anyone,"defeat_lord_answer_1", [],
   "Damn you. You will regret this.", "close_window", []],

  [anyone|plyr,"defeat_lord_answer", [],
   "You are free to go now. But don't you step in my path again.", "defeat_lord_answer_2",
   [(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 10),
    (call_script, "script_change_player_honor", 5)]],

  [anyone,"defeat_lord_answer_2", [],
   "We will meet again.", "close_window", []],

  [anyone,"start", [(eq,"$talk_context",tc_party_encounter),
                    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
                    (lt,"$g_encountered_party_relation",0),
                    (encountered_party_is_attacker),
                    ],
   "You have no chance against us. Surrender now or we will kill you all...", "party_encounter_lord_hostile_attacker",
   []],
  [anyone|plyr,"party_encounter_lord_hostile_attacker", [
                    ],
   "Don't attack! We surrender.", "close_window", [(assign,"$g_player_surrenders",1)]],
#  [anyone|plyr,"party_encounter_hostile_attacker", [
#                    ],
#   "I will pay you 1000 denars if you just let us go.", "close_window", []],
  [anyone|plyr,"party_encounter_lord_hostile_attacker", [
                    ],
   "We will fight you to the end!", "close_window", []],
  
##  [anyone,"start", [(eq,"$talk_context",tc_party_encounter),
##                    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
##                    (lt,"$g_encountered_party_relation",0),
##                    (neg|encountered_party_is_attacker),
##                    ],
##   "What do you want?", "party_encounter_lord_hostile_defender",
##   []],


#  [anyone|plyr,"party_encounter_lord_hostile_defender", [],
#   "Nothing. We'll leave you in peace.", "close_window", [(assign, "$g_leave_encounter",1)]],



 
#Betrayal texts should go here


##  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
##                     (troop_slot_eq,"$g_talk_troop",slot_troop_last_quest_betrayed, 1),
##                     (troop_slot_eq,"$g_talk_troop",slot_troop_last_quest, "qst_deliver_message_to_lover"),
##                     (le,"$talk_context",tc_siege_commander),
##                     ],
##   "I had trusted that letter to you, thinking you were a {man/lady} of honor, and you handed it directly to the girl's father.\
## I should have known you were not to be trusted. Anyway, I have learned my lesson and I won't make that mistake again.", "close_window",
##   [(call_script, "script_clear_last_quest", "$g_talk_troop")]],


# Events....
# Choose friend.  
  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (neq, "$g_talk_troop_met", 0),
                     (gt, "$g_time_since_last_talk", 24),
                     (gt, "$g_talk_troop_relation", -10),
                     (store_random_in_range, ":random_num", 0, 100),
                     (lt, ":random_num", 100), #TODO: Reduce this to 30
                     (eq,"$talk_context",tc_town_talk),
                     (call_script, "script_cf_troop_get_random_enemy_troop_with_occupation", "$g_talk_troop", slto_kingdom_hero),
                     (assign, ":other_lord",reg0),
                     (troop_get_slot, ":other_lord_relation", ":other_lord", slot_troop_player_relation),
                     (ge, ":other_lord_relation", 20),
                     (str_store_troop_name, s6, ":other_lord"),
                     (assign, "$temp", ":other_lord"),
                     ],
   "I heard that you have befriended that filthy bastard called {s6}.\
 Believe me, you can't trust that man.\
 You should end your dealings with him.", "lord_event_choose_friend", []],

  [anyone|plyr ,"lord_event_choose_friend", [],  "I assure you sir. I am no friend of {s6}.", "lord_event_choose_friend_renounce", [
      (call_script, "script_change_player_relation_with_troop","$g_talk_troop",5),
      (call_script, "script_change_player_relation_with_troop","$temp",-10),
      ]],
  [anyone ,"lord_event_choose_friend_renounce", [],  "Ah. I am happy to hear that.\
 You should be very careful with {s6}. He's worse than a snake.", "lord_pretalk", []],
  
  [anyone|plyr ,"lord_event_choose_friend", [],  "{s6} is an honorable man. You have no right to speak of him thus.", "lord_event_choose_friend_defend", [
      (call_script, "script_change_player_relation_with_troop","$g_talk_troop",-10),
      (call_script, "script_change_player_relation_with_troop","$temp",5),
      ]],
  [anyone ,"lord_event_choose_friend_defend", [],  "Fine. Stay loyal to {s6}. But you are a fool for trusting him.", "lord_pretalk", []],
  
  [anyone|plyr ,"lord_event_choose_friend", [],  "I don't want to be involved in your quarrel with {s6}.", "lord_event_choose_friend_neutral", [
      (call_script, "script_change_player_relation_with_troop","$g_talk_troop",-2),
      (call_script, "script_change_player_relation_with_troop","$temp",-3),
      ]],

  [anyone ,"lord_event_choose_friend_neutral", [],  "All right.\
 But remember {playername}, you must choose your friends wisely.", "lord_pretalk", []],

#Meeting.

  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (eq, "$g_invite_faction_lord", "$g_talk_troop"),
                     ],
   "{playername}, I was expecting you. Are you ready to give me your oath?", "lord_invite_1",  []],
  [anyone|plyr ,"lord_invite_1", [],  "Yes, my lord.", "lord_ask_enter_service",  []],
  [anyone|plyr ,"lord_invite_1", [],  "No sir. I can't serve you right now.", "lord_enter_service_reject",  []],

  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (neq, "$g_talk_troop_met", 0),
                     (gt, "$g_time_since_last_talk", 24),
                     (gt, "$g_talk_troop_relation", 50),
                     (gt, "$g_talk_troop_faction_relation", 10),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "Isn't this my brave champion {playername}...", "lord_start",  []],
  
  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (neq, "$g_talk_troop_met", 0),
                     (gt, "$g_time_since_last_talk", 24),
                     (gt, "$g_talk_troop_relation", 10),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "Good to see you again {playername}...", "lord_start", []],

  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (neq, "$g_talk_troop_met", 0),
                     (gt, "$g_time_since_last_talk", 24),
#                     (lt, "$g_talk_troop_faction_relation", 0),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "So, we meet again {playername}...", "lord_start", []],

  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (eq, "$g_talk_troop_met", 0),
                     (ge, "$g_talk_troop_faction_relation", 0),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "Do I know you?", "lord_meet_neutral", []],
  [anyone|plyr ,"lord_meet_neutral", [],  "I am {playername}.", "lord_start", []],
  [anyone|plyr ,"lord_meet_neutral", [],  "My name is {playername}. At your service sir.", "lord_start", []],

#  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
#                     (eq, "$g_talk_troop_met", 0),
#                     (ge, "$g_talk_troop_faction_relation", 0),
#                     (le,"$talk_context",tc_siege_commander),
#                     ],
#   "Who is this then?", "lord_meet_ally", []],
#  [anyone|plyr ,"lord_meet_ally", [],  "I am {playername} sir. A warrior of {s4}.", "lord_start", []],
#  [anyone|plyr ,"lord_meet_ally", [],  "I am but a soldier of {s4} sir. My name is {playername}.", "lord_start", []],

  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (eq, "$g_talk_troop_met", 0),
                     (lt, "$g_talk_troop_faction_relation", 0),
#                     (str_store_faction_name, s4,  "$players_kingdom"),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "And who the hell are you?", "lord_meet_enemy", []],
  [anyone|plyr ,"lord_meet_enemy", [],  "I am {playername} sir.", "lord_meet_enemy_2", []],  #A warrior of {s4}.
  [anyone|plyr ,"lord_meet_enemy", [],  "They know me as {playername}. Mark it down, because you'll hear of me a lot.", "lord_meet_enemy_2", []],
  [anyone, "lord_meet_enemy_2", [],  "{playername} eh? Never heard of you. What do want?", "lord_talk", []],

  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "Well {playername}...", "lord_start",
   []],


##### TODO: QUESTS COMMENT OUT BEGIN
  
##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_lend_surgeon"),
##                         (quest_slot_eq, "qst_lend_surgeon", slot_quest_giver_troop, "$g_talk_troop")],
##   "Your surgeon convinced my friend and operated upon him. Now it is out of our hands, and all we can do is pray for his recovery.\
## Anyway, I thank you for lending your surgeon to me {sir/madam}. I will not forget your kindness.", "lord_generic_mission_completed",[(call_script, "script_succeed_quest", "qst_lend_surgeon", 100),
##                                                                    (troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],
##
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_bring_prisoners_to_enemy"),
##                         (quest_slot_eq, "qst_bring_prisoners_to_enemy", slot_quest_current_state, 0),
##                         (check_quest_succeeded, "qst_bring_prisoners_to_enemy"),
##                         (quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                         (assign, reg1, ":quest_target_amount")],
##   "TODO: You have brought the prisoners and received {reg1} denars. Give me the money now.", "lord_bring_prisoners_complete_2",[]],
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_bring_prisoners_to_enemy"),
##                         (quest_slot_eq, "qst_bring_prisoners_to_enemy", slot_quest_current_state, 1),#Some of them were brought only
##                         (check_quest_succeeded, "qst_bring_prisoners_to_enemy"),
##                         (quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                         (assign, reg1, ":quest_target_amount")],
##   "TODO: You have brought the prisoners but some of them died during your expedition. Give me the full money of {reg1} denars.", "lord_bring_prisoners_complete_2",[]],
##
##
##  [anyone|plyr,"lord_bring_prisoners_complete_2", [(store_troop_gold, ":cur_gold", "trp_player"),
##                                                   (quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                                                   (ge, ":cur_gold", ":quest_target_amount")],
##   "TODO: Here it is.", "lord_generic_mission_thank", [(quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                                                  (troop_remove_gold, "trp_player", ":quest_target_amount"),
##                                                  (call_script, "script_succeed_quest", "qst_bring_prisoners_to_enemy", 100)]],
##  
##  [anyone|plyr,"lord_bring_prisoners_complete_2", [(store_troop_gold, ":cur_gold", "trp_player"),
##                                                   (quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                                                   (lt, ":cur_gold", ":quest_target_amount")],
##   "TODO: I'm afraid I spent some of it, I don't have that much money with me.", "lord_bring_prisoners_no_money", [(quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                                                                                                                   (call_script, "script_change_debt_to_troop", "$g_talk_troop", ":quest_target_amount"),#Adding the taken money as a debt
##                                                                                                                   (call_script, "script_succeed_quest", "qst_bring_prisoners_to_enemy", 100)]],
##
##  [anyone,"lord_bring_prisoners_no_money", [],
##   "TODO: You owe me that money!", "lord_pretalk", []],
##
##
##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_incriminate_loyal_commander"),
##                         (check_quest_succeeded, "qst_incriminate_loyal_commander"),
##                         (quest_get_slot, ":quest_target_troop", "qst_incriminate_loyal_commander", slot_quest_target_troop),
##                         (str_store_troop_name, s3, ":quest_target_troop"),
##                         (quest_get_slot, reg5, "qst_incriminate_loyal_commander", slot_quest_gold_reward),
##                         ],
##   "Our plan against {s3} worked perfectly, and now the fool has lost one of his most trustworthy men.\
## It won't be long before we bring him to his knees. So we can begin celebrating now, eh?\
## Here, this purse contains {reg5} denars. It is all for you. And you will get much more of it if you keep serving me this well.", "lord_generic_mission_completed",[
##     (call_script, "script_succeed_quest", "qst_incriminate_loyal_commander", 100),
##     (call_script, "script_change_player_relation_with_troop","$g_talk_troop",5),
##     (call_script, "script_change_player_honor", -10),
##     ]],
##
##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_incriminate_loyal_commander"),
##                         (check_quest_failed, "qst_incriminate_loyal_commander")],
##   "You werent't able to complete a simple task. I had set up everything.\
## The only thing you needed to do was sacrifice a messenger, and we would be celebrating now.\
## But no, you were too damned honorable, weren't you?", "lord_generic_mission_failed",[]],
##
##
##
##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_kill_local_merchant"),
##                         (check_quest_succeeded, "qst_kill_local_merchant"),
##                         (quest_slot_eq, "qst_kill_local_merchant", slot_quest_current_state, 0)],
##   "I heard that you got rid of that pestilent merchant who was giving me a headache.\
## You are not afraid to get your hands dirty, eh? That's good, now here's your reward. Stick with me {palyername};\
## You are the kind of {man/woman} I need, and with my leadership and your sword, we will both be rich and powerful.", "lord_generic_mission_completed",
##   [(call_script, "script_succeed_quest", "qst_kill_local_merchant", 100)]],
##
##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_kill_local_merchant"),
##                         (check_quest_failed, "qst_kill_local_merchant")],
##   "I heard that the merchant got the better of you. How can you let a simple merchant defeat you in a sword fight, eh?", "lord_generic_mission_failed",[]],
##
##
##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_kill_local_merchant"),
##                         (check_quest_succeeded, "qst_kill_local_merchant"),
##                         (quest_slot_eq, "qst_kill_local_merchant", slot_quest_current_state, 1)],
##   "You haven't killed that merchant. You just let him go. Why?", "lord_kill_local_merchant_let_go",[]],
##
##  [anyone|plyr,"lord_kill_local_merchant_let_go", [],
##   "I made sure he will not act against you sir.", "lord_kill_local_merchant_let_go_2",[]],
##
##  [anyone,"lord_kill_local_merchant_let_go_2", [],
##   "I don't like this. You were supposed to take him out, not preach to him. Anyway, I hope he will do as you say and behave sensibly.\
## Here... this is half the money I promised to pay you. You haven't earned your full pay.", "lord_pretalk",[(call_script, "script_succeed_quest", "qst_kill_local_merchant", 50)]],
##
##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_hunt_down_raiders"),
##                         (check_quest_failed, "qst_hunt_down_raiders")],
##   "I heard that those raiders you were after have got away. Do you have an explanation?", "quest_hunt_down_raiders_failed",[]],
##  [anyone|plyr,"quest_hunt_down_raiders_failed", [],  "They were too quick for us my lord. But next time we'll get them", "quest_hunt_down_raiders_failed_2",[]],
##  [anyone|plyr,"quest_hunt_down_raiders_failed", [],  "They were too strong and well armed my lord. But we'll be ready for them next time.", "quest_hunt_down_raiders_failed_2",[]],
##  
##  [anyone|plyr,"quest_hunt_down_raiders_failed", [],  "Well, it was a long call anyway. Next time do make sure that you are better prepared.",
##   "lord_pretalk",[(call_script, "script_end_quest", "qst_hunt_down_raiders")]],
##
##
##
##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_hunt_down_raiders"),
##                         (check_quest_succeeded, "qst_hunt_down_raiders")],
##   "I heard that you have given those raiders the punishment they deserved. Well done {playername}.\
## ", "lord_generic_mission_completed",[(call_script, "script_succeed_quest", "qst_hunt_down_raiders", 100),
##                                      (call_script, "script_change_player_relation_with_troop","$g_talk_troop",3)]],
##


##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_defend_nobles_against_peasants"),
##                         (this_or_next|check_quest_succeeded, "qst_defend_nobles_against_peasants"),
##                         (check_quest_failed, "qst_defend_nobles_against_peasants"),
##                         (assign, ":num_saved", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##                         (party_count_companions_of_type, ":num_nobles", "p_main_party", "trp_noble_refugee"),
##                         (val_add, ":num_saved", ":num_nobles"),
##                         (party_count_companions_of_type, ":num_nobles", "p_main_party", "trp_noble_refugee_woman"),
##                         (val_add, ":num_saved", ":num_nobles"),
##                         (assign, "$qst_defend_nobles_against_peasants_num_nobles_saved", ":num_saved"),
##                         (eq, ":num_saved", "$qst_defend_nobles_against_peasants_num_nobles_to_save")],
##   "TODO: You have saved all of them. Good boy.", "lord_generic_mission_completed",
##   [(party_remove_members, "p_main_party", "trp_noble_refugee", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##    (party_remove_members, "p_main_party", "trp_noble_refugee_woman", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##    (call_script, "script_succeed_quest", "qst_defend_nobles_against_peasants", 100)]],
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_defend_nobles_against_peasants"),
##                         (this_or_next|check_quest_succeeded, "qst_defend_nobles_against_peasants"),
##                         (check_quest_failed, "qst_defend_nobles_against_peasants"),
##                         (assign, ":num_saved", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##                         (party_count_companions_of_type, ":num_nobles", "p_main_party", "trp_noble_refugee"),
##                         (val_add, ":num_saved", ":num_nobles"),
##                         (party_count_companions_of_type, ":num_nobles", "p_main_party", "trp_noble_refugee_woman"),
##                         (val_add, ":num_saved", ":num_nobles"),
##                         (assign, "$qst_defend_nobles_against_peasants_num_nobles_saved", ":num_saved"),
##                         (lt, ":num_saved", "$qst_defend_nobles_against_peasants_num_nobles_to_save"),
##                         (gt, "$qst_defend_nobles_against_peasants_num_nobles_saved", 0)],
##   "TODO: You have saved some of them. Half good boy.", "lord_capture_conspirators_half_completed",
##   [(party_remove_members, "p_main_party", "trp_noble_refugee", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##    (party_remove_members, "p_main_party", "trp_noble_refugee_woman", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##    (assign, ":ratio", 100),
##    (val_mul, ":ratio", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##    (val_div, ":ratio", "$qst_defend_nobles_against_peasants_num_nobles_to_save"),
##    (call_script, "script_succeed_quest", "qst_defend_nobles_against_peasants", ":ratio")]],
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_defend_nobles_against_peasants"),
##                         (this_or_next|check_quest_succeeded, "qst_defend_nobles_against_peasants"),
##                         (check_quest_failed, "qst_defend_nobles_against_peasants"),
##                         (assign, ":num_saved", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##                         (party_count_companions_of_type, ":num_nobles", "p_main_party", "trp_noble_refugee"),
##                         (val_add, ":num_saved", ":num_nobles"),
##                         (party_count_companions_of_type, ":num_nobles", "p_main_party", "trp_noble_refugee_woman"),
##                         (val_add, ":num_saved", ":num_nobles"),
##                         (eq, ":num_saved", 0)],
##   "TODO: You have saved none of them. Bad boy.", "lord_generic_mission_failed", []],
##
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_capture_conspirators"),
##                         (this_or_next|check_quest_succeeded, "qst_capture_conspirators"),
##                         (check_quest_failed, "qst_capture_conspirators"),
##                         (party_count_prisoners_of_type, ":num_conspirators", "p_main_party", "trp_conspirator"),
##                         (party_count_prisoners_of_type, ":num_conspirator_leaders", "p_main_party", "trp_conspirator_leader"),
##                         (store_add, ":sum_captured", ":num_conspirators", ":num_conspirator_leaders"),
##                         (ge, ":sum_captured", "$qst_capture_conspirators_num_troops_to_capture")],
##   "TODO: You have captured all of them. Good boy.", "lord_generic_mission_completed",
##   [(party_remove_prisoners, "p_main_party", "trp_conspirator_leader", "$qst_capture_conspirators_num_troops_to_capture"),
##    (party_remove_prisoners, "p_main_party", "trp_spy_partner", "$qst_capture_conspirators_num_troops_to_capture"),
##    (call_script, "script_succeed_quest", "qst_capture_conspirators", 100)]],
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_capture_conspirators"),
##                         (this_or_next|check_quest_succeeded, "qst_capture_conspirators"),
##                         (check_quest_failed, "qst_capture_conspirators"),
##                         (party_count_prisoners_of_type, ":num_conspirators", "p_main_party", "trp_conspirator"),
##                         (party_count_prisoners_of_type, ":num_conspirator_leaders", "p_main_party", "trp_conspirator_leader"),
##                         (store_add, ":sum_captured", ":num_conspirators", ":num_conspirator_leaders"),
##                         (lt, ":sum_captured", "$qst_capture_conspirators_num_troops_to_capture"),
##                         (gt, ":sum_captured", 0)],
##   "TODO: You have captured some of them. Half good boy.", "lord_capture_conspirators_half_completed",
##   [(assign, ":sum_removed", 0),
##    (party_remove_prisoners, "p_main_party", "trp_conspirator_leader", "$qst_capture_conspirators_num_troops_to_capture"),
##    (val_add, ":sum_removed", reg0),
##    (party_remove_prisoners, "p_main_party", "trp_conspirator", "$qst_capture_conspirators_num_troops_to_capture"),
##    (val_add, ":sum_removed", reg0),
##    (val_mul, ":sum_removed", 100),
##    (val_div, ":sum_removed", "$qst_capture_conspirators_num_troops_to_capture"),
##    (call_script, "script_succeed_quest", "qst_capture_conspirators", ":sum_removed")]],
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_capture_conspirators"),
##                         (this_or_next|check_quest_succeeded, "qst_capture_conspirators"),
##                         (check_quest_failed, "qst_capture_conspirators"),
##                         (party_count_prisoners_of_type, ":num_conspirators", "p_main_party", "trp_conspirator"),
##                         (party_count_prisoners_of_type, ":num_conspirator_leaders", "p_main_party", "trp_conspirator_leader"),
##                         (store_add, ":sum_captured", ":num_conspirators", ":num_conspirator_leaders"),
##                         (eq, ":sum_captured", 0)],
##   "TODO: You have captured none of them. Bad boy.", "lord_generic_mission_failed", []],
##
##  [anyone|plyr,"lord_capture_conspirators_half_completed", [],
##   "TODO: That's all I can do.", "lord_pretalk", []],


##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_follow_spy"),
##                         (this_or_next|check_quest_succeeded, "qst_follow_spy"),
##                         (check_quest_failed, "qst_follow_spy"),
##                         (party_count_prisoners_of_type, ":num_spies", "p_main_party", "trp_spy"),
##                         (party_count_prisoners_of_type, ":num_spy_partners", "p_main_party", "trp_spy_partner"),
##                         (gt, ":num_spies", 0),
##                         (gt, ":num_spy_partners", 0)],
##   "TODO: You have captured both of them. Good boy.", "lord_generic_mission_completed",
##   [(party_remove_prisoners, "p_main_party", "trp_spy", 1),
##    (party_remove_prisoners, "p_main_party", "trp_spy_partner", 1),
##    (call_script, "script_succeed_quest", "qst_follow_spy", 100)]],
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_follow_spy"),
##                         (this_or_next|check_quest_succeeded, "qst_follow_spy"),
##                         (check_quest_failed, "qst_follow_spy"),
##                         (party_count_prisoners_of_type, ":num_spies", "p_main_party", "trp_spy"),
##                         (party_count_prisoners_of_type, ":num_spy_partners", "p_main_party", "trp_spy_partner"),
##                         (gt, ":num_spies", 0),
##                         (eq, ":num_spy_partners", 0),
##                         (neg|party_is_active, "$qst_follow_spy_spy_partners_party")],
##   "TODO: You have captured only spy. Half good boy.", "lord_follow_spy_half_completed",
##   [(party_remove_prisoners, "p_main_party", "trp_spy", 1),
##    (call_script, "script_succeed_quest", "qst_follow_spy", 50)]],
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_follow_spy"),
##                         (this_or_next|check_quest_succeeded, "qst_follow_spy"),
##                         (check_quest_failed, "qst_follow_spy"),
##                         (party_count_prisoners_of_type, ":num_spies", "p_main_party", "trp_spy"),
##                         (party_count_prisoners_of_type, ":num_spy_partners", "p_main_party", "trp_spy_partner"),
##                         (eq, ":num_spies", 0),
##                         (gt, ":num_spy_partners", 0),
##                         (neg|party_is_active, "$qst_follow_spy_spy_party")],
##   "TODO: You have captured only spy partner. Half good boy.", "lord_follow_spy_half_completed",
##   [(party_remove_prisoners, "p_main_party", "trp_spy_partner", 1),
##    (call_script, "script_succeed_quest", "qst_follow_spy", 50)]],
##
##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_follow_spy"),
##                         (this_or_next|check_quest_succeeded, "qst_follow_spy"),
##                         (check_quest_failed, "qst_follow_spy"),
##                         (party_count_prisoners_of_type, ":num_spies", "p_main_party", "trp_spy"),
##                         (party_count_prisoners_of_type, ":num_spy_partners", "p_main_party", "trp_spy_partner"),
##                         (eq, ":num_spies", 0),
##                         (eq, ":num_spy_partners", 0),
##                         (neg|party_is_active, "$qst_follow_spy_spy_party"),
##                         (neg|party_is_active, "$qst_follow_spy_spy_partners_party")],
##   "TODO: You couldn't capture any spies. Bad boy.", "lord_generic_mission_failed", []],
##
##  [anyone|plyr,"lord_follow_spy_half_completed", [],
##   "TODO: That's all I can do.", "lord_pretalk", []],
##

##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_bring_back_runaway_serfs"),
##                         (check_quest_succeeded, "qst_bring_back_runaway_serfs")],
##   "I learned that all the serfs have come back and they are already busy preparing for the harvest.\
##  You have handled this job very well {playername}. Here, please take this reward.", "lord_generic_mission_completed",
##   [(call_script, "script_succeed_quest", "qst_bring_back_runaway_serfs", 100),
##    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",2),
##    ]],
##
##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_bring_back_runaway_serfs"),
##                         (check_quest_failed, "qst_bring_back_runaway_serfs"),
##                         (eq, "$qst_bring_back_runaway_serfs_num_parties_returned", 0)],
##   "Bah, none of the serfs that run away have returned home, and thanks to you there is noone to gather the harvest.\
## I don't believe that you were unable to turn back a bunch of half witted serfs.\
## Maybe you are conspiring with my enemies to ruin me?", "lord_bring_back_runaway_serfs_failed", []],
##  [anyone|plyr,"lord_bring_back_runaway_serfs_failed", [],
##   "Forgive me Lord, those serfs were slippery as eels.", "lord_bring_back_runaway_serfs_failed_1a", []],
##  [anyone|plyr,"lord_bring_back_runaway_serfs_failed", [],
##   "Maybe if you had taken better care of your serfs, they wouldn't run away in the first place.", "lord_bring_back_runaway_serfs_failed_1b", []],
##  [anyone|plyr,"lord_bring_back_runaway_serfs_failed_1a", [],
##   "Well, those bastards can indeed be slippery. I guess you did what you could, but be more careful next time. Anyway, I need to find some way to lift the harvest now.", "lord_pretalk",
##   [(call_script, "script_change_player_relation_with_troop","$g_talk_troop",-1),(complete_quest,"qst_bring_back_runaway_serfs")]],
##  [anyone|plyr,"lord_bring_back_runaway_serfs_failed_1b", [],
##   "Hah! You not only act like a traitor, you talk like one! I should have never trusted you!", "close_window",
##   [(call_script, "script_change_player_relation_with_troop","$g_talk_troop",-10),
##   #TODO: Increase relation with peasants 
##    (complete_quest,"qst_bring_back_runaway_serfs")]],
##
##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_bring_back_runaway_serfs"),
##                         (check_quest_failed, "qst_bring_back_runaway_serfs"),
##                         (gt, "$qst_bring_back_runaway_serfs_num_parties_returned", 0),
##                         (assign, reg1, "$qst_bring_back_runaway_serfs_num_parties_returned")],
##   "I am disappointed {playername}. You have managed to bring back only {reg1} of the three groups of runaway serfs.\
## Anyway, I guess those who have returned will have to work twice as hard to make up for the ones who got away.\
## As for your reward, I'll make you only a partial payment since you were unable to turn back all the serfs.", "lord_runaway_serf_half_completed",
##   [(store_mul, ":reward", "$qst_bring_back_runaway_serfs_num_parties_returned", 100),
##    (val_div, ":reward", 5),
##    (call_script, "script_succeed_quest", "qst_bring_back_runaway_serfs", ":reward")]],
##
##  [anyone|plyr,"lord_runaway_serf_half_completed", [],
##   "Thank you sir. You are very generous.", "lord_pretalk", []],
##
##
##  [anyone,"lord_start",[(check_quest_active,"qst_rescue_lady_under_siege"),
##                        (quest_slot_eq, "qst_rescue_lady_under_siege", slot_quest_target_troop, "$g_talk_troop"),
##                        (quest_slot_eq, "qst_rescue_lady_under_siege", slot_quest_current_state, 1)],
##   "I heard that you have rescued my {s7} from the siege of {s5} and brought her to safety.\
## I am in your debt for this {playername}. Thank you.", "lord_generic_mission_completed",
##   [(quest_get_slot, ":quest_object_troop", "qst_rescue_lady_under_siege", slot_quest_object_troop),
##    (try_begin),
##      (troop_slot_eq, "$g_talk_troop", slot_troop_daughter, ":quest_object_troop"),
##      (str_store_string, s7, "str_daughter"),
##    (else_try),
##      (str_store_string, s7, "str_wife"),
##    (try_end),
##    (remove_member_from_party, ":quest_object_troop"),
##    (try_begin),
##      (is_between, "$g_encountered_party", centers_begin, centers_end),#Lord might be in wilderness
##      (troop_set_slot, ":quest_object_troop", slot_troop_cur_center, "$g_encountered_party"),
##    (try_end),
##    (call_script, "script_succeed_quest", "qst_rescue_lady_under_siege", 100),
##    (call_script, "script_change_player_relation_with_troop","$g_talk_troop", 4),    
##    ]],
##
##  [anyone,"lord_generic_mission_thank", [],
##   "You have been most helpful {playername}. Thank you.", "lord_generic_mission_completed",[]],
##
##  [anyone|plyr,"lord_generic_mission_completed", [],
##   "It was an honour to serve you sir.", "lord_pretalk",[]],
##
##  [anyone|plyr,"lord_generic_mission_failed", [],
##   "I'm sorry I failed you sir. It won't happen again.", "lord_pretalk",[(store_partner_quest,":lords_quest"),
##                                                                         (complete_quest,":lords_quest")]],
##### TODO: QUESTS COMMENT OUT END
  
  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                         (troop_get_slot, ":cur_debt", "$g_talk_troop", slot_troop_player_debt),
                         (gt, ":cur_debt", 0)],
   "I think you owe me {reg1} denars, {playername}. Do you intend to pay your debt anytime soon?", "lord_pay_debt_2",[]],

  [anyone|plyr, "lord_pay_debt_2", [(troop_get_slot, ":cur_debt", "$g_talk_troop", slot_troop_player_debt),
                                    (store_troop_gold, ":cur_gold", "trp_player"),
                                    (le, ":cur_debt", ":cur_gold")],
   "Actually, I had come to pay you my debt sir. Here you are.", "lord_pay_debt_3_1", [(troop_get_slot, ":cur_debt", "$g_talk_troop", slot_troop_player_debt),
                                                   (troop_remove_gold, "trp_player", ":cur_debt"),
                                                   (troop_set_slot, "$g_talk_troop", slot_troop_player_debt, 0)]],

  [anyone|plyr, "lord_pay_debt_2", [],
   "Aalas, I don't have sufficient funds sir. But I'll pay you soon enough.", "lord_pay_debt_3_2", []],

  [anyone, "lord_pay_debt_3_1", [],
   "Ah. That's very good now. You are a {man/woman} of honor {playername}.", "lord_pretalk", []],

  [anyone, "lord_pay_debt_3_2", [],
   "Well, don't keep me waiting much longer.", "lord_pretalk", []],

##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (is_between,"$g_talk_troop_faction_relation",0,3),
###                         (eq,"$players_kingdom",0),
##                         ],
##   "Why don't you join us in our cause? You seem to be an able fighter.\
## We need {men/people} like you who will take part in our glory and share the spoils of our victory.", "lord_talk",[]],


#Claim center begin
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (eq,"$g_talk_troop_faction","$players_kingdom"),
##                         (faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
##                         (call_script, "script_get_number_of_unclaimed_centers_by_player"),
##                         (gt, reg1, 0),
##                         (assign, "$center_to_be_claimed", reg1),
##                         (str_store_party_name, s4, "$center_to_be_claimed"),
##                         ],
##   "I heard that your forces have taken {s4}. I commend you for your victory {playername}.\
## But we need to decide what to do with this new castle now.", "lord_claim_center_begin", []],


##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (ge,"$g_talk_troop_faction_relation",0),
##                         (call_script, "script_get_number_of_unclaimed_centers_by_player"),
##                         (gt, reg1, 0),
##                         (assign, "$center_wanted_to_be_bought", reg1),
##                         (str_store_party_name, s4, "$center_wanted_to_be_bought"),
##                         (call_script, "script_get_number_of_hero_centers", "$g_talk_troop"),
##                         (assign, ":no_of_owned_centers", reg0),
##                         (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
##                         (lt, ":no_of_owned_centers", 2),
##                         (troop_get_slot, ":wealth", "$g_talk_troop", slot_troop_wealth),
##                         (ge, ":wealth", 6000)],
##   "I heard that your forces have taken {s4}. I applaud your victory {playername}, but you know as well as I do that\
## as a person of low rank and status you can not be permitted to hold that castle for yourself.\
## It is to your benefit to sell it to a Lord like myself who can hold and protect the castle and the surrounding estates.\
## Anyway, I am ready to make you an offer of 5000 denars, should you decide to sell that castle.", "lord_buy_center", []],
##
##
##  [anyone|plyr,"lord_buy_center", [],
##   "I accept your offer sir. The castle is yours for 5000 denars.", "lord_buy_center_accept", []],
##  [anyone|plyr,"lord_buy_center", [],
##   "I am afraid I can't accept that offer.", "lord_buy_center_deny", []],
##
##  [anyone,"lord_buy_center_accept", [],
##   "Excellent, {playername}! You have decided wisely.\
## Why bother yourself with the necessities of keeping a castle while you can leave all those boring details to noble Lords like me?\
## I am sure money will be much more useful to you than a castle would.", "lord_buy_center_accept_2", []],
##
##  [anyone|plyr,"lord_buy_center_accept_2", [],
##   "One day sir, one day I'll have my own castle.", "lord_buy_center_accept_3", []],
##  [anyone|plyr,"lord_buy_center_accept_2", [],
##   "Everyone needs money sir. I can take another castle anytime.", "lord_buy_center_accept_3", []],
##
##  [anyone,"lord_buy_center_accept_3", [],
##   "Of course, of course, {playername}.  Then let us conclude our deal. Here's the 5000 denars I offered you.\
## I'll have my clerk handle the necessary details.\
## I guess from now on, {s4} belongs to me. Well, that worked very well for both of us, I guess.", "lord_pretalk",
##   [(troop_get_slot, ":wealth", "$g_talk_troop", slot_troop_wealth),
##    (val_sub, ":wealth", 6000),
##    (troop_set_slot, "$g_talk_troop", slot_troop_wealth, ":wealth"),
##    (troop_add_gold, "trp_player", 5000),
##    (party_set_slot, "$center_wanted_to_be_bought", slot_town_lord, "$g_talk_troop"),
##    #Changing center faction
##    (party_set_faction, "$center_wanted_to_be_bought", "$g_talk_troop_faction"),
##    (set_spawn_radius, 1),
##    (spawn_around_party, "$center_wanted_to_be_bought", "pt_old_garrison"),
##    (assign, ":new_party", reg0),
##    (party_set_ai_behavior, ":new_party", ai_bhvr_attack_party),
##    (party_set_ai_object, ":new_party", "p_main_party"),
##    (party_set_flags, ":new_party", pf_default_behavior, 0),
##    (call_script, "script_party_copy", ":new_party", "$center_wanted_to_be_bought"),
##    (party_clear, "$center_wanted_to_be_bought"),
##
##    (faction_get_slot, ":reinforcement_template_archers", "$g_talk_troop_faction", slot_faction_reinforcements_archers),
##    (faction_get_slot, ":reinforcement_template_infantry", "$g_talk_troop_faction", slot_faction_reinforcements_infantry),
##    (party_add_template, "$center_wanted_to_be_bought", ":reinforcement_template_archers"),
##    (party_add_template, "$center_wanted_to_be_bought", ":reinforcement_template_infantry"),
##    ]],
##
##  [anyone,"lord_buy_center_deny", [],
##   "As you wish {playername}. But don't forget, the great lords of the country won't like a low born {man/woman} like you holding such an estate without their consent.\
## It is the nature of this world {playername}. Everyone should know their place.", "lord_pretalk", []],

  [anyone,"lord_start", [(party_slot_eq, "$g_encountered_party",slot_town_lord, "$g_talk_troop"),#we are talking to Town's Lord.
                         (ge,"$g_talk_troop_faction_relation",0),
                         (lt, "$g_encountered_party_2", 0), #town is not under siege
                         (hero_can_join_as_prisoner, "$g_encountered_party"),
                         (party_get_num_prisoner_stacks,":num_prisoner_stacks","p_main_party"),
                         (assign, "$prisoner_lord_to_buy", -1),
                         (try_for_range,":i_pris_stack",0,":num_prisoner_stacks"),
                           (party_prisoner_stack_get_troop_id, ":t_id", "p_main_party", ":i_pris_stack"),
                           (troop_slot_eq, ":t_id", slot_troop_occupation, slto_kingdom_hero),
                           (store_troop_faction, ":fac", ":t_id"),
                           (store_relation, ":rel", ":fac", "$g_talk_troop_faction"),
                           (lt,  ":rel", 0),
                           (assign, "$prisoner_lord_to_buy", ":t_id"),
                         (try_end),
                         (gt, "$prisoner_lord_to_buy", 0), #we have a prisoner lord.
                         (str_store_troop_name, s3, "$prisoner_lord_to_buy"),
                         (assign, reg5, "$prisoner_lord_to_buy"),
                         (assign, reg6, 2000),
                         (assign, "$temp", 2000),
                         ],
   "I heard that you have captured our enemy {s3} and he is with you at the moment.\
 I can pay you {reg6} denars for him if you want to get rid of him.\
 You can wait for his family to pay his ransom of course, but there is no telling how long that will take, eh?\
", "lord_buy_prisoner", []],

  [anyone|plyr,"lord_buy_prisoner", [],
   "I accept your offer sir. I'll leave {s3} to you for {reg6} denars.", "lord_buy_prisoner_accept", []],
  [anyone|plyr,"lord_buy_prisoner", [],
   "I am afraid I can't accept that offer.", "lord_buy_prisoner_deny", []],

  [anyone,"lord_buy_prisoner_accept", [],
   "Good. Then here's your {reg6} denars.\
 I'll tell my men to fetch {s3} and bring him to the prison.", "lord_pretalk", [
     (remove_troops_from_prisoners,  "$prisoner_lord_to_buy", 1),
     (troop_add_gold, "trp_player", "$temp"),
     (party_add_prisoners, "$g_encountered_party", "$prisoner_lord_to_buy", 1),
     (troop_set_slot, "$prisoner_lord_to_buy", slot_troop_is_prisoner, 1),
     ]],



  [anyone,"lord_start", [],
   "What is it?", "lord_talk",[]],

  [anyone,"lord_pretalk", [],
   "Anything else?", "lord_talk",[]],
  
  [anyone,"hero_pretalk", [],
   "Anything else?", "lord_talk",[]],

##### TODO: QUESTS COMMENT OUT BEGIN
##
##  [anyone|plyr,"lord_talk",[(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                            (check_quest_active,"qst_lend_companion"),
##                            (quest_slot_eq, "qst_lend_companion", slot_quest_giver_troop, "$g_talk_troop"),
##                            (store_current_day, ":cur_day"),
##                            (quest_get_slot, ":quest_target_amount", "qst_lend_companion", slot_quest_target_amount),
##                            (ge, ":cur_day", ":quest_target_amount"),
##                            (quest_get_slot, ":quest_target_troop", "qst_lend_companion", slot_quest_target_troop),
##                            (str_store_troop_name,1,":quest_target_troop"),
##                            (troop_get_type, reg3, ":quest_target_troop"),
##                            ],
##   "Sir, I wish to take {s1} back, if you no longer need {reg3?her:his} service.", "lord_lend_companion_end",
##   []],
##
##  [anyone,"lord_lend_companion_end",[(quest_get_slot, ":quest_target_troop", "qst_lend_companion", slot_quest_target_troop),
##                                     (party_add_members, "p_main_party", ":quest_target_troop", 1),
##                                     (call_script, "script_succeed_quest", "qst_lend_companion", 100)],
##   "Of course {playername}. {reg?She:He} is a bright {reg3?girl:fellow}, that {s1}. You are lucky to have someone like {reg3?her:him} in your party.", "lord_pretalk",
##   []],
##
##
##  [anyone|plyr,"lord_talk",[(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                            (check_quest_active,"qst_bring_reinforcements_to_siege"),
##                             (quest_get_slot, ":quest_target_troop", "qst_bring_reinforcements_to_siege", slot_quest_target_troop),
##                             (eq,"$g_talk_troop",":quest_target_troop"),
##                             (quest_get_slot, ":quest_giver_troop", "qst_bring_reinforcements_to_siege", slot_quest_giver_troop),
##                             (quest_get_slot, ":quest_target_amount", "qst_bring_reinforcements_to_siege", slot_quest_target_amount),
##                             (quest_get_slot, ":quest_object_troop", "qst_bring_reinforcements_to_siege", slot_quest_object_troop),
##                             (party_count_companions_of_type, ":num_companions", "p_main_party", ":quest_object_troop"),
##                             (ge, ":num_companions", ":quest_target_amount"),
##                             (str_store_troop_name,1,":quest_giver_troop"),
##                             (assign, reg1, ":quest_target_amount"),
##                             (str_store_troop_name,2,":quest_object_troop")],
##   "Sir, {s1} ordered me to bring {reg1} {s2} to reinforce your siege.", "lord_reinforcement_brought",
##   [(quest_get_slot, ":quest_target_amount", "qst_bring_reinforcements_to_siege", slot_quest_target_amount),
##    (quest_get_slot, ":quest_target_party", "qst_bring_reinforcements_to_siege", slot_quest_target_party),
##    (quest_get_slot, ":quest_object_troop", "qst_bring_reinforcements_to_siege", slot_quest_object_troop),
##    (party_remove_members, "p_main_party", ":quest_object_troop", ":quest_target_amount"),
##    (party_add_members, ":quest_target_party", ":quest_object_troop", ":quest_target_amount"),
##    (call_script, "script_succeed_quest", "qst_bring_reinforcements_to_siege", 100),
##    ]],
##
##  [anyone|plyr,"lord_talk",[(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                            (check_quest_active,"qst_bring_reinforcements_to_siege"),
##                             (quest_get_slot, ":quest_target_troop", "qst_bring_reinforcements_to_siege", slot_quest_target_troop),
##                             (eq,"$g_talk_troop",":quest_target_troop"),
##                             (quest_get_slot, ":quest_giver_troop", "qst_bring_reinforcements_to_siege", slot_quest_giver_troop),
##                             (quest_get_slot, ":quest_target_amount", "qst_bring_reinforcements_to_siege", slot_quest_target_amount),
##                             (quest_get_slot, ":quest_object_troop", "qst_bring_reinforcements_to_siege", slot_quest_object_troop),
##                             (party_count_companions_of_type, ":num_companions", "p_main_party", ":quest_object_troop"),
##                             (lt, ":num_companions", ":quest_target_amount"),
##                             (gt, ":num_companions", 0),
##                             (str_store_troop_name,1,":quest_giver_troop"),
##                             (assign, reg1, ":quest_target_amount"),
##                             (str_store_troop_name,2,":quest_object_troop")],
##   "Sir, {s1} ordered me to bring {reg1} {s2} as a reinforcement to your siege, but unfortunately I lost some of them during my expedition.", "lord_reinforcement_brought_some",
##   [(quest_get_slot, ":quest_target_amount", "qst_bring_reinforcements_to_siege", slot_quest_target_amount),
##    (quest_get_slot, ":quest_target_party", "qst_bring_reinforcements_to_siege", slot_quest_target_party),
##    (quest_get_slot, ":quest_object_troop", "qst_bring_reinforcements_to_siege", slot_quest_object_troop),
##    (party_count_companions_of_type, ":num_companions", "p_main_party", ":quest_object_troop"),
##    (party_remove_members, "p_main_party", ":quest_object_troop", ":num_companions"),
##    (party_add_members, ":quest_target_party", ":quest_object_troop", ":num_companions"),
##    (assign, ":percentage_completed", 100),
##    (val_mul, ":percentage_completed", ":num_companions"),
##    (val_div, ":percentage_completed", ":quest_target_amount"),
##    (call_script, "script_succeed_quest", "qst_bring_reinforcements_to_siege", ":percentage_completed"),
##     ]],
##
##  [anyone,"lord_reinforcement_brought", [], "Well done {playername}. These men will no doubt be very useful. I will speak to {s1} of your help.", "lord_pretalk",[]],
##  [anyone,"lord_reinforcement_brought_some", [], "That's not quite good enough {playername}. But I suppose it is better than no reinforcements at all. Whatever, I'll tell {s1} you tried your best.", "lord_pretalk",[]],
##
##
##  [anyone|plyr,"lord_talk",[(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                            (check_quest_active,"qst_duel_for_lady"),
##                            (quest_slot_eq, "qst_duel_for_lady", slot_quest_target_troop, "$g_talk_troop"),
##                            (quest_get_slot, ":quest_giver_troop", "qst_duel_for_lady", slot_quest_giver_troop),
##                            (str_store_troop_name,1,":quest_giver_troop")],
##   "I want you to take back your accusations against {s1}.", "lord_challenge_duel_for_lady", []],
##  [anyone,"lord_challenge_duel_for_lady", [], "What accusations? Everyone knows that she takes her stable boys to her bed when her husband is away.\
## I am merely repeating what everyone else says.", "lord_challenge_duel_for_lady_2",[]],
##  [anyone|plyr,"lord_challenge_duel_for_lady_2", [], "You will take back your lies, or prove them against my sword.", "lord_challenge_duel_for_lady_3",[]],
##  [anyone|plyr,"lord_challenge_duel_for_lady_2", [], "Well, if you say so...", "lord_pretalk",[]],
##  [anyone,"lord_challenge_duel_for_lady_2", [], "So you are challenging me to a duel... It will be good sport to crush your head.", "close_window",
##   [(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -20),
##    (party_get_slot, ":arena_scene","$g_encountered_party",slot_town_arena),
##    (try_begin),
##      (le, ":arena_scene", 0),
##      (assign, ":arena_scene", "scn_conversation_scene"),#TODO: Change this to scn_default_arena
##    (try_end),
##    (modify_visitors_at_site,":arena_scene"),(reset_visitors),
##    (set_visitor, 0, "trp_player"),
##    (set_visitor, 8, "$g_talk_troop"),
##    (set_jump_mission,"mt_arena_duel"),
##    (jump_to_scene,":arena_scene"),
##    ]],
##
##
##  [anyone|plyr,"lord_talk",[(check_quest_active,"qst_deliver_message"),
##                             (quest_get_slot, ":quest_target_troop", "qst_deliver_message", slot_quest_target_troop),
##                             (eq,"$g_talk_troop",":quest_target_troop"),
##                             (quest_get_slot, ":quest_giver_troop", "qst_deliver_message", slot_quest_giver_troop),
##                             (str_store_troop_name,1,":quest_giver_troop")],
##   "Sir, I have brought you a message from lord {s1}.", "lord_message_delivered",
##   []],
##
##  [anyone,"lord_message_delivered", [], "Hmm let me see that. And here... this is for your trouble.", "lord_pretalk",[(call_script, "script_succeed_quest", "qst_deliver_message", 100)]],
##
##
##
##  [anyone|plyr,"lord_talk", [(check_quest_active,"qst_deliver_message_to_prisoner_lord"),
##                             (quest_slot_eq, "qst_deliver_message_to_prisoner_lord", slot_quest_target_troop, "$g_talk_troop"),
##                             (quest_get_slot, ":quest_giver_troop", "qst_deliver_message_to_prisoner_lord", slot_quest_giver_troop),
##                             (str_store_troop_name, s1, ":quest_giver_troop")],
##   "I have brought you a message from {s1}.", "lord_deliver_message_prisoner",[(call_script, "script_succeed_quest", "qst_deliver_message_to_prisoner_lord", 100)]],
##
##  [anyone,"lord_deliver_message_prisoner", [], "Is that true? Thank you so much {playername}. You have brought me hope and joy in this dark prison.\
## I hope I can repay you one day.", "lord_deliver_message_prisoner_2",[]],
##  [anyone|plyr,"lord_deliver_message_prisoner_2", [], "Don't mention it my lord. It was the least I could do.", "lord_deliver_message_prisoner_2a",[]],
##  [anyone,"lord_deliver_message_prisoner_2a", [], "Thank you {playername}. Thank you.", "close_window",[]],
##  [anyone|plyr,"lord_deliver_message_prisoner_2", [], "Don't worry sir. I'll give you ample opportunity to do that once you are free again.", "lord_deliver_message_prisoner_2b",[]],
##  [anyone,"lord_deliver_message_prisoner_2b", [], "Ha-hah. Of course {playername}. Thank you.", "close_window",[]],
##
##  [anyone|plyr,"lord_talk", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 1),
##                             (check_quest_active,"qst_rescue_lord_by_replace"),
##                             (quest_slot_eq, "qst_rescue_lord_by_replace", slot_quest_target_troop, "$g_talk_troop"),
##                             (neg|check_quest_succeeded, "qst_rescue_lord_by_replace")],
##   "I am here to rescue you...", "lord_rescue_by_replace_offer",[]],
##  [anyone,"lord_rescue_by_replace_offer", [],
##   "Good God! And how do you plan to do that?", "lord_rescue_by_replace_offer_2",[]],
##  [anyone|plyr,"lord_rescue_by_replace_offer_2", [],
##   "We will switch our garments and you will leave this place disguised as me.\
## I paid the guards a handsome bribe, with which I am sure they have already purchased half the wine stocks of the nearest tavern.\
## With some luck they'll soon be too drunk to notice the difference between us.", "lord_rescue_by_replace_offer_3",[]],
##  [anyone,"lord_rescue_by_replace_offer_3", [],
##   "Sounds like a good plan. But what about you? They won't look too kindly on you once they realize what happened. You may need to spend a long time in this prison.", "lord_rescue_by_replace_offer_4",[]],
##  [anyone|plyr,"lord_rescue_by_replace_offer_4", [],
##   "Don't worry about me sir. I already started to like this place.", "lord_rescue_by_replace_offer_5a",[]],
##  [anyone|plyr,"lord_rescue_by_replace_offer_4", [],
##   "As long as you remember to give me a fat reward afterwards my lord, I'll be just fine.", "lord_rescue_by_replace_offer_5b",[]],
##  [anyone,"lord_rescue_by_replace_offer_5a",[],
##   "You are a brave soul indeed. I won't forget this.", "lord_rescue_by_replace_offer_6",[]],
##  [anyone,"lord_rescue_by_replace_offer_5b",[],
##   "Ha-hah. Of course. Come to me when you are out of here. You'll find out how generous I can be.", "lord_rescue_by_replace_offer_6",[]],
##  [anyone|plyr,"lord_rescue_by_replace_offer_6",[],
##   "Let's switch our garments now sir. It is time for you to go.", "close_window",
##   [(succeed_quest, "qst_rescue_lord_by_replace"),
##    (quest_get_slot, ":quest_target_troop", "qst_rescue_lord_by_replace", slot_quest_target_troop),
##    (quest_get_slot, ":quest_target_center", "qst_rescue_lord_by_replace", slot_quest_target_center),
##    (party_remove_prisoners, ":quest_target_center", ":quest_target_troop", 1),
##    (troop_set_slot, ":quest_target_troop", slot_troop_is_prisoner, 0),
##    (assign,"$auto_menu",-1),
##    (assign, "$capturer_party", "$g_encountered_party"),
##    (jump_to_menu, "mnu_captivity_rescue_lord_taken_prisoner"),
##    (finish_mission),
##    ]],
##
##  
##  [anyone|plyr,"lord_talk", [(check_quest_active, "qst_deliver_message_to_lover"),
##                             (troop_get_slot, ":cur_daughter", "$g_talk_troop", slot_troop_daughter),
##                             (quest_slot_eq, "qst_deliver_message_to_lover", slot_quest_target_troop, ":cur_daughter"),
##                             (quest_get_slot, ":troop_no", "qst_deliver_message_to_lover", slot_quest_giver_troop),
##                             (str_store_troop_name, 3, ":troop_no"),
##                             (str_store_troop_name, 4, ":cur_daughter")],
##   "My lord, {s3} asked me to give this letter to your daughter, but I think you should read it first.", "lord_deliver_message_to_lover_tell_father",[]],
##
##  [anyone,"lord_deliver_message_to_lover_tell_father", [],
##   "That swine called {s3} is trying to approach my daughter eh? You have made the right decision by bringing this letter to me. I'll have a long talk with {s4} about it.", "lord_pretalk",
##   [(add_xp_as_reward, 200),
##    (troop_add_gold, "trp_player", 1000),
##    (quest_get_slot, ":quest_giver", "qst_deliver_message_to_lover", slot_quest_giver_troop),
##    (quest_get_slot, ":target_troop", "qst_deliver_message_to_lover", slot_quest_target_troop),
##    (call_script, "script_change_player_relation_with_troop", ":quest_giver", -20),
##    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 10),
##    (call_script, "script_change_player_relation_with_troop", ":target_troop", -10),
##    (complete_quest,"qst_deliver_message_to_lover"),
##    #Adding betrayal to the quest giver
##    (troop_set_slot, ":quest_giver", slot_troop_last_quest, "qst_deliver_message_to_lover"),
##    (troop_set_slot, ":quest_giver", slot_troop_last_quest_betrayed, 1)]],
##
##
##  [anyone|plyr,"lord_talk",[(check_quest_active,"qst_deliver_message_to_enemy_lord"),
##                            (quest_get_slot, ":quest_target_troop", "qst_deliver_message_to_enemy_lord", slot_quest_target_troop),
##                            (eq,"$g_talk_troop",":quest_target_troop"),
###                            (eq,"$talk_context",tc_back_alley), #make sure we are meeting secretly
##                            (quest_get_slot, ":quest_giver_troop", "qst_deliver_message_to_enemy_lord", slot_quest_giver_troop),
##                            (str_store_troop_name,1,":quest_giver_troop")],
##   "I have brought you a message from {s1}.", "lord_message_delivered_enemy",
##   [(call_script, "script_succeed_quest", "qst_deliver_message_to_enemy_lord", 100)]],
## 
##
##  [anyone,"lord_message_delivered_enemy", [], "Hmmm... Give the message to me.... All right, you can go now.", "close_window",[]],
##
##### TODO: QUESTS COMMENT OUT END
#sango actm
#active mission rewrite from 901
  [anyone|plyr,"lord_talk",[(check_quest_active,"qst_deliver_message"),
                             (quest_get_slot, ":quest_target_troop", "qst_deliver_message", slot_quest_target_troop),
                             (eq,"$g_talk_troop",":quest_target_troop"),
                             (quest_get_slot, ":quest_giver_troop", "qst_deliver_message", slot_quest_giver_troop),
                             (str_store_troop_name,s9,":quest_giver_troop")],
   "Sir, I have brought you a message from {s9}.", "lord_message_delivered",
   []],

  [anyone,"lord_message_delivered", [], "Hmm let me see that... Well, it was kind of you to bring this to me {playername}.\
 Give my regards to {s9} when you see him again.", "lord_pretalk",[
     (call_script, "script_end_quest", "qst_deliver_message"),
     (quest_get_slot, ":quest_giver", "qst_deliver_message", slot_quest_giver_troop),
     (str_store_troop_name,s9,":quest_giver"),
     (call_script, "script_change_player_relation_with_troop", ":quest_giver", 2),
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),
   ]],
   
  [anyone|plyr,"lord_talk", [(store_partner_quest,":lords_quest"),(ge,":lords_quest",0)],
   "About the task you asked of me...", "lord_active_mission_1",[]],
  [anyone,"lord_active_mission_1", [], "Yes, have you made any progress on it?", "lord_active_mission_2",[]],
  [anyone|plyr,"lord_active_mission_2",[(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                            (check_quest_active,"qst_capture_prisoners"),
                            (quest_slot_eq, "qst_capture_prisoners", slot_quest_giver_troop, "$g_talk_troop"),
                            (quest_get_slot, ":quest_target_amount", "qst_capture_prisoners", slot_quest_target_amount),
                            (quest_get_slot, ":quest_target_troop", "qst_capture_prisoners", slot_quest_target_troop),
                            (party_count_prisoners_of_type, ":count_prisoners", "p_main_party", ":quest_target_troop"),
                            (ge, ":count_prisoners", ":quest_target_amount"),
                            (assign, reg1, ":quest_target_amount"),
                            (str_store_troop_name_plural, s1, ":quest_target_troop")],
   "Indeed. I brought you {reg1} {s1} as prisoners.", "lord_generic_mission_thank",
   [(quest_get_slot, ":quest_target_amount", "qst_capture_prisoners", slot_quest_target_amount),
    (quest_get_slot, ":quest_target_troop", "qst_capture_prisoners", slot_quest_target_troop),
    (party_remove_prisoners, "p_main_party", ":quest_target_troop", ":quest_target_amount"),
    (party_add_prisoners, "$g_encountered_party", ":quest_target_troop", ":quest_target_amount"),
    (call_script, "script_finish_quest", "qst_capture_prisoners", 100)]],
  [anyone|plyr,"lord_active_mission_2", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                                         (store_partner_quest,":lords_quest"),
                                         (eq,":lords_quest","qst_raise_troops"),
                                         (quest_get_slot, ":quest_target_troop", ":lords_quest", slot_quest_target_troop),
                                         (quest_get_slot, ":quest_target_amount", ":lords_quest", slot_quest_target_amount),
                                         (party_count_companions_of_type, ":num_companions", "p_main_party", ":quest_target_troop"),
                                         (ge, ":num_companions", ":quest_target_amount"),
                                         (assign, reg1, ":quest_target_amount"),
                                         (str_store_troop_name_plural, 3, ":quest_target_troop")],
   "Indeed. I have raised {reg1} {s3}. You can take them.", "lord_raise_troops_thank",[(quest_get_slot, ":quest_target_troop", "qst_raise_troops", slot_quest_target_troop),
                                                                                         (quest_get_slot, ":quest_target_amount", "qst_raise_troops", slot_quest_target_amount),
                                                                                         (call_script,"script_change_player_relation_with_troop","$g_talk_troop",8),
                                                                                         (party_remove_members, "p_main_party", ":quest_target_troop", ":quest_target_amount"),
                                                                                         (call_script, "script_end_quest", "qst_raise_troops"),
                                                                                         (troop_get_slot, ":cur_lords_party", "$g_talk_troop", slot_troop_leaded_party),
                                                                                         (gt, ":cur_lords_party", 0),
                                                                                         (party_add_members, ":cur_lords_party", ":quest_target_troop", ":quest_target_amount"),
                                                                                         ]],

  [anyone,"lord_raise_troops_thank", [],
   "These men will be very useful {playername}. I am sure you have trained them well. Thank you.", "lord_raise_troops_thank_2",[]],

  [anyone|plyr,"lord_raise_troops_thank_2", [],
   "Well, the lads are at your command now, sir. I am sure you will take good care of them.", "lord_pretalk",[]],
  [anyone|plyr,"lord_active_mission_2", [], "I am still working on it sir.", "lord_active_mission_3",[]],
  [anyone|plyr,"lord_active_mission_2", [], "I am afraid I won't be able to do this quest, sir.", "lord_mission_failed",[]],
                                                                                                                                                   
  [anyone,"lord_active_mission_3", [], "Good. Keep working. I am counting on you.", "lord_pretalk",[]],

  [anyone,"lord_mission_failed", [], "I am disappointed {playername}. I was counting on you. Well... It was a long call anyway. Let us hope you will be luckier next time.", "lord_pretalk",
   [(store_partner_quest,":lords_quest"),
    (call_script, "script_abort_quest", ":lords_quest", 1)]],

#end sango actm

  [anyone|plyr,"lord_talk", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                             (ge,"$g_talk_troop_faction_relation",0),
                             (party_slot_eq, "$g_encountered_party", slot_party_type, spt_castle),
                             (party_slot_eq, "$g_encountered_party", slot_town_lord, "$g_talk_troop"),
                             (eq, "$g_permitted_to_center",0),
                             (party_get_num_companions, reg7, "p_main_party"),
                             (val_sub, reg7, 1),
                             ],
   "{reg7?Me and my men:I} need shelter for the night my lord. Can we rest in your castle for a while?", "lord_castle_let_in",[]],

  [anyone, "lord_castle_let_in", [(lt,"$g_talk_troop_relation",-10)],
   "What? Do I look like I am running an inn here? I have no place here for {reg7?you and your lot:you}. Now get off my lands...", "close_window",[(assign, "$g_permitted_to_center",1)]],
  [anyone, "lord_castle_let_in", [(lt,"$g_talk_troop_relation",2), (lt, "$g_talk_troop_faction_relation", 10),(assign, reg6, 100)],
   "I'll give you shelter if you pay a toll of {reg6} denars.", "lord_castle_let_in_toll",[]],
  [anyone|plyr,"lord_castle_let_in_toll", [(store_troop_gold, ":gold", "trp_player"),(gt,":gold",reg6)], "Of course sir. I'll pay the toll.", "lord_castle_let_in_toll_pay",
   [(troop_remove_gold, "trp_player",reg6)]],
  [anyone, "lord_castle_let_in_toll_pay", [(str_store_party_name, s1, "$g_encountered_party")],
   "Then you are welcome to {s1}.", "close_window",[(assign, "$g_permitted_to_center",1),(jump_to_menu, "mnu_town")]],
  [anyone|plyr,"lord_castle_let_in_toll", [], "I can't pay that sum sir.", "lord_castle_let_in_toll_nopay",[]],
  [anyone,"lord_castle_let_in_toll_nopay", [], "Then you are out of luck, I guess.", "lord_pretalk",[]],
  
  [anyone, "lord_castle_let_in", [(str_store_party_name, s1, "$g_encountered_party")],
   "Of course {playername}. You are welcome here. You may rest at {s1} as long as you wish.", "close_window",[(assign, "$g_permitted_to_center",1)]],

##  [anyone|plyr,"lord_talk", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                             (lt, "$g_talk_troop_faction_relation", 0),
##                             (str_store_faction_name, s4, "$g_talk_troop_faction")],
##   "I want to make my peace with {s4}.", "lord_ask_for_pardon",[]],
##  [anyone,"lord_ask_for_pardon", [(lt, "$g_talk_troop_relation", -4)], "Do you now? Then go on and put a knife into your heart. Then we will have peace.", "lord_pretalk",[]],
##  [anyone,"lord_ask_for_pardon", [(store_sub, ":hostility", 4, "$g_talk_troop_faction_relation"),
##                                  (val_mul, ":hostility", ":hostility"), #square it
##                                  (store_mul, reg16, ":hostility", 10),
##      ], "I can use my influence in {s4} and arrange that you be pardoned {playername},\
## but there are people here that see you as an enemy and they won't be satisfied unless you pay a tribute.\
## All in all I think a peace with {s4} will cost you no less than {reg16} denars.", "lord_ask_for_pardon_2",[]],
##
##  [anyone|plyr,"lord_ask_for_pardon_2", [(store_troop_gold, ":gold","trp_player"),(ge, ":gold", reg16)], "I will gladly pay a tribute of {reg16} denars.", "lord_ask_for_pardon_tribue_accept",[]],
##  [anyone|plyr,"lord_ask_for_pardon_2", [], "I am afraid I can't pay that much.", "lord_ask_for_pardon_tribue_deny",[]],
##
##  [anyone,"lord_ask_for_pardon_tribue_accept", [], "That is very good {playername}.\
## I will use this gold to pay those that can oppose your pardon, and I am sure in a very short time, word will spread that you are no longer an enemy of {s4}.", "close_window",[
##     (troop_remove_gold, "trp_player",reg16),
##     (set_relation, "$g_talk_troop_faction", "fac_player_faction", 0),
##     (assign,"$g_leave_town_outside",1),
##     ]],
##  [anyone,"lord_ask_for_pardon_tribue_deny", [], "In that case, there is nothing I can do for your pardon {playername}.", "lord_pretalk",[]],

  
#  [anyone|plyr,"lord_talk", [(store_partner_quest,":lords_quest"),(ge,":lords_quest",0)],
#   "About the mission you gave me sir...", "lord_active_mission_1",[]],

  [anyone|plyr,"lord_talk", [(eq, 1,0),
                             (troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                             (ge, "$g_talk_troop_faction_relation", 0),
#                             (eq,"$g_talk_troop_faction","$players_kingdom")
                             ],
   "Do you have any jobs for me?", "lord_request_mission_ask",[]],

  [anyone|plyr,"lord_talk", [(eq,"$talk_context",tc_party_encounter),
                             (lt, "$g_encountered_party_relation", 0)],
   "Surrender or die!", "party_encounter_lord_hostile_ultimatum_surrender", []],
  [anyone,"party_encounter_lord_hostile_ultimatum_surrender", [],
   "You rascal! You will pay for this", "close_window", [(call_script, "script_make_kingdom_hostile_to_player", "$g_encountered_party_faction", -3),
                                                         (assign,"$encountered_party_hostile",1)]],


  [anyone|plyr,"lord_talk", [(le,"$talk_context", tc_party_encounter),(ge, "$g_talk_troop_faction_relation", 0),
                                   (troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                             (faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
                             (ge, "$g_talk_troop_faction_relation", 0),
                             (neq, "$players_kingdom", "$g_talk_troop_faction")],
   "I want to give my oath to you and fight your enemies, my lord.", "lord_ask_enter_service",[]],

  [anyone|plyr,"lord_talk", [(eq,1,0),(le,"$talk_context", tc_party_encounter),(ge, "$g_talk_troop_faction_relation", 0)],
   "I have an offer for you.", "lord_talk_preoffer",[]],

  [anyone|plyr,"lord_talk", [(ge, "$g_talk_troop_faction_relation", 0)],
   "I wish to ask you something.", "lord_talk_ask_something",[]],

  [anyone,"lord_talk_ask_something", [],
   "What is it?", "lord_talk_ask_something_2",[]],

  [anyone|plyr,"lord_talk_ask_something_2", [],
   "I want to know about the location of someone.", "lord_talk_ask_location",[]],
  [anyone|plyr,"lord_talk_ask_something_2", [],
   "Never mind.", "lord_pretalk",[]],

  [anyone,"lord_talk_ask_location", [],
   "Whose location?", "lord_talk_ask_location_2",[]],

  [anyone|plyr|repeat_for_troops,"lord_talk_ask_location_2", [(store_repeat_object, ":troop_no"),
                                                              (neq, "$g_talk_troop", ":troop_no"),
                                                              (is_between, ":troop_no", heroes_begin, heroes_end),
                                                              (store_troop_faction, ":faction_no", ":troop_no"),
                                                              (eq, "$g_encountered_party_faction", ":faction_no"),
                                                              (str_store_troop_name, s1, ":troop_no")],
   "{s1}", "lord_talk_ask_location_3",[(store_repeat_object, "$hero_requested_to_learn_location")]],

  [anyone|plyr,"lord_talk_ask_location_2", [], "Never mind.", "lord_pretalk",[]],

  [anyone,"lord_talk_ask_location_3", [(call_script, "script_get_information_about_troops_position", "$hero_requested_to_learn_location", 0)],
   "{s1}", "lord_pretalk",[]],

# sango
[anyone|plyr,"lord_talk",[(eq,"$g_encountered_party_faction","$players_kingdom")],"wo xiang zhao mu yi xie bu dui.","npc_talk_1",[]],
[anyone|plyr,"lord_talk",[(eq,"$g_encountered_party_faction","$players_kingdom"),(ge,"$faction_rank","$setting_mintuan_guanzhi_limit"),(eq,"$mintuan",0)],"guan yu bu dui de shi qing.","npc_talk_army",[]],
#mintuan
[anyone,"npc_talk_army",[],"ni lai de zheng hao,qian ji tian ren min zi fa zu zhi le yi zhi bu dui ,wo zheng chou \
bu zhi dao zen me chu li,jiu ba ta men jiao gei ni dai ling ba.","close_window",[(assign,"$mintuan",1),
[set_spawn_radius,1],
[spawn_around_party,reg5,"pt_mintuan"], 
(assign,"$qinweidui",reg(0)),
(party_set_faction,reg(0),"fac_player_faction"),
(party_set_slot, "$qinweidui", slot_party_commander_party, "p_main_party"),
(call_script, "script_party_decide_next_ai_state_under_command", "$qinweidui"),
]],

[party_tpl|pt_mintuan,"start",[],"da ren ,wo men denge hou ni de ming ling.","mintuan_talk",[]],
[anyone|plyr,"mintuan_talk",[],"ji xu qian jin.","close_window",[(assign, "$g_leave_encounter",1)]],
[anyone|plyr,"mintuan_talk",[],"zai zhe li deng dai wo.","close_window",[(party_set_ai_behavior,"$qinweidui",ai_bhvr_hold),
(party_set_ai_object,"$qinweidui",0),(assign, "$g_leave_encounter",1)]],
[anyone|plyr,"mintuan_talk",[],"gen zhe wo.","close_window",[
								(party_set_slot, "$qinweidui", slot_party_commander_party, "p_main_party"),
                                (call_script, "script_party_decide_next_ai_state_under_command", "$qinweidui"),
								(assign, "$g_leave_encounter",1)]],
[anyone|plyr,"mintuan_talk",[],"zai zhe li xun luo.","close_window",[(party_set_ai_behavior,"$qinweidui",ai_bhvr_patrol_party),(assign, "$g_leave_encounter",1)]],
[anyone|plyr,"mintuan_talk",[(store_troop_gold,reg(46),"trp_player"),(ge,reg(46),6000)],"wo yao jing xing ren shi diao zheng","mintuan_talk_1",[
(store_random_in_range,reg(44),troop_join_begin,troop_join_end),(str_store_troop_name,10,reg(44))]],
[anyone,"mintuan_talk_1",[(assign,reg(42),"$quest_prestige"),(val_div,reg(42),200),(val_add,reg(42),10)],"zun ming da ren ,qing zhi shi.","mintuan_talk",[
(troop_remove_gold,"trp_player",6000),(party_add_members,"$qinweidui",reg(44),reg(42))]],
[anyone|plyr,"mintuan_talk",[(store_troop_gold,reg(46),"trp_player"),(ge,reg(46),1000)],"ni de qu mu ji xie ren zuo zhan.","mintuan_talk_2",[]],
[anyone,"mintuan_talk_2",[],"you 10 ge ren jia ru le.","mintuan_talk",[(party_add_members,"$qinweidui","trp_volunteer",4),
(party_add_members,"$qinweidui","trp_voluntary_footman",3),(party_add_members,"$qinweidui","trp_mercenary",2),
(party_add_members,"$qinweidui","trp_perdue",1),(troop_remove_gold,"trp_player",1000)]],
# some bug will appear in above lines, under-re-edit
#gong ji party
[anyone|plyr,"mintuan_talk",[[neg|call_script,"script_cf_check_relation_with_faction","fac_kingdom_caowei"],(lt,"$wei_guoli",50),(store_random_in_range,"$gongji_chengshi",towns_begin,towns_end),
   (store_faction_of_party,reg4,"$gongji_chengshi"),(eq,reg4,"fac_kingdom_caowei")],"wo yao ni qu gong ji wei de cheng chi.","mintuan_talk_gong",[]],

[anyone|plyr,"mintuan_talk",[[neg|call_script,"script_cf_check_relation_with_faction","fac_kingdom_shuhan"],(lt,"$shu_guoli",50),(store_random_in_range,"$gongji_chengshi",towns_begin,towns_end),
   (store_faction_of_party,reg4,"$gongji_chengshi"),(eq,reg4,"fac_kingdom_shuhan")],"wo yao ni qu gong ji shu de cheng chi.","mintuan_talk_gong",[]],

[anyone|plyr,"mintuan_talk",[[neg|call_script,"script_cf_check_relation_with_faction","fac_kingdom_wu"],(lt,"$wu_guoli",50),(store_random_in_range,"$gongji_chengshi",towns_begin,towns_end),
   (store_faction_of_party,reg4,"$gongji_chengshi"),(eq,reg4,"fac_kingdom_wu")],"wo yao ni qu gong ji wu de cheng chi.","mintuan_talk_gong",[]],
   
[anyone,"mintuan_talk_gong",[],"de ling!","close_window",[(party_set_ai_behavior,"$qinweidui",ai_bhvr_attack_party),
(party_set_ai_object,"$qinweidui","$gongji_chengshi"),(assign, "$g_leave_encounter",1)]],
# buy troops
[anyone,"npc_talk_1",[],"wo men di que you xie yu bei bu dui,bu guo ni de you zu gou de gong ji cai neng shi yong ta men.","npc_talk_2",[]],
#troop
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_wei_begin),(lt,reg6,npc_wei_end),(ge,"$quest_prestige",20),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"wei qi bing.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_wei_heavy_cavalry",1),(val_sub,"$quest_prestige",20)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_wei_begin),(lt,reg6,npc_wei_end),(ge,"$quest_prestige",200),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"wei qi bing *10.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_wei_heavy_cavalry",10),(val_sub,"$quest_prestige",190)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_wei_begin),(lt,reg6,npc_wei_end),(ge,"$quest_prestige",18),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"wei bu bing.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_wei_elite_footman",1),(val_sub,"$quest_prestige",18)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_wei_begin),(lt,reg6,npc_wei_end),(ge,"$quest_prestige",180),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"wei bu bing*10.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_wei_elite_footman",10),(val_sub,"$quest_prestige",170)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_wei_begin),(lt,reg6,npc_wei_end),(ge,"$quest_prestige",16),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"wei gong jian shou","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_wei_elite_archer",1),(val_sub,"$quest_prestige",16)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_wei_begin),(lt,reg6,npc_wei_end),(ge,"$quest_prestige",160),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"wei gong jian shou*10","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_wei_elite_archer",10),(val_sub,"$quest_prestige",150)]],

[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_shu_begin),(lt,reg6,npc_shu_end),(ge,"$quest_prestige",16),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"shu qi bing.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_shu_elite_horseman",1),(val_sub,"$quest_prestige",16)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_shu_begin),(lt,reg6,npc_shu_end),(ge,"$quest_prestige",160),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"shu qi bing*10.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_shu_elite_horseman",10),(val_sub,"$quest_prestige",150)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_shu_begin),(lt,reg6,npc_shu_end),(ge,"$quest_prestige",20),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"shu bu bing.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_elite_shu_infantry",1),(val_sub,"$quest_prestige",20)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_shu_begin),(lt,reg6,npc_shu_end),(ge,"$quest_prestige",200),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"shu bu bing*10.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_elite_shu_infantry",10),(val_sub,"$quest_prestige",190)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_shu_begin),(lt,reg6,npc_shu_end),(ge,"$quest_prestige",18),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"shu nu bing","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_shu_strong_crossbowman",1),(val_sub,"$quest_prestige",18)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_shu_begin),(lt,reg6,npc_shu_end),(ge,"$quest_prestige",180),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"shu nu bing*10","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_shu_strong_crossbowman",10),(val_sub,"$quest_prestige",170)]],

[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_wu_begin),(lt,reg6,npc_wu_end),(ge,"$quest_prestige",18),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"wu qi bing.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_wu_elite_rider",1),(val_sub,"$quest_prestige",18)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_wu_begin),(lt,reg6,npc_wu_end),(ge,"$quest_prestige",180),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"wu qi bing*10.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_wu_elite_rider",10),(val_sub,"$quest_prestige",170)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_wu_begin),(lt,reg6,npc_wu_end),(ge,"$quest_prestige",20),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"wu bu bing.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_wu_hard_army",1),(val_sub,"$quest_prestige",20)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_wu_begin),(lt,reg6,npc_wu_end),(ge,"$quest_prestige",200),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"wu bu bing*10.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_wu_hard_army",10),(val_sub,"$quest_prestige",190)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_wu_begin),(lt,reg6,npc_wu_end),(ge,"$quest_prestige",16),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"wu gong jian shou","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_wu_elite_bowman",1),(val_sub,"$quest_prestige",16)]],
[anyone|plyr,"npc_talk_2",[(store_conversation_troop,reg6),(ge,reg6,npc_wu_begin),(lt,reg6,npc_wu_end),(ge,"$quest_prestige",160),
(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"wu gong jian shou*10","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_wu_elite_bowman",10),(val_sub,"$quest_prestige",150)]],
#special troop
[trp_caocao|plyr,"npc_talk_2",[(ge,"$quest_prestige",50),(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"hu wei 1 ming.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_tiger_fighter",1),(val_sub,"$quest_prestige",50)]],
[trp_caocao|plyr,"npc_talk_2",[(ge,"$quest_prestige",500),(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"hu wei 10 ming.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_tiger_fighter",10),(val_sub,"$quest_prestige",450)]],
[trp_caocao|plyr,"npc_talk_2",[(ge,"$quest_prestige",50),(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"dian wei jia shi 1 ming.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_armoured_infantry",1),(val_sub,"$quest_prestige",50)]],
[trp_caocao|plyr,"npc_talk_2",[(ge,"$quest_prestige",500),(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"dian wei jia shi 10 ming.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_armoured_infantry",10),(val_sub,"$quest_prestige",450)]],

[trp_liubei|plyr,"npc_talk_2",[(ge,"$quest_prestige",50),(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"yin qiang wei 1 ming.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_silver_lancer",1),(val_sub,"$quest_prestige",50)]],
[trp_liubei|plyr,"npc_talk_2",[(ge,"$quest_prestige",500),(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"yin qiang wei 10 ming.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_silver_lancer",10),(val_sub,"$quest_prestige",450)]],
[trp_liubei|plyr,"npc_talk_2",[(ge,"$quest_prestige",50),(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"xi liang 1 ming.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_western_liang_valiant_calvary",1),(val_sub,"$quest_prestige",50)]],
[trp_liubei|plyr,"npc_talk_2",[(ge,"$quest_prestige",500),(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"xi liang 10 ming.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_western_liang_valiant_calvary",10),(val_sub,"$quest_prestige",450)]],

[trp_sunquan|plyr,"npc_talk_2",[(ge,"$quest_prestige",50),(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"ma xian 1 ming.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_courage",1),(val_sub,"$quest_prestige",50)]],
[trp_sunquan|plyr,"npc_talk_2",[(ge,"$quest_prestige",500),(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"ma xian 10 ming.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_courage",10),(val_sub,"$quest_prestige",450)]],
[trp_sunquan|plyr,"npc_talk_2",[(ge,"$quest_prestige",50),(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),1)],"gan si 1 ming.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_hundred_dead_warrior",1),(val_sub,"$quest_prestige",50)]],
[trp_sunquan|plyr,"npc_talk_2",[(ge,"$quest_prestige",500),(store_num_free_stacks,reg(0),"p_main_party"),(ge,reg(0),10)],"gan si 10 ming.","npc_talk_2_a",[
(party_add_members,"p_main_party","trp_hundred_dead_warrior",10),(val_sub,"$quest_prestige",450)]],


[anyone,"npc_talk_2_a",[],"shi bing yi jing hua ru ni de zhang xi.","npc_talk_1",[]],

[anyone|plyr,"npc_talk_2",[],"rang wo zai xiang xiang.","close_window",[]],



#  sango end
   
  [anyone|plyr,"lord_talk", [(eq,"$talk_context", tc_party_encounter),
                                 ], "I demand something from you!", "lord_predemand",[]],
  [anyone,"lord_predemand", [], "What do you want?", "lord_demand",[]],
#faction equation simple
  [anyone|plyr,"lord_demand", [(neq,"$g_encountered_party_faction","$players_kingdom")], "Surrender or die!", "lord_ultimatum_surrender",[]],
  
  [anyone,"lord_ultimatum_surrender", [(ge, "$g_encountered_party_relation", 0)], "What? Why do you attack us? Speak you rascal!", "lord_attack_verify",[]],
  
  [anyone|plyr,"lord_attack_verify", [], "Forgive me sir. I don't know what I was thinking.", "lord_attack_verify_cancel",[]],
  [anyone,"lord_attack_verify_cancel", [], "Bah! What nonsense!", "close_window",[(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -1),(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"lord_attack_verify", [], "That is none of your businness. Prepare to fight!", "lord_attack_verify_commit",[]],

  [anyone,"lord_ultimatum_surrender", [], "You will not survive this!", "lord_attack_verify",
   [(store_relation,":rel", "$g_encountered_party_faction","fac_player_faction"),
    (val_sub, ":rel", 1),
    (set_relation,"$g_encountered_party_faction", "fac_player_faction",":rel"),
    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -5),
    ]],
  
  [anyone,"lord_attack_verify_commit", [], "Damn you. You will regret this!", "close_window",
   [(call_script, "script_make_kingdom_hostile_to_player", "$g_encountered_party_faction", -3),
    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -30),
    ]],

  [anyone|plyr,"lord_demand", [], "Forgive me. It's nothing.", "lord_pretalk",[]],

# sango 894 dialogs 1
	[anyone|plyr,"lord_talk", [(eq, "$players_kingdom", "$g_talk_troop_faction")],
		"TODO: I need task.","npc_give_task",[]],# npc_give_task listed appendly
# end sango 894 dialogs 1
##  [anyone|plyr,"lord_talk", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                             (ge, "$g_talk_troop_faction_relation", 0),
##                             ],
##   "I wish to ask for a favor.", "lord_ask_for_favor_ask",[]],

  [anyone|plyr,"lord_talk", [#(eq, "$cheat_mode", 1),
                             #(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                             #(ge, "$g_talk_troop_faction_relation", 10),							 
							 (eq,"$g_encountered_party_faction","$players_kingdom"),
							 (troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
							 (assign,reg46,"$command_time"),
							 (ge,"$command_time",1),
                             ],
   "TODO:I want to suggest a course of action.({reg46} times left)", "lord_suggest_action_ask",[]],

  [anyone|plyr,"lord_talk", [],
   "What are you doing here?", "lord_tell_objective",[]],

  [anyone,"lord_tell_objective", [(troop_slot_eq, "$g_talk_troop", slot_troop_leaded_party, -1)],
   "I don't have a party.", "lord_pretalk",[]],

  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_holding_center)],
   "We are resting at {s1}.", "lord_pretalk",[(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
                                                      (str_store_party_name, s1, ":ai_object")]],

  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_patrolling_around_center)],
   "We are patrolling around {s1}.", "lord_pretalk",[(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
                                                      (str_store_party_name, s1, ":ai_object")]],

  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_raiding_around_center)],
   "We are raiding the country around {s1}.", "lord_pretalk",[(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
                                                               (str_store_party_name, s1, ":ai_object")]],

  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_raiding_village)],
   "We are looting the village of {s1}.", "lord_pretalk",[(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
                                                               (str_store_party_name, s1, ":ai_object")]],

  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_retreating_to_center)],
   "We are retreating to {s1}.", "lord_pretalk",[(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
                                                               (str_store_party_name, s1, ":ai_object")]],

  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_besieging_center)],
   "We are besieging {s1}.", "lord_pretalk",[(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
                                                               (str_store_party_name, s1, ":ai_object")]],

  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_undefined)],
   "We are reconsidering our next objective.", "lord_pretalk",[]],

  [anyone,"lord_tell_objective", [],
   "I don't know: {reg1} {s1}", "lord_pretalk",[(party_get_slot, reg1, "$g_talk_troop_party", slot_party_ai_state),
                                                (party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
                                                               (str_store_party_name, s1, ":ai_object")]],


  [anyone,"lord_talk_preoffer", [], "Yes?", "lord_talk_offer",[]],
  
##  [anyone|plyr,"lord_talk_offer", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                             (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"), #he is not a faction leader!
##                             (call_script, "script_get_number_of_hero_centers", "$g_talk_troop"),
##                             (eq, reg0, 0), #he has no castles or towns
##                             (hero_can_join),
##                             ],
##   "I need capable men like you. Will you join me?", "knight_offer_join",[
##       ]],
  [anyone|plyr,"lord_talk_offer", [],
   "TODO: I want to pay the ransom of one of your prisoners.", "knight_offer_join",[
       ]],
  [anyone|plyr,"lord_talk_offer", [], "Never mind.", "lord_pretalk",[]],

  [anyone ,"knight_offer_join", [(call_script, "script_cf_is_quest_troop", "$g_talk_troop")],
   "TODO: I can't join you, I'm in one of your quests.", "hero_pretalk",[]],

  [anyone ,"knight_offer_join", [(lt, "$g_talk_troop_relation", 5),
                                 (store_character_level,":player_level","trp_player"),
                                 (store_character_level,":talk_troop_level","$g_talk_troop"),
                                 (val_mul,":player_level",2),
                                 (lt, ":player_level", ":talk_troop_level")],
   "You forget your place, {sir/madame}. I do not take orders from the likes of you.", "hero_pretalk",[]],
  
  [anyone ,"knight_offer_join", [
       (assign, ":num_player_companions",0),
       (try_for_range, ":hero_id", heroes_begin, heroes_end),
         (troop_slot_eq, ":hero_id",slot_troop_occupation, slto_player_companion),
         (val_add, ":num_player_companions",1),
       (try_end),
       (assign, reg5, ":num_player_companions"),
       (store_add, reg6, reg5, 1),
       (val_mul, reg6,reg6),
       (val_mul, reg6, 1000),
       (gt, reg6,0)], #note that we abuse the value of reg6 in the next line.
 "I will fight alongside you my friend, but I have this debt of {reg6} denars and I am honor-bound to pay it.\
 If you would give me {reg6} denars, I would settle my debt and then I would be free to join you.", "knight_offer_join_2",[]],
  [anyone ,"knight_offer_join", [(gt,reg6, 100000)], "Join you? I don't think so.", "close_window",[]],
  [anyone ,"knight_offer_join", [], "Yes friend, I will be honored to join you.", "knight_offer_join_2",[]],

  [anyone|plyr,"knight_offer_join_2", [(gt, reg6,0),(store_troop_gold, ":gold", "trp_player"),(gt,":gold",reg6)],
   "I will be happy to pay your debt. Let us ride together from now on.", "knight_offer_join_accept",[(troop_remove_gold, "trp_player",reg6)]],
  [anyone|plyr,"knight_offer_join_2", [(le, reg6,0)], "Then let us ride together from now on.", "knight_offer_join_accept",[]],
   
  [anyone|plyr,"knight_offer_join_2", [(eq, "$talk_context", tc_hero_freed)], "That's good to know. I will think about that...", "close_window",[]],
  [anyone|plyr,"knight_offer_join_2", [(neq, "$talk_context", tc_hero_freed)], "That's good to know. I will think about that.", "hero_pretalk",[]],
  
  
  [anyone ,"knight_offer_join_accept", [(troop_slot_ge, "$g_talk_troop", slot_troop_leaded_party, 1)],
   "I have some trusted men in my party who could be of use to you. What do you want to do with them?", "knight_offer_join_accept_party",[
      ]],
  [anyone ,"knight_offer_join_accept", [], "Ah, it will be good fun.", "close_window",[
      (call_script, "script_recruit_troop_as_companion", "$g_talk_troop"),
      (assign, "$g_leave_encounter",1)
      ]],
  
  [anyone|plyr,"knight_offer_join_accept_party", [], "You can disband your men. I have no need for other troops.", "knight_join_party_disband",[]],
  [anyone|plyr,"knight_offer_join_accept_party", [(troop_get_slot, ":companions_party","$g_talk_troop", slot_troop_leaded_party),
                                       (party_can_join_party,":companions_party","p_main_party"),
      ], "Your men can join my party. We need every man that we can muster.", "knight_join_party_join",[]],
  [anyone|plyr,"knight_offer_join_accept_party", [(is_between,"$g_encountered_party",centers_begin, centers_end)], "Lead your men out of the town. I will meet with you in the wilderness.", "knight_join_party_lead_out",[]],
  [anyone|plyr,"knight_offer_join_accept_party", [(neg|is_between,"$g_encountered_party",centers_begin, centers_end)],
   "Keep leading your party. I will meet with you later.", "knight_join_party_lead_out",[]],


  [anyone ,"knight_join_party_disband", [], "Well, it saddens me to loose those men, but it's your call.\
 I'll disband my soldiers and join your party then.", "close_window",[
      (call_script, "script_recruit_troop_as_companion", "$g_talk_troop"),

      (troop_get_slot, ":companions_party","$g_talk_troop", slot_troop_leaded_party),
      (party_detach, ":companions_party"),
      (remove_party, ":companions_party"),
      (assign, "$g_leave_encounter",1)
      ]],

  [anyone ,"knight_join_party_join", [], "Excellent.\
 Then my lads and I will join your party.", "close_window",[
      (call_script, "script_recruit_troop_as_companion", "$g_talk_troop"),
      (party_remove_members, "p_main_party", "$g_talk_troop", 1),
      
      (troop_get_slot, ":companions_party","$g_talk_troop", slot_troop_leaded_party),
      (assign, "$g_move_heroes", 1),
      (call_script, "script_party_add_party", "p_main_party", ":companions_party"),
      (party_detach, ":companions_party"),
      (remove_party, ":companions_party"),
      (assign, "$g_leave_encounter",1)
      ]],

  [anyone ,"knight_join_party_lead_out", [], "All right then.\
 I'll keep leading my men and patrol this area. Meet with me if you have further orders.", "close_window",[
      (call_script, "script_recruit_troop_as_companion", "$g_talk_troop"),
      (party_remove_members, "p_main_party", "$g_talk_troop", 1),
      
      (troop_get_slot, ":companions_party","$g_talk_troop", slot_troop_leaded_party),
      (party_set_faction, ":companions_party", "fac_player_faction"),
      (party_detach, ":companions_party"),
      (party_set_ai_behavior, ":companions_party", ai_bhvr_patrol_location),
      (party_set_flags, ":companions_party", pf_default_behavior, 0),
      ]],


  [anyone,"lord_enter_service_reject", [], "You arent fooling with me are you!! Now go before I loose my temper.", "close_window",
   [(call_script, "script_change_player_relation_with_troop", "$g_invite_faction_lord", -4),
    (assign, "$g_invite_faction", 0),(assign, "$g_invite_faction_lord", 0),(assign, "$g_invite_offered_center", 0),]],

  [anyone,"lord_ask_enter_service", [(eq, "$g_invite_faction_lord", "$g_talk_troop")], "That is agreeable {playername}.\
 Give me your oath now and I will accept you as my follower and offer you my protection.", "lord_give_oath_go_on",[]],

  [anyone,"lord_ask_enter_service", [(gt, "$players_kingdom", 0),
                                     (faction_get_slot, ":players_lord", "$players_kingdom", slot_faction_leader),
                                     (str_store_troop_name, s5, ":players_lord"),
                                     ], "You are already oath-bound to serve {s5}, are you not?", "lord_give_oath_under_oath_already",[]],
  [anyone|plyr ,"lord_give_oath_under_oath_already", [], "Indeed I am, my lord. Forgive my rambling.", "lord_pretalk",[]],

  [anyone,"lord_ask_enter_service", [(lt, "$g_talk_troop_relation", -5)], "I accept oaths only from my trusted men.", "lord_pretalk",[]],

  
  [anyone,"lord_ask_enter_service", [], "That is agreeable {playername}.\
 Give me your oath now and I will accept you as my follower and offer you my protection.", "lord_give_oath_go_on",[]],

  [anyone|plyr,"lord_give_oath_go_on", [],  "I give you my oath lord, that I will remain as your loyal and devoted {man/follower} as long as my breath remains.\
 I will never act in a way to cause you harm, and I will be at your side to fight your enemies should you need my sword.", "lord_give_oath_go_on_2", []],

  [anyone,"lord_give_oath_go_on_2", [(gt, "$g_invite_offered_center", 0),
                                     (str_store_party_name, s1, "$g_invite_offered_center"),
                                     ],  "Then let it be know that from now on, you are my sworn {man/follower}.\
 I give you my protection and grant you the right to bear arms in my name. Furthormore I give you the fief of {s1} with all its rent and revenues.\
 You have done wisely {playername}. Serve me well and I promise, you will rise high.", "lord_give_oath_5", []],
  
  [anyone,"lord_give_oath_go_on_2", [],  "Then let it be know that from now on, you are my sworn {man/follower}.\
 I give you my protection and grant you the right to bear arms in my name.\
 You have done wisely {playername}. Serve me well and I promise, you will rise high.", "lord_give_oath_5", []],
  
#  [anyone,"lord_ask_enter_service", [(lt, "$g_talk_troop_relation", 10),
#                                     (store_character_level, ":player_level", "trp_player"),
#                                     (lt, ":player_level", 10),
#                                     ], "I know not much about you. Keep serving me {playername}. Prove your loyality, then I will know I can trust you and accept your oath.", "lord_pretalk",[]],

##  [anyone,"lord_ask_enter_service", [], "What kind of oath are you willing to make?", "lord_oath_what_kind",[]],
##
##  [anyone|plyr ,"lord_oath_what_kind", [], "I will give you my oath to serve you for two moths.", "lord_oath_what_kind_2",[(assign, "$temp", 60)]],
##  [anyone|plyr ,"lord_oath_what_kind", [], "I will give you my oath to serve you for three moths.", "lord_oath_what_kind_2",[(assign, "$temp", 90)]],
##  [anyone|plyr ,"lord_oath_what_kind", [], "I will give you my oath to serve you for six moths.", "lord_oath_what_kind_2",[(assign, "$temp", 180)]],
##  [anyone|plyr ,"lord_oath_what_kind", [], "I will give you my oath to serve you indefinitely.", "lord_oath_what_kind_2",[(assign, "$temp", 720)]],
##  [anyone|plyr ,"lord_oath_what_kind", [], "Maybe I should give more thought to this, my lord.", "lord_oath_what_kind_cancel",[]],
##  [anyone ,"lord_oath_what_kind_cancel", [], "What nonsense is this? Now go make up your mind and stop wasting my time.", "close_window",[]],
##
##  [anyone, "lord_oath_what_kind_2", [], "Hmmm. Do you ask for anything in return?", "lord_oath_what_do_you_want",[]],
##  
##  [anyone|plyr, "lord_oath_what_do_you_want", [], "I ask for nothing but your blessing, my lord.", "lord_oath_consider",[(assign,"$temp2",0)]],
##  [anyone|plyr, "lord_oath_what_do_you_want", [], "I only ask for the right to have my own banner, my lord.", "lord_oath_consider",[(assign,"$temp2",1)]],
##  [anyone|plyr, "lord_oath_what_do_you_want", [], "I just ask for the right to hold one castle, my lord.", "lord_oath_consider",[(assign,"$temp2",2)]],
##  [anyone|plyr, "lord_oath_what_do_you_want", [], "I ask for the right to hold two castles, my lord.", "lord_oath_consider",[(assign,"$temp2",4)]],
##  [anyone|plyr, "lord_oath_what_do_you_want", [], "I ask for the right to hold three castles, my lord.", "lord_oath_consider",[(assign,"$temp2",6)]],
##  [anyone|plyr ,"lord_oath_what_do_you_want", [], "Maybe I should give more thought to this, my lord.", "lord_oath_what_kind_cancel",[]],
##  
##  [anyone ,"lord_oath_consider", [
##      (store_character_level, ":player_level", "trp_player"),
##      (store_mul, ":benefit", ":player_level", 5),
##      (val_add, ":benefit", "$temp"),
##      (val_add, ":benefit", "$g_talk_troop_relation"),
##      
##      (store_mul, ":cost", "$temp2", 100),
##      (lt, ":cost", ":benefit"),
##      ], "That is agreeable {playername}. Give me your oath now and I will accept you as my follower and offer you my protection.", "lord_give_oath_go_on",[]],
##
##  [anyone ,"lord_oath_consider", [], "Hmmm. What you ask for is not acceptible {playername}.", "close_window",[]],
##
##  [anyone|plyr,"lord_give_oath_go_on", [(eq, "$temp", 60)],  "I give you my oath lord, that I will remain in your service for two months.\
## During this time, I will be faithful to you,\
## I will not act in a way to cause you harm, and I will be at your side to fight your enemies should you need my sword.", "lord_give_oath_go_on_2", []],
##  [anyone|plyr,"lord_give_oath_go_on", [(eq, "$temp", 90)],  "I give you my oath lord, that I will remain in your service for three months.\
## During this time, I will be faithful to you,\
## I will not act in a way to cause you harm, and I will be at your side to fight your enemies should you need my sword.", "lord_give_oath_go_on_2", []],
##  [anyone|plyr,"lord_give_oath_go_on", [(eq, "$temp", 180)],  "I give you my oath lord, that I will remain in your service for six months.\
## During this time, I will be faithful to you,\
## I will not act in a way to cause you harm, and I will be at your side to fight your enemies should you need my sword.", "lord_give_oath_go_on_2", []],
##  [anyone|plyr,"lord_give_oath_go_on", [(gt, "$temp", 700)],  "I give you my oath lord, that I will remain as your loyal and devoted {man/follower} as long as my breath remains.\
## I will never act in a way to cause you harm, and I will be at your side to fight your enemies should you need my sword.", "lord_give_oath_go_on_2", []],
##  
##  [anyone,"lord_give_oath_go_on_2", [(eq,"$temp2",0)],  "Then let it be know that from now on, you are my sworn {man/follower}.\
## I give you my protection and grant you the right to bear arms in my name.\
## You have done wisely {playername}. Serve me well and I promise, you will rise high.", "lord_give_oath_5", []],
##
##  [anyone,"lord_give_oath_go_on_2", [(eq,"$temp2",1)],  "Then let it be know that from now on, you are my sworn {man/follower}.\
## I give you my protection and grant you the right to hold your own banner.\
## You have done wisely {playername}. Serve me well and I promise, you will rise high.", "lord_give_oath_5", []],
##  
##  [anyone,"lord_give_oath_go_on_2", [(eq,"$temp2",2)],  "Then let it be know that from now on, you are my sworn {man/follower} and vassal.\
## I give you my protection and grant you the right to hold a castle.\
## You have done wisely {playername}. Serve me well and I promise, you will rise high.", "lord_give_oath_5", []],
##
##  [anyone,"lord_give_oath_go_on_2", [(eq,"$temp2",4)],  "Then let it be know that from now on, you are my sworn {man/follower} and vassal.\
## I give you my protection and grant you the right to hold two castles.\
## You have done wisely {playername}. Serve me well and I promise, you will rise high.", "lord_give_oath_5", []],
##
##  [anyone,"lord_give_oath_go_on_2", [],  "Then let it be know that from now on, you are my sworn {man/follower} and vassal.\
## I give you my protection and grant you the right to hold three castles.\
## You have done wisely {playername}. Serve me well and I promise, you will rise high.", "lord_give_oath_5", []],

  [anyone|plyr,"lord_give_oath_5", [],  "I thank you lord.", "lord_give_oath_6", [
    (call_script, "script_player_join_faction", "$g_talk_troop_faction"),
    (try_begin),
      (gt, "$g_invite_offered_center", 0),
      (eq, "$g_invite_faction_lord", "$g_talk_troop"),
      (store_faction_of_party, ":offered_center_faction", "$g_invite_offered_center"),
      (eq, ":offered_center_faction", "$g_talk_troop_faction"),
      (call_script, "script_give_center_to_lord", "$g_invite_offered_center", "trp_player"),
      #TODO: Add xp and gold reward?
      (call_script, "script_end_quest", "qst_join_faction"),
    (try_end),
    (assign, "$g_invite_faction", 0),(assign, "$g_invite_faction_lord", 0),(assign, "$g_invite_offered_center", 0),
    (assign, "$g_leave_encounter",1)]],

  [anyone,"lord_give_oath_6", [],  "I have great hopes for you {playername}. I know you will be worthy of my trust.", "close_window", []],

  

  [anyone,"lord_ask_enter_service", [(str_store_faction_name,5,"$g_talk_troop_faction")], "A wise decision {playername}. Our army is destined to win this war.\
 Now swear before God that you drop all other bonds\
 and from now on you will serve only the {s5}.", "lord_enter_service_swear",[]],
  [anyone|plyr ,"lord_enter_service_swear", [], "I swear. From now on your enemies are my enemies.", "lord_enter_service_swear_accepted",[]],
  [anyone|plyr ,"lord_enter_service_swear", [], "I need some time to think about this.", "lord_enter_service_swear_denied",[]],
  [anyone ,"lord_enter_service_swear_denied", [], "You aren't fooling me are you? Now go make up your mind and\
 stop wasting my time.", "close_window",[]],

  [anyone ,"lord_enter_service_swear_accepted", [(str_store_faction_name,5,"$g_talk_troop_faction")], "Then I welcome you among our ranks.\
 {playername}, from now on, you are a soldier of the {s5}.", "lord_enter_service_swear_accepted_2",
   [
   ]],

  [anyone ,"lord_enter_service_swear_accepted_2", [(str_store_faction_name,5,"$g_talk_troop_faction")],
 "I charge you with attacking our enemies wherever you come across them.\
 Moreover, I and other lords can have missions for you from time to time.\
 Carry out these missions with righteous fury, stay loyal and be brave, and you will rise in the service of the  {s5}. Our strength and resolve is beyond compare, and victory will soon be ours.\
 May God grant victory to our cause.", "close_window",[(assign, "$g_leave_encounter",1)]],



#Active quests
##### TODO: QUESTS COMMENT OUT BEGIN
##  [anyone,"lord_active_mission_1", [], "Yes, have you made any progress on it?", "lord_active_mission_2",[]],
##
##  [anyone|plyr,"lord_active_mission_2",[(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                            (check_quest_active,"qst_capture_prisoners"),
##                            (quest_slot_eq, "qst_capture_prisoners", slot_quest_giver_troop, "$g_talk_troop"),
##                            (quest_get_slot, ":quest_target_amount", "qst_capture_prisoners", slot_quest_target_amount),
##                            (quest_get_slot, ":quest_target_troop", "qst_capture_prisoners", slot_quest_target_troop),
##                            (party_count_prisoners_of_type, ":count_prisoners", "p_main_party", ":quest_target_troop"),
##                            (ge, ":count_prisoners", ":quest_target_amount"),
##                            (assign, reg1, ":quest_target_amount"),
##                            (str_store_troop_name_plural, s1, ":quest_target_troop")],
##   "Indeed. I brought you {reg1} {s1} as prisoners.", "lord_generic_mission_thank",
##   [(quest_get_slot, ":quest_target_amount", "qst_capture_prisoners", slot_quest_target_amount),
##    (quest_get_slot, ":quest_target_troop", "qst_capture_prisoners", slot_quest_target_troop),
##    (party_remove_prisoners, "p_main_party", ":quest_target_troop", ":quest_target_amount"),
##    (party_add_prisoners, "$g_encountered_party", ":quest_target_troop", ":quest_target_amount"),
##    (call_script, "script_succeed_quest", "qst_capture_prisoners", 100)]],
##
##
##  [anyone|plyr,"lord_active_mission_2", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                                    (store_partner_quest,":lords_quest"),
##                                    (eq,":lords_quest","qst_capture_enemy_hero"),
##                                    (assign, ":is_hero_still_prisoner", 0),
##                                    (quest_get_slot, ":quest_target_faction", "qst_capture_enemy_hero", slot_quest_target_faction),
##                                    (party_get_num_prisoner_stacks, ":num_stacks","p_main_party"),
##                                    (try_for_range, ":i_stack", 0, ":num_stacks"),
##                                      (party_prisoner_stack_get_troop_id, ":stack_troop","p_main_party",":i_stack"),
##                                      (troop_is_hero, ":stack_troop"),
##                                      (store_troop_faction, ":stack_faction", ":stack_troop"),
##                                      (eq, ":quest_target_faction", ":stack_faction"),
##                                      (assign, ":is_hero_still_prisoner", 1),
##                                      (quest_set_slot, "qst_capture_enemy_hero", slot_quest_target_troop, ":stack_troop"),
##                                    (try_end),
##                                    (eq, ":is_hero_still_prisoner", 1),
##                                    (str_store_faction_name, s3, ":quest_target_faction")],
##   "Indeed. I have captured a lord from {s3}.", "lord_generic_mission_thank",[(quest_get_slot, ":quest_target_troop", "qst_capture_enemy_hero", slot_quest_target_troop),
##                                                                                         (party_remove_prisoners, "p_main_party", ":quest_target_troop", 1),
##                                                                                         (party_add_prisoners, "$g_encountered_party", ":quest_target_troop", 1), #Adding him to the dungeon
##                                                                                         (call_script, "script_succeed_quest", "qst_capture_enemy_hero", 100)]],
##
##
##  [anyone|plyr,"lord_active_mission_2", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                                         (store_partner_quest,":lords_quest"),
##                                         (eq,":lords_quest","qst_capture_messenger"),
##                                         (quest_get_slot, ":quest_target_troop", ":lords_quest", slot_quest_target_troop),
##                                         (quest_get_slot, ":quest_target_amount", ":lords_quest", slot_quest_target_amount),
##                                         (store_num_parties_destroyed_by_player, ":num_destroyed", "pt_messenger_party"),
##                                         (gt, ":num_destroyed", ":quest_target_amount"),
##                                         (party_count_prisoners_of_type, ":num_prisoners", "p_main_party", ":quest_target_troop"),
##                                         (ge, ":num_prisoners", 1),
##                                         (str_store_troop_name, 3, ":quest_target_troop")],
##   "Indeed sir. I have captured a {s3} my lord.", "lord_generic_mission_thank",[(quest_get_slot, ":quest_target_troop", "qst_capture_messenger", slot_quest_target_troop),
##                                                                     (party_remove_prisoners, "p_main_party", ":quest_target_troop", 1),
##                                                                     (party_add_prisoners, "$g_encountered_party", ":quest_target_troop", 1),#Adding him to the dungeon
##                                                                     (call_script, "script_succeed_quest", "qst_capture_messenger", 100)]],
##  
##
##  [anyone|plyr,"lord_active_mission_2", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                                         (store_partner_quest,":lords_quest"),
##                                         (eq,":lords_quest","qst_raise_troops"),
##                                         (quest_get_slot, ":quest_target_troop", ":lords_quest", slot_quest_target_troop),
##                                         (quest_get_slot, ":quest_target_amount", ":lords_quest", slot_quest_target_amount),
##                                         (party_count_companions_of_type, ":num_companions", "p_main_party", ":quest_target_troop"),
##                                         (ge, ":num_companions", ":quest_target_amount"),
##                                         (assign, reg1, ":quest_target_amount"),
##                                         (str_store_troop_name_plural, 3, ":quest_target_troop")],
##   "Yes, sir. I have raised {reg1} {s3} as you ordered me to, my lord.", "lord_generic_mission_thank",[(quest_get_slot, ":quest_target_troop", "qst_raise_troops", slot_quest_target_troop),
##                                                                                        (quest_get_slot, ":quest_target_amount", "qst_raise_troops", slot_quest_target_amount),
##                                                                                        (party_remove_members, "p_main_party", ":quest_target_troop", ":quest_target_amount"),
##                                                                                        (troop_get_slot, ":cur_lords_party", "$g_talk_troop", slot_troop_leaded_party),
##                                                                                        (gt, ":cur_lords_party", 0),
##                                                                                        (party_add_members, ":cur_lords_party", ":quest_target_troop", ":quest_target_amount"),
##                                                                                        (call_script, "script_succeed_quest", "qst_raise_troops", 100)]],
##
##
##  [anyone|plyr,"lord_active_mission_2", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                                         (store_partner_quest,":lords_quest"),
##                                         (eq,":lords_quest","qst_bring_back_deserters"),
##                                         (quest_get_slot, ":quest_target_troop", ":lords_quest", slot_quest_target_troop),
##                                         (quest_get_slot, ":quest_target_amount", ":lords_quest", slot_quest_target_amount),
##                                         (party_count_prisoners_of_type, ":num_prisoners", "p_main_party", ":quest_target_troop"),
##                                         (ge, ":num_prisoners", ":quest_target_amount"),
##                                         (assign, reg1, ":quest_target_amount")],
##   "Yes sir. I have brought {reg1} deserters as you asked me to.", "lord_generic_mission_thank",[(quest_get_slot, ":quest_target_troop", "qst_bring_back_deserters", slot_quest_target_troop),
##                                                                                     (quest_get_slot, ":quest_target_amount", "qst_bring_back_deserters", slot_quest_target_amount),
##                                                                                     (party_remove_prisoners, "p_main_party", ":quest_target_troop", ":quest_target_amount"),
##                                                                                     (faction_get_slot, ":faction_tier_2_troop", "$g_talk_troop_faction", slot_faction_tier_2_troop),
##                                                                                     (try_begin),
##                                                                                       (gt, ":faction_tier_2_troop", 0),
##                                                                                       (troop_get_slot, ":cur_lords_party", "$g_talk_troop", slot_troop_leaded_party),
##                                                                                       (gt, ":cur_lords_party", 0),
##                                                                                       (party_add_members, ":cur_lords_party", ":faction_tier_2_troop", ":quest_target_amount"),
##                                                                                     (try_end),
##                                                                                     (call_script, "script_succeed_quest", "qst_bring_back_deserters", 100)]],
## 
##
##  [anyone|plyr,"lord_active_mission_2", [], "I am still working on it sir.", "lord_active_mission_3",[]],
##  [anyone|plyr,"lord_active_mission_2", [], "I am afraid I won't be able to do this quest, sir.", "lord_mission_failed",[]],
##                                                                                                                                                   
##  [anyone,"lord_active_mission_3", [], "Good. Keep working. We need to do our best to win this war.", "lord_pretalk",[]],
##
##  [anyone,"lord_mission_failed", [], "I am disappointed {playername}. I was counting on you. Well... It was a long call anyway. Let us hope you will be luckier next time.", "lord_pretalk",
##   [(store_partner_quest,":lords_quest"),
##    (call_script, "script_abort_quest", ":lords_quest", 1)]],
  
##### TODO: QUESTS COMMENT OUT END

#Claim center
##  [anyone,"lord_claim_center_begin", [],
##   "What do you want to do with {s4}?", "lord_claim_center_ask",[]],
##
##  [anyone|plyr,"lord_claim_center_ask", [],
##   "I want to claim it for myself.", "lord_claim_center_2",[]],
##  [anyone|plyr,"lord_claim_center_ask", [],
##   "I will leave it to you my lord. I have no interest in holding {s4}.", "lord_claim_center_leave_to_lord",[]],


##  [anyone,"lord_claim_center_2", [(eq, "$g_player_permitted_castles", 0),],
##   "You are an able warrior {playername} and there is no question of your bravery.\
## Alas, you are not noble born, and there are those who will be upset if I allow you to hold a castle.\
## So, it saddens me but I must decline your request.", "lord_claim_center_deny", []],
##  
##  [anyone|plyr,"lord_claim_center_deny", [],
##   "This is not fair my lord. I shed my blood to take {s4}. Now another {man/master} will rule over it.", "lord_claim_center_deny_2", []],
##  [anyone|plyr,"lord_claim_center_deny", [],
##   "I understand sir. Do as you will.", "lord_claim_center_leave_to_lord", []],
##  [anyone,"lord_claim_center_deny_2", [],
##   "Remember that you gave me your oath {playername}. And you agreed to do as told.", "lord_claim_center_deny_3", []],
##  [anyone,"lord_claim_center_deny_3", [],
##   "Yes sir.", "lord_claim_center_leave_to_lord", []],
##
##  [anyone,"lord_claim_center_leave_to_lord", [],
##   "Very well.  Then I will find a suitable master for {s4}.\
## In recognition of your bravery and service, I give you these 5000 denars.", "lord_pretalk",
##   [(troop_get_slot, ":wealth", "$g_talk_troop", slot_troop_wealth),
##    (val_sub, ":wealth", 6000),
##    (troop_set_slot, "$g_talk_troop", slot_troop_wealth, ":wealth"),
##    (troop_add_gold, "trp_player", 5000),
##
##    (assign, ":new_master", "$g_talk_troop"),
##    (assign, ":max_wealth", 0),
##
##    (try_for_range, ":hero_no", kingdom_heroes_begin, kingdom_heroes_end),
##      (troop_slot_eq, ":hero_no", slot_troop_is_prisoner, 0),
##      (troop_slot_eq, ":hero_no", slot_troop_occupation, slto_kingdom_hero),
##      (store_troop_faction, ":hero_faction", ":hero_no"),
##      (eq, ":hero_faction", "$players_kingdom"),
##      (call_script, "script_get_number_of_hero_centers", "$g_talk_troop"),
##      (assign, ":no_of_owned_centers", reg0),
##      (neg|faction_slot_eq, "$players_kingdom", slot_faction_leader, ":hero_no"),
##      (lt, ":no_of_owned_centers", 2),
##      (troop_get_slot, ":wealth", "$g_talk_troop", slot_troop_wealth),
##      (ge, ":wealth", ":max_wealth"),
##      (assign, ":new_master", ":hero_no"),
##      (assign, ":max_wealth", ":wealth"),
##    (try_end),
##
##    (call_script, "script_give_center_to_lord", "$center_to_be_claimed", ":new_master"),
##    (set_spawn_radius, 1),
##    (spawn_around_party, "$center_to_be_claimed", "pt_old_garrison"),
##    (assign, ":new_party", reg0),
##    (party_set_ai_behavior, ":new_party", ai_bhvr_attack_party),
##    (party_set_ai_object, ":new_party", "p_main_party"),
##    (party_set_flags, ":new_party", pf_default_behavior, 0),
##    (call_script, "script_party_copy", ":new_party", "$center_to_be_claimed"),
##    (party_clear, "$center_to_be_claimed"),
##
##    (faction_get_slot, ":reinforcement_template_a", "$g_talk_troop_faction", slot_faction_reinforcements_a),
##    (faction_get_slot, ":reinforcement_template_b", "$g_talk_troop_faction", slot_faction_reinforcements_b),
##    (party_add_template, "$center_to_be_claimed", ":reinforcement_template_a"),
##    (party_add_template, "$center_to_be_claimed", ":reinforcement_template_b"),
##    ]],
##  
##
##  [anyone,"lord_claim_center_2", [(assign, ":number_of_claimed_centers", 0),
##                                  (try_for_range, ":center_no", centers_begin, centers_end),
##                                    (party_slot_eq, ":center_no", slot_party_type, spt_castle),
##                                    (store_faction_of_party, ":faction_no", ":center_no"),
##                                    (eq, ":faction_no", "fac_player_faction"),
##                                    (party_slot_eq, ":center_no", slot_town_claimed_by_player, 1),
##                                    (val_add, ":number_of_claimed_centers", 1),
##                                  (try_end),
##                                  (lt, ":number_of_claimed_centers", "$g_player_permitted_castles"),
##                                  (assign, reg7, ":number_of_claimed_centers"),
##                                  ],
##   "I had promised you to defend your right to hold {reg7?a:another} castle {playername}. Now I honor that promise.\
## I can think of {no man finer than you/no one better than you} to be the {lord/lady} of {s4}.\
## Renew your oath to me now. Then I will be your liege,\
## and I'll support you and protect you against all those who oppose your claim.",
##  "lord_claim_center_give_oath",[]],
##
##                                    
##  [anyone|plyr,"lord_claim_center_give_oath", [],  "I give you my oath lord, I will forever be faithful to you,\
## I will never act in a way to cause you harm, and I will be at your side to fight your enemies should you need my sword.", "lord_claim_center_direct_3", []],
##  [anyone,"lord_claim_center_direct_3", [],  "You have given your oath of fealty {playername}. I accept your oath and give you the fief of {s4}.\
## Rule it wisely and protect it against our enemies.", "lord_claim_center_direct_4", [
##     (party_set_slot, "$center_to_be_claimed", slot_town_claimed_by_player, 1),
##     (call_script, "script_give_center_to_lord", "$center_to_be_claimed", "trp_player")]],
##  [anyone|plyr,"lord_claim_center_direct_4", [],  "I thank you lord.", "close_window", [(assign, "$g_leave_encounter",1)]],

#Ask for favor
##  [anyone,"lord_ask_for_favor_ask", [],
##   "What is it? I don't have time for personal requests.", "lord_ask_for_favor",[]],
##  [anyone,"lord_ask_for_favor_ask", [],
##   "Say it then. If it's something possible...", "lord_ask_for_favor",[]],
##
##  [anyone|plyr,"lord_ask_for_favor", [],
##   "Nothing my lord. It's not important.", "lord_pretalk",[]],
#Suggest action
  [anyone,"lord_suggest_action_ask", [],
   "What do you suggest?", "lord_suggest_action",[]],


#  [anyone|plyr,"lord_suggest_action", [],
#   "I want to join your faction.", "lord_suggest_join_faction",[]],
#  [anyone,"lord_suggest_join_faction", [],
#   "Alright then.", "lord_give_oath_5",[]],

  [anyone|plyr,"lord_suggest_action", [(neq, "$talk_context", tc_siege_commander),(call_script,"script_command_lord_avalible",3),(eq,reg45,1)],
   "Let us attack an enemy town or castle sir.", "lord_suggest_attack_enemy_castle",[(val_sub,"$command_time",3),]],
  [anyone|plyr,"lord_suggest_action", [(neq, "$talk_context", tc_siege_commander),(call_script,"script_command_lord_avalible",1),(eq,reg45,1)],
   "Let us return back to a friendly town sir.", "lord_suggest_go_to_friendly_town",[(val_sub,"$command_time",1),]],
  [anyone|plyr,"lord_suggest_action", [(neq, "$talk_context", tc_siege_commander),(call_script,"script_command_lord_avalible",2),(eq,reg45,1)],
   "Let us attack an enemy war party sir.", "lord_suggest_attack_enemy_party",[(val_sub,"$command_time",2),]],
  [anyone|plyr,"lord_suggest_action", [(eq, "$talk_context", tc_siege_commander),(call_script,"script_command_lord_avalible",3),(eq,reg45,1)],
   "Let us lift this siege sir.", "lord_suggest_lift_siege",[(val_sub,"$command_time",3),]],
  [anyone|plyr,"lord_suggest_action", [(neq, "$talk_context", tc_siege_commander),(call_script,"script_command_lord_avalible",2),(eq,reg45,1)],
   "Follow me.", "lord_suggest_follow_me",[(val_sub,"$command_time",2),]],
  [anyone|plyr,"lord_suggest_action", [(neq, "$talk_context", tc_siege_commander),(call_script,"script_command_lord_avalible",2),(eq,reg45,1)],
   "Follow someone.", "lord_suggest_follow_other",[(val_sub,"$command_time",2),]],
  [anyone|plyr,"lord_suggest_action", [(neq, "$talk_context", tc_siege_commander),(call_script,"script_command_lord_avalible",1),(eq,reg45,1)],
   "Raid a village.", "lord_suggest_raid_village",[(val_sub,"$command_time",1),]],
#  [anyone|plyr,"lord_suggest_action", [],
#   "CHEAT: LIKE ME.", "lord_pretalk",[(call_script,"script_change_player_relation_with_troop","$g_talk_troop",20)]],

  [anyone,"lord_suggest_lift_siege", [(call_script,"script_try_suggest"),(eq,reg45,1),],
   "Alright then.", "close_window",[(call_script, "script_party_set_ai_state", "$g_talk_troop_party", spai_undefined),
                                           (party_leave_cur_battle, "$g_talk_troop_party"),
                                           (assign, "$g_leave_encounter", 1)]],
  [anyone,"lord_suggest_lift_siege", [],"TODO:I don't think I should do that. Let me think for a while...","close_window",[]],

  [anyone,"lord_suggest_go_to_friendly_town", [],
   "Hmm. Which town or castle do you suggest we go to?", "lord_suggest_go_to_friendly_town2",[]],
  [anyone|plyr|repeat_for_parties,"lord_suggest_go_to_friendly_town2", [
                                                                       (store_repeat_object, ":center_no"),
                                                                       (this_or_next|party_slot_eq,":center_no",slot_party_type, spt_castle),
                                                                       (party_slot_eq,":center_no",slot_party_type, spt_town),
                                                                       (neq, ":center_no", "$g_encountered_party"),
                                                                       (store_faction_of_party, ":town_faction", ":center_no"),
                                                                       (eq, ":town_faction", "$g_talk_troop_faction"),
                                                                       (str_store_party_name, s1, ":center_no")],
   "{s1}", "lord_suggest_go_to_friendly_town3",[(store_repeat_object, "$town_suggested_to_go_to")]],
  [anyone|plyr,"lord_suggest_go_to_friendly_town2", [],
   "Never mind my lord.", "lord_pretalk",[]],

  [anyone,"lord_suggest_go_to_friendly_town3", [(call_script,"script_try_suggest"),(eq,reg45,1),(str_store_party_name, 1, "$town_suggested_to_go_to")],
   "All right then. We go to {s1} now.", "lord_pretalk",
   [
       (call_script, "script_party_set_ai_state", "$g_talk_troop_party", spai_holding_center, "$town_suggested_to_go_to"),
       ]],
  [anyone,"lord_suggest_go_to_friendly_town3", [],"TODO:I don't think I should do that. Let me think for a while...","close_window",[]],

  
  [anyone,"lord_suggest_attack_enemy_party", [(troop_get_slot, ":player_favor", "$g_talk_troop", slot_troop_player_favor),
                                              (lt, ":player_favor", 0)],
   "TODO: No way.", "lord_pretalk",[]],
  
  [anyone,"lord_suggest_attack_enemy_party", [],
   "Hmm. Which party do you suggest we attack?", "lord_suggest_attack_enemy_party2",[]],
  [anyone|plyr|repeat_for_parties,"lord_suggest_attack_enemy_party2", [
                                                                       (store_repeat_object, ":party_no"),
                                                                       (this_or_next|party_slot_eq,":party_no",slot_party_type, spt_kingdom_hero_party),
                                                                       (this_or_next|party_slot_eq,":party_no",slot_party_type, spt_war_party),
                                                                       (party_slot_eq,":party_no",slot_party_type, spt_patrol),
                                                                       (party_is_active, ":party_no"),
                                                                       (store_faction_of_party, ":party_faction", ":party_no"),
                                                                       (store_relation, ":party_relation", ":party_faction", "$g_talk_troop_faction"),
                                                                       (le, ":party_relation", -10),
                                                                       (call_script, "script_get_closest_walled_center", ":party_no"),
                                                                       (assign, ":center_no", reg0),
                                                                       (str_store_party_name, s3, ":center_no"),
                                                                       (str_store_faction_name, s2, ":party_faction"),
                                                                       (str_store_party_name, s1, ":party_no")],
   "{s1} of {s2} around {s3}", "lord_suggest_attack_enemy_party3",[(store_repeat_object, "$suggested_to_attack_party")]],
  [anyone|plyr,"lord_suggest_attack_enemy_party2", [],
   "Never mind my lord.", "lord_pretalk",[]],

  [anyone,"lord_suggest_attack_enemy_party3", [(call_script,"script_try_suggest"),(eq,reg45,1),(str_store_party_name, 1, "$suggested_to_attack_party")],
   "All right then. We attack {s1} now.", "lord_pretalk",
   [
       (call_script, "script_party_set_ai_state", "$g_talk_troop_party", spai_engaging_army, "$suggested_to_attack_party"),
       ]],
  [anyone,"lord_suggest_attack_enemy_party3", [],"TODO:I don't think I should do that. Let me think for a while...","close_window",[]],



##  [anyone,"lord_suggest_attack_enemy_castle", [(troop_get_slot, ":player_favor", "$g_talk_troop", slot_troop_player_favor),
##                                               (lt, ":player_favor", 20)],
##   "Hmm. No, I don't think that's a good idea.", "lord_pretalk",[]],

  [anyone,"lord_suggest_attack_enemy_castle", [],
   "Hmm. Which town or castle do you suggest we attack?", "lord_suggets_attack_enemy_castle2",[]],
  [anyone|plyr|repeat_for_parties,"lord_suggets_attack_enemy_castle2", [
                                                                       (store_repeat_object, ":center_no"),
                                                                       (this_or_next|party_slot_eq,":center_no",slot_party_type, spt_castle),
                                                                       (party_slot_eq,":center_no",slot_party_type, spt_town),
                                                                       (store_faction_of_party, ":town_faction", ":center_no"),
                                                                       (store_relation, ":town_relation", ":town_faction", "$g_talk_troop_faction"),
                                                                       (le, ":town_relation", -10),
                                                                       (str_store_faction_name, s2, ":town_faction"),
                                                                       (str_store_party_name, s1, ":center_no")],
   "{s1} of {s2}", "lord_suggets_attack_enemy_castle3",[(store_repeat_object, "$suggested_to_attack_center")]],
  [anyone|plyr,"lord_suggets_attack_enemy_castle2", [],
   "Never mind my lord.", "lord_pretalk",[]],

  [anyone,"lord_suggets_attack_enemy_castle3", [(call_script,"script_try_suggest"),(eq,reg45,1),(str_store_party_name, 1, "$suggested_to_attack_center")],
   "All right then. We attack {s1} now.", "lord_pretalk",
   [
       (call_script, "script_party_set_ai_state", "$g_talk_troop_party", spai_besieging_center, "$suggested_to_attack_center"),
       
       (assign, ":difference", 35),
       (try_begin),
         (is_between, "$suggested_to_attack_center", towns_begin, towns_end),
         (val_add, ":difference", 15),
       (try_end),
       (call_script, "script_change_player_favor_of_troop", "$g_talk_troop", ":difference"),

       ]],
  [anyone,"lord_suggets_attack_enemy_castle3", [],"TODO:I don't think I should do that. Let me think for a while...","close_window",[]],

  [anyone,"lord_suggest_raid_village", [],
   "Hmm. Which village do you suggest we attack?", "lord_suggest_raid_village_2",[]],
  [anyone|plyr|repeat_for_parties,"lord_suggest_raid_village_2", [
                                                                       (store_repeat_object, ":center_no"),
                                                                       (party_slot_eq,":center_no",slot_party_type, spt_village),
                                                                       (store_faction_of_party, ":town_faction", ":center_no"),
                                                                       (store_relation, ":town_relation", ":town_faction", "$g_talk_troop_faction"),
                                                                       (le, ":town_relation", -10),
                                                                       (str_store_faction_name, s2, ":town_faction"),
                                                                       (str_store_party_name, s1, ":center_no")],
   "{s1} of {s2}", "lord_suggest_raid_village_3",[(store_repeat_object, "$suggested_to_attack_center")]],
  [anyone|plyr,"lord_suggest_raid_village_2", [],
   "Never mind my lord.", "lord_pretalk",[]],

  [anyone,"lord_suggest_raid_village_3", [(call_script,"script_try_suggest"),(eq,reg45,1),(str_store_party_name, s1, "$suggested_to_attack_center")],
   "All right then. We attack {s1} now.", "lord_pretalk",
   [
       (call_script, "script_party_set_ai_state", "$g_talk_troop_party", spai_raiding_around_center, "$suggested_to_attack_center"),
       ]],
  [anyone,"lord_suggest_raid_village_3", [],"TODO:I don't think I should do that. Let me think for a while...","close_window",[]],


  [anyone,"lord_suggest_follow_me", [(call_script,"script_try_suggest"),(eq,reg45,1),],
   "All right. I will follow you.", "lord_pretalk",[(party_set_slot, "$g_talk_troop_party", slot_party_commander_party, "p_main_party"),
                                (call_script, "script_party_decide_next_ai_state_under_command", "$g_talk_troop_party")]],
  [anyone,"lord_suggest_follow_me", [],"TODO:I don't think I should do that. Let me think for a while...","close_window",[]],


  [anyone,"lord_suggest_follow_other", [],
   "Hmm. Who do you want me to follow?", "lord_suggest_follow_other_2",[]],
  [anyone|plyr|repeat_for_parties,"lord_suggest_follow_other_2", [
                                                                       (store_repeat_object, ":party_no"),
                                                                       (party_slot_eq,":party_no",slot_party_type, spt_kingdom_hero_party),
                                                                       (neq, ":party_no", "$g_talk_troop"),
                                                                       (store_faction_of_party, ":party_faction", ":party_no"),
                                                                       (eq, ":party_faction", "$g_talk_troop_faction"),
                                                                       (str_store_party_name, s1, ":party_no")],
   "{s1}", "lord_suggest_follow_other_3",[(store_repeat_object, "$town_suggested_to_go_to")]],
  [anyone|plyr,"lord_suggest_follow_other_2", [],
   "Never mind.", "lord_pretalk",[]],

  [anyone,"lord_suggest_follow_other_3", [(call_script,"script_try_suggest"),(eq,reg45,1),(str_store_party_name, 1, "$town_suggested_to_go_to")],
   "All right then. I will be accompanying {s1}.", "lord_pretalk",
   [
       (party_set_slot, "$g_talk_troop_party", slot_party_commander_party, "$town_suggested_to_go_to"),
       (call_script, "script_party_decide_next_ai_state_under_command", "$g_talk_troop_party"),
       ]],
  [anyone,"lord_suggest_follow_other_3", [],"TODO:I don't think I should do that. Let me think for a while...","close_window",[]],

  [anyone|plyr,"lord_suggest_action", [],
   "Nothing sir. It's not important.", "lord_pretalk",[]],


##### TODO: QUESTS COMMENT OUT BEGIN
#Request Mission


##  [anyone,"lord_request_mission_ask", [(store_partner_quest,":lords_quest"),(ge,":lords_quest",0)],
##   "Well {playername}. You still have not finished the last job I gave you. You should be working on that now.", "lord_pretalk",[]],
##
##  [anyone,"lord_request_mission_ask", [(troop_slot_eq, "$g_talk_troop", slot_troop_does_not_give_quest, 1)],
##   "I don't have any other jobs for you right now.", "lord_pretalk",[]],
##  [anyone,"lord_request_mission_ask", [], "A job eh?", "lord_tell_mission",
##   [
##       (call_script, "script_get_random_kingdom_quest", "$g_talk_troop"),
##       (assign, "$random_quest_no", reg0),
##   ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_deliver_message")],
##   "I need you to deliver a message to lord {s3} who is currently located at {s4}. Get on the road as soon as possible.", "lord_mission_told",
##   [
##     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##     (str_store_troop_name,1,"$g_talk_troop"),
##     (str_store_party_name,2,"$g_encountered_party"),
##     (str_store_troop_name,3,":quest_target_troop"),
##     (str_store_party_name,4,":quest_target_center"),
##     (setup_quest_text,"$random_quest_no"),
##     (try_begin),
##       (is_between, "$g_encountered_party", centers_begin, centers_end),
##       (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##     (else_try),
##       (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##     (try_end),
##   ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_deliver_message_to_lover")],
##   "My dear friend, I have a deep affection for {s3} and I believe she feels the same way for me as well.\
## Alas, her father {s5} finds me unsuitable for her and will do anything to prevent our union.\
## I really need your help. Please, will you take this letter to her? She should be at {s4} at the moment.", "lord_mission_told",
##   [
##     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##     (str_store_troop_name,1,"$g_talk_troop"),
##     (str_store_party_name,2,"$g_encountered_party"),
##     (str_store_troop_name,3,":quest_target_troop"),
##     (str_store_party_name,4,":quest_target_center"),
##     (setup_quest_text,"$random_quest_no"),
##     (try_begin),
##       (is_between, "$g_encountered_party", centers_begin, centers_end),
##       (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##     (else_try),
##       (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##     (try_end),
##   ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_escort_lady")],
##   "My {s7} {s3} is to visit her relatives at {s4}. But of course, with all the trouble on the roads, I want to make sure she's well guarded.\
## You are an able commander {playername} and I believe I can trust her you.\
## I want you to escort her to {s4} and make sure she arrives there safe and sound.", "lord_mission_told",
##   [
##     (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
##     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##     (try_begin),
##       (troop_slot_eq, "$g_talk_troop", slot_troop_daughter, ":quest_object_troop"),
##       (str_store_string, s7, "str_daughter"),
##     (else_try),
##       (str_store_string, s7, "str_wife"),
##     (try_end),
##     (str_store_troop_name,1,"$g_talk_troop"),
##     (str_store_party_name,2,"$g_encountered_party"),
##     (str_store_troop_name,3,":quest_object_troop"),
##     (str_store_party_name,4,":quest_target_center"),
##     (setup_quest_text,"$random_quest_no"),
##     (try_begin),
##       (is_between, "$g_encountered_party", centers_begin, centers_end),
##       (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##     (else_try),
##       (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##     (try_end),
##   ]],
##
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_hunt_down_raiders")],
## "A messenger came with important news a few hours ago.\
## A group of enemy raiders have attacked a village near {s3}.\
## They have murdered anyone who tried to resist, stolen everything they could carry and put the rest to fire.\
## Now, they must be on their way back to their base at {s4}.\
## You must catch them on the way and make them pay for their crimes.", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_object_center", "$random_quest_no", slot_quest_object_center),
##       (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##       (str_store_party_name,3,":quest_object_center"),
##       (str_store_party_name,4,":quest_target_center"),
##    ]],
##  
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_bring_back_deserters")],
## "I am worried about the growing number of deserters. If we don't do something about it, we may soon have noone left to fight in our wars.\
## I want you to go now and bring back {reg1} {s3}. I would ask you to hang the bastards but we are short of men and we need them back in the ranks.", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_amount", "$random_quest_no", slot_quest_target_amount),
##       (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##      
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (str_store_troop_name_plural,3,":quest_target_troop"),
##       (assign, reg1, ":quest_target_amount"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_deliver_supply_to_center_under_siege")],
## "The enemy has besieged {s5}. Our brothers there are doing their best to fend off attacks, but they can't hold for long without supplies.\
## We need someone to take the supplies they need and make it into the town as soon as possible.\
## It's a very dangerous job, but if there's one person who can do it, it's you {playername}.\
## You can take the supplies from seneschal {s3}. When you arrive at {s5}, give them to the seneschal of that town.", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_amount", "$random_quest_no", slot_quest_target_amount),
##       (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##       (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
##       (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##      
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (str_store_troop_name,3,":quest_object_troop"),
##       (str_store_troop_name,4,":quest_target_troop"),
##       (str_store_party_name,5,":quest_target_center"),
##       (assign, reg1, ":quest_target_amount"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_bring_reinforcements_to_siege")],
## "{s4} has besieged {s5} and God willing, that town will not hold for long.\
## Still I promised him to send {reg1} {s3} as reinforcements and I need someone to lead those men.\
## Can you take them to {s4}?", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_amount", "$random_quest_no", slot_quest_target_amount),
##       (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##       (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
##       (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##      
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (str_store_troop_name_plural,3,":quest_object_troop"),
##       (str_store_troop_name,4,":quest_target_troop"),
##       (str_store_party_name,5,":quest_target_center"),
##       (assign, reg1, ":quest_target_amount"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_rescue_lady_under_siege")],
## "The enemy has besieged {s4} and my dear {s7} {s3} has been trapped within the town walls.\
## As you may guess, I am greatly distressed by this. I need a very reliable commander, to rescue her from the town and bring her back to me.\
## Will you do that {playername}?", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##       (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
##
##       (try_begin),
##         (troop_slot_eq, "$g_talk_troop", slot_troop_daughter, ":quest_object_troop"),
##         (str_store_string, s7, "str_daughter"),
##       (else_try),
##         (str_store_string, s7, "str_wife"),
##       (try_end),
##      
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (str_store_troop_name,3,":quest_object_troop"),
##       (str_store_party_name,4,":quest_target_center"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_deliver_message_to_enemy_lord")],
##   "I need to deliver a message to the enemy {playername}. I want you to go to {s4} on my behalf and deliver my message to {s3}.", "lord_mission_told",
##   [
##     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##     (str_store_troop_name,1,"$g_talk_troop"),
##     (str_store_party_name,2,"$g_encountered_party"),
##     (str_store_troop_name,3,":quest_target_troop"),
##     (str_store_party_name,4,":quest_target_center"),
##     (setup_quest_text,"$random_quest_no"),
##     (try_begin),
##       (is_between, "$g_encountered_party", centers_begin, centers_end),
##       (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##     (else_try),
##       (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##     (try_end),
##   ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_bring_prisoners_to_enemy")],
##   "The enemy wants to ransom some of their soldiers that we captured at the last battle.\
## They'll pay 100 denars in return for giving them back {reg1} {s3}.\
## God knows I can use that money so I accepted their offer.\
## Now, what I need is someone to take the prisoners to {s4} and come back with the money.", "lord_mission_told",
##   [
##     (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
##     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##     (quest_get_slot, reg1, "$random_quest_no", slot_quest_target_amount),
##     (str_store_troop_name,1,"$g_talk_troop"),
##     (str_store_party_name,2,"$g_encountered_party"),
##     (str_store_troop_name_plural,3,":quest_object_troop"),
##     (str_store_party_name,4,":quest_target_center"),
##     (setup_quest_text,"$random_quest_no"),
##     (try_begin),
##       (is_between, "$g_encountered_party", centers_begin, centers_end),
##       (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##     (else_try),
##       (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##     (try_end),
##   ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_raise_troops")], "I was inspecting the troops the other day,\
## and there are men out there who don't know which end of the sword is meant for business.\
## Fat lazy bastards. God knows if we are going to win this war, we need hardened warriors.\
## And you are going to raise those warriors for me. I want you to raise {reg1} {s3} and bring them to me.", "lord_mission_told",
##   [
##     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##     (quest_get_slot, reg1, "$random_quest_no", slot_quest_target_amount),
##     (str_store_troop_name,1,"$g_talk_troop"),
##     (str_store_party_name,2,"$g_encountered_party"),
##     (str_store_troop_name_plural,3,":quest_target_troop"),
##     (setup_quest_text,"$random_quest_no"),
##     (try_begin),
##       (is_between, "$g_encountered_party", centers_begin, centers_end),
##       (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##     (else_try),
##       (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##     (try_end),
##   ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_capture_messenger")],
##   "The enemy seems to be preparing for some kind of action and I want to know what their plans are.\
## Capture one of their messengers and bring him to me.", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##      
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (str_store_troop_name,3,":quest_target_troop"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##   ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_kill_local_merchant")],
##   "I owe some money to one of the merchants here in {s3}. I have no intention of paying it back of course,\
## but the wretched man is making such a fuss about it. He threatens to write a letter of complaint to the king.\
## Anyway that fool must be taught his place. I need someone to silence him. For good.", "lord_mission_told_kill_local_merchant",
##   [
##       (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##      
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (str_store_party_name,3,":quest_target_center"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##   ]],
##  
##  [anyone|plyr,"lord_mission_told_kill_local_merchant", [], "Don't worry sir. He will not breath a word.", "lord_mission_accepted_kill_local_merchant",[]],
##  [anyone|plyr,"lord_mission_told_kill_local_merchant", [], "I'm no common murderer sir. Find someone else for your dirty job.", "lord_mission_rejected",[]],
##
##  [anyone,"lord_mission_accepted_kill_local_merchant", [], "Good. I knew I could trust you with this.\
## Talk to your local contacts in the town to learn the whereabouts of the man.\
## Take him out for me and I'll reward you generously {playername}.", "close_window",[(start_quest,"$random_quest_no"),(assign, "$g_leave_encounter",1)]],
##    
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_bring_back_runaway_serfs")],
## "Some of the serfs working on my fields have run away. Ungrateful bastards, I let them fill their bellies plowing my fields and this is how they pay me.\
## Anyway, it seems that they have split into three groups and each group is trying to make its way to {s3} on its own.\
## I want you to catch all three groups on the way and force them back here. And, make sure that they all come back alive.\
## I should really have them hanged for attempting to escape, but we need hands for the upcoming harvest,\
## so I'll let them go off this time with a good beating.", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##      
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (str_store_party_name,3,":quest_target_center"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_follow_spy")],
## "My men suspect a man in this town to be an enemy spy.\
## I should have him arrested and hanged but we guess that very soon he will leave the town to meet his master somewhere in the wilderness.\
## Now, that spy himself is not very important, but the master is a very dangerous man.\
## And if we can capture him the knowledge we gain from him will very valuable.", "lord_tell_mission_follow_spy",[]],
##  [anyone,"lord_tell_mission_follow_spy", [],
## "I want you to wait here until the spy leaves the town. Then you must follow him from a distance until he meets with his master.\
## You must be careful not to be seen by the spy during his travel, or else he may get suspicious and turn back.\
## Once he meets with his master, you must ambush and arrest them and bring them both back to me.\
## Meke sure that you bring them alive because they may have important knowledge.", "lord_mission_told",
##   [
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_capture_enemy_hero")],
## "TODO: Capture a lord from {s3}.", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_faction", "$random_quest_no", slot_quest_target_faction),
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (str_store_faction_name,3,":quest_target_faction"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_lend_companion")],
## "I don't have a job for you right now, but your companion {s3} is a skilled {reg3?lass:fellow}\
## and I need someone with {reg3?her:his} talents. Will you lend {reg3?her:him} to me for a while?", "lord_tell_mission_lend_companion",
##   [
##       (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##       (quest_get_slot, ":quest_target_amount", "$random_quest_no", slot_quest_target_amount),
##       (val_add, ":quest_target_amount", 1),
##       (assign, reg1, ":quest_target_amount"),
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (str_store_troop_name,3,":quest_target_troop"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##       (troop_get_type, reg3, ":quest_target_troop"),
##    ]],
##  [anyone|plyr,"lord_tell_mission_lend_companion", [],
## "How long will you be needing {reg3?her:him} sir?", "lord_tell_mission_lend_companion_2", []],
##  [anyone,"lord_tell_mission_lend_companion_2", [],
## "Just a few days, one week at most.", "lord_mission_told", []],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_capture_conspirators")],
## "TODO: I want you to capture troops in {reg1} conspirator parties that plan to rebel against me and join {s3}.", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##       (assign, reg1, "$qst_capture_conspirators_num_parties_to_spawn"),
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (str_store_troop_name,3,":quest_target_troop"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_defend_nobles_against_peasants")],
## "TODO: I want you to defend {reg1} noble parties against peasants.", "lord_mission_told",
##   [
##       (assign, reg1, "$qst_defend_nobles_against_peasants_num_noble_parties_to_spawn"),
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_incriminate_loyal_commander"),
##                                (quest_get_slot, ":quest_target_troop", "qst_incriminate_loyal_commander", slot_quest_target_troop),
##                                (quest_get_slot, ":quest_object_troop", "qst_incriminate_loyal_commander", slot_quest_object_troop),
##                                (quest_get_slot, ":quest_target_center", "qst_incriminate_loyal_commander", slot_quest_target_center),
##                                (str_store_troop_name,3,":quest_target_troop"),
##                                (str_store_party_name,4,":quest_target_center"),
##                                (str_store_troop_name,5,":quest_object_troop"),
##                                ],
## "That dribbling fool called {s3} is not fit to rule {s4}. And God knows he would have his county [lands?] snatched from him without him even knowing what was happening, were it not for his loyal commander {s5}.\
## As long as he has his commander aiding him, I will not be able to snatch {s4} from him.\
## So I need to get {s5} out of the picture, and I have a plan just to do that... with your help of course...", "lord_tell_mission_incriminate_commander",[]],
##
##  [anyone|plyr,"lord_tell_mission_incriminate_commander", [], "Go on sir. I am all ears.", "lord_tell_mission_incriminate_commander_2",[]],
##  [anyone|plyr,"lord_tell_mission_incriminate_commander", [], "I'd rather not be involved in anything dishonorable against {s3} my lord.", "lord_tell_mission_incriminate_commander_rejected",[]],
##
##  [anyone,"lord_tell_mission_incriminate_commander_rejected", [], "Is that so? I had hoped I could count on you {playername}.\
## Now I see that I have been mistaken. Very well. I will find someone whose loyality I can trust.", "lord_pretalk",
##   [(call_script, "script_change_player_relation_with_troop","$g_talk_troop",-5),
##    (call_script, "script_change_player_honor", 5)]],
##
##  [anyone,"lord_tell_mission_incriminate_commander_2", [], "I have written a fake letter to {s3}\s commander,\
## which suggests that he is conspiring with us to hand over {s4} to me. Now if we can make {s3} believe that the letter is genuine,\
## he will send away his loyal commander {s5}. But how to convince the old fool that the letter is real?", "lord_tell_mission_incriminate_commander_3",[]],
##
##  [anyone|plyr,"lord_tell_mission_incriminate_commander_3", [], "Please continue sir...", "lord_tell_mission_incriminate_commander_4",[]],
##  [anyone|plyr,"lord_tell_mission_incriminate_commander_3", [], "I'd rather not hear anymore. I won't be part of this conspiracy.", "lord_tell_mission_incriminate_commander_rejected",[]],
##
##  [anyone,"lord_tell_mission_incriminate_commander_4", [], "This is where you come into play.\
## You'll take the letter to {s4}, give it to one of your soldiers and instruct him to take it to {s5}.\
## But before doing that, we'll send word to the town guards so that your man will be arrested upon entering the town.\
## The guards will no doubt find the letter on your man and take it to {s3}.\
## They'll torture your man of course to get the truth out of him, but all he can tell is that you gave the letter to him to be handed to {s5}.\
## {s3} knows that you are serving me, and because he's a bloody idiot, he'll believe the whole thing.", "lord_tell_mission_incriminate_commander_5",[]],
##  
##  [anyone|plyr,"lord_tell_mission_incriminate_commander_5", [], "How will I make sure my messenger is arrested upon entering the town?", "lord_tell_mission_incriminate_commander_6",[]],
##  [anyone,"lord_tell_mission_incriminate_commander_6", [], "You don't worry about that {playername}.\
## I will instruct my spies to tip off the guards that an enemy messenger will enter the town.\
## As soon as our man appears at the gates, he will be caught.", "lord_tell_mission_incriminate_commander_7",[]],
##  [anyone,"lord_tell_mission_incriminate_commander_7", [(str_store_troop_name, s8, "$incriminate_quest_sacrificed_troop"),
##                                                        (str_store_troop_name_plural, s9, "$incriminate_quest_sacrificed_troop"),
##      ], "Ah! One more thing.\
## If you send the letter with a simple peasant, {s3} may suspect that something fishy is going on.\
## He may be a halfwit, but he is not a complete fool.\
## Therefore send the letter with someone of rank, with one of your {s9}, perhaps.", "lord_tell_mission_incriminate_commander_8",[]],
##  [anyone|plyr,"lord_tell_mission_incriminate_commander_8", [], "I can't send one of my trusted {s9} to his death sir.", "lord_tell_mission_incriminate_commander_9",[]],
##  [anyone|plyr,"lord_tell_mission_incriminate_commander_8", [], "A {s8} it will be then sir.", "lord_tell_mission_incriminate_commander_fin",[]],
##  [anyone,"lord_tell_mission_incriminate_commander_9", [], "Come on now,  {playername}.\
## Don't be such a sentimental fool. I'll make it up to you generously.\
## Besides soldiers are meant to die for us. That's what we pay them for.", "lord_tell_mission_incriminate_commander_10",[]],
##  [anyone|plyr,"lord_tell_mission_incriminate_commander_10", [], "All right then. A {s8} it will be sir.", "lord_tell_mission_incriminate_commander_fin",[]],
##  [anyone|plyr,"lord_tell_mission_incriminate_commander_10", [], "I can't sacrifice one of my chosen men sir. Sorry.", "lord_tell_mission_incriminate_commander_rejected",[]],
##   
## [anyone,"lord_tell_mission_incriminate_commander_fin", [], "Excellent, I knew I could count on you.\
## Here is the letter you will take with to {s4} and 200 denars for your expenses.\
## Of course you'll get much more than this once you succed your task.", "lord_pretalk",
##   [
##       (quest_get_slot, ":quest_target_troop", "qst_incriminate_loyal_commander", slot_quest_target_troop),
##       (quest_get_slot, ":quest_object_troop", "qst_incriminate_loyal_commander", slot_quest_object_troop),
##       (quest_get_slot, ":quest_target_center", "qst_incriminate_loyal_commander", slot_quest_target_center),
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (str_store_troop_name,3,":quest_target_troop"),
##       (str_store_party_name,4,":quest_target_center"),
##       (str_store_troop_name_plural,5,"$incriminate_quest_sacrificed_troop"),
##       (str_store_troop_name,6,":quest_object_troop"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##       (troop_add_gold, "trp_player",200),
##       (start_quest,"$random_quest_no"),
##    ]],
##
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_capture_prisoners")],
## "A group of my soldiers were captured in a recent skirmish.\
## Thankfully we have got a mutual agreement with the enemy and they will set free those men, but they want us to set free prisoners of equal rank and number.\
## So, I now need to find {reg1} {s3} as prisoners, so that I can exchange them with my captured soldiers.", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_troop", "qst_capture_prisoners", slot_quest_target_troop),
##       (quest_get_slot, ":quest_target_amount", "qst_capture_prisoners", slot_quest_target_amount),
##       (assign,reg1,":quest_target_amount"),
##       (str_store_troop_name,1,"$g_talk_troop"),
##       (str_store_party_name,2,"$g_encountered_party"),
##       (str_store_troop_name_by_count,3,":quest_target_troop",":quest_target_amount"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##  
## 
##
##  [anyone,"lord_tell_mission", [], "No {playername}. I do not need your services at this time.", "lord_pretalk",[]],
##
##
##  [anyone|plyr,"lord_mission_told", [], "As you wish sir. You can count on me.", "lord_mission_accepted",[]],
##  [anyone|plyr,"lord_mission_told", [], "I'm afraid I can't carry out this mission right now, sir.", "lord_mission_rejected",[]],
##
##  [anyone,"lord_mission_accepted", [], "Excellent. Do this {playername}. I really have high hopes for you.", "close_window",
##   [(assign, "$g_leave_encounter",1),
##    (try_begin),
##      (eq, "$random_quest_no", "qst_escort_lady"),
##      (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
##      (troop_set_slot, ":quest_object_troop", slot_troop_cur_center, 0),
##      (troop_join, ":quest_object_troop"),
##    (else_try),
##      (eq, "$random_quest_no", "qst_hunt_down_raiders"),
##      (quest_get_slot, ":quest_object_center", "$random_quest_no", slot_quest_object_center),
##      (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##      (quest_get_slot, ":quest_target_faction", "$random_quest_no", slot_quest_target_faction),
##      (set_spawn_radius, 3),
##      (call_script, "script_cf_create_kingdom_party", ":quest_target_faction", spt_raider),
###      (spawn_around_party,":quest_object_center",":quest_target_party_template"),
##      (assign, ":quest_target_party", reg0),
##      (party_relocate_near_party, reg0, ":quest_object_center"),
##      (quest_set_slot, "$random_quest_no", slot_quest_target_party, ":quest_target_party"),
##      (party_set_ai_behavior,":quest_target_party",ai_bhvr_travel_to_party),
##      (party_set_ai_object,":quest_target_party",":quest_target_center"),
##      (party_set_flags, ":quest_target_party", pf_default_behavior, 0),
##      (party_set_faction,":quest_target_party",":quest_target_faction"),
##      (str_store_troop_name,1,"$g_talk_troop"),
##      (str_store_party_name,2,"$g_encountered_party"),
##      (str_store_party_name,3,":quest_object_center"),
##      (str_store_party_name,4,":quest_target_center"),
##      (setup_quest_text,"$random_quest_no"),
##      (try_begin),
##        (is_between, "$g_encountered_party", centers_begin, centers_end),
##        (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##      (else_try),
##        (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##      (try_end),
##    (else_try),
##      (eq, "$random_quest_no", "qst_bring_reinforcements_to_siege"),
##      (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
##      (quest_get_slot, ":quest_target_amount", "$random_quest_no", slot_quest_target_amount),
##      (troop_get_slot, ":cur_party", "$g_talk_troop", slot_troop_leaded_party),
##      (party_remove_members, ":cur_party", ":quest_object_troop", ":quest_target_amount"),
##      (party_add_members, "p_main_party", ":quest_object_troop", ":quest_target_amount"),
##    (else_try),
##      (eq, "$random_quest_no", "qst_bring_prisoners_to_enemy"),
##      (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
##      (quest_get_slot, ":quest_target_amount", "$random_quest_no", slot_quest_target_amount),
##      (party_add_prisoners, "p_main_party", ":quest_object_troop", ":quest_target_amount"),
##    (else_try),
##      (eq, "$random_quest_no", "qst_deliver_message_to_enemy_lord"),
##      (troop_add_gold, "trp_player",10),
##    (else_try),
##      (eq, "$random_quest_no", "qst_bring_back_runaway_serfs"),
##      (quest_get_slot, ":quest_object_center", "$random_quest_no", slot_quest_object_center),
##      (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##      (quest_get_slot, ":quest_target_party_template", "$random_quest_no", slot_quest_target_party_template),
##
##      (set_spawn_radius, 3),
##      (spawn_around_party,":quest_object_center",":quest_target_party_template"),
##      (assign, "$qst_bring_back_runaway_serfs_party_1", reg0),
##      (party_set_ai_behavior,"$qst_bring_back_runaway_serfs_party_1",ai_bhvr_travel_to_party),
##      (party_set_ai_object,"$qst_bring_back_runaway_serfs_party_1",":quest_target_center"),
##      (party_set_flags, "$qst_bring_back_runaway_serfs_party_1", pf_default_behavior, 0),
##      (spawn_around_party,":quest_object_center",":quest_target_party_template"),
##      (assign, "$qst_bring_back_runaway_serfs_party_2", reg0),
##      (party_set_ai_behavior,"$qst_bring_back_runaway_serfs_party_2",ai_bhvr_travel_to_party),
##      (party_set_ai_object,"$qst_bring_back_runaway_serfs_party_2",":quest_target_center"),
##      (party_set_flags, "$qst_bring_back_runaway_serfs_party_2", pf_default_behavior, 0),
##      (spawn_around_party,":quest_object_center",":quest_target_party_template"),
##      (assign, "$qst_bring_back_runaway_serfs_party_3", reg0),
##      (party_set_ai_behavior,"$qst_bring_back_runaway_serfs_party_3",ai_bhvr_travel_to_party),
##      (party_set_ai_object,"$qst_bring_back_runaway_serfs_party_3",":quest_target_center"),
##      (party_set_flags, "$qst_bring_back_runaway_serfs_party_3", pf_default_behavior, 0),
##      (rest_for_hours, 1, 4),
##    (else_try),
##      (eq, "$random_quest_no", "qst_follow_spy"),
##      (quest_get_slot, ":quest_object_center", "$random_quest_no", slot_quest_object_center),
##      (spawn_around_party, "p_main_party", "pt_spy_partners"),
##      (assign, "$qst_follow_spy_spy_partners_party", reg0),
##      (party_set_position, "$qst_follow_spy_spy_partners_party", pos63),
##      (party_set_ai_behavior, "$qst_follow_spy_spy_partners_party", ai_bhvr_hold),
##      (party_set_flags, "$qst_follow_spy_spy_partners_party", pf_default_behavior, 0),
##      (set_spawn_radius, 0),
##      (spawn_around_party, "$g_encountered_party", "pt_spy"),
##      (assign, "$qst_follow_spy_spy_party", reg0),
##      (party_set_ai_behavior, "$qst_follow_spy_spy_party", ai_bhvr_travel_to_party),
##      (party_set_ai_object, "$qst_follow_spy_spy_party", "$qst_follow_spy_spy_partners_party"),
##      (party_set_flags, "$qst_follow_spy_spy_party", pf_default_behavior, 0),
##      (assign, "$g_leave_town", 1),
##      (rest_for_hours, 2, 4),
##    (else_try),
##      (eq, "$random_quest_no", "qst_lend_companion"),
##      (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##      (party_remove_members, "p_main_party", ":quest_target_troop", 1),
##    (else_try),
##      (eq, "$random_quest_no", "qst_capture_conspirators"),
##      (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##      (spawn_around_party,"p_main_party","pt_conspirator_leader"),
##      (assign, "$qst_capture_conspirators_party_1", reg0),
##      (assign, "$qst_capture_conspirators_num_parties_spawned", 1),
##      (party_set_ai_behavior, "$qst_capture_conspirators_party_1", ai_bhvr_hold),
##      (party_set_flags, "$qst_capture_conspirators_party_1", pf_default_behavior, 0),
##      (party_get_position, pos1, ":quest_target_center"),
##      (call_script, "script_map_get_random_position_around_position_within_range", 17, 19),
##      (party_set_position, "$qst_capture_conspirators_party_1", pos2),
##      (party_get_num_companions, ":num_companions", "$qst_capture_conspirators_party_1"),
##      (val_add, "$qst_capture_conspirators_num_troops_to_capture", ":num_companions"),
##    (else_try),
##      (eq, "$random_quest_no", "qst_defend_nobles_against_peasants"),
##      (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##      (set_spawn_radius, 9),
##      (try_for_range, ":unused", 0, "$qst_defend_nobles_against_peasants_num_peasant_parties_to_spawn"),
##        (spawn_around_party, ":quest_target_center", "pt_peasant_rebels"),
##        (try_begin),
##          (le, "$qst_defend_nobles_against_peasants_peasant_party_1", 0),
##          (assign, "$qst_defend_nobles_against_peasants_peasant_party_1", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_peasant_party_2", 0),
##          (assign, "$qst_defend_nobles_against_peasants_peasant_party_2", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_peasant_party_3", 0),
##          (assign, "$qst_defend_nobles_against_peasants_peasant_party_3", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_peasant_party_4", 0),
##          (assign, "$qst_defend_nobles_against_peasants_peasant_party_4", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_peasant_party_5", 0),
##          (assign, "$qst_defend_nobles_against_peasants_peasant_party_5", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_peasant_party_6", 0),
##          (assign, "$qst_defend_nobles_against_peasants_peasant_party_6", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_peasant_party_7", 0),
##          (assign, "$qst_defend_nobles_against_peasants_peasant_party_7", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_peasant_party_8", 0),
##          (assign, "$qst_defend_nobles_against_peasants_peasant_party_8", reg0),
##        (try_end),
##      (try_end),
##      (set_spawn_radius, 0),
##      (party_get_position, pos1, ":quest_target_center"),
##      (try_for_range, ":unused", 0, "$qst_defend_nobles_against_peasants_num_noble_parties_to_spawn"),
##        (spawn_around_party, ":quest_target_center", "pt_noble_refugees"),
##        (assign, ":cur_noble_party", reg0),
##        (party_set_ai_behavior, ":cur_noble_party", ai_bhvr_travel_to_party),
##        (party_set_ai_object, ":cur_noble_party", ":quest_target_center"),
##	    (party_set_flags, ":cur_noble_party", pf_default_behavior, 0),
##        (call_script, "script_map_get_random_position_around_position_within_range", 13, 17),
##        (party_set_position, ":cur_noble_party", pos2),
##        (party_get_num_companions, ":num_companions", ":cur_noble_party"),
##        (val_add, "$qst_defend_nobles_against_peasants_num_nobles_to_save", ":num_companions"),
##        (try_begin),
##          (le, "$qst_defend_nobles_against_peasants_noble_party_1", 0),
##          (assign, "$qst_defend_nobles_against_peasants_noble_party_1", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_noble_party_2", 0),
##          (assign, "$qst_defend_nobles_against_peasants_noble_party_2", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_noble_party_3", 0),
##          (assign, "$qst_defend_nobles_against_peasants_noble_party_3", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_noble_party_4", 0),
##          (assign, "$qst_defend_nobles_against_peasants_noble_party_4", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_noble_party_5", 0),
##          (assign, "$qst_defend_nobles_against_peasants_noble_party_5", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_noble_party_6", 0),
##          (assign, "$qst_defend_nobles_against_peasants_noble_party_6", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_noble_party_7", 0),
##          (assign, "$qst_defend_nobles_against_peasants_noble_party_7", reg0),
##        (else_try),
##          (le, "$qst_defend_nobles_against_peasants_noble_party_8", 0),
##          (assign, "$qst_defend_nobles_against_peasants_noble_party_8", reg0),
##        (try_end),
##      (try_end),
##    (try_end),
##    (start_quest,"$random_quest_no"),
##    (try_begin),
##      (eq, "$random_quest_no", "qst_lend_surgeon"),
##      (assign, "$g_leave_town_outside", 1),
##      (assign,"$auto_enter_town","$g_encountered_party"),
##      (store_current_hours, "$quest_given_time"),
##      (rest_for_hours, 4),
##      (assign, "$lord_requested_to_talk_to", "$g_talk_troop"),
##    (try_end),
##    ]],
##  [anyone,"lord_mission_rejected", [], "Is that so? Perhaps you are not up for the task anyway...", "close_window",
##   [(assign, "$g_leave_encounter",1),
##    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -1),
##    (troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1),
##    ]],
##

##### TODO: QUESTS COMMENT OUT END

#Leave
  [anyone|plyr,"lord_talk", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 1)], "I must leave now.", "lord_leave_prison",[]],
  [anyone|plyr,"lord_talk", [], "[Leave]", "lord_leave",[]],

##  [anyone,"lord_leave", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##      (lt, "$g_talk_troop_faction_relation", 0),
##      (store_partner_quest,":enemy_lord_quest"),
##      (lt, ":enemy_lord_quest", 0),
##      (troop_slot_eq, "$g_talk_troop", slot_troop_does_not_give_quest, 0),      
##      (call_script, "script_get_random_kingdom_quest", "$g_talk_troop"),
##      (assign, "$random_quest_no", reg0),
##      (ge, "$random_quest_no", 0),
##    ],
##   "Before you leave {playername}... I have something to ask from you. We may be enemies at war, but I hope you think, as I do,\
## that we may still be civil towards each other. So maybe you will be kind enough to help me in a certain matter.", "lord_leave_give_quest",[]],
##
##  [anyone|plyr,"lord_leave_give_quest", [],
##   "I am listening sir.", "enemy_lord_tell_mission",[]],


##  [anyone,"enemy_lord_tell_mission", [(eq,"$random_quest_no","qst_lend_surgeon")],
##   "I have a friend here, an old warrior, who is very sick. Unless he goes under the surgeon's knife soon, he will surely die.\
## He is very dear to me, but he's also a stubborn fool and refuses to have the operation, saying he doesn't trust our physicians here.\
## I have heard that you have a capable surgeon with you. If you let your surgeon come to the town and have a look at him\
## {reg3?she:he} may be able to convince him to the operation. I will be indebted to you if you grant me that.", "lord_mission_told",
##   [
##     (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
##     (str_store_troop_name,1,"$g_talk_troop"),
##     (str_store_party_name,2,"$g_encountered_party"),
##     (str_store_troop_name,3,":quest_object_troop"),
##     (setup_quest_text,"$random_quest_no"),
##     (troop_get_type, reg3, ":quest_object_troop"),
##     (try_begin),
##       (is_between, "$g_encountered_party", centers_begin, centers_end),
##       (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##     (else_try),
##       (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##     (try_end),
##   ]],


  [anyone,"lord_leave_prison", [],
   "We'll meet again.", "close_window",[]],

  [anyone|auto_proceed,"lord_leave", [(faction_slot_eq,"$g_talk_troop_faction",slot_faction_leader,"$g_talk_troop")],
   "Yes you may leave.", "close_window",[(eq,"$talk_context",tc_party_encounter),(assign, "$g_leave_encounter", 1)]],
  [anyone|auto_proceed,"lord_leave", [(ge,"$g_talk_troop_relation",10)],
   "I wish you a good journey {playername}.", "close_window",[(eq,"$talk_context",tc_party_encounter),(assign, "$g_leave_encounter", 1)]],
  [anyone|auto_proceed,"lord_leave", [],
   "Yes, yes. Go.", "close_window",[(eq,"$talk_context",tc_party_encounter),(assign, "$g_leave_encounter", 1)]],


#Royal family members

  [anyone|plyr,"member_chat", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady)],
   "Are you enjoying the journey my lady?", "lady_journey_1",[]],
  [anyone,"lady_journey_1", [],
   "I am doing fine {playername}. Thank you.", "close_window",[]],
  
##### TODO: QUESTS COMMENT OUT BEGIN
##  [anyone,"start", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
##                    (check_quest_active, "qst_duel_for_lady"),
##                    (check_quest_succeeded, "qst_duel_for_lady"),
##                    (quest_slot_eq, "qst_duel_for_lady", slot_quest_giver_troop, "$g_talk_troop"),
##                    (quest_get_slot, ":quest_target_troop", "qst_duel_for_lady", slot_quest_target_troop),
##                    (str_store_troop_name, s3, ":quest_target_troop"),
##                    (le,"$talk_context",tc_siege_commander),
##                    ],
##   "My dear {playername}, how good to see you again. I heard you gave that vile {s3} the lesson he deserved.\
## I hope he never forgets his humiliation.\
## And I have a reward for you. It's nothing compared to what you have done for me, but...", "lady_qst_duel_for_lady_succeeded_1",[]],
##  [anyone|plyr,"lady_qst_duel_for_lady_succeeded_1", [], "Speak not of it my lady. I merely served the truth.", "lady_qst_duel_for_lady_succeeded_2",[]],
##  [anyone|plyr,"lady_qst_duel_for_lady_succeeded_1", [], "No need to reward me my lady. I would kick {s2}'s butt for the joy of it.", "lady_qst_duel_for_lady_succeeded_2",[]],
##  [anyone,"lady_qst_duel_for_lady_succeeded_2", [], "{playername}, what a dear friend you are. But I insist you take this.\
## Don't worry. I have plenty more. And I am sure you can put it to better use than I do. I would spend it all on fancy dresses and jewelry anyway.", "lady_pretalk",
##   [(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 10),
##    (add_xp_as_reward, 1000),
##    (troop_add_gold, "trp_player", 2000),
##    (complete_quest,"qst_duel_for_lady"),]],
##
##  [anyone,"start", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
##                    (check_quest_active, "qst_duel_for_lady"),
##                    (check_quest_failed, "qst_duel_for_lady"),
##                    (le,"$talk_context",tc_siege_commander),
##                    (quest_slot_eq, "qst_duel_for_lady", slot_quest_giver_troop, "$g_talk_troop")],
##   "I heard that you went against {s3} to prove my innocence {playername}. I thank you for it.", "lady_qst_duel_for_lady_failed", []],
##  [anyone|plyr,"lady_qst_duel_for_lady_failed", [], "I am so sorry I couldn't defeat him my lady.", "lady_qst_duel_for_lady_failed_2",[]],
##  [anyone,"lady_qst_duel_for_lady_failed_2", [], "You tried, and that alone speaks a lot.\
## It's a ridiculous idea anyway, that truth can be proven with swords.\
## You have put your life at risk for my honor. That should alone convince people of my innocence, {playername}.", "lady_pretalk",
##   [(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 10),
##    (add_xp_as_reward, 1000),
##    (complete_quest,"qst_duel_for_lady"),
##    ]],
##
##
##  [anyone,"start", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
##                    (check_quest_active, "qst_escort_lady"),
##                    (eq,"$talk_context",tc_entering_center_quest_talk),
##                    (quest_slot_eq, "qst_escort_lady", slot_quest_object_troop, "$g_talk_troop")],
##   "Thank you for escorting me here {playername}. Please, accept this as a gift from me. I hope we'll meet again.", "lady_generic_mission_succeeded",[(quest_get_slot, ":cur_center", "qst_escort_lady", slot_quest_target_center),
##                                                                                                       (call_script, "script_succeed_quest", "qst_escort_lady", 100),
##                                                                                                       (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 2),
##                                                                                                       (troop_set_slot, "$g_talk_troop", slot_troop_cur_center, ":cur_center"),
##                                                                                                       (remove_member_from_party,"$g_talk_troop")]],
##                                                                                     
##  [anyone,"start", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
##                    (le,"$talk_context",tc_siege_commander),
##                    (check_quest_active, "qst_rescue_lord_by_replace"),
##                    (check_quest_succeeded, "qst_rescue_lord_by_replace"),
##                    (quest_slot_eq, "qst_rescue_lord_by_replace", slot_quest_giver_troop, "$g_talk_troop"),
##                    (troop_get_slot, ":cur_lord", "$g_talk_troop", slot_troop_father),
##                    (try_begin),
##                      (gt, ":cur_lord", 0),
##                      (str_store_string, 7, "str_father"),
##                    (else_try),
##                      (str_store_string, 7, "str_husband"),
##                    (try_end)],
##   "TODO: Thank you so much for rescuing my {s7}. Here is your reward.", "lady_generic_mission_succeeded",[(call_script, "script_succeed_quest", "qst_rescue_lord_by_replace")]],
##
##  [anyone|plyr,"lady_generic_mission_succeeded", [], "TODO: It's an honor to serve you milady.", "lady_pretalk",[]],
##### TODO: QUESTS COMMENT OUT END


  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_lady),
                     (eq, "$g_talk_troop_met", 0),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "You don't look familiar...", "lady_premeet", []],
  [anyone|plyr ,"lady_premeet", [],  "I am {playername} madam.", "lady_meet", []],
  [anyone|plyr ,"lady_premeet", [],  "My name is {playername}. At your service my lady.", "lady_meet", []],

  [anyone, "lady_meet", [],  "I don't think I have heard of you before.", "lady_meet_end", []],

  [anyone, "lady_meet_end", [],  "Yes?", "lady_talk", []],

  [anyone,"start", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
                    (le,"$talk_context",tc_siege_commander),
                    ],
   "Yes?", "lady_talk",[]],

##### TODO: QUESTS COMMENT OUT BEGIN
##  [anyone|plyr,"lady_talk", [(check_quest_active, "qst_deliver_message_to_lover"),
##                             (quest_slot_eq, "qst_deliver_message_to_lover", slot_quest_target_troop, "$g_talk_troop"),
##                             (quest_get_slot, ":troop_no", "qst_deliver_message_to_lover", slot_quest_giver_troop),
##                             (str_store_troop_name, 3, ":troop_no")],
##   "I have brought you a message from {s3}", "lady_message_from_lover_success",[(call_script, "script_succeed_quest", "qst_deliver_message_to_lover", 100)]],
##
##  [anyone|plyr,"lady_talk", [(check_quest_active, "qst_rescue_lady_under_siege"),
##                             (quest_slot_eq, "qst_rescue_lady_under_siege", slot_quest_object_troop, "$g_talk_troop"),
##                             (quest_slot_eq, "qst_rescue_lady_under_siege", slot_quest_current_state, 0)],
##   "TODO: I'm taking you home!", "lady_rescue_from_siege_check",[]],
##
##
##  [anyone,"lady_rescue_from_siege_check", [(neg|hero_can_join)],
##   "TODO: You don't have enough room for me!", "close_window",[]],
##
##
##  [anyone,"lady_rescue_from_siege_check", [], "TODO: Thank you so much!", "lady_pretalk",[(quest_set_slot, "qst_rescue_lady_under_siege", slot_quest_current_state, 1),
##                                                                                          (troop_set_slot, "$g_talk_troop", slot_troop_cur_center, 0),
##                                                                                          (troop_join, "$g_talk_troop")]],
##  [anyone,"lady_message_from_lover_success", [], "TODO: Thank you so much!", "lady_pretalk",[]],
##
##  [anyone,"lady_pretalk", [], "Anything else?", "lady_talk",[]],
##
##  [anyone|plyr,"lady_talk", [(eq, 1, 0),
##                             (store_partner_quest,":ladys_quest"),
##                             (lt, ":ladys_quest", 0)],
##   "Do you have any quests for me?", "lady_ask_for_quest",[(call_script, "script_get_random_kingdom_quest", "$g_talk_troop"),
##                                                                 (assign, "$random_quest_no", reg0)]],
##
##  [anyone,"lady_ask_for_quest", [(troop_slot_eq, "$g_talk_troop", slot_troop_does_not_give_quest, 1)],
##   "I don't have any other missions for you right now.", "lady_pretalk",[]],
##  
##  [anyone,"lady_ask_for_quest", [(eq, "$random_quest_no", "qst_rescue_lord_by_replace")],
##   "My {s7} {s3} is a prisoner in the dungeon of {s4}.\
## We have tried to negotiate his ransom but there is no way we can raise that much money without selling all our estates, and God knows {s3} would rather spend his life in prison than do that.\
## So I have made a plan to get him out of there but it requires somone to make a great sacrifice. Would you do it?", "lady_mission_told",
##   [(quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##    (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##
##    (try_begin),
##      (troop_get_slot, ":cur_lord", "$g_talk_troop", slot_troop_spouse),
##      (gt, ":cur_lord", 0),
##      (str_store_string, 7, "str_husband"),
##    (else_try),
##      (str_store_string, 7, "str_father"),
##    (try_end),
##    
##    (str_store_troop_name,1,"$g_talk_troop"),
##    (str_store_party_name,2,"$g_encountered_party"),
##    (str_store_troop_name,3,":quest_target_troop"),
##    (str_store_party_name,4,":quest_target_center"),
##    (setup_quest_text,"$random_quest_no"),
##    (try_begin),
##      (is_between, "$g_encountered_party", centers_begin, centers_end),
##      (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##    (else_try),
##      (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##    (try_end),
##    ]],
##
##  [anyone,"lady_ask_for_quest", [(eq, "$random_quest_no", "qst_deliver_message_to_prisoner_lord")],
##   "My {s7} {s3} is a prisoner in the dungeon of {s4}. Could you take him a message from me?", "lady_mission_told",
##   [(quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##    (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##
##    (try_begin),
##      (troop_get_slot, ":cur_lord", "$g_talk_troop", slot_troop_spouse),
##      (gt, ":cur_lord", 0),
##      (str_store_string, 7, "str_husband"),
##    (else_try),
##      (str_store_string, 7, "str_father"),
##    (try_end),
##    
##    (str_store_troop_name,1,"$g_talk_troop"),
##    (str_store_party_name,2,"$g_encountered_party"),
##    (str_store_troop_name,3,":quest_target_troop"),
##    (str_store_party_name,4,":quest_target_center"),
##    (setup_quest_text,"$random_quest_no"),
##    (try_begin),
##      (is_between, "$g_encountered_party", centers_begin, centers_end),
##      (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##    (else_try),
##      (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##    (try_end),
##    ]],
##  
##
##  [anyone,"lady_ask_for_quest", [(eq, "$random_quest_no", "qst_duel_for_lady")],
##   "My dear {playername}. You don't know my trobules. But I can't possibly ask you to throw yourself into danger for me.", "lady_quest_duel_for_lady",[]],
##  [anyone|plyr,"lady_quest_duel_for_lady", [], "Please my lady. Tell me what troubles you, and I will do my best to relieve you... if it's in my power.", "lady_quest_duel_for_lady_2",[
##    (quest_get_slot, ":quest_object_center", "$random_quest_no", slot_quest_object_center),
##    (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##
##    (str_store_troop_name,1,"$g_talk_troop"),
##    (str_store_party_name,2,"$g_encountered_party"),
##    (str_store_troop_name,3,":quest_target_troop"),
##    (str_store_party_name,4,":quest_object_center"),
##    (setup_quest_text,"$random_quest_no"),
##    (try_begin),
##      (is_between, "$g_encountered_party", centers_begin, centers_end),
##      (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##    (else_try),
##      (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##    (try_end),
##    ]],
##  [anyone,"lady_quest_duel_for_lady_2", [], "Oh {playername}, you are so kind.\
## One of my husband's enemies, {s3} is making terrible accusations against me. He can't harm my husband, so he's targeting my honor to hurt us.\
## The lies he tells everyone... Oh, they are so awful! I cannot stand to repeat them... I wish there was someone brave enough to make him recant his slander.\
## But {s3} is a vile and dangerous man, and everyone is afraid of his wrath.", "lady_quest_duel_for_lady_3",[]],
##
##  [anyone|plyr,"lady_quest_duel_for_lady_3", [], "Not me my lady. I will go and make him eat his dirty lies.", "lady_quest_duel_for_lady_3_accepted",[]],
##  [anyone,"lady_quest_duel_for_lady_3_accepted", [], "You are such a dear friend {playername}. Will you really do that for me? I will forever be indebted to you. Thank you. I will be praying for you.", "close_window",
##   [(start_quest,"$random_quest_no")]],
##
##  [anyone|plyr,"lady_quest_duel_for_lady_3", [], "If he is such a dangerous man my lady, maybe it would be better to let this go.", "lady_quest_duel_for_lady_3_rejected",[]],
##  [anyone,"lady_quest_duel_for_lady_3_rejected", [], "Oh? Well... maybe you are right {playername}. It seems that the valour of which the troubadours sing no longer exists in this fallen world. Good day to you.", "close_window",
##   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1),
##    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -2),
##    ]],
##
##
##
##  [anyone,"lady_ask_for_quest", [], "No {playername}. I do not need your services at this time.", "lady_pretalk",[]],
##
##  [anyone|plyr,"lady_mission_told", [], "As you wish my lady. You can count on me.", "lady_mission_accepted",[]],
##  [anyone|plyr,"lady_mission_told", [], "I'm afraid I can't carry out this mission right now, my lady.", "lady_mission_rejected",[]],
##
##  [anyone,"lady_mission_accepted", [], "Excellent. Do this {playername}. I really have high hopes for you.", "close_window",
##   [
##    (try_begin),
##      (eq, "$random_quest_no", "qst_deliver_message_to_prisoner_lord"),
##      (troop_add_gold, "trp_player",10),
##    (try_end),
##    (start_quest,"$random_quest_no")
##    ]],
##  [anyone,"lady_mission_rejected", [], "Is that so? Perhaps you are not up for the task anyway... Then I'll just have to find someone who's more reliable than you are.", "close_window",
##   [#TODO: Reduce relation
##    (troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1),
##    ]],
##### TODO: QUESTS COMMENT OUT END


#Leave
  [anyone|plyr,"lady_talk", [], "[Leave]", "lady_leave",[]],
  
  [anyone|auto_proceed,"lady_leave", [], "Yes you may leave.", "close_window",[(eq,"$talk_context",tc_party_encounter),(assign, "$g_leave_encounter", 1)]],
  

#Seneschal

  [anyone,"start", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_seneschal),
                    (eq, "$talk_context", tc_siege_won_seneschal),
                    (str_store_party_name, s1, "$g_encountered_party"),
                    ],
   "I congratulate you on your victory, my {lord/lady}. Welcome to {s1}. We, the servants of this castle, are at your service.", "siege_won_seneschal_1",[]],
  [anyone|plyr,"siege_won_seneschal_1", [], "Are you the seneschal of the castle?", "siege_won_seneschal_2",[]],
  [anyone,"siege_won_seneschal_2", [], "Yes my {lord/lady}. And may I say that I have up to now served the previous masters of {s1} most satisfactorily.\
 If you let me keep my post as seneschal here, I promise you will not be disappointed.", "siege_won_seneschal_3",[]],
  [anyone|plyr,"siege_won_seneschal_3", [], "All right. You can keep your post for the time being.", "siege_won_seneschal_4",[]],
  [anyone|plyr,"siege_won_seneschal_3", [], "You can stay as the seneschal. But be careful. If I catch you stealing, you'll pay with your head.", "siege_won_seneschal_4",[]],
  [anyone,"siege_won_seneschal_4", [], "Thank you my {lord/lady}. And I if you don't mind my asking, what will you do with the castle?", "siege_won_seneschal_5",[]],

  [anyone|plyr,"siege_won_seneschal_5", [], "I will sell it to another lord.", "siege_won_seneschal_6",[]],
  [anyone|plyr,"siege_won_seneschal_5", [], "I will claim it for myself.", "siege_won_seneschal_6",[]],
  
  [anyone|plyr,"siege_won_seneschal_5", [], "I haven't given much tought to it until now. What are my options?", "siege_won_seneschal_list_options",[]],

  [anyone,"siege_won_seneschal_list_options", [], " You can place a garrison here, to protect it against any immediate attack,\
 and then sell the castle to another lord. I am sure you can get a hefty sum for it.\
 If you don't want to sell it then you must find yourself a lord who will accept to be your protector and your liege.\
 The ancient laws dictate that any lord who holds a castle must have been granted it by a greater lord.\
 ", "siege_won_seneschal_list_options_2",[]],

  [anyone|plyr,"siege_won_seneschal_list_options_2", [], "What do you mean granted by a higher lord? I took this castle with my sword you dimwit!", "siege_won_seneschal_list_options_3",[]],
  [anyone,"siege_won_seneschal_list_options_3", [], "Of course you have my lord, of course you have.\
 But the other lords will not recognize you as the rightful owner of the castle unless you give your oath to one of them and promise to serve him,\
 and he, in turn, accepts you as his vassal. It's our law and custom.", "siege_won_seneschal_list_options_4",[]],
  [anyone|plyr,"siege_won_seneschal_list_options_4", [], "Hmm. I'll think about it then.", "siege_won_seneschal_6",[]],

  [anyone,"siege_won_seneschal_6", [], "I am very pleased to hear that my {lord/lady}. I will serve you to the best of my ability.\
 If you need my services, at any time, you can always find me at the castle hall.", "close_window",[]],

  
  [anyone,"start", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_seneschal),(eq,"$g_talk_troop_met",0),(str_store_party_name,s1,"$g_encountered_party")],
   "Good day {sir/madam}. I don't think I have seen you here before. I am the seneschal of {s1}.", "seneschal_intro_1",[]],
  [anyone|plyr,"seneschal_intro_1", [],  "Good to meet you seneschal.", "seneschal_intro_1a",[]],
  [anyone,"seneschal_intro_1a", [], "How can I help you?", "seneschal_talk",[]],
  [anyone|plyr,"seneschal_intro_1", [],  "What does a seneschal do?", "seneschal_intro_1b",[]],
  [anyone,"seneschal_intro_1b", [], "Well, I collect rents from my lord's estates, manage the castle's storerooms,\
 and in general take care of all the mundane matters on behalf of my lord.\
 I don't deal with military matters of course. I am not a soldier, you see.", "seneschal_talk",[]],
  
  [anyone,"start", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_seneschal)],
   "Good day {sir/madam}.", "seneschal_talk",[]],

  [anyone,"seneschal_pretalk", [], "Anything else?", "seneschal_talk",[]],


##### TODO: QUESTS COMMENT OUT BEGIN
##  [anyone|plyr,"seneschal_talk", [(check_quest_active, "qst_deliver_supply_to_center_under_siege"),
##                                  (quest_slot_eq, "qst_deliver_supply_to_center_under_siege", slot_quest_target_troop, "$g_talk_troop"),
##                                  (quest_slot_eq, "qst_deliver_supply_to_center_under_siege", slot_quest_current_state, 1),
##                                  (store_item_kind_count, ":no_supplies", "itm_siege_supply"),
##                                  (quest_get_slot, ":target_amount", "qst_deliver_supply_to_center_under_siege", slot_quest_target_amount),
##                                  (ge, ":no_supplies", ":target_amount")],
##   "TODO: Here are the supplies.", "seneschal_supplies_given",[]],
##
##  [anyone|plyr,"seneschal_talk", [(check_quest_active, "qst_deliver_supply_to_center_under_siege"),
##                                  (quest_slot_eq, "qst_deliver_supply_to_center_under_siege", slot_quest_target_troop, "$g_talk_troop"),
##                                  (quest_slot_eq, "qst_deliver_supply_to_center_under_siege", slot_quest_current_state, 1),
##                                  (store_item_kind_count, ":no_supplies", "itm_siege_supply"),
##                                  (quest_get_slot, ":target_amount", "qst_deliver_supply_to_center_under_siege", slot_quest_target_amount),
##                                  (lt, ":no_supplies", ":target_amount"),
##                                  (gt, ":no_supplies", 0)],
##   "TODO: Here are the supplies, but some of them are missing.", "seneschal_supplies_given_missing",[]],
##  
##  [anyone|plyr,"seneschal_talk", [(check_quest_active, "qst_deliver_supply_to_center_under_siege"),
##                                  (quest_slot_eq, "qst_deliver_supply_to_center_under_siege", slot_quest_object_troop, "$g_talk_troop"),
##                                  (quest_slot_eq, "qst_deliver_supply_to_center_under_siege", slot_quest_current_state, 0)],
##   "TODO: Give me the supplies.", "seneschal_supplies",[]],
##  
##  [anyone,"seneschal_supplies", [(store_free_inventory_capacity, ":free_inventory"),
##                                 (quest_get_slot, ":quest_target_amount", "qst_deliver_supply_to_center_under_siege", slot_quest_target_amount),
##                                 (ge, ":free_inventory", ":quest_target_amount"),
##                                 (quest_get_slot, ":quest_target_center", "qst_deliver_supply_to_center_under_siege", slot_quest_target_center),
##                                 (str_store_party_name, 0, ":quest_target_center"),
##                                 (troop_add_items, "trp_player", "itm_siege_supply", ":quest_target_amount")],
##   "TODO: Here, take these supplies. You must deliver them to {s0} as soon as possible.", "seneschal_pretalk",[(quest_set_slot, "qst_deliver_supply_to_center_under_siege", slot_quest_current_state, 1)]],
##
##  [anyone,"seneschal_supplies", [],
##   "TODO: You don't have enough space to take the supplies. Free your inventory and return back to me.", "seneschal_pretalk",[]],
##
##
##  [anyone,"seneschal_supplies_given", [],
##   "TODO: Thank you.", "seneschal_pretalk",[(party_get_slot, ":town_siege_days", "$g_encountered_party", slot_town_siege_days),
##                                            (quest_get_slot, ":target_amount", "qst_deliver_supply_to_center_under_siege", slot_quest_target_amount),
##                                            (val_sub, ":town_siege_days", ":target_amount"),
##                                            (try_begin),
##                                              (lt, ":town_siege_days", 0),
##                                              (assign, ":town_siege_days", 0),
##                                            (try_end),
##                                            (party_set_slot, "$g_encountered_party", slot_town_siege_days, ":town_siege_days"),
##                                            (troop_remove_items, "trp_player", "itm_siege_supply", ":target_amount"),
##                                            (call_script, "script_succeed_quest", "qst_deliver_supply_to_center_under_siege", 100)]],
##
##  [anyone,"seneschal_supplies_given_missing", [],
##   "TODO: Thank you but it's not enough...", "seneschal_pretalk",[(store_item_kind_count, ":no_supplies", "itm_siege_supply"),
##                                                                  (quest_get_slot, ":target_amount", "qst_deliver_supply_to_center_under_siege", slot_quest_target_amount),
##                                                                  (assign, ":percentage_completed", 100),
##                                                                  (val_mul, ":percentage_completed", ":no_supplies"),
##                                                                  (val_div, ":percentage_completed", ":target_amount"),
##                                                                  (call_script, "script_succeed_quest", "qst_deliver_supply_to_center_under_siege", ":percentage_completed"),
##                                                                  (party_get_slot, ":town_siege_days", "$g_encountered_party", slot_town_siege_days),
##                                                                  (val_sub, ":town_siege_days", ":no_supplies"),
##                                                                  (try_begin),
##                                                                    (lt, ":town_siege_days", 0),
##                                                                    (assign, ":town_siege_days", 0),
##                                                                  (try_end),
##                                                                  (party_set_slot, "$g_encountered_party", slot_town_siege_days, ":town_siege_days"),
##                                                                  (troop_remove_items, "trp_player", "itm_siege_supply", ":no_supplies"),
##                                                                  (complete_quest,"qst_deliver_supply_to_center_under_siege")]],
##
##### TODO: QUESTS COMMENT OUT END

  [anyone|plyr,"seneschal_talk", [(store_relation, ":cur_rel", "fac_player_faction", "$g_encountered_party_faction"),
                                  (ge, ":cur_rel", 0),],
   "TODO: I want to ask you something.", "seneschal_ask_something",[]],

  [anyone|plyr,"seneschal_talk", [(store_relation, ":cur_rel", "fac_player_faction", "$g_encountered_party_faction"),
                                  (ge, ":cur_rel", 0),],
   "TODO: Tell me about someone.", "seneschal_ask_about_someone",[]],

  [anyone,"seneschal_ask_about_someone", [],
   "TODO: Who do you wish to know about?", "seneschal_ask_about_someone_2",[]],

  [anyone|plyr|repeat_for_troops,"seneschal_ask_about_someone_2", [(store_repeat_object, ":troop_no"),
                                                                  (is_between, ":troop_no", heroes_begin, heroes_end),
                                                                  (store_troop_faction, ":faction_no", ":troop_no"),
                                                                  (eq, "$g_encountered_party_faction", ":faction_no"),
                                                                  (str_store_troop_name, s1, ":troop_no")],
   "{s1}", "seneschal_ask_about_someone_3",[(store_repeat_object, "$hero_requested_to_learn_relations")]],

  [anyone|plyr,"seneschal_ask_about_someone_2", [], "Never mind.", "seneschal_pretalk",[]],

  [anyone, "seneschal_ask_about_someone_3", [(call_script, "script_troop_write_family_relations_to_s1", "$hero_requested_to_learn_relations"),
                                           (call_script, "script_troop_write_owned_centers_to_s2", "$hero_requested_to_learn_relations")],
   "{s2}{s1}", "seneschal_ask_about_someone_4",[(add_troop_note_from_dialog, "$hero_requested_to_learn_relations", 2)]],
  
  [anyone, "seneschal_ask_about_someone_relation", [(call_script, "script_troop_count_number_of_enemy_troops", "$hero_requested_to_learn_relations"),
                                            (assign, ":no_enemies", reg0),
                                            (try_begin),
                                              (gt, ":no_enemies", 1),
                                              (try_for_range, ":i_enemy", 1, ":no_enemies"),
                                                (store_add, ":slot_no", slot_troop_enemies_begin, ":i_enemy"),
                                                (troop_get_slot, ":cur_enemy", "$hero_requested_to_learn_relations", ":slot_no"),
                                                (str_store_troop_name_link, s50, ":cur_enemy"),
                                                (try_begin),
                                                  (eq, ":i_enemy", 1),
                                                  (troop_get_slot, ":cur_enemy", "$hero_requested_to_learn_relations", slot_troop_enemy_1),
                                                  (str_store_troop_name_link, s51, ":cur_enemy"),
                                                  (str_store_string, s51, "str_s50_and_s51"),
                                                (else_try),
                                                  (str_store_string, s51, "str_s50_comma_s51"),
                                                (try_end),
                                              (try_end),
                                            (else_try),
                                              (eq, ":no_enemies", 1),
                                              (troop_get_slot, ":cur_enemy", "$hero_requested_to_learn_relations", slot_troop_enemy_1),
                                              (str_store_troop_name_link, s51, ":cur_enemy"),
                                            (else_try),
                                              (str_store_string, s51, "str_noone"),
                                            (try_end),
                                            (troop_get_type, reg1, "$hero_requested_to_learn_relations")],
   "{reg1?She:He} hates {s51}.", "seneschal_ask_about_someone_4",[(add_troop_note_from_dialog, "$hero_requested_to_learn_relations", 3)]],

  [anyone|plyr,"seneschal_ask_about_someone_4", [], "TODO: Tell me about relations.", "seneschal_ask_about_someone_relation",[]],
  [anyone|plyr,"seneschal_ask_about_someone_4", [], "TODO: Thanks.", "seneschal_pretalk",[]],

 
  [anyone|plyr,"seneschal_talk", [], "TODO: I guess I should go now.", "close_window",[]],


  [anyone,"seneschal_ask_something", [],
   "TODO: What is it?", "seneschal_ask_something_2",[]],

  [anyone|plyr,"seneschal_ask_something_2", [],
   "TODO: I want to know about the location of someone.", "seneschal_ask_location",[]],

  [anyone,"seneschal_ask_location", [],
   "TODO: Whose location?", "seneschal_ask_location_2",[]],

  [anyone|plyr|repeat_for_troops,"seneschal_ask_location_2", [(store_repeat_object, ":troop_no"),
                                                              (is_between, ":troop_no", heroes_begin, heroes_end),
                                                              (store_troop_faction, ":faction_no", ":troop_no"),
                                                              (eq, "$g_encountered_party_faction", ":faction_no"),
                                                              (str_store_troop_name, s1, ":troop_no")],
   "{s1}", "seneschal_ask_location_3",[(store_repeat_object, "$hero_requested_to_learn_location")]],

  [anyone|plyr,"seneschal_ask_location_2", [], "Never mind.", "seneschal_pretalk",[]],

  [anyone,"seneschal_ask_location_3", [(call_script, "script_get_information_about_troops_position", "$hero_requested_to_learn_location", 0)],
   "{s1}", "seneschal_pretalk",[]],

#caravan merchants
  [anyone,"start",
   [(eq,"$caravan_escort_state",1),
    (eq,"$g_talk_troop","$caravan_escort_troop_id"),
    (le,"$talk_context",tc_party_encounter),
    (store_distance_to_party_from_party, reg(0),"$caravan_escort_destination_town","$caravan_escort_party_id"),
    (lt,reg(0),5),
    (str_store_party_name,s3,"$caravan_escort_destination_town"),
    (assign,reg(3), "$caravan_escort_agreed_reward"),
    ],
   "We have arrived at {s3}. \
 Here, take these {reg3} denars that I promised. I hope we travel together again someday.", "close_window",
   [
    (assign,"$caravan_escort_state",0),
    (troop_add_gold, "trp_player","$caravan_escort_agreed_reward"),
    (assign,reg(4), "$caravan_escort_agreed_reward"),
    (val_mul,reg(4), 1),
    (add_xp_as_reward,reg(4)),
    (assign, "$g_leave_encounter",1),
    ]],
  
  [anyone,"start",
   [(eq,"$caravan_escort_state",1),
    (eq,"$g_encountered_party","$caravan_escort_party_id"),
    (eq, "$talk_context", tc_party_encounter),
    ],
   "Well, we have made it so far. Do you think there will be any more danger?", "talk_caravan_escort",[]],
  [anyone|plyr,"talk_caravan_escort", [],
   "There can be bandits nearby. Let us make haste.", "talk_caravan_escort_2a",[]],
  [anyone,"talk_caravan_escort_2a", [],
   "This is as fast as we can go.\
 We need to carry all these goods remember?", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"talk_caravan_escort", [],
   "The way lies clear ahead. We can rest a little.", "talk_caravan_escort_2b",[]],
  [anyone,"talk_caravan_escort_2b", [],
   "We will get all the rest we want when we reach {s1}. Let us move on now.", "close_window",[[str_store_party_name,s1,"$caravan_escort_destination_town"],(assign, "$g_leave_encounter",1)]],

  [anyone,"start", [(eq,"$talk_context", tc_party_encounter),
                    (eq, "$g_encountered_party_type", spt_kingdom_caravan),
                    (party_slot_ge, "$g_encountered_party", slot_party_last_toll_paid_hours, "$g_current_hours"),
                    ],
   "What do you want? We paid our toll to you less than three days ago.", "merchant_talk",[]],

  [anyone,"start", [(eq,"$talk_context", tc_party_encounter),(eq, "$g_encountered_party_type", spt_kingdom_caravan),(ge,"$g_encountered_party_relation",0)],
   "Greetings traveller.", "merchant_talk",[]],

  [anyone,"start", [(eq,"$talk_context", tc_party_encounter),
                    (eq, "$g_encountered_party_type", spt_kingdom_caravan),
                    (lt,"$g_encountered_party_relation",0),
                    (eq, "$g_encountered_party_faction", "fac_merchants"),
                    ],
   "What do you want? We are just honest merchants doing our trade. Leave us alone.", "merchant_talk",[]],

  [anyone,"start", [(eq,"$talk_context", tc_party_encounter),
                    (eq, "$g_encountered_party_type", spt_kingdom_caravan),
                    (lt,"$g_encountered_party_relation",0),
                    (faction_get_slot, ":faction_leader", "$g_encountered_party_faction",slot_faction_leader),
                    (str_store_troop_name, s9, ":faction_leader"),
                    ],
   "Be warned knave! This Caravan is under the protection of {s9}.\
 Step out of our way or you will face his fury!", "merchant_talk",[]],


  [anyone,"start", [(party_slot_eq, "$g_encountered_party", slot_party_type, spt_kingdom_caravan),(this_or_next|eq,"$talk_context", tc_party_encounter),(eq,"$talk_context", 0)],
   "Yes? What do you want?", "merchant_talk",[]],
  [anyone,"merchant_pretalk", [], "Anything else?", "merchant_talk",[]],

  [anyone|plyr,"merchant_talk", [(le,"$talk_context", tc_party_encounter)], "I have an offer for you.", "merchant_talk_offer",[]],
  [anyone,"merchant_talk_offer", [], "What?", "merchant_talk_offer_2",[]],
  
  [anyone|plyr,"merchant_talk_offer_2", [(eq,"$talk_context", tc_party_encounter),(eq, "$g_encountered_party_faction", "$players_kingdom")],
   "I can escort you to your destination for a price.", "caravan_offer_protection",[]],
  
##  [anyone|plyr,"merchant_talk_offer_2", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                                 (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"), #he is not a faction leader!
##                                 (call_script, "script_get_number_of_hero_centers", "$g_talk_troop"),
##                                 (eq, reg0, 0), #he has no castles or towns
##                                 (hero_can_join),
##                             ],
##   "I need capable men like you. Will you join me?", "knight_offer_join",[
##       ]],
  
  [anyone|plyr,"merchant_talk_offer_2", [], "Nothing. Forget it", "merchant_pretalk",[]],

  
  [anyone|plyr,"merchant_talk", [(eq,"$talk_context", tc_party_encounter), #TODO: For the moment don't let attacking if merchant has paid toll.
                                 (neg|party_slot_ge, "$g_encountered_party", slot_party_last_toll_paid_hours, "$g_current_hours"),
                                 ], "I demand something from you!", "merchant_demand",[]],
  [anyone,"merchant_demand", [(eq,"$talk_context", tc_party_encounter)], "What do you want?", "merchant_demand_2",[]],

  [anyone|plyr,"merchant_demand_2", [(neq,"$g_encountered_party_faction","$players_kingdom")], "You must pay us a toll for free passage!", "merchant_demand_toll",[]],
  
  [anyone,"merchant_demand_toll", [(gt, "$g_strength_ratio", 70),
                                        (store_div, reg6, "$g_ally_strength", 2),
                                        (val_add, reg6, 40),
                                        (assign, "$temp", reg6),
                                        ], "I don't want any trouble. I will pay you {reg6} denars,  just let us go.", "merchant_demand_toll_2",[]],
  [anyone,"merchant_demand_toll", [(store_div, reg6, "$g_ally_strength", 4),
                                        (val_add, reg6, 10),
                                        (assign, "$temp", reg6),
                                        ], "I don't want any trouble. I will pay you {reg6} denars if you'll let us go.", "merchant_demand_toll_2",[]],
  
  [anyone|plyr,"merchant_demand_toll_2", [], "Agreed. Pay the toll now and you may go in peace.", "merchant_demand_toll_accept",[]],
  [anyone,"merchant_demand_toll_accept", [(assign, reg6, "$temp")], "All right then. Here's {reg6} denars. ", "close_window",
   [(assign, "$g_leave_encounter",1),
    (troop_add_gold, "trp_player","$temp"),
    (store_add, ":toll_finish_time", "$g_current_hours", merchant_toll_duration),
    (party_set_slot, "$g_encountered_party", slot_party_last_toll_paid_hours, ":toll_finish_time"),
    (try_begin),
      (ge, "$g_encountered_party_relation", -5),
      (store_relation,":rel", "$g_encountered_party_faction","fac_player_faction"),
      (try_begin),
        (gt, ":rel", 0),
        (val_sub, ":rel", 1),
      (try_end),
      (val_sub, ":rel", 1),
      (set_relation,"$g_encountered_party_faction", "fac_player_faction",":rel"),
    (try_end),
    ]],
  
  [anyone|plyr,"merchant_demand_toll_2", [], "I changed my mind. I don't want anything from you.", "merchant_pretalk",[]],
  
  [anyone|plyr,"merchant_demand_toll_2", [], "No, I want everything you have! [Attack]", "merchant_attack",[]],
  
  [anyone|plyr,"merchant_demand_2", [(neq,"$g_encountered_party_faction","$players_kingdom")], "Hand over your gold and valuables now!", "merchant_attack_begin",[]],
  [anyone|plyr,"merchant_demand_2", [], "Nothing. Forget it.", "merchant_pretalk",[]],
  
  
  [anyone,"merchant_attack_begin", [], "Are you robbing us?", "merchant_attack_verify",[]],
  [anyone|plyr,"merchant_attack_verify", [], "Robbing you? Hell no! I was just joking.", "merchant_attack_verify_norob",[]],
  [anyone,"merchant_attack_verify_norob", [], "Phew. For a moment I thought we were in trouble.", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"merchant_attack_verify", [], "Damn right. I am robbing you. Now start handing over your goods.", "merchant_attack",[]],
  
  [anyone,"merchant_attack", [], "Damn you. You will have to fight us first.", "close_window",
   [(store_relation,":rel", "$g_encountered_party_faction","fac_player_faction"),
    (try_begin),
      (gt, ":rel", 0),
      (val_sub, ":rel", 10),
    (try_end),
    (val_sub, ":rel", 5),
    (set_relation,"$g_encountered_party_faction", "fac_player_faction",":rel"),
    ]],

  [anyone,"caravan_offer_protection", [],
   "These roads are very dangerous indeed. One can never have enough protection.", "caravan_offer_protection_2",
   [(get_party_ai_object,":caravan_destination","$g_encountered_party"),
    (store_distance_to_party_from_party, "$caravan_distance_to_target",":caravan_destination","$g_encountered_party"),
    (assign,"$caravan_escort_offer","$caravan_distance_to_target"),
    (val_sub, "$caravan_escort_offer", 10),
    (call_script, "script_party_calculate_strength", "p_main_party"),
    (assign, ":player_strength", reg0),
    (val_min, ":player_strength", 200),
    (val_add, ":player_strength", 20),
    (val_mul,"$caravan_escort_offer",":player_strength"),
    (val_div,"$caravan_escort_offer",50),
    (val_max, "$caravan_escort_offer", 5),
    ]],
  [anyone,"caravan_offer_protection_2", [[lt,"$caravan_distance_to_target",10]],
   "But we have almost arrived at our destination. Thanks for your offer anyway...", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone,"caravan_offer_protection_2", [(get_party_ai_object,":caravan_destination","$g_encountered_party"),
    (str_store_party_name,1,":caravan_destination"),
    (assign,reg(2),"$caravan_escort_offer")],
   "We are heading to {s1}. I will pay you {reg2} denars if you escort us until there.", "caravan_offer_protection_3",
   []],
  [anyone|plyr,"caravan_offer_protection_3", [],
   "Agreed.", "caravan_offer_protection_4",[]],
  [anyone,"caravan_offer_protection_4", [],
   "I want you to stay close to us along the way.\
 We'll need your help if we are ambushed by bandits.", "caravan_offer_protection_5",[]],
  [anyone|plyr,"caravan_offer_protection_5", [],
   "All right, I will stay close to you. Don't worry.", "caravan_offer_protection_6",[]],
  [anyone,"caravan_offer_protection_6", [(get_party_ai_object,":caravan_destination","$g_encountered_party"),
    (str_store_party_name,1,":caravan_destination")],
   "Good. Come and collect your money when we come close to {s1}. Let's get on the way now.", "close_window",
   [(get_party_ai_object,":caravan_destination","$g_encountered_party"),
    (assign, "$caravan_escort_destination_town", ":caravan_destination"),
    (assign, "$caravan_escort_party_id", "$g_encountered_party"),
    (assign, "$caravan_escort_troop_id", "$g_talk_troop"),
    (assign, "$caravan_escort_agreed_reward", "$caravan_escort_offer"),
    (assign, "$caravan_escort_state", 1),
    (assign, "$g_leave_encounter",1)
   ]],
  [anyone|plyr,"caravan_offer_protection_3", [],
   "Forget it...", "caravan_offer_protection_4b",[]],
  [anyone,"caravan_offer_protection_4b", [],
   "Well then, maybe another time...", "close_window",[(assign, "$g_leave_encounter",1)]],

  [anyone|plyr,"merchant_talk", [(eq,"$talk_context", tc_party_encounter),(lt, "$g_talk_troop_faction_relation", 0)],
   "Not so fast. First hand over all your goods and money.", "talk_caravan_enemy_2",[]],

  [anyone,"talk_caravan_enemy_2", [],
   "Never. It is our duty to protect these goods. You will have to fight us, you brigand!", "close_window",
   [
    (store_relation,":rel","$g_encountered_party_faction","fac_player_faction"),
    (val_min,":rel",0),
    (val_sub,":rel",4),
    (set_relation,"$g_encountered_party_faction","fac_player_faction",":rel"),
    ]],

  [anyone|plyr,"merchant_talk", [], "[Leave]", "close_window",[(assign, "$g_leave_encounter",1)]],




# Prison Guards

  [anyone,"start", [(faction_slot_eq, "$g_encountered_party_faction", slot_faction_prison_guard_troop, "$g_talk_troop")],
   "Yes? What do you want?", "prison_guard_talk",[]],

  [anyone|plyr,"prison_guard_talk", [],
   "Who is imprisoned here?", "prison_guard_ask_prisoners",[]],
  [anyone|plyr,"prison_guard_talk", [],
   "I want to speak with a prisoner.", "prison_guard_visit_prison",[]],

  [anyone,"prison_guard_ask_prisoners", [],
   "My lord, {s51} {reg1?are:is} imprisoned here.","prison_guard_talk",[(party_clear, "p_temp_party"),
                                                                              (assign, ":num_heroes", 0),
                                                                              (party_get_num_prisoner_stacks, ":num_stacks","$g_encountered_party"),
                                                                              (try_for_range, ":i_stack", 0, ":num_stacks"),
                                                                                (party_prisoner_stack_get_troop_id, ":stack_troop","$g_encountered_party",":i_stack"),
                                                                                (troop_is_hero, ":stack_troop"),
                                                                                (party_add_members, "p_temp_party", ":stack_troop", 1),
                                                                                (val_add, ":num_heroes", 1),
                                                                              (try_end),
                                                                              (call_script, "script_print_party_members", "p_temp_party"),
                                                                              (try_begin),
                                                                                (gt, ":num_heroes", 1),
                                                                                (assign, reg1, 1),
                                                                              (else_try),
                                                                                (assign, reg1, 0),
                                                                              (try_end)]],
  
  [anyone,"prison_guard_visit_prison", [(ge, "$g_talk_troop_faction_relation", 10)],
   "Of course {sir/madam}. Go in.", "close_window",[(call_script, "script_enter_dungeon", "$current_town", "mt_town_default")]],

  [anyone,"prison_guard_visit_prison", [],
   "You need to get permission from the lord to talk to prisoners.", "prison_guard_visit_prison_2",[]],

  [anyone|plyr,"prison_guard_visit_prison_2", [], "All right then. I'll try that.", "close_window",[]],
  [anyone|plyr,"prison_guard_visit_prison_2", [], "Come on now. I thought you were the boss here.", "prison_guard_visit_prison_3",[]],
  [anyone,"prison_guard_visit_prison_3", [], "He-heh. You got that right. Still, I can't let you into the prison.", "prison_guard_visit_prison_4",[]],
  
  [anyone|plyr,"prison_guard_visit_prison_4", [], "All right then. I'll leave now.", "close_window",[]],
  [anyone|plyr,"prison_guard_visit_prison_4", [(store_troop_gold,":gold","trp_player"),(ge,":gold",100)],
   "I found a purse with 100 denars a few paces away. I reckon it belongs to you.", "prison_guard_visit_prison_5",[]],

  [anyone,"prison_guard_visit_prison_5", [(troop_remove_gold, "trp_player",100)], "Ah! I was looking for this all day. How good of you to bring it back {sir/madam}.\
 Well, now that I know what an honest {man/lady} you are, there can be no harm in letting you inside. Go in.", "close_window",[(call_script, "script_enter_dungeon", "$current_town", "mt_town_default")]],

  [anyone|plyr,"prison_guard_talk", [],
   "Never mind.", "close_window",[]],




# Castle Guards

  [anyone,"start", [(faction_slot_eq, "$g_encountered_party_faction", slot_faction_castle_guard_troop, "$g_talk_troop"),(eq, "$sneaked_into_town",1),
                    (gt,"$g_talk_troop_last_talk_time",0)],
   "Get out of my sight, beggar! You stink!", "castle_guard_sneaked_intro_1",[]],
  [anyone,"start", [(faction_slot_eq, "$g_encountered_party_faction", slot_faction_castle_guard_troop, "$g_talk_troop"),(eq, "$sneaked_into_town",1)],
   "Get lost before I loose my temper you vile beggar!", "close_window",[]],
  [anyone|plyr,"castle_guard_sneaked_intro_1", [], "I want to enter the hall and speak to the lord.", "castle_guard_sneaked_intro_2",[]],
  [anyone|plyr,"castle_guard_sneaked_intro_1", [], "[Leave]", "close_window",[]],
  [anyone,"castle_guard_sneaked_intro_2", [], "Are you out of your mind, {man/woman}?\
 Beggars are not allowed into the hall. Now get lost or I'll beat you bloody.", "close_window",[]],
  
  
  [anyone,"start", [(faction_slot_eq, "$g_encountered_party_faction", slot_faction_castle_guard_troop, "$g_talk_troop")],
   "What do you want?", "castle_guard_intro_1",[]],
  [anyone|plyr,"castle_guard_intro_1", [],
   "I want to enter the hall and speak to the lord.", "castle_guard_intro_2",[]],
  [anyone|plyr,"castle_guard_intro_1", [],
   "Never mind.", "close_window",[]],
  [anyone,"castle_guard_intro_2", [], "You can go in after leaving your weapons with me. No one is allowed to carry arms into the lord's hall.", "castle_guard_intro_2",
   []],
  [anyone|plyr,"castle_guard_intro_2", [], "Here, take my arms. I'll go in.", "close_window", [(call_script, "script_enter_court", "$current_town")]],
  [anyone|plyr,"castle_guard_intro_2", [], "No, I give my arms to no one.", "castle_guard_intro_2b", []],
  [anyone,"castle_guard_intro_2b", [], "Then you can't go in.", "close_window", []],
  
##  [anyone|plyr,"castle_guard_intro_1", [],
##   "Never mind.", "close_window",[]],
##  [anyone,"castle_guard_intro_2", [],
##   "Does the lord expect you?", "castle_guard_intro_3",[]],
##  [anyone|plyr,"castle_guard_intro_3", [], "Yes.", "castle_guard_intro_check",[]],
##  [anyone|plyr,"castle_guard_intro_3", [], "No.", "castle_guard_intro_no",[]],
##  [anyone,"castle_guard_intro_check", [], "Hmm. All right {sir/madam}.\
## You can go in. But you must leave your weapons with me. Noone's allowed into the court with weapons.", "close_window",[]],
##  [anyone,"castle_guard_intro_check", [], "You liar!\
## Our lord would have no business with a filthy vagabond like you. Get lost now before I kick your butt.", "close_window",[]],
##  [anyone,"castle_guard_intro_no", [], "Well... What business do you have here then?", "castle_guard_intro_4",[]],
##  [anyone|plyr,"castle_guard_intro_4", [], "I wish to present the lord some gifts.", "castle_guard_intro_gifts",[]],
##  [anyone|plyr,"castle_guard_intro_4", [], "I have an important matter to discuss with the lord. Make way now.", "castle_guard_intro_check",[]],
##  [anyone,"castle_guard_intro_gifts", [], "Really? What gifts?", "castle_guard_intro_5",[]],
##  [anyone|plyr,"castle_guard_intro_4", [], "Many gifts. For example, I have a gift of 20 denars here for his loyal servants.", "castle_guard_intro_gifts",[]],
##  [anyone|plyr,"castle_guard_intro_4", [], "My gifts are of no concern to you. They are for your lords and ladies..", "castle_guard_intro_check",[]],
##  [anyone,"castle_guard_intro_gifts", [], "Oh! you can give those 20 denars to me. I can distribute them for you.\
## You can enter the court and present your gifts to the lord. I'm sure he'll be pleased.\
## But you must leave your weapons with me. Noone's allowed into the court with weapons.", "close_window",[]],

#Kingdom Parties
#  [anyone,"start", [(this_or_next|eq,"$g_encountered_party_template","pt_swadian_foragers"),
#                    (eq,"$g_encountered_party_template","pt_vaegir_foragers"),
  [anyone,"start", [(this_or_next|party_slot_eq,"$g_encountered_party",slot_party_type, spt_forager),
                    (this_or_next|party_slot_eq,"$g_encountered_party",slot_party_type, spt_scout),
                    (party_slot_eq,"$g_encountered_party",slot_party_type, spt_patrol),
                    (str_store_faction_name,5,"$g_encountered_party_faction")],
   "In the name of the {s5}.", "kingdom_party_encounter",[]],
  
  [anyone,"kingdom_party_encounter", [(le,"$g_encountered_party_relation",-10)],
   "Surrender now, and save yourself the indignity of defeat!", "kingdom_party_encounter_war",[]],
  [anyone|plyr,"kingdom_party_encounter_war", [],  "[Go to Battle]", "close_window",[(encounter_attack)]],

  [anyone,"kingdom_party_encounter", [(ge,"$g_encountered_party_relation",10)],
   "Greetings, fellow warrior.", "close_window",[(eq,"$talk_context",tc_party_encounter),(assign, "$g_leave_encounter", 1)]],

  [anyone,"kingdom_party_encounter", [],
   "You can go.", "close_window",[]],








#Player Parties
##  [party_tpl|pt_old_garrison,"start", [],
##   "They told us to leave the castle to the new garrison {sir/madam}. So we left and came to rejoin you.", "player_old_garrison_encounter",[]],
##  
##  [anyone|plyr,"player_old_garrison_encounter", [(party_can_join)],
##   "You have done well. You'll join my command now.", "close_window",[(assign, "$g_move_heroes", 1),
##                                        (call_script, "script_party_add_party", "p_main_party", "$g_encountered_party"),
##                                        (remove_party, "$g_encountered_party"),
##                                        (assign, "$g_leave_encounter", 1)]],
##  [anyone|plyr,"player_old_garrison_encounter", [(assign, reg1, 0),
##                                                 (try_begin),
##                                                   (neg|party_can_join),
##                                                   (assign, reg1, 1),
##                                                 (try_end)],
##   "You can't join us now{reg1?, I can't command all the lot of you:}. Follow our lead.", "close_window",[(party_set_ai_behavior, "$g_encountered_party", ai_bhvr_attack_party),
##                                                                         (party_set_ai_object, "$g_encountered_party", "p_main_party"),
##                                                                         (party_set_flags, "$g_encountered_party", pf_default_behavior, 0),
##                                                                         (assign, "$g_leave_encounter", 1)]],
##
##  [anyone|plyr,"player_old_garrison_encounter", [(assign, reg1, 0),
##                                                 (try_begin),
##                                                   (neg|party_can_join),
##                                                   (assign, reg1, 1),
##                                                 (try_end)],
##   "You can't join us now{reg1?, I can't command all the lot of you:}. Stay here and wait for me.", "close_window",[
##       (party_set_ai_behavior, "$g_encountered_party", ai_bhvr_travel_to_point),
##       (party_get_position, pos1, "$g_encountered_party"),
##       (party_set_ai_target_position, "$g_encountered_party", pos1),
##       (party_set_flags, "$g_encountered_party", pf_default_behavior, 0),
##       (assign, "$g_leave_encounter", 1)]],
##









#Enemy Kingdom Meetings


  [anyone,"start", [(eq, "$talk_context", tc_lord_talk_in_center)],
   "Greetings {playername}.", "request_meeting_1",[]],

  [anyone,"request_meeting_pretalk", [(eq, "$talk_context", tc_lord_talk_in_center)],
   "Yes?", "request_meeting_1",[]],
  
#  [anyone|plyr,"request_meeting_1", [(ge, "$g_encountered_party_faction", 0)], "Open the gates and let me in!", "request_meeting_open_gates",[]],
  
  [anyone|plyr,"request_meeting_1", [(party_slot_ge, "$g_encountered_party", slot_town_lord, 1)], "I want to speak with the lord of the castle.", "request_meeting_castle_lord",[]],
  [anyone|plyr,"request_meeting_1", [], "I want to speak with someone in the castle.", "request_meeting_other",[]],

##### TODO: QUESTS COMMENT OUT BEGIN
##  [anyone|plyr,"request_meeting_1",[(check_quest_active,"qst_bring_prisoners_to_enemy"),
##                                    (neg|check_quest_succeeded, "qst_bring_prisoners_to_enemy"),
##                                    (quest_get_slot, ":quest_giver_troop", "qst_bring_prisoners_to_enemy", slot_quest_giver_troop),
##                                    (quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                                    (quest_get_slot, ":quest_object_troop", "qst_bring_prisoners_to_enemy", slot_quest_object_troop),
##                                    (quest_slot_eq, "qst_bring_prisoners_to_enemy", slot_quest_target_center, "$g_encountered_party"),
##                                    (party_count_prisoners_of_type, ":num_prisoners", "p_main_party", ":quest_object_troop"),
##                                    (ge, ":num_prisoners", ":quest_target_amount"),
##                                    (str_store_troop_name,1,":quest_giver_troop"),
##                                    (assign, reg1, ":quest_target_amount"),
##                                    (str_store_troop_name_plural,2,":quest_object_troop")],
##   "TODO: Sir, lord {s1} ordered me to bring {reg1} {s2} for ransom.", "guard_prisoners_brought",
##   [(quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##    (quest_get_slot, ":quest_target_center", "qst_bring_prisoners_to_enemy", slot_quest_target_center),
##    (quest_get_slot, ":quest_object_troop", "qst_bring_prisoners_to_enemy", slot_quest_object_troop),
##    (party_remove_prisoners, "p_main_party", ":quest_object_troop", ":quest_target_amount"),
##    (party_add_members, ":quest_target_center", ":quest_object_troop", ":quest_target_amount"),
##    (call_script, "script_game_get_join_cost", ":quest_object_troop"),
##    (assign, ":reward", reg0),
##    (val_mul, ":reward", ":quest_target_amount"),
##    (val_div, ":reward", 2),
##    (troop_add_gold, "trp_player",":reward"),
##    (party_get_slot, ":cur_lord", "$g_encountered_party", slot_town_lord),#Removing gold from the town owner's wealth
##    (troop_get_slot, ":cur_wealth", ":cur_lord", slot_troop_wealth),
##    (val_sub, ":cur_wealth", ":reward"),
##    (troop_set_slot, ":cur_lord", slot_troop_wealth, ":cur_wealth"),
##    (quest_set_slot, "qst_bring_prisoners_to_enemy", slot_quest_target_amount, ":reward"),
##    (succeed_quest, "qst_bring_prisoners_to_enemy"),
##    ]],
##
##  [anyone|plyr,"request_meeting_1",[(check_quest_active,"qst_bring_prisoners_to_enemy"),
##                                    (neg|check_quest_succeeded, "qst_bring_prisoners_to_enemy"),
##                                    (quest_get_slot, ":quest_giver_troop", "qst_bring_prisoners_to_enemy", slot_quest_giver_troop),
##                                    (quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                                    (quest_get_slot, ":quest_object_troop", "qst_bring_prisoners_to_enemy", slot_quest_object_troop),
##                                    (quest_slot_eq, "qst_bring_prisoners_to_enemy", slot_quest_target_center, "$g_encountered_party"),
##                                    (party_count_prisoners_of_type, ":num_prisoners", "p_main_party", ":quest_object_troop"),
##                                    (lt, ":num_prisoners", ":quest_target_amount"),
##                                    (gt, ":num_prisoners", 0),
##                                    (str_store_troop_name,1,":quest_giver_troop"),
##                                    (assign, reg1, ":quest_target_amount"),
##                                    (str_store_troop_name_plural,2,":quest_object_troop")],
##   "TODO: Sir, lord {s1} ordered me to bring {reg1} {s2} for ransom, but some of them died during my expedition.", "guard_prisoners_brought_some",
##   [(quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##    (quest_get_slot, ":quest_target_center", "qst_bring_prisoners_to_enemy", slot_quest_target_center),
##    (quest_get_slot, ":quest_object_troop", "qst_bring_prisoners_to_enemy", slot_quest_object_troop),
##    (party_count_prisoners_of_type, ":num_prisoners", "p_main_party", ":quest_object_troop"),
##    (party_remove_prisoners, "p_main_party", ":quest_object_troop", ":num_prisoners"),
##    (party_add_members, ":quest_target_center", ":quest_object_troop", ":num_prisoners"),
##    (call_script, "script_game_get_join_cost", ":quest_object_troop"),
##    (assign, ":reward", reg0),
##    (val_mul, ":reward", ":num_prisoners"),
##    (val_div, ":reward", 2),
##    (troop_add_gold, "trp_player",":reward"),
##    (party_get_slot, ":cur_lord", "$g_encountered_party", slot_town_lord),#Removing gold from the town owner's wealth
##    (troop_get_slot, ":cur_wealth", ":cur_lord", slot_troop_wealth),
##    (val_sub, ":cur_wealth", ":reward"),
##    (troop_set_slot, ":cur_lord", slot_troop_wealth, ":cur_wealth"),
##    (call_script, "script_game_get_join_cost", ":quest_object_troop"),
##    (assign, ":reward", reg0),
##    (val_mul, ":reward", ":quest_target_amount"),
##    (val_div, ":reward", 2),
##    (quest_set_slot, "qst_bring_prisoners_to_enemy", slot_quest_current_state, 1),#Some of the prisoners are given, so it's state will change for remembering that.
##    (quest_set_slot, "qst_bring_prisoners_to_enemy", slot_quest_target_amount, ":reward"),#Still needs to pay the lord the full price of the prisoners
##    (succeed_quest, "qst_bring_prisoners_to_enemy"),
##    ]],
##
##
##  [anyone,"guard_prisoners_brought", [],
##   "TODO: Thank you. Here is the money for prisoners.", "request_meeting_pretalk",[]],
##
##  [anyone,"guard_prisoners_brought_some", [],
##   "TODO: Thank you, but that's not enough. Here is the money for prisoners.", "request_meeting_pretalk",[]],

  [anyone|plyr,"request_meeting_1", [], "[Leave]", "close_window",[]],




  
##  [anyone,"request_meeting_open_gates", [(party_get_slot, ":castle_lord", "$g_encountered_party", slot_town_lord),
##                                         (call_script, "script_get_troop_attached_party", ":castle_lord"),
##                                         (eq, "$g_encountered_party", reg0),
##                                         (str_store_troop_name, 1, ":castle_lord")
##                                         ],  "My lord {s1} is in the castle now. You must ask his permission to enter.", "request_meeting_pretalk",[]],
##
##  [anyone,"request_meeting_open_gates", [(party_get_slot, ":castle_lord", "$g_encountered_party", slot_town_lord),
##                                         (call_script, "script_get_troop_attached_party", ":castle_lord"),
##                                         (neq, "$g_encountered_party", reg0),
##                                         (ge, "$g_encountered_party_relation", 0),
##                                         (troop_get_slot, ":castle_lord_relation", ":castle_lord", slot_troop_player_relation),
##                                         (ge, ":castle_lord_relation", 20),
##                                         (str_store_troop_name, 1, ":castle_lord")
##                                         ],  "My lord {s1} is not in the castle now.\
## But I think he would approve of you taking shelter here, {sir/madam}.\
## Come on in. I am opening the gates for you.", "close_window",[]],
##  
##  [anyone,"request_meeting_open_gates", [(party_get_slot, ":castle_lord", "$g_encountered_party", slot_town_lord),(str_store_troop_name, 1, ":castle_lord")],
##   "My lord {s1} is not in the castle now. I can't allow you into the castle without his orders.", "request_meeting_pretalk",[]],
  
  [anyone,"request_meeting_castle_lord", [(party_get_slot, ":castle_lord", "$g_encountered_party", slot_town_lord),
                                         (call_script, "script_get_troop_attached_party", ":castle_lord"),
                                         (eq, "$g_encountered_party", reg0),
                                         (str_store_troop_name, 1, ":castle_lord"),
                                         (assign, "$lord_requested_to_talk_to", ":castle_lord"),
                                          ],  "Wait here. My lord {s1} will see you.", "close_window",[]],
  
  [anyone,"request_meeting_castle_lord", [],  "My lord is not here now.", "request_meeting_pretalk",[]],

  
  [anyone,"request_meeting_other", [],  "TODO: Who?", "request_meeting_3",[]],

  [anyone|plyr|repeat_for_troops,"request_meeting_3", [(store_repeat_object, ":troop_no"),
                                                       (troop_is_hero, ":troop_no"),
                                                       (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
                                                       (call_script, "script_get_troop_attached_party", ":troop_no"),
                                                       (eq, "$g_encountered_party", reg0),
                                                       (str_store_troop_name, 1, ":troop_no"),
                                                       ],
   "{s1}", "request_meeting_4",[(store_repeat_object, "$lord_requested_to_talk_to")]],

  [anyone|plyr,"request_meeting_3", [], "Never mind.", "close_window",[(assign, "$lord_requested_to_talk_to", 0)]],

  [anyone,"request_meeting_4", [], "Wait there. I'll send him your request.", "request_meeting_5",[]],

  [anyone|plyr,"request_meeting_5", [], "I'm waiting...", "request_meeting_6",[]],

  [anyone,"request_meeting_6", [#TODO: Check relation
      ], "All right. Lord {s2} will talk to you now.", "close_window",[(str_store_troop_name, s2, "$lord_requested_to_talk_to")]],

  [anyone,"request_meeting_6", [(str_store_troop_name, s2, "$lord_requested_to_talk_to")], "Lord {s2} says he will not see you. Begone now.", "close_window",[]],



# Quest conversations

##### TODO: QUESTS COMMENT OUT BEGIN
  
##  [party_tpl|pt_peasant_rebels,"start", [],
##   "TODO: What.", "peasant_rebel_talk",[]],
##  [anyone|plyr, "peasant_rebel_talk", [], "TODO: Die.", "close_window",[]],
##  [anyone|plyr, "peasant_rebel_talk", [], "TODO: Nothing.", "close_window",[(assign, "$g_leave_encounter",1)]],
##
##  [party_tpl|pt_noble_refugees,"start", [],
##   "TODO: What.", "noble_refugee_talk",[]],
##  [anyone|plyr, "noble_refugee_talk", [], "TODO: Nothing.", "close_window",[(assign, "$g_leave_encounter",1)]],
##
##
##  [trp_local_merchant,"start", [], "Mercy! Please don't kill me!", "local_merchant_mercy",[]],
##  [anyone|plyr,"local_merchant_mercy", [(quest_get_slot, ":quest_giver_troop", "qst_kill_local_merchant", slot_quest_giver_troop),(str_store_troop_name, s2, ":quest_giver_troop")],
##   "I have nothing against you man. But {s2} wants you dead. Sorry.", "local_merchant_mercy_no",[]],
##  [anyone,"local_merchant_mercy_no", [], "Damn you! May you burn in Hell!", "close_window",[]],
##  [anyone|plyr,"local_merchant_mercy", [], "I'll let you live, if you promise me...", "local_merchant_mercy_yes",[]],
##
##  [anyone,"local_merchant_mercy_yes", [], "Of course, I promise, I'll do anything. Just don't kill me... ", "local_merchant_mercy_yes_2",[]],
##  [anyone|plyr,"local_merchant_mercy_yes_2", [], "You are going to forget about {s2}'s debt to you.\
## And you will sign a paper stating that he owes you nothing.", "local_merchant_mercy_yes_3",[]],
##  [anyone,"local_merchant_mercy_yes_3", [], "Yes, of course. I'll do as you say.", "local_merchant_mercy_yes_4",[]],
##  [anyone|plyr,"local_merchant_mercy_yes_4", [], "And if my lord hears so much of a hint of a complaint about this issue, then I'll come back for you,\
## and it won't matter how much you scream for mercy then.\
## Do you understand me?", "local_merchant_mercy_yes_5",[]],
##  [anyone,"local_merchant_mercy_yes_5", [], "Yes {sir/madam}. Don't worry. I won't make any complaint.", "local_merchant_mercy_yes_6",[]],
##  [anyone|plyr,"local_merchant_mercy_yes_6", [], "Good. Go now, before I change my mind.", "close_window",[(quest_set_slot, "qst_kill_local_merchant", slot_quest_current_state, 1),
##                                                                            (succeed_quest, "qst_kill_local_merchant"),
##                                                                            (try_begin),
##                                                                              (eq, "$sneaked_into_town",1),
##                                                                              (assign,":cur_mission_template","mt_town_disguised"),
##                                                                            (else_try),
##                                                                               (assign,":cur_mission_template","mt_town_default"),
##                                                                            (try_end),
##                                                                            (set_jump_mission,":cur_mission_template"),
##                                                                            (party_get_slot, ":cur_town_center", "$current_town", slot_town_center),
##                                                                            (set_jump_entry, 0),
##                                                                            (jump_to_scene,":cur_town_center")]],
##
##
##  [anyone,"member_chat", [(check_quest_active,"qst_incriminate_loyal_commander"),
##                          (quest_slot_eq, "qst_incriminate_loyal_commander", slot_quest_current_state, 0),
##                          (store_conversation_troop, "$g_talk_troop"),
##                          (eq, "$g_talk_troop", "$incriminate_quest_sacrificed_troop"),
##                          (quest_get_slot, ":quest_target_center", "qst_incriminate_loyal_commander", slot_quest_target_center),
##                          (store_distance_to_party_from_party, ":distance", "p_main_party", ":quest_target_center"),
##                          (lt, ":distance", 10),
##                          ], "Yes {sir/madam}?", "sacrificed_messenger_1",[]],
##
##  [anyone|plyr,"sacrificed_messenger_1", [(quest_get_slot, ":quest_target_center", "qst_incriminate_loyal_commander", slot_quest_target_center),
##                                          (str_store_party_name, s1, ":quest_target_center"),
##                                          (quest_get_slot, ":quest_object_troop", "qst_incriminate_loyal_commander", slot_quest_object_troop),
##                                          (str_store_troop_name, s2, ":quest_object_troop"),],
##   "Take this letter to {s1} and give it to {s2}.", "sacrificed_messenger_2",[]],
##  [anyone|plyr,"sacrificed_messenger_1", [],
##   "Nothing. Nothing at all.", "close_window",[]],
##
##  [anyone,"sacrificed_messenger_2", [],
##   "Yes {sir/madam}. You can trust me. I will not fail you.", "sacrificed_messenger_3",[]],
##
##  [anyone|plyr,"sacrificed_messenger_3", [],
##   "Good. I will not forget your service. You will be rewarded when you return.", "close_window",[(party_remove_members, "p_main_party", "$g_talk_troop", 1),
##                                     (set_spawn_radius, 0),
##                                     (spawn_around_party, "p_main_party", "pt_sacrificed_messenger"),
##                                     (assign, ":new_party", reg0),
##                                     (party_add_members, ":new_party", "$g_talk_troop", 1),
##                                     (party_set_ai_behavior, ":new_party", ai_bhvr_travel_to_party),
##                                     (quest_get_slot, ":quest_target_center", "qst_incriminate_loyal_commander", slot_quest_target_center),
##                                     (party_set_ai_object, ":new_party", ":quest_target_center"),
##                                     (party_set_flags, ":new_party", pf_default_behavior, 0),
##                                     (quest_set_slot, "qst_incriminate_loyal_commander", slot_quest_current_state, 2),
##                                     (quest_set_slot, "qst_incriminate_loyal_commander", slot_quest_target_party, ":new_party")]],
##  [anyone|plyr,"sacrificed_messenger_3", [], "Arggh! I can't do this. I can't send you to your own death!", "sacrificed_messenger_cancel",[]],
##  [anyone,"sacrificed_messenger_cancel", [], "What do you mean {sir/madam}", "sacrificed_messenger_cancel_2",[]],
##  [anyone|plyr,"sacrificed_messenger_cancel_2", [(quest_get_slot, ":quest_giver", "qst_incriminate_loyal_commander", slot_quest_giver_troop),
##                                                 (str_store_troop_name, s3, ":quest_giver"),
##      ], "There's a trap set up for you in the town.\
## {s3} ordered me to sacrifice one of my chosen warriors to fool the enemy,\
## but he will just need to find another way.", "sacrificed_messenger_cancel_3",[
##     (quest_get_slot, ":quest_giver", "qst_incriminate_loyal_commander", slot_quest_giver_troop),
##     (quest_set_slot, "qst_incriminate_loyal_commander", slot_quest_current_state, 1),
##     (call_script, "script_change_player_relation_with_troop",":quest_giver",-5),
##     (call_script, "script_change_player_honor", 5),
##     (fail_quest, "qst_incriminate_loyal_commander"),
##     ]],
##  [anyone,"sacrificed_messenger_3", [], "Thank you {sir/madam}.\
## I will follow you to the gates of hell. But this would not be a good death.", "close_windows",[]],
##
##  [party_tpl|pt_sacrificed_messenger,"start", [],
##   "TODO: I'm on my way.", "close_window",[(assign, "$g_leave_encounter",1)]],

###Spy
##
##  [party_tpl|pt_spy,"start", [], "Good day {sir/madam}. Such fine weather don't you think? If you'll excuse me now I must go on my way.", "follow_spy_talk",[]],
##
##  [anyone|plyr,"follow_spy_talk", [(quest_get_slot,":quest_giver","qst_follow_spy",slot_quest_giver_troop),
##                                   (str_store_troop_name,s1,":quest_giver")],
##   "In the name of {s1}, you are under arrest!", "follow_spy_talk_2",[]],
##  [anyone,"follow_spy_talk_2", [], "You won't get me alive!", "close_window",[]],
##  [anyone|plyr,"follow_spy_talk", [], "Never mind me. I was just passing by.", "close_window",[(assign, "$g_leave_encounter",1)]],
##
##  [party_tpl|pt_spy_partners,"start", [], "Greetings.", "spy_partners_talk",[]],
##
##  [anyone|plyr,"spy_partners_talk", [(quest_get_slot,":quest_giver","qst_follow_spy",slot_quest_giver_troop),
##                                     (str_store_troop_name,s1,":quest_giver")],
##   "In the name of {s1} You are under arrest!", "spy_partners_talk_2",[]],
##  [anyone,"spy_partners_talk_2", [], "You will have to fight us first!", "close_window",[]],
##  [anyone|plyr,"spy_partners_talk", [], "Never mind me. I was just passing by.", "close_window",[(assign, "$g_leave_encounter",1)]],
##
##
###Conspirator
##
##  [party_tpl|pt_conspirator_leader,"start", [], "TODO: Hello.", "conspirator_talk",[]],
##  [party_tpl|pt_conspirator,"start", [], "TODO: Hello.", "conspirator_talk",[]],
##
##  [anyone|plyr,"conspirator_talk", [(gt, "$qst_capture_conspirators_leave_meeting_counter", 0),
##                                    (quest_get_slot,":quest_giver","qst_capture_conspirators",slot_quest_giver_troop),
##                                    (str_store_troop_name,s1,":quest_giver")],
##   "TODO: In the name of {s1}, you are under arrest!", "conspirator_talk_2",[]],
##
##  [anyone|plyr,"conspirator_talk", [], "TODO: Bye.", "close_window",[(assign, "$g_leave_encounter",1)]],
##
##  [anyone,"conspirator_talk_2", [], "You won't get me alive!", "close_window",[]],
##
###Runaway Peasants
##
##  [party_tpl|pt_runaway_serfs,"start", [(party_slot_eq, "$g_encountered_party", slot_town_center, 0)], "TODO: We are running away.", "runaway_serf_talk",[(party_set_slot, "$g_encountered_party", slot_town_center, 1)]],
##  [party_tpl|pt_runaway_serfs,"start", [(get_party_ai_object, ":cur_ai_object"),
##                                           (quest_get_slot, ":quest_object_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
##                                           (neq, ":quest_object_center", ":cur_ai_object")], "TODO: Hello again.", "runaway_serf_talk_again_go_back",[]],
##  [party_tpl|pt_runaway_serfs,"start", [], "TODO: Hello again.", "runaway_serf_talk_again_good_boy",[]],
##  
##  [anyone|plyr,"runaway_serf_talk", [], "TODO: Go back.", "runaway_serf_go_back",[(quest_get_slot, ":quest_object_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
##                                                                                        (party_set_ai_object, "$g_encountered_party", ":quest_object_center")]],
##  [anyone|plyr,"runaway_serf_talk", [], "TODO: Nothing.", "close_window",[(assign, "$g_leave_encounter",1)]],
##
##  [anyone|plyr,"runaway_serf_talk_again_go_back", [],
##   "TODO: I said go back!", "runaway_serf_go_back_again",[(quest_get_slot, ":quest_object_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
##                                                             (party_set_ai_object, "$g_encountered_party", ":quest_object_center")]],
##  [anyone|plyr,"runaway_serf_talk_again_good_boy", [],
##   "TODO: Good boy.", "close_window",[(assign, "$g_leave_encounter",1)]],
##
##  [party_tpl|pt_runaway_serfs,"runaway_serf_go_back", [], "TODO: OK.", "close_window", [(assign, "$g_leave_encounter",1)]],
##  [party_tpl|pt_runaway_serfs,"runaway_serf_go_back_again", [], "TODO: OK OK.", "close_window",[(assign, "$g_leave_encounter",1)]],
##
##
###Deserters
##  [anyone,"start", [(eq,"$g_encountered_party_type",spt_deserter),
##                    (eq,"$talk_context",tc_party_encounter),
##                    (party_get_slot,":protected_until_hours", "$g_encountered_party",slot_party_ignore_player_until),
##                    (store_current_hours,":cur_hours"),
##                    (store_sub, ":protection_remaining",":protected_until_hours",":cur_hours"),
##                    (gt, ":protection_remaining", 0)], "What do you want?\
## You want to pay us some more money?", "deserter_paid_talk",[]],
##  [anyone|plyr,"deserter_paid_talk", [], "Sorry to trouble you. I'll be on my way now.", "deserter_paid_talk_2a",[]],
##  [anyone,"deserter_paid_talk_2a", [], "Yeah. Stop fooling around and go make some money.\
## I want to see that purse full next time I see you.", "close_window",[(assign, "$g_leave_encounter",1)]],
##  [anyone|plyr,"deserter_paid_talk", [], "No. It's your turn to pay me this time.", "deserter_paid_talk_2b",[]],
##  [anyone,"deserter_paid_talk_2b", [], "What nonsense are you talking about? You want trouble? You got it.", "close_window",[
##       (party_set_slot,"$g_encountered_party",slot_party_ignore_player_until,0),
##       (party_ignore_player, "$g_encountered_party", 0),
##    ]],
##
##  
##  [anyone,"start", [(eq,"$g_encountered_party_type",spt_deserter),(eq,"$talk_context",tc_party_encounter)], "We are the free brothers.\
## We will fight only for ourselves from now on.\
## Now give us your gold or taste our steel.", "deserter_talk",[]],
##  [anyone|plyr,"deserter_talk", [(check_quest_active, "qst_bring_back_deserters"),
##                                 (quest_get_slot, ":target_deserter_troop", "qst_bring_back_deserters", slot_quest_target_troop),
##                                 (party_count_members_of_type, ":num_deserters", "$g_encountered_party",":target_deserter_troop"),
##                                 (gt, ":num_deserters", 1)],
##   "If you surrender to me now, you will rejoin the army of your kingdom without being punished. Otherwise you'll get a taste of my sword.", "deserter_join_as_prisoner",[]],
##  [anyone|plyr,"deserter_talk", [], "When I'm done with you, you'll regret ever leaving the army.", "close_window",[]],
##  [anyone|plyr,"deserter_talk", [], "There's no need to fight. I am ready to pay for free passage.", "deserter_barter",[]],
##
##  [anyone,"deserter_join_as_prisoner", [(call_script, "script_party_calculate_strength", "p_main_party"),
##                                        (assign, ":player_strength", reg0),
##                                        (store_encountered_party,":encountered_party"),
##                                        (call_script, "script_party_calculate_strength", ":encountered_party"),
##                                        (assign, ":enemy_strength", reg0),
##                                        (val_mul, ":enemy_strength", 2),
##                                        (ge, ":player_strength", ":enemy_strength")],
##   "All right we join you then.", "close_window",[(assign, "$g_enemy_surrenders", 1)]],
##  [anyone,"deserter_join_as_prisoner", [], "TODO: We will never surrender!", "close_window",[(encounter_attack)]],
##
##  [anyone,"deserter_barter", [], "Good. You are clever. You pay us {reg5} denars. Then you can go.", "deserter_barter_2",[(assign,"$deserter_tribute",150),(assign,reg(5),"$deserter_tribute")]],
##  [anyone|plyr,"deserter_barter_2", [(store_troop_gold,reg(2)),(ge,reg(2),"$deserter_tribute"),(assign,reg(5),"$deserter_tribute")],
##   "All right here's your {reg5} denars.", "deserter_barter_3a",[(troop_remove_gold, "trp_player","$deserter_tribute")]],
##  [anyone|plyr,"deserter_barter_2", [],
##   "I don't have that much money with me", "deserter_barter_3b",[]],
##  [anyone,"deserter_barter_3b", [],
##   "Too bad. Then we'll have to sell you to the slavers.", "close_window",[]],
##
##
##  [anyone,"deserter_barter_3a", [], "Heh. That wasn't difficult now was it? All right. Go now.", "close_window",[
##    (store_current_hours,":protected_until"),
##    (val_add, ":protected_until", 72),
##    (party_set_slot,"$g_encountered_party",slot_party_ignore_player_until,":protected_until"),
##    (party_ignore_player, "$g_encountered_party", 72),
##      
##    (assign, "$g_leave_encounter",1)
##    ]],

##### TODO: QUESTS COMMENT OUT END

#Tavernkeepers
  [trp_zendar_tavernkeeper,"start", [], "Good day dear {sir/madam}. How can I help you?", "tavernkeeper_talk",[]],

  [anyone ,"start", [(store_conversation_troop,reg(1)),(ge,reg(1),tavernkeepers_begin),(lt,reg(1),tavernkeepers_end)],
   "Good day dear {sir/madam}. How can I help you?", "tavernkeeper_talk",
   [
#    (store_encountered_party,reg(2)),
#    (party_get_slot,"$tavernkeeper_party",reg(2),slot_town_mercs),
    ]],
  
  [anyone,"tavernkeeper_pretalk", [], "Anything else?", "tavernkeeper_talk",[]],

  [anyone|plyr,"tavernkeeper_talk", [(check_quest_active,"qst_deliver_wine"),
                                     (store_encountered_party,reg(7)),
                                     (eq,reg(7),"$deliver_wine_quest_town"),
                                     (store_item_kind_count,reg(8),"$deliver_wine_quest_item"),
                                     (ge,reg(8),"$deliver_wine_quest_number"),
                                     (assign,reg(9),"$deliver_wine_quest_number"),
                                     (str_store_item_name,s2,"$deliver_wine_quest_item"),
                                     ],
   "I was told to deliver you {reg9} units of {s2}.", "tavernkeeper_deliver_wine",[]],
  [anyone,"tavernkeeper_deliver_wine", [],
 "At last! My stock was almost depleted.\
 I had paid the cost of the {s2} in advance.\
 Here, take these {reg5} denars. That should cover your pay.\
 And tell {s1} my regards.\
 I'll put in a good word for you next time I deal with him.", "tavernkeeper_pretalk",
   [[troop_remove_items, 0,"$deliver_wine_quest_item","$deliver_wine_quest_number"],
    [troop_add_gold, "trp_player","$deliver_wine_quest_pay"],
    [assign,reg(12),"$deliver_wine_quest_pay"],
    [val_mul,reg(12),5],
    [add_xp_as_reward,reg(12)],
    [call_script, "script_end_quest","qst_deliver_wine"],
    [assign,"$deliver_wine_quest_active",0],
    [assign,reg(5),"$deliver_wine_quest_pay"],
    [str_store_item_name,s2,"$deliver_wine_quest_item"],
    [str_store_troop_name,s1,"$deliver_wine_quest_giver"],
    [val_add,"$merchants_guild_rank",1]]],

  [anyone|plyr,"tavernkeeper_talk", [[check_quest_active,"qst_deliver_wine"],
                                     [store_encountered_party,reg(7)],
                                     [eq,reg(7),"$deliver_wine_quest_town"],
                                     [store_item_kind_count,reg(8),"$deliver_wine_quest_item"],
                                     [lt,reg(8),"$deliver_wine_quest_number"],
                                     [ge,reg(8),1],
                                     [assign,reg(9),"$deliver_wine_quest_number"],
                                     [str_store_item_name,s2,"$deliver_wine_quest_item"],
                                     ],
   "I was told to deliver you {reg9} units of {s2}, but I lost some of the cargo on the way.", "tavernkeeper_deliver_wine_incomplete",[]],
  [anyone,"tavernkeeper_deliver_wine_incomplete", [],
 "Attacked by bandits eh?\
 You are lucky they left you alive.\
 Anyway, I can pay you no more than {reg5} denars for this.\
 And I will let {s1} know that my order was delivered less than completly,\
 so you will probably be charged for this loss.", "tavernkeeper_pretalk",
   [[store_item_kind_count,reg(8),"$deliver_wine_quest_item"],
    [troop_remove_items, 0,"$deliver_wine_quest_item",reg(8)],
    [assign,reg(5),"$deliver_wine_quest_pay"],
    [val_mul,reg(5),reg(8)],
    [val_div,reg(5),"$deliver_wine_quest_number"],
    [troop_add_gold, "trp_player",reg(5)],
    [assign,reg(12),reg(5)],
    [val_mul,reg(12),4],
    [add_xp_as_reward,reg(12)],
    [call_script, "script_end_quest","qst_deliver_wine"],
    [assign,"$deliver_wine_quest_active",0],
    [str_store_item_name,s2,"$deliver_wine_quest_item"],
    [str_store_troop_name,s1,"$deliver_wine_quest_giver"],
    [assign,reg(14),"$deliver_wine_quest_debt"],
    [val_mul,reg(14),reg(8)],
    [val_div,reg(14),"$deliver_wine_quest_number"],
    [val_add,"$debt_to_merchants_guild",reg(14)],
   ]],
  [anyone|plyr,"tavernkeeper_talk", [[check_quest_active,"qst_deliver_wine"],
                                     [store_encountered_party,reg(7)],
                                     [eq,reg(7),"$deliver_wine_quest_town"],
                                     [store_item_kind_count,reg(8),"$deliver_wine_quest_item"],
                                     [eq,reg(8),0],
                                     [assign,reg(9),"$deliver_wine_quest_number"],
                                     [str_store_item_name,s2,"$deliver_wine_quest_item"],
                                     ],
   "I was told to deliver you {reg9} units of {s2}, but I lost the cargo on the way.", "tavernkeeper_deliver_wine_lost",[]],
  [anyone,"tavernkeeper_deliver_wine_lost", [],
 "What? I was waiting for that {s2} for weeks!\
 And now you are telling me that you lost it?\
 You may rest assured that I will let {s1} know about this.", "tavernkeeper_pretalk",
   [[add_xp_as_reward,40],
    [call_script, "script_end_quest","qst_deliver_wine"],
    [assign,"$deliver_wine_quest_active",0],
    [str_store_item_name,s2,"$deliver_wine_quest_item"],
    [str_store_troop_name,s1,"$deliver_wine_quest_giver"],
    [val_add,"$debt_to_merchants_guild","$deliver_wine_quest_debt"],
   ]],

##  [anyone|plyr,"tavernkeeper_talk", [], "I need to hire some soldiers. Can you help me?", "tavernkeeper_buy_peasants",[]],
##  [anyone,"tavernkeeper_buy_peasants",
##   [
##       (store_encountered_party,reg(3)),
##       (store_faction_of_party,reg(4),reg(3)),
##       (store_relation,reg(5),"fac_player_faction",reg(4)),
##       (lt, reg(5), -3),
##    ], "I don't think anyone from this town will follow somebody like you. Try your luck elsewhere.", "tavernkeeper_buy_peasants_2",[]],
##  [anyone,"tavernkeeper_buy_peasants", [], "I know a few fellows who would follow you if you paid for their equipment.", "tavernkeeper_buy_peasants_2",[(set_mercenary_source_party,"$tavernkeeper_party"),[change_screen_buy_mercenaries]]],
##  [anyone,"tavernkeeper_buy_peasants_2", [], "Anything else?", "tavernkeeper_talk",[]],
##
##  [anyone|plyr,"tavernkeeper_talk", [], "I want to rest for a while.", "tavernkeeper_rest",[]],
###  [anyone,"tavernkeeper_rest", [], "Of course... How long do you want to rest?", "tavernkeeper_rest_2",[]],
##  [anyone,"tavernkeeper_rest",
##   [
##       (store_encountered_party,reg(3)),
##       (store_faction_of_party,reg(4),reg(3)),
##       (store_relation,reg(5),"fac_player_faction",reg(4)),
##       (lt, reg(5), -3),
##      ], "You look like trouble stranger. I can't allow you to stay for the night. No.", "close_window",
##   []],
##  [anyone,"tavernkeeper_rest", [], "Of course... That will be {reg3} denars for the room and food. How long do you want to rest?", "tavernkeeper_rest_2",
##   [(store_party_size,reg(3)),
##    (val_add,reg(3),1),
##    (val_div,reg(3),3),
##    (val_max,reg(3),1),
##    (assign,"$tavern_rest_cost",reg(3))]],
##  [anyone|plyr,"tavernkeeper_rest_2", [(store_time_of_day,reg(1)),
##                                       (val_add,reg(1),7),
##                                       (val_mod,reg(1),24),
##                                       (lt,reg(1),12),
##                                       (store_troop_gold,reg(8),"trp_player"),
##                                       (ge,reg(8),"$tavern_rest_cost"),
##                                       ],
##   "I want to rest until morning.", "close_window",
##   [(assign, reg(2), 13),(val_sub,reg(2),reg(1)),(assign, "$g_town_visit_after_rest", 1),(rest_for_hours, reg(2)),(troop_remove_gold, "trp_player","$tavern_rest_cost"),(call_script, "script_change_player_party_morale", 2)]],
##  [anyone|plyr,"tavernkeeper_rest_2", [(store_time_of_day,reg(1)),
##                                       (val_add,reg(1),7),
##                                       (val_mod,reg(1),24),
##                                       (ge,reg(1),12),
##                                       (store_troop_gold,reg(8),"trp_player"),
##                                       (ge,reg(8),"$tavern_rest_cost"),
##                                       ],
##   "I want to rest until evening.", "close_window",
##   [(assign, reg(2), 28),(val_sub,reg(2),reg(1)),(assign, "$g_town_visit_after_rest", 1),(rest_for_hours, reg(2)),(troop_remove_gold, "trp_player","$tavern_rest_cost"),(call_script, "script_change_player_party_morale", 2)]],
##  [anyone|plyr,"tavernkeeper_rest_2", [], "Forget it.", "close_window",[]],

  [anyone|plyr,"tavernkeeper_talk", [], "I guess I should leave now.", "close_window",[]],

#Tavern Talk (with companions)
  [anyone, "companion_recruit_yes", [(neg|hero_can_join, "p_main_party"),], "I don't think can lead any more men than you do now.\
 You need to release someone from service if you want me to join your party.", "close_window", []],

#Add individual companion conversations after here.

#  [trp_marnid,"start",[(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, 0),(eq,"$marnid_introduced",0)],"Hello, you are new to the town aren't you. Would you be so kind to have a cup of wine with a fellow traveller?\
# I am here to waste my last five denars and I'd rather have someone help me with that.", "marnid_introduce_1",[(assign,"$marnid_introduced",1)]],
#  [trp_marnid|plyr,"marnid_introduce_1",[],"Your last five denars? It seems that luck has not been at your side lately.", "marnid_introduce_2",[]],
#  [trp_marnid,"marnid_introduce_2",[],"Luck? I have had none of that lately.\
# Three months ago, I left Geroia with a caravan of goods. I was hoping to sell it all in Harlaushia and make a hefty sum.\
# But, what do you know... we were ambushed by a party of Khergit raiders who rode away with most of the horses and goods.\
# And two weeks later, my own caravan guards ran away with the rest of what I had.","marnid_introduce_3",[]],
#  [trp_marnid|plyr,"marnid_introduce_3",[],"My sympathies friend. What are you planning to do now?", "marnid_introduce_4",[]],
#  [trp_marnid,"marnid_introduce_4",[],"Eh. I have no money left, no friends or relatives to ask for help.\
# The only way left for me is to enlist as a soldier and seek my fortune in war. Do you know, by any chance,\
# anyone who would want to hire a ruined merchant? I don't have much skill with the sword, but I am sure I could be helpful if someone gave me a chance.", "marnid_ask_hire",[]],
#
#  [trp_marnid|plyr,"marnid_ask_hire", [], "Actually, I am looking for companions. I could use a tradesman like you.", "companion_recruit_yes",[]],
#  [trp_marnid,"companion_recruit_yes", [], "Well, look at this. I feel that my luck is starting to turn back after all.\
# I am at your service, friend. Let us hit the road and discover what adventures await us.", "close_window",
#   [(call_script, "script_recruit_troop_as_companion", "$g_talk_troop")]],
#  
#  [trp_marnid|plyr,"marnid_ask_hire", [], "Sorry. I recruit only the best warriors.", "marnid_no",[]],
#  [trp_marnid,"marnid_no", [], "Ah! If you say so. Well, let me know if you change your mind.", "close_window",[]],
#
#  [trp_marnid,"start",[(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, 0)], "Hello {playername}, do you know, by any chance,\
# anyone who would want to hire a ruined merchant? I don't have much skill with the sword, but I am sure I could be helpful if someone gave me a chance..",
#   "marnid_ask_hire",[]],


#individual companion conversations end.

  [anyone, "start", [(is_between, "$g_talk_troop", companions_begin, companions_end),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, 0)],
   "TODO: Hello. do you want to recruit me?", "companion_recruit_default", []],

  [anyone|plyr, "companion_recruit_default", [], "Yes.", "companion_recruit_yes", []],

  
  [anyone, "companion_recruit_yes", [], "Great!", "close_window", [(call_script, "script_recruit_troop_as_companion", "$g_talk_troop")]],

  [anyone|plyr, "companion_recruit_default", [],  "No.", "companion_recruit_no", []],
  [anyone, "companion_recruit_no", [], "All right then.", "close_window", []],

  [anyone, "start", [(is_between, "$g_talk_troop", companions_begin, companions_end),
                     (eq, "$talk_context", tc_tavern_talk),],
   "Let's leave as soon as possible.", "close_window", []],


#Tavern Talk (with ransom brokers)


  [anyone,"start", [(is_between, "$g_talk_troop", ransom_brokers_begin, ransom_brokers_end),
                    (eq, "$g_talk_troop_met", 0)],
   "Greetings to you, {sir/madam}. You look like someone who should get to know me.", "ransom_broker_intro",[]],

  [anyone|plyr,"ransom_broker_intro",[], "Why is that?", "ransom_broker_intro_2",[]],
  [anyone, "ransom_broker_intro_2", [], "I broker ransoms for the poor wretches who are captured in these endless wars.\
 Normally I travel between the salt mines and the slave markets on the coast, on commission from those whose relatives have gone missing.\
 But if I'm out on my errands of mercy, and I come across a fellow dragging around a captive or two,\
 well, there's no harm in a little speculative investment, is there?\
 And you look like the type who might have a prisoner to sell.", "ransom_broker_info_talk",[(assign, "$ransom_broker_families_told",0),
                                                                                            (assign, "$ransom_broker_prices_told",0),
                                                                                            (assign, "$ransom_broker_ransom_me_told",0),
                                                                                            ]],

  [anyone|plyr,"ransom_broker_info_talk",[(eq, "$ransom_broker_families_told",0)], "What if their families can't pay?", "ransom_broker_families",[]],
  [anyone, "ransom_broker_families", [], "Oh, then I spin them a few heartwarming tales of life on the galleys.\
 You'd be surprised what sorts of treasures a peasant can dig out of his cowshed or wheedle out of his cousins,\
 assuming he's got the proper motivation!\
 And if in the end they cannot come up with the silver, then there are always slave merchants who are looking for galley slaves.\
 One cannot do Heaven's work with an empty purse, you see.", "ransom_broker_info_talk",[(assign, "$ransom_broker_families_told",1)]],
  [anyone|plyr,"ransom_broker_info_talk",[(eq, "$ransom_broker_prices_told",0)], "What can I get for a prisoner?", "ransom_broker_prices",[]],
  [anyone, "ransom_broker_prices", [], "It varies. I fancy that I have a fine eye for assessing a ransom.\
 There are a dozen little things about a man that will tell you whether he goes to bed hungry, or dines each night on soft dumplings and goose.\
 The real money of course is in the gentry, and if you ever want to do my job you'll want to learn about every landowning family in Calradia,\
 their estates, their heraldry, their offspring both lawful and bastard, and, of course, their credit with the merchants.", "ransom_broker_info_talk",[(assign, "$ransom_broker_prices_told",1)]],
  [anyone|plyr,"ransom_broker_info_talk",[(eq, "$ransom_broker_ransom_me_told",0)], "Would you be able to ransom me if I were taken?", "ransom_broker_ransom_me",[]],
  [anyone, "ransom_broker_ransom_me", [], "Of course. I'm welcome in every court in Calradia.\
 There's not many who can say that! So always be sure to keep a pot of denars buried somewhere,\
 and a loyal servant who can find it in a hurry.", "ransom_broker_info_talk",[(assign, "$ransom_broker_ransom_me_told",1)]],
  [anyone|plyr,"ransom_broker_info_talk",[], "That's all I need to know. Thanks.", "ransom_broker_pretalk",[]],

  [anyone,"start", [(is_between, "$g_talk_troop", ransom_brokers_begin, ransom_brokers_end),],
   "Greetings. If you have any prisoners, I will be happy to buy them from you.", "ransom_broker_talk",[]],
  [anyone,"ransom_broker_pretalk", [],
   "Anyway, if you have any prisoners, I will be happy to buy them from you.", "ransom_broker_talk",[]],

  [anyone|plyr,"ransom_broker_talk",
   [[store_num_regular_prisoners,reg(0)],[ge,reg(0),1]],
   "Then you'd better bring your purse. I have got prisoners to sell.", "ransom_broker_sell_prisoners",[]],
  [anyone|plyr,"ransom_broker_talk", [], "Tell me about what you do again.", "ransom_broker_intro_2",[]],
  [anyone|plyr,"ransom_broker_talk",[], "Not this time. Good-bye.", "close_window",[]],
  [anyone,"ransom_broker_sell_prisoners", [],
  "Let me see what you have...", "ransom_broker_sell_prisoners_2",
   [[change_screen_trade_prisoners]]],
#  [anyone, "ransom_broker_sell_prisoners_2", [], "You take more prisoners, bring them to me. I will pay well.", "close_window",[]],
  [anyone, "ransom_broker_sell_prisoners_2", [], "I will be staying here for a few days. Let me know if you need my services.", "close_window",[]],


#Tavern Talk (with travelers)
  [anyone, "start", [(is_between, "$g_talk_troop", tavern_travelers_begin, tavern_travelers_end),
                     (party_get_slot, ":info_faction", "$g_encountered_party", slot_center_traveler_info_faction),
                     (str_store_faction_name, s17, ":info_faction"),
                     ],
   "Greetings. They say you're the kind of {man/woman} who'd be interested to hear that I travel frequently to {s17}. I'll tell you all I know for a mere 100 denars.", "tavern_traveler_answer", []],

  [anyone|plyr, "tavern_traveler_answer", [(store_troop_gold, ":cur_gold", "trp_player"),
                                            (ge, ":cur_gold", 100)],
   "Here's 100 denars. Tell me what you know.", "tavern_traveler_continue", [(party_get_slot, ":info_faction", "$g_encountered_party", slot_center_traveler_info_faction),
                                           (call_script, "script_update_faction_traveler_notes", ":info_faction"),
                                           (change_screen_notes, 2, ":info_faction"),
                                           ]],

  [anyone|plyr, "tavern_traveler_answer", [],
   "Sorry friend. I am not interested.", "close_window", []],

  [anyone, "tavern_traveler_continue", [],
   "Well, that's all I can tell you. Good bye.", "close_window", [(troop_remove_gold, "trp_player", 100),]],

#Tavern Talk (with minstrels)
  [anyone, "start", [(is_between, "$g_talk_troop", tavern_minstrels_begin, tavern_minstrels_end),
                     ],
   "TODO: Hello. I am a minstrel. (Not implemeted yet)", "close_window", []],

#Tavern Talk (with troops)

  [anyone, "start", [(eq, "$talk_context", tc_tavern_talk),
                     (party_get_slot, ":mercenary_troop", "$g_encountered_party", slot_center_mercenary_troop_type),
                     (party_get_slot, ":mercenary_amount", "$g_encountered_party", slot_center_mercenary_troop_amount),
                     (gt, ":mercenary_amount", 0),
                     (store_sub, reg3, ":mercenary_amount", 1),
                     (store_sub, reg4, reg3, 1),
                     (call_script, "script_game_get_join_cost", ":mercenary_troop"),
                     (assign, ":join_cost", reg0),
                     (store_mul, reg5, ":mercenary_amount", reg0),
                     (party_get_free_companions_capacity, ":free_capacity", "p_main_party"),
                     (val_min, ":mercenary_amount", ":free_capacity"),
                     (store_troop_gold, ":cur_gold", "trp_player"),
                     (try_begin),
                       (gt, ":join_cost", 0),
                       (val_div, ":cur_gold", ":join_cost"),
                       (val_min, ":mercenary_amount", ":cur_gold"),
                     (try_end),
                     (assign, "$temp", ":mercenary_amount"),
                     ],
   "Do you have a need for mercenaries, {sir/madam}?\
 {reg3?Me and {reg4?{reg3} of my mates:one of my mates} are:I am} looking for a master.\
 We'll join you for {reg5} denars.", "mercenary_tavern_talk", []],

  [anyone, "start", [(eq, "$talk_context", tc_tavern_talk),],
   "Any orders, {sir/madam}?", "mercenary_after_recruited", []],

  [anyone|plyr, "mercenary_after_recruited", [],
   "Make your preparations. We'll be moving at dawn.", "mercenary_after_recruited_2", []],
  [anyone|plyr, "mercenary_after_recruited", [],
   "Take your time. We'll be staying in this town for a while.", "mercenary_after_recruited_2", []],

  [anyone, "mercenary_after_recruited_2", [], "Yes {sir/madam}. We'll be ready when you tell us to leave.", "close_window", []],

  [anyone|plyr, "mercenary_tavern_talk", [(party_get_slot, ":mercenary_amount", "$g_encountered_party", slot_center_mercenary_troop_amount),
                                          (eq, ":mercenary_amount", "$temp"),
                                          (party_get_slot, ":mercenary_troop", "$g_encountered_party", slot_center_mercenary_troop_type),
                                          (call_script, "script_game_get_join_cost", ":mercenary_troop"),
                                          (store_mul, reg5, "$temp", reg0),                                          
                                          ],
   "All right. I will hire all of you. Here is {reg5} denars.", "mercenary_tavern_talk_hire", []],

  [anyone|plyr, "mercenary_tavern_talk", [(party_get_slot, ":mercenary_amount", "$g_encountered_party", slot_center_mercenary_troop_amount),
                                          (lt, "$temp", ":mercenary_amount",),
                                          (gt, "$temp", 0),
                                          (assign, reg6, "$temp"),
                                          (party_get_slot, ":mercenary_troop", "$g_encountered_party", slot_center_mercenary_troop_type),
                                          (call_script, "script_game_get_join_cost", ":mercenary_troop"),
                                          (store_mul, reg5, "$temp", reg0),
                                          ],
   "All right. But I can only hire {reg6} of you. Here is {reg5} denars.", "mercenary_tavern_talk_hire", []],


  [anyone, "mercenary_tavern_talk_hire", [(store_random_in_range, ":rand", 0, 4),
                                          (try_begin),
                                            (eq, ":rand", 0),
                                            (gt, "$temp", 1),
                                            (str_store_string, s17,
                                             "@You chose well, {sir/madam}. My lads know how to keep their word and earn their pay."),
                                          (else_try),
                                            (eq, ":rand", 1), 
                                            (str_store_string, s17,
                                             "@Well done, {sir/madam}. Keep the money and wine coming our way, and there's no foe in Calradia you need fear."),
                                          (else_try),
                                            (eq, ":rand", 2), 
                                            (str_store_string, s17,
                                             "@We are at your service, {sir/madam}. Point us in the direction of those who need hurting, and we'll do the rest."),
                                          (else_try),
                                            (str_store_string, s17,
                                             "@You will not be dissapointed {sir/madam}. You will not find better warriors in all Calradia."),
                                          (try_end),],
   "{s17}", "close_window", [
                                          (party_get_slot, ":mercenary_troop", "$g_encountered_party", slot_center_mercenary_troop_type),
                                          (call_script, "script_game_get_join_cost", ":mercenary_troop"),
                                          (store_mul, ":total_cost", "$temp", reg0),
                                          (troop_remove_gold, "trp_player", ":total_cost"),
                                          (party_add_members, "p_main_party", ":mercenary_troop", "$temp"),
                                          (party_set_slot, "$g_encountered_party", slot_center_mercenary_troop_amount, 0)]],

  [anyone|plyr, "mercenary_tavern_talk", [(eq, "$temp", 0),
                                          (party_get_free_companions_capacity, ":free_capacity", "p_main_party"),
                                          (ge, ":free_capacity", 1)],
   "That sounds good. But I can't afford to hire any more men right now.", "tavern_mercenary_cant_lead", []],
  
  [anyone, "tavern_mercenary_cant_lead", [], "That's a pity. Well, {reg3?we will:I will} be lingering around here for a while,\
 if you need to hire anyone.", "close_window", []],
  
  [anyone|plyr, "mercenary_tavern_talk", [(eq, "$temp", 0),
                                          (party_get_free_companions_capacity, ":free_capacity", "p_main_party"),
                                          (eq, ":free_capacity", 0)],
   "That sounds good. But I can't lead any more men right now.", "tavern_mercenary_cant_lead", []],


  [anyone|plyr, "mercenary_tavern_talk", [(gt, "$temp", 0)],
   "Sorry. I don't need any other men right now.", "close_window", []],


#Crooks

##  [anyone ,"start", [(is_between,"$g_talk_troop",crooks_begin,crooks_end),(eq,"$g_talk_troop_met",0),(eq,"$sneaked_into_town",0),(store_random_in_range, reg2, 2)],
##   "You {reg2?looking for:want} something?:", "crook_intro_1",[]],
##  [anyone|plyr,"crook_intro_1",[],"I am trying to learn my way around the town.", "crook_intro_2",[]],
##  
##  [anyone,"crook_intro_2",[(eq,"$crook_talk_order",0),(val_add,"$crook_talk_order",1),(str_store_troop_name,s1,"$g_talk_troop")],
##"Then you came to the right guy. My name is {s1}, and I know everyone and everything that goes around in this town.\
## Anyone you want to meet, I can arrange it. Anything you need to know, I can find out. For the the right price, of course. Do you have gold?", "crook_intro_2a",[]],
##  [anyone|plyr,"crook_intro_2a",[],"I have gold. Plenty of it.", "crook_intro_2a_1a",[]],
##  [anyone|plyr,"crook_intro_2a",[],"Not really.", "crook_intro_2a_1b",[]],
##  [anyone,"crook_intro_2a_1a",[],"Good. That means you and I will be great friends.", "crook_talk",[]],
##  [anyone,"crook_intro_2a_1b",[],"Then you should look into earning some. Listen to me now, for I'll give you some free advice.\
## The easiest way to make money is to fight in the tournaments and bet on yourself. If you are good, you'll quickly get yourself enough money to get going.", "crook_talk",[]],
##
##  [anyone,"crook_intro_2",[(eq,"$crook_talk_order",1),(val_add,"$crook_talk_order",1),(str_store_troop_name,s1,"$g_talk_troop")],
##"Then you need to go no further. I am {s1}, and I can provide you anything... For the the right price.", "crook_intro_2b",[]],
##  [anyone|plyr,"crook_intro_2b",[],"Are you a dealer?", "crook_intro_2b_1",[]],
##  [anyone,"crook_intro_2b_1",[],"A dealer? Yes. I deal in knowledge... connections.. lies... secrets... Those are what I deal in. Interested?", "crook_talk",[]],
##
##  [anyone,"crook_intro_2",[(eq,"$crook_talk_order",2),(val_add,"$crook_talk_order",1),(str_store_troop_name,s1,"$g_talk_troop")],
##"Then this is your lucky day. Because you are talking to {s1}, and I know every piss-stained brick of this wicked town.\
##I know every person, every dirty little secret. And all that knowledge can be yours. For a price.", "crook_talk",[]],
##
##  [anyone,"crook_intro_2",[(val_add,"$crook_talk_order",1),(str_store_troop_name,s1,"$g_talk_troop")],
## "Then {s1} is at your service {sir/madam}. If you want to know what's really going on in this town, or arrange a meeting in secret, then come to me. I can help you.", "crook_talk",[]],
##
##  [anyone ,"start", [(is_between,"$g_talk_troop",crooks_begin,crooks_end),(eq,"$g_talk_troop_met",0),(eq,"$sneaked_into_town",1),(eq,"$crook_sneak_intro_order",0),(val_add,"$crook_sneak_intro_order",1)],
##   "Good day. {playername} right?", "crook_intro_sneak_1",[]],
##  [anyone|plyr,"crook_intro_sneak_1", [], "You must be mistaken. I'm just a poor pilgrim. I don't answer to that name.", "crook_intro_sneak_2",[]],
##  [anyone,"crook_intro_sneak_2", [(str_store_troop_name,s1,"$g_talk_troop")], "Of course you do. And if the town guards knew you were here, they'd be upon you this minute.\
## But don't worry. Noone knows it is {playername} under that hood. Except me of course. But I am {s1}. It is my business to know things.", "crook_intro_sneak_3",[]],
##  [anyone|plyr,"crook_intro_sneak_3", [], "You won't tip off the guards about my presence?", "crook_intro_sneak_4",[]],
##  [anyone,"crook_intro_sneak_4", [], "What? Of course not! Well, maybe I would, but the new captain of the guards is a dung-eating cheat.\
## I led him to this fugitive, and the man was worth his weight in silver as prize money. But I swear, I didn't see a penny of it.\
## The bastard took it all to himself. So your secret is safe with me.", "crook_intro_sneak_5",[]],
##  [anyone,"crook_intro_sneak_5", [], "Besides, I heard you have a talent for surviving any kind of ordeal.\
## I wouldn't want you to survive this one as well and then come after me with a sword. Ha-hah.", "crook_talk",[]],
##
##
##  [anyone ,"start", [(is_between,"$g_talk_troop",crooks_begin,crooks_end),(eq,"$g_talk_troop_met",0),(eq,"$sneaked_into_town",1),(str_store_troop_name,s1,"$g_talk_troop")],
##   "{s1} is at your service {sir/madam}. If you want to know what's really going on in this town, or arrange a meeting in secret, then come to me. I can help you.", "crook_talk",[]],
##
##  [anyone ,"start", [(is_between,"$g_talk_troop",crooks_begin,crooks_end),(store_character_level, ":cur_level", "trp_player"),(lt,":cur_level",8)],
##   "{You again?/Delighted to see you again my pretty.}", "crook_talk",[]],
##  [anyone ,"start", [(is_between,"$g_talk_troop",crooks_begin,crooks_end)],
##   "I see that you need my services {sir/madam}...", "crook_talk",[]],
##  [anyone ,"crook_pretalk", [],
##   "Is that all?", "crook_talk",[]],

##### TODO: QUESTS COMMENT OUT BEGIN
##  [anyone|plyr,"crook_talk", [(check_quest_active, "qst_kill_local_merchant"),
##                              (neg|check_quest_succeeded, "qst_kill_local_merchant"),
##                              (neg|check_quest_failed, "qst_kill_local_merchant"),
##                              (quest_slot_eq, "qst_kill_local_merchant", slot_quest_target_center, "$g_encountered_party")],
##   "TODO: I want to kill a local merchant.", "crook_local_merchant",[]],
##
##  [anyone,"crook_local_merchant", [],
##   "Alright but this will cost you 50 denars.", "crook_local_merchant_2", []],
##
##  [anyone|plyr, "crook_local_merchant_2", [(store_troop_gold, ":cur_gold", "trp_player"),
##                                           (ge, ":cur_gold", 50)],
##   "TODO: Here it is. 50 denars.", "crook_local_merchant_3_1",[(troop_remove_gold, "trp_player", 50)]],
##
##  [anyone|plyr, "crook_local_merchant_2", [(store_troop_gold, ":cur_gold", "trp_player"),
##                                            (ge, ":cur_gold", 50)],
##   "Never mind then.", "crook_pretalk",[]],
##
##  [anyone|plyr, "crook_local_merchant_2", [(store_troop_gold, ":cur_gold", "trp_player"),
##                                            (lt, ":cur_gold", 50)],
##   "TODO: I don't have that much money.", "crook_local_merchant_3_2",[]],
##
##  [anyone,"crook_local_merchant_3_1", [],
##   "TODO: There you go.", "close_window", [(quest_get_slot, ":quest_target_troop", "qst_kill_local_merchant", slot_quest_target_troop),
##                                           (set_jump_mission,"mt_back_alley_battle"),
##                                           (party_get_slot, ":town_alley", "$g_encountered_party", slot_town_alley),
##                                           (modify_visitors_at_site,":town_alley"),(reset_visitors),
##                                           (set_visitor, 0, "trp_player"),
##                                           (set_visitor, 8, ":quest_target_troop"),
##                                           (jump_to_scene,":town_alley")]],
##
##  [anyone,"crook_local_merchant_3_2", [],
##   "TODO: Come back later then.", "crook_pretalk",[]],
##### TODO: QUESTS COMMENT OUT END


  
##  [anyone|plyr,"crook_talk", [], "I'm looking for a person...", "crook_search_person",[]],
##  [anyone|plyr,"crook_talk", [], "I want you to arrange me a meeting with someone...", "crook_request_meeting",[]],
##  [anyone|plyr,"crook_talk", [], "[Leave]", "close_window",[]],



#  [anyone,"crook_enter_dungeon", [],
#   "Alright but this will cost you 50 denars.", "crook_enter_dungeon_2", []],

#  [anyone|plyr, "crook_enter_dungeon_2", [(store_troop_gold, ":cur_gold", "trp_player"),
#                                            (ge, ":cur_gold", 50)],
#   "TODO: Here it is. 50 denars.", "crook_enter_dungeon_3_1",[(troop_remove_gold, "trp_player", 50)]],

#  [anyone|plyr, "crook_enter_dungeon_2", [(store_troop_gold, ":cur_gold", "trp_player"),
#                                            (ge, ":cur_gold", 50)],
#   "Never mind then.", "crook_pretalk",[]],

#  [anyone|plyr, "crook_enter_dungeon_2", [(store_troop_gold, ":cur_gold", "trp_player"),
#                                            (lt, ":cur_gold", 50)],
#   "TODO: I don't have that much money.", "crook_enter_dungeon_3_2",[]],

#  [anyone,"crook_enter_dungeon_3_1", [],
#   "TODO: There you go.", "close_window", [(call_script, "script_enter_dungeon", "$current_town", "mt_town_disguised")]],

#  [anyone,"crook_enter_dungeon_3_2", [],
#   "TODO: Come back later then.", "crook_pretalk",[]],
 

##  [anyone, "crook_request_meeting", [],
##   "Who do you want to meet with?", "crook_request_meeting_2",[]],
##  [anyone|plyr|repeat_for_troops,"crook_request_meeting_2", [(store_encountered_party, ":center_no"),
##                                                             (store_repeat_object, ":troop_no"),
##                                                             (is_between, ":troop_no", heroes_begin, heroes_end),
##                                                             (troop_get_slot, ":cur_center", ":troop_no", slot_troop_cur_center),
##                                                             (call_script, "script_get_troop_attached_party", ":troop_no"),
##                                                             (assign, ":cur_center_2", reg0),
##                                                             (this_or_next|eq, ":cur_center", ":center_no"),
##                                                             (eq, ":cur_center_2", ":center_no"),
##                                                             (neg|party_slot_eq, ":center_no", slot_town_lord, ":troop_no"),#Neglect the ruler of the center
##                                                             (str_store_troop_name, s1, ":troop_no")],
##   "{s1}", "crook_request_meeting_3", [(store_repeat_object, "$selected_troop")]],
##
##  [anyone|plyr,"crook_request_meeting_2", [], "Never mind.", "crook_pretalk", []],
##
##  [anyone,"crook_request_meeting_3", [],
##   "Alright but this will cost you 50 denars.", "crook_request_meeting_4", []],
##
##  [anyone|plyr, "crook_request_meeting_4", [(store_troop_gold, ":cur_gold", "trp_player"),
##                                            (ge, ":cur_gold", 50)],
##   "TODO: Here it is. 50 denars.", "crook_search_person_5_1",[(troop_remove_gold, "trp_player", 50)]],
##
##  [anyone|plyr, "crook_request_meeting_4", [(store_troop_gold, ":cur_gold", "trp_player"),
##                                            (ge, ":cur_gold", 50)],
##   "Never mind then.", "crook_pretalk",[]],
##
##  [anyone|plyr, "crook_request_meeting_4", [(store_troop_gold, ":cur_gold", "trp_player"),
##                                            (lt, ":cur_gold", 50)],
##   "TODO: I don't have that much money.", "crook_search_person_5_2",[]],
##
##  [anyone, "crook_search_person_5_1", [],
##   "TODO: Ok.", "close_window",[(party_get_slot, ":town_alley", "$g_encountered_party", slot_town_alley),
##                                (modify_visitors_at_site,":town_alley"),(reset_visitors),
##                                (set_visitor,0,"trp_player"),
##                                (set_visitor,17,"$selected_troop"),
##                                (set_jump_mission,"mt_conversation_encounter"),
##                                (jump_to_scene,":town_alley"),
##                                (assign, "$talk_context", tc_back_alley),
##                                (change_screen_map_conversation, "$selected_troop")]],
##
##  [anyone, "crook_search_person_5_2", [],
##   "TODO: Come back later then.", "crook_pretalk",[]],
##
##  [anyone, "crook_search_person", [],
##   "TODO: Who are you searching for?", "crook_search_person_2",[]],
##  [anyone|plyr|repeat_for_factions,"crook_search_person_2", [(store_repeat_object, ":faction_no"),
##                                                             (is_between, ":faction_no", kingdoms_begin, kingdoms_end),
##                                                             (str_store_faction_name, s1, ":faction_no")],
##   "TODO: I'm looking for a {s1}.", "crook_search_person_3", [(store_repeat_object, "$selected_faction")]],
##
##  [anyone|plyr,"crook_search_person_2", [], "Never mind.", "crook_pretalk", []],
##
##  
##  [anyone, "crook_search_person_3", [],
##   "TODO: Who?", "crook_search_person_4",[]],
##  
##  [anyone|plyr|repeat_for_troops,"crook_search_person_4", [(store_repeat_object, ":troop_no"),
##                                                           (is_between, ":troop_no", heroes_begin, heroes_end),
##                                                           (store_troop_faction, ":faction_no", ":troop_no"),
##                                                           (eq, ":faction_no", "$selected_faction"),
##                                                           (str_store_troop_name, s1, ":troop_no")],
##   "{s1}", "crook_search_person_5", [(store_repeat_object, "$selected_troop")]],
##
##  [anyone|plyr,"crook_search_person_4", [], "Never mind.", "crook_pretalk", []],
##
##  [anyone, "crook_search_person_5", [(call_script, "script_get_information_about_troops_position", "$selected_troop", 0),
##                                     (eq, reg0, 1),
##                                     (str_store_troop_name, s1, "$selected_troop")],
##   "TODO: I know where {s1} is at the moment, but hearing it will cost you 50 denars.", "crook_search_person_6",[]],
##
##  [anyone, "crook_search_person_5", [],
##   "TODO: Sorry I don't know anything.", "crook_pretalk",[]],
##
##  [anyone|plyr, "crook_search_person_6", [(store_troop_gold, ":cur_gold", "trp_player"),
##                                          (ge, ":cur_gold", 50)],
##   "TODO: Here it is. 50 denars.", "crook_search_person_7_1",[(troop_remove_gold, "trp_player", 50)]],
##
##  [anyone|plyr, "crook_search_person_6", [(store_troop_gold, ":cur_gold", "trp_player"),
##                                          (ge, ":cur_gold", 50)],
##   "Never mind then.", "crook_pretalk",[]],
##
##  [anyone|plyr, "crook_search_person_6", [(store_troop_gold, ":cur_gold", "trp_player"),
##                                          (lt, ":cur_gold", 50)],
##   "TODO: I don't have that much money.", "crook_search_person_7_2",[]],
##
##  [anyone, "crook_search_person_7_1", [(call_script, "script_get_information_about_troops_position", "$selected_troop", 0)],
##   "{s1}", "crook_pretalk",[]],
##
##  [anyone, "crook_search_person_7_2", [],
##   "TODO: Come back later then.", "crook_pretalk",[]],
##  

#Goods Merchants
  
  [anyone ,"start", [(store_conversation_troop,reg(1)),(ge,reg(1),goods_merchants_begin),(lt,reg(1),goods_merchants_end)],
   "Welcome {sir/madam}.", "merchant_begin",[]],

  #[trp_salt_mine_merchant,"start", [], "Hello.", "merchant_begin",[]],

  [anyone,"merchant_begin", [[eq,"$kidnapped_girl_brought_back",1],
                             [store_conversation_troop,reg(7)],
                             [eq,"$kidnapped_girl_quest_giver",reg(7)]],
   "Dear {playername}. I am in your debt for bringing back my friend's daughter.\
  Please take these {reg8} denars that I promised you.\
  My friend wished he could give more but paying that ransom brought him to his knees.", "close_window",
   [[assign,"$kidnapped_girl_brought_back",0],
    [troop_add_gold, "trp_player","$kidnapped_girl_quest_pay"],
    [assign,reg(8),"$kidnapped_girl_quest_pay"],
    [assign,reg(9),"$kidnapped_girl_quest_pay"],
    [val_div,reg(9),2],
    [store_random,reg(11),100],
    [val_add,reg(9),reg(11)],
    [val_mul,reg(9),10],
    [add_xp_as_reward,reg(9)],
    [call_script, "script_end_quest","qst_kidnapped_girl"],
    [store_conversation_troop,"$merchant_quest_last_offerer"],
    [assign,"$merchant_offered_quest",-1],
    [val_add,"$merchants_guild_rank",1],
    ]],
  
  [anyone,"merchant_begin", [[eq,"$troublesome_bandits_quest_succeeded",1],
                             [store_conversation_troop,reg(7)],
                             [eq,reg(7),"$troublesome_bandits_quest_giver"]],
   "I have heard about your deeds. You have given those bandits the punishment they deserved.\
 You are really as good as they say.\
 Here is your reward: {reg5} denars.\
 I would like to give more but those bandits almost brought me to bankrupcy.", "goods_merchant_friendly_pretalk",
                              [[assign,"$troublesome_bandits_quest_succeeded",0],
                               [call_script, "script_end_quest","qst_troublesome_bandits"],
                               [assign,reg(5),"$troublesome_bandits_quest_pay"],
                               [troop_add_gold, "trp_player","$troublesome_bandits_quest_pay"],
                               [assign,reg(8),"$troublesome_bandits_quest_pay"],
                               [val_mul,reg(8),7],
                               [add_xp_as_reward,reg(8)],
                               [store_conversation_troop,"$merchant_quest_last_offerer"],
                               [assign,"$merchant_offered_quest",-1],
                               [val_add,"$merchants_guild_rank",1],
                               ]],

  [anyone,"merchant_begin", [[ge,"$debt_to_merchants_guild",50]],
   "According to my accounts, you owe the merchants guild {reg1} denars.\
 I'd better collect that now.", "merchant_ask_for_debts",[[assign,reg(1),"$debt_to_merchants_guild"]]],
  [anyone|plyr,"merchant_ask_for_debts", [[store_troop_gold,reg(5),"trp_player"],[ge,reg(5),"$debt_to_merchants_guild"]],
   "Alright. I'll pay my debt to you.", "merchant_debts_paid",[[troop_remove_gold, "trp_player","$debt_to_merchants_guild"],
                                                                [assign,"$debt_to_merchants_guild",0]]],
  [anyone, "merchant_debts_paid", [], "Excellent. I'll let my fellow merchants know that you are clear of any debts.", "goods_merchant_pretalk",[]],

  [anyone|plyr, "merchant_ask_for_debts", [], "I'm afraid I can't pay that sum now.", "merchant_debts_not_paid",[]],
  [anyone, "merchant_debts_not_paid", [], "In that case, I am afraid, I can't deal with you. Guild rules...\
 Come back when you can pay the {reg1} denars.\
 And know that we'll be charging an interest to your debt.\
 So the sooner you pay it, the better.", "close_window",[]],

  [anyone,"goods_merchant_friendly_pretalk", [], "Now... What else may I do for you?", "goods_merchant_talk",[]],

  [anyone,"merchant_begin", [], " What can I do for you?", "goods_merchant_talk",[]],


  [anyone|plyr,"goods_merchant_talk", [], "I want to buy a few things... and perhaps sell some.", "goods_trade_requested",[]],
  [anyone,"goods_trade_requested", [], "Sure, sure... Let me show you what we have...", "goods_trade_completed",[[change_screen_trade]]],
  [anyone,"goods_trade_completed", [], "Anything else?", "goods_merchant_talk",[]],
  [anyone,"goods_merchant_pretalk", [], "Anything else?", "goods_merchant_talk",[]],
#  [anyone|plyr,"goods_merchant_talk", [], "What do caravans buy and sell in this town?", "goods_merchant_town_info",[]],
#  [anyone,"goods_merchant_town_info_completed", [], "Anything else?", "goods_merchant_talk",[]],
  
  [anyone|plyr,"goods_merchant_talk", [[store_partner_quest,reg(2)],[lt,reg(2),0],
                                       [store_conversation_troop,reg(5)],
                                       [neq,"$merchant_quest_last_offerer",reg(5)]],
   "Do you happen to have a job for me?", "merchant_quest_requested",[
     [store_conversation_troop,"$merchant_quest_last_offerer"],
     [assign,"$num_merchant_quests_available","$merchants_guild_rank"],
     [assign,"$cur_merchant_quests_end",merchant_quests_begin],
     [val_max,"$num_merchant_quests_available",1],
     [val_add,"$cur_merchant_quests_end","$num_merchant_quests_available"],
     [val_min,"$cur_merchant_quests_end",merchant_quests_end],
     [store_random_quest_in_range,reg(0),merchant_quests_begin,"$cur_merchant_quests_end"],
     [assign,"$random_merchant_quest_no",reg(0)],
     [assign,"$merchant_offered_quest","$random_merchant_quest_no"],
     ]],
  [anyone|plyr,"goods_merchant_talk", [[store_partner_quest,reg(2)],[lt,reg(2),0],
                                       [store_conversation_troop,reg(5)],
                                       [eq,"$merchant_quest_last_offerer",reg(5)],
                                       [ge,"$merchant_offered_quest",0]], "About that job you offered me...", "merchant_quest_last_offered_job",[]],

  [anyone|plyr,"goods_merchant_talk", [[store_partner_quest,reg(2)],[ge,reg(2),0]],
   "About the job you gave me...", "merchant_quest_about_job",[]],
  [anyone,"merchant_quest_about_job", [], "What about it?", "merchant_quest_about_job_2",[]],
  [anyone|plyr,"merchant_quest_about_job_2", [], "What if I can't finish it?", "merchant_quest_what_if_fail",[]],
  [anyone|plyr,"merchant_quest_about_job_2", [], "Well, I'm still working on it.", "merchant_quest_about_job_working",[]],
  [anyone,"merchant_quest_about_job_working", [], "Good. I'm sure you will handle it.", "goods_merchant_pretalk",[]],


  [anyone,"merchant_quest_last_offered_job", [], "Eh, you want to reconsider that. Good...", "merchant_quest_brief",
   [[assign,"$random_merchant_quest_no","$merchant_offered_quest"]]],


  [anyone,"merchant_quest_what_if_fail", [[store_partner_quest,reg(2)],[eq,reg(2),"qst_deliver_wine"]],
   "I hope you don't fail. In that case, I'll have to ask for the price of the cargo you were carrying.", "goods_merchant_pretalk",[]],
  [anyone,"merchant_quest_what_if_fail", [], "Well, just do your best to finish it.", "goods_merchant_pretalk",[]],

  [anyone|plyr,"goods_merchant_talk", [], "Nothing. Thanks.", "close_window",[]],

  [anyone,"merchant_quest_taken", [], "Excellent. I am counting on you then. Good luck.", "goods_merchant_pretalk",
   [[assign,"$merchant_quest_last_offerer",0]]],
  [anyone,"merchant_quest_stall", [], "Well, the job will be available for a few more days I guess. Tell me if you decide to take it.", "goods_merchant_pretalk",[]],

###################################################################3
# Random Merchant quests....
##############################
  # deliver wine:
  [anyone,"merchant_quest_requested", [[eq,"$random_merchant_quest_no","qst_deliver_wine"],], "You're looking for a job?\
 Actually I was looking for someone to deliver some {s2}.\
 Perhaps you can do that...", "merchant_quest_brief",
   [
    [store_random_party_in_range, reg(0),towns_begin,towns_end],
    [assign,"$deliver_wine_quest_town", reg(0)],
    [store_random_in_range, ":random_no", 0, 2],
    [try_begin],
      [eq, ":random_no", 0],
      [assign,"$deliver_wine_quest_item","itm_quest_wine"],
    [else_try],
      [assign,"$deliver_wine_quest_item","itm_quest_ale"],
    [try_end],
    [store_random,"$deliver_wine_quest_number",6],
    [val_add,"$deliver_wine_quest_number",6],
    [str_store_item_name,s2,"$deliver_wine_quest_item"],
    [store_conversation_troop,"$deliver_wine_quest_giver"],
    [store_encountered_party,"$deliver_wine_quest_giver_town"],
    [store_distance_to_party_from_party, reg(0),"$deliver_wine_quest_giver_town","$deliver_wine_quest_town"],
    [assign,"$deliver_wine_quest_pay",reg(0)],
    [val_add,"$deliver_wine_quest_pay",2],
    [assign,reg(10),5],
    [val_add,reg(10),"$deliver_wine_quest_number"],
    [val_mul,"$deliver_wine_quest_pay",reg(10)],
#    [val_mul,"$deliver_wine_quest_pay",2],
#    [val_div,"$deliver_wine_quest_pay",3],
    [val_div,"$deliver_wine_quest_pay",100],
    [val_mul,"$deliver_wine_quest_pay",10],
    [store_item_value,"$deliver_wine_quest_debt","$deliver_wine_quest_item"],
    [val_mul,"$deliver_wine_quest_debt","$deliver_wine_quest_number"],
    [val_mul,"$deliver_wine_quest_debt",6],
    [val_div,"$deliver_wine_quest_debt",5],
    ]],

  [anyone,"merchant_quest_brief", [[eq,"$random_merchant_quest_no","qst_deliver_wine"]],
   "I have a cargo of {s6} that needs to be delivered to the tavern in {s2}.\
 If you can take {reg5} units of {s6} to {s2} in 7 days, you may earn {reg8} denars.\
 What do you say?", "merchant_quest_brief_deliver_wine",[
     [assign,reg(8),"$deliver_wine_quest_pay"],
     [assign,reg(5),"$deliver_wine_quest_number"],
     [str_store_troop_name,s1,"$deliver_wine_quest_giver"],
     [str_store_party_name,s2,"$deliver_wine_quest_town"],
     [str_store_item_name,s6,"$deliver_wine_quest_item"],
     [setup_quest_text,"qst_deliver_wine"],
   ]],
  
  [anyone|plyr,"merchant_quest_brief_deliver_wine", [[store_free_inventory_capacity,reg(6)],[ge,reg(6),"$deliver_wine_quest_number"]],
      "Alright. I will make the delivery.", "merchant_quest_taken",[
        (assign,"$deliver_wine_quest_active",1),
        (store_current_day, "$deliver_wine_quest_end_day"),
        (val_add,"$deliver_wine_quest_end_day",7),
        (troop_add_items,  0,"$deliver_wine_quest_item","$deliver_wine_quest_number"),
        (str_store_party_name, s3, "$g_encountered_party"),
        (str_store_string, s2, "@{s1} of {s3} asked you to deliver {reg5} units of {s6} to the tavern in {s2} in 7 days."),
        (call_script, "script_start_quest", "qst_deliver_wine", "$g_talk_troop"),
        ]],
  [anyone|plyr,"merchant_quest_brief_deliver_wine", [], "I am afraid I can't carry all that cargo now.", "merchant_quest_stall",[]],

#escort merchant caravan:
  [anyone,"merchant_quest_requested", [[eq,"$random_merchant_quest_no","qst_escort_merchant_caravan"]], "You're looking for a job?\
 Actually I was looking for someone to escort a caravan.\
 Perhaps you can do that...", "merchant_quest_brief",
   [
    [store_random_party_in_range, reg(0),towns_begin,towns_end],
    [assign,"$escort_merchant_caravan_quest_town", reg(0)],
    [store_encountered_party,"$escort_merchant_caravan_quest_giver_town"],
    [assign,"$escort_merchant_caravan_quest_pay",200],
    [store_distance_to_party_from_party, reg(0),"$escort_merchant_caravan_quest_giver_town","$escort_merchant_caravan_quest_town"],
    [assign,"$escort_merchant_caravan_quest_pay",reg(0)],
    [val_add,"$escort_merchant_caravan_quest_pay",25],
    [val_mul,"$escort_merchant_caravan_quest_pay",25],
    [val_div,"$escort_merchant_caravan_quest_pay",2],
    [val_div,"$escort_merchant_caravan_quest_pay",10],
    [val_mul,"$escort_merchant_caravan_quest_pay",1],
    [store_random,"$escort_merchant_min_size",6],
    [val_add,"$escort_merchant_min_size",6],
    ]],

  [anyone,"merchant_quest_brief", [[eq,"$random_merchant_quest_no","qst_escort_merchant_caravan"]],
   "I am going to send a caravan of goods to {s1}.\
 However with all those bandits and deserters on the roads, I don't want to send them out without an escort.\
 If you can lead that caravan to {s1} in 15 days, you will earn {reg8} denars.\
 Of course your party needs to be at least {reg4} strong to offer them any protection.", "escort_merchant_caravan_quest_brief",[
     [assign,reg(8),"$escort_merchant_caravan_quest_pay"],
     [assign,reg(4),"$escort_merchant_min_size"],
     [str_store_party_name,1,"$escort_merchant_caravan_quest_town"],
   ]],
  
  [anyone|plyr,"escort_merchant_caravan_quest_brief", [[store_party_size_wo_prisoners,reg(6)],[ge,reg(6),"$escort_merchant_min_size"]],
      "Alright. I will escort the caravan.", "merchant_quest_taken",[
        (assign,"$escort_merchant_caravan_quest_active",1),
        (set_spawn_radius,1),
        (spawn_around_party,"$escort_merchant_caravan_quest_giver_town","pt_merchant_caravan"),
        (assign,"$merchant_caravan_id",reg(0)),
        (party_set_ai_behavior,"$merchant_caravan_id",ai_bhvr_track_party),
        (party_set_ai_object,"$merchant_caravan_id",0),
        (party_set_flags, "$merchant_caravan_id", pf_default_behavior, 0),
        (assign,"$merchant_caravan_met",0),
        (str_store_party_name,1,"$escort_merchant_caravan_quest_town"),
        (setup_quest_text,"qst_escort_merchant_caravan"),
        (str_store_string, s2, "@Escort the merchant caravan to the town of {s1}."),
        (call_script, "script_start_quest", "qst_escort_merchant_caravan", "$g_talk_troop"),
    ]],
  [anyone|plyr,"escort_merchant_caravan_quest_brief", [[store_party_size_wo_prisoners,reg(6)],[lt,reg(6),"$escort_merchant_min_size"]],
   "I am afraid I don't have that many soldiers with me.", "merchant_quest_stall",[]],
  [anyone|plyr,"escort_merchant_caravan_quest_brief", [[store_party_size,reg(6)],[ge,reg(6),"$escort_merchant_min_size"]],
   "Sorry. I can't do that right now", "merchant_quest_stall",[]],

  [party_tpl|pt_merchant_caravan,"start", [[store_encountered_party,reg(11)],
                                                     [eq,reg(11),"$merchant_caravan_id"],
                                                     [eq,"$escort_merchant_caravan_quest_active",2]],
   "We can cover the rest of the way ourselves. Thanks.", "close_window",[(assign, "$g_leave_encounter",1)]],
  
  [party_tpl|pt_merchant_caravan,"start", [[store_encountered_party,reg(11)],
                                                     [eq,reg(11),"$merchant_caravan_id"],
                                                     [store_distance_to_party_from_party, reg(0),"$escort_merchant_caravan_quest_town","$merchant_caravan_id"],
                                                     [lt,reg(0),4],
                                                     [eq,"$escort_merchant_caravan_quest_active",1]],
   "Well, we have almost reached {s21}. We can cover the rest of the way ourselves.\
 Here's your pay... {reg4} denars.\
 Thanks for escorting us. Good luck.", "close_window",[[party_set_ai_behavior,"$merchant_caravan_id",ai_bhvr_travel_to_party],
                                                       [party_set_ai_object,"$merchant_caravan_id","$escort_merchant_caravan_quest_town"],
				                                       [party_set_flags, "$merchant_caravan_id", pf_default_behavior, 0],
                                                       [str_store_party_name,s21,"$escort_merchant_caravan_quest_town"],
                                                       [call_script, "script_end_quest","qst_escort_merchant_caravan"],
                                                       [assign,"$escort_merchant_caravan_quest_active",2],
                                                       [troop_add_gold, "trp_player","$escort_merchant_caravan_quest_pay"],
                                                       [assign,reg(7),"$escort_merchant_caravan_quest_pay"],
                                                       [val_mul,reg(7),5],
                                                       [val_add,reg(7),100],
                                                       [add_xp_as_reward,reg(7)],
                                                       [assign,reg(4),"$escort_merchant_caravan_quest_pay"],
                                                       [val_add,"$merchants_guild_rank",1],
                                                       (assign, "$g_leave_encounter",1)]],
  
  [party_tpl|pt_merchant_caravan,"start", [[store_encountered_party,reg(11)],
                                                     [eq,reg(11),"$merchant_caravan_id"],
                                                     [eq,"$merchant_caravan_met",0]],
   "Greetings. You must be our escort, right?", "merchant_caravan_intro_1",[[assign,"$merchant_caravan_met",1]]],
  [anyone|plyr,"merchant_caravan_intro_1", [], "Yes. My name is {playername}. I will lead you to {s1}.", "merchant_caravan_intro_2",[[str_store_party_name,1,"$escort_merchant_caravan_quest_town"]]],
  [anyone,"merchant_caravan_intro_2", [], "Well, It is good to know we won't travel alone. What do you want us to do now?", "escort_merchant_caravan_talk",[]],
  [party_tpl|pt_merchant_caravan,"start", [[store_encountered_party,reg(11)],
                                                     [eq,reg(11),"$merchant_caravan_id"]],
   "Eh. We've made it this far... What do you want us to do?", "escort_merchant_caravan_talk",[]],
  [anyone|plyr,"escort_merchant_caravan_talk", [], "You follow my lead. I'll take you through a safe route.", "merchant_caravan_follow_lead",[]],
  [anyone,"merchant_caravan_follow_lead", [], "Alright. We'll be right behind you.", "close_window",[(assign,"$escort_merchant_caravan_mode",0),(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"escort_merchant_caravan_talk", [], "You stay here for a while. I'll go ahead and check the road.", "merchant_caravan_stay_here",[]],
  [anyone,"merchant_caravan_stay_here", [], "Alright. We'll be waiting here for you.", "close_window",[(assign,"$escort_merchant_caravan_mode",1),(assign, "$g_leave_encounter",1)]],
#  [anyone|plyr,"escort_merchant_caravan_talk", [], "You go ahead to {s1}. I'll catch up with you.", "merchant_caravan_go_to_destination",[]],
#  [anyone,"merchant_caravan_go_to_destination", [], "Alright. But stay close.", "close_window",[[assign,"escort_merchant_caravan_mode",2]]],


# Troublesome bandits:
  [anyone,"merchant_quest_requested", [[eq,"$random_merchant_quest_no","qst_troublesome_bandits"]],
 "Actually, I was looking for an able adventurer like you.\
 There's this group of particularly troublesome bandits.\
 They have infested the vicinity of our town and are preying on my caravans.\
 They have avoided all the soldiers and the militias up to now.\
 If someone doesn't stop them soon, I am going to be ruined...", "merchant_quest_brief",
   [
    [store_conversation_troop,"$troublesome_bandits_quest_giver"],
    [store_encountered_party,"$troublesome_bandits_quest_giver_town"],
    [store_character_level,reg(7)],
    [val_add,reg(7),20],
    [val_mul,reg(7),35],
    [assign,"$troublesome_bandits_quest_pay",reg(7)],
    [val_div,"$troublesome_bandits_quest_pay",100],
    [val_mul,"$troublesome_bandits_quest_pay",10],
    ]],

  [anyone,"merchant_quest_brief", [[eq,"$random_merchant_quest_no","qst_troublesome_bandits"]],
  "I will pay you {reg8} denars if you hunt down those troublesome bandits.\
 It's dangerous work. But I believe that you are the {man/one} for it.\
 What do you say?", "troublesome_bandits_quest_brief",[
     [assign,reg(8),"$troublesome_bandits_quest_pay"],
   ]],

  [anyone|plyr,"troublesome_bandits_quest_brief", [],
      "Alright. I will hunt down those bandits.", "merchant_quest_taken_bandits",[
        (assign,"$troublesome_bandits_quest_active",1),
        (assign,"$troublesome_bandits_quest_succeeded",0),
        (set_spawn_radius,7),
        (spawn_around_party,"$troublesome_bandits_quest_giver_town","pt_troublesome_bandits"),
        (assign,"$troublesome_bandits_id",reg(0)),
        (store_num_parties_destroyed,"$troublesome_bandits_eliminated","pt_troublesome_bandits"),
        (store_num_parties_destroyed_by_player, "$troublesome_bandits_eliminated_by_player", "pt_troublesome_bandits"),
        (str_store_troop_name,1,"$troublesome_bandits_quest_giver"),
        (str_store_party_name,2,"$troublesome_bandits_quest_giver_town"),
        (setup_quest_text,"qst_troublesome_bandits"),
        (str_store_string, s2, "@Merchant {s1} of {s2} asked you to hunt down the troublesome bandits in the vicinity of the town."),
        (call_script, "script_start_quest", "qst_troublesome_bandits", "$g_talk_troop"),
    ]],
  [anyone,"merchant_quest_taken_bandits", [], "You will? I am so happy to hear that. Good luck to you.", "goods_merchant_friendly_pretalk",
   [[assign,"$merchant_quest_last_offerer",0]]],
  
  [anyone|plyr,"troublesome_bandits_quest_brief", [],
   "Sorry. I don't have time for this right now.", "merchant_quest_stall",[]],

# Kidnapped girl:
  [anyone,"merchant_quest_requested", [[eq,"$random_merchant_quest_no","qst_kidnapped_girl"]],
 "Actually, I was looking for a reliable {man/helper} that can undertake an important mission.\
 A group of bandits have kidnapped the daughter of a friend of mine and are holding her for ransom.\
 My friend is ready to pay them, but we still need\
 someone to take the money to those rascals and bring the girl back to safety.", "merchant_quest_brief",
   [
    [store_random_party_in_range, reg(0),towns_begin,towns_end],
    [assign,"$kidnapped_girl_quest_town", reg(0)],
    [store_conversation_troop,"$kidnapped_girl_quest_giver"],
    [store_encountered_party,"$kidnapped_girl_quest_giver_town"],
    [store_character_level,reg(7)],
    [val_add,reg(7),15],
    [store_distance_to_party_from_party, reg(0),"$kidnapped_girl_quest_giver_town","$kidnapped_girl_quest_town"],
    [val_add,reg(0),15],
    [val_mul,reg(0),2],
    [val_mul,reg(7),reg(0)],
    [assign,"$kidnapped_girl_ransom_amount",reg(7)],
    [assign,"$kidnapped_girl_quest_pay","$kidnapped_girl_ransom_amount"],
    [val_div,"$kidnapped_girl_quest_pay",4],
    [val_div,"$kidnapped_girl_quest_pay",100],
    [val_mul,"$kidnapped_girl_quest_pay",10],
    [val_div,"$kidnapped_girl_ransom_amount",100],
    [val_mul,"$kidnapped_girl_ransom_amount",10],
    ]],

  [anyone,"merchant_quest_brief", [[eq,"$random_merchant_quest_no","qst_kidnapped_girl"]],
  "The amount the bandits ask as ransom is {reg12} denars.\
 I will give you that money once you accept to take the quest.\
 You have 15 days to take the money to the bandits who will be waiting near the town of {s2}.\
 Those bastards said that they are going to kill the poor girl if they don't get the money by that time.\
 You will get your pay of {reg8} denars when you bring the girl safely back here.",
   "kidnapped_girl_quest_brief",[
     [str_store_party_name,2,"$kidnapped_girl_quest_town"],
     [assign,reg(8),"$kidnapped_girl_quest_pay"],
     [assign,reg(12),"$kidnapped_girl_ransom_amount"],
   ]],

  [anyone|plyr,"kidnapped_girl_quest_brief", [],
      "Alright. I will take the ransom money to the bandits and bring back the girl.", "kidnapped_girl_quest_taken",[
        (set_spawn_radius,4),
        (spawn_around_party,"$kidnapped_girl_quest_town","pt_bandits_awaiting_ransom"),
        (assign,"$kidnapped_girl_bandits_id",reg(0)),
        (party_set_ai_behavior,"$kidnapped_girl_bandits_id",ai_bhvr_hold),
        (party_set_ai_object,"$kidnapped_girl_bandits_id",0),
        (party_set_flags, "$kidnapped_girl_bandits_id", pf_default_behavior, 0),
        (troop_add_gold, "trp_player","$kidnapped_girl_ransom_amount"),
        (assign,"$kidnapped_girl_freed",0),
        (assign,"$kidnapped_girl_bandits_introd",0),
        (assign,"$kidnapped_girl_joined",0),
        (assign,"$kidnapped_girl_bandits_attacked",0),
        (assign,reg(12),"$kidnapped_girl_ransom_amount"),
        (str_store_troop_name,1,"$kidnapped_girl_quest_giver"),
        (str_store_party_name,2,"$kidnapped_girl_quest_giver_town"),
        (str_store_party_name,3,"$kidnapped_girl_quest_town"),
        (setup_quest_text,"qst_kidnapped_girl"),
        (str_store_string, s2, "@Merchant {s1} gave you {reg12} denars to pay the ransom of a girl kidnapped by bandits.\
 You are to meet the bandits near {s3} and pay them the ransom fee.\
 After that you are to bring the girl back to {s2}."),
        (call_script, "script_start_quest", "qst_kidnapped_girl", "$g_talk_troop"),
     ]],
  [anyone,"kidnapped_girl_quest_taken", [], "Good. I knew we could trust you at this.\
 Here is the ransom money, {reg12} denars.\
 Count it before taking it.\
 And please, don't attempt to do anything rash.\
 Keep in mind that the girl's well being is more important than anything else...", "close_window",
   [[assign,"$merchant_quest_last_offerer",0]]],
  
  [anyone|plyr,"kidnapped_girl_quest_brief", [],
   "Sorry. I don't have time for this right now.", "merchant_quest_stall",[]],


  [anyone,"start", [(eq, "$talk_context", tc_hero_freed),(store_conversation_troop,":cur_troop"),(eq,":cur_troop","trp_kidnapped_girl"),],
   "Oh {sir/madam}. Thank you so much for rescuing me. Will you take me to my family now?", "kidnapped_girl_liberated_battle",[]],

  [trp_kidnapped_girl|plyr,"kidnapped_girl_liberated_map", [], "Yes. Come with me. We are going home.", "kidnapped_girl_liberated_map_2a",[]],
  [trp_kidnapped_girl,"kidnapped_girl_liberated_map_2a", [[neg|party_can_join]], "Unfortunately. You do not have room in your party for me.", "close_window",[(assign, "$g_leave_encounter",1)]],
  [trp_kidnapped_girl,"kidnapped_girl_liberated_map_2a", [], "Oh really? Thank you so much!", "close_window",[(party_join),(assign,"$kidnapped_girl_joined",1),(assign, "$g_leave_encounter",1)]],
  [trp_kidnapped_girl|plyr,"kidnapped_girl_liberated_map", [], "Wait here a while longer. I'll come back for you.", "kidnapped_girl_liberated_map_2b",[]],
  [trp_kidnapped_girl,"kidnapped_girl_liberated_map_2b", [], "Oh, please {sir/madam}, do not leave me here all alone!", "close_window",[(assign, "$g_leave_encounter",1)]],


  [trp_kidnapped_girl,"start", [],
   "Oh {sir/madam}. Thank you so much for rescuing me. Will you take me to my family now?", "kidnapped_girl_liberated_map",[]],
  
  [trp_kidnapped_girl|plyr,"kidnapped_girl_liberated_battle", [], "Yes. Come with me. We are going home.", "kidnapped_girl_liberated_battle_2a",[]],
  [trp_kidnapped_girl,"kidnapped_girl_liberated_battle_2a", [[neg|hero_can_join]], "Unfortunately. You do not have room in your party for me.", "kidnapped_girl_liberated_battle_2b",[]],
  [trp_kidnapped_girl,"kidnapped_girl_liberated_battle_2a", [], "Oh really? Thank you so much!", "close_window",[(party_add_members, "p_main_party","trp_kidnapped_girl",1),(assign,"$kidnapped_girl_joined",1)]],
  [trp_kidnapped_girl|plyr,"kidnapped_girl_liberated_battle", [], "Wait here a while longer. I'll come back for you.", "kidnapped_girl_liberated_battle_2b",[]],
  [trp_kidnapped_girl,"kidnapped_girl_liberated_battle_2b", [], "Oh, please {sir/madam}, do not leave me here all alone!", "close_window",[(add_companion_party,"trp_kidnapped_girl"),(assign, "$g_leave_encounter",1)]],

  [trp_kidnapped_girl,"start", [], "Can I come with you now?", "kidnapped_girl_liberated_map",[]],

  [trp_kidnapped_girl,"member_chat", [], "Are we home yet?", "kidnapped_girl_chat_1",[]],
  [trp_kidnapped_girl|plyr,"kidnapped_girl_chat_1", [], "No not yet.", "kidnapped_girl_chat_2",[]],
  [trp_kidnapped_girl,"kidnapped_girl_chat_2", [], "I missed my family so much. I can't wait to see them again.", "close_window",[]],


  [party_tpl|pt_bandits_awaiting_ransom,"start", [[eq,"$kidnapped_girl_freed",0],[eq,"$kidnapped_girl_bandits_introd",0]],
   "Are you the one that brought the ransom?\
 Quick, give us the money now.", "bandits_awaiting_ransom_intro_1",[[assign,"$kidnapped_girl_bandits_introd",1]]],
  [party_tpl|pt_bandits_awaiting_ransom,"start", [[eq,"$kidnapped_girl_freed",0]],
   "You came back?\
 Quick, give us the money now.", "bandits_awaiting_ransom_intro_1",[]],
  [party_tpl|pt_bandits_awaiting_ransom|plyr, "bandits_awaiting_ransom_intro_1", [[store_troop_gold,reg(14)],[ge,reg(14),"$kidnapped_girl_ransom_amount"]],
   "Here, take the money. Just set the girl free.", "bandits_awaiting_ransom_pay",[]],
  [party_tpl|pt_bandits_awaiting_ransom, "bandits_awaiting_ransom_pay", [[store_troop_gold,reg(14)],[ge,reg(14),"$kidnapped_girl_ransom_amount"]],
   "Heh. You've brought the money all right.\
 You can take the girl now.\
 It was a pleasure doing business with you...", "close_window",
   [[troop_remove_gold, "trp_player","$kidnapped_girl_ransom_amount"],
    [remove_member_from_party,"trp_kidnapped_girl","$kidnapped_girl_bandits_id"],
    [set_spawn_radius,1],
    [spawn_around_party,"$kidnapped_girl_bandits_id","pt_kidnapped_girl"],
    [assign,"$kidnapped_girl_party_id",reg(0)],
    [party_set_ai_behavior,"$kidnapped_girl_party_id",ai_bhvr_hold],
	[party_set_flags, "$kidnapped_girl_party_id", pf_default_behavior, 0],
    [assign,"$kidnapped_girl_freed",1],
    [party_set_ai_behavior,"$kidnapped_girl_bandits_id",ai_bhvr_travel_to_party],
    [party_set_ai_object,"$kidnapped_girl_bandits_id","$kidnapped_girl_quest_town"],
	[party_set_flags, "$kidnapped_girl_bandits_id", pf_default_behavior, 0],
    [add_gold_to_party,"$kidnapped_girl_ransom_amount","$kidnapped_girl_bandits_id"],
    (assign, "$g_leave_encounter",1),
    ]],
  [anyone|plyr, "bandits_awaiting_ransom_intro_1", [],
   "No way! You release the girl first.", "bandits_awaiting_ransom_b",[]],
  [anyone, "bandits_awaiting_ransom_b", [],
   "You fool! Stop playing games and give us the money! ", "bandits_awaiting_ransom_b2",[]],
  [anyone|plyr, "bandits_awaiting_ransom_b2", [[store_troop_gold,reg(14)],[ge,reg(14),"$kidnapped_girl_ransom_amount"]],
   "All right. Here's your money. Let the girl go now.", "bandits_awaiting_ransom_pay",[]],
  [anyone|plyr, "bandits_awaiting_ransom_b2", [],
   "I had left the money in a safe place. Let me go fetch it.", "bandits_awaiting_ransom_no_money",[]],
  [anyone, "bandits_awaiting_ransom_no_money", [],
   "Are you testing our patience or something?  Go and bring that money here quickly.", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone|plyr, "bandits_awaiting_ransom_b2", [],
#   "Release the girl at once or face the consequences!", "bandits_awaiting_ransom_fight",[]],
   "I have no intention to pay you anything. I demand that you release the girl now!", "bandits_awaiting_ransom_fight",[]],
  [anyone, "bandits_awaiting_ransom_fight", [],
   "You won't be demanding anything when you're dead.", "close_window",[[encounter_attack],[assign,"$kidnapped_girl_bandits_attacked",1],]],
#  [anyone|plyr, "bandits_awaiting_ransom_fight_2", [[store_troop_gold,reg(14)],[ge,reg(14),"$kidnapped_girl_ransom_amount"]],
#   "All right. Here's your money. Let the girl go now.", "bandits_awaiting_ransom_pay",[]],
#  [anyone|plyr, "bandits_awaiting_ransom_fight_2", [],
#   "Empty threats? No. I'll pay it to you with cold steel...", "close_window",[[encounter_attack]]],

  [party_tpl|pt_bandits_awaiting_ransom,"start", [[eq,"$kidnapped_girl_freed",1]],
   "What's it? You have given us the money. We have no more business.", "bandits_awaiting_remeet",[]],
  [anyone|plyr,"bandits_awaiting_remeet", [],
   "Sorry to bother you. I'll be on my way now.", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"bandits_awaiting_remeet", [],
   "We have one more business. You'll give the money back to me.", "bandits_awaiting_remeet_2",[]],
  [anyone,"bandits_awaiting_remeet_2", [],
   "Oh, that business! Of course. Let us get down to it.", "close_window",[[encounter_attack]]],

  [party_tpl|pt_kidnapped_girl,"start", [],
   "Oh {sir/madam}. Thank you so much for rescuing me. Will you take me to my family now?", "kidnapped_girl_encounter_1",[]],
  [anyone|plyr,"kidnapped_girl_encounter_1", [], "Yes. Come with me. I'll take you home.", "kidnapped_girl_join",[]],
  [anyone,"kidnapped_girl_join", [[neg|party_can_join]], "Unfortunately. You do not have room in your party for me.", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone,"kidnapped_girl_join", [], "Oh, thank you so much!", "close_window",[[party_join],[assign,"$kidnapped_girl_joined",1],(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"kidnapped_girl_encounter_1", [], "Wait here a while longer. I'll come back for you.", "kidnapped_girl_wait",[]],
  [anyone,"kidnapped_girl_wait", [], "Oh, please {sir/madam}, do not leave me here all alone!", "close_window",[(assign, "$g_leave_encounter",1)]],

  [trp_kidnapped_girl,"event_triggered", [[eq,"$talking_with_kidnapped_girl",1]],
   "Thank you so much for bringing me back!\
  I can't wait to see my family. Good-bye.",
   "close_window",[[remove_member_from_party,"trp_kidnapped_girl"]]],

  [anyone|plyr,"merchant_quest_about_job_2", [[store_partner_quest,reg(2)],[eq,reg(2),"qst_kidnapped_girl"],
                                              [eq,"$kidnapped_girl_joined",1],
                                              [neg|main_party_has_troop,"trp_kidnapped_girl"]],
   "Unfortunately I lost the girl on the way here...", "lost_kidnapped_girl",[]],
  [anyone,"lost_kidnapped_girl", [],
   "Oh no! How am I going to tell this to my friend?", "lost_kidnapped_girl_2",[]],
  [anyone|plyr,"lost_kidnapped_girl_2", [],
   "I'm sorry. I could do nothing about it.", "lost_kidnapped_girl_3",[]],
  [anyone,"lost_kidnapped_girl_3", [],
   "You let me down {playername}. I had trusted you.\
 I will let people know of your incompetence at this task.\
 Also, I want back that {reg8} denars I gave you as the ransom fee.", "lost_kidnapped_girl_4",
   [[assign,reg(8),"$kidnapped_girl_ransom_amount"],
    [call_script, "script_end_quest","qst_kidnapped_girl"],
    [store_conversation_troop,"$merchant_quest_last_offerer"],
    [assign,"$merchant_offered_quest",-1],
    [val_sub,"$merchants_guild_rank",4],
    ]],
  [anyone|plyr,"lost_kidnapped_girl_4", [[store_troop_gold,reg(11)],[ge,reg(11),"$kidnapped_girl_ransom_amount"]],
   "Of course. Here you are...", "merchant_quest_about_job_5a",[[troop_remove_gold, "trp_player","$kidnapped_girl_ransom_amount"]]],
  [anyone,"merchant_quest_about_job_5a", [],
   "At least you have the decency to return the money.", "close_window",[]],
  [anyone|plyr,"lost_kidnapped_girl_4", [],
   "Sorry. I don't have that amount with me.", "merchant_quest_about_job_5b",[]],
  [anyone,"merchant_quest_about_job_5b", [],
   "Do you expect me to believe that? You are going to pay that ransom fee back! Go and bring the money now!", "close_window",[
     [val_add,"$debt_to_merchants_guild","$kidnapped_girl_ransom_amount"]]],


#  Give us the money now. Quick.
# Here, take the money. Just set the girl free.
# Heh, It was a pleasure doing business with you. 
  
# You set the girl free first. You'll have the money afterwards.
# Stop playing games.  

################################################# 
#################### Random merchant quests end

  [anyone,"merchant_quest_requested", [], "I am afraid I can't offer you a job right now.", "goods_merchant_pretalk",[]],

##  [anyone,"goods_merchant_town_info", [],
##   "TODO: We produce {s1}, and we consume {s2}.", "goods_merchant_town_info_completed",
##   [(call_script, "script_print_productions_above_or_below_50", "$g_encountered_party", 1),
##    (str_store_string_reg, s1, s51),
##    (call_script, "script_print_productions_above_or_below_50", "$g_encountered_party", -1),
##    (str_store_string_reg, s2, s51)]],
##  
##  [anyone,"goods_merchant_town_info", [(store_encountered_party,reg(1)),(eq,reg(1),"p_zendar")],
##"You can buy tools from here at a very good price.\
## The best place to sell them would be Tulga. Heard they pay quite well for tools over there.\
## And next time you come here bring some salt. I will pay well for salt.", "goods_merchant_town_info_completed",[]],
##  [anyone,"goods_merchant_town_info", [(store_encountered_party,reg(1)),(eq,reg(1),"p_town_1")],
##"Sargoth is famous for its fine linen. Many caravans come here to buy that.\
## I heard you can sell it at Halmar and make a nice profit.\
## And next time you come here bring some iron. I will pay well for iron.", "goods_merchant_town_info_completed",[]],
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_town_2"]],
##"I can sell you some smoked fish with a special price.\
## I heard that caravans take smoked fish to Uxkhal and make a good profit.\
## And next time you come here bring some wool. I will pay you well for wool.", "goods_merchant_town_info_completed",[]],
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_town_3"]],
##"I can sell you some wine with a special price.\
## I heard that caravans buy wine from here and sell it at Wercheg, making a good profit.\
## And next time you come here, bring some dried meat. I will pay you well for dried meat.", "goods_merchant_town_info_completed",[]],
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_town_4"]],
##"I have a stock of oil which I can sell you with a good price.\
## They say they offer a fortune for oil in Rivacheg, so maybe you can sell it there.\
## And next time you come here, bring some furs. I will pay you well for furs.", "goods_merchant_town_info_completed",[]],
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_town_5"]],
##"Jelkala is famous for its velvet. Many caravans come here to buy that.\
## They say merchants will buy it at insane prices in Reyvadin, so maybe you can take it there.\
## And next time you come here, bring some pottery. I will pay you well for pottery.", "goods_merchant_town_info_completed",[]],
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_town_6"]],
##"We produce some excellent ale here in Praven. Most caravans come here to buy that.\
## They say that the folks at Khudan will sell their right arms for ale, so maybe you can take it there.\
## And next time you come here, bring some spice. I have sold out my stock of spice and I will pay you well for it.", "goods_merchant_town_info_completed",[]],
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_town_7"]],
##"We produce mostly wheat here in Uxkhal. I would suggest you buy that.\
## I heard you can sell it with a good profit in Tulga, so maybe you can take it there.\
## And next time you come here, bring some smoked fish. I will pay you well for it.", "goods_merchant_town_info_completed",[]],
##
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_town_8"]],
##"Most caravans come to Reyvadin to buy wool.\
## I heard that they take it to Tihr where they pay well for wool.\
## And next time you come here, bring some velvet. I will buy it from you at a good price.", "goods_merchant_town_info_completed",[]],
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_town_9"]],
##"Most caravans come to Khudan to buy furs.\
## I heard that they take it to Suno where they pay well for it.\
## And next time you come here, bring some ale. I will buy it from you at a good price.", "goods_merchant_town_info_completed",[]],
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_town_10"]],
##"Most caravans come to Tulga to buy spice.\
## They say that in Praven they pay well for spice, so you may think of selling it to the mechants there.\
## And next time you come here, bring some wheat. I will buy it from you at a good price.", "goods_merchant_town_info_completed",[]],
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_town_11"]],
##"We mine a lot of iron here in Curaw. I would suggest you buy that.\
## I heard you can take it to Sargoth and sell it with a good profit.\
## And next time you come here, bring some dried meat. I will pay you well for it.", "goods_merchant_town_info_completed",[]],
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_town_12"]],
##"I can sell you some smoked fish with a special price.\
## I heard that caravans take smoked fish to Uxkhal and make a good profit.\
## And next time you come here bring some wine. I will pay you well for wine.", "goods_merchant_town_info_completed",[]],
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_town_13"]],
##"I have a stock of dried meat which I can sell you with a good price.\
## They say they pay very well for dried meat in Veluca, so maybe you can sell it there.\
## And next time you come here, bring some oil. I have sold out my stock of oil and I will pay you well for it.", "goods_merchant_town_info_completed",[]],
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_town_14"]],
##"We produce some good quality pottery here in Halmar. Most caravans come here to buy that.\
## I heard that caravans buy pottery from here and sell it at Jelkala, making a good profit.\
## And next time you come here, bring some linen. I have sold out my stock of linen and I will pay you well for it.", "goods_merchant_town_info_completed",[]],
##
##  [anyone,"goods_merchant_town_info", [[store_encountered_party,reg(1)],[eq,reg(1),"p_salt_mine"]],
##"Heh. Are you joking with me? This is the salt mine. Merchants come here to buy salt.", "goods_merchant_town_info_completed",[]],
##
##  [anyone,"goods_merchant_town_info", [
##                                       (store_encountered_party,reg(9)),
##                                       (party_get_slot,reg(5),reg(9),slot_town_export_good),
##                                       (party_get_slot,reg(6),reg(9),slot_town_import_good),
##                                       (ge,reg(5),1),
##                                       (ge,reg(6),1),
##                                       (str_store_item_name,1,reg(5)),
##                                       (str_store_item_name,2,reg(6)),
##                                       ],
##  "I can sell you some {s1} with a special price.\
##And next time you come here bring some {s2}. I will pay you well for that.", "goods_merchant_town_info_completed",[]],
##
##  [anyone,"goods_merchant_town_info", [
##                                       (store_encountered_party,reg(9)),
##                                       (party_get_slot,reg(5),reg(9),slot_town_export_good),
##                                       (ge,reg(5),1),
##                                       (str_store_item_name,1,reg(5)),
##                                       ],
##  "I can sell you some {s1} with a special price.", "goods_merchant_town_info_completed",[]],
##
##  [anyone,"goods_merchant_town_info", [
##                                       (store_encountered_party,reg(9)),
##                                       (party_get_slot,reg(6),reg(9),slot_town_import_good),
##                                       (ge,reg(6),1),
##                                       (str_store_item_name,2,reg(6)),
##                                       ],
##  "If you have some {s2} with you, I am ready to pay you good money for it.", "goods_merchant_town_info_completed",[]],
##  
##  [anyone,"goods_merchant_town_info", [],
##"Sorry. Caravans hardly ever trade anything here.", "goods_merchant_town_info_completed",[]],






#############################################################################
#### ARENA MASTERS
#############################################################################

  
  [anyone ,"start", [(store_conversation_troop,reg(1)),
                     (is_between,reg(1),arena_masters_begin,arena_masters_end),
                     (eq,"$g_talk_troop_met", 0),
                     ],
   "Hello. You seem to be new here. Care to share your name?", "arena_master_intro_1",[]],
  [anyone|plyr,"arena_master_intro_1", [], "I am {playername}.", "arena_master_intro_2",[]],
  [anyone,"arena_master_intro_2", [(store_encountered_party,reg(2)),(str_store_party_name,1,reg(2))],
   "Well met {playername}. I am the master of the tournaments here at {s1}. Talk to me if you want to join the games or bet on one of the teams.", "arena_master_pre_talk",[]],

  [anyone,"start", [(store_conversation_troop,reg(1)),(is_between,reg(1),arena_masters_begin,arena_masters_end),(eq,"$waiting_for_arena_fight_result",1),(eq,"$arena_join_or_watch",0),(eq,"$arena_fight_won",1)],
 "Congratulations champion. You made some pretty good moves out there. Here is your share of share of the prize money, 2 denars.", "arena_master_pre_talk",
   [(assign,"$waiting_for_arena_fight_result",0),(add_xp_to_troop,20,"trp_player"),(troop_add_gold, "trp_player",2)]],
  [anyone,"start", [(store_conversation_troop,reg(1)),(is_between,reg(1),arena_masters_begin,arena_masters_end),(eq,"$waiting_for_arena_fight_result",1),(eq,"$arena_join_or_watch",0)],
 "That's quite the bruise you're sporting. But don't worry; everybody gets trounced once in awhile. The important thing is to pick yourself up, dust yourself off and keep fighting. That's what champions do.", "arena_master_pre_talk",[[assign,"$waiting_for_arena_fight_result"]]],
  [anyone,"start", [(store_conversation_troop,reg(1)),(is_between,reg(1),arena_masters_begin,arena_masters_end),(eq,"$waiting_for_arena_fight_result",1)],
 "That was exciting wasn't it? Nothing like a good fight to get the blood flowing.", "arena_master_pre_talk",[(assign,"$waiting_for_arena_fight_result",0)]],

  [anyone ,"start", [(store_conversation_troop,reg(1)),(is_between,reg(1),arena_masters_begin,arena_masters_end)],
   "Hello {playername}. Good to see you again.", "arena_master_pre_talk",[]],
  
  [anyone,"arena_master_pre_talk",
   [(eq,"$arena_join_or_watch",1),
    (ge,"$arena_bet_amount",1),
    (eq,"$arena_bet_team","$arena_winner_team"),
    (assign,reg(5),"$arena_win_amount")],
 "You've won the bet, eh? Let me see. The sum you have earned amounts to {reg5} denars. Here you go.", "arena_master_pre_talk",
   [(troop_add_gold, "trp_player","$arena_win_amount"),
    (assign,"$arena_bet_amount",0),
    (assign,"$arena_win_amount",0),
    ]],
  
  [anyone,"arena_master_pre_talk",
   [(eq,"$arena_join_or_watch",0),
    (ge,"$arena_bet_amount",1),
    (eq,"$arena_fight_won",1),
    (assign,reg(5),"$arena_win_amount"),
   ],
 "And you had the good sense to bet on yourself too. Hmm let me see. You have won yourself some {reg5} denars. Here you are.", "arena_master_pre_talk",
   [(troop_add_gold, "trp_player","$arena_win_amount"),
    (assign,"$arena_bet_amount",0),
    (assign,"$arena_win_amount",0)]],

  [anyone,"arena_master_pre_talk", [], "What would you like to do?", "arena_master_talk",[]],


  [anyone|plyr,"arena_master_talk", [], "About the arena fights...", "arena_master_melee",[]],
  [anyone|plyr,"arena_master_talk", [], "I need to leave now. Good bye.", "close_window",[]],

  [anyone,"arena_master_melee", [], "The next arena fight will start in a while. Hurry up if you want to take part in it.", "arena_master_melee_talk",[
    (party_get_slot, ":arena_cur_tier","$current_town",slot_town_arena_melee_cur_tier),
    (try_begin), #reg3 = num teams, reg4 = team size
      (eq, ":arena_cur_tier", 0),
      (party_get_slot, "$_num_teams","$current_town",slot_town_arena_melee_1_num_teams),
      (party_get_slot, "$_team_size","$current_town",slot_town_arena_melee_1_team_size),
    (else_try),
      (eq, ":arena_cur_tier", 1),
      (party_get_slot, "$_num_teams","$current_town",slot_town_arena_melee_2_num_teams),
      (party_get_slot, "$_team_size","$current_town",slot_town_arena_melee_2_team_size),
    (else_try),
      (party_get_slot, "$_num_teams","$current_town",slot_town_arena_melee_3_num_teams),
      (party_get_slot, "$_team_size","$current_town",slot_town_arena_melee_3_team_size),
    (try_end),
   ]],
  [anyone|plyr,"arena_master_melee_talk", [], "I want to join the next fight", "arena_master_next_melee_join",[(assign,"$arena_join_or_watch",0)]],
  [anyone|plyr,"arena_master_melee_talk", [], "I would like to watch the next fight", "arena_master_next_melee_watch",
   [(assign,"$arena_join_or_watch",1)]],
  [anyone|plyr,"arena_master_melee_talk", [], "No. perhaps later.", "arena_master_we_will_fight_not",[]],
  [anyone,"arena_master_we_will_fight_not", [], "Alright. Talk to me when you are ready.", "close_window",[]],
  [anyone,"arena_master_next_melee_join", [
    (assign,"$arena_bet_amount"),
    (assign,"$arena_bet_team",0),
    (party_get_slot, ":player_odds", "$g_encountered_party", slot_town_player_odds),
    (store_div, ":divider", ":player_odds", 20),
    (store_mul, ":odds_simple", ":divider", 20),
    (val_sub, ":odds_simple", ":player_odds"),
    (try_begin),
      (lt, ":odds_simple", 0),
      (val_add, ":divider", 1),
    (try_end),
    (val_max, ":divider", 50),
    (store_div, ":odds_player", ":player_odds", ":divider"),
    (store_div, ":odds_other", 1000, ":divider"),
    (try_for_range, ":unused", 0, 5),
      (assign, ":last_divider", 21),
      (try_for_range, ":cur_divider", 2, ":last_divider"),
        (store_div, ":odds_player_test", ":odds_player", ":cur_divider"),
        (val_mul, ":odds_player_test", ":cur_divider"),
        (eq, ":odds_player_test", ":odds_player"),
        (store_div, ":odds_other_test", ":odds_other", ":cur_divider"),
        (val_mul, ":odds_other_test", ":cur_divider"),
        (eq, ":odds_other_test", ":odds_other"),
        (val_div, ":odds_player", ":cur_divider"),
        (val_div, ":odds_other", ":cur_divider"),
        (assign, ":last_divider", 0),
      (try_end),
    (try_end),
    (assign, reg5, ":odds_player"),
    (assign, reg6, ":odds_other"),], "Do you want to place a bet on yourself? The odds against you are {reg5} to {reg6}.", "arena_master_will_you_bet",
   []],

  [anyone|plyr,"arena_master_will_you_bet", [], "No.", "arena_master_start_fight",[]],
  [anyone|plyr,"arena_master_will_you_bet", [(store_troop_gold,reg(0)),(ge,reg(0),10)], "I want to bet 10 denars.",
   "arena_master_bet_placed",[(assign,"$arena_bet_amount",10),(troop_remove_gold, "trp_player",10)]],
  [anyone|plyr,"arena_master_will_you_bet", [(store_troop_gold,reg(0)),(ge,reg(0),50)], "I want to bet 50 denars.",
   "arena_master_bet_placed",[(assign,"$arena_bet_amount",50),(troop_remove_gold, "trp_player",50)]],
  [anyone|plyr,"arena_master_will_you_bet", [(store_troop_gold,reg(0)),(ge,reg(0),100)], "I want to bet 100 denars.",
   "arena_master_bet_placed",[(assign,"$arena_bet_amount",100),(troop_remove_gold, "trp_player",100)]],
  [anyone,"arena_master_next_melee_watch", [], "Do you want to place a bet?", "arena_master_will_you_bet",[]],
  [anyone,"arena_master_bet_placed", [(eq,"$arena_join_or_watch",1)], "Hmm. That's good. And which team do you want to place your bet on.", "arena_master_select_team",[]],
  [anyone|plyr,"arena_master_select_team", [], "The red team. I have a feeling they will win this one.",
   "arena_master_start_fight",[(assign,"$arena_bet_team",0)]],
  [anyone|plyr,"arena_master_select_team", [], "The blue team. They will sweep the ground with the reds.",
   "arena_master_start_fight",[(assign,"$arena_bet_team",1)]],
  [anyone|plyr,"arena_master_select_team", [(ge,"$_num_teams",3)], "The green team. My money is on them this time.",
   "arena_master_start_fight",[(assign,"$arena_bet_team",2)]],
  [anyone|plyr,"arena_master_select_team", [(ge,"$_num_teams",4)], "The yellow team. They will be victorious.",
   "arena_master_start_fight",[(assign,"$arena_bet_team",3)]],
  [anyone,"arena_master_bet_placed", [], "That's good. Let me record that. If you win, you'll get {reg5} denars.", "arena_master_start_fight",
   [(store_mul,"$arena_win_amount", "$arena_bet_amount", "$_num_teams"),
    (try_begin),
      (eq, "$arena_join_or_watch", 0),
      (party_get_slot, ":player_odds", "$g_encountered_party", slot_town_player_odds),
      (val_sub, "$arena_win_amount", "$arena_bet_amount"),
      (val_mul, "$arena_win_amount", ":player_odds"),
      (val_div, "$arena_win_amount", 1000),
      (val_add, "$arena_win_amount", "$arena_bet_amount"),
    (try_end),
    (val_mul, "$arena_win_amount", 9),
    (val_div, "$arena_win_amount", 10),
    (assign, reg5, "$arena_win_amount"),
    ]],
  
  [anyone,"arena_master_start_fight", [], "Very well. The fight starts in a moment. Good luck.", "close_window",
   [
    (store_encountered_party,"$current_town"),
    (party_get_slot, ":arena_scene","$current_town",slot_town_arena),
    (modify_visitors_at_site,":arena_scene"),(reset_visitors),


    #Assemble participants
    (assign, ":slot_no", 0),
    (troop_set_slot, "trp_temp_array_a", ":slot_no", "trp_xerina"),
    (val_add, ":slot_no", 1),
    (troop_set_slot, "trp_temp_array_a", ":slot_no", "trp_dranton"),
    (val_add, ":slot_no", 1),
    (troop_set_slot, "trp_temp_array_a", ":slot_no", "trp_kradus"),
    (val_add, ":slot_no", 1),
    (try_for_range, reg(4), 0, 10),
      (lt, ":slot_no", 48),
      (troop_set_slot, "trp_temp_array_a", ":slot_no", "trp_regular_fighter"),
      (val_add, ":slot_no", 1),
    (try_end),
    (try_for_range, reg(4), 0, 10),
      (lt, ":slot_no", 48),
      (troop_set_slot, "trp_temp_array_a", ":slot_no", "trp_veteran_fighter"),
      (val_add, ":slot_no", 1),
    (try_end),
    (try_for_range, reg(4), 0, 10),
      (lt, ":slot_no", 48),
      (troop_set_slot, "trp_temp_array_a", ":slot_no", "trp_champion_fighter"),
      (val_add, ":slot_no", 1),
    (try_end),
    (try_for_range, reg(4), 0, 5),
      (lt, ":slot_no", 48),
      (troop_set_slot, "trp_temp_array_a", ":slot_no", "trp_charger_fighter"),
      (val_add, ":slot_no", 1),
    (try_end),
    (try_for_range, reg(4), 0, 10),
      (lt, ":slot_no", 48),
      (troop_set_slot, "trp_temp_array_a", ":slot_no", "trp_charger_elite_fighter"),
      (val_add, ":slot_no", 1),
    (try_end),
    (try_for_range, reg(4), 0, 10),
      (lt, ":slot_no", 48),
      (troop_set_slot, "trp_temp_array_a", ":slot_no", "trp_mercenary"),
      (val_add, ":slot_no", 1),
    (try_end),
    (assign, "$pin_troop", "trp_temp_array_a"),
    (call_script, "script_shuffle_troop_slots", 0, 48),

    
    (try_for_range, reg(12), 0, 48),
      (troop_set_slot, "trp_temp_array_b", reg(12),reg(12)), #Initialize temp_array_b such that temp_array_b[i] = i
    (try_end),


    (store_random_in_range, "$arena_player_team", 0, "$_num_teams"),
    (try_for_range, ":i_team", 0, "$_num_teams"), # repeat for num_teams; reg(55) = cur_team
      (assign, ":team_slots_start", ":i_team"),
      (val_mul, ":team_slots_start", 8),
      (assign, ":team_slots_end", ":team_slots_start"),
      (val_add, ":team_slots_end", 8),
      (assign, "$pin_troop", "trp_temp_array_b"),
      (call_script, "script_shuffle_troop_slots", ":team_slots_start", ":team_slots_end"),
      (assign, ":cur_slot", ":team_slots_start"),
      (try_for_range, reg(6), 0, "$_team_size"), # repeat for team_size; 
        (troop_get_slot, ":cur_slot_troop", "trp_temp_array_a", ":cur_slot"),
        (try_begin), #place player
          (eq,"$arena_join_or_watch",0),
          (eq, ":i_team", "$arena_player_team"),
          (eq, reg(6), 0),
          (assign, ":cur_slot_troop", "trp_player"),
        (try_end),
        (troop_get_slot, ":cur_entry_no", "trp_temp_array_b", ":cur_slot"),
        (set_visitor,":cur_entry_no",":cur_slot_troop"),
        (val_add, ":cur_slot", 1),
      (try_end),
    (try_end),

    (try_begin),
      (eq,"$arena_join_or_watch",1),
      (set_visitor,32,"trp_player"),
    (try_end),
    (assign,"$arena_fight_won",0),
    (assign,"$arena_winner_team",-1),
    (assign,"$waiting_for_arena_fight_result",1),
    (party_get_slot, reg(6),"$current_town",slot_town_arena_melee_cur_tier),
    (val_add,reg(6),1),
    (val_mod,reg(6),3),
    (party_set_slot, "$current_town",slot_town_arena_melee_cur_tier, reg(6)),
#    (set_jump_mission,"mt_arena_melee_fight"),
    (party_get_slot, ":arena_mission_template","$current_town",slot_town_arena_template),
    (set_jump_mission,":arena_mission_template"),
    (party_get_slot, reg(7),"$current_town", slot_town_arena),
    (jump_to_scene,reg(7)),
    ]],




######################################################################################
  [trp_galeas,"start", [], "Hello {boy/girl}. If you have any prisoners, I will be happy to buy them from you.", "galeas_talk",[]],

  [trp_galeas|plyr,"galeas_talk",
   [[store_num_regular_prisoners,reg(0)],[ge,reg(0),1]],
   "Then you'd better bring your purse. I have got prisoners to sell.", "galeas_sell_prisoners",[]],
  [trp_galeas|plyr,"galeas_talk",[], "Not this time. Good-bye.", "close_window",[]],
  [trp_galeas,"galeas_sell_prisoners", [],
  "Let me see what you have...", "galeas_sell_prisoners_2",
   [[change_screen_trade_prisoners]]],
  [trp_galeas, "galeas_sell_prisoners_2", [], "You take more prisoners, bring them to me. I will pay well.", "close_window",[]],

##  [party_tpl|pt_refugees,"start", [], "We have been driven out of our homes because of this war.", "close_window",[(assign, "$g_leave_encounter",1)]],
##  [party_tpl|pt_farmers,"start", [], "We are just simple farmers.", "close_window",[(assign, "$g_leave_encounter",1)]],


# Random Quest related conversations
#  [trp_nobleman, "start", [],
#   "Who are you? What do you want? Be warned, we are fully armed and more than capable to defend ourselves. Go to your way now or you will regret it.", "nobleman_talk_1",
#   [(play_sound,"snd_encounter_nobleman")]],
#  [trp_nobleman|plyr, "nobleman_talk_1", [],
#   "I demand that you surrender to me.", "nobleman_talk_2",[]],
#  [trp_nobleman|plyr, "nobleman_talk_1", [],
#   "I am sorry sir. You may go.", "close_window",[(assign, "$g_leave_encounter",1)]],
#  [trp_nobleman, "nobleman_talk_2", [],
#   "Surrender to a puny peasant like you? Hah. Not likely.", "close_window",[[encounter_attack]]],
#
#  [trp_nobleman,"enemy_defeated", [], "Parley! I am of noble birth, and I ask for my right to surrender.", "nobleman_defeated_1",[]],
#  [trp_nobleman|plyr,"nobleman_defeated_1", [], "And I will grant you that. If you can be ransomed of course...", "nobleman_defeated_2",[]],
#  [trp_nobleman,"nobleman_defeated_2", [], "Oh, you need not worry about that. My family would pay a large ransom for me.", "nobleman_defeated_3",[]],
#  [trp_nobleman|plyr,"nobleman_defeated_3", [[str_store_troop_name,1,"$nobleman_quest_giver"]], "Hmm. {s1} will be happy about this... Then you are my prisoner.", "close_window",
#   [[assign,"$nobleman_quest_succeeded",1],[assign,"$nobleman_quest_nobleman_active",0]]],

# Prisoner Trains
  [anyone,"start", [(eq,"$g_encountered_party_type",spt_prisoner_train)],
   "What do you want?", "prisoner_train_talk",[]],

  [anyone|plyr,"prisoner_train_talk", [],
   "Set those prisoners free now!", "prisoner_train_talk_ultimatum",[]],
  [anyone,"prisoner_train_talk_ultimatum", [],
   "Or what? Are you going to attack us?", "prisoner_train_talk_ultimatum_2",[]],
  [anyone|plyr,"prisoner_train_talk_ultimatum_2", [],
   "Yes I will. Consider yourself warned!", "prisoner_train_talk_ultimatum_2a",[]],
  [anyone,"prisoner_train_talk_ultimatum_2a", [],
   "We'll see that.", "close_window",[
    (call_script, "script_make_kingdom_hostile_to_player", "$g_encountered_party_faction", -3),
    ]],

  [anyone|plyr,"prisoner_train_talk_ultimatum_2", [],
   "Attack you? Hell no! I just took pity on those poor souls.", "prisoner_train_talk_ultimatum_2b",[]],
  [anyone,"prisoner_train_talk_ultimatum_2b", [],
   "Find something else to take pity on.", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"prisoner_train_talk", [],
   "Better watch those prisoners well. They may try to run away.", "prisoner_train_smalltalk",[]],
  [anyone,"prisoner_train_smalltalk", [],
   "Don't worry. They aren't going anywhere.", "close_window",[(assign, "$g_leave_encounter",1)]],



  [anyone,"start", [(eq, "$g_encountered_party_type", spt_forager), (is_between, "$g_encountered_party_relation", -9, 1)],
   "Hold it right there. Who are you?", "soldiers_interrogation",[(play_sound,"snd_encounter_vaegirs_neutral")]],
  [anyone,"start", [(eq, "$g_encountered_party_type", spt_forager), (le, "$g_encountered_party_relation", -10)],
   "You will not survive this!", "close_window",
   [(store_relation, reg(5),"$g_encountered_party_faction"), (val_sub,reg(5),1), (set_relation,"$g_encountered_party_faction",0,reg(5)),(encounter_attack,0)]],
  [anyone,"start", [(eq, "$g_encountered_party_type", spt_forager),(ge, "$g_encountered_party_relation", 1)],
   "Our lands have been invaded. But we will drive them back.", "close_window",[(assign, "$g_leave_encounter",1),(play_sound,"snd_encounter_vaegirs_ally"),]],

  [anyone,"start", [(eq, "$g_encountered_party_type", spt_scout),(is_between, "$g_encountered_party_relation", -9, 1)],
   "Hold it right there. Who are you?", "soldiers_interrogation",[]],
  [anyone,"start", [(eq, "$g_encountered_party_type", spt_scout),(le, "$g_encountered_party_relation", -10)],
   "You deserve to die a thousand deaths!", "close_window",
   [(store_relation, reg(5),"$g_encountered_party_faction"), (val_sub,reg(5),2), (set_relation,"$g_encountered_party_faction",0,reg(5)),(encounter_attack,0)]],
  [anyone,"start", [(eq, "$g_encountered_party_type", spt_scout),(ge, "$g_encountered_party_relation", 1)],
   "Venture deep into the enemy territory and find myself a caravan to raid. That's the way I will get rich.", "close_window",[(assign, "$g_leave_encounter",1)]],

  [anyone,"start", [(this_or_next|eq, "$g_encountered_party_type", spt_patrol),(eq, "$g_encountered_party_type", spt_war_party),(is_between, "$g_encountered_party_relation", -9, 1)],
   "Hold it right there. Who are you?", "soldiers_interrogation",[]],
  [anyone,"start", [(this_or_next|eq, "$g_encountered_party_type", spt_patrol),(eq, "$g_encountered_party_type", spt_war_party),(le, "$g_encountered_party_relation", -10)],
   "You will not survive this!", "close_window",
   [(store_relation, reg(5),"$g_encountered_party_type"), (val_sub,reg(5),3), (set_relation,"$g_encountered_party_type",0,reg(5)),(encounter_attack,0)]],
  [anyone,"start", [(this_or_next|eq, "$g_encountered_party_type", spt_patrol),(eq, "$g_encountered_party_type", spt_war_party),(ge, "$g_encountered_party_relation", 1)],
   "Sooner or later, friend. Victory will belong to us.", "close_window",[(assign, "$g_leave_encounter",1)]],

#swadian parties
  [anyone|plyr,"soldiers_interrogation", [], "I am {playername}.", "soldiers_interrogation_2",[]],
  [anyone,"soldiers_interrogation_2", [], "What are you doing here?", "soldiers_interrogation_3",[]],
  [anyone|plyr,"soldiers_interrogation_3", [], "I am on my way to Zendar.", "soldiers_interrogation_4",[]],
  [anyone|plyr,"soldiers_interrogation_3", [], "I am carrying some merchandise.", "soldiers_interrogation_4",[]],
  [anyone|plyr,"soldiers_interrogation_3", [], "I am just admiring the sights.", "soldiers_interrogation_4",[]],
  [anyone,"soldiers_interrogation_4", [], "Hmm. All right. You may go now. But be careful. There is a war going on. The roads are not safe for travellers.", "close_window",[(assign, "$g_leave_encounter",1)]],
  

  

# Bandits
##  [party_tpl|pt_mountain_bandits,"start", [(eq,"$talk_context",tc_party_encounter),
##                                           (party_get_slot,":protected_until_hours", "$g_encountered_party",slot_party_ignore_player_until),
##                                           (store_current_hours,":cur_hours"),
##                                           (store_sub, ":protection_remaining",":protected_until_hours",":cur_hours"),
##                                           (ge, ":protection_remaining", 0)], "What do you want?\
## You want to pay us some more money?", "bandit_paid_talk",[]],
##  
##  [party_tpl|pt_forest_bandits,"start", [(ge,"$forest_bandits_paid",1),(eq,"$talk_context",tc_party_encounter)], "What do you want?\
## You want to pay us some more money?", "bandit_paid_talk",[]],
##  [anyone|plyr,"bandit_paid_talk", [], "Sorry to trouble you. I'll be on my way now.", "bandit_paid_talk_2a",[]],
##  [anyone,"bandit_paid_talk_2a", [], "Yeah. Stop fooling around and go make some money.\
## I want to see that purse full next time I see you.", "close_window",[(assign, "$g_leave_encounter",1)]],
##  [anyone|plyr,"bandit_paid_talk", [], "No. It's your turn to pay me this time.", "bandit_paid_talk_2b",[]],
##  [party_tpl|pt_mountain_bandits,"bandit_paid_talk_2b", [], "What nonsense are you talking about? You want trouble? You got it.", "close_window",[
##    (assign,"$mountain_bandits_paid",0),
##    (assign,reg(5),"$mountain_bandits_relation_original"),
##    (val_sub,reg(5),3),
##    (set_relation,"fac_mountain_bandits","fac_player_faction",reg(5)),
##    (encounter_attack,0),
##    ]],
##  [party_tpl|pt_forest_bandits,"bandit_paid_talk_2b", [], "What nonsense are you talking about? You want trouble? You got it.", "close_window",[
##    (assign,"$forest_bandits_paid",0),
##    (assign,reg(5),"$forest_bandits_relation_original"),
##    (val_sub,reg(5),3),
##    (set_relation,"fac_forest_bandits","fac_player_faction",reg(5)),
##    (encounter_attack,0),
##    ]],
##
##  
##  [party_tpl|pt_mountain_bandits,"start", [(eq,"$talk_context",tc_party_encounter)], "You have so much gold and we have nothing.\
## Not fair. You give us your gold now!", "bandit_talk",[(play_sound,"snd_encounter_bandits")]],
##  [party_tpl|pt_forest_bandits,"start", [(eq,"$talk_context",tc_party_encounter)], "Loitering around in this wild place may be dangerous for you {sir/madam}.\
## Why don't you give us your gold? Then you will have nothing to worry about.", "bandit_talk",[(play_sound,"snd_encounter_bandits")]],
##  [anyone|plyr,"bandit_talk", [], "I am going to give you nothing but cold steel, you scum!", "close_window",[[encounter_attack]]],
##  [anyone|plyr,"bandit_talk", [], "There's no need to fight. I am ready to pay for free passage.", "bandit_barter",[]],
##  [anyone,"bandit_barter", [], "Good. You are clever. You pay us {reg5} denars. Then you can go.", "bandit_barter_2",[
##    [assign,"$bandit_tribute",100],
##    [assign,reg(5),"$bandit_tribute"]]],
##  [anyone|plyr,"bandit_barter_2", [[store_troop_gold,reg(2)],[ge,reg(2),"$bandit_tribute"],[assign,reg(5),"$bandit_tribute"]],
##   "All right here's your {reg5} denars.", "bandit_barter_3a",[[troop_remove_gold, "trp_player","$bandit_tribute"]]],
##  [anyone|plyr,"bandit_barter_2", [],
##   "I don't have that much money with me", "bandit_barter_3b",[]],
##  [anyone,"bandit_barter_3b", [],
##   "You are one of those fools who would die rather than pay. Works for me.", "close_window",[[encounter_attack]]],
##
##
##  [party_tpl|pt_mountain_bandits,"bandit_barter_3a", [], "Heh. That wasn't difficult now was it. All right. Go now.", "close_window",[
##    (store_relation, reg(5),"fac_mountain_bandits"),
##    (assign,"$mountain_bandits_relation_original",reg(5)),
##    (set_relation,"fac_mountain_bandits", "fac_player_faction", -1),
##    (assign,"$mountain_bandits_paid",2),
##    (assign, "$g_leave_encounter",1)
##    ]],
##  [party_tpl|pt_forest_bandits,"bandit_barter_3a", [], "Heh. That wasn't difficult now was it. All right. Go now.", "close_window",[
##    (store_relation, reg(5),"fac_forest_bandits"),
##    (assign,"$forest_bandits_relation_original",reg(5)),
##    (set_relation,"fac_forest_bandits", "fac_player_faction", -1),
##    (assign,"$forest_bandits_paid",2),
##    (assign, "$g_leave_encounter",1)
##    ]],

  
#Quest dialogs
  
  [party_tpl|pt_troublesome_bandits,"start", [[store_encountered_party,reg(11)],
                                                        [eq,reg(11),"$troublesome_bandits_id"]],
   "This must be your unlucky day indeed. We are the baddest guys you coud have run into in these parts...", "troublesome_bandits_intro_1",[]],
  [anyone|plyr,"troublesome_bandits_intro_1", [],
   "Heh. For me, you are nothing more than walking money bags.\
 A merchant in {s1} offered me good money for your heads.", "troublesome_bandits_intro_2",[[str_store_party_name,1,"$troublesome_bandits_quest_giver_town"]]],
  [anyone,"troublesome_bandits_intro_2", [],
   "A bounty hunter! ... I hate bounty hunters! Kill {him/her}! Kill {him/her} now!", "close_window",[(encounter_attack)]],
 

  

  [party_tpl|pt_rescued_prisoners,"start", [(eq,"$talk_context",tc_party_encounter)], "Do you want us to follow you?", "disbanded_troop_ask",[]],
  [anyone|plyr,"disbanded_troop_ask", [], "Yes. Let us ride together.", "disbanded_troop_join",[]],
  [anyone|plyr,"disbanded_troop_ask", [], "No. Not at this time.", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone,"disbanded_troop_join", [[neg|party_can_join]], "Unfortunately. You do not have room in your party for us.", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone,"disbanded_troop_join", [], "We are at your command.", "close_window",[[party_join],(assign, "$g_leave_encounter",1)]],
   
  [party_tpl|pt_enemy,"start", [(eq,"$talk_context",tc_party_encounter)], "You will not capture me again. Not this time.", "enemy_talk_1",[]],
  [party_tpl|pt_enemy|plyr,"enemy_talk_1", [], "You don't have a chance against me. Give up.", "enemy_talk_2",[]],
  [party_tpl|pt_enemy,"enemy_talk_2", [], "I will give up when you are dead!", "close_window",[[encounter_attack]]],







  [anyone,"sell_prisoner_outlaws", [[store_troop_kind_count,0,"trp_mountain_bandit3"],[ge,reg(0),1],[assign,reg(1),reg(0)],[val_mul,reg(1),10],[val_mul,reg(2),reg(0)],[val_mul,reg(2),10]],
   "Hmmm. 10 denars for each river_pirate makes {reg1} denars for all {reg0} of them.", "sell_prisoner_outlaws",
   [[troop_add_gold, "trp_player",reg(1)],[add_xp_to_troop,reg(2)],[remove_member_from_party,"trp_mountain_bandit3"]]],
  [anyone,"sell_prisoner_outlaws", [[store_troop_kind_count,0,"trp_mountain_bandit1"],[ge,reg(0),1],[assign,reg(1),reg(0)],[val_mul,reg(1),20],[assign,reg(2),reg(0)],[val_mul,reg(2),20]],
   "Let me see. You have brought {reg0} bandits. 20 denars for each makes {reg1} denars..", "sell_prisoner_outlaws",
   [[troop_add_gold, "trp_player",reg(1)],[add_xp_to_troop,reg(2)],[remove_member_from_party,"trp_mountain_bandit1"]]],
  [anyone,"sell_prisoner_outlaws", [[store_troop_kind_count,0,"trp_robber"],[ge,reg(0),1],[assign,reg(1),reg(0)],[val_mul,reg(1),30],[assign,reg(2),reg(0)],[val_mul,reg(2),30]],
   "Well well, you have captured {reg0} brigand. Each one is worth 30 denars, that means I'll pay you a sum of {reg1}.", "sell_prisoner_outlaws",
   [[troop_add_gold, "trp_player",reg(1)],[add_xp_to_troop,reg(2)],[remove_member_from_party,"trp_robber"]]],
  [anyone,"sell_prisoner_outlaws", [], "Well, I guess that would be all.", "sell_prisoner_outlaws_finished",[]],

#native  [anyone,"member_chat", [], "How about having a little chat. It will make the journey easier.", "member_chat_2",[]],
#native  [anyone|plyr,"member_chat_2", [], "We don't have time for that now. We should make speed.", "close_window",[]],

   #SANGO NEW
  [anyone,"member_chat", [], "Your orders {sir/madam}?", "sg_member_talk",[]],
  [anyone|plyr,"sg_member_talk", [], "Tell me about yourself", "sg_view_regular_char_requested",[]],
  [anyone,"sg_view_regular_char_requested", [], "Aye {sir/madam}. Let me tell you all there is to know about me.", "member_talk_rep",[[change_screen_view_character]]],

  ##level up
   [anyone|plyr,"sg_member_talk",[(this_or_next|eq,"$g_talk_troop","trp_wei_heavy_bow_archer"),
   (this_or_next|eq,"$g_talk_troop","trp_armored_guarder"),(this_or_next|eq,"$g_talk_troop","trp_dragoon"),
   (this_or_next|eq,"$g_talk_troop","trp_wei_main_flag_holder"),(this_or_next|eq,"$g_talk_troop","trp_yuan_rong_crossbowman"),
   (this_or_next|eq,"$g_talk_troop","trp_shu_unstopped_horseman"),(this_or_next|eq,"$g_talk_troop","trp_shu_armed_horseman"),
   (this_or_next|eq,"$g_talk_troop","trp_shu_main_flag_holder"),(this_or_next|eq,"$g_talk_troop","trp_wu_five_troops_bowman"),
   (this_or_next|eq,"$g_talk_troop","trp_feather_army"),(this_or_next|eq,"$g_talk_troop","trp_wu_tiger_rider"),
   (this_or_next|eq,"$g_talk_troop","trp_wu_main_flag_holder"),(this_or_next|eq,"$g_talk_troop","trp_huang_jin_lieutenant"),
   (this_or_next|eq,"$g_talk_troop","trp_southern_man_cany_armour_solider"),(this_or_next|eq,"$g_talk_troop","trp_northern_xiong_nu_strong_horse_bowman"),
   (eq,"$g_talk_troop","trp_eastern_yue_fly_footman"),
   ],"level up","member_level_1",[]],
   
   [anyone,"member_level_1",[(try_begin),(eq,"$g_talk_troop","trp_wei_heavy_bow_archer"),(assign,"$party_level_troop","trp_wei_heavy_bow_archer_elite"),(assign,"$level_gold",500),
   (else_try),(eq,"$g_talk_troop","trp_armored_guarder"),(assign,"$party_level_troop","trp_armored_guarder_elite"),(assign,"$level_gold",350),
   (else_try),(eq,"$g_talk_troop","trp_dragoon"),(assign,"$party_level_troop","trp_dragoon_elite"),(assign,"$level_gold",500),
   (else_try),(eq,"$g_talk_troop","trp_wei_main_flag_holder"),(assign,"$party_level_troop","trp_wei_main_flag_holder_elite"),(assign,"$level_gold",300),
   (else_try),(eq,"$g_talk_troop","trp_yuan_rong_crossbowman"),(assign,"$party_level_troop","trp_yuan_rong_crossbowman_elite"),(assign,"$level_gold",500),
   (else_try),(eq,"$g_talk_troop","trp_shu_unstopped_horseman"),(assign,"$party_level_troop","trp_shu_unstopped_horseman_elite"),(assign,"$level_gold",250),
   (else_try),(eq,"$g_talk_troop","trp_shu_armed_horseman"),(assign,"$party_level_troop","trp_shu_armed_horseman_elite"),(assign,"$level_gold",350),
   (else_try),(eq,"$g_talk_troop","trp_shu_main_flag_holder"),(assign,"$party_level_troop","trp_shu_main_flag_holder_elite"),(assign,"$level_gold",250),
   (else_try),(eq,"$g_talk_troop","trp_wu_five_troops_bowman"),(assign,"$party_level_troop","trp_wu_five_troops_bowman_elite"),(assign,"$level_gold",350),
   (else_try),(eq,"$g_talk_troop","trp_feather_army"),(assign,"$party_level_troop","trp_feather_army_elite"),(assign,"$level_gold",500),
   (else_try),(eq,"$g_talk_troop","trp_wu_tiger_rider"),(assign,"$party_level_troop","trp_wu_tiger_rider_elite"),(assign,"$level_gold",250),
   (else_try),(eq,"$g_talk_troop","trp_wu_main_flag_holder"),(assign,"$party_level_troop","trp_wu_main_flag_holder_elite"),(assign,"$level_gold",250),
   (else_try),(eq,"$g_talk_troop","trp_huang_jin_lieutenant"),(assign,"$party_level_troop","trp_huang_jin_high_capitain"),(assign,"$level_gold",400),
   (else_try),(eq,"$g_talk_troop","trp_southern_man_cany_armour_solider"),(assign,"$party_level_troop","trp_southern_man_lieutenant"),(assign,"$level_gold",400),
   (else_try),(eq,"$g_talk_troop","trp_northern_xiong_nu_strong_horse_bowman"),(assign,"$party_level_troop","trp_northern_xiong_nu_lieutenant"),(assign,"$level_gold",400),
   (else_try),(eq,"$g_talk_troop","trp_eastern_yue_fly_footman"),(assign,"$party_level_troop","trp_eastern_yue_lieutenant"),(assign,"$level_gold",400),(end_try)],
   "How many?","member_level_2",[]],
   
   [anyone|plyr,"member_level_2",[
       (party_count_companions_of_type, ":cur_number", "p_main_party", "$g_talk_troop"),
       (store_troop_gold,":i_gold","trp_player"),
       (ge,":i_gold","$level_gold"),
       (ge,":cur_number",1),
       ],
    "one","close_window",[
       (party_remove_members,"p_main_party","$g_talk_troop",1),
       (party_add_members,"p_main_party","$party_level_troop",1),
       (troop_remove_gold,"trp_player","$level_gold")]],

   [anyone|plyr,"member_level_2",[
       (party_count_companions_of_type, ":cur_num", "p_main_party", "$g_talk_troop"),
       (store_troop_gold,":i_gold","trp_player"),
       (store_mul,":total_gold","$level_gold",5),
       (ge,":i_gold",":total_gold"),
       (ge,":cur_num",5),
       ],"five","close_window",[
       (party_remove_members,"p_main_party","$g_talk_troop",5),
       (party_add_members,"p_main_party","$party_level_troop",5),
       (val_mul,"$level_gold",5),
       (troop_remove_gold,"trp_player","$level_gold")]],

   [anyone|plyr,"member_level_2",[
       (party_count_companions_of_type, ":cur_num", "p_main_party", "$g_talk_troop"),
       (store_troop_gold,":i_gold","trp_player"),
       (store_mul,":total_gold","$level_gold",10),
       (ge,":i_gold",":total_gold"),
       (ge,":cur_num",10),
       ],"ten","close_window",[
       (party_remove_members,"p_main_party","$g_talk_troop",10),
       (party_add_members,"p_main_party","$party_level_troop",10),
       (val_mul,"$level_gold",10),
       (troop_remove_gold,"trp_player","$level_gold")]],

   [anyone|plyr,"member_level_2",[],"Nothing","member_talk_rep",[]],

  ##qi xi
  [anyone|plyr,"sg_member_talk", [
      (assign,":finded",0),
      (party_get_num_companion_stacks,":num_stacks","p_main_party"),
      (try_for_range,":i_stack", 1,":num_stacks"),
        (eq,":finded",0),
        (party_stack_get_troop_id,":stack_troop","p_main_party",":i_stack"),
        (eq,":stack_troop","$g_talk_troop"),
        (assign,":finded",1),
        (party_stack_get_size,":stack_size","p_main_party",":i_stack"),
        (party_stack_get_num_wounded, ":num_wounded","p_main_party",":i_stack"),
        (val_sub,":stack_size",":num_wounded"),
      (try_end),
      (ge,":stack_size",5),
      (eq,":finded",1),
      ], "Surprise attacks", "qi_xi_1",[]],

  [anyone,"qi_xi_1", [(eq,"$use_qixi",1)], "You have to change your mind?", "qi_xi_bak",[]],
  [anyone|plyr,"qi_xi_bak", [], "Yes.", "member_talk_rep",[
      (assign,"$use_qixi",0),
      (try_begin),
        (eq,"$five",2),
        (party_add_members,"p_main_party","$qi_xi_troop",5),
      (else_try),
        (eq,"$ten",2),
        (party_add_members,"p_main_party","$qi_xi_troop",10),
      (else_try),
        (eq,"$twenty",2),
        (party_add_members,"p_main_party","$qi_xi_troop",20),
      (try_end),
      ]],
  [anyone|plyr,"qi_xi_bak", [], "NO.", "member_talk_rep",[]],

  [anyone,"qi_xi_1", [], "How many", "qi_xi_2",[
      (assign,"$five",0),
      (assign,"$ten",0),
      (assign,"$twenty",0),
      (assign,":finded",0),
      (party_get_num_companion_stacks,":num_stacks","p_main_party"),
      (try_for_range,":i_stack", 1,":num_stacks"),
        (eq,":finded",0),
        (party_stack_get_troop_id,":stack_troop","p_main_party",":i_stack"),
        (eq,":stack_troop","$g_talk_troop"),
        (party_stack_get_size,":stack_size","p_main_party",":i_stack"),
        (party_stack_get_num_wounded, ":num_wounded","p_main_party",":i_stack"),
        (val_sub,":stack_size",":num_wounded"),
        (ge,":stack_size",5),
        (assign,"$five",1),
        (try_begin),
          (ge,":stack_size",10),
          (assign,"$ten",1),
        (try_end),
        (try_begin),
          (ge,":stack_size",20),
          (assign,"$twenty",1),
        (try_end),
        (assign,":finded",1),
      (try_end),
      ]],

  [anyone|plyr,"qi_xi_2", [(eq,"$five",1)], "Five", "qi_xi_3",[
#     (try_begin),
#       (neq,"$qi_xi_troop","$g_talk_troop"),
#       (assign,"$qi_xi_num",0),
#     (try_end),
#     (assign,"$qi_xi_troop",-1),
#     (assign,"$qi_xi_num",0),
     (assign,"$use_qixi",1),
     (assign,"$qi_xi_troop","$g_talk_troop"),
     (assign, "$wounded", 0),
     (party_remove_members,"p_main_party","$g_talk_troop",5),
     (assign,"$qi_xi_num",5),
     (assign,"$amount_to_use","$qi_xi_num"),
     (assign,"$five",2),
#     (assign,"$qi_xi_troop","$g_talk_troop"),
#     (val_add,"$qi_xi_num",5),
      ]],
  [anyone|plyr,"qi_xi_2", [(ge,"$qixi",1),(eq,"$ten",1)], "Ten", "qi_xi_3",[
     (assign,"$use_qixi",1),
     (assign,"$qi_xi_troop","$g_talk_troop"),
     (assign, "$wounded", 0),
     (party_remove_members,"p_main_party","$g_talk_troop",10),
     (assign,"$qi_xi_num",10),
     (assign,"$amount_to_use","$qi_xi_num"),
     (assign,"$ten",2),
      ]],

  [anyone|plyr,"qi_xi_2", [(ge,"$qixi",2),(eq,"$twenty",1)], "Twenty", "qi_xi_3",[
     (assign,"$use_qixi",1),
     (assign,"$qi_xi_troop","$g_talk_troop"),
     (assign, "$wounded", 0),
     (party_remove_members,"p_main_party","$g_talk_troop",20),
     (assign,"$qi_xi_num",20),
     (assign,"$amount_to_use","$qi_xi_num"),
     (assign,"$twenty",2),
      ]],

  [anyone|plyr,"qi_xi_2", [], "Nothing", "member_chat",[]],

  [anyone,"qi_xi_3", [], "Yes sir", "member_talk_rep",[]],

  [anyone,"member_talk_rep", [], "Anything else?", "sg_member_talk",[]],

  [anyone|plyr,"sg_member_talk", [], "Nothing. Keep moving.", "close_window",[]],
##SG end

  [anyone|plyr,"prisoner_chat", [], "Do not try running away or trying something stupid. I will be watching you.", "prisoner_chat_2",[]],
  [anyone,"prisoner_chat_2", [], "No, I swear I won't.", "close_window",[]],


  [anyone,"start", [(is_between,"$g_talk_troop",weapon_merchants_begin,weapon_merchants_end)], "Hello. What can I do for you?", "town_merchant_talk",[]],
  [anyone,"start", [(is_between,"$g_talk_troop",armor_merchants_begin,armor_merchants_end)], "Hello. What can I do for you?", "town_merchant_talk",[]],
  [anyone,"start", [(is_between,"$g_talk_troop",horse_merchants_begin,horse_merchants_end)], "Hello. What can I do for you?", "town_merchant_talk",[]],
  [anyone|plyr,"town_merchant_talk", [], "I want to buy a few things. Show me your wares.", "trade_requested",[]],
  [anyone,"trade_requested", [], "Ah, yes {sir/madam}. Please have a look at my fine selection of items.", "merchant_trade",[[change_screen_trade]]],
  [anyone,"merchant_trade", [], "Anything else?", "town_merchant_talk",[]],
  [anyone|plyr,"town_merchant_talk", [], "Tell me. What are people talking about these days?", "merchant_gossip",[]],
  [anyone,"merchant_gossip", [], "Well, nothing new lately. Prices, weather, the war, the same old things.", "town_merchant_talk",[]],
  [anyone|plyr,"town_merchant_talk", [], "Good-bye.", "close_window",[]],




  [anyone,"start", [(eq, "$talk_context", 0),
                    (is_between,"$g_talk_troop",town_walkers_begin, town_walkers_end),
                    (eq, "$sneaked_into_town",1),
                     ], "Stay away beggar!", "close_window",[]],
  [anyone,"start", [(eq, "$talk_context", 0),
                    (is_between,"$g_talk_troop",town_walkers_begin, town_walkers_end),
                     ], "Good day {sir/madam}.", "close_window",[]],

  [anyone,"start", [(eq, "$talk_context", 0),
                    (is_between,"$g_talk_troop",regular_troops_begin, regular_troops_end),
                    (eq,"$g_encountered_party_faction","fac_player_faction"),
                     ], "Yes {sir/madam}?", "player_castle_guard_talk",[]],
  [anyone|plyr,"player_castle_guard_talk", [], "How goes the watch, soldier?", "player_castle_guard_talk_2",[]],
  [anyone,"player_castle_guard_talk_2", [], "All quite {sir/madam}. Nothing to report.", "player_castle_guard_talk_3",[]],
  [anyone|plyr,"player_castle_guard_talk_3", [], "Good. Keep your eyes open.", "close_window",[]],

  [anyone,"start", [(eq, "$talk_context", 0),
                    (is_between,"$g_talk_troop",regular_troops_begin, regular_troops_end),
                    (is_between,"$g_encountered_party_faction",kingdoms_begin, kingdoms_end),
                     ], "Mind your manners within the city walls and we'll have no trouble", "close_window",[]],


  [anyone,"enemy_defeated", [], "Arggh! I hate this.", "close_window",[]],

  [anyone,"party_relieved", [], "Thank you for helping us against those bastards.", "close_window",[]],

##  [anyone,"start", [(eq,"$talk_context", tc_party_encounter),(store_encountered_party, reg(5)),(party_get_template_id,reg(7),reg(5)),(eq,reg(7),"pt_sea_raiders")],
##   "I will drink from your skull!", "battle_reason_stated",[(play_sound,"snd_encounter_sea_raiders")]],
  














# sango 894 dialogs 2
	#npc_give_task
	[anyone,"npc_give_task",[],
		"Let me think for a minute.","lord_tell_mission",
		[
			(call_script, "script_get_random_quest", "$g_talk_troop"),
			(assign, "$random_quest_no", reg0),
		]
	],



# rewrite from 901	
  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_deliver_message")],
   "I need to send a letter to {s13} who should be currently at {s4}.\
 If you will be heading towards there, would you deliver it to him?\
 The letter needs to be in his hands in 30 days.", "lord_mission_deliver_message",
   [
     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
     (str_store_troop_name_link,s9,"$g_talk_troop"),
     (str_store_troop_name_link,s13,":quest_target_troop"),
     (str_store_party_name_link,s4,":quest_target_center"),
     (setup_quest_text,"$random_quest_no"),
     (str_store_string, s2, "@{s9} asked you to take a message to {s13}. {s13} was believed to be at {s4} when you were given this quest."),
   ]],

  [anyone|plyr,"lord_mission_deliver_message", [], "I expect to be at {s4} sometime this month. I will be happy to give your letter to {s13}.", "lord_mission_deliver_message_accepted",[]],
  [anyone|plyr,"lord_mission_deliver_message", [], "As a matter of fact, I don't think I will see {s13} anytime soon. You'd better send it with someone else.", "lord_mission_deliver_message_rejected",[]],
  [anyone|plyr,"lord_mission_deliver_message", [], "I am not an errand boy sir. Hire yourself a courrier to take your letter.", "lord_mission_deliver_message_rejected_rudely",[]],

  [anyone,"lord_mission_deliver_message_accepted", [], "That's kind of you {playername}. Here's the letter.\
 And here's a little something to help with your travel expenses. Give my regards to {s13} when you see him.", "close_window",
   [(call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    (troop_add_gold, "trp_player",30),
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",1),
    (assign, "$g_leave_encounter",1),
   ]],

  [anyone,"lord_mission_deliver_message_rejected", [], "Ah, all right then. Well, I am sure I will find someone else.", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],
  
  [anyone,"lord_mission_deliver_message_rejected_rudely", [], "I had merely asked for a small favor {playername}. I didn't know you would take offence.", "lord_mission_deliver_message_rejected_rudely_2",[]],
    
  [anyone|plyr,"lord_mission_deliver_message_rejected_rudely_2", [], "Well, you will know better from now on.", "lord_mission_deliver_message_rejected_rudely_3",[]],
  [anyone|plyr,"lord_mission_deliver_message_rejected_rudely_2", [], "Forgive my temper, my lord. I will be happy to deliver your letter.", "lord_mission_deliver_message_accepted",[]],

  [anyone,"lord_mission_deliver_message_rejected_rudely_3", [], "All right. I will remember that.", "close_window",[
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",-4),
    (quest_set_slot, "$random_quest_no", slot_quest_dont_give_again_remaining_days, 150),
    (troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1),    
    (assign, "$g_leave_encounter",1),
      ]],

#  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_deliver_message_to_enemy_lord")],
#   "I need to deliver a message to {s13} {playername}. I think he is currently at {s4}.\
# If you are going towards there, would you deliver my letter to him? The letter needs to reach him in 40 days.", "lord_mission_deliver_message",
#   [
#     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
#     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
#     (str_store_troop_name_link,s9,"$g_talk_troop"),
#     (str_store_troop_name_link,s13,":quest_target_troop"),
#     (str_store_party_name_link,s4,":quest_target_center"),
#     (store_troop_faction, ":target_faction", ":quest_target_troop"),
#     (str_store_faction_name_link,s15,":target_faction"),
#     (setup_quest_text,"$random_quest_no"),
#     (str_store_string, s2, "@{s9} asked you to take a message to {s13} from {s15}. {s13} was believed to be at {s4} when you were given this quest."),
#   ]],


# Deal with bandits
#  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_deal_with_bandits_at_lords_village")],
#   "A group of bandits have taken refuge in my village of {s1}.\
# They are plundering nearby farms, and getting rich and fat stealing my taxes and feasting on my cattle.\
# I wish I could go there and crush them, but I have my hands full at the moment, so I can't do anything about it.", "lord_mission_deal_with_bandits_told",
#   [
#     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
#     (str_store_party_name_link,s15,":quest_target_center"),
#     (str_store_troop_name_link,s13,"$g_talk_troop"),
#     (setup_quest_text,"$random_quest_no"),
#     (str_store_string, s2, "@{s13} asked you to deal with the bandits who took refuge in his village of {s15} and then report back to him."),
#   ]],
#
#  [anyone|plyr,"lord_mission_deal_with_bandits_told", [],
#   "Don't worry. I can go to {s1} and deal with the scum for you.", "lord_mission_deal_with_bandits_accepted",[]],
#  [anyone|plyr,"lord_mission_deal_with_bandits_told", [], "You need to find help elsewhere. I am too busy myself.", "lord_mission_deal_with_bandits_rejected",[]],
#
#  [anyone,"lord_mission_deal_with_bandits_accepted", [], "Will you do that?\
# Well, I am grateful to you. Here is some money for the expenses of your campaign.\
# Go and make an example of those bastards.", "close_window",
#   [(call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
#    (troop_add_gold, "trp_player", 200),
#    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",3),
#    (assign, "$g_leave_encounter",1),
#   ]],
#
#  [anyone,"lord_mission_deal_with_bandits_rejected", [], "Yes, of course. Well, good luck to you then.", "lord_pretalk",
#   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],

# Raise troops
  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_raise_troops")], "I was inspecting my soldiers the other day,\
 and there are men out there who don't know which end of the sword is meant for business.\
 Fat lazy bastards. God knows how I am going to win a battle with this rabble.\
 You are a warrior of renown {playername}, will you train some troops for me?\
 I would be grateful to you.", "lord_tell_mission_raise_troops",[]],

  [anyone|plyr,"lord_tell_mission_raise_troops", [], "How many men do you need?", "lord_tell_mission_raise_troops_2",[]],

  [anyone,"lord_tell_mission_raise_troops_2", [], "If you can raise {reg1} {s14} and bring them to me, that will probably be enough.", "lord_mission_raise_troops_told",
   [
     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
     (quest_get_slot, reg1, "$random_quest_no", slot_quest_target_amount),
     (str_store_troop_name_link,s9,"$g_talk_troop"),
     (str_store_troop_name_plural,s14,":quest_target_troop"),
     (setup_quest_text,"$random_quest_no"),
     (str_store_string, s2, "@{s9} asked you to raise {reg1} {s14} and bring them to him."),
   ]],

  [anyone|plyr,"lord_mission_raise_troops_told", [(quest_get_slot, reg1, "$random_quest_no", slot_quest_target_amount)],
   "Of course, sir. Give me {reg1} untrained recruits and I'll train them as {s14} for you.", "lord_mission_raise_troops_accepted",[]],
  [anyone|plyr,"lord_mission_raise_troops_told", [], "I am too busy these days to train anyone.", "lord_mission_raise_troops_rejected",[]],

  [anyone,"lord_mission_raise_troops_accepted", [], "That will be excellent {playername}.\
 I will tell my sergeants to select the recruits and give them to your command.\
 And here, let me give you some money to help with their expenses.\
 Thank you for your help.", "close_window",
   [(call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    (troop_add_gold, "trp_player",100),
    (quest_get_slot, ":recruit_troop", "$random_quest_no", slot_quest_object_troop),
    (quest_get_slot, ":num_recruits", "$random_quest_no", slot_quest_target_amount),
    (party_add_members, "p_main_party", ":recruit_troop", ":num_recruits"),
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",2),
    (assign, "$g_leave_encounter",1),
   ]],

  [anyone,"lord_mission_raise_troops_rejected", [], "Oh, of course. I had expected that much. Well, good luck to you then.", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],
  

#   [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_kill_local_merchant")],
#   "I owe some money to one of the merchants here in {s3}. I have no intention of paying it back of course,\
# but the wretched man is making such a fuss about it. He threatens to write a letter of complaint to all the trade guilds and bankers and ruin my reputation.\
# Anyway that fool must be taught his place. I need someone to silence him. For good.", "lord_mission_told_kill_local_merchant",
#   [
#       (str_store_troop_name_link,s9,"$g_talk_troop"),
#       (str_store_party_name_link,s3,"$current_town"),
#       (setup_quest_text,"$random_quest_no"),
#       (str_store_string, s2, "@{s9} asked you to assasinate a local merchant at {s3}."),
#   ]],
  
#  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_lend_companion")],
# "I don't have a job for you right now, but your companion {s3} is a skilled {reg3?lass:fellow}\
# and I need someone with {reg3?her:his} talents. Will you lend {reg3?her:him} to me for a while?", "lord_tell_mission_lend_companion",
#   [
#       (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
#       (quest_get_slot, ":quest_target_amount", "$random_quest_no", slot_quest_target_amount),
#       (val_add, ":quest_target_amount", 1),
#       (assign, reg1, ":quest_target_amount"),
#       (str_store_troop_name_link,s9,"$g_talk_troop"),
#       (str_store_troop_name,s3,":quest_target_troop"),
#       (setup_quest_text,"$random_quest_no"),
#       (troop_get_type, reg3, ":quest_target_troop"),
#       (str_store_string, s2, "@{s9} asked you to lend your companion {s3} to him for a week."),
#    ]],
#  [anyone|plyr,"lord_tell_mission_lend_companion", [],
# "How long will you be needing {reg3?her:him}?", "lord_tell_mission_lend_companion_2", []],
#  [anyone,"lord_tell_mission_lend_companion_2", [],
# "Just a few days, one week at most.", "lord_mission_lend_companion_told", []],
#
#  [anyone|plyr,"lord_mission_lend_companion_told",
#   [(quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),(str_store_troop_name,s3,":quest_target_troop"),],
#   "Then I will leave {s3} with you for one week.", "lord_tell_mission_lend_companion_accepted", []],
#  [anyone|plyr,"lord_mission_lend_companion_told", [(quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
#                                                    (str_store_troop_name,s3,":quest_target_troop"),],
#   "I am sorry, but I can not do without {s3} for a whole week.", "lord_tell_mission_lend_companion_rejected", []],
#
#  [anyone,"lord_tell_mission_lend_companion_accepted", [],
#   "You made me very happy by accepting this {playername}. Don't worry. You will have your companion back in no time.", "close_window",
#   [(call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
#    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",3),
#    (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
#    (party_remove_members, "p_main_party", ":quest_target_troop", 1),
#    (assign, "$g_leave_encounter",1),
#   ]],
#
#  [anyone,"lord_tell_mission_lend_companion_rejected", [],
#   "Oh, of course {playername}. I should have guessed that.", "lord_pretalk",
#   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],
  

  [anyone,"lord_tell_mission", [], "No {playername}. I do not need your services at this time.", "lord_pretalk",[]],


#  [anyone|plyr,"lord_mission_told", [], "As you wish sir. You can count on me.", "lord_mission_accepted",[]],
#  [anyone|plyr,"lord_mission_told", [], "I'm afraid I can't carry out this mission right now, sir.", "lord_mission_rejected",[]],

#  [anyone,"lord_mission_accepted", [], "Excellent. Do this {playername}. I really have high hopes for you.", "close_window",
#   [(assign, "$g_leave_encounter",1),
#    (try_begin),
#      (eq, "$random_quest_no", "qst_deliver_message_to_enemy_lord"),
#      (troop_add_gold, "trp_player",10),
#    (try_end),
#    (call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
#    (try_begin),
#      (eq, "$random_quest_no", "qst_lend_surgeon"),
#      (assign, "$g_leave_town_outside", 1),
#      (assign,"$auto_enter_town","$g_encountered_party"),
#      (store_current_hours, "$quest_given_time"),
#      (rest_for_hours, 4),
#      (assign, "$lord_requested_to_talk_to", "$g_talk_troop"),
#    (try_end),
#    ]],
#  [anyone,"lord_mission_rejected", [], "Is that so? Perhaps you are not up for the task anyway...", "close_window",
#   [(assign, "$g_leave_encounter",1),
#    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -1),
#    (troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1),
#    ]],
# end rewrite from 901
	
# end sango 894 dialogs 2

#sango
  [trp_wangxiaohu,"start",[(eq,"$marnid_introduced",0),
    (assign, reg3, "trp_wangxiaohu"),
    (troop_set_slot,reg3,slot_upgrade_armor,1),
    (troop_set_slot,reg3,slot_upgrade_melee,melee_upgrade_one_handed),
    (troop_set_slot,reg3,slot_upgrade_horse,1),
    (troop_set_slot,reg3,slot_upgrade_ranged,0),
    (store_random,reg1,10000),
    (troop_set_slot,reg3,slot_random_hash,reg1),
  ],"Hello, you are new to the town aren't you. Would you be so kind to have a cup of wine with a fellow traveller?\
 I am here to waste my last five denars and I'd rather have someone help me with that.", "marnid_introduce_1",[[assign,"$marnid_introduced",1]]],
  [trp_wangxiaohu|plyr,"marnid_introduce_1",[],"Your last five denars? It seems that luck has not been at your side lately.", "marnid_introduce_2",[]],
  [trp_wangxiaohu,"marnid_introduce_2",[],"Luck? You know it comes and it goes.\
 Three months ago, I left Geroia with a caravan of goods. I was hoping to sell it all in Harlaushia and make a hefty sum.\
 But, what do you know... we were ambushed by a party of Khergit raiders who rode away with most of the horses and goods.\
 And two weeks later, my own caravan guards ran away with the rest of what I had.","marnid_introduce_3",[]],
  [trp_wangxiaohu|plyr,"marnid_introduce_3",[],"My sympathies friend. I hope your luck turns back soon.", "marnid_introduce_4",[]],
  [trp_wangxiaohu,"marnid_introduce_4",[],"Thanks... Anyway, my name is Marnid Rhaleis.", "marnid_introduce_5",[]],
  [trp_wangxiaohu|plyr,"marnid_introduce_5",[],"{playername}. What are you planning to do now?", "marnid_introduce_6",[]],
  [trp_wangxiaohu,"marnid_introduce_6",[],"Eh. I have no money left, no friends or relatives to ask for help.\
 The only way left for me is to enlist as a soldier and seek my fortune in war.", "marnid_introduce_7",[]],
  [trp_wangxiaohu|plyr,"marnid_introduce_7",[],"Do you have training in combat?", "marnid_introduce_8",[]],
  [trp_wangxiaohu,"marnid_introduce_8",[],"Not really. I guess I will have to learn it all the hard way, through battle.\
 But what worries me really is that I have no armor.\
 If I enlist now, they will surely place me among the peasant levies, and you know what that means.\
 I will be butchered in the first encounter with the enemy.\
 If only I had some serviceable armor, even a suit of padded cloth. Sigh.", "marnid_intro_talk",[]],

#  [trp_wangxiaohu,"start", [(eq,"$marnid_joined_party",1),
#                        (neg|main_party_has_troop,"trp_wangxiaohu"),
#                        (neq, "$g_encountered_party", "p_four_ways_inn"),], "Do you want me to rejoin you?", "member_wilderness_talk",[]],
#  [trp_wangxiaohu,"start", [(neg|main_party_has_troop,"trp_wangxiaohu"),(eq, "$g_encountered_party", "p_four_ways_inn")], "Do you want me to rejoin you?", "member_inn_talk",[]],
#  [trp_wangxiaohu,"member_separate_inn", [], "All right then. I'll meet you at the four ways inn. Good luck.", "close_window",
#   [(store_conversation_troop,reg(0)),(remove_member_from_party,reg(0)),(add_troop_to_site, reg(0), "scn_four_ways_inn",marnid_inn_entry), (call_script, "script_unequip_for_battle")]],

  [trp_wangxiaohu,"start", [(neg|troop_slot_eq,"$g_talk_troop", slot_troop_occupation, slto_player_companion),], "Hello {playername}.", "marnid_intro_talk",[]],
  [trp_wangxiaohu,"marnid_pre_free", [], "Yes?", "marnid_intro_talk",[]],
  [trp_wangxiaohu|plyr,"marnid_intro_talk", [], "Tell me about yourself.", "marnid_view_char_requested",[]],
  [trp_wangxiaohu,"marnid_view_char_requested", [], "You know, I am a ruined merchant. I know a thing or two about trade, a bit about riding and a few other things.", "marnid_pre_free",[[change_screen_view_character]]],
   
  [trp_wangxiaohu|plyr,"marnid_intro_talk", [(eq,"$marnid_joined_party")], "Would you fight in my service if I gave you a padded cloth?.", "marnid_leather_hauberk_1",[]],
  [trp_wangxiaohu,"marnid_leather_hauberk_1", [(eq,"$marnid_join_party_answered")], "Well... Of course, why not? For all I know, you could be as good a captain as anyone else.\
 Yes I would gladly follow you to battle if you gave me a padded cloth.", "marnid_leather_hauberk_2",[(assign,"$marnid_join_party_answered",1)]],
  [trp_wangxiaohu,"marnid_leather_hauberk_1", [], "Yes, I haven't changed my mind. I would.", "marnid_leather_hauberk_2",[]],
  [trp_wangxiaohu|plyr,"marnid_leather_hauberk_2", [(player_has_item,"itm_mianpao")], "Then, take this padded cloth I have. I want you to join me.", "marnid_leather_hauberk_3_cloth",[]],
  [trp_wangxiaohu|plyr,"marnid_leather_hauberk_2", [(store_troop_gold,"$wangxiaohu","trp_player"),(ge,"$wangxiaohu",500)], "Then, take this padded leather I have. I want you to join me.", "marnid_leather_hauberk_3_leather",[]],
  [trp_wangxiaohu|plyr,"marnid_leather_hauberk_2", [], "Hmm. Let me think about this then.", "close_window",[]],
  [trp_wangxiaohu,"marnid_leather_hauberk_3_cloth", [(neg|hero_can_join,0)], "I would like to, friend. But I am afraid you don't have room for me in your party. Once you make room, let me know. I'm eager to leave this place.", "close_window",[]],
  [trp_wangxiaohu,"marnid_leather_hauberk_3_cloth", [], "Well, look at this. I feel that my luck is starting to turn back after all. I am at your service, friend. Let us hit the road and discover what adventures await us.", "close_window",[
	(troop_remove_item,0,"itm_mianpao"),(troop_add_item,"trp_wangxiaohu","itm_mianpao"),
	(troop_join,"trp_wangxiaohu"),(remove_troop_from_site,"trp_wangxiaohu"),(assign,"$marnid_joined_party",1)]],

  [trp_wangxiaohu,"marnid_leather_hauberk_3_leather", [(neg|hero_can_join,0)], "I would like to, friend. But I am afraid you don't have room for me in your party. Once you make room, let me know. I'm eager to leave this place.", "close_window",[]],
  [trp_wangxiaohu,"marnid_leather_hauberk_3_leather", [], "Well, look at this. I feel that my luck is starting to turn back after all. I am at your service, friend. Let us hit the road and discover what adventures await us.", "close_window",[
	(troop_remove_gold,0,500),
	(call_script, "script_recruit_troop_as_companion", "$g_talk_troop"),(remove_troop_from_site,"trp_wangxiaohu"),
	#(troop_join,"trp_wangxiaohu"),(remove_troop_from_site,"trp_wangxiaohu"),(assign,"$marnid_joined_party",1)
	]],

  [trp_wangxiaohu|plyr,"marnid_intro_talk", [], "I must leave now. Good-bye", "close_window",[]],

[trp_shahongbing,"start",[(neg|troop_slot_eq,"$g_talk_troop", slot_troop_occupation, slto_player_companion),],"ta zhe qing ying de wu bu pian pian qi wu!","sha_intro",[]],
[trp_shahongbing|plyr,"sha_intro",[],"zhen shi mei li de wu dao a!","close_window",[]],
[trp_shahongbing|plyr,"sha_intro",[(ge,"$quest_prestige",30),(eq,"$shahongbing_joined_party",0)],"ke xi ru ci mei miao de wu zi que zhi neng che fu zai zhe me yi ge xiao di fang\
wu fa rang geng duo de shi ren xin shang dao.","sha_intro_1" ,[]],
[trp_shahongbing,"sha_intro_1",[],"xian sheng suo yan shen shi,qing jiao xian sheng da ming.","sha_intro_2",[]],
[trp_shahongbing|plyr,"sha_intro_2",[],"zai xia shi {playername},qing jiao xiao jie fang ming.","sha_intro_3",[]],
[trp_shahongbing,"sha_intro_3",[],"wo jiao sha hong bing ,ting xian sheng yi fan hua,shen you gan chu,qi shi wo zao jiu xiang chu qu\
jian jian shi mian le,mo lian zi ji de wu ji,xian sheng ke fou dai wo yi qi chu.","sha_intro_4",[]],
[trp_shahongbing|plyr,"sha_intro_4",[],"qiu zhi bu de.","close_window",[
(call_script, "script_recruit_troop_as_companion", "$g_talk_troop"),(remove_troop_from_site,"trp_shahongbing"),
 #(troop_join,"trp_shahongbing"),(remove_troop_from_site,"trp_shahongbing"),(assign,"$shahongbing_joined_party",1)
 ]],
# [trp_shahongbing,"start", [(eq,"$shahongbing_joined_party",1),
#                        (neg|main_party_has_troop,"trp_shahongbing"),
#                        (neq, "$g_encountered_party", "p_four_ways_inn"),], "Do you want me to rejoin you?", "member_wilderness_talk",[]],
#  [trp_shahongbing,"start", [(neg|main_party_has_troop,"trp_shahongbing"),(eq, "$g_encountered_party", "p_four_ways_inn")], "Do you want me to rejoin you?", "member_inn_talk",[]],
#  [trp_shahongbing,"member_separate_inn", [], "All right then. I'll meet you at the four ways inn. Good luck.", "close_window",
#  [(store_conversation_troop,reg(0)),(remove_member_from_party,reg(0)),(add_troop_to_site, reg(0), "scn_four_ways_inn",borcha_inn_entry), (call_script, "script_unequip_for_battle")]],
  [trp_shahongbing,"sha_intro_4", [(neg|hero_can_join,0)], "I would like to, friend. But I am afraid you don't have room for me in your party. Once you make room, let me know. I'm eager to leave this place.", "close_window",[]],



#sango end

#sango govener
 [anyone ,"start", [(store_conversation_troop, reg5),(ge,reg5,governers_begin),(lt,reg5,governers_end)],
   "qing wen ge xia jin ri qian lai, suo wei he shi a", "governer_start",
   [
       (store_encountered_party, reg5),
       (store_faction_of_party,"$governer_faction",reg5),
	   (store_relation,"$governer_relation","$governer_faction","fac_player_faction"),
    ]],
	
 [anyone,"governer_start",[(eq,"$g_encountered_party_faction","$players_kingdom")],"TODO:you are friend","governer_pretalk_ally",[]],
 [anyone,"governer_start",[],"TODO:please talk to our lord","close_window",[]],

[anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",10],[lt,"$faction_rank",1],(eq,"$wuguan",1)],
   "And I am happy to inform you that you have earned a promotion. From now on, you rank as a regular of the army. Congratulations. You will also be receiving an increase of your wages, to {reg0} denars per week.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",50],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",1]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",50],[lt,"$faction_rank",2],(eq,"$wuguan",1)],
   "Your deeds do not go unnoticed, {playername}. From now on, you rank as a veteran of the army, with a wage of {reg0} denars. Congratulations.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",100],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",2],(eq,"$wuguan",1)]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",100],[lt,"$faction_rank",3],(eq,"$wuguan",1)],
   "My scouts have brought tales of your cunning and valour, {playername}. From now on you rank as a sergeant of the army. And your wages will amount to {reg0} denars per week. You've earned it.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",180],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",3]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",200],[lt,"$faction_rank",4],(eq,"$wuguan",1)],
   "The men speak highly of you, {playername}. From now on you rank as a sergeant-at-arms of the army, and your wage will increase to {reg0} denars per week. You are an inspiration to the troops, and I thank you.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",300],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",4]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",400],[lt,"$faction_rank",5],(eq,"$wuguan",1)],
   "The lords have spoken of you, {playername}, and we have decided to let you enter the most elite service of our army. From now on you rank as a squire, a stepping stone into the realm of our greatest champions. Your wage will reflect this, at {reg0} denars per week. Who knows, perhaps one day your name will be engraved in history like those before you.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",450],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",5]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",800],[lt,"$faction_rank",6],(eq,"$wuguan",1)],
   "You have completed your service as a squire, {playername}, and proven your valor in battle many times. Now, bow before me to receive this well deserved honor you have earned. {playername}! In recognition of your services to our kingdom, I dub thee knight. Carry your title with honour and humility. Now rise {sir/lady} {playername}, and go give our enemies hell!","governer_pretalk_ally",
   [[assign,"$weekly_wage",660],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",6]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",1500],[lt,"$faction_rank",7],(eq,"$wuguan",1)],
   "You impress even our veteran knights, {playername}. Your deeds speak of our cause, and your words are taken to heart by the troops. Please accept the position of a knight-at-arms, with a weekly wage of {reg0} denars.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",900],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",7]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",2500],[lt,"$faction_rank",8],(eq,"$wuguan",1)],
   "Even our knights are humbled by your victories, {playername}. They shout your name in song and chant as they march, and the bards are competing to see who can concoct the most clever rhyme. You are promoted to sergeant-knight, with a wage of {reg0} denars per week.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",1200],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",8]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",4000],[lt,"$faction_rank",9],(eq,"$wuguan",1)],
   "You are on a path that few can achieve, and even the lords nod and smile when they hear your name. True greatness is rarely reached, but you have shown that one can rise from nothing and wretch victory from the enemy again and again. You are now a sergeant-knight-at-arms, with your wage increased to {reg0}. Do us proud, {playername}, we will never grow tired of your tales of victory.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",1500],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",9]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",6000],[lt,"$faction_rank",10],(eq,"$wuguan",1)],
   "I must admit I am a little awed at your presence. You are a becoming a legend, {playername}. The enemy wets themselves at the mere mention of your name, and accepts their fate when you enter the battlefield. Please accept the title of master-knight, with wages of {reg0}. Even breath you draw is one closer to victory. We're depending on you, {playername}.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",2000],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",10]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",9000],[lt,"$faction_rank",11],(eq,"$wuguan",1)],
   "Ah, {playername} the Great. Or is it {playername} the Invincible? Which title do you prefer? You can choose from any the bards have thought up, I suppose. That is a right few can claim. You are our greatest champion, {playername}. When the history of this war is written, a hundred years from now, it is your name that they will remember above all else.\
You are the first grandmaster-knight. The meager {reg0} denars per week we offer hardly seems fitting, I know, but please accept this humble offering. I don't often use the word hero, but I permit myself to do so now. You are a hero to all that fly our banners and a living testament to the victory we march towards. Go forth, hero {playername}, and take victory for our people.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",3000],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",11]]],
  #
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",10],[lt,"$faction_rank",1],(eq,"$wenguan",1)],
   "ni bei sheng wei le zhu bo.zhou xin 50.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",50],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",1]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",50],[lt,"$faction_rank",2],(eq,"$wenguan",1)],
   "ni de jin bu hen da,wo jue ding ti ba ni wei chang shi.zhou xin shi 100.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",100],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",2],(eq,"$wuguan",1)]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",100],[lt,"$faction_rank",3],(eq,"$wenguan",1)],
   "wo hen gao xing kan dao ni  zhe yang de ren cai wei wo men xiao li,ni bei sheng wei le shi lang,zhou xin shi 180. ", "governer_pretalk_ally",
   [[assign,"$weekly_wage",180],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",3]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",200],[lt,"$faction_rank",4],(eq,"$wenguan",1)],
   "ni de zuo wei yin qi le zhong cheng men de zhu yi ,wo men jue ding ti ba ni wei pu shen yi zhi,xin shui 300.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",300],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",4]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",400],[lt,"$faction_rank",5],(eq,"$wenguan",1)],
   "bai xing men zhi yao ting dao ni de ming zi ,dou hui su qi da mu zhi,wo hen gao xing de tong zhi ni,ni cheng wei le tai zhong da fu,zhou xin 450.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",450],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",5]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",600],[lt,"$faction_rank",6],(eq,"$wenguan",1)],
   "quan guo shang xia mei you bu zhi dao ni zhe ge ming zi de,ni xian zai xiao you ming qi le,ni pei de shang zhong shu ling zhe ge zhi wei ,zhou xin ye sheng dao le 660.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",660],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",6]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",1000],[lt,"$faction_rank",7],(eq,"$wenguan",1)],
   "wo men de tan zi gao su wo,di guo yi jing zai zhu yi ni le,ni de neng li shi ni zu yi sheng ren tai chang yi zhi,ni jiang huo de 900 zhou xin.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",900],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",7]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",2000],[lt,"$faction_rank",8],(eq,"$wenguan",1)],
   "bu zhi yi ge ren xiang chao ting yao qiu,ba ni diao dao ta men na li,yin wei ni suo dao zhi chu,ren min an ning,jing ji fa da,nong ye chang sheng,mei shen me shuo de ,wo men bi xu shou yu ni ting wei yi zhi.zhou xin shi 1500.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",1200],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",8]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",3500],[lt,"$faction_rank",9],(eq,"$wenguan",1)],
   "di guo ba nin zuo wei le ta men zhong dian wa jiao de dui xiang,nin de neng li lian di fang dou chui xian san chi,qing jie shou zhi jin wu yi zhi,feng shang 1500 de zhou xin.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",1500],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",9]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",5000],[lt,"$faction_rank",10],(eq,"$wenguan",1)],
   "nin de neng li,lian di yi jun shi zhu ge kong ming dou gan bai xia feng,nin jiang cheng wei xin de si kong,zhou xin shi 2000.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",2000],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",10]]],
  [anyone,"governer_pretalk_ally", [[ge,"$quest_prestige",7000],[lt,"$faction_rank",11],(eq,"$wenguan",1)],
   "gu jin wang lai,kong pa hen nan zai you ren chao yue nin de neng li,hou shi bi jiang liu chuan :de {playername} zhe ke an tian xia.ni cheng wei le yi ren zhi xia wan ren zhi shang de cheng xiang,ji 3000 gao xin.", "governer_pretalk_ally",
   [[assign,"$weekly_wage",3000],[assign,reg(0),"$weekly_wage"],[assign,"$faction_rank",11]]],

     [anyone,"governer_pretalk_ally", [[eq,"$players_kingdom","fac_kingdom_caowei"]],
   "Yes?", "governer_talk",[
     [assign,"$nobleman_party_template","pt_shu_nobleman"],
     ]],
  [anyone,"governer_pretalk_ally", [[eq,"$players_kingdom","fac_kingdom_shuhan"]],
   "Yes?", "governer_talk",[
     [assign,"$nobleman_party_template","pt_wu_nobleman"],
     ]],
     [anyone,"governer_pretalk_ally", [[eq,"$players_kingdom","fac_kingdom_wu"]],
   "Yes?", "governer_talk",[
     [assign,"$nobleman_party_template","pt_wei_nobleman"],
     ]],
#quest
[anyone|plyr,"governer_talk",[[check_quest_active,"qst_deliver_message",1],
                                     [store_encountered_party,reg5],
                                     [eq,reg5,"$message_quest_town"],
                                     [str_store_troop_name,1,"$message_quest_giver"],
                                     [str_store_party_name,2,"$message_quest_giver_town"]],
   "I have brought you a message from {s1} of {s2} milord.", "governer_message_delivered",
   [
     [troop_add_gold, "trp_player",10],
     [add_xp_as_reward,100],
     [complete_quest,"qst_deliver_message"],
     [val_add,"$quest_prestige",5]]],
  [anyone,"governer_message_delivered", [], "Hmm let me see that. You can leave now. And here take this money.", "close_window",[]],

  [anyone|plyr,"governer_talk", [[store_partner_quest,reg(2)],[ge,reg(2),0]], "About the mission you gave me sir...", "governer_active_mission_1",[]],
  [anyone,"governer_active_mission_1", [], "Yes, have you made any progress on it?", "governer_active_mission_2",[]],
# DEBUG  
#  [anyone|plyr,"governer_active_mission_2", [],
#   "I have completed the mission.", "governer_mission_complete",[[val_add,"$quest_points",1],]],
  [anyone|plyr,"governer_active_mission_2",
   [[store_partner_quest,reg(2)],[eq,reg(2),"qst_supply_horses"],
    [store_item_kind_count,reg(8),"$horse_quest_item_kind"],
    [ge,reg(8),"$horse_quest_number"],[assign,reg(7),"$horse_quest_number"],[str_store_item_name,1,"$horse_quest_item_kind"]],
   "I have brought {reg7} {s1} as you ordered.", "governer_mission_complete",
   [  [troop_remove_items, 0,"$horse_quest_item_kind","$horse_quest_number"],
#      [store_item_value,reg(10),"horse_quest_item_kind"],
#      [val_mul,reg(10),"horse_quest_number"],
      [assign,reg(10),reg(0)],
      [val_mul,reg(10),10],
      [val_div,reg(10),4],
      [store_add, reg(10),reg(10),10],
      [troop_add_gold, "trp_player",reg(10)],
      [assign,reg(20),2],
      [val_add,reg(20),"$horse_quest_item_kind"],
      [val_sub,reg(20),"itm_sumpter_horse"],
      [val_mul,reg(20),"$horse_quest_number"],
      [val_mul,reg(20),4],
      [add_xp_as_reward,reg(20)],
      (store_item_value,reg(30),"$horse_quest_item_kind"),
      (val_mul,reg(30),"$horse_quest_number"),
      (val_div,reg(30),100),
      (val_add,reg(30),10),
      [val_add,"$quest_prestige",reg(30)],
      [val_add,"$quest_prestige",reg(30)]]],
  [anyone|plyr,"governer_active_mission_2",
   [[store_partner_quest,reg(2)],[eq,reg(2),"qst_supply_equipment"],
    [store_item_kind_count,reg(8),"$equipment_quest_item_kind"],
    [ge,reg(8),"$equipment_quest_number"],[assign,reg(7),"$equipment_quest_number"],[str_store_item_name,1,"$equipment_quest_item_kind"]],
   "I have brought the equipment you asked for, my lord.", "governer_mission_complete",
   [  [troop_remove_items, 0,"$equipment_quest_item_kind","$equipment_quest_number"],
#      [store_item_value,reg(10),"equipment_quest_item_kind"],
#      [val_mul,reg(10),2],
#      [val_mul,reg(10),"equipment_quest_number"],
      [assign,reg(10),reg(0)],
      [val_mul,reg(10),9],
      [val_div,reg(10),4],
      [val_add,reg(10),10],
      [troop_add_gold, "trp_player",reg(10)],
      [assign,reg(20),7],
      [val_mul,reg(20),"$equipment_quest_number"],
      [val_add,reg(20),30],
      [add_xp_as_reward,reg(20)],
      (store_item_value,reg(30),"$equipment_quest_item_kind"),
      (val_mul,reg(30),"$equipment_quest_number"),
      (val_div,reg(30),100),
      (val_add,reg(30),10),
      [val_add,"$quest_prestige",reg(30)]]],
  [anyone|plyr,"governer_active_mission_2",
   [[store_partner_quest,reg(2)],[eq,reg(2),"qst_supply_armor"],
    [store_item_kind_count,reg(8),"$armor_quest_item_kind"],
    [ge,reg(8),"$armor_quest_number"],[assign,reg(7),"$armor_quest_number"],[str_store_item_name,1,"$armor_quest_item_kind"]],
   "I have brought the armors you asked for, my lord.", "governer_mission_complete",
   [  [troop_remove_items, 0,"$armor_quest_item_kind","$armor_quest_number"],
#      [store_item_value,reg(10),"armor_quest_item_kind"],
#      [val_mul,reg(10),3],
#      [val_mul,reg(10),"armor_quest_number"],
      [assign,reg(10),reg(0)],
      [val_mul,reg(10),9],
      [val_div,reg(10),4],
      [val_add,reg(10),10],
      [troop_add_gold, "trp_player",reg(10)],
      [assign,reg(20),7],
      [val_mul,reg(20),"$armor_quest_number"],
      [val_add,reg(20),30],
      [add_xp_as_reward,reg(20)],
      (store_item_value,reg(30),"$armor_quest_item_kind"),
      (val_mul,reg(30),"$armor_quest_number"),
      (val_div,reg(30),100),
      (val_add,reg(30),10),
      [val_add,"$quest_prestige",reg(30)]]],
  [anyone|plyr,"governer_active_mission_2",
   [[store_partner_quest,reg(2)],[eq,reg(2),"qst_capture_prisoners"],[store_troop_count_prisoners,reg(8),"$capture_prisoners_quest_troop"],
    [ge,reg(8),"$capture_prisoners_quest_number"],[assign,reg1,"$capture_prisoners_quest_number"],[str_store_troop_name_plural,1,"$capture_prisoners_quest_troop"]],
   "I have brought you {reg1} {s1} as prisoners, my lord.", "governer_mission_complete",[
      [remove_troops_from_prisoners,"$capture_prisoners_quest_troop","$capture_prisoners_quest_number"],
      [store_troop_value,reg(10),"$capture_prisoners_quest_troop"],
      [val_mul,reg(10),5],
      [val_mul,reg(10),"$capture_prisoners_quest_number"],
      [val_add,reg(10),10],
      [troop_add_gold, "trp_player",reg(10)],
      [assign,reg(20),7],
      [val_mul,reg(20),"$capture_prisoners_quest_number"],
      [val_add,reg(20),30],
      [add_xp_as_reward,reg(20)],
      [store_troop_value,reg(30),"$capture_prisoners_quest_troop"],
      [val_mul,reg(30),"$raise_troops_quest_number"],
      (val_div,reg(30),100),
      (val_add,reg(30),20),
      [val_add,"$quest_prestige",reg(30)]]],
  [anyone|plyr,"governer_active_mission_2",
   [[store_partner_quest,reg(2)],[eq,reg(2),"qst_raise_troops"],[store_troop_count_companions,reg(8),"$raise_troops_quest_troop"],
    [ge,reg(8),"$raise_troops_quest_number"]],
   "I have raised the troops you asked for, my lord.", "governer_mission_complete",[
      [remove_troops_from_companions,"$raise_troops_quest_troop","$raise_troops_quest_number"],
      [store_troop_value,reg(10),"$raise_troops_quest_troop"],
      [val_mul,reg(10),"$raise_troops_quest_number"],
      [val_mul,reg(10),5],
      [val_div,reg(10),2],
      [val_add,reg(10),4],
      [troop_add_gold, "trp_player",reg(10)],
      [assign,reg(20),30],
      [val_mul,reg(20),"$raise_troops_quest_number"],
      [val_add,reg(20),40],
      [add_xp_as_reward,reg(20)],
      [store_troop_value,reg(30),"$raise_troops_quest_troop"],
      [val_mul,reg(30),"$raise_troops_quest_number"],
       (val_div,reg(30),100),
      (val_add,reg(30),20),
      [val_add,"$quest_prestige",reg(30)]]],

  [anyone|plyr,"governer_active_mission_2",
   [[store_partner_quest,reg(2)],[eq,reg(2),"qst_capture_nobleman"],[store_troop_count_prisoners,reg3,"trp_nobleman"],[ge,reg3,1]],
   "I have captured the nobleman sir.", "governer_mission_complete",[
      [remove_troops_from_prisoners,"trp_nobleman",1],
      [troop_add_gold, "trp_player",1000],
      [add_xp_as_reward,3500],
      [val_add,"$quest_prestige",40],
      [assign,"$nobleman_quest_nobleman_active",0],
     ]],
  
  [anyone|plyr,"governer_active_mission_2",
   [[store_partner_quest,reg(2)],[eq,reg(2),"qst_capture_nobleman"],[eq,"$nobleman_quest_failed",1]],
   "I was unable to capture that nobleman sir.", "governer_mission_failed",[
     ]],
  
  [anyone|plyr,"governer_active_mission_2",
   [[store_partner_quest,reg(2)],[eq,reg(2),"qst_hunt_down_raiders"],[eq,"$raider_quest_succeeded",1]],
   "I have given those raiders the punishment they deserved.", "governer_mission_complete",[
      [troop_add_gold, "trp_player",500],
      [add_xp_as_reward,1500],
      [val_add,"$quest_prestige",30]]],
  [anyone|plyr,"governer_active_mission_2",
   [[store_partner_quest,reg(2)],[eq,reg(2),"qst_hunt_down_raiders"],[eq,"$raider_quest_failed",1]],
   "I was unable to catch those raiders sir.", "governer_mission_failed",[
     ]],

  [anyone|plyr,"governer_active_mission_2", [], "I am still working on it sir.", "governer_active_mission_3",[]],
  [anyone,"governer_active_mission_3", [], "Good. Keep working. We need to do our best to win this war.", "close_window",[]],

  [anyone,"governer_mission_complete", [], "Excellent {playername}. You are really reliable. I will not forget your service at this.", "governer_pretalk_ally",
   [[store_partner_quest,reg(2)],[complete_quest,reg(2)],[val_add,"$num_quests_fulfilled",1]]],
  [anyone,"governer_mission_failed", [], "Well. It was a long call anyway. Let us hope you will be luckier next time.", "governer_pretalk_ally",
   [[store_partner_quest,reg(2)],[complete_quest,reg(2)],[val_add,"$num_quests_failed",1]]],

  [anyone|plyr,"governer_talk", [[store_partner_quest,reg(2)],[lt,reg(2),0]], "Do you have any mission for me sir?", "governer_talk_quest_asked",[]],
#  [anyone,"governer_talk_quest_asked", [[store_partner_quest_status,reg(2)],[eq,reg(2),0]], "I don't have any mission for you at this moment {playername}. But ask me again in a few days. I might have something for you then.", "governer_pre_talk",[]],
  [anyone,"governer_talk_quest_asked", [[store_partner_quest,reg(2)],[ge,reg(2),0]], "Well {playername}. You still have not finished the mission I gave you. You should be working on that now.", "governer_pre_talk",[]],
#
  [anyone,"governer_talk_quest_asked", [[store_partner_faction,reg1],[eq,reg1,"fac_kingdom_caowei"],
                                        [store_random_quest_in_range,reg(0),governer_quests_begin,governer_quests_end],
                                        [neq,reg(0),-1],[assign,"$random_quest_no",reg(0)]
                                        ], "A mission? As a matter of fact I just need you to carry out a mission for me.", "governer_tell_mission",
   [[assign,"$enemy_base_troop","trp_shu_youth"],
    [assign,"$ally_base_troop","trp_wei_youth"],
    [assign,"$enemy_raider_party","pt_shu_riders"],
    ]],
  #
  [anyone,"governer_talk_quest_asked", [[store_partner_faction,reg1],[eq,reg1,"fac_kingdom_shuhan"],
                                        [store_random_quest_in_range,reg(0),governer_quests_begin,governer_quests_end],
                                        [neq,reg(0),-1],[assign,"$random_quest_no",reg(0)],
                                        ], "A mission? As a matter of fact I just need you to carry out a mission for me.", "governer_tell_mission",
   [[assign,"$enemy_base_troop","trp_wu_youth"],
    [assign,"$ally_base_troop","trp_shu_youth"],
    [assign,"$enemy_raider_party","pt_wu_riders"],
    ]],
   #
     [anyone,"governer_talk_quest_asked", [[store_partner_faction,reg1],[eq,reg1,"fac_kingdom_wu"],
                                        [store_random_quest_in_range,reg(0),governer_quests_begin,governer_quests_end],
                                        [neq,reg(0),-1],[assign,"$random_quest_no",reg(0)],
                                        ], "A mission? As a matter of fact I just need you to carry out a mission for me.", "governer_tell_mission",
   [[assign,"$enemy_base_troop","trp_wei_youth"],
    [assign,"$ally_base_troop","trp_wu_youth"],
    [assign,"$enemy_raider_party","pt_wei_riders"],
    ]],
    #
  [anyone,"governer_talk_quest_asked", [], "A mission? No {playername}. I do not need your services at this time.", "governer_pretalk_ally",[]],
#
  [anyone,"governer_tell_mission", [(eq,"$random_quest_no","qst_deliver_message"),
                                    (assign, "$pin_faction", "$governer_faction"),
                                    (call_script,"script_select_faction_town"),
                                    (assign,"$message_quest_town","$pout_town"),
                                    (store_encountered_party,"$message_quest_giver_town"),
                                    (neq,"$message_quest_town","$message_quest_giver_town"),
                                    ],
   "I need you to deliver a message to the lord of {s3}. Get on the road as soon as possible.", "governer_mission_told",
   [
     [store_conversation_troop,"$message_quest_giver"],
     [str_store_troop_name,1,"$message_quest_giver"],
     [str_store_party_name,2,"$message_quest_giver_town"],
     [str_store_party_name,3,"$message_quest_town"],
     [setup_quest_text,"$random_quest_no"],
	 (str_store_string, s2, "@{s1} of {s2} asked you to take a message to the lord of {s3}."),
   ]],
  [anyone,"governer_tell_mission", [(eq,"$random_quest_no","qst_supply_horses")], "In the last battle we lost too many good horses and my stables are now almost empty.\
 I need you to bring me {reg1} {s3}s. Talk to horse merchants, visit farms, heck steal them if necessary.\
 Just get me those horses.", "governer_mission_horses_1", [
    [store_random,reg1,5],
    [val_add,reg1,4],
    [store_character_level,reg(7)],
    [val_div,reg(7),5],
    [val_add,reg1,reg(7)],
    [assign,"$horse_quest_number",reg1],
    [store_character_level,reg(6)],
    [val_div,reg(6),4],
    [val_min,reg(6),7],
    [store_random,reg3,reg(6)],
    [val_add,reg3,"itm_sumpter_horse"],
#    [store_random_horse,reg3],
    [assign,"$horse_quest_item_kind",reg3],
    [str_store_item_name,3,reg3],
    [store_conversation_troop,reg(25)],[str_store_troop_name,1,reg(25)],
    [store_encountered_party,reg(26)],[str_store_party_name,2,reg(26)],
    [setup_quest_text,"$random_quest_no"],
	(str_store_string, s2, "@{s1} of {s2} asked you to bring him {reg1} {s3}."),
   ]],
  [anyone|plyr,"governer_mission_horses_1", [], "Sir, can I get some money for the expenses?", "governer_mission_horses_2",[]],
  [anyone,"governer_mission_horses_2", [], "Sure, sure. Bring the horses and I will pay for your expenses and of course something extra for you too.", "governer_mission_told",[]],
  [anyone,"governer_tell_mission", [(eq,"$random_quest_no","qst_supply_equipment")],
 "I am raising a new company of troops {playername}.\
 Soon they will be ready for battle except that we can't fully equip them from my armory.\
 I need to purchase some of the equipment from outside.\
 Now, I want you to bring me {reg1} {s3}.\
 I will pay handsomely for your effort as soon as you have brought them.", "governer_mission_told", [
    [store_random,reg1,4],[val_add,reg1,3],
    [assign,"$equipment_quest_number",reg1],
    [store_random_equipment,reg3],
    [assign,"$equipment_quest_item_kind",reg3],
    [str_store_item_name,3,reg3],
    [store_conversation_troop,reg(25)],[str_store_troop_name,1,reg(25)],
    [store_encountered_party,reg(26)],[str_store_party_name,2,reg(26)],
    [setup_quest_text,"$random_quest_no"],
	(str_store_string, s2, "@{s1} of {s2} asked you to bring him {reg1} {s3}."),
   ]],
  [anyone,"governer_tell_mission", [(eq,"$random_quest_no","qst_supply_armor")],
 "I am raising a new company of troops {playername}.\
 Soon they will be ready for battle except that we can't fully equip them from my armory.\
 I need to purchase some of the armor from outside.\
 Now, I want you to bring me {reg1} {s3}.\
 I will pay handsomely for your effort as soon as you have brought them.", "governer_mission_told", [
    [store_random,reg1,4],[val_add,reg1,3],
    [assign,"$armor_quest_number",reg1],
    [store_random_armor,reg3],
    [assign,"$armor_quest_item_kind",reg3],
    [str_store_item_name,3,reg3],
    [store_conversation_troop,reg(25)],[str_store_troop_name,1,reg(25)],
    [store_encountered_party,reg(26)],[str_store_party_name,2,reg(26)],
    [setup_quest_text,"$random_quest_no"],
	(str_store_string, s2, "@{s1} of {s2} asked you to bring him {reg1} {s3}."),
	
   ]],
  [anyone,"governer_tell_mission", [(eq,"$random_quest_no","qst_capture_prisoners")], "We are in the dark regarding what the enemy is planning and by God, I don't like this.\
 If we capture a few prisoners, perhaps they will tell us something useful. Go now and bring me {reg1} {s3} as prisoners.", "governer_mission_told",
   [[store_random,reg1,5],[val_add,reg1,2],
    [assign,"$capture_prisoners_quest_number",reg1],
    [store_random_troop_to_capture,reg3,"$enemy_base_troop"],
    [assign,"$capture_prisoners_quest_troop",reg3],
    [str_store_troop_name_plural,3,reg3],
    [store_conversation_troop,reg(25)],[str_store_troop_name,1,reg(25)],
    [store_encountered_party,reg(26)],[str_store_party_name,2,reg(26)],
    [setup_quest_text,"$random_quest_no"],
	(str_store_string, s2, "@{s1} of {s2} wanted you to bring him {reg1} {s3} as prisoners."),
	]],
  [anyone,"governer_tell_mission", [[eq,"$random_quest_no","qst_raise_troops"]], "I was inspecting the troops the other day,\
 and there are men out there who don't know which end of the sword is meant for business.\
 Fat lazy bastards. God knows if we are going to win this war, we need hardened warriors.\
 And you are going to raise those warriors for me. I want you to raise {reg1} {s3} and bring them to me.", "governer_mission_told",[
    [store_random,reg1,5],[val_add,reg1,2],
    [assign,"$raise_troops_quest_number",reg1],
    [store_random_troop_to_raise,reg3,"$ally_base_troop"],
    [assign,"$raise_troops_quest_troop",reg3],
    [str_store_troop_name_plural,3,reg3],
    [store_conversation_troop,reg(25)],[str_store_troop_name,1,reg(25)],
    [store_encountered_party,reg(26)],[str_store_party_name,2,reg(26)],
    [setup_quest_text,"$random_quest_no"],
	(str_store_string, s2, "@{s1} of {s2} asked you to raise {reg1} {s3} and bring them to him."),
   ]],
  [anyone,"governer_tell_mission", [(eq,"$random_quest_no","qst_capture_nobleman"),
                                    (assign, "$pin_faction", "$governer_enemy_faction"),
                                    (call_script,"script_select_faction_town"),
                                    (assign,"$nobleman_quest_source_town","$pout_town"),
                                    (assign, "$pin_faction", "$governer_enemy_faction"),
                                    (call_script,"script_select_faction_town"),
                                    (assign,"$nobleman_quest_target_town","$pout_town"),
                                    (neq,"$nobleman_quest_source_town","$nobleman_quest_target_town"),
                                    ],
 "I have been informed that an enemy nobleman will make a journey from {s3} to {s4} in {reg1} days.\
 What is more, he will be escorted very lightly on the way.\
 Now, that nobleman's ransom must be worth a small fortune and you and I are going to claim it.\
 You must leave instantly and attack the nobleman's party on their way to {s4}.\
 Once you capture him, bring him to me. I am counting on you.", "governer_mission_told",
   [(spawn_around_party,"$nobleman_quest_source_town","$nobleman_party_template"),
    (assign, "$nobleman_quest_party_id",reg(0)),
    (party_set_ai_behavior,"$nobleman_quest_party_id",ai_bhvr_travel_to_party),
    (party_set_ai_object,"$nobleman_quest_party_id","$nobleman_quest_target_town"),
    (party_set_faction,"$nobleman_quest_party_id","$governer_enemy_faction"),
    (disable_party,"$nobleman_quest_party_id"),
    (assign,"$nobleman_quest_nobleman_enable",1),
    (assign,"$nobleman_quest_succeeded",0),
    (assign,"$nobleman_quest_failed",0),
    (assign,"$nobleman_quest_nobleman_active",0),
    (str_store_party_name,3,"$nobleman_quest_source_town"),
    (str_store_party_name,4,"$nobleman_quest_target_town"),
    (store_current_hours,reg(7)),
    (store_conversation_troop,"$nobleman_quest_giver"),
    (store_encountered_party,"$nobleman_quest_giver_town"),
    (str_store_party_name,2,"$nobleman_quest_giver_town"),
    (store_distance_to_party_from_party, reg(0),"$nobleman_quest_giver_town",reg5),
    (val_div,reg(0),60),
    (val_add,reg(0),1),
    (assign,reg1,reg(0)),
    (assign,reg1,2), #overwrite. TODO: fix this.
    (assign,reg(12),reg(0)),
    (val_mul,reg(12),24),
    (val_add,reg(7),reg(12)),
    (str_store_troop_name,1,"$nobleman_quest_giver"),
    (str_store_party_name,2,"$nobleman_quest_giver_town"),
    (setup_quest_text,"$random_quest_no"),
	(str_store_string, s2,   "@{s1} of {s2} wanted you to capture an enemy nobleman on his way from {s3} to {s4}.\
		He said the nobleman would leave {s3} in {reg1} days."
	),
    ]],
  [anyone,"governer_tell_mission", [(eq,"$random_quest_no","qst_hunt_down_raiders"),
                                    (assign, "$pin_faction", "$governer_faction"),
                                    (call_script,"script_select_faction_town"),
                                    (assign,"$raider_quest_source_town","$pout_town"),
                                    (assign, "$pin_faction", "$governer_enemy_faction"),
                                    (call_script,"script_select_faction_town"),
                                    (assign,"$raider_quest_target_town","$pout_town"),
                                    (store_encountered_party,reg(11)),
                                    (neq,reg(11),"$raider_quest_source_town"),
                                    ],
 "A messenger came with important news a few hours ago.\
 A group of enemy raiders have attacked a village near {s3}.\
 They have murdered anyone who tried to resist, stolen everything they could carry and put the rest to fire.\
 Now, they must be on their way back to their base at {s4}.\
 You must catch them on the way and make them pay for their crimes.\
 God be with you.", "governer_mission_told",
   [(set_spawn_radius, 3),
    (spawn_around_party,"$raider_quest_source_town","$enemy_raider_party"),
    (assign, "$raider_quest_party_id",reg(0)),
    (party_set_ai_behavior,"$raider_quest_party_id",ai_bhvr_travel_to_party),
    (party_set_ai_object,"$raider_quest_party_id","$raider_quest_target_town"),
    (party_set_faction,"$raider_quest_party_id","$governer_enemy_faction"),
    (assign,"$raider_quest_succeeded",0),
    (assign,"$raider_quest_failed",0),
    (assign,"$raider_quest_active",1),
    (str_store_party_name,3,"$raider_quest_source_town"),
    (str_store_party_name,4,"$raider_quest_target_town"),
    (store_encountered_party,reg(11)),(str_store_party_name,2,reg(11)),
    (store_conversation_troop,reg(12)),(str_store_troop_name,1,reg(12)),
    (setup_quest_text,"$random_quest_no"),
	(str_store_string, s2, "@{s1} of {s2} asked you to hunt down and punish the raiders that attacked a village near {s3} before they reach the safety of their base at {s4}."),
    ]],
  [anyone,"governer_tell_mission", [], "I am afraid I wasn't able to come up with a mission for you.", "close_window",[]],

  [anyone|plyr,"governer_mission_told", [], "As you wish sir. You can count on me.", "governer_mission_accepted",[]],
  [anyone|plyr,"governer_mission_told", [], "TODO:I'm sorry. I can't do that.", "governer_mission_rejected",[]],
  
  [anyone,"governer_mission_accepted", [], "Excellent. Do this {playername}. I really have high hopes for you.", "close_window",
   [
   #[start_quest,"$random_quest_no"]
   (call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
   ]],
  [anyone,"governer_mission_rejected", [], "TODO:Never mind", "close_window",[]],

  [anyone|plyr,"governer_talk", [], "About my rank and wages...", "governer_rank_and_wages",[]],
#
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 0]], "Well... you are but a fresh recruit for our army and as such your weekly wage is {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 1],(eq,"$wuguan",1)], "Well... you are a regular of our army and as such your weekly wage is {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 2],(eq,"$wuguan",1)], "Well... you are a veteran of our army and as such your weekly wage is {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 3],(eq,"$wuguan",1)], "Well... you are a sergeant of our army and as such your weekly wage is {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 4],(eq,"$wuguan",1)], "Well... you are a sergeant-at-arms of our army and as such your weekly wage is {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 5],(eq,"$wuguan",1)], "Well... you are a squire in our army and as such you are entitled to  a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 6],(eq,"$wuguan",1)], "Well... you are a knight of our army and as such you are entitled to a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 7],(eq,"$wuguan",1)], "Well... you are a knight-at-arms of our army and as such you are entitled to a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 8],(eq,"$wuguan",1)], "Well... you are a sergeant-knight of our army and as such you are entitled to a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 9],(eq,"$wuguan",1)], "Well... you are a sergeant-knight-at-arms of our army and as such you are entitled to a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank",10],(eq,"$wuguan",1)], "Well... you are a master-knight of our army and as such you are entitled to a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank",11],(eq,"$wuguan",1)], "Well... you are the grandmaster-knight of our army and as such you are entitled to a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],

  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 1],(eq,"$wenguan",1)], "Well... you are a zhu bo and as such your weekly wage is {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 2],(eq,"$wenguan",1)], "Well... you are a chang shi and as such your weekly wage is {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 3],(eq,"$wenguan",1)], "Well... you are a shi lang and as such your weekly wage is {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 4],(eq,"$wenguan",1)], "Well... you are a pu she and as such your weekly wage is {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 5],(eq,"$wenguan",1)], "Well... you are a tai zhong da fu and as such you are entitled to  a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 6],(eq,"$wenguan",1)], "Well... you are a zhong shu ling and as such you are entitled to a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 7],(eq,"$wenguan",1)], "Well... you are a tai chang and as such you are entitled to a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 8],(eq,"$wenguan",1)], "Well... you are a ting wei and as such you are entitled to a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank", 9],(eq,"$wenguan",1)], "Well... you are a zhi jin wu and as such you are entitled to a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank",10],(eq,"$wenguan",1)], "Well... you are si kong and as such you are entitled to a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],
  [anyone,"governer_rank_and_wages", [[eq,"$faction_rank",11],(eq,"$wenguan",1)], "Well... you are chen xiang and as such you are entitled to a weekly wage of {reg0} denars.", "governer_collect_wages",[[assign,reg(0),"$weekly_wage"]]],

  [anyone,"governer_collect_wages", [[eq,"$wages",0]], "You have no wages accumulated yet.", "governer_anything_else",[]],
  [anyone,"governer_collect_wages", [], "By the way, your wages have accumulated to some {reg1} denars. Well here you go.", "close_window",
   [[assign,reg1,"$wages"],[troop_add_gold, "trp_player","$wages"],[assign,"$wages",0]]],
  [anyone,"governer_anything_else", [], "Anything else?", "governer_talk",[]],
#
  [anyone|plyr,"governer_talk", [[gt,"$governer_relation",0]], "May I have permission to leave now sir?", "governer_leave_ally",[]],
  [anyone|plyr ,"governer_talk", [[lt,"$governer_relation",0]], "Let me be on my way now milord. Good-bye.", "close_window",[]],
  [anyone|plyr ,"governer_talk", [[eq,"$governer_relation",0]], "Let me be on my way now milord. Good-bye.", "close_window",[]],

  [anyone,"governer_leave_ally", [], "Yes you may leave now.", "close_window",[]],

#sango end










######################################
# GENERIC MEMBER CHAT
######################################

  [anyone,"member_chat", [], "Your orders {sir/madam}?", "regular_member_talk",[]],
  [anyone|plyr,"regular_member_talk", [], "Tell me about yourself", "view_regular_char_requested",[]],
  [anyone,"view_regular_char_requested", [], "Aye {sir/madam}. Let me tell you all there is to know about me.", "do_regular_member_view_char",[[change_screen_view_character]]],
  [anyone,"do_regular_member_view_char", [], "Anything else?", "regular_member_talk",[]],
  [anyone|plyr,"regular_member_talk", [], "Nothing. Keep moving.", "close_window",[]],




######################################
# GENERIC PARTY ENCOUNTER
######################################

  [anyone,"start", [(eq,"$talk_context",tc_party_encounter),
                    (gt,"$encountered_party_hostile",0),
                    (encountered_party_is_attacker),
                    ],
   "You have no chance against us. Surrender now or we will kill you all...", "party_encounter_hostile_attacker",
   []],
  [anyone|plyr,"party_encounter_hostile_attacker", [
                    ],
   "Don't attack! We surrender.", "close_window", [(assign,"$g_player_surrenders",1)]],
#  [anyone|plyr,"party_encounter_hostile_attacker", [
#                    ],
#   "I will pay you 1000 denars if you just let us go.", "close_window", []],
  [anyone|plyr,"party_encounter_hostile_attacker", [
                    ],
   "We will fight you to the end!", "close_window", []],
  
  [anyone,"start", [(eq,"$talk_context",tc_party_encounter),
                    (neg|encountered_party_is_attacker),
                    ],
   "What do you want?", "party_encounter_hostile_defender",
   []],

  [anyone|plyr,"party_encounter_hostile_defender", [],
   "Surrender or die!", "party_encounter_hostile_ultimatum_surrender", []],
  [anyone,"party_encounter_hostile_ultimatum_surrender", [],
   "You rascal! You will pay for this", "close_window", [(assign,"$encountered_party_hostile",1)]],

  [anyone|plyr,"party_encounter_hostile_defender", [],
   "Nothing. We'll leave you in peace.", "close_window", [(assign, "$g_leave_encounter",1)]],




  [anyone,"start", [(eq,"$talk_context",tc_join_battle_ally),
                    ],
   "You have come just in time. Let us join our forces now and teach our enemy a lesson.", "close_window",
   []],

  [anyone,"start", [(eq,"$talk_context",tc_join_battle_enemy),
                    ],
   "You are making a big mistake by fighting against us.", "close_window",
   []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (eq, "$g_talk_troop_met", 0),
                    (ge, "$g_talk_troop_relation", 17),
                    ],
   "I don't think we have met properly my friend. You just saved my life out there, and I still don't know your name...", "ally_thanks_meet", []],


  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (eq, "$g_talk_troop_met", 0),
                    (ge, "$g_talk_troop_relation", 5),
                    ],
   "Your help was most welcome stranger. My name is {s1}. Can I learn yours?", "ally_thanks_meet", []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (eq, "$g_talk_troop_met", 0),
                    (ge, "$g_talk_troop_relation", 0),
                    (str_store_troop_name, s1, "$g_talk_troop"),
                    ],
   "Thanks for yor help, stranger. We haven't met properly yet, have we? What is you name?", "ally_thanks_meet", []],

  [anyone|plyr,"ally_thanks_meet", [], "My name is {playername}.", "ally_thanks_meet_2", []],

  [anyone, "ally_thanks_meet_2", [(ge, "$g_talk_troop_relation", 15),(str_store_troop_name, s1, "$g_talk_troop")],
   "Well met indeed {playername}. My name is {s1} and I am forever in your debt. If there is ever anything I can help you with, just let me know...", "close_window", []],
  [anyone, "ally_thanks_meet_2", [(ge, "$g_talk_troop_relation", 5),], "Well met {playername}. I am in your debt for what you just did. I hope one day I will find a way to repay it.", "close_window", []],
  [anyone, "ally_thanks_meet_2", [], "Well met {playername}. I am {s1}. Thanks for your help and I hope we meet again.", "close_window", []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (ge, "$g_talk_troop_relation", 30),
                    (ge, "$g_relation_boost", 10),
                    ],
   "You are making it a habit of saving our backs {playername}. I am starting to believe you are my guardian angel.", "close_window", []],
  
  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (ge, "$g_talk_troop_relation", 20),
                    (ge, "$g_relation_boost", 5),
                    ],
   "You turn up just at the right time {playername}. As always! Those bastards didn't stand a chance!", "close_window", []],
  
  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (ge, "$g_talk_troop_relation", 0),
                    (ge, "$g_relation_boost", 3),
                    ],
   "You turned up just in time {playername}. Thank you! I will not forget your help.", "close_window", []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (ge, "$g_talk_troop_relation", -5),
                    ],
   "Good to see you here {playername}. It was a good fight wasn't it? Those bastards didn't stand a chance!", "close_window", []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (ge, "$g_relation_boost", 4),
                    ],
   "If you expect me to thank you {playername}, you can just keep waiting. You may have helped me out there, but remember, we still have unfinished business.", "close_window", []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (ge, "$g_talk_troop_relation", -20),
                    ],
   "So, this is {playername}. Well, your help wasn't really needed, but I guess you had nothing better to do, right?", "close_window", []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    ],
   "Who told you to come to our help? I certainly didn't. Begone now. I want nothing from you and I will not let you steal my victory.", "close_window", []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (ge, "$g_relation_boost", 10),
                    (party_get_num_companions, reg1, "$g_encountered_party"),
                    (val_sub, reg1, 1),
                    ],
   "Thank you for your help {sir/madam}. You saved {reg1?our lives:my life} out there.", "close_window", []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (ge, "$g_relation_boost", 10),
                    ],
   "Thank you for your help {sir/madam}. Things didn't look very well for us but then you came up and everything changed.", "close_window", []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks)],
   "Thank you for your help. ", "close_window", []],
  

  [anyone,"start", [(eq,"$talk_context",tc_hero_freed)],
   "I am in your debt for freeing me friend.", "freed_hero_answer",
   []],

  [anyone|plyr,"freed_hero_answer", [],
   "You're not going anywhere. You'll be my prisoner now!", "freed_hero_answer_1",
   [
     (store_conversation_troop, ":cur_troop_id"), 
     (party_add_prisoners, "p_main_party", ":cur_troop_id", 1),#take prisoner
    ]],

  [anyone,"freed_hero_answer_1", [],
   "Alas. Will my luck never change?", "close_window",
   []],

  [anyone|plyr,"freed_hero_answer", [],
   "You are free to go wherever you want.", "freed_hero_answer_2",
   [
    ]],

  [anyone,"freed_hero_answer_2", [],
   "Thank you friend. I will not forget this. May good fortune be with you.", "close_window",
   []],

  [anyone|plyr,"freed_hero_answer", [],
   "Would you like to join me?", "freed_hero_answer_3",
   []],

  [anyone,"freed_hero_answer_3", [(store_random_in_range, ":random_no",0,2),(eq, ":random_no", 0)],
   "All right I will join you.", "close_window",
   [
     (store_conversation_troop, ":cur_troop_id"), 
     (party_add_members, "p_main_party", ":cur_troop_id", 1),#join hero
   ]],

  [anyone,"freed_hero_answer_3", [],
   "No, I want to go on my own.", "close_window",
   [
    ]],

  [anyone,"start", [(eq,"$talk_context",tc_hero_defeated)],
   "You will not live long to enjoy your victory. My kinsmen will soon wipe out the stain of this defeat.", "defeat_hero_answer",
   [
    ]],

  [anyone|plyr,"defeat_hero_answer", [],
   "You are my prisoner now.", "defeat_hero_answer_1",
   [
     (store_conversation_troop, ":cur_troop_id"), 
     (party_add_prisoners, "p_main_party", ":cur_troop_id", 1),#take prisoner
     (troop_set_slot, ":cur_troop_id", slot_troop_is_prisoner, 1),
    ]],

  [anyone,"defeat_hero_answer_1", [],
   "Damn you. You will regret this.", "close_window",
   []],

  [anyone|plyr,"defeat_hero_answer", [],
   "You are free to go now. But don't you step in my path again.", "defeat_hero_answer_2",
   []],

  [anyone,"defeat_hero_answer_2", [],
   "We will meet again.", "close_window",
   []],



  

  [anyone,"start", [], "Surrender or die. Make your choice", "battle_reason_stated",[]],
  [anyone|plyr,"battle_reason_stated", [], "I am not afraid of you. I will fight.", "close_window",[[encounter_attack]]],

  [anyone,"start", [], "You are going to die today", "close_window",[[encounter_attack]]],


  [anyone,"start", [], "Hello. What can I do for you?", "free",[]],
  [anyone|plyr,"free", [[neg|in_meta_mission]], "Tell me about yourself", "view_char_requested",[]],
  [anyone,"view_char_requested", [], "Ok then listen to this...", "view_char",[[change_screen_view_character]]],
  [anyone,"view_char", [], "Anything else?", "free",[]],

  [anyone|plyr,"end", [], "(Done)", "close_window",[]],
  
  [anyone|plyr,"start", [], "Drop your weapons and surrender if you want to live", "threaten_1",[]],
  [anyone,"threaten_1", [], "We will fight you first", "end",[[encounter_attack]]],

#  [anyone|plyr,"free", [[partner_is_mercmaster]], "I need to hire some mercenaries.", "mercenaries_requested",[]],
#  [anyone,"mercenaries_requested", [], "I have the toughest fighters in all Calradia.", "buy_mercenaries",[[change_screen_buy_mercenaries]]],
#  [anyone,"buy_mercenaries", [], "Anything else?", "free",[]],

#  [anyone|plyr,"free", [[partner_is_recruitable]], "I need a capable sergeant like yourself. How much do you ask to work for me?", "employ_mercenary_requested",[]],
#  [anyone,"employ_mercenary_requested", [[store_mercenary_price,0],[store_mercenary_wage,1]], "I want {reg0} denars now and {reg1} denars as monthly payment.", "employ_mercenary_2",[]],
#  [anyone|plyr,"employ_mercenary_2", [], "I see I need to think of this.", "employ_mercenary_giveup",[]],
#  [anyone|plyr,"employ_mercenary_2", [[neg|hero_can_join]], "I don't have any more room in my party right now. I will talk to you again later.", "employ_mercenary_giveup",[]],
#  [anyone|plyr,"employ_mercenary_2", [[player_gold_ge,reg(0)],[hero_can_join]], "That's fine. Here's the {reg0} denars. From now on you work for me.", "employ_mercenary_commit",[[troop_remove_gold, "trp_player",reg(0)],[recruit_mercenary]]],
#  [anyone,"employ_mercenary_giveup", [], "Suits me.", "free",[]],
#  [anyone,"employ_mercenary_commit", [], "You got yourself the best fighter in the land.", "end",[]],


  [anyone|plyr,"free", [[in_meta_mission]], " Good-bye.", "close_window",[]],
  [anyone|plyr,"free", [[neg|in_meta_mission]], " [Leave]", "close_window",[]],
#  [anyone,"free", [], "NO MATCHING SENTENCE!", "close_window",[]],


]
