from header_factions import *

####################################################################################################################
#  Each faction record contains the following fields:
#  1) Faction id: used for referencing factions in other files.
#     The prefix fac_ is automatically added before each faction id.
#  2) Faction name.
#  3) Faction flags. See header_factions.py for a list of available flags
#  4) Faction coherence. Relation between members of this faction.
#  5) Relations. This is a list of relation records.
#     Each relation record is a tuple that contains the following fields:
#    5.1) Faction. Which other faction this relation is referring to
#    5.2) Value: Relation value between the two factions.
#         Values range between -1 and 1.
#  6) Ranks
#  7) Faction color (default is gray)
####################################################################################################################
factions_defined=1
default_kingdom_relations = [("outlaws",-0.05),("peasant_rebels", -0.1),("deserters", -0.02),("mountain_bandits", -0.02),("forest_bandits", -0.02)]
factions = [
  ("player_faction","Player Faction",0, 0.9, [], []),
  ("commoners","Commoners",0, 0.1,[("player_faction",0.1)], []),
  ("outlaws","Outlaws", max_player_rating(-30), 0.5,[("commoners",-0.6),("player_faction",-0.3)], []),
# Factions before this point are hardwired into the game end their order should not be changed.

  ("neutral","Neutral",0, 0.1,[("player_faction",0.0)], []),
  ("innocents","Innocents", ff_always_hide_label, 0.5,[("outlaws",-0.05)], []),
  ("merchants","Merchants", ff_always_hide_label, 0.5,[("outlaws",-0.5),], []),

  ("dark_knights","Dark Knights", 0, 0.5,[("innocents",-0.9),("player_faction",-0.4)], []),

  ("culture_1",  "culture_1", 0, 0.9, [], []),
  ("culture_2",  "culture_2", 0, 0.9, [], []),
  ("culture_3",  "culture_3", 0, 0.9, [], []),
  ("culture_4",  "culture_4", 0, 0.9, [], []),
  ("culture_5",  "culture_5", 0, 0.9, [], []),

#  ("swadian_caravans","Swadian Caravans", 0, 0.5,[("outlaws",-0.8), ("dark_knights",-0.2)], []),
#  ("vaegir_caravans","Vaegir Caravans", 0, 0.5,[("outlaws",-0.8), ("dark_knights",-0.2)], []),

  ("kingdom_1",  "Kingdom of Swadia", 0, 0.9, [("outlaws",-0.05),("peasant_rebels", -0.1),("deserters", -0.02),("mountain_bandits", -0.05),("forest_bandits", -0.05)], [], 0xDD8844),
  ("kingdom_2",  "Kingdom of Vaegirs",    0, 0.9, [("outlaws",-0.05),("peasant_rebels", -0.1),("deserters", -0.02),("mountain_bandits", -0.05),("forest_bandits", -0.05)], [], 0x33DD33),
  ("kingdom_3",  "Khergit Khanate", 0, 0.9, [("outlaws",-0.05),("peasant_rebels", -0.1),("deserters", -0.02),("mountain_bandits", -0.05),("forest_bandits", -0.05)], [], 0xCC99FF),
  ("kingdom_4",  "Kingdom of Nords",    0, 0.9, [("outlaws",-0.05),("peasant_rebels", -0.1),("deserters", -0.02),("mountain_bandits", -0.05),("forest_bandits", -0.05)], [], 0xDDDD33),
  ("kingdom_5",  "Kingdom of Rhodoks",  0, 0.9, [("outlaws",-0.05),("peasant_rebels", -0.1),("deserters", -0.02),("mountain_bandits", -0.05),("forest_bandits", -0.05)], [], 0x33DDDD),


##  ("kingdom_of_france",  "Kingdom of France", 0, 0.9, default_kingdom_relations, []),
##  ("duchy_of_normandy",  "Duchy of Normandy", 0, 0.9, default_kingdom_relations, []),
##  ("county_of_brittany", "County of Brittany", 0, 0.9, default_kingdom_relations, []),
##  ("county_of_maine",    "County of Maine", 0, 0.9, default_kingdom_relations, []),
##  ("county_of_anjou",    "County of Anjou", 0, 0.9, default_kingdom_relations, []),
##  ("county_of_blois",    "County of Blois", 0, 0.9, default_kingdom_relations, []),
##  ("county_of_vermandois",  "County of Vermandois", 0, 0.9, default_kingdom_relations, []),
##  ("county_of_flanders",  "County of Flanders", 0, 0.9, default_kingdom_relations, []),

#  ("kingdoms_end","kingdoms_end", 0, 0,[], []),

##  ("robber_knights",  "robber_knights", 0, 0.1, [], []),

  ("khergits","Khergits", 0, 0.5,[("player_faction",0.0)], []),
  ("black_khergits","Black Khergits", 0, 0.5,[("player_faction",-0.3)], []),

##  ("rebel_peasants","Rebel Peasants", 0, 0.5,[("vaegirs",-0.5),("player_faction",0.0)], []),

  ("manhunters","Manhunters", 0, 0.5,[("outlaws",-0.6),("player_faction",0.1)], []),
  ("deserters","Deserters", 0, 0.5,[("manhunters",-0.6),("merchants",-0.5),("player_faction",-0.2)], []),
  ("mountain_bandits","Mountain Bandits", 0, 0.5,[("commoners",-0.2),("merchants",-0.5),("manhunters",-0.6),("player_faction",-0.3)], []),
  ("forest_bandits","Forest Bandits", 0, 0.5,[("commoners",-0.2),("merchants",-0.5),("manhunters",-0.6),("player_faction",-0.3)], []),

  ("undeads","Undeads", max_player_rating(-30), 0.5,[("commoners",-0.7),("player_faction",-0.5)], []),
  ("slavers","Slavers", 0, 0.1, [], []),
  ("peasant_rebels","Peasant Rebels", 0, 1.0,[("noble_refugees",-1.0),("player_faction",-0.4)], []),
  ("noble_refugees","Noble Refugees", 0, 0.5,[], []),
  
  
  
  
  ("kingdom_caowei","kingdom Caowei", 0, 0.9,[("force_headyellow",-0.5),("force_cateran",-0.5),("force_hijacker",-0.5),("force_defector",-0.5),("force_hun",-0.5),("force_southsavagery",-0.1),("force_mountainsavagery",-0.1),("force_peasantry",0.2),("force_efugee",0.2)], [],0x2020ff),
  ("kingdom_shuhan","kingdom Shuhan", 0, 0.9,[("force_headyellow",-0.5),("force_cateran",-0.5),("force_hijacker",-0.5),("force_defector",-0.5),("force_hun",-0.1),("force_southsavagery",-0.1),("force_mountainsavagery",-0.1),("force_peasantry",0.2),("force_efugee",0.2)], [],0x20ff20),
  ("kingdom_wu","kingdom Wu", 0, 0.9,[("force_headyellow",-0.5),("force_cateran",-0.5),("force_hijacker",-0.5),("force_defector",-0.5),("force_hun",-0.1),("force_southsavagery",-0.1),("force_mountainsavagery",-0.5),("force_peasantry",0.2),("force_efugee",0.2)], [],0xff2020),


##  ("kingdom_of_france",  "Kingdom of France", 0, 0.9, default_kingdom_relations, []),
##  ("duchy_of_normandy",  "Duchy of Normandy", 0, 0.9, default_kingdom_relations, []),
##  ("county_of_brittany", "County of Brittany", 0, 0.9, default_kingdom_relations, []),
##  ("county_of_maine",    "County of Maine", 0, 0.9, default_kingdom_relations, []),
##  ("county_of_anjou",    "County of Anjou", 0, 0.9, default_kingdom_relations, []),
##  ("county_of_blois",    "County of Blois", 0, 0.9, default_kingdom_relations, []),
##  ("county_of_vermandois",  "County of Vermandois", 0, 0.9, default_kingdom_relations, []),
##  ("county_of_flanders",  "County of Flanders", 0, 0.9, default_kingdom_relations, []),

  ("kingdoms_end","kingdoms_end", 0, 0,[], []),
  ("undeads","Undeads", max_player_rating(-30), 0.5,[("commoners",-0.7),("player_faction",-0.5)], []),
  ("slavers","Slavers", 0, 0.1, [], []),
  ("peasant_rebels","Peasant Rebels", 0, 1.0,[("noble_refugees",-1.0),("player_faction",-0.4)], []),
  ("noble_refugees","Noble Refugees", 0, 0.5,[], []),
  ("force_peasantry","Force Peasantry", 0, 0.5,[("player_faction",0.1)], []),
  ("force_efugee","Force Efugee", 0, 0.5,[("player_faction",0.1)], []),
  ("force_headyellow","Force Headyellow", 0, 0.5,[("force_hun",-0.2),("force_southsavagery",-0.2),("force_mountainsavagery",-0.2),("force_peasantry",-0.1),("force_efugee",-0.1),("player_faction",-0.3)], []),
  ("force_cateran","Force Cateran", 0, 0.5,[("force_hun",-0.2),("force_southsavagery",-0.2),("force_mountainsavagery",-0.2),("force_peasantry",-0.1),("force_efugee",-0.1),("player_faction",-0.3)], []),
  ("force_hijacker","Force Hijacker", 0, 0.5,[("force_hun",-0.2),("force_southsavagery",-0.2),("force_mountainsavagery",-0.2),("force_peasantry",-0.1),("force_efugee",-0.1),("player_faction",-0.3)], []),
  ("force_defector","Force Defector", 0, 0.5,[("force_hun",-0.2),("force_southsavagery",-0.2),("force_mountainsavagery",-0.2),("force_peasantry",-0.1),("force_efugee",-0.1),("player_faction",-0.3)], []),
  ("force_hun","Force Hun", 0, 0.5,[("force_peasantry",-0.5),("force_efugee",-0.5),("force_southsavagery",-0.1),("force_mountainsavagery",-0.1),("player_faction",-0.1)], []),
  ("force_southsavagery","Force Southsavagery", 0, 0.5,[("force_peasantry",-0.5),("force_efugee",-0.5),("force_mountainsavagery",-0.1),("player_faction",-0.1)], []),
  ("force_mountainsavagery","Force Mountainsavagery", 0, 0.5,[("force_peasantry",-0.5),("force_efugee",-0.5),("player_faction",-0.1)], []),

]
