from header_game_menus import *
from header_parties import *
from header_items import *

from module_constants import *

####################################################################################################################
#  (menu-id, menu-flags, menu_text, mesh-name, [<operations>], [<options>]),
#
#   Each game menu is a tuple that contains the following fields:
#  
#  1) Game-menu id (string): used for referencing game-menus in other files.
#     The prefix menu_ is automatically added before each game-menu-id
#
#  2) Game-menu flags (int). See header_game_menus.py for a list of available flags
#  3) Game-menu text (string).
#  4) mesh-name (string). Not currently used. Must be the string "none"
#  5) Operations block (list). A list of operations. See header_operations.py for reference.
#     The operations block is executed when the game menu is activated.
#  6) List of Menu options (List).
#     Each menu-option record is a tuple containing the following fields:
#   6.1) Menu-option-id (string) used for referencing game-menus in other files.
#        The prefix mno_ is automatically added before each menu-option.
#   6.2) Conditions block (list). This must be a valid operation block. See header_operations.py for reference. 
#        The conditions are executed for each menu option to decide whether the option will be shown to the player or not.
#   6.3) Menu-option text (string).
#   6.4) Consequences block (list). This must be a valid operation block. See header_operations.py for reference. 
#        The consequences are executed for the menu option that has been selected by the player.
#
#
# Note: The first Menu is the initial character creation menu.
####################################################################################################################
game_menus_defined=1
game_menus = [
#This needs to be the first window!!!
  (
    "start_game_1",0,
    "Welcome, adventurer, to Mount&Blade. Before you start the game, you must create a character. To begin, select your character's gender.",
    "none",
    [(assign, "$savegame_version", mod_version_num),
	(set_quest_progression,"qst_prestige",0),(start_quest,"qst_prestige")],
    [
      ("start_male",[],"Male",
       [
			(troop_set_type,"trp_player",0),
			(assign,"$character_gender",0),
			(troop_raise_attribute, "trp_player",ca_strength,2),
			(troop_raise_attribute, "trp_player",ca_agility,1),
			(troop_raise_attribute, "trp_player",ca_charisma,2),	   
			(jump_to_menu,"mnu_start_game_2"),
        ]
       ),
      ("start_female",[],"Female",
       [
			(troop_set_type,"trp_player",1),
			(assign,"$character_gender",1),
			(troop_raise_attribute, "trp_player",ca_agility,2),           
			(troop_raise_attribute, "trp_player",ca_intelligence,1),
			(troop_raise_attribute, "trp_player",ca_charisma,4),
			(jump_to_menu,"mnu_start_game_2")
        ]
       ),
      ("go_back",[],"Go back",
       [(change_screen_quit),
        ]
       ),
      ]
  ),
#This needs to be the second window!!!
  (
    "start_phase_2",0,
    "During your travels, you come accross a group of men who are looking for a leader. You...",
    "none",
    [],
    [
      ("lead_them",[],"...convince them to follow you, promising riches and glory.",
       [
           (party_add_members, "p_main_party", "trp_farmer", 5),
           (change_screen_return),
        ]
       ),
      ("let_them_go",[],"...wish them good luck and go the other way.",
       [
           (change_screen_return),
        ]
       ),
      ("tutorial_cheat",[(eq,1,0)],"CHEAT!",[(change_screen_return),
                                     (assign, "$cheat_mode", 1),
                                     (add_xp_to_troop, 15000, "trp_player"),
                                     (troop_raise_skill, "trp_player", skl_leadership, 7),
                                     (troop_raise_skill, "trp_player", skl_prisoner_management, 5),
                                     (party_add_members, "p_main_party", "trp_wei_heavy_cavalry", 10),
                                     (party_add_members, "p_main_party", "trp_shu_armed_horseman_elite", 10),
                                     (party_add_members, "p_main_party", "trp_shu_archer_troop", 10),
                                     (party_add_members, "p_main_party", "trp_wei_heavy_bow_archer", 10),
#                                     (troop_add_item, "trp_player","itm_surcoat_over_mail",0),
#                                     (troop_add_item, "trp_player","itm_byrnie",0),
#                                         (troop_add_item, "trp_player","itm_nobleman_outfit",0),
#                                    (troop_add_item, "trp_player","itm_ragged_outfit",0),
#                                    (troop_add_item, "trp_player","itm_mail_with_surcoat",0),
#                                     (troop_add_item, "trp_player","itm_lady_dress_green",0),
#                                      (troop_add_item, "trp_player","itm_peasant_dress",0),
    #                                 (troop_add_item, "trp_player","itm_turret_hat_blue",0),
#                                     (troop_add_item, "trp_player","itm_wimple_with_veil",0), 
#                                     (troop_add_item, "trp_player","itm_wimple_a",0),
 
#                                     (troop_add_item, "trp_player","itm_ankle_boots",0),
#                                    (troop_add_item, "trp_player","itm_norman_helmet",0),                                    
#                                    (troop_add_item, "trp_player","itm_torch",0),
#                                     (troop_add_item, "trp_player","itm_sword_medieval_a",0),
#                                     (troop_add_item, "trp_player","itm_sword_medieval_b",0),
#                                     (troop_add_item, "trp_player","itm_sword_medieval_c",0),
#                                     (troop_add_item, "trp_player","itm_sword_medieval_d",0),
#                                     (troop_add_item, "trp_player","itm_sword_medieval_e",0),

#                                     (troop_add_item, "trp_player","itm_sword_viking_a",0),
#                                     (troop_add_item, "trp_player","itm_sword_viking_b",0),
#                                     (troop_add_item, "trp_player","itm_sword_viking_c",0),


                                     (try_for_range, ":cur_place", scenes_begin, scenes_end),
                                       (scene_set_slot, ":cur_place", slot_scene_visited, 1),
                                     (try_end)]),
    ]
  ),
# This needs to be the third window!!!  
  (
    "start_game_3",0,
    "Choose scenario",
    "none",
    [],
    [
      ("custom_battle_scenario_1",[], "Skirmish 1",
       [
           (assign, "$g_custom_battle_scenario", 0),
           (jump_to_menu, "mnu_custom_battle_2"),

        ]
       ),
##      ("custom_battle_scenario_2",[],"Siege Attack 1",
##       [
##           (assign, "$g_custom_battle_scenario", 1),
##           (jump_to_menu, "mnu_custom_battle_2"),
##
##        ]
##       ),
      ("custom_battle_scenario_3",[],"Skirmish 2",
       [
           (assign, "$g_custom_battle_scenario", 2),
           (jump_to_menu, "mnu_custom_battle_2"),

        ]
       ),
       ("custom_battle_scenario_4",[],"Siege Defense 1",
       [
           (assign, "$g_custom_battle_scenario", 3),
           (jump_to_menu, "mnu_custom_battle_2"),
        ]
       ),
       ("custom_battle_scenario_5",[],"Skirmish 3",
       [
           (assign, "$g_custom_battle_scenario", 4),
           (jump_to_menu, "mnu_custom_battle_2"),
        ]
       ),
      ("custom_battle_scenario_6",[],"Siege Attack 1",
       [
           (assign, "$g_custom_battle_scenario", 5),
           (jump_to_menu, "mnu_custom_battle_2"),

        ]
       ),
      ("go_back",[],"Go back",
       [(change_screen_quit),
        ]
       ),
    ]
  ),

# This needs to be the fourth window!!!  
  (
    "training_ground",0,
    "You approach a field where locals are training with weapons. You can practice here to improve your combat skills.",
    "none",
    [(set_passage_menu, "mnu_training_ground"),
     (try_begin),
       (eq, "$tutorial_1_finished", 1),
       (str_store_string, s1, "str_finished"),
     (else_try),
       (str_store_string, s1, "str_empty_string"),
     (try_end),
     (try_begin),
       (eq, "$tutorial_2_finished", 1),
       (str_store_string, s2, "str_finished"),
     (else_try),
       (str_store_string, s2, "str_empty_string"),
     (try_end),
     (try_begin),
       (eq, "$tutorial_3_finished", 1),
       (str_store_string, s3, "str_finished"),
     (else_try),
       (str_store_string, s3, "str_empty_string"),
     (try_end),
     (try_begin),
       (eq, "$tutorial_4_finished", 1),
       (str_store_string, s4, "str_finished"),
     (else_try),
       (str_store_string, s4, "str_empty_string"),
     (try_end),
     (try_begin),
       (eq, "$tutorial_5_finished", 1),
       (str_store_string, s5, "str_finished"),
     (else_try),
       (str_store_string, s5, "str_empty_string"),
     (try_end),
        ],
    [
      ("tutorial_1",[],"Tutorial #1: Basic movement and weapon selection. {s1}",[
           (modify_visitors_at_site,"scn_tutorial_1"),(reset_visitors,0),
           (set_jump_mission,"mt_tutorial_1"),
           (jump_to_scene,"scn_tutorial_1"),(change_screen_mission)]),
      ("tutorial_2",[],"Tutorial #2: Fighting with a shield. {s2}",[
           (modify_visitors_at_site,"scn_tutorial_2"),(reset_visitors,0),
           (set_visitor,1,"trp_tutorial_maceman"),
           (set_visitor,2,"trp_tutorial_archer"),
           (set_jump_mission,"mt_tutorial_2"),
           (jump_to_scene,"scn_tutorial_2"),(change_screen_mission)]),
      ("tutorial_3",[],"Tutorial #3: Fighting without a shield. {s3}",[
           (modify_visitors_at_site,"scn_tutorial_3"),(reset_visitors,0),
           (set_visitor,1,"trp_tutorial_maceman"),
           (set_visitor,2,"trp_tutorial_swordsman"),
           (set_jump_mission,"mt_tutorial_3"),
           (jump_to_scene,"scn_tutorial_3"),(change_screen_mission)]),
      ("tutorial_3b",[(eq,0,1)],"Tutorial 3 b",[(try_begin),
                                                  (ge, "$tutorial_3_state", 12),
                                                  (modify_visitors_at_site,"scn_tutorial_3"),(reset_visitors,0),
                                                  (set_visitor,1,"trp_tutorial_maceman"),
                                                  (set_visitor,2,"trp_tutorial_swordsman"),
                                                  (set_jump_mission,"mt_tutorial_3_2"),
                                                  (jump_to_scene,"scn_tutorial_3"),
                                                  (change_screen_mission),
                                                (else_try),
                                                  (display_message,"str_door_locked",0xFFFFAAAA),
                                                (try_end)], "next level"),
      ("tutorial_4",[],"Tutorial #4: Riding a horse. {s4}",[
           (modify_visitors_at_site,"scn_tutorial_4"),(reset_visitors,0),
           (set_jump_mission,"mt_tutorial_4"),
           (jump_to_scene,"scn_tutorial_4"),(change_screen_mission)]),
      ("tutorial_5",[(eq,1,0)],"Tutorial #5: Commanding a band of soldiers. {s5}",[
           (modify_visitors_at_site,"scn_tutorial_5"),(reset_visitors,0),
           (set_visitor,0,"trp_player"),
           (set_visitor,1,"trp_elite_shu_infantry"),
           (set_visitor,2,"trp_elite_shu_infantry"),
           (set_visitor,3,"trp_elite_shu_infantry"),
           (set_visitor,4,"trp_elite_shu_infantry"),
           (set_jump_mission,"mt_tutorial_5"),
           (jump_to_scene,"scn_tutorial_5"),(change_screen_mission)]),

      ("go_back_dot",[],"Go back.",
       [(change_screen_quit),
        ]
       ),
    ]
  ),

# This needs to be the fifth window!!!  
  ("reports",0,
   "Which report would you like to view?",
   "none",
   [],
    [
      ("view_morale_report",[],"View party morale report.",
       [(jump_to_menu, "mnu_morale_report"),
        ]
       ),
      ("view_character_report",[],"View character report.",
       [(jump_to_menu, "mnu_character_report"),
        ]
       ),
      ("view_party_size_report",[],"View party size report.",
       [(jump_to_menu, "mnu_party_size_report"),
        ]
       ),
      ("resume_travelling",[],"Resume travelling.",
       [(change_screen_return),
        ]
       ),
      ]
  ),
  
  (
    "custom_battle_2",0,
    "Battle is going to start. You'll have {reg5} troops against the enemy's {reg6}.",
    "none",
    [
     (assign, "$g_battle_result", 0),
     (assign, ":ally_count", 0),
     (assign, ":enemy_count", 0),

     (troop_clear_inventory, "trp_player"),
     (troop_raise_attribute, "trp_player", ca_strength, -1000),
     (troop_raise_attribute, "trp_player", ca_agility, -1000),
     (troop_raise_attribute, "trp_player", ca_charisma, -1000),
     (troop_raise_attribute, "trp_player", ca_intelligence, -1000),
     (troop_raise_skill, "trp_player", skl_shield, -1000),
     (troop_raise_skill, "trp_player", skl_athletics, -1000),
     (troop_raise_skill, "trp_player", skl_riding, -1000),
     (troop_raise_skill, "trp_player", skl_power_strike, -1000),
     (troop_raise_skill, "trp_player", skl_power_throw, -1000),
     (troop_raise_skill, "trp_player", skl_weapon_master, -1000),
     (troop_raise_skill, "trp_player", skl_horse_archery, -1000),
     (troop_raise_skill, "trp_player", skl_ironflesh, -1000),
     (troop_raise_proficiency_linear, "trp_player", wpt_one_handed_weapon, -10000),
     (troop_raise_proficiency_linear, "trp_player", wpt_two_handed_weapon, -10000),
     (troop_raise_proficiency_linear, "trp_player", wpt_polearm, -10000),
     (troop_raise_proficiency_linear, "trp_player", wpt_archery, -10000),
     (troop_raise_proficiency_linear, "trp_player", wpt_crossbow, -10000),
     (troop_raise_proficiency_linear, "trp_player", wpt_throwing, -10000),

     (reset_visitors),
##   Scene 1 Start "Shalow Lake War"
     (try_begin),
       (eq, "$g_custom_battle_scenario", 0),

       (troop_raise_attribute, "trp_player", ca_strength, 12),
       (troop_raise_attribute, "trp_player", ca_agility, 6),
       (troop_raise_attribute, "trp_player", ca_charisma, 5),
       (troop_raise_attribute, "trp_player", ca_intelligence, 5),
       (troop_raise_skill, "trp_player", skl_ironflesh, 5),
       (troop_raise_skill, "trp_player", skl_shield, 2),
       (troop_raise_skill, "trp_player", skl_athletics, 2),
       (troop_raise_skill, "trp_player", skl_power_draw, 5),
       (troop_raise_skill, "trp_player", skl_power_strike, 4),
       (troop_raise_skill, "trp_player", skl_weapon_master, 3),
       (troop_raise_skill, "trp_player", skl_riding, 3),
       (troop_raise_skill, "trp_player", skl_horse_archery, 3),
       (troop_raise_proficiency_linear, "trp_player", wpt_one_handed_weapon, 120),
       (troop_raise_proficiency_linear, "trp_player", wpt_two_handed_weapon, 40),
       (troop_raise_proficiency_linear, "trp_player", wpt_polearm, 30),
       (troop_raise_proficiency_linear, "trp_player", wpt_archery, 170),
       (troop_raise_proficiency_linear, "trp_player", wpt_crossbow, 20),
       (troop_raise_proficiency_linear, "trp_player", wpt_throwing, 20),
     
       (assign, "$g_custom_battle_scene", "scn_quick_battle_1"),
       (modify_visitors_at_site, "$g_custom_battle_scene"),
       (set_visitor, 0, "trp_player"),

#       (troop_add_item, "trp_player","itm_bascinet",0),
#       (troop_add_item, "trp_player","itm_mail_with_surcoat",0),
#       (troop_add_item, "trp_player","itm_bastard_sword",0),
#       (troop_add_item, "trp_player","itm_war_bow",0),
#       (troop_add_item, "trp_player","itm_khergit_arrows",0),
#       (troop_add_item, "trp_player","itm_kite_shield",0),
#       (troop_add_item, "trp_player","itm_hunter",0),
       (troop_equip_items, "trp_player"),
     
       (set_visitors, 1, "trp_farmer", 6),
       (set_visitors, 2, "trp_wei_elite_footman", 5),
       (set_visitors, 3, "trp_wei_heavy_bow_archer", 4),
       (set_visitors, 4, "trp_wei_horse_solider", 8),
       (set_visitors, 5, "trp_wei_heavy_cavalry", 3),
       (assign, ":ally_count", 27),
     
##     Enemy
       (set_visitors, 16, "trp_elite_shu_infantry", 6),
       (set_visitors, 17, "trp_shu_archer_troop", 6),
       (set_visitors, 18, "trp_shu_horseman", 4),
       (set_visitors, 19, "trp_shu_armed_horseman_elite", 10),
       (set_visitors, 20, "trp_elite_shu_infantry", 6),
       (assign, ":enemy_count", 32),

##   SCENE 2 Start "Steppe Castle Destruction"
     (else_try),
       (eq, "$g_custom_battle_scenario", 1),

       (troop_raise_attribute, "trp_player", ca_strength, 8),
       (troop_raise_attribute, "trp_player", ca_agility, 8),
       (troop_raise_attribute, "trp_player", ca_charisma, 5),
       (troop_raise_attribute, "trp_player", ca_intelligence, 5),
       (troop_raise_skill, "trp_player", skl_ironflesh, 5),
       (troop_raise_skill, "trp_player", skl_shield, 2),
       (troop_raise_skill, "trp_player", skl_athletics, 2),
       (troop_raise_skill, "trp_player", skl_riding, 4),
       (troop_raise_skill, "trp_player", skl_power_strike, 3),
       (troop_raise_skill, "trp_player", skl_power_draw, 3),
       (troop_raise_skill, "trp_player", skl_weapon_master, 2),
       (troop_raise_skill, "trp_player", skl_horse_archery, 2),
       (troop_raise_proficiency_linear, "trp_player", wpt_one_handed_weapon, 80),
       (troop_raise_proficiency_linear, "trp_player", wpt_two_handed_weapon, 30),
       (troop_raise_proficiency_linear, "trp_player", wpt_polearm, 20),
       (troop_raise_proficiency_linear, "trp_player", wpt_archery, 30),
       (troop_raise_proficiency_linear, "trp_player", wpt_crossbow, 100),
       (troop_raise_proficiency_linear, "trp_player", wpt_throwing, 10),
     
       (assign, "$g_custom_battle_scene", "scn_quick_battle_2"),
       (modify_visitors_at_site, "$g_custom_battle_scene"),
       (set_visitor, 0, "trp_player"),
#       (troop_add_item, "trp_player","itm_bascinet",0),
#       (troop_add_item, "trp_player","itm_mail_with_surcoat",0),
#       (troop_add_item, "trp_player","itm_nordic_sword",0),
#       (troop_add_item, "trp_player","itm_heavy_crossbow",0),
#       (troop_add_item, "trp_player","itm_steel_bolts",0),
#       (troop_add_item, "trp_player","itm_iron_greaves",0),
#       (troop_add_item, "trp_player","itm_hunter",0),
       (troop_equip_items, "trp_player"),
       (set_visitors, 1, "trp_wei_elite_archer", 2),
       (set_visitors, 2, "trp_wei_elite_footman", 2),
       (set_visitors, 4, "trp_wei_footman", 8),
       (set_visitors, 5, "trp_wei_solider", 4),
       (set_visitors, 6, "trp_wei_solider", 2),
       (set_visitors, 3, "trp_wei_heavy_bow_archer", 2),
       (assign, ":ally_count", 21),

##     Enemy
       (set_visitors, 16, "trp_elite_shu_infantry", 1),
       (set_visitors, 17, "trp_shu_archer_troop", 4),
       (set_visitors, 18, "trp_elite_shu_infantry", 5),
       (set_visitors, 19, "trp_elite_shu_infantry", 4),
       (set_visitors, 20, "trp_yuan_rong_crossbowman", 3),
       (set_visitors, 21, "trp_shu_youth", 4),
       (set_visitors, 22, "trp_shu_archer_troop", 4),
       (set_visitors, 23, "trp_elite_shu_infantry", 3),
       (assign, ":enemy_count", 28),
     
##   SCENE 3 Start "Mountain Bandit Hunt"
     (else_try),
       (eq, "$g_custom_battle_scenario", 2),

       (troop_raise_attribute, "trp_player", ca_strength, 8),
       (troop_raise_attribute, "trp_player", ca_agility, 8),
       (troop_raise_attribute, "trp_player", ca_charisma, 5),
       (troop_raise_attribute, "trp_player", ca_intelligence, 5),
       (troop_raise_skill, "trp_player", skl_shield, 2),
       (troop_raise_skill, "trp_player", skl_athletics, 2),
       (troop_raise_skill, "trp_player", skl_riding, 4),
       (troop_raise_skill, "trp_player", skl_power_strike, 2),
       (troop_raise_skill, "trp_player", skl_power_throw, 5),
       (troop_raise_skill, "trp_player", skl_weapon_master, 2),
       (troop_raise_skill, "trp_player", skl_horse_archery, 2),
       (troop_raise_skill, "trp_player", skl_ironflesh, 5),
       (troop_raise_proficiency_linear, "trp_player", wpt_one_handed_weapon, 105),
       (troop_raise_proficiency_linear, "trp_player", wpt_two_handed_weapon, 30),
       (troop_raise_proficiency_linear, "trp_player", wpt_polearm, 20),
       (troop_raise_proficiency_linear, "trp_player", wpt_archery, 20),
       (troop_raise_proficiency_linear, "trp_player", wpt_crossbow, 10),
       (troop_raise_proficiency_linear, "trp_player", wpt_throwing, 220),
     
       (assign, "$g_custom_battle_scene", "scn_quick_battle_3"),
       (modify_visitors_at_site, "$g_custom_battle_scene"),
       (set_visitor, 0, "trp_player"),
#   Player Wear
#       (troop_add_item, "trp_player","itm_flat_topped_helmet",0),
#       (troop_add_item, "trp_player","itm_brigandine_a",0),
#       (troop_add_item, "trp_player","itm_military_pick",0),
#       (troop_add_item, "trp_player","itm_iron_greaves",0),
#       (troop_add_item, "trp_player","itm_steppe_horse",0),
#       (troop_add_item, "trp_player","itm_nomad_boots",0),
#       (troop_add_item, "trp_player","itm_shield_round_e",0),
#       (troop_add_item, "trp_player","itm_javelin",0),
#       (troop_add_item, "trp_player","itm_fighting_axe",0),
#
       (troop_equip_items, "trp_player"),
     
       (set_visitors, 1, "trp_shu_archer_troop", 4),
       (set_visitors, 2, "trp_shu_archer_troop", 5),
       (set_visitors, 3, "trp_shu_infantry", 4),
       (set_visitors, 4, "trp_shu_horseman", 4),
       (set_visitors, 5, "trp_shu_solider", 2),
       (set_visitors, 6, "trp_shu_armed_horseman_elite", 4),
       (assign, ":ally_count", 24),
## ENEMY
     
       (set_visitors, 16, "trp_mountain_bandit2", 4),
       (set_visitors, 17, "trp_mountain_bandit1", 8),
       (set_visitors, 18, "trp_mountain_bandit2", 8),
       (set_visitors, 19, "trp_mountain_bandit2", 6),
       (set_visitors, 20, "trp_mountain_bandit4", 5),
       (set_visitors, 21, "trp_mountain_bandit2", 4),
       (set_visitors, 22, "trp_robber", 6),
       (set_visitors, 23, "trp_mountain_bandit4", 8),
       (set_visitors, 25, "trp_robber", 10),
       (assign, ":enemy_count", 59),

##   SCENE 4 Start "Grand Stand"
     (else_try),
       (eq, "$g_custom_battle_scenario", 3),

       (troop_raise_attribute, "trp_player", ca_strength, 12),
       (troop_raise_attribute, "trp_player", ca_agility, 9),
       (troop_raise_attribute, "trp_player", ca_charisma, 5),
       (troop_raise_attribute, "trp_player", ca_intelligence, 5),
       (troop_raise_skill, "trp_player", skl_shield, 3),
       (troop_raise_skill, "trp_player", skl_athletics, 2),
       (troop_raise_skill, "trp_player", skl_riding, 3),
       (troop_raise_skill, "trp_player", skl_power_strike, 4),
       (troop_raise_skill, "trp_player", skl_power_draw, 5),
       (troop_raise_skill, "trp_player", skl_weapon_master, 4),    
       (troop_raise_skill, "trp_player", skl_ironflesh, 6),
       (troop_raise_proficiency_linear, "trp_player", wpt_one_handed_weapon, 200),
       (troop_raise_proficiency_linear, "trp_player", wpt_two_handed_weapon, 30),
       (troop_raise_proficiency_linear, "trp_player", wpt_polearm, 20),
       (troop_raise_proficiency_linear, "trp_player", wpt_archery, 260),
       (troop_raise_proficiency_linear, "trp_player", wpt_crossbow, 10),
       (troop_raise_proficiency_linear, "trp_player", wpt_throwing, 10),
     
       (assign, "$g_custom_battle_scene", "scn_quick_battle_4"),
       (modify_visitors_at_site, "$g_custom_battle_scene"),
       (set_visitor, 0, "trp_player"),
     
#       (troop_add_item, "trp_player","itm_helmet_with_neckguard",0),
#       (troop_add_item, "trp_player","itm_plate_armor",0),
#       (troop_add_item, "trp_player","itm_one_handed_battle_axe",0),
#       (troop_add_item, "trp_player","itm_iron_greaves",0),
#       (troop_add_item, "trp_player","itm_mail_chausses",0),
#       (troop_add_item, "trp_player","itm_shield_round_e",0),
#       (troop_add_item, "trp_player","itm_strong_bow",0),
#       (troop_add_item, "trp_player","itm_khergit_arrows",0),
       (troop_equip_items, "trp_player"),
## US     
       (set_visitors, 1, "trp_elite_shu_infantry", 4),
       (set_visitors, 2, "trp_shu_archer_troop", 3),
       (set_visitors, 3, "trp_elite_shu_infantry", 6),
       (set_visitors, 4, "trp_shu_archer_troop", 4),
       (set_visitors, 5, "trp_elite_shu_infantry", 3),
       (set_visitors, 6, "trp_shu_solider", 6),
       (set_visitors, 7, "trp_shu_solider", 4),
       (set_visitors, 8, "trp_shu_archer_troop", 2),
       (assign, ":ally_count", 33),

## ENEMY
       (set_visitors, 16, "trp_wei_footman", 8),
       (set_visitors, 17, "trp_wei_footman", 8),
       (set_visitors, 18, "trp_wei_elite_footman", 6),
       (set_visitors, 19, "trp_wei_heavy_bow_archer", 8),
       (set_visitors, 20, "trp_wei_solider", 8),
       (assign, ":enemy_count", 38),
     
##   Scene 5 START
     (else_try),
       (eq, "$g_custom_battle_scenario", 4),

       (troop_raise_attribute, "trp_player", ca_strength, 10),
       (troop_raise_attribute, "trp_player", ca_agility, 8),
       (troop_raise_attribute, "trp_player", ca_charisma, 5),
       (troop_raise_attribute, "trp_player", ca_intelligence, 5),
       (troop_raise_skill, "trp_player", skl_shield, 3),
       (troop_raise_skill, "trp_player", skl_athletics, 1),
       (troop_raise_skill, "trp_player", skl_riding, 4),
       (troop_raise_skill, "trp_player", skl_power_strike, 4),
       (troop_raise_skill, "trp_player", skl_power_draw, 1),
       (troop_raise_skill, "trp_player", skl_weapon_master, 3),    
       (troop_raise_skill, "trp_player", skl_ironflesh, 6),
       (troop_raise_proficiency_linear, "trp_player", wpt_one_handed_weapon, 80),
       (troop_raise_proficiency_linear, "trp_player", wpt_two_handed_weapon, 50),
       (troop_raise_proficiency_linear, "trp_player", wpt_polearm, 150),
       (troop_raise_proficiency_linear, "trp_player", wpt_archery, 10),
       (troop_raise_proficiency_linear, "trp_player", wpt_crossbow, 20),
       (troop_raise_proficiency_linear, "trp_player", wpt_throwing, 60),
     
       (assign, "$g_custom_battle_scene", "scn_quick_battle_5"),
       (modify_visitors_at_site, "$g_custom_battle_scene"),
       (set_visitor, 0, "trp_player"),
     
#       (troop_add_item, "trp_player","itm_helmet_with_neckguard",0),
#       (troop_add_item, "trp_player","itm_plate_armor",0),
#       (troop_add_item, "trp_player","itm_nordic_sword",0),
#       (troop_add_item, "trp_player","itm_iron_greaves",0),
#       (troop_add_item, "trp_player","itm_mail_chausses",0),
#       (troop_add_item, "trp_player","itm_shield_round_e",0),
#       (troop_add_item, "trp_player","itm_great_lance",0),
#       (troop_add_item, "trp_player","itm_warhorse",0),
       (troop_equip_items, "trp_player"),
## US     
       (val_add, ":ally_count", 1),
       (set_visitors, 1, "trp_wei_heavy_cavalry", 3),
       (set_visitors, 2, "trp_wei_elite_footman", 4),
       (set_visitors, 3, "trp_wei_heavy_bow_archer", 8),
       (set_visitors, 4, "trp_wei_horse_solider", 8),
       (set_visitors, 5, "trp_wei_heavy_cavalry", 2),
       (assign, ":ally_count", 26),
     
##     enemy
       (set_visitors, 16, "trp_elite_shu_infantry", 8),
       (set_visitors, 17, "trp_shu_archer_troop", 10),
       (set_visitors, 18, "trp_shu_horseman", 4),
       (set_visitors, 19, "trp_shu_armed_horseman_elite", 10),
       (set_visitors, 20, "trp_elite_shu_infantry", 7),
       (assign, ":enemy_count", 39),
     (else_try),
       (eq, "$g_custom_battle_scenario", 5),

       (assign, "$g_custom_battle_scene", "scn_quick_battle_6"),
#   Player Wear
       (set_player_troop, "trp_quick_battle_6_player"),
       (assign, "$g_player_troop", "trp_quick_battle_6_player"),
#
       (troop_equip_items, "trp_player"),
     
       (modify_visitors_at_site, "$g_custom_battle_scene"),
       (set_visitor, 0, "$g_player_troop"),

       (set_visitors, 1, "trp_shu_archer_troop", 8),
       (set_visitors, 2, "trp_shu_archer_troop", 8),
       (set_visitors, 3, "trp_shu_infantry", 10),
       (set_visitors, 4, "trp_shu_horseman", 10),
       (set_visitors, 5, "trp_shu_solider", 10),
       (assign, ":ally_count", 46),
## ENEMY
     
       (set_visitors, 8, "trp_shu_solider", 10),
       (set_visitors, 9, "trp_shu_solider", 10),
       (set_visitors, 10, "trp_shu_solider", 10),
       (assign, ":enemy_count", 30),
     (try_end),
     (assign, reg5, ":ally_count"),
     (assign, reg6, ":enemy_count"),
     ],
    
    [
      ("custom_battle_go",[],"Start.",
       [(try_begin),
          (eq, "$g_custom_battle_scenario", 1),
          (assign, "$defender_team", 1),
          (assign, "$attacker_team", 0),
          (assign, "$attacker_reinforcement_stage",3),
          (set_jump_mission,"mt_custom_battle_siege"),
        (else_try),
          (eq, "$g_custom_battle_scenario", 3),
          (assign, "$defender_team", 0),
          (assign, "$attacker_team", 1),
          (assign, "$attacker_reinforcement_stage",3),
          (set_jump_mission,"mt_custom_battle_siege"),
        (else_try),
          (eq, "$g_custom_battle_scenario", 5),
          (set_jump_mission,"mt_custom_battle_5"),
        (else_try),
          (set_jump_mission,"mt_custom_battle"),
        (try_end),
        (jump_to_menu, "mnu_custom_battle_end"),
        (jump_to_scene,"$g_custom_battle_scene"),
        (change_screen_mission),
        ]
       ),
      ("leave_custom_battle_2",[],"Cancel.",
       [(jump_to_menu, "mnu_start_game_3"),
        ]
       ),
    ]
  ),


  (
    "custom_battle_end",0,
    "Battle is over. {s1} Your party killed {reg5} troops, enemy party killed {reg6} troops. You have killed {reg7} troops.",
    "none",
    [(assign, reg5, "$g_custom_battle_team2_death_count"),
     (assign, reg6, "$g_custom_battle_team1_death_count"),
     (get_player_agent_kill_count, ":kill_count"),
     (get_player_agent_kill_count, ":wound_count", 1),
     (store_add, reg7, ":kill_count", ":wound_count"),
     (try_begin),
       (eq, "$g_battle_result", 1),
       (str_store_string, s1, "str_battle_won"),
     (else_try),
       (str_store_string, s1, "str_battle_lost"),
     (try_end),],
    [
      ("continue",[],"Continue.",
       [(change_screen_quit),
        ]
       ),
    ]
  ),
  (
    "start_game_2",0,
    "In this troublous era, you must use your weapon to keep alive. What kind of weapon do you focus on?",
    "none",
    [],
    [
      ("one_hand_weapon",[],"One hand weapon",[
        (troop_raise_attribute, "trp_player",ca_strength,2),
        (troop_raise_attribute, "trp_player",ca_agility,3),
        (troop_raise_skill, "trp_player",skl_ironflesh,1),
        (troop_raise_skill, "trp_player",skl_weapon_master,1),
        (troop_raise_skill, "trp_player",skl_power_strike,1),
        (troop_raise_skill, "trp_player",skl_shield,1),
        (troop_raise_proficiency, "trp_player",0,60),
        (troop_raise_proficiency, "trp_player",1,30),
        (troop_add_item, "trp_player","itm_china_25huanshou",imod_rusty),
        (troop_add_item, "trp_player","itm_wooden_shield",0),
        (jump_to_menu, "mnu_choose_skill"),
        ]),
      ("two_hand_weapon",[],"Two hand weapon",[
        (troop_raise_attribute, "trp_player",ca_strength,3),
        (troop_raise_attribute, "trp_player",ca_agility,2),
        (troop_raise_skill, "trp_player",skl_weapon_master,1),
        (troop_raise_skill, "trp_player",skl_ironflesh,1),
        (troop_raise_skill, "trp_player",skl_power_strike,2),
        (troop_raise_proficiency, "trp_player",0,30),
        (troop_raise_proficiency, "trp_player",1,60),
        (troop_add_item, "trp_player","itm_china_s100huan",imod_rusty),
        (jump_to_menu, "mnu_choose_skill"),
        ]),
      ("ranged_weapon",[],"Ranged_Weapon",[
        (troop_raise_attribute, "trp_player",ca_strength,3),
        (troop_raise_attribute, "trp_player",ca_agility,2),
        (troop_raise_skill, "trp_player",skl_power_draw,3),
        (troop_raise_skill, "trp_player",skl_weapon_master,1),
        (troop_raise_proficiency, "trp_player",3,45),
        (troop_raise_proficiency, "trp_player",4,45),
        (troop_add_item, "trp_player","itm_hunting_bow",0),
        (troop_add_item, "trp_player","itm_arrows",0),
        (jump_to_menu, "mnu_choose_skill"),
        ]),
      ("throw_weapon",[],"Throw_Weapon",[
        (troop_raise_attribute, "trp_player",ca_strength,3),
        (troop_raise_attribute, "trp_player",ca_agility,2),
        (troop_raise_skill, "trp_player",skl_power_throw,3),
        (troop_raise_skill, "trp_player",skl_weapon_master,1),
        (troop_raise_proficiency, "trp_player",5,90),
        (troop_add_item, "trp_player","itm_jarid",0),
        (troop_add_item, "trp_player","itm_jarid",0),
        (jump_to_menu, "mnu_choose_skill"),
        ]),
      ("go_back_dot",[],"Go back.",[(jump_to_menu, "mnu_start_game_1"),]),
    ]
  ),

(
    "choose_skill",0,
    "Skill keeps your life more comfortable. What kind of skill do you focus on?",
    "none",
    [],
    [
      ("riding",[],"Riding",[
        (troop_raise_attribute, "trp_player",ca_agility,3),
        (troop_raise_skill, "trp_player",skl_riding,2),
        (troop_raise_skill, "trp_player",skl_pathfinding,2),
        (troop_raise_skill, "trp_player",skl_horse_archery,1),
        (assign,"$wuguan",1),
        (jump_to_menu, "mnu_choose_path"),
        ]),
      ("medicine",[],"Medicine",[
        (troop_raise_attribute, "trp_player",ca_intelligence,2),
        (troop_raise_attribute, "trp_player",ca_charisma,1),
        (troop_raise_skill, "trp_player",skl_surgery,2),
        (troop_raise_skill, "trp_player",skl_wound_treatment,2),
        (troop_raise_skill, "trp_player",skl_first_aid,1),
        (assign,"$wenguan",1),
        (jump_to_menu, "mnu_choose_path"),
        ]),
      ("tactics",[],"Tactics",[
        (troop_raise_attribute, "trp_player",ca_intelligence,3),
        (troop_raise_skill, "trp_player",skl_tactics,2),
        (troop_raise_skill, "trp_player",skl_stratagem,2),
        (troop_raise_skill, "trp_player",skl_trainer,1),
        (assign,"$wenguan",1),
        (jump_to_menu, "mnu_choose_path"),
        ]),
      ("leadership",[],"Leadership",[
        (troop_raise_attribute, "trp_player",ca_charisma,3),
        (troop_raise_skill, "trp_player",skl_leadership,2),
        (troop_raise_skill, "trp_player",skl_trade,2),
        (troop_raise_skill, "trp_player",skl_prisoner_management,1),
        (assign,"$wuguan",1),
        (jump_to_menu, "mnu_choose_path"),
        ]),
      
    ]
  ),

(
    "choose_path",0,
    "Your will lead your path. What kind of path do you focus on?",
    "none",
    [],
    [
      ("yongwu",[],"Path of fight",[
        (assign,"$yongwu",1),
        (jump_to_menu, "mnu_end_choose"),
        ]),
      ("yunchou",[],"Path of stratagem",[
        (assign,"$yunchou",1),
        (jump_to_menu, "mnu_end_choose"),
        ]),
      ("shengwang",[],"Path of frame",[
        (assign,"$shengwang",1),
        (jump_to_menu, "mnu_end_choose"),
        ]),
      ("tongshuai",[],"Path of leadership",[
        (assign,"$tongshuai",1),
        (jump_to_menu, "mnu_end_choose"),
        ]),
      
    ]
  ),

(
    "end_choose",0,
    "You must face your choice",
    "none",
    [],
    [("continue",[],"Continue.",[(troop_add_item, "trp_player","itm_sumpter_horse",0),(troop_add_item, "trp_player","itm_mianpao",0),(troop_add_item, "trp_player","itm_caoshoes",0),(troop_add_item, "trp_player","itm_banaxe",imod_rusty),(troop_add_item, "trp_player","itm_cabbages",0),(assign,"$can_feat",3),(change_screen_return,0),]),]
),

#Feat menus
(
    "choose_feat",0,
    "You have reach a new level, you have a chance to choose a new feat",
    "none",
    [],
    [("one_hand_proficiency",[(eq,"$know_one",0)],"One handed weapon proficiency",[
        (troop_raise_proficiency, "trp_player",0,50),
        (assign,"$know_one",1),
        (change_screen_return,0),
        ]),
     ("two_hand_proficiency",[(eq,"$know_two",0)],"Two handed weapon proficiency",[
        (troop_raise_proficiency, "trp_player",1,50),
        (assign,"$know_two",1),
        (change_screen_return,0),
        ]),
     ("ranged_proficiency",[(eq,"$know_ran",0)],"Ranged weapon proficiency",[
        (troop_raise_proficiency, "trp_player",3,30),
        (troop_raise_proficiency, "trp_player",4,30),
        (assign,"$know_ran",1),
        (change_screen_return,0),
        ]),
     ("throw_proficiency",[(eq,"$know_thr",0)],"Throwing weapon proficiency",[
        (troop_raise_proficiency, "trp_player",5,50),
        (assign,"$know_thr",1),
        (change_screen_return,0),
        ]),
     ("one_hand_proficiency_2",[(eq,"$know_one",1),(ge,"$ply_lv",12)],"One handed weapon proficiency_2",[
        (troop_raise_proficiency, "trp_player",0,80),
        (troop_raise_attribute, "trp_player",ca_strength,2),
        (assign,"$know_one",2),
        (change_screen_return,0),
        ]),
     ("two_hand_proficiency_2",[(eq,"$know_two",1),(ge,"$ply_lv",12)],"Two handed weapon proficiency_2",[
        (troop_raise_proficiency, "trp_player",1,80),
        (troop_raise_attribute, "trp_player",ca_strength,2),
        (assign,"$know_two",2),
        (change_screen_return,0),
        ]),
     ("ranged_proficiency_2",[(eq,"$know_ran",1),(ge,"$ply_lv",12)],"Ranged weapon proficiency_2",[
        (troop_raise_proficiency, "trp_player",3,60),
        (troop_raise_proficiency, "trp_player",4,60),
        (troop_raise_attribute, "trp_player",ca_strength,2),
        (assign,"$know_ran",2),
        (change_screen_return,0),
        ]),
     ("throw_proficiency_2",[(eq,"$know_thr",1),(ge,"$ply_lv",12)],"Throwing weapon proficiency_2",[
        (troop_raise_proficiency, "trp_player",5,80),
        (troop_raise_attribute, "trp_player",ca_strength,2),
        (assign,"$know_thr",2),
        (change_screen_return,0),
        ]),
     ("one_hand_proficiency_3",[(eq,"$yongwu",1),(eq,"$know_one",2),(ge,"$ply_lv",18)],"One handed weapon proficiency_3",[
        (troop_raise_proficiency, "trp_player",0,100),
        (troop_raise_attribute, "trp_player",ca_strength,1),
        (troop_raise_skill, "trp_player",skl_power_strike,1),
        (troop_raise_skill, "trp_player",skl_weapon_master,1),
        (assign,"$know_one",3),
        (change_screen_return,0),
        ]),
     ("two_hand_proficiency_3",[(eq,"$yongwu",1),(eq,"$know_two",2),(ge,"$ply_lv",18)],"Two handed weapon proficiency_3",[
        (troop_raise_proficiency, "trp_player",1,100),
        (troop_raise_attribute, "trp_player",ca_strength,1),
        (troop_raise_skill, "trp_player",skl_power_strike,1),
        (troop_raise_skill, "trp_player",skl_weapon_master,1),
        (assign,"$know_two",3),
        (change_screen_return,0),
        ]),
     ("ranged_proficiency_3",[(eq,"$yongwu",1),(eq,"$know_ran",2),(ge,"$ply_lv",18)],"Ranged weapon proficiency_3",[
        (troop_raise_proficiency, "trp_player",3,60),
        (troop_raise_proficiency, "trp_player",4,60),
        (troop_raise_attribute, "trp_player",ca_strength,1),
        (troop_raise_skill, "trp_player",skl_power_draw,1),
        (troop_raise_skill, "trp_player",skl_weapon_master,1),
        (assign,"$know_ran",3),
        (change_screen_return,0),
        ]),
     ("throw_proficiency_3",[(eq,"$yongwu",1),(eq,"$know_thr",2),(ge,"$ply_lv",18)],"Throwing weapon proficiency_3",[
        (troop_raise_proficiency, "trp_player",5,100),
        (troop_raise_attribute, "trp_player",ca_strength,1),
        (troop_raise_skill, "trp_player",skl_power_throw,1),
        (troop_raise_skill, "trp_player",skl_weapon_master,1),
        (assign,"$know_thr",3),
        (change_screen_return,0),
        ]),
     ("know_normal_armor",[(eq,"$know_na",0),(ge,"$ply_lv",6)],"Know normal armor",[
        (assign,"$know_na",1),
        (change_screen_return,0),
        ]),
     ("know_heavy_armor",[(eq,"$know_na",1),(eq,"$know_ha",0),(ge,"$ply_lv",15)],"Know heavy armor",[
        (assign,"$know_ha",1),
        (change_screen_return,0),
        ]),
     ("know_special_armor",[(eq,"$yongwu",1),(eq,"$know_ha",1),(eq,"$know_sa",0),(ge,"$ply_lv",24)],"Know special armor",[
        (assign,"$know_sa",1),
        (change_screen_return,0),
        ]),
     ("huoji_proficiency",[(eq,"$huoji",0),(ge,"$ply_lv",12)],"huoji proficiency",[
        (assign,"$huoji",1),
        (change_screen_return,0),
        ]),
     ("xianjing_proficiency",[(eq,"$xianjing",0),(ge,"$ply_lv",12)],"xianjing oficiency",[
        (assign,"$xianjing",1),
        (change_screen_return,0),
        ]),
     ("hunluan_proficiency",[(eq,"$hunluan",0),(ge,"$ply_lv",12)],"hunluan proficiency",[
        (assign,"$hunluan",1),
        (change_screen_return,0),
        ]),
     ("qixi_proficiency",[(eq,"$qixi",0),(ge,"$ply_lv",12)],"qixi proficiency",[
       (assign,"$qixi",1),
       (change_screen_return,0),
       ]),
     ("lianhuan_proficiency",[(eq,"$lianhuan",0),(ge,"$ply_lv",27),(eq,"$yunchou",1)],"lianhuan proficiency",[
       (assign,"$lianhuan",1),
       (change_screen_return,0),
       ]),
     ("frame_per_week",[(eq,"$fpw",0),(ge,"$ply_lv",9)],"frame_per_week",[
       (try_begin),
       (eq,"$shengwang",1),
       (assign,"$fpw",2),
       (else_try),
       (assign,"$fpw",1),
       (try_end),
       (change_screen_return,0),
       ]),
     ("save_frame",[(eq,"$sf",0),(ge,"$ply_lv",21)],"save_frame",[
       (try_begin),
       (eq,"$shengwang",1),
       (assign,"$sf",2),
       (else_try),
       (assign,"$sf",1),
       (try_end),
       (change_screen_return,0),
       ]),
     ("personality",[(eq,"$p_s",0),(ge,"$ply_lv",21)],"Personality",[
       (try_begin),
       (eq,"$shengwang",1),
       (assign,"$p_s",2),
       (else_try),
       (assign,"$p_s",1),
       (try_end),
       (change_screen_return,0),
       ]),
     ("get_captive",[(eq,"$gc",0),(ge,"$ply_lv",12)],"get captive",[
       (try_begin),
       (eq,"$tongshuai",1),
       (assign,"$gc",2),
       (else_try),
       (assign,"$gc",1),
       (try_end),
       (change_screen_return,0),
       ]),
     ("power_leadership",[(gt,"$ply_lv",17),(eq,"$tongshuai",1)],"Power leadership",[
       (troop_raise_skill, "trp_player",skl_tactics,2),
       (troop_raise_skill, "trp_player",skl_trainer,1),
       (change_screen_return,0),
       ]),
    ("huoji_proficiency_2",[(eq,"$huoji",1),(ge,"$ply_lv",24)],"huoji proficiency_2",[
        (assign,"$huoji",2),
        (change_screen_return,0),
        ]),
    ("xianjing_proficiency_2",[(eq,"$xianjing",1),(ge,"$ply_lv",24)],"xianjing oficiency_2",[
        (assign,"$xianjing",2),
        (change_screen_return,0),
        ]),
     ("hunluan_proficiency_2",[(eq,"$hunluan",1),(ge,"$ply_lv",24)],"hunluan proficiency_2",[
        (assign,"$hunluan",2),
        (change_screen_return,0),
        ]),
     ("qixi_proficiency_2",[(eq,"$qixi",1),(ge,"$ply_lv",24)],"qixi proficiency_2",[
       (assign,"$qixi",2),
       (change_screen_return,0),
       ]),
     ("lijian_proficiency",[(eq,"$lijian",0),(ge,"$ply_lv",12)],"lijian proficiency",[
        (assign,"$lijian",1),
        (change_screen_return,0),
       ]),
     ("lijian_proficiency_2",[(eq,"$lijian",1),(ge,"$ply_lv",24)],"hunluan proficiency_2",[
        (assign,"$lijian",2),
        (change_screen_return,0),
      ]),
     ("weibao_proficiency",[(eq,"$weibao",0),(ge,"$ply_lv",12)],"weibao proficiency",[
        (assign,"$weibao",1),
        (change_screen_return,0),
      ]),
     ("weibao_proficiency_2",[(eq,"$weibao",1),(ge,"$ply_lv",24)],"weibao proficiency_2",[
        (assign,"$weibao",2),
        (change_screen_return,0),
      ]),
    ("add_st",[(eq,"$add_st",0),(ge,"$ply_lv",21),(eq,"$yunchou",1)],"Add st",[
        (assign,"$add_st",1),
        (change_screen_return,0),
      ]),
    ("add_st_2",[(eq,"$add_st",1),(eq,"$yunchou",1),(ge,"$ply_lv",30)],"Add st 2",[
        (assign,"$add_st",2),
        (change_screen_return,0),
      ]),
    ("know_rider",[(eq,"$kn_r",0),(eq,"$tongshuai",1),(ge,"$ply_lv",15)],"Know Rider",[
                   (assign,"$kn_r",1),
                   (change_screen_return,0),
    ]),
    ("know_footman",[(eq,"$kn_f",0),(eq,"$tongshuai",1),(ge,"$ply_lv",15)],"Know Footman",[
                   (assign,"$kn_f",1),
                   (change_screen_return,0),
    ]),
    ("know_archer",[(eq,"$kn_a",0),(eq,"$tongshuai",1),(ge,"$ply_lv",15)],"Know Archer",[
                    (assign,"$kn_a",1),
                    (change_screen_return,0),
    ]),
    ("know_horsearcher",[(eq,"$kn_h",0),(eq,"$tongshuai",1),(ge,"$ply_lv",21)],"Know HorseArcher",[
                    (assign,"$kn_h",1),
                    (change_screen_return,0),
    ]),
     ("another_path",[(eq,"$ply_lv",30)],"Another path",[
                    (jump_to_menu, "mnu_choose_another_path"),
    ]),
    ("cancel",[],"Cancel",[(change_screen_return,0),]),
  ]),

 (
    "choose_another_path",0,
    "You have chance to choose another path",
    "none",
    [],
    [
      ("yongwu_1",[(neq,"$yongwu",1)],"Path of fight",[
        (assign,"$yongwu",1),
        (change_screen_return,0),
        ]),
      ("yunchou_1",[(neq,"$yunchou",1)],"Path of stratagem",[
        (assign,"$yunchou",1),
        (change_screen_return,0),
        ]),
      ("shengwang_1",[(neq,"$shengwang",1)],"Path of frame",[
        (assign,"$shengwang",1),
        (change_screen_return,0),
        ]),
      ("tongshuai_1",[(neq,"$tongshuai",1)],"Path of leadership",[
        (assign,"$tongshuai",1),
        (change_screen_return,0),
        ]),
      
    ]
   ),

  (
    "start_game_2_dis",0,
    "You are...",
    "none",
    [(assign, reg3, "$character_gender"),],
    [
      ("start_child_of_minor_noble",[],"{reg3?Daughter:Son} of a minor noble.",[
        (assign, "$background_type", 1),
        (jump_to_menu,"mnu_choose_skill"),
        ]),
      ("start_child_of_merchant",[],"{reg3?Daughter:Son} of a well-to-do merchant.",[
        (assign, "$background_type", 2),
        (jump_to_menu,"mnu_choose_skill"),
        ]),
      ("start_child_of_unknown_adventurer",[],"An unknown adventurer.",[
        (assign, "$background_type", 3),
        (jump_to_menu,"mnu_choose_skill"),
        ]),
      ("go_back_dot",[],"Go back.",[
        (jump_to_menu, "mnu_start_game_1"),
        ]),

##      ("start_squire",[(eq,"$character_gender",0)],"a squire",[
###        (assign,"$character_class",0),
##        (troop_raise_attribute, "trp_player",ca_strength,5),
##        (troop_raise_attribute, "trp_player",ca_agility,2),
##        (troop_raise_attribute, "trp_player",ca_charisma,1),
##        (troop_raise_skill, "trp_player",skl_ironflesh,2),
##        (troop_raise_skill, "trp_player",skl_weapon_master,2),
##        (troop_raise_skill, "trp_player",skl_power_strike,3),
##        (troop_raise_skill, "trp_player",skl_riding,1),
##        (troop_raise_skill, "trp_player",skl_tactics,1),
##        (troop_raise_skill, "trp_player",skl_shield,1),
##        (troop_raise_skill, "trp_player",skl_leadership,1),
##        (troop_raise_skill, "trp_player",skl_prisoner_management,1),
##        (troop_raise_proficiency, "trp_player",0,40),
##        (troop_raise_proficiency, "trp_player",1,40),
##        (troop_raise_proficiency, "trp_player",2,30),
##        (troop_raise_proficiency, "trp_player",5,20),
##        
##        (change_screen_return,0),
##        ]),
##      ("start_lady",[(eq,"$character_gender",1)],"a court lady",[
###        (assign,"$character_class",1),
##        (troop_raise_attribute, "trp_player",ca_strength,1),
##        (troop_raise_attribute, "trp_player",ca_agility,1),
##        (troop_raise_attribute, "trp_player",ca_intelligence,3),
##        (troop_raise_attribute, "trp_player",ca_charisma,3),
##        (troop_raise_skill, "trp_player","skl_weapon_master",1),
##        (troop_raise_skill, "trp_player","skl_riding",2),
##        (troop_raise_skill, "trp_player","skl_wound_treatment",2),
##        (troop_raise_skill, "trp_player","skl_first_aid",2),
##        (troop_raise_skill, "trp_player","skl_tactics",1),
##        (troop_raise_skill, "trp_player","skl_leadership",2),
##        (troop_raise_skill, "trp_player","skl_trade",2),
##        (troop_raise_proficiency, "trp_player",0,15),
##        (troop_raise_proficiency, "trp_player",4,10),
##        (troop_raise_proficiency, "trp_player",5,10),
##        (troop_add_item, "trp_player","itm_woolen_dress",imod_sturdy),
##        (troop_add_item, "trp_player","itm_dagger",imod_watered_steel),
##        (troop_add_item, "trp_player","itm_hunting_crossbow",0),
##        (troop_add_item, "trp_player","itm_bolts",0),
##        (troop_add_item, "trp_player","itm_leather_boots",0),
##        (troop_add_item, "trp_player","itm_smoked_fish",0),
##        (troop_add_item, "trp_player","itm_courser",imod_spirited),
##        [troop_add_gold, "trp_player", 35],
##        (change_screen_return,0),
##        ]),
##      ("start_hunter",[],"a hunter",[
###        (assign,"$character_class",2),
##        (troop_raise_attribute, "trp_player",ca_strength,3),
##        (troop_raise_attribute, "trp_player",ca_agility,4),
##        (troop_raise_attribute, "trp_player",ca_intelligence,1),
##        (troop_raise_skill, "trp_player",skl_athletics,3),
##        (troop_raise_skill, "trp_player",skl_power_draw,3),
##        (troop_raise_skill, "trp_player",skl_pathfinding,2),
##        (troop_raise_skill, "trp_player",skl_tracking,2),
##        (troop_raise_skill, "trp_player",skl_spotting,2),
##        (troop_raise_proficiency, "trp_player",3,70),
##        (troop_add_item, "trp_player","itm_hunting_bow",0),
##        (troop_add_item, "trp_player","itm_arrows",0),
##        (troop_add_item, "trp_player","itm_hatchet",0),
##        (troop_add_item, "trp_player","itm_rawhide_coat",0),
##        (troop_add_item, "trp_player","itm_hide_boots",0),
##        (troop_add_item, "trp_player","itm_dried_meat",0),
##        (troop_add_item, "trp_player","itm_sumpter_horse",0),
##        (troop_add_item, "trp_player","itm_furs",0),
##        [troop_add_gold, "trp_player", 35],
##        (change_screen_return,0),
##        ]),
##      ("start_priest",[(eq,"$character_gender",0)],"a novice priest",[
###        (assign,"$character_class",3),
##        (troop_raise_attribute, "trp_player",ca_strength,1),
##        (troop_raise_attribute, "trp_player",ca_agility,1),
##        (troop_raise_attribute, "trp_player",ca_intelligence,5),
##        (troop_raise_attribute, "trp_player",ca_charisma,1),
##        (troop_raise_skill, "trp_player",skl_ironflesh,2),
##        (troop_raise_skill, "trp_player",skl_wound_treatment,3),
##        (troop_raise_skill, "trp_player",skl_first_aid,3),
##        (troop_raise_skill, "trp_player",skl_leadership,2),
##        (troop_raise_skill, "trp_player",skl_surgery,2),
##        (troop_raise_proficiency, "trp_player",2,15),
##        (troop_add_item, "trp_player","itm_robe",0),
##        (troop_add_item, "trp_player","itm_staff",0),
##        (troop_add_item, "trp_player","itm_grain",0),
##        [troop_add_gold, "trp_player", 35],
##        (change_screen_return,0),
##        ]),
##      ("start_nun",[(eq,"$character_gender",1)],"a nun",[
###        (assign,"$character_class",4),
##        (troop_raise_attribute, "trp_player",ca_intelligence,6),
##        (troop_raise_attribute, "trp_player",ca_charisma,1),
##        (troop_raise_attribute, "trp_player",ca_agility,1),
##        (troop_raise_skill, "trp_player",skl_athletics,1),
##        (troop_raise_skill, "trp_player",skl_wound_treatment,4),
##        (troop_raise_skill, "trp_player",skl_first_aid,4),
##        (troop_raise_skill, "trp_player",skl_leadership,1),
##        (troop_raise_skill, "trp_player",skl_surgery,2),
##        (troop_add_item, "trp_player","itm_robe",0),
##        (troop_add_item, "trp_player","itm_staff",0),
##        (troop_add_item, "trp_player","itm_grain",0),
##        [troop_add_gold, "trp_player", 35],
##        (change_screen_return,0),
##        ]),
##      ("start_merchant",[],"a merchant",[
###        (assign,"$character_class",5),
##        (troop_raise_attribute, "trp_player",ca_strength,1),
##        (troop_raise_attribute, "trp_player",ca_agility,1),
##        (troop_raise_attribute, "trp_player",ca_intelligence,3),
##        (troop_raise_attribute, "trp_player",ca_charisma,3),
##        (troop_raise_skill, "trp_player",skl_riding,2),
##        (troop_raise_skill, "trp_player",skl_inventory_management,3),
##        (troop_raise_skill, "trp_player",skl_pathfinding,1),
##        (troop_raise_skill, "trp_player",skl_trade,3),
##        (troop_raise_skill, "trp_player",skl_leadership,3),
##        (troop_raise_proficiency, "trp_player",0,15),
##        (troop_raise_proficiency, "trp_player",3,10),
##        (change_screen_return,0),
##        ]),
    ]
  ),
  (
    "choose_skill",0,
    "In which area are you skilled at?",
    "none",
    [],
    [
      ("start_swordsman",[],"Swordsmanship.",[
        (assign, "$starting_skill", 1),
        (jump_to_menu,"mnu_past_life_explanation"),
        ]),
      ("start_child_of_merchant",[],"Archery.",[
        (assign, "$starting_skill", 2),
        (jump_to_menu,"mnu_past_life_explanation"),
        ]),
      ("start_child_of_unknown_adventurer",[],"Medicine.",[
        (assign, "$starting_skill", 3),
        (jump_to_menu,"mnu_past_life_explanation"),
        ]),
      ("go_back_dot",[],"Go back.",[
        (jump_to_menu, "mnu_start_game_2"),
        ]),
    ]
  ),

  (
    "past_life_explanation",0,
    "{s3}{s4}",
    "none",
    [(try_begin),
       (eq, "$background_type", 1),
       (str_store_string, s3, "@As the {reg3?daughter:son} of a minor noble, you will start the game with some renown and good quality equipment.\
 Your early game will be relatively easy."),
     (else_try),
       (eq, "$background_type", 2),
       (str_store_string, s3, "@As the {reg3?daughter:son} of a merchant, you will start the game with average equipment, some starting capital, and a low renown.\
 Your early game will be of average difficulty."),
     (else_try),
       (str_store_string, s3, "@As an unknown adventurer, you will start the game with very poor equipment and no renown.\
 Your early game may be somewhat tougher and more challenging."),
     (try_end),
     (try_begin),
       (eq, "$starting_skill", 1),
       (str_store_string, s4, "@You are skilled at swordsmanship."),
     (else_try),
       (eq, "$starting_skill", 2),
       (str_store_string, s4, "@You are skilled at archery."),
     (else_try),
       (str_store_string, s4, "@You are skilled at medicine."),
     (try_end),
     ],
    [
      ("continue",[],"Continue...",
       [
           (try_begin),
             (eq,"$character_gender",0),
             (troop_raise_attribute, "trp_player",ca_strength,1),
             (troop_raise_attribute, "trp_player",ca_charisma,1),
           (else_try),
             (troop_raise_attribute, "trp_player",ca_agility,1),
             (troop_raise_attribute, "trp_player",ca_intelligence,1),
           (try_end),

           (troop_raise_attribute, "trp_player",ca_strength,3),
           (troop_raise_attribute, "trp_player",ca_agility,3),
           (troop_raise_attribute, "trp_player",ca_charisma,2),
           
           (troop_raise_skill, "trp_player","skl_leadership",1),
           (troop_raise_skill, "trp_player","skl_riding",1),
           (try_begin),
             (eq, "$starting_skill", 1),
             (troop_raise_attribute, "trp_player",ca_agility,1),
             (troop_raise_attribute, "trp_player",ca_strength,1),
             (troop_raise_skill, "trp_player",skl_power_strike,2),
             (troop_raise_proficiency, "trp_player",0,30),
             (troop_raise_proficiency, "trp_player",1,20),
           (else_try),
             (eq, "$starting_skill", 2),
             (troop_raise_attribute, "trp_player",ca_strength,2),
             (troop_raise_skill, "trp_player",skl_power_draw,2),
             (troop_raise_proficiency, "trp_player",3,50),
           (else_try),
             (troop_raise_attribute, "trp_player",ca_intelligence,1),
             (troop_raise_attribute, "trp_player",ca_charisma,1),
             (troop_raise_skill, "trp_player",skl_first_aid,1),
             (troop_raise_skill, "trp_player",skl_wound_treatment,1),
             (troop_add_item, "trp_player","itm_winged_mace",0),
             (troop_raise_proficiency, "trp_player",0,15),
             (troop_raise_proficiency, "trp_player",1,15),
             (troop_raise_proficiency, "trp_player",2,15),
           (try_end),
           (try_begin),
             (eq, "$background_type", 1),
             (troop_set_slot, "trp_player", slot_troop_renown, 100),
             (troop_raise_skill, "trp_player",skl_ironflesh,1),
             (troop_raise_skill, "trp_player",skl_weapon_master,1),
             (troop_raise_skill, "trp_player",skl_riding,2),
             (troop_raise_skill, "trp_player",skl_tactics,1),
             (troop_raise_skill, "trp_player",skl_shield,1),
             (troop_raise_skill, "trp_player",skl_leadership,1),
             (troop_raise_skill, "trp_player",skl_prisoner_management,1),
             (troop_raise_proficiency, "trp_player",0,10),
             (troop_raise_proficiency, "trp_player",1,10),
             (troop_raise_proficiency, "trp_player",2,10),
             (troop_raise_proficiency, "trp_player",5,10),
#             (troop_add_item, "trp_player","itm_segmented_helmet",0),
#             (troop_add_item, "trp_player","itm_padded_leather",0),
             (try_begin),
               (eq, "$starting_skill", 1),
#               (troop_add_item, "trp_player","itm_bastard_sword",0),
#               (troop_add_item, "trp_player","itm_kite_shield",0),
#               (troop_add_item, "trp_player","itm_hunting_crossbow",0),
#               (troop_add_item, "trp_player","itm_bolts",0),
             (else_try),
               (eq, "$starting_skill", 2),
#               (troop_add_item, "trp_player","itm_sword",0),
#               (troop_add_item, "trp_player","itm_short_bow",0),
#               (troop_add_item, "trp_player","itm_arrows",0),
             (else_try),
#               (troop_add_item, "trp_player","itm_winged_mace",0),
#               (troop_add_item, "trp_player","itm_round_shield",0),
#               (troop_add_item, "trp_player","itm_hunting_crossbow",0),
#               (troop_add_item, "trp_player","itm_bolts",0),
             (try_end),
#             (troop_add_item, "trp_player","itm_lance",0),
#             (troop_add_item, "trp_player","itm_leather_boots",0),
#             (troop_add_item, "trp_player","itm_leather_gloves",0),
#             (troop_add_item, "trp_player","itm_smoked_fish",0),
#             (troop_add_item, "trp_player","itm_saddle_horse",0),
             (troop_add_gold, "trp_player", 520),
             (party_add_members, "p_main_party", "trp_mercenary", 4),
           (else_try),
             (eq, "$background_type", 2),
             (troop_set_slot, "trp_player", slot_troop_renown, 20),
             (troop_raise_skill, "trp_player",skl_riding,2),
             (troop_raise_skill, "trp_player",skl_inventory_management,1),
             (troop_raise_skill, "trp_player",skl_pathfinding,1),
             (troop_raise_skill, "trp_player",skl_trade,2),
             (troop_raise_skill, "trp_player",skl_leadership,2),
             (troop_raise_proficiency, "trp_player",0,15),
             (troop_raise_proficiency, "trp_player",3,10),
#             (troop_add_item, "trp_player","itm_leather_jacket",0),
#             (troop_add_item, "trp_player","itm_leather_boots",0),

             (try_begin),
               (eq, "$starting_skill", 1),
#               (troop_add_item, "trp_player","itm_sword",0),
#               (troop_add_item, "trp_player","itm_wooden_shield",0),
#               (troop_add_item, "trp_player","itm_hunting_crossbow",0),
#               (troop_add_item, "trp_player","itm_bolts",0),
             (else_try),
               (eq, "$starting_skill", 2),
#               (troop_add_item, "trp_player","itm_quarter_staff",0),
#               (troop_add_item, "trp_player","itm_hunting_bow",0),
#               (troop_add_item, "trp_player","itm_arrows",0),
             (else_try),
#               (troop_add_item, "trp_player","itm_dagger",0),
#               (troop_add_item, "trp_player","itm_winged_mace",0),
#               (troop_add_item, "trp_player","itm_hunting_crossbow",0),
#               (troop_add_item, "trp_player","itm_bolts",0),
             (try_end),
#             (troop_add_item, "trp_player","itm_smoked_fish",0),
#             (troop_add_item, "trp_player","itm_saddle_horse",0),
#             (troop_add_item, "trp_player","itm_sumpter_horse",0),
#             (troop_add_item, "trp_player","itm_salt",0),
#             (troop_add_item, "trp_player","itm_salt",0),
#             (troop_add_item, "trp_player","itm_salt",0),
#             (troop_add_item, "trp_player","itm_salt",0),
#             (troop_add_item, "trp_player","itm_pottery",0),
#             (troop_add_item, "trp_player","itm_pottery",0),
#             (troop_add_item, "trp_player","itm_pottery",0),
#             (troop_add_gold, "trp_player", 1250),
             (party_add_members, "p_main_party", "trp_mercenary", 3),
           (else_try),
#             (troop_add_item, "trp_player","itm_leather_jerkin",imod_ragged),
             (troop_raise_skill, "trp_player",skl_weapon_master,1),
             (troop_raise_skill, "trp_player",skl_riding,1),
             (troop_raise_skill, "trp_player",skl_athletics,2),
             (troop_raise_skill, "trp_player",skl_pathfinding,2),
             (troop_raise_skill, "trp_player",skl_tracking,1),
             (troop_raise_skill, "trp_player",skl_spotting,1),
             (troop_raise_proficiency, "trp_player",0,15),
             (troop_raise_proficiency, "trp_player",3,10),
             (try_begin),
               (eq, "$starting_skill", 1),
#               (troop_add_item, "trp_player","itm_arming_sword",imod_rusty),
#               (troop_add_item, "trp_player","itm_hunting_crossbow",0),
#               (troop_add_item, "trp_player","itm_bolts",0),
             (else_try),
               (eq, "$starting_skill", 2),
#               (troop_add_item, "trp_player","itm_quarter_staff",0),
#               (troop_add_item, "trp_player","itm_hunting_bow",0),
#               (troop_add_item, "trp_player","itm_arrows",0),
             (else_try),
#               (troop_add_item, "trp_player","itm_dagger",0),
#               (troop_add_item, "trp_player","itm_staff",0),
#               (troop_add_item, "trp_player","itm_hunting_crossbow",0),
#               (troop_add_item, "trp_player","itm_bolts",0),
             (try_end),

#             (troop_add_item, "trp_player","itm_leather_boots",0),
#             (troop_add_item, "trp_player","itm_leather_gloves",imod_tattered),
#             (troop_add_item, "trp_player","itm_smoked_fish",0),
#             (troop_add_item, "trp_player","itm_saddle_horse",imod_swaybacked),
             (troop_add_gold, "trp_player", 35),           
           (try_end),
           (try_begin),
             (eq, "$background_type", 1),
             (jump_to_menu, "mnu_auto_return"),
             (start_presentation, "prsnt_banner_selection"),
           (else_try),
             (change_screen_return, 0),
           (try_end),
        ]),
      ("go_back_dot",[],"Go back.",[
        (jump_to_menu, "mnu_choose_skill"),
        ]),
    ]
  ),

  (
    "auto_return",0,
    "This menu automatically returns to caller.",
    "none",
    [(change_screen_return, 0)],
    [
    ]
  ),
  ("morale_report",0,
   "{s1}",
   "none",
   [(call_script, "script_get_player_party_morale_values"),
    (assign, ":target_morale", reg0),
    (assign, reg1, "$g_player_party_morale_modifier_party_size"),
    (try_begin),
      (gt, reg1, 0),
      (str_store_string, s2, "@ -"),
    (else_try),
      (str_store_string, s2, "@ "),
    (try_end),

    (assign, reg2, "$g_player_party_morale_modifier_leadership"),
    (try_begin),
      (gt, reg2, 0),
      (str_store_string, s3, "@ +"),
    (else_try),
      (str_store_string, s3, "@ "),
    (try_end),

    (try_begin),
      (gt, "$g_player_party_morale_modifier_no_food", 0),
      (assign, reg7, "$g_player_party_morale_modifier_no_food"),
      (str_store_string, s5, "@^No food:  -{reg7}"),
    (else_try),
      (str_store_string, s5, "@ "),
    (try_end),
    (assign, reg3, "$g_player_party_morale_modifier_food"),
    (try_begin),
      (gt, reg3, 0),
      (str_store_string, s4, "@ +"),
    (else_try),
      (str_store_string, s4, "@ "),
    (try_end),

    (try_begin),
      (gt, "$g_player_party_morale_modifier_debt", 0),
      (assign, reg6, "$g_player_party_morale_modifier_debt"),
      (str_store_string, s6, "@^Wage debt:  -{reg6}"),
    (else_try),
      (str_store_string, s6, "@ "),
    (try_end),

    (party_get_morale, reg5, "p_main_party"),
    (store_sub, reg4, reg5, ":target_morale"),
    (try_begin),
      (gt, reg4, 0),
      (str_store_string, s7, "@ +"),
    (else_try),
      (lt, reg4, 0),
      (str_store_string, s7, "@ -"),
    (else_try),
      (str_store_string, s7, "@ "),
    (try_end),
    (str_store_string, s1, "@Current party morale is {reg5}.^Current party morale modifiers are:^^Base morale:  +50^Party size: {s2}{reg1}^Leadership: {s3}{reg2}^Food variety: {s4}{reg3}{s5}{s6}^Recent events: {s7}{reg4}^TOTAL:  {reg5}"),
    ],
    [
      ("continue",[],"Continue...",
       [(jump_to_menu, "mnu_reports"),
        ]
       ),
      ]
  ),

  ("character_report",0,
   "{s9}",
   "none",
   [(assign, ":num_friends", 0),
    (assign, ":num_enemies", 0),
    (str_store_string, s6, "@none"),
    (str_store_string, s8, "@none"),
    (try_for_range, ":troop_no", kingdom_heroes_begin, kingdom_heroes_end),
      (troop_get_slot, ":player_relation", ":troop_no", slot_troop_player_relation),
      (try_begin),
        (gt, ":player_relation", 20),
        (try_begin),
          (eq, ":num_friends", 0),
          (str_store_troop_name, s8, ":troop_no"),
        (else_try),
          (eq, ":num_friends", 1),
          (str_store_troop_name, s7, ":troop_no"),
          (str_store_troop_name, s8, "@{s7} and {s8}"),
        (else_try),
          (str_store_troop_name, s7, ":troop_no"),
          (str_store_troop_name, s8, "@{s7}, {s8}"),
        (try_end),
        (val_add, ":num_friends", 1),
      (else_try),
        (lt, ":player_relation", -20),
        (try_begin),
          (eq, ":num_enemies", 0),
          (str_store_troop_name, s6, ":troop_no"),
        (else_try),
          (eq, ":num_enemies", 1),
          (str_store_troop_name, s5, ":troop_no"),
          (str_store_troop_name, s6, "@{s5} and {s6}"),
        (else_try),
          (str_store_troop_name, s5, ":troop_no"),
          (str_store_troop_name, s6, "@{s5}, {s6}"),
        (try_end),
        (val_add, ":num_enemies", 1),
      (try_end),
    (try_end),
    (assign, reg3, "$player_honor"),
    (troop_get_slot, reg2, "trp_player", slot_troop_renown),
    (str_store_string, s9, "@Renown: {reg2}.^Honor rating: {reg3}.^Friends: {s8}.^Enemies: {s6}."),

	(assign,reg45,"$max_st"),#sg st
	(assign,reg44,"$quest_prestige"),
	(str_store_string, s9, "@{s9}^^Prestige: {reg44}^^"),
	
    (call_script, "script_get_number_of_hero_centers", "trp_player"),
    (assign, ":no_centers", reg0),
    (try_begin),
      (gt, ":no_centers", 0),
      (try_for_range, ":i_center", 0, ":no_centers"),
        (call_script, "script_troop_get_leaded_center_with_index", "trp_player", ":i_center"),
        (assign, ":cur_center", reg0),
        (try_begin),
          (eq, ":i_center", 0),
          (str_store_party_name, s8, ":cur_center"),
        (else_try),
          (eq, ":i_center", 1),
          (str_store_party_name, s7, ":cur_center"),
          (str_store_string, s8, "@{s7} and {s8}"),
        (else_try),
          (str_store_party_name, s7, ":cur_center"),
          (str_store_string, s8, "@{s7}, {s8}"),
        (try_end),
      (try_end),
      (str_store_string, s9, "@Your estates are: {s8}.^{s9}"),
    (try_end),
    (try_begin),
      (gt, "$players_kingdom", 0),
      (str_store_faction_name, s8, "$players_kingdom"),
      (str_store_string, s9, "@You are a lord of {s8}.^{s9}"),
    (try_end),
    ],
    [
      ("continue",[],"Continue...",
       [(jump_to_menu, "mnu_reports"),
        ]
       ),
      ]
  ),

  ("party_size_report",0,
   "{s1}",
   "none",
   [(call_script, "script_game_get_party_companion_limit"),
    (assign, ":party_size_limit", reg0),

    (store_skill_level, ":leadership", "skl_leadership", "trp_player"),
    (val_mul, ":leadership", 3),
    (store_attribute_level, ":charisma", "trp_player", ca_charisma),

    (troop_get_slot, ":renown", "trp_player", slot_troop_renown),
    (val_div, ":renown", 25),
    (try_begin),
      (gt, ":leadership", 0),
      (str_store_string, s2, "@ +"),
    (else_try),
      (str_store_string, s2, "@ "),
    (try_end),
    (try_begin),
      (gt, ":charisma", 0),
      (str_store_string, s3, "@ +"),
    (else_try),
      (str_store_string, s3, "@ "),
    (try_end),
    (try_begin),
      (gt, ":renown", 0),
      (str_store_string, s4, "@ +"),
    (else_try),
      (str_store_string, s4, "@ "),
    (try_end),
    (assign, reg5, ":party_size_limit"),
    (assign, reg1, ":leadership"),
    (assign, reg2, ":charisma"),
    (assign, reg3, ":renown"),
    (str_store_string, s1, "@Current party size limit is {reg5}.^Current party size modifiers are:^^Base size:  +10^Leadership: {s2}{reg1}^Charisma: {s3}{reg2}^Renown: {s4}{reg3}^TOTAL:  {reg5}"),
    ],
    [
      ("continue",[],"Continue...",
       [(jump_to_menu, "mnu_reports"),
        ]
       ),
      ]
  ),


  ("camp",0,
   "You set up camp. What do you want to do?",
   "none",
   [(assign, "$g_player_icon_state", pis_normal),
    (set_background_mesh, "mesh_pic_camp"),
    ],
    [
      ("camp_action_1",[(eq,"$cheat_mode",1)],"Cheat: Walk around.",
       [(set_jump_mission,"mt_ai_training"),
        (call_script, "script_setup_random_scene"),
        (change_screen_mission),
        ]
       ),
##SG
      #huoji
      ("camp_action_2",[
          ],"Prepared Fire.",
       [(jump_to_menu, "mnu_fire")]
       ),

      #xian jing
      ("camp_action_3",[
          ],"Prepared Trap.",
       [(jump_to_menu, "mnu_trap")]
       ),
##SG end

      ("camp_wait_here",[],"Wait here for some time.",
       [
           (assign,"$g_camp_mode", 1),
#           (assign,"$auto_menu","mnu_camp"),
           (assign, "$g_player_icon_state", pis_camping),
           (rest_for_hours_interactive, 72, 5, 1), #rest while attackable
           (change_screen_return),
        ]
       ),
      ("camp_recruit_prisoners",
       [(troops_can_join, 1),
        (store_current_hours, ":cur_time"),
        (val_sub, ":cur_time", 24),
        (gt, ":cur_time", "$g_prisoner_recruit_last_time"),
        (try_begin),
          (gt, "$g_prisoner_recruit_last_time", 0),
          (assign, "$g_prisoner_recruit_troop_id", 0),
          (assign, "$g_prisoner_recruit_size", 0),
          (assign, "$g_prisoner_recruit_last_time", 0),
        (try_end),
        (assign, ":num_regular_prisoner_slots", 0),
        (party_get_num_prisoner_stacks, ":num_stacks", "p_main_party"),
        (try_for_range, ":cur_stack", 0, ":num_stacks"),
          (party_prisoner_stack_get_troop_id, ":cur_troop_id", "p_main_party", ":cur_stack"),
          (neg|troop_is_hero, ":cur_troop_id"),
          (val_add, ":num_regular_prisoner_slots", 1),
        (try_end),
        (gt, ":num_regular_prisoner_slots", 0),
        ], "Recruit from prisoners.",
       [(jump_to_menu, "mnu_camp_recruit_prisoners"),
        ],
       ),
      ("camp_cheat",
       [(eq, "$cheat_mode", 1)
        ], "CHEAT MENU!",
       [(jump_to_menu, "mnu_camp_cheat"),
        ],
       ),
      ("resume_travelling",[],"Resume travelling.",
       [
           (change_screen_return),
        ]
       ),
      ]
  ),

##SG
   #trap
  ("trap",0,
   "Select Trap count",
   "none",
   [
     (assign,reg58,"$xj_use_count"),
     (try_begin),
        (player_has_item,"itm_tools"),
        (str_store_string, s59, "@camp_trap_1"),
     (else_try),
        (str_store_string, s59, "@camp_trap_2"),
     (try_end),

       ],
    [
      ("one",[
       (store_item_kind_count,":itm_count","itm_tools","trp_player"),
       (ge,":itm_count",1),
          ],"One.",
       [
        (store_time_of_day,"$time_begin"),
        (troop_remove_item,"trp_player","itm_tools"),
        (party_get_skill_level, ":i_skill", "p_main_party", skl_engineer),
        (val_div,":i_skill",3),
        (store_sub,"$time_cons",3,":i_skill"),
        (val_max,"$time_cons",1),
        (assign,"$xj_ready", 1),
        (assign,"$xj_use_count", 1),
        (assign,"$g_camp_mode", 1),
        (assign, "$g_player_icon_state", pis_camping),
        (rest_for_hours_interactive, 3, 2, 1),
        (change_screen_return),
        ]
       ),
      ("two",[
       (ge,"$xianjing",1),
       (store_item_kind_count,":itm_count","itm_tools","trp_player"),
       (ge,":itm_count",2),
          ],"Two.",
       [
        (store_time_of_day,"$time_begin"),
        (troop_remove_items,"trp_player","itm_tools",2),
        (party_get_skill_level, ":i_skill", "p_main_party", skl_engineer),
        (val_div,":i_skill",3),
        (store_sub,"$time_cons",4,":i_skill"),
        (val_max,"$time_cons",1),
        (assign,"$xj_ready", 1),
        (assign,"$xj_use_count", 2),
        (assign,"$g_camp_mode", 1),
        (assign, "$g_player_icon_state", pis_camping),
        (rest_for_hours_interactive, 4, 2, 1),
        (change_screen_return),
        ]
       ),
      ("three",[
       (ge,"$xianjing",2),
       (store_item_kind_count,":itm_count","itm_tools","trp_player"),
       (ge,":itm_count",3),
          ],"Three.",
       [
        (store_time_of_day,"$time_begin"),
        (troop_remove_items,"trp_player","itm_tools",3),
        (party_get_skill_level, ":i_skill", "p_main_party", skl_engineer),
        (val_div,":i_skill",3),
        (store_sub,"$time_cons",5,":i_skill"),
        (val_max,"$time_cons",1),
        (assign,"$xj_ready", 1),
        (assign,"$xj_use_count", 3),
        (assign,"$g_camp_mode", 1),
        (assign, "$g_player_icon_state", pis_camping),
        (rest_for_hours_interactive, 5, 2, 1),
        (change_screen_return),
        ]
       ),
      ("camp_action_4",[],"Back to camp menu.",
       [(jump_to_menu, "mnu_camp")]
       ),
      ]
  ),
   #fire
  ("fire",0,
   "fire",
   "none",
   [
     (assign,reg58,"$hj_use_count"),
     (store_add,":value","$huoji",1),
     (store_item_kind_count,":itm_count","itm_oil","trp_player"),
     (try_begin),
        (lt,":itm_count",1),
        (str_store_string, s59, "@camp_fire_3"),
     (else_try),
        (ge,":itm_count",1),
        (gt,":value","$hj_use_count"),
        (str_store_string, s59, "@camp_fire_1"),
     (else_try),
        (le,":value","$hj_use_count"),
        (str_store_string, s59, "@camp_fire_2"),
     (try_end),
       ],
    [
      ("fire_1",[
       (player_has_item,"itm_oil"),
       (store_add,":value","$huoji",1),
       (gt,":value","$hj_use_count"),
          ],"Prepared Fire 1.",
       [
        (store_time_of_day,"$time_begin"),
        (troop_remove_item,"trp_player","itm_oil"),
        (party_get_skill_level, ":i_skill", "p_main_party", skl_engineer),
        (val_div,":i_skill",3),
        (store_sub,"$time_cons",3,":i_skill"),
        (val_max,"$time_cons",1),
        (assign,"$hj_ready", 1),

        (assign,"$g_camp_mode", 1),
        (assign, "$g_player_icon_state", pis_camping),
        (rest_for_hours_interactive, 3, 2, 1),
        (change_screen_return),
        ]
       ),

      ("camp_action_4",[],"Back to camp menu.",
       [(jump_to_menu, "mnu_camp")]
       ),
      ]
  ),
##SG end
  ("camp_cheat",0,
   "Select a cheat:",
   "none",
   [],
    [
      ("camp_cheat_1",[],"Increase player renown.",
       [(str_store_string, s1, "@Player renown is increased by 100. "),
        (call_script, "script_change_troop_renown", "trp_player" ,100),
        (jump_to_menu, "mnu_camp_cheat"),
        ]
       ),
      ("camp_action_4",[],"Back to camp menu.",
       [(jump_to_menu, "mnu_camp"),
        ]
       ),
      ]
  ),
  ("camp_recruit_prisoners",0,
   "{reg1} {s1} {reg2?accept:accepts} to join you. What is your answer?",
   "none",
   [(try_begin),
      (eq, "$g_prisoner_recruit_troop_id", 0),
      (assign, ":num_regular_prisoner_slots", 0),
      (party_get_num_prisoner_stacks, ":num_stacks", "p_main_party"),
      (try_for_range, ":cur_stack", 0, ":num_stacks"),
        (party_prisoner_stack_get_troop_id, ":cur_troop_id", "p_main_party", ":cur_stack"),
        (neg|troop_is_hero, ":cur_troop_id"),
        (val_add, ":num_regular_prisoner_slots", 1),
      (try_end),
      (store_random_in_range, ":random_prisoner_slot", 0, ":num_regular_prisoner_slots"),
      (try_for_range, ":cur_stack", 0, ":num_stacks"),
        (party_prisoner_stack_get_troop_id, ":cur_troop_id", "p_main_party", ":cur_stack"),
        (neg|troop_is_hero, ":cur_troop_id"),
        (val_sub, ":random_prisoner_slot", 1),
        (lt, ":random_prisoner_slot", 0),
        (assign, ":num_stacks", 0),
        (assign, "$g_prisoner_recruit_troop_id", ":cur_troop_id"),
        (party_prisoner_stack_get_size, "$g_prisoner_recruit_size", "p_main_party", ":cur_stack"),
      (try_end),
    (try_end),
    (party_get_free_companions_capacity, ":capacity", "p_main_party"),
    (val_min, "$g_prisoner_recruit_size", ":capacity"),
    (assign, reg1, "$g_prisoner_recruit_size"),
    (try_begin),
      (gt, "$g_prisoner_recruit_size", 1),
      (assign, reg2, 1),
    (else_try),
      (assign, reg2, 0),
    (try_end),
    (str_store_troop_name_by_count, s1, "$g_prisoner_recruit_troop_id", "$g_prisoner_recruit_size"),
    (store_current_hours, "$g_prisoner_recruit_last_time"),
    ],
    [
      ("camp_recruit_prisoners_accept",[],"Accept.",
       [(store_random_in_range,":rp",0,100),
        (try_begin),
          (eq,"$gc",1),
          (val_add,":rp",20),
        (else_try),
          (eq,"$gc",2),
          (val_add,":rp",40),
        (try_end),
        (val_add,":rp",20),
        (try_begin),
        (ge,":rp",100),
        (remove_troops_from_prisoners, "$g_prisoner_recruit_troop_id", "$g_prisoner_recruit_size"),
        (party_add_members, "p_main_party", "$g_prisoner_recruit_troop_id", "$g_prisoner_recruit_size"),
        (store_mul, ":morale_change", -3, "$g_prisoner_recruit_size"),
        (call_script, "script_change_player_party_morale", ":morale_change"),
        (else_try),
        (display_message,"str_failure"),
        (try_end),
        (jump_to_menu, "mnu_camp"),
        ]
       ),
      ("camp_recruit_prisoners_reject",[],"Reject.",
       [(jump_to_menu, "mnu_camp"),
        (assign, "$g_prisoner_recruit_troop_id", 0),
        (assign, "$g_prisoner_recruit_size", 0),
        ]
       ),
      ]
  ),

  (
    "pay_day",0,
    "{s1}.",
    "none",
    [
        (set_background_mesh, "mesh_pic_payment"),
        
        (call_script, "script_calculate_player_faction_wage"),
        (assign, ":total_wages", reg0),
        (assign, reg6, ":total_wages"),

        (assign, reg2, "$g_player_debt_to_party_members"),
        (store_add, reg3, reg6, reg2),
        (store_troop_gold, ":player_wealth", "trp_player"),
        (assign, reg4, ":player_wealth"),

        (val_add, ":total_wages", "$g_player_debt_to_party_members"),

        (try_begin),
          (ge, ":player_wealth", ":total_wages"),
          (assign, "$g_player_debt_to_party_members", 0),
          (troop_remove_gold, "trp_player",":total_wages"),
          (store_sub, reg5, reg4, reg3),
          (str_store_string, s1, "@You paid {reg3} of your {reg4} denars to your men. You have {reg5} denars left."),
        (else_try),
          (troop_remove_gold, "trp_player",":player_wealth"),
          (store_sub, ":unpaid", ":total_wages", ":player_wealth"),
          (assign, reg5, ":unpaid"),
          (str_store_string, s1, "@Your debt to your men amounted to {reg3} denars, however you only had {reg4}. Unpaid sum of {reg5} denars is added as debt. Your party loses morale."),
          (val_add, "$g_player_debt_to_party_members", ":unpaid"),
        (try_end),

        (str_store_string, s1, "@This week's wages: {reg6} denars^Earlier debts: {reg2} denars^Total payment: {reg3} denars^Current wealth: {reg4} denars^^{s1}"),
    ],
    [
      ("continue",[],"Continue...",
       [
        (change_screen_return,0),
        ]
       ),
    ]
  ),

  
  (
    "simple_encounter",mnf_enable_hot_keys,
    "{s2} You have {reg10} troops fit for battle against their {reg11}.",
    "none",
    [
        (assign, "$g_enemy_party", "$g_encountered_party"),
        (assign, "$g_ally_party", -1),
        (call_script, "script_encounter_calculate_fit"),
        (try_begin),
          (eq, "$new_encounter", 1),
          (assign, "$new_encounter", 0),
          (assign, "$g_encounter_is_in_village", 0),
          (assign, "$g_encounter_type", 0),
          (try_begin),
            (party_slot_eq, "$g_enemy_party", slot_party_ai_state, spai_raiding_village),
            (party_get_slot, ":village_no", "$g_enemy_party", slot_party_ai_object),
            (store_distance_to_party_from_party, ":dist", ":village_no", "$g_enemy_party"),
            (try_begin),
              (lt, ":dist", raid_distance),
              (assign, "$g_encounter_is_in_village", ":village_no"),
              (assign, "$g_encounter_type", enctype_fighting_against_village_raid),
            (try_end),
          (try_end),
          (try_begin),
            (gt, "$g_player_raiding_village", 0),
            (assign, "$g_encounter_is_in_village", "$g_player_raiding_village"),
            (assign, "$g_encounter_type", enctype_catched_during_village_raid),
            (party_quick_attach_to_current_battle, "$g_encounter_is_in_village", 1), #attach as enemy
            (str_store_string, s1, "@Villagers"),
            (display_message, "str_s1_joined_battle_enemy"),
          (else_try),
            (eq, "$g_encounter_type", enctype_fighting_against_village_raid),
            (party_quick_attach_to_current_battle, "$g_encounter_is_in_village", 0), #attach as friend
            (str_store_string, s1, "@Villagers"),
            (display_message, "str_s1_joined_battle_friend"),
            # Let village party join battle at your side
          (try_end),
          (call_script, "script_let_nearby_parties_join_current_battle"),
          (call_script, "script_encounter_init_variables"),
          (assign, "$encountered_party_hostile", 0),
          (assign, "$encountered_party_friendly", 0),
          (try_begin),
            (gt, "$g_encountered_party_relation", 0),
            (assign, "$encountered_party_friendly", 1),
          (try_end),
          (try_begin),
            (lt, "$g_encountered_party_relation", 0),
            (assign, "$encountered_party_hostile", 1),
            (try_begin),
              (encountered_party_is_attacker),
              (assign, "$cant_leave_encounter", 1),
            (try_end),
          (try_end),
          (assign, "$talk_context", tc_party_encounter),
          (call_script, "script_setup_party_meeting", "$g_encountered_party"),
        (else_try), #second or more turn
#          (try_begin),
#            (call_script, "script_encounter_calculate_morale_change"),
#          (try_end),
          (try_begin),
            # We can leave battle only after some troops have been killed. 
            (eq, "$cant_leave_encounter", 1),
            (call_script, "script_party_count_fit_regulars", "p_main_party_backup"),
            (assign, ":org_total_party_counts", reg0),
            (call_script, "script_party_count_fit_regulars", "p_encountered_party_backup"),
            (val_add, ":org_total_party_counts", reg0),

            (call_script, "script_party_count_fit_regulars", "p_main_party"),
            (assign, ":cur_total_party_counts", reg0),
            (call_script, "script_party_count_fit_regulars", "p_collective_enemy"),
            (val_add, ":cur_total_party_counts", reg0),

            (store_sub, ":leave_encounter_limit", ":org_total_party_counts", 10),
            (lt, ":cur_total_party_counts", ":leave_encounter_limit"),
            (assign, "$cant_leave_encounter", 0),
          (try_end),
          (eq, "$g_leave_encounter",1),
          (change_screen_return),
        (try_end),

        #setup s2
        (str_store_party_name, s1,"$g_encountered_party"),
        (try_begin),
          (eq, "$g_encounter_type", 0),
          (str_store_string, s2,"@You have encountered {s1}."),
        (else_try),
          (eq, "$g_encounter_type", enctype_fighting_against_village_raid),
          (str_store_party_name, s3, "$g_encounter_is_in_village"),
          (str_store_string, s2,"@You have engaged {s1}, while they were raiding {s3}."),
        (else_try),
          (eq, "$g_encounter_type", enctype_catched_during_village_raid),
          (str_store_party_name, s3, "$g_encounter_is_in_village"),
          (str_store_string, s2,"@You were caught by {s1}, while your forces were raiding {s3}."),
        (try_end),
        (try_begin),
          (call_script, "script_party_count_fit_regulars","p_collective_enemy"),
          (assign, ":num_enemy_regulars_remaining", reg(0)),
          (assign, ":enemy_finished",0),
          (try_begin),
            (eq, "$g_battle_result", 1),
            (eq, ":num_enemy_regulars_remaining", 0), #battle won
            (assign, ":enemy_finished",1),
          (else_try),
            (eq, "$g_engaged_enemy", 1),
            (le, "$g_enemy_fit_for_battle",0),
            (ge, "$g_friend_fit_for_battle",1),
            (assign, ":enemy_finished",1),
          (try_end),
          (this_or_next|eq, ":enemy_finished",1),
          (eq,"$g_enemy_surrenders",1),
          (assign, "$g_next_menu", -1),
          (jump_to_menu, "mnu_total_victory"),
        (else_try),
#          (eq, "$encountered_party_hostile", 1),
          (call_script, "script_party_count_fit_regulars","p_main_party"),
          (assign, reg(3), reg(0)),
          (assign, ":friends_finished",0),
          (try_begin),
            (eq, "$g_battle_result", -1),
            (eq, reg(3), 0), #battle lost
            (assign,  ":friends_finished",1),
          (else_try),
            (eq, "$g_engaged_enemy", 1),
            (ge, "$g_enemy_fit_for_battle",1),
            (le, "$g_friend_fit_for_battle",0),
            (assign,  ":friends_finished",1),
          (try_end),
          (this_or_next|eq,  ":friends_finished",1),
          (eq,"$g_player_surrenders",1),
          (assign, "$g_next_menu", "mnu_captivity_start_wilderness"),
          (jump_to_menu, "mnu_total_defeat"),
        (try_end),

       
        (try_begin),
          (this_or_next|eq, "$g_encountered_party_template", "pt_river_pirates"),
          #(this_or_next|eq, "$g_encountered_party_template", "pt_forest_bandits"),
          #(eq, "$g_encountered_party_template", "pt_mountain_bandits"),
          (set_background_mesh, "mesh_pic_bandits"),
        (try_end),
    ],
    [
      ("encounter_attack",[
          (eq, "$encountered_party_friendly", 0),
          (neg|troop_is_wounded, "trp_player"),
##          (store_troop_health,reg(5)),
##          (ge,reg(5),5),
          ],
                            "Charge the enemy.",[
                                (assign, "$g_battle_result", 0),
                                (assign, "$g_engaged_enemy", 1),
                                (call_script, "script_calculate_renown_value"),
                                (call_script, "script_calculate_battle_advantage"),
                                (set_battle_advantage, reg0),
                                (set_party_battle_mode),
                                (try_begin),
                                  (eq, "$g_encounter_type", enctype_fighting_against_village_raid),
                                  (set_jump_mission,"mt_village_raid"),
                                  (party_get_slot, ":scene_to_use", "$g_encounter_is_in_village", slot_castle_exterior),
                                  (jump_to_scene, ":scene_to_use"),
                                (else_try),
                                  (eq, "$g_encounter_type", enctype_catched_during_village_raid),
                                  (set_jump_mission,"mt_village_raid"),
                                  (party_get_slot, ":scene_to_use", "$g_encounter_is_in_village", slot_castle_exterior),
                                  (jump_to_scene, ":scene_to_use"),
                                (else_try),
                                  (set_jump_mission,"mt_lead_charge"),
                                  (call_script, "script_setup_random_scene"),
                                (try_end),
                                (assign, "$g_next_menu", "mnu_simple_encounter"),
                                (jump_to_menu, "mnu_battle_debrief"),
                                (change_screen_mission),
                                ]),
      ("encounter_order_attack",[
          (eq, "$encountered_party_friendly", 0),
          (call_script, "script_party_count_fit_regulars", "p_main_party"),(ge, reg(0), 2),
          ],
           "Order your troops to attack as you stay back.",[(jump_to_menu,"mnu_order_attack_begin"),
                                                            #(simulate_battle,3)
                                                            ]),
      ("encounter_leave",[
          (eq,"$cant_leave_encounter", 0),
          ],"Leave.",[(leave_encounter),(change_screen_return)]),
      ("encounter_surrender",[
         (eq,"$cant_leave_encounter", 1),
          ],"Surrender.",[(assign,"$g_player_surrenders",1)]),
    ]
  ),
  (
    "order_attack_begin",0,
    "Your troops are ready to attack the enemy...",
    "none",
    [],
    [
      ("order_attack_begin",[],"Order the attack to begin.", [
                                    (assign, "$g_engaged_enemy", 1),
                                    (jump_to_menu,"mnu_order_attack_2"),
                                    ]),
      ("call_back",[],"Call them back.",[(jump_to_menu,"mnu_simple_encounter")]),
    ]
  ),
  (
    "order_attack_2",0,
    "{s4}^^Your casualties: {s8}^^Enemy casualties: {s9}",
    "none",
    [
                                    (call_script, "script_party_calculate_regular_strength", "p_main_party"),
                                    (assign, ":player_party_strength", reg0),
                                    (val_div, ":player_party_strength", 5),
                                    (call_script, "script_party_calculate_regular_strength", "p_collective_enemy"),
                                    (assign, ":enemy_party_strength", reg0),
                                    (val_div, ":enemy_party_strength", 5),
                                    
#                                    (call_script,"script_inflict_casualties_to_party", "p_main_party", ":enemy_party_strength"),
                                    (inflict_casualties_to_party_group, "p_main_party", ":enemy_party_strength", "p_temp_casualties"),
                                    (call_script, "script_print_casualties_to_s0", "p_temp_casualties", 0),
                                    (str_store_string_reg, s8, s0),
                                    
####                                    (call_script,"script_inflict_casualties_to_party", "$g_encountered_party", ":player_party_strength"),
                                    (inflict_casualties_to_party_group, "$g_encountered_party", ":player_party_strength", "p_temp_casualties"),
                                    (call_script, "script_print_casualties_to_s0", "p_temp_casualties", 0),
                                    (str_store_string_reg, s9, s0),

                                    (party_collect_attachments_to_party, "$g_encountered_party", "p_collective_enemy"),


 #                                   (assign, "$cant_leave_encounter", 0),

                                    (assign, "$no_soldiers_left", 0),
                                    (try_begin),
                                      (call_script, "script_party_count_fit_regulars","p_main_party"),
                                      (le, reg(0), 0),
                                      (assign, "$no_soldiers_left", 1),
                                      (str_store_string, s4, "str_order_attack_failure"),
                                    (else_try),
                                      (call_script, "script_party_count_fit_regulars","p_collective_enemy"),
                                      (le, reg(0), 0),
                                      (assign, ":continue", 0),
                                      (party_get_num_companion_stacks, ":party_num_stacks", "p_collective_enemy"),
                                      (try_begin),
                                        (eq, ":party_num_stacks", 0),
                                        (assign, ":continue", 1),
                                      (else_try),
                                        (party_stack_get_troop_id, ":party_leader", "p_collective_enemy", 0),
                                        (neg|troop_is_hero, ":party_leader"),
                                        (assign, ":continue", 1),
                                      (try_end),
                                      (eq, ":continue", 1),
                                      (assign, "$g_battle_result", 1),
                                      (assign, "$no_soldiers_left", 1),
                                      (str_store_string, s4, "str_order_attack_success"),
                                    (else_try),
                                      (str_store_string, s4, "str_order_attack_continue"),
                                    (try_end),
    ],
    [
      ("order_attack_continue",[(eq,  "$no_soldiers_left", 0)],"Order your soldiers to continue the attack.",[
          (jump_to_menu,"mnu_order_attack_2"),
          ]),
      ("order_retreat",[(eq,  "$no_soldiers_left", 0)],"Call your soldiers back.",[
          (jump_to_menu,"mnu_simple_encounter"),
          ]),
      ("continue",[(eq,  "$no_soldiers_left", 1)],"Continue...",[
          (jump_to_menu,"mnu_simple_encounter"),
          ]),
    ]
  ),

  (
    "battle_debrief",0,
    "{s11} Casualties are:^^Your Casualties:{s8}{s10}^^Enemy Casualties::{s9}",
    "none",
    [(try_begin),
       (eq, "$g_battle_result", 1),
       (call_script, "script_change_troop_renown", "trp_player", "$battle_renown_value"),
     (try_end),

     (call_script, "script_encounter_calculate_fit"),
     (try_begin),
       (eq, "$g_battle_result", 1),
       (eq, "$g_enemy_fit_for_battle", 0),
       (str_store_string, s11, "@You were victorious!"),
     (else_try),
       (eq, "$g_battle_result", -1),
       (ge, "$g_enemy_fit_for_battle",1),
       (le, "$g_friend_fit_for_battle",0),
       (str_store_string, s11, "@Battle is lost. Your forces were utterly crushed."),
     (else_try),
       (eq, "$g_battle_result", -1),
       (str_store_string, s11, "@Your companions carry you away from the fighting."),
     (else_try),
       (eq, "$g_battle_result", 1),
       (str_store_string, s11, "@You have defeated the enemy."),
     (else_try),
       (eq, "$g_battle_result", 0),
       (str_store_string, s11, "@You have retreated from the fight."),
     (try_end),

     (call_script, "script_print_casualties_to_s0", "p_player_casualties", 0),
     (str_store_string_reg, s8, s0),
     (call_script, "script_print_casualties_to_s0", "p_enemy_casualties", 0),
     (str_store_string_reg, s9, s0),
     (str_clear, s10),
     (try_begin),
       (eq, "$any_allies_at_the_last_battle", 1),
       (call_script, "script_print_casualties_to_s0", "p_ally_casualties", 0),
       (str_store_string, s10, "@^^Ally Casualties:{s0}"),
     (try_end),
     ],
    [
      ("continue",[],"Continue...",[(jump_to_menu, "$g_next_menu"),]),
    ]
  ),


  
  (
    "total_victory",0,
    "You shouldn't be reading this... {s9}",
    "none",
    [
        # We exploit the menu condition system below.
        # The conditions should make sure that always another screen or menu is called.
        (assign, ":done", 0),
        (try_begin),
          # Talk to ally leader
          (eq, "$thanked_by_ally_leader", 0),
          (assign, "$thanked_by_ally_leader", 1),
          (gt, "$g_ally_party", 0),

#          (store_add, ":total_str_without_player", "$g_starting_strength_ally_party", "$g_starting_strength_enemy_party"),
          
          (store_add, ":total_str_without_player", "$g_starting_strength_friends", "$g_starting_strength_enemy_party"),
          (val_sub, ":total_str_without_player", "$g_starting_strength_main_party"),

          (store_sub, ":ally_strength_without_player", "$g_starting_strength_friends", "$g_starting_strength_main_party"),
        
          (store_mul, ":ally_advantage", ":ally_strength_without_player", 100),
          (val_div, ":ally_advantage", ":total_str_without_player"),
          #Ally advantage=50  means battle was evenly matched

          (store_sub, ":enemy_advantage", 100, ":ally_advantage"),
        
          (store_mul, ":faction_reln_boost", ":enemy_advantage", "$g_starting_strength_enemy_party"),
          (val_div, ":faction_reln_boost", 3000),
          (val_min, ":faction_reln_boost", 4),

          (store_mul, "$g_relation_boost", ":enemy_advantage", ":enemy_advantage"),
          (val_div, "$g_relation_boost", 700),
        
          (party_get_num_companion_stacks, ":num_ally_stacks", "$g_ally_party"),
          (gt, ":num_ally_stacks", 0),
          (store_faction_of_party, ":ally_faction","$g_ally_party"),
          (store_relation, ":ally_reln",":ally_faction","fac_player_faction"),
          (store_add, ":new_ally_reln", ":ally_reln", ":faction_reln_boost"),
          (set_relation, ":ally_faction","fac_player_faction", ":new_ally_reln"),
          (party_stack_get_troop_id, ":ally_leader", "$g_ally_party"),
          (party_stack_get_troop_dna, ":ally_leader_dna", "$g_ally_party"),
          (try_begin),
            (troop_is_hero, ":ally_leader"),
            (troop_get_slot, ":hero_relation", ":ally_leader", slot_troop_player_relation),
            (assign, ":rel_boost", "$g_relation_boost"),
            (try_begin),
              (lt, ":hero_relation", -5),
              (val_div, ":rel_boost", 3),
            (try_end),
            (call_script,"script_change_player_relation_with_troop", ":ally_leader", ":rel_boost"),
          (try_end),
          (assign, "$talk_context", tc_ally_thanks),
          (call_script, "script_setup_troop_meeting",":ally_leader", ":ally_leader_dna"),
        (else_try),
          # Talk to enemy leaders
          (assign, ":done", 0),
          (party_get_num_companion_stacks, ":num_stacks", "p_encountered_party_backup"),
        
          (try_for_range, ":stack_no", "$last_defeated_hero", ":num_stacks"),
            (eq, ":done", 0),
            (party_stack_get_troop_id,   ":stack_troop","p_encountered_party_backup",":stack_no"),
            (party_stack_get_troop_dna,   ":stack_troop_dna","p_encountered_party_backup",":stack_no"),
            
            (troop_is_hero, ":stack_troop"),
            (store_add, "$last_defeated_hero", ":stack_no", 1),
        
            (troop_set_slot, ":stack_troop", slot_troop_is_prisoner, 0),
            (troop_set_slot, ":stack_troop", slot_troop_leaded_party, -1),
            (store_random_in_range, ":rand", 0, 100),
            (try_begin),
              (lt, ":rand", hero_escape_after_defeat_chance),
              (str_store_troop_name, s1, ":stack_troop"),
              (store_troop_faction, ":defeated_faction", ":stack_troop"),
              (str_store_faction_name, s3, ":defeated_faction"),
              (str_store_string,s17,"@{s1} of {s3} managed to escape."),
              (display_log_message,"@{s17}"),
              (jump_to_menu, "mnu_enemy_slipped_away"),
              (assign, ":done", 1),
            (else_try),
              (assign, "$talk_context", tc_hero_defeated),
              (call_script, "script_setup_troop_meeting",":stack_troop", ":stack_troop_dna"),
              (assign, ":done", 1),
            (try_end),
          (try_end),
          (eq, ":done", 1),
        (else_try),
          # Talk to freed heroes
          (assign, ":done", 0),
          (party_get_num_prisoner_stacks, ":num_prisoner_stacks","p_encountered_party_backup"),
          (try_for_range, ":stack_no", "$last_freed_hero", ":num_prisoner_stacks"),
            (eq, ":done", 0),
            (party_prisoner_stack_get_troop_id,   ":stack_troop","p_encountered_party_backup",":stack_no"),
            (troop_is_hero, ":stack_troop"),
            (party_prisoner_stack_get_troop_dna,   ":stack_troop_dna","p_encountered_party_backup",":stack_no"),
            (store_add, "$last_freed_hero", ":stack_no", 1),
            (assign, "$talk_context", tc_hero_freed),
            (call_script, "script_setup_troop_meeting",":stack_troop", ":stack_troop_dna"),
            (assign, ":done", 1),
          (try_end),
          (eq, ":done", 1),
        (else_try),
          (eq, "$capture_screen_shown", 0),
          (assign, "$capture_screen_shown", 1),
          (party_clear, "p_temp_party"),
          (assign, "$g_move_heroes", 0),
          (call_script, "script_party_prisoners_add_party_companions", "p_temp_party", "p_collective_enemy"),
          (call_script, "script_party_add_party_prisoners", "p_temp_party", "p_collective_enemy"),

          (try_begin),
            (call_script, "script_party_calculate_strength", "p_collective_friends_backup"),
            (assign,":total_initial_strength", reg(0)),
            (gt, ":total_initial_strength", 0),
#            (gt, "$g_ally_party", 0),
            (call_script, "script_party_calculate_strength", "p_main_party_backup"),
            (assign,":player_party_initial_strength", reg(0)),
            # move ally_party_initial_strength/(player_party_initial_strength + ally_party_initial_strength) prisoners to ally party.
            # First we collect the share of prisoners of the ally party and distribute those among the allies.
            (store_sub, ":ally_party_initial_strength", ":total_initial_strength", ":player_party_initial_strength"),

#            (call_script, "script_party_calculate_strength", "p_ally_party_backup"),
#            (assign,":ally_party_initial_strength", reg(0)),
#            (store_add, ":total_initial_strength", ":player_party_initial_strength", ":ally_party_initial_strength"),
            (store_mul, ":ally_share", ":ally_party_initial_strength", 1000),
            (val_div, ":ally_share", ":total_initial_strength"),
            (assign, "$pin_number", ":ally_share"), #we send this as a parameter to the script.
            (party_clear, "p_temp_party_2"),
            (call_script, "script_move_members_with_ratio", "p_temp_party", "p_temp_party_2"),
        
            #TODO: This doesn't handle prisoners if our allies joined battle after us.
            (try_begin),
              (gt, "$g_ally_party", 0),
              (distribute_party_among_party_group, "p_temp_party_2", "$g_ally_party"),
            (try_end),
             #next if there's anything left, we'll open up the party exchange screen and offer them to the player.
          (try_end),
##SG qixi
          (try_begin),
            (eq,"$use_qixi",2),
            (assign,"$use_qixi",0),
            (call_script, "script_add_qi_xi_troop_to_main_party"),
#            (display_message, "@back"),#
          (try_end),
##SG qixi
          (party_get_num_companions, ":num_rescued_prisoners", "p_temp_party"),
          (party_get_num_prisoners,  ":num_captured_enemies", "p_temp_party"),
          (store_add, ":total_capture_size", ":num_rescued_prisoners", ":num_captured_enemies"),
          (gt, ":total_capture_size", 0),
          (change_screen_exchange_with_party, "p_temp_party"),
        (else_try),
          (eq, "$loot_screen_shown", 0),
          (assign, "$loot_screen_shown", 1),
          (try_begin),
            (gt, "$g_ally_party", 0),
            (call_script, "script_party_add_party", "$g_ally_party", "p_temp_party"), #Add remaining prisoners to ally TODO: FIX it.
          (else_try),
            (party_get_num_attached_parties, ":num_quick_attachments", "p_main_party"),
            (gt, ":num_quick_attachments", 0),
            (party_get_attached_party_with_rank, ":helper_party", "p_main_party", 0),
            (call_script, "script_party_add_party", ":helper_party", "p_temp_party"), #Add remaining prisoners to our reinforcements
          (try_end),
          (troop_clear_inventory, "trp_temp_troop"),
          (call_script, "script_party_calculate_loot", "p_encountered_party_backup"),
          (gt, reg0, 0),
          (change_screen_loot, "trp_temp_troop"),
        (else_try),
          #finished all
          (try_begin),
#            (gt, "$g_ally_party", 0),
            (end_current_battle),
          (try_end),
          (call_script, "script_party_give_xp_and_gold", "p_encountered_party_backup"),
          (try_begin),
            (eq, "$g_enemy_party", 0),
            (display_message,"str_error_string"),
          (try_end),
          (call_script, "script_clear_party_group", "$g_enemy_party"),
          (try_begin),
            (eq, "$g_next_menu", -1),
            (leave_encounter),
            (change_screen_return),
          (else_try),
            (jump_to_menu, "$g_next_menu"),
          (try_end),
        (try_end),
      ],
    [
      ("continue",[],"Continue...",[]),
        ]
  ),

  (
    "enemy_slipped_away",0,
    "{s17}",
    "none",
    [],
    [
      ("continue",[],"Continue...",[(jump_to_menu,"mnu_total_victory")]),
    ]
  ),

  (
    "total_defeat",0,
    "You shouldn't be reading this...",
    "none",
    [
           # Free prisoners
          (party_get_num_prisoner_stacks, ":num_prisoner_stacks","p_main_party"),
          (try_for_range, ":stack_no", 0, ":num_prisoner_stacks"),
            (party_prisoner_stack_get_troop_id, ":stack_troop","p_main_party",":stack_no"),
            (troop_is_hero, ":stack_troop"),
            (troop_set_slot, ":stack_troop", slot_troop_is_prisoner, 0),
          (try_end),

          (troop_get_inventory_capacity, ":inv_cap", "trp_player"),
          (try_for_range, ":i_slot", 0, ":inv_cap"),
            (troop_get_inventory_slot, ":item_id", "trp_player", ":i_slot"),
            (ge, ":item_id", 0),
            (troop_get_inventory_slot_modifier, ":item_modifier", "trp_player", ":i_slot"),
            (try_begin),
              (is_between, ":item_id", trade_goods_begin, trade_goods_end),
              (assign, ":randomness", 20),
            (else_try),
              (is_between, ":item_id", horses_begin, horses_end),
              (assign, ":randomness", 15),
            (else_try),
              (this_or_next|is_between, ":item_id", weapons_begin, weapons_end),
              (is_between, ":item_id", ranged_weapons_begin, ranged_weapons_end),
              (assign, ":randomness", 5),
            (else_try),
              (this_or_next|is_between, ":item_id", armors_begin, armors_end),
              (is_between, ":item_id", shields_begin, shields_end),
              (assign, ":randomness", 5),
            (try_end),
            (store_random_in_range, ":random_no", 0, 100),
            (lt, ":random_no", ":randomness"),
            (troop_remove_item, "trp_player", ":item_id"),
            
            (party_get_slot, ":cur_loot_slot", "$g_enemy_party", slot_party_next_looted_item_slot),
            (val_add, ":cur_loot_slot", slot_party_looted_item_1),
            (party_set_slot, "$g_enemy_party", ":cur_loot_slot", ":item_id"),
            (val_sub, ":cur_loot_slot", slot_party_looted_item_1),
            (val_add, ":cur_loot_slot", slot_party_looted_item_1_modifier),
            (party_set_slot, "$g_enemy_party", ":cur_loot_slot", ":item_modifier"),
            (val_sub, ":cur_loot_slot", slot_party_looted_item_1_modifier),
            (val_add, ":cur_loot_slot", 1),
            (val_mod, ":cur_loot_slot", num_party_loot_slots),
            (party_set_slot, "$g_enemy_party", slot_party_next_looted_item_slot, ":cur_loot_slot"),
           (try_end),

          (store_troop_gold, ":cur_gold", "trp_player"),
          (store_div, ":max_lost", ":cur_gold", 4),
          (store_div, ":min_lost", ":cur_gold", 10),
          (store_random_in_range, ":lost_gold", ":min_lost", ":max_lost"),
          (troop_remove_gold, "trp_player", ":lost_gold"),

          (assign, "$g_move_heroes", 0),
          (party_clear, "p_temp_party"),
          (call_script, "script_party_add_party_prisoners", "p_temp_party", "p_main_party"),
          (call_script, "script_party_prisoners_add_party_companions", "p_temp_party", "p_main_party"),
          (distribute_party_among_party_group, "p_temp_party", "$g_enemy_party"),
        
          (call_script, "script_party_remove_all_companions", "p_main_party"),
          (assign, "$g_move_heroes", 1),
          (call_script, "script_party_remove_all_prisoners", "p_main_party"),

          (try_begin),
            (eq, "$g_next_menu", -1),
            (leave_encounter),
            (change_screen_return),
          (else_try),
            (jump_to_menu, "$g_next_menu"),
          (try_end),
          (try_begin),
            (gt, "$g_ally_party", 0),
            (call_script, "script_party_wound_all_members", "$g_ally_party"),
          (try_end),
      ],
    []
  ),
  
  (
    "pre_join",0,
    "You come accross a battle where {s2} are attacking {s1}. You decide to...",
    "none",
    [
        (str_store_party_name, 1,"$g_encountered_party"),
        (str_store_party_name, 2,"$g_encountered_party_2"),
      ],
    [
      ("pre_join_help_attackers",[
          (store_faction_of_party, ":attacker_faction", "$g_encountered_party_2"),
          (store_relation, ":attacker_relation", ":attacker_faction", "fac_player_faction"),
          (store_faction_of_party, ":defender_faction", "$g_encountered_party"),
          (store_relation, ":defender_relation", ":defender_faction", "fac_player_faction"),
          (ge, ":attacker_relation", -1),
          (le, ":defender_relation", -1),
          ],
          "Go and help the {s2}.",[
              (select_enemy,0),
              (assign,"$g_enemy_party","$g_encountered_party"),
              (assign,"$g_ally_party","$g_encountered_party_2"),
              (jump_to_menu,"mnu_join_battle")]),
      ("pre_join_help_defenders",[
          (store_faction_of_party, ":attacker_faction", "$g_encountered_party_2"),
          (store_relation, ":attacker_relation", ":attacker_faction", "fac_player_faction"),
          (store_faction_of_party, ":defender_faction", "$g_encountered_party"),
          (store_relation, ":defender_relation", ":defender_faction", "fac_player_faction"),
          (ge, ":defender_relation", -1),
          (le, ":attacker_relation", -1),
          ],
          "Rush to the aid of the {s1}.",[
              (select_enemy,1),
              (assign,"$g_enemy_party","$g_encountered_party_2"),
              (assign,"$g_ally_party","$g_encountered_party"),
              (jump_to_menu,"mnu_join_battle")]),
      ("pre_join_leave",[],"Don't get involved.",[(leave_encounter),(change_screen_return)]),
    ]
  ),
  (
    "join_battle",0,
    "You are helping the {s2} against the {s1}. You have {reg10} troops fit for battle against the enemy's {reg11}.",
    "none",
    [
        (str_store_party_name, 1,"$g_enemy_party"),
        (str_store_party_name, 2,"$g_ally_party"),

        (call_script, "script_encounter_calculate_fit"),

        (try_begin),
          (eq, "$new_encounter", 1),
          (assign, "$new_encounter", 0),
          (call_script, "script_encounter_init_variables"),
##          (assign, "$capture_screen_shown", 0),
##          (assign, "$loot_screen_shown", 0),
##          (assign, "$g_battle_result", 0),
##          (assign, "$cant_leave_encounter", 0),
##          (assign, "$last_defeated_hero", 0),
##          (assign, "$last_freed_hero", 0),
##          (call_script, "script_party_copy", "p_main_party_backup", "p_main_party"),
##          (call_script, "script_party_copy", "p_encountered_party_backup", "p_collective_enemy"),
##          (call_script, "script_party_copy", "p_ally_party_backup", "p_collective_ally"),
        (else_try), #second or more turn
          (eq, "$g_leave_encounter",1),
          (change_screen_return),
        (try_end),

        (try_begin),
          (call_script, "script_party_count_fit_regulars","p_collective_enemy"),
          (assign, ":num_enemy_regulars_remaining", reg(0)),
          (assign, ":enemy_finished",0),
          (try_begin),
            (eq, "$g_battle_result", 1),
            (eq, ":num_enemy_regulars_remaining", 0), #battle won
            (assign, ":enemy_finished",1),
          (else_try),
            (eq, "$g_engaged_enemy", 1),
            (le, "$g_enemy_fit_for_battle",0),
            (ge, "$g_friend_fit_for_battle",1),
            (assign, ":enemy_finished",1),
          (try_end),
          (this_or_next|eq, ":enemy_finished",1),
          (eq,"$g_enemy_surrenders",1),
          (assign, "$g_next_menu", -1),
          (jump_to_menu, "mnu_total_victory"),
        (else_try),
#          (eq, "$encountered_party_hostile", 1),
          (call_script, "script_party_count_fit_regulars","p_collective_friends"),
          (assign, ":ally_num_soldiers", reg(0)),
          (assign, ":battle_lost", 0),
          (try_begin),
            (eq, "$g_battle_result", -1),
            (eq, ":ally_num_soldiers", 0), #battle lost
            (assign, ":battle_lost",1),
          (try_end),
          (this_or_next|eq, ":battle_lost",1),
          (eq,"$g_player_surrenders",1),
        # TODO: Split prisoners to all collected parties.
        # NO Need? Let default battle logic do it for us. 
#          (assign, "$g_move_heroes", 0),
#          (call_script, "script_party_add_party_prisoners", "$g_enemy_party", "p_collective_ally"),
#          (call_script, "script_party_prisoners_add_party_companions", "$g_enemy_party", "p_collective_ally"),
        #TODO: Clear all attached allies.
#          (call_script, "script_party_remove_all_companions", "$g_ally_party"),
#          (call_script, "script_party_remove_all_prisoners", "$g_ally_party"),
          (leave_encounter),
          (change_screen_return),
        (try_end),
      ],
    [
      ("join_attack",[
#          (neq, "$encountered_party_hostile", 0),
          (neg|troop_is_wounded, "trp_player"),
##          (store_troop_health,reg(5),"trp_player"),
##          (ge,reg(5),20),
          ],
                            "Charge the enemy.",[
                                (assign, "$g_battle_result", 0),
                                (call_script, "script_calculate_renown_value"),
                                (call_script, "script_calculate_battle_advantage"),
                                (set_battle_advantage, reg0),
                                (set_party_battle_mode),
                                (set_jump_mission,"mt_lead_charge"),
                                (call_script, "script_setup_random_scene"),
                                (assign, "$g_next_menu", "mnu_join_battle"),
                                (jump_to_menu, "mnu_battle_debrief"),
                                (change_screen_mission),
                                ]),

      ("join_order_attack",[
#          (gt, "$encountered_party_hostile", 0),
          (call_script, "script_party_count_fit_regulars", "p_main_party"),(ge, reg(0), 2),
          ],
           "Order your troops to join your allies while you stay back.",[(jump_to_menu,"mnu_join_order_attack"),
                                                            ]),
      
#      ("join_attack",[],"Lead a charge against the enemies",[(set_jump_mission,"mt_charge_with_allies"),
#                                (call_script, "script_setup_random_scene"),
#                                                             (change_screen_mission,0)]),
      ("join_leave",[],"Leave.",[(leave_encounter),(change_screen_return)]),
    ]
  ),


  (
    "join_order_attack",0,
    "{s4}^^Your casualties: {s8}^^Allies' casualties: {s9}^^Enemy casualties: {s10}",
    "none",
    [
                                    (call_script, "script_party_calculate_regular_strength", "p_main_party"),
                                    (assign, ":player_party_strength", reg0),
                                    (val_div, ":player_party_strength", 5),
                                    (call_script, "script_party_calculate_regular_strength", "p_collective_friends"),
                                    (assign, ":friend_party_strength", reg0),
                                    (val_div, ":friend_party_strength", 5),
                                    
                                    (call_script, "script_party_calculate_regular_strength", "p_collective_enemy"),
                                    (assign, ":enemy_party_strength", reg0),
                                    (val_div, ":enemy_party_strength", 5),

                                    (assign, ":enemy_party_strength_for_p", ":enemy_party_strength"),
                                    (val_mul, ":enemy_party_strength_for_p", ":player_party_strength"),
                                    (val_div, ":enemy_party_strength_for_p", ":friend_party_strength"),

                                    (val_sub, ":enemy_party_strength", ":enemy_party_strength_for_p"),
                                    (inflict_casualties_to_party_group, "p_main_party", ":enemy_party_strength_for_p", "p_temp_casualties"),
                                    (call_script, "script_print_casualties_to_s0", "p_temp_casualties", 0),
                                    (str_store_string_reg, s8, s0),
                                    
                                    (inflict_casualties_to_party_group, "$g_enemy_party", ":friend_party_strength", "p_temp_casualties"),
                                    (call_script, "script_print_casualties_to_s0", "p_temp_casualties", 0),
                                    (str_store_string_reg, s10, s0),
                                    
                                    (call_script, "script_collect_friendly_parties"),
#                                    (party_collect_attachments_to_party, "$g_ally_party", "p_collective_ally"),

                                    (inflict_casualties_to_party_group, "$g_ally_party", ":enemy_party_strength", "p_temp_casualties"),
                                    (call_script, "script_print_casualties_to_s0", "p_temp_casualties", 0),
                                    (str_store_string_reg, s9, s0),
                                    (party_collect_attachments_to_party, "$g_enemy_party", "p_collective_enemy"),

#                                    (assign, "$cant_leave_encounter", 0),
                                    (assign, "$no_soldiers_left", 0),
                                    (try_begin),
                                      (call_script, "script_party_count_fit_regulars","p_main_party"),
                                      (le, reg(0), 0),
                                      (assign, "$no_soldiers_left", 1),
                                      (str_store_string, s4, "str_join_order_attack_failure"),
                                    (else_try),
                                      (call_script, "script_party_count_fit_regulars","p_collective_enemy"),
                                      (le, reg(0), 0),
                                      (assign, "$g_battle_result", 1),
                                      (assign, "$no_soldiers_left", 1),
                                      (str_store_string, s4, "str_join_order_attack_success"),
                                    (else_try),
                                      (str_store_string, s4, "str_join_order_attack_continue"),
                                    (try_end),
    ],
    [
      ("continue",[],"Continue...",[
          (jump_to_menu,"mnu_join_battle"),
          ]),
    ]
  ),

  
# Towns
  (
    "zendar",mnf_auto_enter,
    "You enter the town of Zendar.",
    "none",
    [(reset_price_rates,0),(set_price_rate_for_item,"itm_tools",70),(set_price_rate_for_item,"itm_salt",140)],
    [
      ("zendar_enter",[],"_",[(set_jump_mission,"mt_town_default"),(jump_to_scene,"scn_zendar_center"),(change_screen_mission)],"Door to the town centre."),
      ("zendar_tavern",[],"_",[(set_jump_mission,"mt_town_default"),
                                                   (jump_to_scene,"scn_the_happy_boar"),
                                                   (change_screen_mission)],"Door to the tavern."),
      ("zendar_merchant",[],"_",[(set_jump_mission,"mt_town_default"),
                                                   (jump_to_scene,"scn_zendar_merchant"),
                                                   (change_screen_mission)],"Door to the merchant."),
      ("zendar_arena",[],"_",[(set_jump_mission,"mt_town_default"),
                                                   (jump_to_scene,"scn_zendar_arena"),
                                                   (change_screen_mission)],"Door to the arena."),
#      ("zendar_leave",[],"Leave town.",[[leave_encounter],[change_screen_return]]),
      ("town_1_leave",[],"_",[(leave_encounter),(change_screen_return)]),
    ]
  ),
  (
    "salt_mine",mnf_auto_enter,
    "You enter the salt mine.",
    "none",
    [(reset_price_rates,0),(set_price_rate_for_item,"itm_salt",55)],
    [
      ("enter",[],"Enter.",[(set_jump_mission,"mt_town_center"),(jump_to_scene,"scn_salt_mine"),(change_screen_mission)]),
      ("leave",[],"Leave.",[(leave_encounter),(change_screen_return)]),
    ]
  ),
  (
    "four_ways_inn",mnf_auto_enter,
    "You enter the four ways inn.",
    "none",
    [],
    [

#      ("enter",[],"Enter.",[[set_jump_mission,"mt_town_default"],[jump_to_scene,"scn_conversation_scene"],[change_screen_mission]]),
      ("enter",[],"Enter.",[(set_jump_mission,"mt_camera_test"),(jump_to_scene,"scn_four_ways_inn"),(change_screen_mission)]),
      ("leave",[],"Leave.",[(leave_encounter),(change_screen_return)]),
    ]
  ),
  (
    "test_scene",mnf_auto_enter,
    "You enter the test scene.",
    "none",
    [],
    [

      ("enter",[],"Enter.",[[set_jump_mission,"mt_ai_training"],[jump_to_scene,"scn_test_scene"],[change_screen_mission]]),
      ("leave",[],"Leave.",[(leave_encounter),(change_screen_return)]),
    ]
  ),
  (
    "dhorak_keep",0,
#    "Dhorak Keep, the stronghold of the bandits stands overlooking the barren wilderness.",
    "You enter the Dhorak Keep",
    "none",
    [],
    [
      ("enter",[],"Enter.",[(set_jump_mission,"mt_town_center"),(jump_to_scene,"scn_dhorak_keep"),(change_screen_mission)]),
      ("leave",[],"Leave.",[(leave_encounter),(change_screen_return)]),
    ]
  ),
  (
    "join_siege_outside",0,
    "{s1} has been besieged by {s2}.",
    "none",
    [
        (str_store_party_name, 1, "$g_encountered_party"),
        (str_store_party_name, 2, "$g_encountered_party_2"),
        (set_background_mesh, "mesh_pic_siege_sighted"),
    ],
    [
      ("approach_besiegers",[],"Approach the besiegers camp.",[
          (jump_to_menu, "mnu_besiegers_camp_with_allies"),
                                ]),
      ("pass_through_siege",[],"Pass through the siege and enter {s1}.",[
            (jump_to_menu,"mnu_cut_siege_without_fight"),
          ]),
      ("leave",[],"Leave.",[(leave_encounter),(change_screen_return)]),
    ]
  ),
  (
    "cut_siege_without_fight",0,
    "The besiegers let you approach the castle gates without challange.",
    "none",
    [],
    [
      ("continue",[],"Continue",[(try_begin),
                                   (this_or_next|eq, "$g_encountered_party_faction", "fac_player_faction"),
                                   (eq, "$g_encountered_party_faction", "$players_kingdom"),
                                   (jump_to_menu, "mnu_town"),
                                 (else_try),
                                   (jump_to_menu, "mnu_castle_outside"),
                                 (try_end)]),
      ]
  ),
  (
    "besiegers_camp_with_allies",0,
    "{s1} has been besieged by {s2}.",
    "none",
    [
        (str_store_party_name, 1, "$g_encountered_party"),
        (str_store_party_name, 2, "$g_encountered_party_2"),
        (eq, "$g_leave_encounter",1),
        (change_screen_return),
        ],
    [
      ("talk_to_siege_commander",[]," Request a meeting with the commander of the siege.",[
                                (modify_visitors_at_site,"scn_conversation_scene"),(reset_visitors),
                                (set_visitor,0,"trp_player"),
                                (party_stack_get_troop_id, ":siege_leader_id","$g_encountered_party_2",0),
                                (party_stack_get_troop_dna,":siege_leader_dna","$g_encountered_party_2",0),
                                (set_visitor,17,":siege_leader_id",":siege_leader_dna"),
                                (set_jump_mission,"mt_conversation_encounter"),
                                (jump_to_scene,"scn_conversation_scene"),
                                (assign, "$talk_context", tc_siege_commander),
                                (change_screen_map_conversation, ":siege_leader_id")]),
#      ("join_siege_wait",[],"Join the siege and wait",[
#           (rest_for_hours, 12),
#           (assign,"$auto_join_siege_town","$g_encountered_party"),
#           (change_screen_return),
#          ]),
      ("leave",[],"Leave.",[(leave_encounter),(change_screen_return)]),
    ]
  ),
  (
    "castle_outside",0,
    "You are outside {s1}. {s2} {s3}",
    "none",
    [
        (assign, "$g_enemy_party", "$g_encountered_party"),
        (assign, "$g_ally_party", -1),
        (str_store_party_name, 1,"$g_encountered_party"),
        (call_script, "script_encounter_calculate_fit"),
        (try_begin),
          (eq, "$new_encounter", 1),
          (assign, "$new_encounter", 0),
          (call_script, "script_encounter_init_variables"),
          (assign, "$entry_to_town_forbidden",0),
          (assign, "$current_town","$g_encountered_party"),
          (assign, "$sneaked_into_town",0),
          (assign, "$town_entered", 0),
          (assign, "$waiting_for_arena_fight_result", 0),
          (assign, "$encountered_party_hostile", 0),
          (assign, "$encountered_party_friendly", 0),
          (try_begin),
            (neq,"$g_player_besiege_town","$g_encountered_party"),
            (assign,"$g_player_besiege_town",-1),
          (try_end),
          (try_begin),
            (lt, "$g_encountered_party_relation", 0),
            (assign, "$encountered_party_hostile", 1),
            (assign,"$entry_to_town_forbidden",1),
          (try_end),

          (assign,"$cant_sneak_into_town",0),
          (try_begin),
            (eq,"$current_town","$last_sneak_attempt_town"),
            (store_current_hours,reg(2)),
            (val_sub,reg(2),"$last_sneak_attempt_time"),
            (lt,reg(2),12),
            (assign,"$cant_sneak_into_town",1),
          (try_end),
        (else_try), #second or more turn
          (eq, "$g_leave_encounter",1),
          (change_screen_return),
        (try_end),

        (str_clear,3),
        (try_begin), 
          (eq,"$entry_to_town_forbidden",1),
          (try_begin),
            (eq,"$cant_sneak_into_town",1),
            (str_store_string,3,"str_sneaking_to_town_impossible"),
          (else_try),
            (str_store_string,3,"str_entrance_to_town_forbidden"),
          (try_end),
        (try_end),


        (party_get_num_companions, reg(7),"p_collective_enemy"),
        (assign,"$castle_undefended",0),
        (try_begin),
          (eq,reg(7),0),
          (assign,"$castle_undefended",1),
#          (party_set_faction,"$g_encountered_party","fac_neutral"),
#          (party_set_slot, "$g_encountered_party", slot_town_lord, stl_unassigned),
          (str_store_string, 2, "str_castle_is_abondened"),
        (else_try),
          (eq,"$g_encountered_party_faction","fac_player_faction"),
          (str_store_string, 2, "str_place_is_occupied_by_player"),
        (else_try),
          (lt, "$g_encountered_party_relation", 0),
          (str_store_string, 2, "str_place_is_occupied_by_enemy"),
        (else_try),
          (str_store_string, 2, "str_place_is_occupied_by_friendly"),
        (try_end),

        (try_begin),
          (eq,"$g_leave_town_outside",1),
          (assign,"$g_leave_town_outside",0),
          (assign, "$g_permitted_to_center", 0),
          (change_screen_return),
##### TODO: QUESTS COMMENT OUT BEGIN
##        (else_try),
##          (check_quest_active,"qst_escort_lady",1),
##          (quest_slot_eq, "qst_escort_lady", slot_quest_target_center, "$g_encountered_party"),
##          (quest_get_slot, ":quest_object_troop", "qst_escort_lady", slot_quest_object_troop),
##          (modify_visitors_at_site,"scn_conversation_scene"),(reset_visitors),
##          (set_visitor,0,"trp_player"),
##          (set_visitor,17,":quest_object_troop"),
##          (set_jump_mission,"mt_conversation_encounter"),
##          (jump_to_scene,"scn_conversation_scene"),
##          (assign, "$talk_context", tc_entering_center_quest_talk),
##          (change_screen_map_conversation, ":quest_object_troop"),
##### TODO: QUESTS COMMENT OUT END
        (else_try),
          (gt, "$lord_requested_to_talk_to", 0),
#          (store_current_hours, ":cur_hours"),
#          (neq, ":cur_hours", "$quest_given_time"),
          (modify_visitors_at_site,"scn_conversation_scene"),(reset_visitors),
          (assign, ":cur_lord", "$lord_requested_to_talk_to"),
          (assign, "$lord_requested_to_talk_to", 0),
          (set_visitor,0,"trp_player"),
          (set_visitor,17,":cur_lord"),
          (set_jump_mission,"mt_conversation_encounter"),
          (jump_to_scene,"scn_conversation_scene"),
          (assign, "$talk_context", tc_lord_talk_in_center),
          (change_screen_map_conversation, ":cur_lord"),
        (else_try),
          (party_slot_eq,"$g_encountered_party", slot_party_type,spt_castle),
          (ge, "$g_encountered_party_relation", 0),
#          (this_or_next|eq,"$g_encountered_party_faction","fac_player_faction"),
#          (this_or_next|eq,"$castle_undefended",1),
#          (eq, "$g_permitted_to_center",1),
          (jump_to_menu, "mnu_town"),
        (else_try),
          (party_slot_eq,"$g_encountered_party", slot_party_type,spt_town),
          (ge, "$g_encountered_party_relation", 0),
          (jump_to_menu, "mnu_town"),
        (else_try),
          (eq, "$g_player_besiege_town", "$g_encountered_party"),
          (jump_to_menu, "mnu_castle_besiege"),
        (try_end),
        ],
    [
#        ("talk_to_castle_commander",[
#            (party_get_num_companions, ":no_companions", "$g_encountered_party"),
#            (ge, ":no_companions", 1),
#            (eq,"$ruler_meeting_denied",0), #this variable is removed
#            ],
#         "Request a meeting with the lord of the castle.",[
#             (modify_visitors_at_site,"scn_conversation_scene"),(reset_visitors),
#             (set_visitor,0,"trp_player"),
#             (party_stack_get_troop_id, reg(6),"$g_encountered_party",0),
#             (party_stack_get_troop_dna,reg(7),"$g_encountered_party",0),
#             (set_visitor,17,reg(6),reg(7)),
#             (set_jump_mission,"mt_conversation_encounter"),
#             (jump_to_scene,"scn_conversation_scene"),
#             (assign, "$talk_context", tc_castle_commander),
#             (change_screen_map_conversation, reg(6))
#             ]),
        #TODO: Fill here
      ("request_meeting",[(this_or_next|eq,"$entry_to_town_forbidden",1),
                          (party_slot_eq,"$g_encountered_party", slot_party_type,spt_castle)],
       "Approach the gates and hail the guard.",[(modify_visitors_at_site,"scn_conversation_scene"),(reset_visitors),
                                                   (set_visitor,0,"trp_player"),
                                                   (store_faction_of_party, ":cur_faction", "$g_encountered_party"),
                                                   (faction_get_slot, ":cur_guard", ":cur_faction", slot_faction_guard_troop),
                                                   (set_visitor,17,":cur_guard"),
                                                   (set_jump_mission,"mt_conversation_encounter"),
                                                   (jump_to_scene,"scn_conversation_scene"),
                                                   (assign, "$talk_context", tc_lord_talk_in_center),
                                                   (change_screen_map_conversation, ":cur_guard")]),
      ("town_sneak",[(party_slot_eq,"$g_encountered_party", slot_party_type,spt_town),
                     (eq,"$entry_to_town_forbidden",1),
                     (eq,"$cant_sneak_into_town",0)],
       "Disguise yourself and try to sneak through the town gates.",[
          (store_random,reg(9),100),
          (try_begin),
            (lt, reg(9), 50),
            (jump_to_menu,"mnu_sneak_into_town_caught"),
          (else_try),
            (assign, "$sneaked_into_town",1),
            (jump_to_menu,"mnu_sneak_into_town_suceeded"),
          (try_end)]),

        #SANGO NEW ATTACK
       ("attack_town",[
#       (eq,"$entry_to_town_forbidden",1),
       (store_encountered_party, reg5),
       (store_faction_of_party,"$governer_faction",reg5),
       (try_begin),
         (eq,"$governer_faction","fac_kingdom_caowei"),
         (assign,":temp_guoli","$wei_guoli"),
       (else_try),
         (eq,"$governer_faction","fac_kingdom_shuhan"),
         (assign,":temp_guoli","$shu_guoli"),
       (else_try),
         (eq,"$governer_faction","fac_kingdom_wu"),
         (assign,":temp_guoli","$wu_guoli"),
       (try_end),
       (ge,":temp_guoli",0),
       (lt,":temp_guoli",1000),
       (assign,":party",reg5),(call_script, "script_wounded", ":party"),
       (ge, reg(0), 1)],
       "You decide to attack the town!",[(party_get_slot, ":sneak_scene", reg5,slot_town_center), 
                                                (set_party_battle_mode),
                                                (set_jump_mission,"mt_lead_charge_castle"),
                                                (jump_to_scene,":sneak_scene"),
                                                (change_screen_mission)]),             
       ("change_town_faction",[(eq,"$entry_to_town_forbidden",1),(store_encountered_party, reg5),(assign,":party",reg5),
       (store_faction_of_party,"$governer_faction",reg5),
       (store_relation,reg(48),"$governer_faction","fac_player_faction"),
       (party_get_num_companions,":num_fighter_party",reg5),
       (lt,reg(48),0),
       (call_script, "script_wounded", ":party"),
       (this_or_next|lt, reg(0), 1),(eq,":num_fighter_party",0)],"You recive the town!",[(try_begin),
       (eq,"$player_relation_to_kingdom_caowei",rel_ally),
       (assign,"$join_faction","fac_kingdom_caowei"),
       (assign,"$youther","trp_wei_youth"),(assign,"$solider","trp_wei_solider"),(assign,"$horse_solider","trp_wei_horse_solider"),
       (else_try),(eq,"$player_relation_to_kingdom_shuhan",rel_ally),(assign,"$join_faction","fac_kingdom_shuhan"),
       (assign,"$youther","trp_shu_youth"),(assign,"$solider","trp_shu_solider"),(assign,"$horse_solider","trp_shu_horse_solider"),
       (else_try),(eq,"$player_relation_to_kingdom_wu",rel_ally),(assign,"$join_faction","fac_kingdom_wu"),
       (assign,"$youther","trp_wu_youth"),(assign,"$solider","trp_wu_solider"),(assign,"$horse_solider","trp_wu_horse_solider"),(end_try),
       (party_set_faction,reg5,"$join_faction"),
       (party_add_members,reg5,"$youther",20),(party_add_members,reg5,"$solider",10),(party_add_members,reg5,"$horse_solider",10),
       (val_add,"$quest_prestige",200)]), 
        ("change_town_faction",[(store_encountered_party, reg5),
       (store_faction_of_party,"$governer_faction",reg5),
       (eq,"$governer_faction","fac_neutral")],
       "You recive the town!",[(try_begin),(eq,"$player_relation_to_kingdom_caowei",rel_ally),(assign,"$join_faction","fac_kingdom_caowei"),
       (assign,"$youther","trp_wei_youth"),(assign,"$solider","trp_wei_solider"),(assign,"$horse_solider","trp_wei_horse_solider"),
       (else_try),(eq,"$player_relation_to_kingdom_shuhan",rel_ally),(assign,"$join_faction","fac_kingdom_shuhan"),
       (assign,"$youther","trp_shu_youth"),(assign,"$solider","trp_shu_solider"),(assign,"$horse_solider","trp_shu_horse_solider"),
       (else_try),(eq,"$player_relation_to_kingdom_wu",rel_ally),(assign,"$join_faction","fac_kingdom_wu"),
       (assign,"$youther","trp_wu_youth"),(assign,"$solider","trp_wu_solider"),(assign,"$horse_solider","trp_wu_horse_solider"),(end_try),
       (party_set_faction,reg5,"$join_faction"),(party_add_members,reg5,"$youther",30),(party_add_members,reg5,"$solider",20),
       (party_add_members,reg5,"$horse_solider",20),(val_add,"$quest_prestige",200)]), 

##      ("castle_attack_walls",
##       [
##           (party_slot_eq,"$g_encountered_party", slot_party_type,spt_castle),
##           (store_faction_of_party,reg(3),  "$g_encountered_party"),
##           (store_relation, reg(5), reg(3), "fac_player_faction"),
##           (lt, reg(5), 0),
##           (lt, "$g_encountered_party_2", 1),
##           (call_script, "script_party_count_fit_regulars","p_main_party"),
##           (gt, reg(0), 0),
##        ],
##         "Attack the walls.",
##         [
##             (jump_to_menu, "mnu_castle_attack_walls_begin"),
##          ]),
      ("castle_start_siege",
       [   (eq,1,2),
           (gt, "$players_kingdom", 0),
           (store_faction_of_party,reg(3),  "$g_encountered_party"),
           (store_relation, ":reln", "$g_encountered_party_faction", "$players_kingdom"),
           (lt, ":reln", 0),
           (lt, "$g_encountered_party_2", 1),
#           (party_slot_eq, "$g_encountered_party", slot_party_type, spt_castle),
           (call_script, "script_party_count_fit_regulars","p_main_party"),
           (gt, reg(0), 0),
           ],
       "Besiege the castle...",
       [
           (assign,"$g_player_besiege_town","$g_encountered_party"),
           (jump_to_menu, "mnu_castle_besiege"),
           ]),
       #TODO: Fill here
      ("castle_leave",[],"Leave.",[(change_screen_return,0)]),
      ("castle_cheat_interior",[(eq, "$cheat_mode", 1)], "CHEAT! Interior.",[(set_jump_mission,"mt_ai_training"),
                                                       (party_get_slot, ":castle_scene", "$current_town", slot_town_castle),
                                                       (jump_to_scene,":castle_scene"),
                                                       (change_screen_mission)]),
      ("castle_cheat_exterior",[(eq, "$cheat_mode", 1)], "CHEAT! Exterior.",[
#                                                       (set_jump_mission,"mt_town_default"),
                                                       (set_jump_mission,"mt_ai_training"),
                                                       (party_get_slot, ":castle_scene", "$current_town", slot_castle_exterior),
                                                       (jump_to_scene,":castle_scene"),
                                                       (change_screen_mission)]),
    ]
  ),

   (
    "castle_besiege",0,
    "You have besieged {s1}. {s2} {s3}",
    "none",
    [
        (set_background_mesh, "mesh_pic_siege_sighted"),
        (assign, "$g_siege_force_wait", 0),
        (try_begin),
          (party_slot_eq, "$g_encountered_party", slot_center_is_besieged_by, -1),
          (party_set_slot, "$g_encountered_party", slot_center_is_besieged_by, "p_main_party"),
          (assign, "$g_siege_method", 0),
        (try_end),

        (party_get_slot, ":town_food_store", "$g_encountered_party", slot_party_food_store),
        (call_script, "script_center_get_food_consumption", "$g_encountered_party"),
        (assign, ":food_consumption", reg0),
        (assign, reg7, ":food_consumption"),
        (assign, reg8, ":town_food_store"),
        (store_div, reg3, ":town_food_store", ":food_consumption"),

        (try_begin),
          (party_slot_eq, "$g_encountered_party", slot_party_type, spt_town),
          (assign, reg6, 1),
        (else_try),
          (assign, reg6, 0),
        (try_end),
        
        (try_begin),
          (gt, reg3, 0),
          (str_store_string, s2, "@It seems that the {reg6?town's:castle's} food stores can last for {reg3} days ({reg7}/{reg8})."),
        (else_try),
          (str_store_string, s2, "@The {reg6?town's:castle's} food stores have run out and the defenders are starving."),
        (try_end),

        (str_store_string, s3, "str_empty_string"),
        (try_begin),
          (ge, "$g_siege_method", 1),
          (store_current_hours, ":cur_hours"),
          (try_begin),
            (lt, ":cur_hours",  "$g_siege_method_finish_hours"),
            (store_sub, reg9, "$g_siege_method_finish_hours", ":cur_hours"),
            (try_begin),
              (eq, "$g_siege_method", 1),
              (str_store_string, s3, "@You are preparing to attack the walls ({reg9} hours to finish preparations)."),
            (else_try),
              (eq, "$g_siege_method", 2),
              (str_store_string, s3, "@Your forces are building a siege tower ({reg9} to finish)."),
            (try_end),
          (else_try),
            (try_begin),
              (eq, "$g_siege_method", 1),
              (str_store_string, s3, "@You are ready for attacking the walls."),
            (else_try),
              (eq, "$g_siege_method", 2),
              (str_store_string, s3, "@The siege tower is built and ready for an attack."),
            (try_end),
          (try_end),
        (try_end),
        
        #Check if enemy leaves the castle to us...
        (try_begin),
          (eq, "$g_castle_left_to_player",1), #we come here after dialog. Empty the castle and send parties away.
          (assign, "$g_castle_left_to_player",0),
          (store_faction_of_party, ":castle_faction", "$g_encountered_party"),
          (party_set_faction,"$g_encountered_party","fac_neutral"), #temporarily erase faction so that it is not the closest town
          (party_get_num_attached_parties, ":num_attached_parties_to_castle","$g_encountered_party"),
          (try_for_range_backwards, ":iap", 0, ":num_attached_parties_to_castle"),
            (party_get_attached_party_with_rank, ":attached_party", "$g_encountered_party", ":iap"),
            (party_detach, ":attached_party"),
            (party_get_slot, ":attached_party_type", ":attached_party", slot_party_type),
            (eq, ":attached_party_type", spt_kingdom_hero_party),
            (party_set_slot, ":attached_party", slot_party_ai_state, spai_undefined),
            (store_faction_of_party, ":attached_party_faction", ":attached_party"),
            (call_script, "script_get_closest_walled_center_of_faction", ":attached_party", ":attached_party_faction"),
            (party_set_ai_object, ":attached_party", reg0),
            (party_set_ai_behavior, ":attached_party", ai_bhvr_travel_to_party),
            (party_set_flags, ":attached_party", pf_default_behavior, 0),
          (try_end),
          (call_script, "script_party_remove_all_companions", "$g_encountered_party"),
          (change_screen_return),
          (party_collect_attachments_to_party, "$g_encountered_party", "p_collective_enemy"), #recalculate so that
          (call_script, "script_party_copy", "p_encountered_party_backup", "p_collective_enemy"), #leaving troops will not be considered as captured
          (party_set_faction,"$g_encountered_party",":castle_faction"), 
        (try_end),

        #Check for victory or defeat....
        (assign, "$g_enemy_party", "$g_encountered_party"),
        (assign, "$g_ally_party", -1),
        (str_store_party_name, 1,"$g_encountered_party"),
        (call_script, "script_encounter_calculate_fit"),
        
        (assign, reg11, "$g_enemy_fit_for_battle"),
        (assign, reg10, "$g_friend_fit_for_battle"),


        (try_begin),
          (eq, "$g_leave_encounter",1),
          (change_screen_return),
        (else_try),
          (call_script, "script_party_count_fit_regulars","p_collective_enemy"),
          (assign, ":enemy_finished",0),
          (try_begin),
            (eq, "$g_battle_result", 1),
            (assign, ":enemy_finished",1),
          (else_try),
            (le, "$g_enemy_fit_for_battle",0),
            (ge, "$g_friend_fit_for_battle",1),
            (assign, ":enemy_finished",1),
          (try_end),
          (this_or_next|eq, ":enemy_finished",1),
          (eq,"$g_enemy_surrenders",1),
          (assign, "$g_next_menu", "mnu_castle_taken"),
          (jump_to_menu, "mnu_total_victory"),
        (else_try),
          (call_script, "script_party_count_fit_regulars","p_main_party"),
          (assign, ":main_party_fit_regulars", reg(0)),
          (eq, "$g_battle_result", -1),
          (eq, ":main_party_fit_regulars", 0), #all lost
          (assign, "$g_next_menu", "mnu_captivity_start_castle_defeat"),
          (jump_to_menu, "mnu_total_defeat"),
        (try_end),
    ],
    [
      ("siege_request_meeting",[(eq, "$cant_talk_to_enemy", 0)],"Call for a meeting with the castle commander.", [
          (assign, "$cant_talk_to_enemy", 1),
          (assign, "$g_enemy_surrenders",0),
          (assign, "$g_castle_left_to_player",0),
          (assign, "$talk_context", tc_castle_commander),
          (party_get_num_attached_parties, ":num_attached_parties_to_castle","$g_encountered_party"),
          (try_begin),
            (gt, ":num_attached_parties_to_castle", 0),
            (party_get_attached_party_with_rank, ":leader_attached_party", "$g_encountered_party", 0),
            (call_script, "script_setup_party_meeting", ":leader_attached_party"),
          (else_try),
            (call_script, "script_setup_party_meeting", "$g_encountered_party"),
          (try_end),
           ]),
        
      ("wait_24_hours",[],"Wait until tomorrow.", [
          (assign,"$auto_besiege_town","$g_encountered_party"),
          (assign, "$g_siege_force_wait", 1),
          (store_time_of_day,":cur_time_of_day"),
          (val_add, ":cur_time_of_day", 1),
          (assign, ":time_to_wait", 31),
          (val_sub,":time_to_wait",":cur_time_of_day"),
          (val_mod,":time_to_wait",24),
          (val_add, ":time_to_wait", 1),
          (rest_for_hours_interactive, ":time_to_wait", 5, 1), #rest while attackable
          (assign, "$cant_talk_to_enemy", 0),
          (change_screen_return),
          ]),

      
      ("castle_lead_attack",[(ge, "$g_siege_method", 1),(gt, "$g_friend_fit_for_battle", 3),(store_current_hours, ":cur_hours"),
                             (ge, ":cur_hours",  "$g_siege_method_finish_hours"),
                             ],
       "Lead your soldiers to attack.", [
           (party_get_slot, ":battle_scene", "$g_encountered_party", slot_castle_exterior),
           (set_party_battle_mode),
           (try_begin),
             (party_slot_eq, "$current_town", slot_center_siege_with_belfry, 1),
             (set_jump_mission,"mt_castle_attack_walls_belfry"),
           (else_try),
             (set_jump_mission,"mt_castle_attack_walls_ladder"),
           (try_end),
           (jump_to_scene,":battle_scene"),
           (assign, "$cant_talk_to_enemy", 0),           
#           (jump_to_menu,"mnu_castle_outside"),
           (assign, "$g_next_menu", "mnu_castle_besiege"),
           (jump_to_menu, "mnu_battle_debrief"),
           (change_screen_mission),
       ]),
      ("attack_stay_back",[(ge, "$g_siege_method", 1),(gt, "$g_friend_fit_for_battle", 3),(store_current_hours, ":cur_hours"),
                             (ge, ":cur_hours",  "$g_siege_method_finish_hours"),],
       "Order your soldiers to attack while you stay back...", [(assign, "$cant_talk_to_enemy", 0),(jump_to_menu,"mnu_castle_attack_walls_simulate")]),

      ("build_ladders",[(party_slot_eq, "$current_town", slot_center_siege_with_belfry, 0),(eq, "$g_siege_method", 0)],
       "Prepare to attack the walls.", [(jump_to_menu,"mnu_construct_ladders")]),

      ("build_siege_tower",[(party_slot_eq, "$current_town", slot_center_siege_with_belfry, 1),(eq, "$g_siege_method", 0)],
       "Build a siege tower.", [(jump_to_menu,"mnu_construct_siege_tower")]),
      
      ("lift_siege",[],"Leave.",[(assign,"$g_player_besiege_town",0),(change_screen_return)]),
    ]
  ),
  (
    "construct_ladders",0,
    "As the party member with the highest engineer skill ({reg2}), {reg3?you reckon:{s3} reckons} that building ladders for the attack will take\
 {reg4} hours.",
    "none",
    [(call_script, "script_get_max_skill_of_player_party", "skl_engineer"),
     (assign, ":max_skill", reg0),
     (assign, ":max_skill_owner", reg1),
     (assign, reg2, ":max_skill"),

     (store_sub, reg4, 14, ":max_skill"),
     (val_mul, reg4, 2),
     (val_div, reg4, 3),
     
     (try_begin),
       (eq, ":max_skill_owner", "trp_player"),
       (assign, reg3, 1),
     (else_try),
       (assign, reg3, 0),
       (str_store_troop_name, s3, ":max_skill_owner"),
     (try_end),
    ],
    [
      ("build_ladders_cont",[],
       "Go on.", [
           (assign, "$g_siege_method", 1),
           (store_current_hours, ":cur_hours"),
           (call_script, "script_get_max_skill_of_player_party", "skl_engineer"),
           (store_sub, ":hours_takes", 14, reg0),
           (val_mul, ":hours_takes", 2),
           (val_div, ":hours_takes", 3),
           (store_add, "$g_siege_method_finish_hours",":cur_hours", ":hours_takes"),
           (assign,"$auto_besiege_town","$current_town"),
           (rest_for_hours_interactive, 96, 5, 1), #rest while attackable. A trigger will divert control when attack is ready.
           (change_screen_return),
           ]),
      ("forget_it",[],
       "Forget it.", [(jump_to_menu,"mnu_castle_besiege")]),
        ],
  ),
  
  (
    "construct_siege_tower",0,
    "As the party member with the highest engineer skill ({reg2}), {reg3?you reckon:{s3} reckons} that building a siege tower will take\
 {reg4} hours.",
    "none",
    [(call_script, "script_get_max_skill_of_player_party", "skl_engineer"),
     (assign, ":max_skill", reg0),
     (assign, ":max_skill_owner", reg1),
     (assign, reg2, ":max_skill"),

     (store_sub, reg4, 15, ":max_skill"),
     (val_mul, reg4, 6),
     
     (try_begin),
       (eq, ":max_skill_owner", "trp_player"),
       (assign, reg3, 1),
     (else_try),
       (assign, reg3, 0),
       (str_store_troop_name, s3, ":max_skill_owner"),
     (try_end),
    ],
    [
      ("build_siege_tower_cont",[],
       "Start building.", [
           (assign, "$g_siege_method", 2),
           (store_current_hours, ":cur_hours"),
           (call_script, "script_get_max_skill_of_player_party", "skl_engineer"),
           (store_sub, ":hours_takes", 15, reg0),
           (val_mul, ":hours_takes", 6),
           (store_add, "$g_siege_method_finish_hours",":cur_hours", ":hours_takes"),
           (assign,"$auto_besiege_town","$current_town"),
           (rest_for_hours_interactive, 240, 5, 1), #rest while attackable. A trigger will divert control when attack is ready.
           (change_screen_return),
           ]),
      ("forget_it",[],
       "Forget it.", [(jump_to_menu,"mnu_castle_besiege")]),
        ],
  ),

  
##   (
##    "castle_attack_walls_begin",0,
##    "TODO: Belfry needs to be constructed before the attack can start. It takes 24 hours to construct the belfry.",
##    "none",
##    [(try_begin),
##       (eq, "$g_belfry_construct_town", "$g_encountered_party"),
##       (jump_to_menu, "mnu_castle_attack_walls_2"),
##     (try_end),
##        ],
##    [
##      ("order_build_belfry",[],"Construct the belfry.", [(assign,"$auto_enter_town","$current_town"),
##                                                         (assign, "$g_belfry_construct_town", "$current_town"),
##                                                         (assign, "$g_belfry_auto_attack", 1),
##                                                         (rest_for_hours, 24),
##                                                         (change_screen_return),
##                                                         ]),
##      ("order_retreat",[],"Call your soldiers back.",[(jump_to_menu,"mnu_castle_outside")]),
##    ]
##  ),
##   (
##    "castle_attack_walls_2",0,
##    "TODO: We're ready to attack.",
##    "none",
##    [],
##    [
##      ("castle_lead_attack",[(eq, "$no_soldiers_left", 0)],"Lead the attack personally.", [
##           (party_get_slot, ":battle_scene", "$g_encountered_party", slot_castle_exterior),
##           (set_party_battle_mode),
##           (set_jump_mission,"mt_castle_attack_walls"),
##           (jump_to_scene,":battle_scene"),
##           (jump_to_menu,"mnu_castle_outside"),
##           (change_screen_mission),
##       ]),
##      ("continue_attacking_stay_back",[(eq, "$no_soldiers_left", 0)],"Order your soldiers to keep attacking as you stay back...", [
##                                    (jump_to_menu,"mnu_castle_attack_walls_3"),
##                                    ]),
##      ("call_soldiers_back",[(eq, "$no_soldiers_left", 0)],"Call your soldiers back.",[(jump_to_menu,"mnu_castle_outside")]),
##      ("continue",[(eq, "$no_soldiers_left", 1)],"Continue...",[(jump_to_menu,"mnu_castle_outside")]),
##    ]
##  ),
   (
    "castle_attack_walls_simulate",0,
    "{s4}^^Your casualties:{s8}^^Enemy casualties were: {s9}",
    "none",
    [
        (set_background_mesh, "mesh_pic_siege_sighted"),
        
        (call_script, "script_party_calculate_regular_strength", "p_main_party"),
        (assign, ":player_party_strength", reg0),
        (val_div, ":player_party_strength", 10),

        (call_script, "script_party_calculate_regular_strength", "$g_encountered_party"),
        (assign, ":enemy_party_strength", reg0),
        (val_div, ":enemy_party_strength", 4),

        (call_script,"script_inflict_casualties_to_party", "p_main_party", ":enemy_party_strength"),
        (call_script, "script_print_casualties_to_s0", "p_temp_casualties", 0),
        (str_store_string_reg, s8, s0),

        (call_script,"script_inflict_casualties_to_party", "$g_encountered_party", ":player_party_strength"),
        (call_script, "script_print_casualties_to_s0", "p_temp_casualties", 0),
        (str_store_string_reg, s9, s0),

        (assign, "$no_soldiers_left", 0),
        (try_begin),
          (call_script, "script_party_count_fit_regulars","p_main_party"),
          (le, reg(0), 0),
          (assign, "$no_soldiers_left", 1),
          (str_store_string, s4, "str_attack_walls_failure"),
        (else_try),
          (call_script, "script_party_count_fit_regulars","$g_encountered_party"),
          (le, reg(0), 0),
          (assign, "$no_soldiers_left", 1),
          (assign, "$g_battle_result", 1),
          (str_store_string, s4, "str_attack_walls_success"),
        (else_try),
          (str_store_string, s4, "str_attack_walls_continue"),
        (try_end),
     ],
    [
##      ("lead_next_wave",[(eq, "$no_soldiers_left", 0)],"Lead the next wave of attack personally.", [
##           (party_get_slot, ":battle_scene", "$g_encountered_party", slot_castle_exterior),
##           (set_party_battle_mode),
##           (set_jump_mission,"mt_castle_attack_walls"),
##           (jump_to_scene,":battle_scene"),
##           (jump_to_menu,"mnu_castle_outside"),
##           (change_screen_mission),
##       ]),
##      ("continue_attacking",[(eq, "$no_soldiers_left", 0)],"Order your soldiers to keep attacking...", [
##                                    (jump_to_menu,"mnu_castle_attack_walls_3"),
##                                    ]),
##      ("call_soldiers_back",[(eq, "$no_soldiers_left", 0)],"Call your soldiers back.",[(jump_to_menu,"mnu_castle_outside")]),
      ("continue",[],"Continue...",[(jump_to_menu,"mnu_castle_besiege")]),
    ]
  ),
  (
    "castle_taken",0,
#    "The rest of the castle garrison recognizes that their situation is hopeless and surrenders. {s1} is at your mercy now. What do you want to do with this castle?",
    "You have taken {s1}.",# What do you want to do with this castle?",
    "none",
    [
        (party_clear, "$g_encountered_party"),
        (party_set_slot, "$g_encountered_party", slot_center_last_taken_by_troop, "trp_player"),
        (try_begin),
          (gt, "$players_kingdom", 0),
          (call_script, "script_give_center_to_faction", "$g_encountered_party", "$players_kingdom"),
        (try_end),
        (call_script, "script_change_troop_renown", "trp_player", 5),
        (jump_to_menu, "mnu_castle_taken_2"),
    ],
    [
      ("continue",[],"Continue...",
       [
            (jump_to_menu, "mnu_town"),
        ]),
    ],
  ),
  (
    "castle_taken_2",0,
    "You have taken {s1}. You can now send a message to your liege and inform him of your victory.",
    "none",
    [
        (str_store_party_name, s1, "$g_encountered_party"),
    ],
    [
      ("castle_taken_claim",[],"Ask for {s1} to be given to you.",
       [
        (party_set_slot, "$g_encountered_party", slot_center_last_taken_by_troop, "trp_player"),
        (assign, "$g_castle_requested_by_player", "$current_town"),
        (jump_to_menu, "mnu_town"),
        ]),
      ("castle_taken_no_claim",[],"Ask for nothing.",
       [
        (party_set_slot, "$g_encountered_party", slot_center_last_taken_by_troop, -1),
        (jump_to_menu, "mnu_town"),
        ]),
    ],
  ),

  (
    "requested_castle_granted_to_player",0,
    "You receive a message from your liege, {s3}.^^ He grants {s2} to you.",
    "none",
    [(set_background_mesh, "mesh_pic_messenger"),
     (faction_get_slot, ":faction_leader", "$players_kingdom", slot_faction_leader),
     (str_store_troop_name, s3, ":faction_leader"),
     (str_store_party_name, s2, "$g_center_to_give_to_player"),
    ],
    [
      ("continue",[],"Continue.",
       [(call_script, "script_give_center_to_lord", "$g_center_to_give_to_player", "trp_player"),
        (jump_to_menu, "mnu_give_center_to_player_2"),
        ]),
     ],
  ),
  
  (
    "requested_castle_granted_to_another",0,
    "You receive a message from your liege, {s3}.^^\
 'I hear that you have fought valiantly and captured {s2}. Your victory has made us very glad.\
 You say that you want the said castle to be granted to yourself.\
 Your wish I would have granted, had it not been that you already hold other estates in my realm.\
 Therefore, I am sending you {reg6} denars to pay for the expenses of your campaign, but {s2}, I give to {s5}.'\
 ",
    "none",
    [(set_background_mesh, "mesh_pic_messenger"),
     (faction_get_slot, ":faction_leader", "$players_kingdom", slot_faction_leader),
     (str_store_troop_name, s3, ":faction_leader"),
     (str_store_party_name, s2, "$g_center_to_give_to_player"),
     (party_get_slot, ":new_owner", "$g_center_to_give_to_player", slot_town_lord),
     (str_store_troop_name, s5, ":new_owner"),
     (assign, reg6, 900),
    ],
    [
      ("continue",[],"Continue.",
       [
       (troop_add_gold, "trp_player", reg6),
       (change_screen_return),
        ]),
     ],
  ),

  (
    "give_center_to_player",0,
    "Your lord offers you a new fief! {s1} offers {s2} to you. What is your answer?",
    "none",
    [(set_background_mesh, "mesh_pic_messenger"),
     (store_faction_of_party, ":center_faction", "$g_center_to_give_to_player"),
     (faction_get_slot, ":faction_leader", ":center_faction", slot_faction_leader),
     (str_store_troop_name, s1, ":faction_leader"),
     (str_store_party_name, s2, "$g_center_to_give_to_player"),
    ],
    [
      ("give_center_to_player_accept",[],"Accept. This will be good for both you and your lord.",
       [(call_script, "script_give_center_to_lord", "$g_center_to_give_to_player", "trp_player"),
        (jump_to_menu, "mnu_give_center_to_player_2"),
        ]),
      ("give_center_to_player_reject",[],"Reject. You have no interest in holding {s2}.",
       [(party_set_slot, "$g_center_to_give_to_player", slot_town_lord, stl_rejected_by_player),
        (change_screen_return),
        ]),
    ],
  ),
  
  (
    "give_center_to_player_2",0,
    "You have been given a new fief. You are now the lord of {s2}. You can claim the rents and revenues of that estate, draft soldiers from the populace.\
 You are also expected to defend your fief from enemies and marauders and keep law and order.",
    "none",
    [
      (str_store_party_name, s2, "$g_center_to_give_to_player"),
    ],
    [
      ("continue",[],"Continue...",
       [(change_screen_return),
        ]),
    ],
  ),

##  (
##    "castle_garrison_stationed",0,
###    "The rest of the castle garrison recognizes that their situation is hopeless and surrenders. {s1} is at your mercy now. What do you want to do with this castle?",
##    "_",
##    "none",
##    [
##        (jump_to_menu, "mnu_town"),
##    ],
##    [],
##  ),

##  (
##    "castle_choose_captain",0,
##    "You will need to assign one of your companions as the castellan. Who will it be?",
##    "none",
##    [
##        (try_for_range, ":slot_no", 0, 20),
##          (troop_set_slot, "trp_temp_troop", ":slot_no", 0),
##        (try_end),
##        (assign, ":num_captains", 0),
##        (party_clear, "p_temp_party"),
##        (party_get_num_companion_stacks, ":num_stacks", "p_main_party"),
##        (try_for_range, ":i_s", 1,":num_stacks"),
##          (party_stack_get_troop_id, ":companion","p_main_party", ":i_s"),
##          (troop_slot_eq, ":companion", slot_troop_occupation, slto_player_companion),
##          (troop_set_slot, "trp_temp_troop", ":num_captains", ":companion"),
##        (try_end),
##    ],
##    [
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 0),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 0),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 1),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 1),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 2),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 2),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 3),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 3),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 4),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 4),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 5),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 5),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 6),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 6),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 7),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 7),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 8),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 8),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 9),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 9),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 10),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 10),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 11),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 11),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 12),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 12),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 13),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 13),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 14),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 14),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      ("castellan_candidate",  [(troop_get_slot, ":captain", "trp_temp_troop", 15),(gt,":captain",0),(str_store_troop_name, s5,":captain")],
##         "{s5}",    [(troop_get_slot, "$selected_castellan", "trp_temp_troop", 15),(jump_to_menu,"mnu_castle_captain_chosen")]),
##      
##      ("cancel",[],
##         "Cancel...",
##         [(jump_to_menu, "mnu_town")]),
##    ],
##  ),
##  (
##    "castle_captain_chosen",0,
##    "h this castle?",
##    "none",
##    [
##        (party_add_leader, "$g_encountered_party",  "$selected_castellan"),
##        (party_remove_members, "p_main_party", "$selected_castellan",1),
##        (party_set_slot, "$g_encountered_party", slot_town_lord, "trp_player"),
##        (party_set_faction, "$g_encountered_party", "fac_player_faction"),
##        (try_for_range, ":slot_no", 0, 20), #clear temp troop slots just in case
##          (troop_set_slot, "trp_temp_troop", ":slot_no", 0),
##        (try_end),
##        (jump_to_menu, "mnu_town"),
##        (change_screen_exchange_members,0),
##    ],
##    [],
##  ),

  (
    "under_siege_attacked_continue",0,
    "{s1} Test test",
    "none",
    [
        (assign, "$g_enemy_party", "$g_encountered_party_2"),
        (assign, "$g_ally_party", "$g_encountered_party"),
        (str_store_party_name, 1,"$g_enemy_party"),
        (str_store_party_name, 2,"$g_ally_party"),
        (party_set_next_battle_simulation_time, "$g_encountered_party", 0),
        (call_script, "script_encounter_calculate_fit"),
        (try_begin),
          (call_script, "script_party_count_fit_regulars","p_collective_enemy"),
          (assign, ":num_enemy_regulars_remaining", reg(0)),
          (assign, ":enemy_finished",0),
          (try_begin),
            (eq, "$g_battle_result", 1),
            (eq, ":num_enemy_regulars_remaining", 0), #battle won
            (assign, ":enemy_finished",1),
          (else_try),
            (eq, "$g_engaged_enemy", 1),
            (le, "$g_enemy_fit_for_battle",0),
            (ge, "$g_friend_fit_for_battle",1),
            (assign, ":enemy_finished",1),
          (try_end),
          (this_or_next|eq, ":enemy_finished",1),
          (eq,"$g_enemy_surrenders",1),
          (assign, "$g_center_under_siege_battle", 0),
          (assign, "$g_next_menu", -1),
          (jump_to_menu, "mnu_total_victory"),
        (else_try),
          (assign, ":battle_lost", 0),
          (try_begin),
            (eq, "$g_battle_result", -1),
            (assign, ":battle_lost",1),
          (try_end),
          (this_or_next|eq, ":battle_lost",1),
          (eq,"$g_player_surrenders",1),
          (assign, "$g_center_under_siege_battle", 0),
          (assign, "$g_next_menu", "mnu_captivity_start_under_siege_defeat"),
          (jump_to_menu, "mnu_total_defeat"),
        (else_try),
    # Ordinary victory.
          (try_begin),
          #check whether enemy retreats
            (eq, "$g_battle_result", 1),
            (store_mul, ":min_enemy_str","$g_enemy_fit_for_battle", 2),
            (lt, ":min_enemy_str", "$g_friend_fit_for_battle"),
            (party_set_slot, "$g_enemy_party", slot_party_retreat_flag, 1),
            (party_set_ai_behavior, "$g_enemy_party", ai_bhvr_hold),
			(party_set_flags, "$g_enemy_party", pf_default_behavior, 0),
            (party_set_slot, "$g_enemy_party", slot_party_ai_state, spai_undefined),
          (try_end),
          (assign, "$g_center_under_siege_battle", 0),
          (jump_to_menu, "mnu_town"),
        (try_end),
        ],
    [
    ]
  ),


  (
    "siege_started_defender",0,
    "{s1} launched an assault on {s2}. You have {reg10} troops fit for battle against the enemy's {reg11}. You decide to...",
    "none",
    [
        (select_enemy,1),
        (assign, "$g_enemy_party", "$g_encountered_party_2"),
        (assign, "$g_ally_party", "$g_encountered_party"),
        (str_store_party_name, 1,"$g_enemy_party"),
        (str_store_party_name, 2,"$g_ally_party"),
        (call_script, "script_encounter_calculate_fit"),
        (call_script, "script_encounter_init_variables"),
        ],
    [
      ("siege_defender_join_battle",[(neg|troop_is_wounded, "trp_player"),
##(store_troop_health,":player_health","trp_player"),
##                                     (ge,":player_health",20),
                                     ],
          "Join the battle.",[
              (assign, "$g_battle_result", 0),
              (party_get_slot, ":battle_scene", "$g_encountered_party", slot_castle_exterior),
              (set_party_battle_mode),
              (try_begin),
                (party_slot_eq, "$current_town", slot_center_siege_with_belfry, 1),
                (set_jump_mission,"mt_castle_attack_walls_belfry"),
              (else_try),
                (set_jump_mission,"mt_castle_attack_walls_ladder"),
              (try_end),
              (jump_to_scene,":battle_scene"),
              (assign, "$g_next_menu", "mnu_under_siege_attacked_continue"),
              (jump_to_menu, "mnu_battle_debrief"),
              (change_screen_mission)]),
      ("siege_defender_troops_join_battle",[(call_script, "script_party_count_fit_regulars", "p_main_party"),(ge, reg0, 2)],
          "Order your men to join the battle while you stay back.",[
              (select_enemy,1),
              (assign,"$g_enemy_party","$g_encountered_party_2"),
              (assign,"$g_ally_party","$g_encountered_party"),
              (assign,"$g_siege_join", 1),
              (jump_to_menu,"mnu_siege_join_defense")]),
      ("siege_defender_do_not_join_battle",[(call_script, "script_party_count_fit_regulars","p_collective_ally"),
                                            (gt, reg0, 0)],
       "Don't get involved.", [(assign,"$g_siege_join", 0),
                               (jump_to_menu,"mnu_siege_join_defense")]),
      ("siege_defender_surrender",[(call_script, "script_party_count_fit_regulars","p_collective_ally"),
                                   (this_or_next|eq, reg0, 0),
                                   (party_slot_eq, "$g_encountered_party", slot_town_lord, "trp_player"),
                                   ],
       "Surrender.",[(assign, "$g_player_surrenders", 1),
                     (jump_to_menu,"mnu_under_siege_attacked_continue")]),
    ]
  ),

  (
    "siege_join_defense",0,
    "{s4}^^Your casualties: {s8}^^Allies' casualties: {s9}^^Enemy casualties: {s10}",
    "none",
    [
        (try_begin),
          (eq, "$g_siege_join", 1),
          (call_script, "script_party_calculate_regular_strength", "p_main_party"),
          (assign, ":player_party_strength", reg0),
          (val_div, ":player_party_strength", 5),
        (else_try),
          (assign, ":player_party_strength", 0),
        (try_end),
        
        (call_script, "script_party_calculate_regular_strength", "p_collective_ally"),
        (assign, ":ally_party_strength", reg0),
        (val_div, ":ally_party_strength", 5),
        (call_script, "script_party_calculate_regular_strength", "p_collective_enemy"),
        (assign, ":enemy_party_strength", reg0),
        (val_div, ":enemy_party_strength", 10),

        (store_add, ":friend_party_strength", ":player_party_strength", ":ally_party_strength"),
        (assign, ":enemy_party_strength_for_p", ":enemy_party_strength"),
        (val_mul, ":enemy_party_strength_for_p", ":player_party_strength"),
        (val_div, ":enemy_party_strength_for_p", ":friend_party_strength"),

        (val_sub, ":enemy_party_strength", ":enemy_party_strength_for_p"),
        (inflict_casualties_to_party_group, "p_main_party", ":enemy_party_strength_for_p", "p_temp_casualties"),
        (call_script, "script_print_casualties_to_s0", "p_temp_casualties", 0),
        (str_store_string_reg, s8, s0),

        (inflict_casualties_to_party_group, "$g_enemy_party", ":friend_party_strength", "p_temp_casualties"),
        (call_script, "script_print_casualties_to_s0", "p_temp_casualties", 0),
        (str_store_string_reg, s9, s0),
        (party_collect_attachments_to_party, "$g_ally_party", "p_collective_ally"),

        (inflict_casualties_to_party_group, "$g_ally_party", ":enemy_party_strength", "p_temp_casualties"),
        (call_script, "script_print_casualties_to_s0", "p_temp_casualties", 0),
        (str_store_string_reg, s10, s0),
        (party_collect_attachments_to_party, "$g_enemy_party", "p_collective_enemy"),

#        (assign, "$no_soldiers_left", 0),
        (try_begin),
          (call_script, "script_party_count_fit_regulars","p_main_party"),
          (le, reg(0), 0),
#          (assign, "$no_soldiers_left", 1),
          (str_store_string, s4, "str_siege_defender_order_attack_failure"),
        (else_try),
          (call_script, "script_party_count_fit_regulars","p_collective_enemy"),
          (le, reg(0), 0),
          (assign, "$g_battle_result", 1),
#          (assign, "$no_soldiers_left", 1),
          (str_store_string, s4, "str_siege_defender_order_attack_success"),
        (else_try),
          (str_store_string, s4, "str_siege_defender_order_attack_continue"),
        (try_end),
    ],
    [
      ("continue",[],"Continue...",[
          (jump_to_menu,"mnu_under_siege_attacked_continue"),
          ]),
    ]
  ),


##  (
##    "siege_break_out",0,
##    "TODO: You managed to leave the area.",
##    "none",
##    [
##    ],
##    [
##      ("continue",[],"Continue...",[(change_screen_return)]),
##    ]
##  ),

  (
    "village",mnf_enable_hot_keys,
    "{s4}{s6}{s7}",
    "none",
    [
        (store_encountered_party,"$current_town"),
        (call_script, "script_update_center_recon_notes", "$current_town"),
        (str_store_party_name, s16, "$current_town"),
        (party_get_slot, ":village_lord", "$current_town", slot_town_lord),
        (store_faction_of_party, ":village_faction", "$current_town"),

        (try_begin),
          (neq, "$g_player_raiding_village",  "$current_town"),
          (assign, "$g_player_raiding_village", 0),
        (else_try),
          (jump_to_menu, "mnu_village_loot_continue"),
        (try_end),

        (str_clear, s4),

        (try_begin),
          (eq, ":village_lord", "trp_player"),
          (str_store_string, s4, "@You are at the village of {s16} which belongs to you."),
        (else_try),
          (ge, ":village_lord", 1),
          (str_store_troop_name, s38, ":village_lord"),
          (store_troop_faction, ":lord_faction", ":village_lord"),
          (try_begin),
            (is_between, ":lord_faction", kingdoms_begin, kingdoms_end),
            (str_store_faction_name, s39, ":lord_faction"),
            (str_store_string, s4, "@You are at the village of {s16} which belongs to {s38} of {s39}."),
          (else_try),
            (str_store_string, s4, "@You are at the village of {s16} which belongs to {s38}."),
          (try_end),
        (else_try),
          (str_store_faction_name, s39, ":village_faction"),
          (str_store_string, s4, "@You are at the village of {s16} which belongs to {s39}."),
        (try_end),

        (str_clear, s7),
        (try_begin),
          (neg|party_slot_eq, "$current_town", slot_village_state, svs_looted),
          (party_get_slot, ":center_relation", "$current_town", slot_center_player_relation),
          (call_script, "script_describe_center_relation_to_s3", ":center_relation"),
          (assign, reg9, ":center_relation"),
          (str_store_string, s7, "@ {s3} ({reg9})."),
        (try_end),
        (str_clear, s6),
        (try_begin),
          (party_slot_eq, "$current_town", slot_village_state, svs_looted),
          (str_store_string, s6, "@ The village has been looted. A handful of souls scatter as you pass through the burnt out houses."),
        (else_try),
          (party_slot_eq, "$current_town", slot_village_state, svs_being_raided),
          (str_store_string, s6, "@ The village is being raided."),
        (try_end),

        (try_begin),
          (eq, "$g_player_raid_complete", 1),
          (assign, "$g_player_raid_complete", 0),
          (jump_to_menu, "mnu_village_loot_complete"),
        (else_try),
          (party_get_slot, ":raider_party", "$current_town", slot_village_raided_by),
          (gt, ":raider_party", 0),
        # Process here...
        (try_end),

         #Adding tax to player if player is the owner of the villager
        (try_begin),
          (party_slot_eq, "$current_town", slot_town_lord, "trp_player"),
          (party_get_slot, ":accumulated_rents", "$current_town", slot_center_accumulated_rents),
          (gt, ":accumulated_rents", 0),
          (jump_to_menu, "mnu_center_tax"),
        (try_end),


        (try_begin),
          (eq,"$g_leave_town",1),
          (assign,"$g_leave_town",0),
          (change_screen_return),
        (try_end),
        
    ],
    [
      ("village_manage",[(neg|party_slot_eq, "$current_town", slot_village_state, svs_looted),
                         (neg|party_slot_eq, "$current_town", slot_village_state, svs_being_raided),
                         (party_slot_eq, "$current_town", slot_town_lord, "trp_player")]
       ,"Manage this village.",
       [
           (jump_to_menu, "mnu_village_manage"),
        ]),
      ("recruit_volunteers",[
          (neg|party_slot_eq, "$current_town", slot_village_state, svs_looted),
          (neg|party_slot_eq, "$current_town", slot_village_state, svs_being_raided),
          (store_faction_of_party, ":village_faction", "$current_town"),
          (party_get_slot, ":center_relation", "$current_town", slot_center_player_relation),
          (ge, ":center_relation", 0),
          (this_or_next|ge, ":center_relation", 5),
          (this_or_next|eq, ":village_faction", "$players_kingdom"),
          (eq, "$players_kingdom", 0),
          (party_slot_ge, "$current_town", slot_center_volunteer_troop_amount, 0),
          (party_get_free_companions_capacity, ":free_capacity", "p_main_party"),
          (ge, ":free_capacity", 1),
          ]
       ,"Recruit Volunteers.",
       [
           (jump_to_menu, "mnu_recruit_volunteers"),
        ]),
      ("village_center",[(neg|party_slot_eq, "$current_town", slot_village_state, svs_looted),
                         (neg|party_slot_eq, "$current_town", slot_village_state, svs_being_raided)]
       ,"Go to the village center.",
       [
           (party_get_slot, ":village_scene", "$current_town", slot_castle_exterior),
           (modify_visitors_at_site,":village_scene"),(reset_visitors),
           (set_jump_mission,"mt_village_center"),
           (jump_to_scene,":village_scene"),
           (change_screen_mission),
        ],"Door to the village centre."),
      ("village_buy_food",[(party_slot_eq, "$current_town", slot_village_state, 0)],"Buy supplies from the peasants.",
       [(party_get_slot, ":merchant_troop", "$current_town", slot_town_merchant),(change_screen_trade, ":merchant_troop")]),
      ("village_take_food",[
          (party_slot_eq, "$current_town", slot_village_state, 0),
          (party_get_slot, ":merchant_troop", "$current_town", slot_town_merchant),
          (assign, ":town_stores_not_empty", 0),
          (try_for_range, ":slot_no", 0 ,90),
            (troop_get_inventory_slot, ":slot_item", ":merchant_troop", ":slot_no"),
            (ge, ":slot_item", 0),
            (assign, ":town_stores_not_empty", 1),
          (try_end),
          (eq, ":town_stores_not_empty", 1),
          ],"Force the peasants to give you supplies.",
       [
           (jump_to_menu, "mnu_village_take_food")
        ]),
      ("village_loot",[(party_slot_eq, "$current_town", slot_village_state, 0),
                       (store_faction_of_party, ":center_faction", "$current_town"),
                       (store_relation, ":reln", "fac_player_faction", ":center_faction"),
                       (lt, ":reln", 0),
                       ],
       "Loot and burn this village.",
       [
#           (party_clear, "$current_town"),
#           (party_add_template, "$current_town", "pt_villagers_in_raid"),
           (jump_to_menu, "mnu_village_start_attack"),
           ]),
      ("village_reports",[(eq, "$cheat_mode", 1),], "CHEAT! Show reports.",
       [(jump_to_menu,"mnu_center_reports"),
           ]),
      ("village_leave",[],"Leave...",[(change_screen_return,0)]),
    ],
  ),
  (
    "recruit_volunteers",0,
    "{s18}",
    "none",
    [
        (party_get_slot, ":volunteer_troop", "$current_town", slot_center_volunteer_troop_type),
        (party_get_slot, ":volunteer_amount", "$current_town", slot_center_volunteer_troop_amount),
        (try_begin),
          (eq, ":volunteer_amount", 0),
          (str_store_string, s18, "@No one here seems to be willing to join your party."),
        (else_try),
          (party_get_free_companions_capacity, ":free_capacity", "p_main_party"),
          (val_min, ":volunteer_amount", ":free_capacity"),
          (assign, reg5, ":volunteer_amount"),
          (str_store_troop_name_by_count, s3, ":volunteer_troop", ":volunteer_amount"),
          (try_begin),
            (eq, reg5, 1),
            (str_store_string, s18, "@One {s3} volunteers to follow you."),
          (else_try),
            (str_store_string, s18, "@{reg5} {s3} volunteer to follow you."),
          (try_end),
        (try_end),
    ],
    [
      ("continue",[(party_slot_eq, "$current_town", slot_center_volunteer_troop_amount, 0)],
       "Continue...",[(party_set_slot, "$current_town", slot_center_volunteer_troop_amount, -1),(jump_to_menu,"mnu_village")]),
      ("recruit_them",[(party_slot_ge, "$current_town", slot_center_volunteer_troop_amount, 1)],
       "Recruit them.",[
          (party_get_slot, ":volunteer_troop", "$current_town", slot_center_volunteer_troop_type),
          (party_get_slot, ":volunteer_amount", "$current_town", slot_center_volunteer_troop_amount),
          (party_get_free_companions_capacity, ":free_capacity", "p_main_party"),
          (val_min, ":volunteer_amount", ":free_capacity"),
          (party_add_members, "p_main_party", ":volunteer_troop", ":volunteer_amount"),
          (party_set_slot, "$current_town", slot_center_volunteer_troop_amount, -1),
          (jump_to_menu,"mnu_village"),
          ]),
      ("forget_it",[(party_slot_ge, "$current_town", slot_center_volunteer_troop_amount, 1)],
      "Forget it.",[(jump_to_menu,"mnu_village")]),
    ],
  ),

  (
    "village_manage",0,
    "Population: N/A^Housing: Level {reg3}^Irrigation: Level {reg4}^Mill: Level {reg5}{reg6?^^You are\
 currently improving {s3} to level {reg7}. The improvement will be completed after {reg8} day{reg9?s:}.:}",
    "none",
    [(party_get_slot, reg3, "$g_encountered_party", slot_center_housing_level),
     (party_get_slot, reg4, "$g_encountered_party", slot_center_irrigation_level),
     (party_get_slot, reg5, "$g_encountered_party", slot_center_mill_level),
     (assign, reg6, 1),
     (try_begin),
       (party_slot_eq, "$g_encountered_party", slot_center_current_improvement, slot_center_housing_level),
       (str_store_string, s3, "@housing"),
       (party_get_slot, reg7, "$g_encountered_party", slot_center_housing_level),
       (val_add, reg7, 1),
     (else_try),
       (party_slot_eq, "$g_encountered_party", slot_center_current_improvement, slot_center_irrigation_level),
       (str_store_string, s3, "@irrigation"),
       (party_get_slot, reg7, "$g_encountered_party", slot_center_irrigation_level),
       (val_add, reg7, 1),
     (else_try),
       (party_slot_eq, "$g_encountered_party", slot_center_current_improvement, slot_center_mill_level),
       (str_store_string, s3, "@mill"),
       (party_get_slot, reg7, "$g_encountered_party", slot_center_mill_level),
       (val_add, reg7, 1),
     (else_try),
       (assign, reg6, 0),
     (try_end),
     (try_begin),
       (eq, reg6, 1),
       (store_current_hours, ":cur_hours"),
       (party_get_slot, ":finish_time", "$g_encountered_party", slot_center_improvement_end_hour),
       (val_sub, ":finish_time", ":cur_hours"),
       (store_div, reg8, ":finish_time", 24),
       (val_max, reg8, 1),
       (store_sub, reg9, reg8, 1),
     (try_end),
    ],
    [
      ("village_improve_housing",[(eq, reg6, 0),
                                  (neg|party_slot_eq, "$g_encountered_party", slot_center_housing_level, 5),
                                  ],
       "Improve Housing.",[(assign, "$g_improvement_type", slot_center_housing_level),
                           (jump_to_menu, "mnu_village_improve"),]),
      ("village_improve_irrigation",[(eq, reg6, 0),
                                     (neg|party_slot_eq, "$g_encountered_party", slot_center_irrigation_level, 5),
                                     ],
       "Improve Irrigation.",[(assign, "$g_improvement_type", slot_center_irrigation_level),
                              (jump_to_menu, "mnu_village_improve"),]),
      ("village_improve_mill",[(eq, reg6, 0),
                               (neg|party_slot_eq, "$g_encountered_party", slot_center_mill_level, 5),
                               ],
       "Improve the Mill.",[(assign, "$g_improvement_type", slot_center_mill_level),
                            (jump_to_menu, "mnu_village_improve"),]),
      ("village_manage_back",[],"Back to village menu.",[(jump_to_menu, "mnu_village")]),
    ],
  ),

  (
    "village_improve",0,
    "As the party member with the highest engineer skill ({reg2}), {reg3?you reckon:{s3} reckons} that improving {s4} to level {reg4} will cost you\
 {reg5} denars and will take {reg6} days.",
    "none",
    [(call_script, "script_get_max_skill_of_player_party", "skl_engineer"),
     (assign, ":max_skill", reg0),
     (assign, ":max_skill_owner", reg1),
     (assign, reg2, ":max_skill"),

     (try_begin),
       (eq, "$g_improvement_type", slot_center_housing_level),
       (str_store_string, s4, "@housing"),
       (party_get_slot, ":current_level", "$g_encountered_party", slot_center_housing_level),
     (else_try),
       (eq, "$g_improvement_type", slot_center_irrigation_level),
       (str_store_string, s4, "@irrigation"),
       (party_get_slot, ":current_level", "$g_encountered_party", slot_center_irrigation_level),
     (else_try),
       (eq, "$g_improvement_type", slot_center_mill_level),
       (str_store_string, s4, "@mill"),
       (party_get_slot, ":current_level", "$g_encountered_party", slot_center_mill_level),
     (try_end),
     (store_add, ":new_level", ":current_level", 1),
     (assign, reg4, ":new_level"),
     (store_mul, ":improvement_time", ":new_level", 3),
     (val_sub, ":improvement_time", ":max_skill"),
     (val_max, ":improvement_time", 1),
     (store_sub, ":multiplier", 15, ":max_skill"),
     (val_mul, ":improvement_time", ":multiplier"),
     (try_begin),
       (eq, "$g_improvement_type", slot_center_housing_level),
       (val_mul, ":improvement_time", 3),
       (store_mul, ":cost", ":improvement_time", 50),
       (val_add, ":cost", 8000),
     (else_try),
       (eq, "$g_improvement_type", slot_center_irrigation_level),
       (val_mul, ":improvement_time", 2),
       (store_mul, ":cost", ":improvement_time", 50),
       (val_add, ":cost", 6000),
     (else_try),
       (eq, "$g_improvement_type", slot_center_mill_level),
       (val_mul, ":improvement_time", 1),
       (store_mul, ":cost", ":improvement_time", 50),
       (val_add, ":cost", 4000),
     (try_end),
     (assign, reg5, ":cost"),
     (assign, reg6, ":improvement_time"),

     (try_begin),
       (eq, ":max_skill_owner", "trp_player"),
       (assign, reg3, 1),
     (else_try),
       (assign, reg3, 0),
       (str_store_troop_name, s3, ":max_skill_owner"),
     (try_end),
    ],
    [
      ("improve_cont",[(store_troop_gold, ":cur_gold", "trp_player"),
                       (ge, ":cur_gold", reg5)],
       "Go on.", [(troop_remove_gold, "trp_player", reg5),
                  (party_set_slot, "$g_encountered_party", slot_center_current_improvement, "$g_improvement_type"),
                  (store_current_hours, ":cur_hours"),
                  (store_mul, ":hours_takes", reg6, 24),
                  (val_add, ":hours_takes", ":cur_hours"),
                  (party_set_slot, "$g_encountered_party", slot_center_improvement_end_hour, ":hours_takes"),
                  (jump_to_menu,"mnu_village_manage"),
                  ]),
      ("forget_it",[(store_troop_gold, ":cur_gold", "trp_player"),
                    (ge, ":cur_gold", reg5)],
       "Forget it.", [(jump_to_menu,"mnu_village_manage")]),
      ("improve_not_enough_gold",[(store_troop_gold, ":cur_gold", "trp_player"),
                                  (lt, ":cur_gold", reg5)],
       "I don't have enough money for that.", [(jump_to_menu,"mnu_village_manage"),]),
    ],
  ),


  (
    "village_take_food",0,
    "The villagers grudgingly bring some supplies.",
    "none",
    [
       (call_script, "script_party_count_fit_regulars","p_main_party"),
       (assign, ":player_party_size", reg(0)),
       (call_script, "script_party_count_fit_regulars","$current_town"),
       (assign, ":villagers_party_size", reg(0)),
       (try_begin),
         (lt, ":player_party_size", 6),
         (ge, ":villagers_party_size", 40),
         (neg|party_slot_eq, "$current_town", slot_town_lord, "trp_player"),
         (jump_to_menu, "mnu_village_start_attack"),
       (try_end),
    ],
    [
      ("take_supplies",[],"Take the supplies.",[
          
          (try_begin),
            (party_slot_ge, "$current_town", slot_center_player_relation, -35),
            (try_begin),
              (party_slot_eq, "$current_town", slot_town_lord, "trp_player"),
              (call_script, "script_change_player_relation_with_center", "$current_town", -1),
            (else_try),
              (call_script, "script_change_player_relation_with_center", "$current_town", -3),
            (try_end),
          (try_end),
          (party_get_slot, ":village_lord", "$current_town", slot_town_lord),
          (try_begin),
            (gt,  ":village_lord", 1),
            (call_script, "script_change_player_relation_with_troop", ":village_lord", -2),
          (try_end),
          (party_get_slot, ":merchant_troop", "$current_town", slot_town_merchant),
          (try_for_range, ":slot_no", 0 ,90),
            (store_random_in_range, ":rand", 0, 100),
            (lt, ":rand", 70),
            (troop_set_inventory_slot, ":merchant_troop", ":slot_no", -1),
          (try_end),
          (jump_to_menu, "mnu_village"),
          (change_screen_loot, ":merchant_troop")          
          ]),
      ("forget_it",[],"Forget it.",[(jump_to_menu, "mnu_village")]),
    ],
  ),


  (
    "village_start_attack",0,
    "Some of the villagers grab their farming tools and prepare to resist you.",
    "none",
    [
       (call_script, "script_party_count_fit_regulars","p_main_party"),
       (assign, ":player_party_size", reg(0)),
       (call_script, "script_party_count_fit_regulars","$current_town"),
       (assign, ":villagers_party_size", reg(0)),
       
       (try_begin),
         (gt, ":player_party_size", 25),
         (jump_to_menu, "mnu_village_loot_no_resist"),
       (else_try),
         (this_or_next|eq, ":villagers_party_size", 0),
         (eq, "$g_battle_result", 1),
         (try_begin),
           (eq, "$g_battle_result", 1),
           (store_random_in_range, ":enmity", -30, -15),
           (call_script, "script_change_player_relation_with_center", "$current_town", ":enmity"),
         (try_end),
         (jump_to_menu, "mnu_village_loot_no_resist"),
       (else_try),
         (eq, "$g_battle_result", -1),
         (jump_to_menu, "mnu_village_loot_defeat"),
       (try_end),
    ],
    [
      ("village_raid_attack",[],"Attack them.",[
          (store_random_in_range, ":enmity", -10, -5),
          (call_script, "script_change_player_relation_with_center", "$current_town", ":enmity"),
          (set_party_battle_mode),
          (assign, "$g_battle_result", 0),
          (set_jump_mission,"mt_village_raid"),
          (party_get_slot, ":scene_to_use", "$current_town", slot_castle_exterior),
          (jump_to_scene, ":scene_to_use"),
          (assign, "$g_next_menu", "mnu_village_start_attack"),
          (jump_to_menu, "mnu_battle_debrief"),
          (change_screen_mission),
          ]),
      ("village_raid_leave",[],"Leave this village alone...",[(change_screen_return)]),
    ],
  ),
  
  (
    "village_loot_no_resist",0,
    "The villagers quickly scatter before your forces. The village is at your mercy.",
    "none",
    [],
    [
      ("village_loot",[], "Loot the village and burn the houses.",
       [
          (call_script, "script_village_set_state", "$current_town", svs_being_raided),
          (party_set_slot, "$current_town", slot_village_raided_by, "p_main_party"),
          (assign,"$g_player_raiding_village","$current_town"),
          (rest_for_hours, 3, 5, 1), #rest while attackable (3 hours will be extended by the trigger)
          (change_screen_return),
           ]),
      ("village_raid_leave",[],"Leave this village alone...",[(change_screen_return)]),
    ],
  ),
  (
    "village_loot_complete",0,
    "The village has been looted. You find gold worth {reg1} denars.",
    "none",
    [
        (party_get_slot, ":village_lord", "$current_town", slot_town_lord),
        (try_begin),
          (gt,  ":village_lord", 1),
          (call_script, "script_change_player_relation_with_troop", ":village_lord", -3),
        (try_end),
        (store_random_in_range, ":enmity", -40, -20),
        (call_script, "script_change_player_relation_with_center", "$current_town", ":enmity"),
        (store_random_in_range, ":morale_increase", 10, 20),
        (call_script, "script_change_player_party_morale", ":morale_increase"),
        (store_random_in_range, reg1, 100, 500),
        (troop_add_gold, "trp_player", reg1),
      ],
    [
      ("continue",[], "Continue.",
       [
          (jump_to_menu, "mnu_close"),
          (troop_clear_inventory, "trp_temp_troop"),
          (reset_item_probabilities,100),
          (troop_add_merchandise,"trp_temp_troop",itp_type_goods,45),
          (change_screen_loot, "trp_temp_troop"),
        ]),
    ],
  ),
  (
    "village_loot_defeat",0,
    "Fighting with courage and determination, the villagers drive your forces away.",
    "none",
    [],
    [
      ("continue",[],"Continue...",[(change_screen_return)]),
    ],
  ),
  
  (
    "village_loot_continue",0,
    "Do you wish to continue looting this village?",
    "none",
    [],
    [
      ("continue",[],"Yes.",[ (rest_for_hours, 3, 5, 1), #rest while attackable (3 hours will be extended by the trigger)
                              (change_screen_return),
                              ]),
      ("continue",[],"No.",[(call_script, "script_village_set_state", "$current_town", 0),
                            (party_set_slot, "$current_town", slot_village_raided_by, -1),
                            (assign, "$g_player_raiding_village", 0),
                            (change_screen_return)]),
    ],
  ),
  
  (
    "close",0,
    "Nothing.",
    "none",
    [
        (change_screen_return),
      ],
    [],
  ),
  
  (
    "center_tax",0,
    "You receive the accumulated taxes of this fief amounting to {reg1} denars.",
    "none",
    [
        (str_clear, s3),
        (try_begin),
          (party_slot_eq, "$current_town", slot_town_lord, "trp_player"),
          (party_get_slot, ":accumulated_rents", "$current_town", slot_center_accumulated_rents),
          (party_get_slot, ":accumulated_tariffs", "$current_town", slot_center_accumulated_tariffs),
          (store_add, ":total_tax", ":accumulated_rents", ":accumulated_tariffs"),
          (assign, reg1, ":total_tax"),
          (troop_add_gold, "trp_player", ":total_tax"),
          (party_set_slot, "$current_town", slot_center_accumulated_rents, 0),
          (party_set_slot, "$current_town", slot_center_accumulated_tariffs, 0),
        (try_end),
      ],
    [
      ("continue",[], "Continue.",
       [
           (try_begin),
             (party_slot_eq, "$current_town", slot_party_type, spt_village),
             (jump_to_menu, "mnu_village"),
           (else_try),
             (jump_to_menu, "mnu_town"),
           (try_end),
        ]),
    ],
  ),

  (
    "town",mnf_enable_hot_keys,
    "{s1} {s3}",
    "none",
    [
        (store_encountered_party,"$current_town"),
        (call_script, "script_update_center_recon_notes", "$current_town"),
        (assign, "$g_defending_against_siege", 0),
        (str_clear, s3),
        (party_get_battle_opponent, ":besieger_party", "$current_town"),
        (try_begin),
          (gt, ":besieger_party", 0),
          (eq, "$g_encountered_party_faction", "$players_kingdom"),
          (assign, "$g_defending_against_siege", 1),
          (eq, "$g_town_visit_after_rest", 1),
          (store_random_in_range, ":random_no", 0, 100),
          (lt, ":random_no", 100),
          (assign, "$g_center_under_siege_battle", 1),
        (try_end),

        (try_begin),
          (eq, "$g_center_under_siege_battle", 1),
          (jump_to_menu,"mnu_siege_started_defender"),
        (else_try),
          (eq, "$g_town_assess_trade_goods_after_rest", 1),
          (assign, "$g_town_assess_trade_goods_after_rest", 0),
          (jump_to_menu,"mnu_town_trade_assessment"),
        (try_end),

        (assign, "$talk_context", 0),
        (assign,"$all_doors_locked",0),

        (try_begin),
          (eq, "$g_town_visit_after_rest", 1),
          (assign, "$g_town_visit_after_rest", 0),
          (assign, "$town_entered", 1),
        (try_end),

        (try_begin),
          (eq,"$g_leave_town",1),
          (assign,"$g_leave_town",0),
          (assign,"$g_permitted_to_center",0),
          (change_screen_return),
        (try_end),

        #Adding tax to player if player is the owner of the town or castle
        (try_begin),
          (party_slot_eq, "$current_town", slot_town_lord, "trp_player"),
          (party_get_slot, ":accumulated_rents", "$current_town", slot_center_accumulated_rents),
          (gt, ":accumulated_rents", 0),
          (jump_to_menu, "mnu_center_tax"),
        (try_end),
        

        (str_store_party_name,s2, "$current_town"),
        (party_get_slot, ":center_lord", "$current_town", slot_town_lord),
        (store_faction_of_party, ":center_faction", "$current_town"),
        (str_store_faction_name,s9,":center_faction"),
        (try_begin),
          (ge, ":center_lord", 0),
          (str_store_troop_name,s8,":center_lord"),
          (str_store_string,s7,"@{s8} of {s9}"),
        (try_end),
        (try_begin),
          (party_slot_eq,"$current_town",slot_party_type, spt_castle),
          (try_begin),
            (eq, ":center_lord", "trp_player"),
            (str_store_string,s1,"@You are at {s2} which belongs to you."),
          (else_try),
            (ge, ":center_lord", 0),
            (str_store_string,s1,"@You are at {s2} which belongs to {s7}."),
          (else_try),
            (str_store_string,s1,"@You are at {s2}."),
          (try_end),
        (else_try),
          (try_begin),
            (eq, ":center_lord", "trp_player"),
            (str_store_string,s1,"@You are in the town of {s2} which belongs to you."),
          (else_try),
            (ge, ":center_lord", 0),
            (str_store_string,s1,"@You are in the town of {s2} which belongs to {s7}."),
          (else_try),
            (str_store_string,s1,"@You are in the town of {s2}."),
          (try_end),
        (try_end),
        
        (try_begin), 
          (gt,"$entry_to_town_forbidden",0),
          (str_store_string,s1,"@{s1} You have successfully sneaked in."),
        (try_end),

        #forbidden to enter?
        (try_begin), 
          (store_time_of_day,reg(12)),
          (ge,reg(12),5),
          (lt,reg(12),21),
          (assign,"$town_nighttime",0),
          (str_store_string,3,"str_empty_string"),
        (else_try),
          (assign,"$town_nighttime",1),
          (str_store_string,3,"str_town_nighttime"),
        (try_end),


        (assign,"$castle_undefended",0),
        (party_get_num_companions, ":castle_garrison_size","p_collective_enemy"),
        (try_begin),
          (eq,":castle_garrison_size",0),
          (assign,"$castle_undefended",1),
#          (party_set_faction,"$g_encountered_party","fac_neutral"),
#          (party_set_slot, "$g_encountered_party", slot_town_lord, -1),
          (try_begin),
            (party_slot_eq,"$current_town",slot_party_type, spt_castle),
            (str_store_string, 3, "str_castle_is_abondened"),
          (else_try),
            (str_store_string, 3, "str_town_is_abondened"),
          (try_end),
        (else_try),
          (store_faction_of_party,reg(3),  "$g_encountered_party"),
          (eq,reg(3),"fac_player_faction"),
          (str_store_string, 3, "str_place_is_occupied_by_player"),
        (else_try),
          (store_faction_of_party,":encountered_faction",  "$g_encountered_party"),
          (store_relation, ":relation", ":encountered_faction", "fac_player_faction"),
          (try_begin),
            (lt, ":relation", 0),
            (str_store_string, 3, "str_place_is_occupied_by_enemy"),
          (else_try),
            (str_store_string, 3, "str_place_is_occupied_by_friendly"),
          (try_end),
        (try_end),


        #TODO:
        # Check under siege.
        # Jump_to_menu in_center_under_attack
        # process pre_join_help_defenders
        #
        ],
    [
      ("castle_castle",[(party_slot_eq,"$current_town",slot_party_type, spt_castle)],"Go to the Lord's hall.",
       [
           (try_begin),
             (eq,"$all_doors_locked",1),
             (display_message,"str_door_locked",0xFFFFAAAA),
           (else_try),
             (assign, "$town_entered", 1),
             (call_script, "script_enter_court", "$current_town"),
##             (set_jump_mission,"mt_visit_town_castle"),
##             (party_get_slot, ":castle_scene", "$current_town", slot_town_castle),
##             (modify_visitors_at_site,":castle_scene"),(reset_visitors),
##             
##             (assign, ":cur_pos", 16),
##             (call_script, "script_get_heroes_attached_to_center", "$current_town", "p_temp_party"),
##             (party_get_num_companion_stacks, ":num_stacks","p_temp_party"),
##             (try_for_range, ":i_stack", 0, ":num_stacks"),
##               (party_stack_get_troop_id, ":stack_troop","p_temp_party",":i_stack"),
##               (lt, ":cur_pos", 32), # spawn up to entry point 32
##               (set_visitor, ":cur_pos", ":stack_troop"),
##               (val_add,":cur_pos", 1),
##             (try_end),
##
### TODO: Disabling ladies for the time being.
###             (try_for_range, ":cur_troop", heroes_begin, heroes_end),
###               (troop_slot_eq, ":cur_troop", slot_troop_cur_center, "$current_town"),
###               (lt, ":cur_pos", 32), # spawn up to entry point 32
###               (set_visitor, ":cur_pos", ":cur_troop"),
###               (val_add,":cur_pos", 1),
###             (try_end),
##
##             (jump_to_scene,":castle_scene"),
##             (change_screen_mission),
           (try_end),
        ], "Door to the castle."),
        #This slot is not used but it has to stay as a dummy
      ("disguise_and_sneak",[(eq,1,0),(eq,"$entry_to_town_forbidden",1),(eq,"$sneaked_into_town",0),(eq,"$cant_sneak_into_town",0)],
       "Disguise yourself and try to sneak through the town gates.",[
          (store_random,reg(9),100),
          (try_begin),
            (lt, reg(9), 50),
            (jump_to_menu,"mnu_sneak_into_town_caught"),
          (else_try),
            (assign, "$sneaked_into_town",1),
            (jump_to_menu,"mnu_sneak_into_town_suceeded"),
          (try_end),
          ]),
      ("town_castle",[
          (party_slot_eq,"$current_town",slot_party_type, spt_town),
          (eq,"$entry_to_town_forbidden",0),
#          (party_get_slot, ":castle_scene", "$current_town", slot_town_castle),
#          (scene_slot_ge, ":castle_scene", slot_scene_visited, 1), #check if scene has been visited before to allow entry from menu. Otherwise scene will only be accessible from the town center.
          ],"Go to the castle.",
       [
           (try_begin),
             (eq,"$all_doors_locked",1),
             (display_message,"str_door_locked",0xFFFFAAAA),
           (else_try),
             (assign, "$town_entered", 1),
             (call_script, "script_enter_court", "$current_town"),
           (try_end),
        ], "Door to the castle."),
      
      ("town_center",[
          (party_slot_eq,"$current_town",slot_party_type, spt_town),
          (this_or_next|eq,"$entry_to_town_forbidden",0),
          (eq, "$sneaked_into_town",1)]
       ,"Take a walk around the streets.",
       [
           (assign, "$talk_context", 0),
           (try_begin),
             (eq,"$town_nighttime",0),
             (party_get_slot, reg(11), "$current_town", slot_town_center),
           (else_try),
             (party_get_slot, reg(11), "$current_town", slot_town_center),
           (try_end),

           (modify_visitors_at_site,reg(11)),(reset_visitors),
           (store_faction_of_party, ":town_faction","$current_town"),
           (try_begin),
             (neq, ":town_faction", "fac_player_faction"),
             (faction_get_slot, ":troop_prison_guard", "$g_encountered_party_faction", slot_faction_prison_guard_troop),
             (faction_get_slot, ":troop_castle_guard", "$g_encountered_party_faction", slot_faction_castle_guard_troop),
             (set_visitor, 23, ":troop_castle_guard"),
             (set_visitor, 24, ":troop_prison_guard"),
           (try_end),
           (faction_get_slot, ":tier_2_troop", ":town_faction", slot_faction_tier_2_troop),
           (faction_get_slot, ":tier_3_troop", ":town_faction", slot_faction_tier_3_troop),

           (try_begin),
             (gt,":tier_2_troop", 0),
             (assign,reg(0),":tier_3_troop"),
             (assign,reg(1),":tier_3_troop"),
             (assign,reg(2),":tier_2_troop"),
             (assign,reg(3),":tier_2_troop"),
           (else_try),
             (assign,reg(0),"trp_elite_shu_infantry"),
             (assign,reg(1),"trp_elite_shu_infantry"),
             (assign,reg(2),"trp_shu_archer_troop"),
             (assign,reg(3),"trp_shu_solider"),
           (try_end),
           (shuffle_range,0,4),
           (set_visitor,25,reg(0)),
           (set_visitor,26,reg(1)),
           (set_visitor,27,reg(2)),
           (set_visitor,28,reg(3)),

           (call_script, "script_init_town_walkers"),

           (set_jump_mission,"mt_town_center"),
           (try_begin),
             (eq, "$sneaked_into_town",1),
             (set_jump_mission,"mt_town_disguised"),
           (else_try),
             (eq, "$town_entered", 0),
             (assign, "$town_entered", 1),
             (set_jump_entry,1),
           (try_end),
           (party_get_slot, ":eno", "$current_town", slot_town_entry_no),
           (set_jump_entry, ":eno"),
           (jump_to_scene,reg(11)),
           (change_screen_mission),
        ],"Door to the town centre."),

      ("town_tavern",[
          (party_slot_eq,"$current_town",slot_party_type, spt_town),
          (this_or_next|eq,"$entry_to_town_forbidden",0),
          (eq, "$sneaked_into_town",1),
#          (party_get_slot, ":scene", "$current_town", slot_town_tavern),
#          (scene_slot_eq, ":scene", slot_scene_visited, 1), #check if scene has been visited before to allow entry from menu. Otherwise scene will only be accessible from the town center.
          ]
       ,"Visit the tavern.",
       [
           (try_begin),
             (eq,"$all_doors_locked",1),
             (display_message,"str_door_locked",0xFFFFAAAA),
           (else_try),
             (try_begin),
               (eq, "$sneaked_into_town",1),
               (assign,reg(10),"mt_town_disguised"),
             (else_try),
               (assign,reg(10),"mt_town_default"),
             (try_end),
             (assign, "$town_entered", 1),
             (set_jump_mission,reg(10)),
             (party_get_slot, reg(11), "$current_town", slot_town_tavern),
             (jump_to_scene,reg(11)),
             (scene_set_slot, reg(11), slot_scene_visited, 1),

             (assign, "$talk_context", tc_tavern_talk),

             (modify_visitors_at_site,reg(11)),(reset_visitors),
             (party_get_slot, ":mercenary_troop", "$current_town", slot_center_mercenary_troop_type),
             (party_get_slot, ":mercenary_amount", "$current_town", slot_center_mercenary_troop_amount),
             (try_begin),
               (gt, ":mercenary_amount", 0),
               (set_visitor, 17, ":mercenary_troop"),
             (try_end),
             
             (try_begin),
               (party_get_slot, ":companion_candidate", "$current_town", slot_center_companion_candidate),
               (gt, ":companion_candidate", 0),
               (troop_slot_eq, ":companion_candidate", slot_troop_occupation, 0),
               (set_visitor, 18, ":companion_candidate"),
             (try_end),
             (try_begin),
               (party_get_slot, ":ransom_broker", "$current_town", slot_center_ransom_broker),
               (gt, ":ransom_broker", 0),
               (set_visitor, 19, ":ransom_broker"),
             (try_end),
             (try_begin),
               (party_get_slot, ":tavern_traveler", "$current_town", slot_center_tavern_traveler),
               (gt, ":tavern_traveler", 0),
               (set_visitor, 20, ":tavern_traveler"),
             (try_end),
             (try_begin),
               (party_get_slot, ":tavern_minstrel", "$current_town", slot_center_tavern_minstrel),
               (gt, ":tavern_minstrel", 0),
               (set_visitor, 21, ":tavern_minstrel"),
             (try_end),

             (change_screen_mission),
           (try_end,0),
        ],"Door to the tavern."),
      
#      ("town_smithy",[
#          (eq,"$entry_to_town_forbidden",0),
#          (eq,"$town_nighttime",0),
#          ],
#       "Visit the smithy.",
#       [
#           (set_jump_mission,"mt_town_default"),
#           (jump_to_scene,"$pout_scn_smithy"),
#           (change_screen_mission,0),
#        ]),
      
      ("town_merchant",
       [(party_slot_eq,"$current_town",slot_party_type, spt_town),
           (eq, 1, 0),
           (eq,"$town_nighttime",0),
           (this_or_next|eq,"$entry_to_town_forbidden",0),
           (eq, "$sneaked_into_town",1),
#           (party_get_slot, ":scene", "$current_town", slot_town_store),
#           (scene_slot_eq, ":scene", slot_scene_visited, 1), #check if scene has been visited before to allow entry from menu. Otherwise scene will only be accessible from the town center.
           ],
       "Speak with the merchant.",
       [
           
           (try_begin),
             (this_or_next|eq,"$all_doors_locked",1),
             (eq,"$town_nighttime",1),
             (display_message,"str_door_locked",0xFFFFAAAA),
           (else_try),
             (try_begin),
               (eq, "$sneaked_into_town",1),
               (assign,reg(10),"mt_town_disguised"),
             (else_try),
               (assign,reg(10),"mt_town_default"),
             (try_end),
             (assign, "$town_entered", 1),
             (set_jump_mission,reg(10)),
             (party_get_slot, reg(11), "$current_town", slot_town_store),
             (jump_to_scene,reg(11)),
             (scene_set_slot, reg(11), slot_scene_visited, 1),
             (change_screen_mission),
           (try_end),
        ],"Door to the shop."),

      ("town_dungeon",
       [(eq, "$cheat_mode", 1),(party_slot_eq,"$current_town",slot_party_type, spt_town),(eq, "$g_encountered_party_faction", "fac_player_faction")],
       "CHEAT: Enter the dungeon.",
       [
           (try_begin),
             (neq, "$g_encountered_party_faction", "fac_player_faction"),
             (display_message,"str_door_locked",0xFFFFAAAA),
           (else_try),
             (assign, "$town_entered", 1),
             (call_script, "script_enter_dungeon", "$current_town", "mt_town_default"),
           (try_end),
        ],"Door to the dungeon."),
      
      ("castle_inspect", [
         (party_slot_eq,"$current_town",slot_party_type, spt_castle),
#           (this_or_next|ge, "$g_encountered_party_relation", 0),
#           (eq,"$castle_undefended",1),
          ],
       "Take a walk around the premises.",
       [
           (party_get_slot, ":cur_castle_exterior", "$current_town", slot_castle_exterior),
           (modify_visitors_at_site,":cur_castle_exterior"),(reset_visitors),
           (set_visitor, 0, "trp_player"),
           (assign, ":guard_no", 1),

           (party_get_num_companion_stacks, ":num_stacks", "$g_encountered_party"),
           (try_for_range, ":troop_iterator", 0, ":num_stacks"),
             (lt, ":guard_no", 5),
             (party_stack_get_troop_id, ":cur_troop_id", "$g_encountered_party", ":troop_iterator"),
             (neg|troop_is_hero, ":cur_troop_id"),
             (party_stack_get_size, ":stack_size","$g_encountered_party",":troop_iterator"),
             (party_stack_get_num_wounded, ":num_wounded","$g_encountered_party",":troop_iterator"),
             (val_sub, ":stack_size", ":num_wounded"),
             (gt, ":stack_size", 0),
             (party_stack_get_troop_dna,":troop_dna","$g_encountered_party",":troop_iterator"),
             (set_visitor, ":guard_no", ":cur_troop_id", ":troop_dna"),
             (val_add, ":guard_no", 1),
           (try_end),
##           (try_begin),
##             (neq, "$g_encountered_party_faction", "fac_player_faction"),
##             (faction_get_slot, ":troop_prison_guard", "$g_encountered_party_faction", slot_faction_prison_guard_troop),
##             (set_visitor, 5, ":troop_prison_guard"),
##           (try_end),
           (set_jump_mission,"mt_castle_visit"),
           (jump_to_scene,":cur_castle_exterior"),
           (change_screen_mission),
        ]),

      ("trade_with_merchants",
       [
           (party_slot_eq,"$current_town",slot_party_type, spt_town)
        ],
         "Go to the marketplace.",
         [
           (jump_to_menu,"mnu_town_trade"),
          ]),
      
     ("castle_station_troops",
      [
          (party_slot_eq,"$current_town",slot_town_lord, "trp_player"),
       ],
         "Station a garrison here...",
         [
           (change_screen_exchange_members,1),
          ]),


      ("castle_wait",
       [
#           (party_slot_eq,"$current_town",slot_party_type, spt_castle),
           (this_or_next|ge, "$g_encountered_party_relation", 0),
           (eq,"$castle_undefended",1),
           (assign, ":can_rest", 1),
           (str_clear, s1),
           (try_begin),
             (neq, "$g_encountered_party_faction", "$players_kingdom"),
             (neq, "$g_encountered_party_faction", "fac_player_faction"),
             (party_get_num_companions, ":num_men", "p_main_party"),
             (store_div, reg1, ":num_men", 5),
             (val_add, reg1, 1),
             (str_store_string, s1, "@ ({reg1} denars per night)"),
             (store_troop_gold, ":gold", "trp_player"),
             (lt, ":gold", reg1),
             (assign, ":can_rest", 0),
           (try_end),
           (eq, ":can_rest", 1),
           (eq, "$g_defending_against_siege", 0),
        ],
         "Wait here for some time{s1}.",
         [
           (assign,"$auto_enter_town","$current_town"),
           (assign, "$g_town_visit_after_rest", 1),
           (assign, "$g_last_rest_center", "$current_town"),
           (assign, "$g_last_rest_payment_until", -1),

           (rest_for_hours_interactive, 72, 5, 0), #rest while not attackable
           (change_screen_return),
          ]),

##      ("rest_until_morning",
##       [
##           (this_or_next|ge, "$g_encountered_party_relation", 0),
##           (eq,"$castle_undefended",1),
##           (store_time_of_day,reg(1)),(neg|is_between,reg(1), 5, 18),
##           (eq, "$g_defending_against_siege", 0),
##        ],
##         "Rest until morning.",
##         [
##           (store_time_of_day,reg(1)),
##           (assign, reg(2), 30),
##           (val_sub,reg(2),reg(1)),
##           (val_mod,reg(2),24),
##           (assign,"$auto_enter_town","$current_town"),
##           (assign, "$g_town_visit_after_rest", 1),
##           (rest_for_hours_interactive, reg(2)),
##           (change_screen_return),
##          ]),
##      
##      ("rest_until_evening",
##       [
##           (this_or_next|ge, "$g_encountered_party_relation", 0),
##           (eq,"$castle_undefended",1),
##           (store_time_of_day,reg(1)), (is_between,reg(1), 5, 18),
##           (eq, "$g_defending_against_siege", 0),
##        ],
##         "Rest until evening.",
##         [
##           (store_time_of_day,reg(1)),
##           (assign, reg(2), 20),
##           (val_sub,reg(2),reg(1)),
##           (assign,"$auto_enter_town","$current_town"),
##           (assign, "$g_town_visit_after_rest", 1),
##           (rest_for_hours_interactive, reg(2)),
##           (change_screen_return),
##          ]),
      ("town_alley",
       [(party_slot_eq,"$current_town",slot_party_type, spt_town),(neq, "$sneaked_into_town",1),
        (eq, "$cheat_mode", 1),
        (eq, 1, 0),#Never enters here
           ],
       "Go to the alley.",
       [
           (party_slot_eq,"$current_town",slot_party_type, spt_town),
           (eq,"$town_nighttime",0),
           (this_or_next|eq,"$entry_to_town_forbidden",0),
           (eq, "$sneaked_into_town",1),
           (party_get_slot, reg(11), "$current_town", slot_town_alley),
           (set_jump_mission,"mt_town_default"),
           (jump_to_scene,reg(11)),
           (change_screen_mission),
        ]),
      
      ("town_leave",[],"Leave...",[
            (assign, "$g_permitted_to_center",0),
            (change_screen_return,0),
          ],"Leave Area."),
#      ("siege_leave",[(eq, "$g_defending_against_siege", 1)],"Try to break out...",[(jump_to_menu,"mnu_siege_break_out")]),#TODO: Go to Menu here.

      ("castle_cheat_interior",[(eq, "$cheat_mode", 1)], "CHEAT! Interior.",[
                                                       (set_jump_mission,"mt_ai_training"),
                                                       (party_get_slot, ":castle_scene", "$current_town", slot_town_castle),
                                                       (jump_to_scene,":castle_scene"),
                                                       (change_screen_mission)]),
      ("castle_cheat_town_exterior",[(eq, "$cheat_mode", 1)], "CHEAT! Exterior.",[
                                                       (try_begin),
                                                         (party_slot_eq,"$current_town",slot_party_type, spt_castle),
                                                         (party_get_slot, ":scene", "$current_town", slot_castle_exterior),
                                                       (else_try),
                                                         (party_get_slot, ":scene", "$current_town", slot_town_center),
                                                       (try_end),
                                                       (set_jump_mission,"mt_ai_training"),
                                                       (jump_to_scene,":scene"),
                                                       (change_screen_mission)]),

      ("center_reports",[(eq, "$cheat_mode", 1),], "CHEAT! Show reports.",
       [(jump_to_menu,"mnu_center_reports"),
           ]),

      ("manage_center",[(party_slot_eq, "$current_town", slot_town_lord, "trp_player"),
                        (assign, reg1, 1),
                        (try_begin),
                          (party_slot_eq,"$current_town",slot_party_type, spt_castle),
                          (assign, reg1, 0),
                        (try_end),], "Manage this {reg1?town:castle}.",
       [(jump_to_menu,"mnu_center_management"),
           ]),
      

      ("sail_from_port",[(party_slot_eq,"$current_town",slot_party_type, spt_town),
                         (eq, "$cheat_mode", 1),
#                         (party_slot_eq,"$current_town",slot_town_near_shore, 1),
                         ], "Sail from port.",
       [(assign, "$g_player_icon_state", pis_ship),
        (party_set_flags, "p_main_party", pf_is_ship, 1),
        (party_get_position, pos1, "p_main_party"),
        (map_get_water_position_around_position, pos2, pos1, 6),
        (party_set_position, "p_main_party", pos2),
        (assign, "$g_main_ship_party", -1),
        (change_screen_return),
        ]),

      ]
  ),

  (
    "center_management",0,
    "Not available in this version of Mount&Blade.",
    "none",
    [],
    [
      ("continue", [], "Continue...",
       [(jump_to_menu, "mnu_town"),
        ]),
    ]
  ),

  (
    "disembark",0,
    "Do you wish to disembark?",
    "none",
    [],
    [
      ("disembark_yes", [], "Yes.",
       [(assign, "$g_player_icon_state", pis_normal),
        (party_set_flags, "p_main_party", pf_is_ship, 0),
        (party_get_position, pos1, "p_main_party"),
        (party_set_position, "p_main_party", pos0),
        (try_begin),
          (le, "$g_main_ship_party", 0),
          (set_spawn_radius, 0),
          (spawn_around_party, "p_main_party", "pt_none"),
          (assign, "$g_main_ship_party", reg0),
          (party_set_flags, "$g_main_ship_party", pf_is_static|pf_always_visible|pf_hide_defenders|pf_is_ship, 1),
          (str_store_troop_name, s1, "trp_player"),
          (party_set_name, "$g_main_ship_party", "@{s1}'s Ship"),
          (party_set_icon, "$g_main_ship_party", "icon_ship"),
          (party_set_slot, "$g_main_ship_party", slot_party_type, spt_ship),
        (try_end),
        (enable_party, "$g_main_ship_party"),
        (party_set_position, "$g_main_ship_party", pos0),
        (party_set_icon, "$g_main_ship_party", "icon_ship_on_land"),
        (assign, "$g_main_ship_party", -1),
        (change_screen_return),
        ]),
      ("disembark_no", [], "No.",
       [(change_screen_return),
        ]),
    ]
  ),

  (
    "ship_reembark",0,
    "Do you wish to embark?",
    "none",
    [],
    [
      ("reembark_yes", [], "Yes.",
       [(assign, "$g_player_icon_state", pis_ship),
        (party_set_flags, "p_main_party", pf_is_ship, 1),
        (party_get_position, pos1, "p_main_party"),
        (map_get_water_position_around_position, pos2, pos1, 6),
        (party_set_position, "p_main_party", pos2),
        (assign, "$g_main_ship_party", "$g_encountered_party"),
        (disable_party, "$g_encountered_party"),
        (change_screen_return),
        ]),
      ("reembark_no", [], "No.",
       [(change_screen_return),
        ]),
    ]
  ),

  (
    "center_reports",0,
    "Town Name: {s1}^Rent Income: {reg1} denars^Tariff Income: {reg2} denars^Food Stock: for {reg3} days",
    "none",
    [(party_get_slot, ":town_food_store", "$g_encountered_party", slot_party_food_store),
     (call_script, "script_center_get_food_consumption", "$g_encountered_party"),
     (assign, ":food_consumption", reg0),
     (store_div, reg3, ":town_food_store", ":food_consumption"),
     (str_store_party_name, s1, "$g_encountered_party"),
     (party_get_slot, reg1, "$g_encountered_party", slot_center_accumulated_rents),
     (party_get_slot, reg2, "$g_encountered_party", slot_center_accumulated_tariffs),
     ],
    [
      ("to_price_and_productions", [], "Show prices and productions.",
       [(jump_to_menu, "mnu_price_and_production"),
        ]),
      
      ("go_back_dot",[],"Go back.",
       [(try_begin),
          (party_slot_eq, "$g_encountered_party", slot_party_type, spt_village),
          (jump_to_menu, "mnu_village"),
        (else_try),
          (jump_to_menu, "mnu_town"),
        (try_end),
        ]),
    ]
  ),
    
  (
    "price_and_production",0,
    "Productions are:^{s1}^^Price factors are:^{s2}",
    "none",
    [(str_store_string, s1, "@ "),
     (str_store_string, s2, "@ "),
     (try_for_range, ":cur_good", trade_goods_begin, trade_goods_end),
       (store_sub, ":cur_good_slot", ":cur_good", trade_goods_begin),
       (val_add, ":cur_good_slot", slot_town_trade_good_productions_begin),
       (store_sub, ":cur_good_price_slot", ":cur_good", trade_goods_begin),
       (val_add, ":cur_good_price_slot", slot_town_trade_good_prices_begin),
       (party_get_slot, ":production", "$g_encountered_party", ":cur_good_slot"),
       (party_get_slot, ":price", "$g_encountered_party", ":cur_good_price_slot"),
       (str_store_item_name, s3, ":cur_good"),
       (assign, reg1, ":production"),
       (str_store_string, s1, "@^{s3} = {reg1}{s1}"),
       (assign, reg1, ":price"),
       (str_store_string, s2, "@^{s3} = {reg1}{s2}"),
     (try_end),
     ],
    [
      ("go_back_dot",[],"Go back.",
       [(try_begin),
          (party_slot_eq, "$g_encountered_party", slot_party_type, spt_village),
          (jump_to_menu, "mnu_village"),
        (else_try),
          (jump_to_menu, "mnu_town"),
        (try_end),
        ]),
    ]
  ),


  
  (
    "town_trade",0,
    "You head towards the marketplace.",
    "none",
    [],
    [
      ("assess_prices",[],
       "Assess trade goods prices.",
       [
           (assign,"$auto_enter_town","$current_town"),
           (assign, "$g_town_assess_trade_goods_after_rest", 1),

           (call_script, "script_get_max_skill_of_player_party", "skl_trade"),
           (val_div, reg0, 2),
           (store_sub, ":num_hours", 6, reg0),

           (assign, "$g_last_rest_center", "$current_town"),
           (assign, "$g_last_rest_payment_until", -1),

           (rest_for_hours, ":num_hours", 5, 0), #rest while not attackable
           (change_screen_return),
        ]),
      ("trade_with_arms_merchant",[(party_slot_ge, "$current_town", slot_town_weaponsmith, 1)],
       "Trade with the arms merchant.",
       [
           (party_get_slot, ":merchant_troop", "$current_town", slot_town_weaponsmith),
           (change_screen_trade, ":merchant_troop"),
        ]),
      ("trade_with_armor_merchant",[(party_slot_ge, "$current_town", slot_town_armorer, 1)],
       "Trade with the armor merchant.",
       [
           (party_get_slot, ":merchant_troop", "$current_town", slot_town_armorer),
           (change_screen_trade, ":merchant_troop"),
        ]),
      ("trade_with_horse_merchant",[(party_slot_ge, "$current_town", slot_town_horse_merchant, 1)],
       "Trade with the horse merchant.",
       [
           (party_get_slot, ":merchant_troop", "$current_town", slot_town_horse_merchant),
           (change_screen_trade, ":merchant_troop"),
        ]),
      ("trade_with_goods_merchant",[(party_slot_ge, "$current_town", slot_town_merchant, 1)],
       "Trade with the goods merchant.",
       [
           (party_get_slot, ":merchant_troop", "$current_town", slot_town_merchant),
           (change_screen_trade, ":merchant_troop"),
        ]),
      ("back_to_town_menu",[],"Head back.",
       [
           (jump_to_menu,"mnu_town"),
        ]),
    ]
  ),


  (
    "town_trade_assessment",0,
    "As the party member with the highest trade skill ({reg2}), {reg3?you assess:{s1} assesses} the prices. {s2}",
    "none",
    [(call_script, "script_get_max_skill_of_player_party", "skl_trade"),
     (assign, ":max_skill", reg0),
     (assign, ":max_skill_owner", reg1),

     (assign, ":num_best_results", 0),
     (assign, ":best_result_1_item", -1),
     (assign, ":best_result_1_town", -1),
     (assign, ":best_result_1_profit", 0),
     (assign, ":best_result_2_item", -1),
     (assign, ":best_result_2_town", -1),
     (assign, ":best_result_2_profit", 0),
     (assign, ":best_result_3_item", -1),
     (assign, ":best_result_3_town", -1),
     (assign, ":best_result_3_profit", 0),

     (store_sub, ":num_towns", towns_end, towns_begin),
     (store_sub, ":num_goods", trade_goods_end, trade_goods_begin),
     (store_mul, ":max_iteration", ":num_towns", ":num_goods"),
     (val_mul, ":max_iteration", ":max_skill"),
     (val_div, ":max_iteration", 20),

     (assign, ":org_encountered_party", "$g_encountered_party"),

     (try_for_range, ":unused", 0, ":max_iteration"),
       (store_random_in_range, ":random_trade_good", trade_goods_begin, trade_goods_end),
       (store_random_in_range, ":random_town", towns_begin, towns_end),
       (assign, ":already_best", 0),
       (try_begin),
         (eq, ":random_trade_good", ":best_result_1_item"),
         (eq, ":random_town", ":best_result_1_town"),
         (val_add, ":already_best", 1),
       (else_try),
         (eq, ":random_trade_good", ":best_result_2_item"),
         (eq, ":random_town", ":best_result_2_town"),
         (val_add, ":already_best", 1),
       (else_try),
         (eq, ":random_trade_good", ":best_result_3_item"),
         (eq, ":random_town", ":best_result_3_town"),
         (val_add, ":already_best", 1),
       (try_end),
       (eq, ":already_best", 0),
       (store_item_value, ":random_trade_good_price", ":random_trade_good"),
       (assign, "$g_encountered_party", ":org_encountered_party"),
       (call_script, "script_game_get_item_buy_price_factor", ":random_trade_good"),
       (store_mul, ":random_trade_good_buy_price", ":random_trade_good_price", reg0),
       (val_div, ":random_trade_good_buy_price", 100),
       (val_max, ":random_trade_good_buy_price", 1),
       (assign, "$g_encountered_party", ":random_town"),
       (call_script, "script_game_get_item_sell_price_factor", ":random_trade_good"),
       (store_mul, ":random_trade_good_sell_price", ":random_trade_good_price", reg0),
       (val_div, ":random_trade_good_sell_price", 100),
       (val_max, ":random_trade_good_sell_price", 1),
       (store_sub, ":difference", ":random_trade_good_sell_price", ":random_trade_good_buy_price"),
       (try_begin),
         (gt, ":difference", ":best_result_1_profit"),
         (val_add, ":num_best_results", 1),
         (val_min, ":num_best_results", 3),
         (assign, ":best_result_3_item", ":best_result_2_item"),
         (assign, ":best_result_3_town", ":best_result_2_town"),
         (assign, ":best_result_3_profit", ":best_result_2_profit"),
         (assign, ":best_result_2_item", ":best_result_1_item"),
         (assign, ":best_result_2_town", ":best_result_1_town"),
         (assign, ":best_result_2_profit", ":best_result_1_profit"),
         (assign, ":best_result_1_item", ":random_trade_good"),
         (assign, ":best_result_1_town", ":random_town"),
         (assign, ":best_result_1_profit", ":difference"),
       (else_try),
         (gt, ":difference", ":best_result_2_profit"),
         (val_add, ":num_best_results", 1),
         (val_min, ":num_best_results", 3),
         (assign, ":best_result_3_item", ":best_result_2_item"),
         (assign, ":best_result_3_town", ":best_result_2_town"),
         (assign, ":best_result_3_profit", ":best_result_2_profit"),
         (assign, ":best_result_2_item", ":random_trade_good"),
         (assign, ":best_result_2_town", ":random_town"),
         (assign, ":best_result_2_profit", ":difference"),
       (else_try),
         (gt, ":difference", ":best_result_3_profit"),
         (val_add, ":num_best_results", 1),
         (val_min, ":num_best_results", 3),
         (assign, ":best_result_3_item", ":random_trade_good"),
         (assign, ":best_result_3_town", ":random_town"),
         (assign, ":best_result_3_profit", ":difference"),
       (try_end),
     (try_end),

     (assign, "$g_encountered_party", ":org_encountered_party"),

     (str_clear, s3),
     
     (assign, reg2, ":max_skill"),
     (try_begin),
       (eq, ":max_skill_owner", "trp_player"),
       (assign, reg3, 1),
     (else_try),
       (assign, reg3, 0),
       (str_store_troop_name, s1, ":max_skill_owner"),
     (try_end),
     (try_begin),
       (le, ":num_best_results", 0),
       (str_store_string, s2, "@{reg3?You:{s1}} could not find any trade goods that would bring you a profit."),
     (else_try),
       (try_begin),
         (ge, ":best_result_3_item", 0),
         (assign, reg6, ":best_result_3_profit"),
         (str_store_item_name, s4, ":best_result_3_item"),
         (str_store_party_name, s5, ":best_result_3_town"),
         (str_store_string, s3, "@^Buying {s4} from here and selling it at {s5} would generate a profit of {reg6} denars per item.{s3}"),
       (try_end),
       (try_begin),
         (ge, ":best_result_2_item", 0),
         (assign, reg6, ":best_result_2_profit"),
         (str_store_item_name, s4, ":best_result_2_item"),
         (str_store_party_name, s5, ":best_result_2_town"),
         (str_store_string, s3, "@^Buying {s4} from here and selling it at {s5} would generate a profit of {reg6} denars per item.{s3}"),
       (try_end),
       (try_begin),
         (ge, ":best_result_1_item", 0),
         (assign, reg6, ":best_result_1_profit"),
         (str_store_item_name, s4, ":best_result_1_item"),
         (str_store_party_name, s5, ":best_result_1_town"),
         (str_store_string, s3, "@^Buying {s4} from here and selling it at {s5} would generate a profit of {reg6} denars per item.{s3}"),
       (try_end),
       (str_store_string, s2, "@{reg3?You find:{s1} finds} out the following:^{s3}"),
     (try_end),
     ],
    [
      ("continue",[],"Continue...",
       [
           (jump_to_menu,"mnu_town_trade"),
        ]),
    ]
  ),

  (
    "sneak_into_town_suceeded",0,
    "Disguised in the garments of a poor pilgrim, you fool the guards and make your way into the town.",
    "none",
    [],
    [
      ("continue",[],"Continue...",
       [
           (assign, "$sneaked_into_town",1),
           (jump_to_menu,"mnu_town"),
        ]),
    ]
  ),
  (
    "sneak_into_town_caught",0,
    "As you try to sneak in, one of the guards recognizes you and gives a warning!\
 You must flee back through the gates before all the guards in the town rush against you.",
    "none",
    [
       (assign,"$auto_menu","mnu_captivity_start_castle_surrender"),
    ],
    [
      ("sneak_caught_fight",[],"Try to fight your way out!",
       [
           (assign,"$all_doors_locked",1),
           (party_get_slot, ":sneak_scene", "$current_town",slot_town_center), # slot_town_gate),
           (modify_visitors_at_site,":sneak_scene"),(reset_visitors),
           (set_visitor,0,"trp_player"),
           (store_faction_of_party, ":town_faction","$current_town"),
           (faction_get_slot, ":tier_2_troop", ":town_faction", slot_faction_tier_2_troop),
           (faction_get_slot, ":tier_3_troop", ":town_faction", slot_faction_tier_3_troop),
           (try_begin),
             (gt, ":tier_2_troop", 0),
             (gt, ":tier_3_troop", 0),
             (assign,reg(0),":tier_3_troop"),
             (assign,reg(1),":tier_3_troop"),
             (assign,reg(2),":tier_2_troop"),
             (assign,reg(3),":tier_2_troop"),
           (else_try),
             (assign,reg(0),"trp_wei_elite_archer"),
             (assign,reg(1),"trp_wei_archer"),
             (assign,reg(2),"trp_wei_elite_footman"),
             (assign,reg(3),"trp_wei_archer"),
           (try_end),
           (assign,reg(4),-1),
           (shuffle_range,0,5),
           (set_visitor,1,reg(0)),
           (set_visitor,2,reg(1)),
           (set_visitor,3,reg(2)),
           (set_visitor,4,reg(3)),
           (set_jump_mission,"mt_sneak_caught_fight"),
 #          (jump_to_menu,"mnu_captivity_start_castle_defeat"),
           (set_passage_menu,"mnu_town"),
           (jump_to_scene,":sneak_scene"),
           (change_screen_mission),
        ]),
      ("sneak_caught_surrender",[],"Surrender.",
       [
           (jump_to_menu,"mnu_captivity_start_castle_surrender"),
        ]),
    ]
  ),
  (
    "sneak_into_town_caught_ran_away",0,
    "You leave the town behind and run away to the safety of the hills.",
    "none",
    [],
    [
      ("continue",[],"Continue...",
       [
           (assign,"$auto_menu",-1),
           (store_encountered_party,"$last_sneak_attempt_town"),
           (store_current_hours,"$last_sneak_attempt_time"),
           (change_screen_return),
        ]),
    ]
  ),


##  (
##    "oath_fulfilled",0,
##    "You had given your oath to {s1} to serve him for a certain duration.\
## Your oath has now been fulfilled. What will you do?",
##    "none",
##    [(faction_get_slot, ":faction_leader", "$players_kingdom"),
##     (str_store_troop_name,s1,":faction_leader"),
##     ],
##    [
##      ("renew_oath",[],"Renew your oath to {s1} for another month.",[
##          (store_current_day, ":cur_day"),
##          (store_add, "$g_oath_end_day", ":cur_day", 30),
##          (change_screen_return)]),
##      ("dont_renew_oath",[],"Become free of your bond.",[
##          (assign, "$players_kingdom",0),
##          (assign, "$g_player_permitted_castles", 0),
##          (change_screen_return)]),
##    ]
##  ),


#####################################################################
## Captivity....
#####################################################################
#####################################################################
#####################################################################
#####################################################################

  (
    "captivity_start_wilderness",0,
    "Stub",
    "none",
    [
          (assign, "$g_player_is_captive", 1),
          (try_begin),
            (eq,"$g_player_surrenders",1),
            (jump_to_menu, "mnu_captivity_start_wilderness_surrender"), 
          (else_try),
            (jump_to_menu, "mnu_captivity_start_wilderness_defeat"), 
          (try_end),
      ],
    []
  ),
  
  (
    "captivity_start_wilderness_surrender",0,
    "Stub",
    "none",
    [
       (assign, "$g_player_is_captive", 1),
       (assign,"$auto_menu",-1), #We need this since we may come here by something other than auto_menu
       (assign, "$capturer_party", "$g_encountered_party"),
       (jump_to_menu, "mnu_captivity_wilderness_taken_prisoner"),
      ],
    []
  ),
  (
    "captivity_start_wilderness_defeat",0,
    "Your enemies take you as prisoner.",
    "none",
    [
       (assign, "$g_player_is_captive", 1),
       (assign,"$auto_menu",-1),
       (assign, "$capturer_party", "$g_encountered_party"),
       (jump_to_menu, "mnu_captivity_wilderness_taken_prisoner"),
    ],
    []
  ),
  (
    "captivity_start_castle_surrender",0,
    "Stub",
    "none",
    [
       (assign, "$g_player_is_captive", 1),
       (assign,"$auto_menu",-1),
       (assign, "$capturer_party", "$g_encountered_party"),
       (jump_to_menu, "mnu_captivity_castle_taken_prisoner"),
      ],
    []
  ),
  (
    "captivity_start_castle_defeat",0,
    "Stub",
    "none",
    [
       (assign, "$g_player_is_captive", 1),
       (assign,"$auto_menu",-1),
       (assign, "$capturer_party", "$g_encountered_party"),
       (jump_to_menu, "mnu_captivity_castle_taken_prisoner"),
      ],
    []
  ),
  (
    "captivity_start_under_siege_defeat",0,
    "Your enemies take you as prisoner.",
    "none",
    [
       (assign, "$g_player_is_captive", 1),
       (assign,"$auto_menu",-1),
       (assign, "$capturer_party", "$g_encountered_party"),
       (jump_to_menu, "mnu_captivity_castle_taken_prisoner"),
    ],
    []
  ),  
  (
    "captivity_wilderness_taken_prisoner",0,
    "Your enemies take you as prisoner.",
    "none",
    [
        (set_background_mesh, "mesh_pic_prisoner_wilderness"),
     ],
    [
      ("continue",[],"Continue...",
       [
           (set_camera_follow_party, "$capturer_party"),
           (assign, "$g_player_is_captive", 1),
           (store_random_in_range, reg(8), 12, 19),
           (rest_for_hours, reg(8)),
           (assign,"$auto_menu","mnu_captivity_wilderness_check"),
           (change_screen_return),
        ]),
    ]
  ),
  (
    "captivity_wilderness_check",0,
    "stub",
    "none",
    [(jump_to_menu,"mnu_captivity_end_wilderness_escape")],
    []
  ),
  (
    "captivity_end_wilderness_escape",0,
    "After painful days of being dragged about as a prisoner, you find a chance and escape from your captors!",
    "none",
    [
        (set_background_mesh, "mesh_pic_escape_1"),
    ],
    [
      ("continue",[],"Continue...",
       [
           (assign, "$g_player_is_captive", 0),
           (assign, "$g_player_icon_state", pis_normal),
           (party_relocate_near_party, "p_main_party", "$capturer_party", 2),
           (party_ignore_player, "$capturer_party", 6),
           (set_camera_follow_party, "p_main_party"),
           (change_screen_return),
        ]),
    ]
  ),
  (
    "captivity_castle_taken_prisoner",0,
    "You are quickly surrounded by guards who take away your weapons. With curses and insults, they throw you into the dungeon where you will spend the miserable days of your captivity.",
    "none",
    [],
    [
      ("continue",[],"Continue...",
       [
           (assign, "$g_player_is_captive", 1),
           (store_random_in_range, reg(8), 16, 22),
           (rest_for_hours, reg(8)),
           (assign,"$auto_menu", "mnu_captivity_castle_check"),
           (change_screen_return)
        ]),
    ]
  ),
##  (
##    "captivity_rescue_lord_taken_prisoner",0,
##    "Lord has escaped and you were taken prisoner.",
##    "none",
##    [],
##    [
##      ("continue",[],"Continue...",
##       [
##           (assign, "$g_player_is_captive", 1),
##           (store_random_in_range, reg(8), 16, 22),
##           (rest_for_hours, reg(8)),
##           (assign,"$auto_menu", "mnu_captivity_castle_check"),
##           (change_screen_return)
##        ]),
##    ]
##  ),
  (
    "captivity_castle_check",0,
    "stub",
    "none",
    [
        (store_random_in_range, reg(7), 0, 10),
        (try_begin),
          (lt, reg(7), 4),
          (store_random_in_range, "$player_ransom_amount", 3, 6),
          (val_mul, "$player_ransom_amount", 100),
          (store_troop_gold, reg(3), "trp_player"),
          (gt, reg(3), "$player_ransom_amount"),
          (jump_to_menu,"mnu_captivity_end_propose_ransom"),
        (else_try),
          (lt, reg(7), 7),
          (jump_to_menu,"mnu_captivity_end_exchanged_with_prisoner"),
        (else_try),
          (jump_to_menu,"mnu_captivity_castle_remain"),
        (try_end),
    ],
    []
  ),
  (
    "captivity_end_exchanged_with_prisoner",0,
    "After days of imprisonment, you are finally set free when your captors exchange you with a prisoner of their own.",
    "none",
    [],
    [
      ("continue",[],"Continue...",
       [
           (assign, "$g_player_is_captive", 0),
           (party_relocate_near_party, "p_main_party", "$capturer_party", 2),
           (party_ignore_player, "$capturer_party", 12),
           (set_camera_follow_party, "p_main_party"),
           (change_screen_return),
        ]),
    ]
  ),
  (
    "captivity_end_propose_ransom",0,
    "After some time your captors come to you with an offer: In return for {reg5} denars of your hidden wealth, they propose to set you free. You decide to...",
    "none",
    [
        (store_character_level, ":player_level", "trp_player"),
        (store_mul, "$player_ransom_amount", ":player_level", 50),
        (val_add, "$player_ransom_amount", 100),
        (assign, reg5, "$player_ransom_amount"),
    ],
    [
      ("captivity_end_ransom_accept",[(store_troop_gold,":player_gold", "trp_player"),(ge, ":player_gold","$player_ransom_amount")],"Accept the offer.",
       [
           (assign, "$g_player_is_captive", 0),
           (troop_remove_gold, "trp_player", "$player_ransom_amount"), 
           (party_relocate_near_party, "p_main_party", "$capturer_party", 1),
           (party_ignore_player, "$capturer_party", 6),
           (set_camera_follow_party, "p_main_party"),
           (rest_for_hours, 0),
           (change_screen_return),
        ]),
      ("captivity_end_ransom_deny",[],"Wait for a better chance.",
       [
           (assign, "$g_player_is_captive", 1),
           (store_random_in_range, reg(8), 16, 22),
           (rest_for_hours, reg(8)),
           (assign,"$auto_menu", "mnu_captivity_castle_check"),
           (change_screen_return),
        ]),
    ]
  ),
  (
    "captivity_castle_remain",0,
    "Days pass in the darkness of your cell where you have to endure the hardships of captivity and the scorns of the guards...",
    "none",
    [
        (set_background_mesh, "mesh_pic_prisoner_man"),        
        (store_random_in_range, reg(8), 16, 22),
        (rest_for_hours, reg(8)),
        (assign,"$auto_menu", "mnu_captivity_castle_check"),
        
    ],
    [
      ("continue",[],"Continue...",
       [
           (assign, "$g_player_is_captive", 1),
           (change_screen_return),
        ]),
    ]
  ),

  (
    "invite_player_to_faction",0,
    "You Receive an Offer of Vassalage^^{s8} of {s9} invites you to be his vassal and offers you the fief of {s2}.\
 In return he asks you to swear an oath of fealty to him and fight in his military campaigns.",
    "none",
    [
        (set_background_mesh, "mesh_pic_messenger"),
        (faction_get_slot, "$g_invite_faction_lord", "$g_invite_faction", slot_faction_leader),
        (str_store_troop_name, s8, "$g_invite_faction_lord"),
        (str_store_faction_name, s9, "$g_invite_faction"),
        (str_store_party_name, s2, "$g_invite_offered_center"),
      ],
    [
      ("faction_accept",[],"Accept...",
       [(str_store_troop_name,s1,"$g_invite_faction_lord"),
        (setup_quest_text,"qst_join_faction"),

        (str_store_troop_name_link, s3, "$g_invite_faction_lord"),
        (str_store_faction_name_link, s4, "$g_invite_faction"),
        (str_store_party_name_link, s5, "$g_invite_offered_center"),
        (str_store_string, s2, "@Find and speak with {s3} of {s4} to give him your oath of fealty."),
        (call_script, "script_start_quest", "qst_join_faction", "$g_invite_faction_lord"),
        (call_script, "script_report_quest_troop_positions", "qst_join_faction", "$g_invite_faction_lord"),
        (jump_to_menu, "mnu_invite_player_to_faction_accepted"),
        ]),
      ("faction_reject",[],"Reject...",
       [(call_script, "script_change_player_relation_with_troop", "$g_invite_faction_lord", -3),
        (assign, "$g_invite_faction", 0),
        (assign, "$g_invite_faction_lord", 0),
        (assign, "$g_invite_offered_center", 0),
        (change_screen_return),
        ]),
     ]
  ),
  
  (
    "invite_player_to_faction_accepted",0,
    "{s3} will expect you to swear an oath of fealty to him. Therefore, you must find him and give him your oath. {s5}.",
    "none",
    [
        (call_script, "script_get_information_about_troops_position", "$g_invite_faction_lord", 0),
        (str_store_troop_name, s3, "$g_invite_faction_lord"),
        (str_store_string, s5, "@{s1}"),        
      ],
    [
      ("continue",[],"Continue...",
       [(change_screen_return),
        ]),
     ]
  ),


 
 ]

