from header_items import  *
from header_operations import *
from header_triggers import *

####################################################################################################################
#  Each item record contains the following fields:
#  1) Item id: used for referencing items in other files.
#     The prefix itm_ is automatically added before each item id.
#  2) Item name. Name of item as it'll appear in inventory window
#  3) List of meshes.  Each mesh record is a tuple containing the following fields:
#    3.1) Mesh name.
#    3.2) Modifier bits that this mesh matches.
#     Note that the first mesh record is the default.
#  4) Item flags. See header_items.py for a list of available flags.
#  5) Item capabilities. Used for which animations this item is used with. See header_items.py for a list of available flags.
#  6) Item value.
#  7) Item stats: Bitwise-or of various stats about the item such as:
#      weight, abundance, difficulty, head_armor, body_armor,leg_armor, etc...
#  8) Modifier bits: Modifiers that can be applied to this item.
#  9) [Optional] Triggers: List of simple triggers to be associated with the item.
####################################################################################################################
itc_cut_thrust_polearm = itc_parry_two_handed |itcf_thrust_twohanded |itcf_thrust_onehanded_lance|itc_cut_two_handed
itc_thrustpolearm = itc_parry_two_handed |itcf_thrust_twohanded |itcf_thrust_onehanded_lance
# Some constants for ease of use.
imodbits_none = 0
imodbits_none = 0
imodbits_horse_basic = imodbit_swaybacked|imodbit_lame|imodbit_spirited|imodbit_heavy|imodbit_stubborn
imodbits_cloth  = imodbit_tattered | imodbit_ragged | imodbit_sturdy | imodbit_thick | imodbit_hardened
imodbits_armor  = imodbit_rusty | imodbit_battered | imodbit_crude | imodbit_thick | imodbit_reinforced
imodbits_plate  = imodbit_cracked | imodbit_rusty | imodbit_battered | imodbit_crude | imodbit_thick | imodbit_reinforced
imodbits_polearm = imodbit_cracked | imodbit_bent
imodbits_shield  = imodbit_cracked | imodbit_battered |imodbit_thick | imodbit_reinforced
imodbits_sword   = imodbit_rusty | imodbit_chipped | imodbit_balanced
imodbits_scimitar   = imodbits_sword | imodbit_watered_steel
imodbits_axe   = imodbit_rusty | imodbit_chipped | imodbit_balanced |imodbit_heavy
imodbits_mace   = imodbit_rusty | imodbit_chipped | imodbit_balanced |imodbit_heavy
imodbits_pick   = imodbit_rusty | imodbit_chipped | imodbit_balanced | imodbit_heavy
imodbits_bow = imodbit_cracked | imodbit_bent
imodbits_crossbow = imodbit_cracked | imodbit_bent
imodbits_missile   = imodbit_bent | imodbit_large_bag

imodbits_horse_good=imodbit_spirited|imodbit_heavy
imodbits_good   = imodbit_sturdy | imodbit_thick | imodbit_hardened | imodbit_reinforced
imodbits_bad    = imodbit_rusty | imodbit_chipped | imodbit_tattered | imodbit_ragged | imodbit_cracked | imodbit_bent
# Replace winged mace/spiked mace with: Flanged mace / Knobbed mace?
# Fauchard (majowski glaive) 
items_defined=1
items = [
# item_name, mesh_name, item_properties, item_capabilities, slot_no, cost, bonus_flags, weapon_flags, scale, view_dir, pos_offset
 ["no_item","INVALID ITEM", [("practice_sword",0)], itp_type_one_handed_wpn|itp_melee|itp_primary|itp_secondary, itc_longsword, 3,weight(1.5)|spd_rtng(103)|weapon_length(90)|swing_damage(16,blunt)|thrust_damage(10,blunt),imodbits_none],
 ["horse_meat","Horse Meat", [("raw_meat",0)], itp_type_goods|itp_consumable|itp_food, 0, 12,weight(40)|food_quality(30)|max_ammo(40),imodbits_none],
# Items before this point are hardwired and their order should not be changed!
 ["practice_sword","Practice Sword", [("practice_sword",0)], itp_type_one_handed_wpn|itp_melee|itp_primary|itp_secondary, itc_longsword, 3,weight(1.5)|spd_rtng(103)|weapon_length(90)|swing_damage(16,blunt)|thrust_damage(10,blunt),imodbits_none],
 ["heavy_practice_sword","Heavy Practice Sword", [("heavy_practicesword",0)], itp_type_two_handed_wpn|itp_melee|itp_two_handed|itp_primary, itc_greatsword,
    21, weight(6.25)|spd_rtng(94)|weapon_length(128)|swing_damage(26,blunt)|thrust_damage(18,blunt),imodbits_none],
 ["practice_staff","Practice Staff", [("wooden_staff",0)],itp_type_two_handed_wpn|itp_spear|itp_melee|itp_primary|itp_penalty_with_shield,itc_staff|itcf_carry_sword_back,9, weight(2.5)|spd_rtng(103) | weapon_length(118)|swing_damage(16,blunt) | thrust_damage(16,blunt),imodbits_none],
 ["practice_lance","Practice Lance", [("joust_of_peace",0)], itp_type_two_handed_wpn|itp_spear|itp_melee|itp_primary|itp_penalty_with_shield, itc_greatlance, 18,weight(4.25)|spd_rtng(58)|weapon_length(227)|swing_damage(0,blunt)|thrust_damage(15,blunt),imodbits_none],
 ["practice_shield","Practice Shield", [("shield_round_a",0)], itp_type_shield, 0, 20,weight(3.5)|body_armor(1)|hit_points(200)|spd_rtng(100)|weapon_length(30),imodbits_none],
 ["practice_bow","Practice Bow", [("hunting_bow",0)], itp_type_bow|itp_two_handed|itp_primary|itp_attach_left_hand, itcf_shoot_bow, 4,weight(1.5)|spd_rtng(90)|shoot_speed(40)|thrust_damage(19,blunt),imodbits_none],
# ["cheap_shirt","Cheap Shirt", [("shirt",0)], itp_type_body_armor|itp_covers_legs, 0, 4,weight(1.25)|body_armor(3),imodbits_none],
 ["practice_horse","Practice Horse", [("horse_b",0)], itp_type_horse, 0, 37,body_armor(10)|horse_speed(40)|horse_maneuver(37)|horse_charge(14),imodbits_none],
 ["practice_arrows","Practice Arrows", [("arrow",0),("flying_missile",ixmesh_flying_ammo)], itp_type_arrows, 0, 31,weight(1.5)|weapon_length(95)|max_ammo(80),imodbits_none],
 ["red_tourney_armor","Red Tourney Armor", [("tourn_armor_a",0)], itp_type_body_armor|itp_covers_legs, 0, 152,weight(15.0)|body_armor(20)|leg_armor(6),imodbits_none],
 ["blue_tourney_armor","Blue Tourney Armor", [("mail_shirt",0)], itp_type_body_armor|itp_covers_legs, 0, 152,weight(15.0)|body_armor(20)|leg_armor(6),imodbits_none],
 ["green_tourney_armor","Green Tourney Armor", [("leather_vest",0)], itp_type_body_armor|itp_covers_legs, 0, 152,weight(15.0)|body_armor(20)|leg_armor(6),imodbits_none],
 ["gold_tourney_armor","Gold Tourney Armor", [("padded_armor",0)], itp_type_body_armor|itp_covers_legs, 0, 152,weight(15.0)|body_armor(20)|leg_armor(6),imodbits_none],
 ["red_tourney_helmet","Red Tourney Helmet",[("flattop_helmet",0)],itp_type_head_armor,0,126, weight(2)|head_armor(16),imodbits_none],
 ["blue_tourney_helmet","Blue Tourney Helmet",[("segmented_helm",0)],itp_type_head_armor,0,126, weight(2)|head_armor(16),imodbits_none],
 ["green_tourney_helmet","Green Tourney Helmet",[("hood_c",0)],itp_type_head_armor,0,126, weight(2)|head_armor(16),imodbits_none],
 ["gold_tourney_helmet","Gold Tourney Helmet",[("hood_a",0)],itp_type_head_armor,0,126, weight(2)|head_armor(16),imodbits_none],
 

# ["dry_bread", "wheat_sack", itp_type_goods|itp_consumable, 0, slt_none,view_goods,95,weight(2),max_ammo(50),imodbits_none],
#foods (first one is smoked_fish)
 ["smoked_fish","Smoked Fish", [("smoked_fish",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 25,weight(30)|abundance(110)|food_quality(50)|max_ammo(50),imodbits_none],
 ["dried_meat","Dried Meat", [("smoked_meat",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 42,weight(40)|abundance(100)|food_quality(70)|max_ammo(50),imodbits_none],
 ["apples","Apples", [("apple_basket",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 14,weight(35)|abundance(110)|food_quality(40)|max_ammo(50),imodbits_none],
 ["honey","Honey", [("honey_pot",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 56,weight(35)|abundance(110)|food_quality(40)|max_ammo(10),imodbits_none],
 ["cabbages","Cabbages", [("cabbage",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 10,weight(35)|abundance(110)|food_quality(40)|max_ammo(50),imodbits_none],
 ["butter","Butter", [("butter_pot",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 150,weight(35)|abundance(110)|food_quality(40)|max_ammo(30),imodbits_none],
#sango food start
["meat","Meat", [("meat",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 200,weight(40)|abundance(100)|food_quality(80)|max_ammo(200),imodbits_none],
["paddy","Paddy", [("paddy",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 100,weight(35)|abundance(110)|food_quality(54)|max_ammo(250),imodbits_none],
["fish","Fresh Fish", [("fish",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 225,weight(30)|abundance(110)|food_quality(100)|max_ammo(50),imodbits_none],
#sango food end

#morale boosters (first one is wine)
 ["wine","Wine", [("amphora_slim",0)], itp_merchandise|itp_type_goods|itp_consumable, 0, 51,weight(40)|abundance(60)|max_ammo(50),imodbits_none],
 ["ale","Ale", [("ale_barrel",0)], itp_merchandise|itp_type_goods|itp_consumable, 0, 34,weight(40)|abundance(70)|max_ammo(50),imodbits_none],
#sango morale boosters start
["baijiu","Rice Wine", [("baijiu",0)], itp_merchandise|itp_type_goods|itp_consumable, 0, 50,weight(40)|abundance(80)|max_ammo(50),imodbits_none],
#sango morale boosters end

#other trade goods (first one is spice)
 ["spice","Spice", [("spice_sack",0)], itp_merchandise|itp_type_goods, 0, 280,weight(40)|abundance(25),imodbits_none],
 ["salt","Salt", [("salt_sack",0)], itp_merchandise|itp_type_goods, 0, 16,weight(40)|abundance(120),imodbits_none],
 ["grain","Wheat", [("wheat_sack",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 15,weight(35)|abundance(110)|food_quality(40)|max_ammo(50),imodbits_none],
 ["flour","Flour", [("salt_sack",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 19,weight(40)|abundance(100)|food_quality(45)|max_ammo(50),imodbits_none],
 ["iron","Iron", [("iron",0)], itp_merchandise|itp_type_goods, 0,74,weight(40)|abundance(60),imodbits_none],
 ["oil","Oil", [("firewood",0)], itp_merchandise|itp_type_goods, 0, 104,weight(40)|abundance(60),imodbits_none],
 ["pottery","Pottery", [("jug",0)], itp_merchandise|itp_type_goods, 0, 36,weight(40)|abundance(90),imodbits_none],
 ["linen","Linen", [("linen",0)], itp_merchandise|itp_type_goods, 0, 51,weight(40)|abundance(90),imodbits_none],
 ["furs","Furs", [("fur_pack",0)], itp_merchandise|itp_type_goods, 0, 91,weight(40)|abundance(90),imodbits_none],
 ["wool","Wool", [("wool_sack",0)], itp_merchandise|itp_type_goods, 0,60,weight(40)|abundance(90),imodbits_none],
 ["tools","Tools", [("iron_hammer",0)], itp_merchandise|itp_type_goods, 0, 53,weight(40)|abundance(90),imodbits_none],
#sango trade goods start
["cotton","Cotton", [("cotton",0)], itp_merchandise|itp_type_goods, 0,12,weight(20)|abundance(120),imodbits_none],
["silk","Silk", [("silk",0)], itp_merchandise|itp_type_goods, 0,240,weight(24)|abundance(20),imodbits_none],
#sango trade goods end

#************************************************************************************************
# ITEMS before this point are hardcoded into item_codes.h and their order should not be changed!
#************************************************************************************************

# Quest Items

 ["siege_supply","Supply", [("ale_barrel",0)], itp_type_goods, 0, 96,weight(40)|abundance(70),imodbits_none],
 ["quest_wine","Wine", [("amphora_slim",0)], itp_type_goods, 0, 1,weight(40)|abundance(60)|max_ammo(50),imodbits_none],
 ["quest_ale","Ale", [("ale_barrel",0)], itp_type_goods, 0, 1,weight(40)|abundance(70)|max_ammo(50),imodbits_none],

 
# Tutorial Items

 ["tutorial_sword", "Sword", [("long_sword",0),("scab_longsw_a", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 0 , weight(1.5)|difficulty(0)|spd_rtng(100) | weapon_length(102)|swing_damage(18 , cut) | thrust_damage(15 ,  pierce),imodbits_sword ],
 ["tutorial_axe", "Axe", [("iron_ax",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield, itc_nodachi|itcf_carry_axe_back, 0 , weight(4)|difficulty(0)|spd_rtng(91) | weapon_length(108)|swing_damage(19 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
 ["tutorial_spear", "Spear", [("spear",0)], itp_type_two_handed_wpn| itp_spear|itp_primary|itp_penalty_with_shield, itc_spear, 0 , weight(4.5)|difficulty(0)|spd_rtng(80) | weapon_length(158)|swing_damage(0 , cut) | thrust_damage(19 ,  pierce),imodbits_polearm ],
 ["tutorial_club", "Club", [("club",0)], itp_type_one_handed_wpn| itp_primary, itc_scimitar, 0 , weight(2.5)|difficulty(0)|spd_rtng(95) | weapon_length(95)|swing_damage(11 , blunt) | thrust_damage(0 ,  pierce),imodbits_none ],
 ["tutorial_battle_axe", "Battle Axe", [("battle_ax",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield, itc_nodachi|itcf_carry_axe_back, 0 , weight(5)|difficulty(0)|spd_rtng(88) | weapon_length(108)|swing_damage(27 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
 ["tutorial_arrows","Arrows", [("arrow",0),("flying_missile",ixmesh_flying_ammo),("quiver", ixmesh_carry)], itp_type_arrows, itcf_carry_quiver_back, 0,weight(3)|abundance(160)|weapon_length(95)|thrust_damage(0,pierce)|max_ammo(20),imodbits_missile],
 ["tutorial_bolts","Bolts", [("bolt",0),("flying_missile",ixmesh_flying_ammo),("bolt_bag", ixmesh_carry),("bolt_bag_b", ixmesh_carry|imodbit_large_bag)], itp_type_bolts, itcf_carry_quiver_right_vertical, 0,weight(2.25)|abundance(90)|weapon_length(55)|thrust_damage(0,pierce)|max_ammo(18),imodbits_missile],
 ["tutorial_short_bow", "Short Bow", [("short_bow",0),("short_bow_carry",ixmesh_carry)], itp_type_bow |itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bow_back, 0 , weight(1)|difficulty(0)|spd_rtng(98) | shoot_speed(49) | thrust_damage(12 ,  pierce  ),imodbits_bow ],
 ["tutorial_crossbow", "Crossbow", [("crossbow",0)], itp_type_crossbow |itp_primary|itp_two_handed|itp_cant_use_on_horseback ,itcf_shoot_crossbow|itcf_carry_crossbow_back, 0 , weight(3)|difficulty(0)|spd_rtng(42) | shoot_speed(68) | thrust_damage(32,pierce)|max_ammo(1),imodbits_crossbow ],
 ["tutorial_throwing_daggers", "Throwing Daggers", [("throwing_dagger",0)], itp_type_thrown |itp_primary ,itcf_throw_knife, 0 , weight(3.5)|difficulty(0)|spd_rtng(102) | shoot_speed(25) | thrust_damage(16 ,  cut)|max_ammo(14)|weapon_length(0),imodbits_missile ],
 ["tutorial_saddle_horse", "Saddle Horse", [("saddle_horse",0)], itp_type_horse, 0, 0,abundance(90)|body_armor(3)|difficulty(0)|horse_speed(40)|horse_maneuver(38)|horse_charge(8),imodbits_horse_basic],
 ["tutorial_shield", "Kite Shield", [("shield_kite_a",0)], itp_type_shield , itcf_carry_kite_shield,  118 , weight(2.5)|hit_points(480)|body_armor(1)|spd_rtng(82)|weapon_length(90),imodbits_shield ],
 ["tutorial_staff_no_attack","Staff", [("wooden_staff",0)],itp_type_two_handed_wpn|itp_spear|itp_melee|itp_primary|itp_penalty_with_shield,itc_parry_polearm|itcf_carry_sword_back,9, weight(3.5)|spd_rtng(120) | weapon_length(115)|swing_damage(0,blunt) | thrust_damage(0,blunt),imodbits_none],
 ["tutorial_staff","Staff", [("wooden_staff",0)],itp_type_two_handed_wpn|itp_spear|itp_melee|itp_primary|itp_penalty_with_shield,itc_staff|itcf_carry_sword_back,9, weight(3.5)|spd_rtng(120) | weapon_length(115)|swing_damage(16,blunt) | thrust_damage(16,blunt),imodbits_none],

# Horses: sumpter horse/ pack horse, saddle horse, steppe horse, warm blood, geldling, stallion,   war mount, charger, 
# Carthorse, hunter, heavy hunter, hackney, palfrey, courser, destrier.
 ["sumpter_horse","Sumpter Horse", [("sumpter_horse",0)], itp_merchandise|itp_type_horse, 0, 64,abundance(90)|hit_points(110)|body_armor(17)|difficulty(1)|horse_speed(34)|horse_maneuver(33)|horse_charge(9),imodbits_horse_basic],
 ["saddle_horse","Saddle Horse", [("saddle_horse",0),("horse_b",imodbits_horse_good)], itp_merchandise|itp_type_horse, 0, 112,abundance(90)|body_armor(14)|difficulty(1)|horse_speed(39)|horse_maneuver(36)|horse_charge(8),imodbits_horse_basic],
 ["steppe_horse","Steppe Horse", [("steppe_horse",0)], itp_merchandise|itp_type_horse, 0, 92,abundance(80)|body_armor(15)|difficulty(2)|horse_speed(37)|horse_maneuver(41)|horse_charge(7),imodbits_horse_basic],
 ["courser","Courser", [("horse1",0)], itp_merchandise|itp_type_horse, 0, 323,abundance(70)|body_armor(16)|difficulty(2)|horse_speed(43)|horse_maneuver(37)|horse_charge(11),imodbits_horse_basic],
 ["hunter","Hunter", [("horse2",0)], itp_merchandise|itp_type_horse, 0, 434,abundance(60)|hit_points(130)|body_armor(29)|difficulty(3)|horse_speed(40)|horse_maneuver(36)|horse_charge(18),imodbits_horse_basic],

#sango horse begin
#Horses
["dihorse","Di Lu", [("dihorse",0)], itp_type_horse|itp_unique, 0, 10000,hit_points(140)|body_armor(31)|difficulty(6)|horse_speed(46)|horse_maneuver(40)|horse_charge(20),imodbits_horse_basic],
["zhuahorse","Flying Thunder", [("zhuahorse",0)], itp_type_horse|itp_unique, 0, 10000,hit_points(100)|body_armor(35)|difficulty(6)|horse_speed(47)|horse_maneuver(39)|horse_charge(20),imodbits_horse_basic],
["chihorse","Chi Tu", [("chihorse",0)], itp_type_horse|itp_unique, 0, 20000,hit_points(150)|body_armor(40)|difficulty(8)|horse_speed(49)|horse_maneuver(40)|horse_charge(30),imodbits_horse_basic],
["xuehorse","Ice Dragon", [("xuehorse",0)], itp_type_horse, 0, 10000,hit_points(120)|body_armor(50)|difficulty(6)|horse_speed(42)|horse_maneuver(36)|horse_charge(24),imodbits_horse_basic],
["dianhorse","Dian Horse", [("horse_a",0)], itp_merchandise|itp_type_horse, 0, 460,hit_points(100)|abundance(100)|body_armor(18)|difficulty(2)|horse_speed(41)|horse_maneuver(38)|horse_charge(12),imodbits_horse_basic],
["dianhorsea","Dian Horse", [("dianhorsea",0)], itp_merchandise|itp_type_horse, 0, 320,hit_points(100)|abundance(100)|body_armor(18)|difficulty(2)|horse_speed(40)|horse_maneuver(39)|horse_charge(12),imodbits_horse_basic],
["zhanhorse","War Horse", [("zhanhorse",0)], itp_merchandise|itp_type_horse, 0, 1500,abundance(50)|hit_points(140)|body_armor(55)|difficulty(5)|horse_speed(36)|horse_maneuver(33)|horse_charge(25),imodbits_horse_basic],
["dragonhorse","Dragon Horse", [("dragonhorse",0)], itp_merchandise|itp_type_horse, 0, 1650,abundance(20)|hit_points(120)|body_armor(47)|difficulty(5)|horse_speed(41)|horse_maneuver(37)|horse_charge(22),imodbits_horse_basic],
["dahorse","Da Wan", [("dahorse",0)], itp_merchandise|itp_type_horse, 0, 10000,abundance(5)|hit_points(150)|body_armor(24)|difficulty(7)|horse_speed(48)|horse_maneuver(38)|horse_charge(23),imodbits_horse_basic],
["wushunhorse","Wu Sun Horse", [("wushunhorse",0)], itp_merchandise|itp_type_horse, 0, 1000,abundance(80)|hit_points(125)|body_armor(50)|difficulty(4)|horse_speed(37)|horse_maneuver(35)|horse_charge(21),imodbits_horse_basic],
["blackhorse","Black Armor Horse", [("blackhorse",0)], itp_merchandise|itp_type_horse, 0, 2500,abundance(20)|hit_points(130)|body_armor(50)|difficulty(6)|horse_speed(40)|horse_maneuver(35)|horse_charge(20),imodbits_horse_basic],
["xlhorse","West Battle Horse", [("xlhorse",0)], itp_type_horse, 0, 2600,abundance(20)|hit_points(140)|body_armor(48)|difficulty(6)|horse_speed(40)|horse_maneuver(35)|horse_charge(35),imodbits_horse_basic],
["hzhorse","Brown Horse", [("hzhorse",0)], itp_merchandise|itp_type_horse, 0, 800,abundance(80)|hit_points(110)|body_armor(30)|difficulty(4)|horse_speed(41)|horse_maneuver(35)|horse_charge(18),imodbits_horse_basic],
["zhhorse","Red Horse", [("zhhorse",0)], itp_merchandise|itp_type_horse, 0, 800,abundance(80)|hit_points(110)|body_armor(28)|difficulty(4)|horse_speed(40)|horse_maneuver(36)|horse_charge(20),imodbits_horse_basic],
#sango horse end
 
#whalebone crossbow, yew bow, war bow, arming sword 
 ["arrows","Arrows", [("arrow",0),("flying_missile",ixmesh_flying_ammo),("quiver", ixmesh_carry)], itp_type_arrows|itp_merchandise, itcf_carry_quiver_back, 72,weight(3)|abundance(160)|weapon_length(95)|thrust_damage(1,pierce)|max_ammo(24),imodbits_missile],
 ["khergit_arrows","Khergit Arrows", [("arrow_b",0),("flying_missile",ixmesh_flying_ammo),("quiver_b", ixmesh_carry)], itp_type_arrows|itp_merchandise, itcf_carry_quiver_back_right, 410,weight(3.5)|abundance(30)|weapon_length(95)|thrust_damage(3,pierce)|max_ammo(25),imodbits_missile],
 ["barbed_arrows","Barbed Arrows", [("barbed_arrow",0),("flying_missile",ixmesh_flying_ammo),("quiver_d", ixmesh_carry)], itp_type_arrows|itp_merchandise, itcf_carry_quiver_back_right, 124,weight(3)|abundance(70)|weapon_length(95)|thrust_damage(2,pierce)|max_ammo(24),imodbits_missile],
 ["bodkin_arrows","Bodkin Arrows", [("piercing_arrow",0),("flying_missile",ixmesh_flying_ammo),("quiver_c", ixmesh_carry)], itp_type_arrows|itp_merchandise, itcf_carry_quiver_back_right, 350,weight(3)|abundance(50)|weapon_length(91)|thrust_damage(3,pierce)|max_ammo(24),imodbits_missile],
 ["bolts","Bolts", [("bolt",0),("flying_missile",ixmesh_flying_ammo),("bolt_bag", ixmesh_carry),("bolt_bag_b", ixmesh_carry|imodbit_large_bag)], itp_type_bolts|itp_merchandise, itcf_carry_quiver_right_vertical, 64,weight(2.25)|abundance(90)|weapon_length(55)|thrust_damage(1,pierce)|max_ammo(20),imodbits_missile],
 ["s_bolts","Small Bag Bolts", [("bolt",0),("flying_missile",ixmesh_flying_ammo),("bolt_bag", ixmesh_carry),("bolt_bag_b", ixmesh_carry|imodbit_large_bag)], itp_type_bolts, itcf_carry_quiver_right_vertical, 64,weight(2.25)|abundance(90)|weapon_length(55)|thrust_damage(1,pierce)|max_ammo(10),imodbits_missile],
 ["steel_bolts","Steel Bolts", [("bolt",0),("flying_missile",ixmesh_flying_ammo),("bolt_bag_c", ixmesh_carry)], itp_type_bolts|itp_merchandise, itcf_carry_quiver_right_vertical, 210,weight(2.5)|abundance(20)|weapon_length(55)|thrust_damage(2,pierce)|max_ammo(20),imodbits_missile],
#sango ranged2 begin
["iron_bolts","Iron Bolts", [("bolt",0),("flying_missile",ixmesh_flying_ammo),("bolt_bag_c", ixmesh_carry)], itp_type_bolts|itp_merchandise, itcf_carry_quiver_right_vertical, 210,weight(2.5)|abundance(20)|weapon_length(55)|thrust_damage(2,pierce)|max_ammo(20),imodbits_missile],
["s_arrows","Small Bag Arrows", [("arrow_b",0),("flying_missile",ixmesh_flying_ammo),("quiver_b", ixmesh_carry)], itp_type_arrows, itcf_carry_quiver_back_right, 410,weight(3.5)|abundance(30)|weapon_length(95)|thrust_damage(2,pierce)|max_ammo(10),imodbits_missile],
["cavalry_arrows","Cavalry Arrows", [("arrow_b",0),("flying_missile",ixmesh_flying_ammo),("quiver_b", ixmesh_carry)], itp_type_arrows|itp_merchandise, itcf_carry_quiver_back_right, 410,weight(3.5)|abundance(30)|weapon_length(95)|thrust_damage(3,pierce)|max_ammo(25),imodbits_missile],
#sango ranged2 end
 

# ARMOR
#handwear
["leather_gloves","Leather Gloves", [("lthr_glove_L",0)], itp_merchandise|itp_type_hand_armor|itp_civilian,0, 130, weight(0.25)|abundance(120)|body_armor(3)|difficulty(0),imodbits_cloth],

#footwear
["wrapping_boots", "Wrapping Boots", [("shoe_furL",0)], itp_merchandise| itp_type_foot_armor |itp_civilian  ,0, 3 , weight(1)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(6)|difficulty(0) ,imodbits_cloth ],
["nomad_boots", "Nomad Boots", [("boot_nomad_bL",0)], itp_merchandise| itp_type_foot_armor  |itp_civilian | itp_attach_armature,0, 10 , weight(1.25)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["hunter_boots", "Hunter Boots", [("boot_hunterL",0)], itp_merchandise| itp_type_foot_armor |itp_civilian  ,0, 17 , weight(1.25)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(12)|difficulty(0) ,imodbits_cloth ],
["leather_boots", "Leather Boots", [("boot_khergitL",0)], itp_merchandise| itp_type_foot_armor  |itp_civilian ,0, 41 , weight(1.25)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth ],
["splinted_greaves", "Splinted Greaves", [("spl_greavesL",0)], itp_merchandise| itp_type_foot_armor   ,0, 273 , weight(3.5)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(28)|difficulty(0) ,imodbits_armor ],


#headwear
["straw_hat", "Straw Hat", [("straw_hat",0)],itp_merchandise|itp_type_head_armor|itp_civilian,0,9, weight(1)|abundance(100)|head_armor(2)|body_armor(0)|leg_armor(0)|difficulty(0),imodbits_cloth],
["woolen_hood", "Woolen Hood", [("woolen_hood",0)], itp_merchandise| itp_type_head_armor |itp_civilian  ,0, 4 , weight(1)|abundance(100)|head_armor(8)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["fur_hat", "Fur Hat", [("hat_fur_a",0)], itp_merchandise| itp_type_head_armor |itp_civilian  ,0, 4 , weight(0.5)|abundance(100)|head_armor(8)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["nomad_cap", "Nomad Cap", [("helmet_fur_a",0),("helmet_fur_a",imodbits_good)], itp_merchandise| itp_type_head_armor |itp_civilian  ,0, 6 , weight(0.75)|abundance(100)|head_armor(10)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["steppe_cap", "Steppe Cap", [("helmet_fur_b",0)], itp_merchandise| itp_type_head_armor  |itp_civilian ,0, 14 , weight(1)|abundance(100)|head_armor(12)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["leather_warrior_cap", "Leather Warrior Cap", [("nomad_cap_a",0)], itp_merchandise| itp_type_head_armor  |itp_civilian ,0, 14 , weight(1)|abundance(100)|head_armor(12)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["woolen_cap", "Woolen Cap", [("woolen_cap",0)], itp_merchandise| itp_type_head_armor  |itp_civilian ,0, 2 , weight(1)|abundance(100)|head_armor(6)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["leather_cap", "Leather Cap", [("leather_cap",0)], itp_merchandise| itp_type_head_armor  |itp_civilian ,0, 6 , weight(1)|abundance(100)|head_armor(10)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],

#sango bodywears begin
#BodyWears
#Light Armors
["ccshen", "King's Courtly Outfit of Wei", [("ccshen",0)], itp_type_body_armor|itp_civilian|itp_covers_legs|itp_unique ,0, 38000 , weight(2)|head_armor(0)|body_armor(20)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["sqshen", "King's Courtly Outfit of WU", [("sqshen",0)], itp_type_body_armor  |itp_covers_legs|itp_unique ,0, 38000 , weight(2)|head_armor(0)|body_armor(20)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["lbeishen", "King's Courtly Outfit of Shu", [("lbeishen",0)], itp_type_body_armor  |itp_covers_legs|itp_unique ,0, 38000 , weight(2)|head_armor(0)|body_armor(20)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["zglshen", "ZhugeLiang's Cloak", [("zglshen",0)],  itp_type_body_armor  |itp_covers_legs|itp_unique ,0, 38000 , weight(14)|head_armor(0)|body_armor(20)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["diaochan", "DiaoChan's Dress", [("diaochan",0)], itp_type_body_armor  |itp_covers_legs|itp_unique ,0, 38000, weight(1)|abundance(100)|head_armor(0)|body_armor(20)|leg_armor(8)|difficulty(0) ,imodbits_cloth ],
["smyshen", "SimaYi's Courtly Outfit", [("smyshen",0)],  itp_type_body_armor  |itp_covers_legs|itp_unique ,0, 38000 , weight(14)|head_armor(0)|body_armor(20)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["nomad_armor", "Nomad Armor", [("armor_nomad",0)], itp_merchandise| itp_type_body_armor   ,0, 25 , weight(2)|abundance(100)|head_armor(0)|body_armor(24)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["pihuan", "Leather Vest Armor", [("pihuan",0)], itp_merchandise| itp_type_body_armor|itp_covers_legs,0, 25 , weight(3)|abundance(100)|head_armor(0)|body_armor(30)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["khergit_armor", "Khergit Armor", [("armor_nomad_b",0)], itp_merchandise| itp_type_body_armor ,0, 38 , weight(2)|abundance(100)|head_armor(0)|body_armor(14)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["rawhide_coat", "Rawhide Coat", [("tunic_fur",0)], itp_merchandise| itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 12 , weight(5)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["shirt", "Shirt", [("shirt",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 3 , weight(1)|abundance(100)|head_armor(0)|body_armor(5)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["coarse_tunic", "Coarse Tunic", [("coarse_tunic",0)], itp_merchandise| itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 47 , weight(2)|abundance(100)|head_armor(0)|body_armor(11)|leg_armor(6)|difficulty(0) ,imodbits_cloth ],
["nomad_vest", "Nomad Vest", [("nomad_vest_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 143 , weight(7)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["ragged_outfit", "Ragged Outfit", [("ragged_outfit_a",0)], itp_merchandise| itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 150 , weight(7)|abundance(100)|head_armor(0)|body_armor(23)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["padded_leather", "Padded Leather", [("padded_leather",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 294 , weight(12)|abundance(100)|head_armor(0)|body_armor(28)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["tribal_warrior_outfit", "Tribal Warrior Outfit", [("tribal_warrior_outfit_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 340 , weight(14)|abundance(100)|head_armor(0)|body_armor(30)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["nomad_robe", "Nomad Robe", [("nomad_robe_a",0)], itp_merchandise| itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 410 , weight(15)|abundance(100)|head_armor(0)|body_armor(32)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["lamellar_vest", "Lamellar Vest", [("nmd_warrior_a",0)], itp_merchandise| itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 700 , weight(18)|abundance(100)|head_armor(0)|body_armor(46)|leg_armor(7)|difficulty(7) ,imodbits_cloth ],
["leather_apron", "Leather Apron", [("leather_apron",0)], itp_merchandise| itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 59 , weight(3)|abundance(100)|head_armor(0)|body_armor(14)|leg_armor(7)|difficulty(0) ,imodbits_cloth ],
["pilgrim_disguise", "Pilgrim Disguise", [("pilgrim_outfit",0)], 0| itp_type_body_armor |itp_covers_legs |itp_civilian ,0, 25 , weight(2)|abundance(100)|head_armor(0)|body_armor(19)|leg_armor(21)|difficulty(0) ,imodbits_cloth ],
["shuwenshen1", "Liegemen's Dress of Shu", [("shuwenshen1",0)], itp_type_body_armor  |itp_covers_legs ,0, 400 , weight(1)|head_armor(0)|body_armor(5)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["shuwenshen2", "Liegemen's Dress of Shu", [("shuwenshen2",0)], itp_type_body_armor  |itp_covers_legs ,0, 400 , weight(1)|head_armor(0)|body_armor(5)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["weiwenshen1", "Liegemen's Dress of Wei", [("weiwenshen1",0)], itp_type_body_armor  |itp_covers_legs ,0, 400 , weight(1)|head_armor(0)|body_armor(5)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["weiwenshen2", "Liegemen's Dress of Wei", [("weiwenshen2",0)], itp_type_body_armor  |itp_covers_legs ,0, 400 , weight(1)|head_armor(0)|body_armor(5)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["wuwenshen1", "Liegemen's Dress of Wu", [("wuwenshen1",0)], itp_type_body_armor  |itp_covers_legs ,0, 400 , weight(1)|head_armor(0)|body_armor(5)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["wuwenshen2", "Liegemen's Dress of Wu", [("wuwenshen2",0)], itp_type_body_armor  |itp_covers_legs ,0, 400 , weight(1)|head_armor(0)|body_armor(5)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["womancloth3", "Girls Dress", [("womanclothb",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 15, weight(1)|abundance(100)|head_armor(0)|body_armor(3)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["womancloth2", "Girls Dress", [("womanclotha",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 15, weight(1)|abundance(100)|head_armor(0)|body_armor(3)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["womancloth1", "Girls Dress", [("womancloth1",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 20, weight(1)|abundance(100)|head_armor(0)|body_armor(4)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["woolen_dress", "Woolen Dress", [("light_leather",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 20 , weight(1.75)|abundance(100)|head_armor(0)|body_armor(9)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["shirt", "Shirt", [("manclothb",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 15 , weight(1)|abundance(100)|head_armor(0)|body_armor(3)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["shirt1", "Shirt", [("mancloth",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 15 , weight(1)|abundance(100)|head_armor(0)|body_armor(4)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["shirt2", "Shirt", [("manclotha",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 15 , weight(1)|abundance(100)|head_armor(0)|body_armor(4)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["mianpao", "Cotton Coat", [("mianpao",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(8)|abundance(100)|head_armor(0)|body_armor(24)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["beastarmor", "Beast Armor", [("beastarmor",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 300 , weight(9.5)|abundance(100)|head_armor(0)|body_armor(28)|leg_armor(5)|difficulty(0) ,imodbits_armor ],
["huangarmor", "HuangJin Armor", [("huangarmor",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 200 , weight(7)|abundance(100)|head_armor(0)|body_armor(25)|leg_armor(12)|difficulty(0) ,imodbits_cloth ],
["leatherarmor", "Leather Armor", [("leatherarmor",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(10.5)|abundance(100)|head_armor(0)|body_armor(32)|leg_armor(8)|difficulty(0) ,imodbits_armor ],
["qinbushu", "Light Armor of  Shu Infantry", [("qinbushu",0)],  itp_merchandise|itp_type_body_armor  |itp_covers_legs ,0, 300 , weight(6.5)|abundance(100)|head_armor(0)|body_armor(28)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["qinbuwei", "Light Armor of  Wei Infantry", [("qinbuwei",0)],  itp_merchandise|itp_type_body_armor  |itp_covers_legs ,0, 300 , weight(6.5)|abundance(100)|head_armor(0)|body_armor(28)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["qinbuwu", "Light Armor of  Wu Infantry", [("qinbuwu",0)],  itp_merchandise|itp_type_body_armor  |itp_covers_legs ,0, 300 , weight(6.5)|abundance(100)|head_armor(0)|body_armor(28)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["han_wenguanfu1", "Liegemen's Dress of Han Dynasty", [("han_wenguanfu1",0)], itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(5)|head_armor(0)|body_armor(10)|leg_armor(4)|difficulty(0) ,imodbits_cloth ],
["china_soldier_q", "Heavy Leather Jin Armor", [("china_soldier_q",0)], itp_merchandise|itp_type_body_armor|itp_covers_legs,0, 350 , weight(9.4)|abundance(100)|head_armor(0)|body_armor(28)|leg_armor(4)|difficulty(0) ,imodbits_armor ],
["china_soldier_aj", "Leather Ling Armor", [("china_soldier_aj",0)], itp_merchandise|itp_type_body_armor|itp_covers_legs,0, 320 , weight(9.5)|abundance(100)|head_armor(0)|body_armor(29)|leg_armor(5)|difficulty(0) ,imodbits_armor ],
["china_soldier_j", "Leather Chen Armor", [("china_soldier_j",0)], itp_merchandise|itp_type_body_armor|itp_covers_legs,0, 325 , weight(8.2)|abundance(100)|head_armor(0)|body_armor(27)|leg_armor(5)|difficulty(0) ,imodbits_cloth ],
["tengarmor", "Cany Armor", [("tengarmor",0)],   itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(9.5)|abundance(0)|head_armor(0)|body_armor(45)|leg_armor(14)|difficulty(7) ,imodbits_armor ],

#Normal Armors
["weiwushen1", "Lieutenants' Armor of Wei", [("weiwushen1",0)],  itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(17)|head_armor(0)|body_armor(45)|leg_armor(15)|difficulty(12) ,imodbits_armor ],
["weiwushen2", "Lieutenants' Armor of Wei", [("weiwushen2",0)],  itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(14)|head_armor(0)|body_armor(40)|leg_armor(20)|difficulty(12) ,imodbits_armor ],
["wuwushen1", "Lieutenants' Armor of Wu", [("wuwushen1",0)],  itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(14)|head_armor(0)|body_armor(45)|leg_armor(15)|difficulty(12) ,imodbits_armor ],
["wuwushen2", "Lieutenants' Armor of Wu", [("wuwushen2",0)],  itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(14)|head_armor(0)|body_armor(40)|leg_armor(20)|difficulty(12) ,imodbits_armor ],
["liangdang", "Liang Dang Armor", [("liangdang",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 950 , weight(18)|abundance(100)|head_armor(0)|body_armor(42)|leg_armor(9)|difficulty(10) ,imodbits_armor ],
["liangdanga", "Liang Dang Armor", [("liangdanga",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 980 , weight(19)|abundance(100)|head_armor(0)|body_armor(40)|leg_armor(12)|difficulty(10) ,imodbits_armor ],
["zhongpijia", "Heavy Leather Armor", [("zhongpijia",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 900 , weight(14)|abundance(100)|head_armor(0)|body_armor(38)|leg_armor(12)|difficulty(9) ,imodbits_armor ],
["hunzhi", "Mix Iron Armor", [("hunzhi",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1700 , weight(17)|abundance(30)|head_armor(0)|body_armor(44)|leg_armor(14)|difficulty(12) ,imodbits_plate ],
["shanarmor", "Armor of Shan Ye", [("shanarmor",0)],   itp_type_body_armor  |itp_covers_legs ,0, 425 , weight(9.5)|head_armor(0)|body_armor(30)|leg_armor(10)|difficulty(8) ,imodbits_armor ],
["china_soldier_s", "Leather Jin Armor", [("china_soldier_s",0)], itp_merchandise|itp_type_body_armor,0, 400 , weight(9.5)|abundance(100)|head_armor(0)|body_armor(30)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["china_soldier_qs", "Leather Xiong Armor", [("china_soldier_qs",0)], itp_merchandise|itp_type_body_armor|itp_covers_legs,0, 420 , weight(10.5)|abundance(100)|head_armor(0)|body_armor(32)|leg_armor(6)|difficulty(0) ,imodbits_cloth ],
["china_soldier_ys", "Leather Zha Armor", [("china_soldier_qs",0)], itp_merchandise|itp_type_body_armor|itp_covers_legs,0, 480 , weight(12)|abundance(100)|head_armor(0)|body_armor(33)|leg_armor(4)|difficulty(7) ,imodbits_armor ],
["china_soldier_zq", "Heavy Leather Jin Armor", [("china_soldier_zq",0)], itp_merchandise|itp_type_body_armor|itp_covers_legs,0, 375 , weight(10)|abundance(100)|head_armor(0)|body_armor(30)|leg_armor(4)|difficulty(0) ,imodbits_armor ],
["china_soldier_yq", "Zha Armor", [("china_soldier_yq",0)], itp_merchandise|itp_type_body_armor|itp_covers_legs,0, 680 , weight(13.5)|abundance(100)|head_armor(0)|body_armor(36)|leg_armor(10)|difficulty(0) ,imodbits_armor ],
["china_soldier_yj", "Leather Ling Zha Armor", [("china_soldier_yj",0)], itp_merchandise|itp_type_body_armor|itp_covers_legs,0, 425 , weight(10)|abundance(100)|head_armor(0)|body_armor(31)|leg_armor(8)|difficulty(0) ,imodbits_armor ],
["shuwushen1", "Lieutenants' Armor of Shu", [("shuwushen1",0)],  itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(14)|head_armor(0)|body_armor(20)|leg_armor(8)|difficulty(12) ,imodbits_armor ],
["shuwushen2", "Lieutenants' Armor of Shu", [("shuwushen2",0)],  itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(14)|head_armor(0)|body_armor(20)|leg_armor(8)|difficulty(12) ,imodbits_armor ],
["zhiliangdang", "Zhi Liang Dang Armor", [("zhiliangdang",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 900 , weight(16.5)|abundance(100)|head_armor(0)|body_armor(37)|leg_armor(15)|difficulty(11) ,imodbits_plate ],
["xnhunzhi", "Raider Mix Iron Armor", [("xnhunzhi",0)],  itp_type_body_armor  |itp_covers_legs ,0, 1550 , weight(19)|head_armor(0)|body_armor(42)|leg_armor(18)|difficulty(12) ,imodbits_plate ],

#Heavy Armors
["yinjia", "Silver Armor", [("yinjia",0)],  itp_type_body_armor  |itp_covers_legs|itp_unique ,0, 1300 , weight(20)|abundance(50)|head_armor(0)|body_armor(54)|leg_armor(20)|difficulty(12) ,imodbits_plate ],
["ironarmor", "Iron Armor", [("ironarmor",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1250 , weight(21)|abundance(80)|head_armor(0)|body_armor(46)|leg_armor(16)|difficulty(12) ,imodbits_plate ],
["mingarmor", "Shining Armor", [("mingarmor",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1800 , weight(24)|abundance(60)|head_armor(0)|body_armor(49)|leg_armor(15)|difficulty(14) ,imodbits_plate ],
["mingarmora", "Shining Armor", [("mingarmora",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1800 , weight(24)|abundance(60)|head_armor(0)|body_armor(49)|leg_armor(15)|difficulty(14) ,imodbits_plate ],
["mingarmorb", "Shining Armor", [("mingarmorb",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1800 , weight(24)|abundance(60)|head_armor(0)|body_armor(49)|leg_armor(15)|difficulty(14) ,imodbits_plate ],
["shanarmori", "Iron Armor of Shan Ye", [("shanarmori",0)],  itp_type_body_armor  |itp_covers_legs ,0, 1050 , weight(16.5)|head_armor(0)|body_armor(40)|leg_armor(10)|difficulty(13) ,imodbits_plate ],
["tiezhajia", "Iron Zha Plates", [("tiezhajia",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1700 , weight(26)|abundance(60)|head_armor(0)|body_armor(44)|leg_armor(24)|difficulty(15) ,imodbits_plate ],
["tongarmor", "Tong Armor", [("tongarmor",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1650 , weight(22.5)|abundance(60)|head_armor(0)|body_armor(46)|leg_armor(12)|difficulty(12) ,imodbits_plate ],
["ironarmora", "Iron Armor", [("ironarmora",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1350 , weight(23)|abundance(60)|head_armor(0)|body_armor(46)|leg_armor(19)|difficulty(14) ,imodbits_plate ],
["jintie", "Fine Iron Armor", [("jintie",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 2200 , weight(28)|abundance(30)|head_armor(0)|body_armor(52)|leg_armor(18)|difficulty(15) ,imodbits_plate ],
["lianshena", "Match Iron Armor With Mantle", [("lianshena",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 2000 , weight(26)|abundance(30)|head_armor(0)|body_armor(50)|leg_armor(16)|difficulty(14) ,imodbits_plate ],
["lianshen", "Match Iron Armor", [("lianshen",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 2000 , weight(26)|abundance(30)|head_armor(0)|body_armor(50)|leg_armor(16)|difficulty(14) ,imodbits_plate ],
["dangxiong", "Vest Iron Armor", [("dangxiong",0)],  itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1950 , weight(23)|abundance(60)|head_armor(0)|body_armor(48)|leg_armor(18)|difficulty(14) ,imodbits_plate ],

#Special Armors
["zyshen", "ZhaoYun's Armor", [("zyshen",0)],  itp_type_body_armor  |itp_covers_legs|itp_unique ,0, 42000 , weight(22)|head_armor(0)|body_armor(55)|leg_armor(22)|difficulty(15) ,imodbits_plate ],
["gyshen", "GuanYu Armor", [("gyshen",0)],  itp_type_body_armor  |itp_covers_legs|itp_unique ,0, 40000 , weight(28)|head_armor(0)|body_armor(65)|leg_armor(19)|difficulty(16) ,imodbits_plate ],
["lbshen", "Armor of Warlord LvBu", [("lbshen",0)], itp_type_body_armor  |itp_covers_legs |itp_unique,0, 48000 , weight(22)|head_armor(0)|body_armor(55)|leg_armor(32)|difficulty(20) ,imodbits_plate ],
["lxshen", "LuXun's Armor", [("lxshen",0)],  itp_type_body_armor  |itp_covers_legs|itp_unique ,0, 40000 , weight(20)|head_armor(0)|body_armor(57)|leg_armor(20)|difficulty(0) ,imodbits_plate ],
["mcshen", "MarChao's Armor", [("mcshen",0)],  itp_type_body_armor  |itp_covers_legs|itp_unique ,0, 42000 , weight(20)|head_armor(0)|body_armor(57)|leg_armor(24)|difficulty(18) ,imodbits_plate ],
#sango bodywears end
#sango headwears begin
#HeadWares
["pilgrim_hood", "Pilgrim Hood", [("pilgrim_hood",0)], 0| itp_type_head_armor |itp_civilian  ,0, 35 , weight(1.25)|abundance(100)|head_armor(14)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["crown", "Crown", [("crown",0)], itp_type_head_armor |itp_unique  ,0, 100 , weight(2)|head_armor(5)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["lutoujin", "Green Hood", [("lutoujin",0)], itp_type_head_armor |itp_unique  ,0, 160 , weight(2)|abundance(100)|head_armor(12)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["jinbian", "Gold", [("jinbian",0)], itp_type_head_armor |itp_unique  ,0, 520 , weight(3.5)|head_armor(52)|body_armor(0)|leg_armor(0)|difficulty(12) ,imodbits_plate ],
["hutou", "Tiger Helmet", [("hutou",0)],  itp_type_head_armor |itp_unique  ,0, 500 , weight(3.5)|abundance(55)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["smytou", "SimaYi's Hat", [("smytou",0)], itp_type_head_armor |itp_unique  ,0, 300 , weight(1)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["zgltou", "ZhugeLiang's Hat", [("zgltou",0)], itp_type_head_armor |itp_unique  ,0, 300 , weight(1)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["gaoguan", "High Hat", [("gaoguan",0)],  itp_type_head_armor |itp_unique  ,0, 40 , weight(0.5)|abundance(100)|head_armor(8)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["baotou", "Hood", [("baotou",0)], itp_merchandise| itp_type_head_armor   ,0, 80 , weight(0.5)|abundance(100)|head_armor(7)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["butoujin", "Footman Hood", [("butoujin",0)], itp_merchandise| itp_type_head_armor   ,0, 150 , weight(0.5)|abundance(100)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["guanjin", "Guan Jin Hood", [("guanjin",0)], itp_merchandise| itp_type_head_armor   ,0, 40 , weight(0.5)|abundance(100)|head_armor(5)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["shamao", "Voile Hat", [("shamao",0)], itp_merchandise| itp_type_head_armor   ,0, 60 , weight(1)|abundance(100)|head_armor(4)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["toufa", "Hair Riband", [("toufa",0)], itp_merchandise| itp_type_head_armor   ,0, 20 , weight(0.1)|abundance(100)|head_armor(1)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["toujin", "Hair Riband", [("toujin",0)], itp_merchandise| itp_type_head_armor   ,0, 20 , weight(0.1)|abundance(100)|head_armor(1)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["xiaoguan", "Small Hat", [("xiaoguan",0)], itp_merchandise| itp_type_head_armor   ,0, 40 , weight(0.1)|abundance(100)|head_armor(2)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["liangguan", "Liang Hat", [("liangguan",0)], itp_merchandise| itp_type_head_armor   ,0, 80 , weight(1)|abundance(100)|head_armor(10)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["leatherhelmet", "Leather Helmet", [("leatherhelmet",0)], itp_type_head_armor   ,0, 280 , weight(1.5)|head_armor(27)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["yuling", "Feather Helmet", [("yuling",0)], itp_merchandise| itp_type_head_armor   ,0, 360 , weight(2)|abundance(100)|head_armor(36)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["bronzehelmet", "Bronze Helmet", [("bronzehelmet",0)], itp_merchandise| itp_type_head_armor   ,0, 380 , weight(3)|abundance(100)|head_armor(39)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["yanbianb", "Fine iron Helmet", [("yanbianb",0)], itp_merchandise| itp_type_head_armor   ,0, 440 , weight(3.5)|abundance(100)|head_armor(44)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["pitiezhou", "Leather and Iron Helmet", [("pitiezhou",0)], itp_merchandise| itp_type_head_armor   ,0, 340 , weight(2)|abundance(100)|head_armor(32)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["ptiekui", "Falt Top Iron Helmet", [("ptiekui",0)], itp_merchandise| itp_type_head_armor   ,0, 420 , weight(3)|abundance(100)|head_armor(45)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["tenghelmet", "Cany Helmet", [("tenghelmet",0)],  itp_type_head_armor   ,0, 380 , weight(1)|abundance(0)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["tiekui", "Iron Helmet", [("tiekui",0)], itp_merchandise| itp_type_head_armor   ,0, 400 , weight(3)|abundance(100)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["tiekuia", "Iron Helmet", [("tiekuia",0)], itp_merchandise| itp_type_head_armor   ,0, 400 , weight(2.8)|abundance(100)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["tiezhou", "Iron Armet", [("tiezhou",0)], itp_merchandise| itp_type_head_armor   ,0, 460 , weight(3.5)|abundance(80)|head_armor(46)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["yanbian", "Yan Bian Helmet", [("yanbian",0)], itp_merchandise| itp_type_head_armor   ,0, 420 , weight(3)|abundance(100)|head_armor(42)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["yanbiana", "Fine Iron Helmet", [("yanbiana",0)], itp_merchandise| itp_type_head_armor   ,0, 460 , weight(3.5)|abundance(100)|head_armor(42)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["yanyitoukui", "Lacquerd Iron Helmet", [("yanyitoukui",0)], itp_merchandise| itp_type_head_armor   ,0, 660 , weight(4.8)|abundance(100)|head_armor(48)|body_armor(0)|leg_armor(0)|difficulty(10) ,imodbits_plate ],
["yanbianc", "Yan Bian Helmet", [("yanbianc",0)], itp_merchandise| itp_type_head_armor   ,0, 480 , weight(3.8)|abundance(100)|head_armor(42)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["huyan", "Face Helmet", [("huyan",0)], itp_merchandise| itp_type_head_armor   ,0, 650 , weight(4.2)|abundance(50)|head_armor(47)|body_armor(0)|leg_armor(0)|difficulty(9) ,imodbits_plate ],
["daye", "Daye Helmet", [("daye",0)], itp_merchandise| itp_type_head_armor   ,0, 750 , weight(4.5)|abundance(30)|head_armor(49)|body_armor(0)|leg_armor(0)|difficulty(10) ,imodbits_plate ],
["junmao", "Battle Helmet", [("junmao",0)], itp_merchandise| itp_type_head_armor   ,0, 600 , weight(4.2)|abundance(30)|head_armor(46)|body_armor(0)|leg_armor(0)|difficulty(8) ,imodbits_plate ],
["doumao", "Battle Helmet Yin", [("doumao",0)], itp_merchandise| itp_type_head_armor   ,0, 600 , weight(4.2)|abundance(30)|head_armor(46)|body_armor(0)|leg_armor(0)|difficulty(8) ,imodbits_plate ],
["xnhelm", "Raider Iron Helmet", [("xnhelm",0)], itp_type_head_armor   ,0, 300 , weight(3)|abundance(30)|head_armor(38)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
["zijinguan", "ZiJinGuan", [("zijinguan",0)], itp_type_head_armor|itp_unique,0, 300 , weight(1)|head_armor(10)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate ],
#sango headwears end
#sango footwears begin
#FootWears
["yinxie", "Silver Greaves", [("yinxieL",0)],  itp_type_foot_armor |itp_unique  ,0, 320 , weight(8.5)|abundance(10)|head_armor(0)|body_armor(0)|leg_armor(38)|difficulty(0) ,imodbits_armor ],
["jinxie", "Golden Greaves", [("jinxieL",0)],  itp_type_foot_armor |itp_unique  ,0, 320 , weight(8.8)|abundance(10)|head_armor(0)|body_armor(0)|leg_armor(40)|difficulty(0) ,imodbits_armor ],
["caoshoes", "Straw Sandals", [("caoshoesL",0)], itp_merchandise| itp_type_foot_armor   ,0, 3 , weight(1)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(3)|difficulty(0) ,imodbits_cloth ],
["bushoes", "Short Boots", [("bushoesL",0)], itp_merchandise| itp_type_foot_armor   ,0, 45 , weight(2)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(8)|difficulty(0) ,imodbits_cloth ],
["hide_boots", "Hide Boots", [("boot_nomad_aL",0)], itp_merchandise| itp_type_foot_armor |itp_civilian  | itp_attach_armature,0, 11 , weight(1)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["wenxie", "Liegemen's Boots", [("wenxieL",0)], itp_type_foot_armor   ,0, 4 , weight(0.5)|head_armor(0)|body_armor(0)|leg_armor(5)|difficulty(0) ,imodbits_cloth ],
["ironshoes", "Iron Greaves", [("ironshoesL",0)], itp_merchandise| itp_type_foot_armor   ,0, 450 , weight(8)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(34)|difficulty(0) ,imodbits_armor ],
["tengshoes", "Cany Greaves", [("tengshoesL",0)], itp_type_foot_armor   ,0, 450 , weight(3.8)|head_armor(0)|body_armor(0)|leg_armor(30)|difficulty(0) ,imodbits_armor ],
["zhanxie", "Fighting Greaves", [("zhanxieL",0)], itp_merchandise| itp_type_foot_armor   ,0, 360 , weight(6.5)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(32)|difficulty(0) ,imodbits_armor ],
["wuxie", "Lieutenants' Greaves", [("wuxieL",0)], itp_type_foot_armor   ,0, 280 , weight(5.5)|head_armor(0)|body_armor(0)|leg_armor(30)|difficulty(0) ,imodbits_armor ],
#sango footwears end



#WEAPONS
["wooden_stick",         "Wooden Stick", [("wooden_stick",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary, itc_scimitar, 4 , weight(2.5)|difficulty(0)|spd_rtng(99) | weapon_length(90)|swing_damage(11 , blunt) | thrust_damage(0 ,  pierce),imodbits_none ],
["cudgel",         "Cudgel", [("club",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary, itc_scimitar, 4 , weight(2.5)|difficulty(0)|spd_rtng(99) | weapon_length(90)|swing_damage(11 , blunt) | thrust_damage(0 ,  pierce),imodbits_none ],
["hammer",         "Hammer", [("iron_hammer",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary, itc_scimitar, 7 , weight(2)|difficulty(0)|spd_rtng(100) | weapon_length(55)|swing_damage(12 , blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],
["club",         "Club", [("club",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary, itc_scimitar, 11 , weight(2.5)|difficulty(0)|spd_rtng(95) | weapon_length(95)|swing_damage(13 , blunt) | thrust_damage(0 ,  pierce),imodbits_none ],
["winged_mace",         "Winged Mace", [("winged_mace",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary, itc_scimitar|itcf_carry_axe_left_hip, 122 , weight(3.5)|difficulty(0)|spd_rtng(99) | weapon_length(80)|swing_damage(19 , blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],
["maul",         "Maul", [("sledgehammer",0)], itp_type_two_handed_wpn|itp_merchandise| itp_primary|itp_two_handed, itc_nodachi, 67 , weight(10)|difficulty(11)|spd_rtng(65) | weapon_length(105)|swing_damage(24 , blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],
["sledgehammer", "Sledgehammer", [("sledgehammer",0)], itp_type_two_handed_wpn|itp_merchandise|itp_primary|itp_two_handed, itc_nodachi, 101 , weight(13)|difficulty(12)|spd_rtng(63) | weapon_length(110)|swing_damage(29 , blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],
["spiked_club",         "Spiked Club", [("spiked_club",0)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_scimitar|itcf_carry_axe_left_hip, 83 , weight(3)|difficulty(0)|spd_rtng(97) | weapon_length(97)|swing_damage(19 , pierce) | thrust_damage(0 ,  pierce),imodbits_mace ],
["sickle",         "Sickle", [("sickle",0)], itp_type_one_handed_wpn|itp_merchandise|itp_primary|itp_secondary|itp_no_parry, itc_cleaver, 1 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(40)|swing_damage(17 , cut) | thrust_damage(0 ,  pierce),imodbits_none ],
["cleaver",         "Cleaver", [("cleaver",0)], itp_type_one_handed_wpn|itp_merchandise|itp_primary|itp_secondary|itp_no_parry, itc_cleaver, 3 , weight(1.5)|difficulty(0)|spd_rtng(103) | weapon_length(30)|swing_damage(21 , cut) | thrust_damage(0 ,  pierce),imodbits_none ],
["knife",         "Knife", [("peasant_knife",0)], itp_type_one_handed_wpn|itp_merchandise|itp_primary|itp_secondary|itp_no_parry, itc_dagger|itcf_carry_dagger_front_left, 4 , weight(1)|difficulty(0)|spd_rtng(110) | weapon_length(40)|swing_damage(18 , cut) | thrust_damage(11 ,  pierce),imodbits_sword ],
["butchering_knife", "Butchering Knife", [("khyber_knife",0)], itp_type_one_handed_wpn|itp_merchandise|itp_primary|itp_secondary|itp_no_parry, itc_dagger|itcf_carry_dagger_front_right, 13 , weight(1)|difficulty(0)|spd_rtng(108) | weapon_length(60)|swing_damage(21 , cut) | thrust_damage(15 ,  pierce),imodbits_sword ],
["dagger",         "Dagger", [("dagger",0),("scab_dagger",ixmesh_carry),("dagger_b",imodbit_watered_steel),("dagger_b_scabbard",ixmesh_carry|imodbit_watered_steel)], itp_type_one_handed_wpn|itp_merchandise|itp_primary|itp_secondary|itp_no_parry, itc_dagger|itcf_carry_dagger_front_left|itcf_show_holster_when_drawn, 17 , weight(1.25)|difficulty(0)|spd_rtng(112) | weapon_length(47)|swing_damage(19 , cut) | thrust_damage(17 ,  pierce),imodbits_sword ],
["falchion",         "Falchion", [("falchion",0)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_scimitar|itcf_carry_sword_left_hip, 105 , weight(2.5)|difficulty(8)|spd_rtng(96) | weapon_length(73)|swing_damage(29 , cut) | thrust_damage(0 ,  pierce),imodbits_sword ],
["scimitar",         "Scimitar", [("scimeter",0),("scab_scimeter", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 108 , weight(1.5)|difficulty(0)|spd_rtng(105) | weapon_length(97)|swing_damage(26 , cut) | thrust_damage(0 ,  pierce),imodbits_scimitar ],
["nomad_sabre",         "Nomad Sabre", [("shashqa",0),("scab_shashqa", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 115 , weight(1.75)|difficulty(0)|spd_rtng(101) | weapon_length(100)|swing_damage(27 , cut) | thrust_damage(0 ,  pierce),imodbits_scimitar ],
["hatchet",         "Hatchet", [("hatchet",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary|itp_secondary|itp_bonus_against_shield, itc_scimitar|itcf_carry_axe_left_hip, 3 , weight(2)|difficulty(0)|spd_rtng(97) | weapon_length(60)|swing_damage(20 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["hand_axe",         "Hand Axe", [("hatchet",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary|itp_secondary|itp_bonus_against_shield, itc_scimitar|itcf_carry_axe_left_hip, 24 , weight(2)|difficulty(7)|spd_rtng(95) | weapon_length(75)|swing_damage(24 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["fighting_axe", "Fighting Axe", [("fighting_ax",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary|itp_secondary|itp_bonus_against_shield, itc_scimitar|itcf_carry_axe_left_hip, 77 , weight(2.5)|difficulty(9)|spd_rtng(92) | weapon_length(90)|swing_damage(28 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["axe",                 "Axe", [("iron_ax",0)], itp_type_two_handed_wpn|itp_merchandise| itp_two_handed|itp_primary|itp_bonus_against_shield, itc_nodachi|itcf_carry_axe_back, 65 , weight(4)|difficulty(8)|spd_rtng(91) | weapon_length(108)|swing_damage(29 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["one_handed_battle_axe", "One Handed Battle Axe", [("one_handed_battle_axe_b",0),("one_handed_battle_axe_a",imodbits_bad),("one_handed_battle_axe_c",imodbits_good)], itp_type_one_handed_wpn|itp_merchandise| itp_primary|itp_secondary|itp_bonus_against_shield, itc_scimitar|itcf_carry_axe_left_hip, 77 , weight(2.5)|difficulty(11)|spd_rtng(92) | weapon_length(90)|swing_damage(29 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["one_handed_war_axe", "One Handed War Axe", [("one_handed_war_axe_a",0),("one_handed_war_axe_b",imodbits_good)], itp_type_one_handed_wpn|itp_merchandise| itp_primary|itp_secondary|itp_bonus_against_shield, itc_scimitar|itcf_carry_axe_left_hip, 77 , weight(2.5)|difficulty(11)|spd_rtng(92) | weapon_length(90)|swing_damage(28 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["scythe",         "Scythe", [("scythe",0)], itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_staff|itcf_carry_spear, 43 , weight(3)|difficulty(0)|spd_rtng(79) | weapon_length(182)|swing_damage(19 , cut) | thrust_damage(12 ,  pierce),imodbits_polearm ],
["pitch_fork",         "Pitch Fork", [("pitch_fork",0)], itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_spear, 19 , weight(3.5)|difficulty(0)|spd_rtng(83) | weapon_length(154)|swing_damage(0 , blunt) | thrust_damage(16 ,  pierce),imodbits_polearm ],
["battle_fork",         "Battle Fork", [("battle_fork",0)], itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_spear, 282 , weight(4.5)|difficulty(0)|spd_rtng(87) | weapon_length(142)|swing_damage(0 , blunt) | thrust_damage(22 ,  pierce),imodbits_polearm ],
["staff",         "Staff", [("wooden_staff",0)], itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_staff|itcf_carry_sword_back, 16 , weight(1.5)|difficulty(0)|spd_rtng(100) | weapon_length(130)|swing_damage(15 , blunt) | thrust_damage(15 ,  blunt),imodbits_polearm ],
["quarter_staff", "Quarter Staff", [("quarter_staff",0)], itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_staff|itcf_carry_sword_back, 70 , weight(2)|difficulty(0)|spd_rtng(104) | weapon_length(140)|swing_damage(17 , blunt) | thrust_damage(17 ,  blunt),imodbits_polearm ],
["iron_staff",         "Iron Staff", [("iron_staff",0)], itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_staff|itcf_carry_sword_back, 222 , weight(2)|difficulty(0)|spd_rtng(97) | weapon_length(140)|swing_damage(22 , blunt) | thrust_damage(22 ,  blunt),imodbits_polearm ],
["wooden_staff",         "Wooden Staff", [("wooden_staff",0)], itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_staff|itcf_carry_sword_back, 222 , weight(1)|difficulty(0)|spd_rtng(100) | weapon_length(120)|swing_damage(17 , blunt) | thrust_damage(17 ,  blunt),imodbits_polearm ],
["pickaxe",         "Pickaxe", [("rusty_pick",0)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_scimitar|itcf_carry_axe_left_hip, 27 , weight(3)|difficulty(0)|spd_rtng(96) | weapon_length(80)|swing_damage(17 , pierce) | thrust_damage(0 ,  pierce),imodbits_pick ],
#sango weapon start

#One-handed
["yuitian",         "Qing Hong", [("yitian",0),("yitian_scab", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary|itp_unique, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 12000 , weight(3)|difficulty(12)|spd_rtng(96) | weapon_length(105)|swing_damage(28 , cut) | thrust_damage(24 ,  pierce),imodbits_sword ],
["yitiansword",         "Yi Sky", [("yitiansword",0),("yitiansword_scab", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary|itp_unique, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 12000 , weight(3)|difficulty(13)|spd_rtng(99) | weapon_length(98)|swing_damage(30 , cut) | thrust_damage(22 ,  pierce),imodbits_sword ],
["shuangxi",         "Double Blade Male", [("shuangxi",0),("scab_longsw_a", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary|itp_unique, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 6000 , weight(2.9)|difficulty(12)|spd_rtng(100) | weapon_length(96)|swing_damage(27 , cut) | thrust_damage(24 ,  pierce),imodbits_sword ],
["shuangci",         "Double Blade Female", [("shuangci",0),("scab_longsw_a", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary|itp_unique, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 6000 , weight(2.9)|difficulty(12)|spd_rtng(100) | weapon_length(96)|swing_damage(24 , cut) | thrust_damage(27 ,  pierce),imodbits_sword ],
["wugousword",         "Wu Gou Sword", [("wugousword",0),("scab_longsw_a", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary|itp_unique, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 493 , weight(3.1)|difficulty(9)|spd_rtng(98) | weapon_length(94)|swing_damage(25 , cut) | thrust_damage(16 ,  pierce),imodbits_sword ],
["china_50longsword","Sword",  [("china_50longsword",0),("china_scab_50longsword", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 360 , weight(2.5)|difficulty(0)|spd_rtng(97) | weapon_length(84)|swing_damage(24 , cut) | thrust_damage(14 ,  pierce),imodbits_sword ],
["china_100longsword",         "Long Sword", [("china_100longsword",0),("china_scab_100longsword", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 448 , weight(3.5)|difficulty(0)|spd_rtng(89) | weapon_length(100)|swing_damage(26 , cut) | thrust_damage(18 ,  pierce),imodbits_sword ],
["handbronzesword", " Bronze Side Sword", [("handbronzesword",0),("scab_longsw_b", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 156 , weight(1.5)|abundance(100)|difficulty(0)|spd_rtng(100) | weapon_length(68)|swing_damage(16 , cut) | thrust_damage(22 ,  pierce),imodbits_sword ],
["handhalberd",         "Side Halberd", [("handhalberd",0)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 400 , weight(3.7)|abundance(100)|difficulty(0)|spd_rtng(100) | weapon_length(85)|swing_damage(24 , cut) | thrust_damage(24 ,  pierce),imodbits_sword ],
["china_25huanshou",         "Short Twenty-five Rings Falchion", [("china_25huanshou",0),("china_scab_25huanshou", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 360 , weight(2.5)|abundance(100)|difficulty(0)|spd_rtng(99) | weapon_length(84)|swing_damage(24 , cut) | thrust_damage(0 ,  pierce),imodbits_sword ],
["chinafalchion",         "Chinese Falchion", [("chinafalchion",0),("scab_longsw_a", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 360 , weight(2.4)|difficulty(0)|spd_rtng(100) | weapon_length(80)|swing_damage(24 , cut) | thrust_damage(0 ,  pierce),imodbits_sword ],
["china_100huanshou",         "Long Hundred Rings Falchion", [("china_100huanshou",0),("china_scab_100huanshou", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 600 , weight(3.5)|abundance(100)|difficulty(0)|spd_rtng(91) | weapon_length(100)|swing_damage(28 , cut) | thrust_damage(0 ,  pierce),imodbits_sword ],
["jian",         "Jian", [("jian",0),("scab_longsw_a", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 500 , weight(2.8)|abundance(100)|difficulty(0)|spd_rtng(90) |weapon_length(98)|swing_damage(24 , blunt) | thrust_damage(0 ,  pierce),imodbits_sword ],
["banaxe", "Froe", [("banaxe",0)],itp_type_one_handed_wpn|itp_merchandise|itp_primary|itp_secondary|itp_bonus_against_shield, itc_scimitar|itcf_carry_axe_left_hip, 30 , weight(3)|abundance(100)|difficulty(8)|spd_rtng(96) | weapon_length(70)|swing_damage(29 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["china_50huanshou", "Rings Falchion", [("china_50huanshou",0),("china_scab_50huanshou", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 522 , weight(3)|difficulty(0)|spd_rtng(95) | weapon_length(92)|swing_damage(26 , cut) | thrust_damage(0 ,  pierce),imodbits_sword ],
["bian",         "Hard Scourge", [("bian",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary, itc_scimitar, 401 , weight(4)|difficulty(0)|spd_rtng(88) | weapon_length(112)|swing_damage(22 , blunt) | thrust_damage(0 ,  pierce),imodbits_none ],
#Two-handed
["qinglongbardiche",         "Dragon's Moon", [("qinglongbardiche",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_unique, itc_nodachi|itcf_carry_axe_back, 12200 , weight(9.3)|difficulty(18)|spd_rtng(84) | weapon_length(165)|swing_damage(45 , cut)| thrust_damage(0 ,  pierce),imodbits_axe ],
["sanjiandao","Tripple-blade Bardiche",[("sanjiandao",0)],itp_type_two_handed_wpn|itp_merchandise|itp_two_handed|itp_primary|itp_unique, itc_nodachi|itcf_carry_axe_back, 660 , weight(6.2)|difficulty(9)|spd_rtng(94) | weapon_length(140)|swing_damage(20 , pierce)| thrust_damage(32 ,  pierce),imodbits_axe ],
["fangtianhalberd",         "The Paradise in Hell", [("fangtianhalberd",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_unique, itc_cut_thrust_polearm|itcf_carry_axe_back, 20000 , weight(7.9)|difficulty(20)|spd_rtng(95) | weapon_length(175)|swing_damage(36 , cut)| thrust_damage(40 ,  pierce),imodbits_axe ],
["longaxe",         "Long Axe", [("longaxe",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_merchandise, itc_cut_thrust_polearm|itcf_carry_axe_back, 2000 , weight(10.0)|difficulty(16)|spd_rtng(74) | weapon_length(165)|swing_damage(40 , cut)| thrust_damage(22 ,  pierce),imodbits_axe ],
["bronzetuff","Bronze Tuff", [("bronzetuff",0)], itp_type_two_handed_wpn|itp_merchandise| itp_primary,itc_greatsword, 50 , weight(5.6)|abundance(100)|difficulty(0)|spd_rtng(90) | weapon_length(124)|swing_damage(20 , blunt) | thrust_damage(20,  blunt),imodbits_none ],
["jinwu","Iron Wu", [("jinwu",0)], itp_type_two_handed_wpn|itp_merchandise|itp_primary|itp_penalty_with_shield,  itc_scimitar|itcf_carry_sword_left_hip,1250 ,weight(6.9)|abundance(80)|difficulty(11)|spd_rtng(88) | weapon_length(100)|swing_damage(32 , blunt) | thrust_damage(0 ,  pierce),imodbits_sword ],
["bronzesword",         "Bronze Sword", [("bronzesword",0),("scab_bastardsw_b", ixmesh_carry)], itp_type_two_handed_wpn|itp_merchandise|itp_primary,itc_greatsword|itcf_carry_sword_back|itcf_show_holster_when_drawn, 750 ,weight(4.3)|abundance(50)|difficulty(9)|spd_rtng(90) | weapon_length(110)|swing_damage(30 , blunt) | thrust_damage(20 ,  pierce),imodbits_sword ],
["halberd",         "Halberd", [("halberd",0)], itp_type_two_handed_wpn|itp_merchandise| itp_two_handed|itp_primary, itc_greatsword|itcf_carry_axe_back, 900 , weight(5.8)|abundance(100)|difficulty(0)|spd_rtng(89) | weapon_length(145)|swing_damage(26 , cut) | thrust_damage(28 ,  pierce),imodbits_axe ],
["longhalberd",         "Long Halberd", [("longhalberd",0)], itp_type_two_handed_wpn|itp_merchandise| itp_two_handed|itp_primary, itc_greatsword|itcf_carry_axe_back, 1000 , weight(6.4)|abundance(100)|difficulty(0)|spd_rtng(82) | weapon_length(160)|swing_damage(24 , cut) | thrust_damage(30 ,  pierce),imodbits_axe ],
["lianhalberd", "Lian Halberd", [("lianhalberd",0)], itp_type_two_handed_wpn|itp_merchandise|itp_two_handed|itp_primary, itc_greatsword|itcf_carry_axe_back, 611 , weight(8.5)|abundance(60)|difficulty(10)|spd_rtng(90) | weapon_length(158)|swing_damage(32 , cut) | thrust_damage(24 ,  pierce),imodbits_axe ],
["dadao",         "Bardiche", [("dadao",0)], itp_type_two_handed_wpn|itp_merchandise| itp_two_handed|itp_primary|itp_bonus_against_shield, itc_nodachi|itcf_carry_axe_back, 1100 , weight(8.7)|abundance(100)|difficulty(10)|spd_rtng(85) | weapon_length(155)|swing_damage(36 , cut)| thrust_damage(0 ,  pierce),imodbits_axe ],
["china_s100huan", "Hundred Rings Falchion", [("china_s100huan",0),("china_scab_s100huan", ixmesh_carry)], itp_type_two_handed_wpn|itp_merchandise|itp_primary|itp_penalty_with_shield,itc_scimitar|itcf_carry_sword_back|itcf_show_holster_when_drawn,650 , weight(3.6)|abundance(100)|difficulty(9)|spd_rtng(92) | weapon_length(104)|swing_damage(32 , cut) | thrust_damage(0 ,pierce),imodbits_sword ],
["china_s50huan", "Fifty Rings Falchion",[("china_s50huan",0),("china_scab_s50huan", ixmesh_carry)], itp_type_two_handed_wpn|itp_merchandise|itp_primary|itp_penalty_with_shield ,  itc_scimitar|itcf_carry_sword_back|itcf_show_holster_when_drawn,582 ,weight(3.1)|difficulty(0)|spd_rtng(93) | weapon_length(94)|swing_damage(30 , cut) | thrust_damage(0 ,  pierce),imodbits_sword ],
["china_s25huan", "Twenty-five Rings Falchion", [("china_s25huan",0),("china_scab_s25huan", ixmesh_carry)], itp_type_two_handed_wpn|itp_merchandise|itp_primary , itc_scimitar|itcf_carry_sword_back|itcf_show_holster_when_drawn, 386 ,weight(2.6)|abundance(100)|difficulty(0)|spd_rtng(97) | weapon_length(86)|swing_damage(28 , cut) | thrust_damage(0 ,  pierce),imodbits_sword ],
["zhanmabardiche", "Killing-horse Bardiche", [("zhanmabardiche",0)], itp_type_two_handed_wpn|itp_merchandise| itp_two_handed|itp_primary|itp_bonus_against_shield, itc_nodachi|itcf_carry_axe_back, 1660 , weight(6.8)|abundance(80)|difficulty(14)|spd_rtng(82) | weapon_length(140)|swing_damage(38 , cut)| thrust_damage(0 ,  pierce),imodbits_axe ],
["zhongzhandao", "Heavy Bardiche", [("zhongzhandao",0)],itp_type_two_handed_wpn|itp_merchandise|itp_two_handed|itp_primary|itp_bonus_against_shield,itc_nodachi|itcf_carry_axe_back, 1800 , weight(7.9)|abundance(80)|difficulty(15)|spd_rtng(78) | weapon_length(135)|swing_damage(40 , cut)| thrust_damage(0 ,pierce),imodbits_axe ],
["bibardiche", "Stright Bardiche", [("bibardiche",0)], itp_type_two_handed_wpn|itp_merchandise|itp_two_handed|itp_primary|itp_bonus_against_shield, itc_nodachi|itcf_carry_axe_back, 880 , weight(6.2)|abundance(100)|difficulty(10)|spd_rtng(87) | weapon_length(155)|swing_damage(32 , cut) | thrust_damage(24 ,  pierce),imodbits_axe ],
["yue","Voulge", [("yue",0)], itp_type_two_handed_wpn|itp_merchandise|itp_two_handed|itp_primary|itp_bonus_against_shield, itc_nodachi|itcf_carry_axe_back, 900 , weight(9)|abundance(80)|difficulty(14)|spd_rtng(85) | weapon_length(142)|swing_damage(38 , cut)| thrust_damage(0 ,  pierce), imodbits_axe ],
["dayue", "Great Voulge", [("dayue",0)], itp_type_two_handed_wpn|itp_merchandise|itp_primary|itp_bonus_against_shield|itp_penalty_with_shield,itc_scimitar|itcf_carry_axe_back, 1000 , weight(9)|abundance(60)|difficulty(14)|spd_rtng(88) | weapon_length(130)|swing_damage(22 , blunt)| thrust_damage(38 ,  pierce), imodbits_axe ],

#Polearm
["steelspear",         "Steel Killer", [("steelspear",0)], itp_type_two_handed_wpn|itp_two_handed|itp_spear|itp_primary|itp_unique, itc_thrustpolearm, 11400 , weight(7.2)|difficulty(16)|spd_rtng(84) | weapon_length(155)|swing_damage(0 , cut) | thrust_damage(42 ,  pierce),imodbits_polearm ],
["tiejispear",         "Iron Snake", [("tiejispear",0)], itp_type_two_handed_wpn|itp_two_handed|itp_spear|itp_primary|itp_unique, itc_thrustpolearm, 12200 , weight(8)|difficulty(16)|spd_rtng(88) | weapon_length(155)|swing_damage(0 , cut) | thrust_damage(46 ,  pierce),imodbits_polearm ],
["silverlance",         "Silver Dragon", [("silverlance",0)], itp_type_two_handed_wpn|itp_two_handed|itp_spear|itp_primary|itp_unique, itc_thrustpolearm, 12200 , weight(6.6)|difficulty(16)|spd_rtng(90) | weapon_length(150)|swing_damage(0 , cut) | thrust_damage(44 ,  pierce),imodbits_polearm ],
["goulian",         "Gou Lian Lance", [("goulian",0)], itp_type_two_handed_wpn|itp_two_handed|itp_merchandise| itp_spear|itp_primary|itp_unique, itc_cut_thrust_polearm, 990 , weight(7.1)|abundance(80)|difficulty(0)|spd_rtng(90) |weapon_length(148)|swing_damage(26 , cut) | thrust_damage(30 ,  pierce),imodbits_polearm ],
["qiuspear",         "Qiu Spear", [("qiuspear",0)], itp_type_two_handed_wpn|itp_two_handed|itp_spear|itp_primary, itc_thrustpolearm, 2200 , weight(9)|difficulty(11)|spd_rtng(80) | weapon_length(204)|swing_damage(0 , cut) | thrust_damage(30 ,  pierce),imodbits_polearm ],
["congspear",         "Cong Spear", [("congspear",0)], itp_type_two_handed_wpn|itp_two_handed|itp_spear|itp_primary, itc_thrustpolearm, 2000 , weight(9)|difficulty(13)|spd_rtng(82) | weapon_length(190)|swing_damage(0 , cut) | thrust_damage(32 ,  pierce),imodbits_polearm ],
["spear1",         "Spear", [("spear1",0)], itp_type_two_handed_wpn|itp_two_handed|itp_merchandise| itp_spear|itp_primary, itc_thrustpolearm, 650 , weight(6)|difficulty(0)|spd_rtng(99) | weapon_length(165)|swing_damage(0 , cut) | thrust_damage(32 ,  pierce),imodbits_polearm ],
["china_spear",         "Hunting Spear", [("china_spear",0)], itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_thrustpolearm, 550 , weight(5.2)|difficulty(14)|spd_rtng(100) | weapon_length(155)|swing_damage(0 , cut) | thrust_damage(32 ,  pierce),imodbits_polearm ],
["china_l_spear",         "Long Spear", [("china_l_spear",0)], itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_thrustpolearm, 1000 , weight(5.7)|difficulty(0)|spd_rtng(92) | weapon_length(150)|swing_damage(0 , cut) | thrust_damage(33 ,  pierce),imodbits_polearm ],
["ironlance",         "Dark Night", [("ironlance",0)], itp_type_two_handed_wpn|itp_two_handed|itp_spear|itp_primary, itc_thrustpolearm, 5900 , weight(7.9)|abundance(40)|difficulty(17)|spd_rtng(90) | weapon_length(150)|swing_damage(0 ,cut) | thrust_damage(39 ,  pierce),imodbits_polearm ],
["longlance",         "Long Lance", [("longlance",0)], itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_thrustpolearm, 1350 , weight(5.9)|abundance(100)|difficulty(12)|spd_rtng(94) | weapon_length(160)|swing_damage(0 , cut) | thrust_damage(35 ,  pierce),imodbits_polearm ],
["china_s_spear",         "Short spear", [("china_s_spear",0)],  itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_thrustpolearm, 650 , weight(4.6)|abundance(100)|difficulty(0)|spd_rtng(95) | weapon_length(128)|swing_damage(0 , cut) | thrust_damage(28 ,  pierce),imodbits_polearm ],
["ge","Long Dagger", [("ge",0)], itp_type_two_handed_wpn|itp_merchandise|itp_spear|itp_primary|itp_penalty_with_shield, itc_scimitar, 550 , weight(5)|difficulty(0)|spd_rtng(88) |weapon_length(160)|swing_damage(28 , pierce) | thrust_damage(0 ,  pierce),imodbits_polearm ],
["china_ge",         "Long Dagger", [("china_ge",0)], itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_cut_thrust_polearm|itcf_carry_spear, 565 , weight(5.2)|abundance(100)|difficulty(0)|spd_rtng(95) | weapon_length(170)|swing_damage(24 , pierce) | thrust_damage(26 ,  pierce),imodbits_polearm ],
["gea",         "Long Dagger", [("gea",0)], itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_cut_thrust_polearm|itcf_carry_spear, 560 , weight(5)|abundance(100)|difficulty(0)|spd_rtng(100) | weapon_length(160)|swing_damage(25 , pierce) | thrust_damage(25 ,  pierce),imodbits_polearm ],
["geb",         "Long Dagger", [("geb",0)], itp_type_two_handed_wpn|itp_two_handed|itp_merchandise| itp_spear|itp_primary, itc_cut_thrust_polearm|itcf_carry_spear, 720 , weight(6.5)|abundance(100)|difficulty(11)|spd_rtng(96) | weapon_length(165)|swing_damage(22, pierce) | thrust_damage(28 ,  pierce),imodbits_polearm ],
["bupick",         "Bu Pick", [("bupick",0)], itp_type_two_handed_wpn|itp_two_handed|itp_merchandise| itp_spear|itp_primary, itc_thrustpolearm|itp_cant_use_on_horseback, 1450 , weight(7.9)|abundance(100)|difficulty(12)|spd_rtng(84) | weapon_length(160)|swing_damage(0 , pierce) | thrust_damage(38 ,  pierce),imodbits_polearm ],
["china_pike",         "Pike with Branch", [("china_pike",0)], itp_type_two_handed_wpn|itp_merchandise| itp_spear|itp_primary|itp_penalty_with_shield, itc_thrustpolearm, 1365 , weight(7.9)|difficulty(12)|spd_rtng(87) | weapon_length(165)|swing_damage(0 , cut) | thrust_damage(30 ,  pierce),imodbits_polearm ],
["pick",         "Pick", [("pick",0)], itp_type_two_handed_wpn|itp_two_handed|itp_merchandise| itp_spear|itp_primary, itc_thrustpolearm, 1300 , weight(6.9)|abundance(100)|difficulty(14)|spd_rtng(89) | weapon_length(155)|swing_damage(0, cut) | thrust_damage(38 ,  pierce),imodbits_polearm ],
["mapick",         "Ma Pick", [("mapick",0)], itp_type_two_handed_wpn|itp_two_handed|itp_merchandise| itp_spear|itp_primary, itc_thrustpolearm, 1785 , weight(7.7)|abundance(80)|difficulty(14)|spd_rtng(86) | weapon_length(145)|swing_damage(0 ,cut) | thrust_damage(40 ,  pierce),imodbits_polearm ],
["china_su",         "Piercing", [("china_su",0)], itp_type_two_handed_wpn|itp_two_handed|itp_merchandise| itp_spear|itp_primary, itc_thrustpolearm, 1200 , weight(8.1)|difficulty(11)|spd_rtng(79) | weapon_length(166)|swing_damage(27 ,  pierce) | thrust_damage(25 ,  pierce),imodbits_polearm ],
["dbspear",         "Double Heads", [("dbspear",0)], itp_type_two_handed_wpn|itp_two_handed|itp_merchandise| itp_spear|itp_primary, itc_cut_thrust_polearm, 995 , weight(7.4)|abundance(100)|difficulty(9)|spd_rtng(90) | weapon_length(145)|swing_damage(18 , cut) | thrust_damage(30 ,  pierce),imodbits_polearm ],
#Flags
["yaflag", "Ya Flag", [("yaflag",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,3000 , weight(5)|difficulty(10)|spd_rtng(70) | weapon_length(164)|swing_damage(0 , cut) | thrust_damage(15 ,  pierce),imodbits_polearm ],
["huangjinflag", "xFlag of Huang Jin", [("huangjinflag",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,5000 , weight(6.5)|difficulty(14)|spd_rtng(60) | weapon_length(204)|swing_damage(0 , cut) | thrust_damage(25 ,  pierce),imodbits_polearm ],
["jiaoflag_huang", "Jiao Flag of Huang Jin", [("jiaoflag_huang",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,4000 , weight(5.5)|difficulty(12)|spd_rtng(65) | weapon_length(184)|swing_damage(0 , cut) | thrust_damage(20 ,  pierce),imodbits_polearm ],
["jiaoflag_nanman", "Jiao Flag of Southern Man", [("jiaoflag_nanman",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,4000 , weight(5.5)|difficulty(12)|spd_rtng(65) | weapon_length(184)|swing_damage(0 , cut) | thrust_damage(20 ,  pierce),imodbits_polearm ],
["jiaoflag_shanyue", "Jiao Flag of Eastern Yue", [("jiaoflag_shanyue",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,4000 , weight(5.5)|difficulty(12)|spd_rtng(65) | weapon_length(184)|swing_damage(0 , cut) | thrust_damage(20 ,  pierce),imodbits_polearm ],
["jiaoflag_shu", "Jiao Flag of Shu", [("jiaoflag_shu",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,4000 , weight(5.5)|difficulty(12)|spd_rtng(65) | weapon_length(184)|swing_damage(0 , cut) | thrust_damage(20 ,  pierce),imodbits_polearm ],
["jiaoflag_wei", "Jiao Flag of Wei", [("jiaoflag_wei",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,4000 , weight(5.5)|difficulty(12)|spd_rtng(65) | weapon_length(184)|swing_damage(0 , cut) | thrust_damage(20 ,  pierce),imodbits_polearm ],
["jiaoflag_wu", "Jiao Flag of Wu", [("jiaoflag_wu",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,4000 , weight(5.5)|difficulty(12)|spd_rtng(65) | weapon_length(184)|swing_damage(0 , cut) | thrust_damage(20 ,  pierce),imodbits_polearm ],
["jiaoflag_xiongnu", "Jiao Flag of Northern Xiong Nu", [("jiaoflag_xiongnu",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,4000 , weight(5.5)|difficulty(12)|spd_rtng(65) | weapon_length(184)|swing_damage(0 , cut) | thrust_damage(20 ,  pierce),imodbits_polearm ],
["nanmanflag", "Large Flag of Southern Man", [("nanmanflag",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,5000 , weight(6)|difficulty(14)|spd_rtng(60) | weapon_length(204)|swing_damage(0 , cut) | thrust_damage(25 ,  pierce),imodbits_polearm ],
["shanyueflag", "Large Flag of Eastern Yue", [("shanyueflag",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,5000 , weight(6)|difficulty(14)|spd_rtng(60) | weapon_length(204)|swing_damage(0 , cut) | thrust_damage(25 ,  pierce),imodbits_polearm ],
["xiongnuflag", "Large Flag of Northern Xiong Nu", [("xiongnuflag",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,5000 , weight(6)|difficulty(14)|spd_rtng(60) | weapon_length(204)|swing_damage(0 , cut) | thrust_damage(25 ,  pierce),imodbits_polearm ],
["nationflag_wu", "Large Flag of Wu", [("nationflag_wu",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,5000 , weight(6)|difficulty(14)|spd_rtng(60) | weapon_length(204)|swing_damage(0 , cut) | thrust_damage(25 ,  pierce),imodbits_polearm ],
["nationflag_shu", "Large Flag of Shu", [("nationflag_shu",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,5000 , weight(6)|difficulty(14)|spd_rtng(60) | weapon_length(204)|swing_damage(0 , cut) | thrust_damage(25 ,  pierce),imodbits_polearm ],
["nationflag_wei", "Large Flag of Wei", [("nationflag_wei",0)], itp_type_two_handed_wpn|itp_spear|itp_primary, itc_thrustpolearm|itcf_carry_spear,5000 , weight(6)|difficulty(14)|spd_rtng(60) | weapon_length(204)|swing_damage(0 , cut) | thrust_damage(25 ,  pierce),imodbits_polearm ],

#sango weapon end

# SHIELDS
["wooden_shield", "Wooden Shield", [("shield_round_a",0)], itp_merchandise|itp_type_shield , itcf_carry_round_shield,  42 , weight(2)|hit_points(360)|body_armor(1)|spd_rtng(100)|weapon_length(50),imodbits_shield ],
["round_shield", "Round Shield", [("shield_round_c",0)], itp_merchandise|itp_type_shield , itcf_carry_round_shield,  64 , weight(2)|hit_points(400)|body_armor(1)|spd_rtng(100)|weapon_length(50),imodbits_shield ],
["nordic_shield", "Nordic Shield", [("shield_round_b",0)], itp_merchandise|itp_type_shield , itcf_carry_round_shield,  95 , weight(2)|hit_points(440)|body_armor(1)|spd_rtng(100)|weapon_length(50),imodbits_shield ],
["shield_round_e", "Round Shield", [("shield_round_e",0)], itp_merchandise|itp_type_shield , itcf_carry_round_shield,  12 , weight(2)|hit_points(260)|body_armor(6)|spd_rtng(110)|weapon_length(30),imodbits_shield ],
["shield_round_d", "Round Shield", [("shield_round_d",0)], itp_merchandise|itp_type_shield , itcf_carry_round_shield,  12 , weight(2)|hit_points(260)|body_armor(6)|spd_rtng(110)|weapon_length(30),imodbits_shield ],
#sango shields begin
["budun", "Bu Shield", [("budun",0)], itp_merchandise|itp_type_shield , itcf_carry_round_shield,  70 , weight(3.5)|hit_points(350)|body_armor(2)|spd_rtng(90)|weapon_length(65),imodbits_shield ],
["qidun", "Lacquerd Shield", [("qidun",0)], itp_merchandise|itp_type_shield , itcf_carry_round_shield,  35 , weight(3)|hit_points(350)|body_armor(1)|spd_rtng(95)|weapon_length(60),imodbits_shield ],
["dadun", "Large Shield", [("dadun",0)], itp_merchandise|itp_type_shield , itcf_carry_round_shield,  135 , weight(5)|hit_points(450)|body_armor(3)|spd_rtng(60)|weapon_length(95),imodbits_shield ],
["qitadun", "Large Lacquerd Shield", [("qitadun",0)], itp_merchandise|itp_type_shield|itp_cant_use_on_horseback , itcf_carry_round_shield,  300 , weight(5)|hit_points(600)|body_armor(5)|spd_rtng(30)|weapon_length(120),imodbits_shield ],
["xishield", "Xi Shield", [("xishield",0)], itp_merchandise|itp_type_shield , itcf_carry_round_shield,  30 , weight(2)|hit_points(300)|body_armor(1)|spd_rtng(100)|weapon_length(50),imodbits_shield ],
["bigshield", "Giant Shield", [("bigshield",0)], itp_merchandise|itp_type_shield|itp_cant_use_on_horseback , itcf_carry_round_shield,  348 , weight(8)|hit_points(580)|body_armor(6)|spd_rtng(40)|weapon_length(135),imodbits_shield ],
["ironshield", "Iron Shield", [("ironshield",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield,  560 , weight(7)|abundance(40)|hit_points(800)|body_armor(7)|spd_rtng(60)|weapon_length(60),imodbits_shield ],
["shushield", "Dun Shield of Shu", [("shushield",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield,  240 , weight(5.5)|abundance(80)|hit_points(600)|body_armor(4)|spd_rtng(70)|weapon_length(100),imodbits_shield ],
["wushield", "Kui Shield of Wu", [("wushield",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield,  90 , weight(3)|abundance(80)|hit_points(400)|body_armor(2)|spd_rtng(95)|weapon_length(60),imodbits_shield ],
["weishield", "Pai Shield of Wei", [("weishield",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield,  150 , weight(3)|abundance(80)|hit_points(500)|body_armor(3)|spd_rtng(75)|weapon_length(80),imodbits_shield ],
["zhendun", "Zhen Shield", [("zhendun",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield,  160 , weight(4)|abundance(60)|hit_points(520)|body_armor(2)|spd_rtng(80)|weapon_length(90),imodbits_shield ],
["tengshield", "Cany Shield", [("tengshield",0)], itp_type_shield, itcf_carry_round_shield,  200 , weight(4)|abundance(60)|hit_points(450)|body_armor(3)|spd_rtng(100)|weapon_length(60),imodbits_shield ],
#sango shields end

#RANGED
["jarid",         "Jarid", [("jarid_new",0),("jarid_quiver", ixmesh_carry)], itp_type_thrown |itp_merchandise|itp_primary|itp_bonus_against_shield ,itcf_throw_javelin|itcf_carry_quiver_back|itcf_show_holster_when_drawn, 109 , weight(4)|difficulty(1)|spd_rtng(89) | shoot_speed(27) | thrust_damage(30 ,  pierce)|max_ammo(7)|weapon_length(65),imodbits_missile ],
["javelin",         "Javelin", [("javelin",0),("javelins_quiver", ixmesh_carry)], itp_type_thrown |itp_merchandise|itp_primary|itp_bonus_against_shield ,itcf_throw_javelin|itcf_carry_quiver_back|itcf_show_holster_when_drawn, 75 , weight(5)|difficulty(0)|spd_rtng(91) | shoot_speed(28) | thrust_damage(27 ,  pierce)|max_ammo(7)|weapon_length(75),imodbits_missile ],
["stones",         "Stones", [("throwing_stone",0)], itp_type_thrown |itp_merchandise|itp_primary ,itcf_throw_stone, 1 , weight(4)|difficulty(0)|spd_rtng(97) | shoot_speed(30) | thrust_damage(10 ,  blunt)|max_ammo(18)|weapon_length(8),imodbit_large_bag ],
["throwing_knives", "Throwing Knives", [("throwing_knife",0)], itp_type_thrown |itp_merchandise|itp_primary ,itcf_throw_knife, 76 , weight(3.5)|difficulty(0)|spd_rtng(110) | shoot_speed(26) | thrust_damage(19 ,  cut)|max_ammo(15)|weapon_length(0),imodbits_missile ],
["throwing_daggers", "Throwing Daggers", [("throwing_dagger",0)], itp_type_thrown |itp_merchandise|itp_primary ,itcf_throw_knife, 143 , weight(3.5)|difficulty(0)|spd_rtng(102) | shoot_speed(25) | thrust_damage(22 ,  cut)|max_ammo(14)|weapon_length(0),imodbits_missile ],
["throwing_axes", "Throwing Axes", [("francisca",0)], itp_type_thrown |itp_merchandise|itp_primary|itp_bonus_against_shield,itcf_throw_axe,171, weight(5)|difficulty(1)|spd_rtng(88) | shoot_speed(21) | thrust_damage(35,cut)|max_ammo(7)|weapon_length(53),imodbits_missile ],
#sango ranged begin
["cavalry_bow",         "Cavalry Bow", [("khergit_bow",0),("khergit_bow_case", ixmesh_carry)], itp_type_bow |itp_merchandise|itp_primary|itp_two_handed,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 269 , weight(1.25)|difficulty(3)|spd_rtng(95) | shoot_speed(94) | thrust_damage(23 ,pierce),imodbits_bow ],
["hunting_bow",         "Hunting Bow", [("hunting_bow",0),("hunting_bow_carry",ixmesh_carry)], itp_type_bow |itp_merchandise|itp_primary|itp_two_handed,itcf_shoot_bow|itcf_carry_bow_back, 17 , weight(1)|difficulty(0)|spd_rtng(100) | shoot_speed(46) | thrust_damage(16 ,  pierce),imodbits_bow ],
["short_bow",         "Short Bow", [("short_bow",0),("short_bow_carry",ixmesh_carry)], itp_type_bow |itp_merchandise|itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bow_back, 58 , weight(1)|difficulty(1)|spd_rtng(98) | shoot_speed(49) | thrust_damage(18 ,  pierce  ),imodbits_bow ],
["nomad_bow",         "Nomad Bow", [("nomad_bow",0),("nomad_bow_case", ixmesh_carry)], itp_type_bow |itp_merchandise|itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 154 , weight(1.25)|difficulty(2)|spd_rtng(96) | shoot_speed(51) | thrust_damage(20 ,  pierce),imodbits_bow ],
["long_bow",         "Long Bow", [("long_bow",0),("long_bow_carry",ixmesh_carry)], itp_type_bow |itp_merchandise|itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bow_back, 205 , weight(1.75)|difficulty(3)|spd_rtng(82) | shoot_speed(51) | thrust_damage(22 ,  pierce),imodbits_bow ],
["khergit_bow",         "Khergit Bow", [("khergit_bow",0),("khergit_bow_case", ixmesh_carry)], itp_type_bow |itp_merchandise|itp_primary|itp_two_handed,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 269 , weight(1.25)|difficulty(3)|spd_rtng(95) | shoot_speed(54) | thrust_damage(24 ,pierce),imodbits_bow ],
["strong_bow",         "Strong Bow", [("strong_bow",0),("strong_bow_case", ixmesh_carry)], itp_type_bow |itp_merchandise|itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 337 , weight(1.25)|difficulty(3)|spd_rtng(94) | shoot_speed(55) | thrust_damage(26 ,pierce),imodbits_bow ],
["war_bow",         "War Bow", [("war_bow",0),("war_bow_carry",ixmesh_carry)],itp_type_bow|itp_merchandise|itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bow_back, 428 , weight(1.5)|difficulty(4)|spd_rtng(93) | shoot_speed(56) | thrust_damage(27 ,pierce),imodbits_bow ],
["hunting_crossbow", "Hunting Crossbow", [("crossbow",0)], itp_type_crossbow |itp_merchandise|itp_primary|itp_two_handed ,itcf_shoot_crossbow|itcf_carry_crossbow_back, 22 , weight(2.25)|difficulty(0)|spd_rtng(44) | shoot_speed(50) | thrust_damage(24 ,  pierce)|max_ammo(1),imodbits_crossbow ],
["light_crossbow", "Light Crossbow", [("light_crossbow",0)], itp_type_crossbow |itp_merchandise|itp_primary|itp_two_handed ,itcf_shoot_crossbow|itcf_carry_crossbow_back, 67 , weight(2.5)|difficulty(8)|spd_rtng(43) | shoot_speed(59) | thrust_damage(35 ,  pierce)|max_ammo(1),imodbits_crossbow ],
["crossbow",         "Crossbow",         [("crossbow",0)], itp_type_crossbow |itp_merchandise|itp_primary|itp_two_handed|itp_cant_use_on_horseback ,itcf_shoot_crossbow|itcf_carry_crossbow_back, 182 , weight(3)|difficulty(8)|spd_rtng(42) | shoot_speed(68) | thrust_damage(42,pierce)|max_ammo(1),imodbits_crossbow ],
["heavy_crossbow", "Heavy Crossbow", [("heavy_crossbow",0)], itp_type_crossbow |itp_merchandise|itp_primary|itp_two_handed|itp_cant_use_on_horseback ,itcf_shoot_crossbow|itcf_carry_crossbow_back, 349 , weight(3.5)|difficulty(9)|spd_rtng(40) | shoot_speed(72) | thrust_damage(47 ,pierce)|max_ammo(1),imodbits_crossbow ],
["sniper_crossbow", "Sniper Crossbow", [("heavy_crossbow",0)], itp_type_crossbow |itp_merchandise|itp_primary|itp_two_handed|itp_cant_use_on_horseback ,itcf_shoot_crossbow|itcf_carry_crossbow_back, 483 , weight(3.75)|difficulty(10)|spd_rtng(38) | shoot_speed(74) | thrust_damage(52 ,pierce)|max_ammo(1),imodbits_crossbow ],
["killer_crossbow", "Killer Crossbow", [("heavy_crossbow",0)], itp_type_crossbow |itp_primary|itp_two_handed ,itcf_shoot_crossbow|itcf_carry_crossbow_back, 483 , weight(3.75)|difficulty(10)|spd_rtng(45) | shoot_speed(85) | thrust_damage(60 ,pierce)|max_ammo(1),imodbits_crossbow ],
["china_cross", "Continuing Shooting Crossbow", [("china_cross",0)], itp_type_crossbow |itp_unique|itp_primary|itp_two_handed|itp_cant_use_on_horseback|itp_unique ,itcf_shoot_crossbow|itcf_carry_crossbow_back, 483 , weight(4.5)|difficulty(10)|spd_rtng(30) | shoot_speed(95) | thrust_damage(40 ,pierce)|max_ammo(10),imodbits_crossbow ],
["yangyou_bow",         "YangYou Bow", [("yangyou_bow",0),("yangyou_bow_carry",ixmesh_carry)],itp_type_bow|itp_unique|itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bow_back, 428 , weight(5.5)|difficulty(6)|spd_rtng(95) | shoot_speed(70) | thrust_damage(35 ,pierce),imodbits_bow ],
#sango ranged begin


["torch",         "Torch", [("club",0)], itp_type_one_handed_wpn|itp_primary, itc_scimitar, 11 , weight(2.5)|difficulty(0)|spd_rtng(95) | weapon_length(95)|swing_damage(11 , blunt) | thrust_damage(0 ,  pierce),imodbits_none,
 [(ti_on_init_item, [(set_position_delta,0,60,0),(particle_system_add_new, "psys_torch_fire"),(particle_system_add_new, "psys_torch_smoke"),(set_current_color,150, 130, 70),(add_point_light, 10, 30),
])]],

["leather_steppe_cap_a", "Leather Steppe Cap", [("leather_steppe_cap_a",0)], itp_type_head_armor   ,0, 24 , weight(2)|abundance(100)|head_armor(15)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["leather_steppe_cap_b", "Leather Steppe Cap", [("leather_steppe_cap_b",0)], itp_type_head_armor   ,0, 36 , weight(2)|abundance(100)|head_armor(16)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["leather_steppe_cap_c", "Leather Steppe Cap", [("leather_steppe_cap_c",0)], itp_type_head_armor   ,0, 51 , weight(2)|abundance(100)|head_armor(18)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["felt_steppe_cap", "Felt Steppe Cap", [("felt_steppe_cap",0)], itp_type_head_armor   ,0, 237 , weight(2)|abundance(100)|head_armor(16)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["khergit_sword", "Khergit Sword", [("khergit_sword",0),("khergit_sword_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 183 , weight(1.25)|difficulty(0)|spd_rtng(100) | weapon_length(97)|swing_damage(23 , cut) | thrust_damage(14 ,  pierce),imodbits_sword ],
["light_leather_boots",  "Light Leather Boots", [("light_leather_boots_L",0)], itp_type_foot_armor |itp_merchandise| itp_attach_armature,0, 91 , weight(1)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(15)|difficulty(0) ,imodbits_cloth ],


###############################################################################
["cheap_shirt","Cheap Shirt", [("shirt",0)], itp_type_body_armor|itp_covers_legs, 0, 4,weight(1.25)|body_armor(3),imodbits_none],







["quest_items_start","INVALID ITEM", [("practice_sword",0)], itp_type_one_handed_wpn|itp_melee|itp_primary|itp_secondary, itc_longsword, 1000,weight(1.5)|spd_rtng(103)|weapon_length(90)|swing_damage(16,blunt)|thrust_damage(10,blunt),imodbits_none],
# BoW: Special unique items for quests and such go HERE (will not be removed by defeat_lose_items script)
# e.g. Gualitero the hero horse should go here.
 ["cixiongswordx",         "Unkown", [("b_long_sword",0)], itp_type_one_handed_wpn|itp_primary, itc_scimitar|itcf_carry_axe_left_hip, 27 , weight(3)|difficulty(0)|spd_rtng(96) | weapon_length(80)|swing_damage(15 , pierce) | thrust_damage(0 ,  pierce),imodbits_pick ],
 ["guoflag_wei", "Unkown", [("pike",0)], itp_type_two_handed_wpn|itp_spear|itp_primary|itp_penalty_with_shield, itc_thrustpolearm|itcf_carry_spear,3000 , weight(5)|difficulty(10)|spd_rtng(70) | weapon_length(104)|swing_damage(0 , cut) | thrust_damage(15 ,  pierce),imodbits_polearm ],

# ["sulfur","Sulfur", [("oil",0)], itp_merchandise|itp_type_goods, 0, 104,weight(40)|abundance(60),imodbits_none],
# ["saltpeter","Saltpeter", [("oil",0)], itp_merchandise|itp_type_goods, 0, 104,weight(40)|abundance(60),imodbits_none],
# ["charcoal","Charcoal", [("oil",0)], itp_merchandise|itp_type_goods, 0, 104,weight(40)|abundance(60),imodbits_none],

["quest_items_end","INVALID ITEM", [("practice_sword",0)], itp_type_one_handed_wpn|itp_melee|itp_primary|itp_secondary, itc_longsword, 1000,weight(1.5)|spd_rtng(103)|weapon_length(90)|swing_damage(16,blunt)|thrust_damage(10,blunt),imodbits_none],

]
