from header_common import *
from header_operations import *
from header_mission_templates import *
from header_animations import *
from module_constants import *
from header_skills import *

####################################################################################################################
#   Each mission-template is a tuple that contains the following fields:
#  1) Mission-template id (string): used for referencing mission-templates in other files.
#     The prefix mt_ is automatically added before each mission-template id
#
#  2) Mission-template flags (int): See header_mission-templates.py for a list of available flags
#  3) Mission-type(int): Which mission types this mission template matches.
#     For mission-types to be used with the default party-meeting system,
#     this should be 'charge' or 'charge_with_ally' otherwise must be -1.
#     
#  4) Mission description text (string).
#  5) List of spawn records (list): Each spawn record is a tuple that contains the following fields:
#    5.1) entry-no: Troops spawned from this spawn record will use this entry
#    5.2) spawn flags. 
#    5.3) alter flags. which equipment will be overriden
#    5.4) ai flags.
#    5.5) Number of troops to spawn.
#    5.6) list of equipment to add to troops spawned from here (maximum 8).
#  6) List of triggers (list).
#     See module_triggers.py for infomation about triggers.
#
#  Please note that mission templates is work in progress and can be changed in the future versions.
# 
####################################################################################################################

pilgrim_disguise = [itm_pilgrim_hood,itm_pilgrim_disguise,itm_practice_staff, itm_throwing_daggers]
#af_castle_lord = af_override_horse | af_override_weapons| af_require_civilian
af_castle_lord = af_override_horse 
mission_templates_defined=1
mission_templates = [
  (
    "town_default",0,-1,
    "Default town visit",
    [(0,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (1,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),(2,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),(3,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),(4,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),(5,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),(6,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),(7,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (8,mtef_scene_source,af_override_horse,0,1,[]),(9,mtef_scene_source,af_override_horse,0,1,[]),(10,mtef_scene_source,af_override_horse,0,1,[]),(11,mtef_scene_source,af_override_horse,0,1,[]),
     (12,mtef_scene_source,af_override_horse,0,1,[]),(13,mtef_scene_source,0,0,1,[]),(14,mtef_scene_source,0,0,1,[]),(15,mtef_scene_source,0,0,1,[]),
     (16,mtef_visitor_source,af_override_horse,0,1,[]),(17,mtef_visitor_source,af_override_horse,0,1,[]),(18,mtef_visitor_source,af_override_horse,0,1,[]),(19,mtef_visitor_source,af_override_horse,0,1,[]),(20,mtef_visitor_source,af_override_horse,0,1,[]),(21,mtef_visitor_source,af_override_horse,0,1,[]),(22,mtef_visitor_source,af_override_horse,0,1,[]),(23,mtef_visitor_source,af_override_horse,0,1,[]),(24,mtef_visitor_source,af_override_horse,0,1,[]),
     (25,mtef_visitor_source,af_override_horse,0,1,[]),(26,mtef_visitor_source,af_override_horse,0,1,[]),(27,mtef_visitor_source,af_override_horse,0,1,[]),(28,mtef_visitor_source,af_override_horse,0,1,[]),(29,mtef_visitor_source,af_override_horse,0,1,[]),(30,mtef_visitor_source,af_override_horse,0,1,[]),(31,mtef_visitor_source,af_override_horse,0,1,[])
     ],
    [
      (1, 0, ti_once, [], [
          (store_current_scene, ":cur_scene"),
          (scene_set_slot, ":cur_scene", slot_scene_visited, 1),
        ]),
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
      (ti_inventory_key_pressed, 0, 0, [(set_trigger_result,1)], []),
      (ti_tab_pressed, 0, 0, [(set_trigger_result,1)], []),
    ],
  ),

# This template is used in party encounters and such.
# 
  (
    "conversation_encounter",0,-1,
    "Conversation_encounter",
    [( 0,mtef_visitor_source,af_override_fullhelm,0,1,[]),( 1,mtef_visitor_source,af_override_fullhelm,0,1,[]),
     ( 2,mtef_visitor_source,af_override_fullhelm,0,1,[]),( 3,mtef_visitor_source,af_override_fullhelm,0,1,[]),( 4,mtef_visitor_source,af_override_fullhelm,0,1,[]),( 5,mtef_visitor_source,af_override_fullhelm,0,1,[]),( 6,mtef_visitor_source,af_override_fullhelm,0,1,[]),
     ( 7,mtef_visitor_source,af_override_fullhelm,0,1,[]),( 8,mtef_visitor_source,af_override_fullhelm,0,1,[]),( 9,mtef_visitor_source,af_override_fullhelm,0,1,[]),(10,mtef_visitor_source,af_override_fullhelm,0,1,[]),(11,mtef_visitor_source,af_override_fullhelm,0,1,[]),
    #prisoners now...
     (12,mtef_visitor_source,af_override_fullhelm,0,1,[]),(13,mtef_visitor_source,af_override_fullhelm,0,1,[]),(14,mtef_visitor_source,af_override_fullhelm,0,1,[]),(15,mtef_visitor_source,af_override_fullhelm,0,1,[]),(16,mtef_visitor_source,af_override_fullhelm,0,1,[]),
    #Other party
     (17,mtef_visitor_source,af_override_fullhelm,0,1,[]),(18,mtef_visitor_source,af_override_fullhelm,0,1,[]),(19,mtef_visitor_source,af_override_fullhelm,0,1,[]),(20,mtef_visitor_source,af_override_fullhelm,0,1,[]),(21,mtef_visitor_source,af_override_fullhelm,0,1,[]),
     (22,mtef_visitor_source,af_override_fullhelm,0,1,[]),(23,mtef_visitor_source,af_override_fullhelm,0,1,[]),(24,mtef_visitor_source,af_override_fullhelm,0,1,[]),(25,mtef_visitor_source,af_override_fullhelm,0,1,[]),(26,mtef_visitor_source,af_override_fullhelm,0,1,[]),
     (27,mtef_visitor_source,af_override_fullhelm,0,1,[]),(28,mtef_visitor_source,af_override_fullhelm,0,1,[]),(29,mtef_visitor_source,af_override_fullhelm,0,1,[]),(30,mtef_visitor_source,af_override_fullhelm,0,1,[]),(31,mtef_visitor_source,af_override_fullhelm,0,1,[]),
     ],
    [],
  ),
  
#----------------------------------------------------------------
#mission templates before this point are hardwired into the game.
#-----------------------------------------------------------------

  (
    "town_center",0,-1,
    "Default town visit",
    [(0,mtef_scene_source|mtef_team_0,0,0,1,[]),
     (1,mtef_scene_source|mtef_team_0,0,0,1,[]),
     (2,mtef_scene_source|mtef_team_0,0,0,1,[]),
     (3,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (4,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (5,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (6,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (7,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     
     (8,mtef_scene_source,af_override_horse,0,1,[]),
     (9,mtef_scene_source,af_override_horse,0,1,[]),(10,mtef_scene_source,af_override_horse,0,1,[]),(11,mtef_scene_source,af_override_horse,0,1,[]),(12,mtef_scene_source,af_override_horse,0,1,[]),(13,mtef_scene_source,0,0,1,[]),(14,mtef_scene_source,0,0,1,[]),(15,mtef_scene_source,0,0,1,[]),
     (16,mtef_visitor_source,af_override_horse,0,1,[]),(17,mtef_visitor_source,af_override_horse,0,1,[]),(18,mtef_visitor_source,af_override_horse,0,1,[]),(19,mtef_visitor_source,af_override_horse,0,1,[]),(20,mtef_visitor_source,af_override_horse,0,1,[]),(21,mtef_visitor_source,af_override_horse,0,1,[]),(22,mtef_visitor_source,af_override_horse,0,1,[]),(23,mtef_visitor_source,af_override_horse,0,1,[]),
     (24,mtef_visitor_source,af_override_horse,0,1,[]),(25,mtef_visitor_source,af_override_horse,0,1,[]),(26,mtef_visitor_source,af_override_horse,0,1,[]),(27,mtef_visitor_source,af_override_horse,0,1,[]),(28,mtef_visitor_source,af_override_horse,0,1,[]),(29,mtef_visitor_source,af_override_horse,0,1,[]),(30,mtef_visitor_source,af_override_horse,0,1,[]),(31,mtef_visitor_source,af_override_horse,0,1,[]),
     (32,mtef_visitor_source,af_override_horse,0,1,[]),(33,mtef_visitor_source,af_override_horse,0,1,[]),(34,mtef_visitor_source,af_override_horse,0,1,[]),(35,mtef_visitor_source,af_override_horse,0,1,[]),(36,mtef_visitor_source,af_override_horse,0,1,[]),(37,mtef_visitor_source,af_override_horse,0,1,[]),(38,mtef_visitor_source,af_override_horse,0,1,[]),(39,mtef_visitor_source,af_override_horse,0,1,[]),
     (40,mtef_visitor_source,af_override_horse,0,1,[]),(41,mtef_visitor_source,af_override_horse,0,1,[]),(42,mtef_visitor_source,af_override_horse,0,1,[]),(43,mtef_visitor_source,af_override_horse,0,1,[]),(44,mtef_visitor_source,af_override_horse,0,1,[]),(45,mtef_visitor_source,af_override_horse,0,1,[]),(46,mtef_visitor_source,af_override_horse,0,1,[]),(47,mtef_visitor_source,af_override_horse,0,1,[]),
     ],
    [ #SG_Armor_Effect
(0.0, 0, 0.0,
   [
    (assign,"$n_armor",0),  
    (assign,"$h_armor",0),  
    (try_for_range,":armor",normal_armor_begin,normal_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$n_armor",1),
    (try_end),
    (try_for_range,":armor",heavy_armor_begin,heavy_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$h_armor",1),
    (try_end),
    (this_or_next|eq,"$n_armor",0),
    (eq,"$h_armor",0),
    ],
   [
    (try_begin),
       (eq,"$n_armor",0),
       (assign,"$n_armor_eq",0),
    (try_end),
    (try_begin),
       (eq,"$h_armor",0),
       (assign,"$h_armor_eq",0),
    (try_end),
     ]),


  #
  (0.0, 0, 0.0,
   [(eq,"$n_armor_eq",0),(eq,"$n_armor_eft",0),(eq,"$h_armor_eft",0),
    (eq,"$know_na",0),
    (try_for_range,":armor",normal_armor_begin,normal_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$n_armor",1),
    (try_end),
    (eq,"$n_armor",1),
    ],
   [
    (assign,"$n_armor_eq",1),
    (store_skill_level,"$rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$ha_lv",skl_horse_archery,"trp_player"),

    (troop_raise_skill,"trp_player",skl_riding,-1),
    (troop_raise_skill,"trp_player",skl_power_draw,-1),
    (troop_raise_skill,"trp_player",skl_horse_archery,-2),
    (assign,"$n_armor_eft",1),

    (store_skill_level,"$new_rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$new_pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$new_ha_lv",skl_horse_archery,"trp_player"),
    ]),

  #
  (0.0, 0, 0.0,
   [(eq,"$h_armor_eq",0),(eq,"$h_armor_eft",0),(eq,"$n_armor_eft",0),
    (eq,"$know_ha",0),
    (try_for_range,":armor",heavy_armor_begin,heavy_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$h_armor",1),
    (try_end),
    (eq,"$h_armor",1),
    ],
   [
    (assign,"$h_armor_eq",1),
    (store_skill_level,"$rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$ha_lv",skl_horse_archery,"trp_player"),

    (troop_raise_skill,"trp_player",skl_riding,-2),
    (troop_raise_skill,"trp_player",skl_power_draw,-2),
    (troop_raise_skill,"trp_player",skl_horse_archery,-4),
    (assign,"$h_armor_eft",1),

    (store_skill_level,"$new_rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$new_pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$new_ha_lv",skl_horse_archery,"trp_player"),
    ]),

##
  (0.0, 0, 0.0,
   [(eq,"$n_armor_eq",0),(eq,"$n_armor_eft",0),(eq,"$h_armor_eft",0),
    (eq,"$know_na",1),
    #(eq,"$know_ha",0),
    (try_for_range,":armor",normal_armor_begin,normal_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$n_armor",1),
    (try_end),
    (eq,"$n_armor",1),
    ],
   [
    (assign,"$n_armor_eq",1),
    (store_skill_level,"$rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$ha_lv",skl_horse_archery,"trp_player"),

    (troop_raise_skill,"trp_player",skl_horse_archery,-1),
    (assign,"$n_armor_eft",1),

    (store_skill_level,"$new_rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$new_pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$new_ha_lv",skl_horse_archery,"trp_player"),
    ]),

##
  (0.0, 0, 0.0,
   [(eq,"$h_armor_eq",0),(eq,"$h_armor_eft",0),(eq,"$n_armor_eft",0),
   # (eq,"$know_na",0),
    (eq,"$know_ha",1),
    (try_for_range,":armor",heavy_armor_begin,heavy_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$h_armor",1),
    (try_end),
    (eq,"$h_armor",1),
    ],
   [
    (assign,"$h_armor_eq",1),
    (store_skill_level,"$rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$ha_lv",skl_horse_archery,"trp_player"),

    (troop_raise_skill,"trp_player",skl_riding,-1),
    (troop_raise_skill,"trp_player",skl_power_draw,-1),
    (troop_raise_skill,"trp_player",skl_horse_archery,-3),
    (assign,"$h_armor_eft",1),

    (store_skill_level,"$new_rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$new_pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$new_ha_lv",skl_horse_archery,"trp_player"),
    ]),

##
  (0.0, 0, 0.0,
   [(eq,"$n_armor_eft",1),(eq,"$n_armor_eq",0),
    ],
   [
    (store_sub,":return_rid","$rid_lv","$new_rid_lv"),
    (store_sub,":return_pd","$pd_lv","$new_pd_lv"),
    (store_sub,":return_ha","$ha_lv","$new_ha_lv"),
    (troop_raise_skill,"trp_player",skl_riding,":return_rid"),
    (troop_raise_skill,"trp_player",skl_power_draw,":return_pd"),
    (troop_raise_skill,"trp_player",skl_horse_archery,":return_ha"),
    (assign,"$n_armor_eft",0),
    ]),

##
  (0.0, 0, 0.0,
   [(eq,"$h_armor_eft",1),(eq,"$h_armor_eq",0),
    ],
   [
    (store_sub,":return_rid","$rid_lv","$new_rid_lv"),
    (store_sub,":return_pd","$pd_lv","$new_pd_lv"),
    (store_sub,":return_ha","$ha_lv","$new_ha_lv"),
    (troop_raise_skill,"trp_player",skl_riding,":return_rid"),
    (troop_raise_skill,"trp_player",skl_power_draw,":return_pd"),
    (troop_raise_skill,"trp_player",skl_horse_archery,":return_ha"),
    (assign,"$h_armor_eft",0),
    ]),


  (0.0, 0, 0.0, [(eq,"$know_sa",0)], [(try_for_range,":armor",special_armor_begin,special_armor_end),
                                      (troop_has_item_equipped,"trp_player",":armor"),
                                      (troop_remove_item,"trp_player",":armor"),
                                      (troop_set_inventory_slot,"trp_player",17,":armor"),
                                    (try_end),]),
      (1, 0, ti_once, [], [
          (store_current_scene, ":cur_scene"),
          (scene_set_slot, ":cur_scene", slot_scene_visited, 1),
          (call_script, "script_init_town_walker_agents"),
        ]),
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
      (ti_inventory_key_pressed, 0, 0, [(set_trigger_result,1)], []),
      (ti_tab_pressed, 0, 0, [(set_trigger_result,1)], []),
      (ti_on_leave_area, 0, 0, [
          (try_begin),
            (eq, "$g_defending_against_siege", 0),
            (assign,"$g_leave_town",1),
          (try_end),
          ], []),      
      (3, 0, 0, [(call_script, "script_tick_town_walkers")], []),
    ],
  ),


  (
    "town_disguised",0,-1,
    "Default town visit",
    [(0,mtef_scene_source,af_override_all,0,1,pilgrim_disguise),
     (1,mtef_scene_source,af_override_all,0,1,pilgrim_disguise),
     (2,mtef_scene_source,af_override_all,0,1,pilgrim_disguise),
     (3,mtef_scene_source,af_override_all,0,1,pilgrim_disguise),
     (4,mtef_scene_source,af_override_all,0,1,pilgrim_disguise),
     (5,mtef_scene_source,af_override_all,0,1,pilgrim_disguise),
     (6,mtef_scene_source,af_override_all,0,1,pilgrim_disguise),
     (7,mtef_scene_source,af_override_all,0,1,pilgrim_disguise),
     
     #Entries below this are identical to "town_center"
     (8,mtef_scene_source,af_override_horse,0,1,[]),
     (9,mtef_scene_source,af_override_horse,0,1,[]),(10,mtef_scene_source,af_override_horse,0,1,[]),(11,mtef_scene_source,af_override_horse,0,1,[]),(12,mtef_scene_source,af_override_horse,0,1,[]),(13,mtef_scene_source,0,0,1,[]),(14,mtef_scene_source,0,0,1,[]),(15,mtef_scene_source,0,0,1,[]),
     (16,mtef_visitor_source,af_override_horse,0,1,[]),(17,mtef_visitor_source,af_override_horse,0,1,[]),(18,mtef_visitor_source,af_override_horse,0,1,[]),(19,mtef_visitor_source,af_override_horse,0,1,[]),(20,mtef_visitor_source,af_override_horse,0,1,[]),(21,mtef_visitor_source,af_override_horse,0,1,[]),(22,mtef_visitor_source,af_override_horse,0,1,[]),(23,mtef_visitor_source,af_override_horse,0,1,[]),
     (24,mtef_visitor_source,af_override_horse,0,1,[]),(25,mtef_visitor_source,af_override_horse,0,1,[]),(26,mtef_visitor_source,af_override_horse,0,1,[]),(27,mtef_visitor_source,af_override_horse,0,1,[]),(28,mtef_visitor_source,af_override_horse,0,1,[]),(29,mtef_visitor_source,af_override_horse,0,1,[]),(30,mtef_visitor_source,af_override_horse,0,1,[]),(31,mtef_visitor_source,af_override_horse,0,1,[]),
     (32,mtef_visitor_source,af_override_horse,0,1,[]),(33,mtef_visitor_source,af_override_horse,0,1,[]),(34,mtef_visitor_source,af_override_horse,0,1,[]),(35,mtef_visitor_source,af_override_horse,0,1,[]),(36,mtef_visitor_source,af_override_horse,0,1,[]),(37,mtef_visitor_source,af_override_horse,0,1,[]),(38,mtef_visitor_source,af_override_horse,0,1,[]),(39,mtef_visitor_source,af_override_horse,0,1,[]),
     (40,mtef_visitor_source,af_override_horse,0,1,[]),(41,mtef_visitor_source,af_override_horse,0,1,[]),(42,mtef_visitor_source,af_override_horse,0,1,[]),(43,mtef_visitor_source,af_override_horse,0,1,[]),(44,mtef_visitor_source,af_override_horse,0,1,[]),(45,mtef_visitor_source,af_override_horse,0,1,[]),(46,mtef_visitor_source,af_override_horse,0,1,[]),(47,mtef_visitor_source,af_override_horse,0,1,[]),
     ],
    [
        (1, 0, ti_once, [], [
          (call_script, "script_init_town_walker_agents"),
        ]),
      (ti_tab_pressed, 0, 0, [(set_trigger_result,1)], []),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_disguised")], []),
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
      (5, 0, 0, [(call_script, "script_tick_town_walkers")], []),
    ],
  ),
  
  (
    "village_center",0,-1,
    "village center",
    [(0,mtef_scene_source|mtef_team_0,0,0,1,[]),
     (1,mtef_scene_source|mtef_team_0,0,0,1,[]),
     (2,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (3,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (4,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (5,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (6,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (7,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     
     (8,mtef_scene_source,af_override_horse,0,1,[]),
     (9,mtef_scene_source,af_override_horse,0,1,[]),(10,mtef_scene_source,af_override_horse,0,1,[]),(11,mtef_scene_source,af_override_horse,0,1,[]),(12,mtef_scene_source,af_override_horse,0,1,[]),(13,mtef_scene_source,0,0,1,[]),(14,mtef_scene_source,0,0,1,[]),(15,mtef_scene_source,0,0,1,[]),
     (16,mtef_visitor_source,af_override_horse,0,1,[]),(17,mtef_visitor_source,af_override_horse,0,1,[]),(18,mtef_visitor_source,af_override_horse,0,1,[]),(19,mtef_visitor_source,af_override_horse,0,1,[]),(20,mtef_visitor_source,af_override_horse,0,1,[]),(21,mtef_visitor_source,af_override_horse,0,1,[]),(22,mtef_visitor_source,af_override_horse,0,1,[]),(23,mtef_visitor_source,af_override_horse,0,1,[]),
     (24,mtef_visitor_source,af_override_horse,0,1,[]),(25,mtef_visitor_source,af_override_horse,0,1,[]),(26,mtef_visitor_source,af_override_horse,0,1,[]),(27,mtef_visitor_source,af_override_horse,0,1,[]),(28,mtef_visitor_source,af_override_horse,0,1,[]),(29,mtef_visitor_source,af_override_horse,0,1,[]),(30,mtef_visitor_source,af_override_horse,0,1,[]),(31,mtef_visitor_source,af_override_horse,0,1,[]),
     (32,mtef_visitor_source,af_override_horse,0,1,[]),(33,mtef_visitor_source,af_override_horse,0,1,[]),(34,mtef_visitor_source,af_override_horse,0,1,[]),(35,mtef_visitor_source,af_override_horse,0,1,[]),(36,mtef_visitor_source,af_override_horse,0,1,[]),(37,mtef_visitor_source,af_override_horse,0,1,[]),(38,mtef_visitor_source,af_override_horse,0,1,[]),(39,mtef_visitor_source,af_override_horse,0,1,[]),
     (40,mtef_visitor_source,af_override_horse,0,1,[]),(41,mtef_visitor_source,af_override_horse,0,1,[]),(42,mtef_visitor_source,af_override_horse,0,1,[]),(43,mtef_visitor_source,af_override_horse,0,1,[]),(44,mtef_visitor_source,af_override_horse,0,1,[]),(45,mtef_visitor_source,af_override_horse,0,1,[]),(46,mtef_visitor_source,af_override_horse,0,1,[]),(47,mtef_visitor_source,af_override_horse,0,1,[]),
     ],
    [
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
      (ti_inventory_key_pressed, 0, 0, [(set_trigger_result,1)], []),
      (ti_tab_pressed, 0, 0, [(set_trigger_result,1)], []),
      (ti_on_leave_area, 0, 0, [
            (assign,"$g_leave_town",1),
          ], []),      
    ],
  ),

  
  (
    "visit_town_castle",0,-1,
    "You enter the halls of the lord.",
    [(0,mtef_scene_source|mtef_team_0,af_override_horse|af_override_weapons|af_override_head,0,1,[]),
     (1,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),(2,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),(3,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),(4,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),(5,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),(6,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),(7,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (8,mtef_scene_source,af_override_horse,0,1,[]),(9,mtef_scene_source,af_override_horse,0,1,[]),(10,mtef_scene_source,af_override_horse,0,1,[]),(11,mtef_scene_source,af_override_horse,0,1,[]),
     (12,mtef_visitor_source,af_override_horse,0,1,[]),(13,mtef_visitor_source,0,0,1,[]),(14,mtef_visitor_source,0,0,1,[]),(15,mtef_visitor_source,0,0,1,[]),
     (16,mtef_visitor_source,af_override_horse,0,1,[]),(17,mtef_visitor_source,af_castle_lord,0,1,[]),(18,mtef_visitor_source,af_castle_lord,0,1,[]),(19,mtef_visitor_source,af_castle_lord,0,1,[]),(20,mtef_visitor_source,af_castle_lord,0,1,[]),(21,mtef_visitor_source,af_castle_lord,0,1,[]),(22,mtef_visitor_source,af_castle_lord,0,1,[]),(23,mtef_visitor_source,af_castle_lord,0,1,[]),(24,mtef_visitor_source,af_castle_lord,0,1,[]),
#     (16,mtef_visitor_source,af_castle_lord,0,1,[]),(17,mtef_visitor_source,af_castle_lord,0,1,[]),(18,mtef_visitor_source,af_castle_lord,0,1,[]),(19,mtef_visitor_source,af_castle_lord,0,1,[]),(20,mtef_visitor_source,af_castle_lord,0,1,[]),(21,mtef_visitor_source,af_castle_lord,0,1,[]),(22,mtef_visitor_source,af_castle_lord,0,1,[]),(23,mtef_visitor_source,af_castle_lord,0,1,[]),(24,mtef_visitor_source,af_castle_lord,0,1,[]),
     (25,mtef_visitor_source,af_castle_lord,0,1,[]),(26,mtef_visitor_source,af_castle_lord,0,1,[]),(27,mtef_visitor_source,af_castle_lord,0,1,[]),(28,mtef_visitor_source,af_castle_lord,0,1,[]),(29,mtef_visitor_source,af_castle_lord,0,1,[]),(30,mtef_visitor_source,af_castle_lord,0,1,[]),(31,mtef_visitor_source,af_castle_lord,0,1,[])
     ],
    [
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
      (ti_inventory_key_pressed, 0, 0, [(set_trigger_result,1)], []),
      (ti_tab_pressed, 0, 0, [(set_trigger_result,1)], []),
      (0, 0, ti_once, [], [(set_fog_distance, 150, 0xFF736252)]),
    ],
  ),
  
  (
    "visit_town_arena",0,-1,
    "You enter the arena",
    [(0,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (50,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),(51,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (52,mtef_scene_source,af_override_horse,0,1,[]),(53,mtef_scene_source,af_override_horse,0,1,[]),(54,mtef_scene_source,af_override_horse,0,1,[]),(55,mtef_scene_source,af_override_horse,0,1,[]),(56,mtef_scene_source,af_override_horse,0,1,[]),
     (57,mtef_scene_source,af_override_horse,0,1,[]),(58,mtef_scene_source,af_override_horse,0,1,[]),(59,mtef_scene_source,af_override_horse,0,1,[]),(60,mtef_scene_source,af_override_horse,0,1,[]),(61,mtef_scene_source,af_override_horse,0,1,[]),(62,mtef_scene_source,af_override_horse,0,1,[]),(63,mtef_scene_source,af_override_horse,0,1,[])
     ],
    [
      (1, 0, ti_once, [], [
          (store_current_scene, reg(1)),
          (scene_set_slot, reg(1), slot_scene_visited, 1),
        ]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_arena")], []),
      (ti_tab_pressed, 0, 0, [(set_trigger_result,1)], []),
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
    ],
  ),
  (
    "visit_town_arena_disguised",0,-1,
    "You enter the arena",
    [(0,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (50,mtef_scene_source|mtef_team_0,af_override_all,0,1,pilgrim_disguise),(51,mtef_scene_source|mtef_team_0,af_override_horse,0,1,[]),
     (52,mtef_scene_source,af_override_horse,0,1,[]),(53,mtef_scene_source,af_override_horse,0,1,[]),(54,mtef_scene_source,af_override_horse,0,1,[]),(55,mtef_scene_source,af_override_horse,0,1,[]),(56,mtef_scene_source,af_override_horse,0,1,[]),
     (57,mtef_scene_source,af_override_horse,0,1,[]),(58,mtef_scene_source,af_override_horse,0,1,[]),(59,mtef_scene_source,af_override_horse,0,1,[]),(60,mtef_scene_source,af_override_horse,0,1,[]),(61,mtef_scene_source,af_override_horse,0,1,[]),(62,mtef_scene_source,af_override_horse,0,1,[]),(63,mtef_scene_source,af_override_horse,0,1,[])
     ],
    [
      (1, 0, ti_once, [], [
          (store_current_scene, reg(1)),
          (scene_set_slot, reg(1), slot_scene_visited, 1),
        ]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_disguised")], []),
      (ti_tab_pressed, 0, 0, [(set_trigger_result,1)], []),
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
    ],
  ),

##### TODO: QUESTS COMMENT OUT BEGIN
##  (
##    "back_alley_battle",mtf_arena_fight,-1,
##    "You enter the back alley",
##    [
##      (0,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[]),
##      (1,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
##    ],
##    [
##      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_now")], []),
##      (ti_tab_pressed, 0, 0, [(display_message,"str_cant_leave_now")], []),
##      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
##
##      (0, 0, ti_once, [
##          (store_mission_timer_a,":cur_time"),
##          (ge,":cur_time",1), 
##          (assign, ":merchant_hp", 0),
##          (assign, ":player_hp", 0),
##          (assign, ":merchant_hp", 0),
##          (assign, ":merchant_agent", -1),
##          (assign, ":player_agent", -1),
##          (try_for_agents, ":agent_no"),
##            (agent_get_troop_id, ":troop_id", ":agent_no"),
##            (try_begin),
##              (eq, ":troop_id", "trp_local_merchant"),
##              (store_agent_hit_points, ":merchant_hp",":agent_no"),
##              (assign, ":merchant_agent", ":agent_no"),
##            (else_try),
##              (eq, ":troop_id", "trp_player"),
##              (store_agent_hit_points, ":player_hp",":agent_no"),
##              (assign, ":player_agent", ":agent_no"),
##            (try_end),
##          (try_end),
##          (agent_is_alive, ":player_agent"),
##          (agent_is_alive, ":merchant_agent"),
##          (is_between, ":merchant_hp", 1, 30),
##          (gt, ":player_hp", 50),
##          (start_mission_conversation, "trp_local_merchant"),
##          ], []),
##      
##      (1, 4, ti_once, [(this_or_next|main_hero_fallen),(num_active_teams_le,1)],
##       [
##           (try_begin),
##             (main_hero_fallen),
##             (fail_quest, "qst_kill_local_merchant"),
##           (else_try),
##             (succeed_quest, "qst_kill_local_merchant"),
##           (try_end),
##           (try_begin),
##             (eq, "$sneaked_into_town",1),
##             (assign,":cur_mission_template","mt_town_disguised"),
##           (else_try),
##             (assign,":cur_mission_template","mt_town_default"),
##           (try_end),
##           (set_jump_mission,":cur_mission_template"),
##           (party_get_slot, ":cur_town_center", "$current_town", slot_town_center),
##           (set_jump_entry, 0),
##           (jump_to_scene,":cur_town_center"),
##           ]),
##    ],
##  ),
##
##  (
##    "arena_duel",mtf_arena_fight|mtf_commit_casualties,-1,
##    "You enter the arena",
##    [
##      (0,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[]),
##      (1,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield]),
##      (2,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[]),
##      (3,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[]),
##      (4,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield]),
##      (5,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield]),
##      (6,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield]),
##      (7,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield]),
##      (8,mtef_visitor_source|mtef_team_1,af_override_horse|af_override_weapons,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield]),
##    ],
##    [
##      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_now")], []),
##      (ti_tab_pressed, 0, 0, [(display_message,"str_cant_leave_now")], []),
##      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
##
##      (1, 4, ti_once, [(this_or_next|main_hero_fallen),(num_active_teams_le,1)],
##       [
##           (try_begin),
##             (main_hero_fallen),
##             (fail_quest, "qst_duel_for_lady"),
##           (else_try),
##             (succeed_quest, "qst_duel_for_lady"),
##           (try_end),
##           (finish_mission),
##           ]),
##    ],
##  ),
##### TODO: QUESTS COMMENT OUT END

  (
    "lead_charge",mtf_battle_mode,charge,
    "You lead your men to battle.",
    [
     (1,mtef_defenders|mtef_team_0,0,aif_start_alarmed,12,[]),
     (0,mtef_defenders|mtef_team_0,0,aif_start_alarmed,0,[]),
     (4,mtef_attackers|mtef_team_1,0,aif_start_alarmed,12,[]),
     (4,mtef_attackers|mtef_team_1,0,aif_start_alarmed,0,[]),

     (1,mtef_attackers|mtef_team_1,0,aif_start_alarmed,0,[]),
     (4,mtef_defenders|mtef_team_0,0,aif_start_alarmed,0,[]),
     (2,mtef_attackers|mtef_team_1|mtef_cavalry_first,0,aif_start_alarmed,0,[]),
     (2,mtef_defenders|mtef_team_0|mtef_cavalry_first,0,aif_start_alarmed,0,[]),
     (5,mtef_attackers|mtef_team_1|mtef_cavalry_first,0,aif_start_alarmed,0,[]),
     (5,mtef_defenders|mtef_team_0|mtef_cavalry_first,0,aif_start_alarmed,0,[]),
#     (1,mtef_enemy_party,0,aif_start_alarmed,0,[]),
#     (4,mtef_enemy_party,0,aif_start_alarmed,0,[]),
     ],
    [
    #SG_Armor_Effect
(0.0, 0, 0.0,
   [
    (assign,"$n_armor",0),  
    (assign,"$h_armor",0),  
    (try_for_range,":armor",normal_armor_begin,normal_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$n_armor",1),
    (try_end),
    (try_for_range,":armor",heavy_armor_begin,heavy_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$h_armor",1),
    (try_end),
    (this_or_next|eq,"$n_armor",0),
    (eq,"$h_armor",0),
    ],
   [
    (try_begin),
       (eq,"$n_armor",0),
       (assign,"$n_armor_eq",0),
    (try_end),
    (try_begin),
       (eq,"$h_armor",0),
       (assign,"$h_armor_eq",0),
    (try_end),
     ]),
  #
  (0.0, 0, 0.0,
   [(eq,"$n_armor_eq",0),(eq,"$n_armor_eft",0),(eq,"$h_armor_eft",0),
    (eq,"$know_na",0),
    (try_for_range,":armor",normal_armor_begin,normal_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$n_armor",1),
    (try_end),
    (eq,"$n_armor",1),
    ],
   [
    (assign,"$n_armor_eq",1),
    (store_skill_level,"$rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$ha_lv",skl_horse_archery,"trp_player"),

    (troop_raise_skill,"trp_player",skl_riding,-1),
    (troop_raise_skill,"trp_player",skl_power_draw,-1),
    (troop_raise_skill,"trp_player",skl_horse_archery,-2),
    (assign,"$n_armor_eft",1),

    (store_skill_level,"$new_rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$new_pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$new_ha_lv",skl_horse_archery,"trp_player"),
    ]),
  #
  (0.0, 0, 0.0,
   [(eq,"$h_armor_eq",0),(eq,"$h_armor_eft",0),(eq,"$n_armor_eft",0),
    (eq,"$know_ha",0),
    (try_for_range,":armor",heavy_armor_begin,heavy_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$h_armor",1),
    (try_end),
    (eq,"$h_armor",1),
    ],
   [
    (assign,"$h_armor_eq",1),
    (store_skill_level,"$rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$ha_lv",skl_horse_archery,"trp_player"),

    (troop_raise_skill,"trp_player",skl_riding,-2),
    (troop_raise_skill,"trp_player",skl_power_draw,-2),
    (troop_raise_skill,"trp_player",skl_horse_archery,-4),
    (assign,"$h_armor_eft",1),

    (store_skill_level,"$new_rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$new_pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$new_ha_lv",skl_horse_archery,"trp_player"),
    ]),
##
  (0.0, 0, 0.0,
   [(eq,"$n_armor_eq",0),(eq,"$n_armor_eft",0),(eq,"$h_armor_eft",0),
    (eq,"$know_na",1),
    #(eq,"$know_ha",0),
    (try_for_range,":armor",normal_armor_begin,normal_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$n_armor",1),
    (try_end),
    (eq,"$n_armor",1),
    ],
   [
    (assign,"$n_armor_eq",1),
    (store_skill_level,"$rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$ha_lv",skl_horse_archery,"trp_player"),

    (troop_raise_skill,"trp_player",skl_horse_archery,-1),
    (assign,"$n_armor_eft",1),

    (store_skill_level,"$new_rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$new_pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$new_ha_lv",skl_horse_archery,"trp_player"),
    ]),
##
  (0.0, 0, 0.0,
   [(eq,"$h_armor_eq",0),(eq,"$h_armor_eft",0),(eq,"$n_armor_eft",0),
   # (eq,"$know_na",0),
    (eq,"$know_ha",1),
    (try_for_range,":armor",heavy_armor_begin,heavy_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$h_armor",1),
    (try_end),
    (eq,"$h_armor",1),
    ],
   [
    (assign,"$h_armor_eq",1),
    (store_skill_level,"$rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$ha_lv",skl_horse_archery,"trp_player"),

    (troop_raise_skill,"trp_player",skl_riding,-1),
    (troop_raise_skill,"trp_player",skl_power_draw,-1),
    (troop_raise_skill,"trp_player",skl_horse_archery,-3),
    (assign,"$h_armor_eft",1),

    (store_skill_level,"$new_rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$new_pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$new_ha_lv",skl_horse_archery,"trp_player"),
    ]),
##
  (0.0, 0, 0.0,
   [(eq,"$n_armor_eft",1),(eq,"$n_armor_eq",0),
    ],
   [
    (store_sub,":return_rid","$rid_lv","$new_rid_lv"),
    (store_sub,":return_pd","$pd_lv","$new_pd_lv"),
    (store_sub,":return_ha","$ha_lv","$new_ha_lv"),
    (troop_raise_skill,"trp_player",skl_riding,":return_rid"),
    (troop_raise_skill,"trp_player",skl_power_draw,":return_pd"),
    (troop_raise_skill,"trp_player",skl_horse_archery,":return_ha"),
    (assign,"$n_armor_eft",0),

    (store_attribute_level,":str","trp_player",ca_strength),
    (store_attribute_level,":agi","trp_player",ca_agility),
    (store_div,":max_pd",":str",3),
    (store_div,":max_r_a",":agi",3),
    (store_skill_level,":rid",skl_riding,"trp_player"),
    (store_skill_level,":pd",skl_power_draw,"trp_player"),
    (store_skill_level,":ha",skl_horse_archery,"trp_player"),
    (try_begin),
       (gt,":pd",":max_pd"),
       (val_sub,":max_pd",":pd"),
       (troop_raise_skill,"trp_player",skl_power_draw,":max_pd"),
       (val_sub,"$comp_points",":max_pd"),
    (try_end),
    (try_begin),
       (gt,":rid",":max_r_a"),
       (store_sub,":x",":max_r_a",":rid"),
       (troop_raise_skill,"trp_player",skl_riding,":x"),
       (val_sub,"$comp_points",":x"),
    (try_end),
    (try_begin),
       (gt,":ha",":max_r_a"),
       (store_sub,":x",":max_r_a",":ha"),
       (troop_raise_skill,"trp_player",skl_horse_archery,":x"),
       (val_sub,"$comp_points",":x"),
    (try_end),
    ]),
##
  (0.0, 0, 0.0,
   [(eq,"$h_armor_eft",1),(eq,"$h_armor_eq",0),
    ],
   [
    (store_sub,":return_rid","$rid_lv","$new_rid_lv"),
    (store_sub,":return_pd","$pd_lv","$new_pd_lv"),
    (store_sub,":return_ha","$ha_lv","$new_ha_lv"),
    (troop_raise_skill,"trp_player",skl_riding,":return_rid"),
    (troop_raise_skill,"trp_player",skl_power_draw,":return_pd"),
    (troop_raise_skill,"trp_player",skl_horse_archery,":return_ha"),
    (assign,"$h_armor_eft",0),

    (store_attribute_level,":str","trp_player",ca_strength),
    (store_attribute_level,":agi","trp_player",ca_agility),
    (store_div,":max_pd",":str",3),
    (store_div,":max_r_a",":agi",3),
    (store_skill_level,":rid",skl_riding,"trp_player"),
    (store_skill_level,":pd",skl_power_draw,"trp_player"),
    (store_skill_level,":ha",skl_horse_archery,"trp_player"),
    (try_begin),
       (gt,":pd",":max_pd"),
       (val_sub,":max_pd",":pd"),
       (troop_raise_skill,"trp_player",skl_power_draw,":max_pd"),
       (val_sub,"$comp_points",":max_pd"),
    (try_end),
    (try_begin),
       (gt,":rid",":max_r_a"),
       (store_sub,":x",":max_r_a",":rid"),
       (troop_raise_skill,"trp_player",skl_riding,":x"),
       (val_sub,"$comp_points",":x"),
    (try_end),
    (try_begin),
       (gt,":ha",":max_r_a"),
       (store_sub,":x",":max_r_a",":ha"),
       (troop_raise_skill,"trp_player",skl_horse_archery,":x"),
       (val_sub,"$comp_points",":x"),
    (try_end),
    ]),
#
  (3, 0, 0,
   [(gt,"$comp_points",0)],
   [
    (store_attribute_level,":str","trp_player",ca_strength),
    (store_attribute_level,":agi","trp_player",ca_agility),
    (store_div,":max_pd",":str",3),
    (store_div,":max_r_a",":agi",3),
    (store_skill_level,":rid",skl_riding,"trp_player"),
    (store_skill_level,":pd",skl_power_draw,"trp_player"),
    (store_skill_level,":ha",skl_horse_archery,"trp_player"),
    (try_begin),
       (gt,":max_r_a",":ha"),
       (store_sub,":x",":max_r_a",":ha"),
       (ge,"$comp_points",":x"),
       (troop_raise_skill,"trp_player",skl_horse_archery,":x"),
       (val_sub,"$comp_points",":x"),
    (try_end),
    (try_begin),
       (gt,":max_r_a",":rid"),
       (store_sub,":x",":max_r_a",":rid"),
       (ge,"$comp_points",":x"),
       (troop_raise_skill,"trp_player",skl_riding,":x"),
       (val_sub,"$comp_points",":x"),
    (try_end),
    (try_begin),
       (gt,":max_pd",":pd"),
       (val_sub,":max_pd",":pd"),
       (ge,"$comp_points",":max_pd"),
       (troop_raise_skill,"trp_player",skl_power_draw,":max_pd"),
       (val_sub,"$comp_points",":max_pd"),
    (try_end),
    ]),

  (0.0, 0, 0.0, [(eq,"$know_sa",0)], [(try_for_range,":armor",special_armor_begin,special_armor_end),
                                      (troop_has_item_equipped,"trp_player",":armor"),
                                      (troop_remove_item,"trp_player",":armor"),
                                      (troop_add_item,"trp_player",":armor"),
#                                      (troop_set_inventory_slot,"trp_player",17,":armor"),
                                    (try_end),]),
      #SG_Troop_Skill
      
      (10, 0, ti_once,[(neq,"$kn_r",1)],[
                                  (try_for_agents,":agents"), 
                                    (agent_is_ally,":agents"),
                                    (agent_is_alive,":agents"),
                                    (agent_get_troop_id,":troop",":agents"),
                                    (troop_is_hero,":troop"),
                                    (try_begin),
                                      (eq,":troop","trp_caoren"),
                                      (assign,"$s_r",1),
                                    (else_try),
                                      (eq,":troop","trp_zhangliao"),
                                      (assign,"$s_r",1),
                                    (else_try),
                                      (eq,":troop","trp_pangde"),
                                      (assign,"$s_r",1),
                                    (else_try),
                                      (eq,":troop","trp_gaoshun"),
                                      (assign,"$s_r",1),
                                    (else_try),
                                      (eq,":troop","trp_machao"),
                                      (assign,"$s_r",1),
                                    (else_try),
                                      (eq,":troop","trp_ganning"),
                                      (assign,"$s_r",1),
                                    (else_try),
                                      (eq,":troop","trp_lvbu"),
                                      (assign,"$s_r",1),
                                    (else_try),
                                      (eq,":troop","trp_zhaoyun"),
                                      (assign,"$s_r",1),
                                    (try_end),
                                  (try_end),]),
      (10, 0, ti_once,[(neq,"$kn_f",1)],[
                                  (try_for_agents,":agents"), 
                                    (agent_is_ally,":agents"),
                                    (agent_is_alive,":agents"),
                                    (agent_get_troop_id,":troop",":agents"),
                                    (troop_is_hero,":troop"),
                                    (try_begin),
                                      (eq,":troop","trp_caocao"),
                                      (assign,"$s_f",1),
                                    (else_try),
                                      (eq,":troop","trp_simayi"),
                                      (assign,"$s_f",1),
                                    (else_try),
                                      (eq,":troop","trp_weiyan"),
                                      (assign,"$s_f",1),
                                    (else_try),
                                      (eq,":troop","trp_zhouyu"),
                                      (assign,"$s_f",1),
                                    (else_try),
                                      (eq,":troop","trp_taishici"),
                                      (assign,"$s_f",1),
                                    (else_try),
                                      (eq,":troop","trp_luxun"),
                                      (assign,"$s_f",1),
                                    (else_try),
                                      (eq,":troop","trp_zhangren"),
                                      (assign,"$s_f",1),
                                    (try_end),
                                  (try_end),]),
     (10, 0, ti_once,[(neq,"$kn_a",1)],[
                                  (try_for_agents,":agents"), 
                                    (agent_is_ally,":agents"),
                                    (agent_is_alive,":agents"),
                                    (agent_get_troop_id,":troop",":agents"),
                                    (troop_is_hero,":troop"),
                                    (try_begin),
                                      (eq,":troop","trp_xiahouyuan"),
                                      (assign,"$s_a",1),
                                    (else_try),
                                      (eq,":troop","trp_huangzhong"),
                                      (assign,"$s_a",1),
                                    (else_try),
                                      (eq,":troop","trp_zhugeliang"),
                                      (assign,"$s_a",1),
                                    (try_end),
                                  (try_end),]),
     (10, 0, ti_once,[(neq,"$kn_h",1)],[
                                  (try_for_agents,":agents"), 
                                    (agent_is_ally,":agents"),
                                    (agent_is_alive,":agents"),
                                    (agent_get_troop_id,":troop",":agents"),
                                    (troop_is_hero,":troop"),
                                    (try_begin),
                                      (eq,":troop","trp_lvbu"),
                                      (assign,"$s_h",1),
                                    (else_try),
                                      (eq,":troop","trp_gongsunzan"),
                                      (assign,"$s_h",1),
                                    (try_end),
                                  (try_end),]),
    
      (5, 0, ti_once,[],[(try_begin),
                           (eq,"$kn_h",1),
                           (assign,"$s_h",1),
                         (else_try),
                           (eq,"$kn_a",1),
                           (assign,"$s_a",1),
                         (else_try),
                           (eq,"$kn_f",1),
                           (assign,"$s_f",1),
                         (else_try),
                           (eq,"$kn_r",1),
                           (assign,"$s_r",1),
                         (try_end),]),
      (20, 0, ti_once,[],[
                    (assign,"$troop_skill_effect",1),#
                    (store_troop_faction,":p_faction","trp_player"),
                    (try_for_agents,":agents"), 
                      (agent_is_ally,":agents"),
                      (agent_get_troop_id,":troop",":agents"),
                      (store_troop_faction,":faction",":troop"),
                      (eq,":p_faction",":faction"),
                      (try_begin),
                        (is_between,":troop",rider_begin,rider_end),
                        (eq,"$s_r",1),
                        (troop_get_slot,":rs",":troop", slot_rs),
                        (neq,":rs",1),
                        (troop_raise_skill,":troop",skl_riding,1),
                        (troop_raise_skill,":troop",skl_power_strike,1),
                        (troop_raise_proficiency, ":troop",0,50),
                        (troop_raise_proficiency, ":troop",1,50),
                        (troop_set_slot,":troop",slot_rs,1),
                      (else_try),
                        (is_between,":troop",footman_begin,footman_end),
                        (eq,"$s_f",1),
                        (troop_get_slot,":rs",":troop", slot_rs),
                        (neq,":rs",1),
                        (troop_raise_skill,":troop",skl_athletics,1),
                        (troop_raise_skill,":troop",skl_power_strike,1),
                        (troop_raise_proficiency, ":troop",0,50),
                        (troop_raise_proficiency, ":troop",1,50),
                        (troop_set_slot,":troop",slot_rs,1),
                      (else_try),
                        (is_between,":troop",archer_begin,archer_end),
                        (eq,"$s_a",1),
                        (troop_get_slot,":rs",":troop", slot_rs),
                        (neq,":rs",1),
                        (troop_raise_skill,":troop",skl_power_draw,1),
                        (troop_raise_proficiency, ":troop",3,80),
                        (troop_raise_proficiency, ":troop",4,120),
                        (troop_set_slot,":troop",slot_rs,1),
                      (else_try),
                        (is_between,":troop",horsearcher_begin,horsearcher_end),
                        (eq,"$s_h",1),
                        (troop_get_slot,":rs",":troop", slot_rs),
                        (neq,":rs",1),
                        (troop_raise_skill,":troop",skl_power_draw,1),
                        (troop_raise_skill,":troop",skl_horse_archery,1),
                        (troop_raise_proficiency, ":troop",3,80),
                        (assign,"$s_h",2),
                        (troop_set_slot,":troop",slot_rs,1),
                      (try_end),
                    (try_end),
                    ]),
      (0, 0, ti_once,[],[
                   (assign,"$s_h",0),#troop skill
                   (assign,"$s_a",0),#
                   (assign,"$s_f",0),#
                   (assign,"$s_r",0),#
                   (assign,"$num_ae",0),#

                   #SG_Stratagem
                   (troop_set_slot,"trp_jiaxu", slot_use_st,0),#AI st
                   (troop_set_slot,"trp_caocao", slot_use_st,0),
                   (troop_set_slot,"trp_guojia", slot_use_st,0),
                   (troop_set_slot,"trp_simayi", slot_use_st,0),
                   (troop_set_slot,"trp_xunyu", slot_use_st,0),
                   (troop_set_slot,"trp_xushu", slot_use_st,0),
                   (troop_set_slot,"trp_zhugeliang", slot_use_st,0),
                   (troop_set_slot,"trp_pangtong", slot_use_st,0),
                   (troop_set_slot,"trp_zhouyu", slot_use_st,0),
                   (troop_set_slot,"trp_luxun", slot_use_st,0),

                   (assign,"$order",0),#qixi
                   (assign,":finded",0),#hunluan
                   (try_for_agents,":agents"), 
                     (eq,":finded",0),
                     (agent_is_alive,":agents"),
                     (agent_is_human,":agents"),
                     (neg|agent_is_ally,":agents"),
                     (agent_get_position,pos63,":agents"),
                     (assign,":finded",1),
                   (try_end),
                   (position_move_y,pos63,-8000),
                   (assign,":finded",0),
                   (try_for_agents,":agents"), 
                     (eq,":finded",0),
                     (agent_is_alive,":agents"),
                     (agent_is_human,":agents"),
                     (agent_is_ally,":agents"),
                     (agent_get_position,pos62,":agents"),
                     (assign,":finded",1),
                   (try_end),
                   (position_move_y,pos62,-8000),
          ]),

      #SG_Stratagem
      (5, 0, 0,[],[(assign,"$num_en",0),
                   (assign,"$num_al",0),
                   (try_for_agents,":agents"), 
                    (agent_is_alive,":agents"),
                    (agent_is_human,":agents"),
                    (try_begin),
                    (neg|agent_is_ally,":agents"),
                    (val_add,"$num_en",1),
                    (else_try),
                    (val_add,"$num_al",1),
                    (try_end),
                   (try_end),
                   (store_sub,"$num_ae","$num_al","$num_en"),
                   (val_mul,"$num_ae",5)]),
      #Huoji
      (0, 4, 80,
      [ (key_clicked, key_z),
        (try_begin),
          (le,"$max_st",0),
          (display_message, "@st not enough"),
        (else_try),
          (lt,"$hj_use_count",1),
          (display_message, "@fire not ready"),
        (else_try),
          (lt,"$num_al",5),
          (display_message, "@num al shortage"),
        (else_try),
          (display_message,"str_fire"),
        (try_end),
        (ge,"$num_al",5),
        (gt,"$max_st",0),
        (eq, "$can_use_fire", 1),
        ], 
      [(call_script, "script_sg_huo_ji")]),

      #Lijian
      (0, 3, 120,
     [(key_clicked, key_x),
      (try_begin),
        (le,"$max_st",0),
        (display_message, "@st not enough"),
      (else_try),
        (display_message,"str_lijian"),
      (try_end),
      (gt,"$max_st",0),
        ], [(call_script, "script_sg_li_jian")]),

      #Qixi
      (0, 0, 5,
     [(key_clicked, key_v),
      (try_begin),
        (le,"$max_st",0),
        (display_message, "@st not enough"),
      (else_try),
        (lt,"$amount_to_use",1),
        (display_message, "@qixi not ready"),
      (else_try),
        (call_script, "script_sg_qi_xi"),
      (try_end),
        ], []),
      (0, 0, 0.5,##
     [(key_clicked, key_g),
      (eq,"$use_qixi",2),
      (team_get_leader, ":fb_leader",2),
      (agent_get_position, pos1, ":fb_leader"),
      (try_begin),
        (eq,"$order",0),
        (assign,"$order",1),
        (team_give_order,2, grc_everyone, mordr_hold),
        (team_set_order_position,2, grc_everyone, pos1),
        (display_message, "@team 2 hold"),
      (else_try),
        (eq,"$order",1),
        (assign,"$order",0),
        (team_give_order,2, grc_everyone, mordr_charge),
        (display_message, "@team 2 charge"),
      (try_end),
        ], []),
      
      #Hunluan
      (0, 3, 120,
      [ (key_clicked, key_b),
        (try_begin),
          (le,"$max_st",0),
          (display_message, "@st not enough"),
        (else_try),
          (display_message,"str_hunluan"),
        (try_end),
        (gt,"$max_st",0),
        ], 
        [(call_script, "script_sg_hun_luan")]),

    #Xianjing
    (0, 4, 60,
      [ (key_clicked, key_m),
        (try_begin),
          (le,"$max_st",0),
          (display_message, "@st not enough"),
        (else_try),
          (lt,"$xj_use_count",1),
          (display_message, "@trap not ready"),
        (else_try),
          (lt,"$num_al",5),
          (display_message, "@num al shortage"),
        (else_try),
          (display_message,"str_xianjing"),
        (try_end),
        (gt,"$max_st",0),
        (ge,"$num_al",5),
        (eq, "$can_use_xj", 1),
        ], 
      [(call_script, "script_sg_xian_jing")]),

      #lianhuan
      (0, 5, 300,
      [ (key_clicked, key_k),
        (eq,"$lianhuan",1),
        (try_begin),
          (le,"$max_st",2),
          (display_message, "@st not enough"),
        (else_try),
          (lt,"$hj_use_count",1),
          (display_message, "@fire not ready"),
        (else_try),
          (lt,"$amount_to_use",1),
          (display_message, "@qixi not ready"),
        (else_try),
          (lt,"$num_al",10),#15?
          (display_message, "@num al shortage"),
        (else_try),
          (display_message,"str_lianhuan"),
          (call_script, "script_sg_huo_ji"),
          (call_script, "script_sg_hun_luan"),
          (call_script, "script_sg_qi_xi"),
        (try_end),
        ],[]),

      (ti_tab_pressed, 0, 0, [],
       [
           (try_begin),
             (eq, "$battle_won", 1),
##SG
           (try_begin),
             (eq,"$use_qixi",2),
             (call_script, "script_count_qi_xi_agents"),
           (try_end),
##SG
             (call_script, "script_count_mission_casualties_from_agents"),
             (finish_mission,0),
           (else_try),
             (call_script, "script_cf_check_enemies_nearby"),
             (question_box,"str_do_you_want_to_retreat"),
           (else_try),
             (display_message,"str_can_not_retreat"),
           (try_end),
        ]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),
        (eq,":answer",0),
        (assign, "$pin_player_fallen", 0),
        (call_script, "script_simulate_retreat", 10, 20),
##SG
        (try_begin),
          (eq,"$use_qixi",2),
          (call_script, "script_count_qi_xi_agents"),
        (try_end),
##SG
        (call_script, "script_count_mission_casualties_from_agents"),
        (finish_mission,0),]),

      (ti_before_mission_start, 0, 0, [],
       [
           (team_set_relation, 0, 2, 1),
        ]),
      
      (0, 0, ti_once, [], [(assign,"$battle_won",0),
                           (assign,"$defender_reinforcement_stage",0),
                           (assign,"$attacker_reinforcement_stage",0),
                           (assign, "$g_presentation_battle_active", 0),
                           ]),

##      (ti_on_agent_spawn, 0, 0, [],
##       [(store_trigger_param_1, ":agent_no"),
##        (call_script, "script_agent_reassign_team", ":agent_no"),
##        ]),


      (2, 0, 0, [], [(call_script, "script_check_friendly_kills"),
                     ]),

      (1, 0, 5, [(lt,"$defender_reinforcement_stage",2),
                 (store_mission_timer_a,":mission_time"),
                 (ge,":mission_time",10),
                 (store_normalized_team_count,":num_defenders", 0),
                 (lt,":num_defenders",6),
#                 (assign, reg2, ":num_defenders"),
#                 (display_message,"@num_defenders = {reg2}")
                 ],
           [
               (try_for_agents,":agent"),##SG
                 (agent_is_alive,":agent"),
                 (agent_is_human,":agent"),
                 (agent_get_team,":team",":agent"),
                 (eq ,":team",0),
                 (agent_clear_scripted_mode,":agent"),
               (try_end),##SG end
               (add_reinforcements_to_entry,0,7),(val_add,"$defender_reinforcement_stage",1)]),
      
      (1, 0, 5, [(lt,"$attacker_reinforcement_stage",2),
                 (store_mission_timer_a,":mission_time"),
                 (ge,":mission_time",10),
                 (store_normalized_team_count,":num_attackers", 1),
                 (lt,":num_attackers",6),
#                 (assign, reg2, ":num_attackers"),
#                 (display_message,"@num_attackers = {reg2}")
                 ],
           [
               (try_for_agents,":agent"),##SG
                 (agent_is_alive,":agent"),
                 (agent_is_human,":agent"),
                 (agent_get_team,":team",":agent"),
                 (eq ,":team",1),
                 (agent_clear_scripted_mode,":agent"),
               (try_end),##SG end
               (add_reinforcements_to_entry,3,7),(val_add,"$attacker_reinforcement_stage",1)]),
      
      (1, 60, ti_once, [(store_mission_timer_a,reg(1)),
                        (ge,reg(1),10),(all_enemies_defeated,2),
                        (neg|main_hero_fallen,0),
                        (set_mission_result,1),
                        (assign, "$g_battle_result", 1),
                        (display_message,"str_msg_battle_won"),
                        (assign,"$battle_won",1),
                        ],
           [
##SG
            (try_begin),
              (eq,"$use_qixi",2),
              (call_script, "script_count_qi_xi_agents"),
            (try_end),
##SG
            (call_script, "script_count_mission_casualties_from_agents"),
            (finish_mission,1)]),
      (10, 0, 0, [], [(eq,"$battle_won",1),(display_message,"str_msg_battle_won")]),
      (1, 4, ti_once, [(main_hero_fallen)],
          [
              (assign, "$pin_player_fallen", 1),
              (call_script, "script_simulate_retreat", 10, 20),
              (assign, "$g_battle_result", -1),
              (set_mission_result,-1),
##SG
              (try_begin),
                (eq,"$use_qixi",2),
                (call_script, "script_count_qi_xi_agents"),
              (try_end),
##SG
              (call_script, "script_count_mission_casualties_from_agents"),
              (finish_mission,0)]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_use_baggage_for_inventory")], []),


 ##AI Tiggers
      #SG AI st
      #AI huoji
      (3, 1, ti_once,[
           (this_or_next|eq, "$ai_battle_tactic", btactic_hold),
           (eq, "$ai_battle_tactic", btactic_follow_leader),
           (assign,":find",0),
           (assign,":num",0),
           (try_for_agents,":cur_agent"), 
               (eq,":find",0),
               (agent_is_human,":cur_agent"),
               (agent_is_alive,":cur_agent"),
               (neg|agent_is_ally,":cur_agent"),
               (agent_get_troop_id,":hj_id",":cur_agent"),
               (troop_is_hero, ":hj_id"),
               (this_or_next|eq,":hj_id","trp_zhugeliang"),
               (eq,":hj_id","trp_zhouyu"),
               (troop_slot_eq,":hj_id",slot_use_st,0),
               (agent_get_position,pos45,":cur_agent"),
               (assign,":huoji_agent",":cur_agent"),
               (assign,":find",1),
           (try_end),
           (try_begin),
             (eq,":find",1),
             (try_for_agents,":ally_agent"), 
               (agent_is_human,":ally_agent"),
               (agent_is_alive,":ally_agent"),
               (agent_is_ally,":ally_agent"),
               (agent_get_position,pos46,":ally_agent"),
               (get_distance_between_positions,":dist",pos45,pos46),
               (lt,":dist",10000),
               (copy_position,pos47,pos46),
               (val_add,":num",1),
             (try_end),
           (try_end),
           (ge,":num",5),#10
           (store_random_in_range,":oo",0,100),
           (ge,":oo",5),
           (troop_set_slot,":hj_id", slot_use_st,1),
           (str_store_troop_name,s58,":hj_id"),
           (display_message,"@huo ji enemy"),
           (assign,"$e_hj_agent",":huoji_agent"),
          ],[(call_script, "script_sg_huo_ji_ai","$e_hj_agent")]),
    
      #AI hunluan
      (4, 2, ti_once,[
           (assign,":num",0),
           (assign,":find",0),
           (try_for_agents,":cur_agent"), 
               (eq,":find",0),
               (agent_is_human,":cur_agent"),
               (agent_is_alive,":cur_agent"),
               (neg|agent_is_ally,":cur_agent"),
               (agent_get_troop_id,":hl_id",":cur_agent"),
               (troop_is_hero, ":hl_id"),
               (this_or_next|eq,":hl_id","trp_jiaxu"),
               (this_or_next|eq,":hl_id","trp_caocao"),
               (this_or_next|eq,":hl_id","trp_simayi"),
               (this_or_next|eq,":hl_id","trp_guojia"),
               (this_or_next|eq,":hl_id","trp_xunyu"),
               (this_or_next|eq,":hl_id","trp_xushu"),
               (this_or_next|eq,":hl_id","trp_zhugeliang"),
               (this_or_next|eq,":hl_id","trp_pangtong"),
               (this_or_next|eq,":hl_id","trp_luxun"),
               (eq,":hl_id","trp_zhouyu"),
               (troop_slot_eq,":hl_id",slot_use_st,0),
               (agent_get_position,pos45,":cur_agent"),
               (assign,":hunluan_agent",":cur_agent"),
               (assign,":find",1),
           (try_end),
           (try_begin),
             (eq,":find",1),
             (try_for_agents,":ally_agent"), 
               (agent_is_human,":ally_agent"),
               (agent_is_alive,":ally_agent"),
               (agent_is_ally,":ally_agent"),
               (agent_get_position,pos46,":ally_agent"),
               (get_distance_between_positions,":dist",pos45,pos46),
               (lt,":dist",6000),
               (val_add,":num",1),
             (try_end),
           (try_end),
           (ge,":num",5),#8
           (store_random_in_range,":oo",0,100),
           (ge,":oo",40),
           (troop_set_slot,":hl_id", slot_use_st,1),
           (str_store_troop_name,s58,":hl_id"),
           (display_message,"@hun luan enemy"),
           (assign,"$e_hl_agent",":hunluan_agent"),
          ],[(call_script, "script_sg_hun_luan_ai","$e_hl_agent")]),

      #AI lijian
      (4, 2, ti_once,[
           (assign,":num",0),
           (assign,":find",0),
           (try_for_agents,":cur_agent"), 
               (eq,":find",0),
               (agent_is_human,":cur_agent"),
               (agent_is_alive,":cur_agent"),
               (neg|agent_is_ally,":cur_agent"),
               (agent_get_troop_id,":lj_id",":cur_agent"),
               (troop_is_hero, ":lj_id"),
               (this_or_next|eq,":lj_id","trp_caocao"),
               (this_or_next|eq,":lj_id","trp_simayi"),
               (this_or_next|eq,":lj_id","trp_guojia"),
               (this_or_next|eq,":lj_id","trp_xunyu"),
               (this_or_next|eq,":lj_id","trp_luxun"),
               (eq,":lj_id","trp_zhouyu"),
               (troop_slot_eq,":lj_id",slot_use_st,0),
               (agent_get_position,pos45,":cur_agent"),
               (assign,":lijian_agent",":cur_agent"),
               (assign,":find",1),
           (try_end),
           (try_begin),
             (eq,":find",1),
             (try_for_agents,":ally_agent"), 
               (agent_is_human,":ally_agent"),
               (agent_is_alive,":ally_agent"),
               (agent_is_ally,":ally_agent"),
               (agent_get_position,pos46,":ally_agent"),
               (get_distance_between_positions,":dist",pos45,pos46),
               (lt,":dist",6000),
               (val_add,":num",1),
             (try_end),
           (try_end),
           (ge,":num",5),#10
           (store_random_in_range,":oo",0,100),
           (ge,":oo",40),
           (troop_set_slot,":lj_id", slot_use_st,1),
           (str_store_troop_name,s58,":lj_id"),
           (display_message,"@li jian enemy"),
           (assign,"$e_lj_agent",":lijian_agent"),
          ],[(call_script, "script_sg_li_jian_ai","$e_lj_agent")]),

      #AI qixi
      (3, 2, ti_once,[
           (assign,":num",0),
           (assign,":find",0),
           (try_for_agents,":cur_agent"), 
               (eq,":find",0),
               (agent_is_human,":cur_agent"),
               (agent_is_alive,":cur_agent"),
               (neg|agent_is_ally,":cur_agent"),
               (agent_get_troop_id,":qx_id",":cur_agent"),
               (troop_is_hero, ":qx_id"),
               (this_or_next|eq,":qx_id","trp_jiaxu"),
               (this_or_next|eq,":qx_id","trp_simayi"),
               (this_or_next|eq,":qx_id","trp_xushu"),
               (this_or_next|eq,":qx_id","trp_pangtong"),
               (this_or_next|eq,":qx_id","trp_zhugeliang"),
               (this_or_next|eq,":qx_id","trp_luxun"),
               (eq,":qx_id","trp_zhouyu"),
               (troop_slot_eq,":qx_id",slot_use_st,0),
               (agent_get_position,pos45,":cur_agent"),
               (assign,":qixi_agent",":cur_agent"),
               (assign,":find",1),
           (try_end),
           (try_begin),
             (eq,":find",1),
             (try_for_agents,":ally_agent"), 
               (agent_is_human,":ally_agent"),
               (agent_is_alive,":ally_agent"),
               (agent_is_ally,":ally_agent"),
               (agent_get_position,pos46,":ally_agent"),
               (get_distance_between_positions,":dist",pos45,pos46),
               (lt,":dist",8000),
               (val_add,":num",1),
             (try_end),
           (try_end),
           (ge,":num",6),
           (store_random_in_range,":oo",0,100),
           (ge,":oo",40),
           (troop_set_slot,":qx_id", slot_use_st,1),
           (str_store_troop_name,s58,":qx_id"),
           (display_message,"@qi xi enemy"),
           (assign,"$e_qx_agent",":qixi_agent"),
          ],[(call_script, "script_sg_qi_xi_ai","$e_qx_agent")]),
     #ai st end

      (0, 0, ti_once, [
          (store_mission_timer_a,":mission_time"),(ge,":mission_time",1),
          ],
       [(call_script, "script_select_battle_tactic"),
        (call_script, "script_battle_tactic_init")]),
      
      (5, 0, 0, [
          (store_mission_timer_a,":mission_time"),(ge,":mission_time",2),
          (call_script, "script_battle_tactic_apply"),
          ], []),

     (0, 0, 0,
      [(key_clicked, key_backspace),
       (start_presentation, "prsnt_battle"),
        ], []),

     (0.1, 0, 0,
      [(eq, "$g_presentation_battle_active", 1),
       (call_script, "script_update_order_panel_statistics_and_map"),
        ], []),

    ],
  ),

  (
    "village_raid",mtf_battle_mode,charge,
    "You lead your men to battle.",
    [
     (3,mtef_defenders|mtef_team_0,af_override_horse,aif_start_alarmed,12,[]),
     (3,mtef_defenders|mtef_team_0,0,aif_start_alarmed,0,[]),
     (1,mtef_attackers|mtef_team_1,0,aif_start_alarmed,12,[]),
     (1,mtef_attackers|mtef_team_1,0,aif_start_alarmed,0,[]),
     ],
    [
      (ti_tab_pressed, 0, 0, [],
       [
           (try_begin),
             (eq, "$battle_won", 1),
             (call_script, "script_count_mission_casualties_from_agents"),
             (finish_mission,0),
           (else_try),
             (call_script, "script_cf_check_enemies_nearby"),
             (question_box,"str_do_you_want_to_retreat"),
           (else_try),
             (display_message,"str_can_not_retreat"),
           (try_end),
        ]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),
        (eq,":answer",0),
        (assign, "$pin_player_fallen", 0),
        (call_script, "script_simulate_retreat", 10, 20),
        (call_script, "script_count_mission_casualties_from_agents"),
        (finish_mission,0),]),

      (0, 0, ti_once, [], [(assign,"$battle_won",0),
                           (assign,"$defender_reinforcement_stage",0),
                           (assign,"$attacker_reinforcement_stage",0),
                           (assign, "$g_presentation_battle_active", 0),
                           ]),

      (2, 0, 0, [], [(call_script, "script_check_friendly_kills"),
                     ]),

      (1, 0, 5, [(lt,"$defender_reinforcement_stage",2),
                 (store_mission_timer_a,":mission_time"),
                 (ge,":mission_time",10),
                 (store_normalized_team_count,":num_defenders", 0),
                 (lt,":num_defenders",6)],
           [(add_reinforcements_to_entry,0,6),(val_add,"$defender_reinforcement_stage",1)]),
      (1, 0, 5, [(lt,"$attacker_reinforcement_stage",2),
                 (store_mission_timer_a,":mission_time"),
                 (ge,":mission_time",10),
                 (store_normalized_team_count,":num_attackers", 1),
                 (lt,":num_attackers",6)],
           [(add_reinforcements_to_entry,3,6),(val_add,"$attacker_reinforcement_stage",1)]),

      
      (1, 60, ti_once, [(store_mission_timer_a,reg(1)),
                        (ge,reg(1),10),(all_enemies_defeated,2),
                        (neg|main_hero_fallen,0),
                        (set_mission_result,1),
                        (assign, "$g_battle_result", 1),
                        (display_message,"str_msg_battle_won"),
                        (assign,"$battle_won",1),
                        ],
           [(call_script, "script_count_mission_casualties_from_agents"),
            (finish_mission,1)]),
      (10, 0, 0, [], [(eq,"$battle_won",1),(display_message,"str_msg_battle_won")]),
      (1, 4, ti_once, [(main_hero_fallen)],
          [
              (assign, "$pin_player_fallen", 1),
              (call_script, "script_simulate_retreat", 10, 20),
              (assign, "$g_battle_result", -1),
              (set_mission_result,-1),
              (call_script, "script_count_mission_casualties_from_agents"),
              (finish_mission,0)]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_use_baggage_for_inventory")], []),

     (0, 0, 0,
      [(key_clicked, key_backspace),
       (start_presentation, "prsnt_battle"),
        ], []),

##      #AI Tiggers
##      (0, 0, ti_once, [
##          (store_mission_timer_a,reg(1)),(ge,reg(1),4),
##          (call_script, "script_select_battle_tactic"),
##          (call_script, "script_battle_tactic_init"),
##          ], []),
##      (1, 0, 0, [
##          (store_mission_timer_a,reg(1)),(ge,reg(1),4),
##          (call_script, "script_battle_tactic_apply"),
##          ], []),
    ],
  ),



##  (
##    "charge_with_allies",mtf_battle_mode,charge_with_ally,
##    "Taking a handful of fighters with you, you set off to patrol the area.",
##    [
##     (1,mtef_defenders,0,0|aif_start_alarmed,8,[]),
##     (0,mtef_defenders,0,0|aif_start_alarmed,0,[]),
##     (4,mtef_attackers,0,aif_start_alarmed,8,[]),
##     (4,mtef_attackers,0,aif_start_alarmed,0,[]),
##     ],
##    [
##      (ti_tab_pressed, 0, 0, [],
##       [
##           (try_begin),
##             (eq, "$battle_won", 1),
##             (finish_mission,0),
##           (else_try),
##             (call_script, "script_cf_check_enemies_nearby"),
##             (question_box,"str_do_you_want_to_retreat"),
##           (else_try),
##             (display_message,"str_can_not_retreat"),
##           (try_end),
##        ]),
##      (ti_question_answered, 0, 0, [],
##       [(store_trigger_param_1,":answer"),
##        (eq,":answer",0),
##        (assign, "$pin_player_fallen", 0),
##        (call_script, "script_simulate_retreat", 10, 30),
##        (finish_mission,0),]),
##
##      (0, 0, ti_once, [], [(assign,"$battle_won",0),(assign,"$defender_reinforcement_stage",0),(assign,"$attacker_reinforcement_stage",0)]),
##      (1, 0, 5, [(lt,"$defender_reinforcement_stage",2),(store_mission_timer_a,reg(1)),(ge,reg(1),10),(store_defender_count,reg(2)),(lt,reg(2),3)],
##           [(add_reinforcements_to_entry,0,4),(val_add,"$defender_reinforcement_stage",1)]),
##      (1, 0, 5, [(lt,"$attacker_reinforcement_stage",2),(store_mission_timer_a,reg(1)),(ge,reg(1),10),(store_attacker_count,reg(2)),(lt,reg(2),3)],
##           [(add_reinforcements_to_entry,3,4),(val_add,"$attacker_reinforcement_stage",1)]),
##      (1, 60, ti_once, [(store_mission_timer_a,reg(1)),
##                        (ge,reg(1),10),(all_enemies_defeated,2),
##                        (neg|main_hero_fallen,0),
##                        (set_mission_result,1),
##                        (assign, "$g_battle_result", 1),
##                        (display_message,"str_msg_battle_won"),
##                        (assign,"$battle_won",1)],
##           [(finish_mission,1)]),
##      (10, 0, 0, [], [(eq,"$battle_won",1),(display_message,"str_msg_battle_won")]),
##
##      (1, 4, ti_once, [(main_hero_fallen)],
##          [
##              (assign, "$pin_player_fallen", 1),
##              (call_script, "script_simulate_retreat", 20, 30),
##              (assign, "$g_battle_result", -1),
##              (set_mission_result,-1),(finish_mission,0)]),
##      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_use_baggage_for_inventory")], []),
##    ],
##  ),

##  (
##    "charge_with_allies_old",mtf_battle_mode,charge_with_ally,
##    "Taking a handful of fighters with you, you set off to patrol the area.",
##    [(1,mtef_leader_only,0,0,1,[]),
##     (1,mtef_no_leader,0,0|aif_start_alarmed,2,[]),
##     (1,mtef_reverse_order|mtef_ally_party,0,0|aif_start_alarmed,3,[]),
##     (0,mtef_no_leader,0,0|aif_start_alarmed,0,[]),
##     (0,mtef_reverse_order|mtef_ally_party,0,0|aif_start_alarmed,0,[]),
##     (3,mtef_reverse_order|mtef_enemy_party,0,aif_start_alarmed,6,[]),
##     (4,mtef_reverse_order|mtef_enemy_party,0,aif_start_alarmed,0,[])],
##    [
##      (ti_tab_pressed, 0, 0, [],
##       [
##           (try_begin),
##             (eq, "$battle_won", 1),
##             (finish_mission,0),
##           (else_try),
##             (call_script, "script_cf_check_enemies_nearby"),
##             (question_box,"str_do_you_want_to_retreat"),
##           (else_try),
##             (display_message,"str_can_not_retreat"),
##           (try_end),
##        ]),
##      (ti_question_answered, 0, 0, [],
##       [(store_trigger_param_1,":answer"),(eq,":answer",0),(finish_mission,0),]),
##
##      (0, 0, ti_once, [], [(assign,"$battle_won",0),(assign,"$enemy_reinforcement_stage",0),(assign,"$friend_reinforcement_stage",0),(assign,"$ally_reinforcement_stage",0)]),
##      
##      (1, 0, 5, [(lt,"$enemy_reinforcement_stage",2),(store_mission_timer_a,reg(1)),(ge,reg(1),10),(store_enemy_count,reg(2)),(lt,reg(2),3)],
##       [(add_reinforcements_to_entry,6,3),(val_add,"$enemy_reinforcement_stage",1)]),
##      (1, 0, 5, [(lt,"$friend_reinforcement_stage",2),(store_mission_timer_a,reg(1)),(ge,reg(1),10),(store_friend_count,reg(2)),(lt,reg(2),2)],
##       [(add_reinforcements_to_entry,3,1),(val_add,"$friend_reinforcement_stage",1)]),
##      (1, 0, 5, [(lt,"$ally_reinforcement_stage",2),(store_mission_timer_a,reg(1)),(ge,reg(1),10),(store_ally_count,reg(2)),  (lt,reg(2),2)],
##       [(add_reinforcements_to_entry,4,2),(val_add,"$ally_reinforcement_stage",1)]),
##      (1, 60, ti_once, [(store_mission_timer_a,reg(1)),
##                        (ge,reg(1),10),
##                        (all_enemies_defeated,2),
##                        (neg|main_hero_fallen,0),
##                        (set_mission_result,1),
##                        (assign, "$g_battle_result", 1),
##                        (display_message,"str_msg_battle_won"),
##                        (assign,"$battle_won",1),
##                        ],
##       [(finish_mission,1)]),
##      (10, 0, 0, [], [(eq,"$battle_won",1),(display_message,"str_msg_battle_won")]),
##      (1, 4, ti_once, [(main_hero_fallen,0)],
##       [(set_mission_result,-1),(finish_mission,1)]),
##      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_use_baggage_for_inventory")], []),
##    ],
##  ),
##  (
##    "lead_charge_old",mtf_battle_mode,charge,
##    "You lead your men to battle.",
##    [
##     (1,mtef_leader_only,0,0,1,[]),
##     (1,mtef_no_leader,0,0|aif_start_alarmed,5,[]),
##     (0,mtef_no_leader,0,0|aif_start_alarmed,0,[]),
##     (3,mtef_enemy_party|mtef_reverse_order,0,aif_start_alarmed,6,[]),
##     (4,mtef_enemy_party|mtef_reverse_order,0,aif_start_alarmed,0,[]),
##     ],
##    [
##      (ti_tab_pressed, 0, 0, [],
##       [
##           (try_begin),
##             (eq, "$battle_won", 1),
##             (finish_mission,0),
##           (else_try),
##             (call_script, "script_cf_check_enemies_nearby"),
##             (question_box,"str_do_you_want_to_retreat"),
##           (else_try),
##             (display_message,"str_can_not_retreat"),
##           (try_end),
##        ]),
##      (ti_question_answered, 0, 0, [],
##       [(store_trigger_param_1,":answer"),(eq,":answer",0),(finish_mission,0),]),
##
##      (0, 0, ti_once, [], [(assign,"$battle_won",0),(assign,"$enemy_reinforcement_stage",0),(assign,"$friend_reinforcement_stage",0)]),
##      (1, 0, 5, [(lt,"$enemy_reinforcement_stage",2),(store_mission_timer_a,reg(1)),(ge,reg(1),10),(store_enemy_count,reg(2)),(lt,reg(2),3)],
##           [(add_reinforcements_to_entry,4,3),(val_add,"$enemy_reinforcement_stage",1)]),
##      (1, 0, 5, [(lt,"$friend_reinforcement_stage",2),(store_mission_timer_a,reg(1)),(ge,reg(1),10),(store_friend_count,reg(2)),(lt,reg(2),3)],
##           [(add_reinforcements_to_entry,2,3),(val_add,"$friend_reinforcement_stage",1)]),
##      (1, 60, ti_once, [(store_mission_timer_a,reg(1)),
##                        (ge,reg(1),10),(all_enemies_defeated,2),
##                        (neg|main_hero_fallen,0),
##                        (set_mission_result,1),
##                        (assign, "$g_battle_result", 1),
##                        (display_message,"str_msg_battle_won"),
##                        (assign,"$battle_won",1)],
##           [(finish_mission,1)]),
##      (10, 0, 0, [], [(eq,"$battle_won",1),(display_message,"str_msg_battle_won")]),
##      (1, 4, ti_once, [(main_hero_fallen)],
##          [
##              (assign, "$g_battle_result", -1),
##              (set_mission_result,-1),(finish_mission,1)]),
##      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_use_baggage_for_inventory")], []),
##    ],
##  ),

  (
    "castle_attack_walls_belfry",mtf_battle_mode,-1,
    "You attack the walls of the castle...",
    [
     (0,mtef_attackers|mtef_team_1,af_override_horse,aif_start_alarmed,14,[]),
     (0,mtef_attackers|mtef_team_1,af_override_horse,aif_start_alarmed,0,[]),
     (10,mtef_defenders|mtef_team_0,af_override_horse,aif_start_alarmed,0,[]),
     (11,mtef_defenders|mtef_team_0,af_override_horse,aif_start_alarmed,6,[]),
     (15,mtef_defenders|mtef_team_0,af_override_horse,aif_start_alarmed,0,[]),

     (40,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     (41,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     (42,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     (43,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     (44,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     (45,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     (46,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     (47,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     ],
    [
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
      (ti_tab_pressed, 0, 0, [],
       [
           (try_begin),
             (eq, "$battle_won", 1),
             (call_script, "script_count_mission_casualties_from_agents"),
             (finish_mission,0),
           (else_try),
             (call_script, "script_cf_check_enemies_nearby"),
             (question_box,"str_do_you_want_to_retreat"),
           (else_try),
             (display_message,"str_can_not_retreat"),
           (try_end),
        ]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),
        (eq,":answer",0),
        (assign, "$pin_player_fallen", 0),
        (call_script, "script_simulate_retreat", 5, 20),
        (call_script, "script_count_mission_casualties_from_agents"),
        (finish_mission,0),]),
        
      (0, 0, ti_once, [], [(assign,"$battle_won",0),
                           (assign,"$defender_reinforcement_stage",0),
                           (assign,"$attacker_reinforcement_stage",0),
                           ]),

      #AI Tiggers
      (0, 0, ti_once, [
          (assign, "$defender_team", 0),
          (assign, "$attacker_team", 1),
          (team_give_order, "$defender_team", grc_infantry, mordr_hold),
          (team_give_order, "$defender_team", grc_infantry, mordr_stand_closer),
          (team_give_order, "$defender_team", grc_infantry, mordr_stand_closer),
          (team_give_order, "$defender_team", grc_archers, mordr_stand_ground),
          (entry_point_get_position,pos10, 10),
          (team_set_order_position, "$defender_team", grc_everyone, pos10),
          ], []),
      (0, 2, ti_once, [], [
          (try_for_agents, ":agent_no"),
            (agent_is_human, ":agent_no"),
            (agent_is_alive, ":agent_no"),
            (agent_get_team, ":agent_team", ":agent_no"),
            (eq, "$defender_team", ":agent_team"),
            (agent_get_class, ":agent_class", ":agent_no"),
            (eq, ":agent_class", grc_archers),
            (agent_set_slot, ":agent_no", slot_agent_is_not_reinforcement, 1),
          (try_end),
          ]),

      (3, 15, 5, [(lt,"$defender_reinforcement_stage",15),
                 (store_mission_timer_a,":mission_time"),
                 (ge,":mission_time",10),
                 (store_normalized_team_count,":num_defenders",0),
                 (lt,":num_defenders",10),
                 (add_reinforcements_to_entry,4, 4),
                 (val_add,"$defender_reinforcement_stage",1),
                 (try_for_agents, ":agent_no"), #Make original archers stand still.
                   (agent_is_alive, ":agent_no"),
                   (agent_slot_eq, ":agent_no", slot_agent_is_not_reinforcement, 1),
                   (agent_get_position, pos0, ":agent_no"),
                   (agent_set_scripted_destination, ":agent_no", pos0, 0),
                 (try_end),
                 (team_give_order, "$defender_team", grc_archers, mordr_charge), #let others charge.
                 (try_begin),
                   (ge, "$defender_reinforcement_stage", 2),
                   (team_give_order, "$defender_team", grc_infantry, mordr_charge), #AI desperate charge:infantry!!!
                   (ge, "$defender_reinforcement_stage", 4),
                   (team_give_order, "$defender_team", grc_everyone, mordr_charge), #AI desperate charge: everyone!!!
                  (try_end),
                ],
           [#Clear scripted destination for archers after 15 seconds
            (try_for_agents, ":agent_no"),
              (agent_slot_eq, ":agent_no", slot_agent_is_not_reinforcement, 1),
              (agent_clear_scripted_mode, ":agent_no"),
            (try_end),
            (team_give_order, "$defender_team", grc_archers, mordr_stand_ground),
            ]),
      
      (1, 0, 5, [(lt,"$attacker_reinforcement_stage",2),
                 (store_mission_timer_a,":mission_time"),
                 (ge,":mission_time",10),
                 (store_normalized_team_count,":num_attackers",1),
                 (lt,":num_attackers",6)],
           [(add_reinforcements_to_entry,1,7),(val_add,"$attacker_reinforcement_stage",1)]),
      
      (5, 0, 0, [], [ #Make sure attackers do not stall on the ladders...
          (try_for_agents, ":agent_no"),
            (agent_is_human, ":agent_no"),
            (agent_is_alive, ":agent_no"),
            (agent_get_team, ":agent_team", ":agent_no"),
            (eq, "$attacker_team", ":agent_team"),
            (agent_ai_set_always_attack_in_melee, ":agent_no", 1),
          (try_end),
          ]),

      (2, 0, 0, [], [(call_script, "script_check_friendly_kills"),
                     ]),

      
      (1, 60, ti_once, [(store_mission_timer_a,reg(1)),
                        (ge,reg(1),10),
                        (all_enemies_defeated,2),
                        (neg|main_hero_fallen,0),
                        (set_mission_result,1),
                        (display_message,"str_msg_battle_won"),
                        (assign,"$battle_won",1),
                        (assign, "$g_battle_result", 1),
                        ],
           [(call_script, "script_count_mission_casualties_from_agents"),
            (finish_mission,1)]),
      (10, 0, 0, [], [(eq,"$battle_won",1),(display_message,"str_msg_battle_won")]),


#refill ammo of defenders every two minutes.
      (120, 0, 0, [], [(get_player_agent_no, ":player_agent"),
                      (try_for_agents,":cur_agent"),
                        (neq, ":cur_agent", ":player_agent"),
                        (agent_is_defender, ":cur_agent"),
                        (agent_is_alive, ":cur_agent"),
                        (agent_is_human, ":cur_agent"),
                        (agent_refill_ammo, ":cur_agent"),
                      (try_end)]),

      (1, 4, ti_once, [(main_hero_fallen)],
          [
              (assign, "$pin_player_fallen", 1),
              (call_script, "script_simulate_retreat", 5, 20),
              (assign, "$g_battle_result", -1),
              (set_mission_result,-1),
              (call_script, "script_count_mission_casualties_from_agents"),
              (finish_mission,0)]),

      #Init AI and Belfry
      (0, 0, ti_once, [
          (call_script, "script_siege_init_ai_and_belfry"),
          ], []),

      #Moving belfry
      (0, 0, ti_once, [(call_script, "script_cf_siege_move_belfry")], []),

      #Rotating belfry platform at the end
      (0, 2, ti_once, [(call_script, "script_cf_siege_rotate_belfry_platform"),
                       ], [(assign, "$belfry_positioned", 3),
                           ]),

      #Assigning men to the belfry
      (0, 0, ti_once, [(call_script, "script_cf_siege_assign_men_to_belfry")], []),


      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_use_baggage_for_inventory")], []),
    ],
  ),

  (
    "castle_attack_walls_ladder",mtf_battle_mode,-1,
    "You attack the walls of the castle...",
    [
     (0,mtef_attackers|mtef_team_1,af_override_horse,aif_start_alarmed,12,[]),
     (0,mtef_attackers|mtef_team_1,af_override_horse,aif_start_alarmed,0,[]),
     (10,mtef_defenders|mtef_team_0,af_override_horse,aif_start_alarmed,0,[]),
     (11,mtef_defenders|mtef_team_0,af_override_horse,aif_start_alarmed,6,[]),
     (15,mtef_defenders|mtef_team_0,af_override_horse,aif_start_alarmed,0,[]),

     (40,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     (41,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     (42,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     (43,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     (44,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     (45,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     (46,mtef_defenders|mtef_team_0|mtef_archers_first,af_override_horse,aif_start_alarmed,1,[]),
     ],
    [
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
      (ti_tab_pressed, 0, 0, [],
       [
           (try_begin),
             (eq, "$battle_won", 1),
             (call_script, "script_count_mission_casualties_from_agents"),
             (finish_mission,0),
           (else_try),
             (call_script, "script_cf_check_enemies_nearby"),
             (question_box,"str_do_you_want_to_retreat"),
           (else_try),
             (display_message,"str_can_not_retreat"),
           (try_end),
        ]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),
        (eq,":answer",0),
        (assign, "$pin_player_fallen", 0),
        (call_script, "script_simulate_retreat", 5, 20),
        (call_script, "script_count_mission_casualties_from_agents"),
        (finish_mission,0),]),
        
      (0, 0, ti_once, [], [(assign,"$battle_won",0),
                           (assign,"$defender_reinforcement_stage",0),
                           (assign,"$attacker_reinforcement_stage",0),
                           ]),
      
      #AI Tiggers
      (0, 0, ti_once, [
          (assign, "$defender_team", 0),
          (assign, "$attacker_team", 1),
          (team_give_order, "$defender_team", grc_infantry, mordr_hold),
          (team_give_order, "$defender_team", grc_infantry, mordr_stand_closer),
          (team_give_order, "$defender_team", grc_infantry, mordr_stand_closer),
          (team_give_order, "$defender_team", grc_archers, mordr_stand_ground),
          (entry_point_get_position,pos10, 10),
          (team_set_order_position, "$defender_team", grc_everyone, pos10),
          ], []),
      (0, 2, ti_once, [], [
          (try_for_agents, ":agent_no"),
            (agent_is_human, ":agent_no"),
            (agent_is_alive, ":agent_no"),
            (agent_get_team, ":agent_team", ":agent_no"),
            (eq, "$defender_team", ":agent_team"),
            (agent_get_class, ":agent_class", ":agent_no"),
            (eq, ":agent_class", grc_archers),
            (agent_set_slot, ":agent_no", slot_agent_is_not_reinforcement, 1),
          (try_end),
          ]),

      (3, 15, 5, [(lt,"$defender_reinforcement_stage",15),
                 (store_mission_timer_a,":mission_time"),
                 (ge,":mission_time",10),
                 (store_normalized_team_count,":num_defenders",0),
                 (lt,":num_defenders",10),
                 (add_reinforcements_to_entry,4, 4),
                 (val_add,"$defender_reinforcement_stage",1),
                 (try_for_agents, ":agent_no"), #Make original archers stand still.
                   (agent_is_alive, ":agent_no"),
                   (agent_slot_eq, ":agent_no", slot_agent_is_not_reinforcement, 1),
                   (agent_get_position, pos0, ":agent_no"),
                   (agent_set_scripted_destination, ":agent_no", pos0, 0),
                 (try_end),
                 (team_give_order, "$defender_team", grc_archers, mordr_charge), #let others charge.
                 (try_begin),
                   (ge, "$defender_reinforcement_stage", 2),
                   (team_give_order, "$defender_team", grc_infantry, mordr_charge), #AI desperate charge:infantry!!!
                   (ge, "$defender_reinforcement_stage", 4),
                   (team_give_order, "$defender_team", grc_everyone, mordr_charge), #AI desperate charge: everyone!!!
                  (try_end),
                ],
           [#Clear scripted destination for archers after 15 seconds
            (try_for_agents, ":agent_no"),
              (agent_slot_eq, ":agent_no", slot_agent_is_not_reinforcement, 1),
              (agent_clear_scripted_mode, ":agent_no"),
            (try_end),
            (team_give_order, "$defender_team", grc_archers, mordr_stand_ground),
            ]),
      
      (1, 0, 5, [(lt,"$attacker_reinforcement_stage",2),
                 (store_mission_timer_a,":mission_time"),
                 (ge,":mission_time",10),
                 (store_normalized_team_count,":num_attackers",1),
                 (lt,":num_attackers",6)],
           [(add_reinforcements_to_entry,1,7),(val_add,"$attacker_reinforcement_stage",1)]),

      
      (5, 0, 0, [], [ #Make sure attackers do not stall on the ladders...
          (try_for_agents, ":agent_no"),
            (agent_is_human, ":agent_no"),
            (agent_is_alive, ":agent_no"),
            (agent_get_team, ":agent_team", ":agent_no"),
            (eq, "$attacker_team", ":agent_team"),
            (agent_ai_set_always_attack_in_melee, ":agent_no", 1),
          (try_end),
          ]),

      (2, 0, 0, [], [(call_script, "script_check_friendly_kills"),
                     ]),

      
      (1, 60, ti_once, [(store_mission_timer_a,reg(1)),
                        (ge,reg(1),10),
                        (all_enemies_defeated,2),
                        (neg|main_hero_fallen,0),
                        (set_mission_result,1),
                        (display_message,"str_msg_battle_won"),
                        (assign,"$battle_won",1),
                        (assign, "$g_battle_result", 1)],
           [(call_script, "script_count_mission_casualties_from_agents"),
            (finish_mission,1)]),
      (10, 0, 0, [], [(eq,"$battle_won",1),(display_message,"str_msg_battle_won")]),


#refill ammo of defenders every two minutes.
      (120, 0, 0, [], [(get_player_agent_no, ":player_agent"),
                      (try_for_agents,":cur_agent"),
                        (neq, ":cur_agent", ":player_agent"),
                        (agent_is_defender, ":cur_agent"),
                        (agent_is_alive, ":cur_agent"),
                        (agent_is_human, ":cur_agent"),
                        (agent_refill_ammo, ":cur_agent"),
                      (try_end)]),

      (1, 4, ti_once, [(main_hero_fallen)],
          [
              (assign, "$pin_player_fallen", 1),
              (call_script, "script_simulate_retreat", 5, 20),
              (assign, "$g_battle_result", -1),
              (set_mission_result,-1),
              (call_script, "script_count_mission_casualties_from_agents"),
              (finish_mission,0)]),


      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_use_baggage_for_inventory")], []),
    ],
  ),
  

  (
    "castle_visit",0,-1,
    "Castle visit",
    [(1,mtef_visitor_source|mtef_team_0,af_override_horse,0,1,[]),
     # Party members
     (11,mtef_visitor_source|mtef_team_0,af_override_horse,0,1,[]),
     (12,mtef_visitor_source|mtef_team_0,af_override_horse,0,1,[]),
     (13,mtef_visitor_source|mtef_team_0,af_override_horse,0,1,[]),
     (14,mtef_visitor_source|mtef_team_0,af_override_horse,0,1,[]),
     (24,mtef_visitor_source|mtef_team_0,af_override_horse,0,1,[]),
     ],
    [
      (ti_tab_pressed, 0, 0, [(set_trigger_result,1)], []),
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners"),
                                           (replace_scene_props, "spr_battlement_a_destroyed", "spr_battlement_a"),
                                           (replace_scene_props, "spr_snowy_castle_battlement_a_destroyed", "spr_snowy_castle_battlement_a"),
                                           (replace_scene_props, "spr_castle_e_battlement_a_destroyed", "spr_castle_e_battlement_a"),
                                           (replace_scene_props, "spr_castle_battlement_a_destroyed", "spr_castle_battlement_a"),
                                           (replace_scene_props, "spr_castle_battlement_b_destroyed", "spr_castle_battlement_b"),
                                           (replace_scene_props, "spr_belfry_platform_b", "spr_empty"),
                                           (replace_scene_props, "spr_belfry_platform_a", "spr_empty"),
                                           (replace_scene_props, "spr_belfry_a", "spr_empty"),
                                           (replace_scene_props, "spr_belfry_wheel", "spr_empty"),
                                           (replace_scene_props, "spr_mangonel", "spr_empty"),
                                           (replace_scene_props, "spr_trebuchet_old", "spr_empty"),
                                           (replace_scene_props, "spr_trebuchet_new", "spr_empty"),
                                           (replace_scene_props, "spr_stone_ball", "spr_empty"),]),

#      (ti_before_mission_start, 0, 0, [],
#          [(scene_prop_disable,"spr_ramp_12m"),(scene_prop_disable,"spr_portcullis")]),
    ],
  ),

#note : we should not be setting groups for teams. This is done automatically.  
  (
    "zendar_training_fight",mtf_arena_fight,-1,
    "You will fight a match in the arena.",
    [
      (0,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_practice_shield,itm_practice_sword]),
      (1,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_staff]),
      (2,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_staff]),
      (3,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword]),
#      (0,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[]),
#      (1,mtef_visitor_source|mtef_team_1,af_override_all        ,aif_start_alarmed,1,[]),
#      (2,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[]),
#      (3,mtef_visitor_source|mtef_team_3,af_override_all      ,aif_start_alarmed,1,[]),
    ],
    [
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
      (ti_tab_pressed, 0, 0, [],
       [(question_box,"str_give_up_fight")]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),(eq,":answer",0),(jump_to_scene,"scn_zendar_center"),]),
      (1, 3, ti_once, [(main_hero_fallen,0)],
       [(jump_to_scene,"scn_zendar_center")]),
      (1, 3, ti_once, [(store_mission_timer_a,reg(1)),(ge,reg(1),1),(num_active_teams_le,1),(neg|main_hero_fallen,0),(assign,"$training_fight_won",1)],
       [(jump_to_scene,"scn_zendar_center")]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_arena")], []),
    ],
  ),
  (
    "zendar_arena_fight",mtf_arena_fight,-1,
    "You will fight a match in the arena. The fighter to score 9 points first wins.",
    [
      (16,mtef_visitor_source,af_override_horse|af_override_weapons|af_override_head,0,1,[]),
      (0,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_practice_bow,itm_practice_arrows,itm_practice_horse,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (1,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (2,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_practice_horse,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (3,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_practice_lance,itm_practice_shield,itm_practice_horse,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (4,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_practice_bow,itm_practice_arrows,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (5,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_red_tourney_armor]),
      (6,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_practice_horse,itm_red_tourney_armor]),
      (7,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_practice_lance,itm_practice_shield,itm_practice_horse,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (8,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_bow,itm_practice_arrows,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (9,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_lance,itm_practice_shield,itm_practice_horse,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (10,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (11,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (12,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_bow,itm_practice_arrows,itm_practice_horse,itm_blue_tourney_armor]),
      (13,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_lance,itm_practice_shield,itm_practice_horse,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (14,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_blue_tourney_armor]),
      (15,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_blue_tourney_armor]),
    ],
    [
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
      (ti_tab_pressed, 0, 0, [],
       [(question_box,"str_give_up_fight")]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),(eq,":answer",0),(jump_to_scene,"scn_zendar_center"),]),

      (1, 4, ti_once, [(main_hero_fallen,0)],
       [(jump_to_scene,"scn_zendar_center")]),
      (1, 4, ti_once, [(num_active_teams_le,1),(neg|main_hero_fallen,0)],
       [(store_remaining_team_no,"$zendar_winner_team"),(assign,"$arena_fight_won",1),(jump_to_scene,"scn_zendar_center")]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_arena")], []),
    ],
  ),
  (
    "sneak_caught_fight",mtf_arena_fight,-1,
    "You must fight your way out!",
    [
      (0,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,pilgrim_disguise),
      (25,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (26,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (27,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (28,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (29,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (30,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (31,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (32,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
#      (9,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
    ],
    [
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
      (ti_tab_pressed, 0, 0, [],
       [(question_box,"str_do_you_wish_to_surrender")]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),(eq,":answer",0),(jump_to_menu,"mnu_captivity_start_castle_defeat"),(finish_mission,0),]),
      
      (1, 0, ti_once, [], [(play_sound,"snd_sneak_town_halt")]),
      (0, 3, 0,
       [
           (main_hero_fallen,0),
        ],
       [(jump_to_menu,"mnu_captivity_start_castle_defeat"),(finish_mission,0)]),
      (5, 1, ti_once, [(num_active_teams_le,1),(neg|main_hero_fallen)],
       [(assign,"$auto_menu",-1),(jump_to_menu,"mnu_sneak_into_town_caught_ran_away"),(finish_mission,1)]),
      (ti_on_leave_area, 0, ti_once, [],
       [(assign,"$auto_menu",-1),(jump_to_menu,"mnu_sneak_into_town_caught_ran_away"),(finish_mission,0)]),

      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_arena")], []),
      
    ],
  ),

   (
    "ai_training",0,-1,
    "You start training.",
    [
     (0,0,0,aif_start_alarmed,2,[]),
#     (1,mtef_no_leader,0,0|aif_start_alarmed,5,[]),
#     (0,mtef_no_leader,0,0|aif_start_alarmed,0,[]),
#     (3,mtef_enemy_party|mtef_reverse_order,0,aif_start_alarmed,6,[]),
#     (4,mtef_enemy_party|mtef_reverse_order,0,aif_start_alarmed,0,[]),
     ],
    [
#      (ti_before_mission_start, 0, 0, [], [(set_rain, 1,100)]),
      (ti_tab_pressed, 0, 0, [],
       [(question_box,"str_give_up_fight")]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),(eq,":answer",0),(finish_mission,0),]),

     (0, 0, 0,
      [(key_clicked, key_backspace),
       (start_presentation, "prsnt_battle"),
        ], []),

     (0.1, 0, 0,
      [(eq, "$g_presentation_battle_active", 1),
       (call_script, "script_update_order_panel_statistics_and_map"),
        ], []),


      
    ],
  ),
   (
    "camera_test",0,-1,
    "camera Test.",
    [
#     (0,mtef_attackers,0,aif_start_alarmed,5,[]),
     ],
    [
      (1, 0, 0, [(mission_cam_set_mode,1),
          (entry_point_get_position, pos3, 3),
          (mission_cam_set_position, pos3)], []),
#      (ti_before_mission_start, 0, 0, [], [(set_rain, 1,100)]),
      (ti_tab_pressed, 0, 0, [],
       [(finish_mission,0)]),
    ],
  ),

  (
    "arena_melee_fight",mtf_arena_fight,-1,
    "You enter a melee fight in the arena.",
    [
      (0,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_practice_bow,itm_practice_arrows,itm_practice_horse,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (1,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (2,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_practice_horse,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (3,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_practice_lance,itm_practice_shield,itm_practice_horse,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (4,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_practice_bow,itm_practice_arrows,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (5,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_red_tourney_armor]),
      (6,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_practice_horse,itm_red_tourney_armor]),
      (7,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_practice_lance,itm_practice_shield,itm_practice_horse,itm_red_tourney_armor, itm_red_tourney_helmet]),

      (8,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_bow,itm_practice_arrows,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (9,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_lance,itm_practice_shield,itm_practice_horse,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (10,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (11,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (12,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_bow,itm_practice_arrows,itm_practice_horse,itm_blue_tourney_armor]),
      (13,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_lance,itm_practice_shield,itm_practice_horse,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (14,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_blue_tourney_armor]),
      (15,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_blue_tourney_armor]),

      (16,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_bow,itm_practice_arrows,itm_practice_horse,itm_green_tourney_armor, itm_green_tourney_helmet]),
      (17,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_green_tourney_armor, itm_green_tourney_helmet]),
      (18,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_practice_horse,itm_green_tourney_armor, itm_green_tourney_helmet]),
      (19,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_lance,itm_practice_shield,itm_practice_horse,itm_green_tourney_armor, itm_green_tourney_helmet]),
      (20,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_bow,itm_practice_arrows,itm_green_tourney_armor, itm_green_tourney_helmet]),
      (21,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_green_tourney_armor]),
      (22,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_practice_horse,itm_green_tourney_armor]),
      (23,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_lance,itm_practice_shield,itm_practice_horse,itm_green_tourney_armor, itm_green_tourney_helmet]),

      (24,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_practice_bow,itm_practice_arrows,itm_practice_horse,itm_gold_tourney_armor, itm_gold_tourney_helmet]),
      (25,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_gold_tourney_armor, itm_gold_tourney_helmet]),
      (26,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_practice_horse,itm_gold_tourney_armor, itm_gold_tourney_helmet]),
      (27,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_practice_lance,itm_practice_shield,itm_practice_horse,itm_gold_tourney_armor, itm_gold_tourney_helmet]),
      (28,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_practice_bow,itm_practice_arrows,itm_gold_tourney_armor, itm_gold_tourney_helmet]),
      (29,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_gold_tourney_armor]),
      (30,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_practice_horse,itm_gold_tourney_armor]),
      (31,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_practice_lance,itm_practice_shield,itm_practice_horse,itm_gold_tourney_armor, itm_gold_tourney_helmet]),

      (51,mtef_visitor_source,af_override_horse|af_override_weapons|af_override_head,0,1,[]),
    ],
    [
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
      (ti_tab_pressed, 0, 0, [],
       [(question_box,"str_give_up_fight")]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),(eq,":answer",0),(finish_mission,0),]),

        
      (1, 4, ti_once, [(this_or_next|main_hero_fallen),(num_active_teams_le,1)],
       [
           (try_begin),
             (num_active_teams_le,1),
             (neg|main_hero_fallen),
             (assign,"$arena_fight_won",1),
             #Fight won, decrease odds
             (assign, ":player_odds_sub", 0),
             (try_begin),
               (ge,"$arena_bet_amount",1),
               (store_div, ":player_odds_sub", "$arena_win_amount", 2),
             (try_end),
             (party_get_slot, ":player_odds", "$g_encountered_party", slot_town_player_odds),
             (val_add, ":player_odds_sub", 5),
             (val_sub, ":player_odds", ":player_odds_sub"),
             (val_max, ":player_odds", 250),
             (party_set_slot, "$g_encountered_party", slot_town_player_odds, ":player_odds"),
           (else_try),
             #Fight lost, increase odds
             (assign, ":player_odds_add", 0),
             (try_begin),
               (ge,"$arena_bet_amount",1),
               (store_div, ":player_odds_add", "$arena_win_amount", 2),
             (try_end),
             (party_get_slot, ":player_odds", "$g_encountered_party", slot_town_player_odds),
             (val_add, ":player_odds_add", 5),
             (val_add, ":player_odds", ":player_odds_add"),
             (val_min, ":player_odds", 4000),
             (party_set_slot, "$g_encountered_party", slot_town_player_odds, ":player_odds"),
           (try_end),
           (store_remaining_team_no,"$arena_winner_team"),
           (try_begin),
             (eq, "$sneaked_into_town",1),
             (assign,reg(10),"mt_visit_town_arena_disguised"),
           (else_try),
             (assign,reg(10),"mt_visit_town_arena"),
           (try_end),
           (set_jump_mission,reg(10)),
           (party_get_slot, reg(11), "$current_town", slot_town_arena),
           (set_jump_entry, 50),
           (jump_to_scene,reg(11)),
           ]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_arena")], []),
    ],
  ),

  (
    "arena_melee_fight_no_ranged",mtf_arena_fight,-1,
    "You enter a melee fight in the arena.",
    [
      (0,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (0,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (0,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (0,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (0,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (0,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (0,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_red_tourney_armor, itm_red_tourney_helmet]),
      (0,mtef_visitor_source|mtef_team_0,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_red_tourney_armor, itm_red_tourney_helmet]),

      (8,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (8,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (8,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (8,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (8,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (8,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (8,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_blue_tourney_armor,itm_blue_tourney_helmet]),
      (8,mtef_visitor_source|mtef_team_1,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_blue_tourney_armor,itm_blue_tourney_helmet]),

      (16,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_green_tourney_armor]),
      (16,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_green_tourney_armor]),
      (16,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_green_tourney_armor]),
      (16,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_green_tourney_armor]),
      (16,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_green_tourney_armor]),
      (16,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_green_tourney_armor]),
      (16,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_green_tourney_armor]),
      (16,mtef_visitor_source|mtef_team_2,af_override_all,aif_start_alarmed,1,[itm_practice_sword,itm_practice_shield,itm_green_tourney_armor]),

      (24,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_gold_tourney_armor, itm_gold_tourney_helmet]),
      (24,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_gold_tourney_armor, itm_gold_tourney_helmet]),
      (24,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_gold_tourney_armor, itm_gold_tourney_helmet]),
      (24,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_gold_tourney_armor, itm_gold_tourney_helmet]),
      (24,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_gold_tourney_armor, itm_gold_tourney_helmet]),
      (24,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_gold_tourney_armor, itm_gold_tourney_helmet]),
      (24,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_gold_tourney_armor, itm_gold_tourney_helmet]),
      (24,mtef_visitor_source|mtef_team_3,af_override_all,aif_start_alarmed,1,[itm_heavy_practice_sword,itm_gold_tourney_armor, itm_gold_tourney_helmet]),

      (51,mtef_visitor_source,af_override_horse|af_override_weapons|af_override_head,0,1,[]),
    ],
    [
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
      (ti_tab_pressed, 0, 0, [],
       [(question_box,"str_give_up_fight")]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),(eq,":answer",0),(finish_mission,0),]),

        
      (1, 4, ti_once, [(this_or_next|main_hero_fallen),(num_active_teams_le,1)],
       [
           (try_begin),
             (num_active_teams_le,1),
             (neg|main_hero_fallen),
             (assign,"$arena_fight_won",1),
             #Fight won, decrease odds
             (assign, ":player_odds_sub", 0),
             (try_begin),
               (ge,"$arena_bet_amount",1),
               (store_div, ":player_odds_sub", "$arena_win_amount", 2),
             (try_end),
             (party_get_slot, ":player_odds", "$g_encountered_party", slot_town_player_odds),
             (val_add, ":player_odds_sub", 5),
             (val_sub, ":player_odds", ":player_odds_sub"),
             (val_max, ":player_odds", 250),
             (party_set_slot, "$g_encountered_party", slot_town_player_odds, ":player_odds"),
           (else_try),
             #Fight lost, increase odds
             (assign, ":player_odds_add", 0),
             (try_begin),
               (ge,"$arena_bet_amount",1),
               (store_div, ":player_odds_add", "$arena_win_amount", 2),
             (try_end),
             (party_get_slot, ":player_odds", "$g_encountered_party", slot_town_player_odds),
             (val_add, ":player_odds_add", 5),
             (val_add, ":player_odds", ":player_odds_add"),
             (val_max, ":player_odds", 250),
             (party_set_slot, "$g_encountered_party", slot_town_player_odds, ":player_odds"),
           (try_end),
           (store_remaining_team_no,"$arena_winner_team"),
           (try_begin),
             (eq, "$sneaked_into_town",1),
             (assign,reg(10),"mt_visit_town_arena_disguised"),
           (else_try),
             (assign,reg(10),"mt_visit_town_arena"),
           (try_end),
           (set_jump_mission,reg(10)),
           (party_get_slot, reg(11), "$current_town", slot_town_arena),
           (set_jump_entry, 50),
           (jump_to_scene,reg(11)),
           ]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_arena")], []),
    ],
  ),

##   (
##    "tutorial",0,-1,
##    "You enter the training ground.",
##    [
##        (1,mtef_leader_only,af_override_horse,0,1,[]), #af_override_weapons
##        (2,mtef_scene_source,af_override_horse,0,1,[]), #af_override_weapons
##     ],
##    [
##      (ti_tab_pressed, 0, 0, [],
##       [(question_box,"str_do_you_wish_to_leave_tutorial")]),
##      (ti_question_answered, 0, 0, [],
##       [(store_trigger_param_1,":answer"),
##        (eq,":answer",0),
##        (finish_mission,0),
##        (leave_encounter),
##        (change_screen_return),
##        (troop_remove_item, "trp_player", "itm_tutorial_sword"),
##        (troop_remove_item, "trp_player", "itm_tutorial_axe"),
##        (troop_remove_item, "trp_player", "itm_tutorial_spear"),
##        (troop_remove_item, "trp_player", "itm_tutorial_club"),
##        (troop_remove_item, "trp_player", "itm_tutorial_battle_axe"),
##        (troop_remove_item, "trp_player", "itm_tutorial_arrows"),
##        (troop_remove_item, "trp_player", "itm_tutorial_bolts"),
##        (troop_remove_item, "trp_player", "itm_tutorial_short_bow"),
##        (troop_remove_item, "trp_player", "itm_tutorial_crossbow"),
##        (troop_remove_item, "trp_player", "itm_tutorial_throwing_daggers"),
##        
##        (check_quest_active, "qst_destroy_dummies"),
##        (cancel_quest,"qst_destroy_dummies"),
##        ]),
###      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_tutorial")], []),
##      (ti_inventory_key_pressed, 0, 0, [(set_trigger_result,1)], []),
##
##        
##      (0, 0, ti_once, [],
##       [
##        (assign, "$tutorial_enter_melee", 0),
##        (assign, "$tutorial_enter_ranged", 0),
##        (assign, "$tutorial_enter_mounted", 0),
##        (assign, "$tutorial_camp_stage", 0),
##        (assign, "$tutorial_quest_taken", 0),
##        (assign, "$tutorial_quest_succeeded", 0),
##        (assign, "$tutorial_num_total_dummies_destroyed", 0),
##        (assign, "$tutorial_melee_chest", 0),
##        (assign, "$tutorial_ranged_chest", 0),
##        (assign, "$tutorial_award_taken", 0),
##
##           
##        (entry_point_get_position,2,2),#Trainer
##        (entry_point_get_position,16,16),#Horse
##        (set_spawn_position, 16),
##        (spawn_horse, "itm_tutorial_saddle_horse"),
##
##        (troop_remove_item, "trp_tutorial_chest_1", "itm_tutorial_sword"),
##        (troop_remove_item, "trp_tutorial_chest_1", "itm_tutorial_axe"),
##        (troop_remove_item, "trp_tutorial_chest_1", "itm_tutorial_spear"),
##        (troop_remove_item, "trp_tutorial_chest_1", "itm_tutorial_club"),
##        (troop_remove_item, "trp_tutorial_chest_1", "itm_tutorial_battle_axe"),
##        (troop_remove_item, "trp_tutorial_chest_2", "itm_tutorial_arrows"),
##        (troop_remove_item, "trp_tutorial_chest_2", "itm_tutorial_bolts"),
##        (troop_remove_item, "trp_tutorial_chest_2", "itm_tutorial_short_bow"),
##        (troop_remove_item, "trp_tutorial_chest_2", "itm_tutorial_crossbow"),
##        (troop_remove_item, "trp_tutorial_chest_2", "itm_tutorial_throwing_daggers"),
##        (troop_add_item, "trp_tutorial_chest_1", "itm_tutorial_sword"),
##        (troop_add_item, "trp_tutorial_chest_1", "itm_tutorial_axe"),
##        (troop_add_item, "trp_tutorial_chest_1", "itm_tutorial_spear"),
##        (troop_add_item, "trp_tutorial_chest_1", "itm_tutorial_club"),
##        (troop_add_item, "trp_tutorial_chest_1", "itm_tutorial_battle_axe"),
##        (troop_add_item, "trp_tutorial_chest_2", "itm_tutorial_arrows"),
##        (troop_add_item, "trp_tutorial_chest_2", "itm_tutorial_bolts"),
##        (troop_add_item, "trp_tutorial_chest_2", "itm_tutorial_short_bow"),
##        (troop_add_item, "trp_tutorial_chest_2", "itm_tutorial_crossbow"),
##        (troop_add_item, "trp_tutorial_chest_2", "itm_tutorial_throwing_daggers"),
##        ]
##       ),
##     
##      (1, 0, ti_once, [(store_character_level, ":player_level", "trp_player"),
##                       (le, ":player_level", 1),
##                       (get_player_agent_no, ":player_agent"),
##                       (ge, ":player_agent", 0),
##                       (agent_get_position, pos1, ":player_agent"),
##                       (entry_point_get_position,3,3),
##                       (get_distance_between_positions, ":distance_to_area", 1, 3),
##                       (lt, ":distance_to_area", 500),
##                       (eq, "$tutorial_enter_melee", 0),],
##       [(tutorial_box,"str_tutorial_enter_melee", "str_tutorial"), (val_add,"$tutorial_enter_melee", 1)]),
##      (1, 0, ti_once, [(store_character_level, ":player_level", "trp_player"),
##                       (le, ":player_level", 1),
##                       (get_player_agent_no, ":player_agent"),
##                       (ge, ":player_agent", 0),
##                       (neg|conversation_screen_is_active),
##                       (agent_get_position, pos1, ":player_agent"),
##                       (entry_point_get_position,4,4),
##                       (get_distance_between_positions, ":distance_to_area", 1, 4),
##                       (lt, ":distance_to_area", 500),
##                       (eq, "$tutorial_enter_ranged", 0),],
##       [(tutorial_box,"str_tutorial_enter_ranged", "str_tutorial"), (val_add,"$tutorial_enter_ranged", 1)]),
##      (1, 0, ti_once, [(store_character_level, ":player_level", "trp_player"),
##                       (le, ":player_level", 1),
##                       (get_player_agent_no, ":player_agent"),
##                       (ge, ":player_agent", 0),
##                       (neg|conversation_screen_is_active),
##                       (agent_get_position, pos1, ":player_agent"),
##                       (entry_point_get_position,5,5),
##                       (get_distance_between_positions, ":distance_to_area", 1, 5),
##                       (lt, ":distance_to_area", 500),
##                       (eq, "$tutorial_enter_mounted", 0),],
##       [(tutorial_box,"str_tutorial_enter_mounted", "str_tutorial"), (val_add,"$tutorial_enter_mounted", 1)]),
##
##
##      (2, 0, ti_once, [(store_character_level, ":player_level", "trp_player"),
##                       (le, ":player_level", 1),
##                       (get_player_agent_no, ":player_agent"),
##                       (ge, ":player_agent", 0),
##                       (neg|conversation_screen_is_active),
##                       (agent_get_position, pos1, ":player_agent"),
##                       (entry_point_get_position,6,6),
##                       (get_distance_between_positions, ":distance_to_area", 1, 6),
##                       (lt, ":distance_to_area", 300),
##                       (eq, "$tutorial_melee_chest", 0),],
##       [(tutorial_box,"str_tutorial_melee_chest", "str_tutorial"), (val_add,"$tutorial_melee_chest", 1)]),
##      (2, 0, ti_once, [(store_character_level, ":player_level", "trp_player"),
##                       (le, ":player_level", 1),
##                       (get_player_agent_no, ":player_agent"),
##                       (ge, ":player_agent", 0),
##                       (agent_get_position, pos1, ":player_agent"),
##                       (entry_point_get_position,7,7),
##                       (get_distance_between_positions, ":distance_to_area", 1, 7),
##                       (lt, ":distance_to_area", 300),
##                       (eq, "$tutorial_ranged_chest", 0),],
##       [(tutorial_box,"str_tutorial_ranged_chest", "str_tutorial"), (val_add,"$tutorial_ranged_chest", 1)]),
##
##      (2, 0, ti_once, [(store_character_level, ":player_level", "trp_player"),
##                       (le, ":player_level", 1),
##                       (eq, "$tutorial_item_equipped", 0),
##                       (try_begin),
##                         (troop_has_item_equipped, "trp_player", "itm_tutorial_sword"),
##                         (assign, "$tutorial_item_equipped", 1),
##                       (else_try),
##                         (troop_has_item_equipped, "trp_player", "itm_tutorial_axe"),
##                         (assign, "$tutorial_item_equipped", 1),
##                       (else_try),
##                         (troop_has_item_equipped, "trp_player", "itm_tutorial_spear"),
##                         (assign, "$tutorial_item_equipped", 1),
##                       (else_try),
##                         (troop_has_item_equipped, "trp_player", "itm_tutorial_club"),
##                         (assign, "$tutorial_item_equipped", 1),
##                       (else_try),
##                         (troop_has_item_equipped, "trp_player", "itm_tutorial_battle_axe"),
##                         (assign, "$tutorial_item_equipped", 1),
##                       (else_try),
##                         (troop_has_item_equipped, "trp_player", "itm_tutorial_arrows"),
##                         (assign, "$tutorial_item_equipped", 1),
##                       (else_try),
##                         (troop_has_item_equipped, "trp_player", "itm_tutorial_bolts"),
##                         (assign, "$tutorial_item_equipped", 1),
##                       (else_try),
##                         (troop_has_item_equipped, "trp_player", "itm_tutorial_short_bow"),
##                         (assign, "$tutorial_item_equipped", 1),
##                       (else_try),
##                         (troop_has_item_equipped, "trp_player", "itm_tutorial_crossbow"),
##                         (assign, "$tutorial_item_equipped", 1),
##                       (else_try),
##                         (troop_has_item_equipped, "trp_player", "itm_tutorial_throwing_daggers"),
##                         (assign, "$tutorial_item_equipped", 1),
##                       (try_end),
##                       (eq, "$tutorial_item_equipped", 1),],
##       [(tutorial_box,"str_tutorial_item_equipped", "str_tutorial")]),
##
##
##      
##
###      (2, 0, ti_once, [(get_player_agent_no, ":player_agent"),
###                       (agent_get_position, pos1, ":player_agent"),
###                       (entry_point_get_position,21,21),
###                       (get_distance_between_positions, ":distance_to_area", 1, 21),
###                       (lt, ":distance_to_area", 200),
###                       (eq, "$tutorial_group_of_weapons", 0),],
###       [(tutorial_box,"str_tutorial_group_of_weapons", "str_tutorial"), (val_add,"$tutorial_group_of_weapons", 1)]),
##
##      
##
##      (1, 5, ti_once, [(eq,"$tutorial_camp_stage",0),
##                       (neg|conversation_screen_is_active),
##                       (eq,"$tutorial_quest_award_taken",0),
##                       (store_character_level, ":player_level", "trp_player"),
##                       (le, ":player_level", 1),
##                       (tutorial_box,"str_tutorial_camp1","str_tutorial"),],
##          [(val_add,"$tutorial_camp_stage",1)]),
##      (1, 3, ti_once, [(eq,"$tutorial_camp_stage",1),
##                       (neg|conversation_screen_is_active),
##                       (tutorial_box,"str_tutorial_camp2","str_tutorial"),],
##          [(val_add,"$tutorial_camp_stage",1)]),
##      (1, 3, ti_once, [(eq,"$tutorial_camp_stage",2),
##                       (neg|conversation_screen_is_active),
##                       (tutorial_box,"str_tutorial_camp3","str_tutorial"),],
##          [(val_add,"$tutorial_camp_stage",1)]),
##      (1, 3, ti_once, [(eq,"$tutorial_camp_stage",3),(eq, "$tutorial_award_taken", 0),
##                       (neg|conversation_screen_is_active),
##                       (tutorial_box,"str_tutorial_camp4","str_tutorial"),],
##          [(val_add,"$tutorial_camp_stage",2)]),
##      
##     
##      (1, 3, ti_once, [(eq,"$tutorial_camp_stage",5),
##                       (neg|conversation_screen_is_active),
##                       (eq,"$tutorial_quest_taken",1),
##                       (tutorial_box,"str_tutorial_camp6","str_tutorial"),],
##          [(val_add,"$tutorial_camp_stage",1)]),
##
##      (1, 3, ti_once, [(eq,"$tutorial_camp_stage",6),
##                       (neg|conversation_screen_is_active),
##                       (ge,"$tutorial_num_total_dummies_destroyed",10),
##                       (tutorial_box,"str_tutorial_camp7","str_tutorial"),],
##          [(val_add,"$tutorial_camp_stage",1), (assign,"$tutorial_quest_succeeded",1),]),
##      
##      (1, 3, ti_once, [(eq,"$tutorial_camp_stage",7),
##                       (neg|conversation_screen_is_active),
##                       (eq,"$tutorial_quest_award_taken",1),
##                       (tutorial_box,"str_tutorial_camp8","str_tutorial"),
##                       (troop_add_proficiency_points, "trp_player", 10),
##                       (assign, "$tutorial_last_proficiency_sum", 0),
##                       (try_for_range, ":cur_attribute", 0, num_weapon_proficiencies),
##                         (store_proficiency_level, ":cur_attribute_point", "trp_player", ":cur_attribute"),
##                         (val_add, "$tutorial_last_proficiency_sum", ":cur_attribute_point"),
##                       (try_end),],
##       [(val_add,"$tutorial_camp_stage",1),]),
##      
##      (1, 3, ti_once, [(eq,"$tutorial_camp_stage",8),
##                       (neg|conversation_screen_is_active),
##                       (assign, ":new_proficiency_sum", 0),
##                       (try_for_range, ":cur_attribute", 0, num_weapon_proficiencies),
##                         (store_proficiency_level, ":cur_attribute_point", "trp_player", ":cur_attribute"),
##                         (val_add, ":new_proficiency_sum", ":cur_attribute_point"),
##                       (try_end),
##                       (assign, reg(48), ":new_proficiency_sum"),
##                       (assign, reg(49), "$tutorial_last_proficiency_sum"),
##                       (lt,"$tutorial_last_proficiency_sum",":new_proficiency_sum"),
##                       (tutorial_box,"str_tutorial_camp9","str_tutorial"),],
##          [(val_add,"$tutorial_camp_stage",1)]),
##
##      (2, 0, 0, [(check_quest_active,"qst_destroy_dummies"),
##                 (le, "$tutorial_num_total_dummies_destroyed", 10),],
##          [
##              (assign, ":progress", "$tutorial_num_total_dummies_destroyed"),
##              (val_mul, ":progress", 10),
##              (set_quest_progression,"qst_destroy_dummies",":progress"),
##              ]
##       ),
##
##    ],
##  ),

  (
    "tutorial_1",0,-1,
    "You enter the training ground.",
    [
        (0,mtef_leader_only,af_override_horse|af_override_weapons,0,1,[itm_tutorial_shield,itm_tutorial_sword,itm_tutorial_short_bow,itm_tutorial_arrows]), #af_override_weapons
     ],
    [
      (ti_tab_pressed, 0, 0, [],
       [(try_begin),
         (lt, "$tutorial_1_state", 5),
         (question_box,"str_do_you_wish_to_leave_tutorial"),
        (else_try),
          (finish_mission,0),
        (try_end),
        ]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),
        (eq,":answer",0),
        (finish_mission,0),
        ]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_tutorial")], []),

      (0, 0, ti_once, [(assign, "$tutorial_1_state", 0),
                       (assign, "$tutorial_1_msg_1_displayed", 0),
                       (assign, "$tutorial_1_msg_2_displayed", 0),
                       (assign, "$tutorial_1_msg_3_displayed", 0),
                       (assign, "$tutorial_1_msg_4_displayed", 0),
                       (assign, "$tutorial_1_msg_5_displayed", 0),
                       (assign, "$tutorial_1_msg_6_displayed", 0),
                       ], []),

      (0, 0, 0, [(try_begin),
                   (eq, "$tutorial_1_state", 0),
                   (try_begin),
                     (eq, "$tutorial_1_msg_1_displayed", 0),
                     (store_mission_timer_a, ":cur_time"),
                     (gt, ":cur_time", 0),
                     (assign, "$tutorial_1_msg_1_displayed", 1),
                     (tutorial_message, "str_tutorial_1_msg_1"),
                     (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                     (entry_point_get_position,pos1,1),
                     (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                   (try_end),
                   (tutorial_message, "str_tutorial_1_msg_1"),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position,pos2,1),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 100),
                   (val_add, "$tutorial_1_state", 1),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_a", 0),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, -90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (entry_point_get_position,pos1,2),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_1_state", 1),
                   (try_begin),
                     (eq, "$tutorial_1_msg_2_displayed", 0),
                     (assign, "$tutorial_1_msg_2_displayed", 1),
                     (tutorial_message, "str_tutorial_1_msg_2"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position,pos2,2),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 100),
                   (val_add, "$tutorial_1_state", 1),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_a", 1),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, 90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (entry_point_get_position,pos1,3),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_1_state", 2),
                   (try_begin),
                     (eq, "$tutorial_1_msg_3_displayed", 0),
                     (assign, "$tutorial_1_msg_3_displayed", 1),
                     (tutorial_message, "str_tutorial_1_msg_3"),
                     (assign, "$tutorial_num_total_dummies_destroyed", 0),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (ge, "$tutorial_num_total_dummies_destroyed", 4),
                   (val_add, "$tutorial_1_state", 1),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_a", 2),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, 90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                 (else_try),
                   (eq, "$tutorial_1_state", 3),
                   (try_begin),
                     (eq, "$tutorial_1_msg_4_displayed", 0),
                     (assign, "$tutorial_1_msg_4_displayed", 1),
                     (tutorial_message, "str_tutorial_1_msg_4"),
                     (store_mission_timer_a, "$tutorial_time"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (store_mission_timer_a, ":cur_time"),
                   (val_sub, ":cur_time", "$tutorial_time"),
                   (gt, ":cur_time", 10),
                   (val_add, "$tutorial_1_state", 1),
                 (else_try),
                   (eq, "$tutorial_1_state", 4),
                   (try_begin),
                     (eq, "$tutorial_1_msg_5_displayed", 0),
                     (assign, "$tutorial_1_msg_5_displayed", 1),
                     (tutorial_message, "str_tutorial_1_msg_5"),
                     (assign, "$g_last_archery_point_earned", 0),
                     (assign, "$tutorial_num_arrows_hit", 0),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (try_begin),
                     (get_player_agent_no, ":player_agent"),
                     (agent_get_ammo, ":cur_ammo", ":player_agent"),
                     (le, ":cur_ammo", 0),
                     (agent_refill_ammo, ":player_agent"),
                     (tutorial_message, "str_tutorial_ammo_refilled"),
                   (try_end),
                   (gt, "$g_last_archery_point_earned", 0),
                   (assign, "$g_last_archery_point_earned", 0),
                   (val_add, "$tutorial_num_arrows_hit", 1),
                   (gt, "$tutorial_num_arrows_hit", 2),
                   (val_add, "$tutorial_1_state", 1),
                 (else_try),
                   (eq, "$tutorial_1_state", 5),
                   (eq, "$tutorial_1_msg_6_displayed", 0),
                   (assign, "$tutorial_1_msg_6_displayed", 1),
                   (tutorial_message, "str_tutorial_1_msg_6"),
                   (play_sound, "snd_tutorial_2"),
                   (assign, "$tutorial_1_finished", 1),
                 (try_end),
                 ], []),
    ],
  ),


  (
    "tutorial_2",mtf_arena_fight,-1,
    "You enter the training ground.",
    [
        (0,mtef_leader_only|mtef_team_0,af_override_horse|af_override_weapons,0,1,[itm_tutorial_shield]),
        (2,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
        (4,mtef_visitor_source|mtef_team_1,0,0,1,[]),
     ],
    [
      (ti_tab_pressed, 0, 0, [],
       [(try_begin),
         (lt, "$tutorial_2_state", 9),
         (question_box,"str_do_you_wish_to_leave_tutorial"),
        (else_try),
          (finish_mission,0),
        (try_end),
        ]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),
        (eq,":answer",0),
        (finish_mission,0),
        ]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_tutorial")], []),
      (0, 0, ti_once, [
          (store_mission_timer_a, ":cur_time"),
          (gt, ":cur_time", 2),
          (main_hero_fallen),
          (assign, "$tutorial_2_state", 100),
        ], []),

      (0, 0, ti_once, [(assign, "$tutorial_2_state", 0),
                       (assign, "$tutorial_2_msg_1_displayed", 0),
                       (assign, "$tutorial_2_msg_2_displayed", 0),
                       (assign, "$tutorial_2_msg_3_displayed", 0),
                       (assign, "$tutorial_2_msg_4_displayed", 0),
                       (assign, "$tutorial_2_msg_5_displayed", 0),
                       (assign, "$tutorial_2_msg_6_displayed", 0),
                       (assign, "$tutorial_2_msg_7_displayed", 0),
                       (assign, "$tutorial_2_msg_8_displayed", 0),
                       (assign, "$tutorial_2_msg_9_displayed", 0),
                       (assign, "$tutorial_2_melee_agent_state", 0),
                       ], []),

      (10, 0, 0, [(call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_archer"),
                  (agent_refill_ammo, reg0)], []),

      (0, 0, 0, [(try_begin),
                   (eq, "$tutorial_2_state", 0),
                   (try_begin),
                     (eq, "$tutorial_2_msg_1_displayed", 0),
                     (store_mission_timer_a, ":cur_time"),
                     (gt, ":cur_time", 0),
                     (assign, "$tutorial_2_msg_1_displayed", 1),
                     (tutorial_message, "str_tutorial_2_msg_1"),
                     (team_give_order, 1, grc_everyone, mordr_stand_ground),
                     (team_give_order, 1, grc_infantry, mordr_charge),
                     (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                     (assign, ":cur_agent", reg0),
                     (agent_get_position, pos1, ":cur_agent"),
                     (agent_set_scripted_destination, ":cur_agent", pos1, 0),
                   (try_end),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position,pos2,1),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_a", 0),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, 90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (val_add, "$tutorial_2_state", 1),
                 (else_try),
                   (eq, "$tutorial_2_state", 1),
                   (scene_prop_get_instance, ":barrier_object", "spr_barrier_4m", 0),
                   (prop_instance_get_position, pos1, ":barrier_object"),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos2, ":player_agent"),
                   (position_is_behind_position, pos2, pos1),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_a", 0),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, -90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (val_add, "$tutorial_2_state", 1),
                 (else_try),
                   (eq, "$tutorial_2_state", 2),
                   (try_begin),
                     (eq, "$tutorial_2_melee_agent_state", 0),
                     (val_add, "$tutorial_2_melee_agent_state", 1),
                     (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                     (assign, ":cur_agent", reg0),
                     (entry_point_get_position, pos1, 3),
                     (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                   (else_try),
                     (eq, "$tutorial_2_melee_agent_state", 1),
                     (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                     (assign, ":cur_agent", reg0),
                     (entry_point_get_position, pos1, 3),
                     (agent_get_position, pos2, ":cur_agent"),
                     (get_distance_between_positions, ":cur_distance", pos1, pos2),
                     (le, ":cur_distance", 200),
                     (agent_clear_scripted_mode, ":cur_agent"),
                     (val_add, "$tutorial_2_melee_agent_state", 1),
                     (store_mission_timer_a,"$tutorial_time"),
                   (else_try),
                     (eq, "$tutorial_2_melee_agent_state", 2),
                     (try_begin),
                       (eq, "$tutorial_2_msg_2_displayed", 0),
                       (assign, "$tutorial_2_msg_2_displayed", 1),
                       (play_sound, "snd_tutorial_1"),
                     (try_end),
                     (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                     (assign, ":cur_agent", reg0),
                     (store_mission_timer_a,":cur_time"),
                     (val_sub, ":cur_time", "$tutorial_time"),
                     (store_sub, reg3, 20, ":cur_time"),
                     (tutorial_message, "str_tutorial_2_msg_2"),
                     (gt, ":cur_time", 20),
                     (entry_point_get_position, pos1, 3),
                     (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                     (val_add, "$tutorial_2_melee_agent_state", 1),
                   (else_try),
                     (eq, "$tutorial_2_melee_agent_state", 3),
                     (try_begin),
                       (eq, "$tutorial_2_msg_3_displayed", 0),
                       (assign, "$tutorial_2_msg_3_displayed", 1),
                       (tutorial_message, "str_tutorial_2_msg_3"),
                       (play_sound, "snd_tutorial_1"),
                     (try_end),
                     (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                     (assign, ":cur_agent", reg0),
                     (entry_point_get_position, pos1, 3),
                     (agent_get_position, pos2, ":cur_agent"),
                     (get_distance_between_positions, ":cur_distance", pos1, pos2),
                     (le, ":cur_distance", 200),
                     (entry_point_get_position, pos1, 2),
                     (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                     (val_add, "$tutorial_2_melee_agent_state", 1),
                   (else_try),
                     (eq, "$tutorial_2_melee_agent_state", 4),
                     (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                     (assign, ":cur_agent", reg0),
                     (entry_point_get_position, pos1, 2),
                     (agent_get_position, pos2, ":cur_agent"),
                     (get_distance_between_positions, ":cur_distance", pos1, pos2),
                     (le, ":cur_distance", 200),
                     (entry_point_get_position, pos1, 30),
                     (agent_set_position, ":cur_agent", pos1),
                     (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                     (scene_prop_get_instance, ":door_object", "spr_tutorial_door_a", 1),
                     (prop_instance_get_position, pos1, ":door_object"),
                     (position_rotate_z, pos1, 90),
                     (prop_instance_animate_to_position, ":door_object", pos1, 150),
                     (val_add, "$tutorial_2_melee_agent_state", 1),
                     (val_add, "$tutorial_2_state", 1),
                   (try_end),
                 (else_try),
                   (eq, "$tutorial_2_state", 3),
                   (scene_prop_get_instance, ":barrier_object", "spr_barrier_4m", 1),
                   (prop_instance_get_position, pos1, ":barrier_object"),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos2, ":player_agent"),
                   (position_is_behind_position, pos2, pos1),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_a", 1),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, -90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (store_mission_timer_a,"$tutorial_time"),
                   (val_add, "$tutorial_2_state", 1),
                 (else_try),
                   (eq, "$tutorial_2_state", 4),
                   (try_begin),
                     (eq, "$tutorial_2_msg_4_displayed", 0),
                     (assign, "$tutorial_2_msg_4_displayed", 1),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (store_mission_timer_a,":cur_time"),
                   (val_sub, ":cur_time", "$tutorial_time"),
                   (store_sub, reg3, 20, ":cur_time"),
                   (tutorial_message, "str_tutorial_2_msg_4"),
                   (gt, ":cur_time", 20),
                   (entry_point_get_position,pos1,5),
                   (set_spawn_position, pos1),
                   (spawn_item, "itm_tutorial_sword"),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                   (assign, ":cur_agent", reg0),
                   (entry_point_get_position, pos1, 3),
                   (agent_set_position, ":cur_agent", pos1),
                   (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_a", 2),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, 90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (val_add, "$tutorial_2_state", 1),
                 (else_try),
                   (eq, "$tutorial_2_state", 5),
                   (try_begin),
                     (eq, "$tutorial_2_msg_5_displayed", 0),
                     (assign, "$tutorial_2_msg_5_displayed", 1),
                     (tutorial_message, "str_tutorial_2_msg_5"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (scene_prop_get_instance, ":barrier_object", "spr_barrier_4m", 2),
                   (prop_instance_get_position, pos1, ":barrier_object"),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos2, ":player_agent"),
                   (position_is_behind_position, pos2, pos1),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_a", 2),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, -90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (val_add, "$tutorial_2_state", 1),
                 (else_try),
                   (eq, "$tutorial_2_state", 6),
                   (try_begin),
                     (eq, "$tutorial_2_msg_6_displayed", 0),
                     (assign, "$tutorial_2_msg_6_displayed", 1),
                     (tutorial_message, "str_tutorial_2_msg_6"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (get_player_agent_no, ":player_agent"),
                   (agent_has_item_equipped, ":player_agent", "itm_tutorial_sword"),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_a", 3),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, -90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (val_add, "$tutorial_2_state", 1),
                 (else_try),
                   (eq, "$tutorial_2_state", 7),
                   (try_begin),
                     (eq, "$tutorial_2_msg_7_displayed", 0),
                     (assign, "$tutorial_2_msg_7_displayed", 1),
                     (tutorial_message, "str_tutorial_2_msg_7"),
                     (play_sound, "snd_tutorial_1"),
                     (get_player_agent_no, ":player_agent"),
                     (agent_set_hit_points, ":player_agent", 100),
                   (try_end),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_archer"),
                   (assign, ":cur_agent", reg0),
                   (neg|agent_is_alive, ":cur_agent"),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                   (assign, ":cur_agent", reg0),
                   (agent_clear_scripted_mode, ":cur_agent"),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_a", 4),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, -90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (val_add, "$tutorial_2_state", 1),
                 (else_try),
                   (eq, "$tutorial_2_state", 8),
                   (try_begin),
                     (eq, "$tutorial_2_msg_8_displayed", 0),
                     (assign, "$tutorial_2_msg_8_displayed", 1),
                     (tutorial_message, "str_tutorial_2_msg_8"),
                     (play_sound, "snd_tutorial_1"),
                     (get_player_agent_no, ":player_agent"),
                     (agent_set_hit_points, ":player_agent", 100),
                   (try_end),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                   (assign, ":cur_agent", reg0),
                   (neg|agent_is_alive, ":cur_agent"),
                   (val_add, "$tutorial_2_state", 1),
                 (else_try),
                   (eq, "$tutorial_2_state", 9),
                   (eq, "$tutorial_2_msg_9_displayed", 0),
                   (assign, "$tutorial_2_msg_9_displayed", 1),
                   (tutorial_message, "str_tutorial_2_msg_9"),
                   (play_sound, "snd_tutorial_2"),
                   (assign, "$tutorial_2_finished", 1),
                 (else_try),
                   (gt, "$tutorial_2_state", 30),
                   (tutorial_message, "str_tutorial_failed"),
                 (try_end),
                 ], []),
    ],
  ),

  (
    "tutorial_3",mtf_arena_fight,-1,
    "You enter the training ground.",
    [
        (0,mtef_leader_only|mtef_team_0,af_override_horse|af_override_weapons,0,1,[]),
        (3,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
        (5,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
     ],
    [
      (ti_tab_pressed, 0, 0, [],
       [(try_begin),
         (lt, "$tutorial_3_state", 12),
         (question_box,"str_do_you_wish_to_leave_tutorial"),
        (else_try),
          (finish_mission,0),
        (try_end),
        ]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),
        (eq,":answer",0),
        (finish_mission,0),
        ]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_tutorial")], []),

      (0, 0, ti_once, [
          (store_mission_timer_a, ":cur_time"),
          (gt, ":cur_time", 2),
          (main_hero_fallen),
          (assign, "$tutorial_3_state", 100),
        ], []),

      (0, 0, ti_once, [(assign, "$tutorial_3_state", 0),
                       (assign, "$tutorial_3_msg_1_displayed", 0),
                       (assign, "$tutorial_3_msg_2_displayed", 0),
                       (assign, "$tutorial_3_msg_3_displayed", 0),
                       (assign, "$tutorial_3_msg_4_displayed", 0),
                       (assign, "$tutorial_3_msg_5_displayed", 0),
                       (assign, "$tutorial_3_msg_6_displayed", 0),
                       ], []),

      (0, 0, 0, [(try_begin),
                   (eq, "$tutorial_3_state", 0),
                   (try_begin),
                     (eq, "$tutorial_3_msg_1_displayed", 0),
                     (store_mission_timer_a, ":cur_time"),
                     (gt, ":cur_time", 0),
                     (assign, "$tutorial_3_msg_1_displayed", 1),
                     (tutorial_message, "str_tutorial_3_msg_1"),
                     (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                     (assign, ":cur_agent", reg0),
                     (agent_get_position, pos1, ":cur_agent"),
                     (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                     (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_swordsman"),
                     (assign, ":cur_agent", reg0),
                     (agent_get_position, pos1, ":cur_agent"),
                     (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                     (entry_point_get_position, pos1, 1),
                     (set_spawn_position, pos1),
                     (spawn_item, "itm_tutorial_staff_no_attack"),
                   (try_end),
                   (get_player_agent_no, ":player_agent"),
                   (agent_has_item_equipped, ":player_agent", "itm_tutorial_staff_no_attack"),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 1),
                   (try_begin),
                     (eq, "$tutorial_3_msg_2_displayed", 0),
                     (assign, "$tutorial_3_msg_2_displayed", 1),
                     (tutorial_message, "str_tutorial_3_msg_2"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position,pos2,2),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_b", 0),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, -90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 2),
                   (scene_prop_get_instance, ":barrier_object", "spr_barrier_4m", 0),
                   (prop_instance_get_position, pos1, ":barrier_object"),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos2, ":player_agent"),
                   (position_is_behind_position, pos2, pos1),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_b", 0),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, 90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 3),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                   (assign, ":cur_agent", reg0),
                   (entry_point_get_position, pos1, 4),
                   (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 4),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                   (assign, ":cur_agent", reg0),
                   (entry_point_get_position, pos1, 4),
                   (agent_get_position, pos2, ":cur_agent"),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (agent_clear_scripted_mode, ":cur_agent"),
                   (val_add, "$tutorial_3_state", 1),
                   (store_mission_timer_a,"$tutorial_time"),
                 (else_try),
                   (eq, "$tutorial_3_state", 5),
                   (try_begin),
                     (eq, "$tutorial_3_msg_3_displayed", 0),
                     (assign, "$tutorial_3_msg_3_displayed", 1),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                   (assign, ":cur_agent", reg0),
                   (store_mission_timer_a,":cur_time"),
                   (val_sub, ":cur_time", "$tutorial_time"),
                   (store_sub, reg3, 30, ":cur_time"),
                   (tutorial_message, "str_tutorial_3_msg_3"),
                   (gt, ":cur_time", 30),
                   (entry_point_get_position, pos1, 4),
                   (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 6),
                   (try_begin),
                     (eq, "$tutorial_3_msg_4_displayed", 0),
                     (assign, "$tutorial_3_msg_4_displayed", 1),
                     (tutorial_message, "str_tutorial_3_msg_4"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                   (assign, ":cur_agent", reg0),
                   (entry_point_get_position, pos1, 4),
                   (agent_get_position, pos2, ":cur_agent"),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (entry_point_get_position, pos1, 3),
                   (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 7),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                   (assign, ":cur_agent", reg0),
                   (entry_point_get_position, pos1, 3),
                   (agent_get_position, pos2, ":cur_agent"),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (entry_point_get_position, pos1, 7),
                   (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                   (agent_set_position, ":cur_agent", pos1),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_b", 1),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, -90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_b", 3),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, -90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 8),
                   (scene_prop_get_instance, ":barrier_object", "spr_barrier_4m", 1),
                   (prop_instance_get_position, pos1, ":barrier_object"),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos2, ":player_agent"),
                   (position_is_behind_position, pos2, pos1),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_b", 1),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, 90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 9),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_swordsman"),
                   (assign, ":cur_agent", reg0),
                   (entry_point_get_position, pos1, 6),
                   (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 10),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_swordsman"),
                   (assign, ":cur_agent", reg0),
                   (entry_point_get_position, pos1, 6),
                   (agent_get_position, pos2, ":cur_agent"),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (agent_clear_scripted_mode, ":cur_agent"),
                   (val_add, "$tutorial_3_state", 1),
                   (store_mission_timer_a,"$tutorial_time"),
                 (else_try),
                   (eq, "$tutorial_3_state", 11),
                   (try_begin),
                     (eq, "$tutorial_3_msg_5_displayed", 0),
                     (assign, "$tutorial_3_msg_5_displayed", 1),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_swordsman"),
                   (assign, ":cur_agent", reg0),
                   (store_mission_timer_a,":cur_time"),
                   (val_sub, ":cur_time", "$tutorial_time"),
                   (store_sub, reg3, 30, ":cur_time"),
                   (tutorial_message, "str_tutorial_3_msg_5"),
                   (gt, ":cur_time", 30),
                   (entry_point_get_position, pos1, 6),
                   (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 12),
                   (try_begin),
                     (eq, "$tutorial_3_msg_6_displayed", 0),
                     (assign, "$tutorial_3_msg_6_displayed", 1),
                     (tutorial_message, "str_tutorial_3_msg_6"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_swordsman"),
                   (assign, ":cur_agent", reg0),
                   (entry_point_get_position, pos1, 6),
                   (agent_get_position, pos2, ":cur_agent"),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (entry_point_get_position, pos1, 5),
                   (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 13),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_swordsman"),
                   (assign, ":cur_agent", reg0),
                   (entry_point_get_position, pos1, 5),
                   (agent_get_position, pos2, ":cur_agent"),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (entry_point_get_position, pos1, 7),
                   (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                   (agent_set_position, ":cur_agent", pos1),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (gt, "$tutorial_3_state", 30),
                   (tutorial_message, "str_tutorial_failed"),
                 (try_end),
                 ], []),
    ],
  ),

  (
    "tutorial_3_2",mtf_arena_fight,-1,
    "You enter the training ground.",
    [
        (0,mtef_leader_only|mtef_team_0,af_override_horse|af_override_weapons,0,1,[itm_tutorial_staff]), 
        (4,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
        (6,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
     ],
    [
      (ti_tab_pressed, 0, 0, [],
       [(try_begin),
         (lt, "$tutorial_3_state", 5),
         (question_box,"str_do_you_wish_to_leave_tutorial"),
        (else_try),
          (finish_mission,0),
        (try_end),
        ]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),
        (eq,":answer",0),
        (finish_mission,0),
        ]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_tutorial")], []),

      (0, 0, ti_once, [
          (store_mission_timer_a, ":cur_time"),
          (gt, ":cur_time", 2),
          (main_hero_fallen),
          (assign, "$tutorial_3_state", 100),
        ], []),


      (0, 0, ti_once, [(assign, "$tutorial_3_state", 0),
                       (assign, "$tutorial_3_msg_1_displayed", 0),
                       (assign, "$tutorial_3_msg_2_displayed", 0),
                       (assign, "$tutorial_3_msg_3_displayed", 0),
                       (assign, "$tutorial_3_msg_4_displayed", 0),
                       (assign, "$tutorial_3_msg_5_displayed", 0),
                       ], []),

      (0, 0, 0, [(try_begin),
                   (eq, "$tutorial_3_state", 0),
                   (try_begin),
                     (eq, "$tutorial_3_msg_1_displayed", 0),
                     (store_mission_timer_a, ":cur_time"),
                     (gt, ":cur_time", 0),
                     (assign, "$tutorial_3_msg_1_displayed", 1),
                     (tutorial_message, "str_tutorial_3_2_msg_1"),
                     (play_sound, "snd_tutorial_1"),
                     (call_script, "script_cf_get_first_agent_with_troop_id","trp_tutorial_maceman"),
                     (assign, ":cur_agent", reg0),
                     (agent_get_position, pos1, ":cur_agent"),
                     (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                     (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_swordsman"),
                     (assign, ":cur_agent", reg0),
                     (agent_get_position, pos1, ":cur_agent"),
                     (agent_set_scripted_destination, ":cur_agent", pos1, 1),
                   (try_end),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position,pos2,2),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_b", 0),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, -90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 1),
                   (try_begin),
                     (eq, "$tutorial_3_msg_2_displayed", 0),
                     (assign, "$tutorial_3_msg_2_displayed", 1),
                     (tutorial_message, "str_tutorial_3_2_msg_2"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (scene_prop_get_instance, ":barrier_object", "spr_barrier_4m", 0),
                   (prop_instance_get_position, pos1, ":barrier_object"),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos2, ":player_agent"),
                   (position_is_behind_position, pos2, pos1),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_b", 0),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, 90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                   (agent_clear_scripted_mode, reg0),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 2),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_maceman"),
                   (neg|agent_is_alive, reg0),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_b", 1),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, -90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_b", 3),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, -90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 3),
                   (try_begin),
                     (eq, "$tutorial_3_msg_3_displayed", 0),
                     (assign, "$tutorial_3_msg_3_displayed", 1),
                     (tutorial_message, "str_tutorial_3_2_msg_3"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),                 
                   (scene_prop_get_instance, ":barrier_object", "spr_barrier_4m", 1),
                   (prop_instance_get_position, pos1, ":barrier_object"),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos2, ":player_agent"),
                   (position_is_behind_position, pos2, pos1),
                   (scene_prop_get_instance, ":door_object", "spr_tutorial_door_b", 1),
                   (prop_instance_get_position, pos1, ":door_object"),
                   (position_rotate_z, pos1, 90),
                   (prop_instance_animate_to_position, ":door_object", pos1, 150),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_swordsman"),
                   (agent_clear_scripted_mode, reg0),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 4),
                   (try_begin),
                     (eq, "$tutorial_3_msg_4_displayed", 0),
                     (assign, "$tutorial_3_msg_4_displayed", 1),
                     (tutorial_message, "str_tutorial_3_2_msg_4"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (call_script, "script_cf_get_first_agent_with_troop_id", "trp_tutorial_swordsman"),
                   (neg|agent_is_alive, reg0),
                   (val_add, "$tutorial_3_state", 1),
                 (else_try),
                   (eq, "$tutorial_3_state", 5),
                   (eq, "$tutorial_3_msg_5_displayed", 0),
                   (assign, "$tutorial_3_msg_5_displayed", 1),
                   (tutorial_message, "str_tutorial_3_2_msg_5"),
                   (play_sound, "snd_tutorial_2"),
                   (assign, "$tutorial_3_finished", 1),
                 (else_try),
                   (gt, "$tutorial_3_state", 30),
                   (tutorial_message, "str_tutorial_failed"),
                 (try_end),
                 ], []),

      
    ],
  ),

  (
    "tutorial_4",mtf_arena_fight,-1,
    "You enter the training ground.",
    [
        (0,mtef_leader_only|mtef_team_0,af_override_horse|af_override_weapons,0,1,[itm_tutorial_sword,itm_tutorial_short_bow,itm_tutorial_arrows]), #af_override_weapons
     ],
    [
      (ti_tab_pressed, 0, 0, [],
       [(try_begin),
         (lt, "$tutorial_4_state", 11),
         (question_box,"str_do_you_wish_to_leave_tutorial"),
        (else_try),
          (finish_mission,0),
        (try_end),
        ]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),
        (eq,":answer",0),
        (finish_mission,0),
        ]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_tutorial")], []),

      (0, 0, ti_once, [(assign, "$tutorial_4_state", 0),
                       (assign, "$tutorial_4_msg_1_displayed", 0),
                       (assign, "$tutorial_4_msg_2_displayed", 0),
                       (assign, "$tutorial_4_msg_3_displayed", 0),
                       (assign, "$tutorial_4_msg_4_displayed", 0),
                       (assign, "$tutorial_4_msg_5_displayed", 0),
                       (assign, "$tutorial_4_msg_6_displayed", 0),
                       (assign, "$tutorial_4_msg_7_displayed", 0),
                       ], []),

      (0, 0, 0, [(try_begin),
                   (eq, "$tutorial_4_state", 0),
                   (try_begin),
                     (eq, "$tutorial_4_msg_1_displayed", 0),
                     (store_mission_timer_a, ":cur_time"),
                     (gt, ":cur_time", 0),
                     (assign, "$tutorial_4_msg_1_displayed", 1),
                     (tutorial_message, "str_tutorial_4_msg_1"),
                     (entry_point_get_position, pos1, 1),
                     (set_spawn_position, 1),
                     (spawn_horse, "itm_tutorial_saddle_horse"),
                     (assign, "$tutorial_num_total_dummies_destroyed", 0),
                   (try_end),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_horse, ":horse_agent", ":player_agent"),
                   (ge, ":horse_agent", 0),
                   (val_add, "$tutorial_4_state", 1),
                   (entry_point_get_position, pos1, 2),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_4_state", 1),
                   (try_begin),
                     (eq, "$tutorial_4_msg_2_displayed", 0),
                     (assign, "$tutorial_4_msg_2_displayed", 1),
                     (tutorial_message, "str_tutorial_4_msg_2"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position, pos2, 2),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (val_add, "$tutorial_4_state", 1),
                   (entry_point_get_position, pos1, 3),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_4_state", 2),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position, pos2, 3),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (val_add, "$tutorial_4_state", 1),
                   (entry_point_get_position, pos1, 4),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_4_state", 3),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position, pos2, 4),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (val_add, "$tutorial_4_state", 1),
                   (entry_point_get_position, pos1, 5),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_4_state", 4),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position, pos2, 5),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (val_add, "$tutorial_4_state", 1),
                   (entry_point_get_position, pos1, 6),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_4_state", 5),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position, pos2, 6),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (val_add, "$tutorial_4_state", 1),
                   (entry_point_get_position, pos1, 1),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_4_state", 6),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position, pos2, 1),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (val_add, "$tutorial_4_state", 1),
                   (entry_point_get_position, pos1, 7),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_4_state", 7),
                   (try_begin),
                     (eq, "$tutorial_4_msg_3_displayed", 0),
                     (assign, "$tutorial_4_msg_3_displayed", 1),
                     (tutorial_message, "str_tutorial_4_msg_3"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position, pos2, 7),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (val_add, "$tutorial_4_state", 1),
                   (entry_point_get_position, pos1, 20),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_4_state", 8),
                   (try_begin),
                     (eq, "$tutorial_4_msg_4_displayed", 0),
                     (assign, "$tutorial_4_msg_4_displayed", 1),
                     (tutorial_message, "str_tutorial_4_msg_4"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (ge, "$tutorial_num_total_dummies_destroyed", 2),
                   (val_add, "$tutorial_4_state", 1),
                   (entry_point_get_position, pos1, 8),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_4_state", 9),
                   (try_begin),
                     (eq, "$tutorial_4_msg_5_displayed", 0),
                     (assign, "$tutorial_4_msg_5_displayed", 1),
                     (tutorial_message, "str_tutorial_4_msg_5"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position, pos2, 8),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 200),
                   (val_add, "$tutorial_4_state", 1),
                   (entry_point_get_position, pos1, 20),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_4_state", 10),
                   (try_begin),
                     (eq, "$tutorial_4_msg_6_displayed", 0),
                     (assign, "$tutorial_4_msg_6_displayed", 1),
                     (tutorial_message, "str_tutorial_4_msg_6"),
                     (play_sound, "snd_tutorial_1"),
                     (assign, "$g_last_archery_point_earned", 0),
                     (assign, "$tutorial_num_arrows_hit", 0),
                   (try_end),
                   (try_begin),
                     (get_player_agent_no, ":player_agent"),
                     (agent_get_ammo, ":cur_ammo", ":player_agent"),
                     (le, ":cur_ammo", 0),
                     (agent_refill_ammo, ":player_agent"),
                     (tutorial_message, "str_tutorial_ammo_refilled"),
                   (try_end),
                   (gt, "$g_last_archery_point_earned", 0),
                   (assign, "$g_last_archery_point_earned", 0),
                   (val_add, "$tutorial_num_arrows_hit", 1),
                   (gt, "$tutorial_num_arrows_hit", 2),
                   (val_add, "$tutorial_4_state", 1),
                 (else_try),
                   (eq, "$tutorial_4_state", 11),
                   (eq, "$tutorial_4_msg_7_displayed", 0),
                   (assign, "$tutorial_4_msg_7_displayed", 1),
                   (tutorial_message, "str_tutorial_4_msg_7"),
                   (play_sound, "snd_tutorial_2"),
                   (assign, "$tutorial_4_finished", 1),
                 (try_end),
                 ], []),
    ],
  ),

  (
    "tutorial_5",mtf_arena_fight,-1,
    "You enter the training ground.",
    [
        (0,mtef_visitor_source|mtef_team_0,af_override_horse|af_override_weapons,0,1,[itm_tutorial_sword,itm_tutorial_shield,itm_tutorial_short_bow,itm_tutorial_arrows,itm_tutorial_saddle_horse]),
        (1,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
        (2,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
        (3,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
        (4,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
        (8,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
        (9,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
        (10,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
        (13,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
        (14,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
        (15,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
        (16,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
     ],
    [
      (ti_tab_pressed, 0, 0, [],
       [(try_begin),
         (lt, "$tutorial_5_state", 5),
         (question_box,"str_do_you_wish_to_leave_tutorial"),
        (else_try),
          (finish_mission,0),
        (try_end),
        ]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),
        (eq,":answer",0),
        (finish_mission,0),
        ]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_tutorial")], []),


      (0, 0, ti_once, [
          (store_mission_timer_a, ":cur_time"),
          (gt, ":cur_time", 2),
          (main_hero_fallen),
          (assign, "$tutorial_5_state", 100),
        ], []),

      (0, 0, ti_once, [(assign, "$tutorial_5_state", 0),
                       (assign, "$tutorial_5_msg_1_displayed", 0),
                       (assign, "$tutorial_5_msg_2_displayed", 0),
                       (assign, "$tutorial_5_msg_3_displayed", 0),
                       (assign, "$tutorial_5_msg_4_displayed", 0),
                       (assign, "$tutorial_5_msg_5_displayed", 0),
                       (assign, "$tutorial_5_msg_6_displayed", 0),
                       ], []),

      (0, 0, ti_once, [(set_show_messages, 0),
                       (team_give_order, 0, grc_everyone, mordr_stand_ground),
                       (set_show_messages, 1),
                       (store_mission_timer_a, ":cur_time"),
                       (gt, ":cur_time", 3),
                       ], []),

      (0, 0, 0, [(call_script, "script_cf_turn_windmill_fans", 0)], []),
      
      (0, 0, 0, [(try_begin),
                   (eq, "$tutorial_5_state", 0),
                   (try_begin),
                     (eq, "$tutorial_5_msg_1_displayed", 0),
                     (store_mission_timer_a, ":cur_time"),
                     (gt, ":cur_time", 0),
                     (assign, "$tutorial_5_msg_1_displayed", 1),
                     (tutorial_message, "str_tutorial_5_msg_1"),
                     (entry_point_get_position, pos1, 5),
                     (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                     (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                   (try_end),
                   (call_script, "script_cf_team_get_average_position_of_agents_with_type_to_pos1", 0, grc_infantry),
                   (entry_point_get_position, pos2, 5),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 1000),
                   (val_add, "$tutorial_5_state", 1),
                   (entry_point_get_position, pos1, 6),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_red", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_5_state", 1),
                   (try_begin),
                     (eq, "$tutorial_5_msg_2_displayed", 0),
                     (assign, "$tutorial_5_msg_2_displayed", 1),
                     (tutorial_message, "str_tutorial_5_msg_2"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (call_script, "script_cf_team_get_average_position_of_agents_with_type_to_pos1", 0, grc_infantry),
                   (entry_point_get_position, pos2, 5),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 1000),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position, pos2, 6),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 500),
                   (val_add, "$tutorial_5_state", 1),
                   (entry_point_get_position, pos1, 7),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                   (entry_point_get_position, pos1, 30),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_red", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (else_try),
                   (eq, "$tutorial_5_state", 2),
                   (try_begin),
                     (eq, "$tutorial_5_msg_3_displayed", 0),
                     (assign, "$tutorial_5_msg_3_displayed", 1),
                     (tutorial_message, "str_tutorial_5_msg_3"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (get_player_agent_no, ":player_agent"),
                   (agent_get_position, pos1, ":player_agent"),
                   (entry_point_get_position, pos2, 7),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 500),
                   (val_add, "$tutorial_5_state", 1),
                   (modify_visitors_at_site,"scn_tutorial_5"),
                   (reset_visitors),
                   (set_visitor,5,"trp_shu_archer_troop"),
                   (set_visitor,6,"trp_shu_archer_troop"),
                   (set_visitor,7,"trp_shu_archer_troop"),
                   (entry_point_get_position, pos1, 11),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                   (entry_point_get_position, pos1, 12),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_red", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                   (set_show_messages, 0),
                   (team_give_order, 0, grc_archers, mordr_stand_ground),
                   (set_show_messages, 1),
                 (else_try),
                   (eq, "$tutorial_5_state", 3),
                   (try_begin),
                     (eq, "$tutorial_5_msg_4_displayed", 0),
                     (assign, "$tutorial_5_msg_4_displayed", 1),
                     (tutorial_message, "str_tutorial_5_msg_4"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (call_script, "script_cf_team_get_average_position_of_agents_with_type_to_pos1", 0, grc_archers),
                   (entry_point_get_position, pos2, 11),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 1000),
                   (call_script, "script_cf_team_get_average_position_of_agents_with_type_to_pos1", 0, grc_infantry),
                   (entry_point_get_position, pos2, 12),
                   (get_distance_between_positions, ":cur_distance", pos1, pos2),
                   (le, ":cur_distance", 1000),
                   (val_add, "$tutorial_5_state", 1),
                   (entry_point_get_position, pos1, 30),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_red", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                   (modify_visitors_at_site,"scn_tutorial_5"),
                   (reset_visitors),
                   (set_visitor,8,"trp_mountain_bandit1"),
                   (set_visitor,9,"trp_mountain_bandit1"),
                   (set_visitor,10,"trp_mountain_bandit1"),
                   (set_visitor,11,"trp_mountain_bandit1"),
                   (team_give_order, 1, grc_everyone, mordr_charge),
                 (else_try),
                   (eq, "$tutorial_5_state", 4),
                   (try_begin),
                     (eq, "$tutorial_5_msg_5_displayed", 0),
                     (assign, "$tutorial_5_msg_5_displayed", 1),
                     (tutorial_message, "str_tutorial_5_msg_5"),
                     (play_sound, "snd_tutorial_1"),
                   (try_end),
                   (assign, ":enemy_count", 0),
                   (try_for_agents, ":cur_agent"),
                     (agent_is_human, ":cur_agent"),
                     (agent_is_alive, ":cur_agent"),
                     (agent_get_team, ":cur_team", ":cur_agent"),
                     (eq, ":cur_team", 1),
                     (val_add, ":enemy_count", 1),
                   (try_end),
                   (eq, ":enemy_count", 0),
                   (val_add, "$tutorial_5_state", 1),
                 (else_try),
                   (eq, "$tutorial_5_state", 5),
                   (eq, "$tutorial_5_msg_6_displayed", 0),
                   (assign, "$tutorial_5_msg_6_displayed", 1),
                   (tutorial_message, "str_tutorial_5_msg_6"),
                   (play_sound, "snd_tutorial_2"),
                   (assign, "$tutorial_5_finished", 1),
                 (else_try),
                   (gt, "$tutorial_5_state", 30),
                   (tutorial_message, "str_tutorial_failed"),
                   (entry_point_get_position, pos1, 30),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_yellow", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                   (scene_prop_get_instance, ":flag_object", "spr_tutorial_flag_red", 0),
                   (prop_instance_animate_to_position, ":flag_object", pos1, 1),
                 (try_end),
                 ], []),
    ],
  ),

  (
    "custom_battle",mtf_battle_mode,-1,
    "You lead your men to battle.",
    [
      (0,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (1,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (2,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (3,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (4,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (5,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (6,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (7,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),

      (8,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (9,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (10,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (11,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (12,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (13,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (14,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (15,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),

      (16,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (17,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (18,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (19,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (20,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (21,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (22,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (23,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),

      (24,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (25,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (26,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (27,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (28,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (29,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (30,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (31,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
     ],
    [
                
      (ti_tab_pressed, 0, 0, [],
       [(question_box,"str_give_up_fight")]),

      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),
        (eq,":answer",0),
        (assign, "$g_battle_result", -1),
        (assign, "$g_custom_battle_team1_death_count", 0),
        (assign, "$g_custom_battle_team2_death_count", 0),
        (try_for_agents, ":cur_agent"),
          (agent_is_human, ":cur_agent"),
          (neg|agent_is_alive, ":cur_agent"),
          (agent_get_team, ":cur_team", ":cur_agent"),
          (try_begin),
            (eq, ":cur_team", 0),
            (val_add, "$g_custom_battle_team1_death_count", 1),
          (else_try),
            (val_add, "$g_custom_battle_team2_death_count", 1),
          (try_end),
        (try_end),
        (finish_mission),]),
  
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_now")], []),

      (1, 4, ti_once, [(this_or_next|main_hero_fallen),(num_active_teams_le,1)],
       [
           (assign,"$g_battle_result",0),
           (try_begin),
             (neg|main_hero_fallen),
             (assign,"$g_battle_result",1),
           (else_try),
             (assign,"$g_battle_result",-1),
           (try_end),
           (assign, "$g_custom_battle_team1_death_count", 0),
           (assign, "$g_custom_battle_team2_death_count", 0),
           (try_for_agents, ":cur_agent"),
             (agent_is_human, ":cur_agent"),
             (neg|agent_is_alive, ":cur_agent"),
             (agent_get_team, ":cur_team", ":cur_agent"),
             (try_begin),
               (eq, ":cur_team", 0),
               (val_add, "$g_custom_battle_team1_death_count", 1),
             (else_try),
               (val_add, "$g_custom_battle_team2_death_count", 1),
             (try_end),
           (try_end),
           (finish_mission),
           ]),



##      #AI Tiggers
##      (0, 0, ti_once, [
##          (store_mission_timer_a,reg(1)),(ge,reg(1),4),
##          (call_script, "script_select_battle_tactic"),
##          (call_script, "script_battle_tactic_init"),
##          ], []),
##      (1, 0, 0, [
##          (store_mission_timer_a,reg(1)),(ge,reg(1),4),
##          (call_script, "script_battle_tactic_apply"),
##          ], []),
      
    ],
  ),

  (
    "custom_battle_siege",mtf_battle_mode,-1,
    "You lead your men to battle.",
    [
      (0,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (1,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (2,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (3,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (4,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (5,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (6,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (7,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),

      (8,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (9,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (10,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (11,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (12,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (13,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (14,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),
      (15,mtef_visitor_source|mtef_team_0,0,aif_start_alarmed,1,[]),

      (16,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (17,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (18,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (19,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (20,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (21,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (22,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (23,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),

      (24,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (25,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (26,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (27,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (28,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (29,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (30,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
      (31,mtef_visitor_source|mtef_team_1,0,aif_start_alarmed,1,[]),
     ],
    [
      (ti_before_mission_start, 0, 0, [], [(call_script, "script_change_banners")]),
                
      (ti_tab_pressed, 0, 0, [],
       [(question_box,"str_give_up_fight")]),

      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),
        (eq,":answer",0),
        (assign, "$g_battle_result", -1),
        (assign, "$g_custom_battle_team1_death_count", 0),
        (assign, "$g_custom_battle_team2_death_count", 0),
        (try_for_agents, ":cur_agent"),
          (agent_is_human, ":cur_agent"),
          (neg|agent_is_alive, ":cur_agent"),
          (agent_get_team, ":cur_team", ":cur_agent"),
          (try_begin),
            (eq, ":cur_team", 0),
            (val_add, "$g_custom_battle_team1_death_count", 1),
          (else_try),
            (val_add, "$g_custom_battle_team2_death_count", 1),
          (try_end),
        (try_end),
        (finish_mission),]),
  
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_now")], []),

      (1, 4, ti_once, [(this_or_next|main_hero_fallen),(num_active_teams_le,1)],
       [
           (assign,"$g_battle_result",0),
           (try_begin),
             (neg|main_hero_fallen),
             (assign,"$g_battle_result",1),
           (else_try),
             (assign,"$g_battle_result",-1),
           (try_end),
           (assign, "$g_custom_battle_team1_death_count", 0),
           (assign, "$g_custom_battle_team2_death_count", 0),
           (try_for_agents, ":cur_agent"),
             (agent_is_human, ":cur_agent"),
             (neg|agent_is_alive, ":cur_agent"),
             (agent_get_team, ":cur_team", ":cur_agent"),
             (try_begin),
               (eq, ":cur_team", 0),
               (val_add, "$g_custom_battle_team1_death_count", 1),
             (else_try),
               (val_add, "$g_custom_battle_team2_death_count", 1),
             (try_end),
           (try_end),
           (finish_mission),
           ]),

#refill ammo of defenders every two minutes.
      (120, 0, 0, [], [(get_player_agent_no, ":player_agent"),
                      (try_for_agents,":cur_agent"),
                        (neq, ":cur_agent", ":player_agent"),
                        (agent_is_defender, ":cur_agent"),
                        (agent_is_alive, ":cur_agent"),
                        (agent_is_human, ":cur_agent"),
                        (agent_refill_ammo, ":cur_agent"),
                      (try_end)]),

      #Init AI and Belfry
      (0, 0, ti_once, [
          (call_script, "script_siege_init_ai_and_belfry"),
          ], []),


      #Moving belfry
      (0, 0, ti_once, [(call_script, "script_cf_siege_move_belfry")], []),

      #Rotating belfry platform at the end
      (0, 4, ti_once, [(call_script, "script_cf_siege_rotate_belfry_platform"),
                       ], [(assign, "$belfry_positioned", 3)]),

      #Assigning men to the belfry
      (0, 0, ti_once, [(call_script, "script_cf_siege_assign_men_to_belfry")], []),
      #AI Tiggers
      (0, 0, ti_once, [
          (set_show_messages,0),
          (assign, "$defender_team", 0),
          (team_give_order, "$defender_team", grc_infantry, mordr_stand_closer),
          (team_give_order, "$defender_team", grc_infantry, mordr_stand_closer),
          (team_give_order, "$defender_team", grc_archers, mordr_stand_ground),
          (entry_point_get_position,pos8,10),
          (team_give_order, "$defender_team", grc_infantry, mordr_hold),
          (team_set_order_position, "$defender_team", grc_everyone, pos8),
          (set_show_messages,1),
          ], []),
    ],
  ),

  (
    "custom_battle_5",mtf_battle_mode,-1,
    "You lead your men to battle.",
    [
      (0,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[]),
      (1,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[]),
      (2,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[]),
      (3,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[]),
      (4,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[]),
      (5,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[]),
      (6,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[]),
      (7,mtef_visitor_source|mtef_team_0,af_override_horse,aif_start_alarmed,1,[]),

      (8,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (9,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (10,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (11,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (12,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (13,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (14,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
      (15,mtef_visitor_source|mtef_team_1,af_override_horse,aif_start_alarmed,1,[]),
     ],
    [
                
      (ti_tab_pressed, 0, 0, [],
       [(question_box,"str_give_up_fight")]),

      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),
        (eq,":answer",0),
        (assign, "$g_battle_result", -1),
        (assign, "$g_custom_battle_team1_death_count", 0),
        (assign, "$g_custom_battle_team2_death_count", 0),
        (try_for_agents, ":cur_agent"),
          (agent_is_human, ":cur_agent"),
          (neg|agent_is_alive, ":cur_agent"),
          (agent_get_team, ":cur_team", ":cur_agent"),
          (try_begin),
            (eq, ":cur_team", 0),
            (val_add, "$g_custom_battle_team1_death_count", 1),
          (else_try),
            (val_add, "$g_custom_battle_team2_death_count", 1),
          (try_end),
        (try_end),
        (finish_mission),]),
  
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_cant_use_inventory_now")], []),

      (1, 4, ti_once, [(this_or_next|main_hero_fallen),(num_active_teams_le,1)],
       [
           (assign,"$g_battle_result",0),
           (try_begin),
             (neg|main_hero_fallen),
             (assign,"$g_battle_result",1),
           (else_try),
             (assign,"$g_battle_result",-1),
           (try_end),
           (assign, "$g_custom_battle_team1_death_count", 0),
           (assign, "$g_custom_battle_team2_death_count", 0),
           (try_for_agents, ":cur_agent"),
             (agent_is_human, ":cur_agent"),
             (neg|agent_is_alive, ":cur_agent"),
             (agent_get_team, ":cur_team", ":cur_agent"),
             (try_begin),
               (eq, ":cur_team", 0),
               (val_add, "$g_custom_battle_team1_death_count", 1),
             (else_try),
               (val_add, "$g_custom_battle_team2_death_count", 1),
             (try_end),
           (try_end),
           (finish_mission),
           ]),

      #AI Tiggers
      (0, 0, ti_once, [
          (assign, "$ai_team", 1),
          (team_give_order, "$ai_team", grc_infantry, mordr_stand_closer),
          (team_give_order, "$ai_team", grc_infantry, mordr_stand_closer),
          (team_give_order, "$ai_team", grc_archers, mordr_stand_ground),
          (entry_point_get_position,pos8,8),
          (team_give_order, "$ai_team", grc_infantry, mordr_hold),
          (team_set_order_position, "$ai_team", grc_everyone, pos8),
          ], []),
      
      (5, 0, 0, [], [ #Make sure attackers do not stall on the ladders...
          (assign, "$attacker_team", 0),
          (try_for_agents, ":agent_no"),
            (agent_is_human, ":agent_no"),
            (agent_is_alive, ":agent_no"),
            (agent_get_team, ":agent_team", ":agent_no"),
            (eq, "$attacker_team", ":agent_team"),
            (agent_ai_set_always_attack_in_melee, ":agent_no", 1),
          (try_end),
          ]),
#refill ammo of defenders every two minutes.
      (120, 0, 0, [], [
                      (assign, "$defender_team", 1),
                      (try_for_agents,":cur_agent"),
                        (agent_get_team, ":agent_team", ":cur_agent"),
                        (eq, "$defender_team", ":agent_team"),
                        (agent_is_alive, ":cur_agent"),
                        (agent_is_human, ":cur_agent"),
                        (agent_refill_ammo, ":cur_agent"),
                      (try_end)]),
      
    ],
  ),
  
#SANGO NEW TEMPLATES
(
    "lead_charge_castle",mtf_battle_mode,charge,
    "You lead your men to battle.",
    [
        ###############################################
     (41,mtef_defenders,af_override_horse,aif_start_alarmed,2,[itm_hunting_bow,itm_arrows]),
     (42,mtef_defenders,af_override_horse,aif_start_alarmed,2,[itm_hunting_bow,itm_arrows]),
     (43,mtef_defenders,af_override_horse,aif_start_alarmed,3,[itm_hunting_bow,itm_arrows]),
     (44,mtef_defenders,af_override_horse,aif_start_alarmed,3,[itm_hunting_bow,itm_arrows]),
     #(20,mtef_defenders,af_override_horse,aif_start_alarmed,3,[itm_hunting_bow,itm_arrows]),
     (45,mtef_attackers,af_override_horse,aif_start_alarmed,3,[]),
     (46,mtef_attackers,af_override_horse,aif_start_alarmed,3,[]),
     (47,mtef_attackers,af_override_horse,aif_start_alarmed,3,[]),
     (48,mtef_attackers,af_override_horse,aif_start_alarmed,3,[]),
     #(15,mtef_attackers,af_override_horse,aif_start_alarmed,3,[]),
       #################################################
     ],
    [ (1, 1, ti_once, [],[(scene_prop_get_instance,":instance", "spr_sango_tizi", 0),
                          (entry_point_get_position,pos10,10),
                          (prop_instance_animate_to_position,":instance",pos10,10000),]),
      (ti_tab_pressed, 0, 0, [],
       [   
           (try_begin),
             (eq, "$battle_won", 1),
             (finish_mission,0),
           (else_try),
             (call_script, "script_check_enemies_nearby"),
             (question_box,"str_do_you_want_to_retreat"),
           (else_try),
             (display_message,"str_can_not_retreat"),
           (try_end),
        ]),
      (ti_question_answered, 0, 0, [],
       [(store_trigger_param_1,":answer"),(eq,":answer",0),(finish_mission,0),]),
      (ti_before_mission_start, 0, 0, [],
          [#(scene_prop_disable,"spr_sango_wall_duo"),(scene_prop_disable,"spr_exit_16m"),
           #(scene_prop_disable,"spr_exit_8m"),(scene_prop_disable,"spr_exit_4m"),
       ]),
      (0, 0, ti_once, [], [(assign,"$battle_won",0),(assign,"$defender_reinforcement_stage",0),(assign,"$attacker_reinforcement_stage",0)]),
          
          
          #####################################
          # Please read  readme.py  on  x_MT_Reinforcement_1
      #(1, 0, 5, [(lt,"$defender_reinforcement_stage",20),(store_mission_timer_a,reg(1)),(ge,reg(1),10),(store_defender_count,reg(2)),(lt,reg(2),10)],
          #[(add_reinforcements_to_entry,4,4),(val_add,"$defender_reinforcement_stage",1)]),
      #(1, 0, 5, [(lt,"$attacker_reinforcement_stage",20),(store_mission_timer_a,reg(1)),(ge,reg(1),10),(store_attacker_count,reg(2)),(lt,reg(2),10)],
          #[(add_reinforcements_to_entry,5,4),(val_add,"$attacker_reinforcement_stage",1)]),
          #####################################
          
          
          #####################################
          # Please read  readme.py  on  x_MT_Reinforcement_2
      #(1, 0, 5, [(store_mission_timer_a,reg(1)),(ge,reg(1),10),(store_defender_count,reg(2)),(lt,reg(2),10)],
           #[(add_reinforcements_to_entry,4,1),(val_add,"$defender_reinforcement_stage",1)]),
      #(1, 0, 5, [(store_mission_timer_a,reg(1)),(ge,reg(1),10),(store_attacker_count,reg(2)),(lt,reg(2),10)],
           #[(add_reinforcements_to_entry,3,1),(val_add,"$attacker_reinforcement_stage",1)]),
          #####################################
          
          
          
      (1, 60, ti_once, [(store_mission_timer_a,reg(1)),
                        (ge,reg(1),10),(all_enemies_defeated,2),
                        (neg|main_hero_fallen,0),
                        (set_mission_result,1),
                                                ################################
                                                # Please read  readme.py  on  x_MT_if_win
                                                ################################                                                
                        
                        (display_message,"str_msg_battle_won"),
                        (assign,"$battle_won",1),
                                                ],
                        [
                               
                                (finish_mission,1)
                        ]),
      (10, 0, 0, [], [(eq,"$battle_won",1),(display_message,"str_msg_battle_won")]),
      (1, 4, ti_once, [(main_hero_fallen,0)],
          [
                                
                                ########################
                                #Please read  readme.py  on  x_MT_if_lost
                                ########################
                                (set_mission_result,-1),(finish_mission,1)]),
      (ti_inventory_key_pressed, 0, 0, [(display_message,"str_use_baggage_for_inventory")], []),
          
          # attack ways work now
      (0.5, 0, 0, 
                [
                ###########
                # Please read  readme.py  on  x_MT_Waypoint_con                
               
                ###########
                ], 
                [
                        ########################
                        #Please read  readme.py  on  x_MT_Waypoint_point
                        ########################
           (get_player_agent_no, reg(20)),
           (entry_point_get_position,1,49),
           (entry_point_get_position,2,50),
           (entry_point_get_position,3,51),
           (entry_point_get_position,4,52),

          (try_for_agents,reg(5)),
             (neq, reg(5), reg(20)),
             (agent_is_alive, reg(5)),
             (agent_is_human, reg(5)),
             (neg|agent_is_defender, reg(5)),
             (agent_get_slot, reg(6), reg(5), 1),
             (str_store_agent_name,40,reg(5)),
             (assign,reg(40),reg(6)),
#             (display_message, "str_debug_string_1"),
             (agent_get_position, 5, reg(5)),
             (try_begin),
               (eq, reg(6), 0),
               (this_or_next|position_is_behind_position, 5, 2), 
               (position_is_behind_position, 5, 4),
               (get_distance_between_positions, reg(7), 5, 1),
               (get_distance_between_positions, reg(8), 5, 3),
               (try_begin),
                 (lt, reg(7), reg(8)), #agent is closer to entry point 1
                 (get_distance_between_positions, reg(10), 5, 2),
                 (ge,reg(10),110),
                 (agent_set_scripted_destination, reg(5), 1),
                 (agent_set_slot,reg(5),1,1),
               (else_try),          #agent is closer to entry point 3
                 (get_distance_between_positions, reg(10), 5, 4),
                 (ge,reg(10),110),
                 (agent_set_scripted_destination,reg(5), 3),
                 (agent_set_slot,reg(5),1,3),
               (try_end),
             (else_try),
               (get_distance_between_positions,reg(9),5,reg(6)),
               (lt, reg(9), 110),
               (try_begin),
                 (eq,reg(6),1),
                 (agent_set_scripted_destination, reg(5), 2),
                 (agent_set_slot,reg(5),1,2),
               (else_try),
                 (eq,reg(6),3),
                 (agent_set_scripted_destination, reg(5), 4),
                 (agent_set_slot,reg(5),1,4),
               (else_try),
                 (eq,reg(6),2),
                 (neg|position_is_behind_position, 5, 2), 
                 (agent_set_slot,reg(5),1,0),
                 (agent_clear_scripted_mode,reg(5)),
               (else_try),
                 (eq,reg(6),4),
                 (neg|position_is_behind_position, 5, 4), 
                 (agent_set_slot,reg(5),1,0),
                 (agent_clear_scripted_mode,reg(5)),
               (try_end),
             (try_end),
           (try_end),
        ]),
    ],
  ),


]
