from header_common import *
from header_parties import *
from ID_troops import *
from ID_factions import *
from ID_party_templates import *
from ID_map_icons import *
from ss_party_member_setting import *

####################################################################################################################
#  Each party record contains the following fields:
#  1) Party id: used for referencing parties in other files.
#     The prefix p_ is automatically added before each party id.
#  2) Party name.
#  3) Party flags. See header_parties.py for a list of available flags
#  4) Menu. ID of the menu to use when this party is met. The value 0 uses the default party encounter system.
#  5) Party-template. ID of the party template this party belongs to. Use pt_none as the default value.
#  6) Faction.
#  7) Personality. See header_parties.py for an explanation of personality flags.
#  8) Ai-behavior
#  9) Ai-target party
# 10) Initial coordinates.
# 11) List of stacks. Each stack record is a triple that contains the following fields:
#   11.1) Troop-id. 
#   11.2) Number of troops in this stack. 
#   11.3) Member flags. Use pmf_is_prisoner to note that this member is a prisoner.
# 12) Party direction in degrees [optional]
####################################################################################################################

no_menu = 0
#pf_town = pf_is_static|pf_always_visible|pf_hide_defenders|pf_show_faction
pf_town = pf_is_static|pf_always_visible|pf_show_faction|pf_label_large
pf_castle = pf_is_static|pf_always_visible|pf_show_faction|pf_label_medium
pf_village = pf_is_static|pf_always_visible|pf_hide_defenders|pf_label_small

#sample_party = [(trp_wei_heavy_cavalry,1,0), (trp_swadian_peasant,10,0), (trp_wei_archer,1,0), (trp_wei_horse_solider, 1, 0), (trp_wei_footman, 1, 0), (trp_wei_solider,1,0)]

# NEW TOWNS:
# NORMANDY: Rouen, Caen, Bayeux, Coutances, Evreux, Avranches
# Brittany: Rennes, Nantes,
# Maine: Le Mans
# Anjou: Angers

parties_defined=1

parties = [
  ("main_party","Main Party",icon_player|pf_limit_members, no_menu, pt_none,fac_player_faction,0,ai_bhvr_hold,0,(-2,  40),[(trp_player,1,0)]),
  ("temp_party","temp_party",pf_disabled, no_menu, pt_none, fac_commoners,0,ai_bhvr_hold,0,(0,0),[]),
  ("camp_bandits","camp_bandits",pf_disabled, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(1,1),[(trp_unarmed_troop,3,0)]),
#parties before this point are hardwired. Their order should not be changed.

  ("temp_party_2","temp_party_2",pf_disabled, no_menu, pt_none, fac_commoners,0,ai_bhvr_hold,0,(0,0),[]),
#Used for calculating casulties.
  ("temp_casualties","casualties",pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
  ("temp_casualties_2","casualties",pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
  ("temp_casualties_3","casualties",pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
  ("temp_wounded","enemies_wounded",pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
  ("temp_killed", "enemies_killed", pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
  ("main_party_backup","_",  pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
  ("encountered_party_backup","_",  pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
#  ("ally_party_backup","_",  pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
  ("collective_friends_backup","_",  pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
  ("player_casualties","_",  pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
  ("enemy_casualties","_",  pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
  ("ally_casualties","_",  pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
##SG begin
#  ("qi_xi_bak","_",  pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
##SG end
  ("collective_enemy","collective_enemy",pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
  #TODO: remove this and move all to collective ally
  ("collective_ally","collective_ally",pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
  ("collective_friends","collective_ally",pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),

#  ("village_reinforcements","village_reinforcements",pf_is_static|pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(1,1),[]),
#   Kal-dugun    Rinimad      
#              Rietal 
# Tuavus   Pamir   
  

  #("salt_mine","Salt_Mine",icon_village_a|pf_disabled|pf_is_static|pf_always_visible|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(14.2, -31),[]),
  #("four_ways_inn","Four_Ways_Inn",icon_village_a|pf_disabled|pf_is_static|pf_always_visible|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(4.8, -39.6),[]),
  #("test_scene","test_scene",icon_village_a|pf_disabled|pf_is_static|pf_always_visible|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(10.8, -19.6),[]),
  #("dhorak_keep","Dhorak_Keep",icon_town|pf_disabled|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-50,-58),[]),

  ("training_ground","Training Ground",  pf_disabled|icon_training_ground|pf_hide_defenders|pf_is_static|pf_always_visible, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(3, -7),[]),

  ("zendar_mercs","zendar_mercs",pf_disabled, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(0,0),[(trp_farmer,15,0)]),

  
  ("xiangping_mercs","xiangping_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("beiping_mercs","beiping_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("beihai_mercs","beihai_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("pingyuan_mercs","pingyuan_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("xiapi_mercs","xiapi_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("xiangyang_mercs","xiangyang_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("changan_mercs","changan_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("luoyang_mercs","luoyang_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("shouchun_mercs","shouchun_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("xuchang_mercs","xuchang_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("runan_mercs","runan_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("wancheng_mercs","wancheng_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("yecheng_mercs","yecheng_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("jinyang_mercs","jinyang_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("anding_mercs","anding_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("tianshui_mercs","tianshui_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("sishuiguan_mercs","sishuiguan_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("hulaoguan_mercs","hulaoguan_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("tongguan_mercs","tongguan_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("puyang_mercs","puyang_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("hefei_mercs","hefei_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),
  ("nanpi_mercs","nanpi_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_caowei,0,ai_bhvr_hold,0,(0,0),[(trp_wei_youth,15,0)]),

  ("jiangxia_mercs","jiangxia_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_shuhan,0,ai_bhvr_hold,0,(0,0),[(trp_shu_youth,15,0)]),
  ("yongan_mercs","yongan_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_shuhan,0,ai_bhvr_hold,0,(0,0),[(trp_shu_youth,15,0)]),
  ("jiangzhou_mercs","jiangzhou_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_shuhan,0,ai_bhvr_hold,0,(0,0),[(trp_shu_youth,15,0)]),
  ("chengdu_mercs","chengdu_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_shuhan,0,ai_bhvr_hold,0,(0,0),[(trp_shu_youth,15,0)]),
  ("yunnan_mercs","yunnan_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_shuhan,0,ai_bhvr_hold,0,(0,0),[(trp_shu_youth,15,0)]),
  ("shangyong_mercs","shangyong_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_shuhan,0,ai_bhvr_hold,0,(0,0),[(trp_shu_youth,15,0)]),
  ("jiangling_mercs","jiangling_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_shuhan,0,ai_bhvr_hold,0,(0,0),[(trp_shu_youth,15,0)]),
  ("jianning_mercs","jianning_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_shuhan,0,ai_bhvr_hold,0,(0,0),[(trp_shu_youth,15,0)]),
  ("zitong_mercs","zitong_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_shuhan,0,ai_bhvr_hold,0,(0,0),[(trp_shu_youth,15,0)]),
  ("hanzhong_mercs","hanzhong_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_shuhan,0,ai_bhvr_hold,0,(0,0),[(trp_shu_youth,15,0)]),
  ("jiange_mercs","jiange_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_shuhan,0,ai_bhvr_hold,0,(0,0),[(trp_shu_youth,15,0)]),

  ("jianye_mercs","jianye_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_wu,0,ai_bhvr_hold,0,(0,0),[(trp_wu_youth,15,0)]),
  ("wu_mercs","wu_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_wu,0,ai_bhvr_hold,0,(0,0),[(trp_wu_youth,15,0)]),
  ("huiji_mercs","huiji_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_wu,0,ai_bhvr_hold,0,(0,0),[(trp_wu_youth,15,0)]),
  ("chaisang_mercs","chaisang_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_wu,0,ai_bhvr_hold,0,(0,0),[(trp_wu_youth,15,0)]),
  ("changsha_mercs","changsha_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_wu,0,ai_bhvr_hold,0,(0,0),[(trp_wu_youth,15,0)]),
   ("wuling_mercs","wuling_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_wu,0,ai_bhvr_hold,0,(0,0),[(trp_wu_youth,15,0)]),
  ("lingling_mercs","lingling_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_wu,0,ai_bhvr_hold,0,(0,0),[(trp_wu_youth,15,0)]),
  ("guiyang_mercs","guiyang_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_wu,0,ai_bhvr_hold,0,(0,0),[(trp_wu_youth,15,0)]),
  ("nanhai_mercs","nanhai_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_wu,0,ai_bhvr_hold,0,(0,0),[(trp_wu_youth,15,0)]),
  ("yiling_mercs","yiling_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_wu,0,ai_bhvr_hold,0,(0,0),[(trp_wu_youth,15,0)]),
  ("jiaozhi_mercs","jiaozhi_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_wu,0,ai_bhvr_hold,0,(0,0),[(trp_wu_youth,15,0)]),
  ("jianan_mercs","jianan_mercs",pf_disabled, no_menu, pt_none, fac_kingdom_wu,0,ai_bhvr_hold,0,(0,0),[(trp_wu_youth,15,0)]),
########################################################################################
#
#
# 
# 
#
#
#                                        edit by songyx0
#
########################################################################################

#
# 
#
#########################################
# 
# 
#########################################
    ("zendar","Zendar",pf_disabled|icon_village_a|pf_hide_defenders|pf_is_static|pf_always_visible, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-24.431068,-4.604971),[(trp_mercenary,6,0)]),
    
#########################################
# 
# 
#########################################
    # 
    (
         "xiangping",        
         "Xiang_Ping",        
         pf_wi_cmn_town,    
         no_menu,             
         pt_none,             
         fac_kingdom_caowei,  
         0,                   
         ai_bhvr_hold,       
         0,                   
         (81.096916,155.962845),
         ls_cw_Lv3             
    ),
    # 
    (
        "beiping",
        "Bei_Ping", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (33.340511,128.154709),
        ls_cw_Lv2
    ),
    # 
    (
        "beihai",
        "Bei_Hai", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (51.932613,78.898865),
        ls_cw_Lv3
    ),
    # 
    (
        "pingyuan",
        "Ping_Yuan", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (10.437477,84.677124),
        ls_cw_Lv4
    ),
    # 
    (
        "xiapi",
        "Xia_Pi", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (35.090977,41.810970),
        ls_cw_Lv2
    ),
    # 
    (
        "xiangyang",
        "Xiang_Yang", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-38.374149,-4.640651),
        ls_cw_Lv2
    ),
    # 
    (
        "changan",
        "Chang_An", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-64.844734,36.336334),
        ls_cw_Lv1
    ),
    #
    (
        "luoyang",
        "Luo_Yang", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-25.586636,40.361843),
        ls_cw_Lv1
    ),
    #
    (
        "shouchun",
        "Shou_Chun", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (31.272612,15.538349),
       ls_cw_Lv2
    ),
    # 
    (
        "xuchang",
        "Xu_Chang", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-1.101759,32.502800),
        ls_cw_Lv1
    ),
    # 
    (
        "runan",
        "Ru_Nan", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-1.732446,13.095834),
        ls_cw_Lv3
    ),
    # 
    (
        "wancheng",
        "Wan_Cheng", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-25.265812,16.809984),
        ls_cw_Lv3
    ),
    # 
    (
        "yecheng",
        "Ye_Cheng", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-3.748271,58.642601),
        ls_cw_Lv2
    ),
    #
    (
        "jinyang",
        "Jin_Yang", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-28.423237,81.386864),
        ls_cw_Lv4
    ),
    # 
    (
        "anding",
        "An_Ding", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-89.206367,65.172432),
        ls_cw_Lv3
    ),
    #
    (
        "tianshui",
        "Tian_Shui", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-108.285385,40.918663),
        ls_cw_Lv3
    ),
    # 
    (
        "sishuiguan",
        "Si_Shui_Guan", 
        icon_guanka_6|pf_town|pf_hide_defenders, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-15.872573,42.087173),
        ls_cw_Lv4,90
    ),
    #
    (
        "hulaoguan",
        "Hu_Lao_Guan", 
        icon_guanka_3|pf_town|pf_hide_defenders, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-21.012539,30.392662),
        ls_cw_Lv4,90
    ),
    #
    (
        "tongguan",
        "Tong_Guan", 
        icon_guanka_4|pf_town|pf_hide_defenders, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-55.721230,35.910469),
        ls_cw_Lv4,90
    ),
    # 
    (
        "puyang",
        "Pu_Yang", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (0.831276,47.372025),
        ls_cw_Lv3
    ),
    #
    (
        "hefei",
        "He_Fei", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (24,3),
        ls_cw_Lv4
    ),
#
    (
        "nanpi",
        "Nan_Pi", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_caowei, 
        0, 
        ai_bhvr_hold, 
        0, 
        (8.919715,101.837677),
        ls_cw_Lv4
    ),
 #########################################
# 
# 
#########################################
    #
    (
        "jiangxia",
        "Jiang_Xia", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_shuhan, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-2.781169,-30.419416),
        ls_sh_Lv3
    ),
    # 
    (
        "yongan",
        "Yong_An", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_shuhan, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-53.725090,-16.381838),
        ls_sh_Lv3
    ),
    # 
    (
        "jiangzhou",
        "Jiang_Zhou", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_shuhan, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-98.452660,-38.851772),
        ls_sh_Lv3
    ),
    #
    (
        "chengdu",
        "Cheng_Du", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_shuhan, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-118.236824,-19.185915),
        ls_sh_Lv1
    ),
    #
    (
        "yunnan",
        "Yun_Nan", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_shuhan, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-131.677597,-90.554771),
        ls_sh_Lv4
    ),
    #
    (
        "shangyong",
        "Shang_Yong", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_shuhan, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-58.393154,4.229101),
        ls_sh_Lv3
    ),
    #
    (
        "jiangling",
        "Jiang_Ling", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_shuhan, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-11.054433,-16.852839),
        ls_sh_Lv1
    ),
    # 
    (
        "jianning",
        "Jian_Ning", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_shuhan, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-116.635414,-60.325455),
        ls_sh_Lv4
    ),
    # 
    (
        "zitong",
        "Zi_Tong", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_shuhan, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-121.357567,-2.568636),
        ls_sh_Lv3
    ),
    #
    (
        "hanzhong",
        "Han_Zhong", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_shuhan, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-90.298767,5.209319),
        ls_sh_Lv2
    ),
#
(
        "jiange",
        "Jian_Ge", 
       icon_guanka_8|pf_town|pf_hide_defenders, 
        no_menu, 
        pt_none, 
        fac_kingdom_shuhan, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-102.642342,0.511497),
        ls_sh_Lv4,90
    ),
#########################################
# 
#
#########################################
    # 
    (
        "jianye",
        "Jian_Ye", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_wu, 
        0, 
        ai_bhvr_hold, 
        0, 
        (50.088959,-2.410644),
        ls_sw_Lv1
    ),
    # 
    (
        "wu",
        "Wu", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_wu, 
        0, 
        ai_bhvr_hold, 
        0, 
        (71.289452,-17.241835),
        ls_sw_Lv2
    ),
    # 
    (
        "huiji",
        "Hui_Ji", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_wu, 
        0, 
        ai_bhvr_hold, 
        0, 
        (80.777214,-35.582211),
        ls_sw_Lv3
    ),
    # 
    (
        "chaisang",
        "Chai_Sang", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_wu, 
        0, 
        ai_bhvr_hold, 
        0, 
        (14.570601,-33.882965),
        ls_sw_Lv2
    ),
    # 
    (
        "changsha",
        "Chang_Sha", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_wu, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-23.528177,-52.303108),
        ls_sw_Lv2
    ),
    #
    (
        "wuling",
        "Wu_Ling", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_wu, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-48.755550,-47.875751),
        ls_sw_Lv3
    ),
    # 
    (
        "lingling",
        "Ling_Ling", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_wu, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-42.799328,-69.911095),
        ls_sw_Lv3
    ),
    #
    (
        "guiyang",
        "Gui_Yang", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_wu, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-20.396664,-74.261215),
        ls_sw_Lv3
    ),
    #
    (
        "nanhai",
        "Nan_Hai", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_wu, 
        0, 
        ai_bhvr_hold, 
        0, 
        (1.911110,-147.411102),
        ls_sw_Lv4
    ),
    # 
    (
        "yiling",
        "Yi_Ling", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_wu, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-44.161037,-24.693310),
        ls_sw_Lv4
    ),
#
(
        "jiaozhi",
        "Jiao_Zhi", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_wu, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-89.685791,-160.944992),
        ls_sw_Lv4
    ),
#
    (
        "Jianan",
        "Jian_An", 
        pf_wi_cmn_town, 
        no_menu, 
        pt_none, 
        fac_kingdom_wu, 
        0, 
        ai_bhvr_hold, 
        0, 
        (53.682690,-99.119057),
        ls_sw_Lv4
    ),


  #("castle_1","Culmarr_Castle",pf_disabled|icon_castle_a|pf_is_static|pf_always_visible, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(-47,-51),[]),
  #("castle_2","Radoghir_Castle",pf_disabled|icon_castle_a|pf_is_static|pf_always_visible, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(37,-31),[]),
  #("castle_3","castle_3",pf_disabled|icon_castle_a|pf_is_static|pf_always_visible, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(17,11),[]),
  #("castle_5","castle_5",pf_disabled|icon_castle_a|pf_is_static|pf_always_visible, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(-5,36),[]),
  #("castle_6","castle_6",pf_disabled|icon_castle_a|pf_is_static|pf_always_visible, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(5,26),[]),
  #("castle_7","castle_7",pf_disabled|icon_castle_a|pf_is_static|pf_always_visible, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(46,-6),[]),

#########################################
# 
# 
#########################################

  ("village_1", "Cun1",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(76.126862,156.951523),[], 100),
  ("village_2", "liao_xi",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(35.939053,127.035751),[], 110),
  ("village_3", "chang_yi",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(54.065731,80.712212),[], 120),
  ("village_4", "de_zhou",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(9.470044,87.079544),[], 130),
  ("village_5", "dong_hai",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(41.456142,41.581066),[], 170),
  ("village_6", "fan_cheng",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-38.435944,-0.226787),[], 100),
  ("village_7", "xian_yang",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-66.319611,34.257126),[], 110),
  ("village_8", "hong_nong",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-28.558262, 37.218018),[], 120),
  ("village_9", "cheng_de",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(33.696892,14.568796),[], 130),
  ("village_10","chen_liu",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(0.658620, 34.904835),[], 170),
  ("village_11","gu_cheng",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-4.741041,12.533281),[], 100),
  ("village_12","xin_ye",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-22.643913,11.752043),[], 110),
  ("village_13","chao_ge",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-6.440221,57.492420),[], 120),
  ("village_14","bai_ma",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-24.801785,83.072968),[], 130),
  ("village_15","shi_cheng",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-87.298714,62.770084),[], 170),

  ("village_16","chen_cang",  icon_village_snow_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-105.525192, 40.207611),[], 170),
  ("village_17","wu_chao",  icon_village_snow_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(5.035646, 52.029621),[], 170),
  ("village_18","shi_ting",  icon_village_snow_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(28.500175, -0.862144),[], 170),
  ("village_19","bo_hai",  icon_village_snow_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(13.172612, 101.123779),[], 170),
  ("village_20","wu_chang",  icon_village_snow_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(0.479915, -32.818111),[], 170),
  ("village_21","ba_dong",  icon_village_snow_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-56.563290, -15.025792),[], 100),
  ("village_22","jiang_yang",  icon_village_snow_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-103.963394, -37.270523),[], 110),
  ("village_23","guang_han",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-115.816452, -16.757669),[], 120),
  ("village_24","sha_kou",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-127.579865, -86.339462),[], 130),
  ("village_25","nan_xiang",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-54.393154, 4.229101),[], 170),
  ("village_26","chang_ban_po",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-15.963693,-19.700821),[], 170),
  ("village_27","xing_gu",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-114.335342,-61.526539),[], 170),
  ("village_28","luo_feng_po",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-123.701118,-3.813824),[], 170),
  ("village_29","ding_jun_shan",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-94.340958,10.807010),[], 170),

  ("village_30","qu_a",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(54.799568, -1.453951),[], 170),
  ("village_31","jia_xing",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(75.707924, -18.825569),[], 100),
  ("village_32","fu_chun",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(78.773621, -31.787247),[], 110),
  ("village_33","jian_chang",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(12.357951, -36.198887),[], 120),
  ("village_34","han_shou",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-27.528177, -52.303108),[], 130),
  ("village_35","cun35",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-44.755550, -47.875751),[], 170),
  ("village_36","xiang_dong",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-41.519348, -66.948685),[], 170),
  ("village_37","heng_yang",  icon_village_a|pf_village, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-22.998163, -70.920982),[], 170),
  ("village_38","cun38",pf_disabled|icon_village_a|pf_hide_defenders|pf_is_static|pf_always_visible,  no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(26, 23),[], 170),
  ("village_39","cun39",  pf_disabled|icon_village_a|pf_hide_defenders|pf_is_static|pf_always_visible, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-49, 10),[], 170),
  ("village_40","cun40",  pf_disabled|icon_village_a|pf_hide_defenders|pf_is_static|pf_always_visible,  no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(0, -50),[], 170),

("salt_mine","Salt_Mine",pf_disabled|icon_village_a|pf_is_static|pf_always_visible|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(5.007338,-27.065027),[(trp_mercenary,6,0)]),
("dhorak_keep","Dhorak_Keep",pf_disabled|icon_town|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-50,-58),[(trp_mercenary,6,0)]),
("sango","-",icon_sango|pf_is_static|pf_always_visible|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(107.476074,-164.421707),[]),
("training_ground","Training Ground",pf_disabled|icon_village_a|pf_hide_defenders|pf_is_static|pf_always_visible,  no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-17.315571,-5.134086),[]),

   # 
    (
        "bf_wuzhangyuan",
        "Wu_Zhang_Yuan", 
        pf_disabled|icon_village_a|pf_hide_defenders|pf_is_static|pf_always_visible, 
        no_menu, 
        pt_none, 
        fac_commoners, 
        0, 
        ai_bhvr_hold, 
        0, 
        (-92.210922,32.105133),
        [(trp_farmer,15,0)]
    ),
    #
    (
        "bf_chibi",
        "Chi_Bi", 
       pf_disabled|icon_village_a|pf_hide_defenders|pf_is_static|pf_always_visible, 
        no_menu, 
        pt_none, 
        fac_commoners, 
        0, 
        ai_bhvr_hold, 
        0, 
        (3.549019,-29.481377),
        [(trp_farmer,15,0)]
    ),
  ("castle_4","castle_4",pf_disabled|icon_castle_a|pf_is_static, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(-1.190135,4.461992),[]),
  ("castle_8","castle_8",pf_disabled|icon_castle_a|pf_is_static, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(2.293676,-31.643997),[]),
  ("four_ways_inn","Four_Ways_Inn",pf_disabled|icon_village_a|pf_hide_defenders|pf_is_static|pf_always_visible, no_menu, pt_none, fac_player_faction,0,ai_bhvr_hold,0,(3.8, -16.6),[(trp_mercenary,6,0)]),
  ("river_pirate_spawn_point"   ,"river_pirate_sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(6, 54.3),[(trp_mountain_bandit3,15,0)]),
  ("steppe_bandit_spawn_point"  ,"steppe_bandit_sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(-33, -60),[(trp_mountain_bandit3,15,0)]),
##  ("black_khergit_spawn_point"  ,"black_khergit_sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(47.1, -73.3),[(trp_mountain_bandit3,15,0)]),
  ("forest_bandit_spawn_point"  ,"forest_bandit_sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(-24.1, -21),[(trp_mountain_bandit3,15,0)]),
  ("mountain_bandit_spawn_point","mountain_bandit_sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(24.1, -21),[(trp_mountain_bandit3,15,0)]),
  ("sea_raider_spawn_point_1"   ,"sea_raider_sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(-32.6, 53),[(trp_mountain_bandit3,15,0)]),
  ("sea_raider_spawn_point_2"   ,"sea_raider_sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_outlaws,0,ai_bhvr_hold,0,(30.6, 66),[(trp_mountain_bandit3,15,0)]),
("point_1"   ,"sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_force_headyellow,0,ai_bhvr_hold,0,(-12.735203,-7.374756),[(trp_mountain_bandit1,15,0)]),
("point_2"   ,"sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_force_headyellow,0,ai_bhvr_hold,0,(-16.393490,27.499222),[(trp_mountain_bandit1,15,0)]),
("point_3"   ,"sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_force_defector,0,ai_bhvr_hold,0,(-12.185162,52.668789),[(trp_mountain_bandit1,15,0)]),
("point_4"   ,"sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_force_defector,0,ai_bhvr_hold,0,(36.665436,1.122281),[(trp_mountain_bandit1,15,0)]),
("point_5"   ,"sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_force_hun,0,ai_bhvr_hold,0,(-23.837618,96.006432),[(trp_mountain_bandit1,15,0)]),
("point_6"   ,"sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_force_southsavagery,0,ai_bhvr_hold,0,(-111.658371,-42.845226),[(trp_mountain_bandit1,15,0)]),
("point_7"   ,"sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_force_mountainsavagery,0,ai_bhvr_hold,0,(46.942177,-95.703041),[(trp_mountain_bandit1,15,0)]),
("point_8"   ,"sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_force_cateran,0,ai_bhvr_hold,0,(30.814571,54.148769),[(trp_mountain_bandit1,15,0)]),
("point_9"   ,"sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_force_hijacker,0,ai_bhvr_hold,0,(-7.782858,69.307396),[(trp_mountain_bandit1,15,0)]),
("point_10"   ,"sp",pf_disabled|pf_is_static, no_menu, pt_none, fac_force_hijacker,0,ai_bhvr_hold,0,(-50.806801,-7.654566),[(trp_mountain_bandit1,15,0)]),

#jia he liu
("jia1","Jia1",icon_jiaheliu_4_6_a|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-9.434672,44.386791),[(trp_mercenary,6,0)],90),
("jia2","Jia2",icon_jiaheliu_1_8|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-108.595840,42.821888),[(trp_mercenary,6,0)],90),
("jia3","Jia3",icon_jiaheliu_3_7|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-69.582718,36.823063),[(trp_mercenary,6,0)],90),
("jia4","Jia4",icon_jiaheliu_1_8|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(24.990288,18.068359),[(trp_mercenary,6,0)],90),
("jia5","Jia5",icon_jiaheliu_1_8|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-1.162785,24.933187),[(trp_mercenary,6,0)],90),
("jia6","Jia6",icon_jiaheliu_2_8|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(45.861988,-2.065292),[(trp_mercenary,6,0)],90),
("jia7","Jia7",icon_jiaheliu_1_9|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(3.929792,-29.067705),[(trp_mercenary,6,0)],90),
("jia8","Jia8",icon_jiaheliu_6_7|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-34.662300,-4.352058),[(trp_mercenary,6,0)],90),
("jia9","Jia9",icon_jiaheliu_4_6|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-44.736706,-20.939131),[(trp_mercenary,6,0)],90),
("jia10","Jia10",icon_jiaheliu_2_8|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-1.262129,58.671509),[(trp_mercenary,6,0)],90),
("jia11","Jia11",icon_jiaheliu_1_8_a|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(-111.010796,-47.5),[(trp_mercenary,6,0)],90),
("jia12","Jia12",icon_jiaheliu_3_7_a|pf_is_static|pf_always_visible|pf_no_label|pf_hide_defenders, no_menu, pt_none, fac_neutral,0,ai_bhvr_hold,0,(3.194047,54.226978),[(trp_mercenary,6,0)],90),
	
 # add extra towns before this point 
    ("spawn_points_end"                  ,"last_spawn_point",    pf_disabled|pf_is_static, no_menu, pt_none, fac_commoners,0,ai_bhvr_hold,0,(0., 0),[(trp_mountain_bandit1,15,0)]),
    ("catcher_party", "catcher_party", pf_disabled|icon_axeman|pf_no_label, no_menu, pt_none, fac_commoners,0,ai_bhvr_hold,0,(0,0),[]),

]
