from header_common import *
from header_parties import *
from ID_troops import *
from ID_factions import *
from ID_map_icons import *

pmf_is_prisoner = 0x0001

####################################################################################################################
#  Each party template record contains the following fields:
#  1) Party-template id: used for referencing party-templates in other files.
#     The prefix pt_ is automatically added before each party-template id.
#  2) Party-template name.
#  3) Party flags. See header_parties.py for a list of available flags
#  4) Menu. ID of the menu to use when this party is met. The value 0 uses the default party encounter system.
#  5) Faction
#  6) Personality. See header_parties.py for an explanation of personality flags.
#  7) List of stacks. Each stack record is a tuple that contains the following fields:
#    7.1) Troop-id. 
#    7.2) Minimum number of troops in the stack. 
#    7.3) Maximum number of troops in the stack. 
#    7.4) Member flags(optional). Use pmf_is_prisoner to note that this member is a prisoner.
#     Note: There can be at most 6 stacks.
####################################################################################################################
party_templates_defined=1

party_templates = [
  ("none","none",icon_gray_knight,0,fac_commoners,merchant_personality,[]),
  ("rescued_prisoners","Rescued Prisoners",icon_gray_knight,0,fac_commoners,merchant_personality,[]),
  ("enemy","Enemy",icon_gray_knight,0,fac_undeads,merchant_personality,[]),
  ("hero_party","Hero Party",icon_gray_knight,0,fac_commoners,merchant_personality,[]),
####################################################################################################################
# Party templates before this point are hard-wired into the game and should not be changed. 
####################################################################################################################
##  ("old_garrison","Old Garrison",icon_vaegir_knight,0,fac_player_faction,merchant_personality,[]),
  ("village_defenders","village_defenders",icon_peasant,0,fac_commoners,merchant_personality,[(trp_farmer,10,20),(trp_woman,0,4)]),

##  ("vaegir_nobleman","Vaegir Nobleman",icon_vaegir_knight|carries_goods(10)|pf_quest_party,0,fac_commoners,merchant_personality,[(trp_nobleman,1,1),(trp_shu_armed_horseman_elite,2,6),(trp_shu_horseman,4,12)]),
##  ("swadian_nobleman","Swadian Nobleman",icon_gray_knight|carries_goods(10)|pf_quest_party,0,fac_commoners,merchant_personality,[(trp_nobleman,1,1),(trp_wei_heavy_cavalry,2,6),(trp_wei_horse_solider,4,12)]),
#  ("river_pirates","River Pirates",icon_axeman|carries_goods(1),0,fac_outlaws,bandit_personality,[(trp_mountain_bandit3,3,30)]),
#  ("manhunters","Manhunters",icon_gray_knight,0,fac_manhunters,soldier_personality,[(trp_manhunter,9,40)]),
##  ("peasant","Peasant",icon_peasant,0,fac_commoners,merchant_personality,[(trp_farmer,1,6),(trp_woman,0,7)]),

#  ("black_khergit_raiders","Black Khergit Raiders",icon_khergit_horseman_b|carries_goods(2),0,fac_black_khergits,bandit_personality,[(trp_black_khergit_guard,1,10),(trp_black_khergit_horseman,5,5)]),
#  ("steppe_bandits","Steppe Bandits",icon_khergit|carries_goods(2),0,fac_outlaws,bandit_personality,[(trp_steppe_bandit,6,58)]),
#  ("forest_bandits","Forest Bandits",icon_axeman|carries_goods(2),0,fac_forest_bandits,bandit_personality,[(trp_forest_bandit,6,52)]),
#  ("mountain_bandits","Mountain Bandits",icon_axeman|carries_goods(2),0,fac_mountain_bandits,bandit_personality,[(trp_mountain_bandit2,6,60)]),
#  ("sea_raiders","Sea Raiders",icon_axeman|carries_goods(2),0,fac_outlaws,bandit_personality,[(trp_mountain_bandit4,6,50)]),

#  ("merchant_caravan","Merchant Caravan",icon_gray_knight|carries_goods(20)|pf_auto_remove_in_town|pf_quest_party,0,fac_commoners,escorted_merchant_personality,[(trp_caravan_master,1,1),(trp_mercenary,12,40)]),
#  ("troublesome_bandits","Troublesome Bandits",icon_axeman|carries_goods(9)|pf_quest_party,0,fac_outlaws,bandit_personality,[(trp_mountain_bandit1,14,55)]),
#  ("bandits_awaiting_ransom","Bandits Awaiting Ransom",icon_axeman|carries_goods(9)|pf_auto_remove_in_town|pf_quest_party,0,fac_neutral,bandit_personality,[(trp_mountain_bandit1,24,58),(trp_kidnapped_girl,1,1,pmf_is_prisoner)]),
#  ("kidnapped_girl","Kidnapped Girl",icon_woman|pf_quest_party,0,fac_neutral,merchant_personality,[(trp_kidnapped_girl,1,1)]),

##  ("farmers","Farmers",icon_peasant,0,fac_innocents,merchant_personality,[(trp_farmer,11,22),(trp_woman,16,44)]),
  ("village_farmers","Village Farmers",icon_peasant,0,fac_innocents,merchant_personality,[(trp_farmer,5,10),(trp_woman,3,8)]),
##  ("refugees","Refugees",icon_woman_b,0,fac_innocents,merchant_personality,[(trp_refugee,19,48)]),
##  ("dark_hunters","Dark Hunters",icon_gray_knight,0,fac_dark_knights,soldier_personality,[(trp_dark_knight,4,42),(trp_dark_hunter,13,25)]),

##  ("spy_partners", "Unremarkable Travellers", icon_gray_knight|carries_goods(3)|pf_default_behavior|pf_quest_party,0,fac_neutral,merchant_personality,[(trp_spy_partner,1,1),(trp_mercenary,5,11)]),
##  ("runaway_serfs","Runaway Serfs",icon_peasant|carries_goods(5)|pf_default_behavior|pf_quest_party,0,fac_neutral,merchant_personality,[(trp_farmer,6,7), (trp_woman,3,3)]),
##  ("spy", "Ordinary Townsman", icon_gray_knight|carries_goods(3)|pf_default_behavior|pf_quest_party,0,fac_neutral,merchant_personality,[(trp_spy,1,1)]),
##  ("sacrificed_messenger", "Sacrificed Messenger", icon_gray_knight|carries_goods(3)|pf_default_behavior|pf_quest_party,0,fac_neutral,merchant_personality,[]),
##  ("conspirator", "Conspirators", icon_gray_knight|carries_goods(8)|pf_default_behavior|pf_quest_party,0,fac_neutral,merchant_personality,[(trp_conspirator,3,4)]),
##  ("conspirator_leader", "Conspirator Leader", icon_gray_knight|carries_goods(8)|pf_default_behavior|pf_quest_party,0,fac_neutral,merchant_personality,[(trp_conspirator_leader,1,1)]),
##  ("peasant_rebels", "Peasant Rebels", icon_peasant,0,fac_peasant_rebels,bandit_personality,[(trp_peasant_rebel,33,97)]),
##  ("noble_refugees", "Noble Refugees", icon_gray_knight|carries_goods(12)|pf_quest_party,0,fac_noble_refugees,merchant_personality,[(trp_noble_refugee,3,5),(trp_noble_refugee_woman,5,7)]),



  ("forager_party","Foraging Party",icon_gray_knight|carries_goods(5)|pf_show_faction,0,fac_commoners,merchant_personality,[]),
  ("scout_party","Scouts",icon_gray_knight|carries_goods(1)|pf_show_faction,0,fac_commoners,bandit_personality,[]),
  ("patrol_party","Patrol",icon_gray_knight|carries_goods(2)|pf_show_faction,0,fac_commoners,soldier_personality,[]),
#  ("war_party", "War Party",icon_gray_knight|carries_goods(3),0,fac_commoners,soldier_personality,[]),
  ("messenger_party","Messenger",icon_gray_knight|pf_show_faction,0,fac_commoners,merchant_personality,[]),
  ("raider_party","Raiders",icon_gray_knight|carries_goods(16)|pf_quest_party,0,fac_commoners,bandit_personality,[]),
  ("raider_captives","Raider Captives",0,0,fac_commoners,0,[(trp_woman,6,30,pmf_is_prisoner)]),
  ("kingdom_caravan_party","Caravan",icon_mule|carries_goods(25)|pf_show_faction,0,fac_commoners,merchant_personality,[(trp_caravan_master,1,1),(trp_mercenary,12,40)]),
  ("prisoner_train_party","Prisoner Train",icon_gray_knight|carries_goods(5)|pf_show_faction,0,fac_commoners,merchant_personality,[]),
  ("default_prisoners","Default Prisoners",0,0,fac_commoners,0,[(trp_mountain_bandit1,5,10,pmf_is_prisoner)]),
#  ("deserter_party","Deserters",icon_vaegir_knight|carries_goods(1),0,fac_deserters,bandit_personality,[(trp_mercenary,8,56)]),
##  ("merchant_party","Merchant",icon_mule|carries_goods(25)|pf_show_faction,0,fac_merchants,merchant_personality,[(trp_mercenary,12,40)]),
##  ("merchant_party_reinforcement","Merchant Party Reinforcement",icon_mule|carries_goods(25),0,fac_merchants,merchant_personality,[(trp_mercenary,6,20)]),

# Caravans

  ("center_reinforcements","Reinforcements",icon_axeman|carries_goods(16),0,fac_commoners,soldier_personality,[(trp_farmer,5,30),(trp_volunteer,4,20)]),
  
#  ("kingdom_hero_party","kingdom Hero Party",icon_flagbearer_a|pf_show_faction|pf_default_behavior,0,fac_commoners,soldier_personality,[]),
  


# Reinforcements
#  ("default_reinforcements_a","default_reinforcements_a",0,0,fac_commoners,0,[(trp_mercenary,1,10),(trp_volunteer,3,16),(trp_farmer,9,24)]),
#  ("default_reinforcements_b","default_reinforcements_b",0,0,fac_commoners,0,[(trp_mercenary,1,7),(trp_mercenary,3,10),(trp_volunteer,3,15)]),
#  ("default_reinforcements_c","default_reinforcements_c",0,0,fac_commoners,0,[(trp_hired_blade,1,7),(trp_mercenary,3,10),(trp_mercenary,3,15)]),

  ("kingdom_1_reinforcements_a", "kingdom_1_reinforcements_a", 0, 0, fac_commoners, 0, [(trp_wei_light_cavalry,5,10),(trp_wei_elite_archer,4,7)]),
  ("kingdom_1_reinforcements_b", "kingdom_1_reinforcements_b", 0, 0, fac_commoners, 0, [(trp_wei_heavy_cavalry,2,10),(trp_armored_guarder,5,10)]),
  ("kingdom_1_reinforcements_c", "kingdom_1_reinforcements_c", 0, 0, fac_commoners, 0, [(trp_dragoon_elite,3,6),(trp_wei_heavy_bow_archer_elite,3,6)]),

  ("kingdom_2_reinforcements_a", "kingdom_2_reinforcements_a", 0, 0, fac_commoners, 0, [(trp_elite_shu_infantry,5,10),(trp_shu_elite_horseman,4,7)]),
  ("kingdom_2_reinforcements_b", "kingdom_2_reinforcements_b", 0, 0, fac_commoners, 0, [(trp_shu_strong_crossbowman,2,10),(trp_shu_unstopped_horseman,5,10)]),
  ("kingdom_2_reinforcements_c", "kingdom_2_reinforcements_c", 0, 0, fac_commoners, 0, [(trp_shu_armed_horseman_elite,3,6),(trp_yuan_rong_crossbowman_elite,3,6)]),

  ("kingdom_3_reinforcements_a", "kingdom_3_reinforcements_a", 0, 0, fac_commoners, 0, [(trp_wu_elite_rider,5,10),(trp_wu_trouble_dealing_army,5,10)]),
  ("kingdom_3_reinforcements_b", "kingdom_3_reinforcements_b", 0, 0, fac_commoners, 0, [(trp_wu_five_troops_bowman,2,10),(trp_feather_army,4,7)]),
  ("kingdom_3_reinforcements_c", "kingdom_3_reinforcements_c", 0, 0, fac_commoners, 0, [(trp_wu_five_troops_bowman_elite,3,6),(trp_feather_army_elite,3,6)]),

#  ("kingdom_4_reinforcements_a", "kingdom_4_reinforcements_a", 0, 0, fac_commoners, 0, [(trp_nord_footman,2,6),(trp_nord_recruit,4,7)]),
#  ("kingdom_4_reinforcements_b", "kingdom_4_reinforcements_b", 0, 0, fac_commoners, 0, [(trp_nord_trained_footman,2,5),(trp_nord_footman,3,6)]),
#  ("kingdom_4_reinforcements_c", "kingdom_4_reinforcements_c", 0, 0, fac_commoners, 0, [(trp_nord_warrior,3,6)]),

#  ("kingdom_5_reinforcements_a", "kingdom_5_reinforcements_a", 0, 0, fac_commoners, 0, [(trp_rhodok_spearman,2,6),(trp_rhodok_tribesman,4,7)]),
#  ("kingdom_5_reinforcements_b", "kingdom_5_reinforcements_b", 0, 0, fac_commoners, 0, [(trp_rhodok_trained_crossbowman,2,6),(trp_rhodok_crossbowman,4,7)]),
#  ("kingdom_5_reinforcements_c", "kingdom_5_reinforcements_c", 0, 0, fac_commoners, 0, [(trp_rhodok_sergeant,3,6)]),
 

("wei_caravan","Wei_Caravan",icon_mule|pf_show_faction,0,fac_kingdom_caowei,merchant_personality,[(trp_caravan_master,1,1),(trp_wei_light_cavalry,5,30)]),

("shu_caravan","Shu_Caravan",icon_mule|pf_show_faction,0,fac_kingdom_shuhan,merchant_personality,[(trp_caravan_master,1,1),(trp_shu_horseman,5,30)]),

("wu_caravan","Wu_Caravan",icon_mule|pf_show_faction,0,fac_kingdom_wu,merchant_personality,[(trp_caravan_master,1,1),(trp_wu_rider,5,30)]),
#
("wei_recruit_party","Wei_Recruit_Party",icon_footman_s|pf_show_faction,0,fac_kingdom_caowei,soldier_personality,[(trp_wei_youth,10,30),(trp_wei_solider,5,10),(trp_wei_horse_solider,5,10)]),

("wei_scout","Wei_Scout",icon_horseman_s|pf_show_faction,0,fac_kingdom_caowei,soldier_personality,[(trp_dragoon,1,1),(trp_wei_heavy_cavalry,5,10),(trp_wei_light_cavalry,10,20)]),

("wei_patrol","Wei_Patrol",icon_horseman_s|pf_show_faction,0,fac_kingdom_caowei,soldier_personality,[(trp_wei_lieutenant,1,1),(trp_wei_jiao_flag_holder,1,2),(trp_wei_footman,0,15),(trp_wei_archer,0,15),(trp_wei_light_cavalry,0,15)]),

("wei_small_host","Wei_Small_Host",icon_footman_m|pf_show_faction,0,fac_kingdom_caowei,soldier_personality,[(trp_wei_captain,1,1),(trp_wei_lieutenant,2,2),(trp_wei_ya_flag_holder,0,3),(trp_wei_elite_footman,0,20),(trp_wei_elite_archer,0,20),(trp_wei_heavy_cavalry,0,20)]),

("wei_host","Wei_Host",icon_footman_m|pf_show_faction,0,fac_kingdom_caowei,soldier_personality,[(trp_wei_high_capitain,1,1),(trp_wei_captain,2,2),(trp_wei_main_flag_holder,0,5),(trp_armored_guarder,0,25),(trp_wei_heavy_bow_archer,0,25),(trp_dragoon,0,25)]),

("wei_large_host","Wei_Large_Host",icon_footman_m|pf_show_faction,0,fac_kingdom_caowei,soldier_personality,[(trp_wei_general,1,1),(trp_wei_high_capitain,2,2),(trp_wei_main_flag_holder_elite,0,2),(trp_armored_guarder_elite,0,35),(trp_wei_heavy_bow_archer_elite,0,35),(trp_dragoon_elite,5,35)]),

("wei_war_party","Wei_War_Party",icon_horseman_m|pf_show_faction,0,fac_kingdom_caowei,soldier_personality,[(trp_wei_general,1,2),(trp_wei_high_capitain,2,4),(trp_wei_main_flag_holder_elite,1,5),(trp_armored_guarder_elite,5,60),(trp_wei_heavy_bow_archer_elite,5,60),(trp_dragoon_elite,5,60)]),

("tiger","Tiger",icon_footman_s|pf_show_faction,0,fac_kingdom_caowei,soldier_personality,[(trp_tiger_fighter,15,50),(trp_tiger_elite_fighter,10,30),(trp_tiger_guard,5,20)]),

("armoured_troop","Armoured_Troop",icon_footman_s|pf_show_faction,0,fac_kingdom_caowei,soldier_personality,[(trp_armoured_infantry,15,50),(trp_elite_armoured_infantry,10,30),(trp_heavy_armoured_infantry,5,20)]),

("shu_recruit_party","Shu_Recruit_Party",icon_footman_s|pf_show_faction,0,fac_kingdom_shuhan,soldier_personality,[(trp_shu_youth,10,30),(trp_shu_solider,5,10),(trp_shu_horse_solider,5,10)]),

("shu_scout","Shu_Scout",icon_horseman_s|pf_show_faction,0,fac_kingdom_shuhan,soldier_personality,[(trp_shu_armed_horseman,1,1),(trp_shu_elite_horseman,5,10),(trp_shu_horseman,10,20)]),

("shu_patrol","Shu_Patrol",icon_horseman_s|pf_show_faction,0,fac_kingdom_shuhan,soldier_personality,[(trp_shu_lieutenant,1,1),(trp_shu_jiao_flag_holder,1,2),(trp_shu_infantry,0,15),(trp_shu_archer_troop,0,15),(trp_shu_horseman,0,15)]),

("shu_small_host","Shu_Small_Host",icon_footman_m|pf_show_faction,0,fac_kingdom_shuhan,soldier_personality,[(trp_shu_captain,1,1),(trp_shu_lieutenant,2,2),(trp_shu_ya_flag_holder,0,5),(trp_elite_shu_infantry,0,20),(trp_shu_strong_crossbowman,0,20),(trp_shu_elite_horseman,0,20)]),

("shu_host","Shu_Host",icon_footman_m|pf_show_faction,0,fac_kingdom_shuhan,soldier_personality,[(trp_shu_high_capitain,1,1),(trp_shu_captain,2,2),(trp_shu_main_flag_holder,0,2),(trp_shu_unstopped_horseman,0,25),(trp_yuan_rong_crossbowman,0,25),(trp_shu_armed_horseman,0,25)]),

("shu_large_host","Shu_Large_Host",icon_footman_m|pf_show_faction,0,fac_kingdom_shuhan,soldier_personality,[(trp_shu_general,1,1),(trp_shu_high_capitain,2,2),(trp_shu_main_flag_holder_elite,0,2),(trp_shu_unstopped_horseman_elite,0,35),(trp_yuan_rong_crossbowman_elite,0,35),(trp_shu_armed_horseman_elite,0,35)]),

("shu_war_party","Shu_War_Party",icon_horseman_m|pf_show_faction,0,fac_kingdom_shuhan,soldier_personality,[(trp_shu_general,1,2),(trp_shu_high_capitain,2,4),(trp_shu_main_flag_holder_elite,1,5),(trp_shu_unstopped_horseman_elite,5,60),(trp_yuan_rong_crossbowman_elite,5,60),(trp_shu_armed_horseman_elite,5,60)]),

("western_liang_party","Western_Liang_Party",icon_horseman_s|pf_show_faction,0,fac_kingdom_shuhan,soldier_personality,[(trp_western_liang_valiant_calvary,15,50),(trp_western_liang_elite_cavalry,10,30),(trp_western_liang_heavy_cavalry,5,20)]),

("silver_guard","Silver_Guard",icon_horseman_s|pf_show_faction,0,fac_kingdom_shuhan,soldier_personality,[(trp_silver_lancer,15,50),(trp_silver_elite_lancer,10,30),(trp_silver_lancer_guard,5,20)]),

("wu_recruit_party","Wu_Recruit_Party",icon_footman_s|pf_show_faction,0,fac_kingdom_wu,soldier_personality,[(trp_wu_youth,10,30),(trp_wu_solider,5,10),(trp_wu_horse_solider,5,10)]),

("wu_scout","Wu_Scout",icon_horseman_s|pf_show_faction,0,fac_kingdom_wu,soldier_personality,[(trp_wu_tiger_rider,1,1),(trp_wu_elite_rider,5,10),(trp_wu_rider,10,20)]),

("wu_patrol","Wu_Patrol",icon_horseman_s|pf_show_faction,0,fac_kingdom_wu,soldier_personality,[(trp_wu_lieutenant,1,2),(trp_wu_jiao_flag_holder,1,2),(trp_wu_trouble_dealing_army,0,15),(trp_wu_bowman,0,15),(trp_wu_rider,0,15)]),

("wu_small_host","Wu_Small_Host",icon_footman_m|pf_show_faction,0,fac_kingdom_wu,soldier_personality,[(trp_wu_captain,1,2),(trp_wu_lieutenant,2,4),(trp_wu_ya_flag_holde,0,5),(trp_wu_hard_army,0,20),(trp_wu_elite_bowman,0,20),(trp_wu_elite_rider,0,20)]),

("wu_host","Wu_Host",icon_footman_m|pf_show_faction,0,fac_kingdom_wu,soldier_personality,[(trp_wu_high_capitain,1,2),(trp_wu_captain,2,4),(trp_wu_main_flag_holder,0,2),(trp_feather_army,0,25),(trp_wu_five_troops_bowman,0,25),(trp_wu_tiger_rider,0,25)]),

("wu_large_host","Wu_Large_Host",icon_footman_m|pf_show_faction,0,fac_kingdom_wu,soldier_personality,[(trp_wu_general,1,2),(trp_wu_high_capitain,2,4),(trp_wu_main_flag_holder_elite,0,2),(trp_feather_army_elite,0,35),(trp_wu_five_troops_bowman_elite,0,35),(trp_wu_tiger_rider_elite,0,35)]),

("wu_war_party","Wu_War_Party",icon_horseman_m|pf_show_faction,0,fac_kingdom_wu,soldier_personality,[(trp_wu_general,1,2),(trp_wu_high_capitain,2,4),(trp_wu_main_flag_holder_elite,1,5),(trp_feather_army_elite,5,60),(trp_wu_five_troops_bowman_elite,5,60),(trp_wu_tiger_rider_elite,5,60)]),

("forlorn_hope_party","Forlorn_Hope_Party",icon_horseman_s|pf_show_faction,0,fac_kingdom_wu,soldier_personality,[(trp_hundred_dead_warrior,15,50),(trp_elite_hundred_dead_warrior,10,30),(trp_forlorn_hope,5,20)]),

("horse_free_troop","Horse_free_Troop",icon_footman_s|pf_show_faction,0,fac_kingdom_wu,soldier_personality,[(trp_courage,15,50),(trp_elite_courage,10,30),(trp_horse_free_horseman,5,20)]),

("huang_jin_group","Huang_Jin_Group",icon_footman_huangjin|pf_show_faction,0,fac_force_headyellow,soldier_personality,[(trp_huang_jin_posseman,10,30),(trp_huang_jin_solider,10,20)]),

("huang_jin_earth_host","Huang_Jin_Earth_Host",icon_footman_huangjin|pf_show_faction,0,fac_force_headyellow,soldier_personality,[(trp_huang_jin_lieutenant,1,1),(trp_huang_jin_jiao_flag_holder,1,5),(trp_huang_jin_posseman,15,30),(trp_huang_jin_solider,10,25),(trp_huang_jin_calvary,5,20)]),

("huang_jin_sky_host","Huang_Jin_Sky_Host",icon_footman_huangjin|pf_show_faction,0,fac_force_headyellow,soldier_personality,[(trp_huang_jin_high_capitain,1,1),(trp_huang_jin_lieutenant,2,2),(trp_huang_jin_main_flag_holder,1,2),(trp_huang_jin_jiao_flag_holder,1,5),(trp_huang_jin_valoror,15,30),(trp_huang_jin_calvary,0,25)]),

("river_pirates","River Pirates",icon_axeman|carries_goods(1),0,fac_outlaws,bandit_personality,[(trp_mountain_bandit3,3,30)]),

("river_pirates","River_Bandits",icon_axeman|pf_show_faction,0,fac_force_cateran,bandit_personality,[(trp_mountain_bandit1,5,50)]),

("moutain_bandits","Moutain_Bandits",icon_axeman|pf_show_faction,0,fac_force_cateran,bandit_personality,[(trp_mountain_bandit2,20,100)]),

("sea_bandits","Sea_Bandits",icon_axeman|pf_show_faction,0,fac_force_hijacker,bandit_personality,[(trp_mountain_bandit3,20,60),(trp_mountain_bandit4,0,40)]),

("robbers","Robbers",icon_axeman|pf_show_faction,0,fac_force_hijacker,bandit_personality,[(trp_robber,20,70),(trp_robbers_leader,0,50)]),

("southern_man_small_host","Southern_Man_Small_Host",icon_footman_nanman|pf_show_faction,0,fac_force_southsavagery,soldier_personality,[(trp_southern_man_lieutenant,1,1),(trp_southern_man_jiao_flag_holder,1,5),(trp_southern_man_barbarian,15,35),(trp_southern_man_armyman,15,30),(trp_southern_man_berserker,5,20)]),

("southern_man_host","Southern_Man_Host",icon_footman_nanman|pf_show_faction,0,fac_force_southsavagery,soldier_personality,[(trp_southern_man_lieutenant,2,2),(trp_southern_man_main_flag_holder,1,5),(trp_southern_man_jiao_flag_holder,0,10),(trp_southern_man_armyman,15,30),(trp_southern_man_berserker,10,40),(trp_southern_man_cany_armour_solider,5,30)]),

("northern_xiong_nu_small_host","Northern_Xiong_Nu_Small_Host",icon_horseman_xn|pf_show_faction,0,fac_force_hun,soldier_personality,[(trp_northern_xiong_nu_lieutenant,1,1),(trp_northern_xiong_nu_jiao_flag_holder,1,10),(trp_northern_xiong_nu_wrangler,15,35),(trp_northern_xiong_nu_horse_bowman,10,30),(trp_northern_xiong_nu_horse_archer,5,20)]),

("northern_xiong_nu_host","Northern_Xiong_Nu_Host",icon_horseman_xn|pf_show_faction,0,fac_force_hun,soldier_personality,[(trp_northern_xiong_nu_lieutenant,2,2),(trp_northern_xiong_nu_main_flag_holder,1,5),(trp_northern_xiong_nu_jiao_flag_holder,1,10),(trp_northern_xiong_nu_horse_bowman,15,35),(trp_northern_xiong_nu_horse_archer,10,40),(trp_northern_xiong_nu_strong_horse_bowman,10,35)]),

("eastern_yue_small_host","Eastern_Yue_Small_Host",icon_footman_shanyue|pf_show_faction,0,fac_force_mountainsavagery,soldier_personality,[(trp_eastern_yue_lieutenant,1,1),(trp_eastern_yue_jiao_flag_holder,1,10),(trp_eastern_yue_refugee,15,35),(trp_eastern_yue_climb_footman,10,30),(trp_eastern_yue_flash_footman,5,20)]),

("eastern_yue_host","Eastern_Yue_Host",icon_footman_shanyue|pf_show_faction,0,fac_force_mountainsavagery,soldier_personality,[(trp_eastern_yue_lieutenant,2,2),(trp_eastern_yue_main_flag_holder,1,5),(trp_eastern_yue_jiao_flag_holder,5,10),(trp_eastern_yue_climb_footman,15,40),(trp_eastern_yue_flash_footman,15,45),(trp_eastern_yue_fly_footman,10,30)]),

("charger_troop","Charger_Troop",icon_horseman_s|pf_show_faction,0,fac_force_peasantry,soldier_personality,[(trp_gaoshun,1,1),(trp_charger_fighter,15,50),(trp_charger_elite_fighter,10,30),(trp_charger_warrior,5,20)]),

("white_horse_troop","White_Horse_Troop",icon_horseman_s|pf_show_faction,0,fac_force_peasantry,soldier_personality,[(trp_gongsunzan,1,1),(trp_white_horse_vanguard,15,50),(trp_white_horse_elite_vanguard,10,30),(trp_white_horse_follower,5,20)]),

("crushing_troop","Crushing_Troop",icon_horseman_s|pf_show_faction,0,fac_force_peasantry,soldier_personality,[(trp_yuanshao,1,1),(trp_crushing_man,15,50),(trp_crushing_elite_man,10,30),(trp_crushing_warrior,5,20)]),

("wei_riders","Shu_Riders",icon_horseman_s|pf_show_faction,0,fac_kingdom_caowei,soldier_personality,[(trp_wei_light_cavalry,10,40),(trp_wei_heavy_cavalry,5,20)]),

("shu_riders","Wei_Riders",icon_horseman_s|pf_show_faction,0,fac_kingdom_shuhan,soldier_personality,[(trp_shu_horseman,10,40),(trp_shu_elite_horseman,5,20)]),

("wu_riders","Wu_Riders",icon_horseman_s|pf_show_faction,0,fac_kingdom_wu,soldier_personality,[(trp_wu_rider,10,40),(trp_wu_elite_rider,5,20)]),

("wei_gongcheng","Wei Gong Cheng Da Jun",icon_gray_knight|pf_show_faction,0,fac_kingdom_caowei,soldier_personality,[(trp_wei_general,1,2),(trp_wei_high_capitain,2,4),(trp_wei_main_flag_holder_elite,5,30),(trp_armored_guarder_elite,5,60),(trp_wei_heavy_bow_archer_elite,5,60),(trp_dragoon_elite,5,60)]),

("shu_gongcheng","Shu Gong Cheng Da Jun",icon_khergit|pf_show_faction,0,fac_kingdom_shuhan,soldier_personality,[(trp_shu_general,1,2),(trp_shu_high_capitain,2,4),(trp_shu_main_flag_holder_elite,5,30),(trp_shu_unstopped_horseman_elite,5,60),(trp_yuan_rong_crossbowman_elite,5,60),(trp_shu_armed_horseman_elite,5,60)]),

("wu_gongcheng","Wu  Gong Cheng Da Jun",icon_vaegir_knight|pf_show_faction,0,fac_kingdom_wu,soldier_personality,[(trp_wu_general,1,2),(trp_wu_high_capitain,2,4),(trp_wu_main_flag_holder_elite,5,30),(trp_feather_army_elite,5,60),(trp_wu_five_troops_bowman_elite,5,60),(trp_wu_tiger_rider_elite,5,60)]),

("kingdom_hero_party","kingdom Hero Party",icon_flagbearer_a|pf_show_faction|pf_default_behavior,0,fac_commoners,soldier_personality,[]),
#
("peasant","Farmers",icon_peasant|pf_show_faction,0,fac_force_peasantry,merchant_personality,[(trp_farmer,2,40),(trp_woman,2,40)]),

("wei_nobleman","Shu_Nobleman",icon_khergit|pf_show_faction,0,fac_kingdom_caowei,soldier_personality,[(trp_nobleman,1,1),(trp_wei_heavy_cavalry,10,30)]),

("shu_nobleman","Wei_Nobleman",icon_gray_knight|pf_show_faction,0,fac_kingdom_shuhan,soldier_personality,[(trp_nobleman,1,1),(trp_shu_elite_horseman,10,30)]),

("wu_nobleman","Wu_Nobleman",icon_vaegir_knight|pf_show_faction,0,fac_kingdom_wu,soldier_personality,[(trp_nobleman,1,1),(trp_wu_elite_rider,10,30)]),

("bandits_awaiting_ransom","Bandits Awaiting Ransom",icon_axeman,0,fac_neutral,merchant_personality,[(trp_robber,20,70),(trp_robbers_leader,5,30)]),

("troublesome_bandits","Troublesome_bandits ",icon_axeman,0,fac_force_hijacker,soldier_personality,[(trp_robber,10,70),(trp_robbers_leader,5,30)]),

("kidnapped_girl","Kidnapped Girl",icon_woman|pf_quest_party,0,fac_neutral,merchant_personality,[(trp_kidnapped_girl,1,1)]),

("merchant_caravan","Merchant Caravan",icon_mule|pf_show_faction,0,fac_force_peasantry,merchant_personality,[(trp_caravan_master,1,1),(trp_mercenary,10,40),(trp_perdue,5,20)]),

("mintuan","Mintuan",icon_footman_m|pf_show_faction|pf_always_visible,0,fac_player_faction,soldier_personality,[(trp_yijun_leader,1,1),(trp_volunteer,15,15),(trp_voluntary_footman,12,12),(trp_mercenary,8,8),(trp_perdue,5,5)]),

("catcher_party", "_", icon_player|pf_no_label, 0, fac_neutral, soldier_personality,[(trp_player,1,1)]),  

##  ("kingdom_1_reinforcements_a", "kingdom_1_reinforcements_a", 0, 0, fac_commoners, 0, [(trp_wei_footman,3,7),(trp_wei_elite_archer,5,10),(trp_wei_solider,11,26)]),
##  ("kingdom_1_reinforcements_b", "kingdom_1_reinforcements_b", 0, 0, fac_commoners, 0, [(trp_wei_horse_solider,5,10),(trp_wei_elite_footman,5,10),(trp_wei_archer,3,8)]),
##  ("kingdom_1_reinforcements_c", "kingdom_1_reinforcements_c", 0, 0, fac_commoners, 0, [(trp_wei_heavy_cavalry,2,6),(trp_wei_elite_footman,2,5),(trp_wei_heavy_bow_archer,2,5)]),
##
##  ("kingdom_2_reinforcements_a", "kingdom_2_reinforcements_a", 0, 0, fac_commoners, 0, [(trp_shu_infantry,3,7),(trp_shu_strong_crossbowman,5,10),(trp_shu_solider,11,26)]),
##  ("kingdom_2_reinforcements_b", "kingdom_2_reinforcements_b", 0, 0, fac_commoners, 0, [(trp_shu_horseman,4,9),(trp_elite_shu_infantry,5,10),(trp_shu_archer_troop,3,8)]),
##  ("kingdom_2_reinforcements_c", "kingdom_2_reinforcements_c", 0, 0, fac_commoners, 0, [(trp_shu_armed_horseman_elite,3,7),(trp_elite_shu_infantry,2,5),(trp_yuan_rong_crossbowman,2,5)]),
##
##  ("kingdom_3_reinforcements_a", "kingdom_3_reinforcements_a", 0, 0, fac_commoners, 0, [(trp_feather_army,3,7),(trp_wu_solider,5,10),(trp_wu_youth,11,26)]),
##  ("kingdom_3_reinforcements_b", "kingdom_3_reinforcements_b", 0, 0, fac_commoners, 0, [(trp_wu_elite_rider,4,9),(trp_feather_army_elite,5,10),(trp_feather_army,3,8)]),
##  ("kingdom_3_reinforcements_c", "kingdom_3_reinforcements_c", 0, 0, fac_commoners, 0, [(trp_wu_tiger_rider,3,7),(trp_wu_elite_rider,2,5),(trp_feather_army_elite,2,5)]),
##
##  ("kingdom_4_reinforcements_a", "kingdom_4_reinforcements_a", 0, 0, fac_commoners, 0, [(trp_nord_trained_footman,3,7),(trp_nord_footman,5,10),(trp_nord_recruit,11,26)]),
##  ("kingdom_4_reinforcements_b", "kingdom_4_reinforcements_b", 0, 0, fac_commoners, 0, [(trp_nord_veteran,4,9),(trp_nord_warrior,5,10),(trp_nord_footman,3,8)]),
##  ("kingdom_4_reinforcements_c", "kingdom_4_reinforcements_c", 0, 0, fac_commoners, 0, [(trp_nord_champion,1,3),(trp_nord_veteran,2,5),(trp_nord_warrior,2,5)]),
##
##  ("kingdom_5_reinforcements_a", "kingdom_5_reinforcements_a", 0, 0, fac_commoners, 0, [(trp_rhodok_spearman,3,7),(trp_rhodok_crossbowman,5,10),(trp_rhodok_tribesman,11,26)]),
##  ("kingdom_5_reinforcements_b", "kingdom_5_reinforcements_b", 0, 0, fac_commoners, 0, [(trp_rhodok_trained_spearman,4,9),(trp_rhodok_spearman,5,10),(trp_rhodok_crossbowman,3,8)]),
##  ("kingdom_5_reinforcements_c", "kingdom_5_reinforcements_c", 0, 0, fac_commoners, 0, [(trp_rhodok_sergeant,3,7),(trp_rhodok_veteran_spearman,2,5),(trp_rhodok_veteran_crossbowman,2,5)]),
("wei_patrol_reinf_1", "wei_patrol_reinf_1", 0, 0, fac_commoners, 0, [(trp_wei_solider,8,16),(trp_wei_horse_solider,7,14)]),
("wei_shost_reinf_1", "wei_shost_reinf_1", 0, 0, fac_commoners, 0, [(trp_wei_jiao_flag_holder,6,12),(trp_wei_footman,8,16),(trp_wei_archer,8,16),(trp_wei_light_cavalry,8,16)]),
("wei_host_reinf_1", "wei_host_reinf_1", 0, 0, fac_commoners, 0, [(trp_wei_lieutenant,3,6),(trp_wei_ya_flag_holder,6,12),(trp_wei_elite_footman,8,16),(trp_wei_elite_archer,8,16),(trp_wei_heavy_cavalry,8,16),(trp_wei_jiao_flag_holder,9,18)]),
("wei_host_reinf_2", "wei_host_reinf_2", 0, 0, fac_commoners, 0, [(trp_wei_footman,12,24),(trp_wei_archer,12,24),(trp_wei_light_cavalry,12,24)]),
("wei_lhost_reinf_1", "wei_lhost_reinf_1", 0, 0, fac_commoners, 0, [(trp_wei_lieutenant,5,10),(trp_wei_captain,3,6),(trp_wei_main_flag_holder,6,12),(trp_armored_guarder,8,16),(trp_wei_heavy_bow_archer,8,16),(trp_dragoon,8,16)]),
("wei_lhost_reinf_2", "wei_lhost_reinf_2", 0, 0, fac_commoners, 0, [(trp_wei_ya_flag_holder,9,18),(trp_wei_elite_footman,12,24),(trp_wei_elite_archer,12,24),(trp_wei_heavy_cavalry,12,24),(trp_wei_jiao_flag_holder,12,24),(trp_wei_footman,16,32)]),
("wei_lhost_reinf_3", "wei_lhost_reinf_3", 0, 0, fac_commoners, 0, [(trp_wei_archer,16,32),(trp_wei_light_cavalry,16,32)]),
("wei_war_reinf_1", "wei_war_reinf_1", 0, 0, fac_commoners, 0, [(trp_wei_lieutenant,8,16),(trp_wei_captain,4,8),(trp_wei_main_flag_holder,10,20),(trp_armored_guarder,15,30),(trp_wei_heavy_bow_archer,15,30),(trp_dragoon,15,30)]),
("wei_war_reinf_2", "wei_war_reinf_2", 0, 0, fac_commoners, 0, [(trp_wei_ya_flag_holder,12,24),(trp_wei_elite_footman,18,36),(trp_wei_elite_archer,18,36),(trp_wei_heavy_cavalry,18,36),(trp_wei_jiao_flag_holder,16,32),(trp_wei_footman,21,42)]),
("wei_war_reinf_3", "wei_war_reinf_3", 0, 0, fac_commoners, 0, [(trp_wei_archer,21,42),(trp_wei_light_cavalry,21,42)]),


("shu_patrol_reinf_1", "shu_patrol_reinf_1", 0, 0, fac_commoners, 0, [(trp_shu_solider,8,16),(trp_shu_horse_solider,7,14)]),
("shu_shost_reinf_1", "shu_shost_reinf_1", 0, 0, fac_commoners, 0, [(trp_shu_jiao_flag_holder,6,12),(trp_shu_infantry,8,16),(trp_shu_archer_troop,8,16),(trp_shu_horseman,8,16)]),
("shu_host_reinf_1", "shu_host_reinf_1", 0, 0, fac_commoners, 0, [(trp_shu_lieutenant,3,6),(trp_shu_ya_flag_holder,6,12),(trp_elite_shu_infantry,8,16),(trp_shu_strong_crossbowman,8,16),(trp_shu_elite_horseman,8,16),(trp_shu_jiao_flag_holder,9,18)]),
("shu_host_reinf_2", "shu_host_reinf_2", 0, 0, fac_commoners, 0, [(trp_shu_infantry,12,24),(trp_shu_archer_troop,12,24),(trp_shu_horseman,12,24)]),
("shu_lhost_reinf_1", "shu_lhost_reinf_1", 0, 0, fac_commoners, 0, [(trp_shu_lieutenant,5,10),(trp_shu_captain,3,6),(trp_shu_main_flag_holder,6,12),(trp_shu_unstopped_horseman,8,16),(trp_yuan_rong_crossbowman,8,16),(trp_shu_armed_horseman,8,16)]),
("shu_lhost_reinf_2", "shu_lhost_reinf_2", 0, 0, fac_commoners, 0, [(trp_shu_ya_flag_holder,9,18),(trp_elite_shu_infantry,12,24),(trp_shu_strong_crossbowman,12,24),(trp_shu_elite_horseman,12,24),(trp_shu_jiao_flag_holder,12,24),(trp_shu_infantry,16,32)]),
("shu_lhost_reinf_3", "shu_lhost_reinf_3", 0, 0, fac_commoners, 0, [(trp_shu_archer_troop,16,32),(trp_shu_horseman,16,32)]),
("shu_war_reinf_1", "shu_war_reinf_1", 0, 0, fac_commoners, 0, [(trp_shu_lieutenant,8,16),(trp_shu_captain,4,8),(trp_shu_main_flag_holder,10,20),(trp_shu_unstopped_horseman,15,30),(trp_yuan_rong_crossbowman,15,30),(trp_shu_armed_horseman,15,30)]),
("shu_war_reinf_2", "shu_war_reinf_2", 0, 0, fac_commoners, 0, [(trp_shu_ya_flag_holder,12,24),(trp_elite_shu_infantry,18,36),(trp_shu_strong_crossbowman,18,36),(trp_shu_elite_horseman,18,36),(trp_shu_jiao_flag_holder,16,32),(trp_shu_infantry,21,42)]),
("shu_war_reinf_3", "shu_war_reinf_3", 0, 0, fac_commoners, 0, [(trp_shu_archer_troop,21,42),(trp_shu_horseman,21,42)]),

("wu_patrol_reinf_1", "wu_patrol_reinf_1", 0, 0, fac_commoners, 0, [(trp_wu_solider,8,16),(trp_wu_horse_solider,7,14)]),
("wu_shost_reinf_1", "wu_shost_reinf_1", 0, 0, fac_commoners, 0, [(trp_wu_jiao_flag_holder,6,12),(trp_wu_trouble_dealing_army,8,16),(trp_wu_bowman,8,16),(trp_wu_rider,8,16)]),
("wu_host_reinf_1", "wu_host_reinf_1", 0, 0, fac_commoners, 0, [(trp_wu_lieutenant,3,6),(trp_wu_ya_flag_holde,6,12),(trp_wu_hard_army,8,16),(trp_wu_elite_bowman,8,16),(trp_wu_elite_rider,8,16),(trp_wu_jiao_flag_holder,9,18)]),
("wu_host_reinf_2", "wu_host_reinf_2", 0, 0, fac_commoners, 0, [(trp_wu_trouble_dealing_army,12,24),(trp_wu_bowman,12,24),(trp_wu_rider,12,24)]),
("wu_lhost_reinf_1", "wu_lhost_reinf_1", 0, 0, fac_commoners, 0, [(trp_wu_lieutenant,5,10),(trp_wu_captain,3,6),(trp_wu_main_flag_holder,6,12),(trp_feather_army,8,16),(trp_wu_five_troops_bowman,8,16),(trp_wu_tiger_rider,8,16)]),
("wu_lhost_reinf_2", "wu_lhost_reinf_2", 0, 0, fac_commoners, 0, [(trp_wu_ya_flag_holde,9,18),(trp_wu_hard_army,12,24),(trp_wu_elite_bowman,12,24),(trp_wu_elite_rider,12,24),(trp_wu_jiao_flag_holder,12,24),(trp_wu_trouble_dealing_army,16,32)]),
("wu_lhost_reinf_3", "wu_lhost_reinf_3", 0, 0, fac_commoners, 0, [(trp_wu_bowman,16,32),(trp_wu_rider,16,32)]),
("wu_war_reinf_1", "wu_war_reinf_1", 0, 0, fac_commoners, 0, [(trp_wu_lieutenant,8,16),(trp_wu_captain,4,8),(trp_wu_main_flag_holder,10,20),(trp_feather_army,15,30),(trp_wu_five_troops_bowman,15,30),(trp_wu_tiger_rider,15,30)]),
("wu_war_reinf_2", "wu_war_reinf_2", 0, 0, fac_commoners, 0, [(trp_wu_ya_flag_holde,12,24),(trp_wu_hard_army,18,36),(trp_wu_elite_bowman,18,36),(trp_wu_elite_rider,18,36),(trp_wu_jiao_flag_holder,16,32),(trp_wu_trouble_dealing_army,21,42)]),
("wu_war_reinf_3", "wu_war_reinf_3", 0, 0, fac_commoners, 0, [(trp_wu_bowman,21,42),(trp_wu_rider,21,42)]),
##SG
("xian_jing", "xian_jing", icon_xian_jing|pf_no_label, 0, fac_neutral, 0, []),

]
