from header_common import *
from header_presentations import *
from header_mission_templates import *
from ID_meshes import *
from header_operations import *
from header_triggers import *
from module_constants import *
import string

####################################################################################################################
#  Each presentation record contains the following fields:
#  1) Presentation id: used for referencing presentations in other files. The prefix prsnt_ is automatically added before each presentation id.
#  2) Presentation flags. See header_presentations.py for a list of available flags
#  3) Presentation background mesh: See module_meshes.py for a list of available background meshes
#  4) Triggers: Simple triggers that are associated with the presentation
####################################################################################################################
presentations_defined=1
presentations = [
  ("game_credits",prsntf_read_only,mesh_load_window,[
      (ti_on_presentation_load,
       [(assign, "$g_presentation_credits_obj_1", -1),
        (assign, "$g_presentation_credits_obj_2", -1),
        (assign, "$g_presentation_credits_obj_3", -1),
        (assign, "$g_presentation_credits_obj_4", -1),
        (assign, "$g_presentation_credits_obj_5", -1),
        (assign, "$g_presentation_credits_obj_6", -1),
        (assign, "$g_presentation_credits_obj_1_alpha", 0),
        (assign, "$g_presentation_credits_obj_2_alpha", 0),
        (assign, "$g_presentation_credits_obj_3_alpha", 0),
        (assign, "$g_presentation_credits_obj_4_alpha", 0),
        (assign, "$g_presentation_credits_obj_5_alpha", 0),
        ]),
      (ti_on_presentation_run,
       [
        (store_trigger_param_1, ":cur_time"),
        (set_fixed_point_multiplier, 1000),
        (try_begin),
          (this_or_next|key_clicked, key_space),
          (this_or_next|key_clicked, key_enter),
          (this_or_next|key_clicked, key_escape),
          (this_or_next|key_clicked, key_back_space),
          (this_or_next|key_clicked, key_left_mouse_button),
          (key_clicked, key_right_mouse_button),
          (presentation_set_duration, 0),
        (try_end),
        (try_begin),
          (lt, "$g_presentation_credits_obj_1", 0),
          (str_store_string, s1, "str_credits_1"),
          (create_text_overlay, "$g_presentation_credits_obj_1", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_1", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_1", 0),
          (position_set_x, pos1, 1500),
          (position_set_y, pos1, 1500),
          (overlay_set_size, "$g_presentation_credits_obj_1", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_1", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_1", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 2000),
          (eq, "$g_presentation_credits_obj_1_alpha", 0),
          (assign, "$g_presentation_credits_obj_1_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_1", 1000, 0x00),
        (else_try),
          (gt, ":cur_time", 3500),
          (lt, "$g_presentation_credits_obj_2", 0),
          (str_store_string, s1, "str_credits_2"),
          (create_text_overlay, "$g_presentation_credits_obj_2", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_2", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_2", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_2", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_2", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_2", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 5500),
          (eq, "$g_presentation_credits_obj_2_alpha", 0),
          (assign, "$g_presentation_credits_obj_2_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_2", 1000, 0x00),
        (else_try),
          (gt, ":cur_time", 7000),
          (lt, "$g_presentation_credits_obj_3", 0),
          (str_store_string, s1, "str_credits_3"),
          (create_text_overlay, "$g_presentation_credits_obj_3", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_3", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_3", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_3", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_3", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_3", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 9000),
          (eq, "$g_presentation_credits_obj_3_alpha", 0),
          (assign, "$g_presentation_credits_obj_3_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_3", 1000, 0),
        (else_try),
          (gt, ":cur_time", 10500),
          (lt, "$g_presentation_credits_obj_4", 0),
          (str_store_string, s1, "str_credits_4"),
          (create_text_overlay, "$g_presentation_credits_obj_4", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_4", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_4", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_4", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_4", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_4", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 12500),
          (eq, "$g_presentation_credits_obj_4_alpha", 0),
          (assign, "$g_presentation_credits_obj_4_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_4", 1000, 0),
        (else_try),
          (gt, ":cur_time", 14000),
          (lt, "$g_presentation_credits_obj_5", 0),
          (str_store_string, s1, "str_credits_5"),
          (create_text_overlay, "$g_presentation_credits_obj_5", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_5", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_5", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_5", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_5", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_5", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 16000),
          (eq, "$g_presentation_credits_obj_5_alpha", 0),
          (assign, "$g_presentation_credits_obj_5_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_5", 1000, 0),
        (else_try),
          (gt, ":cur_time", 17500),
          (lt, "$g_presentation_credits_obj_6", 0),
          (str_store_string, s1, "str_credits_6"),
          (create_text_overlay, "$g_presentation_credits_obj_6", s1, tf_center_justify|tf_double_space),
          (overlay_set_color, "$g_presentation_credits_obj_6", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_6", 0xFF),
          (position_set_x, pos1, 1000),
          (position_set_y, pos1, 1000),
          (overlay_set_size, "$g_presentation_credits_obj_6", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, -4400),
          (overlay_set_position, "$g_presentation_credits_obj_6", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 760),
          (overlay_animate_to_position, "$g_presentation_credits_obj_6", 60000, pos1),
        (try_end),
        ]),
      ]),
  
  ("banner_selection",0,mesh_load_window,[
      (ti_on_presentation_load,
       [(set_fixed_point_multiplier, 1000),
        (str_store_string, s1, "str_banner_selection_text"),
        (create_text_overlay, reg1, s1, tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),
        (create_button_overlay, "$g_presentation_obj_1", "@Next Page", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 50),
        (overlay_set_position, "$g_presentation_obj_1", pos1),

        (assign, ":x_pos", 150),
        (assign, ":y_pos", 575),
        (assign, ":try_end", "mesh_banner_c21"),
        (store_mul, ":begin_mesh", 16, "$g_presentation_page_no"),
        (val_add, ":begin_mesh", "mesh_banner_a01"),
        (store_add, ":try_end_2", ":begin_mesh", 16),
        (val_min, ":try_end", ":try_end_2"),
        (store_add, "$g_presentation_banner_start", "$g_presentation_obj_1", 1),
        (try_for_range, ":cur_banner_mesh", ":begin_mesh", ":try_end"),
          (create_image_button_overlay, reg1, ":cur_banner_mesh", ":cur_banner_mesh"),
          (position_set_x, pos1, ":x_pos"),
          (position_set_y, pos1, ":y_pos"),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 100),
          (position_set_y, pos1, 100),
          (overlay_set_size, reg1, pos1),
          (val_add, ":x_pos", 100),
          (ge, ":x_pos", 900),
          (assign, ":x_pos", 150),
          (val_sub, ":y_pos", 250),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_1"),
          (val_add, "$g_presentation_page_no", 1),
          (val_mod, "$g_presentation_page_no", 4),
          (start_presentation, "prsnt_banner_selection"),
        (else_try),
          (store_sub, ":selected_banner", ":object", "$g_presentation_banner_start"),
          (store_mul, ":page_adder", 16, "$g_presentation_page_no"),
          (val_add, ":selected_banner", ":page_adder"),
          (val_add, ":selected_banner", "icon_banner_01"),
          (party_set_banner_icon, "p_main_party", ":selected_banner"),
          (store_sub, ":selected_banner_spr", ":selected_banner", "icon_banner_01"),
          (val_add, ":selected_banner_spr", "spr_banner_a"),
          (troop_set_slot, "trp_player", slot_troop_banner_scene_prop, ":selected_banner_spr"),
          (presentation_set_duration, 0),
          (assign, ":troop_to_change", 0),
          (assign, ":end_cond", kingdom_heroes_end),
          (try_for_range, ":cur_troop", kingdom_heroes_begin, ":end_cond"),
            (troop_slot_eq, ":cur_troop", slot_troop_banner_scene_prop, ":selected_banner_spr"),
            (assign, ":troop_to_change", ":cur_troop"),
            (assign, ":end_cond", 0),
            (troop_set_slot, ":cur_troop", slot_troop_banner_scene_prop, "spr_banner_cu"),
            (troop_get_slot, ":cur_party", ":cur_troop", slot_troop_leaded_party),
            (gt, ":cur_party", 0),
            (party_set_banner_icon, ":cur_party", "icon_banner_63"),
          (try_end),
          (try_begin),
            (gt, ":troop_to_change", 0),
            (try_for_range, ":cur_center", walled_centers_begin, walled_centers_end),
              (party_slot_eq, ":cur_center", slot_town_lord, ":troop_to_change"),
              (party_set_banner_icon, ":cur_center", "icon_banner_63"),
            (try_end),
          (try_end),
        (try_end),
        ]),
      (ti_on_presentation_run,
       [(try_begin),
          (this_or_next|key_clicked, key_space),
          (this_or_next|key_clicked, key_enter),
          (this_or_next|key_clicked, key_escape),
          (key_clicked, key_back_space),
          (presentation_set_duration, 0),
        (try_end),

        ]),
      ]),

  ("battle",0,0,[
      (ti_on_presentation_load,
       [(set_fixed_point_multiplier, 1000),
        (assign, "$g_formation_infantry_selected", 0),
        (assign, "$g_formation_archers_selected", 0),
        (assign, "$g_formation_cavalry_selected", 0),
        (assign, "$g_presentation_battle_active", 1),

        (str_clear, s7),

        (position_set_x, pos1, 0),
        (create_image_button_overlay, "$g_presentation_obj_1", "mesh_white_plane", "mesh_white_plane"),
        (position_set_y, pos1, 653),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        (create_image_button_overlay, "$g_presentation_obj_2", "mesh_white_plane", "mesh_white_plane"),
        (position_set_y, pos1, 613),
        (overlay_set_position, "$g_presentation_obj_2", pos1),
        (create_image_button_overlay, "$g_presentation_obj_3", "mesh_white_plane", "mesh_white_plane"),
        (position_set_y, pos1, 573),
        (overlay_set_position, "$g_presentation_obj_3", pos1),
        (position_set_x, pos1, 31500),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_presentation_obj_1", pos1),
        (overlay_set_size, "$g_presentation_obj_2", pos1),
        (overlay_set_size, "$g_presentation_obj_3", pos1),
        (overlay_set_alpha, "$g_presentation_obj_1", 0),
        (overlay_set_alpha, "$g_presentation_obj_2", 0),
        (overlay_set_alpha, "$g_presentation_obj_3", 0),
        (overlay_set_color, "$g_presentation_obj_1", 0xFFFF00),
        (overlay_set_color, "$g_presentation_obj_2", 0xFFFF00),
        (overlay_set_color, "$g_presentation_obj_3", 0xFFFF00),
        
        (position_set_x, pos1, 20),
        (create_check_box_overlay, "$g_presentation_obj_4", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_y, pos1, 663),
        (overlay_set_position, "$g_presentation_obj_4", pos1),
        (create_check_box_overlay, "$g_presentation_obj_5", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_y, pos1, 623),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
        (create_check_box_overlay, "$g_presentation_obj_6", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_y, pos1, 583),
        (overlay_set_position, "$g_presentation_obj_6", pos1),

        (get_player_agent_no, ":player_agent"),
        (agent_get_team, ":player_team", ":player_agent"),
        
        (position_set_x, pos1, 50),
        (create_text_overlay, "$g_presentation_obj_7", s7, 0),
        (position_set_y, pos1, 660),
        (overlay_set_position, "$g_presentation_obj_7", pos1),
        (create_text_overlay, "$g_presentation_obj_8", s7, 0),
        (position_set_y, pos1, 620),
        (overlay_set_position, "$g_presentation_obj_8", pos1),
        (create_text_overlay, "$g_presentation_obj_9", s7, 0),
        (position_set_y, pos1, 580),
        (overlay_set_position, "$g_presentation_obj_9", pos1),

        (position_set_y, pos1, 700),
        (create_text_overlay, reg1, "@Action", tf_center_justify),
        (position_set_x, pos1, 250),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "@Mount", tf_center_justify),
        (position_set_x, pos1, 400),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "@Attack Type", tf_center_justify),
        (position_set_x, pos1, 550),
        (overlay_set_position, reg1, pos1),

        (create_text_overlay, "$g_presentation_infantry_movement", s7, tf_center_justify),
        (create_text_overlay, "$g_presentation_infantry_riding", s7, tf_center_justify),
        (create_text_overlay, "$g_presentation_infantry_weapon_usage", s7, tf_center_justify),
        (create_text_overlay, "$g_presentation_archers_movement", s7, tf_center_justify),
        (create_text_overlay, "$g_presentation_archers_riding", s7, tf_center_justify),
        (create_text_overlay, "$g_presentation_archers_weapon_usage", s7, tf_center_justify),
        (create_text_overlay, "$g_presentation_cavalry_movement", s7, tf_center_justify),
        (create_text_overlay, "$g_presentation_cavalry_riding", s7, tf_center_justify),
        (create_text_overlay, "$g_presentation_cavalry_weapon_usage", s7, tf_center_justify),

        (call_script, "script_update_order_panel", ":player_team"),

        (create_button_overlay, "$g_presentation_obj_10", "@Hold This Position", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_11", "@Follow Me", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_12", "@Charge", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_13", "@Advance", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_14", "@Fall Back", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_15", "@Stand Closer", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_16", "@Spread Out", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_17", "@Stand Ground", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_18", "@Mount", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_19", "@Dismount", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_20", "@Use Any Weapon", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_21", "@Use Blunt Weapons", tf_center_justify),

        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, "$g_presentation_obj_10", pos1),
        (overlay_set_size, "$g_presentation_obj_11", pos1),
        (overlay_set_size, "$g_presentation_obj_12", pos1),
        (overlay_set_size, "$g_presentation_obj_13", pos1),
        (overlay_set_size, "$g_presentation_obj_14", pos1),
        (overlay_set_size, "$g_presentation_obj_15", pos1),
        (overlay_set_size, "$g_presentation_obj_16", pos1),
        (overlay_set_size, "$g_presentation_obj_17", pos1),
        (overlay_set_size, "$g_presentation_obj_18", pos1),
        (overlay_set_size, "$g_presentation_obj_19", pos1),
        (overlay_set_size, "$g_presentation_obj_20", pos1),
        (overlay_set_size, "$g_presentation_obj_21", pos1),
        
        (position_set_x, pos1, 250),
        (position_set_y, pos1, 540),
        (overlay_set_position, "$g_presentation_obj_10", pos1),
        (position_set_y, pos1, 520),
        (overlay_set_position, "$g_presentation_obj_11", pos1),
        (position_set_y, pos1, 500),
        (overlay_set_position, "$g_presentation_obj_12", pos1),
        (position_set_y, pos1, 480),
        (overlay_set_position, "$g_presentation_obj_13", pos1),
        (position_set_y, pos1, 460),
        (overlay_set_position, "$g_presentation_obj_14", pos1),
        (position_set_y, pos1, 440),
        (overlay_set_position, "$g_presentation_obj_15", pos1),
        (position_set_y, pos1, 420),
        (overlay_set_position, "$g_presentation_obj_16", pos1),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_17", pos1),

        (position_set_x, pos1, 400),
        (position_set_y, pos1, 540),
        (overlay_set_position, "$g_presentation_obj_18", pos1),
        (position_set_y, pos1, 520),
        (overlay_set_position, "$g_presentation_obj_19", pos1),
        
        (position_set_x, pos1, 550),
        (position_set_y, pos1, 540),
        (overlay_set_position, "$g_presentation_obj_20", pos1),
        (position_set_y, pos1, 520),
        (overlay_set_position, "$g_presentation_obj_21", pos1),

        (create_text_overlay, "$g_presentation_obj_22", "@Us", 0),
        (create_text_overlay, "$g_presentation_obj_24", "@Enemies", 0),
        (create_text_overlay, "$g_presentation_obj_25", "@Ready", tf_center_justify),
        (create_text_overlay, "$g_presentation_obj_26", "@Wounded", tf_center_justify),
        (create_text_overlay, "$g_presentation_obj_27", "@Dead", tf_center_justify),

        (create_text_overlay, "$g_battle_us_ready", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_us_wounded", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_us_dead", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_enemies_ready", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_enemies_wounded", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_enemies_dead", s7, tf_center_justify),

        (create_text_overlay, "$g_presentation_obj_23", "@Allies", 0),
        (create_text_overlay, "$g_battle_allies_ready", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_allies_wounded", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_allies_dead", s7, tf_center_justify),

        (assign, ":stat_position_x", 100),
        (assign, ":stat_position_y", 100),

        (val_add, ":stat_position_x", 150),
        (val_add, ":stat_position_y", 120),
        (position_set_x, pos1, ":stat_position_x"),
        (position_set_y, pos1, ":stat_position_y"),
        (overlay_set_position, "$g_presentation_obj_25", pos1),
        (val_add, ":stat_position_x", 150),
        (position_set_x, pos1, ":stat_position_x"),
        (overlay_set_position, "$g_presentation_obj_26", pos1),
        (val_add, ":stat_position_x", 150),
        (position_set_x, pos1, ":stat_position_x"),
        (overlay_set_position, "$g_presentation_obj_27", pos1),

        (val_add, ":stat_position_x", -450),
        (val_add, ":stat_position_y", -40),
        (position_set_x, pos1, ":stat_position_x"),
        (position_set_y, pos1, ":stat_position_y"),
        (overlay_set_position, "$g_presentation_obj_22", pos1),
        (val_add, ":stat_position_y", -40),
        (position_set_y, pos1, ":stat_position_y"),
        (overlay_set_position, "$g_presentation_obj_23", pos1),
        (val_add, ":stat_position_y", -40),
        (position_set_y, pos1, ":stat_position_y"),
        (overlay_set_position, "$g_presentation_obj_24", pos1),

        (get_scene_boundaries, pos2, pos3),
        (position_transform_position_to_local, pos4, pos2, pos3),
        (set_fixed_point_multiplier, 1000),
        (position_get_x, ":map_width", pos4),
        (position_get_y, ":map_height", pos4),
        (set_fixed_point_multiplier, 1000),
        (store_div, ":map_ratio", ":map_height", 100),
        (store_div, ":map_ratio", ":map_width", ":map_ratio"),
        (try_begin),
          (gt, ":map_ratio", 100),
          (assign, "$g_battle_map_width", 300),
          (store_div, "$g_battle_map_scale", ":map_width", "$g_battle_map_width"),
          (store_div, "$g_battle_map_height", ":map_height", "$g_battle_map_scale"),
        (else_try),
          (assign, "$g_battle_map_height", 300),
          (store_div, "$g_battle_map_scale", ":map_height", "$g_battle_map_height"),
          (store_div, "$g_battle_map_width", ":map_width", "$g_battle_map_scale"),
        (try_end),
        
        (create_image_button_overlay, "$g_battle_map_plane", "mesh_white_plane", "mesh_white_plane"),
        (overlay_set_color, "$g_battle_map_plane", 0),
        (store_add, ":map_bordered_width", "$g_battle_map_width", 20),
        (store_add, ":map_bordered_height", "$g_battle_map_height", 20),
        (store_mul, ":map_scale_x", ":map_bordered_width", 50),
        (store_mul, ":map_scale_y", ":map_bordered_height", 50),
        (position_set_x, pos1, ":map_scale_x"),
        (position_set_y, pos1, ":map_scale_y"),
        (overlay_set_size, "$g_battle_map_plane", pos1),
        (store_sub, ":map_pos_x", 990, ":map_bordered_width"),
        (store_sub, ":map_pos_y", 740, ":map_bordered_height"),
        (position_set_x, pos1, ":map_pos_x"),
        (position_set_y, pos1, ":map_pos_y"),
        (overlay_set_position, "$g_battle_map_plane", pos1),
        (overlay_set_alpha, "$g_battle_map_plane", 0x44),

        (create_mesh_overlay, "$g_battle_map_infantry_order_flag", "mesh_flag_infantry"),
        (create_mesh_overlay, "$g_battle_map_archers_order_flag", "mesh_flag_archers"),
        (create_mesh_overlay, "$g_battle_map_cavalry_order_flag", "mesh_flag_cavalry"),
        (overlay_set_alpha, "$g_battle_map_infantry_order_flag", 0),
        (overlay_set_alpha, "$g_battle_map_archers_order_flag", 0),
        (overlay_set_alpha, "$g_battle_map_cavalry_order_flag", 0),

        (call_script, "script_update_order_panel_statistics_and_map"),
        (call_script, "script_update_order_panel_checked_classes"),

        (presentation_set_duration, 999999),
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
        (get_player_agent_no, ":player_agent"),
        (agent_get_team, ":player_team", ":player_agent"),

        (assign, ":update_listeners", 0),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_4"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_infantry_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_1", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_1", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_5"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_archers_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_2", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_2", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_6"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_cavalry_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_3", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_3", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_1"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_infantry_selected", 1),
          (assign, "$g_formation_archers_selected", 0),
          (assign, "$g_formation_cavalry_selected", 0),
          (overlay_animate_to_alpha, "$g_presentation_obj_1", 250, 0x44),
          (overlay_animate_to_alpha, "$g_presentation_obj_2", 250, 0),
          (overlay_animate_to_alpha, "$g_presentation_obj_3", 250, 0),
          (overlay_set_val, "$g_presentation_obj_4", 1),
          (overlay_set_val, "$g_presentation_obj_5", 0),
          (overlay_set_val, "$g_presentation_obj_6", 0),
        (else_try),
          (eq, ":object", "$g_presentation_obj_2"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_infantry_selected", 0),
          (assign, "$g_formation_archers_selected", 1),
          (assign, "$g_formation_cavalry_selected", 0),
          (overlay_animate_to_alpha, "$g_presentation_obj_1", 250, 0),
          (overlay_animate_to_alpha, "$g_presentation_obj_2", 250, 0x44),
          (overlay_animate_to_alpha, "$g_presentation_obj_3", 250, 0),
          (overlay_set_val, "$g_presentation_obj_4", 0),
          (overlay_set_val, "$g_presentation_obj_5", 1),
          (overlay_set_val, "$g_presentation_obj_6", 0),
        (else_try),
          (eq, ":object", "$g_presentation_obj_3"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_infantry_selected", 0),
          (assign, "$g_formation_archers_selected", 0),
          (assign, "$g_formation_cavalry_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_1", 250, 0),
          (overlay_animate_to_alpha, "$g_presentation_obj_2", 250, 0),
          (overlay_animate_to_alpha, "$g_presentation_obj_3", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_4", 0),
          (overlay_set_val, "$g_presentation_obj_5", 0),
          (overlay_set_val, "$g_presentation_obj_6", 1),
        (else_try),
          (eq, ":object", "$g_presentation_obj_10"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_hold),
          (call_script, "script_update_order_panel", ":player_team"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_11"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_follow),
          (call_script, "script_update_order_panel", ":player_team"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_12"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_charge),
          (call_script, "script_update_order_panel", ":player_team"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_13"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_advance),
          (call_script, "script_update_order_panel", ":player_team"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_14"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_fall_back),
          (call_script, "script_update_order_panel", ":player_team"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_15"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_stand_closer),
          (call_script, "script_update_order_panel", ":player_team"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_16"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_spread_out),
          (call_script, "script_update_order_panel", ":player_team"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_17"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_stand_ground),
          (call_script, "script_update_order_panel", ":player_team"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_18"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_mount),
          (call_script, "script_update_order_panel", ":player_team"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_19"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_dismount),
          (call_script, "script_update_order_panel", ":player_team"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_20"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_use_any_weapon),
          (call_script, "script_update_order_panel", ":player_team"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_21"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_use_blunt_weapons),
          (call_script, "script_update_order_panel", ":player_team"),
        (else_try),
          (eq, ":object", "$g_battle_map_plane"),
          (get_scene_boundaries, pos2, pos3),
          (mouse_get_position, pos1),
          (set_fixed_point_multiplier, 1000),
          (position_get_x, ":mouse_x", pos1),
          (position_get_y, ":mouse_y", pos1),
          (store_sub, ":map_x", 980, "$g_battle_map_width"),
          (store_sub, ":map_y", 730, "$g_battle_map_height"),
          (val_sub, ":mouse_x", ":map_x"),
          (val_sub, ":mouse_y", ":map_y"),
          (val_clamp, ":mouse_x", 0, "$g_battle_map_width"),
          (val_clamp, ":mouse_y", 0, "$g_battle_map_height"),
          (val_mul, ":mouse_x", "$g_battle_map_scale"),
          (val_mul, ":mouse_y", "$g_battle_map_scale"),
          (set_fixed_point_multiplier, 1000),
          (position_set_x, pos1, ":mouse_x"),
          (position_set_y, pos1, ":mouse_y"),
          (position_transform_position_to_parent, pos3, pos2, pos1),
          (try_begin),
            (eq, "$g_formation_infantry_selected", 1),
            (team_give_order, ":player_team", grc_infantry, mordr_hold),
            (team_set_order_position, ":player_team", grc_infantry, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_archers_selected", 1),
            (team_give_order, ":player_team", grc_archers, mordr_hold),
            (team_set_order_position, ":player_team", grc_archers, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_cavalry_selected", 1),
            (team_give_order, ":player_team", grc_cavalry, mordr_hold),
            (team_set_order_position, ":player_team", grc_cavalry, pos3),
          (try_end),
          (call_script, "script_update_order_flags_on_map"),
          (call_script, "script_update_order_panel", ":player_team"),
        (try_end),
        (try_begin),
          (eq, ":update_listeners", 1),
          (try_begin),
            (eq, "$g_formation_infantry_selected", 1),
            (eq, "$g_formation_archers_selected", 1),
            (eq, "$g_formation_cavalry_selected", 1),
            (team_set_order_listener, ":player_team", grc_everyone),
          (else_try),
            (eq, "$g_formation_infantry_selected", 1),
            (team_set_order_listener, ":player_team", grc_infantry),
          (else_try),
            (eq, "$g_formation_archers_selected", 1),
            (team_set_order_listener, ":player_team", grc_archers),
          (else_try),
            (eq, "$g_formation_cavalry_selected", 1),
            (team_set_order_listener, ":player_team", grc_cavalry),
          (try_end),
        (try_end),
        ]),
      (ti_on_presentation_mouse_enter_leave,
       [(store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":enter_leave"),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_1"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_infantry_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_infantry_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_infantry_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_7", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_infantry_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_infantry_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_infantry_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_7", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_2"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_archers_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_archers_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_archers_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_8", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_archers_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_archers_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_archers_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_3"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_cavalry_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_cavalry_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_cavalry_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_9", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_cavalry_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_cavalry_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_cavalry_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_9", 250, 0),
          (try_end),
        (try_end),
        ]),
      (ti_on_presentation_run,
       [(store_trigger_param_1, ":cur_time"),
        (try_begin),
          (this_or_next|game_key_clicked, gk_infantry_hear),
          (this_or_next|game_key_clicked, gk_archers_hear),
          (this_or_next|game_key_clicked, gk_cavalry_hear),
          (this_or_next|game_key_clicked, gk_heroes_hear),
          (this_or_next|game_key_clicked, gk_everyone_hear),
          (game_key_clicked, gk_reverse_order_group),
          (call_script, "script_update_order_panel_checked_classes"),
        (try_end),
        (try_begin),
          (this_or_next|game_key_clicked, gk_order_halt),
          (this_or_next|game_key_clicked, gk_order_follow),
          (this_or_next|game_key_clicked, gk_order_charge),
          (this_or_next|game_key_clicked, gk_order_mount),
          (this_or_next|game_key_clicked, gk_order_dismount),
          (this_or_next|game_key_clicked, gk_order_advance),
          (this_or_next|game_key_clicked, gk_order_fall_back),
          (this_or_next|game_key_clicked, gk_order_stand_closer),
          (this_or_next|game_key_clicked, gk_order_spread_out),
          (game_key_clicked, gk_order_blunt_weapons_toggle),
          (get_player_agent_no, ":player_agent"),
          (agent_get_team, ":player_team", ":player_agent"),
          (call_script, "script_update_order_panel", ":player_team"),
        (try_end),
        (try_begin),
          (gt, ":cur_time", 200),
          (key_clicked, key_back_space),
          (assign, "$g_presentation_battle_active", 0),
          (try_for_agents, ":cur_agent"),
            (agent_set_slot, ":cur_agent", slot_agent_map_overlay_id, 0),
          (try_end),
          (presentation_set_duration, 0),
        (try_end),
        ]),
      ]),


    ("sliders",0,0,[
      (ti_on_presentation_load,
       [(set_fixed_point_multiplier, 1000),
        (create_slider_overlay, "$g_presentation_obj_1", 0, 100),
        (create_slider_overlay, "$g_presentation_obj_2", 0, 100),
        (create_slider_overlay, "$g_presentation_obj_3", 0, 100),
        (create_slider_overlay, "$g_presentation_obj_4", 0, 100),
        (assign, reg1, 25),
        (str_store_string, s1, "str_reg1"),
        (create_text_overlay, "$g_presentation_obj_5", s1),
        (create_text_overlay, "$g_presentation_obj_6", s1),
        (create_text_overlay, "$g_presentation_obj_7", s1),
        (create_text_overlay, "$g_presentation_obj_8", s1),
        (assign, "$g_presentation_obj_1_val", 25),
        (overlay_set_val, "$g_presentation_obj_1", 25),
        (assign, "$g_presentation_obj_2_val", 25),
        (overlay_set_val, "$g_presentation_obj_2", 25),
        (assign, "$g_presentation_obj_3_val", 25),
        (overlay_set_val, "$g_presentation_obj_3", 25),
        (assign, "$g_presentation_obj_4_val", 25),
        (overlay_set_val, "$g_presentation_obj_4", 25),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 200),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_2", pos1),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_3", pos1),
        (position_set_y, pos1, 500),
        (overlay_set_position, "$g_presentation_obj_4", pos1),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 200),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_6", pos1),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_7", pos1),
        (position_set_y, pos1, 500),
        (overlay_set_position, "$g_presentation_obj_8", pos1),
        (position_set_x, pos1, 500),
        (overlay_set_size, "$g_presentation_obj_3", pos1),
        ]),
      (ti_on_presentation_run,
       [
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
        (assign, ":val_changed", 0),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_1"),
          (try_begin),
            (neq, "$g_presentation_obj_1_val", ":value"),
            (assign, "$g_presentation_obj_1_val", ":value"),
            (assign, ":val_changed", 1),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_2"),
          (try_begin),
            (neq, "$g_presentation_obj_2_val", ":value"),
            (assign, "$g_presentation_obj_2_val", ":value"),
            (assign, ":val_changed", 1),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_3"),
          (try_begin),
            (neq, "$g_presentation_obj_3_val", ":value"),
            (assign, "$g_presentation_obj_3_val", ":value"),
            (assign, ":val_changed", 1),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_4"),
          (try_begin),
            (neq, "$g_presentation_obj_4_val", ":value"),
            (assign, "$g_presentation_obj_4_val", ":value"),
            (assign, ":val_changed", 1),
          (try_end),
        (try_end),
        (try_begin),
          (eq, ":val_changed", 1),
          (assign, ":sum_values", 0),
          (val_add, ":sum_values", "$g_presentation_obj_1_val"),
          (val_add, ":sum_values", "$g_presentation_obj_2_val"),
          (val_add, ":sum_values", "$g_presentation_obj_3_val"),
          (val_add, ":sum_values", "$g_presentation_obj_4_val"),
          (store_sub, ":difference", 100, ":sum_values"),
          (assign, ":obj_1_new_val", "$g_presentation_obj_1_val"),
          (assign, ":obj_2_new_val", "$g_presentation_obj_2_val"),
          (assign, ":obj_3_new_val", "$g_presentation_obj_3_val"),
          (assign, ":obj_4_new_val", "$g_presentation_obj_4_val"),
          (assign, ":adder", 1),
          (assign, ":between_1", 0),
          (assign, ":between_2", 100),
          (try_begin),
            (lt, ":difference", 0),
            (val_mul, ":difference", -1),
            (assign, ":adder", -1),
            (assign, ":between_1", 1),
            (assign, ":between_2", 101),
          (try_end),
          (store_sub, ":sum_non_changed_values", ":sum_values", ":value"),
          (val_add, ":sum_non_changed_values", 30),
          (try_for_range, ":unused", 0, ":difference"),
            (store_random_in_range, ":random_no", 0, ":sum_non_changed_values"),
            (try_begin),
              (neq, ":object", "$g_presentation_obj_1"),
              (val_sub, ":random_no", "$g_presentation_obj_1_val"),
              (val_sub, ":random_no", 10),
              (lt, ":random_no", 0),
              (is_between, ":obj_1_new_val", ":between_1", ":between_2"),
              (val_add, ":obj_1_new_val", ":adder"),
            (else_try),
              (neq, ":object", "$g_presentation_obj_2"),
              (val_sub, ":random_no", "$g_presentation_obj_2_val"),
              (val_sub, ":random_no", 10),
              (lt, ":random_no", 0),
              (is_between, ":obj_2_new_val", ":between_1", ":between_2"),
              (val_add, ":obj_2_new_val", ":adder"),
            (else_try),
              (neq, ":object", "$g_presentation_obj_3"),
              (val_sub, ":random_no", "$g_presentation_obj_3_val"),
              (val_sub, ":random_no", 10),
              (lt, ":random_no", 0),
              (is_between, ":obj_3_new_val", ":between_1", ":between_2"),
              (val_add, ":obj_3_new_val", ":adder"),
            (else_try),
              (is_between, ":obj_4_new_val", ":between_1", ":between_2"),
              (val_add, ":obj_4_new_val", ":adder"),
            (else_try),
              (val_add, ":difference", 1),
            (try_end),
          (try_end),
          (assign, "$g_presentation_obj_1_val", ":obj_1_new_val"),
          (assign, "$g_presentation_obj_2_val", ":obj_2_new_val"),
          (assign, "$g_presentation_obj_3_val", ":obj_3_new_val"),
          (assign, "$g_presentation_obj_4_val", ":obj_4_new_val"),
        (try_end),
        (overlay_set_val, "$g_presentation_obj_1", "$g_presentation_obj_1_val"),
        (overlay_set_val, "$g_presentation_obj_2", "$g_presentation_obj_2_val"),
        (overlay_set_val, "$g_presentation_obj_3", "$g_presentation_obj_3_val"),
        (overlay_set_val, "$g_presentation_obj_4", "$g_presentation_obj_4_val"),
        (assign, reg1, "$g_presentation_obj_1_val"),
        (str_store_string, s1, "str_reg1"),
        (overlay_set_text, "$g_presentation_obj_5", s1),
        (assign, reg1, "$g_presentation_obj_2_val"),
        (str_store_string, s1, "str_reg1"),
        (overlay_set_text, "$g_presentation_obj_6", s1),
        (assign, reg1, "$g_presentation_obj_3_val"),
        (str_store_string, s1, "str_reg1"),
        (overlay_set_text, "$g_presentation_obj_7", s1),
        (assign, reg1, "$g_presentation_obj_4_val"),
        (str_store_string, s1, "str_reg1"),
        (overlay_set_text, "$g_presentation_obj_8", s1),
        ]),
      ]),
]
