from header_common import *
from header_operations import *
from header_triggers import *
from header_scenes import *
from module_constants import *

####################################################################################################################
#  Each scene record contains the following fields:
#  1) Scene id {string}: used for referencing scenes in other files. The prefix scn_ is automatically added before each scene-id.
#  2) Scene flags {int}. See header_scenes.py for a list of available flags
#  3) Mesh name {string}: This is used for indoor scenes only. Use the keyword "none" for outdoor scenes.
#  4) Body name {string}: This is used for indoor scenes only. Use the keyword "none" for outdoor scenes.
#  5) Min-pos {(float,float)}: minimum (x,y) coordinate. Player can't move beyond this limit.
#  6) Max-pos {(float,float)}: maximum (x,y) coordinate. Player can't move beyond this limit.
#  7) Water-level {float}. 
#  8) Terrain code {string}: You can obtain the terrain code by copying it from the terrain generator screen
#  9) List of other scenes accessible from this scene {list of strings}.
#     (deprecated. This will probably be removed in future versions of the module system)
#     (In the new system passages are used to travel between scenes and
#     the passage's variation-no is used to select the game menu item that the passage leads to.)
# 10) List of chest-troops used in this scene {list of strings}. You can access chests by placing them in edit mode.
#     The chest's variation-no is used with this list for selecting which troop's inventory it will access.
#  town_1   Sargoth     #plain
#  town_2   Tihr        #steppe
#  town_3   Veluca      #steppe
#  town_4   Suno        #plain
#  town_5   Jelkala     #plain
#  town_6   Praven      #plain
#  town_7   Uxkhal      #plain
#  town_8   Reyvadin    #plain
#  town_9   Khudan      #snow
#  town_10  Tulga       #steppe
#  town_11  Curaw       #snow
#  town_12  Wercheg     #plain
#  town_13  Rivacheg    #plain
#  town_14  Halmar      #steppe
####################################################################################################################
scenes_defined=1
scenes = [
  ("random_scene",sf_generate|sf_randomize|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x300028000003e8fa0000034e00004b34000059be",
    [],[]),
  ("conversation_scene",0,"encounter_spot", "bo_encounter_spot", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("random_scene_steppe",sf_generate|sf_randomize|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x0000000229602800000691a400003efe00004b34000059be",
    [],[], "outer_terrain_steppe_2"),
  ("random_scene_plain",sf_generate|sf_randomize|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x0000000229602800000691a400003efe00004b34000059be",
    [],[], "outer_terrain_plain_2"),
  ("random_scene_snow",sf_generate|sf_randomize|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x0000000229602800000691a400003efe00004b34000059be",
    [],[], "outer_terrain_snow_2"),
  ("random_scene_desert",sf_generate|sf_randomize|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x0000000229602800000691a400003efe00004b34000059be",
    [],[], "outer_terrain_steppe_2"),
  ("random_scene_steppe_forest",sf_generate|sf_randomize|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x300028000003e8fa0000034e00004b34000059be",
    [],[], "outer_terrain_plain_1"),
  ("random_scene_plain_forest",sf_generate|sf_randomize|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x300028000003e8fa0000034e00004b34000059be",
    [],[], "outer_terrain_plain_1"),
  ("random_scene_snow_forest",sf_generate|sf_randomize|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x300028000003e8fa0000034e00004b34000059be",
    [],[], "outer_terrain_snow_1"),
  ("random_scene_desert_forest",sf_generate|sf_randomize|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x300028000003e8fa0000034e00004b34000059be",
    [],[], "outer_terrain_plain_1"),
  ("four_ways_inn",sf_generate,"none", "none", (0,0),(120,120),-100,"0x0230817a00028ca300007f4a0000479400161992",
    [],[], "outer_terrain_plain_1"),
  ("test_scene",sf_generate,"none", "none", (0,0),(120,120),-100,"0x0230817a00028ca300007f4a0000479400161992",
    [],[], "outer_terrain_plain_1"),
  ("quick_battle_1",sf_generate,"none", "none", (0,0),(120,120),-100,"0x30401ee300059966000001bf0000299a0000638f", 
    [],[], "outer_terrain_plain_1"),
  ("quick_battle_2",sf_generate,"none", "none", (0,0),(120,120),-100,"0xa0425ccf0004a92a000063d600005a8a00003d9a", 
    [],[], "outer_terrain_steppe_1"),
  ("quick_battle_3",sf_generate,"none", "none", (0,0),(120,120),-100,"0x4c6024e3000691a400001b7c0000591500007b52", 
    [],[], "outer_terrain_snow_1"),
  ("quick_battle_4",sf_generate,"none", "none", (0,0),(120,120),-100,"0x00001d63c005114300006228000053bf00004eb9", 
    [],[], "outer_terrain_plain_1"),
  ("quick_battle_5",sf_generate,"none", "none", (0,0),(120,120),-100,"0x3a078bb2000589630000667200002fb90000179c", 
    [],[], "outer_terrain_plain_1"),
  ("quick_battle_6",sf_generate,"none", "none", (0,0),(120,120),-100,"0xa0425ccf0004a92a000063d600005a8a00003d9a", 
    [],[], "outer_terrain_steppe_1"),
  ("reserved3",sf_generate,"none", "none", (0,0),(120,120),-100,"63422", 
    [],[]),
  ("salt_mine",sf_generate,"none", "none", (-200,-200),(200,200),-100,"0x2a07b23200025896000023ee00007f9c000022a8",  
    [],[], "outer_terrain_steppe_1"),
  ("novice_ground",sf_indoors,"training_house_a", "bo_training_house_a", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("zendar_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[], "outer_terrain_plain_1"),
  ("dhorak_keep",sf_generate,"none", "none", (0,0),(120,120),-100,"0x33a7946000028ca300007f4a0000479400161992",
    ["exit"],[]),
  ("reserved4",sf_generate,"none", "none", (0,0),(120,120),-100,"28791",
    [],[]),
  ("reserved5",sf_generate,"none", "none", (0,0),(120,120),-100,"117828",
    [],[]),
  ("reserved6",sf_generate,"none", "none", (0,0),(100,100),-100,"6849",
    [],[]),
  ("reserved7",sf_generate,"none", "none", (0,0),(100,100),-100,"6849",
    [],[]),
  ("reserved8",sf_generate,"none", "none", (0,0),(100,100),-100,"13278",
    [],[]),
  ("reserved9",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("reserved10",0,"none", "none", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("reserved11",0,"none", "none", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("reserved12",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("training_ground",sf_generate,"none", "none", (0,0),(120,120),-100,"0x30000500400360d80000189f00002a8380006d91",
    [],["tutorial_chest_1", "tutorial_chest_2"], "outer_terrain_plain_1"),
  ("tutorial_1",sf_indoors,"tutorial_1_scene", "bo_tutorial_1_scene", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("tutorial_2",sf_indoors,"tutorial_2_scene", "bo_tutorial_2_scene", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("tutorial_3",sf_indoors,"tutorial_3_scene", "bo_tutorial_3_scene", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("tutorial_4",sf_generate,"none", "none", (0,0),(120,120),-100,"0x30000500400360d80000189f00002a8380006d91",
    [],[], "outer_terrain_plain_1"),
  ("tutorial_5",sf_generate,"none", "none", (0,0),(120,120),-100,"0x3a06dca80005715c0000537400001377000011fe",
    [],[], "outer_terrain_plain_1"),




  ("zendar_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    ["the_happy_boar","","zendar_merchant"],[], "outer_terrain_plain_1"),
#  ("zendar_center",0,"sargoth_square", "bo_sargoth_square", (-24,-22),(21,13),-100,"0",
#    ["the_happy_boar","","zendar_merchant"],[]),
  ("the_happy_boar",sf_indoors,"interior_town_house_f", "bo_interior_town_house_f", (-100,-100),(100,100),-100,"0",
    ["zendar_center"],["zendar_chest"]),
  ("zendar_merchant",sf_indoors,"interior_town_house_i", "bo_interior_town_house_i", (-100,-100),(100,100),-100,"0",
    [],[]),

# Tvern names:
  #the shy monkey
  #the singing pumpkin
  #three swords
  #red stag
  #the bard's corner


#interior_tavern_a
#  town_1   Sargoth     #plain
#  town_2   Tihr        #steppe
#  town_3   Veluca      #steppe
#  town_4   Suno        #plain  
#  town_5   Jelkala     #plain
#  town_6   Praven      #plain
#  town_7   Uxkhal      #plain
#  town_8   Reyvadin    #plain
#  town_9   Khudan      #snow
#  town_10  Tulga       #steppe
#  town_11  Curaw       #snow
#  town_12  Wercheg     #plain
#  town_13  Rivacheg    #plain
#  town_14  Halmar      #steppe
  ("town_1_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x20008a110002589600006af30000356b00002c27",
    [],[],"outer_terrain_plain_2"),
  ("town_2_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa009c7070002589600002b6300001ef60000122e",
    [],["bonus_chest_3"],"outer_terrain_town_thir_1"),
  ("town_3_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x200077ce0003e8f800006de200006a2000006959",
    [],[],"outer_terrain_steppe_1"),
  ("town_4_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30001d9300031ccb0000156f000048ba0000361c",
    [],[],"outer_terrain_plain_1"),
  ("town_5_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0xb0058fa3000258960000541100000c5700001313",
    [],["bonus_chest_2"],"outer_terrain_plain_1"),
  ("town_6_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[],"outer_terrain_plain_1"),
  ("town_7_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30050d0d0002d4b300000e2f000027d200005f66",
    [],[],"outer_terrain_plain_1"),
  ("town_8_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[],"outer_terrain_plain_1"),
  ("town_9_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x400790b20002c8b0000050d500006f8c00006dbd",
    [],[],"outer_terrain_snow_1"),
  ("town_10_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x20078a620002dcb700004e330000655d00005986",
    [],[],"outer_terrain_steppe_1"),
  ("town_11_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x400790b20002c8b0000050d500006f8c00006dbd",
    [],[],"outer_terrain_snow_1"),
  ("town_12_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3002cd340002b4ac00002ccd800026dc00000c1d",
    [],[],"outer_terrain_town_thir_1"),
  ("town_13_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x300416a600035cd600007ee80000012100003fbc",
    [],["bonus_chest_1"]),
  ("town_14_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x20c7956000025896000037e800000e860000674b",
    [],[],"outer_terrain_steppe_1"),
  
 
  ("town_1_castle",sf_indoors,"interior_castle_y", "bo_interior_castle_y", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("town_2_castle",sf_indoors,"interior_castle_t", "bo_interior_castle_t", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_3_castle",sf_indoors,"interior_castle_q", "bo_interior_castle_q", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_4_castle",sf_indoors, "interior_castle_a", "bo_interior_castle_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_5_castle",sf_indoors, "interior_castle_c", "bo_interior_castle_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_6_castle",sf_indoors, "interior_castle_p", "bo_interior_castle_p", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_7_castle",sf_indoors, "interior_castle_n", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_8_castle",sf_indoors, "interior_castle_f", "bo_interior_castle_f", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_9_castle",sf_indoors, "interior_castle_g", "bo_interior_castle_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_10_castle",sf_indoors, "interior_castle_v", "bo_interior_castle_v", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_11_castle",sf_indoors, "interior_castle_i", "bo_interior_castle_i", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_12_castle",sf_indoors, "interior_castle_d", "bo_interior_castle_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_13_castle",sf_indoors, "interior_castle_b", "bo_interior_castle_b", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_14_castle",sf_indoors, "interior_castle_e", "bo_interior_castle_e", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  
  ("town_1_tavern",sf_indoors,"interior_town_house_f", "bo_interior_town_house_f", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("town_2_tavern",sf_indoors,"interior_tavern_e", "bo_interior_tavern_e", (-100,-100),(100,100),-100,"0",
    ["exit"],[],"outer_terrain_town_thir_1"),
  ("town_3_tavern",sf_indoors,"interior_town_house_d", "bo_interior_town_house_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_4_tavern",sf_indoors, "interior_tavern_f", "bo_interior_tavern_f", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_5_tavern",sf_indoors, "interior_tavern_h", "bo_interior_tavern_h", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_6_tavern",sf_indoors, "interior_tavern_g", "bo_interior_tavern_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_7_tavern",sf_indoors, "interior_town_house_f", "bo_interior_town_house_f", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_8_tavern",sf_indoors, "interior_tavern_h", "bo_interior_tavern_h", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_9_tavern",sf_indoors, "interior_tavern_g", "bo_interior_tavern_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_10_tavern",sf_indoors, "interior_tavern_b", "bo_interior_tavern_b", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_11_tavern",sf_indoors, "interior_tavern_c", "bo_interior_tavern_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_12_tavern",sf_indoors, "interior_town_house_aa", "bo_interior_town_house_aa", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_13_tavern",sf_indoors, "interior_tavern_g", "bo_interior_tavern_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_14_tavern",sf_indoors, "interior_tavern_d", "bo_interior_tavern_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  
  ("town_1_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_2_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_3_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_4_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_5_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_6_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_7_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_8_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_9_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_10_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_11_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_12_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_13_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_14_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  
  ("town_1_store",sf_indoors,"interior_town_house_i", "bo_interior_town_house_i", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("town_2_store",sf_indoors,"interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_3_store",sf_indoors,"interior_town_house_e", "bo_interior_town_house_e", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_4_store",sf_indoors, "interior_town_house_a", "bo_interior_town_house_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_5_store",sf_indoors, "interior_town_house_d", "bo_interior_town_house_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_6_store",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_7_store",sf_indoors, "interior_house_a", "bo_interior_house_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_8_store",sf_indoors, "interior_house_b", "bo_interior_house_b", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_9_store",sf_indoors, "interior_tavern_a", "bo_interior_tavern_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_10_store",sf_indoors, "interior_town_house_i", "bo_interior_town_house_i", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_11_store",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_12_store",sf_indoors, "interior_house_a", "bo_interior_house_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_13_store",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_14_store",sf_indoors, "interior_town_house_c", "bo_interior_town_house_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  
  ("town_1_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[],"outer_terrain_plain_1"),
  ("town_2_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[],"outer_terrain_town_thir_1"),
  ("town_3_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("town_4_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[],"outer_terrain_plain_1"),
  ("town_5_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[],"outer_terrain_plain_1"),
  ("town_6_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[],"outer_terrain_plain_1"),
  ("town_7_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[],"outer_terrain_plain_1"),
  ("town_8_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[],"outer_terrain_plain_1"),
  ("town_9_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x40001d9300031ccb0000156f000048ba0000361c",
    [],[],"outer_terrain_snow_1"),
  ("town_10_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[],"outer_terrain_steppe_1"),
  ("town_11_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x40001d9300031ccb0000156f000048ba0000361c",
    [],[],"outer_terrain_snow_1"),
  ("town_12_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[],"outer_terrain_town_thir_1"),
  ("town_13_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("town_14_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[],"outer_terrain_steppe_1"),
  
  ("town_1_prison",sf_indoors,"interior_prison_a", "bo_interior_prison_a", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("town_2_prison",sf_indoors,"interior_prison_b", "bo_interior_prison_b", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("town_3_prison",sf_indoors,"interior_prison_f", "bo_interior_prison_f", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("town_4_prison",sf_indoors,"interior_prison_g", "bo_interior_prison_g", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("town_5_prison",sf_indoors,"interior_prison_h", "bo_interior_prison_h", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_6_prison",sf_indoors,"interior_prison_e", "bo_interior_prison_e", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_7_prison",sf_indoors,"interior_prison_i", "bo_interior_prison_i", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_8_prison",sf_indoors,"dungeon_cell_b", "bo_dungeon_cell_b", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_9_prison",sf_indoors,"interior_prison_j", "bo_interior_prison_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_10_prison",sf_indoors,"interior_prison_k", "bo_interior_prison_k", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_11_prison",sf_indoors,"dungeon_a", "bo_dungeon_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_12_prison",sf_indoors,"interior_prison_d", "bo_interior_prison_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_13_prison",sf_indoors,"interior_prison_a", "bo_interior_prison_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_14_prison",sf_indoors,"interior_prison_f", "bo_interior_prison_f", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  
  ("town_1_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  ("town_2_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  ("town_3_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  ("town_4_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  ("town_5_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  ("town_6_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  ("town_7_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  ("town_8_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  ("town_9_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  ("town_10_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  ("town_11_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  ("town_12_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  ("town_13_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  ("town_14_siege",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    [],[]),
  
  ("town_1_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    [],[],"outer_terrain_plain_1"),
  ("town_2_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    [],[],"outer_terrain_town_thir_1"),
  ("town_3_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    [],[]),
  ("town_4_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    [],[],"outer_terrain_plain_1"),
  ("town_5_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    [],[],"outer_terrain_plain_1"),
  ("town_6_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    [],[],"outer_terrain_plain_1"),
  ("town_7_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x20008a110002589600006af30000356b00002c27",
    [],[],"outer_terrain_plain_1"),
  ("town_8_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    [],[],"outer_terrain_plain_1"),
  ("town_9_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x400211130001e07800002ad400001172000035c4",
    [],[],"outer_terrain_snow_1"),
  ("town_10_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    [],[],"outer_terrain_steppe_1"),
  ("town_11_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x400211130001e07800002ad400001172000035c4",
    [],[],"outer_terrain_snow_1"),
  ("town_12_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    [],[],"outer_terrain_town_thir_1"),
  ("town_13_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    [],[]),
  ("town_14_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    [],[],"outer_terrain_steppe_1"),

#0x30054d228004050000005a768000688400002e3b
#0x30054da28004050000005a76800022aa00002e3b
#Castles:

#       1 Steppe
  ("castle_1_exterior",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30054da28004050000005a76800022aa00002e3b",
    [],[],"outer_terrain_steppe_1"),
  ("castle_1_interior",sf_indoors, "dungeon_entry_a", "bo_dungeon_entry_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
#       2 Plain
  ("castle_2_exterior",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa00363638005c16d00003c82000037e000002303",
    [],[],"outer_terrain_plain_1"),
  ("castle_2_interior",sf_indoors, "interior_castle_u", "bo_interior_castle_u", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
#       3 Plain
  ("castle_3_exterior",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30044e900003dd02000001920000400100005697",
    [],[],"outer_terrain_plain_1"),
  ("castle_3_interior",sf_indoors, "interior_castle_m", "bo_interior_castle_m", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
#       4 Plain
  ("castle_4_exterior",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30044e900003dd02000001920000400100005697",
    [],[],"outer_terrain_plain_1"),
  ("castle_4_interior",sf_indoors, "interior_castle_k", "bo_interior_castle_k", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
#       5 Plain
  ("castle_5_exterior",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3189dc1a000429090000619700007cbd00005ab7",
    [],[],"outer_terrain_plain_1"),
  ("castle_5_interior",sf_indoors, "interior_castle_j", "bo_interior_castle_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
#       6 Plain
  ("castle_6_exterior",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000b009723200059d6800005f4f0000757f000069cd",
    [],[],"outer_terrain_plain_1"),
  ("castle_6_interior",sf_indoors, "interior_castle_p", "bo_interior_castle_p", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
#       7 Snow
  ("castle_7_exterior",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000c007a56300047d1e00006c9100002859000028bc",
    [],[],"outer_terrain_snow_1"),
  ("castle_7_interior",sf_indoors, "interior_castle_o", "bo_interior_castle_o", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
#       8 Plain
  ("castle_8_exterior",sf_generate,"none", "none", (0,0),(100,100),-100,"0x314d060900036cd70000295300002ec9000025f3",
    [],[],"outer_terrain_plain_1"),
  ("castle_8_interior",sf_indoors, "interior_castle_t", "bo_interior_castle_t", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
#       9 Steppe
  ("castle_9_exterior",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0048e000004d93700004f91000065980000229b",
    [],[],"outer_terrain_castle_9"),
  ("castle_9_interior",sf_indoors, "interior_castle_l", "bo_interior_castle_l", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
#       10 Steppe  
  ("castle_10_exterior",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0045f200004751b000051cf00007f7a00002cd9",
    [],[],"outer_terrain_steppe_1"),
  ("castle_10_interior",sf_indoors, "interior_castle_n", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
#       11 Plain
  ("castle_11_exterior",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30044e900003dd02000001920000400100005697",
    [],[],"outer_terrain_plain_1"),
  ("castle_11_interior",sf_indoors, "interior_castle_a", "bo_interior_castle_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

  ("village_1",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000030081763000589620000338e00004f2c00005cfb",
    [],[],"outer_terrain_plain_2"),
  ("village_2",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000003007a21c0003ecfe000001f0000073b100000fd2",
    [],[],"outer_terrain_plain_2"),
  ("village_3",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000023003dc4e0006118b000029f8000034670000105f",
    [],[],"outer_terrain_plain_2"),
  ("village_4",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000230079732000651a00000044c0000177200000234",
    [],[],"outer_terrain_plain_2"),
  ("village_5",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000003001ce100006097d0000134c000016d8000042a2",
    [],[],"outer_terrain_plain_2"),
  ("village_6",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000230035598000761df000058ea000006f3000005e7",
    [],[],"outer_terrain_plain_2"),
  ("village_7",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000031059a0d0004792000005c3a00004df500000dbc",
    [],[],"outer_terrain_plain_2"),
  ("village_8",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000002300798320006499200002acc000040d70000421d",
    [],[],"outer_terrain_plain_2"),
  ("village_9",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000003a0005008005b57000004e31800017d80000754b",
    [],[],"outer_terrain_plain_2"),
  ("village_10",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300619e30003a8ec00004c8380007de100001cb5",
    [],[],"outer_terrain_plain_1"),
  ("village_11",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000220029c4400077de100002dcc00002edf00003925",
    [],[],"outer_terrain_steppe_1"),
  ("village_12",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000002200213e300077ddf000019d3000034520000626e",
    [],[]),
  ("village_13",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000300265e3400691a400005e4d80006dfa00003bc8",
    [],[], "outer_terrain_plain_2"),
  ("village_14",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000230029ce30004912400002acc000040d7000077db",
    [],[], "outer_terrain_plain_2"),
  ("village_15",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000002300029d4000691a4000015148000335800004190",
    [],[],"outer_terrain_plain_2"),
  ("village_16",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000240031a0f0006b9ae00006e1b00006e9000007281",
    [],[],"outer_terrain_snow_2"),
  ("village_17",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000002c003131700066da00000484c000008630000613d",
    [],[],),
  ("village_18",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000024003561a00070dbe000016f8000010ca000069f8",
    [],[],"outer_terrain_snow_2"),
  ("village_19",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000024003991e0006f1bc000055cc0000085600001563",
    [],[],"outer_terrain_snow_2"),
  ("village_20",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000024003d7d20007d1f40000374100001e120000097b",
    [],[],"outer_terrain_snow_2"),
  ("village_21",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000240024d3800074dcc0000488b0000016100002047",
    [],[],"outer_terrain_snow_2"),
  ("village_22",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000024003d7d20007d1f40000374100001e120000097b",
    [],[],"outer_terrain_snow_2"),
  ("village_23",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000002300415380007b5e600005f7b00000a9200001615",
    [],[],),
  ("village_24",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000002300029d4000691a4000015148000335800004190",
    [],[],),
  ("village_25",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000002d0021ede000775dd000032670000173700007c40",
    [],[],"outer_terrain_steppe_1"),
  ("village_26",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000002300029d4000691a4000015148000335800004190",
    [],[],),
  ("village_27",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000002300029d4000691a4000015148000335800004190",
    [],[],),
  ("village_28",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000022002de4c00077ddd00007e1300000af400006de1",
    [],[],"outer_terrain_steppe_1"),
  ("village_29",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000002300029d4000691a4000015148000335800004190",
    [],[],),
  ("village_30",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300619e30003a8ec00004c8380007de100001cb5",
    [],[],"outer_terrain_plain_1"),
  ("village_31",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300619e30003a8ec00004c8380007de100001cb5",
    [],[],"outer_terrain_plain_1"),
  ("village_32",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300619e30003a8ec00004c8380007de100001cb5",
    [],[],"outer_terrain_plain_1"),
  ("village_33",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300619e30003a8ec00004c8380007de100001cb5",
    [],[],"outer_terrain_plain_1"),
  ("village_34",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300619e30003a8ec00004c8380007de100001cb5",
    [],[],"outer_terrain_plain_1"),
  ("village_35",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300619e30003a8ec00004c8380007de100001cb5",
    [],[],"outer_terrain_plain_1"),
  ("village_36",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300619e30003a8ec00004c8380007de100001cb5",
    [],[],"outer_terrain_plain_1"),
  ("village_37",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000022004d36300077dd600002e08000036ab00004651",
    [],[],"outer_terrain_steppe_1"),
  ("village_38",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300619e30003a8ec00004c8380007de100001cb5",
    [],[],"outer_terrain_plain_1"),
  ("village_39",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300619e30003a8ec00004c8380007de100001cb5",
    [],[],"outer_terrain_plain_1"),
  ("village_40",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000220031f6300076dda000056f100004f6d000070b3",
    [],[],"outer_terrain_steppe_1"),

	
  # BoW: Try to add new scenes. (Changed the first line of this group, too!)
  ("zendar_merchant_ymira",sf_indoors,"interior_town_house_i", "bo_interior_town_house_i", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("zendar_training_hall",sf_indoors,"interior_town_house_f", "bo_interior_town_house_f", (-100,-100),(100,100),-100,"0",
    [],[]),

("npc_horde_tavern",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    [],[]),
("equipping_station",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    [],[]),

	
# Tvern names:
  #the shy monkey
  #the singing pumpkin
  #three swords
  #red stag
  #the bard's corner


#interior_tavern_a
 #
  ("xiangping_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x20008a110002589600006af30000356b00002c27",
    ["xiangping_castle","xiangping_tavern","xiangping_store"],[]),
  ("xiangping_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xiangping_store",sf_indoors,"interior_town_house_i", "bo_interior_town_house_i", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xiangping_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("xiangping_prison",sf_indoors,"dungeon_entry_a", "bo_dungeon_entry_a", (-100,-100),(100,100),-100,"0",
    [],[]),


  ("beiping_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x400790b20002c8b0000050d500006f8c00006dbd",
    ["beiping_castle","beiping_tavern","beiping_store"],[]),
  ("beiping_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("beiping_store",sf_indoors,"interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("beiping_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("beiping_prison",sf_indoors,"dungeon_a", "bo_dungeon_a", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("beihai_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x30050d0d8002d4b300000e2f000027d200005f66",
    ["beihai_castle","beihai_tavern","beihai_store"],[]),
  ("beihai_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("beihai_store",sf_indoors,"interior_town_house_e", "bo_interior_town_house_e", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("beihai_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("beihai_prison",sf_indoors,"dungeon_entry_b", "bo_dungeon_entry_b", (-100,-100),(100,100),-100,"0",
    [],[]),
  
  ("pingyuan_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30001d9300031ccb0000156f000048ba0000361c",
    ["pingyuan_castle","pingyuan_tavern","pingyuan_store"],[]),
  ("pingyuan_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("pingyuan_store",sf_indoors, "interior_town_house_a", "bo_interior_town_house_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("pingyuan_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("pingyuan_prison",sf_indoors,"dungeon_tower_stairs_a", "bo_dungeon_tower_stairs_a", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("xiapi_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0xb0058fa3000258960000541100000c5700001313",
    ["xiapi_castle","xiapi_tavern","xiapi_store"],[]),
  ("xiapi_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xiapi_store",sf_indoors, "interior_town_house_d", "bo_interior_town_house_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xiapi_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("xiapi_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

  ("xiangyang_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3102cd348002b4ac00002ccd800026dc00000c1d",
    ["xiangyang_castle","xiangyang_tavern","xiangyang_store"],[]),
  ("xiangyang_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xiangyang_store",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xiangyang_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("xiangyang_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

  ("weil_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x22001baf0004c93400001d0200007beb000001f6",
    [],[],"outer_terrain_plain_1"),
  ("changan_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("changan_store",sf_indoors, "interior_house_a", "bo_interior_house_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("changan_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("changan_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

  ("luoyang_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x300798b20002dcb700002484000062cd000018d9",
    ["luoyang_castle","luoyang_tavern","luoyang_store"],[]),
  ("luoyang_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("luoyang_store",sf_indoors, "interior_house_a", "bo_interior_house_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("luoyang_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("luoyang_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),


   ("wein_center",sf_generate,"none", "none", (0,0),(120,120),-100,"0x0000000338eb05000004551800002245000066b500001d55",
    [],[],"outer_terrain_plain_1"),
  ("shouchun_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("shouchun_store",sf_indoors, "interior_tavern_a", "bo_interior_tavern_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("shouchun_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x40001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("shouchun_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

  ("xuchang_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x22001baf8004c93400001d020000657200004b93",
    ["xuchang_castle","xuchang_tavern","xuchang_store"],[]),
  ("xuchang_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xuchang_store",sf_indoors, "interior_house_a", "bo_interior_house_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xuchang_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("xuchang_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

 ("weis_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x22001baf0004c93400001d0200007beb000001f6",
    [],[],"outer_terrain_plain_1"),
  ("runan_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("runan_store",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("runan_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x40001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("runan_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

  ("wancheng_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    ["wancheng_castle","wancheng_tavern","wancheng_store"],[]),
  ("wancheng_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("wancheng_store",sf_indoors, "interior_house_a", "bo_interior_house_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("wancheng_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("wancheng_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

  ("yecheng_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x300416a600035cd600007ee80000012100003fbc",
    ["yecheng_castle","yecheng_tavern","yecheng_store"],[]),
  ("yecheng_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yecheng_store",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yecheng_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("yecheng_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

  ("jinyang_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x20c7956000025896000037e800000e860000674b",
    ["jinyang_castle","jinyang_tavern","jinyang_store"],[]),
  ("jinyang_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jinyang_store",sf_indoors, "interior_town_house_c", "bo_interior_town_house_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jinyang_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("jinyang_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

     ("anding_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x30050d0d8002d4b300000e2f000027d200005f66",
    ["anding_castle","anding_tavern","anding_store"],[]),
  ("anding_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("anding_store",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("anding_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x40001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("anding_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

    ("tianshui_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x30004500c00589600000535d00001738000020fd",
    ["tianshui_castle","tianshui_tavern","tianshui_store"],[]),
  ("tianshui_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("tianshui_store",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("tianshui_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x40001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("tianshui_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

   ("sishuiguan_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x202019254005795d00006e260000516e000027bf",
    ["sishuiguan_castle","sishuiguan_tavern","sishuiguan_store"],[]),
  ("sishuiguan_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("sishuiguan_store",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("sishuiguan_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x40001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("sishuiguan_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

   ("hulaoguan_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x22001baf8004c93400001d020000657200004b93",
    [],[],"outer_terrain_plain_1"),
  ("hulaoguan_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("hulaoguan_store",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("hulaoguan_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x40001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("hulaoguan_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

    ("tongguan_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x22001baf8004c93400001d020000657200004b93",
    [],[],"outer_terrain_plain_1"),
  ("tongguan_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("tongguan_store",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("tongguan_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x40001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("tongguan_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

   ("puyang_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30004500c00589600000535d00001738000020fd",
    ["puyang_castle","puyang_tavern","puyang_store"],[]),
  ("puyang_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("puyang_store",sf_indoors,"interior_town_house_i", "bo_interior_town_house_i", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("puyang_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("puyang_prison",sf_indoors,"dungeon_entry_a", "bo_dungeon_entry_a", (-100,-100),(100,100),-100,"0",
   ["exit"],[]),
   
   ("hefei_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x20020ee3000605860000466a0000532e000014f5",
    ["hefei_castle","hefei_tavern","hefei_store"],[]),
  ("hefei_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("hefei_store",sf_indoors,"interior_town_house_i", "bo_interior_town_house_i", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("hefei_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("hefei_prison",sf_indoors,"dungeon_entry_a", "bo_dungeon_entry_a", (-100,-100),(100,100),-100,"0",
   ["exit"],[]),

       ("nanpi_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30054da28004050000005a76800022aa00002e3b",
    ["nanpi_castle","nanpi_tavern","nanpi_store"],[]),
  ("nanpi_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("nanpi_store",sf_indoors,"interior_town_house_i", "bo_interior_town_house_i", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("nanpi_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("nanpi_prison",sf_indoors,"dungeon_entry_a", "bo_dungeon_entry_a", (-100,-100),(100,100),-100,"0",
   ["exit"],[]),
   #
   ("jiangxia_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x20c7956000025896000037e800000e860000674b",
    ["jiangxia_castle","jiangxia_tavern","jiangxia_store"],[]),
  ("jiangxia_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiangxia_store",sf_indoors,"interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiangxia_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("jiangxia_prison",sf_indoors,"dungeon_a", "bo_dungeon_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

     ("yongan_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x30001d9300031ccb0000156f000048ba0000361c",
    ["yongan_castle","yongan_tavern","yongan_store"],[]),
  ("yongan_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yongan_store",sf_indoors,"interior_town_house_e", "bo_interior_town_house_e", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yongan_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("yongan_prison",sf_indoors,"dungeon_entry_b", "bo_dungeon_entry_b", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

    ("jiangzhou_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x216077ce0003e8f800006de200006a2000006959",
    ["jiangzhou_castle","jiangzhou_tavern","jiangzhou_store"],[]),
  ("jiangzhou_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiangzhou_store",sf_indoors,"interior_town_house_e", "bo_interior_town_house_e", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiangzhou_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    ["exit"],[]),
  ("jiangzhou_prison",sf_indoors,"dungeon_entry_b", "bo_dungeon_entry_b", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

   ("shul_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x20c7956000025896000037e800000e860000674b",
    [],[],"outer_terrain_steppe_1"),
  ("chengdu_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("chengdu_store",sf_indoors, "interior_house_a", "bo_interior_house_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("chengdu_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("chengdu_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]), 

    ("shus_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x400790b20002c8b0000050d500006f8c00006dbd",
    [],[],"outer_terrain_steppe_1"),
  ("yunnan_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yunnan_store",sf_indoors, "interior_town_house_i", "bo_interior_town_house_i", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yunnan_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("yunnan_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

    ("shangyong_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x20078a620002dcb700004e330000655d00005986",
    ["shangyong_castle","shangyong_tavern","shangyong_store"],[]),
  ("shangyong_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("shangyong_store",sf_indoors,"interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("shangyong_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    ["exit"],[]),
  ("shangyong_prison",sf_indoors,"dungeon_entry_b", "bo_dungeon_entry_b", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

     ("jiangling_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30054da28004050000005a76800022aa00002e3b",
    ["jiangling_castle","jiangling_tavern","jiangling_store"],[]),
  ("jiangling_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiangling_store",sf_indoors,"interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiangling_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("jiangling_prison",sf_indoors,"dungeon_a", "bo_dungeon_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

  ("jianning_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0xa009c7078002589600002b6300001ef60000122e",
    ["jianning_castle","jianning_tavern","jianning_store"],[]),
  ("jianning_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jianning_store",sf_indoors,"interior_town_house_e", "bo_interior_town_house_e", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jianning_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    ["exit"],[]),
  ("jianning_prison",sf_indoors,"dungeon_entry_b", "bo_dungeon_entry_b", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

    ("zitong_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0xb0058fa3000258960000541100000c5700001313",
    ["zitong_castle","zitong_tavern","zitong_store"],[]),
  ("zitong_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("zitong_store",sf_indoors, "interior_house_b", "bo_interior_house_b", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("zitong_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("zitong_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

    ("shun_center",sf_generate,"none", "none", (0,0),(120,120),-100,"0x0000000338eb05000004551800002245000066b500001d55",
    [],[],"outer_terrain_steppe_1"),
  ("hanzhong_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("hanzhong_store",sf_indoors, "interior_house_b", "bo_interior_house_b", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("hanzhong_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("hanzhong_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

   ("jiange_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x00000000b44ab7638002fcbd00007c31800003e8000007d0",
    ["jiange_castle","jiange_tavern","jiange_store"],[]),
  ("jiange_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiange_store",sf_indoors, "interior_house_b", "bo_interior_house_b", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiange_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("jiange_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

   #
   ("wul_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x22001baf0004c93400001d0200007beb000001f6",
    [],[],"outer_terrain_plain_1"),
  ("jianye_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jianye_store",sf_indoors,"interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jianye_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("jianye_prison",sf_indoors,"dungeon_a", "bo_dungeon_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

    ("wu_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    ["wu_castle","wu_tavern","wu_store"],[]),
  ("wu_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("wu_store",sf_indoors, "interior_house_a", "bo_interior_house_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("wu_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("wu_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),


   ("wun_center",sf_generate,"none", "none", (0,0),(120,120),-100,"0x0000000338eb05000004551800002245000066b500001d55",
    [],[],"outer_terrain_plain_1"),
  ("huiji_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("huiji_store",sf_indoors, "interior_house_a", "bo_interior_house_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("huiji_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("huiji_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

  ("chaisang_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30004500c00589600000535d00001738000020fd",
    ["chaisang_castle","chaisang_tavern","chaisang_store"],[]),
  ("chaisang_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("chaisang_store",sf_indoors, "interior_house_a", "bo_interior_house_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("chaisang_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("chaisang_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

    ("changsha_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x22001baf8004c93400001d020000657200004b93",
    ["changsha_castle","changsha_tavern","changsha_store"],[]),
  ("changsha_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("changsha_store",sf_indoors, "interior_tavern_a", "bo_interior_tavern_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("changsha_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x40001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("changsha_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

  ("wus_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x400790b20002c8b0000050d500006f8c00006dbd",
    [],[],"outer_terrain_plain_1"),
  ("wuling_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("wuling_store",sf_indoors, "interior_tavern_a", "bo_interior_tavern_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("wuling_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x40001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("wuling_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

    ("lingling_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    ["lingling_castle","lingling_tavern","lingling_store"],[]),
  ("lingling_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("lingling_store",sf_indoors, "interior_town_house_d", "bo_interior_town_house_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("lingling_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("lingling_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

    ("guiyang_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x30050d0d8002d4b300000e2f000027d200005f66",
    ["guiyang_castle","guiyang_tavern","guiyang_store"],[]),
  ("guiyang_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("guiyang_store",sf_indoors, "interior_town_house_d", "bo_interior_town_house_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("guiyang_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("guiyang_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

    ("nanhai_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0x30050d0d8002d4b300000e2f000027d200005f66",
    ["nanhai_castle","nanhai_tavern","nanhai_store"],[]),
  ("nanhai_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("nanhai_store",sf_indoors, "interior_town_house_c", "bo_interior_town_house_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("nanhai_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("nanhai_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

    ("yiling_center",sf_generate,"none", "none",(0,0),(100,100),-100,"0xb0058fa3000258960000541100000c5700001313",
    ["yiling_castle","yiling_tavern","yiling_store"],[]),
  ("yiling_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yiling_store",sf_indoors, "interior_town_house_c", "bo_interior_town_house_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yiling_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("yiling_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

     ("jianan_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x3000148000025896000074e600006c260000125a",
    ["jianan_castle","jianan_tavern","jianan_store"],[]),
  ("jianan_smithy",sf_indoors, "thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jianan_store",sf_indoors, "interior_house_a", "bo_interior_house_a", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jianan_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("jianan_prison",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

    ("jiaozhi_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x20020ee3000605860000466a0000532e000014f5",
    ["jiaozhi_castle","jiaozhi_tavern","jiaozhi_store"],[]),
  ("jiaozhi_smithy",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiaozhi_store",sf_indoors,"interior_town_house_i", "bo_interior_town_house_i", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiaozhi_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[]),
  ("jiaozhi_prison",sf_indoors,"dungeon_entry_a", "bo_dungeon_entry_a", (-100,-100),(100,100),-100,"0",
   ["exit"],[]),
#castle
   ("xiangping_castle",sf_indoors,"court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("beiping_castle",sf_indoors,"court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("beihai_castle",sf_indoors,"court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("pingyuan_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xiapi_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xiangyang_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("changan_castle",sf_indoors, "palace", "bo_palace", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("luoyang_castle",sf_indoors, "palace", "bo_palace", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("shouchun_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xuchang_castle",sf_indoors, "palace", "bo_palace", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
   
  ("runan_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("wancheng_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yecheng_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jinyang_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("anding_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("tianshui_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("sishuiguan_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("hulaoguan_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("tongguan_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("puyang_castle",sf_indoors,"court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("hefei_castle",sf_indoors,"court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("nanpi_castle",sf_indoors,"court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiangxia_castle",sf_indoors,"court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yongan_castle",sf_indoors,"court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiangzhou_castle",sf_indoors,"court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("chengdu_castle",sf_indoors,"palace", "bo_palace", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
   
  ("yunnan_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("shangyong_castle",sf_indoors,"court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiangling_castle",sf_indoors,"court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jianning_castle",sf_indoors,"court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("zitong_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("hanzhong_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
 ("jiange_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
 ("jianye_castle",sf_indoors, "palace", "bo_palace", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
    
  ("wu_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("huiji_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("chaisang_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("changsha_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("wuling_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("lingling_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("guiyang_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("nanhai_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yiling_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jianan_castle",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiaozhi_castle",sf_indoors,"court", "bo_court", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
#tavern
  ("xiangping_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("beiping_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("beihai_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("pingyuan_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xiapi_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xiangyang_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("changan_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("luoyang_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("shouchun_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("xuchang_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("runan_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("wancheng_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yecheng_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jinyang_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("anding_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("tianshui_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("sishuiguan_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("hulaoguan_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("tongguan_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("puyang_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("hefei_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("nanpi_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiangxia_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yongan_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiangzhou_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("chengdu_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yunnan_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("shangyong_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiangling_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jianning_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("zitong_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("hanzhong_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiange_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jianye_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("wu_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("huiji_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("chaisang_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("changsha_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("wuling_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("lingling_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("guiyang_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("nanhai_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("yiling_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jianan_tavern",sf_indoors, "tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("jiaozhi_tavern",sf_indoors,"tavern", "bo_tavern", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("sango",sf_indoors, "court", "bo_court", (-100,-100),(100,100),-100,"0",
    [],[]),


]

