from header_common import *
from header_operations import *
from header_parties import *
from header_items import *
from header_skills import *
from header_triggers import *
from header_troops import *

from module_constants import *
from setting_sango import *
####################################################################################################################
# Simple triggers are the alternative to old style triggers. They do not preserve state, and thus simpler to maintain.
#
#  Each simple trigger contains the following fields:
# 1) Check interval: How frequently this trigger will be checked
# 2) Operation block: This must be a valid operation block. See header_operations.py for reference. 
####################################################################################################################


simple_triggers_defined=1
simple_triggers = [

# This trigger is deprecated. Use "script_game_event_party_encounter" in module_scripts.py instead  
  (ti_on_party_encounter,
   [#SANGO NEW
   (store_encountered_party, "$g_encountered_party"),
       (store_encountered_party2,"$g_encountered_party_2"), # encountered_party2 is set when we come across a battle or siege, otherwise it's a minus value
       (assign, "$talk_context", 0),
       (assign,"$g_player_surrenders",0),
       (assign,"$g_enemy_surrenders",0),
       (assign, "$g_leave_encounter",0),
       (assign, "$new_encounter", 1), #check this in the menu.
       (try_begin),
         (lt, "$g_encountered_party_2",0), #Normal encounter. Not battle or siege.
         (try_begin),
           (eq, "$g_encountered_party", "p_zendar"),
           (jump_to_menu, "mnu_zendar"),
         (else_try),  
           (eq, "$g_encountered_party", "p_salt_mine"),
           (jump_to_menu, "mnu_salt_mine"),
         (else_try),
           (eq, "$g_encountered_party", "p_four_ways_inn"),
           (jump_to_menu, "mnu_four_ways_inn"),
         (else_try),
           (eq, "$g_encountered_party", "p_dhorak_keep"),
           (jump_to_menu, "mnu_dhorak_keep"),
         (else_try),
           (eq, "$g_encountered_party", "p_training_ground"),
           (jump_to_menu, "mnu_training_ground"),
         (else_try),
           (jump_to_menu, "mnu_simple_encounter"),
         (try_end),
       (else_try), #Battle
         (try_begin),
           (this_or_next|is_between, "$g_encountered_party", towns_begin, towns_end),
           (is_between, "$g_encountered_party", castles_begin, castles_end),
           (try_begin),
             (eq, "$auto_enter_town", "$g_encountered_party"),
             (jump_to_menu, "mnu_town"),
           (try_end),
         (else_try),
           (jump_to_menu, "mnu_pre_join"),
         (try_end),
       (try_end),
       (assign,"$auto_enter_town",0),
    ]),


# This trigger is deprecated. Use "script_game_event_simulate_battle" in module_scripts.py instead 
  (ti_simulate_battle,
   [
    ]),

  (1,
   [
      (gt,"$auto_besiege_town",0),
      (gt,"$g_player_besiege_town", 0),
      (ge, "$g_siege_method", 1),
      (store_current_hours, ":cur_hours"),
      (eq, "$g_siege_force_wait", 0),
      (ge, ":cur_hours", "$g_siege_method_finish_hours"),
      (neg|is_currently_night),
      (rest_for_hours, 0, 0, 0), #stop resting
    ]),

#Auto-menu
  (0,
   [   (map_free),
       (try_begin),
         (ge,"$auto_menu",1),
         (jump_to_menu,"$auto_menu"),
         (assign,"$auto_menu",-1),
       (else_try),
         (ge,"$auto_enter_town",1),
         (start_encounter, "$auto_enter_town"),
       (else_try),
         (ge,"$auto_besiege_town",1),
         (start_encounter, "$auto_besiege_town"),
       (else_try),
         (ge,"$g_camp_mode", 1),
         (assign, "$g_camp_mode", 0),
         (assign, "$g_player_icon_state", pis_normal),
         (display_message, "@Breaking camp..."),
       (try_end),
    ]),

#Player raiding a village
# This trigger will check if player's raid has been completed and will lead control to village menu.
  (1,
   [
      (ge,"$g_player_raiding_village",1),
      (try_begin),
        (neq, "$g_player_is_captive", 0),
        (rest_for_hours, 0, 0, 0), #stop resting - abort
        (assign,"$g_player_raiding_village",0),
      (else_try),
        (map_free), #we have been attacked during raid
      (else_try),
        (this_or_next|party_slot_eq, "$g_player_raiding_village", slot_village_state, svs_looted),
        (party_slot_eq, "$g_player_raiding_village", slot_village_state, svs_deserted),
        (start_encounter, "$g_player_raiding_village"),
        (rest_for_hours, 0),
        (assign,"$g_player_raiding_village",0),
        (assign,"$g_player_raid_complete",1),
      (else_try),
        (party_slot_eq, "$g_player_raiding_village", slot_village_state, svs_being_raided),
        (rest_for_hours, 3, 5, 1), #rest while attackable
      (else_try),
        (rest_for_hours, 0, 0, 0), #stop resting - abort
        (assign,"$g_player_raiding_village",0),
        (assign,"$g_player_raid_complete",0),
      (try_end),
    ]),


  #Pay day.
  (24 * 7,
   [
      (jump_to_menu,"mnu_pay_day"),
    ]),
  
  # Oath fulfilled?
##  (24,
##   [
##      (le,"$auto_menu",0),
##      (gt, "$players_kingdom", 0),
##      (store_current_day, ":cur_day"),
##      (gt, ":cur_day", "$g_oath_end_day"),
##      (jump_to_menu,"mnu_oath_fulfilled"),
##    ]),
  

  # Banner selection menu
  (24,
   [(eq, "$g_player_banner_granted", 1),
    (troop_slot_eq, "trp_player", slot_troop_banner_scene_prop, 0),
    (le,"$auto_menu",0),
    (start_presentation, "prsnt_banner_selection"),
    ]),

  # Party Morale: Move morale towards target value.
  (24,
   [
      (call_script, "script_get_player_party_morale_values"),
      (assign, ":target_morale", reg0),
      (party_get_morale, ":cur_morale", "p_main_party"),
      (store_sub, ":dif", ":target_morale", ":cur_morale"),
      (store_div, ":dif_to_add", ":dif", 5),
      (store_mul, ":dif_to_add_correction", ":dif_to_add", 5),
      (try_begin),#finding ceiling of the value
        (neq, ":dif_to_add_correction", ":dif"),
        (try_begin),
          (gt, ":dif", 0),
          (val_add, ":dif_to_add", 1),
        (else_try),
          (val_sub, ":dif_to_add", 1),
        (try_end),
      (try_end),
      (val_add, ":cur_morale", ":dif_to_add"),
      (party_set_morale, "p_main_party", ":cur_morale"),
    ]),
  

#Party AI: pruning some of the prisoners in each center (once a week)
  (24*7,
   [
       (try_for_range, ":center_no", centers_begin, centers_end),
         (party_get_num_prisoner_stacks, ":num_prisoner_stacks",":center_no"),
         (try_for_range_backwards, ":stack_no", 0, ":num_prisoner_stacks"),
           (party_prisoner_stack_get_troop_id, ":stack_troop",":center_no",":stack_no"),
           (neg|troop_is_hero, ":stack_troop"),
           (party_prisoner_stack_get_size, ":stack_size",":center_no",":stack_no"),
           (store_random_in_range, ":rand_no", 0, 40),
           (val_mul, ":stack_size", ":rand_no"),
           (val_div, ":stack_size", 100),
           (party_remove_prisoners, ":center_no", ":stack_troop", ":stack_size"),
         (try_end),
       (try_end),
    ]),

  #Adding net incomes to heroes (once a week)
  #Hiring men with hero wealths (once a week)
  #Increasing debts to heroes by 1% (once a week)
  #Adding net incomes to centers (once a week)
  #Hiring men with center wealths (once a week)
  (24*7,
   [
       (try_for_range, ":troop_no", kingdom_heroes_begin, kingdom_heroes_end),
         (troop_get_slot, ":cur_debt", ":troop_no", slot_troop_player_debt),#Increasing debt
         (val_mul, ":cur_debt", 101),
         (val_div, ":cur_debt", 100),
         (troop_set_slot, ":troop_no", slot_troop_player_debt, ":cur_debt"),
         (call_script, "script_calculate_hero_weekly_net_income_and_add_to_wealth", ":troop_no"),#Adding net income
         (troop_get_slot, ":party_no", ":troop_no", slot_troop_leaded_party),
         (ge, ":party_no", 1),
         (party_get_attached_to, ":cur_attached_party", ":party_no"),
         (is_between, ":cur_attached_party", centers_begin, centers_end),
         (party_slot_eq, ":cur_attached_party", slot_center_is_besieged_by, -1), #center not under siege
         (call_script, "script_hire_men_to_kingdom_hero_party", ":troop_no"),#Hiring men with current wealth
       (try_end),
       (try_for_range, ":center_no", centers_begin, centers_end),
         (try_begin),
           #If non-player center, adding income to wealth and hiring troops
           (party_get_slot, ":cur_wealth", ":center_no", slot_town_wealth),
           (try_begin),
             (party_slot_eq, ":center_no", slot_party_type, spt_town),
             (val_add, ":cur_wealth", 1000),
           (else_try),
             (val_add, ":cur_wealth", 500),
           (try_end),
           (call_script, "script_calculate_weekly_party_wage", ":center_no"),
           (val_sub, ":cur_wealth", reg0),
           
           (try_begin),
             (party_slot_eq, ":center_no", slot_center_is_besieged_by, -1), #center not under siege
             (neg|party_slot_eq, ":center_no", slot_town_lord, "trp_player"), #center does not belong to player.
             (assign, ":hiring_budget", ":cur_wealth"),
             (val_div, ":hiring_budget", 20),
             (try_begin),
               (gt, ":hiring_budget", reinforcement_cost),
               (neg|party_slot_ge, ":center_no", slot_center_is_besieged_by, 0),
               (call_script, "script_cf_reinforce_party", ":center_no"),
               (val_sub, ":cur_wealth", reinforcement_cost),
             (try_end),
           (try_end),
           (party_set_slot, ":center_no", slot_town_wealth, ":cur_wealth"),
         (try_end),
       (try_end),
    ]),

#Troop AI: Kingdom Heroes thinking
##  (24,
##   [
##       (try_for_range, ":troop_no", kingdom_heroes_begin, kingdom_heroes_end),
##         (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
##         (troop_slot_eq, ":troop_no", slot_troop_is_prisoner, 0),
##         (troop_get_slot, ":party_no", ":troop_no", slot_troop_leaded_party),
##         (gt, ":party_no", 0),
##         (party_get_attached_to, ":center_no", ":party_no"),
##         (store_troop_faction, ":faction_no", ":troop_no"),
##
##         (call_script, "script_party_count_fit_for_battle", ":party_no"),
##         (assign, ":party_fit_for_battle", reg0),
##
##         (assign, ":chance_move_to_home_center", 0),
##         (assign, ":target_move_to_home_center", -1),
##         (assign, ":chance_move_to_other_center", 0),
##         (assign, ":target_move_to_other_center", -1),
##         (assign, ":chance_besiege_enemy_center", 0),
##         (assign, ":target_besiege_enemy_center", -1),
##         (assign, ":chance_help_besieged_center", 0),
##         (assign, ":target_help_besieged_center", -1),
##         (assign, ":chance_patrol_around_center", 0),
##         (assign, ":target_patrol_around_center", -1),
##         (assign, ":chance_stay", 0),
##       
##         (assign, ":is_besieging", 0),
##         (assign, ":under_siege", 0),
##         (try_begin),
##           (party_get_battle_opponent, ":enemy_leader_party", ":party_no"),
##           (ge, ":enemy_leader_party", 0),
##           (party_get_battle_opponent, ":leader_party", ":enemy_leader_party"),
##           (is_between, ":leader_party", centers_begin, centers_end),
##           (assign, ":under_siege", 1),
##         (try_end),
##         (assign, ":siege_going_well", 0),
##         (assign, ":siege_going_badly", 0),
##         (try_begin),
##           (party_get_battle_opponent, ":besieged_center", ":party_no"),
##           (is_between, ":besieged_center", centers_begin, centers_end), #we are besieging
##       
##           (party_get_battle_opponent, ":leader_party", ":besieged_center"),
##       
##           (party_collect_attachments_to_party, ":besieged_center", "p_temp_party"),
##           (call_script, "script_party_calculate_strength", "p_temp_party"),
##           (assign, ":besieged_center_strength", reg0),
##           (val_max, ":besieged_center_strength", 1),
##
##           (party_collect_attachments_to_party, ":leader_party", "p_temp_party"),
##           (call_script, "script_party_calculate_strength", "p_temp_party"),
##           (assign, ":besiegers_strength", reg0),
##           (val_max, ":besiegers_strength", 1),
##
##           (try_begin),
##             (gt, ":besiegers_strength", ":besieged_center_strength"),
##             (assign, ":siege_going_well", 1),
##           (else_try),
##             (assign, ":siege_going_badly", 1),
##           (try_end),
##         (try_end),
##
##         (eq, ":under_siege", 0),
##         (try_begin),
##          
##           (assign, ":target_move_to_home_center", -1), #Moving to home center
##           (try_begin),
##             (is_between, ":center_no", centers_begin, centers_end),
##             (party_slot_eq,  ":center_no", slot_town_lord, ":troop_no"),
##             (assign, ":target_move_to_home_center", ":center_no"),
##             (assign, ":chance_move_to_home_center", 100),
##           (try_end),
##           (try_begin),
##             (eq, ":target_move_to_home_center", -1),
##             (call_script, "script_cf_troop_get_random_leaded_center", ":troop_no"),#Can fail
##             (assign, ":target_move_to_home_center", reg0),
##             (assign, ":chance_move_to_home_center", 50),
##           (try_end),
##         (try_end),
##         (try_begin),
##           
##           (assign, ":target_move_to_other_center", -1),#Moving to other center
##           (try_begin),
##             (party_slot_eq, ":party_no", slot_party_ai_state, spai_holding_center),
##             (party_get_slot, ":target_move_to_other_center", ":party_no", slot_party_ai_object),
##             (assign, ":chance_move_to_other_center", 30),
##           (try_end),
##           (try_begin),
##             (eq, ":target_move_to_other_center", -1),
##             (call_script, "script_cf_select_random_center_with_faction", ":faction_no"),
##             (assign, ":target_move_to_other_center", reg0),
##             (assign, ":chance_move_to_other_center", 10),
##             (party_get_slot, ":lord_of_center", ":target_move_to_other_center", slot_town_lord),
##             (try_begin),
##               (call_script, "script_cf_troop_check_troop_is_enemy", ":troop_no", ":lord_of_center"),
##             (else_try),
##               (assign, ":chance_move_to_other_center", 0),
##             (try_end),
##           (try_end),
##         (try_end),
##         (try_begin),
##           
##           (assign, ":target_besiege_enemy_center", -1),#Initiate siege
##           (try_begin),
##             (party_slot_eq, ":party_no", slot_party_ai_state, spai_besieging_center),
##             (party_get_slot, ":target_besiege_enemy_center", ":party_no", slot_party_ai_object),
##           (try_end),
##           (try_begin),
##             (eq, ":target_besiege_enemy_center", -1),
##             (try_begin),
##               (call_script, "script_cf_get_random_siege_location_with_attacker_faction", ":faction_no"),#Can fail
##               (assign, ":target_besiege_enemy_center", reg0),
##               (party_get_battle_opponent, ":target_party", ":target_besiege_enemy_center"),
##               (call_script, "script_cf_get_party_leader", ":target_party"),#Can fail
##               (assign, ":target_lord", reg0),
##               (try_begin),
##                 (call_script, "script_cf_troop_check_troop_is_enemy", ":troop_no", ":target_lord"),#Can fail
##                 (assign, ":target_besiege_enemy_center", -1),
##               (try_end),
##             (try_end),
##             (try_begin),
##               (eq, ":target_besiege_enemy_center", -1),
##               (call_script, "script_get_random_enemy_center", ":party_no"),
##               (assign, ":target_besiege_enemy_center", reg0),
##             (try_end),
##           (try_end),
##           (try_begin),
##             (is_between, ":target_besiege_enemy_center", centers_begin, centers_end),
##             (party_collect_attachments_to_party, ":target_besiege_enemy_center", "p_temp_party"),
##             (call_script, "script_party_calculate_strength", "p_temp_party"),
##             (assign, ":enemy_strength", reg0),
##             (val_max, ":enemy_strength", 1),
##             (party_clear, "p_temp_party"),
##             (try_begin),
##               (party_get_battle_opponent, ":friend_party", ":target_besiege_enemy_center"),
##               (gt, ":friend_party", 0),
##               (party_collect_attachments_to_party, ":friend_party", "p_temp_party"),
##             (try_end),
##             (try_begin),
##               (neq, ":center_no", ":friend_party"),
##               (assign, "$g_move_heroes", 1),
##               (call_script, "script_party_add_party_companions", "p_temp_party", ":party_no"),
##             (try_end),
##             (call_script, "script_party_calculate_strength", "p_temp_party"),
##             (assign, ":our_strength", reg0),
##             (store_mul, ":strength_ratio", ":our_strength", 100),
##             (val_div, ":strength_ratio", ":enemy_strength"),
##       
##             (gt, ":strength_ratio", 90),
##             (store_div, ":chance_besiege_enemy_center", ":strength_ratio", 4),
##             (store_distance_to_party_from_party, ":cur_distance", ":party_no", ":target_besiege_enemy_center"),
##             (val_add, ":cur_distance", 20),
##             (val_mul, ":chance_besiege_enemy_center", 20),
##             (val_div, ":chance_besiege_enemy_center", ":cur_distance"),
##           (try_end),
##         (try_end),
##         (try_begin),
##           
##           (assign, ":target_help_besieged_center", -1),#Help besieged center
##           (try_begin),
##             (party_slot_eq, ":party_no", slot_party_ai_state, spai_helping_town_against_siege),
##             (party_get_slot, ":target_help_besieged_center", ":party_no", slot_party_ai_object),
##           (try_end),
##           (try_begin),
##             (eq, ":target_help_besieged_center", -1),
##             (call_script, "script_cf_get_random_siege_location_with_faction", ":faction_no"),#Can fail
##             (assign, ":target_help_besieged_center", reg0),
##           (try_end),
##           (try_begin),
##             (neq, ":target_help_besieged_center", -1),
##             (party_get_slot, ":target_lord", ":target_help_besieged_center", slot_town_lord),
##             (try_begin),
##               (call_script, "script_cf_troop_check_troop_is_enemy", ":troop_no", ":target_lord"),#Can fail
##             (else_try),
##               (gt, ":party_fit_for_battle", 20),
##               (assign, ":chance_help_besieged_center", 10),
##             (try_end),
##           (try_end),
##         (try_end),
##         (try_begin),
##           
##           (assign, ":target_patrol_around_center", -1),#Patrol
##           (try_begin),
##             (party_slot_eq, ":party_no", slot_party_ai_state, spai_patrolling),
##             (party_get_slot, ":target_patrol_around_center", ":party_no", slot_party_ai_object),
##           (try_end),
##           (try_begin),
##             (eq, ":target_patrol_around_center", -1),
##             (call_script, "script_get_closest_center_of_faction", ":party_no", ":faction_no"),
##             (assign, ":target_patrol_around_center", reg0),
##           (try_end),
##           (try_begin),
##              (neg|faction_slot_eq,":faction_no",slot_faction_leader, ":troop_no"),
##              (gt, ":party_fit_for_battle", 15),
##              (is_between, ":target_patrol_around_center", centers_begin, centers_end),
##              (assign, ":chance_patrol_around_center", 50),
##           (try_end),
##         (try_end),
##         (try_begin),
##           
##           (party_get_slot, ":ai_state", ":party_no", slot_party_ai_state),#Stay
##           (neq, ":ai_state", spai_undefined),
##           (eq, ":is_besieging", 0),
##           (assign, ":chance_stay", 100),
##         (try_end),
##
##         (try_begin),
##           (eq, ":siege_going_badly", 1),
##           (assign, ":chance_besiege_enemy_center", 0),
##           (assign, ":chance_stay", 0),
##         (try_end),
##         (try_begin),
##           (eq, ":siege_going_well", 1),
##           (assign, ":chance_move_to_home_center", 0),
##           (assign, ":chance_move_to_other_center", 0),
##           (assign, ":chance_patrol_around_center", 0),
##           (assign, ":chance_besiege_enemy_center", 0),
##           (assign, ":chance_help_besieged_center", 0),
##         (try_end),
##
##         (assign, ":sum_chances", ":chance_move_to_home_center"),
##         (val_add, ":sum_chances", ":chance_move_to_other_center"),
##         (val_add, ":sum_chances", ":chance_besiege_enemy_center"),
##         (val_add, ":sum_chances", ":chance_help_besieged_center"),
##         (val_add, ":sum_chances", ":chance_patrol_around_center"),
##         (val_add, ":sum_chances", ":chance_stay"),
##         (store_random_in_range, ":random_no", 0, ":sum_chances"),
##         (val_sub, ":random_no", ":chance_move_to_home_center"),
##         (try_begin),
##           (lt, ":random_no", 0),
##           (party_set_ai_object, ":party_no", ":target_move_to_home_center"),
##           (party_set_ai_behavior, ":party_no", ai_bhvr_travel_to_party),
##           (party_set_slot, ":party_no", slot_party_ai_state, spai_holding_center),
##           (party_set_slot, ":party_no", slot_party_ai_object, ":target_move_to_home_center"),
##           (try_begin),
##             (is_between, ":center_no", centers_begin, centers_end),
##             (party_detach, ":party_no"),
##           (try_end),
##           (party_set_flags, ":party_no", pf_default_behavior, 1),
##         (else_try),
##           (val_sub, ":random_no", ":chance_move_to_other_center"),
##           (lt, ":random_no", 0),
##           (party_set_ai_object, ":party_no", ":target_move_to_other_center"),
##           (party_set_ai_behavior, ":party_no", ai_bhvr_travel_to_party),
##           (party_set_flags, ":party_no", pf_default_behavior, 0),
##           (party_set_slot, ":party_no", slot_party_ai_state, spai_holding_center),
##           (party_set_slot, ":party_no", slot_party_ai_object, ":target_move_to_other_center"),
##           (try_begin),
##             (is_between, ":center_no", centers_begin, centers_end),
##             (party_detach, ":party_no"),
##           (try_end),
##         (else_try),
##           (val_sub, ":random_no", ":chance_besiege_enemy_center"),
##           (lt, ":random_no", 0),
##           (party_set_ai_object, ":party_no", ":target_besiege_enemy_center"),
##           (party_set_ai_behavior, ":party_no", ai_bhvr_attack_party),
##           (party_set_slot, ":party_no", slot_party_ai_state, spai_besieging_center),
##           (party_set_slot, ":party_no", slot_party_ai_object, ":target_besiege_enemy_center"),
##           (try_begin),
##             (is_between, ":center_no", centers_begin, centers_end),
##             (party_detach, ":party_no"),
##           (try_end),
##           (party_set_flags, ":party_no", pf_default_behavior, 1),
##         (else_try),
##           (val_sub, ":random_no", ":chance_help_besieged_center"),
##           (lt, ":random_no", 0),
##           (party_set_ai_object, ":party_no", ":target_help_besieged_center"),
##           (party_set_ai_behavior, ":party_no", ai_bhvr_travel_to_party),
##           (party_set_slot, ":party_no", slot_party_ai_state, spai_helping_town_against_siege),
##           (party_set_slot, ":party_no", slot_party_ai_object, ":target_help_besieged_center"),
##           (try_begin),
##             (is_between, ":center_no", centers_begin, centers_end),
##             (party_detach, ":party_no"),
##           (try_end),
##           (party_set_flags, ":party_no", pf_default_behavior, 1),
##         (else_try),
##           (val_sub, ":random_no", ":chance_patrol_around_center"),
##           (lt, ":random_no", 0),
##           (party_set_ai_object, ":party_no", ":target_patrol_around_center"),
##           (party_set_ai_behavior, ":party_no", ai_bhvr_patrol_party),
##           (party_set_flags, ":party_no", pf_default_behavior, 0),
##           (party_set_slot, ":party_no", slot_party_ai_state, spai_patrolling),
##           (party_set_slot, ":party_no", slot_party_ai_object, ":target_patrol_around_center"),
##           (try_begin),
##             (is_between, ":center_no", centers_begin, centers_end),
##             (party_detach, ":party_no"),
##           (try_end),
##         (try_end),
##       (try_end),
##    ]),
##

  #Party AI: Kingdom Parties thinking after return
  (5,
   [
       (try_for_parties, ":party_no"),
         (party_is_in_any_town, ":party_no"),#TODO: Change this
         (get_party_ai_object, ":party_center", ":party_no"),

         (store_faction_of_party, ":party_faction", ":party_no"),
         (store_faction_of_party, ":center_faction", ":party_no"),
         (try_begin),
           #Redirecting parties because of returning to the newly captured centers
           (neq, ":party_faction", ":center_faction"),
           (party_get_slot, ":party_type", ":party_no", slot_party_type),
           (is_between, ":party_type", kingdom_party_types_begin, kingdom_party_types_end),
           (call_script, "script_get_closest_center_of_faction", ":party_no", ":party_faction"),
           (assign, ":new_center", reg0),
           (party_set_ai_object, ":party_no", ":new_center"),
         (else_try),
           (party_slot_eq, ":party_no", slot_party_ai_state, spai_trading_within_kingdom),
           (call_script, "script_find_travel_location", ":party_center"),
           (assign, ":new_center_no", reg0),
           (try_begin),
             (lt, ":new_center_no", 0),
             (remove_party, ":party_no"),
           (else_try),
             (party_set_ai_behavior, ":party_no", ai_bhvr_travel_to_party),
             (party_set_ai_object, ":party_no", ":new_center_no"),
             (party_set_flags, ":party_no", pf_default_behavior, 0),
           (try_end),
         (try_end),
       (try_end),
    ]),

  # Give some xp to hero parties
   (48,
   [
       (try_for_range, ":troop_no", kingdom_heroes_begin, kingdom_heroes_end),
         (store_random_in_range, ":rand", 0, 100),
         (lt, ":rand", 30),
         (troop_get_slot, ":hero_party", ":troop_no", slot_troop_leaded_party),
         (gt, ":hero_party", centers_end),
         (party_is_active, ":hero_party"),
         (party_upgrade_with_xp, ":hero_party", 500),
       (try_end),
    ]),

  # Process sieges
   (24,
   [
       (call_script, "script_process_sieges"),
    ]),

  # Process village raids
   (2,
   [
       (call_script, "script_process_village_raids"),
    ]),


  # Decide vassal ai
   (12,
   [
       (try_for_range, ":troop_no", kingdom_heroes_begin, kingdom_heroes_end),
         (call_script, "script_decide_kingdom_party_ai", ":troop_no"),
       (try_end),
    ]),

  
  # Process vassal ai
   (3,
   [
       (call_script, "script_process_kingdom_parties_ai"),
    ]),

  # Process alarms
   (3,
   [
       (call_script, "script_process_alarms"),
    ]),


  # Decide faction ai
   (3 * 24,
   [
       (try_for_range, ":faction_no", kingdoms_begin, kingdoms_end),
         (call_script, "script_decide_faction_ai", ":faction_no"),
       (try_end),
    ]),
  
  # Count faction armies
   (24,
   [
       (try_for_range, ":faction_no", kingdoms_begin, kingdoms_end),
         (call_script, "script_faction_recalculate_strength", ":faction_no"),
       (try_end),
    ]),

  # Reset hero quest status
  # Change hero relation
  # Change hero favor
   (24,
   [
       (try_for_range, ":troop_no", heroes_begin, heroes_end),
         (troop_set_slot, ":troop_no", slot_troop_does_not_give_quest, 0),
         (troop_get_slot, ":relation", ":troop_no", slot_troop_player_relation),
         (troop_get_slot, ":favor", ":troop_no", slot_troop_player_favor),
         (try_begin),
           (gt, ":relation", 0),
           (try_begin),
             (gt, ":relation", ":favor"),
             (store_div, ":increment_amount", ":relation", 10),
             (val_add, ":increment_amount", 1),
             (val_add, ":favor", ":increment_amount"),#Moving towards relation by 10% + 1 of the relation every day
           (else_try),
             (assign, ":favor", ":relation"),#Favor can not be greater than the relation
           (try_end),
         (try_end),
         (troop_set_slot, ":troop_no", slot_troop_player_favor, ":favor"),
       (try_end),
    ]),

  # Refresh merchant inventories
   (24,
   [
      (try_for_range, ":village_no", villages_begin, villages_end),
        (call_script, "script_refresh_village_merchant_inventory", ":village_no"),
      (try_end),
    ]),

   (48,
   [
      (try_for_range, ":village_no", villages_begin, villages_end),
        (call_script, "script_refresh_village_defenders", ":village_no"),
      (try_end),
    ]),

  # Accumulate taxes
   (24 * 7,
   [
      (try_for_range, ":center_no", centers_begin, centers_end),
        (party_get_slot, ":accumulated_rents", ":center_no", slot_center_accumulated_rents),
        (try_begin),
          (party_slot_eq, ":center_no", slot_party_type, spt_village),
          (party_slot_eq, ":center_no", slot_village_state, svs_normal),
          (val_add, ":accumulated_rents", 700),
        (else_try),
          (party_slot_eq, ":center_no", slot_party_type, spt_castle),
          (val_add, ":accumulated_rents", 500),
        (else_try),
          (party_slot_eq, ":center_no", slot_party_type, spt_town),
          (val_add, ":accumulated_rents", 1500),
        (try_end),
        (party_set_slot, ":center_no", slot_center_accumulated_rents, ":accumulated_rents"),
      (try_end),

      #Adding earnings to town lords' wealths.
      (try_for_range, ":center_no", centers_begin, centers_end),
        (party_get_slot, ":town_lord", ":center_no", slot_town_lord),
        (neq, ":town_lord", "trp_player"),
        (is_between, ":town_lord", kingdom_heroes_begin, kingdom_heroes_end),
        (party_get_slot, ":accumulated_rents", ":center_no", slot_center_accumulated_rents),
        (party_get_slot, ":accumulated_tariffs", ":center_no", slot_center_accumulated_tariffs),
        (troop_get_slot, ":troop_wealth", ":town_lord", slot_troop_wealth),
        (val_add, ":troop_wealth", ":accumulated_rents"),
        (val_add, ":troop_wealth", ":accumulated_tariffs"),
        (troop_set_slot, ":town_lord", slot_troop_wealth, ":troop_wealth"),
        (party_set_slot, ":center_no", slot_center_accumulated_rents, 0),
        (party_set_slot, ":center_no", slot_center_accumulated_tariffs, 0),
        (assign, reg1, ":troop_wealth"),
        (add_troop_note_from_sreg, ":town_lord", 2, "@Current wealth: {reg1}", 0),
      (try_end),
    ]),

   (7 * 24,
   [
       (call_script, "script_get_number_of_unclaimed_centers_by_player"),
       (assign, ":unclaimed_centers", reg0),
       (gt, ":unclaimed_centers", 0),
# You are holding an estate without a lord.        
#       (try_for_range, ":troop_no", heroes_begin, heroes_end),
#         (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
#         (troop_get_slot, ":relation", ":troop_no", slot_troop_player_relation),
#         (val_sub, ":relation", 1),
#         (val_max, ":relation", -100),
#         (troop_set_slot, ":troop_no", slot_troop_player_relation, ":relation"),
#       (try_end),
# You relation with all kingdoms other than your own has decreased by 1.     
#       (try_for_range, ":faction_no", kingdoms_begin, kingdoms_end),
#         (neq, ":faction_no", "$players_kingdom"),
#         (store_relation,":faction_relation",":faction_no","fac_player_faction"),
#         (val_sub, ":faction_relation", 1),
#         (val_max, ":faction_relation", -100),
#         (set_relation, ":faction_no", "fac_player_faction", ":faction_relation"),
#       (try_end),
    ]),

  
  # Offer player to join faction
   (24,
   [
       (eq, "$players_kingdom", 0),
       (le, "$g_invite_faction", 0),
       (eq, "$g_player_is_captive", 0),
       (troop_get_slot, ":player_renown", "trp_player", slot_troop_renown),
       (ge, ":player_renown", 100),
       (store_random_in_range, ":rand", 0, 100),
       (lt, ":rand", 50),
       (store_random_in_range, ":kingdom_no", kingdoms_begin, kingdoms_end),
       (assign, ":min_distance", 999999),
       (try_for_range, ":center_no", walled_centers_begin, walled_centers_end),
         (store_distance_to_party_from_party, ":cur_distance", "p_main_party", ":center_no"),
         (val_min, ":min_distance", ":cur_distance"),
       (try_end),
       (lt, ":min_distance", 30),
       (store_relation, ":reln", ":kingdom_no", "fac_player_faction"),
       (ge, ":reln", 0),
       (faction_get_slot, ":kingdom_lord", ":kingdom_no", slot_faction_leader),
       (troop_get_slot, ":lord_rel", ":kingdom_lord", slot_troop_player_relation),
       (ge, ":lord_rel", 0),
       (assign, "$g_invite_offered_center", -1),
       (try_for_range, ":village_no", villages_begin, villages_end),
         (store_faction_of_party, ":village_faction", ":village_no"),
         (eq, ":village_faction", ":kingdom_no"),
         (assign, "$g_invite_offered_center", ":village_no"),
       (try_end),
       (ge, "$g_invite_offered_center", 0),
       (assign, "$g_invite_faction", ":kingdom_no"),
       (jump_to_menu, "mnu_invite_player_to_faction"),
    ]),




  # Reset kingdom lady current centers
##   (28,
##   [
##       (try_for_range, ":troop_no", heroes_begin, heroes_end),
##         (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_lady),
##
##         # Find the active quest ladies
##         (assign, ":not_ok", 0),
##         (try_for_range, ":quest_no", lord_quests_begin, lord_quests_end),
##           (eq, ":not_ok", 0),
##           (check_quest_active, ":quest_no"),
##           (quest_slot_eq, ":quest_no", slot_quest_object_troop, ":troop_no"),
##           (assign, ":not_ok", 1),
##         (try_end),
##         (eq, ":not_ok", 0),
##
##         (troop_get_slot, ":troop_center", ":troop_no", slot_troop_cur_center),
##         (assign, ":is_under_siege", 0),
##         (try_begin),
##           (is_between, ":troop_center", walled_centers_begin, walled_centers_end),
##           (party_get_battle_opponent, ":besieger_party", ":troop_center"),
##           (gt, ":besieger_party", 0),
##           (assign, ":is_under_siege", 1),
##         (try_end),
##
##         (eq, ":is_under_siege", 0),# Omit ladies in centers under siege
##
##         (try_begin),
##           (store_random_in_range, ":random_num",0, 100),
##           (lt, ":random_num", 20),
##           (store_troop_faction, ":cur_faction", ":troop_no"),
##           (call_script, "script_cf_select_random_town_with_faction", ":cur_faction"),#Can fail
##           (troop_set_slot, ":troop_no", slot_troop_cur_center, reg0),
##         (try_end),
##       
##         (store_random_in_range, ":random_num",0, 100),
##         (lt, ":random_num", 50),
##         (troop_get_slot, ":lord_no", ":troop_no", slot_troop_father),
##         (try_begin),
##           (eq, ":lord_no", 0),
##           (troop_get_slot, ":lord_no", ":troop_no", slot_troop_spouse),
##         (try_end),
##         (gt, ":lord_no", 0),
##         (troop_get_slot, ":cur_party", ":lord_no", slot_troop_leaded_party),
##         (gt, ":cur_party", 0),
##         (party_get_attached_to, ":cur_center", ":cur_party"),
##         (gt, ":cur_center", 0),
##
##         (troop_set_slot, ":troop_no", slot_troop_cur_center, ":cur_center"),
##       (try_end),
##    ]),


  # Attach Lord Parties to the town they are in
  (0.1,
   [
       (try_for_range, ":troop_no", heroes_begin, heroes_end),
         (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
         (troop_get_slot, ":troop_party_no", ":troop_no", slot_troop_leaded_party),
         (ge, ":troop_party_no", 1),
         (party_get_attached_to, ":cur_attached_town", ":troop_party_no"),
         (lt, ":cur_attached_town", 1),
         (party_get_cur_town, ":destination", ":troop_party_no"),
         (is_between, ":destination", centers_begin, centers_end),
         (call_script, "script_get_relation_between_parties", ":destination", ":troop_party_no"),
         (ge, reg0, 0),
         (party_attach_to_party, ":troop_party_no", ":destination"),
         (try_begin),
           (store_faction_of_party, ":troop_faction_no", ":troop_party_no"),
           (store_faction_of_party, ":destination_faction_no", ":destination"),
           (eq, ":troop_faction_no", ":destination_faction_no"),
           (assign, "$g_move_heroes", 1),
           (call_script, "script_party_prisoners_add_party_prisoners", ":destination", ":troop_party_no"),#Moving prisoners to the center
           (assign, "$g_move_heroes", 1),
           (call_script, "script_party_remove_all_prisoners", ":troop_party_no"),
         (try_end),
       (try_end),
    ]),


  # Respawn hero party after kingdom hero is released from captivity.
  (48,
   [
       (try_for_range, ":troop_no", kingdom_heroes_begin, kingdom_heroes_end),
         (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
         (troop_slot_eq, ":troop_no", slot_troop_is_prisoner, 0),
         (neg|troop_slot_ge, ":troop_no", slot_troop_leaded_party, 1),

         (store_troop_faction, ":cur_faction", ":troop_no"),
         (call_script, "script_cf_select_random_center_with_faction", ":cur_faction"),#Can fail
         (assign, ":center_no", reg0),
         (party_slot_eq, ":center_no", slot_center_is_besieged_by, -1), #center not under siege
         (call_script, "script_create_kingdom_hero_party", ":troop_no", ":center_no"),
         (party_attach_to_party, "$pout_party", ":center_no"),
       (try_end),
    ]),

  # Spawn merchant caravan parties
##  (3,
##   [
##       (try_for_range, ":troop_no", merchants_begin, merchants_end),
##         (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_merchant),
##         (troop_slot_eq, ":troop_no", slot_troop_is_prisoner, 0),
##         (neg|troop_slot_ge, ":troop_no", slot_troop_leaded_party, 1),
##
##         (call_script, "script_cf_create_merchant_party", ":troop_no"),
##       (try_end),
##    ]),

  # Spawn village farmer parties
  (24,
   [
       (try_for_range, ":village_no", villages_begin, villages_end),
         (party_slot_eq, ":village_no", slot_village_state, svs_normal),
         (party_get_slot, ":farmer_party", ":village_no", slot_village_farmer_party),
         (this_or_next|eq, ":farmer_party", 0),
         (neg|party_is_active, ":farmer_party"),
         (store_random_in_range, ":random_no", 0, 100),
         (lt, ":random_no", 30),
         (call_script, "script_create_village_farmer_party", ":village_no"),
         (assign, ":party_no", reg0),
         (party_set_slot, ":village_no", slot_village_farmer_party, ":party_no"),
         (str_store_party_name, s1, ":village_no"),
#         (display_message, "@Village farmers created at {s1}."),
       (try_end),
    ]),

  
   (24,
   [
  # Updating trade good prices according to the productions
       (call_script, "script_update_trade_good_prices"),
 # Updating player odds
       (try_for_range, ":cur_center", centers_begin, centers_end),
         (party_get_slot, ":player_odds", ":cur_center", slot_town_player_odds),
         (try_begin),
           (gt, ":player_odds", 1000),
           (val_mul, ":player_odds", 95),
           (val_div, ":player_odds", 100),
           (val_max, ":player_odds", 1000),
         (else_try),
           (lt, ":player_odds", 1000),
           (val_mul, ":player_odds", 105),
           (val_div, ":player_odds", 100),
           (val_min, ":player_odds", 1000),
         (try_end),
         (party_set_slot, ":cur_center", slot_town_player_odds, ":player_odds"),
       (try_end),
    ]),


  #Troop AI: Merchants thinking
  (8,
   [
       (try_for_parties, ":party_no"),
         (party_slot_eq, ":party_no", slot_party_type, spt_kingdom_caravan),
         (party_is_in_any_town, ":party_no"),
         
         (try_begin),
           (party_get_slot, ":cur_ai_state", ":party_no", slot_party_ai_state),
           (eq, ":cur_ai_state", spai_trading_with_town),
           (party_get_cur_town, ":cur_center", ":party_no"),
           (party_get_slot, ":cur_ai_object", ":party_no", slot_party_ai_object),
           (eq, ":cur_center", ":cur_ai_object"),
           (call_script, "script_do_merchant_town_trade", ":party_no", ":cur_center"),
         (try_end),
         
         (try_begin), #Make sure escorted caravan continues to its original destination.
           (eq, "$caravan_escort_party_id", ":party_no"),
           (neg|party_is_in_town, ":party_no", "$caravan_escort_destination_town"),
           (assign, ":target_center", "$caravan_escort_destination_town"),
         (else_try),
           (store_faction_of_party, ":merchant_faction", ":party_no"),
           (call_script, "script_cf_select_random_town_at_peace_with_faction",  ":merchant_faction"),
           (assign, ":target_center", reg0),
         (try_end),
         (neg|party_is_in_town, ":party_no", ":target_center"),
         (party_set_ai_behavior, ":party_no", ai_bhvr_travel_to_party),
         (party_set_ai_object, ":party_no", ":target_center"),
         (party_set_flags, ":party_no", pf_default_behavior, 0),
         (party_set_slot, ":party_no", slot_party_ai_state, spai_trading_with_town),
         (party_set_slot, ":party_no", slot_party_ai_object, ":target_center"),
       (try_end),
    ]),

  #Troop AI: Village farmers thinking
  (8,
   [
       (try_for_parties, ":party_no"),
         (party_slot_eq, ":party_no", slot_party_type, spt_village_farmer),
         (party_is_in_any_town, ":party_no"),
         (party_get_slot, ":home_center", ":party_no", slot_party_home_center),

         (try_begin),
           (party_is_in_town, ":party_no", ":home_center"),

           (try_begin),
             (store_random_in_range, ":random_no", 0, 100),
             (lt, ":random_no", 10),
             (call_script, "script_do_party_center_trade", ":party_no", ":home_center", 50),
             (assign, ":total_change", reg0),
             (val_div, ":total_change", 10),#10% of the sales.

             #Adding tax revenue to the center
             (party_get_slot, ":accumulated_tariffs", ":home_center", slot_center_accumulated_tariffs),
             (val_add, ":accumulated_tariffs", ":total_change"),
             (party_set_slot, ":home_center", slot_center_accumulated_tariffs, ":accumulated_tariffs"),
      
             #Moving farmers to the home town
             (party_get_slot, ":market_town", ":home_center", slot_village_market_town),
             (party_set_slot, ":party_no", slot_party_ai_object, ":market_town"),
             (party_set_slot, ":party_no", slot_party_ai_state, spai_trading_with_town),
             (party_set_ai_behavior, ":party_no", ai_bhvr_travel_to_party),
             (party_set_ai_object, ":party_no", ":market_town"),
             (str_store_party_name, s1, ":home_center"),
             (assign, reg1, ":total_change"),
             (try_begin),
               (eq, "$cheat_mode", 1),
               (display_message, "@Village farmers traded with {s1} merchants. Tax={reg1}"),
             (try_end),
           (try_end),
         (else_try),
           (party_get_slot, ":cur_ai_object", ":party_no", slot_party_ai_object),

           (call_script, "script_do_party_center_trade", ":party_no", ":cur_ai_object", 10),
           (assign, ":total_change", reg0),
           (val_div, ":total_change", 10),#10% of the sales.

           #Adding tax revenue to the center
           (party_get_slot, ":accumulated_tariffs", ":cur_ai_object", slot_center_accumulated_tariffs),
           (val_add, ":accumulated_tariffs", ":total_change"),
           (party_set_slot, ":cur_ai_object", slot_center_accumulated_tariffs, ":accumulated_tariffs"),
           #Adding tax revenue to the home center
           (party_get_slot, ":accumulated_tariffs", ":home_center", slot_center_accumulated_tariffs),
           (val_add, ":accumulated_tariffs", ":total_change"),
           (party_set_slot, ":home_center", slot_center_accumulated_tariffs, ":accumulated_tariffs"),

           #Increasing food stocks of the town
           (party_get_slot, ":town_food_store", ":cur_ai_object", slot_party_food_store),
           (call_script, "script_center_get_food_store_limit", ":cur_ai_object"),
           (assign, ":food_store_limit", reg0),
           (val_add, ":town_food_store", 1000),
           (val_min, ":town_food_store", ":food_store_limit"),
           (party_set_slot, ":cur_ai_object", slot_party_food_store, ":town_food_store"),

           #Moving farmers to their home village
           (party_set_slot, ":party_no", slot_party_ai_object, ":home_center"),
           (party_set_slot, ":party_no", slot_party_ai_state, spai_trading_with_town),
           (party_set_ai_behavior, ":party_no", ai_bhvr_travel_to_party),
           (party_set_ai_object, ":party_no", ":home_center"),
           (str_store_party_name, s1, ":cur_ai_object"),
           (assign, reg1, ":total_change"),
           (try_begin),
             (eq, "$cheat_mode", 1),
             (display_message, "@Village farmers traded with {s1} merchants. Tax={reg1} to both sides"),
           (try_end),
         (try_end),
       (try_end),
    ]),


  # Make heroes running away from someone retreat to friendly centers
  (0.5,
   [
       (try_for_range, ":cur_troop", heroes_begin, heroes_end),
         (troop_slot_eq, ":cur_troop", slot_troop_occupation, slto_kingdom_hero),
         (troop_get_slot, ":cur_party", ":cur_troop", slot_troop_leaded_party),
         (gt, ":cur_party", 0),
         (get_party_ai_current_behavior, ":ai_bhvr", ":cur_party"),
         (eq, ":ai_bhvr", ai_bhvr_avoid_party),
         (store_faction_of_party, ":party_faction", ":cur_party"),
         (assign, ":done", 0),
         (try_for_range, ":cur_center", walled_centers_begin, walled_centers_end),
           (eq, ":done", 0),
           (store_faction_of_party, ":center_faction", ":cur_center"),
           (store_relation, ":cur_relation", ":center_faction", ":party_faction"),
           (ge, ":cur_relation", 0),
           (store_distance_to_party_from_party, ":cur_distance", ":cur_party", ":cur_center"),
           (lt, ":cur_distance", 20),
           (party_get_position, pos1, ":cur_party"),
           (party_get_position, pos2, ":cur_center"),
           (neg|position_is_behind_position, pos2, pos1),
           (party_set_ai_behavior, ":cur_party", ai_bhvr_travel_to_party),
           (party_set_ai_object, ":cur_party", ":cur_center"),
           (party_set_slot, ":cur_party", slot_party_ai_state, spai_retreating_to_center),
           (party_set_slot, ":cur_party", slot_party_ai_object, ":cur_center"),
           (party_set_slot, ":cur_party", slot_party_commander_party, -1),
           (party_set_flags, ":cur_party", pf_default_behavior, 1),
           (assign, ":done", 1),
         (try_end),
       (try_end),
    ]),

  # Consuming food at every 8 hours
  (8,
   [#(store_sub, ":num_food", food_end, food_begin),
    (party_get_num_companion_stacks, ":num_stacks","p_main_party"),
    (assign, ":num_men", 0),
    (try_for_range, ":i_stack", 0, ":num_stacks"),
      (party_stack_get_size, ":stack_size","p_main_party",":i_stack"),
      (val_add, ":num_men", ":stack_size"),
    (try_end),
    (val_div, ":num_men", 3),
    (try_begin),
      (eq, ":num_men", 0),
      (val_add, ":num_men", 1),
    (try_end),
    
    (assign, ":consumption_amount", ":num_men"),
    (assign, ":no_food_displayed", 0),
    (try_for_range, ":unused", 0, ":consumption_amount"),
      (assign, ":available_food", 0),
      (try_for_range, ":cur_food", food_begin, food_end),
        (item_set_slot, ":cur_food", slot_item_is_checked, 0),
        (player_has_item, ":cur_food"),
        (val_add, ":available_food", 1),
      (try_end),
      (try_begin),
        (gt, ":available_food", 0),
        (store_random_in_range, ":selected_food", 0, ":available_food"),
        (call_script, "script_consume_food", ":selected_food"),
      (else_try),
        (eq, ":no_food_displayed", 0),
        (display_message, "@Party has nothing to eat!", 0xFF0000),
        (assign, ":no_food_displayed", 1),
      (try_end),
      (assign, ":available_morale_boosters", 0),
      (try_for_range, ":cur_food", food_end, morale_boosters_end),
        (item_set_slot, ":cur_food", slot_item_is_checked, 0),
        (player_has_item, ":cur_food"),
        (val_add, ":available_morale_boosters", 1),
      (try_end),
      (try_begin),
        (gt, ":available_morale_boosters", 0),
        (store_add, ":random_end", ":available_food", ":available_morale_boosters"),
        (store_random_in_range, ":selected_food", ":available_food", ":random_end"),
        (call_script, "script_consume_food", ":selected_food"),
      (try_end),
    (try_end),
    ]),

  # Assigning lords to centers with no leaders
  (72,
   [(call_script, "script_assign_lords_to_empty_centers"),
    ]),
  
  # Updating player icon in every frame
  (0,
   [(troop_get_inventory_slot, ":cur_horse", "trp_player", 8), #horse slot
    (assign, ":new_icon", -1),
    (try_begin),
      (eq, "$g_player_icon_state", pis_normal),
      (try_begin),
        (ge, ":cur_horse", 0),
        (assign, ":new_icon", "icon_player_horseman"),
      (else_try),
        (assign, ":new_icon", "icon_player"),
      (try_end),
    (else_try),
      (eq, "$g_player_icon_state", pis_camping),
      (assign, ":new_icon", "icon_camp"),
    (else_try),
      (eq, "$g_player_icon_state", pis_ship),
      (assign, ":new_icon", "icon_ship"),
    (try_end),
    (neq, ":new_icon", "$g_player_party_icon"),
    (assign, "$g_player_party_icon", ":new_icon"),
    (party_set_icon, "p_main_party", ":new_icon"),
    ]),

  # Checking escape chances of prisoners that joined the party recently.
  (6,
   [(gt, "$g_prisoner_recruit_troop_id", 0),
    (gt, "$g_prisoner_recruit_size", 0),
    (gt, "$g_prisoner_recruit_last_time", 0),
    (is_currently_night),
    (try_begin),
      (store_skill_level, ":leadership", "skl_leadership", "trp_player"),
      (val_mul, ":leadership", 5),
      (store_sub, ":chance", 66, ":leadership"),
      (gt, ":chance", 0),
      (assign, ":num_escaped", 0),
      (try_for_range, ":unused", 0, "$g_prisoner_recruit_size"),
        (store_random_in_range, ":random_no", 0, 100),
        (lt, ":random_no", ":chance"),
        (val_add, ":num_escaped", 1),
      (try_end),
      (party_remove_members, "p_main_party", "$g_prisoner_recruit_troop_id", ":num_escaped"),
      (assign, ":num_escaped", reg0),
      (gt, ":num_escaped", 0),
      (try_begin),
        (gt, ":num_escaped", 1),
        (assign, reg2, 1),
      (else_try),
        (assign, reg2, 0),
      (try_end),
      (assign, reg1, ":num_escaped"),
      (str_store_troop_name_by_count, s1, "$g_prisoner_recruit_troop_id", ":num_escaped"),
      (display_log_message, "@{reg1} {s1} {reg2?have:has} escaped from your party during the night."),
    (try_end),
    (assign, "$g_prisoner_recruit_troop_id", 0),
    (assign, "$g_prisoner_recruit_size", 0),
    ]),
  
  # Adding mercenary troops to the towns
  (72,
   [(call_script, "script_update_mercenary_units_of_towns"),
    (call_script, "script_update_companion_candidates_in_taverns"),
    (call_script, "script_update_ransom_brokers"),
    (call_script, "script_update_tavern_travelers"),
    (call_script, "script_update_tavern_minstels"),
    (try_for_range, ":village_no", villages_begin, villages_end),
      (call_script, "script_update_volunteer_troops_in_village", ":village_no"),
    (try_end),
    ]),

  # Checking center upgrades
  (12,
   [(try_for_range, ":center_no", centers_begin, centers_end),
      (party_get_slot, ":cur_improvement", ":center_no", slot_center_current_improvement),
      (gt, ":cur_improvement", 0),
      (party_get_slot, ":cur_improvement_end_time", ":center_no", slot_center_improvement_end_hour),
      (store_current_hours, ":cur_hours"),
      (ge, ":cur_hours", ":cur_improvement_end_time"),
      (party_get_slot, ":cur_level", ":center_no", ":cur_improvement"),
      (val_add, ":cur_level", 1),
      (party_set_slot, ":center_no", ":cur_improvement", ":cur_level"),
      (party_set_slot, ":center_no", slot_center_current_improvement, 0),
      (try_begin),
        (eq, ":cur_improvement", slot_center_housing_level),
        (str_store_string, s3, "@housing"),
      (else_try),
        (eq, ":cur_improvement", slot_center_irrigation_level),
        (str_store_string, s3, "@irrigation"),
      (else_try),
        (eq, ":cur_improvement", slot_center_mill_level),
        (str_store_string, s3, "@mill"),
      (try_end),
      (str_store_party_name, s4, ":center_no"),
      (display_log_message, "@Improvement of {s3} in {s4} has been completed."),
    (try_end),
    ]),

  # Asking to give center to player
  (8,
   [
    (assign, ":done", 0),
    (try_for_range, ":center_no", centers_begin, centers_end),
      (eq, ":done", 0),
      (party_slot_eq, ":center_no", slot_town_lord, stl_reserved_for_player),
      (assign, "$g_center_to_give_to_player", ":center_no"),
      (try_begin),
        (eq, "$g_center_to_give_to_player", "$g_castle_requested_by_player"),
        (assign, "$g_castle_requested_by_player", 0),
        (jump_to_menu, "mnu_requested_castle_granted_to_player"),
      (else_try),
        (jump_to_menu, "mnu_give_center_to_player"),
      (try_end),
      (assign, ":done", 1),
    (else_try),
      (eq, ":center_no", "$g_castle_requested_by_player"),
      (party_slot_ge, ":center_no", slot_town_lord, kingdom_heroes_begin),
      (assign, "$g_castle_requested_by_player", 0),
      (store_faction_of_party, ":faction", ":center_no"),
      (eq, ":faction", "$players_kingdom"),
      (assign, "$g_center_to_give_to_player", ":center_no"),
      (jump_to_menu, "mnu_requested_castle_granted_to_another"),
      (assign, ":done", 1),
    (try_end),
    ]),
  
  # Taking denars from player while resting in non-kingdom faction centers
  (1,
   [(neg|map_free),
    (is_currently_night),
    (ge, "$g_last_rest_center", 0),
    (store_faction_of_party, ":center_faction", "$g_last_rest_center"),
    (neq, ":center_faction", "fac_player_faction"),
    (neq, ":center_faction", "$players_kingdom"),
    (store_current_hours, ":cur_hours"),
    (ge, ":cur_hours", "$g_last_rest_payment_until"),
    (store_add, "$g_last_rest_payment_until", ":cur_hours", 24),
    (store_troop_gold, ":gold", "trp_player"),
    (party_get_num_companions, ":num_men", "p_main_party"),
    (store_div, ":total_cost", ":num_men", 5),
    (val_add, ":total_cost", 1),
    (try_begin),
      (ge, ":gold", ":total_cost"),
      (display_message, "@You pay for accommodation."),
      (troop_remove_gold, "trp_player", ":total_cost"),
    (else_try),
      (gt, ":gold", 0),
      (troop_remove_gold, "trp_player", ":gold"),
    (try_end),
    ]),
  # Spawn some bandits.
  (24,
   [
       (call_script, "script_spawn_bandits"),
    ]),

  # Make parties larger as game progresses.
  (24,
   [
       (call_script, "script_update_party_creation_random_limits"),
    ]),

  # Reduce renown slightly by 0.5% every week
  (7 * 24,
   [
       (troop_get_slot, ":player_renown", "trp_player", slot_troop_renown),
       (store_div, ":renown_decrease", ":player_renown", 200),
       (val_sub, ":player_renown", ":renown_decrease"),
       (troop_set_slot, "trp_player", slot_troop_renown, ":player_renown"),
    ]),
  
#####!!!!!
]

