from header_common import *
from header_operations import *
from header_parties import *
from header_items import *
from header_skills import *
from header_triggers import *
from header_troops import *

from module_constants import *
from setting_sango import *

####################################################################################################################
#  Each trigger contains the following fields:
# 1) Check interval: How frequently this trigger will be checked
# 2) Delay interval: Time to wait before applying the consequences of the trigger
#    After its conditions have been evaluated as true.
# 3) Re-arm interval. How much time must pass after applying the consequences of the trigger for the trigger to become active again.
#    You can put the constant ti_once here to make sure that the trigger never becomes active again after it fires once.
# 4) Conditions block (list). This must be a valid operation block. See header_operations.py for reference.
#    Every time the trigger is checked, the conditions block will be executed.
#    If the conditions block returns true, the consequences block will be executed.
#    If the conditions block is empty, it is assumed that it always evaluates to true.
# 5) Consequences block (list). This must be a valid operation block. See header_operations.py for reference. 
####################################################################################################################

# Some constants for use below
merchant_inventory_space = 30
num_merchandise_goods = 36


triggers_defined=1
triggers = [
#Give Benus Item
  (2.0, 0, ti_once, [(store_num_parties_destroyed_by_player,":num","pt_southern_man_host"),(ge,":num",5)], [(troop_add_item,"trp_player","itm_tenghelm"),(display_message,"str_benus")]),
  (2.0, 0, ti_once, [(store_num_parties_destroyed_by_player,":num","pt_southern_man_host"),(ge,":num",6)], [(troop_add_item,"trp_player","itm_tengshoes"),(display_message,"str_benus")]),
  (2.0, 0, ti_once, [(store_num_parties_destroyed_by_player,":num","pt_southern_man_host"),(ge,":num",8)], [(troop_add_item,"trp_player","itm_tengarmor"),(display_message,"str_benus")]),
  (2.0, 0, ti_once, [(store_num_parties_destroyed_by_player,":num","pt_northern_xiong_nu_host"),(ge,":num",8)], [(troop_add_item,"trp_player","itm_dahorse"),(display_message,"str_benus")]),
  (2.0, 0, ti_once, [(store_num_parties_destroyed_by_player,":num","pt_eastern_yue_host"),(ge,":num",8)], [(troop_add_item,"trp_player","itm_xlhorse"),(display_message,"str_benus")]),

#Max_st
  (24.0, 0, 0.0, [], [(store_skill_level,":st",skl_stratagem,"trp_player"),
                      (assign,"$max_st",":st"),(val_add,"$max_st","$add_st"),]),
#Weibao
  (0.0, 0, 0.0, [(key_clicked, key_n)],[(gt,"$max_st",0),(val_sub,"$max_st",1),(assign,"$weibao_active",1),                                 (display_message,"str_weibao"),]),

#Raise_fame
  (168.0, 0, 0.0, [(map_free,0)], [(try_begin),
                                     (eq,"$fpw",1),
                                     (val_add,"$quest_prestige",100),
                                   (else_try),
                                     (eq,"$fpw",2),
                                     (val_add,"$quest_prestige",180),
                                   (try_end),]),

#SG_Armor_Effect
 (0.0, 0, 0.0,
   [
    (assign,"$n_armor",0),  
    (assign,"$h_armor",0),  
    (try_for_range,":armor",normal_armor_begin,normal_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$n_armor",1),
    (try_end),
    (try_for_range,":armor",heavy_armor_begin,heavy_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$h_armor",1),
    (try_end),
    (this_or_next|eq,"$n_armor",0),
    (eq,"$h_armor",0),
    ],
   [
    (try_begin),
       (eq,"$n_armor",0),
       (assign,"$n_armor_eq",0),
    (try_end),
    (try_begin),
       (eq,"$h_armor",0),
       (assign,"$h_armor_eq",0),
    (try_end),
     ]),


  #
  (0.0, 0, 0.0,
   [(eq,"$n_armor_eq",0),(eq,"$n_armor_eft",0),(eq,"$h_armor_eft",0),
    (eq,"$know_na",0),
    (try_for_range,":armor",normal_armor_begin,normal_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$n_armor",1),
    (try_end),
    (eq,"$n_armor",1),
    ],
   [
    (assign,"$n_armor_eq",1),
    (store_skill_level,"$rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$ha_lv",skl_horse_archery,"trp_player"),

    (troop_raise_skill,"trp_player",skl_riding,-1),
    (troop_raise_skill,"trp_player",skl_power_draw,-1),
    (troop_raise_skill,"trp_player",skl_horse_archery,-2),
    (assign,"$n_armor_eft",1),

    (store_skill_level,"$new_rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$new_pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$new_ha_lv",skl_horse_archery,"trp_player"),
    ]),

  #
  (0.0, 0, 0.0,
   [(eq,"$h_armor_eq",0),(eq,"$h_armor_eft",0),(eq,"$n_armor_eft",0),
    (eq,"$know_ha",0),
    (try_for_range,":armor",heavy_armor_begin,heavy_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$h_armor",1),
    (try_end),
    (eq,"$h_armor",1),
    ],
   [
    (assign,"$h_armor_eq",1),
    (store_skill_level,"$rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$ha_lv",skl_horse_archery,"trp_player"),

    (troop_raise_skill,"trp_player",skl_riding,-2),
    (troop_raise_skill,"trp_player",skl_power_draw,-2),
    (troop_raise_skill,"trp_player",skl_horse_archery,-4),
    (assign,"$h_armor_eft",1),

    (store_skill_level,"$new_rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$new_pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$new_ha_lv",skl_horse_archery,"trp_player"),
    ]),

##
  (0.0, 0, 0.0,
   [(eq,"$n_armor_eq",0),(eq,"$n_armor_eft",0),(eq,"$h_armor_eft",0),
    (eq,"$know_na",1),
    #(eq,"$know_ha",0),
    (try_for_range,":armor",normal_armor_begin,normal_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$n_armor",1),
    (try_end),
    (eq,"$n_armor",1),
    ],
   [
    (assign,"$n_armor_eq",1),
    (store_skill_level,"$rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$ha_lv",skl_horse_archery,"trp_player"),

    (troop_raise_skill,"trp_player",skl_horse_archery,-1),
    (assign,"$n_armor_eft",1),

    (store_skill_level,"$new_rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$new_pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$new_ha_lv",skl_horse_archery,"trp_player"),
    ]),

##
  (0.0, 0, 0.0,
   [(eq,"$h_armor_eq",0),(eq,"$h_armor_eft",0),(eq,"$n_armor_eft",0),
   # (eq,"$know_na",0),
    (eq,"$know_ha",1),
    (try_for_range,":armor",heavy_armor_begin,heavy_armor_end),
       (troop_has_item_equipped,"trp_player",":armor"),
       (assign,"$h_armor",1),
    (try_end),
    (eq,"$h_armor",1),
    ],
   [
    (assign,"$h_armor_eq",1),
    (store_skill_level,"$rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$ha_lv",skl_horse_archery,"trp_player"),

    (troop_raise_skill,"trp_player",skl_riding,-1),
    (troop_raise_skill,"trp_player",skl_power_draw,-1),
    (troop_raise_skill,"trp_player",skl_horse_archery,-3),
    (assign,"$h_armor_eft",1),

    (store_skill_level,"$new_rid_lv",skl_riding,"trp_player"),
    (store_skill_level,"$new_pd_lv",skl_power_draw,"trp_player"),
    (store_skill_level,"$new_ha_lv",skl_horse_archery,"trp_player"),
    ]),

##
  (0.0, 0, 0.0,
   [(eq,"$n_armor_eft",1),(eq,"$n_armor_eq",0),
    ],
   [
    (store_sub,":return_rid","$rid_lv","$new_rid_lv"),
    (store_sub,":return_pd","$pd_lv","$new_pd_lv"),
    (store_sub,":return_ha","$ha_lv","$new_ha_lv"),
    (troop_raise_skill,"trp_player",skl_riding,":return_rid"),
    (troop_raise_skill,"trp_player",skl_power_draw,":return_pd"),
    (troop_raise_skill,"trp_player",skl_horse_archery,":return_ha"),
    (assign,"$n_armor_eft",0),

    (store_attribute_level,":str","trp_player",ca_strength),
    (store_attribute_level,":agi","trp_player",ca_agility),
    (store_div,":max_pd",":str",3),
    (store_div,":max_r_a",":agi",3),
    (store_skill_level,":rid",skl_riding,"trp_player"),
    (store_skill_level,":pd",skl_power_draw,"trp_player"),
    (store_skill_level,":ha",skl_horse_archery,"trp_player"),
    (try_begin),
       (gt,":pd",":max_pd"),
       (val_sub,":max_pd",":pd"),
       (troop_raise_skill,"trp_player",skl_power_draw,":max_pd"),
       (val_sub,"$comp_points",":max_pd"),
    (try_end),
    (try_begin),
       (gt,":rid",":max_r_a"),
       (store_sub,":x",":max_r_a",":rid"),
       (troop_raise_skill,"trp_player",skl_riding,":x"),
       (val_sub,"$comp_points",":x"),
    (try_end),
    (try_begin),
       (gt,":ha",":max_r_a"),
       (store_sub,":x",":max_r_a",":ha"),
       (troop_raise_skill,"trp_player",skl_horse_archery,":x"),
       (val_sub,"$comp_points",":x"),
    (try_end),
    ]),

##
  (0.0, 0, 0.0,
   [(eq,"$h_armor_eft",1),(eq,"$h_armor_eq",0),
    ],
   [
    (store_sub,":return_rid","$rid_lv","$new_rid_lv"),
    (store_sub,":return_pd","$pd_lv","$new_pd_lv"),
    (store_sub,":return_ha","$ha_lv","$new_ha_lv"),
    (troop_raise_skill,"trp_player",skl_riding,":return_rid"),
    (troop_raise_skill,"trp_player",skl_power_draw,":return_pd"),
    (troop_raise_skill,"trp_player",skl_horse_archery,":return_ha"),
    (assign,"$h_armor_eft",0),

    (store_attribute_level,":str","trp_player",ca_strength),
    (store_attribute_level,":agi","trp_player",ca_agility),
    (store_div,":max_pd",":str",3),
    (store_div,":max_r_a",":agi",3),
    (store_skill_level,":rid",skl_riding,"trp_player"),
    (store_skill_level,":pd",skl_power_draw,"trp_player"),
    (store_skill_level,":ha",skl_horse_archery,"trp_player"),
    (try_begin),
       (gt,":pd",":max_pd"),
       (val_sub,":max_pd",":pd"),
       (troop_raise_skill,"trp_player",skl_power_draw,":max_pd"),
       (val_sub,"$comp_points",":max_pd"),
    (try_end),
    (try_begin),
       (gt,":rid",":max_r_a"),
       (store_sub,":x",":max_r_a",":rid"),
       (troop_raise_skill,"trp_player",skl_riding,":x"),
       (val_sub,"$comp_points",":x"),
    (try_end),
    (try_begin),
       (gt,":ha",":max_r_a"),
       (store_sub,":x",":max_r_a",":ha"),
       (troop_raise_skill,"trp_player",skl_horse_archery,":x"),
       (val_sub,"$comp_points",":x"),
    (try_end),
    ]),
#
  (0.5, 0, 0,
   [(gt,"$comp_points",0)],
   [
    (store_attribute_level,":str","trp_player",ca_strength),
    (store_attribute_level,":agi","trp_player",ca_agility),
    (store_div,":max_pd",":str",3),
    (store_div,":max_r_a",":agi",3),
    (store_skill_level,":rid",skl_riding,"trp_player"),
    (store_skill_level,":pd",skl_power_draw,"trp_player"),
    (store_skill_level,":ha",skl_horse_archery,"trp_player"),
    (try_begin),
       (gt,":max_r_a",":ha"),
       (store_sub,":x",":max_r_a",":ha"),
       (ge,"$comp_points",":x"),
       (troop_raise_skill,"trp_player",skl_horse_archery,":x"),
       (val_sub,"$comp_points",":x"),
    (try_end),
    (try_begin),
       (gt,":max_r_a",":rid"),
       (store_sub,":x",":max_r_a",":rid"),
       (ge,"$comp_points",":x"),
       (troop_raise_skill,"trp_player",skl_riding,":x"),
       (val_sub,"$comp_points",":x"),
    (try_end),
    (try_begin),
       (gt,":max_pd",":pd"),
       (val_sub,":max_pd",":pd"),
       (ge,"$comp_points",":max_pd"),
       (troop_raise_skill,"trp_player",skl_power_draw,":max_pd"),
       (val_sub,"$comp_points",":max_pd"),
    (try_end),
    ]),

  (0.0, 0, 0.0, [(eq,"$know_sa",0)], [(try_for_range,":armor",special_armor_begin,special_armor_end),
                                      (troop_has_item_equipped,"trp_player",":armor"),
                                      (troop_remove_item,"trp_player",":armor"),
                                      (troop_set_inventory_slot,"trp_player",17,":armor"),
                                    (try_end),]),
#End Armor Effect

#SG Troop Slot
 (0.1, 0, ti_once, [],[(try_for_range,":troop",af_troop_begin,af_troop_end),
                       (store_skill_level,":r",skl_riding,":troop"),
                       (store_skill_level,":d",skl_power_draw,":troop"),
                       (store_skill_level,":h",skl_horse_archery,":troop"),
                       (store_skill_level,":s",skl_power_strike,":troop"),
                       (store_skill_level,":a",skl_athletics,":troop"),
                       (store_proficiency_level,":one",":troop",0),
                       (store_proficiency_level,":two",":troop",1),
                       (store_proficiency_level,":bow",":troop",3),
                       (store_proficiency_level,":cross",":troop",4),
                       (troop_set_slot,":troop", slot_r,":r"),
                       (troop_set_slot,":troop", slot_pd,":d"),
                       (troop_set_slot,":troop", slot_ha,":h"),
                       (troop_set_slot,":troop", slot_ps,":s"),
                       (troop_set_slot,":troop", slot_a,":a"),
                       (troop_set_slot,":troop", slot_one,":one"),
                       (troop_set_slot,":troop", slot_two,":two"),
                       (troop_set_slot,":troop", slot_bow,":bow"),
                       (troop_set_slot,":troop", slot_cross,":cross"),
                    (try_end),]),
 
(0, 0, 0, [(eq,"$troop_skill_effect",1)],
           [
               (assign,"$troop_skill_effect",0),
               (try_for_range,":troop",af_troop_begin,af_troop_end),
                       (store_skill_level,":r",skl_riding,":troop"),
                       (store_skill_level,":d",skl_power_draw,":troop"),
                       (store_skill_level,":h",skl_horse_archery,":troop"),
                       (store_skill_level,":s",skl_power_strike,":troop"),
                       (store_skill_level,":a",skl_athletics,":troop"),
                       (store_proficiency_level,":one",":troop",0),
                       (store_proficiency_level,":two",":troop",1),
                       (store_proficiency_level,":bow",":troop",3),
                       (store_proficiency_level,":cross",":troop",4),
                       (troop_get_slot,":sr",":troop", slot_r),
                       (troop_get_slot,":sd",":troop", slot_pd),
                       (troop_get_slot,":sh",":troop", slot_ha),
                       (troop_get_slot,":ss",":troop", slot_ps),
                       (troop_get_slot,":sa",":troop", slot_a),
                       (troop_get_slot,":sone",":troop", slot_one),
                       (troop_get_slot,":stwo",":troop", slot_two),
                       (troop_get_slot,":sbow",":troop", slot_bow),
                       (troop_get_slot,":scross",":troop", slot_cross),
                       (try_begin),
                        (lt,":sr",":r"),
                        (troop_raise_skill,":troop",skl_riding,-1),
                       (else_try),
                        (lt,":sd",":d"),
                        (troop_raise_skill,":troop",skl_power_draw,-1),
                       (else_try),
                        (lt,":sh",":h"),
                        (troop_raise_skill,":troop",skl_horse_archery,-1),
                       (else_try),
                        (lt,":ss",":s"),
                        (troop_raise_skill,":troop",skl_power_strike,-1),
                       (else_try),
                        (lt,":sa",":a"),
                        (troop_raise_skill,":troop",skl_athletics,-1),
                       (else_try),
                        (lt,":sone",":one"),
                        (troop_raise_proficiency, ":troop",0,-50),
                       (else_try),
                        (lt,":stwo",":two"),
                        (troop_raise_proficiency, ":troop",1,-50),
                       (else_try),
                        (lt,":sbow",":bow"),
                        (troop_raise_proficiency, ":troop",3,-80),
                       (else_try),
                        (lt,":scross",":cross"),
                        (troop_raise_proficiency, ":troop",4,-120),
                       (try_end),
                       (troop_set_slot,":troop",slot_rs,0),
               (try_end),
            ]),

#SG Level Up
  (0.1, 0, 0.0, [(store_character_level,"$ply_lv","trp_player"),(ge,"$ply_lv","$can_feat"),], [(val_add,"$can_feat",3),(jump_to_menu, "mnu_choose_feat"),]),

# Tutorial:
  (0.1, 0, ti_once, [(map_free,0)],
   [(tutorial_box,"str_tutorial_map1"),
    (play_track,"track_music_in_world"),
    (assign,"$comp_points",0),
    ]),

# Refresh Merchants
  (0.0, 0, 24.0, [], [
                      (reset_item_probabilities,100),
                      (set_merchandise_modifier_quality,150),


                      (reset_item_probabilities,100),(set_item_probability_in_merchandise,"itm_tools",700),
                      (troop_add_merchandise,"trp_zendar_merchant",itp_type_goods,num_merchandise_goods),
                      (reset_item_probabilities,100),(set_item_probability_in_merchandise,"itm_salt",700),
#                      (troop_add_merchandise,"trp_salt_mine_merchant",itp_type_goods,num_merchandise_goods),

                      # Add trade goods to merchant inventories
#                      (store_sub, ":item_to_production_slot", slot_town_trade_good_productions_begin, trade_goods_begin),
                      (store_sub, ":item_to_price_slot", slot_town_trade_good_prices_begin, trade_goods_begin),

                      (try_for_range,":cur_center",towns_begin,towns_end),
                        (party_get_slot,":cur_merchant",":cur_center",slot_town_merchant),
                        (reset_item_probabilities,100),
                        (try_for_range, ":cur_goods", trade_goods_begin, trade_goods_end),
#                          (store_add, ":cur_production_slot", ":cur_goods", ":item_to_production_slot"),
                          (store_add, ":cur_price_slot", ":cur_goods", ":item_to_price_slot"),
#                          (party_get_slot, ":cur_production", ":cur_center", ":cur_production_slot"),
                          (party_get_slot, ":cur_price", ":cur_center", ":cur_price_slot"),
                      
##                          (assign, ":cur_probability", 100),
##                          (store_add, ":cur_production", 100, ":cur_production"),
##                          (val_mul, ":cur_probability", ":cur_production"),
##                          (val_div, ":cur_probability", 100),
##                          (try_begin),
##                            (gt, ":cur_probability", 100),
##                            (store_sub, ":temp_dif", ":cur_probability", 100),
##                            (val_mul, ":temp_dif", 4),
##                            (val_add, ":cur_probability", ":temp_dif"),
##                          (try_end),
##                          (store_sub, ":temp_dif", average_price_factor, ":cur_price"),
##                          (val_div, ":temp_dif", 2),
##                          (val_add, ":cur_price", ":temp_dif"),
                          (assign, ":cur_probability", 100),
                          (val_mul, ":cur_probability", average_price_factor),
                          (val_div, ":cur_probability", ":cur_price"),
                          (val_mul, ":cur_probability", average_price_factor),
                          (val_div, ":cur_probability", ":cur_price"),
                          (val_mul, ":cur_probability", average_price_factor),
                          (val_div, ":cur_probability", ":cur_price"),
                          (val_mul, ":cur_probability", average_price_factor),
                          (val_div, ":cur_probability", ":cur_price"),
                          (set_item_probability_in_merchandise,":cur_goods",":cur_probability"),
                        (try_end),
                        (troop_add_merchandise,":cur_merchant",itp_type_goods,num_merchandise_goods),

                        (troop_ensure_inventory_space,":cur_merchant",merchant_inventory_space),
                        (store_troop_gold, ":cur_gold",":cur_merchant"),
                        (lt,":cur_gold",1000),
                        (store_random_in_range,":new_gold",100,200),
                        (troop_add_gold,":cur_merchant",":new_gold"),
                      (try_end),

                      #Adjusting salt mine merchant
                      (reset_item_probabilities, 0),
                      (set_item_probability_in_merchandise, "itm_salt", 100),
#                      (troop_add_merchandise,"trp_salt_mine_merchant",itp_type_goods,4),
#                      (troop_ensure_inventory_space,"trp_salt_mine_merchant",merchant_inventory_space),
#                      (store_troop_gold, ":cur_gold","trp_salt_mine_merchant"),
                      (lt,":cur_gold",400),
                      (store_random,":new_gold",50),
                      (val_add,":new_gold",100),
#                      (troop_add_gold,"trp_salt_mine_merchant",":new_gold"),
                      (try_for_range, ":cur_good", trade_goods_begin, trade_goods_end),
                        (store_sub, ":cur_good_price_slot", ":cur_good", trade_goods_begin),
                        (val_add, ":cur_good_price_slot", slot_town_trade_good_prices_begin),
                        (try_begin),
                          (eq, ":cur_good", "itm_salt"),
                          (party_set_slot, "p_salt_mine", ":cur_good_price_slot", 100),
                        (else_try),
                          (party_set_slot, "p_salt_mine", ":cur_good_price_slot", 50),
                        (try_end),
                      (try_end),
                     ]),

# Refresh Armor sellers
  (0.0, 0, 24.0, [], [
                      (reset_item_probabilities,100),
                      (set_merchandise_modifier_quality,150),
                      (try_for_range,reg(2),armor_merchants_begin,armor_merchants_end),
                        (troop_add_merchandise,reg(2),itp_type_body_armor,16),
                        (troop_add_merchandise,reg(2),itp_type_head_armor,16),
                        (troop_add_merchandise,reg(2),itp_type_foot_armor,8),
                        (troop_add_merchandise,reg(2),itp_type_hand_armor,4),
                        (troop_ensure_inventory_space,reg(2),merchant_inventory_space),
                        (store_troop_gold, reg(6),reg(2)),
                        (lt,reg(6),400),
                        (store_random_in_range,":new_gold",100,200),
                        (troop_add_gold,reg(2),":new_gold"),
                      (end_try,0),
                     ]),


# Refresh Weapon sellers
  (0.0, 0, 24.0, [], [
                      (reset_item_probabilities,100),
                      (set_merchandise_modifier_quality,150),
                      (try_for_range,reg(2),weapon_merchants_begin,weapon_merchants_end),
                        (troop_add_merchandise,reg(2),itp_type_one_handed_wpn,5),
                        (troop_add_merchandise,reg(2),itp_type_two_handed_wpn,5),
                        (troop_add_merchandise,reg(2),itp_type_polearm,5),
                        (troop_add_merchandise,reg(2),itp_type_shield,6),
                        (troop_add_merchandise,reg(2),itp_type_bow,4),
                        (troop_add_merchandise,reg(2),itp_type_crossbow,3),
                        (troop_add_merchandise,reg(2),itp_type_thrown,5),
                        (troop_add_merchandise,reg(2),itp_type_arrows,2),
                        (troop_add_merchandise,reg(2),itp_type_bolts,2),
                        (troop_ensure_inventory_space,reg(2),merchant_inventory_space),
                        (store_troop_gold, reg(6),reg(2)),
                        (lt,reg(6),400),
                        (store_random_in_range,":new_gold",100,200),
                      (troop_add_gold,reg(2),":new_gold"),
                      (end_try,0),
                     ]),

# Refresh Horse sellers
  (0.0, 0, 24.0, [], [
                      (reset_item_probabilities,100),
                      (set_merchandise_modifier_quality,150),
                      (try_for_range,":cur_merchant",horse_merchants_begin,horse_merchants_end),
                        (troop_add_merchandise,":cur_merchant",itp_type_horse,5),
                        (troop_ensure_inventory_space,":cur_merchant",65),
                        (store_troop_gold, ":cur_gold",":cur_merchant"),
                        (lt,":cur_gold",600),
                        (store_random_in_range,":new_gold",100,200),
                        (troop_add_gold,":cur_merchant",":new_gold"),
                      (try_end),
                     ]),
  
# Refresh Tavernkeepers
  (24.0, 0, 0.0, [], [
    # Refresh Zendar
                      (try_begin,0),
                      (assign,reg(2),"p_zendar_mercs"),
                      (store_party_size,reg(6),reg(2)),
                      (lt,reg(6),20),
                      (store_random,reg(7),4),
                      (val_add,reg(7),1),
                      (party_add_members,reg(2),"trp_farmer",reg(7)),
                      (store_random,reg(8),2),
                      (party_add_members,reg(2),"trp_volunteer",reg(8)),
                      (end_try,0),
    # Refresh Swadians
                      (try_for_range,":town_no",towns_begin,towns_end),
                        (party_get_slot, ":merc_party", ":town_no", slot_town_mercs),
                        (gt, ":merc_party", 0),
                        (store_party_size,reg(6), ":merc_party"),
                        (lt,reg(6),20),
                        (store_random,reg(7),4),
                        (val_add,reg(7),1),
                        (store_faction_of_party, ":faction_no", ":town_no"),
                        (faction_get_slot, ":tier_1_troop", ":faction_no", slot_faction_tier_1_troop),
                        (faction_get_slot, ":tier_2_troop", ":faction_no", slot_faction_tier_2_troop),
                        (gt, ":tier_2_troop", 0),
                        (party_add_members, ":merc_party", ":tier_1_troop", reg(7)),
                        (store_random,reg(8),2),
                        (party_add_members, ":merc_party", ":tier_2_troop", reg(8)),
                      (end_try,0),
                     ]),


#############

#Captivity:

#  (1.0, 0, 0.0, [],
#   [
#       (ge,"$captivity_mode",1),
#       (store_current_hours,reg(1)),
#       (val_sub,reg(1),"$captivity_end_time"),
#       (ge,reg(1),0),
#       (display_message,"str_nobleman_reached_destination"),
#       (jump_to_menu,"$captivity_end_menu"),
#    ]),


  (1.0, 0, ti_once, [], [(assign,"$peak_river_pirates",6)]),
  (3.7, 0, 0.0, [#[store0_distance_to_town_from_party,zendar],[lt,reg(0),40],
                 (store_num_parties_of_template, reg(2), "pt_river_pirates"),
                 (lt,reg(2),"$peak_river_pirates")],
                    [(set_spawn_radius,1),(spawn_around_party,"p_river_pirate_spawn_point","pt_river_pirates")]),

#  (5.7, 0, 0.0, [(store_num_parties_created,reg(3),"pt_manhunters"),
#                 (lt,reg(3),num_max_zendar_manhunters),
#                 (store_num_parties_of_template, reg(2), "pt_manhunters"), (lt,reg(2),3)],
#                       [(set_spawn_radius,1),(spawn_around_party,"p_zendar","pt_manhunters")]),
#  (5.2, 0, 0.0, [(store_num_parties_created,reg(3),"pt_peasant"),(lt,reg(3),num_max_zendar_peasants),
#                 (store_num_parties_of_template, reg(2), "pt_peasant"), (lt,reg(2),3)],
#                          [(set_spawn_radius,1),(spawn_around_party,"p_zendar","pt_peasant")]),
  

  (0.0, 0, 0.0, [(neq,"$quest_accepted_zendar_river_pirates",0),(eq,"$quest_complete_zendar_river_pirates",0)],
   [
    (store_num_parties_destroyed_by_player, ":num_river_pirates_destroyed", "pt_river_pirates"),
    (assign, ":percentage", 100),
    (val_mul, ":percentage", ":num_river_pirates_destroyed"),
    (val_div, ":percentage", num_max_river_pirates),
    (set_quest_progression, "qst_hunt_down_river_pirates", ":percentage"),
   ]),
  
  (0.1, 0, ti_once, [(store_num_parties_destroyed_by_player, ":num_river_pirates_destroyed", "pt_river_pirates"),
                     (ge,":num_river_pirates_destroyed",num_max_river_pirates)],
                          [(assign,"$quest_complete_zendar_river_pirates",1),
                           (set_quest_progression, "qst_hunt_down_river_pirates", 100),
                           (assign,"$peak_river_pirates",2)]),
 

#Tax Collectors
# Prisoner Trains
#  (4.1, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_swadians"),
#                         (assign, "$pin_party_template", "pt_swadian_prisoner_train"),
#                         (assign, "$pin_limit", peak_prisoner_trains),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                         (party_set_ai_behavior,"$pout_party",ai_bhvr_travel_to_party),
#                         (party_set_ai_object,"$pout_party","$pout_town"),
#                    ]),
#
#  (4.1, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_vaegirs"),
#                         (assign, "$pin_party_template", "pt_vaegir_prisoner_train"),
#                         (assign, "$pin_limit", peak_prisoner_trains),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                         (party_set_ai_behavior,"$pout_party",ai_bhvr_travel_to_party),
#                         (party_set_ai_object,"$pout_party","$pout_town"),
#                    ]),

  (2.0, 0, 0, [(store_random_party_of_template, reg(2), "pt_prisoner_train_party"),
               (party_is_in_any_town,reg(2)),
               ],
              [(store_faction_of_party, ":faction_no", reg(2)),
               (call_script,"script_cf_select_random_center_with_faction", ":faction_no"),
               (party_set_ai_behavior,reg(2),ai_bhvr_travel_to_party),
               (party_set_ai_object,reg(2),reg0),
               (party_set_flags, reg(2), pf_default_behavior, 0),
            ]),

##Caravans
#  (4.2, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_swadians"),
#                         (assign, "$pin_party_template", "pt_swadian_caravan"),
#                         (assign, "$pin_limit", peak_kingdom_caravans),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                         (party_set_ai_behavior,"$pout_party",ai_bhvr_travel_to_party),
#                         (party_set_ai_object,"$pout_party","$pout_town"),
#                    ]),

#  (4.2, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_vaegirs"),
#                         (assign, "$pin_party_template", "pt_vaegir_caravan"),
#                         (assign, "$pin_limit", peak_kingdom_caravans),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                         (party_set_ai_behavior,"$pout_party",ai_bhvr_travel_to_party),
#                         (party_set_ai_object,"$pout_party","$pout_town"),
#                    ]),

##  (2.0, 0, 0, [(store_random_party_of_template, reg(2), "pt_kingdom_caravan_party"),
##               (party_is_in_any_town,reg(2)),
##               ],
##              [(store_faction_of_party, ":faction_no", reg(2)),
##               (call_script,"script_cf_select_random_town_with_faction", ":faction_no"),
##               (party_set_ai_behavior,reg(2),ai_bhvr_travel_to_party),
##               (party_set_ai_object,reg(2),reg0),
##               (party_set_flags, reg(2), pf_default_behavior, 0),
##            ]),
  
  (4.0, 0, 0.0, [(eq, "$caravan_escort_state", 1), #cancel caravan_escort_state if caravan leaves the destination
                 (get_party_ai_object,reg(1),"$caravan_escort_party_id"),
                 (neq,reg(1),"$caravan_escort_destination_town"),
                ],
                     [(assign,"$caravan_escort_state",0),
#                      (add_xp_as_reward,100),
                      ]),

#Messengers
#  (4.2, 0, 0.0, [],
#   [(assign, "$pin_faction", "fac_swadians"),
#    (assign, "$pin_party_template", "pt_swadian_messenger"),
#    (assign, "$pin_limit", peak_kingdom_messengers),
#    (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#    (party_set_ai_behavior,"$pout_party",ai_bhvr_travel_to_party),
#    (party_set_ai_object,"$pout_party","$pout_town"),
#    ]),

#  (4.2, 0, 0.0, [],
#   [(assign, "$pin_faction", "fac_vaegirs"),
#    (assign, "$pin_party_template", "pt_vaegir_messenger"),
#    (assign, "$pin_limit", peak_kingdom_caravans),
#    (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#    (party_set_ai_behavior,"$pout_party",ai_bhvr_travel_to_party),
#    (party_set_ai_object,"$pout_party","$pout_town"),
#    ]),

  (1.5, 0, 0, [(store_random_party_of_template, reg(2), "pt_messenger_party"),
               (party_is_in_any_town,reg(2)),
               ],
   [(store_faction_of_party, ":faction_no", reg(2)),
    (call_script,"script_cf_select_random_center_with_faction", ":faction_no"),
    (party_set_ai_behavior,reg(2),ai_bhvr_travel_to_party),
    (party_set_ai_object,reg(2),reg0),
    (party_set_flags, reg(2), pf_default_behavior, 0),
    ]),
  
  

  (24.0, 0.0, 0.0,
   [
       (ge,"$mountain_bandits_paid",1)
    ],
   [
       (val_sub,"$mountain_bandits_paid",1),
       (eq,"$mountain_bandits_paid",0),
       (set_relation,"fac_mountain_bandits", "fac_player_faction", "$mountain_bandits_relation_original"),
    ]
   ),

  (24.0, 0.0, 0.0,
   [
       (ge,"$forest_bandits_paid",1)
    ],
   [
       (val_sub,"$forest_bandits_paid",1),
       (eq,"$forest_bandits_paid",0),
       (set_relation,"fac_forest_bandits", "fac_player_faction", "$forest_bandits_relation_original"),
    ]
   ),
#Deserters

#  (10.2, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_swadians"),
#                         (assign, "$pin_party_template", "pt_swadian_deserters"),
#                         (assign, "$pin_limit", 4),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                    ]),
  
#  (10.2, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_vaegirs"),
#                         (assign, "$pin_party_template", "pt_vaegir_deserters"),
#                         (assign, "$pin_limit", 4),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                    ]),
  
#  (24.0, 0.0, 0.0,
#   [
#       (ge,"$deserters_paid",1)
#    ],
#   [
#       (val_sub,"$deserters_paid",1),
#       (eq,"$deserters_paid",0),
#       (set_relation,"fac_deserters", "fac_player_faction", "$deserter_relation_original"),
#    ]
#   ),


#Kingdom Parties
  (1.0, 0, 0.0, [],
   [(try_for_range, ":cur_kingdom", kingdoms_begin, kingdoms_end),
##      (try_begin),
##        (store_random_in_range, ":random_no", 0, 100),
##        (lt, ":random_no", 10),
##        (call_script, "script_create_kingdom_party_if_below_limit", ":cur_kingdom", spt_forager),
##      (try_end),
##      (try_begin),
##        (store_random_in_range, ":random_no", 0, 100),
##        (lt, ":random_no", 10),
##        (call_script, "script_create_kingdom_party_if_below_limit", ":cur_kingdom", spt_scout),
##      (try_end),
##      (try_begin),
##        (store_random_in_range, ":random_no", 0, 100),
##        (lt, ":random_no", 10),
##        (call_script, "script_create_kingdom_party_if_below_limit", ":cur_kingdom", spt_patrol),
##      (try_end),
##      (try_begin),
##        (store_random_in_range, ":random_no", 0, 100),
##        (lt, ":random_no", 10),
##        (call_script, "script_create_kingdom_party_if_below_limit", ":cur_kingdom", spt_messenger),
##      (try_end),
##      (try_begin),
##        (store_random_in_range, ":random_no", 0, 100),
##        (lt, ":random_no", 10),
##        (call_script, "script_create_kingdom_party_if_below_limit", ":cur_kingdom", spt_kingdom_caravan),
##      (try_end),
##      (try_begin),
##        (store_random_in_range, ":random_no", 0, 100),
##        (lt, ":random_no", 10),
##        (call_script, "script_create_kingdom_party_if_below_limit", ":cur_kingdom", spt_prisoner_train),
##      (try_end),
##      (try_begin),
##        (store_random_in_range, ":random_no", 0, 100),
##        (lt, ":random_no", 10),
##        (call_script, "script_create_kingdom_party_if_below_limit", ":cur_kingdom", spt_deserter),
##      (try_end),
    (try_end),
    ]),


#Swadians
#  (0.0, 0.0, ti_once, [], [(assign,"$peak_swadian_foragers",4)]),
#  (0.0, 0.0, ti_once, [], [(assign,"$peak_swadian_scouts",4)]),
#  (0.0, 0.0, ti_once, [], [(assign,"$peak_swadian_harassers",3)]),
#  (0.0, 0.0, ti_once, [], [(assign,"$peak_swadian_war_parties",2)]),


#  (10.2, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_swadians"),
#                         (assign, "$pin_party_template", "pt_swadian_foragers"),
#                         (assign, "$pin_limit", "$peak_swadian_foragers"),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                    ]),

#  (10.2, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_swadians"),
#                         (assign, "$pin_party_template", "pt_swadian_scouts"),
#                         (assign, "$pin_limit", "$peak_swadian_scouts"),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                    ]),

#  (10.2, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_swadians"),
#                         (assign, "$pin_party_template", "pt_swadian_patrol"),
#                         (assign, "$pin_limit", "$peak_swadian_harassers"),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                    ]),

#  (10.2, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_swadians"),
#                         (assign, "$pin_party_template", "pt_swadian_war_party"),
#                         (assign, "$pin_limit", "$peak_swadian_war_parties"),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                    ]),
#Vaegirs
#  (0.0, 0.0, ti_once, [], [(assign,"$peak_vaegir_foragers",4)]),
#  (0.0, 0.0, ti_once, [], [(assign,"$peak_vaegir_scouts",4)]),
#  (0.0, 0.0, ti_once, [], [(assign,"$peak_vaegir_harassers",3)]),
#  (0.0, 0.0, ti_once, [], [(assign,"$peak_vaegir_war_parties",2)]),
  

#  (10.2, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_vaegirs"),
#                         (assign, "$pin_party_template", "pt_vaegir_foragers"),
#                         (assign, "$pin_limit", "$peak_vaegir_foragers"),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                    ]),

#  (10.2, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_vaegirs"),
#                         (assign, "$pin_party_template", "pt_vaegir_scouts"),
#                         (assign, "$pin_limit", "$peak_vaegir_scouts"),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                    ]),

#  (10.2, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_vaegirs"),
#                         (assign, "$pin_party_template", "pt_vaegir_patrol"),
#                         (assign, "$pin_limit", "$peak_vaegir_harassers"),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                    ]),

#  (10.2, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_vaegirs"),
#                         (assign, "$pin_party_template", "pt_vaegir_war_party"),
#                         (assign, "$pin_limit", "$peak_vaegir_war_parties"),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                    ]),

#Villains etc.
#  (14.2, 0, 0.0, [],
#                     [
#                         (assign, "$pin_faction", "fac_sea_raiders"),
#                         (assign, "$pin_party_template", "pt_sea_raiders"),
#                         (assign, "$pin_limit", 5),
#                         (call_script,"script_cf_spawn_party_at_faction_town_if_below_limit"),
#                    ]),


#
##  (10.1, 0, 0.0, [],
##                     [
##                         (assign, "$pin_party_template", "pt_refugees"),
##                         (assign, "$pin_limit", 5),
##                         (call_script,"script_cf_spawn_party_at_random_town_if_below_limit"),
##                    ]),
##
##  (10.1, 0, 0.0, [],
##                     [
##                         (assign, "$pin_party_template", "pt_farmers"),
##                         (assign, "$pin_limit", 6),
##                         (call_script,"script_cf_spawn_party_at_random_town_if_below_limit"),
##                    ]),

#  [1.0, 96.0, ti_once, [], [[assign,"$peak_dark_hunters",3]]],
  
##  (10.1, 0, 0.0, [],
##                     [
##                         (assign, "$pin_party_template", "pt_dark_hunters"),
##                         (assign, "$pin_limit", "$peak_dark_hunters"),
##                         (call_script,"script_cf_spawn_party_at_random_town_if_below_limit"),
##                    ]),

#Companion quests

##  (0, 0, ti_once,
##   [
##       (entering_town,"p_town_1"),
##       (main_party_has_troop,"trp_borcha"),
##       (eq,"$borcha_freed",0)
##    ],
##   
##   [
##       (assign,"$borcha_arrive_sargoth_as_prisoner",1),
##       (start_map_conversation,"trp_borcha")
##    ]
##   ),
##
##  (1, 0, ti_once,
##   [
##      (map_free,0),
##      (eq,"$borcha_asked_for_freedom",0),
##      (main_party_has_troop,"trp_borcha")
##    ],
##   [
##       (start_map_conversation,"trp_borcha")
##    ]
##   ),
##  
##  (2, 0, ti_once,
##   [
##      (map_free, 0),
##      (neq,"$borcha_asked_for_freedom",0),
##      (eq,"$borcha_freed",0),
##      (main_party_has_troop,"trp_borcha")
##    ],
##   [
##       (start_map_conversation,"trp_borcha"),
##    ]
##   ),

##### TODO: QUESTS COMMENT OUT BEGIN

###########################################################################
### Random Governer Quest triggers
###########################################################################
##
### Incriminate Loyal Advisor quest
##  (0.2, 0.0, 0.0,
##   [
##       (check_quest_active, "qst_incriminate_loyal_commander"),
##       (quest_slot_eq, "qst_incriminate_loyal_commander", slot_quest_current_state, 2),
##       (quest_get_slot, ":quest_target_center", "qst_incriminate_loyal_commander", slot_quest_target_center),
##       (quest_get_slot, ":quest_target_party", "qst_incriminate_loyal_commander", slot_quest_target_party),
##       (try_begin),
##         (neg|party_is_active, ":quest_target_party"),
##         (quest_set_slot, "qst_incriminate_loyal_commander", slot_quest_current_state, 3),
##         (fail_quest, "qst_incriminate_loyal_commander"),
##       (else_try),
##         (party_is_in_town, ":quest_target_party", ":quest_target_center"),
##         (remove_party, ":quest_target_party"),
##         (quest_set_slot, "qst_incriminate_loyal_commander", slot_quest_current_state, 3),
##         (quest_get_slot, ":quest_object_troop", "qst_incriminate_loyal_commander", slot_quest_object_troop),
##         (call_script, "script_change_troop_faction", ":quest_object_troop", "fac_robber_knights"),
##         (succeed_quest, "qst_incriminate_loyal_commander"),
##       (try_end),
##    ],
##   []
##   ),
### Runaway Peasants quest
##  (0.2, 0.0, 0.0,
##   [
##       (check_quest_active, "qst_bring_back_runaway_serfs"),
##       (neg|check_quest_succeeded, "qst_bring_back_runaway_serfs"),
##       (neg|check_quest_failed, "qst_bring_back_runaway_serfs"),
##       (quest_get_slot, ":quest_object_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
##       (quest_get_slot, ":quest_target_center", "qst_bring_back_runaway_serfs", slot_quest_target_center),
##       (try_begin),
##         (party_is_active, "$qst_bring_back_runaway_serfs_party_1"),
##         (try_begin),
##           (party_is_in_town, "$qst_bring_back_runaway_serfs_party_1", ":quest_target_center"),
##           (remove_party, "$qst_bring_back_runaway_serfs_party_1"),
##           (val_add, "$qst_bring_back_runaway_serfs_num_parties_fleed", 1),
##         (else_try),
##           (party_is_in_town, "$qst_bring_back_runaway_serfs_party_1", ":quest_object_center"),
##           (remove_party, "$qst_bring_back_runaway_serfs_party_1"),
##           (val_add, "$qst_bring_back_runaway_serfs_num_parties_returned", 1),
##         (else_try),
##           (store_distance_to_party_from_party, ":cur_distance", "p_main_party", "$qst_bring_back_runaway_serfs_party_1"),
##           (gt, ":cur_distance", 3),
##           (party_set_ai_object, "$qst_bring_back_runaway_serfs_party_1", ":quest_target_center"),
##         (try_end),
##       (try_end),
##       (try_begin),
##         (party_is_active, "$qst_bring_back_runaway_serfs_party_2"),
##         (try_begin),
##           (party_is_in_town, "$qst_bring_back_runaway_serfs_party_2", ":quest_target_center"),
##           (remove_party, "$qst_bring_back_runaway_serfs_party_2"),
##           (val_add, "$qst_bring_back_runaway_serfs_num_parties_fleed", 1),
##         (else_try),
##           (party_is_in_town, "$qst_bring_back_runaway_serfs_party_2", ":quest_object_center"),
##           (remove_party, "$qst_bring_back_runaway_serfs_party_2"),
##           (val_add, "$qst_bring_back_runaway_serfs_num_parties_returned", 1),
##         (else_try),
##           (store_distance_to_party_from_party, ":cur_distance", "p_main_party", "$qst_bring_back_runaway_serfs_party_2"),
##           (gt, ":cur_distance", 3),
##           (party_set_ai_object, "$qst_bring_back_runaway_serfs_party_2", ":quest_target_center"),
##         (try_end),
##       (try_end),
##       (try_begin),
##         (party_is_active, "$qst_bring_back_runaway_serfs_party_3"),
##         (try_begin),
##           (party_is_in_town, "$qst_bring_back_runaway_serfs_party_3", ":quest_target_center"),
##           (remove_party, "$qst_bring_back_runaway_serfs_party_3"),
##           (val_add, "$qst_bring_back_runaway_serfs_num_parties_fleed", 1),
##         (else_try),
##           (party_is_in_town, "$qst_bring_back_runaway_serfs_party_3", ":quest_object_center"),
##           (remove_party, "$qst_bring_back_runaway_serfs_party_3"),
##           (val_add, "$qst_bring_back_runaway_serfs_num_parties_returned", 1),
##         (else_try),
##           (store_distance_to_party_from_party, ":cur_distance", "p_main_party", "$qst_bring_back_runaway_serfs_party_2"),
##           (gt, ":cur_distance", 3),
##           (party_set_ai_object, "$qst_bring_back_runaway_serfs_party_2", ":quest_target_center"),
##         (try_end),
##       (try_end),
##       (assign, ":sum_removed", "$qst_bring_back_runaway_serfs_num_parties_returned"),
##       (val_add, ":sum_removed", "$qst_bring_back_runaway_serfs_num_parties_fleed"),
##       (ge, ":sum_removed", 3),
##       (try_begin),
##         (ge, "$qst_bring_back_runaway_serfs_num_parties_returned", 3),
##         (succeed_quest, "qst_bring_back_runaway_serfs"),
##       (else_try),
##         (fail_quest, "qst_bring_back_runaway_serfs"),
##       (try_end),
##    ],
##   []
##   ),
### Defend Nobles Against Peasants quest
##  (0.2, 0.0, 0.0,
##   [
##       (check_quest_active, "qst_defend_nobles_against_peasants"),
##       (neg|check_quest_succeeded, "qst_defend_nobles_against_peasants"),
##       (neg|check_quest_failed, "qst_defend_nobles_against_peasants"),
##       (quest_get_slot, ":quest_target_center", "qst_defend_nobles_against_peasants", slot_quest_target_center),
##       (assign, ":num_active_parties", 0),
##       (try_begin),
##         (gt, "$qst_defend_nobles_against_peasants_noble_party_1", 0),
##         (party_is_active, "$qst_defend_nobles_against_peasants_noble_party_1"),
##         (val_add, ":num_active_parties", 1),
##         (party_is_in_town, "$qst_defend_nobles_against_peasants_noble_party_1", ":quest_target_center"),
##         (remove_party, "$qst_defend_nobles_against_peasants_noble_party_1"),
##         (party_get_num_companions, ":num_companions", "$qst_defend_nobles_against_peasants_noble_party_1"),
##         (val_add, "$qst_defend_nobles_against_peasants_num_nobles_saved", ":num_companions"),
##       (try_end),
##       (try_begin),
##         (gt, "$qst_defend_nobles_against_peasants_noble_party_2", 0),
##         (party_is_active, "$qst_defend_nobles_against_peasants_noble_party_2"),
##         (val_add, ":num_active_parties", 1),
##         (party_is_in_town, "$qst_defend_nobles_against_peasants_noble_party_2", ":quest_target_center"),
##         (remove_party, "$qst_defend_nobles_against_peasants_noble_party_2"),
##         (party_get_num_companions, ":num_companions", "$qst_defend_nobles_against_peasants_noble_party_2"),
##         (val_add, "$qst_defend_nobles_against_peasants_num_nobles_saved", ":num_companions"),
##       (try_end),
##       (try_begin),
##         (gt, "$qst_defend_nobles_against_peasants_noble_party_3", 0),
##         (party_is_active, "$qst_defend_nobles_against_peasants_noble_party_3"),
##         (val_add, ":num_active_parties", 1),
##         (party_is_in_town, "$qst_defend_nobles_against_peasants_noble_party_3", ":quest_target_center"),
##         (remove_party, "$qst_defend_nobles_against_peasants_noble_party_3"),
##         (party_get_num_companions, ":num_companions", "$qst_defend_nobles_against_peasants_noble_party_3"),
##         (val_add, "$qst_defend_nobles_against_peasants_num_nobles_saved", ":num_companions"),
##       (try_end),
##       (try_begin),
##         (gt, "$qst_defend_nobles_against_peasants_noble_party_4", 0),
##         (party_is_active, "$qst_defend_nobles_against_peasants_noble_party_4"),
##         (val_add, ":num_active_parties", 1),
##         (party_is_in_town, "$qst_defend_nobles_against_peasants_noble_party_4", ":quest_target_center"),
##         (remove_party, "$qst_defend_nobles_against_peasants_noble_party_4"),
##         (party_get_num_companions, ":num_companions", "$qst_defend_nobles_against_peasants_noble_party_4"),
##         (val_add, "$qst_defend_nobles_against_peasants_num_nobles_saved", ":num_companions"),
##       (try_end),
##       (try_begin),
##         (gt, "$qst_defend_nobles_against_peasants_noble_party_5", 0),
##         (party_is_active, "$qst_defend_nobles_against_peasants_noble_party_5"),
##         (val_add, ":num_active_parties", 1),
##         (party_is_in_town, "$qst_defend_nobles_against_peasants_noble_party_5", ":quest_target_center"),
##         (remove_party, "$qst_defend_nobles_against_peasants_noble_party_5"),
##         (party_get_num_companions, ":num_companions", "$qst_defend_nobles_against_peasants_noble_party_5"),
##         (val_add, "$qst_defend_nobles_against_peasants_num_nobles_saved", ":num_companions"),
##       (try_end),
##       (try_begin),
##         (gt, "$qst_defend_nobles_against_peasants_noble_party_6", 0),
##         (party_is_active, "$qst_defend_nobles_against_peasants_noble_party_6"),
##         (val_add, ":num_active_parties", 1),
##         (party_is_in_town, "$qst_defend_nobles_against_peasants_noble_party_6", ":quest_target_center"),
##         (remove_party, "$qst_defend_nobles_against_peasants_noble_party_6"),
##         (party_get_num_companions, ":num_companions", "$qst_defend_nobles_against_peasants_noble_party_6"),
##         (val_add, "$qst_defend_nobles_against_peasants_num_nobles_saved", ":num_companions"),
##       (try_end),
##       (try_begin),
##         (gt, "$qst_defend_nobles_against_peasants_noble_party_7", 0),
##         (party_is_active, "$qst_defend_nobles_against_peasants_noble_party_7"),
##         (val_add, ":num_active_parties", 1),
##         (party_is_in_town, "$qst_defend_nobles_against_peasants_noble_party_7", ":quest_target_center"),
##         (remove_party, "$qst_defend_nobles_against_peasants_noble_party_7"),
##         (party_get_num_companions, ":num_companions", "$qst_defend_nobles_against_peasants_noble_party_7"),
##         (val_add, "$qst_defend_nobles_against_peasants_num_nobles_saved", ":num_companions"),
##       (try_end),
##       (try_begin),
##         (gt, "$qst_defend_nobles_against_peasants_noble_party_8", 0),
##         (party_is_active, "$qst_defend_nobles_against_peasants_noble_party_8"),
##         (val_add, ":num_active_parties", 1),
##         (party_is_in_town, "$qst_defend_nobles_against_peasants_noble_party_8", ":quest_target_center"),
##         (remove_party, "$qst_defend_nobles_against_peasants_noble_party_8"),
##         (party_get_num_companions, ":num_companions", "$qst_defend_nobles_against_peasants_noble_party_8"),
##         (val_add, "$qst_defend_nobles_against_peasants_num_nobles_saved", ":num_companions"),
##       (try_end),
##       (eq, ":num_active_parties", 0),
##       (try_begin),
##         (store_div, ":limit", "$qst_defend_nobles_against_peasants_num_nobles_to_save", 2),
##         (ge, "$qst_defend_nobles_against_peasants_num_nobles_saved", ":limit"),
##         (succeed_quest, "qst_defend_nobles_against_peasants"),
##       (else_try),
##         (fail_quest, "qst_defend_nobles_against_peasants"),
##       (try_end),
##    ],
##   []
##   ),
### Capture Conspirators quest
##  (0.15, 0.0, 0.0,
##   [
##       (check_quest_active, "qst_capture_conspirators"),
##       (neg|check_quest_succeeded, "qst_capture_conspirators"),
##       (neg|check_quest_failed, "qst_capture_conspirators"),
##       (quest_get_slot, ":quest_target_center", "qst_capture_conspirators", slot_quest_target_center),
##       (quest_get_slot, ":faction_no", "qst_capture_conspirators", slot_quest_target_faction),
##       (try_begin),
##         (gt, "$qst_capture_conspirators_num_parties_to_spawn", "$qst_capture_conspirators_num_parties_spawned"),
##         (store_random_in_range, ":random_no", 0, 100),
##         (lt, ":random_no", 20),
##         (set_spawn_radius, 3),
##         (spawn_around_party,":quest_target_center","pt_conspirator"),
##         (val_add, "$qst_capture_conspirators_num_parties_spawned", 1),
##         (party_get_num_companions, ":num_companions", reg0),
##         (val_add, "$qst_capture_conspirators_num_troops_to_capture", ":num_companions"),
##         (party_set_ai_behavior, reg0, ai_bhvr_travel_to_party),
##         (party_set_ai_object, reg0, "$qst_capture_conspirators_party_1"),
##         (party_set_flags, reg0, pf_default_behavior, 0),
##         (try_begin),
##           (le, "$qst_capture_conspirators_party_2", 0),
##           (assign, "$qst_capture_conspirators_party_2", reg0),
##         (else_try),
##           (le, "$qst_capture_conspirators_party_3", 0),
##           (assign, "$qst_capture_conspirators_party_3", reg0),
##         (else_try),
##           (le, "$qst_capture_conspirators_party_4", 0),
##           (assign, "$qst_capture_conspirators_party_4", reg0),
##         (else_try),
##           (le, "$qst_capture_conspirators_party_5", 0),
##           (assign, "$qst_capture_conspirators_party_5", reg0),
##         (else_try),
##           (le, "$qst_capture_conspirators_party_6", 0),
##           (assign, "$qst_capture_conspirators_party_6", reg0),
##         (else_try),
##           (le, "$qst_capture_conspirators_party_7", 0),
##           (assign, "$qst_capture_conspirators_party_7", reg0),
##         (try_end),
##       (try_end),
##
##       (assign, ":num_active_parties", 0),
##
##       (try_begin),
##         (gt, "$qst_capture_conspirators_party_1", 0),
##         (party_is_active, "$qst_capture_conspirators_party_1"),
##         (val_add, ":num_active_parties", 1),
##         (try_begin),
##           (party_is_in_any_town, "$qst_capture_conspirators_party_1"),
##           (remove_party, "$qst_capture_conspirators_party_1"),
##         (else_try),
##           (party_get_num_attached_parties, ":num_attachments", "$qst_capture_conspirators_party_1"),
##           (gt, ":num_attachments", 0),
##           (assign, ":leave_meeting", 0),
##           (try_begin),
##             (store_sub, ":required_attachments", "$qst_capture_conspirators_num_parties_to_spawn", 1),
##             (eq, ":num_attachments", ":required_attachments"),
##             (val_add, "$qst_capture_conspirators_leave_meeting_counter", 1),
##             (ge, "$qst_capture_conspirators_leave_meeting_counter", 15),
##             (assign, ":leave_meeting", 1),
##           (try_end),
##           (try_begin),
##             (eq, "$qst_capture_conspirators_num_parties_to_spawn", "$qst_capture_conspirators_num_parties_spawned"),
##             (store_distance_to_party_from_party, ":cur_distance", "p_main_party", "$qst_capture_conspirators_party_1"),
##             (assign, ":min_distance", 3),
##             (try_begin),
##               (is_currently_night),
##               (assign, ":min_distance", 2),
##             (try_end),
##             (lt, ":cur_distance", ":min_distance"),
##             (assign, "$qst_capture_conspirators_leave_meeting_counter", 15),
##             (assign, ":leave_meeting", 1),
##           (try_end),
##           (eq, ":leave_meeting", 1),
##           (party_set_ai_behavior, "$qst_capture_conspirators_party_1", ai_bhvr_travel_to_point),
##           (party_set_flags, "$qst_capture_conspirators_party_1", pf_default_behavior, 0),
##           (party_get_position, pos1, "$qst_capture_conspirators_party_1"),
##           (call_script, "script_map_get_random_position_around_position_within_range", 15, 17),
##           (party_set_ai_target_position, "$qst_capture_conspirators_party_1", pos2),
##           (try_begin),
##             (gt, "$qst_capture_conspirators_party_2", 0),
##             (party_detach, "$qst_capture_conspirators_party_2"),
##             (party_set_ai_behavior, "$qst_capture_conspirators_party_2", ai_bhvr_travel_to_point),
##             (party_set_flags, "$qst_capture_conspirators_party_2", pf_default_behavior, 0),
##             (call_script, "script_map_get_random_position_around_position_within_range", 15, 17),
##             (party_set_ai_target_position, "$qst_capture_conspirators_party_2", pos2),
##           (try_end),
##           (try_begin),
##             (gt, "$qst_capture_conspirators_party_3", 0),
##             (party_detach, "$qst_capture_conspirators_party_3"),
##             (party_set_ai_behavior, "$qst_capture_conspirators_party_3", ai_bhvr_travel_to_point),
##             (party_set_flags, "$qst_capture_conspirators_party_3", pf_default_behavior, 0),
##             (call_script, "script_map_get_random_position_around_position_within_range", 15, 17),
##             (party_set_ai_target_position, "$qst_capture_conspirators_party_3", pos2),
##           (try_end),
##           (try_begin),
##             (gt, "$qst_capture_conspirators_party_4", 0),
##             (party_detach, "$qst_capture_conspirators_party_4"),
##             (party_set_ai_behavior, "$qst_capture_conspirators_party_4", ai_bhvr_travel_to_point),
##             (party_set_flags, "$qst_capture_conspirators_party_4", pf_default_behavior, 0),
##             (call_script, "script_map_get_random_position_around_position_within_range", 15, 17),
##             (party_set_ai_target_position, "$qst_capture_conspirators_party_4", pos2),
##           (try_end),
##           (try_begin),
##             (gt, "$qst_capture_conspirators_party_5", 0),
##             (party_detach, "$qst_capture_conspirators_party_5"),
##             (party_set_ai_behavior, "$qst_capture_conspirators_party_5", ai_bhvr_travel_to_point),
##             (party_set_flags, "$qst_capture_conspirators_party_5", pf_default_behavior, 0),
##             (call_script, "script_map_get_random_position_around_position_within_range", 15, 17),
##             (party_set_ai_target_position, "$qst_capture_conspirators_party_5", pos2),
##           (try_end),
##           (try_begin),
##             (gt, "$qst_capture_conspirators_party_6", 0),
##             (party_detach, "$qst_capture_conspirators_party_6"),
##             (party_set_ai_behavior, "$qst_capture_conspirators_party_6", ai_bhvr_travel_to_point),
##             (party_set_flags, "$qst_capture_conspirators_party_6", pf_default_behavior, 0),
##             (call_script, "script_map_get_random_position_around_position_within_range", 15, 17),
##             (party_set_ai_target_position, "$qst_capture_conspirators_party_6", pos2),
##           (try_end),
##           (try_begin),
##             (gt, "$qst_capture_conspirators_party_7", 0),
##             (party_detach, "$qst_capture_conspirators_party_7"),
##             (party_set_ai_behavior, "$qst_capture_conspirators_party_7", ai_bhvr_travel_to_point),
##             (party_set_flags, "$qst_capture_conspirators_party_7", pf_default_behavior, 0),
##             (call_script, "script_map_get_random_position_around_position_within_range", 15, 17),
##             (party_set_ai_target_position, "$qst_capture_conspirators_party_7", pos2),
##           (try_end),
##         (try_end),
##         (try_begin),
##           (get_party_ai_behavior, ":ai_behavior", "$qst_capture_conspirators_party_1"),
##           (eq, ":ai_behavior", ai_bhvr_travel_to_point),
##           (party_get_ai_target_position, pos2, "$qst_capture_conspirators_party_1"),
##           (party_get_position, pos1, "$qst_capture_conspirators_party_1"),
##           (get_distance_between_positions, ":distance", pos2, pos1),
##           (lt, ":distance", 200),
##           (call_script, "script_get_closest_walled_center_of_faction", "$qst_capture_conspirators_party_1", ":faction_no"),#Can fail
##           (ge, reg0, 0),
##           (party_set_ai_object, "$qst_capture_conspirators_party_1", reg0),
##           (party_set_ai_behavior, "$qst_capture_conspirators_party_1", ai_bhvr_travel_to_party),
##           (party_set_flags, "$qst_capture_conspirators_party_1", pf_default_behavior, 0),
##         (try_end),
##       (try_end),
##       (try_begin),
##         (gt, "$qst_capture_conspirators_party_2", 0),
##         (party_is_active, "$qst_capture_conspirators_party_2"),
##         (val_add, ":num_active_parties", 1),
##         (try_begin),
##           (party_is_in_any_town, "$qst_capture_conspirators_party_2"),
##           (try_begin),
##             (neg|party_is_in_town, "$qst_capture_conspirators_party_2", "$qst_capture_conspirators_party_1"),
##             (remove_party, "$qst_capture_conspirators_party_2"),
##           (else_try),
##             (get_party_ai_behavior, ":ai_behavior", "$qst_capture_conspirators_party_2"),
##             (neq, ":ai_behavior", ai_bhvr_hold),
##             (party_set_ai_behavior, "$qst_capture_conspirators_party_2", ai_bhvr_hold),
##             (party_attach_to_party, "$qst_capture_conspirators_party_2", "$qst_capture_conspirators_party_1"),
##             (party_set_flags, "$qst_capture_conspirators_party_2", pf_default_behavior, 0),
##           (try_end),
##         (try_end),
##         (try_begin),
##           (get_party_ai_behavior, ":ai_behavior", "$qst_capture_conspirators_party_2"),
##           (eq, ":ai_behavior", ai_bhvr_travel_to_point),
##           (party_get_ai_target_position, pos2, "$qst_capture_conspirators_party_2"),
##           (party_get_position, pos1, "$qst_capture_conspirators_party_2"),
##           (get_distance_between_positions, ":distance", pos2, pos1),
##           (lt, ":distance", 200),
##           (call_script, "script_get_closest_walled_center_of_faction", "$qst_capture_conspirators_party_2", ":faction_no"),#Can fail
##           (ge, reg0, 0),
##           (party_set_ai_object, "$qst_capture_conspirators_party_2", reg0),
##           (party_set_ai_behavior, "$qst_capture_conspirators_party_2", ai_bhvr_travel_to_party),
##           (party_set_flags, "$qst_capture_conspirators_party_2", pf_default_behavior, 0),
##         (try_end),
##       (try_end),
##       (try_begin),
##         (gt, "$qst_capture_conspirators_party_3", 0),
##         (party_is_active, "$qst_capture_conspirators_party_3"),
##         (val_add, ":num_active_parties", 1),
##         (try_begin),
##           (party_is_in_any_town, "$qst_capture_conspirators_party_3"),
##           (try_begin),
##             (neg|party_is_in_town, "$qst_capture_conspirators_party_3", "$qst_capture_conspirators_party_1"),
##             (remove_party, "$qst_capture_conspirators_party_3"),
##           (else_try),
##             (get_party_ai_behavior, ":ai_behavior", "$qst_capture_conspirators_party_3"),
##             (neq, ":ai_behavior", ai_bhvr_hold),
##             (party_set_ai_behavior, "$qst_capture_conspirators_party_3", ai_bhvr_hold),
##             (party_attach_to_party, "$qst_capture_conspirators_party_3", "$qst_capture_conspirators_party_1"),
##             (party_set_flags, "$qst_capture_conspirators_party_3", pf_default_behavior, 0),
##           (try_end),
##         (try_end),
##         (try_begin),
##           (get_party_ai_behavior, ":ai_behavior", "$qst_capture_conspirators_party_3"),
##           (eq, ":ai_behavior", ai_bhvr_travel_to_point),
##           (party_get_ai_target_position, pos2, "$qst_capture_conspirators_party_3"),
##           (party_get_position, pos1, "$qst_capture_conspirators_party_3"),
##           (get_distance_between_positions, ":distance", pos2, pos1),
##           (lt, ":distance", 200),
##           (call_script, "script_get_closest_walled_center_of_faction", "$qst_capture_conspirators_party_3", ":faction_no"),#Can fail
##           (ge, reg0, 0),
##           (party_set_ai_object, "$qst_capture_conspirators_party_3", reg0),
##           (party_set_ai_behavior, "$qst_capture_conspirators_party_3", ai_bhvr_travel_to_party),
##           (party_set_flags, "$qst_capture_conspirators_party_3", pf_default_behavior, 0),
##         (try_end),
##       (try_end),
##       (try_begin),
##         (gt, "$qst_capture_conspirators_party_4", 0),
##         (party_is_active, "$qst_capture_conspirators_party_4"),
##         (val_add, ":num_active_parties", 1),
##         (try_begin),
##           (party_is_in_any_town, "$qst_capture_conspirators_party_4"),
##           (try_begin),
##             (neg|party_is_in_town, "$qst_capture_conspirators_party_4", "$qst_capture_conspirators_party_1"),
##             (remove_party, "$qst_capture_conspirators_party_4"),
##           (else_try),
##             (get_party_ai_behavior, ":ai_behavior", "$qst_capture_conspirators_party_4"),
##             (neq, ":ai_behavior", ai_bhvr_hold),
##             (party_set_ai_behavior, "$qst_capture_conspirators_party_4", ai_bhvr_hold),
##             (party_set_flags, "$qst_capture_conspirators_party_4", pf_default_behavior, 0),
##             (party_attach_to_party, "$qst_capture_conspirators_party_4", "$qst_capture_conspirators_party_1"),
##           (try_end),
##         (try_end),
##         (try_begin),
##           (get_party_ai_behavior, ":ai_behavior", "$qst_capture_conspirators_party_4"),
##           (eq, ":ai_behavior", ai_bhvr_travel_to_point),
##           (party_get_ai_target_position, pos2, "$qst_capture_conspirators_party_4"),
##           (party_get_position, pos1, "$qst_capture_conspirators_party_4"),
##           (get_distance_between_positions, ":distance", pos2, pos1),
##           (lt, ":distance", 200),
##           (call_script, "script_get_closest_walled_center_of_faction", "$qst_capture_conspirators_party_4", ":faction_no"),#Can fail
##           (ge, reg0, 0),
##           (party_set_ai_object, "$qst_capture_conspirators_party_4", reg0),
##           (party_set_ai_behavior, "$qst_capture_conspirators_party_4", ai_bhvr_travel_to_party),
##           (party_set_flags, "$qst_capture_conspirators_party_4", pf_default_behavior, 0),
##         (try_end),
##       (try_end),
##       (try_begin),
##         (gt, "$qst_capture_conspirators_party_5", 0),
##         (party_is_active, "$qst_capture_conspirators_party_5"),
##         (val_add, ":num_active_parties", 1),
##         (try_begin),
##           (party_is_in_any_town, "$qst_capture_conspirators_party_5"),
##           (try_begin),
##             (neg|party_is_in_town, "$qst_capture_conspirators_party_5", "$qst_capture_conspirators_party_1"),
##             (remove_party, "$qst_capture_conspirators_party_5"),
##           (else_try),
##             (get_party_ai_behavior, ":ai_behavior", "$qst_capture_conspirators_party_5"),
##             (neq, ":ai_behavior", ai_bhvr_hold),
##             (party_set_ai_behavior, "$qst_capture_conspirators_party_5", ai_bhvr_hold),
##             (party_set_flags, "$qst_capture_conspirators_party_5", pf_default_behavior, 0),
##             (party_attach_to_party, "$qst_capture_conspirators_party_5", "$qst_capture_conspirators_party_1"),
##           (try_end),
##         (try_end),
##         (try_begin),
##           (get_party_ai_behavior, ":ai_behavior", "$qst_capture_conspirators_party_5"),
##           (eq, ":ai_behavior", ai_bhvr_travel_to_point),
##           (party_get_ai_target_position, pos2, "$qst_capture_conspirators_party_5"),
##           (party_get_position, pos1, "$qst_capture_conspirators_party_5"),
##           (get_distance_between_positions, ":distance", pos2, pos1),
##           (lt, ":distance", 200),
##           (call_script, "script_get_closest_walled_center_of_faction", "$qst_capture_conspirators_party_5", ":faction_no"),#Can fail
##           (ge, reg0, 0),
##           (party_set_ai_object, "$qst_capture_conspirators_party_5", reg0),
##           (party_set_ai_behavior, "$qst_capture_conspirators_party_5", ai_bhvr_travel_to_party),
##           (party_set_flags, "$qst_capture_conspirators_party_5", pf_default_behavior, 0),
##         (try_end),
##       (try_end),
##       (try_begin),
##         (gt, "$qst_capture_conspirators_party_6", 0),
##         (party_is_active, "$qst_capture_conspirators_party_6"),
##         (val_add, ":num_active_parties", 1),
##         (try_begin),
##           (party_is_in_any_town, "$qst_capture_conspirators_party_6"),
##           (try_begin),
##             (neg|party_is_in_town, "$qst_capture_conspirators_party_6", "$qst_capture_conspirators_party_1"),
##             (remove_party, "$qst_capture_conspirators_party_6"),
##           (else_try),
##             (get_party_ai_behavior, ":ai_behavior", "$qst_capture_conspirators_party_6"),
##             (neq, ":ai_behavior", ai_bhvr_hold),
##             (party_set_ai_behavior, "$qst_capture_conspirators_party_6", ai_bhvr_hold),
##             (party_set_flags, "$qst_capture_conspirators_party_6", pf_default_behavior, 0),
##             (party_attach_to_party, "$qst_capture_conspirators_party_6", "$qst_capture_conspirators_party_1"),
##           (try_end),
##         (try_end),
##         (try_begin),
##           (get_party_ai_behavior, ":ai_behavior", "$qst_capture_conspirators_party_6"),
##           (eq, ":ai_behavior", ai_bhvr_travel_to_point),
##           (party_get_ai_target_position, pos2, "$qst_capture_conspirators_party_6"),
##           (party_get_position, pos1, "$qst_capture_conspirators_party_6"),
##           (get_distance_between_positions, ":distance", pos2, pos1),
##           (lt, ":distance", 200),
##           (call_script, "script_get_closest_walled_center_of_faction", "$qst_capture_conspirators_party_6", ":faction_no"),#Can fail
##           (ge, reg0, 0),
##           (party_set_ai_object, "$qst_capture_conspirators_party_6", reg0),
##           (party_set_ai_behavior, "$qst_capture_conspirators_party_6", ai_bhvr_travel_to_party),
##           (party_set_flags, "$qst_capture_conspirators_party_6", pf_default_behavior, 0),
##         (try_end),
##       (try_end),
##       (try_begin),
##         (gt, "$qst_capture_conspirators_party_7", 0),
##         (party_is_active, "$qst_capture_conspirators_party_7"),
##         (val_add, ":num_active_parties", 1),
##         (try_begin),
##           (party_is_in_any_town, "$qst_capture_conspirators_party_7"),
##           (try_begin),
##             (neg|party_is_in_town, "$qst_capture_conspirators_party_7", "$qst_capture_conspirators_party_1"),
##             (remove_party, "$qst_capture_conspirators_party_7"),
##           (else_try),
##             (get_party_ai_behavior, ":ai_behavior", "$qst_capture_conspirators_party_7"),
##             (neq, ":ai_behavior", ai_bhvr_hold),
##             (party_set_ai_behavior, "$qst_capture_conspirators_party_7", ai_bhvr_hold),
##             (party_set_flags, "$qst_capture_conspirators_party_7", pf_default_behavior, 0),
##             (party_attach_to_party, "$qst_capture_conspirators_party_7", "$qst_capture_conspirators_party_1"),
##           (try_end),
##         (try_end),
##         (try_begin),
##           (get_party_ai_behavior, ":ai_behavior", "$qst_capture_conspirators_party_7"),
##           (eq, ":ai_behavior", ai_bhvr_travel_to_point),
##           (party_get_ai_target_position, pos2, "$qst_capture_conspirators_party_7"),
##           (party_get_position, pos1, "$qst_capture_conspirators_party_7"),
##           (get_distance_between_positions, ":distance", pos2, pos1),
##           (lt, ":distance", 200),
##           (call_script, "script_get_closest_walled_center_of_faction", "$qst_capture_conspirators_party_7", ":faction_no"),#Can fail
##           (ge, reg0, 0),
##           (party_set_ai_object, "$qst_capture_conspirators_party_7", reg0),
##           (party_set_ai_behavior, "$qst_capture_conspirators_party_7", ai_bhvr_travel_to_party),
##           (party_set_flags, "$qst_capture_conspirators_party_7", pf_default_behavior, 0),
##         (try_end),
##       (try_end),
##
##       (eq, ":num_active_parties", 0),
##       (party_count_prisoners_of_type, ":count_captured_conspirators", "p_main_party", "trp_conspirator"),
##       (party_count_prisoners_of_type, ":count_captured_conspirator_leaders", "p_main_party", "trp_conspirator_leader"),
##       (val_add, ":count_captured_conspirators", ":count_captured_conspirator_leaders"),
##       (try_begin),
##         (store_div, ":limit", "$qst_capture_conspirators_num_troops_to_capture", 2),
##         (gt, ":count_captured_conspirators", ":limit"),
##         (succeed_quest, "qst_capture_conspirators"),
##       (else_try),
##         (fail_quest, "qst_capture_conspirators"),
##       (try_end),
##    ],
##   []
##   ),
### Follow Spy quest
##  (0.5, 0.0, 0.0,
##   [
##       (check_quest_active, "qst_follow_spy"),
##       (neg|check_quest_succeeded, "qst_follow_spy"),
##       (neg|check_quest_failed, "qst_follow_spy"),
##       (quest_get_slot, ":quest_giver_center", "qst_follow_spy", slot_quest_giver_center),
##       (quest_get_slot, ":quest_object_center", "qst_follow_spy", slot_quest_object_center),
##       (assign, ":abort_meeting", 0),
##       (try_begin),
##         (this_or_next|eq, "$qst_follow_spy_run_away", 1),
##         (this_or_next|neg|party_is_active, "$qst_follow_spy_spy_party"),
##         (neg|party_is_active, "$qst_follow_spy_spy_partners_party"),
##       (else_try),
##         (eq, "$qst_follow_spy_meeting_state", 0),
##         (store_distance_to_party_from_party, ":cur_distance", "p_main_party", "$qst_follow_spy_spy_party"),
##         (try_begin),
##           (assign, ":min_distance", 3),
##           (try_begin),
##             (is_currently_night),
##             (assign, ":min_distance", 1),
##           (try_end),
##           (le, ":cur_distance", ":min_distance"),
##           (store_distance_to_party_from_party, ":player_distance_to_quest_giver_center", "p_main_party", ":quest_giver_center"),
##           (gt, ":player_distance_to_quest_giver_center", 1),
##           (assign, ":abort_meeting", 1),
##           (assign, "$qst_follow_spy_run_away", 1),
##           (display_message, "str_qst_follow_spy_noticed_you"),
##         (else_try),
##           (store_distance_to_party_from_party, ":cur_distance", "$qst_follow_spy_spy_partners_party", "$qst_follow_spy_spy_party"),
##           (le, ":cur_distance", 1),
##           (party_attach_to_party, "$qst_follow_spy_spy_party", "$qst_follow_spy_spy_partners_party"),
##           (assign, "$qst_follow_spy_meeting_state", 1),
##           (assign, "$qst_follow_spy_meeting_counter", 0),
##         (try_end),
##       (else_try),
##         (eq, "$qst_follow_spy_meeting_state", 1),
##         (store_distance_to_party_from_party, ":cur_distance", "p_main_party", "$qst_follow_spy_spy_partners_party"),
##         (try_begin),
##           (le, ":cur_distance", 1),
##           (party_detach, "$qst_follow_spy_spy_party"),
##           (assign, ":abort_meeting", 1),
##           (assign, "$qst_follow_spy_run_away", 1),
##           (display_message, "str_qst_follow_spy_noticed_you"),
##         (else_try),
##           (val_add, "$qst_follow_spy_meeting_counter", 1),
##           (gt, "$qst_follow_spy_meeting_counter", 4),
##           (party_detach, "$qst_follow_spy_spy_party"),
##           (assign, ":abort_meeting", 0),
##           (assign, "$qst_follow_spy_meeting_state", 2),
##         (try_end),
##       (try_end),
##       (try_begin),
##         (eq, ":abort_meeting", 1),
##         (party_set_ai_object, "$qst_follow_spy_spy_party", ":quest_giver_center"),
##         (party_set_ai_object, "$qst_follow_spy_spy_partners_party", ":quest_object_center"),
##         (party_set_ai_behavior, "$qst_follow_spy_spy_party", ai_bhvr_travel_to_party),
##         (party_set_ai_behavior, "$qst_follow_spy_spy_partners_party", ai_bhvr_travel_to_party),
##         (party_set_flags, "$qst_follow_spy_spy_party", pf_default_behavior, 0),
##         (party_set_flags, "$qst_follow_spy_spy_partners_party", pf_default_behavior, 0),
##       (try_end),
##       (try_begin),
##         (party_is_active, "$qst_follow_spy_spy_party"),
##         (party_is_in_town, "$qst_follow_spy_spy_party", ":quest_giver_center"),
##         (remove_party, "$qst_follow_spy_spy_party"),
##         (assign, "$qst_follow_spy_spy_back_in_town",1),
##       (try_end),
##       (try_begin),
##         (party_is_active, "$qst_follow_spy_spy_partners_party"),
##         (party_is_in_town, "$qst_follow_spy_spy_partners_party", ":quest_object_center"),
##         (remove_party, "$qst_follow_spy_spy_partners_party"),
##         (assign, "$qst_follow_spy_partner_back_in_town",1),
##       (try_end),
##       (try_begin),
##         (eq, "$qst_follow_spy_partner_back_in_town",1),
##         (eq, "$qst_follow_spy_spy_back_in_town",1),
##         (fail_quest, "qst_follow_spy"),
##       (try_end),
##    ],
##   []
##   ),
### Raiders quest
##  (0.95, 0.0, 0.2,
##   [
##       (check_quest_active, "qst_hunt_down_raiders"),
##       (neg|check_quest_succeeded, "qst_hunt_down_raiders"),
##       (neg|check_quest_failed, "qst_hunt_down_raiders"),
##    ],
##   [
##       (quest_get_slot, ":quest_target_party", "qst_hunt_down_raiders", slot_quest_target_party),
##       (party_set_ai_behavior, ":quest_target_party", ai_bhvr_hold),
##       (party_set_flags, ":quest_target_party", pf_default_behavior, 0),
##    ]
##   ),
##
##  (0.7, 0, 0.2,
##   [
##       (check_quest_active, "qst_hunt_down_raiders"),
##       (neg|check_quest_succeeded, "qst_hunt_down_raiders"),
##       (neg|check_quest_failed, "qst_hunt_down_raiders"),
##    ],
##   [
##       (quest_get_slot, ":quest_target_party", "qst_hunt_down_raiders", slot_quest_target_party),
##       (party_set_ai_behavior,":quest_target_party",ai_bhvr_travel_to_party),
##       (party_set_flags, ":quest_target_party", pf_default_behavior, 0),
##    ]
##   ),
##  
##  (0.1, 0.0, 0.0,
##   [
##       (check_quest_active, "qst_hunt_down_raiders"),
##       (neg|check_quest_succeeded, "qst_hunt_down_raiders"),
##       (neg|check_quest_failed, "qst_hunt_down_raiders"),
##       (quest_get_slot, ":quest_target_party", "qst_hunt_down_raiders", slot_quest_target_party),
##       (neg|party_is_active, ":quest_target_party")
##    ],
##   [
##       (succeed_quest, "qst_hunt_down_raiders"),
##    ]
##   ),
##  
##  (1.3, 0, 0.0,
##   [
##       (check_quest_active, "qst_hunt_down_raiders"),
##       (neg|check_quest_succeeded, "qst_hunt_down_raiders"),
##       (neg|check_quest_failed, "qst_hunt_down_raiders"),
##       (quest_get_slot, ":quest_target_party", "qst_hunt_down_raiders", slot_quest_target_party),
##       (quest_get_slot, ":quest_target_center", "qst_hunt_down_raiders", slot_quest_target_center),
##       (party_is_in_town,":quest_target_party",":quest_target_center")
##    ],
##   [
##       (fail_quest, "qst_hunt_down_raiders"),
##       (display_message, "str_raiders_reached_base"),
##       (quest_get_slot, ":quest_target_party", "qst_hunt_down_raiders", slot_quest_target_party),
##       (remove_party, ":quest_target_party"),
##    ]
##   ),

##### TODO: QUESTS COMMENT OUT END

#########################################################################
# Random MERCHANT quest triggers
####################################  
 # Apply interest to merchants guild debt  1% per week
  (24.0 * 7, 0.0, 0.0,
   [],
   [
       (val_mul,"$debt_to_merchants_guild",101),
       (val_div,"$debt_to_merchants_guild",100)
    ]
   ),
# Deliver food to tavern  
  (24.0, 0, 1.0,
   [
       (eq,"$deliver_wine_quest_active",1),
       (store_current_day,reg(3)),
       (lt,"$deliver_wine_quest_end_day",reg(3)),
     ],
   [
       (fail_quest,"qst_deliver_wine"),
       (call_script, "script_end_quest","qst_deliver_wine"),
       (assign,"$deliver_wine_quest_active",0),
       (val_add,"$debt_to_merchants_guild","$deliver_wine_quest_debt")
     ]
   ),
# Escort merchant caravan:
  (0.1, 0.0, 0.1, [[eq,"$escort_merchant_caravan_quest_active",1],
                   [eq,"$escort_merchant_caravan_mode",1]], [[party_set_ai_behavior,"$merchant_caravan_id",ai_bhvr_hold],[party_set_flags, "$merchant_caravan_id", pf_default_behavior, 0]]),
  (0.02, 0.0, 0.1, [[eq,"$escort_merchant_caravan_quest_active",1],
                   [eq,"$escort_merchant_caravan_mode",0],
#                   [store_distance_to_party_from_party, reg(0),"$merchant_caravan_id"],
#                   [ge,reg(0),1]
                   ], [[party_set_ai_behavior,"$merchant_caravan_id",ai_bhvr_escort_party],[party_set_flags, "$merchant_caravan_id", pf_default_behavior, 0],
                                    [party_set_ai_object,"$merchant_caravan_id",0]]),
  (0.02, 0.0, 0.1, [[eq,"$escort_merchant_caravan_quest_active",1],
                   [eq,"$escort_merchant_caravan_mode",0],
                   [store_distance_to_party_from_party, reg(0),"$merchant_caravan_id"],
                   [lt,reg(0),1]], [
#                   [party_set_ai_behavior,"$merchant_caravan_id",ai_bhvr_hold],[party_set_flags, "$merchant_caravan_id", pf_default_behavior, 0]
                   ]),

  (0.1, 0, 0.0, [[eq,"$escort_merchant_caravan_quest_active",1],
                 [neg|party_is_active,"$merchant_caravan_id"]],
                         [[fail_quest,"qst_escort_merchant_caravan"],
                          [call_script, "script_end_quest","qst_escort_merchant_caravan"],
                           [assign,"$escort_merchant_caravan_quest_active",0]]),

# Troublesome bandits
  (0.3, 0.0, 1.1, [[eq,"$troublesome_bandits_quest_active",1],
                   [store_num_parties_destroyed,reg(3),"pt_troublesome_bandits"],
                   [lt,"$troublesome_bandits_eliminated",reg(3)],
                   (store_num_parties_destroyed_by_player, ":num_quest_bandits_destroyed_by_player", "pt_troublesome_bandits"),
                   [eq,":num_quest_bandits_destroyed_by_player","$troublesome_bandits_eliminated_by_player"],
                   ], [[display_message,"str_bandits_eliminated_by_another"],
                       [fail_quest,"qst_troublesome_bandits"],
                       [call_script, "script_end_quest","qst_troublesome_bandits"],
                       [assign,"$troublesome_bandits_quest_active",0]]),

  (0.3, 0.0, 1.1, [[eq,"$troublesome_bandits_quest_active",1],
                   [store_num_parties_destroyed,reg(3),"pt_troublesome_bandits"],
                   [lt,"$troublesome_bandits_eliminated",reg(3)],
                   (store_num_parties_destroyed_by_player, ":num_quest_bandits_destroyed_by_player", "pt_troublesome_bandits"),
                   [neq,":num_quest_bandits_destroyed_by_player","$troublesome_bandits_eliminated_by_player"],
                   ], [[succeed_quest,"qst_troublesome_bandits"],
                       [assign,"$troublesome_bandits_quest_active",0],
                       [assign,"$troublesome_bandits_quest_succeeded",1]]),
# Kidnapped girl:
  (0, 0, 0,
   [
       (entering_town,"$kidnapped_girl_quest_giver_town"),
       (main_party_has_troop,"trp_kidnapped_girl")
       ],
   [
       (start_map_conversation,"trp_kidnapped_girl"),
       (assign,"$talking_with_kidnapped_girl",1),
       (assign,"$kidnapped_girl_brought_back",1)
       ]
   ),
  
  (2.0, 0, 0,
   [
      (check_quest_active,"qst_kidnapped_girl"),
      (main_party_has_troop,"trp_kidnapped_girl"),
      (eq,"$kidnapped_girl_bandits_attacked",1),
      (eq,"$kidnapped_girl_joined",0),
    ],
   [
      (assign,"$kidnapped_girl_joined",1),
    ]
   ),
   
   
   [0.0,0.0,0.0,[],[(assign,reg56,"$quest_prestige"),(setup_quest_text,"qst_prestige")]],

(24.0,0,0,[(eq,"$faction_rank",1)],[(val_add,"$quest_prestige",3)]),
(24.0,0,0,[(eq,"$faction_rank",2)],[(val_add,"$quest_prestige",5)]),
(24.0,0,0,[(eq,"$faction_rank",3)],[(val_add,"$quest_prestige",7)]),
(24.0,0,0,[(eq,"$faction_rank",4)],[(val_add,"$quest_prestige",9)]),
(24.0,0,0,[(eq,"$faction_rank",5)],[(val_add,"$quest_prestige",12)]),
(24.0,0,0,[(eq,"$faction_rank",6)],[(val_add,"$quest_prestige",16)]),
(24.0,0,0,[(eq,"$faction_rank",7)],[(val_add,"$quest_prestige",20)]),
(24.0,0,0,[(eq,"$faction_rank",8)],[(val_add,"$quest_prestige",25)]),
(24.0,0,0,[(eq,"$faction_rank",9)],[(val_add,"$quest_prestige",32)]),
(24.0,0,0,[(eq,"$faction_rank",10)],[(val_add,"$quest_prestige",40)]),
(24.0,0,0,[(eq,"$faction_rank",11)],[(val_add,"$quest_prestige",50)]),
#destroy parties add prestige
#qian ren qu
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wei_large_host_1","pt_wei_large_host"),
(assign,"$wei_large_host_3","$wei_large_host_1"),(val_sub,"$wei_large_host_3","$wei_large_host_2"),(val_mul,"$wei_large_host_3",20),
(val_add,"$quest_prestige","$wei_large_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wei_large_host_2","pt_wei_large_host"),
(assign,"$wei_large_host_3","$wei_large_host_2"),(val_sub,"$wei_large_host_3","$wei_large_host_1"),(val_mul,"$wei_large_host_3",20),
(val_add,"$quest_prestige","$wei_large_host_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$shu_large_host_1","pt_shu_large_host"),
(assign,"$shu_large_host_3","$shu_large_host_1"),(val_sub,"$shu_large_host_3","$shu_large_host_2"),(val_mul,"$shu_large_host_3",20),
(val_add,"$quest_prestige","$shu_large_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$shu_large_host_2","pt_shu_large_host"),
(assign,"$shu_large_host_3","$shu_large_host_2"),(val_sub,"$shu_large_host_3","$shu_large_host_1"),(val_mul,"$shu_large_host_3",20),
(val_add,"$quest_prestige","$shu_large_host_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wu_large_host_1","pt_wu_large_host"),
(assign,"$wu_large_host_3","$wu_large_host_1"),(val_sub,"$wu_large_host_3","$wu_large_host_2"),(val_mul,"$wu_large_host_3",20),
(val_add,"$quest_prestige","$wu_large_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wu_large_host_2","pt_wu_large_host"),
(assign,"$wu_large_host_3","$wu_large_host_2"),(val_sub,"$wu_large_host_3","$wu_large_host_1"),(val_mul,"$wu_large_host_3",20),
(val_add,"$quest_prestige","$wu_large_host_3")]],
#wu bai ren bu
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wei_host_1","pt_wei_host"),
(assign,"$wei_host_3","$wei_host_1"),(val_sub,"$wei_host_3","$wei_host_2"),(val_mul,"$wei_host_3",10),
(val_add,"$quest_prestige","$wei_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wei_host_2","pt_wei_host"),
(assign,"$wei_host_3","$wei_host_2"),(val_sub,"$_3","$wei_host_1"),(val_mul,"$wei_host_3",10),
(val_add,"$quest_prestige","$wei_host_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$shu_host_1","pt_shu_host"),
(assign,"$shu_host_3","$shu_host_1"),(val_sub,"$shu_host_3","$shu_host_2"),(val_mul,"$shu_host_3",10),
(val_add,"$quest_prestige","$shu_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$shu_host_2","pt_shu_host"),
(assign,"$shu_host_3","$shu_host_2"),(val_sub,"$shu_host_3","$shu_host_1"),(val_mul,"$shu_host_3",10),
(val_add,"$quest_prestige","$shu_host_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wu_host_1","pt_wu_host"),
(assign,"$wu_host_3","$wu_host_1"),(val_sub,"$wu_host_3","$wu_host_2"),(val_mul,"$wu_host_3",10),
(val_add,"$quest_prestige","$wu_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wu_host_2","pt_wu_host"),
(assign,"$wu_host_3","$wu_host_2"),(val_sub,"$wu_host_3","$wu_host_1"),(val_mul,"$wu_host_3",10),
(val_add,"$quest_prestige","$wu_host_3")]],
#bai ren bu 
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wei_small_host_1","pt_wei_small_host"),
(assign,"$wei_small_host_3","$wei_small_host_1"),(val_sub,"$wei_small_host_3","$wei_small_host_2"),(val_mul,"$wei_small_host_3",5),
(val_add,"$quest_prestige","$wei_small_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wei_small_host_2","pt_wei_small_host"),
(assign,"$wei_small_host_3","$wei_small_host_2"),(val_sub,"$wei_small_host_3","$wei_small_host_1"),(val_mul,"$wei_small_host_3",5),
(val_add,"$quest_prestige","$wei_small_host_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$shu_small_host_1","pt_shu_small_host"),
(assign,"$shu_small_host_3","$shu_small_host_1"),(val_sub,"$shu_small_host_3","$shu_small_host_2"),(val_mul,"$shu_small_host_3",5),
(val_add,"$quest_prestige","$shu_small_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$shu_small_host_2","pt_shu_small_host"),
(assign,"$shu_small_host_3","$shu_small_host_2"),(val_sub,"$shu_small_host_3","$shu_small_host_1"),(val_mul,"$shu_small_host_3",5),
(val_add,"$quest_prestige","$shu_small_host_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$shu_small_host_1","pt_shu_small_host"),
(assign,"$shu_small_host_3","$shu_small_host_1"),(val_sub,"$shu_small_host_3","$shu_small_host_2"),(val_mul,"$shu_small_host_3",5),
(val_add,"$quest_prestige","$shu_small_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$shu_small_host_2","pt_shu_small_host"),
(assign,"$shu_small_host_3","$shu_small_host_2"),(val_sub,"$shu_small_host_3","$shu_small_host_1"),(val_mul,"$shu_small_host_3",5),
(val_add,"$quest_prestige","$shu_small_host_3")]],
#xun luo
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wei_patrol_1","pt_wei_patrol"),
(assign,"$wei_patrol_3","$wei_patrol_1"),(val_sub,"$wei_patrol_3","$wei_patrol_2"),(val_mul,"$wei_patrol_3",2),
(val_add,"$quest_prestige","$wei_patrol_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wei_patrol_2","pt_wei_patrol"),
(assign,"$wei_patrol_3","$wei_patrol_2"),(val_sub,"$wei_patrol_3","$wei_patrol_1"),(val_mul,"$wei_patrol_3",2),
(val_add,"$quest_prestige","$wei_patrol_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$shu_patrol_1","pt_shu_patrol"),
(assign,"$shu_patrol_3","$shu_patrol_1"),(val_sub,"$shu_patrol_3","$shu_patrol_2"),(val_mul,"$shu_patrol_3",2),
(val_add,"$quest_prestige","$shu_patrol_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$shu_patrol_2","pt_shu_patrol"),
(assign,"$shu_patrol_3","$shu_patrol_2"),(val_sub,"$shu_patrol_3","$shu_patrol_1"),(val_mul,"$shu_patrol_3",2),
(val_add,"$quest_prestige","$shu_patrol_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wu_patrol_1","pt_wu_patrol"),
(assign,"$wu_patrol_3","$wu_patrol_1"),(val_sub,"$wu_patrol_3","$wu_patrol_2"),(val_mul,"$wu_patrol_3",2),
(val_add,"$quest_prestige","$wu_patrol_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$wu_patrol_2","pt_wu_patrol"),
(assign,"$wu_patrol_3","$wu_patrol_2"),(val_sub,"$wu_patrol_3","$wu_patrol_1"),(val_mul,"$wu_patrol_3",2),
(val_add,"$quest_prestige","$wu_patrol_3")]],
#npc bu dui
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$charger_troop_1","pt_charger_troop"),
(assign,"$charger_troop_3","$charger_troop_1"),(val_sub,"$charger_troop_3","$charger_troop_2"),(val_mul,"$charger_troop_3",15),
(val_add,"$quest_prestige","$charger_troop_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$charger_troop_2","pt_charger_troop"),
(assign,"$charger_troop_3","$charger_troop_2"),(val_sub,"$charger_troop_3","$charger_troop_1"),(val_mul,"$charger_troop_3",15),
(val_add,"$quest_prestige","$charger_troop_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$white_horse_troop_1","pt_white_horse_troop"),
(assign,"$white_horse_troop_3","$white_horse_troop_1"),(val_sub,"$white_horse_troop_3","$white_horse_troop_2"),(val_mul,"$white_horse_troop_3",15),
(val_add,"$quest_prestige","$white_horse_troop_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$white_horse_troop_2","pt_white_horse_troop"),
(assign,"$white_horse_troop_3","$white_horse_troop_2"),(val_sub,"$white_horse_troop_3","$white_horse_troop_1"),(val_mul,"$white_horse_troop_3",15),
(val_add,"$quest_prestige","$white_horse_troop_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$crushing_troop_1","pt_crushing_troop"),
(assign,"$crushing_troop_3","$crushing_troop_1"),(val_sub,"$crushing_troop_3","$crushing_troop_2"),(val_mul,"$crushing_troop_3",15),
(val_add,"$quest_prestige","$crushing_troop_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$crushing_troop_2","pt_crushing_troop"),
(assign,"$crushing_troop_3","$crushing_troop_2"),(val_sub,"$crushing_troop_3","$crushing_troop_1"),(val_mul,"$crushing_troop_3",15),
(val_add,"$quest_prestige","$crushing_troop_3")]],
#shao shu min zu
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$southern_man_small_host_1","pt_southern_man_small_host"),
(assign,"$southern_man_small_host_3","$southern_man_small_host_1"),(val_sub,"$southern_man_small_host_3","$southern_man_small_host_2"),(val_mul,"$southern_man_small_host_3",5),
(val_add,"$quest_prestige","$southern_man_small_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$southern_man_small_host_2","pt_southern_man_small_host"),
(assign,"$southern_man_small_host_3","$southern_man_small_host_2"),(val_sub,"$southern_man_small_host_3","$southern_man_small_host_1"),(val_mul,"$southern_man_small_host_3",5),
(val_add,"$quest_prestige","$southern_man_small_host_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$southern_man_host_1","pt_southern_man_host"),
(assign,"$southern_man_host_3","$southern_man_host_1"),(val_sub,"$southern_man_host_3","$southern_man_host_2"),(val_mul,"$southern_man_host_3",10),
(val_add,"$quest_prestige","$southern_man_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$southern_man_host_2","pt_southern_man_host"),
(assign,"$southern_man_host_3","$southern_man_host_2"),(val_sub,"$southern_man_host_3","$southern_man_host_1"),(val_mul,"$southern_man_host_3",10),
(val_add,"$quest_prestige","$southern_man_host_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$northern_xiong_nu_small_host_1","pt_northern_xiong_nu_small_host"),
(assign,"$northern_xiong_nu_small_host_3","$northern_xiong_nu_small_host_1"),(val_sub,"$northern_xiong_nu_small_host_3","$northern_xiong_nu_small_host_2"),(val_mul,"$northern_xiong_nu_small_host_3",5),
(val_add,"$quest_prestige","$northern_xiong_nu_small_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$northern_xiong_nu_small_host_2","pt_northern_xiong_nu_small_host"),
(assign,"$northern_xiong_nu_small_host_3","$northern_xiong_nu_small_host_2"),(val_sub,"$northern_xiong_nu_small_host_3","$northern_xiong_nu_small_host_1"),(val_mul,"$northern_xiong_nu_small_host_3",5),
(val_add,"$quest_prestige","$northern_xiong_nu_small_host_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$northern_xiong_nu_host_1","pt_northern_xiong_nu_host"),
(assign,"$northern_xiong_nu_host_3","$northern_xiong_nu_host_1"),(val_sub,"$northern_xiong_nu_host_3","$northern_xiong_nu_host_2"),(val_mul,"$northern_xiong_nu_host_3",10),
(val_add,"$quest_prestige","$northern_xiong_nu_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$northern_xiong_nu_host_2","pt_northern_xiong_nu_host"),
(assign,"$northern_xiong_nu_host_3","$northern_xiong_nu_host_2"),(val_sub,"$northern_xiong_nu_host_3","$northern_xiong_nu_host_1"),(val_mul,"$northern_xiong_nu_host_3",10),
(val_add,"$quest_prestige","$northern_xiong_nu_host_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$eastern_yue_small_host_1","pt_eastern_yue_small_host"),
(assign,"$eastern_yue_small_host_3","$eastern_yue_small_host_1"),(val_sub,"$eastern_yue_small_host_3","$eastern_yue_small_host_2"),(val_mul,"$eastern_yue_small_host_3",5),
(val_add,"$quest_prestige","$eastern_yue_small_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$eastern_yue_small_host_2","pt_eastern_yue_small_host"),
(assign,"$eastern_yue_small_host_3","$eastern_yue_small_host_2"),(val_sub,"$eastern_yue_small_host_3","$eastern_yue_small_host_1"),(val_mul,"$eastern_yue_small_host_3",5),
(val_add,"$quest_prestige","$eastern_yue_small_host_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$eastern_yue_host_1","pt_eastern_yue_host"),
(assign,"$eastern_yue_host_3","$eastern_yue_host_1"),(val_sub,"$eastern_yue_host_3","$eastern_yue_host_2"),(val_mul,"$eastern_yue_host_3",10),
(val_add,"$quest_prestige","$eastern_yue_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$eastern_yue_host_2","pt_eastern_yue_host"),
(assign,"$eastern_yue_host_3","$eastern_yue_host_2"),(val_sub,"$eastern_yue_host_3","$eastern_yue_host_1"),(val_mul,"$eastern_yue_host_3",10),
(val_add,"$quest_prestige","$eastern_yue_host_3")]],
#other
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$huang_jin_earth_host_1","pt_huang_jin_earth_host"),
(assign,"$huang_jin_earth_host_3","$huang_jin_earth_host_1"),(val_sub,"$huang_jin_earth_host_3","$huang_jin_earth_host_2"),(val_mul,"$huang_jin_earth_host_3",5),
(val_add,"$quest_prestige","$huang_jin_earth_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$huang_jin_earth_host_2","pt_huang_jin_earth_host"),
(assign,"$huang_jin_earth_host_3","$huang_jin_earth_host_2"),(val_sub,"$huang_jin_earth_host_3","$huang_jin_earth_host_1"),(val_mul,"$huang_jin_earth_host_3",5),
(val_add,"$quest_prestige","$huang_jin_earth_host_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$huang_jin_sky_host_1","pt_huang_jin_sky_host"),
(assign,"$huang_jin_sky_host_3","$huang_jin_sky_host_1"),(val_sub,"$huang_jin_sky_host_3","$huang_jin_sky_host_2"),(val_mul,"$huang_jin_sky_host_3",10),
(val_add,"$quest_prestige","$huang_jin_sky_host_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$huang_jin_sky_host_2","pt_huang_jin_sky_host"),
(assign,"$huang_jin_sky_host_3","$huang_jin_sky_host_2"),(val_sub,"$huang_jin_sky_host_3","$huang_jin_sky_host_1"),(val_mul,"$huang_jin_sky_host_3",10),
(val_add,"$quest_prestige","$huang_jin_sky_host_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$robbers_1","pt_robbers"),
(assign,"$robbers_3","$robbers_1"),(val_sub,"$robbers_3","$robbers_2"),(val_mul,"$robbers_3",5),
(val_add,"$quest_prestige","$robbers_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$robbers_2","pt_robbers"),
(assign,"$robbers_3","$robbers_2"),(val_sub,"$robbers_3","$robbers_1"),(val_mul,"$robbers_3",5),
(val_add,"$quest_prestige","$robbers_3")]],
#speacil army
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$tiger_1","pt_tiger"),
(assign,"$tiger_3","$tiger_1"),(val_sub,"$tiger_3","$tiger_2"),(val_mul,"$tiger_3",15),
(val_add,"$quest_prestige","$tiger_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$tiger_2","pt_tiger"),
(assign,"$tiger_3","$tiger_2"),(val_sub,"$tiger_3","$tiger_1"),(val_mul,"$tiger_3",15),
(val_add,"$quest_prestige","$tiger_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$armoured_troop_1","pt_armoured_troop"),
(assign,"$armoured_troop_3","$armoured_troop_1"),(val_sub,"$armoured_troop_3","$armoured_troop_2"),(val_mul,"$armoured_troop_3",15),
(val_add,"$quest_prestige","$armoured_troop_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$armoured_troop_2","pt_armoured_troop"),
(assign,"$armoured_troop_3","$armoured_troop_2"),(val_sub,"$armoured_troop_3","$armoured_troop_1"),(val_mul,"$armoured_troop_3",15),
(val_add,"$quest_prestige","$armoured_troop_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$western_liang_party_1","pt_western_liang_party"),
(assign,"$western_liang_party_3","$western_liang_party_1"),(val_sub,"$western_liang_party_3","$western_liang_party_2"),(val_mul,"$western_liang_party_3",15),
(val_add,"$quest_prestige","$western_liang_party_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$western_liang_party_2","pt_western_liang_party"),
(assign,"$western_liang_party_3","$western_liang_party_2"),(val_sub,"$western_liang_party_3","$western_liang_party_1"),(val_mul,"$western_liang_party_3",15),
(val_add,"$quest_prestige","$western_liang_party_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$silver_guard_1","pt_silver_guard"),
(assign,"$silver_guard_3","$silver_guard_1"),(val_sub,"$silver_guard_3","$silver_guard_2"),(val_mul,"$silver_guard_3",15),
(val_add,"$quest_prestige","$silver_guard_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$silver_guard_2","pt_silver_guard"),
(assign,"$silver_guard_3","$silver_guard_2"),(val_sub,"$silver_guard_3","$silver_guard_1"),(val_mul,"$silver_guard_3",15),
(val_add,"$quest_prestige","$silver_guard_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$forlorn_hope_party_1","pt_forlorn_hope_party"),
(assign,"$forlorn_hope_party_3","$forlorn_hope_party_1"),(val_sub,"$forlorn_hope_party_3","$forlorn_hope_party_2"),(val_mul,"$forlorn_hope_party_3",15),
(val_add,"$quest_prestige","$forlorn_hope_party_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$forlorn_hope_party_2","pt_forlorn_hope_party"),
(assign,"$forlorn_hope_party_3","$forlorn_hope_party_2"),(val_sub,"$forlorn_hope_party_3","$forlorn_hope_party_1"),(val_mul,"$forlorn_hope_party_3",15),
(val_add,"$quest_prestige","$forlorn_hope_party_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$horse_free_troop_1","pt_horse_free_troop"),
(assign,"$horse_free_troop_3","$horse_free_troop_1"),(val_sub,"$horse_free_troop_3","$horse_free_troop_2"),(val_mul,"$horse_free_troop_3",15),
(val_add,"$quest_prestige","$horse_free_troop_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$horse_free_troop_2","pt_horse_free_troop"),
(assign,"$horse_free_troop_3","$horse_free_troop_2"),(val_sub,"$horse_free_troop_3","$horse_free_troop_1"),(val_mul,"$horse_free_troop_3",15),
(val_add,"$quest_prestige","$horse_free_troop_3")]],





#########################################################################
# Random Governer Quest triggers
#########################################################################

# Enable nobleman's party 48 hours after the flag is set.
  (1.0, 48.0, 1.0,
   [
       (eq,"$nobleman_quest_nobleman_enable",1)
    ],
   [
       (assign,"$nobleman_quest_nobleman_active",1),
       (enable_party,"$nobleman_quest_party_id"),
       (assign,"$nobleman_quest_nobleman_enable",0),
    ]
   ),
# Stop nobleman's party every few hours
  (1.5, 0.0, 0.2,
   [
       (eq,"$nobleman_quest_nobleman_active",1)
    ],
   [
       (party_set_ai_behavior,"$nobleman_quest_party_id",ai_bhvr_hold),
    ]
   ),

  (0.9, 0, 0.2,
   [
       (eq,"$nobleman_quest_nobleman_active",1)
    ],
   [
       (party_set_ai_behavior,"$nobleman_quest_party_id",ai_bhvr_travel_to_party),
    ]
   ),
# Fail nobleman quest if he reaches target town
  (1.3, 0, 0.0,
   [
       (eq,"$nobleman_quest_nobleman_active",1),
       (party_is_in_town,"$nobleman_quest_party_id","$nobleman_quest_target_town")
    ],
   [
       (assign,"$nobleman_quest_failed",1),
       (assign,"$nobleman_quest_nobleman_active",0),
       (display_message,"str_nobleman_reached_destination"),
       (fail_quest,"qst_capture_nobleman"),
       (remove_party,"$nobleman_quest_party_id"),
    ]
   ),
# Fail nobleman quest if quest is completed but our 
  (0.1, 0.0, 0.0,
   [
       (eq,"$nobleman_quest_nobleman_active",1),
       (neg|main_party_has_troop,"trp_nobleman"),
       (neg|party_is_active,"$nobleman_quest_party_id")
    ],
   [
       (assign,"$nobleman_quest_failed",1),
       (fail_quest,"qst_capture_nobleman"),
       (assign,"$nobleman_quest_nobleman_active",0),
    ]
   ),
# Raiders quest
  (0.95, 0.0, 0.2,
   [
       (eq,"$raider_quest_active",1)
       ],
   [
       (party_set_ai_behavior,"$raider_quest_party_id",ai_bhvr_hold),
  ]),

  (0.7, 0, 0.2,
   [
       (eq,"$raider_quest_active",1)
    ],
   [
       (party_set_ai_behavior,"$raider_quest_party_id",ai_bhvr_travel_to_party),
    ]
   ),
  
  (0.1, 0.0, 0.0,
   [
       (eq,"$raider_quest_active",1),
       (neg|party_is_active,"$raider_quest_party_id")
    ],
   [
       (assign,"$raider_quest_succeeded",1),
       (assign,"$raider_quest_active",0)
    ]
   ),
  
  (1.3, 0, 0.0,
   [
       (eq,"$raider_quest_active",1),
       (party_is_in_town,"$raider_quest_party_id","$raider_quest_target_town")
    ],
   [
       (assign,"$raider_quest_failed",1),
       (assign,"$raider_quest_active",0),
       (display_message,"str_raiders_reached_base"),
       (fail_quest,"qst_hunt_down_raiders"),
       (remove_party,"$raider_quest_party_id"),
    ]
   ),
#relation
(0.0, 0.0, ti_once, [], [[assign,"$player_relation_to_kingdom_caowei", rel_neutral]]),
(0.0, 0.0, ti_once, [], [[assign,"$player_relation_to_kingdom_shuhan", rel_neutral]]),
(0.0, 0.0, ti_once, [], [[assign,"$player_relation_to_kingdom_wu", rel_neutral]]),
(0.0,0.0,ti_once,[],[(assign,"$quest_prestige",0)]),

# wages
  (1.0, 0, (7.0 * 24.0), [(eq,"$player_relation_to_kingdom_caowei",rel_ally)], [(val_add,"$wages","$weekly_wage")]),
  (1.0, 0, (7.0 * 24.0), [(eq,"$player_relation_to_kingdom_shuhan",rel_ally)], [(val_add,"$wages","$weekly_wage")]),
  (1.0, 0, (7.0 * 24.0), [(eq,"$player_relation_to_kingdom_wu",rel_ally)], [(val_add,"$wages","$weekly_wage")]),
  #AI gong cheng
  [168.0,0.0,0,[(lt,"$wei_guoli",50),(ge,"$shu_guoli",50),(store_random_in_range,"$gongji_chengshi_shu",towns_begin,towns_end),(eq,"$shu_active",0),
   (store_faction_of_party,reg4,"$gongji_chengshi_shu"),(eq,reg4,"fac_kingdom_caowei"),(call_script,"script_chengchi"),(gt,"$wei_chengchi",0)],[(spawn_around_party,"p_chengdu","pt_shu_gongcheng"),
                         (party_add_members,reg(0),"trp_shu_lieutenant",5),
                         (party_add_members,reg(0),"trp_shu_captain",3),
                         (party_add_members,reg(0),"trp_shu_main_flag_holder",6),
                         (party_add_members,reg(0),"trp_shu_unstopped_horseman",8),
                         (party_add_members,reg(0),"trp_yuan_rong_crossbowman",8),
                         (party_add_members,reg(0),"trp_shu_armed_horseman",8),
                         (party_add_members,reg(0),"trp_shu_ya_flag_holder",9),
                         (party_add_members,reg(0),"trp_elite_shu_infantry",12),
                         (party_add_members,reg(0),"trp_shu_strong_crossbowman",12),
                         (party_add_members,reg(0),"trp_shu_elite_horseman",12),
                         (party_add_members,reg(0),"trp_shu_jiao_flag_holder",12),
                         (party_add_members,reg(0),"trp_shu_infantry",16),
                         (party_add_members,reg(0),"trp_shu_archer_troop",16),
                         (party_add_members,reg(0),"trp_shu_horseman",16),
   (assign,"$gongchengbudui",reg(0)),
   (party_set_ai_behavior,"$gongchengbudui",ai_bhvr_attack_party),
   (party_set_ai_object,"$gongchengbudui","$gongji_chengshi_shu"),(assign,"$shu_active",1)]],
   [168.0,0.0,0,[(lt,"$wei_guoli",50),(ge,"$wu_guoli",50),(store_random_in_range,"$gongji_chengshi_wu",towns_begin,towns_end),(eq,"$wu_active",0),
   (store_faction_of_party,reg4,"$gongji_chengshi_wu"),(eq,reg4,"fac_kingdom_caowei"),(call_script,"script_chengchi"),(gt,"$wei_chengchi",0)],[(spawn_around_party,"p_jianye","pt_wu_gongcheng"),
                         (party_add_members,reg(0),"trp_wu_lieutenant",5),
                         (party_add_members,reg(0),"trp_wu_captain",3),
                         (party_add_members,reg(0),"trp_wu_main_flag_holder",6),
                         (party_add_members,reg(0),"trp_feather_army",8),
                         (party_add_members,reg(0),"trp_wu_five_troops_bowman",8),
                         (party_add_members,reg(0),"trp_wu_tiger_rider",8),
                         (party_add_members,reg(0),"trp_wu_ya_flag_holde",9),
                         (party_add_members,reg(0),"trp_wu_hard_army",12),
                         (party_add_members,reg(0),"trp_wu_elite_bowman",12),
                         (party_add_members,reg(0),"trp_wu_elite_rider",12),
                         (party_add_members,reg(0),"trp_wu_jiao_flag_holder",12),
                         (party_add_members,reg(0),"trp_wu_trouble_dealing_army",16),
                         (party_add_members,reg(0),"trp_wu_bowman",16),
                         (party_add_members,reg(0),"trp_wu_rider",16),
    (assign,"$gongchengbudui",reg(0)),
  (party_set_ai_behavior,"$gongchengbudui",ai_bhvr_attack_party),
  (party_set_ai_object,"$gongchengbudui","$gongji_chengshi_wu"),(assign,"$wu_active",1)]],

   [168.0,0.0,0,[(lt,"$shu_guoli",50),(ge,"$wei_guoli",50),(store_random_in_range,"$gongji_chengshi_wei",towns_begin,towns_end),(eq,"$wei_active",0),
   (store_faction_of_party,reg4,"$gongji_chengshi_wei"),(eq,reg4,"fac_kingdom_shuhan"),(call_script,"script_chengchi"),(gt,"$shu_chengchi",0)],[(spawn_around_party,"p_xuchang","pt_wei_gongcheng"),
                         (party_add_members,reg(0),"trp_wei_lieutenant",5),
                         (party_add_members,reg(0),"trp_wei_captain",3),
                         (party_add_members,reg(0),"trp_wei_main_flag_holder",6),
                         (party_add_members,reg(0),"trp_armored_guarder",8),
                         (party_add_members,reg(0),"trp_wei_heavy_bow_archer",8),
                         (party_add_members,reg(0),"trp_dragoon",8),
                         (party_add_members,reg(0),"trp_wei_ya_flag_holder",9),
                         (party_add_members,reg(0),"trp_wei_elite_footman",12),
                         (party_add_members,reg(0),"trp_wei_elite_archer",12),
                         (party_add_members,reg(0),"trp_wei_heavy_cavalry",12),
                         (party_add_members,reg(0),"trp_wei_jiao_flag_holder",12),
                         (party_add_members,reg(0),"trp_wei_footman",16),
                         (party_add_members,reg(0),"trp_wei_archer",16),
                         (party_add_members,reg(0),"trp_wei_light_cavalry",16),
    (assign,"$gongchengbudui",reg(0)),
  (party_set_ai_behavior,"$gongchengbudui",ai_bhvr_attack_party),
  (party_set_ai_object,"$gongchengbudui","$gongji_chengshi_wei"),(assign,"$wei_active",1)]],
   [168.0,0.0,0,[(lt,"$shu_guoli",50),(ge,"$wu_guoli",50),(store_random_in_range,"$gongji_chengshi_wu",towns_begin,towns_end),(eq,"$wu_active",0),
   (store_faction_of_party,reg4,"$gongji_chengshi_wu"),(eq,reg4,"fac_kingdom_shuhan"),(call_script,"script_chengchi"),(gt,"$shu_chengchi",0)],[(spawn_around_party,"p_jianye","pt_wu_gongcheng"),
                         (party_add_members,reg(0),"trp_wu_lieutenant",5),
                         (party_add_members,reg(0),"trp_wu_captain",3),
                         (party_add_members,reg(0),"trp_wu_main_flag_holder",6),
                         (party_add_members,reg(0),"trp_feather_army",8),
                         (party_add_members,reg(0),"trp_wu_five_troops_bowman",8),
                         (party_add_members,reg(0),"trp_wu_tiger_rider",8),
                         (party_add_members,reg(0),"trp_wu_ya_flag_holde",9),
                         (party_add_members,reg(0),"trp_wu_hard_army",12),
                         (party_add_members,reg(0),"trp_wu_elite_bowman",12),
                         (party_add_members,reg(0),"trp_wu_elite_rider",12),
                         (party_add_members,reg(0),"trp_wu_jiao_flag_holder",12),
                         (party_add_members,reg(0),"trp_wu_trouble_dealing_army",16),
                         (party_add_members,reg(0),"trp_wu_bowman",16),
                         (party_add_members,reg(0),"trp_wu_rider",16),
    (assign,"$gongchengbudui",reg(0)),
  (party_set_ai_behavior,"$gongchengbudui",ai_bhvr_attack_party),
  (party_set_ai_object,"$gongchengbudui","$gongji_chengshi_wu"),(assign,"$wu_active",1)]],

   [168.0,0.0,0,[(lt,"$wu_guoli",80),(ge,"$wei_guoli",50),(store_random_in_range,"$gongji_chengshi_wei",towns_begin,towns_end),(eq,"$wei_active",0),
   (store_faction_of_party,reg4,"$gongji_chengshi_wei"),(eq,reg4,"fac_kingdom_wu"),(call_script,"script_chengchi"),(gt,"$wu_chengchi",0)],[(spawn_around_party,"p_xuchang","pt_wei_gongcheng"),
                         (party_add_members,reg(0),"trp_wei_lieutenant",5),
                         (party_add_members,reg(0),"trp_wei_captain",3),
                         (party_add_members,reg(0),"trp_wei_main_flag_holder",6),
                         (party_add_members,reg(0),"trp_armored_guarder",8),
                         (party_add_members,reg(0),"trp_wei_heavy_bow_archer",8),
                         (party_add_members,reg(0),"trp_dragoon",8),
                         (party_add_members,reg(0),"trp_wei_ya_flag_holder",9),
                         (party_add_members,reg(0),"trp_wei_elite_footman",12),
                         (party_add_members,reg(0),"trp_wei_elite_archer",12),
                         (party_add_members,reg(0),"trp_wei_heavy_cavalry",12),
                         (party_add_members,reg(0),"trp_wei_jiao_flag_holder",12),
                         (party_add_members,reg(0),"trp_wei_footman",16),
                         (party_add_members,reg(0),"trp_wei_archer",16),
                         (party_add_members,reg(0),"trp_wei_light_cavalry",16),
   (assign,"$gongchengbudui",reg(0)),
  (party_set_ai_behavior,"$gongchengbudui",ai_bhvr_attack_party),
  (party_set_ai_object,"$gongchengbudui","$gongji_chengshi_wei"),(assign,"$wei_active",1)]],
   [168.0,0.0,0,[(lt,"$wu_guoli",80),(ge,"$shu_guoli",50),(store_random_in_range,"$gongji_chengshi_shu",towns_begin,towns_end),(eq,"$shu_active",0),
   (store_faction_of_party,reg4,"$gongji_chengshi_shu"),(eq,reg4,"fac_kingdom_wu"),(call_script,"script_chengchi"),(gt,"$wu_chengchi",0)],[(spawn_around_party,"p_chengdu","pt_shu_gongcheng"),
                         (party_add_members,reg(0),"trp_shu_lieutenant",5),
                         (party_add_members,reg(0),"trp_shu_captain",3),
                         (party_add_members,reg(0),"trp_shu_main_flag_holder",6),
                         (party_add_members,reg(0),"trp_shu_unstopped_horseman",8),
                         (party_add_members,reg(0),"trp_yuan_rong_crossbowman",8),
                         (party_add_members,reg(0),"trp_shu_armed_horseman",8),
                         (party_add_members,reg(0),"trp_shu_ya_flag_holder",9),
                         (party_add_members,reg(0),"trp_elite_shu_infantry",12),
                         (party_add_members,reg(0),"trp_shu_strong_crossbowman",12),
                         (party_add_members,reg(0),"trp_shu_elite_horseman",12),
                         (party_add_members,reg(0),"trp_shu_jiao_flag_holder",12),
                         (party_add_members,reg(0),"trp_shu_infantry",16),
                         (party_add_members,reg(0),"trp_shu_archer_troop",16),
                         (party_add_members,reg(0),"trp_shu_horseman",16),
    (assign,"$gongchengbudui",reg(0)),
  (party_set_ai_behavior,"$gongchengbudui",ai_bhvr_attack_party),
  (party_set_ai_object,"$gongchengbudui","$gongji_chengshi_shu"),(assign,"$shu_active",1)]],
(0.3,0,0,[(store_faction_of_party,reg6,"$gongji_chengshi_shu"),(eq,reg6,"fac_kingdom_shuhan")],[(party_set_ai_behavior,"pt_shu_gongcheng",ai_bhvr_travel_to_party),
  (party_set_ai_object,"pt_shu_gongcheng","p_chengdu")]),
(0.3,0,0,[(store_faction_of_party,reg6,"$gongji_chengshi_wei"),(eq,reg6,"fac_kingdom_caowei")],[(party_set_ai_behavior,"pt_wei_gongcheng",ai_bhvr_travel_to_party),
  (party_set_ai_object,"pt_wei_gongcheng","p_xuchang")]),
(0.3,0,0,[(store_faction_of_party,reg6,"$gongji_chengshi_wu"),(eq,reg6,"fac_kingdom_wu")],[(party_set_ai_behavior,"pt_wu_gongcheng",ai_bhvr_travel_to_party),
  (party_set_ai_object,"pt_wu_gongcheng","p_jianye")]),
 (0.1, 0.0, 0.0,
   [
       (eq,"$shu_active",1),
       (neg|party_is_active,"pt_shu_gongcheng")
    ],
   [
       (assign,"$shu_active",0),
    ]
   ),

    (0.1, 0.0, 0.0,
   [
       (eq,"$wei_active",1),
       (neg|party_is_active,"pt_wei_gongcheng")
    ],
   [
       (assign,"$wei_active",0),
    ]
   ),

    (0.1, 0.0, 0.0,
   [
       (eq,"$wu_active",1),
       (neg|party_is_active,"pt_wu_gongcheng")
    ],
   [
       (assign,"$wu_active",0),
    ]
   ),
 #zheng bing 
(2.0, 0, (1.0 * 24.0), [], 
  	[
        (try_for_range,reg(2), towns_begin, towns_end),
      	(store_random,reg(7),4),
      	(val_add,reg(7),1),
      	(store_faction_of_party, reg(11), reg(2)),
				(try_begin,0),
					(eq, reg(11), "fac_kingdom_caowei"),
					(store_random_in_range,reg(8),troop_wei_begin,troop_wei_end),
					(party_add_members,reg(2),reg(8),reg(7)),
				(else_try),
					(eq, reg(11), "fac_kingdom_shuhan"),
					(store_random_in_range,reg(8),troop_shu_begin,troop_shu_end),
					(party_add_members,reg(2),reg(8),reg(7)),
				(else_try),	
					(eq, reg(11), "fac_kingdom_wu"),
					(store_random_in_range,reg(8),troop_wu_begin,troop_wu_end),
					(party_add_members,reg(2),reg(8),reg(7)),
				(try_end,0),
			(try_end,0),
		]),
#guanzhi
  (2.0, 0.0, ti_once, [(eq,"$wuguan",1),(eq,"$faction_rank",6)], [(troop_raise_attribute, "trp_player",ca_strength,1),
        (troop_raise_attribute, "trp_player",ca_agility,1)]),
  (2.0, 0.0, ti_once, [(eq,"$wuguan",1),(eq,"$faction_rank",7)], [(troop_raise_attribute, "trp_player",ca_strength,1),
        (troop_raise_attribute, "trp_player",ca_agility,1)]),
  (2.0, 0.0, ti_once, [(eq,"$wuguan",1),(eq,"$faction_rank",8)], [(troop_raise_attribute, "trp_player",ca_strength,1),
        (troop_raise_attribute, "trp_player",ca_agility,1),(troop_raise_skill, "trp_player",skl_power_draw,1)]),
  (2.0, 0.0, ti_once, [(eq,"$wuguan",1),(eq,"$faction_rank",9)], [(troop_raise_attribute, "trp_player",ca_strength,1),
        (troop_raise_attribute, "trp_player",ca_agility,1),(troop_raise_skill, "trp_player",skl_ironflesh,1)]),
  (2.0, 0.0, ti_once, [(eq,"$wuguan",1),(eq,"$faction_rank",10)], [(troop_raise_attribute, "trp_player",ca_strength,1),
        (troop_raise_attribute, "trp_player",ca_agility,1),(troop_raise_skill, "trp_player",skl_athletics,2)]),
  (2.0, 0.0, ti_once, [(eq,"$wuguan",1),(eq,"$faction_rank",11)], [(troop_raise_attribute, "trp_player",ca_strength,1),
        (troop_raise_attribute, "trp_player",ca_agility,1),(troop_raise_skill, "trp_player",skl_leadership,2),(troop_raise_skill, "trp_player",skl_tactics,1)]),

  (2.0, 0.0, ti_once, [(eq,"$wenguan",1),(eq,"$faction_rank",6)], [(troop_raise_attribute, "trp_player",ca_intelligence,1),
        (troop_raise_attribute, "trp_player",ca_charisma,1),(troop_raise_skill, "trp_player",skl_pathfinding,1)]),
  (2.0, 0.0, ti_once, [(eq,"$wenguan",1),(eq,"$faction_rank",7)], [(troop_raise_attribute, "trp_player",ca_intelligence,1),
        (troop_raise_attribute, "trp_player",ca_charisma,1),(troop_raise_skill, "trp_player",skl_tracking,1)]),
  (1.0, 0.0, ti_once, [(eq,"$wenguan",1),(eq,"$faction_rank",8)], [(troop_raise_attribute, "trp_player",ca_intelligence,1),
        (troop_raise_attribute, "trp_player",ca_charisma,1),(troop_raise_skill, "trp_player",skl_spotting,1)]),
  (2.0, 0.0, ti_once, [(eq,"$wenguan",1),(eq,"$faction_rank",9)], [(troop_raise_attribute, "trp_player",ca_intelligence,1),
        (troop_raise_attribute, "trp_player",ca_charisma,1),(troop_raise_skill, "trp_player",skl_wound_treatment,1),(troop_raise_skill, "trp_player",skl_trade,5)]),
  (2.0, 0.0, ti_once, [(eq,"$wenguan",1),(eq,"$faction_rank",10)], [(troop_raise_attribute, "trp_player",ca_intelligence,1),
        (troop_raise_attribute, "trp_player",ca_charisma,1),(troop_raise_skill, "trp_player",skl_first_aid,1),(troop_raise_skill, "trp_player",skl_inventory_management,1)]),
  (2.0, 0.0, ti_once, [(eq,"$wenguan",1),(eq,"$faction_rank",11)], [(troop_raise_attribute, "trp_player",ca_intelligence,1),
        (troop_raise_attribute, "trp_player",ca_charisma,1),(troop_raise_skill, "trp_player",skl_leadership,1),(troop_raise_skill, "trp_player",skl_surgery,2)]),
# guoli start
 (0.0, 0.0, ti_once, [], [
 	(assign,"$wei_guoli", 150.0),
 	(assign,"$wu_guoli", 160.0),
 	(assign,"$shu_guoli", 160.0),
 	(assign,"$wei_guoli_raise", 0.3),
 	(assign,"$wu_guoli_raise", 0.3),
 	(assign,"$shu_guoli_raise", 0.3),
 	]),

 # guoli raise and display
 #wei
 (24.0, 0.0, 0, [(eq,"$wei_display",0)], [ (call_script,"script_chengchi"),
 	(try_begin),
 		(eq,"$wei_chengchi",0),
 		(display_message,"str_wei_wang"),
 		(assign,"$wei_display",1),
 		(assign,"$wei_guoli_level",0),
 		(assign,"$peak_wei_caravan",0),
 		(assign,"$peak_wei_recruit_party",0),
 		(assign,"$peak_wei_scout",0),
 		(assign,"$peak_wei_patrol",0),
              (assign,"$peak_tiger",0),
              (assign,"$peak_armoured_troop",0),
 	(else_try),
              (lt,"$wei_guoli",10),
 		(display_message,"str_wei_bingwang"),
 		(assign,"$wei_guoli_level",0),
 	(end_try),
 	(val_add,"$wei_guoli", "$wei_guoli_raise"),
 	(try_begin),
 		(ge,"$wei_guoli",180),
 		(assign,"$wei_guoli_level",5),
 		(display_message,"str_wei_qiangsheng"),
 	(else_try),
 		(ge,"$wei_guoli",120),
 		(assign,"$wei_guoli_level",4),
 		(display_message,"str_wei_fuqiang"),
 	(else_try), 
 		(ge,"$wei_guoli",80),
 		(assign,"$wei_guoli_level",3),
 		(display_message,"str_wei_yiban"),
 	(else_try), 
 		(ge,"$wei_guoli",50),
 		(assign,"$wei_guoli_level",2),
 		(display_message,"str_wei_xuruo"),
 	(else_try), 
 		(ge,"$wei_guoli",10),
 		(assign,"$wei_guoli_level",1),
 		(display_message,"str_wei_shuailuo"),
 	(end_try)]),
 #wu
(24.0, 0.0, 0, [(eq,"$wu_display",0)], [(call_script,"script_chengchi"),
 	(try_begin),
 		(eq,"$wu_chengchi",0),
 		(display_message,"str_wu_wang"),
 		(assign,"$wu_display",1),
 		(assign,"$wu_guoli_level",0),
 		(assign,"$peak_wu_caravan",0),
 		(assign,"$peak_wu_recruit_party",0),
 		(assign,"$peak_wu_scout",0),
 		(assign,"$peak_wu_patrol",0),
 		(assign,"$peak_forlorn_hope_party",0),
              (assign,"$peak_horse_free_troop",0),
 	(else_try),
 		(lt,"$wu_guoli",10),
 		(display_message,"str_wu_bingwang"),
 		(assign,"$wu_guoli_level",0),
 	(end_try),
 	(val_add,"$wu_guoli", "$wu_guoli_raise"),
 	(try_begin),
 		(ge,"$wu_guoli",180),
 		(assign,"$wu_guoli_level",5),
 		(display_message,"str_wu_qiangsheng"),
 	(else_try),
 		(ge,"$wu_guoli",120),
 		(assign,"$wu_guoli_level",4),
 		(display_message,"str_wu_fuqiang"),
 	(else_try), 
 		(ge,"$wu_guoli",80),
 		(assign,"$wu_guoli_level",3),
 		(display_message,"str_wu_yiban"),
 	(else_try), 
 		(ge,"$wu_guoli",50),
 		(assign,"$wu_guoli_level",2),
 		(display_message,"str_wu_xuruo"),
 	(else_try), 
 		(ge,"$wu_guoli",10),
 		(assign,"$wu_guoli_level",1),
 		(display_message,"str_wu_shuailuo"),
 	(end_try)]),
 #shu
(24.0, 0.0, 0, [(eq,"$shu_display",0)], [(call_script,"script_chengchi"),
 	(try_begin),
 		(eq,"$shu_chengchi",0),
 		(display_message,"str_shu_wang"),
 		(assign,"$shu_display",1),
 		(assign,"$shu_guoli_level",0),
 		(assign,"$peak_shu_caravan",0),
 		(assign,"$peak_shu_recruit_party",0),
 		(assign,"$peak_shu_scout",0),
 		(assign,"$peak_shu_patrol",0),
 		(assign,"$peak_western_liang_party",0),
              (assign,"$peak_silver_guard",0),
 	(else_try),
 		(lt,"$shu_guoli",10),
 		(display_message,"str_shu_bingwang"),
 		(assign,"$shu_guoli_level",0),
 	(end_try),
 	(val_add,"$shu_guoli", "$shu_guoli_raise"),
 	(try_begin),
 		(ge,"$shu_guoli",180),
 		(assign,"$shu_guoli_level",5),
 		(display_message,"str_shu_qiangsheng"),
 	(else_try),
 		(ge,"$shu_guoli",120),
 		(assign,"$shu_guoli_level",4),
 		(display_message,"str_shu_fuqiang"),
 	(else_try), 
 		(ge,"$shu_guoli",80),
 		(assign,"$shu_guoli_level",3),
 		(display_message,"str_shu_yiban"),
 	(else_try), 
 		(ge,"$shu_guoli",50),
 		(assign,"$shu_guoli_level",2),
 		(display_message,"str_shu_xuruo"),
 	(else_try), 
 		(ge,"$shu_guoli",10),
 		(assign,"$shu_guoli_level",1),
 		(display_message,"str_shu_shuailuo"),
 	(end_try)]),
 #fang chong fu ji suan
 (24.0,1.0,0.0,[],[
 	(assign,"$wei_guoli_raise", 0.3),
 	(assign,"$wu_guoli_raise", 0.3),
 	(assign,"$shu_guoli_raise", 0.3),
 	(assign,"$wei_chengchi", 0),
 	(assign,"$shu_chengchi", 0),
 	(assign,"$wu_chengchi", 0)]),
                         
 
 # army has killed,cut down gulli
  [2.0,0.0,0,[],[[store_num_parties_destroyed,"$wei_gongcheng","pt_wei_gongcheng"],(assign,"$wei_gongcheng_3","$wei_gongcheng_1"),(val_sub,"$wei_gongcheng_3","$wei_gongcheng_2"),
  (val_mul,"$wei_gongcheng_3",10),(val_sub,"$wei_guoli","$wei_gongcheng_3")]],
  [2.0,1.0,0,[],[[store_num_parties_destroyed,"$wei_gongcheng_2","pt_wei_gongcheng"],(assign,"$wei_gongcheng_3","$wei_gongcheng_2"),(val_sub,"$wei_gongcheng_3","$wei_gongcheng_1"),
  (val_mul,"$wei_gongcheng_3",10),(val_sub,"$wei_guoli","$wei_gongcheng_3")]],
   [2.0,0.0,0,[],[[store_num_parties_destroyed,"$shu_gongcheng_1","pt_shu_gongcheng"],(assign,"$shu_gongcheng_3","$shu_gongcheng_1"),(val_sub,"$shu_gongcheng_3","$shu_gongcheng_2"),
  (val_mul,"$shu_gongcheng_3",10),(val_sub,"$shu_guoli","$wei_gongcheng_3")]],
  [2.0,1.0,0,[],[[store_num_parties_destroyed,"$shu_gongcheng_2","pt_shu_gongcheng"],(assign,"$shu_gongcheng_3","$shu_gongcheng_2"),(val_sub,"$shu_gongcheng_3","$shu_gongcheng_1"),
  (val_mul,"$shu_gongcheng_3",10),(val_sub,"$shu_guoli","$shu_gongcheng_3")]],
  [2.0,0.0,0,[],[[store_num_parties_destroyed,"$wu_gongcheng_1","pt_wu_gongcheng"],(assign,"$wu_gongcheng_3","$wu_gongcheng_1"),(val_sub,"$wu_gongcheng_3","$wu_gongcheng_2"),
  (val_mul,"$wu_gongcheng_3",10),(val_sub,"$wu_guoli","$wu_gongcheng_3")]],
  [2.0,1.0,0,[],[[store_num_parties_destroyed,"$wu_gongcheng_2","pt_wu_gongcheng"],(assign,"$wu_gongcheng_3","$wu_gongcheng_2"),(val_sub,"$wu_gongcheng_3","$wu_gongcheng_1"),
  (val_mul,"$wu_gongcheng_3",10),(val_sub,"$wu_guoli","$wu_gongcheng_3")]],

 
  [2.0,0.0,0,[],[[store_num_parties_destroyed,"$wei_mie_qian_1","pt_wei_large_host"],(assign,"$wei_mie_qian_3","$wei_mie_qian_1"),(val_sub,"$wei_mie_qian_3","$wei_mie_qian_2"),
  (val_mul,"$wei_mie_qian_3",5),(val_sub,"$wei_guoli","$wei_mie_qian_3")]],
  [2.0,1.0,0,[],[[store_num_parties_destroyed,"$wei_mie_qian_2","pt_wei_large_host"],(assign,"$wei_mie_qian_3","$wei_mie_qian_2"),(val_sub,"$wei_mie_qian_3","$wei_mie_qian_1"),
  (val_mul,"$wei_mie_qian_3",5),(val_sub,"$wei_guoli","$wei_mie_qian_3")]],
   [2.0,0.0,0,[],[[store_num_parties_destroyed,"$shu_mie_qian_1","pt_shu_large_host"],(assign,"$shu_mie_qian_3","$shu_mie_qian_1"),(val_sub,"$shu_mie_qian_3","$shu_mie_qian_2"),
  (val_mul,"$shu_mie_qian_3",5),(val_sub,"$shu_guoli","$wei_mie_qian_3")]],
  [2.0,1.0,0,[],[[store_num_parties_destroyed,"$shu_mie_qian_2","pt_shu_large_host"],(assign,"$shu_mie_qian_3","$shu_mie_qian_2"),(val_sub,"$shu_mie_qian_3","$shu_mie_qian_1"),
  (val_mul,"$shu_mie_qian_3",5),(val_sub,"$shu_guoli","$shu_mie_qian_3")]],
  [2.0,0.0,0,[],[[store_num_parties_destroyed,"$wu_mie_qian_1","pt_wu_large_host"],(assign,"$wu_mie_qian_3","$wu_mie_qian_1"),(val_sub,"$wu_mie_qian_3","$wu_mie_qian_2"),
  (val_mul,"$wu_mie_qian_3",5),(val_sub,"$wu_guoli","$wu_mie_qian_3")]],
  [2.0,1.0,0,[],[[store_num_parties_destroyed,"$wu_mie_qian_2","pt_wu_large_host"],(assign,"$wu_mie_qian_3","$wu_mie_qian_2"),(val_sub,"$wu_mie_qian_3","$wu_mie_qian_1"),
  (val_mul,"$wu_mie_qian_3",5),(val_sub,"$wu_guoli","$wu_mie_qian_3")]],

  [2.0,0.0,0,[],[[store_num_parties_destroyed,"$wei_mie_wubai_1","pt_wei_host"],(assign,"$wei_mie_wubai_3","$wei_mie_wubai_1"),(val_sub,"$wei_mie_wubai_3","$wei_mie_wubai_2"),
  (val_mul,"$wei_mie_wubai_3",3),(val_sub,"$wei_guoli","$wei_mie_wubai_3")]],
  [2.0,1.0,0,[],[[store_num_parties_destroyed,"$wei_mie_wubai_2","pt_wei_host"],(assign,"$wei_mie_wubai_3","$wei_mie_wubai_2"),(val_sub,"$wei_mie_wubai_3","$wei_mie_wubai_1"),
  (val_mul,"$wei_mie_wubai_3",3),(val_sub,"$wei_guoli","$wei_mie_wubai_3")]],
   [2.0,0.0,0,[],[[store_num_parties_destroyed,"$shu_mie_wubai_1","pt_shu_host"],(assign,"$shu_mie_wubai_3","$shu_mie_wubai_1"),(val_sub,"$shu_mie_wubai_3","$shu_mie_wubai_2"),
  (val_mul,"$shu_mie_wubai_3",3),(val_sub,"$shu_guoli","$wei_mie_wubai_3")]],
  [2.0,1.0,0,[],[[store_num_parties_destroyed,"$shu_mie_wubai_2","pt_shu_host"],(assign,"$shu_mie_wubai_3","$shu_mie_wubai_2"),(val_sub,"$shu_mie_wubai_3","$shu_mie_wubai_1"),
  (val_mul,"$shu_mie_wubai_3",3),(val_sub,"$shu_guoli","$shu_mie_wubai_3")]],
  [2.0,0.0,0,[],[[store_num_parties_destroyed,"$wu_mie_wubai_1","pt_wu_host"],(assign,"$wu_mie_wubai_3","$wu_mie_wubai_1"),(val_sub,"$wu_mie_wubai_3","$wu_mie_wubai_2"),
  (val_mul,"$wu_mie_wubai_3",3),(val_sub,"$wu_guoli","$wu_mie_wubai_3")]],
  [2.0,1.0,0,[],[[store_num_parties_destroyed,"$wu_mie_wubai_2","pt_wu_host"],(assign,"$wu_mie_wubai_3","$wu_mie_wubai_2"),(val_sub,"$wu_mie_wubai_3","$wu_mie_wubai_1"),
  (val_mul,"$wu_mie_wubai_3",3),(val_sub,"$wu_guoli","$wu_mie_wubai_3")]],

   [2.0,0.0,0,[],[[store_num_parties_destroyed,"$wei_mie_bai_1","pt_wei_small_host"],(assign,"$wei_mie_bai_3","$wei_mie_bai_1"),(val_sub,"$wei_mie_bai_3","$wei_mie_bai_2"),
  (val_mul,"$wei_mie_bai_3",1),(val_sub,"$wei_guoli","$wei_mie_bai_3")]],
  [2.0,1.0,0,[],[[store_num_parties_destroyed,"$wei_mie_bai_2","pt_wei_small_host"],(assign,"$wei_mie_bai_3","$wei_mie_bai_2"),(val_sub,"$wei_mie_bai_3","$wei_mie_bai_1"),
  (val_mul,"$wei_mie_bai_3",1),(val_sub,"$wei_guoli","$wei_mie_bai_3")]],
   [2.0,0.0,0,[],[[store_num_parties_destroyed,"$shu_mie_bai_1","pt_shu_small_host"],(assign,"$shu_mie_bai_3","$shu_mie_bai_1"),(val_sub,"$shu_mie_bai_3","$shu_mie_bai_2"),
  (val_mul,"$shu_mie_bai_3",1),(val_sub,"$shu_guoli","$wei_mie_bai_3")]],
  [2.0,1.0,0,[],[[store_num_parties_destroyed,"$shu_mie_bai_2","pt_shu_small_host"],(assign,"$shu_mie_bai_3","$shu_mie_bai_2"),(val_sub,"$shu_mie_bai_3","$shu_mie_bai_1"),
  (val_mul,"$shu_mie_bai_3",1),(val_sub,"$shu_guoli","$shu_mie_bai_3")]],
  [2.0,0.0,0,[],[[store_num_parties_destroyed,"$wu_mie_bai_1","pt_wu_small_host"],(assign,"$wu_mie_bai_3","$wu_mie_bai_1"),(val_sub,"$wu_mie_bai_3","$wu_mie_bai_2"),
  (val_mul,"$wu_mie_bai_3",1),(val_sub,"$wu_guoli","$wu_mie_bai_3")]],
  [2.0,1.0,0,[],[[store_num_parties_destroyed,"$wu_mie_bai_2","pt_wu_small_host"],(assign,"$wu_mie_bai_3","$wu_mie_bai_2"),(val_sub,"$wu_mie_bai_3","$wu_mie_bai_1"),
  (val_mul,"$wu_mie_bai_3",1),(val_sub,"$wu_guoli","$wu_mie_bai_3")]],

[2.0,0.0,0.0,[],[(store_num_parties_destroyed,"$tiger_g_1","pt_tiger"),
(assign,"$tiger_g_3","$tiger_g_1"),(val_sub,"$tiger_g_3","$tiger_g_2"),(val_mul,"$tiger_g_3",4),
(val_sub,"$wei_guoli","$tiger_g_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed,"$tiger_g_2","pt_tiger"),
(assign,"$tiger_g_3","$tiger_g_2"),(val_sub,"$tiger_g_3","$tiger_g_1"),(val_mul,"$tiger_g_3",4),
(val_sub,"$wei_guoli","$tiger_g_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed,"$armoured_troop_g_1","pt_armoured_troop"),
(assign,"$armoured_troop_g_3","$armoured_troop_g_1"),(val_sub,"$armoured_troop_g_3","$armoured_troop_g_2"),(val_mul,"$armoured_troop_g_3",4),
(val_sub,"$wei_guoli","$armoured_troop_g_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed,"$armoured_troop_g_2","pt_armoured_troop"),
(assign,"$armoured_troop_g_3","$armoured_troop_g_2"),(val_sub,"$armoured_troop_g_3","$armoured_troop_g_1"),(val_mul,"$armoured_troop_g_3",4),
(val_sub,"$wei_guoli","$armoured_troop_g_3")]],

[2.0,0.0,0.0,[],[(store_num_parties_destroyed,"$western_liang_party_g_1","pt_western_liang_party"),
(assign,"$western_liang_party_g_3","$western_liang_party_g_1"),(val_sub,"$western_liang_party_g_3","$western_liang_party_g_2"),(val_mul,"$western_liang_party_g_3",4),
(val_sub,"$shu_guoli","$western_liang_party_g_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed,"$western_liang_party_g_2","pt_western_liang_party"),
(assign,"$western_liang_party_g_3","$western_liang_party_g_2"),(val_sub,"$western_liang_party_g_3","$western_liang_party_g_1"),(val_mul,"$western_liang_party_g_3",4),
(val_sub,"$shu_guoli","$western_liang_party_g_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed,"$silver_guard_g_1","pt_silver_guard"),
(assign,"$silver_guard_g_3","$silver_guard_g_1"),(val_sub,"$silver_guard_g_3","$silver_guard_g_2"),(val_mul,"$silver_guard_g_3",4),
(val_sub,"$shu_guoli","$silver_guard_g_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed,"$silver_guard_g_2","pt_silver_guard"),
(assign,"$silver_guard_g_3","$silver_guard_g_2"),(val_sub,"$silver_guard_g_3","$silver_guard_g_1"),(val_mul,"$silver_guard_g_3",4),
(val_sub,"$shu_guoli","$silver_guard_g_3")]],

[2.0,0.0,0.0,[],[(store_num_parties_destroyed,"$forlorn_hope_party_g_1","pt_forlorn_hope_party"),
(assign,"$forlorn_hope_party_g_3","$forlorn_hope_party_g_1"),(val_sub,"$forlorn_hope_party_g_3","$forlorn_hope_party_g_2"),(val_mul,"$forlorn_hope_party_g_3",4),
(val_sub,"$wu_guoli","$forlorn_hope_party_g_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed,"$forlorn_hope_party_g_2","pt_forlorn_hope_party"),
(assign,"$forlorn_hope_party_g_3","$forlorn_hope_party_g_2"),(val_sub,"$forlorn_hope_party_g_3","$forlorn_hope_party_g_1"),(val_mul,"$forlorn_hope_party_g_3",4),
(val_sub,"$wu_guoli","$forlorn_hope_party_g_3")]],
[2.0,0.0,0.0,[],[(store_num_parties_destroyed,"$horse_free_troop_g_1","pt_horse_free_troop"),
(assign,"$horse_free_troop_g_3","$horse_free_troop_g_1"),(val_sub,"$horse_free_troop_g_3","$horse_free_troop_g_2"),(val_mul,"$horse_free_troop_g_3",4),
(val_sub,"$wu_guoli","$horse_free_troop_g_3")]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed,"$horse_free_troop_g_2","pt_horse_free_troop"),
(assign,"$horse_free_troop_g_3","$horse_free_troop_g_2"),(val_sub,"$horse_free_troop_g_3","$horse_free_troop_g_1"),(val_mul,"$horse_free_troop_g_3",4),
(val_sub,"$wu_guoli","$horse_free_troop_g_3")]],
 #speacil army refresh
(0.0,0.0,ti_once,[],[(assign,"$peak_tiger",1),(assign,"$peak_armoured_troop",1),(assign,"$peak_western_liang_party",1),
(assign,"$peak_silver_guard",1),(assign,"$peak_forlorn_hope_party",1),(assign,"$peak_horse_free_troop",1)]),
  (5.1, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_caowei"),
                         (assign, "$pin_party_template", "pt_tiger"),
                         (assign, "$pin_limit", "$peak_tiger"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                         (try_begin),(main_party_has_troop,"trp_xuzhe"),
                         (party_remove_members,reg(0),"trp_xuzhe",1),(end_try)
                    ]),  
  
 (5.1, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_caowei"),
                         (assign, "$pin_party_template", "pt_armoured_troop"),
                         (assign, "$pin_limit", "$peak_armoured_troop"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                         (try_begin),(main_party_has_troop,"trp_dianwei"),
                         (party_remove_members,reg(0),"trp_dianwei",1),(end_try)
                    ]),  

 (5.1, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_shuhan"),
                         (assign, "$pin_party_template", "pt_western_liang_party"),
                         (assign, "$pin_limit", "$peak_western_liang_party"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                         (try_begin),(main_party_has_troop,"trp_machao"),
                         (party_remove_members,reg(0),"trp_machao",1),(end_try)
                    ]),  

 (5.1, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_shuhan"),
                         (assign, "$pin_party_template", "pt_silver_guard"),
                         (assign, "$pin_limit", "$peak_silver_guard"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                         (try_begin),(main_party_has_troop,"trp_zhaoyun"),
                         (party_remove_members,reg(0),"trp_zhaoyun",1),(end_try)
                    ]), 

  (5.1, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_wu"),
                         (assign, "$pin_party_template", "pt_forlorn_hope_party"),
                         (assign, "$pin_limit", "$peak_forlorn_hope_party"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                         (try_begin),(main_party_has_troop,"trp_ganning"),
                         (party_remove_members,reg(0),"trp_ganning",1),(end_try)
                    ]), 

  (5.1, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_wu"),
                         (assign, "$pin_party_template", "pt_horse_free_troop"),
                         (assign, "$pin_limit", "$peak_horse_free_troop"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                         (try_begin),(main_party_has_troop,"trp_huanggai"),
                         (party_remove_members,reg(0),"trp_huanggai",1),(end_try)
                    ]), 
   #other army refresh
   (8.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_headyellow"),
                         (assign, "$pin_party_template", "pt_huang_jin_group"),
                         (assign, "$pin_limit", 2),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                    ]), 
   (8.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_headyellow"),
                         (assign, "$pin_party_template", "pt_huang_jin_earth_host"),
                         (assign, "$pin_limit", 2),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                    ]), 
   (8.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_headyellow"),
                         (assign, "$pin_party_template", "pt_huang_jin_sky_host"),
                         (assign, "$pin_limit", 2),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                    ]), 
   (8.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_cateran"),
                         (assign, "$pin_party_template", "pt_moutain_bandits"),
                         (assign, "$pin_limit", 2),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                    ]),                  
   (8.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_cateran"),
                         (assign, "$pin_party_template", "pt_sea_bandits"),
                         (assign, "$pin_limit", 2),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                    ]),
   (6.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_hijacker"),
                         (assign, "$pin_party_template", "pt_robbers"),
                         (assign, "$pin_limit", 2),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                    ]),
     (10.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_southsavagery"),
                         (assign, "$pin_party_template", "pt_southern_man_small_host"),
                         (assign, "$pin_limit", 2),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                    ]),
     (10.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_southsavagery"),
                         (assign, "$pin_party_template", "pt_southern_man_host"),
                         (assign, "$pin_limit", 2),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                         (party_add_members,reg(0),"trp_southern_man_barbarian",30),
                    ]),
     (10.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_hun"),
                         (assign, "$pin_party_template", "pt_northern_xiong_nu_small_host"),
                         (assign, "$pin_limit", 2),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                    ]),
     (10.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_hun"),
                         (assign, "$pin_party_template", "pt_northern_xiong_nu_host"),
                         (assign, "$pin_limit", 2),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                         (party_add_members,reg(0),"trp_northern_xiong_nu_wrangler",30),
                    ]),
    (10.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_mountainsavagery"),
                         (assign, "$pin_party_template", "pt_eastern_yue_small_host"),
                         (assign, "$pin_limit", 2),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                    ]),
     (10.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_mountainsavagery"),
                         (assign, "$pin_party_template", "pt_eastern_yue_host"),
                         (assign, "$pin_limit", 2),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                         (party_add_members,reg(0),"trp_eastern_yue_refugee",30),
                    ]),
     (10.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_peasantry"),
                         (assign, "$pin_party_template", "pt_peasant"),
                         (assign, "$pin_limit", 2),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                    ]),
    (360,0,ti_once,[],[(assign,"$peak_charger_troop",1)]),
    (360,0,ti_once,[],[(assign,"$peak_white_horse_troop",1)]),
    (360,0,ti_once,[],[(assign,"$peak_crushing_troop",1)]),
     (5.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_defector"),
                         (assign, "$pin_party_template", "pt_charger_troop"),
                         (assign, "$pin_limit", "$peak_charger_troop"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                         (try_begin),(main_party_has_troop,"trp_gaoshun"),
                         (party_remove_members,reg(0),"trp_gaoshun",1),(end_try)]),
      (5.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_defector"),
                         (assign, "$pin_party_template", "pt_white_horse_troop"),
                         (assign, "$pin_limit", "$peak_white_horse_troop"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                         (try_begin),(main_party_has_troop,"trp_gongsunzan"),
                         (party_remove_members,reg(0),"trp_gongsunzan",1),(end_try)]),
      (5.0, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_force_defector"),
                         (assign, "$pin_party_template", "pt_crushing_troop"),
                         (assign, "$pin_limit", "$peak_crushing_troop"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                         (try_begin),(main_party_has_troop,"trp_yuanshao"),
                         (party_remove_members,reg(0),"trp_yuanshao",1),(end_try)]),
# refresh wei army
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wei_caravan",4)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wei_recruit_party",6)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wei_scout",6)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wei_patrol",10)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wei_small_host",2)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wei_host",1.8)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wei_large_host",1.5)]),
  (10.2, 0, 0.0, [],[(val_mul,"$peak_wei_small_host","$wei_guoli_level"),(val_mul,"$peak_wei_host","$wei_guoli_level"),(val_mul,"$peak_wei_large_host","$wei_guoli_level")]),
  (10.2,2,0.0,[],[(assign,"$peak_wei_small_host",2),(assign,"$peak_wei_host",1.8),(assign,"$peak_wei_large_host",1.5)]),
  (4.2, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_caowei"),
                         (assign, "$pin_party_template", "pt_wei_caravan"),
                         (assign, "$pin_limit", "$peak_wei_caravan"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_caowei"),
                         (party_set_ai_behavior,"$pout_party",ai_bhvr_travel_to_party),
                         (party_set_ai_object,"$pout_party","$pout_town"),
                    ]),
  (5.0, 0, 0, [(store_random_party_of_template, reg(2), "pt_wei_caravan"),
               (party_is_in_any_town,reg(2)),
               ],
              [
                  (assign, "$pin_faction","fac_kingdom_caowei"),
                  (call_script,"script_select_faction_town"),
                  (party_set_ai_behavior,reg(2),ai_bhvr_travel_to_party),
                  (party_set_ai_object,reg(2),"$pout_town"),
            ]),
  

  (10.2, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_caowei"),
                         (assign, "$pin_party_template", "pt_wei_recruit_party"),
                         (assign, "$pin_limit", "$peak_wei_recruit_party"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_caowei"),
                    ]),

  (10.2, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_caowei"),
                         (assign, "$pin_party_template", "pt_wei_scout"),
                         (assign, "$pin_limit", "$peak_wei_scout"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_caowei"),
                    ]),

  (10.2, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_caowei"),
                         (assign, "$pin_party_template", "pt_wei_patrol"),
                         (assign, "$pin_limit", "$peak_wei_patrol"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_caowei"),
						 (party_add_template, "$pout_party", "pt_wei_patrol_reinf_1"),
                    ]),

  (10.2, 1, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_caowei"),
                         (assign, "$pin_party_template", "pt_wei_small_host"),
                         (assign, "$pin_limit", "$peak_wei_small_host"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_caowei"),
						 (party_add_template, "$pout_party", "pt_wei_shost_reinf_1"),
                    ]),

 (10.2, 1, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_caowei"),
                         (assign, "$pin_party_template", "pt_wei_host"),
                         (assign, "$pin_limit", "$peak_wei_host"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_caowei"),
						 (party_add_template, "$pout_party", "pt_wei_host_reinf_1"),
						 (party_add_template, "$pout_party", "pt_wei_host_reinf_2"),
                    ]),
 (10.2, 1, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_caowei"),
                         (assign, "$pin_party_template", "pt_wei_large_host"),
                         (assign, "$pin_limit", "$peak_wei_large_host"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_caowei"),
						 (party_add_template, "$pout_party", "pt_wei_lhost_reinf_1"),
						 (party_add_template, "$pout_party", "pt_wei_lhost_reinf_2"),
						 (party_add_template, "$pout_party", "pt_wei_lhost_reinf_3"),
                    ]),                   

#refresh shu army
  (0.0, 0.0, ti_once, [], [(assign,"$peak_shu_caravan",4)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_shu_recruit_party",6)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_shu_scout",6)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_shu_patrol",10)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_shu_small_host",2)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_shu_host",1.8)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_shu_large_host",1.5)]),
  (10.2, 0, 0.0, [],[(val_mul,"$peak_shu_small_host","$shu_guoli_level"),(val_mul,"$peak_shu_host","$shu_guoli_level"),(val_mul,"$peak_shu_large_host","$shu_guoli_level")]),
  (10.2,2,0.0,[],[(assign,"$peak_shu_small_host",2),(assign,"$peak_shu_host",1.8),(assign,"$peak_shu_large_host",1.5)]),
  (4.2, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_shuhan"),
                         (assign, "$pin_party_template", "pt_shu_caravan"),
                         (assign, "$pin_limit", "$peak_shu_caravan"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
                         (party_set_ai_behavior,"$pout_party",ai_bhvr_travel_to_party),
						 (party_set_faction,"$pout_party","fac_kingdom_shuhan"),
                         (party_set_ai_object,"$pout_party","$pout_town"),
                    ]),
  (5.0, 0, 0, [(store_random_party_of_template, reg(2), "pt_shu_caravan"),
               (party_is_in_any_town,reg(2)),
               ],
              [
                  (assign, "$pin_faction","fac_kingdom_shuhan"),
                  (call_script,"script_select_faction_town"),
                  (party_set_ai_behavior,reg(2),ai_bhvr_travel_to_party),
                  (party_set_ai_object,reg(2),"$pout_town"),
            ]),
  

  (10.2, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_shuhan"),
                         (assign, "$pin_party_template", "pt_shu_recruit_party"),
                         (assign, "$pin_limit", "$peak_shu_recruit_party"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_shuhan"),
			]),

  (10.2, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_shuhan"),
                         (assign, "$pin_party_template", "pt_shu_scout"),
                         (assign, "$pin_limit", "$peak_shu_scout"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_shuhan"),
                    ]),

  (10.2, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_shuhan"),
                         (assign, "$pin_party_template", "pt_shu_patrol"),
                         (assign, "$pin_limit", "$peak_shu_patrol"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_shuhan"),
						 (party_add_template, "$pout_party", "pt_shu_patrol_reinf_1"),
                    ]),

  (10.2, 1, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_shuhan"),
                         (assign, "$pin_party_template", "pt_shu_small_host"),
                         (assign, "$pin_limit", "$peak_shu_small_host"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_shuhan"),
						 (party_add_template, "$pout_party", "pt_shu_shost_reinf_1"),
                    ]),

 (10.2, 1, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_shuhan"),
                         (assign, "$pin_party_template", "pt_shu_host"),
                         (assign, "$pin_limit", "$peak_shu_host"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_shuhan"),
						 (party_add_template, "$pout_party", "pt_shu_host_reinf_1"),
						 (party_add_template, "$pout_party", "pt_shu_host_reinf_2"),
                    ]),
 (10.2, 1, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_shuhan"),
                         (assign, "$pin_party_template", "pt_shu_large_host"),
                         (assign, "$pin_limit", "$peak_shu_large_host"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_shuhan"),
						 (party_add_template, "$pout_party", "pt_shu_lhost_reinf_1"),
						 (party_add_template, "$pout_party", "pt_shu_lhost_reinf_2"),
						 (party_add_template, "$pout_party", "pt_shu_lhost_reinf_3"),
                    ]),  
 #refresh wu army
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wu_caravan",4)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wu_recruit_party",6)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wu_scout",6)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wu_patrol",10)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wu_small_host",2)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wu_host",1.8)]),
  (0.0, 0.0, ti_once, [], [(assign,"$peak_wu_large_host",1.5)]),
  (10.2, 0, 0.0, [],[(val_mul,"$peak_wu_small_host","$wu_guoli_level"),(val_mul,"$peak_wu_host","$wu_guoli_level"),(val_mul,"$peak_wu_large_host","$wu_guoli_level")]),
  (10.2,2,0.0,[],[(assign,"$peak_wu_small_host",2),(assign,"$peak_wu_host",1.8),(assign,"$peak_wu_large_host",1.5)]),
  (4.2, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_wu"),
                         (assign, "$pin_party_template", "pt_wu_caravan"),
                         (assign, "$pin_limit", "$peak_wu_caravan"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_wu"),
                         (party_set_ai_behavior,"$pout_party",ai_bhvr_travel_to_party),
                         (party_set_ai_object,"$pout_party","$pout_town"),
                    ]),
  (5.0, 0, 0, [(store_random_party_of_template, reg(2), "pt_wu_caravan"),
               (party_is_in_any_town,reg(2)),
               ],
              [
                  (assign, "$pin_faction","fac_kingdom_wu"),
                  (call_script,"script_select_faction_town"),
                  (party_set_ai_behavior,reg(2),ai_bhvr_travel_to_party),
                  (party_set_ai_object,reg(2),"$pout_town"),
            ]),
  
  (2.0, 0, 0.0, [(eq, "$caravan_escort_state", 1),
                 (get_party_ai_object,reg(1),"$caravan_escort_party_id"),
                 (neq,reg(1),"$caravan_escort_destination_town"),
                ],
                     [(assign,"$caravan_escort_state",0),
                      (add_xp_as_reward,100),
                      ]),
  (10.2, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_wu"),
                         (assign, "$pin_party_template", "pt_wu_recruit_party"),
                         (assign, "$pin_limit", "$peak_wu_recruit_party"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_wu"),
                    ]),

  (10.2, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_wu"),
                         (assign, "$pin_party_template", "pt_wu_scout"),
                         (assign, "$pin_limit", "$peak_wu_scout"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_wu"),
                    ]),

  (10.2, 0, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_wu"),
                         (assign, "$pin_party_template", "pt_wu_patrol"),
                         (assign, "$pin_limit", "$peak_wu_patrol"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_wu"),
						 (party_add_template, "$pout_party", "pt_wu_patrol_reinf_1"),
                    ]),

  (10.2, 1, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_wu"),
                         (assign, "$pin_party_template", "pt_wu_small_host"),
                         (assign, "$pin_limit", "$peak_wu_small_host"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_wu"),
						 (party_add_template, "$pout_party", "pt_wu_shost_reinf_1"),
                    ]),

 (10.2, 1, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_wu"),
                         (assign, "$pin_party_template", "pt_wu_host"),
                         (assign, "$pin_limit", "$peak_wu_host"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_wu"),
						 (party_add_template, "$pout_party", "pt_wu_host_reinf_1"),
						 (party_add_template, "$pout_party", "pt_wu_host_reinf_2"),
                    ]),
 (10.2, 1, 0.0, [],
                     [
                         (assign, "$pin_faction", "fac_kingdom_wu"),
                         (assign, "$pin_party_template", "pt_wu_large_host"),
                         (assign, "$pin_limit", "$peak_wu_large_host"),
                         (call_script,"script_spawn_party_at_faction_town_if_below_limit"),
						 (party_set_faction,"$pout_party","fac_kingdom_wu"),
						 (party_add_template, "$pout_party", "pt_wu_lhost_reinf_1"),
						 (party_add_template, "$pout_party", "pt_wu_lhost_reinf_2"),
						 (party_add_template, "$pout_party", "pt_wu_lhost_reinf_3"),
                    ]), 
#zhanyi start 
#initatialize & day counter
	(0,0,ti_once,[],
		[
			(assign,"$chibi",0),
			(assign,"$hefei",0),
			(store_current_day,"$init_day"),
			(assign,"$day_counter",0),
			(assign,"$zhanyi_inited",1),
		]
	),
	(6.0,0,0,[(eq,"$zhanyi_inited",1)],
		[
			(store_current_day,":current_day"),
			(val_sub,":current_day","$init_day"),
			(assign,"$day_counter",":current_day"),
		]
	),
 #chibi begin
	(6.0, 0, 0, 
		[
			(eq,"$chibi",0),
			(ge,"$day_counter",setting_interval_chibi),
			(ge,"$wei_guoli_level",1),
			(ge,"$shu_guoli_level",1),
			(ge,"$wu_guoli_level",1)
		],
# chibi init	
		[
			(call_script,"script_diplomacy_start_peace_between_kingdoms","fac_kingdom_wu","fac_kingdom_shuhan"),
			(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_caowei","fac_kingdom_shuhan"),
			(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_caowei","fac_kingdom_wu"),
#	 (store_relation,reg(0),"fac_kingdom_wu","fac_kingdom_shuhan"),
#        (val_max,reg(0),20),
#        (set_relation,"fac_kingdom_wu","fac_kingdom_shuhan", reg(0)),
			(display_message,"str_chibi"),
			(display_message,"str_shu_wu"),
			
			(assign,"$chibi_wei",0),
			(assign,"$chibi_shu",0),
			(assign,"$chibi_wu",0),
			
			(assign,"$war_town","p_bf_chibi"),
			(assign,"$chibi",1),
			]
	),
#chibi flash pt
	(1.0, 0.0, 0,
		[
			(eq,"$chibi",1),
		],
		[
			(store_num_parties_of_template, "$num_chibi_wei_war_party", "pt_wei_war_party"),
			(try_begin),				
				(eq,"$chibi_wei",0),
				(lt,"$num_chibi_wei_war_party",8),
				(set_spawn_radius,1),
				(spawn_around_party,"p_salt_mine","pt_wei_war_party"),  
				(party_add_template, reg0, "pt_wei_war_reinf_1"),
				(party_add_template, reg0, "pt_wei_war_reinf_2"),
				(party_add_template, reg0, "pt_wei_war_reinf_3"),
				(assign, "$wei_war_party", reg(0)),
				(party_set_faction,"$wei_war_party","fac_kingdom_caowei"),
				(call_script,"script_party_set_ai_state","$wei_war_party",spai_patrolling_around_center,"p_bf_chibi"),
				#(party_set_ai_behavior,"$wei_war_party",ai_bhvr_patrol_party),        
				#(party_set_ai_object,"$wei_war_party","p_bf_chibi"),
			(else_try),
				(assign,"$chibi_wei",1),
			(try_end),
			(store_num_parties_of_template, "$num_chibi_shu_war_party", "pt_shu_war_party"),
			(try_begin),
				(eq,"$chibi_shu",0),
				(lt,"$num_chibi_shu_war_party",4),
				(set_spawn_radius,1),
				(spawn_around_party,"p_castle_8","pt_shu_war_party"),  
				(party_add_template, reg0, "pt_shu_war_reinf_1"),
				(party_add_template, reg0, "pt_shu_war_reinf_2"),
				(party_add_template, reg0, "pt_shu_war_reinf_3"),
				(assign, "$shu_war_party", reg(0)),
				(party_set_faction,"$shu_war_party","fac_kingdom_shuhan"),
				#(party_set_ai_behavior,"$shu_war_party",ai_bhvr_patrol_party),        
				#(party_set_ai_object,"$shu_war_party","p_bf_chibi"),
				(call_script,"script_party_set_ai_state","$shu_war_party",spai_patrolling_around_center,"p_bf_chibi"),
			(else_try),
				(assign,"$chibi_shu",1),
			(try_end),
			(store_num_parties_of_template, "$num_chibi_wu_war_party", "pt_wu_war_party"),
			(try_begin),
				(eq,"$chibi_wu",0),
				(lt,"$num_chibi_wei_war_party",5),			
				(set_spawn_radius,1),
				(spawn_around_party,"p_castle_8","pt_wu_war_party"),  
				(party_add_template, reg0, "pt_wu_war_reinf_1"),
				(party_add_template, reg0, "pt_wu_war_reinf_2"),
				(party_add_template, reg0, "pt_wu_war_reinf_3"),
				(assign, "$wu_war_party", reg(0)),
				(party_set_faction,"$wu_war_party","fac_kingdom_wu"),
				(call_script,"script_party_set_ai_state","$wu_war_party",spai_patrolling_around_center,"p_bf_chibi"),
				#(party_set_ai_behavior,"$wu_war_party",ai_bhvr_patrol_party),        
				#(party_set_ai_object,"$wu_war_party","p_bf_chibi"),
			(else_try),
				(assign,"$chibi_wu",1),
			(try_end),
		]
	),
#chibi finish
	(6.0,0.0,0,
		[
			(eq,"$chibi",1),
		],
		[
			(try_begin),
				(eq,"$chibi_wei",1),
				(store_num_parties_of_template,"$num_chibi_wei_war_party", "pt_wei_war_party"),
				(try_begin),
					(eq,"$num_chibi_wei_war_party",0),
					(display_message,"str_wei_bai_chibi"),
					(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_wu","fac_kingdom_shuhan"),
					(display_message,"str_guanxi"),
					(val_sub,"$wei_guoli",80),
					(val_add,"$shu_guoli",40),
					(val_add,"$wu_guoli",40),
					(call_script,"script_remove_war_party"),
					(assign,"$chibi",2),
					(assign,"$zhanyi_inited",0),
					(store_current_day,"$init_day"),
					(assign,"$day_counter",0),
					(assign,"$zhanyi_inited",1),
				(try_end),
			(else_try),
				(eq,"$chibi_shu",1),
				(eq,"$chibi_wu",1),
				(store_num_parties_of_template,"$num_chibi_shu_war_party", "pt_shu_war_party"),				
				(store_num_parties_of_template,"$num_chibi_wu_war_party", "pt_wu_war_party"),
				(try_begin),
					(eq,"$num_chibi_wu_war_party",0),
					(eq,"$num_chibi_shu_war_party",0),
					(display_message,"str_shuwu_bai_chibi"),
					(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_wu","fac_kingdom_shuhan"),
					(display_message,"str_guanxi"),
					(val_sub,"$wu_guoli",60),
					(val_sub,"$shu_guoli",50),
					(val_add,"$wei_guoli",40),
					(call_script,"script_remove_war_party"),
					(assign,"$chibi",2),
					(assign,"$zhanyi_inited",0),
					(store_current_day,"$init_day"),
					(assign,"$day_counter",0),
					(assign,"$zhanyi_inited",1),
				(try_end),
			(try_end),
		]
	),


#hefei start
	(6.0, 0, 0, 
		[
			(eq,"$hefei",0),
			(ge,"$day_counter",setting_interval_hefei),
			(ge,"$wei_guoli_level",1),
			(ge,"$wu_guoli_level",1),
			#(ge,"$shu_guoli_level",1),
			(eq,"$chibi",2)
		],
		[
			(call_script,"script_diplomacy_start_peace_between_kingdoms","fac_kingdom_wu","fac_kingdom_shuhan"),
			(call_script,"script_diplomacy_start_peace_between_kingdoms","fac_kingdom_caowei","fac_kingdom_shuhan"),
			(display_message,"str_hefei"),
			(display_message,"str_shu"),
			(assign,"$war_town","p_hefei"),
			(assign,"$hefei_wei",0),
			(assign,"$hefei",1),
	]),
#hefei flash pt
	[1.0, 0.0, 0, 
		[
			(eq,"$hefei",1),
			
		],   
		[
			(store_num_parties_of_template, "$num_hefei_wei_war_party", "pt_wei_war_party"),
			(try_begin),
				(lt,"$num_hefei_wei_war_party",7),
				(eq,"$hefei_wei",0),
				(set_spawn_radius,1),
				(spawn_around_party,"p_hefei","pt_wei_war_party"), 
				(party_add_template, reg0, "pt_wei_war_reinf_1"),
				(party_add_template, reg0, "pt_wei_war_reinf_2"),
				(party_add_template, reg0, "pt_wei_war_reinf_3"),
				(assign, "$wei_war_party", reg(0)),
				(party_set_faction,"$wei_war_party","fac_kingdom_caowei"),
				(call_script,"script_party_set_ai_state","$wei_war_party",spai_besieging_center,"p_hefei"),
			(else_try),
				(ge,"$num_hefei_wei_war_party",7),
				(assign,"$hefei_wei",1),
			(try_end),
			(store_num_parties_of_template, "$num_hefei_wu_war_party", "pt_wu_war_party"),
			(try_begin),
				(lt,"$num_hefei_wu_war_party",6),
				(eq,"$hefei_wu",0),
				(set_spawn_radius,1),
				(spawn_around_party,"p_jianye","pt_wu_war_party"),  
				(party_add_template, reg0, "pt_wu_war_reinf_1"),
				(party_add_template, reg0, "pt_wu_war_reinf_2"),
				(party_add_template, reg0, "pt_wu_war_reinf_3"),
				(assign, "$wu_war_party", reg(0)),
				(party_set_faction,"$wu_war_party","fac_kingdom_wu"),
				(call_script,"script_party_set_ai_state","$wu_war_party",spai_besieging_center,"p_hefei"),
			(else_try),
				(ge,"$num_hefei_wu_war_party",6),
				(assign,"$hefei_wu",1),
			(try_end),
	    ]
	],
#hefei finish
	(1.0,0.0,0,
		[			
			(eq,"$hefei",1),
		],
		[
			(store_num_parties_of_template,"$num_hefei_wei_war_party", "pt_wei_war_party"),
			(store_num_parties_of_template,"$num_chibi_wu_war_party", "pt_wu_war_party"),
			(try_begin),
				(eq,"$hefei_wei",1),
				(eq,"$num_hefei_wei_war_party",0),
				(display_message,"str_wei_bai_hefei"),
				(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_caowei","fac_kingdom_shuhan"),
				(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_wu","fac_kingdom_shuhan"),
				(display_message,"str_guanxi"),
				(val_sub,"$wei_guoli",60),
				(val_add,"$wu_guoli",40),
				(call_script,"script_remove_war_party"),
				(assign,"$hefei",2),
				(assign,"$zhanyi_inited",0),
				(store_current_day,"$init_day"),
				(assign,"$day_counter",0),
				(assign,"$zhanyi_inited",1),
			(else_try),
				(eq,"$hefei_wu",1),
				(eq,"$num_hefei_wu_war_party",0),
				(display_message,"str_wu_bai_hefei"),
				(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_caowei","fac_kingdom_shuhan"),
				(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_wu","fac_kingdom_shuhan"),
				(display_message,"str_guanxi"),
				(val_sub,"$wu_guoli",80),
				(val_add,"$wei_guoli",40),
				(call_script,"script_remove_war_party"),
				(assign,"$hefei",2),
				(assign,"$zhanyi_inited",0),
				(store_current_day,"$init_day"),
				(assign,"$day_counter",0),
				(assign,"$zhanyi_inited",1),
			(try_end),
		]
	),

 #yiling begin
	(6.0, 0, 0, 
		[
			(eq,"$yiling",0),
			(ge,"$day_counter",setting_interval_yiling),
			#(ge,"$wei_guoli_level",1),
			(ge,"$shu_guoli_level",1),
			(ge,"$wu_guoli_level",1),
			(eq,"$hefei",2),
		],
# yiling init	
		[
			(call_script,"script_diplomacy_start_peace_between_kingdoms","fac_kingdom_wu","fac_kingdom_caowei"),
			(call_script,"script_diplomacy_start_peace_between_kingdoms","fac_kingdom_shuhan","fac_kingdom_caowei"),#	 (store_relation,reg(0),"fac_kingdom_wu","fac_kingdom_shuhan"),
#        (val_max,reg(0),20),
#        (set_relation,"fac_kingdom_wu","fac_kingdom_shuhan", reg(0)),
			(display_message,"str_yiling"),
			(display_message,"str_wei"),
			
			(assign,"$yiling_shu",0),
			(assign,"$yiling_wu",0),
			
			(assign,"$war_town","p_yiling"),
			(assign,"$yiling",1),
			]
	),
#yiling flash pt
	(1.0, 0.0, 0,
		[
			(eq,"$yiling",1),
		],
		[
			(store_num_parties_of_template, "$num_yiling_shu_war_party", "pt_shu_war_party"),
			(try_begin),
				(eq,"$yiling_shu",0),
				(lt,"$num_yiling_shu_war_party",7),
				(set_spawn_radius,1),
				(spawn_around_party,"p_yongan","pt_shu_war_party"),  
				(party_add_template, reg0, "pt_shu_war_reinf_1"),
				(party_add_template, reg0, "pt_shu_war_reinf_2"),
				(party_add_template, reg0, "pt_shu_war_reinf_3"),
				(assign, "$shu_war_party", reg(0)),
				(party_set_faction,"$shu_war_party","fac_kingdom_shuhan"),
				#(party_set_ai_behavior,"$shu_war_party",ai_bhvr_patrol_party),        
				#(party_set_ai_object,"$shu_war_party","p_bf_yiling"),
				(call_script,"script_party_set_ai_state","$shu_war_party",spai_besieging_center,"p_yiling"),
			(else_try),
				(assign,"$yiling_shu",1),
			(try_end),
			(store_num_parties_of_template, "$num_yiling_wu_war_party", "pt_wu_war_party"),
			(try_begin),
				(eq,"$yiling_wu",0),
				(lt,"$num_yiling_wu_war_party",8),			
				(set_spawn_radius,1),
				(spawn_around_party,"p_yiling","pt_wu_war_party"),  
				(party_add_template, reg0, "pt_wu_war_reinf_1"),
				(party_add_template, reg0, "pt_wu_war_reinf_2"),
				(party_add_template, reg0, "pt_wu_war_reinf_3"),
				(assign, "$wu_war_party", reg(0)),
				(party_set_faction,"$wu_war_party","fac_kingdom_wu"),
				(call_script,"script_party_set_ai_state","$wu_war_party",spai_besieging_center,"p_yiling"),
				#(party_set_ai_behavior,"$wu_war_party",ai_bhvr_patrol_party),        
				#(party_set_ai_object,"$wu_war_party","p_bf_yiling"),
			(else_try),
				(assign,"$yiling_wu",1),
			(try_end),
		]
	),
#yiling finish
	(6.0,0.0,0,
		[
			(eq,"$yiling",1),
		],
		[
			(store_num_parties_of_template,"$num_yiling_shu_war_party", "pt_shu_war_party"),				
			(store_num_parties_of_template,"$num_yiling_wu_war_party", "pt_wu_war_party"),
			(try_begin),
				(eq,"$yiling_shu",1),
				(try_begin),
					(eq,"$num_yiling_shu_war_party",0),
					(display_message,"str_shu_bai_yiling"),
					(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_wu","fac_kingdom_caowei"),
					(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_shuhan","fac_kingdom_caowei"),
					(display_message,"str_guanxi"),
					(val_sub,"$shu_guoli",80),
					(val_add,"$wu_guoli",40),
					(call_script,"script_remove_war_party"),
					(assign,"$yiling",2),
					(assign,"$zhanyi_inited",0),
					(store_current_day,"$init_day"),
					(assign,"$day_counter",0),
					(assign,"$zhanyi_inited",1),
				(try_end),
			(else_try),				
				(eq,"$yiling_wu",1),
				(try_begin),
					(eq,"$num_yiling_wu_war_party",0),
					(display_message,"str_wu_bai_yiling"),
					(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_wu","fac_kingdom_caowei"),
					(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_shuhan","fac_kingdom_caowei"),
					(display_message,"str_guanxi"),
					(val_add,"$shu_guoli",40),
					(val_sub,"$wu_guoli",60),
					(call_script,"script_remove_war_party"),
					(assign,"$yiling",2),
					(assign,"$zhanyi_inited",0),
					(store_current_day,"$init_day"),
					(assign,"$day_counter",0),
					(assign,"$zhanyi_inited",1),
				(try_end),
			(try_end),
		]
	),
 #wuzhangyuan begin
	(6.0, 0, 0, 
		[
			(eq,"$wuzhangyuan",0),
			(ge,"$day_counter",setting_interval_wuzhangyuan),
			(ge,"$wei_guoli_level",1),
			(ge,"$shu_guoli_level",1),
			#(ge,"$wu_guoli_level",1)
			(eq,"$yiling",2),
		],
# wuzhangyuan init	
		[
			(call_script,"script_diplomacy_start_peace_between_kingdoms","fac_kingdom_wu","fac_kingdom_shuhan"),
			(call_script,"script_diplomacy_start_peace_between_kingdoms","fac_kingdom_wu","fac_kingdom_caowei"),#	 (store_relation,reg(0),"fac_kingdom_wu","fac_kingdom_shuhan"),
#        (val_max,reg(0),20),
#        (set_relation,"fac_kingdom_wu","fac_kingdom_shuhan", reg(0)),
			(display_message,"str_wuzhangyuan"),
			(display_message,"str_wu"),
			
			(assign,"$wuzhangyuan_shu",0),
			(assign,"$wuzhangyuan_wei",0),
			
			(assign,"$war_town","p_bf_wuzhangyuan"),
			(assign,"$wuzhangyuan",1),
			]
	),
#wuzhangyuan flash pt
	(1.0, 0.0, 0,
		[
			(eq,"$wuzhangyuan",1),
		],
		[
			(store_num_parties_of_template, "$num_wuzhangyuan_shu_war_party", "pt_shu_war_party"),
			(try_begin),
				(eq,"$wuzhangyuan_shu",0),
				(lt,"$num_wuzhangyuan_shu_war_party",7),
				(set_spawn_radius,1),
				(spawn_around_party,"p_hanzhong","pt_shu_war_party"),  
				(party_add_template, reg0, "pt_shu_war_reinf_1"),
				(party_add_template, reg0, "pt_shu_war_reinf_2"),
				(party_add_template, reg0, "pt_shu_war_reinf_3"),
				(assign, "$shu_war_party", reg(0)),
				(party_set_faction,"$shu_war_party","fac_kingdom_shuhan"),
				#(party_set_ai_behavior,"$shu_war_party",ai_bhvr_patrol_party),        
				#(party_set_ai_object,"$shu_war_party","p_bf_wuzhangyuan"),
				(call_script,"script_party_set_ai_state","$shu_war_party",spai_besieging_center,"p_bf_wuzhangyuan"),
			(else_try),
				(assign,"$wuzhangyuan_shu",1),
			(try_end),
			(store_num_parties_of_template, "$num_wuzhangyuan_wei_war_party", "pt_wei_war_party"),
			(try_begin),
				(eq,"$wuzhangyuan_wei",0),
				(lt,"$num_wuzhangyuan_wei_war_party",9),			
				(set_spawn_radius,1),
				(spawn_around_party,"p_changan","pt_wei_war_party"),  
				(party_add_template, reg0, "pt_wei_war_reinf_1"),
				(party_add_template, reg0, "pt_wei_war_reinf_2"),
				(party_add_template, reg0, "pt_wei_war_reinf_3"),
				(assign, "$wei_war_party", reg(0)),
				(party_set_faction,"$wei_war_party","fac_kingdom_caowei"),
				(call_script,"script_party_set_ai_state","$wei_war_party",spai_besieging_center,"p_bf_wuzhangyuan"),
				#(party_set_ai_behavior,"$wu_war_party",ai_bhvr_patrol_party),        
				#(party_set_ai_object,"$wu_war_party","p_bf_wuzhangyuan"),
			(else_try),
				(assign,"$wuzhangyuan_wei",1),
			(try_end),
		]
	),
#wuzhangyuan finish
	(6.0,0.0,0,
		[
			(eq,"$wuzhangyuan",1),
		],
		[
		(store_num_parties_of_template,"$num_wuzhangyuan_shu_war_party", "pt_shu_war_party"),				
		(store_num_parties_of_template,"$num_wuzhangyuan_wei_war_party", "pt_wei_war_party"),
		(try_begin),
				(eq,"$wuzhangyuan_shu",1),
				(try_begin),
					(eq,"$num_wuzhangyuan_shu_war_party",0),
					(display_message,"str_shu_bai_wuzhangyuan"),
					(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_wu","fac_kingdom_shuhan"),
					(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_wu","fac_kingdom_caowei"),
					(display_message,"str_guanxi"),
					(val_sub,"$shu_guoli",80),
					(val_add,"$wei_guoli",40),
					(call_script,"script_remove_war_party"),
					(assign,"$wuzhangyuan",2),
					(assign,"$zhanyi_inited",0),
					(store_current_day,"$init_day"),
					(assign,"$day_counter",0),
					(assign,"$zhanyi_inited",1),
				(try_end),
			(else_try),				
				(eq,"$wuzhangyuan_wei",1),
				(try_begin),
					(eq,"$num_wuzhangyuan_wei_war_party",0),
					(display_message,"str_wei_bai_wuzhangyuan"),
					(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_wu","fac_kingdom_shuhan"),
					(call_script,"script_diplomacy_start_war_between_kingdoms","fac_kingdom_wu","fac_kingdom_caowei"),
					(display_message,"str_guanxi"),
					(val_add,"$shu_guoli",40),
					(val_sub,"$wei_guoli",60),
					(call_script,"script_remove_war_party"),
					(assign,"$wuzhangyuan",2),
					(assign,"$zhanyi_inited",0),
					(store_current_day,"$init_day"),
					(assign,"$day_counter",0),
					(assign,"$zhanyi_inited",1),
				(try_end),
			(try_end),
		]
	),
#
(48.0,0.0,0.0,[],[(call_script,"script_move_party")]),

(0.3,0,0,[(store_faction_of_party,reg6,"$gongji_chengshi"),(store_relation,reg(0),reg6,"fac_player_faction"),(ge,reg(0),0)],[
(party_set_ai_behavior,"pt_mintuan",ai_bhvr_hold),(party_set_ai_object,"pt_mintuan",0)]),
#
[2.0,0.0,0.0,[],[(store_num_parties_destroyed_by_player,"$mintuan_1","pt_mintuan"),
(assign,"$mintuan_3","$mintuan_1"),(val_sub,"$mintuan_3","$mintuan_2"),(try_begin),(eq,"$mintuan_3",1),(assign,"$mintuan",0),(end_try)]],
[2.0,1.0,0.0,[],[(store_num_parties_destroyed_by_player,"$mintuan_2","pt_mintuan"),
(assign,"$mintuan_3","$mintuan_2"),(val_sub,"$mintuan_3","$mintuan_1"),(try_begin),(eq,"$mintuan_3",1),(assign,"$mintuan",0),(end_try)]],
#
#(12.0,0,0,[],[(assign,reg44,"$quest_prestige"),(display_message,"@quest_prestige=={reg44}"),]),
#sango initialize
(0,0.1,ti_once,[],
	[
		(assign,":setting_mode",setting_cpl_mode),
		(try_begin),
			(eq,":setting_mode",const_cpl_mode_normal),
			(assign,"$quest_prestige",0),
			(assign,"$setting_mintuan_guanzhi_limit",setting_mintuan_guanzhi_limit),
			(assign,setting_vclp_1,setting_command_lord_prestige_limit_lv1),
			(assign,setting_vclp_2,setting_command_lord_prestige_limit_lv2),
			(assign,setting_vclp_3,setting_command_lord_prestige_limit_lv3),
			(assign,setting_vclge_1,setting_command_lord_guanzhi_limit_lv1_wen),
			(assign,setting_vclge_2,setting_command_lord_guanzhi_limit_lv2_wen),
			(assign,setting_vclge_3,setting_command_lord_guanzhi_limit_lv3_wen),
			(assign,setting_vclgu_1,setting_command_lord_guanzhi_limit_lv1_wu),
			(assign,setting_vclgu_2,setting_command_lord_guanzhi_limit_lv2_wu),
			(assign,setting_vclgu_3,setting_command_lord_guanzhi_limit_lv3_wu),
		(else_try),
			(eq,":setting_mode",const_cpl_mode_test_1),
			(assign,"$quest_prestige",2000),
			(assign,"$setting_mintuan_guanzhi_limit",setting_mintuan_guanzhi_limit_in_test),
			(assign,setting_vclp_1,setting_command_lord_prestige_limit_lv1_in_test),
			(assign,setting_vclp_2,setting_command_lord_prestige_limit_lv2_in_test),
			(assign,setting_vclp_3,setting_command_lord_prestige_limit_lv3_in_test),
			(assign,setting_vclge_1,setting_command_lord_guanzhi_limit_lv1_wen_in_test),
			(assign,setting_vclge_2,setting_command_lord_guanzhi_limit_lv2_wen_in_test),
			(assign,setting_vclge_3,setting_command_lord_guanzhi_limit_lv3_wen_in_test),
			(assign,setting_vclgu_1,setting_command_lord_guanzhi_limit_lv1_wu_in_test),
			(assign,setting_vclgu_2,setting_command_lord_guanzhi_limit_lv2_wu_in_test),
			(assign,setting_vclgu_3,setting_command_lord_guanzhi_limit_lv3_wu_in_test),
		(else_try),
			(eq,":setting_mode",const_cpl_mode_test_2),
			(assign,"$quest_prestige",2000),
			(assign,"$setting_mintuan_guanzhi_limit",setting_mintuan_guanzhi_limit),
			(assign,setting_vclp_1,setting_command_lord_prestige_limit_lv1),
			(assign,setting_vclp_2,setting_command_lord_prestige_limit_lv2),
			(assign,setting_vclp_3,setting_command_lord_prestige_limit_lv3),
			(assign,setting_vclge_1,setting_command_lord_guanzhi_limit_lv1_wen),
			(assign,setting_vclge_2,setting_command_lord_guanzhi_limit_lv2_wen),
			(assign,setting_vclge_3,setting_command_lord_guanzhi_limit_lv3_wen),
			(assign,setting_vclgu_1,setting_command_lord_guanzhi_limit_lv1_wu),
			(assign,setting_vclgu_2,setting_command_lord_guanzhi_limit_lv2_wu),
			(assign,setting_vclgu_3,setting_command_lord_guanzhi_limit_lv3_wu),
		(try_end),
		(assign,"$command_time",0),
	]
),
(24,0,0,[],[(assign,"$command_time","$faction_rank"),(val_mul,"$command_time",3),(val_div,"$command_time",2)]),

##SG st
(0,0,0,[(map_free,0),
        (this_or_next|eq,"$hj_ready", 1),
        (eq,"$xj_ready",1)
        ],[
        (try_begin),
          (eq,"$xj_ready",1),
          (assign,"$xj_ready", 0),
        (try_end),
        (try_begin),
          (eq,"$hj_ready",1),
          (assign,"$hj_ready", 0),
        (try_end),
        ]),

(0,0,0,[
        (neg|map_free,0),
        (eq,"$hj_ready", 1),
        (store_time_of_day,":cur_time"),
        (try_begin),
            (ge,":cur_time", "$time_begin"),
            (store_sub,":time_ex",":cur_time","$time_begin"),
        (else_try),
            (store_add,":time_ex",":cur_time",24),
            (val_sub,":time_ex","$time_begin"),
        (try_end),
        (ge, ":time_ex","$time_cons"),
#        (assign,"$hj_last_build_time",":cur_time"),
    ],
   [(display_message,"str_success"),
    (assign, "$can_use_fire", 1),
    (assign,"$hj_ready", 0),
    (val_add,"$hj_use_count",1),
#    (assign, "$hj_mnu","$hj_use_count"),
    (assign, ":done", 0),
    (jump_to_menu, "mnu_camp"),
    (assign, ":done", 1),
    (rest_for_hours, 0, 0, 0), #stop resting
   ]),

  (0, 0, 0, [
        (neg|map_free,0),
        (eq,"$xj_ready", 1),
        (store_time_of_day,":cur_time"),
        (try_begin),
            (ge,":cur_time", "$time_begin"),
            (val_sub,":cur_time","$time_begin"),
        (else_try),
            (val_add,":cur_time",24),
            (val_sub,":cur_time","$time_begin"),
        (try_end),
        (ge, ":cur_time","$time_cons"),
    ],
    [
     (assign, ":finded",0),
     (try_for_parties, ":party_no"),
        (eq, ":finded",0),
        (party_get_template_id,":pt_id",":party_no"),
        (eq,":pt_id","pt_xian_jing"),
        (remove_party,":party_no"),
        (assign, ":finded",1),
     (try_end),
     (display_message,"str_success"),
     (assign, "$can_use_xj", 1),
     (assign,"$xj_ready", 0),
     (set_spawn_radius,0),
     (spawn_around_party,"p_main_party","pt_xian_jing"),
     (assign, ":done", 0),
     (jump_to_menu, "mnu_camp"),
     (assign, ":done", 1),
     (rest_for_hours, 0, 0, 0), #stop resting
     ]),

  (0, 0, 0, [(map_free,0),
        (ge, "$can_use_xj", 1),
        ],[
        (try_begin),
          (eq, "$can_use_xj", 3),
          (assign, ":finded",0),
          (try_for_parties,":party_no"),
            (eq, ":finded",0),
            (party_get_template_id,":pt_id",":party_no"),
            (eq,":pt_id","pt_xian_jing"),
            (remove_party,":party_no"),
            (assign, ":finded",1),
          (try_end),
          (assign, "$can_use_xj", 0),
        (try_end),
        (try_begin),
          (this_or_next|eq, "$can_use_xj", 1),
          (eq, "$can_use_xj", 2),
          (try_for_parties, ":party_no"),
            (party_get_template_id,":pt_id",":party_no"),
            (eq,":pt_id","pt_xian_jing"),
            (store_distance_to_party_from_party, ":distance", ":party_no", "p_main_party"),
          (try_end),
          (try_begin),
            (gt,":distance", 1),
            (eq, "$can_use_xj", 1),
            (assign, "$can_use_xj", 2),
            (display_message, "@Out of the trap range."),
          (else_try),
            (le,":distance", 1),
            (eq, "$can_use_xj", 2),
            (assign, "$can_use_xj", 1),
            (display_message, "@Enter the trap range."),
          (try_end),
        (try_end),
         ]),

(0,0,0,[(map_free,0),
        (eq,"$use_qixi",2),
        ],[
        (assign,"$use_qixi",0),
        (call_script, "script_add_qi_xi_troop_to_main_party"),
        ]),

#(0.5,0,24,[(ge,"$hj_use_count",1),
#           (val_sub,"$hj_use_count",1),
#           ],[]),

]
