import random

from header_common import *
from header_items import *
from header_troops import *
from header_skills import *
from ID_factions import *
from ID_items import *
from ID_scenes import *

####################################################################################################################
#  Each troop contains the following fields:
#  1) Troop id (string): used for referencing troops in other files. The prefix trp_ is automatically added before each troop-id .
#  2) Toop name (string).
#  3) Plural troop name (string).
#  4) Troop flags (int). See header_troops.py for a list of available flags
#  5) Scene (int) (only applicable to heroes) For example: scn_reyvadin_castle|entry(1) puts troop in reyvadin castle's first entry point
#  6) Reserved (int). Put constant "reserved" or 0.
#  7) Faction (int)
#  8) Inventory (list): Must be a list of items
#  9) Attributes (int): Example usage:
#           str_6|agi_6|int_4|cha_5|level(5)
# 10) Weapon proficiencies (int): Example usage:
#           wp_one_handed(55)|wp_two_handed(90)|wp_polearm(36)|wp_archery(80)|wp_crossbow(24)|wp_throwing(45)
#     The function wp(x) will create random weapon proficiencies close to value x.
#     To make an expert archer with other weapon proficiencies close to 60 you can use something like:
#           wp_archery(160) | wp(60)
# 11) Skills (int): See header_skills.py to see a list of skills. Example:
#           knows_ironflesh_3|knows_power_strike_2|knows_athletics_2|knows_riding_2
# 12) Face code (int): You can obtain the face code by pressing ctrl+E in face generator screen
# 13) Face code (int)(2) (only applicable to regular troops, can be omitted for heroes):
#     The game will create random faces between Face code 1 and face code 2 for generated troops
#  town_1   Sargoth
#  town_2   Tihr
#  town_3   Veluca
#  town_4   Suno
#  town_5   Jelkala
#  town_6   Praven
#  town_7   Uxkhal
#  town_8   Reyvadin
#  town_9   Khudan
#  town_10  Tulga
#  town_11  Curaw
#  town_12  Wercheg
#  town_13  Rivacheg
#  town_14  Halmar
####################################################################################################################

# Some constant and function declarations to be used below...

def wp(x):
  n = 0
  r = 10 + int(x / 10)
  n |= wp_one_handed(x + random.randrange(r))
  n |= wp_two_handed(x + random.randrange(r))
  n |= wp_polearm(x + random.randrange(r))
  n |= wp_archery(x + random.randrange(r))
  n |= wp_crossbow(x + random.randrange(r))
  n |= wp_throwing(x + random.randrange(r))
  return n

#Skills
knows_common = knows_riding_1|knows_trade_2|knows_inventory_management_2|knows_prisoner_management_1|knows_leadership_1


knows_lord_1 = knows_riding_3|knows_trade_2|knows_inventory_management_2|knows_tactics_4|knows_prisoner_management_4|knows_leadership_7

lord_attrib = str_20|agi_20|int_20|cha_20|level(38)

knight_attrib_1 = str_15|agi_14|int_8|cha_16|level(22)
knight_attrib_2 = str_16|agi_16|int_10|cha_18|level(26)
knight_attrib_3 = str_18|agi_17|int_12|cha_20|level(30)
knight_attrib_4 = str_19|agi_19|int_13|cha_22|level(35)
knight_attrib_5 = str_20|agi_20|int_15|cha_25|level(41)
knight_skills_1 = knows_riding_3|knows_ironflesh_2|knows_power_strike_3|knows_athletics_1|knows_tactics_2|knows_prisoner_management_1|knows_leadership_3
knight_skills_2 = knows_riding_4|knows_ironflesh_3|knows_power_strike_4|knows_athletics_2|knows_tactics_3|knows_prisoner_management_2|knows_leadership_5
knight_skills_3 = knows_riding_5|knows_ironflesh_4|knows_power_strike_5|knows_athletics_3|knows_tactics_4|knows_prisoner_management_2|knows_leadership_6
knight_skills_4 = knows_riding_6|knows_ironflesh_5|knows_power_strike_6|knows_athletics_4|knows_tactics_6|knows_prisoner_management_3|knows_leadership_7
knight_skills_5 = knows_riding_7|knows_ironflesh_6|knows_power_strike_7|knows_athletics_5|knows_tactics_8|knows_prisoner_management_3|knows_leadership_9

#These face codes are generated by the in-game face generator.
#Enable edit mode and press ctrl+E in face generator screen to obtain face codes.

refugee_face1 = 0x000000000000000201c0600048440000
refugee_face2 = 0x00000000000c300401c0600048440000
girl_face1    = 0x000000000000000101c0600048440000
girl_face2    = 0x00000000000c300401c0600048440000
merchant_face1= 0x00000000001091c301da4914e4919295
merchant_face2= 0x000000000004028601ea89a44929b699


vaegir_face1  = 0x00000000000001c101d8248040040049
vaegir_face2  = 0x000000000004328701fed769b6fb6dbe
swadian_face1 = 0x000000000000000101c0008040008240
swadian_face2 = 0x00000000000c71c701fcdb69aff77dbf

khergit_face1 = 0x00000000000843c801cc244a98000000
khergit_face2 = 0x00000000000c740901ff524a9e77eb1d
pirate_face1  = 0x00000000000031c301c0000000000000
pirate_face2  = 0x00000000000c824801feb76dffffffff
bandit_face1  = 0x00000000000031c301c0000000000000
bandit_face2  = 0x00000000000c724801feb76dffffffff

undead_face1  = 0x00000000002000000000000000000000
undead_face2  = 0x000000000020010000001fffffffffff


sanguo_face1 = 0x000000000000730301eb6db8e85162d1
sanguo_face2 = 0x000000000000740301e270372131b291
sanguo_face3 = 0x000000000010360301c3496850962335
sanguo_face4 = 0x000000000000700401f47036f13532d2
sanguo_face5 = 0x00000000000875c301fd9ce66341cda1
sanguo_face6 = 0x00000000000c314301e2f6e5166754a6
sanguo_face7 = 0x000000000008238401d10ad773a1438d


reserved = 0

no_scene = 0

# BoW: Awali facecodes
awali_face1 = 0x00000000000c800901c244a8c1549040
awali_face2 = 0x00000000000c800901fcce7d5cbf6df0

awali_fem1 = 0x00000000000c000101d9ec4606dd145c
awali_fem2 = 0x00000000000c100601c27cd5244c6222
# BoW: End awali facecodes


#NAMES:
#


troops_defined=1
troops = [
  ["player","Player","Player",tf_hero,no_scene,reserved,fac_player_faction,
   [],
   str_4|agi_4|int_4|cha_4,wp(15),0,0x000000000000000101db6db6db6db6db],
  ["temp_troop","Temp Troop","Temp Troop",tf_hero,no_scene,reserved,fac_commoners,[],def_attrib,0,knows_common|knows_inventory_management_10,0],
  ["game","Game","Game",tf_hero,no_scene,reserved,fac_commoners,[],def_attrib,0,knows_common,0],
  ["unarmed_troop","Unarmed Troop","Unarmed Troops",tf_hero,no_scene,reserved,fac_commoners,[itm_arrows,itm_short_bow],def_attrib|str_14,0,knows_common|knows_power_draw_2,0],
####################################################################################################################
# Troops before this point are hardwired into the game and their order should not be changed!
####################################################################################################################
  ["random_town_sequence","Random Town Sequence","Random Town Sequence",tf_hero,no_scene,reserved,fac_commoners,[],def_attrib,0,knows_common|knows_inventory_management_10,0],
  ["tutorial_maceman","Maceman","Maceman",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_tutorial_club,itm_shirt1,itm_hide_boots],
   str_6|agi_6|level(1),wp(50),knows_common,swadian_face1,swadian_face2],
  ["tutorial_archer","Archer","Archer",tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_ranged,no_scene,reserved,fac_commoners,
   [itm_tutorial_short_bow,itm_tutorial_arrows,itm_shirt,itm_hide_boots],
   str_6|agi_6|level(5),wp(100),knows_common|knows_power_draw_4,swadian_face1,swadian_face2],
  ["tutorial_swordsman","Swordsman","Swordsman",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_tutorial_sword,itm_shirt2,itm_hide_boots],
   str_6|agi_6|level(5),wp(80),knows_common,swadian_face1,swadian_face2],

#rider begin
["shu_horse_solider","Shu_Horse_Solider","Shu_Horse_Soliders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_shuhan,[itm_butoujin,itm_qinbushu,itm_bushoes,itm_china_s_spear,itm_ge,itm_china_spear,itm_budun,itm_saddle_horse,itm_s_arrows,itm_hunting_bow],def_attrib|level(6),wp(90),knows_power_draw_1|knows_horse_archery_2|knows_power_strike_1|knows_riding_2,sanguo_face1,sanguo_face2],

["shu_horseman","Shu_Horseman","Shu_Horsemans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_shuhan,[itm_butoujin,itm_leatherarmor,itm_bushoes,itm_china_50huanshou,itm_gea,itm_china_s_spear,itm_round_shield,itm_hunter,itm_s_arrows,itm_nomad_bow],def_attrib|level(11),wp(150),knows_riding_3|knows_power_strike_2|knows_ironflesh_1|knows_power_draw_3|knows_horse_archery_2,sanguo_face1,sanguo_face2,sanguo_face4],

["shu_elite_horseman","Shu_Elite_Horseman","Shu_Elite_Horsemans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_shuhan,[itm_leatherhelmet,itm_leatherarmor,itm_leather_gloves,itm_leather_boots,itm_geb,itm_longlance,itm_xishield,itm_hzhorse,itm_s_arrows,itm_nomad_bow],def_attrib|level(17),wp(170),knows_riding_4|knows_power_strike_2|knows_ironflesh_2|knows_power_draw_3|knows_horse_archery_3,sanguo_face1,sanguo_face2,sanguo_face4],

["shu_armed_horseman","Shu_armed_Horseman","Shu_armed_Horsemans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_shuhan,[itm_tiezhou,itm_zhongpijia,itm_leather_gloves,itm_leather_boots,itm_dadao,itm_china_100huanshou,itm_longhalberd,itm_ironshield,itm_hzhorse,itm_s_arrows,itm_khergit_bow],def_attrib|level(24),wp(190),knows_riding_5|knows_power_strike_2|knows_ironflesh_3|knows_power_draw_4|knows_horse_archery_4,sanguo_face1,sanguo_face2,sanguo_face4],

["shu_solider","Shu_Solider","Shu_Soliders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_kingdom_shuhan,[itm_butoujin,itm_qinbushu,itm_bushoes,itm_china_s_spear,itm_ge,itm_one_handed_battle_axe,itm_china_spear,itm_budun],def_attrib|level(6),wp(90),knows_ironflesh_1|knows_power_strike_1|knows_athletics_2,sanguo_face1,sanguo_face2,sanguo_face4],

["shu_armed_horseman_elite","Shu_armed_Horseman","Shu_armed_Horsemans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_shuhan,[itm_tiezhou,itm_zhongpijia,itm_leather_gloves,itm_leather_boots,itm_dadao,itm_china_100huanshou,itm_longhalberd,itm_ironshield,itm_wushunhorse,itm_s_arrows,itm_khergit_bow],def_attrib|level(28),wp(260),knows_riding_6|knows_power_strike_3|knows_ironflesh_3|knows_power_draw_4|knows_horse_archery_4,sanguo_face1,sanguo_face2,sanguo_face4],

["western_liang_valiant_calvary","Western_Liang_Valiant_Calvary","Western_Liang_Valiant_Calvarys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_kingdom_shuhan,[itm_yanbianc,itm_ironarmor,itm_leather_gloves,itm_leather_boots,itm_ironlance,itm_hzhorse],def_attrib|level(30),wp(230),knows_riding_6|knows_ironflesh_3|knows_power_strike_3,sanguo_face1,sanguo_face2,sanguo_face4],

["western_liang_elite_cavalry","Western_Liang_Elite_Cavalry","Western_Liang_Elite_Cavalrys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_kingdom_shuhan,[itm_tiezhou,itm_mingarmor,itm_leather_gloves,itm_ironshoes,itm_mapick,itm_zhanhorse],def_attrib|level(35),wp(250),knows_riding_6|knows_ironflesh_4|knows_power_strike_4,sanguo_face1,sanguo_face2,sanguo_face4],

["western_liang_heavy_cavalry","Western_Liang_Heavy_Cavalry","Western_Liang_Heavy_Cavalrys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_kingdom_shuhan,[itm_tiezhou,itm_dangxiong,itm_leather_gloves,itm_ironshoes,itm_mapick,itm_xlhorse],def_attrib|level(45),wp(270),knows_riding_7|knows_ironflesh_4|knows_power_throw_3|knows_power_strike_4,sanguo_face1,sanguo_face2],

["silver_lancer","Silver_Lancer","Silver_Lancers",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_shield,no_scene,reserved,fac_kingdom_shuhan,[itm_tiekui,itm_ironarmora,itm_ironlance,itm_leather_gloves,itm_leather_boots,itm_courser],def_attrib|level(30),wp(230),knows_riding_7|knows_power_strike_4|knows_ironflesh_3,sanguo_face1,sanguo_face2,sanguo_face4],

["silver_elite_lancer","Silver_Elite_Lancer","Silver_Elite_Lancers",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_shield,no_scene,reserved,fac_kingdom_shuhan,[itm_tiekui,itm_yinjia,itm_tongarmor,itm_leather_gloves,itm_ironshoes,itm_silverlance,itm_courser,itm_xuehorse],def_attrib|level(35),wp(250),knows_riding_7|knows_power_strike_4|knows_ironflesh_4|knows_shield_2,sanguo_face1,sanguo_face2],

["silver_lancer_guard","Silver_Lancer_Guard","Silver_Lancer_Guards",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_shield,no_scene,reserved,fac_kingdom_shuhan,[itm_doumao,itm_yinjia,itm_leather_gloves,itm_ironshoes,itm_silverlance,itm_xuehorse],def_attrib|level(45),wp(270),knows_riding_8|knows_power_strike_5|knows_ironflesh_4|knows_shield_2,sanguo_face1,sanguo_face2],

["shu_jiao_flag_holder","Shu_Jiao_Flag_Holder","Shu_Jiao_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots,no_scene,reserved,fac_kingdom_shuhan,[itm_pitiezhou,itm_leatherarmor,itm_jiaoflag_shu,itm_leather_boots],def_attrib|level(15),wp(150),knows_common|knows_athletics_2|knows_ironflesh_2,sanguo_face1,sanguo_face2,sanguo_face4],

["shu_ya_flag_holder","Shu_Ya_Flag_Holder","Shu_Ya_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_shuhan,[itm_pitiezhou,itm_leatherarmor,itm_yaflag,itm_hunter,itm_leather_boots],def_attrib|level(18),wp(170),knows_common|knows_athletics_5|knows_ironflesh_5,sanguo_face1,sanguo_face2,sanguo_face4],

["shu_main_flag_holder","Shu_Main_Flag_Holder","Shu_Main_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse,no_scene,reserved,fac_kingdom_shuhan,[itm_yanbian,itm_zhongpijia,itm_leather_gloves,itm_leather_boots,itm_nationflag_shu,itm_wushunhorse],def_attrib|level(22),wp(190),knows_common|knows_athletics_6|knows_ironflesh_5|knows_riding_5,sanguo_face1,sanguo_face2],

["shu_main_flag_holder_elite","Shu_Main_Flag_Holder","Shu_Main_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse,no_scene,reserved,fac_kingdom_shuhan,[itm_yanbian,itm_zhongpijia,itm_leather_gloves,itm_leather_boots,itm_nationflag_shu,itm_wushunhorse],def_attrib|level(26),wp(200),knows_common|knows_athletics_6|knows_ironflesh_6|knows_riding_5,sanguo_face1,sanguo_face2],

["shu_high_capitain","Shu_High_Capitain","Shu_High_Capitains",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_kingdom_shuhan,[itm_yanbiana,itm_shuwushen2,itm_shuwushen1,itm_china_50huanshou,itm_halberd,itm_leather_gloves,itm_wuxie,itm_zhendun,itm_courser],def_attrib|level(46),wp(330),knows_athletics_5|knows_ironflesh_9|knows_riding_6|knows_power_strike_7|knows_tactics_4|knows_leadership_8,sanguo_face1,sanguo_face2,sanguo_face4],

["shu_general","Shu_General","Shu_Generals",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_shield,no_scene,reserved,fac_kingdom_shuhan,[itm_junmao,itm_yanbiana,itm_mingarmor,itm_tongarmor,itm_longlance,itm_china_100huanshou,itm_shushield,itm_dragonhorse,itm_wuxie],def_attrib|level(49),wp(360),knows_common|knows_athletics_5|knows_ironflesh_10|knows_riding_7|knows_power_strike_7|knows_tactics_6|knows_shield_5|knows_leadership_8,sanguo_face1,sanguo_face2,sanguo_face4],

["wu_horse_solider","Wu_Horse_Solider","Wu_Horse_Soliders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_wu,[itm_butoujin,itm_qinbuwu,itm_bushoes,itm_ge,itm_falchion,itm_one_handed_battle_axe,itm_saddle_horse,itm_s_bolts,itm_hunting_crossbow],def_attrib|level(6),wp(90),knows_horse_archery_3|knows_riding_1|knows_power_strike_1|knows_ironflesh_1,sanguo_face1,sanguo_face2],

["wu_rider","Wu_Rider","Wu_Riders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_wu,[itm_butoujin,itm_leatherarmor,itm_bushoes,itm_china_50huanshou,itm_china_s_spear,itm_china_spear,itm_geb,itm_budun,itm_courser,itm_s_bolts,itm_light_crossbow],def_attrib|level(10),wp(150),knows_horse_archery_4|knows_riding_3|knows_ironflesh_1|knows_power_strike_1,sanguo_face1,sanguo_face2],

["wu_elite_rider","Wu_Elite_Rider","Wu_Elite_Riders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_wu,[itm_pitiezhou,itm_china_soldier_ys,itm_leather_gloves,itm_leather_boots,itm_china_s100huan,itm_china_l_spear,itm_jian,itm_jinwu,itm_wushield,itm_courser,itm_s_bolts,itm_light_crossbow],def_attrib|level(16),wp(175),knows_horse_archery_5|knows_riding_4|knows_ironflesh_2|knows_power_strike_2,sanguo_face1,sanguo_face2],

["wu_tiger_rider","Wu_Tiger_Rider","Wu_Tiger_Riders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_wu,[itm_yuling,itm_zhongpijia,itm_leather_gloves,itm_zhanxie,itm_dadao,itm_longhalberd,itm_wushield,itm_hzhorse,itm_s_bolts,itm_light_crossbow],def_attrib|level(23),wp(210),knows_horse_archery_5|knows_riding_5|knows_ironflesh_3|knows_power_strike_2,sanguo_face1,sanguo_face2],

["wu_tiger_rider_elite","Wu_Tiger_Rider","Wu_Tiger_Riders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_wu,[itm_yuling,itm_zhongpijia,itm_leather_gloves,itm_zhanxie,itm_dadao,itm_longhalberd,itm_wushield,itm_hzhorse,itm_s_bolts,itm_light_crossbow],def_attrib|level(26),wp(270),knows_horse_archery_6|knows_riding_5|knows_ironflesh_3|knows_power_strike_3,sanguo_face1,sanguo_face2],

["wu_jiao_flag_holder","Wu_Jiao_Flag_Holder","Wu_Jiao_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots,no_scene,reserved,fac_kingdom_wu,[itm_pitiezhou,itm_leatherarmor,itm_jiaoflag_wu,itm_leather_boots],def_attrib|level(15),wp(150),knows_common|knows_athletics_2|knows_ironflesh_2,sanguo_face1,sanguo_face2,sanguo_face4],

["wu_ya_flag_holde","Wu_Ya_Flag_Holde","Wu_Ya_Flag_Holdes",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_wu,[itm_pitiezhou,itm_leatherarmor,itm_yaflag,itm_hunter,itm_leather_boots],def_attrib|level(18),wp(170),knows_common|knows_athletics_5|knows_ironflesh_5,sanguo_face1,sanguo_face2,sanguo_face4],

["wu_main_flag_holder","Wu_Main_Flag_Holder","Wu_Main_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse,no_scene,reserved,fac_kingdom_wu,[itm_tiekuia,itm_china_soldier_yq,itm_leather_gloves,itm_leather_boots,itm_nationflag_wu,itm_wushunhorse],def_attrib|level(22),wp(190),knows_common|knows_athletics_6|knows_ironflesh_5|knows_riding_5,sanguo_face1,sanguo_face2],

["wu_main_flag_holder_elite","Wu_Main_Flag_Holder","Wu_Main_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse,no_scene,reserved,fac_kingdom_wu,[itm_tiekuia,itm_china_soldier_yq,itm_leather_gloves,itm_leather_boots,itm_nationflag_wu,itm_wushunhorse],def_attrib|level(26),wp(200),knows_common|knows_athletics_6|knows_ironflesh_6|knows_riding_5,sanguo_face1,sanguo_face2],

["wu_high_capitain","Wu_High_Capitain","Wu_High_Capitains",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_kingdom_wu,[itm_tiekuia,itm_wuwushen2,itm_wuwushen1,itm_halberd,itm_goulian,itm_leather_gloves,itm_wuxie,itm_courser],def_attrib|level(46),wp(330),knows_athletics_5|knows_ironflesh_9|knows_riding_6|knows_power_strike_7|knows_tactics_4|knows_leadership_8,sanguo_face1,sanguo_face2,sanguo_face4],

["wu_general","Wu_General","Wu_Generals",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_kingdom_wu,[itm_yanyitoukui,itm_wuwushen1,itm_tongarmor,itm_china_100longsword,itm_china_50longsword,itm_wushield,itm_dragonhorse,itm_wuxie],def_attrib|level(49),wp(360),knows_common|knows_athletics_5|knows_ironflesh_10|knows_riding_7|knows_power_strike_7|knows_tactics_6|knows_leadership_8,sanguo_face1,sanguo_face2,sanguo_face4],

["wei_horse_solider","Wei_Horse_Solider","Wei_Horse_Soliders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_kingdom_caowei,[itm_butoujin,itm_pihuan,itm_bushoes,itm_one_handed_war_axe,itm_china_25huanshou,itm_wooden_shield,itm_saddle_horse],def_attrib|level(6),wp(90),knows_shield_1|knows_riding_2|knows_ironflesh_2,sanguo_face1,sanguo_face2,sanguo_face4],

["wei_light_cavalry","Wei_Light_Cavalry","Wei_Light_Cavalrys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_shield,no_scene,reserved,fac_kingdom_caowei,[itm_pitiezhou,itm_leatherarmor,itm_bushoes,itm_china_50huanshou,itm_gea,itm_china_pike,itm_spear1,itm_round_shield,itm_hunter],def_attrib|level(12),wp(150),knows_riding_4|knows_ironflesh_2|knows_shield_1|knows_power_strike_2,sanguo_face1,sanguo_face2],

["wei_heavy_cavalry","Wei_Heavy_Cavalry","Wei_Heavy_Cavalrys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse,no_scene,reserved,fac_kingdom_caowei,[itm_yanbianb,itm_ironarmora,itm_leather_gloves,itm_leather_boots,itm_china_l_spear,itm_mapick,itm_halberd,itm_xishield,itm_zhanhorse],def_attrib|level(18),wp(180),knows_riding_5|knows_ironflesh_2|knows_shield_2|knows_power_strike_3,sanguo_face1,sanguo_face2],

["dragoon","Dragoon","Dragoons",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse,no_scene,reserved,fac_kingdom_caowei,[itm_yanbiana,itm_tongarmor,itm_leather_gloves,itm_ironshoes,itm_mapick,itm_longlance,itm_yue,itm_weishield,itm_blackhorse],def_attrib|level(25),wp(230),knows_riding_6|knows_ironflesh_3|knows_shield_2|knows_power_strike_4,sanguo_face1,sanguo_face2],

["dragoon_elite","Dragoon","Dragoons",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse,no_scene,reserved,fac_kingdom_caowei,[itm_huyan,itm_lianshena,itm_leather_gloves,itm_ironshoes,itm_china_100huanshou,itm_mapick,itm_longlance,itm_longaxe,itm_weishield,itm_blackhorse],def_attrib|level(30),wp(250),knows_riding_7|knows_ironflesh_6|knows_shield_4|knows_power_strike_5,sanguo_face1,sanguo_face2],

["wei_high_capitain","Wei_High_Capitain","Wei_High_Capitains",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_kingdom_caowei,[itm_yanbiana,itm_weiwushen2,itm_weiwushen1,itm_halberd,itm_china_100huanshou,itm_leather_gloves,itm_wuxie,itm_courser],def_attrib|level(46),wp(330),knows_athletics_5|knows_ironflesh_9|knows_riding_7|knows_power_strike_7|knows_tactics_4|knows_leadership_8,sanguo_face1,sanguo_face2,sanguo_face4],

["wei_general","Wei_General","Wei_Generals",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_kingdom_caowei,[itm_yanyitoukui,itm_mingarmorb,itm_china_100longsword,itm_longhalberd,itm_weishield,itm_dragonhorse,itm_wuxie],def_attrib|level(49),wp(360),knows_common|knows_athletics_5|knows_ironflesh_10|knows_riding_8|knows_power_strike_7|knows_tactics_6|knows_leadership_8,sanguo_face1,sanguo_face2,sanguo_face4],

["huang_jin_calvary","Huang_Jin_Calvary","Huang_Jin_Calvarys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_force_headyellow,[itm_guanjin,itm_huangarmor,itm_bushoes,itm_spear1,itm_china_ge,itm_china_50huanshou,itm_wooden_shield,itm_steppe_horse],def_attrib|level(10),wp(180),knows_riding_4|knows_power_throw_2|knows_power_strike_3,sanguo_face1,sanguo_face2],

["huang_jin_valoror","Huang_Jin_Valoror","Huang_Jin _Valorors",tf_guarantee_ranged,no_scene,reserved,fac_force_headyellow,[itm_guanjin,itm_china_soldier_j,itm_leather_boots,itm_jarid,itm_ironlance,itm_dadao,itm_dayue],def_attrib|level(16),wp(230),knows_riding_4|knows_ironflesh_3|knows_power_throw_3|knows_athletics_4|knows_power_strike_3,sanguo_face1,sanguo_face2,sanguo_face4],

["huang_jin_lieutenant","Huang_Jin_lieutenant","Huang_Jin_lieutenants",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_shield|tf_guarantee_horse,no_scene,reserved,fac_force_headyellow,[itm_guanjin,itm_leatherarmor,itm_leather_boots,itm_china_s100huan,itm_wooden_shield],def_attrib|level(40),wp(270),knows_common|knows_athletics_6|knows_ironflesh_6|knows_shield_3|knows_power_strike_5|knows_tactics_2|knows_leadership_5,sanguo_face1,sanguo_face2,sanguo_face4],

["huang_jin_high_capitain","Huang_Jin_High_Capitain","Huang_Jin_High_Capitains",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_force_headyellow,[itm_guanjin,itm_china_soldier_ys,itm_leather_boots,itm_spear1,itm_ironshield,itm_hunter],def_attrib|level(43),wp(300),knows_common|knows_athletics_7|knows_ironflesh_7|knows_shield_4|knows_power_strike_6|knows_tactics_2|knows_leadership_6,sanguo_face1,sanguo_face2,sanguo_face4],

["huang_jin_jiao_flag_holder","Huang_Jin_Jiao_Flag_Holder","Huang_Jin_Jiao_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_force_headyellow,[itm_guanjin,itm_huangarmor,itm_bushoes,itm_jiaoflag_huang],def_attrib|level(10),wp(150),knows_common|knows_athletics_2|knows_ironflesh_2,sanguo_face1,sanguo_face2,sanguo_face4],

["huang_jin_main_flag_holder","Huang_Jin_Main_Flag_Holder","Huang_Jin_Main_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse,no_scene,reserved,fac_force_headyellow,[itm_guanjin,itm_huangarmor,itm_leather_gloves,itm_leather_boots,itm_huangjinflag,itm_hunter],def_attrib|level(23),wp(190),knows_common|knows_athletics_6|knows_ironflesh_6|knows_riding_5,sanguo_face1,sanguo_face2],

["charger_fighter","Charger_fighter","Charger_fighters",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_force_peasantry,[itm_tiekui,itm_tiezhajia,itm_leather_gloves,itm_leather_boots,itm_spear1,itm_zhanhorse],def_attrib|level(30),wp(230),knows_ironflesh_4|knows_shield_2|knows_power_strike_5|knows_riding_7,sanguo_face1,sanguo_face2],

["charger_elite_fighter","Charger_Elite_Fighter","Charger_Elite_Fighters",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_force_peasantry,[itm_doumao,itm_jintie,itm_leather_gloves,itm_leather_boots,itm_ironshield,itm_longlance,itm_blackhorse],def_attrib|level(35),wp(250),knows_ironflesh_5|knows_shield_3|knows_power_strike_6|knows_riding_7,sanguo_face1,sanguo_face2],

["charger_warrior","Charger_warrior","Charger_warriors",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_force_peasantry,[itm_doumao,itm_jintie,itm_leather_gloves,itm_leather_boots,itm_ironshield,itm_longlance,itm_blackhorse],def_attrib|level(45),wp(270),knows_ironflesh_6|knows_shield_3|knows_power_strike_6|knows_riding_8,sanguo_face1,sanguo_face2],

#archer begin
["shu_archer_troop","Shu_Archer_Troop","Shu_Archer_Troops",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_shuhan,[itm_qinbushu,itm_bushoes,itm_crossbow,itm_bolts,itm_dagger],def_attrib|level(12),wp_one_handed(150)|wp_two_handed(150)|wp_polearm(150)|wp_archery(150)|wp_crossbow(150)|wp_throwing(150),knows_ironflesh_1|knows_athletics_2|knows_power_strike_1,sanguo_face1,sanguo_face2,sanguo_face4],

["shu_strong_crossbowman","shu_strong_crossbowman","shu_strong_crossbowmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_shuhan,[itm_tiekuia,itm_china_soldier_qs,itm_leather_gloves,itm_leather_boots,itm_heavy_crossbow,itm_bolts,itm_dagger],def_attrib|level(18),wp_one_handed(170)|wp_two_handed(170)|wp_polearm(170)|wp_archery(170)|wp_crossbow(170)|wp_throwing(170),knows_ironflesh_2|knows_athletics_3|knows_power_strike_2,sanguo_face1,sanguo_face2,sanguo_face4],

["yuan_rong_crossbowman","Yuan_Rong_Crossbowman","Yuan_Rong_Crossbowmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_shuhan,[itm_bronzehelmet,itm_china_soldier_ys,itm_leather_gloves,itm_leather_boots,itm_china_cross,itm_bolts,itm_china_25huanshou],def_attrib|level(25),wp(210),knows_ironflesh_3|knows_athletics_4|knows_power_strike_3,sanguo_face1,sanguo_face2,sanguo_face4],

["yuan_rong_crossbowman_elite","Yuan_Rong_Crossbowman","Yuan_Rong_Crossbowmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_shuhan,[itm_bronzehelmet,itm_leatherarmor,itm_leather_gloves,itm_leather_boots,itm_china_cross,itm_bolts,itm_china_25huanshou],def_attrib|level(30),wp(280),knows_ironflesh_4|knows_athletics_4|knows_power_strike_3,sanguo_face1,sanguo_face2,sanguo_face4],

["wu_bowman","Wu_Bowman","Wu_Bowmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_wu,[itm_xiaoguan,itm_china_soldier_q,itm_bushoes,itm_nomad_bow,itm_arrows,itm_dagger],def_attrib|level(11),wp(150),knows_power_draw_3|knows_athletics_1|knows_ironflesh_1,sanguo_face1,sanguo_face2,sanguo_face4],

["wu_elite_bowman","Wu_Elite_Bowman","Wu_Elite_Bowmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_wu,[itm_leatherhelmet,itm_bushoes,itm_china_soldier_yj,itm_cavalry_bow,itm_arrows,itm_dagger],def_attrib|level(17),wp(170),knows_power_draw_4|knows_athletics_2|knows_ironflesh_2,sanguo_face1,sanguo_face2,sanguo_face4],

["wu_five_troops_bowman","Wu_Five_troops_Bowman","Wu_Five_troops_Bowmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_wu,[itm_pitiezhou,itm_china_soldier_ys,itm_leather_gloves,itm_leather_boots,itm_war_bow,itm_bodkin_arrows,itm_dagger],def_attrib|level(24),wp(190),knows_power_draw_5|knows_athletics_3|knows_ironflesh_3,sanguo_face1,sanguo_face2,sanguo_face4],

["wu_five_troops_bowman_elite","Wu_Five_troops_Bowman","Wu_Five_troops_Bowmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_wu,[itm_pitiezhou,itm_china_soldier_ys,itm_leather_gloves,itm_leather_boots,itm_war_bow,itm_bodkin_arrows,itm_dagger],def_attrib|level(28),wp(230),knows_power_draw_5|knows_athletics_3|knows_ironflesh_4,sanguo_face1,sanguo_face2,sanguo_face4],

["courage","Courage","Courages",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_wu,[itm_bronzehelmet,itm_china_soldier_q,itm_leather_boots,itm_heavy_crossbow,itm_bolts,itm_handhalberd],def_attrib|level(30),wp(230),knows_athletics_5|knows_ironflesh_5|knows_power_strike_3,sanguo_face1,sanguo_face2,sanguo_face4],

["elite_courage","Elite_Courage","Elite_Courages",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_wu,[itm_bronzehelmet,itm_china_soldier_yq,itm_leather_boots,itm_bolts,itm_sniper_crossbow,itm_china_s100huan],def_attrib|level(35),wp(250),knows_athletics_5|knows_ironflesh_6|knows_power_strike_4,sanguo_face1,sanguo_face2,sanguo_face4],

["horse_free_horseman","Horse_free_Horseman","Horse_free_Horsemans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_wu,[itm_bronzehelmet,itm_china_soldier_yq,itm_leather_boots,itm_bolts,itm_sniper_crossbow,itm_china_s100huan],def_attrib|level(45),wp(270),knows_athletics_6|knows_ironflesh_6|knows_power_strike_4,sanguo_face1,sanguo_face2,sanguo_face4],

["wei_archer","Wei_Archer","Wei_Archers",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged,no_scene,reserved,fac_kingdom_caowei,[itm_toujin,itm_china_soldier_qs,itm_bushoes,itm_short_bow,itm_arrows,itm_dagger],def_attrib|level(10),wp(150),knows_power_draw_3|knows_ironflesh_1|knows_athletics_1,sanguo_face1,sanguo_face2,sanguo_face4],

["wei_elite_archer","Wei_Elite_Archer","Wei_Elite_Archers",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_caowei,[itm_leatherhelmet,itm_china_soldier_q,itm_leather_boots,itm_long_bow,itm_arrows,itm_dagger],def_attrib|level(16),wp(175),knows_power_draw_4|knows_ironflesh_2|knows_athletics_2,sanguo_face1,sanguo_face2,sanguo_face4],

["wei_heavy_bow_archer","Wei_Heavy_Bow_Archer","Wei_Heavy_Bow_Archers",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_caowei,[itm_leatherhelmet,itm_china_soldier_aj,itm_leather_gloves,itm_leather_boots,itm_strong_bow,itm_barbed_arrows,itm_handbronzesword],def_attrib|level(23),wp(210),knows_power_draw_5|knows_ironflesh_3|knows_athletics_3,sanguo_face1,sanguo_face2,sanguo_face4],

["wei_heavy_bow_archer_elite","Wei_Heavy_Bow_Archer","Wei_Heavy_Bow_Archers",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_caowei,[itm_leatherhelmet,itm_china_soldier_aj,itm_leather_gloves,itm_leather_boots,itm_strong_bow,itm_barbed_arrows,itm_handbronzesword],def_attrib|level(26),wp(210),knows_power_draw_5|knows_ironflesh_4|knows_athletics_3,sanguo_face1,sanguo_face2,sanguo_face4],

["crushing_man","Crushing_man","Crushing_mans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_force_peasantry,[itm_pitiezhou,itm_leatherarmor,itm_arrows,itm_heavy_crossbow,itm_bolts,itm_spear1,itm_xishield],def_attrib|level(30),wp(230),knows_ironflesh_5|knows_power_strike_4|knows_athletics_5|knows_shield_2,sanguo_face1,sanguo_face2],

["crushing_elite_man","Crushing_Elite_Man","Crushing_Elite_Mans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_force_peasantry,[itm_pitiezhou,itm_china_soldier_ys,itm_leather_gloves,itm_leather_boots,itm_sniper_crossbow,itm_bolts,itm_xishield,itm_longlance],def_attrib|level(35),wp(250),knows_ironflesh_5|knows_power_strike_5|knows_athletics_6|knows_shield_3,sanguo_face1,sanguo_face2],

["crushing_warrior","crushing_Warrior","crushing_Warriors",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_force_peasantry,[itm_pitiezhou,itm_zhongpijia,itm_leather_gloves,itm_leather_boots,itm_sniper_crossbow,itm_bolts,itm_xishield,itm_longlance],def_attrib|level(45),wp(270),knows_ironflesh_6|knows_power_strike_5|knows_athletics_6|knows_shield_3,sanguo_face1,sanguo_face2],

#footman begin
["shu_infantry","Shu_Infantry","Shu_Infantrys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_kingdom_shuhan,[itm_bronzehelmet,itm_leatherarmor,itm_bushoes,itm_gea,itm_spear1,itm_budun,itm_china_s50huan],def_attrib|level(10),wp(150),knows_athletics_2|knows_ironflesh_2|knows_power_strike_2|knows_shield_1,sanguo_face1,sanguo_face2],

["elite_shu_infantry","Elite_Shu_Infantry","Elite_Shu_Infantrys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_shuhan,[itm_bronzehelmet,itm_liangdang,itm_leather_gloves,itm_leather_boots,itm_nomad_bow,itm_arrows,itm_goulian,itm_china_s100huan,itm_china_l_spear,itm_halberd,itm_shushield],def_attrib|level(16),wp(170),knows_athletics_3|knows_ironflesh_3|knows_power_strike_2|knows_shield_1|knows_power_draw_2,sanguo_face1,sanguo_face2],

["shu_unstopped_horseman","Shu_unstopped_Horseman","Shu_unstopped_Horsemans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_shuhan,[itm_ptiekui,itm_zhiliangdang,itm_ironshoes,itm_khergit_bow,itm_arrows,itm_longaxe,itm_longlance,itm_zhongzhandao,itm_bigshield],def_attrib|level(23),wp(190),knows_athletics_5|knows_ironflesh_4|knows_power_strike_3|knows_shield_1|knows_power_draw_3,sanguo_face1,sanguo_face2],

["shu_unstopped_horseman_elite","Shu_unstopped_Horseman","Shu_unstopped_Horsemans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_shuhan,[itm_ptiekui,itm_hunzhi,itm_ironshoes,itm_longaxe,itm_longlance,itm_strong_bow,itm_arrows,itm_zhongzhandao,itm_bigshield],def_attrib|level(26),wp(210),knows_athletics_6|knows_ironflesh_4|knows_power_strike_4|knows_shield_2|knows_power_draw_4,sanguo_face1,sanguo_face2],

["shu_lieutenant","Shu_lieutenant","Shu_lieutenants",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_kingdom_shuhan,[itm_tiekuia,itm_shuwushen1,itm_shuwushen2,itm_gea,itm_spear1,itm_ironshield,itm_leather_boots,itm_leather_gloves],def_attrib|level(40),wp(270),knows_athletics_6|knows_ironflesh_7|knows_shield_3|knows_power_strike_5|knows_tactics_3|knows_leadership_8,sanguo_face1,sanguo_face2,sanguo_face4],

["shu_captain","Shu_Captain","Shu_Captains",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_kingdom_shuhan,[itm_tiekuia,itm_shuwushen1,itm_shuwushen2,itm_qiuspear,itm_shushield,itm_leather_boots,itm_leather_gloves],def_attrib|level(43),wp(300),knows_athletics_7|knows_ironflesh_8|knows_shield_4|knows_power_strike_6|knows_tactics_2|knows_leadership_8,sanguo_face1,sanguo_face2,sanguo_face4],

["shu_youth","Shu_Youth","Shu_Youths",tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_shield,no_scene,reserved,fac_kingdom_shuhan,[itm_straw_hat,itm_toujin,itm_coarse_tunic,itm_shirt,itm_shirt,itm_caoshoes,itm_wrapping_boots,itm_dagger,itm_butchering_knife,itm_falchion,itm_sickle,itm_hammer,itm_wooden_shield],def_attrib|level(3),wp(60),knows_common,sanguo_face1,sanguo_face2,sanguo_face4],

["wu_youth","Wu_Youth","Wu_Youths",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_kingdom_wu,[itm_straw_hat,itm_toujin,itm_shirt,itm_shirt,itm_caoshoes,itm_wrapping_boots,itm_dagger,itm_butchering_knife,itm_falchion,itm_sickle,itm_hammer],def_attrib|level(3),wp(60),knows_common,sanguo_face1,sanguo_face2,sanguo_face4],

["wu_solider","Wu_Solider","Wu_Soliders",tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,no_scene,reserved,fac_kingdom_wu,[itm_butoujin,itm_qinbuwu,itm_bushoes,itm_one_handed_battle_axe,itm_falchion,itm_ge,itm_light_crossbow,itm_bolts],def_attrib|level(6),wp(90),knows_shield_2|knows_athletics_3|knows_power_strike_1|knows_ironflesh_1,sanguo_face1,sanguo_face2],

["wu_trouble_dealing_army","Wu_trouble_dealing_Army","Wu_trouble_dealing_Armys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_kingdom_wu,[itm_tiekuia,itm_zhongpijia,itm_bushoes,itm_xishield,itm_china_50huanshou,itm_china_spear,itm_gea,itm_crossbow,itm_bolts],def_attrib|level(12),wp(150),knows_shield_2|knows_athletics_3|knows_power_strike_2|knows_ironflesh_2,sanguo_face1,sanguo_face2],

["wu_hard_army","Wu_Hard_Army","Wu_Hard_Armys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_wu,[itm_bronzehelmet,itm_liangdanga,itm_leather_gloves,itm_leather_boots,itm_wushield,itm_longlance,itm_china_100huanshou,itm_pick,itm_halberd,itm_light_crossbow,itm_bolts],def_attrib|level(18),wp(180),knows_shield_3|knows_athletics_4|knows_power_strike_3|knows_ironflesh_2,sanguo_face1,sanguo_face2],

["feather_army","Feather_Army","Feather_Armys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_wu,[itm_yuling,itm_zhongpijia,itm_leather_gloves,itm_zhanxie,itm_qitadun,itm_zhanmabardiche,itm_longlance,itm_dayue,itm_crossbow,itm_bolts],def_attrib|level(25),wp(230),knows_shield_4|knows_athletics_5|knows_power_strike_4|knows_ironflesh_2,sanguo_face1,sanguo_face2],

["feather_army_elite","Feather_Army","Feather_Armys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_wu,[itm_yanbiana,itm_lianshen,itm_leather_gloves,itm_zhanxie,itm_qitadun,itm_longaxe,itm_congspear,itm_longlance,itm_heavy_crossbow,itm_bolts],def_attrib|level(30),wp(300),knows_shield_4|knows_athletics_7|knows_power_strike_5|knows_ironflesh_5,sanguo_face1,sanguo_face2],

["wu_lieutenant","Wu_lieutenant","Wu_lieutenants",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_kingdom_wu,[itm_tiekuia,itm_wuwushen1,itm_wuwushen2,itm_wuwushen2,itm_gea,itm_spear1,itm_ironshield,itm_leather_boots,itm_leather_gloves],def_attrib|level(40),wp(270),knows_athletics_6|knows_ironflesh_7|knows_shield_3|knows_power_strike_5|knows_tactics_3|knows_leadership_8,sanguo_face1,sanguo_face2,sanguo_face4],

["wu_captain","Wu_Captain","Wu_Captains",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots,no_scene,reserved,fac_kingdom_wu,[itm_tiekuia,itm_wuwushen1,itm_wuwushen2,itm_longlance,itm_handhalberd,itm_wushield,itm_leather_boots,itm_leather_gloves],def_attrib|level(43),wp(3000),knows_athletics_7|knows_ironflesh_8|knows_shield_4|knows_power_strike_6|knows_tactics_2|knows_leadership_8,sanguo_face1,sanguo_face2,sanguo_face4],

["wei_youth","Wei_Youth","Wei_Youths",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_kingdom_caowei,[itm_straw_hat,itm_toujin,itm_shirt,itm_caoshoes,itm_wrapping_boots,itm_knife,itm_dagger,itm_hammer,itm_sickle,itm_bronzetuff,itm_cleaver,itm_butchering_knife,itm_wooden_staff,itm_pitch_fork],def_attrib|level(3),wp(60),knows_common,sanguo_face1,sanguo_face2,sanguo_face4],

["wei_solider","Wei_Solider","Wei_Soliders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_kingdom_caowei,[itm_butoujin,itm_qinbuwei,itm_bushoes,itm_bronzetuff,itm_banaxe,itm_falchion,itm_wooden_shield],def_attrib|level(6),wp(90),knows_shield_1|knows_athletics_2|knows_ironflesh_1,sanguo_face1,sanguo_face2,sanguo_face4],

["wei_footman","Wei_Footman","Wei_Footmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots,no_scene,reserved,fac_kingdom_caowei,[itm_tiekuia,itm_leatherarmor,itm_bushoes,itm_china_25huanshou,itm_china_ge,itm_china_s_spear,itm_round_shield],def_attrib|level(11),wp(150),knows_athletics_3|knows_ironflesh_2|knows_power_strike_2|knows_shield_1,sanguo_face1,sanguo_face2],

["wei_elite_footman","Wei_Elite_Footman","Wei_Elite_Footmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_caowei,[itm_tiekui,itm_ironarmor,itm_leather_gloves,itm_leather_boots,itm_china_100huanshou,itm_bupick,itm_halberd,itm_spear1,itm_ironshield],def_attrib|level(17),wp(170),knows_athletics_4|knows_ironflesh_2|knows_power_strike_3|knows_shield_2,sanguo_face1,sanguo_face2],

["armored_guarder","Armored_guarder","Armored_guarders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_caowei,[itm_tiekui,itm_tiezhajia,itm_leather_gloves,itm_ironshoes,itm_bupick,itm_longlance,itm_weishield,itm_light_crossbow,itm_bolts],def_attrib|level(24),wp(190),knows_athletics_5|knows_ironflesh_3|knows_power_strike_4|knows_shield_2,sanguo_face1,sanguo_face2],

["armored_guarder_elite","Armored_guarder","Armored_guarders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_caowei,[itm_tiekui,itm_tiezhajia,itm_leather_gloves,itm_ironshoes,itm_bupick,itm_longlance,itm_weishield,itm_crossbow,itm_bolts],def_attrib|level(28),wp(190),knows_athletics_5|knows_ironflesh_4|knows_power_strike_4|knows_shield_3,sanguo_face1,sanguo_face2],

["wei_jiao_flag_holder","Wei_Jiao_Flag_Holder","Wei_Jiao_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots,no_scene,reserved,fac_kingdom_caowei,[itm_pitiezhou,itm_leatherarmor,itm_jiaoflag_wei,itm_leather_boots],def_attrib|level(15),wp(150),knows_common|knows_athletics_2|knows_ironflesh_2,sanguo_face1,sanguo_face2,sanguo_face4],

["wei_ya_flag_holder","Wei_Ya_Flag_Holder","Wei_Ya_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_kingdom_caowei,[itm_pitiezhou,itm_leatherarmor,itm_yaflag,itm_hunter,itm_leather_boots],def_attrib|level(18),wp(170),knows_common|knows_athletics_5|knows_ironflesh_5,sanguo_face1,sanguo_face2,sanguo_face4],

["wei_main_flag_holder","Wei_Main_Flag_Holder","Wei_Main_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse,no_scene,reserved,fac_kingdom_caowei,[itm_yanbian,itm_china_soldier_yq,itm_leather_gloves,itm_leather_boots,itm_nationflag_wei],def_attrib|level(22),wp(190),knows_common|knows_athletics_6|knows_ironflesh_5|knows_riding_5,sanguo_face1,sanguo_face2],

["wei_main_flag_holder_elite","Wei_Main_Flag_Holder","Wei_Main_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse,no_scene,reserved,fac_kingdom_caowei,[itm_yanbian,itm_china_soldier_yq,itm_leather_gloves,itm_leather_boots,itm_nationflag_wei],def_attrib|level(26),wp(200),knows_common|knows_athletics_6|knows_ironflesh_6|knows_riding_5,sanguo_face1,sanguo_face2],

["tiger_fighter","Tiger_Fighter","Tiger_Fighters",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots,no_scene,reserved,fac_kingdom_caowei,[itm_bronzehelmet,itm_zhiliangdang,itm_leather_gloves,itm_leather_boots,itm_longaxe],def_attrib|level(30),wp(230),knows_power_strike_6|knows_ironflesh_3|knows_athletics_5,sanguo_face1,sanguo_face2,sanguo_face4],

["tiger_elite_fighter","Tiger_Elite_Fighter","Tiger_Elite_Fighters",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots,no_scene,reserved,fac_kingdom_caowei,[itm_bronzehelmet,itm_tongarmor,itm_leather_gloves,itm_leather_boots,itm_longaxe],def_attrib|level(35),wp(250),knows_power_strike_6|knows_ironflesh_4|knows_athletics_6,sanguo_face1,sanguo_face2,sanguo_face4],

["tiger_guard","Tiger_Guard","Tiger_Guards",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots,no_scene,reserved,fac_kingdom_caowei,[itm_tiezhou,itm_jintie,itm_leather_gloves,itm_leather_boots,itm_longaxe],def_attrib|level(45),wp(270),knows_power_strike_7|knows_ironflesh_4|knows_athletics_6,sanguo_face1,sanguo_face2,sanguo_face4],

["armoured_infantry","Armoured_Infantry","Armoured_Infantrys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_kingdom_caowei,[itm_tiekuia,itm_ironarmor,itm_leather_gloves,itm_leather_boots,itm_dayue,itm_ironshield,itm_throwing_daggers],def_attrib|level(30),wp(230),knows_shield_2|knows_ironflesh_5|knows_power_strike_5|knows_athletics_3,sanguo_face1,sanguo_face2],

["elite_armoured_infantry","Elite_Armoured_Infantry","Elite_Armoured_Infantry",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_kingdom_caowei,[itm_tiezhou,itm_ironarmora,itm_leather_gloves,itm_ironshoes,itm_dayue,itm_qitadun,itm_throwing_daggers],def_attrib|level(35),wp(250),knows_shield_3|knows_ironflesh_5|knows_power_strike_6|knows_athletics_4,sanguo_face1,sanguo_face2],

["heavy_armoured_infantry","Heavy_Armoured_Infantry","Heavy_Armoured_Infantrys",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_kingdom_caowei,[itm_tiezhou,itm_lianshen,itm_leather_gloves,itm_ironshoes,itm_dayue,itm_qitadun,itm_throwing_daggers],def_attrib|level(45),wp(270),knows_shield_3|knows_ironflesh_6|knows_power_strike_6|knows_athletics_4,sanguo_face1,sanguo_face2],

["wei_lieutenant","Wei_lieutenant","Wei_lieutenants",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_kingdom_caowei,[itm_tiekuia,itm_weiwushen1,itm_weiwushen2,itm_ge,itm_spear1,itm_ironshield,itm_leather_boots,itm_leather_gloves],def_attrib|level(40),wp(270),knows_athletics_6|knows_ironflesh_7|knows_shield_3|knows_power_strike_5|knows_tactics_3|knows_leadership_8,sanguo_face1,sanguo_face2,sanguo_face4],

["wei_captain","Wei_Captain","Wei_Captains",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots,no_scene,reserved,fac_kingdom_caowei,[itm_tiekuia,itm_weiwushen1,itm_weiwushen2,itm_longlance,itm_handhalberd,itm_weishield,itm_leather_boots,itm_leather_gloves],def_attrib|level(43),wp(300),knows_athletics_7|knows_ironflesh_8|knows_shield_4|knows_power_strike_6|knows_tactics_2|knows_leadership_8,sanguo_face1,sanguo_face2,sanguo_face4],

["huang_jin_posseman","Huang_Jin_Posseman","Huang_Jin_Possemans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_ranged,no_scene,reserved,fac_force_headyellow,[itm_guanjin,itm_cheap_shirt,itm_caoshoes,itm_wrapping_boots,itm_stones,itm_dagger,itm_butchering_knife,itm_falchion,itm_bronzetuff,itm_sickle,itm_hammer],def_attrib|level(4),wp(90),knows_common,sanguo_face1,sanguo_face2,sanguo_face4],

["huang_jin_solider","Huang_Jin_Solider","Huang_Jin_Soliders",tf_guarantee_helmet|tf_guarantee_armor,no_scene,reserved,fac_force_headyellow,[itm_guanjin,itm_huangarmor,itm_caoshoes,itm_wrapping_boots,itm_bronzetuff,itm_banaxe,itm_handhalberd,itm_iron_staff,itm_china_s_spear,itm_falchion],def_attrib|level(6),wp(150),knows_power_throw_1|knows_athletics_2|knows_power_strike_1,sanguo_face1,sanguo_face2,sanguo_face4],

["southern_man_barbarian","Southern_Man_Barbarian","Southern_Man_Barbarians",tf_guarantee_helmet|tf_guarantee_armor,no_scene,reserved,fac_force_southsavagery,[itm_leather_cap,itm_rawhide_coat,itm_banaxe,itm_wooden_shield],def_attrib|level(5),wp(70),knows_common|knows_ironflesh_1,sanguo_face1,sanguo_face2,sanguo_face4],

["southern_man_armyman","Southern_Man_Armyman","Southern_Man_Armymans",tf_guarantee_helmet|tf_guarantee_armor,no_scene,reserved,fac_force_southsavagery,[itm_leather_cap,itm_dbspear,itm_banaxe,itm_wooden_shield,itm_short_bow,itm_arrows],def_attrib|level(11),wp(130),knows_common|knows_ironflesh_3|knows_power_strike_2|knows_athletics_3|knows_power_draw_2,sanguo_face1,sanguo_face2,sanguo_face4],

["southern_man_berserker","Southern_Man_Berserker","Southern_Man_Berserkers",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots,no_scene,reserved,fac_force_southsavagery,[itm_beastarmor,itm_leather_cap,itm_leather_gloves,itm_dadao,itm_zhanmabardiche,itm_yue],def_attrib|level(17),wp(190),knows_common|knows_ironflesh_4|knows_power_strike_5|knows_athletics_5,sanguo_face1,sanguo_face2],

["southern_man_cany_armour_solider","Southern_Man_Cany_Armour_solider","Southern_Man_Cany_Armour_soliders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_force_southsavagery,[itm_tenghelmet,itm_tengarmor,itm_leather_gloves,itm_tengshoes,itm_china_100huanshou,itm_tengshield],def_attrib|level(30),wp(250),knows_common|knows_ironflesh_5|knows_power_strike_5|knows_athletics_7|knows_shield_1,sanguo_face1,sanguo_face2,sanguo_face4],

["southern_man_lieutenant","Southern_Man_lieutenant","Southern_Man_lieutenants",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_force_southsavagery,[itm_tenghelmet,itm_tengarmor,itm_tengshoes,itm_ironshield,itm_longlance],def_attrib|level(43),wp(330),knows_common|knows_athletics_7|knows_ironflesh_8|knows_tactics_2|knows_power_strike_7,sanguo_face1,sanguo_face2,sanguo_face4],

["southern_man_jiao_flag_holder","Southern_Man_Jiao_Flag_Holder","Southern_Man_Jiao_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_force_southsavagery,[itm_rawhide_coat,itm_wrapping_boots,itm_jiaoflag_nanman],def_attrib|level(10),wp(150),knows_common|knows_athletics_2|knows_ironflesh_2,sanguo_face1,sanguo_face2,sanguo_face4],

["southern_man_main_flag_holder","Southern_Man_Main_Flag_Holder","Southern_Man_Main_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse,no_scene,reserved,fac_force_southsavagery,[itm_beastarmor,itm_hunter_boots,itm_nanmanflag],def_attrib|level(23),wp(190),knows_common|knows_athletics_6|knows_ironflesh_6|knows_riding_5,sanguo_face1,sanguo_face2],

["eastern_yue_refugee","Eastern_Yue_Refugee","Eastern_Yue_Refugees",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_ranged|tf_guarantee_shield,no_scene,reserved,fac_force_mountainsavagery,[itm_toujin,itm_rawhide_coat,itm_pitch_fork,itm_wooden_shield,itm_hatchet],def_attrib|level(5),wp(70),knows_common|knows_athletics_2,sanguo_face1,sanguo_face2,sanguo_face4],

["eastern_yue_climb_footman","Eastern_Yue_climb_Footman","Eastern_Yue_climb_Footmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_shield,no_scene,reserved,fac_force_mountainsavagery,[itm_beastarmor,itm_china_spear,itm_jarid,itm_round_shield,itm_china_s50huan],def_attrib|level(11),wp(130),knows_common|knows_athletics_4|knows_power_strike_3|knows_power_throw_2|knows_ironflesh_2,sanguo_face1,sanguo_face2,sanguo_face4],

["eastern_yue_flash_footman","Eastern_Yue_Flash_Footman","Eastern_Yue_Flash_Footmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots,no_scene,reserved,fac_force_mountainsavagery,[itm_leather_steppe_cap_a,itm_ragged_outfit,itm_nomad_boots,itm_china_pike,itm_xishield,itm_bronzesword,itm_yue,itm_jarid],def_attrib|level(17),wp(190),knows_common|knows_athletics_5|knows_power_strike_3|knows_power_throw_3|knows_ironflesh_3,sanguo_face1,sanguo_face2,sanguo_face4],

["eastern_yue_fly_footman","Eastern_Yue_Fly_Footman","Eastern_Yue_Fly_Footmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_force_mountainsavagery,[itm_fur_hat,itm_tribal_warrior_outfit,itm_nomad_boots,itm_congspear,itm_ironshield,itm_zhanmabardiche],def_attrib|level(30),wp(250),knows_common|knows_athletics_7|knows_power_strike_5|knows_power_throw_4|knows_ironflesh_4,sanguo_face1,sanguo_face2,sanguo_face4],

["eastern_yue_lieutenant","Eastern_Yue_lieutenant","Eastern_Yue_lieutenants",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse,no_scene,reserved,fac_force_mountainsavagery,[itm_fur_hat,itm_tribal_warrior_outfit,itm_nomad_boots,itm_congspear,itm_ironshield,itm_jarid],def_attrib|level(43),wp(330),knows_common|knows_athletics_10|knows_ironflesh_6|knows_power_strike_7|knows_tactics_2,sanguo_face1,sanguo_face2,sanguo_face4],

["eastern_yue_jiao_flag_holder","Eastern_Yue_Jiao_Flag_Holder","Eastern_Yue_Jiao_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_force_mountainsavagery,[itm_leather_steppe_cap_a,itm_mianpao,itm_leather_boots,itm_jiaoflag_shanyue],def_attrib|level(10),wp(150),knows_common|knows_athletics_2|knows_ironflesh_2,sanguo_face1,sanguo_face2,sanguo_face4],

["storm_troops","Storm troop","Storm troops",tf_guarantee_armor|tf_guarantee_boots,no_scene,reserved,fac_force_peasantry,[itm_mianpao,itm_leather_boots,itm_round_shield,itm_china_100huanshou,],def_attrib|level(10),wp_one_handed(150)|wp_two_handed(150)|wp_polearm(150)|wp_archery(150)|wp_crossbow(150)|wp_throwing(150),knows_ironflesh_3|knows_shield_1|knows_athletics_5|knows_power_strike_4,sanguo_face1,sanguo_face2],

["storm_troops_2","Storm troop","Storm troops",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_shield,no_scene,reserved,fac_force_peasantry,[itm_tiekuia,itm_leatherarmor,itm_leather_boots,itm_ironshield,itm_longlance,],def_attrib|level(15),wp_one_handed(180)|wp_two_handed(180)|wp_polearm(180)|wp_archery(180)|wp_crossbow(180)|wp_throwing(150),knows_ironflesh_3|knows_shield_1|knows_athletics_5|knows_power_strike_4,sanguo_face1,sanguo_face2],

["storm_troops_3","Storm troop","Storm troops",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots,no_scene,reserved,fac_force_peasantry,[itm_yanbian,itm_zhiliangdang,itm_leather_boots,itm_bibardiche,],def_attrib|level(20),wp_one_handed(200)|wp_two_handed(220)|wp_polearm(150)|wp_archery(150)|wp_crossbow(150)|wp_throwing(150),knows_ironflesh_5|knows_shield_3|knows_athletics_7|knows_power_strike_6,sanguo_face1,sanguo_face2],

["storm_troops_4","Storm troop","Storm troops",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots,no_scene,reserved,fac_force_peasantry,[itm_yanbianc,itm_hunzhi,itm_leather_boots,itm_zhongzhandao,],def_attrib|level(25),wp_one_handed(200)|wp_two_handed(280)|wp_polearm(150)|wp_archery(150)|wp_crossbow(150)|wp_throwing(150),knows_ironflesh_6|knows_shield_3|knows_athletics_8|knows_power_strike_7,sanguo_face1,sanguo_face2],

["eastern_yue_main_flag_holder","Eastern_Yue_Main_Flag_Holder","Eastern_Yue_Main_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse,no_scene,reserved,fac_force_mountainsavagery,[itm_leather_steppe_cap_a,itm_shanarmor,itm_leather_boots,itm_shanyueflag],def_attrib|level(23),wp(190),knows_common|knows_athletics_6|knows_ironflesh_6|knows_riding_5,sanguo_face1,sanguo_face2],

#horsearcher begin
["hundred_dead_warrior","Hundred_dead_Warrior","Hundred_dead_Warriors",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_horse,no_scene,reserved,fac_kingdom_wu,[itm_tiekuia,itm_leatherarmor,itm_leather_gloves,itm_leather_boots,itm_killer_crossbow,itm_s_bolts,itm_zhanmabardiche,itm_hzhorse],def_attrib|level(30),wp(230),knows_common|knows_horse_archery_5|knows_ironflesh_3|knows_riding_6|knows_power_strike_3,sanguo_face1,sanguo_face2,sanguo_face4],

["elite_hundred_dead_warrior","Elite_Hundred_Dead_Warrior","Elite_Hundred_Dead_Warriors",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_horse,no_scene,reserved,fac_kingdom_wu,[itm_tiekuia,itm_leatherarmor,itm_leather_gloves,itm_leather_boots,itm_killer_crossbow,itm_s_bolts,itm_zhanmabardiche,itm_hzhorse],def_attrib|level(35),wp(250),knows_common|knows_horse_archery_6|knows_ironflesh_4|knows_riding_6|knows_power_strike_4,sanguo_face1,sanguo_face2,sanguo_face4],

["forlorn_hope","Forlorn_Hope","Forlorn_Hopes",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_horse,no_scene,reserved,fac_kingdom_wu,[itm_tiekuia,itm_leatherarmor,itm_leather_gloves,itm_leather_boots,itm_killer_crossbow,itm_s_bolts,itm_zhanmabardiche,itm_hzhorse],def_attrib|level(45),wp(270),knows_common|knows_horse_archery_7|knows_ironflesh_4|knows_riding_7|knows_power_strike_4,sanguo_face1,sanguo_face2,sanguo_face4],

["northern_xiong_nu_wrangler","Northern_Xiong_Nu_Wrangler","Northern_Xiong_Nu_Wranglers",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_ranged|tf_guarantee_horse,no_scene,reserved,fac_force_hun,[itm_fur_hat,itm_rawhide_coat,itm_short_bow,itm_arrows,itm_scimitar,itm_steppe_horse],def_attrib|level(5),wp(70),knows_common|knows_horse_archery_2|knows_riding_3|knows_power_draw_2,sanguo_face1,sanguo_face2],

["northern_xiong_nu_horse_bowman","Northern_Xiong_Nu_Horse_bowman","Northern_Xiong_Nu_Horse_bowmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_ranged|tf_guarantee_horse,no_scene,reserved,fac_force_hun,[itm_leather_cap,itm_nomad_vest,itm_mianpao,itm_nomad_boots,itm_nomad_bow,itm_arrows,itm_scimitar,itm_wooden_shield,itm_steppe_horse],def_attrib|level(11),wp(130),knows_horse_archery_4|knows_riding_5|knows_power_draw_4|knows_power_strike_2|knows_ironflesh_2,sanguo_face1,sanguo_face2,sanguo_face4],

["northern_xiong_nu_horse_archer","Northern_Xiong_Nu_Horse_archer","Northern_Xiong_Nu_Horse_archers",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_horse,no_scene,reserved,fac_force_hun,[itm_leather_steppe_cap_a,itm_mianpao,itm_nomad_vest,itm_hunter_boots,itm_hide_boots,itm_cavalry_bow,itm_arrows,itm_nomad_sabre,itm_scimitar,itm_wooden_shield,itm_hzhorse],def_attrib|level(17),wp(190),knows_horse_archery_6|knows_riding_6|knows_power_draw_5|knows_power_strike_3|knows_ironflesh_3,sanguo_face1,sanguo_face2,sanguo_face4],

["northern_xiong_nu_strong_horse_bowman","Northern_Xiong_Nu_Strong_Horse_bowman","Northern_Xiong_Nu_Strong_Horse_bowmans",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged|tf_guarantee_horse,no_scene,reserved,fac_force_hun,[itm_xnhelm,itm_xnhunzhi,itm_leather_gloves,itm_leather_boots,itm_hide_boots,itm_war_bow,itm_arrows,itm_scimitar,itm_ironshield,itm_dahorse],def_attrib|level(30),wp(250),knows_horse_archery_8|knows_riding_8|knows_power_draw_6|knows_power_strike_3|knows_ironflesh_4,sanguo_face1,sanguo_face2,sanguo_face4],

["northern_xiong_nu_lieutenant","Northern_Xiong_Nu_lieutenant","Northern_Xiong_Nu_lieutenants",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_force_hun,[itm_xnhelm,itm_xnhunzhi,itm_leather_gloves,itm_leather_boots,itm_war_bow,itm_bodkin_arrows,itm_scimitar,itm_ironshield,itm_dahorse],def_attrib|level(43),wp(330),knows_horse_archery_9|knows_riding_9|knows_power_draw_7|knows_power_strike_4|knows_ironflesh_4|knows_leadership_8,sanguo_face1,sanguo_face2,sanguo_face4],

["northern_xiong_nu_jiao_flag_holder","Northern_Xiong_Nu_Jiao_Flag_Holder","Northern_Xiong_Nu_Jiao_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,no_scene,reserved,fac_force_hun,[itm_fur_hat,itm_nomad_vest,itm_nomad_boots,itm_jiaoflag_xiongnu,itm_steppe_horse],def_attrib|level(10),wp(150),knows_common|knows_riding_6|knows_power_strike_4|knows_ironflesh_3,sanguo_face1,sanguo_face2],

["northern_xiong_nu_main_flag_holder","Northern_Xiong_Nu_Main_Flag_Holder","Northern_Xiong_Nu_Main_Flag_Holders",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_horse,no_scene,reserved,fac_force_hun,[itm_mianpao,itm_felt_steppe_cap,itm_nomad_boots,itm_leather_gloves,itm_xiongnuflag,itm_steppe_horse],def_attrib|level(23),wp(190),knows_common|knows_riding_7|knows_power_strike_4|knows_ironflesh_4,sanguo_face1,sanguo_face2],

["white_horse_vanguard","White_Horse_Vanguard","White_Horse_Vanguards",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_force_peasantry,[itm_leather_cap,itm_zhongpijia,itm_leather_boots,itm_cavalry_bow,itm_arrows,itm_china_50huanshou,itm_budun,itm_courser],def_attrib|level(30),wp(230),knows_riding_6|knows_power_draw_5|knows_horse_archery_6|knows_power_strike_2,sanguo_face1,sanguo_face2],

["white_horse_elite_vanguard","White_Horse_Elite_Vanguard","White_Horse_Elite_Vanguards",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_force_peasantry,[itm_yuling,itm_zhongpijia,itm_leather_boots,itm_strong_bow,itm_barbed_arrows,itm_china_50huanshou,itm_budun,itm_courser],def_attrib|level(35),wp(250),knows_riding_6|knows_power_draw_6|knows_horse_archery_7|knows_power_strike_3,sanguo_face1,sanguo_face2],

["white_horse_follower","White_Horse_Follower","White_Horse_Followers",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_boots|tf_guarantee_horse|tf_guarantee_ranged,no_scene,reserved,fac_force_peasantry,[itm_junmao,itm_hunzhi,itm_leather_boots,itm_strong_bow,itm_barbed_arrows,itm_china_50huanshou,itm_budun,itm_courser],def_attrib|level(45),wp(270),knows_riding_7|knows_power_draw_6|knows_horse_archery_7|knows_power_strike_3,sanguo_face1,sanguo_face2],

























["woman","Woman","Womans",tf_female|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_ranged,no_scene,reserved,fac_force_peasantry,[itm_knife,itm_wooden_staff,itm_hunting_crossbow,itm_bolts,itm_bushoes,itm_womancloth2],def_attrib|level(3),wp_one_handed(60)|wp_two_handed(60)|wp_polearm(60)|wp_archery(60)|wp_crossbow(60)|wp_throwing(60),knows_common,awali_fem1,awali_fem2],

["woman1","Woman","Womans",tf_female|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_ranged,no_scene,reserved,fac_force_peasantry,[itm_knife,itm_wooden_staff,itm_hunting_crossbow,itm_bolts,itm_bushoes,itm_womancloth3],def_attrib|level(8),wp_one_handed(70)|wp_two_handed(60)|wp_polearm(60)|wp_archery(60)|wp_crossbow(80)|wp_throwing(60),knows_common|knows_ironflesh_1|knows_athletics_2,awali_fem1,awali_fem2],

["woman2","Woman","Womans",tf_female|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_ranged,no_scene,reserved,fac_force_peasantry,[itm_china_50longsword,itm_hunting_crossbow,itm_bolts,itm_bushoes,itm_sumpter_horse,itm_womancloth3],def_attrib|level(13),wp_one_handed(80)|wp_two_handed(60)|wp_polearm(60)|wp_archery(60)|wp_crossbow(150)|wp_throwing(60),knows_common|knows_ironflesh_1|knows_power_strike_1|knows_riding_1|knows_athletics_2,awali_fem1,awali_fem2],

["woman3","Woman","Womans",tf_female|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_ranged,no_scene,reserved,fac_force_peasantry,[itm_china_50longsword,itm_light_crossbow,itm_bolts,itm_bushoes,itm_saddle_horse,itm_womancloth3],def_attrib|level(18),wp_one_handed(100)|wp_two_handed(60)|wp_polearm(60)|wp_archery(60)|wp_crossbow(200)|wp_throwing(60),knows_common|knows_ironflesh_2|knows_power_strike_2|knows_riding_2|knows_athletics_3,awali_fem1,awali_fem2],

["farmer","Farmer","Farmers",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_force_peasantry,[itm_knife,itm_dagger,itm_hammer,itm_sickle,itm_bronzetuff,itm_cleaver,itm_butchering_knife,itm_wooden_staff,itm_shirt,itm_straw_hat,itm_toujin,itm_caoshoes,itm_wrapping_boots],def_attrib|level(3),wp_one_handed(60)|wp_two_handed(60)|wp_polearm(60)|wp_archery(60)|wp_crossbow(60)|wp_throwing(60),knows_common,sanguo_face1,sanguo_face2,sanguo_face4],

["volunteer","Volunteer","Volunteers",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_force_peasantry,[itm_toujin,itm_leatherhelmet,itm_shirt,itm_mianpao,itm_bronzetuff,itm_falchion,itm_hatchet,itm_pickaxe,itm_quarter_staff,itm_caoshoes,itm_wrapping_boots],def_attrib|level(5),wp_one_handed(90)|wp_two_handed(90)|wp_polearm(90)|wp_archery(90)|wp_crossbow(90)|wp_throwing(90),knows_common|knows_shield_1|knows_power_strike_1,sanguo_face1,sanguo_face2,sanguo_face4],

["voluntary_footman","voluntary_Footman","voluntary_Footmans",tf_guarantee_armor|tf_guarantee_boots,no_scene,reserved,fac_force_peasantry,[itm_leatherhelmet,itm_guanjin,itm_tiekui,itm_nomad_armor,itm_bushoes,itm_wooden_shield,itm_falchion],def_attrib|level(7),wp_one_handed(120)|wp_two_handed(120)|wp_polearm(120)|wp_archery(120)|wp_crossbow(120)|wp_throwing(120),knows_common|knows_ironflesh_2|knows_shield_2|knows_athletics_3,sanguo_face1,sanguo_face2],

["mercenary","Mercenary","Mercenarys",tf_guarantee_armor|tf_guarantee_boots,no_scene,reserved,fac_force_peasantry,[itm_bronzehelmet,itm_guanjin,itm_toujin,itm_leatherhelmet,itm_leatherarmor,itm_leather_gloves,itm_leather_boots,itm_spear1,itm_china_su,itm_pick,itm_china_50huanshou,itm_banaxe,itm_handhalberd,itm_round_shield,itm_halberd,itm_hunter],def_attrib|level(15),wp_one_handed(150)|wp_two_handed(150)|wp_polearm(150)|wp_archery(150)|wp_crossbow(150)|wp_throwing(150),knows_common|knows_ironflesh_2|knows_shield_4|knows_athletics_3|knows_power_strike_2|knows_riding_4,sanguo_face1,sanguo_face2,sanguo_face4],

["perdue","Perdue","Perdues",tf_guarantee_armor|tf_guarantee_boots,no_scene,reserved,fac_force_peasantry,[itm_bronzehelmet,itm_china_soldier_yq,itm_leather_gloves,itm_leather_boots,itm_courser,itm_round_shield,itm_ironshield,itm_china_100huanshou,itm_jarid,itm_longlance,itm_jian,itm_lianhalberd],def_attrib|level(21),wp_one_handed(180)|wp_two_handed(180)|wp_polearm(180)|wp_archery(180)|wp_crossbow(180)|wp_throwing(180),knows_ironflesh_3|knows_shield_5|knows_athletics_5|knows_power_strike_3|knows_riding_5|knows_power_throw_2,sanguo_face1,sanguo_face2,sanguo_face4],

["voluntary_archer","Voluntary_Archer","Voluntary_Archers",tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged,no_scene,reserved,fac_force_peasantry,[itm_leatherhelmet,itm_guanjin,itm_mianpao,itm_bushoes,itm_hunting_bow,itm_arrows,itm_dagger],def_attrib|level(7),wp_one_handed(120)|wp_two_handed(100)|wp_polearm(120)|wp_archery(140)|wp_crossbow(120)|wp_throwing(120),knows_common|knows_power_draw_2,sanguo_face1,sanguo_face2,sanguo_face4],

["hunderd_steps_archer","Hunderd_Steps_Archer","Hunderd_Steps_Archers",tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged,no_scene,reserved,fac_force_peasantry,[itm_pitiezhou,itm_guanjin,itm_toujin,itm_leatherhelmet,itm_china_soldier_j,itm_bushoes,itm_long_bow,itm_arrows,itm_dagger],def_attrib|level(15),wp_one_handed(150)|wp_two_handed(140)|wp_polearm(150)|wp_archery(160)|wp_crossbow(150)|wp_throwing(150),knows_common|knows_ironflesh_2|knows_power_draw_3|knows_athletics_2|knows_power_strike_1|knows_shield_2,sanguo_face1,sanguo_face2,sanguo_face4],

["mercenaries_end","mercenaries_end","mercenaries_end",tf_hero,no_scene,reserved,fac_commoners,[],def_attrib|level(1),wp(10),knows_common,0x000000000008100401ed90ab14b16521],

["sniper","Sniper","Snipers",tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_ranged,no_scene,reserved,fac_force_peasantry,[itm_bronzehelmet,itm_china_soldier_q,itm_leather_gloves,itm_leather_boots,itm_strong_bow,itm_cavalry_arrows,itm_dagger],def_attrib|level(21),wp_one_handed(180)|wp_two_handed(170)|wp_polearm(180)|wp_archery(190)|wp_crossbow(180)|wp_throwing(180),knows_common|knows_ironflesh_3|knows_power_draw_5|knows_athletics_3|knows_power_strike_1|knows_shield_3,sanguo_face1,sanguo_face2,sanguo_face4],




["mountain_bandit1","Bandit","Bandit",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_force_peasantry,[itm_caoshoes,itm_nomad_boots,itm_bronzetuff,itm_falchion,itm_hammer,itm_hatchet,itm_rawhide_coat,itm_khergit_armor,itm_nomad_armor,itm_hunting_bow,itm_arrows,itm_shield_round_d],def_attrib|level(7),wp_one_handed(80)|wp_two_handed(80)|wp_polearm(60)|wp_archery(60)|wp_crossbow(60)|wp_throwing(60),knows_common,sanguo_face1,sanguo_face2,sanguo_face4],  

["mountain_bandit2","Mountain Bandit","Mountain Bandit",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_force_peasantry,[itm_straw_hat,itm_knife,itm_falchion,itm_pitch_fork,itm_woolen_dress,itm_shirt,itm_nomad_boots,itm_wrapping_boots,itm_sumpter_horse,itm_hunting_bow,itm_arrows,itm_shield_round_e],def_attrib|level(10),wp_one_handed(80)|wp_two_handed(80)|wp_polearm(80)|wp_archery(80)|wp_crossbow(80)|wp_throwing(80),knows_common|knows_horse_archery_2|knows_riding_2,sanguo_face1,sanguo_face2,sanguo_face4], 

["mountain_bandit3","River Bandit","River Bandit",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_force_peasantry,[itm_beastarmor,itm_mianpao,itm_caoshoes,itm_wrapping_boots,itm_bronzetuff,itm_banaxe,itm_throwing_knives,itm_jarid,itm_long_bow,itm_arrows,itm_wooden_shield,itm_china_s50huan],def_attrib|level(10),wp_one_handed(80)|wp_two_handed(80)|wp_polearm(80)|wp_archery(80)|wp_crossbow(80)|wp_throwing(80),knows_common,sanguo_face1,sanguo_face2,sanguo_face4], 

["mountain_bandit4","Strong River Bandit","Strong River Bandit",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_force_peasantry,[itm_woolen_cap,itm_beastarmor,itm_mianpao,itm_caoshoes,itm_wrapping_boots,itm_banaxe,itm_throwing_knives,itm_jarid,itm_long_bow,itm_arrows,itm_spear1,itm_wooden_shield,itm_china_s50huan],def_attrib|level(14),wp_one_handed(80)|wp_two_handed(80)|wp_polearm(80)|wp_archery(80)|wp_crossbow(80)|wp_throwing(80),knows_common,sanguo_face1,sanguo_face2,sanguo_face4], 

["robber","Robber","Robber",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_force_peasantry,[itm_khergit_armor,itm_hunter_boots,itm_wrapping_boots,itm_falchion,itm_handhalberd,itm_knife,itm_wooden_shield,itm_stones],def_attrib|level(12),wp_one_handed(80)|wp_two_handed(80)|wp_polearm(60)|wp_archery(60)|wp_crossbow(60)|wp_throwing(60),knows_common,sanguo_face1,sanguo_face2,sanguo_face4], 

["robbers_leader","Robbers Leader","Robbers Leader",tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_horse,no_scene,reserved,fac_force_peasantry,[itm_leather_cap,itm_nomad_vest,itm_leather_gloves,itm_hide_boots,itm_spear1,itm_china_s50huan,itm_bian,itm_round_shield,itm_sledgehammer,itm_saddle_horse],def_attrib|level(14),wp_one_handed(100)|wp_two_handed(80)|wp_polearm(80)|wp_archery(80)|wp_crossbow(80)|wp_throwing(80),knows_common|knows_riding_2|knows_power_strike_2|knows_athletics_2,sanguo_face1,sanguo_face2],

["nobleman","Nobleman","Nobleman",tf_guarantee_helmet|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_horse,no_scene,reserved,fac_force_defector,[itm_han_wenguanfu1,itm_shamao,itm_leather_gloves,itm_china_50longsword,itm_dianhorsea],def_attrib|level(9),wp_one_handed(90)|wp_two_handed(80)|wp_polearm(80)|wp_archery(80)|wp_crossbow(80)|wp_throwing(80),knows_common,sanguo_face1,sanguo_face2,sanguo_face4],

["caravan_master","caravan master","caravan master",tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_horse,no_scene,reserved,fac_force_peasantry,[itm_leather_gloves,itm_china_50longsword,itm_gaoguan,itm_mianpao,itm_dianhorsea],def_attrib|level(9),wp_one_handed(90)|wp_two_handed(80)|wp_polearm(80)|wp_archery(80)|wp_crossbow(80)|wp_throwing(80),knows_common,sanguo_face1,sanguo_face2,sanguo_face4],


#governers olgrel rasevas
["town_1_ruler_a", "Owqh Casivh", "Owqh Casivhs", tf_hero, scn_xiangping_castle|entry(9),reserved, fac_kingdom_caowei,[itm_xiaoguan,itm_weiwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_2_ruler_a", "Pqet Ioiwzh", "Pqet Ioiwzhs", tf_hero, scn_beiping_castle|entry(9),reserved, fac_kingdom_caowei,[itm_liangguan,itm_weiwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_3_ruler_a", "Bhca Yyhhnd", "Bhca Yyhhnds", tf_hero, scn_beihai_castle|entry(9),reserved, fac_kingdom_caowei,[itm_shamao,itm_weiwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_4_ruler_a", "Wvkf Xfqolx", "Wvkf Xfqolxs", tf_hero, scn_pingyuan_castle|entry(9),reserved, fac_kingdom_caowei,[itm_liangguan,itm_weiwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_5_ruler_a", "Afbh Hijtsn", "Afbh Hijtsns", tf_hero, scn_xiapi_castle|entry(9),reserved, fac_kingdom_caowei,[itm_shamao,itm_weiwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_6_ruler_a", "Pndf Zjmuja", "Pndf Zjmujas", tf_hero, scn_xiangyang_castle|entry(9),reserved, fac_kingdom_caowei,[itm_xiaoguan,itm_weiwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_7_ruler_a", "Nroa Cgyrjk", "Nroa Cgyrjks", tf_hero, scn_changan_castle|entry(9),reserved, fac_kingdom_caowei,[itm_liangguan,itm_weiwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_8_ruler_a", "Vrjr Paumuq", "Vrjr Paumuqs", tf_hero, scn_luoyang_castle|entry(9),reserved, fac_kingdom_caowei,[itm_liangguan,itm_weiwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_9_ruler_a", "Npng Lqadot", "Npng Lqadots", tf_hero, scn_shouchun_castle|entry(9),reserved, fac_kingdom_caowei,[itm_liangguan,itm_weiwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_10_ruler_a", "Ojbr Reprst", "Ojbr Reprsts", tf_hero, scn_xuchang_castle|entry(9),reserved, fac_kingdom_caowei,[itm_shamao,itm_weiwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_11_ruler_a", "Aazz Hoocgq", "Aazz Hoocgqs", tf_hero, scn_runan_castle|entry(9),reserved, fac_kingdom_caowei,[itm_liangguan,itm_weiwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_12_ruler_a", "Vohd Gvxjdk", "Vohd Gvxjdks", tf_hero, scn_wancheng_castle|entry(9),reserved, fac_kingdom_caowei,[itm_shamao,itm_weiwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_13_ruler_a", "Zzzf Pyqoka", "Zzzf Pyqokas", tf_hero, scn_yecheng_castle|entry(9),reserved, fac_kingdom_caowei,[itm_liangguan,itm_weiwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_14_ruler_a", "Ogad Iztpbn", "Ogad Iztpbns", tf_hero, scn_jinyang_castle|entry(9),reserved, fac_kingdom_caowei,[itm_xiaoguan,itm_weiwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_15_ruler_a", "Mkly Lwfmcx", "Mkly Lwfmcxs", tf_hero, scn_anding_castle|entry(9),reserved, fac_kingdom_caowei,[itm_shamao,itm_weiwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_16_ruler_a", "Ulgp Xqbhmd", "Ulgp Xqbhmds", tf_hero, scn_tianshui_castle|entry(9),reserved, fac_kingdom_caowei,[itm_xiaoguan,itm_weiwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_17_ruler_a", "Mike Ughygg", "Mike Ughyggs", tf_hero, scn_sishuiguan_castle|entry(9),reserved, fac_kingdom_caowei,[itm_liangguan,itm_weiwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_18_ruler_a", "Nczp Auwmkg", "Nczp Auwmkgs", tf_hero, scn_hulaoguan_castle|entry(9),reserved, fac_kingdom_caowei,[itm_shamao,itm_weiwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_19_ruler_a", "Zuxx Pevxyd", "Zuxx Pevxyds", tf_hero, scn_tongguan_castle|entry(9),reserved, fac_kingdom_caowei,[itm_xiaoguan,itm_weiwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_20_ruler_a", "Uhfb Pleevw", "Uhfb Pleevws", tf_hero, scn_puyang_castle|entry(9),reserved, fac_kingdom_caowei,[itm_liangguan,itm_weiwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_21_ruler_a", "Yswd Yoxidn", "Yswd Yoxidns", tf_hero, scn_hefei_castle|entry(9),reserved, fac_kingdom_caowei,[itm_shamao,itm_weiwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_43_ruler_a", "Na", "Na", tf_hero, scn_nanpi_castle|entry(9),reserved, fac_kingdom_caowei,[itm_liangguan,itm_weiwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],

["town_22_ruler_a", "Nzxb Rpajua", "Nzxb Rpajuas", tf_hero, scn_jiangxia_castle|entry(9),reserved, fac_kingdom_shuhan,[itm_xiaoguan,itm_shuwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_23_ruler_a", "Ldjw Ummhuj", "Ldjw Ummhujs", tf_hero, scn_yongan_castle|entry(9),reserved, fac_kingdom_shuhan,[itm_liangguan,itm_shuwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_24_ruler_a", "Tedo Ggicfq", "Tedo Ggicfqs", tf_hero, scn_jiangzhou_castle|entry(9),reserved, fac_kingdom_shuhan,[itm_liangguan,itm_shuwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_25_ruler_a", "Lbic Cwotzt", "Lbic Cwotzts", tf_hero, scn_chengdu_castle|entry(9),reserved, fac_kingdom_shuhan,[itm_shamao,itm_shuwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_26_ruler_a", "Mwwn Ikdhdt", "Mwwn Ikdhdts", tf_hero, scn_yunnan_castle|entry(9),reserved, fac_kingdom_shuhan,[itm_liangguan,itm_shuwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_27_ruler_a", "Ynuv Yudsrq", "Ynuv Yudsrqs", tf_hero, scn_shangyong_castle|entry(9),reserved, fac_kingdom_shuhan,[itm_shamao,itm_shuwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_28_ruler_a", "Tbca Ybmzoj", "Tbca Ybmzojs", tf_hero, scn_jiangling_castle|entry(9),reserved, fac_kingdom_shuhan,[itm_xiaoguan,itm_shuwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_29_ruler_a", "Xlub Heedvz", "Xlub Heedvzs", tf_hero, scn_jianning_castle|entry(9),reserved, fac_kingdom_shuhan,[itm_liangguan,itm_shuwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_30_ruler_a", "Msvz Afhemm", "Msvz Afhemms", tf_hero, scn_zitong_castle|entry(9),reserved, fac_kingdom_shuhan,[itm_shamao,itm_shuwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_31_ruler_a", "Ke", "Ke", tf_hero, scn_hanzhong_castle|entry(9),reserved, fac_kingdom_shuhan,[itm_xiaoguan,itm_shuwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_42_ruler_a", "Bo", "Bo", tf_hero, scn_jiange_castle|entry(9),reserved, fac_kingdom_shuhan,[itm_xiaoguan,itm_shuwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],

["town_32_ruler_a", "Ti", "Ti", tf_hero, scn_jianye_castle|entry(9),reserved, fac_kingdom_wu,[itm_shamao,itm_wuwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_33_ruler_a", "Que", "Que", tf_hero, scn_wu_castle|entry(9),reserved, fac_kingdom_wu,[itm_xiaoguan,itm_wuwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_34_ruler_a", "Bao", "Bao", tf_hero, scn_huiji_castle|entry(9),reserved, fac_kingdom_wu,[itm_xiaoguan,itm_wuwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_35_ruler_a", "Bu", "Bu", tf_hero, scn_chaisang_castle|entry(9),reserved, fac_kingdom_wu,[itm_liangguan,itm_wuwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_36_ruler_a", "Pai", "Pai", tf_hero, scn_changsha_castle|entry(9),reserved, fac_kingdom_wu,[itm_shamao,itm_wuwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_37_ruler_a", "Wu", "Wu", tf_hero, scn_wuling_castle|entry(9),reserved, fac_kingdom_wu,[itm_xiaoguan,itm_wuwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_38_ruler_a", "Xian", "Xian", tf_hero, scn_lingling_castle|entry(9),reserved, fac_kingdom_wu,[itm_liangguan,itm_wuwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_39_ruler_a", "Sai", "Sai", tf_hero, scn_guiyang_castle|entry(9),reserved, fac_kingdom_wu,[itm_xiaoguan,itm_wuwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_40_ruler_a", "Jian", "Jian", tf_hero, scn_nanhai_castle|entry(9),reserved, fac_kingdom_wu,[itm_liangguan,itm_wuwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_41_ruler_a", "Ban", "Ban", tf_hero, scn_yiling_castle|entry(9),reserved, fac_kingdom_wu,[itm_liangguan,itm_wuwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_44_ruler_a", "Bi", "Bi", tf_hero, scn_jianan_castle|entry(9),reserved, fac_kingdom_wu,[itm_xiaoguan,itm_wuwenshen2,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],
["town_45_ruler_a", "Nuo", "Nuo", tf_hero, scn_jiaozhi_castle|entry(9),reserved, fac_kingdom_wu,[itm_shamao,itm_wuwenshen1,itm_wenxie],def_attrib|level(2),wp(20),knows_common, sanguo_face3],








#Arena Masters
["town_1_arena_master", "Jingjimaster","Tournament Master",tf_hero, scn_xiangping_arena|entry(52),reserved, fac_commoners,[itm_bushoes,itm_shirt],str_10|agi_10|int_9|cha_9|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_common,0x000000000010000c01cb97582d8d6a53],


# Armor Merchants
["zendar_armorer","Rabugti","Rabugti",tf_hero|tf_is_merchant, scn_zendar_center|entry(4),0,  fac_commoners,[itm_coarse_tunic,itm_bushoes],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c318301f24e38a36e38e3],


["town_1_armorer","Qxkqy","Qxkqy",tf_hero|tf_is_merchant, scn_xiangping_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000c389868f70debb3ba8e440],
["town_2_armorer","Nxcki","Nxcki",tf_hero|tf_is_merchant, scn_beiping_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000007f21576f48caaa576ba1c4],
["town_3_armorer","Xsqhp","Xsqhp",tf_hero|tf_is_merchant, scn_beihai_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000142d6af4511f3578bcbff4],
["town_4_armorer","Qzvfu","Qzvfu",tf_hero|tf_is_merchant, scn_pingyuan_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000a7528812b54cc838e6b499],
["town_5_armorer","Gpajo","Gpajo",tf_hero|tf_is_merchant, scn_xiapi_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000006b702c07ecd40e237a9bd3],
["town_6_armorer","Kozcj","Kozcj",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000166930ce3748f871cb8d81],
["town_7_armorer","Ynoax","Ynoax",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000005b8ff503b3934c92dd082b],
["town_8_armorer","Imjgo","Imjgo",tf_hero|tf_is_merchant, scn_luoyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000094d1f14f28e95b9f08b951],
["town_9_armorer","Bjycz","Bjycz",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000dcd5e9f706c34cee0d9643],
["town_10_armorer","Qamze","Qamze",tf_hero|tf_is_merchant, scn_xuchang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000a9bea282c1f87d3476c234],
["town_11_armorer","Tjnkv","Tjnkv",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000009b3f2abe9a69592bed86b2],
["town_12_armorer","Mchyl","Mchyl",tf_hero|tf_is_merchant, scn_wancheng_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000000f06c7cd5f0b631716d2e3],
["town_13_armorer","Pdyzf","Pdyzf",tf_hero|tf_is_merchant, scn_yecheng_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000006d507b7f513351bc95ad7e],
["town_14_armorer","Ikzkk","Ikzkk",tf_hero|tf_is_merchant, scn_jinyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000b9d2a3f386bd31cd0b34d5],
["town_15_armorer","Qzaid","Qzaid",tf_hero|tf_is_merchant, scn_anding_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000025a473e227e6f5311dbd43],
["town_16_armorer","Zstjy","Zstjy",tf_hero|tf_is_merchant, scn_tianshui_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000004290bdb48511d097499de3],
["town_17_armorer","Wghru","Wghru",tf_hero|tf_is_merchant, scn_sishuiguan_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000029136547aa66b2252ed2e8],
["town_18_armorer","Dekbg","Dekbg",tf_hero|tf_is_merchant, scn_hulaoguan_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000004a2eb2d47cc3c10d702df1],
["town_19_armorer","Jmced","Jmced",tf_hero|tf_is_merchant, scn_tongguan_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000082c910e5f0076108067b1f],
["town_20_armorer","Gojzx","Gojzx",tf_hero|tf_is_merchant, scn_puyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000020651c817d21efbc7502bb],
["town_21_armorer","Lsviu","Lsviu",tf_hero|tf_is_merchant, scn_hefei_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000055c5956167e34c7b1ddd6d],
["town_43_armorer","Zu","Zu",tf_hero|tf_is_merchant, scn_nanpi_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],

["town_22_armorer","Fkdgi","Fkdgi",tf_hero|tf_is_merchant, scn_jiangxia_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000dc45f57112eb152e546f9f],
["town_23_armorer","Eogxo","Eogxo",tf_hero|tf_is_merchant, scn_yongan_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000e202cac1482f439dd824dc],
["town_24_armorer","Fljwu","Fljwu",tf_hero|tf_is_merchant, scn_jiangzhou_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000d214a84c71c9518dd5bf2e],
["town_25_armorer","Ivtpq","Ivtpq",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000fd986fa482fc52455ecd71],
["town_26_armorer","Gqdvu","Gqdvu",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000008693da9b8f60da059d263f],
["town_27_armorer","Xjoxt","Xjoxt",tf_hero|tf_is_merchant, scn_shangyong_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000000e3e91cdb73cbe534cb48d],
["town_28_armorer","Fpink","Fpink",tf_hero|tf_is_merchant, scn_jiangling_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000003ca3cb8243f1726949a965],
["town_29_armorer","Coxqm","Coxqm",tf_hero|tf_is_merchant, scn_jianning_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000007623cf117238f1c4466ce3],
["town_30_armorer","Jvtzj","Jvtzj",tf_hero|tf_is_merchant, scn_zitong_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000c5e9798d3f04e8eaea42f5],
["town_31_armorer","Ji","Ji",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_42_armorer","Chong","Chong",tf_hero|tf_is_merchant, scn_jiange_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],

["town_32_armorer","Yan","Yan",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_33_armorer","Lv","Lv",tf_hero|tf_is_merchant, scn_wu_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_34_armorer","Non","Non",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_35_armorer","Yi","Yi",tf_hero|tf_is_merchant, scn_chaisang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_36_armorer","Lian","Lian",tf_hero|tf_is_merchant, scn_changsha_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_37_armorer","Tuan","Tuan",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_38_armorer","Zhu","Zhu",tf_hero|tf_is_merchant, scn_lingling_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_39_armorer","De","De",tf_hero|tf_is_merchant, scn_guiyang_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_40_armorer","He","He",tf_hero|tf_is_merchant, scn_nanhai_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_41_armorer","Gao","Gao",tf_hero|tf_is_merchant, scn_yiling_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_44_armorer","Bie","Bie",tf_hero|tf_is_merchant, scn_jianan_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_45_armorer","Lei","Lei",tf_hero|tf_is_merchant, scn_jiaozhi_center|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],

# Weapon merchants
 ["zendar_weaponsmith","Dunga","Dunga",tf_hero|tf_is_merchant, scn_zendar_center|entry(3),0,  fac_commoners,[itm_shirt,itm_bushoes],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000021c401f545a49b6eb2bc],


["town_1_weaponsmith","Kkfhr","Kkfhr",tf_hero|tf_is_merchant, scn_xiangping_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000d9b9be20fa543f734732b3],
["town_2_weaponsmith","Xzlve","Xzlve",tf_hero|tf_is_merchant, scn_beiping_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000000f54137f8b2545149a5e49],
["town_3_weaponsmith","Mxurr","Mxurr",tf_hero|tf_is_merchant, scn_beihai_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000008eb69f5e2d7a0d9c7e9d13],
["town_4_weaponsmith","Abetv","Abetv",tf_hero|tf_is_merchant, scn_pingyuan_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000e7c7713e6d5acefa3085c6],
["town_5_weaponsmith","Wsaug","Wsaug",tf_hero|tf_is_merchant, scn_xiapi_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000004259ead22a7efcf0d188a2],
["town_6_weaponsmith","Xqzdh","Xqzdh",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000003b96a596cec2eb3cee7f2d],
["town_7_weaponsmith","Sbkom","Sbkom",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000a17eff97d75655b45022e5],
["town_8_weaponsmith","Spxpu","Spxpu",tf_hero|tf_is_merchant, scn_luoyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000b6a523edf915c292a25626],
["town_9_weaponsmith","Onlyd","Onlyd",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000061a782a5f4b11709e752e3],
["town_10_weaponsmith","Wralh","Wralh",tf_hero|tf_is_merchant, scn_xuchang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000006b2d5fe4a3ec58b1a35666],
["town_11_weaponsmith","Mlbnf","Mlbnf",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000065711bc3ae52c4c1cbe859],
["town_12_weaponsmith","Gppru","Gppru",tf_hero|tf_is_merchant, scn_wancheng_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000e65f8d7c1c5b94cac3329a],
["town_13_weaponsmith","Meslx","Meslx",tf_hero|tf_is_merchant, scn_yecheng_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000023b40b30542e074586d1db],
["town_14_weaponsmith","Lpmnk","Lpmnk",tf_hero|tf_is_merchant, scn_jinyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000a5469e3a42de0855b13bb3],
["town_15_weaponsmith","Pguxc","Pguxc",tf_hero|tf_is_merchant, scn_anding_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000095ac02534a898a2677ac6e],
["town_16_weaponsmith","Bjalu","Bjalu",tf_hero|tf_is_merchant, scn_tianshui_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000028ddd96a6803901053505f],
["town_17_weaponsmith","Fqqjn","Fqqjn",tf_hero|tf_is_merchant, scn_sishuiguan_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000ed3931a4ae8e97e5049e67],
["town_18_weaponsmith","Vmtqh","Vmtqh",tf_hero|tf_is_merchant, scn_hulaoguan_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000067d279c3186b0564b5d2fa],
["town_19_weaponsmith","Iccry","Iccry",tf_hero|tf_is_merchant, scn_tongguan_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000004f547e37dc202fc193e4ef],
["town_20_weaponsmith","Aqhze","Aqhze",tf_hero|tf_is_merchant, scn_puyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000c7acdadd58dd668aaf3d26],
["town_21_weaponsmith","Uhmko","Uhmko",tf_hero|tf_is_merchant, scn_hefei_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000009c4699b9c1d13c814cd9fa],
["town_43_weaponsmith","Ao","Ao",tf_hero|tf_is_merchant, scn_nanpi_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],

["town_22_weaponsmith","Qvtpb","Qvtpb",tf_hero|tf_is_merchant, scn_jiangxia_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000b91c8f422dccebbfa785ca],
["town_23_weaponsmith","Mebeb","Mebeb",tf_hero|tf_is_merchant, scn_yongan_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000002d9690c11d43e4f6c97aea],
["town_24_weaponsmith","Psavw","Psavw",tf_hero|tf_is_merchant, scn_jiangzhou_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000085e4c9349fad639678c05a],
["town_25_weaponsmith","Rcbta","Rcbta",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000009493f0613fefd24bc23b72],
["town_26_weaponsmith","Asxrj","Asxrj",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000019c7c6210fd5a171141629],
["town_27_weaponsmith","Gdeje","Gdeje",tf_hero|tf_is_merchant, scn_shangyong_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000006fb5fefe1e2762c129c519],
["town_28_weaponsmith","Pjlyg","Pjlyg",tf_hero|tf_is_merchant, scn_jiangling_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000be029a956713685c29b8ad],
["town_29_weaponsmith","Yjpam","Yjpam",tf_hero|tf_is_merchant, scn_jianning_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000c052c983d5caddda54e342],
["town_30_weaponsmith","Rpdqk","Rpdqk",tf_hero|tf_is_merchant, scn_zitong_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000ad3dbd12a3d0d57c04b0a5],
["town_31_weaponsmith","Pi","Pi",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],
["town_42_weaponsmith","Feng","Feng",tf_hero|tf_is_merchant, scn_jiange_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],

["town_32_weaponsmith","Ma","Ma",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],
["town_33_weaponsmith","Tu","Tu",tf_hero|tf_is_merchant, scn_wu_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],
["town_34_weaponsmith","Ro","Ro",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],
["town_35_weaponsmith","Fen","Fen",tf_hero|tf_is_merchant, scn_chaisang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],
["town_36_weaponsmith","Xue","Xue",tf_hero|tf_is_merchant, scn_changsha_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],
["town_37_weaponsmith","Su","Su",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],
["town_38_weaponsmith","Pu","Pu",tf_hero|tf_is_merchant, scn_lingling_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],
["town_39_weaponsmith","Ci","Ci",tf_hero|tf_is_merchant, scn_guiyang_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],
["town_40_weaponsmith","Ruo","Ruo",tf_hero|tf_is_merchant, scn_nanhai_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],
["town_41_weaponsmith","Kao","Kao",tf_hero|tf_is_merchant, scn_yiling_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],
["town_44_weaponsmith","Lao","Lao",tf_hero|tf_is_merchant, scn_jianan_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],
["town_45_weaponsmith","Gao","Gao",tf_hero|tf_is_merchant, scn_jiaozhi_center|entry(10),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face5],

#Tavern keepers
  ["zendar_tavernkeeper","Tavernkeeper","Tavernkeeper", tf_hero, scn_the_happy_boar|entry(1),0, fac_commoners,[itm_leather_apron,itm_bushoes],def_attrib|level(2),wp(20),knows_common, 0x00000000000c114501e36db6db6db6db],
  
  ["town_1_tavernkeeper","Turegor","Turegor",tf_hero,scn_xiangping_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, 0x00000000000c218701e351450caad563],
  ["town_2_tavernkeeper","Matheas","Matheas", tf_hero, scn_beiping_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, 0x00000000001031c101e35128e268d44b],
  ["town_3_tavernkeeper","Imbrea","Imbrea", tf_hero|tf_female, scn_beihai_tavern|entry(9),0,  fac_kingdom_caowei,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, 0x000000000008000201ca45468bb4c4a2],
  ["town_4_tavernkeeper","Falsevor","Falsevor", tf_hero, scn_pingyuan_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, 0x000000000004420301e352496eb4d44b],
  ["town_5_tavernkeeper","Gharmall","Gharmall", tf_hero, scn_xiapi_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, 0x000000000008520301ca492689265db6],
  ["town_6_tavernkeeper","Belinda","Belinda", tf_hero|tf_female, scn_xiangyang_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, 0x000000000008100401db6dc7214e26d4],
  ["town_7_tavernkeeper","Ruby","Ruby", tf_hero|tf_female, scn_changan_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, 0x00000000000c200301db6dc692492492],
  ["town_8_tavernkeeper","Awalijiu","Awalijiu",tf_female|tf_hero|tf_is_merchant, scn_luoyang_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_womancloth3],def_attrib|level(12),wp(20),knows_inventory_management_10, awali_face1],
  ["town_9_tavernkeeper","Manjiu","Manjiu",tf_hero|tf_is_merchant, scn_shouchun_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_shirt2],str_12|def_attrib|level(12),wp(20),knows_inventory_management_10, sanguo_face4],
  ["town_10_tavernkeeper","Mengjiu","Mengjiu",tf_hero|tf_is_merchant, scn_xuchang_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_shirt2],def_attrib|level(12),wp(20),knows_inventory_management_10, 0x000000000000134a01dd5b5820a6a385],
  ["town_11_tavernkeeper","Qaelmas","Qaelmas", tf_hero, scn_runan_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, 0x00000000000c628601edb64b09249249],
  ["town_12_tavernkeeper","Rose","Rose", tf_hero|tf_female, scn_wancheng_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, 0x000000000010500401db6dc692492492],
  ["town_13_tavernkeeper","Ralcha","Ralcha", tf_hero|tf_female, scn_yecheng_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, 0x000000000000000401cb6dc724912492],
  ["town_14_tavernkeeper","Naldera","Naldera", tf_hero|tf_female, scn_jinyang_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, 0x00000000000c300701e36dc6db6db91a],
  ["town_15_tavernkeeper","Laruqen","Laruqen", tf_hero, scn_anding_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, 0x00000000000c734901d924928b6c9249],
  ["town_16_tavernkeeper","Willow","Willow", tf_hero|tf_female, scn_tianshui_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, 0x00000000000c100101e36924d5b5b91a],
  ["town_17_tavernkeeper","Reamald","Reamald", tf_hero, scn_sishuiguan_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, 0x00000000000c800001da49192d6de75d],
  ["town_18_tavernkeeper","Turegor","Turegor",tf_hero,scn_hulaoguan_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_19_tavernkeeper","Matheas","Matheas", tf_hero, scn_tongguan_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_20_tavernkeeper","Imbrea","Imbrea", tf_hero|tf_female, scn_puyang_tavern|entry(9),0,  fac_kingdom_caowei,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_21_tavernkeeper","Falsevor","Falsevor", tf_hero, scn_hefei_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_43_tavernkeeper","Que","Que", tf_hero|tf_female, scn_nanpi_tavern|entry(9),0, fac_kingdom_caowei,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, sanguo_face4],

  ["town_22_tavernkeeper","Naldera","Naldera", tf_hero|tf_female, scn_jiangxia_tavern|entry(9),0, fac_kingdom_shuhan,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_23_tavernkeeper","Ba","Ba", tf_hero, scn_yongan_tavern|entry(9),0, fac_kingdom_shuhan,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_24_tavernkeeper","Cu","Cu", tf_hero, scn_jiangzhou_tavern|entry(9),0, fac_kingdom_shuhan,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_25_tavernkeeper","Ye","Ye", tf_hero|tf_female, scn_chengdu_tavern|entry(9),0, fac_kingdom_shuhan,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_26_tavernkeeper","Qiao","Qiao", tf_hero, scn_yunnan_tavern|entry(9),0, fac_kingdom_shuhan,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_27_tavernkeeper","Nian","Nian",tf_hero,scn_shangyong_tavern|entry(9),0, fac_kingdom_shuhan,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_28_tavernkeeper","Li","Li", tf_hero, scn_jiangling_tavern|entry(9),0, fac_kingdom_shuhan,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_29_tavernkeeper","Te","Te", tf_hero|tf_female, scn_jianning_tavern|entry(9),0,  fac_kingdom_shuhan,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_30_tavernkeeper","Che","Che", tf_hero, scn_zitong_tavern|entry(9),0, fac_kingdom_shuhan,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_31_tavernkeeper","Huo","Huo", tf_hero, scn_hanzhong_tavern|entry(9),0, fac_kingdom_shuhan,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_42_tavernkeeper","Ma","Ma", tf_hero|tf_female, scn_jiange_tavern|entry(9),0, fac_kingdom_shuhan,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, sanguo_face4],

  ["town_32_tavernkeeper","Zhen","Zhen", tf_hero, scn_jianye_tavern|entry(9),0, fac_kingdom_wu,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_33_tavernkeeper","Bei","Bei", tf_hero|tf_female, scn_wu_tavern|entry(9),0, fac_kingdom_wu,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_34_tavernkeeper","Bai","Bai", tf_hero|tf_female, scn_huiji_tavern|entry(9),0, fac_kingdom_wu,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_35_tavernkeeper","Yu","Yu",tf_female|tf_hero|tf_is_merchant, scn_chaisang_tavern|entry(9),0, fac_kingdom_wu,[itm_bushoes,itm_womancloth3],def_attrib|level(12),wp(20),knows_inventory_management_10, awali_face1],
  ["town_36_tavernkeeper","Manjiu","Manjiu",tf_hero|tf_is_merchant, scn_changsha_tavern|entry(9),0, fac_kingdom_wu,[itm_bushoes,itm_shirt2],str_12|def_attrib|level(12),wp(20),knows_inventory_management_10, sanguo_face4],
  ["town_37_tavernkeeper","Mengjiu","Mengjiu",tf_hero|tf_is_merchant, scn_wuling_tavern|entry(9),0, fac_kingdom_wu,[itm_bushoes,itm_shirt2],def_attrib|level(12),wp(20),knows_inventory_management_10, sanguo_face4],
  ["town_38_tavernkeeper","Alan","Alan",tf_hero|tf_is_merchant, scn_lingling_tavern|entry(9),0, fac_kingdom_wu,[itm_bushoes,itm_shirt2],def_attrib|level(12),wp(20),knows_inventory_management_10, sanguo_face4],
  ["town_39_tavernkeeper","Qin","Qin", tf_hero, scn_guiyang_tavern|entry(9),0, fac_kingdom_wu,[itm_bushoes,itm_shirt2],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_40_tavernkeeper","Zhe","Zhe", tf_hero|tf_female, scn_nanhai_tavern|entry(9),0, fac_kingdom_wu,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_41_tavernkeeper","Cha","Cha", tf_hero|tf_female, scn_yiling_tavern|entry(9),0, fac_kingdom_wu,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_44_tavernkeeper","Chai","Chai", tf_hero|tf_female, scn_jianan_tavern|entry(9),0, fac_kingdom_wu,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, sanguo_face4],
  ["town_45_tavernkeeper","Ca","Ca", tf_hero|tf_female, scn_jiaozhi_tavern|entry(9),0, fac_kingdom_wu,[itm_bushoes,itm_womancloth3],def_attrib|level(2),wp(20),knows_common, sanguo_face4],

     

#Goods Merchants
["zendar_merchant","Prescan","Prescan",tf_hero|tf_is_merchant, scn_zendar_merchant|entry(1),0, fac_commoners,[itm_leather_apron,itm_bushoes],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],


["town_1_merchant","Unnbm","Unnbm",tf_hero|tf_is_merchant, scn_xiangping_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000f5ce3df47d916a175170fa],
["town_2_merchant","Fwlah","Fwlah",tf_hero|tf_is_merchant, scn_beiping_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000008891173a4f4702870e6154],
["town_3_merchant","Siodt","Siodt",tf_hero|tf_is_merchant, scn_beihai_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000ac97197102d87f81d2ca24],
["town_4_merchant","Foyoc","Foyoc",tf_hero|tf_is_merchant, scn_pingyuan_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000a0724f1a3c13ec81210041],
["town_5_merchant","Qgeuz","Qgeuz",tf_hero|tf_is_merchant, scn_xiapi_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000061a2cf9b123c865fd27532],
["town_6_merchant","Qmkwg","Qmkwg",tf_hero|tf_is_merchant, scn_xiangyang_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000008904070415b15e64d5fb25],
["town_7_merchant","Tamfo","Tamfo",tf_hero|tf_is_merchant, scn_changan_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000004ac3cc4a774b7cc659034],
["town_8_merchant","Zxbut","Zxbut",tf_hero|tf_is_merchant, scn_luoyang_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000b6f1547b126ede34f1213a],
["town_9_merchant","Tdaac","Tdaac",tf_hero|tf_is_merchant, scn_shouchun_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000833c00bed761bce5dd06ff],
["town_10_merchant","Hghbs","Hghbs",tf_hero|tf_is_merchant, scn_xuchang_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000786b4ed412cd27f709d8bb],
["town_11_merchant","Fayok","Fayok",tf_hero|tf_is_merchant, scn_runan_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000006b54aad24d3e3d2eedfe55],
["town_12_merchant","Ihamk","Ihamk",tf_hero|tf_is_merchant, scn_wancheng_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000fdd03684d8204bc550f05d],
["town_13_merchant","Wiedb","Wiedb",tf_hero|tf_is_merchant, scn_yecheng_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000e1690192553c1c300c0062],
["town_14_merchant","Rlvfp","Rlvfp",tf_hero|tf_is_merchant, scn_jinyang_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000049cc164a1783d8ef5c2c4f],
["town_15_merchant","Rgthi","Rgthi",tf_hero|tf_is_merchant, scn_anding_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000347640bd48cdcfd6bd9c84],
["town_16_merchant","Jwgyt","Jwgyt",tf_hero|tf_is_merchant, scn_tianshui_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000e4c1da8f0c2b3b6fdc30a1],
["town_17_merchant","Hobaq","Hobaq",tf_hero|tf_is_merchant, scn_sishuiguan_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000ce9e6843bcf15f3b9ff912],
["town_18_merchant","Rvdgi","Rvdgi",tf_hero|tf_is_merchant, scn_hulaoguan_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000016b6516c5f8104121a5895],
["town_19_merchant","Ddecv","Ddecv",tf_hero|tf_is_merchant, scn_tongguan_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000007d14731c9743e16ec3ac37],
["town_20_merchant","Ubrxy","Ubrxy",tf_hero|tf_is_merchant, scn_puyang_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000a21fe13f96ca2be56d3ba5],
["town_21_merchant","Uyvde","Uyvde",tf_hero|tf_is_merchant, scn_hefei_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000c2b87806a59fa54b1fac40],
["town_43_merchant","En","En",tf_hero|tf_is_merchant, scn_nanpi_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],

["town_22_merchant","Rswvu","Rswvu",tf_hero|tf_is_merchant, scn_jiangxia_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000b13f4a9a9dcc242f1470f7],
["town_23_merchant","Dnzcy","Dnzcy",tf_hero|tf_is_merchant, scn_yongan_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000069e510109c776f1773c539],
["town_24_merchant","Syrqq","Syrqq",tf_hero|tf_is_merchant, scn_jiangzhou_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000a48c4fed34b032a1b1b37f],
["town_25_merchant","Qdxjl","Qdxjl",tf_hero|tf_is_merchant, scn_chengdu_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000000d2bb9d85f78a75ccc9d94],
["town_26_merchant","Pxfwj","Pxfwj",tf_hero|tf_is_merchant, scn_yunnan_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000075d5a4081ad5dc1c841437],
["town_27_merchant","Rxlzg","Rxlzg",tf_hero|tf_is_merchant, scn_shangyong_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000061aaa72345ace88a918fe],
["town_28_merchant","Wbdzz","Wbdzz",tf_hero|tf_is_merchant, scn_jiangling_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000f173955dcc37df45ae138e],
["town_29_merchant","Rhjbr","Rhjbr",tf_hero|tf_is_merchant, scn_jianning_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000047d26a2c657974d34e9a20],
["town_30_merchant","Wpuya","Wpuya",tf_hero|tf_is_merchant, scn_zitong_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000002590c936bab186683f3b80],
["town_31_merchant","Yue","Yue",tf_hero|tf_is_merchant, scn_hanzhong_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],
["town_42_merchant","An","An",tf_hero|tf_is_merchant, scn_jiange_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],

["town_32_merchant","Cai","Cai",tf_hero|tf_is_merchant, scn_jianye_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],
["town_33_merchant","Lo","Lo",tf_hero|tf_is_merchant, scn_wu_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],
["town_34_merchant","Fei","Fei",tf_hero|tf_is_merchant, scn_huiji_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],
["town_35_merchant","Sen","Sen",tf_hero|tf_is_merchant, scn_chaisang_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],
["town_36_merchant","Liw","Liw",tf_hero|tf_is_merchant, scn_changsha_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],
["town_37_merchant","Pen","Pen",tf_hero|tf_is_merchant, scn_wuling_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],
["town_38_merchant","Zhang","Zhang",tf_hero|tf_is_merchant, scn_lingling_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],
["town_39_merchant","Hwang","Hwang",tf_hero|tf_is_merchant, scn_guiyang_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],
["town_40_merchant","Lee","Lee",tf_hero|tf_is_merchant, scn_nanhai_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],
["town_41_merchant","Pan","Pan",tf_hero|tf_is_merchant, scn_yiling_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],
["town_44_merchant","Lo","Lo",tf_hero|tf_is_merchant, scn_jianan_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],
["town_45_merchant","Han","Han",tf_hero|tf_is_merchant, scn_jiaozhi_store|entry(9),0, fac_commoners,[itm_bushoes,itm_shirt1],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face7],
#horse_merchant
["zendar_horse_merchant","Rabugti","Rabugti",tf_hero|tf_is_merchant, scn_zendar_center|entry(12),0,  fac_commoners,[itm_coarse_tunic,itm_bushoes],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c318301f24e38a36e38e3],


["town_1_horse_merchant","Qxkqy","Qxkqy",tf_hero|tf_is_merchant, scn_xiangping_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000c389868f70debb3ba8e440],
["town_2_horse_merchant","Nxcki","Nxcki",tf_hero|tf_is_merchant, scn_beiping_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000007f21576f48caaa576ba1c4],
["town_3_horse_merchant","Xsqhp","Xsqhp",tf_hero|tf_is_merchant, scn_beihai_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000142d6af4511f3578bcbff4],
["town_4_horse_merchant","Qzvfu","Qzvfu",tf_hero|tf_is_merchant, scn_pingyuan_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000a7528812b54cc838e6b499],
["town_5_horse_merchant","Gpajo","Gpajo",tf_hero|tf_is_merchant, scn_xiapi_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000006b702c07ecd40e237a9bd3],
["town_6_horse_merchant","Kozcj","Kozcj",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000166930ce3748f871cb8d81],
["town_7_horse_merchant","Ynoax","Ynoax",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000005b8ff503b3934c92dd082b],
["town_8_horse_merchant","Imjgo","Imjgo",tf_hero|tf_is_merchant, scn_luoyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000094d1f14f28e95b9f08b951],
["town_9_horse_merchant","Bjycz","Bjycz",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000dcd5e9f706c34cee0d9643],
["town_10_horse_merchant","Qamze","Qamze",tf_hero|tf_is_merchant, scn_xuchang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000a9bea282c1f87d3476c234],
["town_11_horse_merchant","Tjnkv","Tjnkv",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000009b3f2abe9a69592bed86b2],
["town_12_horse_merchant","Mchyl","Mchyl",tf_hero|tf_is_merchant, scn_wancheng_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000000f06c7cd5f0b631716d2e3],
["town_13_horse_merchant","Pdyzf","Pdyzf",tf_hero|tf_is_merchant, scn_yecheng_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000006d507b7f513351bc95ad7e],
["town_14_horse_merchant","Ikzkk","Ikzkk",tf_hero|tf_is_merchant, scn_jinyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000b9d2a3f386bd31cd0b34d5],
["town_15_horse_merchant","Qzaid","Qzaid",tf_hero|tf_is_merchant, scn_anding_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000025a473e227e6f5311dbd43],
["town_16_horse_merchant","Zstjy","Zstjy",tf_hero|tf_is_merchant, scn_tianshui_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000004290bdb48511d097499de3],
["town_17_horse_merchant","Wghru","Wghru",tf_hero|tf_is_merchant, scn_sishuiguan_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000029136547aa66b2252ed2e8],
["town_18_horse_merchant","Dekbg","Dekbg",tf_hero|tf_is_merchant, scn_hulaoguan_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000004a2eb2d47cc3c10d702df1],
["town_19_horse_merchant","Jmced","Jmced",tf_hero|tf_is_merchant, scn_tongguan_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000082c910e5f0076108067b1f],
["town_20_horse_merchant","Gojzx","Gojzx",tf_hero|tf_is_merchant, scn_puyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000020651c817d21efbc7502bb],
["town_21_horse_merchant","Lsviu","Lsviu",tf_hero|tf_is_merchant, scn_hefei_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x000000000055c5956167e34c7b1ddd6d],
["town_43_horse_merchant","Zu","Zu",tf_hero|tf_is_merchant, scn_nanpi_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],

["town_22_horse_merchant","Fkdgi","Fkdgi",tf_hero|tf_is_merchant, scn_jiangxia_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000dc45f57112eb152e546f9f],
["town_23_horse_merchant","Eogxo","Eogxo",tf_hero|tf_is_merchant, scn_yongan_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000e202cac1482f439dd824dc],
["town_24_horse_merchant","Fljwu","Fljwu",tf_hero|tf_is_merchant, scn_jiangzhou_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000d214a84c71c9518dd5bf2e],
["town_25_horse_merchant","Ivtpq","Ivtpq",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000fd986fa482fc52455ecd71],
["town_26_horse_merchant","Gqdvu","Gqdvu",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000008693da9b8f60da059d263f],
["town_27_horse_merchant","Xjoxt","Xjoxt",tf_hero|tf_is_merchant, scn_shangyong_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000000e3e91cdb73cbe534cb48d],
["town_28_horse_merchant","Fpink","Fpink",tf_hero|tf_is_merchant, scn_jiangling_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000003ca3cb8243f1726949a965],
["town_29_horse_merchant","Coxqm","Coxqm",tf_hero|tf_is_merchant, scn_jianning_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x00000000007623cf117238f1c4466ce3],
["town_30_horse_merchant","Jvtzj","Jvtzj",tf_hero|tf_is_merchant, scn_zitong_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, 0x0000000000c5e9798d3f04e8eaea42f5],
["town_31_horse_merchant","Ji","Ji",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_42_horse_merchant","Chong","Chong",tf_hero|tf_is_merchant, scn_jiange_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],

["town_32_horse_merchant","Yan","Yan",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_33_horse_merchant","Lv","Lv",tf_hero|tf_is_merchant, scn_wu_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_34_horse_merchant","Non","Non",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_35_horse_merchant","Yi","Yi",tf_hero|tf_is_merchant, scn_chaisang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_36_horse_merchant","Lian","Lian",tf_hero|tf_is_merchant, scn_changsha_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_37_horse_merchant","Tuan","Tuan",tf_hero|tf_is_merchant, scn_xiangyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_38_horse_merchant","Zhu","Zhu",tf_hero|tf_is_merchant, scn_lingling_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_39_horse_merchant","De","De",tf_hero|tf_is_merchant, scn_guiyang_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_40_horse_merchant","He","He",tf_hero|tf_is_merchant, scn_nanhai_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_41_horse_merchant","Gao","Gao",tf_hero|tf_is_merchant, scn_yiling_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_44_horse_merchant","Bie","Bie",tf_hero|tf_is_merchant, scn_jianan_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],
["town_45_horse_merchant","Lei","Lei",tf_hero|tf_is_merchant, scn_jiaozhi_center|entry(12),0, fac_commoners,[itm_bushoes,itm_shirt],def_attrib|level(10),wp_one_handed(100)|wp_two_handed(100)|wp_polearm(100)|wp_archery(50)|wp_crossbow(50)|wp_throwing(50),knows_inventory_management_10, sanguo_face6],


# Place extra merchants before this point
  ["merchants_end","merchants_end","merchants_end",tf_hero, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10,0],
  ["yijun_leader","Leader","Leaders",tf_hero, 0,0, fac_player_faction,[itm_china_100huanshou,itm_qidun,itm_courser,itm_china_soldier_yq,itm_leather_gloves,itm_leather_boots,itm_toujin],def_attrib|level(30),wp(200),knows_power_strike_7|knows_wound_treatment_6|knows_ironflesh_8|knows_pathfinding_10|knows_athletics_7|knows_riding_3,sanguo_face6],

#Quest NPCs
#NPC
["first_npc","First NPC","First NPC",tf_female|tf_hero, 0, reserved, fac_player_faction,[itm_mianpao,itm_knife],def_attrib|level(1),wp(20),knows_wound_treatment_2|knows_trade_2|knows_first_aid_2|knows_surgery_2,0x000000000000000201c152351bab4558],
["jiaxu","Jia Xu","Jia Xus",tf_hero,0, reserved,fac_kingdom_caowei,[itm_gaoguan,itm_weiwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_10|agi_10|int_30|cha_28|level(30),wp_one_handed(100)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_3|knows_trainer_7|knows_tactics_6|knows_leadership_6|knows_spotting_7|knows_tracking_7|knows_pathfinding_7|knows_surgery_8|knows_first_aid_8|knows_wound_treatment_8|knows_stratagem_9|knows_prisoner_management_7|knows_inventory_management_7,0x00000000000c130401f52e6d134ed844],

["xuhuang","Xu Huang","Xu Huangs",tf_hero,0, reserved,fac_kingdom_caowei,[itm_lianshen,itm_junmao,itm_wuxie,itm_zhanhorse,itm_longaxe],str_26|agi_23|int_12|cha_15|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_9|knows_ironflesh_8|knows_athletics_7|knows_power_draw_5|knows_stratagem_2|knows_power_throw_3|knows_weapon_master_8|knows_shield_7|knows_leadership_3|knows_riding_7,0x00000000000803c301fc37c4ec33646c],

["zhanghe","Zhang He","Zhang Hes",tf_hero,0, reserved,fac_kingdom_caowei,[itm_weiwushen2,itm_daye,itm_wuxie,itm_zhanhorse,itm_longaxe],str_24|agi_26|int_14|cha_16|level(30),wp_one_handed(350)|wp_two_handed(400)|wp_polearm(400)|wp_archery(250)|wp_crossbow(250)|wp_throwing(250),
knows_power_strike_10|knows_ironflesh_7|knows_athletics_5|knows_power_draw_5|knows_horse_archery_4|knows_stratagem_3|knows_weapon_master_7|knows_shield_6|knows_tactics_3|knows_leadership_3|knows_riding_7,0x000000000010318401f4acf691003600],

["caoren","Cao Ren","Cao Rens",tf_hero,0, reserved,fac_kingdom_caowei,[itm_jintie,itm_doumao,itm_wuxie,itm_zhanhorse,itm_bibardiche],str_28|agi_27|int_10|cha_12|level(30),wp_one_handed(300)|wp_two_handed(450)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_8|knows_ironflesh_7|knows_athletics_7|knows_power_draw_5|knows_stratagem_4|knows_power_throw_2|knows_weapon_master_8|knows_shield_7|knows_leadership_7|knows_riding_9,0x00000000000c718301fc71fd27f4b51b],

["lidian","Li Dian","Li Dians",tf_hero,0, reserved,fac_kingdom_caowei,[itm_weiwushen2,itm_yanbiana,itm_wuxie,itm_zhanhorse,itm_mapick],str_20|agi_22|int_9|cha_12|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_6|knows_ironflesh_6|knows_athletics_7|knows_power_draw_5|knows_horse_archery_3|knows_power_throw_2|knows_weapon_master_8|knows_shield_8|knows_leadership_3|knows_riding_6,0x00000000000c618101fcb6c8ed9364ac],

["xiahoudun","XiaHou Dun","XiaHou Duns",tf_hero,0, reserved,fac_kingdom_caowei,[itm_dangxiong,itm_daye,itm_wuxie,itm_zhanhorse,itm_mapick],str_26|agi_26|int_11|cha_13|level(30),wp_one_handed(350)|wp_two_handed(400)|wp_polearm(400)|wp_archery(250)|wp_crossbow(250)|wp_throwing(250),
knows_power_strike_8|knows_ironflesh_9|knows_athletics_7|knows_power_draw_5|knows_horse_archery_4|knows_power_throw_4|knows_weapon_master_7|knows_shield_5|knows_trainer_1|knows_leadership_6|knows_riding_8,0x00000000000061c201f813db53659013],

["caopi","Cao Pi","Cao Pis",tf_hero,0, reserved,fac_kingdom_caowei,[itm_gaoguan,itm_weiwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_8|agi_8|int_22|cha_26|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_2|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_4|knows_trainer_6|knows_tactics_5|knows_leadership_4|knows_spotting_9|knows_tracking_9|knows_pathfinding_9|knows_surgery_8|knows_first_aid_8|knows_wound_treatment_8|knows_stratagem_2|knows_prisoner_management_6|knows_inventory_management_6,0x00000000000c100801fa17dad9259002],

["chengyu","Cheng Yu","Cheng Yus",tf_hero,0, reserved,fac_kingdom_caowei,[itm_gaoguan,itm_weiwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_6|agi_8|int_24|cha_27|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_3|knows_trainer_6|knows_tactics_7|knows_leadership_5|knows_spotting_7|knows_tracking_6|knows_pathfinding_6|knows_surgery_6|knows_first_aid_6|knows_wound_treatment_7|knows_stratagem_6|knows_prisoner_management_5|knows_inventory_management_8,0x00000000000c100401c63182af4070a4],

["lejin","Le Jin","Le Jins",tf_hero,0, reserved,fac_kingdom_caowei,[itm_weiwushen2,itm_yanbiana,itm_wuxie,itm_zhanhorse,itm_china_spear],str_21|agi_21|int_10|cha_10|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_7|knows_ironflesh_6|knows_athletics_5|knows_power_draw_5|knows_horse_archery_5|knows_power_throw_3|knows_weapon_master_7|knows_shield_5|knows_leadership_4|knows_riding_6,0x00000000000c414301f8175f25ad42d0],

["caocao","Cao Cao","Cao Caos",tf_hero,0, reserved,fac_kingdom_caowei,[itm_crown,itm_ccshen,itm_wenxie,itm_yitiansword,itm_zhuahorse],str_16|agi_15|int_30|cha_30|level(30),wp_one_handed(100)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_2|knows_power_strike_2|knows_weapon_master_2|knows_athletics_2|knows_riding_5|knows_trainer_10|knows_tactics_8|knows_leadership_8|knows_spotting_10|knows_tracking_9|knows_pathfinding_10|knows_surgery_6|knows_first_aid_6|knows_wound_treatment_6|knows_stratagem_7|knows_prisoner_management_5|knows_inventory_management_10,0x00000000000c73c301f81048480b3200],

["yujin","Yu Jin","Yu Jins",tf_hero,0, reserved,fac_kingdom_caowei,[itm_weiwushen2,itm_yanbiana,itm_wuxie,itm_zhanhorse,itm_china_100huanshou,itm_weishield],str_20|agi_25|int_10|cha_7|level(30),wp_one_handed(155)|wp_two_handed(155)|wp_polearm(205)|wp_archery(100)|wp_crossbow(50)|wp_throwing(50),
knows_power_strike_6|knows_ironflesh_8|knows_athletics_5|knows_power_draw_4|knows_horse_archery_3|knows_power_throw_2|knows_weapon_master_6|knows_shield_6|knows_trainer_3|knows_tactics_1|knows_leadership_7|knows_riding_5,0x00000000000c210901fe37692db4d318],

["xunyou","Xun You","Xun Yous",tf_hero,0, reserved,fac_kingdom_caowei,[itm_gaoguan,itm_weiwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_7|agi_7|int_27|cha_24|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_4|knows_trainer_6|knows_tactics_5|knows_leadership_5|knows_spotting_5|knows_tracking_5|knows_pathfinding_5|knows_surgery_8|knows_first_aid_6|knows_wound_treatment_6|knows_stratagem_7|knows_prisoner_management_8|knows_inventory_management_9,0x00000000000c730401efabf7100256ab],

["xunyu","Xun Yu","Xun Yus",tf_hero,0, reserved,fac_kingdom_caowei,[itm_gaoguan,itm_weiwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_8|agi_7|int_29|cha_22|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_4|knows_trainer_7|knows_tactics_8|knows_leadership_6|knows_spotting_6|knows_tracking_6|knows_pathfinding_6|knows_surgery_9|knows_first_aid_8|knows_wound_treatment_9|knows_stratagem_8|knows_prisoner_management_8|knows_inventory_management_9,0x00000000000c73c401fb6e590908a680],

["simayi","SiMa Yi","SiMa Yis",tf_hero,0, reserved,fac_kingdom_caowei,[itm_gaoguan,itm_smyshen,itm_wenxie,itm_courser,itm_china_50longsword],str_15|agi_15|int_30|cha_30|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_4|knows_trainer_9|knows_tactics_10|knows_leadership_8|knows_spotting_8|knows_tracking_7|knows_pathfinding_7|knows_surgery_9|knows_first_aid_9|knows_wound_treatment_7|knows_stratagem_9|knows_prisoner_management_6|knows_inventory_management_7,0x00000000000c210401f992ba42494692],

["xushu","Xu Shu","Xu Shus",tf_hero,0, reserved,fac_kingdom_caowei,[itm_gaoguan,itm_weiwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_8|agi_9|int_26|cha_27|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_2|knows_riding_3|knows_trainer_8|knows_tactics_10|knows_leadership_9|knows_spotting_8|knows_tracking_7|knows_pathfinding_7|knows_surgery_6|knows_first_aid_6|knows_wound_treatment_8|knows_stratagem_7|knows_prisoner_management_5|knows_inventory_management_7,0x00000000000c73c701fb32988e8cc4c3],

["pangde","Pang De","Pang Des",tf_hero,0, reserved,fac_kingdom_caowei,[itm_lianshena,itm_junmao,itm_wuxie,itm_zhanhorse,itm_sanjiandao],str_27|agi_27|int_11|cha_9|level(30),wp_one_handed(350)|wp_two_handed(400)|wp_polearm(400)|wp_archery(300)|wp_crossbow(250)|wp_throwing(250),
knows_power_strike_7|knows_ironflesh_7|knows_athletics_9|knows_power_draw_7|knows_horse_archery_6|knows_power_throw_6|knows_weapon_master_10|knows_shield_6|knows_trainer_1|knows_leadership_3|knows_riding_9,0x00000000000c254101edf3796e0c717b],

["liuye","Liu Ye","Liu Yes",tf_hero,0, reserved,fac_kingdom_caowei,[itm_gaoguan,itm_weiwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_8|agi_6|int_20|cha_22|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_4|knows_trainer_7|knows_tactics_9|knows_leadership_6|knows_spotting_5|knows_tracking_6|knows_pathfinding_6|knows_surgery_6|knows_first_aid_5|knows_wound_treatment_5|knows_stratagem_5|knows_prisoner_management_5|knows_inventory_management_7,0x00000000000c614301e86d5cd58a5880],

["xiahouyuan","XiaHou Yuan","XiaHou Yuans",tf_hero,0, reserved,fac_kingdom_caowei,[itm_lianshena,itm_doumao,itm_wuxie,itm_zhanhorse,itm_longlance],str_25|agi_25|int_6|cha_5|level(30),wp_one_handed(350)|wp_two_handed(300)|wp_polearm(300)|wp_archery(350)|wp_crossbow(250)|wp_throwing(250),
knows_power_strike_8|knows_ironflesh_7|knows_athletics_8|knows_power_draw_6|knows_horse_archery_7|knows_power_throw_2|knows_weapon_master_8|knows_shield_6|knows_leadership_4|knows_riding_7,0x000000000008618301f84f4eed8de364],

["caohong","Cao Hong","Cao Hongs",tf_hero,0, reserved,fac_kingdom_caowei,[itm_weiwushen2,itm_yanbiana,itm_wuxie,itm_zhanhorse,itm_zhanmabardiche],str_24|agi_25|int_5|cha_5|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_8|knows_ironflesh_7|knows_athletics_7|knows_power_draw_5|knows_horse_archery_4|knows_power_throw_4|knows_weapon_master_7|knows_shield_5|knows_leadership_3|knows_riding_6,0x00000000000c030701c0ab1a1642a4a8],

["guojia","Guo Jia","Guo Jias",tf_hero,0, reserved,fac_kingdom_caowei,[itm_gaoguan,itm_weiwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_4|agi_7|int_30|cha_24|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_3|knows_trainer_8|knows_tactics_8|knows_leadership_6|knows_spotting_7|knows_tracking_7|knows_pathfinding_6|knows_surgery_7|knows_first_aid_7|knows_wound_treatment_7|knows_stratagem_10|knows_prisoner_management_7|knows_inventory_management_10,0x00000000000c73c801f952bb22869251],

["zhangliao","Zhang Liao","Zhang Liaos",tf_hero,0, reserved,fac_kingdom_caowei,[itm_lianshena,itm_junmao,itm_wuxie,itm_zhanhorse,itm_china_s_spear],str_25|agi_29|int_15|cha_20|level(30),wp_one_handed(350)|wp_two_handed(400)|wp_polearm(400)|wp_archery(250)|wp_crossbow(250)|wp_throwing(250),
knows_power_strike_9|knows_ironflesh_9|knows_athletics_8|knows_power_draw_6|knows_horse_archery_4|knows_power_throw_3|knows_weapon_master_10|knows_stratagem_5|knows_trainer_2|knows_tactics_3|knows_leadership_8|knows_riding_9,0x00000000000c710301f9513d53a94283],

["manchong","Man Chong","Man Chongs",tf_hero,0, reserved,fac_kingdom_caowei,[itm_gaoguan,itm_weiwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_5|agi_8|int_22|cha_24|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_3|knows_trainer_4|knows_tactics_4|knows_leadership_4|knows_spotting_5|knows_tracking_5|knows_pathfinding_5|knows_surgery_5|knows_first_aid_5|knows_wound_treatment_5|knows_stratagem_5|knows_prisoner_management_5|knows_inventory_management_6,0x00000000000c614401e86d5cd58a5880],

["pangtong","Pang Tong","Pang Tongs",tf_hero,0, reserved,fac_kingdom_shuhan,[itm_toufa,itm_shuwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_9|agi_7|int_30|cha_15|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_4|knows_trainer_8|knows_tactics_9|knows_leadership_8|knows_spotting_6|knows_tracking_6|knows_pathfinding_8|knows_surgery_7|knows_first_aid_5|knows_wound_treatment_5|knows_stratagem_8|knows_prisoner_management_9|knows_inventory_management_7,0x00000000000c710701f9513d53a94283],

["weiyan","Wei Yan","Wei Yans",tf_hero,0, reserved,fac_kingdom_shuhan,[itm_dangxiong,itm_junmao,itm_wuxie,itm_zhanhorse,itm_dadao],str_25|agi_27|int_18|cha_18|level(30),wp_one_handed(350)|wp_two_handed(400)|wp_polearm(400)|wp_archery(250)|wp_crossbow(250)|wp_throwing(250),
knows_power_strike_7|knows_ironflesh_7|knows_athletics_7|knows_power_draw_5|knows_horse_archery_4|knows_power_throw_3|knows_weapon_master_8|knows_stratagem_6|knows_leadership_5|knows_riding_8,0x00000000000c158301ea285d3209737f],

["zhangfei","Zhang Fei","Zhang Feis",tf_hero,0, reserved,fac_kingdom_shuhan,[itm_lianshen,itm_yanyitoukui,itm_wuxie,itm_steelspear,itm_zhanhorse],str_30|agi_27|int_12|cha_6|level(30),wp_one_handed(400)|wp_two_handed(450)|wp_polearm(450)|wp_archery(300)|wp_crossbow(300)|wp_throwing(300),
knows_power_strike_10|knows_ironflesh_10|knows_athletics_9|knows_power_draw_5|knows_horse_archery_3|knows_power_throw_4|knows_weapon_master_8|knows_stratagem_3|knows_leadership_6|knows_riding_8,0x00000000000c860301fccefd3495f77b],

["liubei","Liu Bei","Liu Beis",tf_hero,0, reserved,fac_kingdom_shuhan,[itm_crown,itm_lbeishen,itm_wenxie,itm_dihorse,itm_shuangxi,itm_shuangci],str_11|agi_12|int_24|cha_30|level(30),wp_one_handed(150)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_2|knows_power_strike_2|knows_weapon_master_2|knows_athletics_2|knows_riding_5|knows_trainer_6|knows_tactics_4|knows_leadership_8|knows_spotting_6|knows_tracking_6|knows_pathfinding_6|knows_surgery_4|knows_first_aid_4|knows_wound_treatment_4|knows_trade_6|knows_stratagem_3|knows_inventory_management_4,0x00000000000c73c401fc665b5b71e641],

["fazheng","Fa Zheng","Fa Zhengs",tf_hero,0, reserved,fac_kingdom_shuhan,[itm_gaoguan,itm_wuwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_7|agi_7|int_25|cha_24|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_3|knows_trainer_6|knows_tactics_6|knows_leadership_8|knows_spotting_7|knows_tracking_5|knows_pathfinding_5|knows_surgery_6|knows_first_aid_6|knows_wound_treatment_8|knows_stratagem_6|knows_prisoner_management_6|knows_inventory_management_6,0x00000000000015c801ef159a2bae1d48],

["yanyan","Yan Yan","Yan Yans",tf_hero,0, reserved,fac_kingdom_shuhan,[itm_shuwushen2,itm_jinbian,itm_yinxie,itm_yuitian,itm_longlance,itm_zhanhorse],str_22|agi_23|int_11|cha_16|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_6|knows_ironflesh_7|knows_athletics_6|knows_power_draw_4|knows_horse_archery_4|knows_power_throw_2|knows_weapon_master_8|knows_shield_6|knows_leadership_3|knows_riding_6,0x000000000010618701d28ab2cd52fb34],

["guanyu","Guan Yu","Guan Yus",tf_hero,0, reserved,fac_kingdom_shuhan,[itm_gyshen,itm_jinxie,itm_lutoujin,itm_qinglongbardiche,itm_zhanhorse],str_27|agi_30|int_9|cha_12|level(30),wp_one_handed(400)|wp_two_handed(450)|wp_polearm(450)|wp_archery(300)|wp_crossbow(300)|wp_throwing(300),
knows_power_strike_9|knows_ironflesh_9|knows_athletics_8|knows_power_draw_6|knows_horse_archery_4|knows_power_throw_4|knows_weapon_master_10|knows_stratagem_3|knows_trainer_1|knows_tactics_1|knows_leadership_5|knows_riding_9,0x00000000000c858301e8adcae36a5a9c],

["huangzhong","Huang Zhong","Huang Zhongs",tf_hero,0, reserved,fac_kingdom_shuhan,[itm_weiwushen2,itm_yanbiana,itm_wuxie,itm_zhanhorse,itm_bibardiche,itm_yangyou_bow,itm_arrows],str_26|agi_24|int_11|cha_15|level(30),wp_one_handed(350)|wp_two_handed(400)|wp_polearm(400)|wp_archery(250)|wp_crossbow(250)|wp_throwing(250),
knows_power_strike_7|knows_ironflesh_7|knows_athletics_7|knows_power_draw_10|knows_horse_archery_10|knows_power_throw_3|knows_weapon_master_7|knows_shield_5|knows_leadership_4|knows_riding_7,0x000000000010360401f3b33d12724762],

["jiangwei","Jiang Wei","Jiang Weis",tf_hero,0, reserved,fac_kingdom_shuhan,[itm_dangxiong,itm_daye,itm_wuxie,itm_longlance,itm_zhanhorse],str_20|agi_20|int_22|cha_20|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(350)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_8|knows_ironflesh_7|knows_athletics_10|knows_power_draw_6|knows_horse_archery_7|knows_power_throw_2|knows_weapon_master_7|knows_stratagem_6|knows_trainer_4|knows_tactics_5|knows_leadership_7|knows_riding_8,0x00000000000c600101f96eba9ea9429a],

["zhugeliang","ZhuGe Liang","ZhuGe Liangs",tf_hero,0, reserved,fac_kingdom_shuhan,[itm_zgltou,itm_zglshen,itm_wenxie,itm_courser,itm_china_50longsword],str_6|agi_10|int_30|cha_30|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_2|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_3|knows_trainer_10|knows_tactics_10|knows_leadership_8|knows_spotting_8|knows_tracking_7|knows_pathfinding_9|knows_surgery_7|knows_first_aid_7|knows_wound_treatment_8|knows_stratagem_9|knows_prisoner_management_6|knows_inventory_management_9,0x00000000000c73c801f371c8cc894630],

["jiangwan","Jiang Wan","Jiang Wans",tf_hero,0, reserved,fac_kingdom_shuhan,[itm_gaoguan,itm_shuwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_5|agi_6|int_25|cha_28|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_4|knows_trainer_6|knows_tactics_4|knows_leadership_4|knows_spotting_5|knows_tracking_6|knows_pathfinding_5|knows_surgery_8|knows_first_aid_8|knows_wound_treatment_8|knows_trade_8|knows_prisoner_management_5|knows_inventory_management_8,0x00000000000c73c401f371c8cc894630],

["sunquan","Sun Quan","Sun Quans",tf_hero,0, reserved,fac_kingdom_wu,[itm_crown,itm_sqshen,itm_wenxie,itm_courser,itm_china_50longsword],str_11|agi_9|int_20|cha_27|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_4|knows_trainer_7|knows_tactics_4|knows_leadership_5|knows_spotting_6|knows_tracking_6|knows_pathfinding_6|knows_surgery_10|knows_first_aid_10|knows_wound_treatment_10|knows_trade_10|knows_prisoner_management_4|knows_inventory_management_7,0x00000000000c114401f992bedb71e8de],

["chengpu","Cheng Pu","Cheng Pus",tf_hero,0, reserved,fac_kingdom_wu,[itm_wuwushen2,itm_yanbiana,itm_wuxie,itm_bian,itm_zhanhorse],str_22|agi_24|int_11|cha_10|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_6|knows_ironflesh_8|knows_athletics_7|knows_power_draw_5|knows_horse_archery_3|knows_power_throw_4|knows_weapon_master_7|knows_shield_8|knows_trainer_1|knows_tactics_1|knows_leadership_5|knows_riding_5,0x00000000000c614301ef71f710005688],

["lusu","Lu Su","Lu Sus",tf_hero,0, reserved,fac_kingdom_wu,[itm_gaoguan,itm_wuwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_7|agi_9|int_22|cha_28|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_3|knows_trainer_7|knows_tactics_8|knows_leadership_7|knows_spotting_7|knows_tracking_7|knows_pathfinding_7|knows_surgery_9|knows_first_aid_8|knows_wound_treatment_8|knows_stratagem_3|knows_prisoner_management_5|knows_inventory_management_7,0x00000000000c748401f5f2fb1c8ee110],

["zhoutai","Zhou Tai","Zhou Tais",tf_hero,0, reserved,fac_kingdom_wu,[itm_lianshen,itm_doumao,itm_wuxie,itm_zhanhorse,itm_zhanmabardiche],str_28|agi_21|int_5|cha_6|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_9|knows_ironflesh_9|knows_athletics_7|knows_power_draw_5|knows_horse_archery_3|knows_power_throw_8|knows_weapon_master_8|knows_shield_5|knows_leadership_2|knows_riding_6,0x00000000000c518801fc973f2356757c],

["zhouyu","Zhou Yu","Zhou Yus",tf_hero,0, reserved,fac_kingdom_wu,[itm_yuling,itm_yinjia,itm_yinxie,itm_courser,itm_wugousword],str_12|agi_13|int_29|cha_29|level(30),wp_one_handed(200)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_3|knows_power_strike_3|knows_weapon_master_3|knows_athletics_2|knows_riding_5|knows_trainer_9|knows_tactics_10|knows_leadership_9|knows_spotting_8|knows_tracking_8|knows_pathfinding_8|knows_surgery_6|knows_first_aid_6|knows_wound_treatment_6|knows_stratagem_9|knows_prisoner_management_5|knows_inventory_management_7,0x00000000000c700801f26dc6d6895482],

["xusheng","Xu Sheng","Xu Shengs",tf_hero,0, reserved,fac_kingdom_wu,[itm_weiwushen2,itm_yanbiana,itm_wuxie,itm_congspear,itm_zhanhorse],str_21|agi_24|int_9|cha_8|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_7|knows_ironflesh_5|knows_athletics_6|knows_power_draw_6|knows_horse_archery_3|knows_power_throw_2|knows_weapon_master_6|knows_shield_4|knows_trainer_1|knows_tactics_1|knows_leadership_4|knows_riding_5,0x00000000000c418001c0b427215bd717],

["lvmeng","Lv Meng","Lv Mengs",tf_hero,0, reserved,fac_kingdom_wu,[itm_gaoguan,itm_wuwushen2,itm_wenxie,itm_courser,itm_china_100longsword],str_16|agi_18|int_23|cha_25|level(30),wp_one_handed(250)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_4|knows_power_strike_4|knows_weapon_master_5|knows_athletics_3|knows_riding_4|knows_trainer_8|knows_tactics_5|knows_leadership_7|knows_spotting_4|knows_tracking_4|knows_pathfinding_3|knows_surgery_4|knows_first_aid_4|knows_wound_treatment_5|knows_stratagem_4|knows_prisoner_management_3|knows_inventory_management_3,0x000000000000020801f28dde3049b8d3],

["taishici","TaiShi Ci","TaiShi Cis",tf_hero,0, reserved,fac_kingdom_wu,[itm_lianshena,itm_daye,itm_wuxie,itm_bian,itm_zhanhorse],str_28|agi_25|int_7|cha_5|level(30),wp_one_handed(350)|wp_two_handed(400)|wp_polearm(400)|wp_archery(250)|wp_crossbow(250)|wp_throwing(250),
knows_power_strike_10|knows_ironflesh_8|knows_athletics_8|knows_power_draw_6|knows_horse_archery_5|knows_power_throw_2|knows_weapon_master_8|knows_shield_4|knows_leadership_6|knows_riding_7,0x00000000000c700701fab29d1b8dc2c2],

["zhangzhao","Zhang Zhao","Zhang Zhaos",tf_hero,0, reserved,fac_kingdom_wu,[itm_gaoguan,itm_wuwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_6|agi_5|int_20|cha_22|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_2|knows_trainer_5|knows_tactics_3|knows_leadership_3|knows_spotting_6|knows_tracking_4|knows_pathfinding_5|knows_surgery_7|knows_first_aid_7|knows_wound_treatment_7|knows_trade_9|knows_prisoner_management_3|knows_inventory_management_9,0x000000000010314301faaecb138ac452],

["luxun","Lu Sun","Lu Xuns",tf_hero,0, reserved,fac_kingdom_wu,[itm_daye,itm_lxshen,itm_wenxie,itm_courser,itm_china_50longsword],str_10|agi_12|int_28|cha_28|level(30),wp_one_handed(150)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_3|knows_power_strike_2|knows_weapon_master_2|knows_athletics_1|knows_riding_4|knows_trainer_8|knows_tactics_7|knows_leadership_7|knows_spotting_7|knows_tracking_9|knows_pathfinding_7|knows_surgery_9|knows_first_aid_8|knows_wound_treatment_6|knows_stratagem_8|knows_prisoner_management_5|knows_inventory_management_6,0x00000000000c710301fb6fccd40e54c9],

["zhanghong","Zhang Hong","Zhang Hongs",tf_hero,0, reserved,fac_kingdom_wu,[itm_gaoguan,itm_wuwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_5|agi_7|int_26|cha_28|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_2|knows_trainer_6|knows_tactics_7|knows_leadership_5|knows_spotting_5|knows_tracking_5|knows_stratagem_2|knows_surgery_10|knows_first_aid_9|knows_wound_treatment_9|knows_trade_9|knows_prisoner_management_8|knows_inventory_management_8,0x000000000004358401faaecb138ac452],

["lingtong","Ling Tong","Ling Tongs",tf_hero,0, reserved,fac_kingdom_wu,[itm_weiwushen2,itm_yanbiana,itm_wuxie,itm_jian,itm_zhanhorse],str_27|agi_20|int_5|cha_6|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_8|knows_ironflesh_7|knows_athletics_9|knows_power_draw_5|knows_horse_archery_3|knows_power_throw_5|knows_weapon_master_8|knows_shield_6|knows_leadership_4|knows_riding_7,0x00000000000035c101f2ce4af58df6bb],

#
["lvbu","Lv Bu","Lv Bus",tf_hero,scn_xiapi_tavern|entry(2), reserved,fac_neutral,[itm_zijinguan,itm_lbshen,itm_yinxie,itm_fangtianhalberd,itm_chihorse],str_30|agi_30|int_15|cha_18|level(30),wp_one_handed(200)|wp_two_handed(500)|wp_polearm(500)|wp_archery(500)|wp_crossbow(100)|wp_throwing(100),
knows_power_strike_10|knows_ironflesh_10|knows_athletics_10|knows_power_draw_8|knows_horse_archery_9|knows_power_throw_4|knows_weapon_master_10|knows_shield_6|knows_leadership_6|knows_riding_10,0x00000000000c724401f877d8fcaac4fb],

["chengong","Chen Gong","Chen Gongs",tf_hero,scn_shouchun_tavern|entry(2), reserved,fac_neutral,[itm_gaoguan,itm_wuwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_7|agi_7|int_26|cha_24|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_4|knows_trainer_7|knows_tactics_5|knows_leadership_5|knows_spotting_5|knows_tracking_5|knows_pathfinding_5|knows_surgery_7|knows_first_aid_7|knows_wound_treatment_7|knows_stratagem_6|knows_prisoner_management_5|knows_inventory_management_6,0x000000000000634301d6874457afed44],

["zhangren","Zhang Ren","Zhang Rens",tf_hero,scn_yongan_tavern|entry(2), reserved,fac_neutral,[itm_mingarmor,itm_doumao,itm_wuxie,itm_courser,itm_qiuspear],str_22|agi_24|int_20|cha_24|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_7|knows_ironflesh_7|knows_athletics_8|knows_power_draw_5|knows_horse_archery_3|knows_power_throw_4|knows_weapon_master_7|knows_shield_7|knows_stratagem_6|knows_tactics_3|knows_leadership_7|knows_riding_6,0x00000000000c40c401e6246d898b9149],

["diaochan","Diao Chan","Diao Chans",tf_hero|tf_female,scn_changan_tavern|entry(2), reserved,fac_neutral,[itm_diaochan,itm_bushoes,itm_handhalberd],str_6|agi_6|int_12|cha_30|level(5),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_1|knows_trainer_5|knows_tactics_1|knows_leadership_1|knows_spotting_1|knows_tracking_1|knows_pathfinding_1|knows_surgery_1|knows_first_aid_1|knows_wound_treatment_1|knows_trade_10|knows_stratagem_1|knows_inventory_management_1,0x000000000000000101d26896dd003009],

["yanliang","Yan Liang","Yan Liangs",tf_hero,scn_puyang_tavern|entry(2), reserved,fac_neutral,[itm_ironarmora,itm_yanbiana,itm_wuxie,itm_courser,itm_zhongzhandao],str_27|agi_29|int_3|cha_4|level(30),wp_one_handed(400)|wp_two_handed(450)|wp_polearm(450)|wp_archery(300)|wp_crossbow(300)|wp_throwing(300),
knows_power_strike_10|knows_ironflesh_8|knows_athletics_8|knows_power_draw_6|knows_horse_archery_4|knows_power_throw_3|knows_weapon_master_10|knows_shield_3|knows_leadership_2|knows_riding_8,0x00000000000c608801d09d5a92d4056b],

["jushou","Ju Shou","Ju Shous",tf_hero,scn_pingyuan_tavern|entry(2), reserved,fac_neutral,[itm_gaoguan,itm_wuwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_7|agi_8|int_24|cha_21|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_3|knows_trainer_4|knows_tactics_5|knows_leadership_4|knows_spotting_6|knows_tracking_6|knows_pathfinding_6|knows_surgery_8|knows_first_aid_8|knows_wound_treatment_8|knows_trade_10|knows_stratagem_5|knows_inventory_management_9,0x00000000000883c401c1dc4a047298f3],

["tianfeng","Tian Feng","Tian Fengs",tf_hero,scn_beiping_tavern|entry(2), reserved,fac_neutral,[itm_gaoguan,itm_wuwenshen2,itm_wenxie,itm_courser,itm_china_50longsword],str_7|agi_7|int_25|cha_20|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_3|knows_trainer_5|knows_tactics_4|knows_leadership_4|knows_spotting_6|knows_tracking_5|knows_pathfinding_6|knows_surgery_10|knows_first_aid_9|knows_wound_treatment_8|knows_trade_8|knows_stratagem_6|knows_inventory_management_7,0x00000000000c134401cab57c0ebb4932],

["wenchou","Wen Chou","Wen Chous",tf_hero,scn_runan_tavern|entry(2), reserved,fac_neutral,[itm_ironarmora,itm_yanbiana,itm_wuxie,itm_courser,itm_zhongzhandao],str_27|agi_28|int_4|cha_4|level(30),wp_one_handed(400)|wp_two_handed(450)|wp_polearm(450)|wp_archery(300)|wp_crossbow(300)|wp_throwing(300),
knows_power_strike_9|knows_ironflesh_9|knows_athletics_9|knows_power_draw_6|knows_horse_archery_6|knows_power_throw_4|knows_weapon_master_8|knows_shield_3|knows_leadership_2|knows_riding_9,0x00000000000c44c101e28ef35a9620e3],

["mateng","Ma Teng","Ma Tengs",tf_hero,scn_tianshui_tavern|entry(2), reserved,fac_neutral,[itm_ironarmora,itm_yanbiana,itm_wuxie,itm_xlhorse,itm_mapick],str_25|agi_23|int_11|cha_15|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_8|knows_ironflesh_8|knows_athletics_6|knows_power_draw_5|knows_horse_archery_5|knows_power_throw_5|knows_weapon_master_8|knows_shield_3|knows_trainer_1|knows_leadership_5|knows_riding_10,0x000000000010514801db97048ba8aab3],

["jiling","Ji Ling","Ji Lings",tf_hero,scn_wancheng_tavern|entry(2), reserved,fac_neutral,[itm_ironarmora,itm_yanbiana,itm_wuxie,itm_courser,itm_sanjiandao],str_28|agi_20|int_3|cha_3|level(30),wp_one_handed(350)|wp_two_handed(400)|wp_polearm(400)|wp_archery(200)|wp_crossbow(200)|wp_throwing(300),
knows_power_strike_9|knows_ironflesh_6|knows_athletics_6|knows_power_draw_4|knows_horse_archery_3|knows_power_throw_2|knows_weapon_master_8|knows_shield_2|knows_leadership_3|knows_riding_7,0x00000000000c85c101f535d380da94b4],

["menghuo","Meng Huo","Meng Huos",tf_hero,scn_jiaozhi_tavern|entry(2), reserved,fac_neutral,[itm_ironarmora,itm_yanbiana,itm_wuxie,itm_courser],str_27|agi_28|int_4|cha_4|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(300),
knows_power_strike_8|knows_ironflesh_8|knows_athletics_8|knows_power_draw_3|knows_horse_archery_2|knows_power_throw_4|knows_weapon_master_7|knows_shield_8|knows_leadership_1|knows_riding_5,0x00000000000c44c101e28ef35a9620e3],

["zhurong","Zhu Rong","Zhu Rongs",tf_hero|tf_female,scn_yunnan_tavern|entry(2), reserved,fac_neutral,[itm_ironarmora,itm_wuxie,itm_courser,itm_longaxe,itm_throwing_knives],str_16|agi_12|int_9|cha_10|level(10),wp_one_handed(200)|wp_two_handed(250)|wp_polearm(250)|wp_archery(200)|wp_crossbow(200)|wp_throwing(400),
knows_power_strike_4|knows_ironflesh_2|knows_athletics_5|knows_power_draw_3|knows_horse_archery_4|knows_power_throw_6|knows_weapon_master_6|knows_shield_4|knows_riding_4,0x00000000000c000601db81c55285d50a],

#npc
["shahongbing","Sha Hongbing","Sha Hongbings",tf_hero|tf_female,0,reserved,fac_commoners,[itm_womancloth1,itm_bushoes,itm_falchion],str_7|agi_5|int_8|cha_8|level(1),wp_one_handed(50)|wp_two_handed(50)|wp_polearm(50)|wp_archery(75)|wp_crossbow(75)|wp_throwing(25),knows_ironflesh_1|knows_weapon_master_1|knows_inventory_management_3|knows_prisoner_management_1|knows_leadership_1|knows_tracking_1|knows_surgery_1|knows_wound_treatment_1|knows_first_aid_1|knows_trade_1,0x00000000000c100101e8bdd65a66b001],

["wangxiaohu","Wang Xiaohu","Wang Xiaohus",tf_hero,0,reserved,fac_commoners,[itm_toujin,itm_shirt,itm_bronzetuff,itm_caoshoes],str_10|agi_8|int_5|cha_5|level(1),wp_one_handed(75)|wp_two_handed(75)|wp_polearm(50)|wp_archery(75)|wp_crossbow(50)|wp_throwing(25),knows_ironflesh_1|knows_power_strike_1|knows_power_draw_1|knows_weapon_master_2|knows_riding_2|knows_inventory_management_2|knows_leadership_1|knows_tactics_1,0x000000000008100f01e8bdd65a66b001],


#specil troop
["gaoshun","Gao Shun","Gao Shuns",tf_hero,0, reserved,fac_neutral,[itm_ironarmora,itm_yanbiana,itm_wuxie,itm_courser,itm_china_pike],str_26|agi_24|int_10|cha_5|level(30),wp_one_handed(300)|wp_two_handed(400)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_8|knows_ironflesh_8|knows_athletics_9|knows_power_draw_6|knows_horse_archery_5|knows_power_throw_1|knows_weapon_master_8|knows_shield_2|knows_trainer_3|knows_tactics_3|knows_leadership_5|knows_riding_8,0x000000000008908901c534369172e4e4],

["yuanshao","Yuan Shao","Yuan Shaos",tf_hero,0, reserved,fac_neutral,[itm_han_wenguanfu1,itm_liangguan,itm_wenxie,itm_courser,itm_china_50longsword],str_9|agi_10|int_22|cha_26|level(30),wp_one_handed(120)|wp_two_handed(50)|wp_polearm(50)|wp_archery(50)|wp_crossbow(100)|wp_throwing(50),
knows_ironflesh_1|knows_power_strike_1|knows_weapon_master_2|knows_athletics_1|knows_riding_4|knows_trainer_6|knows_tactics_4|knows_leadership_4|knows_spotting_5|knows_tracking_5|knows_pathfinding_5|knows_surgery_5|knows_first_aid_5|knows_wound_treatment_5|knows_trade_5|knows_prisoner_management_4|knows_inventory_management_6,0x00000000000c710701fa8ecd1b8de452],

["gongsunzan","GongSun Zan","GongSun Zans",tf_hero,0, reserved,fac_neutral,[itm_hunzhi,itm_junmao,itm_wuxie,itm_courser,itm_spear1,itm_war_bow,itm_arrows],str_20|agi_24|int_17|cha_18|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_6|knows_ironflesh_7|knows_athletics_6|knows_power_draw_9|knows_horse_archery_9|knows_power_throw_3|knows_weapon_master_6|knows_shield_6|knows_trainer_1|knows_leadership_5|knows_riding_8,0x00000000000c714401f9473b61314509],

["dianwei","Dian Wei","Dian Weis",tf_hero,0, reserved,fac_kingdom_caowei,[itm_lianshen,itm_huyan,itm_wuxie,itm_courser,itm_longaxe],str_30|agi_26|int_4|cha_3|level(30),wp_one_handed(400)|wp_two_handed(400)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(500),
knows_power_strike_9|knows_ironflesh_10|knows_athletics_7|knows_power_draw_3|knows_horse_archery_4|knows_power_throw_10|knows_weapon_master_7|knows_shield_3|knows_leadership_2|knows_riding_7,0x000000000000854301f9a618b6819102],

["xuzhe","Xu Zhe","Xu Zhes",tf_hero,0, reserved,fac_kingdom_caowei,[itm_dangxiong,itm_daye,itm_wuxie,itm_zhanhorse,itm_china_su],str_30|agi_25|int_3|cha_4|level(30),wp_one_handed(400)|wp_two_handed(450)|wp_polearm(450)|wp_archery(300)|wp_crossbow(300)|wp_throwing(300),
knows_power_strike_9|knows_ironflesh_10|knows_athletics_7|knows_power_draw_6|knows_horse_archery_5|knows_power_throw_3|knows_weapon_master_7|knows_shield_4|knows_leadership_2|knows_riding_6,0x00000000000c710601f931bf24715720],

["zhaoyun","Zhao Yun","Zhao Yuns",tf_hero,0, reserved,fac_kingdom_shuhan,[itm_zyshen,itm_junmao,itm_yinxie,itm_yuitian,itm_silverlance,itm_xuehorse],str_28|agi_29|int_15|cha_18|level(30),wp_one_handed(400)|wp_two_handed(450)|wp_polearm(450)|wp_archery(300)|wp_crossbow(300)|wp_throwing(300),
knows_power_strike_8|knows_ironflesh_10|knows_athletics_7|knows_power_draw_7|knows_horse_archery_5|knows_power_throw_3|knows_weapon_master_9|knows_shield_4|knows_leadership_6|knows_riding_10,0x00000000000870c901f969e8caa9d709],

["machao","Ma Chao","Ma Chaos",tf_hero,0, reserved,fac_kingdom_shuhan,[itm_hutou,itm_mcshen,itm_wuxie,itm_ironlance,itm_xlhorse],str_28|agi_30|int_6|cha_15|level(30),wp_one_handed(400)|wp_two_handed(450)|wp_polearm(450)|wp_archery(300)|wp_crossbow(300)|wp_throwing(300),
knows_power_strike_9|knows_ironflesh_8|knows_athletics_6|knows_power_draw_6|knows_horse_archery_6|knows_power_throw_3|knows_weapon_master_10|knows_shield_4|knows_trainer_2|knows_leadership_7|knows_riding_10,0x00000000000c100101fa551a596e46d3],

["huanggai","Huang Gai","Huang Gais",tf_hero,0, reserved,fac_kingdom_wu,[itm_weiwushen2,itm_yanbiana,itm_wuxie,itm_tiejispear,itm_zhanhorse],str_26|agi_22|int_6|cha_8|level(30),wp_one_handed(300)|wp_two_handed(350)|wp_polearm(350)|wp_archery(200)|wp_crossbow(200)|wp_throwing(200),
knows_power_strike_8|knows_ironflesh_7|knows_athletics_7|knows_power_draw_5|knows_horse_archery_3|knows_power_throw_4|knows_weapon_master_8|knows_shield_9|knows_leadership_3|knows_riding_5,0x00000000001035c401f2ce4af58df6bb],

["ganning","Gan Ning","Gan Nings",tf_hero,0, reserved,fac_kingdom_wu,[itm_weiwushen2,itm_yanbiana,itm_wuxie,itm_china_ge,itm_zhanhorse],str_26|agi_27|int_6|cha_5|level(30),wp_one_handed(350)|wp_two_handed(400)|wp_polearm(400)|wp_archery(400)|wp_crossbow(250)|wp_throwing(250),
knows_power_strike_8|knows_ironflesh_9|knows_athletics_8|knows_power_draw_7|knows_horse_archery_7|knows_power_throw_3|knows_weapon_master_9|knows_shield_3|knows_trainer_1|knows_leadership_5|knows_riding_8,0x00000000000c534501fb52bef54de332],

["last_npc","Last NPC","Last NPC",tf_female|tf_hero, 0, reserved, fac_player_faction,[itm_mianpao,itm_knife],def_attrib|level(1),wp(20),knows_wound_treatment_2|knows_trade_2|knows_first_aid_2|knows_surgery_2,0x000000000000000201c152351bab4558],
   
   

#

["jiaxu_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["xuhuang_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["zhanghe_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["caoren_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["lidian_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["xiahoudun_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["caopi_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["chengyu_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["lejin_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["caocao_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["yujin_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["xunyou_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["xunyu_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["simayi_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["xushu_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["pangde_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["liuye_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["xiahouyuan_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["caohong_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["guojia_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],

["zhangliao_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["manchong_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["pangtong_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["weiyan_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["zhangfei_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["liubei_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["fazheng_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["yanyan_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["guanyu_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["huangzhong_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["jiangwei_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["zhugeliang_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["jiangwan_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["sunquan_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["chengpu_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["lusu_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["zhoutai_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["zhouyu_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["xusheng_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["lvmeng_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],

["taishici_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["zhangzhao_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["luxun_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["zhanghong_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["lingtong_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],

["lvbu_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["chengong_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["yanliang_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["zhangren_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["jushou_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["tianfeng_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["wenchou_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["mateng_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["jiling_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["menghuo_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["diaochan_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["zhurong_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],

["shahongbing_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["wangxiaohu_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["gaoshun_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["yuanshao_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["gongsunzan_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["dianwei_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["xuzhe_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["zhaoyun_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["machao_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["huanggai_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
["ganning_unequipped_gear","Inventory Troop","Inventory Troop",tf_hero,no_scene,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],


#

   
   
   
   
   
   
   
   
   
   
  ["novice_fighter","Novice Fighter","Novice Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_6|agi_6|level(5),wp(60),knows_common,swadian_face1, swadian_face2],
  ["regular_fighter","Regular Fighter","Regular Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_8|agi_8|level(11),wp(90),knows_common|knows_ironflesh_1|knows_power_strike_1|knows_athletics_1|knows_riding_1|knows_shield_2,swadian_face1, swadian_face2],
  ["veteran_fighter","Veteran Fighter","Veteran Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,0,fac_commoners,
   [itm_wooden_shield,itm_hide_boots],
   str_10|agi_10|level(17),wp(110),knows_common|knows_ironflesh_3|knows_power_strike_2|knows_athletics_2|knows_riding_2|knows_shield_3,swadian_face1, swadian_face2],
  ["champion_fighter","Champion Fighter","Champion Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_12|agi_11|level(22),wp(140),knows_common|knows_ironflesh_4|knows_power_strike_3|knows_athletics_3|knows_riding_3|knows_shield_4,swadian_face1, swadian_face2],


  ["kidnapped_girl","Kidnapped Girl","Kidnapped Girls",tf_hero|tf_female,0,reserved,fac_commoners,
   [itm_leather_boots],
   def_attrib|level(2),wp(50),knows_common|knows_riding_2,0x0000000000100104000011970c848592],



 ["town_walker_1","Townsman","Townsmen",tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_shirt,itm_coarse_tunic, itm_shirt2, itm_nomad_boots,  itm_wrapping_boots, itm_fur_hat, itm_leather_cap],
   def_attrib|level(4),wp(60),knows_common,swadian_face1, swadian_face2],
 ["town_walker_2","Townswoman","Townswomen",tf_female|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_womancloth2, itm_womancloth3,],
   def_attrib|level(2),wp(40),knows_common,refugee_face1,refugee_face2],


# Zendar
  ["tournament_master","Tournament Master","Tournament Master",tf_hero, scn_zendar_center|entry(1),reserved,  fac_commoners,[itm_nomad_armor,itm_nomad_boots],def_attrib|level(2),wp(20),knows_common,0x000000000008414401e28f534c8a2d09],
  ["trainer","Trainer","Trainer",tf_hero, scn_zendar_center|entry(2),reserved,  fac_commoners,[itm_shirt1,itm_hide_boots],def_attrib|level(2),wp(20),knows_common,0x00000000000430c701ea98836781647f],
  ["Constable_Hareck","Constable Hareck","Constable Hareck",tf_hero, scn_zendar_center|entry(5),reserved,  fac_commoners,[itm_shirt2,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,0x00000000000c41c001fb15234eb6dd3f],
  ["Ramun_the_slave_trader","Ramun, the slave trader","Ramun, the slave trader",tf_hero, scn_zendar_center|entry(6),reserved, fac_commoners,[itm_shirt2,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,0x000000000010904001ee2b08ee4c1bbf],

  ["Xerina","Xerina","Xerina",tf_hero|tf_female, scn_the_happy_boar|entry(5),reserved,  fac_commoners,[itm_shirt1,itm_hide_boots],def_attrib|str_15|agi_15|level(39),wp(312),knows_power_strike_5|knows_ironflesh_5|knows_riding_6|knows_power_draw_4|knows_athletics_8|knows_shield_3,0x00000000000c300301f02b0e97b091fc],
  ["Dranton","Dranton","Dranton",tf_hero, scn_the_happy_boar|entry(2),reserved,  fac_commoners,[itm_shirt2,itm_hide_boots],def_attrib|str_15|agi_14|level(42),wp(324),knows_power_strike_5|knows_ironflesh_7|knows_riding_4|knows_power_draw_4|knows_athletics_4|knows_shield_3,0x000000000004120101e4420000028f77],
  ["Kradus","Kradus","Kradus",tf_hero, scn_the_happy_boar|entry(3),reserved,  fac_commoners,[itm_hide_boots],def_attrib|str_15|agi_14|level(43),wp(270),knows_power_strike_5|knows_ironflesh_7|knows_riding_4|knows_power_draw_4|knows_athletics_4|knows_shield_3,0x000000000010424401fe1c1147a619e7],


#Tutorial
  ["tutorial_trainer","Training Ground Master","Training Ground Master",tf_hero, scn_training_ground|entry(2),reserved, fac_commoners,[itm_nomad_boots],def_attrib|level(2),wp(20),knows_common,0x000000000008414401e28f534c8a2d09],

#Sargoth
  #halkard, hardawk. lord_taucard lord_caupard. lord_paugard

#Salt mine
  ["Galeas","Galeas","Galeas",tf_hero, 0, reserved, fac_commoners,[itm_shirt2,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,0x000000000004718201c073191a9bb10c],

#Dhorak keep

# Ransom brokers.
  ["ransom_broker_1","Ransom_Broker","Ransom_Broker",tf_hero, 0, reserved, fac_commoners,[itm_shirt2,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,0x000000000004718201c073191a9bb10c],
  ["ransom_broker_2","Ransom_Broker","Ransom_Broker",tf_hero, 0, reserved, fac_commoners,[itm_shirt2,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,0x000000000004718201c073191a9bb10c],
  ["ransom_broker_3","Ransom_Broker","Ransom_Broker",tf_hero, 0, reserved, fac_commoners,[itm_shirt2,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,0x000000000004718201c073191a9bb10c],
  ["ransom_broker_4","Ransom_Broker","Ransom_Broker",tf_hero, 0, reserved, fac_commoners,[itm_shirt2,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,0x000000000004718201c073191a9bb10c],

# Tavern traveler.
  ["tavern_traveler_1","Traveler","Traveler",tf_hero, 0, reserved, fac_commoners,[itm_shirt2,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,0x000000000004718201c073191a9bb10c],
  ["tavern_traveler_2","Traveler","Traveler",tf_hero, 0, reserved, fac_commoners,[itm_shirt2,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,0x000000000004718201c073191a9bb10c],

# Tavern minstrel.
  ["tavern_minstrel_1","Minstrel","Minstrel",tf_hero, 0, reserved, fac_commoners,[itm_shirt2,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,0x000000000004718201c073191a9bb10c],


#Village stores
  ["village_1_store", "Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_2_store", "Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_3_store", "Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_4_store", "Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_5_store", "Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_6_store", "Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_7_store", "Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_8_store", "Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_9_store", "Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_10_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_11_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_12_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_13_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_14_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_15_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_16_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_17_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_18_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_19_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_20_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_21_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_22_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_23_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_24_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_25_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_26_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_27_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_28_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_29_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_30_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_31_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_32_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_33_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_34_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_35_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_36_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_37_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_38_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_39_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],
  ["village_40_store","Village_Store", "village_1_store",tf_hero|tf_is_merchant, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c80c301da49184925e892],

# Chests
  ["zendar_chest","Zendar Chest","Zendar Chest",tf_hero|tf_inactive, 0,reserved,  fac_neutral,
   [],def_attrib|level(18),wp(60),knows_common, 0],
  ["tutorial_chest_1","Melee Weapons Chest","Melee Weapons Chest",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[itm_tutorial_sword, itm_tutorial_axe, itm_tutorial_spear, itm_tutorial_club, itm_tutorial_battle_axe],def_attrib|level(18),wp(60),knows_common, 0],
  ["tutorial_chest_2","Ranged Weapons Chest","Ranged Weapons Chest",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[itm_tutorial_short_bow, itm_tutorial_arrows, itm_tutorial_crossbow, itm_tutorial_bolts, itm_tutorial_throwing_daggers],def_attrib|level(18),wp(60),knows_common, 0],
  ["bonus_chest_1","Bonus Chest","Bonus Chest",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[],def_attrib|level(18),wp(60),knows_common, 0],
  ["bonus_chest_2","Bonus Chest","Bonus Chest",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[],def_attrib|level(18),wp(60),knows_common, 0],
  ["bonus_chest_3","Bonus Chest","Bonus Chest",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[],def_attrib|level(18),wp(60),knows_common, 0],

# These are used as arrays in the scripts.
  ["temp_array_a","temp_array_a","temp_array_a",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[],def_attrib|level(18),wp(60),knows_common, 0],
  ["temp_array_b","temp_array_b","temp_array_b",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[],def_attrib|level(18),wp(60),knows_common, 0],
  ["temp_array_c","temp_array_c","temp_array_c",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[],def_attrib|level(18),wp(60),knows_common, 0],
  ["temp_troop_for_copy","temp_troop_for_copy","temp_troop_for_copy",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[],def_attrib|level(18),wp(60),knows_common, 0],
  ["options_manager","Options","Options",tf_hero, scn_zendar_center|entry(7),reserved,  fac_commoners,[itm_shirt,itm_bushoes],def_attrib|level(1),wp(60),knows_common, 0x000000000000200001c36db6db6db6db],

##  ["black_khergit_guard","Black Khergit Guard","Black Khergit Guard",tf_mounted|tf_guarantee_ranged|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_horse,0,0,fac_black_khergits,
##   [itm_arrows,itm_nomad_sabre,itm_scimitar,itm_winged_mace,itm_lance,itm_khergit_bow,itm_khergit_guard_helmet,itm_khergit_cavalry_helmet,itm_khergit_guard_boots,itm_khergit_guard_armor,itm_nomad_shield,itm_steppe_horse,itm_warhorse],
##   def_attrib|level(28),wp(140),knows_riding_6|knows_ironflesh_4|knows_horse_archery_6|knows_power_draw_6,khergit_face1, khergit_face2],
  ["quick_battle_6_player", "quick_battle_6_player", "quick_battle_6_player", tf_hero, 0, reserved,  fac_player_faction, [itm_nomad_boots, itm_crossbow, itm_bolts,],    knight_attrib_1,wp(130),knight_skills_1, 0x000000000008010b01f041a9249f65fd],

]





upgrade2(troops,"shu_youth","shu_solider","shu_horse_solider")
upgrade2(troops,"shu_solider","shu_infantry","shu_archer_troop")
upgrade2(troops,"shu_horse_solider","shu_horseman","shu_jiao_flag_holder")

upgrade(troops,"shu_archer_troop","shu_strong_crossbowman" )
upgrade(troops,"shu_strong_crossbowman","yuan_rong_crossbowman")


upgrade(troops,"shu_infantry","elite_shu_infantry")
upgrade(troops,"elite_shu_infantry","shu_unstopped_horseman")


upgrade(troops,"shu_horseman","shu_elite_horseman")
upgrade(troops,"shu_elite_horseman","shu_armed_horseman")

upgrade2(troops,"wei_youth","wei_solider","wei_horse_solider")
upgrade2(troops,"wei_horse_solider","wei_light_cavalry","wei_jiao_flag_holder")
upgrade2(troops,"wei_solider","wei_archer","wei_footman")

upgrade(troops,"wei_archer","wei_elite_archer")
upgrade(troops,"wei_elite_archer","wei_heavy_bow_archer")


upgrade(troops,"wei_footman","wei_elite_footman")
upgrade(troops,"wei_elite_footman","armored_guarder")


upgrade(troops,"wei_light_cavalry","wei_heavy_cavalry")
upgrade(troops,"wei_heavy_cavalry","dragoon")


upgrade2(troops,"wu_youth","wu_solider","wu_horse_solider")
upgrade2(troops,"wu_solider","wu_trouble_dealing_army","wu_bowman")
upgrade2(troops,"wu_horse_solider","wu_rider","wu_jiao_flag_holder")

upgrade(troops,"wu_bowman","wu_elite_bowman")
upgrade(troops,"wu_elite_bowman","wu_five_troops_bowman")


upgrade(troops,"wu_trouble_dealing_army","wu_hard_army")
upgrade(troops,"wu_hard_army","feather_army")


upgrade(troops,"wu_rider","wu_elite_rider")
upgrade(troops,"wu_elite_rider","wu_tiger_rider")


upgrade(troops,"huang_jin_posseman","huang_jin_solider")
upgrade(troops,"huang_jin_solider","huang_jin_calvary")
upgrade(troops,"huang_jin_calvary","huang_jin_valoror")
upgrade(troops,"huang_jin_valoror","huang_jin_lieutenant")
#upgrade(troops,"huang_jin_lieutenant","huang_jin_high_capitain")

upgrade(troops,"southern_man_barbarian","southern_man_armyman")
upgrade(troops,"southern_man_armyman","southern_man_berserker")
upgrade(troops,"southern_man_berserker","southern_man_cany_armour_solider")
#upgrade(troops,"southern_man_cany_armour_solider","southern_man_lieutenant")

upgrade(troops,"northern_xiong_nu_wrangler","northern_xiong_nu_horse_bowman")
upgrade(troops,"northern_xiong_nu_horse_bowman","northern_xiong_nu_horse_archer")
upgrade(troops,"northern_xiong_nu_horse_archer","northern_xiong_nu_strong_horse_bowman")
#upgrade(troops,"northern_xiong_nu_strong_horse_bowman","northern_xiong_nu_lieutenant")

upgrade(troops,"eastern_yue_refugee","eastern_yue_climb_footman")
upgrade(troops,"eastern_yue_climb_footman","eastern_yue_flash_footman")
upgrade(troops,"eastern_yue_flash_footman","eastern_yue_fly_footman")
#upgrade(troops,"eastern_yue_fly_footman","eastern_yue_lieutenant")

upgrade(troops,"farmer","volunteer")
upgrade2(troops,"volunteer","voluntary_footman","voluntary_archer")

upgrade(troops,"voluntary_footman","mercenary")
upgrade(troops,"mercenary","perdue")

upgrade(troops,"voluntary_archer","hunderd_steps_archer")
upgrade(troops,"hunderd_steps_archer","sniper")


upgrade(troops,"wei_jiao_flag_holder","wei_ya_flag_holder")
upgrade(troops,"wei_ya_flag_holder","wei_main_flag_holder")


upgrade(troops,"shu_jiao_flag_holder","shu_ya_flag_holder")
upgrade(troops,"shu_ya_flag_holder","shu_main_flag_holder")


upgrade(troops,"wu_jiao_flag_holder","wu_ya_flag_holde")
upgrade(troops,"wu_ya_flag_holde","wu_main_flag_holder")


upgrade(troops,"huang_jin_jiao_flag_holder","huang_jin_main_flag_holder")
upgrade(troops,"southern_man_jiao_flag_holder","southern_man_main_flag_holder")
upgrade(troops,"northern_xiong_nu_jiao_flag_holder","northern_xiong_nu_main_flag_holder")
upgrade(troops,"eastern_yue_jiao_flag_holder","eastern_yue_main_flag_holder")


upgrade(troops,"wei_lieutenant","wei_captain")
upgrade(troops,"wei_captain","wei_high_capitain")
upgrade(troops,"wei_high_capitain","wei_general")

upgrade(troops,"shu_lieutenant","shu_captain")
upgrade(troops,"shu_captain","shu_high_capitain")
upgrade(troops,"shu_high_capitain","shu_general")

upgrade(troops,"wu_lieutenant","wu_captain")
upgrade(troops,"wu_captain","wu_high_capitain")
upgrade(troops,"wu_high_capitain","wu_general")

#upgrade(troops,"huang_jin_lieutenant","huang_jin_high_capitain")


upgrade(troops,"western_liang_valiant_calvary","western_liang_elite_cavalry")
upgrade(troops,"western_liang_elite_cavalry","western_liang_heavy_cavalry")
upgrade(troops,"silver_lancer","silver_elite_lancer")
upgrade(troops,"silver_elite_lancer","silver_lancer_guard")

upgrade(troops,"tiger_fighter","tiger_elite_fighter")
upgrade(troops,"tiger_elite_fighter","tiger_guard")
upgrade(troops,"armoured_infantry","elite_armoured_infantry")
upgrade(troops,"elite_armoured_infantry","heavy_armoured_infantry")

upgrade(troops,"hundred_dead_warrior","elite_hundred_dead_warrior")
upgrade(troops,"elite_hundred_dead_warrior","forlorn_hope")
upgrade(troops,"courage","elite_courage")
upgrade(troops,"elite_courage","horse_free_horseman")

upgrade(troops,"charger_fighter","charger_elite_fighter")
upgrade(troops,"charger_elite_fighter","charger_warrior")

upgrade(troops,"white_horse_vanguard","white_horse_elite_vanguard")
upgrade(troops,"white_horse_elite_vanguard","white_horse_follower")

upgrade(troops,"crushing_man","crushing_elite_man")
upgrade(troops,"crushing_elite_man","crushing_warrior")

upgrade(troops,"mountain_bandit1","mountain_bandit3")
upgrade(troops,"mountain_bandit3","mountain_bandit4")
upgrade(troops,"mountain_bandit2","robber")
upgrade(troops,"robber","robbers_leader")

upgrade(troops,"woman","woman1")
upgrade(troops,"woman1","woman2")
upgrade(troops,"woman2","woman3")




#Note for upgraded troops: Index of upgraded troops should be less than 256, so declare the upgraded troops at the beginning of the declarations.
##
##upgrade(troops,"farmer", "watchman")
##upgrade(troops,"townsman","watchman")
##upgrade(troops,"watchman","caravan_guard")
##upgrade(troops,"caravan_guard","mercenary")
##upgrade(troops,"mercenary","hired_blade")
##
##upgrade(troops,"swadian_recruit","swadian_militia")
##
##upgrade2(troops,"swadian_militia","swadian_footman","swadian_skirmisher")
##upgrade2(troops,"swadian_footman","swadian_man_at_arms","swadian_infantry")
##upgrade(troops,"swadian_infantry","swadian_sergeant")
##upgrade(troops,"swadian_skirmisher","swadian_crossbowman")
##
##upgrade(troops,"swadian_crossbowman","swadian_sharpshooter")
##
##upgrade(troops,"swadian_man_at_arms","swadian_knight")
##
##upgrade(troops,"vaegir_recruit","vaegir_footman")
##upgrade2(troops,"vaegir_footman","vaegir_veteran","vaegir_skirmisher")
##
##upgrade(troops,"vaegir_skirmisher","vaegir_archer")
##
##upgrade(troops,"vaegir_archer","vaegir_marksman")
##
##upgrade2(troops,"vaegir_veteran","vaegir_horseman","vaegir_infantry")
##
##upgrade(troops,"vaegir_infantry","vaegir_guard")
##upgrade(troops,"vaegir_horseman","vaegir_knight")
##
##upgrade(troops,"khergit_tribesman","khergit_skirmisher")
##upgrade(troops,"khergit_skirmisher","khergit_horseman")
##upgrade2(troops,"khergit_horseman","khergit_lancer","khergit_horse_archer")
##upgrade(troops,"khergit_horse_archer","khergit_veteran_horse_archer")
##
##upgrade(troops,"nord_recruit","nord_footman")
##upgrade(troops,"nord_footman","nord_trained_footman")
##upgrade(troops,"nord_trained_footman","nord_warrior")
##upgrade(troops,"nord_warrior","nord_veteran")
##upgrade(troops,"nord_veteran","nord_champion")
##
##upgrade2(troops,"rhodok_tribesman","rhodok_spearman","rhodok_crossbowman")
##upgrade(troops,"rhodok_spearman","rhodok_trained_spearman")
##upgrade(troops,"rhodok_trained_spearman","rhodok_veteran_spearman")
##upgrade(troops,"rhodok_veteran_spearman","rhodok_sergeant")
##
##upgrade(troops,"rhodok_crossbowman","rhodok_trained_crossbowman")
##upgrade(troops,"rhodok_trained_crossbowman","rhodok_sharpshooter")
##
##upgrade(troops,"river_pirate","bandit")
##
##upgrade2(troops,"bandit","brigand","mercenary")
##upgrade(troops,"manhunter","slave_driver")
##
##upgrade(troops,"forest_bandit","mercenary")
##
##upgrade(troops,"slave_driver","slave_hunter")
##upgrade(troops,"slave_hunter","slave_crusher")
##upgrade(troops,"slave_crusher","slaver_chief")
##
##upgrade(troops,"follower_woman","hunter_woman")
##upgrade(troops,"hunter_woman","fighter_woman")
##
##upgrade(troops,"fighter_woman","sword_sister")
##upgrade(troops,"refugee","follower_woman")
##upgrade(troops,"peasant_woman","follower_woman")
##
