// ==UserScript==
// @name           fix html5 attr contenteditable
// @namespace      fixce.user.js@zbinlin
// @author         zbinlin
// @homepage       http://www.czcp.co.cc/
// @version        0.0.2.1
// @description    修复 firefox HTML5 属性 contenteditable bug
// @include        http://html5demos.com/contenteditable
// @include        http://tieba.baidu.com/f?*
// @updateURL     https://j.mozest.com/userscript/script/40.meta.js
// ==/UserScript==

var fixCE = {
    init: function () {
        var elms = document.querySelectorAll("*[contenteditable='true']");
        if (!elms) return;
        for (var i = 0, len = elms.length; i < len; i++) {
            elms[i].removeAttribute("contenteditable");
            elms[i].addEventListener("focus", fixCE, false);
            elms[i].addEventListener("click", fixCE, false);
            elms[i].addEventListener("blur", fixCE, false);
        }
    },
    handleEvent: function (e) {
        switch (e.type) {
            case 'focus' :
            case 'click' :
                e.currentTarget.setAttribute("contenteditable", "true");
                e.currentTarget.focus();
                break;
            case 'blur' :
                e.currentTarget.removeAttribute("contenteditable");
                break;
        }
    }
}
fixCE.init();
