// ==UserScript==
// @name picViewer
// @author NLF
// @description 围观图(Support Opera 10.1+ ,Fx3.6+(need GreaseMonkey or scriptish) , Chrome5.0+)
// @create 2011-6-15
// @lastmodified 2011-7-11
// @version 3.0.3.3
// @namespace  http://userscripts.org/users/NLF
// @download http://userscripts.org/scripts/show/105741
// @updateURL https://userscripts.org/scripts/source/105741.meta.js
// @include http*
// ==/UserScript==


//opera执行会真实环境,包在匿名函数里面.
(function(topObject,window,document){

	//判断执行环境,opera,firefox(GM),firefox(scriptish),chrome;
	var envir=(function(){
		var envir={
			fxgm:false,
			fxstish:false,
			opera:false,
			chrome:false,
			unknown:false,
		};
		var toString=Object.prototype.toString;
		if(window.opera && toString.call(window.opera)=='[object Opera]'){
			envir.opera=true;
		}else if(typeof XPCNativeWrapper=='function'){
			if(topObject.GM_notification){//scriptish的新api
				envir.fxstish=true;
			}else{
				envir.fxgm=true;
			};
		}else if(typeof window.chrome=='object'){
			envir.chrome=true;
		}else{
			envir.unknown=true;
		};
		return envir;
	})();

	//未知环境,跳出.
	//if(envir.unknown)return;

	function init(){
		if(document.body.nodeName=='FRAMESET')return;

		//一些开关.
		var prefs={
			floatBar:{//浮动工具栏相关设置.
				showDelay:366,//浮动工具栏显示延时.单位(毫秒)
				hideDelay:333,//浮动工具栏隐藏延时.单位(毫秒)
				position:'top left',// 取值为: 'top left'(图片左上角) 或者 'top right'(图片右上角) 'bottom right'(图片右下角) 'bottom left'(图片左下角);
				offset:{//浮动工具栏偏移.单位(像素)
					x:0,//x轴偏移(正值,向右偏移,负值向左)
					y:-11,//y轴偏移(正值,向下,负值向上)
				},
			},
			overlayer:{//覆盖层.
				show:false,//显示
				color:'rgba(0,0,0,0.73)',//颜色和不透明度设置.
				dbcCloseAll:true,//双击覆盖层,关闭所有打开的窗口.
			},
			zoomShowMinSizeLimit:{//就算是图片被缩放了(看到的图片被设定了width或者height限定了大小,这种情况下),如果没有被缩放的原图片小于设定值,那么也不显示浮动工具栏.
				w:60,
				h:60,
			},
			floatBarForceShow:{//在没有被缩放的图片上,但是大小超过下面设定的尺寸时,强制显示浮动框.(以便进行旋转,放大,翻转等等操作)..
				enabled:true,//启用强制显示.
				size:{//图片尺寸.单位(像素);
					w:166,
					h:166,
				},
			},
			wheelZoom:{//滚轮缩放
				range:[0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1,1.2,1.3,1.5,1.7,1.9,2,2.5,3.0,4.0,6.0],//缩放比例.(不要出现负数,谢谢-_-!~)
				minZoomSizeLimit:{//最小的允许缩放尺寸,当原图大于设定值的时候,缩放到设定值,如果原图没有设定值大,那么最小的缩放极限为原图大小(为了能 100% 显示)
					h:199,
					w:199,
				},
			},
			firstOpenFTS:true,//当图片大于屏幕的时候,第一次打开,是否适应屏幕.
			magnifier:{//放大镜的设置.
				radius:77,//默认半径.单位(像素).
				autoRadius:true,//当满足某种特殊条件时为会自动缩放半径,比如:原图太小,为了看到局部-_-!!~...都说是放大镜,就是为了看局部的,我才不要一下全部看到呢..
				//双层边框设置.
				borderWidth:[2,6],//[第一边框宽度,第二边框宽度]边框的宽度.
				borderColor:['rgba(255,255,255,0.9)','rgba(0,0,0,0.6)'],//[第一边框颜色,第二边框颜色]边框的颜色.
				shape:'circle',// 'square'(正方形) 'circle'(圆形)
				minSizeLimit:{//限制当看到的图片大小,大于设定值的时候,才显示放大镜,实际上有被缩放的图片上,都可以显示放大镜,但是如果当前的图片太小,不够足够的距离移动,体验不好.
					width:60,
					height:60,
				},
				wheelZoom:{//滚轮缩放.
					enabled:true,
					needToPause:true,//需要暂停后,才能缩放.(推荐,否则因为放大镜会跟着鼠标,如果放大镜过大,那么会影响滚动.)..
					range:[0.5,0.6,0.7,0.8,0.9,1,1.2,1.3,1.5,1.7,1.9,2,2.5,3.0,4.0],
				},
			},
			multipleInstance:{//多实例相关.
				oneSrcOneInstance:true,//每个SRC只打开一个实例.
			},
			mode:'auto',//取值:'css3' 或者 'canvas' 或者 'auto'(优先使用css3) ,,,表示渲染旋转,翻转,缩放的使用方式..如果你选择的方式不支持,那么会强制使用另外一种.
			shiftRotateStep:15,//按住shift键时,旋转的步进.单位:度.
			waitImgLoad:true,//等图片完全载入后,才开始执行弹出,放大等等操作,按住ctrl键的时候,可以临时执行和这个设定相反的设定哦..比如为true的情况下,如果按住ctrl键,也可以不等图片完全载入就能看哦..
			iframePicOpenInTopWindow:true,//iframe里面的图片在顶层窗口弹出(顶层窗口是frameset的话,那没办法,不过采用frameset的网站,应该绝种了吧..)(chrome此功能无效).
//////////////////////////
			debug:false,//输出debug信息(影响速度,并且可能对你完全没有作用,你最好关闭它..-_-!~)
		};

		//图标.
		prefs.icons={
			actualSize:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEoAAAAWCAYAAABnnAr9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJ  bWFnZVJlYWR5ccllPAAAAyBpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdp  bj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6  eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEz  NDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJo  dHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlw  dGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAv  IiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RS  ZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpD  cmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNSBXaW5kb3dzIiB4bXBNTTpJbnN0YW5jZUlE  PSJ4bXAuaWlkOkY1NzU5MkIxQjU4MDExREZBRDk3QThGQjYzNENBMTU5IiB4bXBNTTpEb2N1bWVu  dElEPSJ4bXAuZGlkOkY1NzU5MkIyQjU4MDExREZBRDk3QThGQjYzNENBMTU5Ij4gPHhtcE1NOkRl  cml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6RjU3NTkyQUZCNTgwMTFERkFEOTdB  OEZCNjM0Q0ExNTkiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6RjU3NTkyQjBCNTgwMTFERkFE  OTdBOEZCNjM0Q0ExNTkiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1l  dGE+IDw/eHBhY2tldCBlbmQ9InIiPz5NyVjzAAAGS0lEQVR42uxZXUxcRRQ+9+5ld9mlUKAiYClE  CkJ8MDaANto1afxNfVETjL4Ya5o0bXwyDZrUUpvYprWxrcbExNRUH9T0QR60SqwkBhWbgBaUFiUh  rixlwRZqV9j/veOcuXdm517ubhfbfetJbmZm98z55vzO2bsKIQSQJiYmyOLiIui6ztYul4uN6XTa  subf20lVVTGvqqqC9vZ2xc7zy+9BcuXqNdDBxCDGnoxiYKigGRiQAwOyGOsqK2BTW9MKjMHBQTI7  OyvOqWmGzGQyaVkXokd9fT0EAgGGoaChpqamSF1dHXi9XuCGUxTjDLnWduLfI8XjcQiHw9Dc3Cw+  nAiGSF1NHZT5NGEGfqRc65WGytJSNA3hv8PQ3tQgMIaHh0lrayuUlZUJQ3DFc63zGWppaQkmJyeh  s7NTgdHRUVIsMmXD0G9/FA3DlA39/f1Fw0DZaiQSgWIRl33t3+WiYXDZCwsLRcNA2RpPp1yhKNOj  +37AZGXzb97Y4siDsjANMYTlMMaMzZW20m545PXvBcbZAw85cumUTzXTXa5bqEMmk7muHo/vHxIY  /b0P5NUDazPThQNg0cYHix6f29df7u1iQo4/W23hkXlTqRQbUaZsfF0nkEgZTzyVnVvXAF/s2yIw  EjY+xpvWIUn5cG4YP4uBRkJsfGKxmJjb13099woMmUfmxTqLI8pEPTQOgArKgEgH++ZBEb4GNr//  rgb47Dxdn58BrN94WBxfe+p2i2HQE/ymZDIpYyJNLNGDEo98HsyD8acFY8/TTZSHmJwUQ6NehywG  OiuRSFjWSEfPXM2DMWfBeGVbpSUqS0pK2E2pyZ6wUzqdgSMvtl43lPd8OMk8IN8a9jTLZKih7Gmh  rBJDN/abWQPetGrhQWdjFNyIHnjTObVDokbJnuB0NRKFEH3m+hvZ+pnlr7NuMWl6ewctqFFqiApL  RMmtBk+9WNJsNVTCegCirA4jkaDxRK3EDVXmJlmrmXosLy/fkB6plMsSUbzV0OxFUFYuRotGMqOD  b8NLcGjueQh4ANrurISO28phJpqE734NQygUMvikiMQiaI8oA8MwZEa6NwrBmJyLMb4ErU+sqtLB  RY1sL9tyCVmtHuPj44xPjkjUQ/Rf9mKOYN2HxyxW7fPvFnMU3uZ5Fdb73JZ6Ju9DOfzWyNYo2h2b  DxrqhQMDIGdiXgxJBtuHnbaO5wYjLB2KORpsx/tBS+3Nh8H55H0oB/XAcqLJYSvTc0fH4Y6aKkhS  L66nIbmhxgNrPQoTjrTG/SR0N5xk+2LxFOPP17njx3rG+t32NwcKwsB9iIH8zLEZYhRn4nyty7Tr  5KUC9VhiGLtOzjvKUXMVtsPd5fQKplc+rS3+siXwr4mBz5eES2ScPSFyBeLuC4w3Qe9r5M93aIXV  JvNZJYZiw0AZRiMFlhpVLD1EjWKhpYnggtM995hhOAlpmiex6EU4Nf0peFUPkAvVUH/iLMy8vJXe  DB/DfR2bIEVTrbFxIwX5S8iR087AoHWFN6B0OLX3YfyhCamvhhhGNDoBH01/4ohx7MHHGEZt62aK  MULrkypkyoQ3ldvtFusPdjaZesybGBcphrMehzbuZxgVFesoBgg5XA+NL1QbKq6T9FqN097nndET  9BQeiJiHiezoAi0eg3L/WmaYVEpnY0tLi+VKlW9BlOfWdJGHBr4iMN4dPZ4Tw033IkaJS4UNd3cZ  N6Zq9D267Ye53Ltx42UxcuuBhkEMHGtray311xJRsieyfUkGlmluj+wcyRnaly9fZp6w75cjlB2Y  KuF1KVIiFo4R/ifBMLwl5j7TFhooK4xSWlr6v/QIBoMMw76f66WhkRDA4/E4Nmq9b5+DXt7O4g3D  awIxFGZdLZ057efexV9KLpUaqsRlblWErVaDIfabH+DgItmIxS7a7/ffkB5O+0VnjgohiL0QD7y1  FUZGrF7oOR1xLHj2/SsiikaTh1tHNw5HaOP57bEn4OdzPxaE4XHxGmc0rG5NWYFpdxh7BXNwC4yN  jRWGYdsvIgrzL1fIIgUCATHfvPsM8wgHkb9zIpHjoDND+Wz146ZgKNl6iM6yO+xmYGBfqJWXlxf8  Xuan97bhq9YVwLmIy65Y4y8aBpddXV1dNAyUfetVcIGvgpVbfy4U9ufCfwIMAOWpL7kL666RAAAA  AElFTkSuQmCC',
			magnifier:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEoAAAAWCAYAAABnnAr9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJ  bWFnZVJlYWR5ccllPAAAAyBpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdp  bj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6  eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEz  NDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJo  dHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlw  dGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAv  IiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RS  ZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpD  cmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNSBXaW5kb3dzIiB4bXBNTTpJbnN0YW5jZUlE  PSJ4bXAuaWlkOjg5RjAyNUU3QjU4MDExREY4MDhGRDYxMzM4MUJCMDNEIiB4bXBNTTpEb2N1bWVu  dElEPSJ4bXAuZGlkOjg5RjAyNUU4QjU4MDExREY4MDhGRDYxMzM4MUJCMDNEIj4gPHhtcE1NOkRl  cml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6ODlGMDI1RTVCNTgwMTFERjgwOEZE  NjEzMzgxQkIwM0QiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6ODlGMDI1RTZCNTgwMTFERjgw  OEZENjEzMzgxQkIwM0QiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1l  dGE+IDw/eHBhY2tldCBlbmQ9InIiPz6P82IlAAAHZ0lEQVR42uyZe2xUVR7Hv/fOvfNoSwtTKJ1C  S2mxUko0UKYqSBHEWNDEPzYmrmuIceMjvoIQMSGbNUh8xqzr6h+7Cij4APU/MUpMQLeiu3R4LtEW  FF88Oi22MNPO+z48vzs9d+6dB3Tqzn+e5MzMufee3+f8fuf3+51z7gi6roNKb2+vPjw8DE3TjLbD  4TC+FUWxtfn97CKKovnb6/WitbVVyH7mcN+P+i8XQtAwxtDTfVQhzRAhpRkowECGMXVKFRbObcxh  dHd36+fOnTPHKUlpmclk0tYejx51dXXo7Ow0GAIZ6tSpU7rP54Pb7QY3nCCkx1ConV34fSrxeBz9  /f1obm42L/b+eFr31fhQUSaZZuBDKtTONVSmjEYV9A/2o7Wx3mQEAgG9paUFFRUVpiG44oXalzLU  6OgoTp48Cb/fL+Do0aN6qcqYbHx1/ETJGGOysWfPnpIxSLYYDodRqsJlh0YiJWNw2UNDQyVjkGyJ  h1MhV+Rlb08fdvZEEVMzoedxCPhjRxlu7JhrXiNZFIbkwlY3pogtFLYZRi/e7YkgplgYkoA7O8oZ  o9W8pkE3wtDgWAKSdFBV9ZKMfYET2BWI5ehxh9+DFf4rc/Sg3Ex6SBzAkzb9tipI7Q07jmF2fQ22  3D8bDneZeU9NRPHy3iB2bwngxbsX2IztdDptbU3TkRwzAH1aszC1n3izJ824rzEv48PXD+CFuzug  C2RxgfXX4ZLZp55hkJF40qbffAHi7Y07v0ZT/XSmR1N+PbYdxPN3XWUztsfjMfSQuJBUKmUTysuG  HcexsqMRty3y4bUDQ/jy+wEobDaSSRXXzZqEtV1N+OhIGdZtO4xn/9Rm9qNB2gbKZiih6FnmSZtr  444AVvpnXZaxflsPnl6zaKwvY0hs1pFh0GQnEglbm5e/7Opjesy+LOPx7cew6fYrzH6yLBsrpZQ9  E7al9sj38PmqcetCHzZ8GkTzFBl/XlyD2gqn4a77T4Ww5q3vsPXOZnz9c4iFzgksW9icd3VU2aAS  2WHB7LT/YB98td5xM/b1fIPr29Oh7lZEmzia7FgslqPHV8dPMz2mjpvx2cFvseSqWfbVkitFM5Fd  tx+I49Glk7HrmxA8bFmX3TKigoRVj7yEKHP/lXOrcMt8L175PIhHl3nxzqGk2ZeMbzUWhV4sma5x  RUM8qbHfGt7+T7goxs6eEaMvVY3kC7otr0QikZz67iGlKMb7xzJyyCuNdGRNglTpBq9x5rlVbPP4  bUTH5CoXUm4nqy6UsRoVHLiQErCooQKBs1FUeqsRSehGv2wjZRjpSiGYoJyl6hNiUH8Km+y0zVMI  VYoQXuNqkYykbvQjOebGNTuZ28D0kJJEeZmMSZNk/G3jS3Ax4S4Wt2vWvYxYPIFPXn2MJW6WJ9Sk  8TzPb3zVyOQotjvWLelp7HtCDGNsNG4YiT1fMv+tevCcTXqYq16hHXe6gwbZJcPlFLH5X0+A8vOm  h/+OZ55bCycDnA6lIEsiVEU1ni+0BaDLmvr/YZAcwWpwG6c0ekiX2nN4HArOBINo8tThokMG7RrI  YRJM8LlQHBLLReFwCgt8Ms72By3rT+6gSTHBekYR099uh1oUQxQscgyh+mU3jG4xVRwDuWlD5Ocb  YwnMqvdPewXP7RuF3xmFymZkZFRDdFTBumceY+7KjBhSMRjV8Ic5Mp7fO4IV9WGzrzXs0gy2nLMP  o7KZczBtJab1A9P+URTjhoak0ZeqaF/0jO0I7d+y6wM1rxbF6Jw+ZPbleoj8QMt30rwK/12Mllt2  YE7o39i6fwg3iedRlYhgOKIhFFEQTmio9yh4sFXFO4ELOHtmAF3+BsNI+Q6edM3J/NeoDtos6ijb  31Ik4zxWXnsFXMx1nTKN236A5jtpa53cu6ooxpnTQSy/utYwkvWNiWQqwW6Yp//upaha+jo0wYUF  /mvQ/fkH2Dy4GmuXSLi+2stikuWIKQLODw/j6d0qBoKDWL/cjRkzZmRiWrJHtYMp4XYIZswoe69G  ZVGM81h7kxcNM+oseUPI8SjaSZvtQ11FMYL9A3joOmDmzJm2E4bBIiMRwOVymTdHWPxWViZwsfcN  fPfDTHinN2HOxc1Yv+tehJJnzedc7By2ek4K99w8FW1tbTm5gc8IncccLMzcsmNssRPYWasA4737  EEpYGSJWtWhYs9qH+W3z0/3JlfS0Rzn0jMfSLrq8vHxCenQ1xXHXiimYN29ejh7mzpwUIkjmcOFE  bOAoGlJvwF9+M1KxL6B1bsFT7Dnr8YYGV1NTA3qXlU+43WgCXNwDtDQjOvg/xthqMtRl27FJysOY  TgzmSdpYf1E3ZDglIYdpnfAwY0T6DzPGdpORXPxP/DWPHtOmzc6rh+lRFH/ZLjtc+yR++ugFFpu1  bNaOYPKSt9De3l706wk+GHpjSYYqs5z9DMZuO+PaiTAEzcwjNNnWCT9BjI9/O4P2mFJlZWXOjXnt  XegrbzTbEzESFS67alJ5yRhcdnV1dckYJPv3V8HjfBUs/P7nwvj+XPhVgAEAvMSkhee0ttQAAAAA  SUVORK5CYII=',
			noZoom:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEoAAAAWCAYAAABnnAr9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJ  bWFnZVJlYWR5ccllPAAAAyBpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdp  bj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6  eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEz  NDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJo  dHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlw  dGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAv  IiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RS  ZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpD  cmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNSBXaW5kb3dzIiB4bXBNTTpJbnN0YW5jZUlE  PSJ4bXAuaWlkOjZCOTNCM0NGQjU4MDExREY4Njg3QjAzMURERUQ0RjVEIiB4bXBNTTpEb2N1bWVu  dElEPSJ4bXAuZGlkOjZCOTNCM0QwQjU4MDExREY4Njg3QjAzMURERUQ0RjVEIj4gPHhtcE1NOkRl  cml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6NkI5M0IzQ0RCNTgwMTFERjg2ODdC  MDMxRERFRDRGNUQiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6NkI5M0IzQ0VCNTgwMTFERjg2  ODdCMDMxRERFRDRGNUQiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1l  dGE+IDw/eHBhY2tldCBlbmQ9InIiPz6199zKAAAGVklEQVR42uxZXW8UVRh+zuzs7Ce7/ZaWFgkt  LTWAoVpAo40Eo17ohRpFYrhRf4B33uO1/gEjCeKFJCZemBhIMCRVCaGGVEpShZSAxRaQfm27X7Mz  c3zPmTmzs7vdBrrdO0833Tlz9jzPeb/fnWWcc4gxPT3NFxcX4TiOnIdCIfluWVbFXK1XD03T/Ou2  tjYMDw+z6s9c+/MOf7S0AgceB3f32Mzl0KC7HKjDgTJHR2saI3t31XCMj4/zubk5/5y67mKaplkx  fxw5enp6MDY2JjmYUNTMzAzv7u5GNBqFUhxj7hnqzauHWhejUChgfn4e/f39/s3pO7O8u6sbybju  q0Edqd68VlHlsZazMP9wHsO7+nyOiYkJPjg4iGQy6StCCV5vvpGi1tbWcPPmTYyOjjJMTk7yZg0P  G5en/moah4eN8+fPN41DYGuZTAbNGgp7ZTXbNA6FvbCw0DQOga2rcAq64je/3cLU7BLcKFsn1HhN  3IkX9ve14uSLAzIMhQsH3VhgBcP2zK83iWNxExxtOPnSHhmGkicQkEIG27b9+beXZzB1bxNy9Lbi  wxd2S3yRm4UcuiJQSVtcT95dxOcnRkUCg596eCW24uZeTnHAcOrcBD4YLcl1wzAqlO84HKbF/b2T  dxc2zXH88B664oiE6T8vcwglqaQtrif/3rwc7x7skeuxWEzKoSvQUqlUJnRsWCTYp2cp8ZoMNi3l  Cu5abydDNMRxZZohR4KP7GHY2wmcfL0g9ykcYQlVKSUmHbZo8S3hKFpe1dRJAShzCGMXi8Wt4fBw  wuGwrJR6tSVUmJQsG70tBmKa8AaK0yVgNUf3KSVkigxtcWC4jeHOP6R1+Xkq6rRReWZ1dbRtUlQg  LBrhMG1XUVFLq+AQRsrn81vD4enDbzOUUEFLcFoskZYHtnPEdYY1WqKqDk5yJuLCO+iQZMh9u4Ab  c0RMpPLwtE/hBFsNFXp502s1NN4QR8F0D580uGhwAorhyGazWyKHwlGthl6dBAWZ+BPu3bn9Jyxr  s8gu23QnTe6bQJYnoVntdMgWLGVbkY61Qqf9prSE6/4iCVZ7lMvheCGBhjhECIco59hVuTiYQhqV  Q3iUkKPCo4LJXM2LJM3Swo8wY78jbmcR1RPIl6LIrcbBzQ48yOzA/fud4KUWdCU6YDrHZGINKjzY  hArrmYEM2hCHp2wpA2frJvNG5Qgq3K96NTmFLgslGxOXHqBE5zBiYUQTJWiGhTBbBfXEdKrrpH2K  8+U88tnnMGIfdatHnc5d3HbsreEQOKxexW+SHPp6QolkViD3zjzMI1swEY4WYSRthMJEEObQDaFl  Sny8RJaxUNJX5eedKvAgGZO5qfwdpREOH0eC8rqN4lbJ4eco6Vq6XrGwShti7UNwckkwUYZFz8Io  kTqEnNMoIYoQcJAr5lFc60VWxLYA9HCCYedyUDlXDajWGEfI05RWWfRkOyL6t62QQ+EoOXQ1qeii  yVS5EseXn31R9op1Q4q5L43hwq1luU8oSiXAYMMp8A3d8bEa4YhQpRIPHoQMTtUX82Dv1giHUJTK  txUeFbRETyKEHy5ew/cXHLfzVTHL3WrFFDBz3zWysBbSsDMV9j0q6KHS2kw0eMw/WPe2yKY4+lpi  siN3rcxqPEp00mpsj7FNcfQmy56p3nWhJEEQiUR8gvcOtGFlZcWfX1/Scbeg4+rtRzg+Nohz47dw  aHcHno5aONBarpbpdLoCR1lXfB8LkbWi4ZBv6XeefQoZweEZeGqRY7bAcHXm3zJHfyf6ohz725nv  DemWFkQMXe4T8oV42WNFF51IJHz+t59JeXK40XIjY+BeKYKJ2ws+x+judvSGi9iXMgNypCpw/M5c  CCRI1BDPdILPob46/QuOH92HNw8PQHQip04coe62gHOXbuDj115eN5HWeBR5U0R5ABl3eGCAwsfj  cBhOf33R5TjUX8PxyRvHvH3efrGPMAyd1XAGDTU0NFQhx5mzV4hjAG/Rd8Vqjo9ePbKuHL5HyeRY  5bLV4+COFL77+Q9YsrxzGTo6CT7S17rhPj/G4UhFxQP540k44kb9fTYr50Nh7KDBn4QjlUrV3Sd6  TH2jD6jx/vO9eGWnUVnuyUJdXV0b7lPY6W2JpnEo7Pb29qZxCOz/HwU/5qNg9v+PC4/348J/AgwA  f2fF9hwxRGcAAAAASUVORK5CYII=',
			loading:'data:image/gif;base64,R0lGODlhGAAYAPYAAAAAAAQEBA4ODhgYGBkZGR0dHSAgICYmJisrKy8vLzMzMzQ0NEBAQExMTFVV  VVlZWWdnZ2xsbG9vb3R0dHV1dXx8fH19fYiIiJeXl52dnaCgoKmpqa+vr7W1tbm5ucPDw8nJydDQ  0NXV1dvb2+Xl5evr6+zs7O/v7/X19fv7+wsLCw8PDxcXFywsLDU1NTs7Oz4+PkZGRklJSU1NTVNT  U1xcXF1dXWFhYWlpaXp6eoeHh4uLi5ubm7e3t7+/v8DAwMfHx8jIyM3NzdLS0tjY2Nra2tzc3OLi  4unp6e3t7fLy8vb29gUFBQwMDBYWFhwcHCcnJykpKTY2NkJCQlRUVFdXV1tbW2hoaHh4eH5+fra2  tri4uLu7u+Tk5PT09Pf39/j4+AoKCg0NDS4uLjc3Nzo6OkVFRVFRUVpaWmpqanl5eYmJiZ6enqio  qMXFxczMzM/Pz9PT09nZ2ebm5u7u7vn5+cTExAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/  C05FVFNDQVBFMi4wAwEAAAAh/i1NYWRlIGJ5IEtyYXNpbWlyYSBOZWpjaGV2YSAod3d3LmxvYWRp  bmZvLm5ldCkAIfkEAQoAKgAsAAAAABgAGAAABv9AlXA4THkkEk+KyGwOMwMAYKBxWoUkhFSKIF2H  n0nyI9gCBCBVCmX9JAiDw8VgLoxAFEvISSH4Bw8UAVIBFiYRDQ0XS0wSfn4OJRiJGCiHiRVsTB0H  AwMFGUIpjCodEBEfVhwPDhmaTSYmTiMdISivVyEdI0MgDQsMG19CGwwKDWkqFgvMD7JXJw8LCgoW  QhXUCg8nXybSzBVCvgrBwyrFCw2pQrQhpFa3urywz00oGQ4PHG0SEB1FjDIUgHPgHxMUFRJBMIFi  UgMMJRw8IiChSQoLiSSYsDAIQAAKDyZScCLCAgUQIwqYMXDhgJ8E6yyyAVFmi4APHSRMiHkli5kQ  LuaYaIgyJVRQIkaQePgSBAAh+QQBCgABACwAAAAAGAAYAAAH/4ABgoOES0NDS4SKi4RIEi0tEkiM  lIM7BCwEBDsBS0RFKZRLQkBJKTWamjZCNJk3R4tLOi8vE0k5mpk4MQC9ADehhEIwCi4uPUUymjM8  K74ABEaKQS8KxRwBJBwcSD8qzwRFikoTxjckikguzzSJikkdHOiLPy4qKjFDiilKwZVIPoAg6Tdo  CQ8cOiZVEoRkBw4ewVjNmLFhoaANE2kEESSRosUAG2TMoCFEkEEcOxQubPjQnSAlSID8UEmJnz9B  Q2Lcc/GDkbYOSWLReOaCZrYbxiYoUVSEwDMVM7eh42BMwQsgiow49bWCxwxNMop0cGENRklCKW48  i4EDk6YcSSkm0NLhctCRG5hI2khFoAY/IEHqoi1CJNElTCw4fUz3KJLRxZ0OCVYUCAAh+QQBCgAB  ACwAAAAAGAAYAAAH/4ABgoOEgmCFiImDIFlZIIqQgkYNClINRpGEYF+CWlJSlVoBWhESH4oiWVhA  ASFTCgpTQxxQTk8Jp4VgWQ0NEUkBG1VVG19WtrYTiGBYvVfAAUnAX1VPTrYSiSAREFuJGdZPUN6E  XSAjJtCIXxlUVRdAJIMZUU1PWV6RJhJPTVEZAbY4AUCQCUBIGZgQBOCEi4SFBBscUtQAIgAJDyFK  VASmIsQIXAYWPKgIg0KCTrzRszfBRCQvWfpF0TCIBJALVahk4JRI2ggQ8ghtgRKOJCEtECI8QhTB  mi0qnKQJSnKlF5aJhCaEc2LlywYrVjaASRKhVxasgz4ksAaFw5BXsSWGBACCJYsIRR8kRBDlqZIU  UQG+oI00CdSlTIpAYMGyFLHjRIEAACH5BAEKAAEALAAAAAAYABgAAAf/gAGCg4SFhoeGS29vS4iG  dXJEjQFsZ2dsjoRHNwMsZ3FKaQ0NaXQBSm6MjzcArQANSGuja3V0EmUvOpODRk+uAGFudG1tSAEd  ZApkL3CFcgO/YT+FHMkKZW6FS2e/ZMaEczfKE0qGcGZiYWTThnMcHaaESDs1aTw/34hyamhrxksS  BghsMCfTnAYCB0ioE2dMwiccMnF4knBMnIYsBEKUSLGTRYAJCRpE2ElCo3lo1Mgx+INHmho78gmi  04FDQUM/yIQRY6ZZISUTkt24OQgJmV9ndglyU0aBsoiEfoT5NWAlITgvkpHpEAAJMTpuprp6YkSb  jjJlJNCpI6uBvwa/J27USQTHTTk6okgpiXMm440jmQZVaoApwBI5RuYGFqQIjtLFkAsFAgAh+QQB  CgARACwAAAAAGAAYAAAH/4ARgoODKR4SEh4phIyNgxkDAAADGo6WgiQIkpIIJJeDHxOJdgKbAAIg  ESiLjh8JBAMHFwamBSMgFFkijhQEvgMPFAGSAVlJEjMzWSiNEr6+DiUYyRgoSVczDRWshB0HAwMF  GYIp3B0QV3aWHA8OGcyOSUmOIx0hKPCXKSEdRoMgMxYw2PBJ0AYGCmakilBhgcMH8y6deKCgYhZB  WSoqgPgpyYMFChZUEGRnhoKBBSMcXDBDnSAj9rhZwsfPXyN5MzPQeMDBkh0JEDoUYpWhAKwDQhmh  qNCgAYQkKKY1wFDCwTMCEhqlyJJNQpIswwAEoPDgKgVHIrJQADGigCkDFyYO+ErwwVIKZiBKbRJg  p4OECXULZjLVKSUjDZEmVTJMyBAiRZcCAQAh+QQBCgABACwAAAAAGAAYAAAH/4ABgoOES0NDS4SK  i4RIEi0tEkiMlIM7BCwEBDsBS0RFKZRLQkBJKTWamjZCNJk3R4tLOi8vE0k5mpk4MQC9ADehhEIw  Ci4uPUUymjM8K74ABEaKQS8KxRwBJBwcSD8qzwRFikoTxjckikguzzSJikkdHOiLPy4qKjFDiilK  wZVIPoAg6TdoCQ8cOiZVEoRkBw4ewVjNmLFhoaANE2kEESSRosUAG2TMoCFEkEEcOxQubPjQnSAl  SID8UEmJnz9BQ2Lcc/GDkbYOSWLReOaCZrYbxiYoUVSEwDMVM7eh42BMwQsgiow49bWCxwxNMop0  cGENRklCKW48i4EjFYEcSSgm0NLhctCRG5hI2kjFogY/IEHqoi1CJNGlTJs+LnIESZLiWIcEKwoE  ACH5BAEKAAEALAAAAAAYABgAAAf/gAGCg4SCYIWIiYMgWVkgipCCRg0KUg1GkYRgX4JaUlKVWgFa  ERIfiiJZWEABIVMKClNDHFBOTwmnhWBZDQ0RSQEbVVUbX1a2thOIYFi9V8ABScBfVU9OthKJIBEQ  W4kZ1k9Q3oRdICMm0IhfGVRVF0AkgxlRTU9ZXpEmEk9NURkBtjgBQJAJQEgZmBAE4ISLhIUEGxxS  1AAiAAkPIUpUBKYixAhcBhY8qAiDQoJOvNGzN8FEJC9Z+kXRMIgEkAtVqGTglEjaCBDyCG2BEo4k  IS0QrjxCFMGaLSqcpAkyAaHXhImEJoRzYuXLBitWNoDxEqHXBayDPiSwBoXDkFexJYYEADIhiwhF  HyREEOWpkhRRAb6gjTQJ1KVMikBgwbIUseNEgQAAIfkEAQoAAQAsAAAAABgAGAAAB/+AAYKDhIWG  h4ZLb29LiIZ1ckSNAWxnZ2yOhEc3AyxncUppDQ1pdAFKboyPNwCtAA1Ia6NrdXQSZS86k4NGT64A  YW50bW1IAR1kCmQvcIVyA79hP4UcyQplboVLZ79kxoRzN8oTSoZwZmJhZNOGcxwdpoRIOzVpPD/f  iHJqaGvGSxIGCGwwJ9OcBgIHSKgTZ0zCJxwycXiScEychiwEQpRIsZNFgAkJGkTYSUKjeWjUyDH4  g0eaGjvyCaLTgUNBQz/IhBFjplkhJROS3bg5CAmZX2d2CXJTRoGyiIR+hPk1YCUhOC+SkekQAAkx  Om6munpiRJuOMmUk0Kkjq4G/Br8lbtRJ9MZNOTqiSCmJcybjjSOZBlW6JGiJHCNzAxdepFSx40KB  AAA7',
			loadingCancle:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAMCAYAAAC0qUeeAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJ  bWFnZVJlYWR5ccllPAAAARJJREFUeNpi/P//PwOxgImBBMACY5g6hzUzMDI+YPj/byHQtj+MjIxA  OcYooJTq6b2ralEUa6qr/Lz78KkZw///XP///p3FyMycBFRsoCgn+RimhhHm5jfvPpgV1/T6Pnr+  SoyB4f9noBSvnKTYq76W4i3CQgInURQDAfOTZy+tsiu6w/78Z2RjZvj3e1pn2UoZKfFjQLm/KIrt  fZNYODg5UphZ2A05ONj//Pjxk+Xvn19Xfnz/Pv3g5nl/UEKDhYUp7v9/RkNZabFXU9tLdoLo/wyM  OkDxRIyg4+Lk0tZUU3jaUZOzQ1JcZDuI1lSVf8rJyakJDzuQM6DYBYiNgJjZJSgNxGeG8l1gahhp  FoMAAQYAjyKC8qt4w34AAAAASUVORK5CYII=',
			close:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAB4AAAAeCAYAAAA7MK6iAAAACXBIWXMAAAsTAAALEwEAmpwYAAAA  BGdBTUEAANjr9RwUqgAAACBjSFJNAABtmAAAc44AAPJxAACDbAAAg7sAANTIAAAx7AAAGbyeiMU/  AAAG7ElEQVR42mJkwA8YoZjBwcGB6fPnz4w/fvxg/PnzJ2N6ejoLFxcX47Rp036B5Dk4OP7z8vL+  P3DgwD+o3v9QjBUABBALHguZoJhZXV2dVUNDgxNIcwEtZnn27Nl/ZmZmQRYWFmag5c90dHQY5OXl  /z98+PDn1atXv79+/foPUN9fIP4HxRgOAAggRhyWMoOwqKgoq6GhIZe3t7eYrq6uHBDb8/Pz27Gy  sloga/jz588FYGicPn/+/OapU6deOnXq1GdgqPwCOuA31AF/0S0HCCB0xAQNBU4FBQWB0NBQublz  59oADV37Hw28ePHi74MHD/6ii3/8+HEFMGQUgQ6WEhQU5AeZBTWTCdkigABC9ylIAZeMjIxQTEyM  ysaNG/3+/v37AGTgr1+//s2cOfOXm5vbN6Caz8jY1NT0a29v76/v37//g6q9sHfv3khjY2M5YAgJ  gsyEmg0PYYAAQreUk4+PT8jd3V1l1apVgUAzfoIM2rlz5x9gHH5BtxAdA9PB1zNnzvyB+R6oLxoo  pgC1nBPZcoAAgiFQnLIDMb+enp5iV1eXBzDeHoI0z58//xcwIX0mZCkMg9S2trb+hFk+ffr0QCkp  KVmQ2VA7QHYxAgQQzLesQMwjIiIilZWVZfPu3bstMJ+SYikyBmUzkBnA9HEMyNcCYgmQHVC7mAAC  CJagOEBBbGdnp7lgwYJEkIavX7/+BcY1SvAaGRl9tba2xohjMTGxL8nJyT+AWQsuxsbG9vnp06e/  QWYdPHiwHmiWKlBcCGQXyNcAAQSzmBuoSQqYim3u37+/EKR48uTJv5ANB+bVr7Dga2xs/AkTV1JS  +gq0AJyoQIkPWU9aWtoPkPibN2/2A/l6QCwJ9TULQADB4hcY//xKXl5eHt++fbsAUmxhYYHiM1Di  Asr9R7ZcVVUVbikIdHd3/0TWIyws/AWYVsByAgICdkAxRSAWAGI2gACClV7C4uLiOv7+/lEgRZ8+  ffqLLd6ABck3ZMuB6uCWrlu37je29HDx4kVwQisvL88FFqkaQDERUHADBBAomBl5eHiYgQmLE1hS  gQQZgIUD1lJm69atf4HR8R1YKoH5QIPAWWP9+vV/gOI/gHkeQw+wGAXTwAJJ5t+/f/BUDRBA4NIE  KMDMyMjICtQIiniG379/4yza7t69+//Lly8oDrty5co/bJaCAEwcZCkwwTJDLWYCCCCwxcDgY3z1  6hXDnTt3voP4EhISWA0BFgZMwNqHExh3jMiG1tbWsgHjnA2bHmAeBtdWwOL1MycnJ7wAAQggBmi+  kgIW/OaKiorJwOLuFShO0LMSMPF9AUYBSpz6+vqixHlOTs4P9MIEWHaDsxSwYMoE2mEGFJcG5SKA  AGJCqjv/AbPUn8ePH98ACQQHB6NUmZqamkzABIgSp5s3bwbHORCA1QDLAWZkPc7OzszA8oHl5cuX  Vy5duvQBGIXwWgoggGA+FgO6xkBNTS28r69vDrT2+Y1cIMDyJchX6KkXVEmAshd6KB06dAic94EO  3AzkBwGxPhCLg8ptgACCZyeQp9jZ2b2AmsuAefM8tnxJCk5ISPgOLTKfAdNEOVDMA2QHLDsBBBC8  AAFlbmCLwlZISCg5JSVlJizeQAaQaimoWAUFK0g/sGGwHiiWCMS2yAUIQAAxI7c4gEmeFZi4OJ48  ecLMzc39CRiEmgEBASxA/QzA8vYvAxEgNjaWZc2aNezAsprp2LFjp4FpZRdQ+AkQvwLij0AMSoC/  AQIIXklAC3AVUBoBxmE8sPXQAiyvN8J8fuPGjR/h4eHf0eMdhkENhOPHj8OT+NGjR88BxZuBOA5k  JtRseCUBEECMSI0AdmgBDooDaaDl8sASTSkyMlKzpqZGU1paGlS7MABLrX83b978A6zwwakTmE0Y  gIkSnHpBfGCV+gxYh98qKSk5CeTeAxVeQPwUiN8AMSjxgdLNX4AAYkRqCLBAXcMHtVwSaLkMMMHJ  AvOq9IQJE9R8fHxElJWV1bEF8aNHj+7t27fvLTDlXwXGLyhoH0OD+DnU0k/QYAa1QP8BBBAjWsuS  FWo5LzRYxKFYAljqiAHzqxCwIBEwMTERBdZeoOYMA7Bl+RFYEbwB5oS3IA9D4/IFEL+E4nfQ6IDF  LTgvAwQQI5ZmLRtSsINSuyA0uwlBUyQPMPWD20/AKo8ByP4DTJTfgRgUjB+gFoEc8R6amGDB+wu5  mQsQQIxYmrdMUJ+zQTM6NzQEeKGO4UJqOzFADQMZ/A1qCSzBfQXi71ALfyM17sEAIIAY8fQiWKAY  FgIwzIbWTv4HjbdfUAf8RPLhH1icojfoAQKIEU8bG9kRyF0aRiz6YP0k5C4LsmUY9TtAADEyEA+I  VfufGEUAAQYABejinPr4dLEAAAAASUVORK5CYII=',
			rotateIndicatorBG:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJ4AAACeCAYAAADDhbN7AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJ  bWFnZVJlYWR5ccllPAAAJJNJREFUeNrsXQl0U+W27pSmc9IpnUegFbBSB0BlejJ5ZVKvvuuTyQWo  KNeJ69K7noh4US+iiFxxvgLigIhV4NnLKIgMIgqU0dKJ0tI2nZtmaNJ0et8u53T9hKRN2qRt4r/X  OivpSZOcnPOdb+/v//fev3tbW5sbN269bV7iE71ez8+GDZaWlhZbUFBQ1tDQ0MrPRtfm6+t71d8e  /JTYbkVFRT5Tp05Nx1MpPxvdMw68bphOp4tJTk4Ow1MffjY48HrNmpub4xISEmQi482ZM4efRyvs  /vvvb9848Lppnp6e0ZGRkUEEPICO4mQ5Pyuc8RyvyLy8okJDQ4nxJNj8hY0bB55jTSKRRAQFBYnA  CxA2bhx4jjVvb2+Fj4+Px5133hlkNBqDOONx4DnccnNzA+Fq/bC1jB07VmYwGII543HgOdz0en2c  u7t7m4eHR9uQIUPkYDwOPA68XhEW0VC17bMVsbGxstbWVgKeJ9StLz87HHiOtFhys/REJpOFNTc3  i4DjcR4HnmMVLdxsO+NJpVJFS0uLON/N3S0HnkOBFykyHtQtTZtJOONx4DncALZwMF2z+GdcXJwf  3K0nZzwOPIdZTk5OKISFtygumpqaJMnJyX6NjY0SzngceA4zg8EQS0Mp4t9gOklMTAwBz5uAB2Xr  zs8SB57dDaCLFdmOjIRFVFSUPzGfcC79+FniwHOEsIgShQXYzqutrc0jNDQ0gJ5zgcGB5zAD20Vh  6wAePQYHB/uTy+XA48BzpKJVgPVaRGHRjjR/f5q3FYEXyM8SB57dzxUAFi4CTxw49vDwcCdlCyB6  csbjwLO7ZWdnKwAyT1FcMO7VLTExUVS2fCyPA8++BkaLYxUtIygoWUAcy/Pl9RccePYWFtGiohVc  bQfjhYeHBwgxnzt3txx49j1RHh4xjJuloRR3Bnhc2XLgOcbAdhHiUIqoaEWTy+Us8Liy5cCzn1FW  iqho2fiOzPeK+XDG48CzO+GB7UK8vb2bTRUtmbu7u9uAAQN8ebIAB55dLTs7m9LdKc5rMwc8sqSk  JFHZ8iEVDjz7GGK6WJOhlGuAFx0d7Wc0Gmksz0foLsCNA69nBtB1KFpSs62trZ6m/6NQKPwZ0cHd  LQdezw0xXDSEhRjfXTWUIlpoaCgLPO5uOfDso2jFAh/ToRTRZDJZIE+P4sCzq1FWilhnYQl4Pj4+  Erlc7iewIWc8DrwemxTxnVycLmPKGa+xgQMH8voLDjz7WH5+fozYssKSohUtISHB12AwkLLlsxcc  eD0zMFicSXKARcajIRXBFUvmzJnjzc+ekwLvyy+/vHHkyJExfXwYMSLwWltbPToDnkKh8OtrZVtX  Vxfk5+en4MDrgWVkZOg+/PDD51asWDEOJ7NPBmXhYqPZAp/O/pcKfwA8775StpcvX560efPm6XQP  cOD1wLZu3Zqbk5Pz0/z58x/7+uuvnx41alRYbx8DQNfRssKSohUtMDAwgIkBe43xLl26FAHQLdNq  tXc8++yz2dhVyIHXQwPodlVXV+cCdLd88cUXy996663RYL9ei5+oSY+lrBRT8/b29oyMjPSHS+61  hFClUjnRx8fnTRxj0osvvrgNuyoaGhp09BriTCkHXjcNJ1H/ySeffInHZl9f39jZs2c/uXPnzofH  jh0b2gtf7w9FG2ApK8WcJScn+wjK1tGMF1ZcXLzUaDT+1d/fvw2MtwXnRYv9ZQLoEul/OPB6YB99  9FH+kSNH9gIERlx82XXXXTcR+15dtmzZbY783ry8vDjTzgFdvSchIYGSBRyapQLXOrm0tHQNmH9I  bGxsNeLQU+PGjbtIL913331+AN3tJLI///zzUg68nrFe67x587ZUVVVdAhAaEWv5BwcHxy1cuPCZ  zMzMvzqK/QCgWHGOVojxunTxUVFRlJdHLs7uXUIpliOWA/MvCAoKagkLC1PjfGgQjhzEyyqAjkTF  HW5X1t3I4jGefcBngMD4HE91YL5WcnttbW2y4cOHT9iwYcPLr7322ggHKN+OdCgaSqGWFV29geov  HJGlQrEcRM5qYjkCHISMgfYfO3Zsz6FDh5ruvvvuAfhzGAEe2zmwnZ4Dz04GYXEOth8s1B4807wo  sR8uRtKCBQsWf/fdd48MHTpUZsehlCiR8bpStKKFhIT4M8zYY3dbXl4eVlJS8iJ+60KZTNYssFz7  zQBmPTNz5kz/MWPGJAOUYjxXAdAVc1VrX9ZrWbx48ZaampoKBPwGJvaSYAtOT0+ftGXLlldffvnl  dICxx7+NVvCxFXhwgcRyUnswHo3L4WE1VOtQMGm9yHJkEDBNc+fO1aSkpJD4EVunNWE77QzX0umm  zM6ePasGs32Jp3q2Vx2xH9yvPxgnCbHf3/E/89LS0oJ68l3U/dO0ZUVXBjbyiI6O9sf/e/SA8eRF  RUUvgXEXkmIllhOPg0yj0QSuW7euAu43AK+p2NPT312s0wKPDPHc0aysrF8BDK3pa8R+tAQA2G8q  2O+VJUuW3AT2607DRDnA7GvapMcaEwp/vLvDeMRyUKzvQkAMgVCpZVmOxhEhsCIQbmgR79aCBavZ  MBCgu+ws19ApgQeX27Z8+fLP9Hp9BRimyfR1kf3kcnnyE0888dymTZseBvhsYp/ff/89nlW01ozh  iRYfHy8VxvKs7hJKbW5JseJmepgUq0KhqBczYkSWq6ioiNZqtW6rV6++ACbU4jc1OpuLdWrgkR05  cqR6x44d3yIO07Eu14T9vMF+8pEjR045efLk0hdeeOF6XCxPaz4f4I21NivFzJCKv1D4Y1WXUFKs  EA5vk2JFqKAxx3L19fWhpKq3b9+eBcFhxP/VMx9xGmzXyIHXS/a3v/3tSGFh4QmwhK4TAFFGiR9Y  ZCjY738R+83GBe5yfM00OcCaoRRmSMVXAF5XAkNOilWcfTAXyxHLwW23Hy8YsRDhgyomJqaMYcOy  /jxQ7JLAg8ttfPvttzfpdLp6gKSps/8F89G4Xwhiv7sPHTr0+tKlS4ea+z/ET7H5+flPA5x3iUza  1RztNYN/sbGRy5Ytm3LrrbeOBqjMpnUJsw/vkGKl2YfOWE6IMRtWrVqVjfChlgEnsdwZZ7x27vhh  7U8QLzkl+Eg4rF27dgZsFpjBqjE8gLQRQNQcPXp0J2KwrcKkuhSB/UNgzwkU2wEIevECE/MQCGw5  LoozEedJACIVPvf7FStWbPvxxx9rKZaDcFgklUrJ7RtYwInfpVarg00Z9ttvvz28devW6ri4uDJm  929guzJnuE74zR3LwmdkZDg/8ATwSQ4ePLgEQf0wMIxVnddp9gPCRF9bW5t94MCB76ZNm/Y/AGQi  xVhgoavYU6VSBSOo79bANMBrCAgIqENcpgHDnUhMTJxIcWZwcLDWtN9eXV1dqOhWWSsqKsp/7rnn  csnF4tiMwu5SgO64s1wjU+C5ROo7GKtp3bp1nwF0NKrfbCUjeZDyBQBuuPfee/8XDBQfHR1dy4KO  hlBqamrC4Mq7PR6Iz/DB+4OhUkPT0tIm4fta2NkHc7Eca9ine/PNNwsgPlQM6JzWxXZ4HTcXsY0b  NxZOmjRpx5gxY+6DmLCanUj5gv28iJWYeNADrlUuAg6MV11WVqaGEFADCBSf1QMs0qSkJB+aIYGK  DaDmjGAkBVz1Nd+BG8KHNgiCFogINUDfSPFjZyzHuNgs/I8ebK4yUbFGDrx+MrYHEPzfkSNHhgMA  A6x1uSL7UQyHmMwPzFJHYIBrrM3KyirYs2dPJWI0I9ywEaBqIvCI43sAIrlITxrjA4A98Zps1KhR  ESNHjlSkpKREgkVNBY4nABuMsMYfrkdH7rsztXzx4sX8zMzM2oiICHag+DJAp3T26+VSzWUoaRSx  0GfPPPPM38EoPrYMgQhuzReKVrt58+ZjP/zwg5bAASbUIaA3sK6xE6s8e/ZsMcAfiFhRMWvWrNRh  w4bFmL4XQPUGAL27OBbdG2+8kQ/xoWZcLAmRc65wrVyuqxHioTPbt2/ff/vtt/8JF8/q2IyGK/7z  n/+c+uyzzxpwsVUJCQk17AAyqzWw1QsbKTM1kZnblXlZL5ohoQ0MWP3BBx+U4XNioJxvjI2NlVsJ  3nb7+uuvj4MR9XifxpVcrMsCj+yFF17I2LZt22AAKAXs0mXdgVqtrlu5cuWvUI96qM4quEjTMUFy  dTRsUd7JJDwbg1HquRdERDhUc/yKFSvKH3nkkXHp6enR1oAPLjYXx988YMCASmZWhlxsuatcI5cE  3vnz5+txsb+mHD1cOElnLhei4dLy5cvPIb7TQ9XWmACDwHQeF7za1mPAeygOpFhMCRCeef/99y9O  njx51j333JMEYLdYeh/iPy1cbC5UcB3DuORiz7rSNXLZBoKvvPLKKQT5h9LS0ibA5QZaAF0x4sF8  CIp6KFN27pOGK87aaypKYMkDo0ePzkbM+ATU9+1iAZEFF9uEuJJ1sVn4jCYOPCcZ24PC/Gb9+vXD  5HK5N2I4qal7fe21184S6OASWdBRzPaLI/LaDh8+XBEZGbkyPDz89ZtvvjnV1O0Ww6Ci1VCxNczu  IhxLpatdH5funQJ1WYsgv0YikWjZDBaAUL9mzRpilgaTREpyjYccmUxZXl6uff3115crlcqLQv1t  h+FYonGT+DIqVu8qKvYPBbzCwsI7QkNDB4LVaFikg9V27dp1Kjc3V2fCLBS4/ybEZg61X3/9tfKr  r75ajZuCdac09ec1e/bs66urq8UB8JO9cTwceHYOI8B0/00T8eTSgoKCKIPFqFKplBs3btQAkKyQ  UAsXua23Du7f//53XkFBwU6aL2b3Dx8+PBrHFmM0Giu6I2o48PrYLl68OAbAC/b3929PkCRXSyvz  ZGRk5Pj6+mqY7F16/LW3g3eqFX7vvfcy4fZVbOESjrkNyncAYtBkV2515pLAKy0tDfHw8LgHAGsU  EyYRzwUgvtLt3btXq1AoWBdLNai6vjjO3bt3V4L1jiKmU1O2jLh/yJAh4QMHDkwEONNc1h0564HD  ZcoQw0WBLZJpyXZcuHCqCpNKpbF42ROgaxHjOsqN02g08lOnTp3G/zQyQxm1AF1JHyrv1tWrVx8E  0MbTsdI8Lu0PDAz0WbRo0V2IAadeuHAhD8dfCddbjpunDAxZ2dzcXDFjxow8vN/IgecAoyaDBC6A  aQCYK4LARR3YAaooKELvqKioFurGTgOt4obXNWz6OJlOp6NyQ6+dO3dWwPU2MC9l9/VvfPHFF3Mm  Tpyovv766+k4gyiRgJaoAvjajxO/NQDPWwA4BQB3I5VNUmICQgkPsKUGz2sNBoMS71VSXOgsoOwP  wPM/e/Ys9RlOxhZJ4ALQCGwELmlkZGQLCywBXDpsams+nFKPwBRBYJPay5cvN8fExIjAU/WH4J1Y  7+DBg+f0ev2NuCk0xMzs6wATpUxpxFiVNRqOwe8LASjDTUGJG1aN99aJoCSmxFa+atWqAnxfI2Xz  /BGA5wtwxeExCcCKwKMCcU0MwENNZvxCQkJMgdVsC7goJYkARgU2xGz0XHj0FhdDQXynIhXLsGG/  afOA47wAgIyUyWRaU+DR76isrIym55TkShvVl+B3NAnPm60FJeUZQtF74Lu0eXl5dQBfGZ6X47xV  NTY2lm3btq1w/fr1+t4ApT2BJwW4EuD64vEDo/BIzEVtvsKpxxxl3rLAokfEWlTXoLUWXLRRJya6  GALYJCy4OjNKPTcpCOo3tQpQsCXEVAQiGvKh32ThHLTfUJRUavpaN0AZDFCGsaBMS0vzeP755zUA  pcoUlJs3b760adOmBnuB0lbgSRDsJuJA4mnhYFxwBWKQePzIUIAryJS5BJA1dlZ+aHJCPEyZSwCX  xNbcOlOrqakxiAsd07XuT3WoUOHVQssLWqhFj9DA5mGU3gDlSy+9pENcWYfjK8X3kOCpQohQkpmZ  WfTxxx/rbAGlOeB5AVxJVJaHL4wAaCJxMoi5QrEFwahIxjSgb8b/VfY1uDozxDmtTD1GfX8KtIuL  i9V0XoRxPLuLAmtBKQKSwOnn52c0LZQXQCkHKEOJoUVQQhh5PvvssyIoS/B6NcipAmFD6a5duy4R  KGlw4b777rsWeEuWLBmFDxgKpRgdERERSu22aNVpBlzkGqu7Ay5yi9S6y9Hg6szw/e7MTIWmPwFv  5cqVTQCfuwC8Xh3ItjMoZQCcH0KHCMSlUWDA1PT09IYJEyYU7tu3jzJ9LlwDvLfffvt3IeD2EPZL  wsPDpTNnzlSkpqb6x8bGSuPi4hSI1QLAgPhuP1KdBCiJGMwTuOjR3LKafW2BgYFeIqu4XZl87ze2  f/9+/5SUlDbhYrf0l+OyBEpcbwMV0dfW1lbhsRZhTN25c+eqjhw5UpmVlaXGe+jmIeZuFDb6u8Gs  qwU6qcqqjn3xjjvu8Dxx4kToL7/8EixUbtViC8EWAOaqADv6RUdHSwcOHCgLDQ31hiqj4Q95QEAA  yNJXSuNR/cVwfCRKxBuiX0284zyFiqtDio99bVQKAObSg7lUVVVVemzGixcv6hCGNdTX17uJTCjE  jRRqSeApFTNmzAjGbzAIN3e9ADjaWgQwtlgUF3PmzKFahVCwHI2kUxIljSWJ+WwGYWun15KSEgkO  SIIDFeO19ruEXCpoNgSs2c6c8fHxcsSH3jQqL5fLg3HAvXoiw8LCAhjg9SvDjRptSz2GvYwKihCH  EbjU2HRKpdIIl284e/YsCQV3BljtFXbkZnENmxQKRVdxqFTYqG+MTghtCEc0VFRBoDR79aH4aPyM  tkIGjOSmggQQEvXKgOx2ZsN2TR0rDXHgLimDYpNQF3QCJIFTjPlwd/iCLX0HDRoUCPctRUzpg31y  KC0pNl97syU+O5jpcefVz4A3gF0B3J6fDdWpBkMZ4A61uBa6ioqKRpCF8fjx4zoiBxq+oU0EFzYj  gNVkpu7EIjkK4KoXWE4vYEfHJl4gNHMzKy66MnwInRiVm0lRCwPMDkDSI5UX4sfIsPkSmMzJdtxh  kqKiIi8RmCIo6ZF6GcNtewMwPmDeIDCllNaDBUhluEjutgITwJbT+4XxMt/+BDxc7MG40EZxvNLW  90NJ0jyvATGXDqDSlJeXt4ML8RYLrnbGIoARqBITE42W0u/NkSPjOnWCxyMW03Y3X9Bud76Qtas3  jRMZYMoFYNImB1tKfa4YAdXdzKCqZ3V1teTkyZPElBKWLYkdaT2JpKSkADyXwo364S4NxF0lhSsI  MNcvD2ClmDXyhx9+qAAA+816sufPnw+mBpK4OVVCbGW2ASSApSK3SF0FqJMBbloCVyPerxdSvtiY  q0kEl+m8dSdmEGIxjQCuBuFRLZCOXa3XXA4OXmXpNWHpI1+BLem5H06gDJvUXC87Ykvc1V5gyw43  LjBme0U/seVTTz01ARf0qgHSESNGxGzfvj0f+2X9iO3GARytYvqW2DEervACGIvml40I6PVCk6EW  AVwUzLe7RoCryUL9rzlrYAClEZ7rO7s2jrJ+EesIswiNnbjxIIEpqS1FELElzA9bkJuZnEIwgycu  2PVwzyFs0A6XHY6YUgE2raIky35QHO2F+PhPlDfIBPw+COzr//Wvf+VjvwqbkZjLBvGhFdjrqrgL  v7VfDZo7RT4eI3bMgdJbAGSgAE5/MEDgmTNnfhs4cOA09qKSS0KAm/rGG2+UR0VFRbr1caIAmOwO  xKzB1LlAjO+oGg7hBQ20GkNDQy0lSWiYQF7FMJfGzUnM6csbBdYymrIlXPRvf/7zn+MR/wVB0UWI  MyaDBw9WpKenX0c95/oYeP5Qs7Ow6ZmxVH+EDM0ZGRkVACMLojy3K90MGvB7tW4uYC5bc0FLUJ04  cWIPXJcnXLKBYT1iyVQwSxrYT95Xx1daWjofMZqPOFFPwyiUN5iXl1dQWVnZKCaCCi4zm2prXQV0  Lg08svnz5+9FrKemBEt2P82yPPbYY7dDNd/eF8dVWFg4EcQ2nrqCivsoSxpCqW39+vVFtJQA01y7  qDer3zjw7MN6jXq9/iIuKI3CXyUkoHxDFy1adC+UbkpvHlN2dvaNPj4+8yMiIurEoQ6hEWSIwWBo  Adt5AZBibNfi1o8SVjnwrDSw3dCYmJgRpAyDgoKuigFJaNx6662Jjz/++N8p+aE3jkelUt0AF/o8  4romtuVtXV1dCMWgYDofMPFQgFBcDKbY2dav4MBzc6MkhcchMmgaqBmPDZSUyv4DDVGMHz8+fsOG  Da9MnDgxvptLT1lliN2mIIZ7AcBrZju9U9klWLlj1SEq6B42bNhAsJ+nICrcOPCci+1o6YAwMF1H  Og6VNpr+H4Fv0KBByW+99dYbS5cuHW3tyj82xHMyKOjncRwPhYSE6GUyWcfxAHC+pssY0PE88MAD  N+E12t/EgedEBhYZAra7Uy6X68QgHQxCA7Nm25XRxYbgCJ41a9bft2/fvvTpp59OtcNhSHJycqbj  s9+DW72ZljGgBEoWdLW1teHmkgLwv97z5s27TalUjnJV4Llcm7Jz5875g1WeRrxkECfBKXhHfBXa  VeYHQCpJT08fRq7u559/vgDWPAgAHKcKF2u//+jRo9TxaTzc6XiaE6ZhEQDuqpoTYRGVEEvHQ0M+  t9xyS1xaWtrUadOm5WZmZipd7Tq5xAIrrBUXF/+V5j8jIyPr2ODdlrUqaD6Ulh9obm6msTUjmKkI  wKUVExuqq6sv09gbQGWg1H4Y1ab44jEezHY9hEwYzZ3SjAkJCHYFRpqZoGMB+1qVpFBTU2NcsmTJ  Nqjcjc7eNYpNi6IFVlyK8RBP3YIfOBYXqmPcjlysrQukUG0IgKbAZ2kA4EaFQhGPzxlAKVUJCQlU  4OIushW5acoaFmp2mwG2q5b7JBMGhwPMLRXVmdF44+zZs0evW7cuF38e4q62f5o/WOdRamrIulgw  TFhnbwILNSKWUkdFRUWYTsRTTEiKE5+po0FdCAStjQD2AugDsAWCHZvwWU2UV2jLZ4wcOTLuxIkT  k+By813J5boM8BCPPULZKrQuBDNuFtzZOrPl5eWla9asOYv3GiZPnjxo+vTpKQjsJaZsReCjjRZX  oZZi4hQcpSaZdBqVCBV2Elozgx4B3tpjx46d/OKLL2qJ7R599NE0GjKxNtuEBpkffPDBG6G4p86Z  M+dTV2nU6BLAq6ioGIELPg4utkZ0c7jgfpZULFVB/fjjj1mffPJJJTFZbGxs3ZkzZyoPHjxYCGa5  buLEiUkA8DXDKlQ9R/GZNTFaaWnp5b17917csWOHjgBKa5FRQsCGDRsq8F0pf/nLX27CPi9rMqnD  w8O9Z86cOUpwuQe5uOgHRh2lAITVAJA3XKFedLG0KJ05tqM6kLVr1567cOFCc3R0dBnNajDs1lxf  X08tJFIWL178X6mpqfLuFOHQ58ydO3cXREYDwKVmv0OIO93BiBELFy4cfcMNN0RYWmGcNaoLfv/9  938BaD/cvXt3mbNdJ1Nx4fTjeIifHgXLBYqgE1WsKeiI5fbt23fsqaeeOg7XWpeYmFhsAghazGT/  999/vzcsLGw7PqMQ4JB055gAXjXA2wZhUm3yHSR6ziBmzAQg161atWrDhx9+eB7/3yW4qVMoWC8d  7HknLd7CXW0fGmK00bggw9ksD3Kx7BSUMCyhfOedd87k5ORQaV41jfGxmHS70hX0kriDmjUeOHBg  H+7SVBrbs7VAHaDVmBRmU2PvAjNt0fZPmTIlJy8vb8b8+fPHDh48OKwzhsUNIQXoRn388cc0lXbY  ma+d0zIedQQFqzxM42WiiqVxMhooZl3e4cOHTyCgPweWUyUlJRWbgI6A8CMLOsYdFoOZGqB2SyAm  bIpDqqurdQBQEwPsXy314kMMWAqgrl+5cuX6zZs3Z2k0lpOIKR6EMIkHQKdAcIRz4PWBqdXqJ6h0  0tTFiuxELPePf/xjH+KikpiYmMsmSwsQGGhBuiOW+h8XFxdfpqY0FH+xzbGtMQiLBnFpUbcrJYCd  xnAQIY0QO3sRCnzw8ssv70D8WW9pVoNc7rx589LwW6GDpkk48Hp36GQCAvd0WumaifXa1abIck8+  +SQtiqcC6MqtZTnWwJJaKoamwWKq6rLx+NqVrAg8a9+3Z8+eQrD4R6+++uqn33zzze+WZuoQLnjD  5Y5BDDqCx3i9Z1Q5NpfmQMV4SHSxYMHKNWvWnDl37pwRDFfL1jMILEcp5AXWfhGARz2Fo2zt4JSb  m6un0kPxnrDlvd9++y3dJDsmTZqUf+rUqekLFiy4NTk5WWaqfG+77ba4kydPjr/rrrsu7ty5U8kZ  z8GmVCqfoAlSNqcNblV26NChLLBUVkFBgWrAgAGXTEAnslyBLd9FzazBKl62MB7e04gYj20B0a06  CbjfXLD3+wgXNm7durUA7HfVtcIpaJ01a9ZwPCWV68kZz7EqdjLYbRhcTS2zT4OLk0sV9bR+hRnF  mm0r4BjGU9KYoDAX29zZLEjHeIlGQ2tWtDHztd1eQ0PozpAJVis4ffr0dCjf2+Lj4/1F9gsPD/d5  6KGHxLncnznjOcAQ7FM/vjnUoFpwsc3Z2dkHH3jggYt5eXn1ZmI5SnU/0F3QCXGjkhID2u/Qq/sn  WzTqX8Io2m4zHmtwpdklJSUfQXh8DibMQyzrIajcthEjRiSkpKRMmTp1agQHngOOE/Y43IsXuViA  ofill176lAZSQ0JCaqOioqqYNg7t43LYDva0HLC+vv6y2JvYWuBVVVVpGdfcZK9uBbt3764H6L7b  vHnzRytXrvyJ+qaILhdx4A04J/3a5YozZE4FPKjEqQjwU2ltWTzfGx0dvTUzM1M6aNAgjUks18Fy  9igJ3L9/PzFemy3AAzPrGODZvbIfyvcMGG/NsmXLvgIYS6huGCGGdO7cuWMRdozkjGc/iwDbPQjg  Ff7zn//8NDU1NQexTd3QoUPlDMuR6822B8ux9u677zbhwtYQ61krMCButIywcMgaafQbAbbNW7Zs  efe9997bX1ZWZqCKucGDB0+69957wznw7HB8YJCnLly4cHDYsGEZcDHlOLnnb7rppmS85mnCcrmO  KHwGu7QrW2uGVOBOWhFvGsRed/aI7zoBXxsYLwui6iOEHVsOHz5cMHPmzJuhfu8Smmhy4HXXjh8/  PhIB9dHp06cfqKmpycdJvTRkyJAkvBRmwnIOa1YjCgxivK6ySGjFHGxtTE86h7ecAPhq4AG+2rRp  0yeffvrp6XHjxg0vLS29jQ+n9MDGjh1b5Xal4XchLQqHO5km/we7XekcdULoIuVQA5DKRGVLatXS  qjtkdXV1pLhZgPZK9yahceJvuEEv5efnT8W5GoFz9Tv213HG64bhBBLL5Qigo7nLG92uFDn/1Bug  ExivTFymoKs4D6ysY7JS2hwV41my77//vgoK/zOIrl34M70/u1xnGkCmcarTvQU40S5dunQ5PT29  Y9UdMKCfpf9VKpU6JhbUO6KFq5Xslw3QUSoWrd3bL3uvOM0AMk5oeW+Djmzx4sV1RqPRQMkCzJJU  Zk3ISunRVJkdzxe52ZL+ej1dummPndx9K1iuiuK8rpQt4qtuJwc4kP048JzVaKXCpqamToHX1tbW  ArdMRdzG3hQWzmoceFaYXq8vJ8ajZAHqvm7uf7RaraalpaWVSV3X8TPHgdcjo6UwxTlbS8t61tbW  akxULwceB17PTKVSXWbG8swKjMrKSg2TlUKs18DPHAdej+zo0aO0dHt7DYSlZIGSkhI9U2ehc8W+  xRx4vWxr166FsDXUk7u1JDCKi4vZoRQuLDjwem4NDQ1tjY2NnSrbvLy8ht5IDuDA+4MZGK8deOaS  BWjFasR4LT2ts+DA43aNgfHKqJpNqKe4atG6+vr69s4B9qiz4MDjZsp4ZZbqL4Q6C1btcsbjwLOP  UTtaS8CrqKhgkwOa+sGqkBx4rmKzZ89Wwt22mAMeJQcw+7ii5cCzq7KlZIFqc/UXhYWFekfXWXDg  /YFN7CzADqlQnQWtoM2HUjjwHKlsy5n6i1ZBdGjBhi1MnQVnPA48+xrbWUBUsUKdRQsztscZjwPP  vgZ2K21qavJiBQbVWTDCoo0DjwPP7qZUKouZ9Kh2sJWVlbGKluosWviZ4sCzqy1atKgOcV4j62op  K4VJd+dsx4Fnf6NkAWpdBnXboWzz8vJYRcuFBQeeY4y6hIpZKkKdRTOvs+DAc7iB7ZRi/QVAqGqh  zAFeZ8GB52ijzgKistVqtTUm02cceBx4jjEq/BHH8urq6gh4opvldRYceI6z8+fPX4a79RAUbQVb  wM3rLDjwHGZLlizpqL/Iz8+vYdaz4G6WA8+xJtZf/PTTTzU8OYADr9cMaraM1rPIysoy0Fpqwm41  PzMceI4GXmlNTY0a7pYaf+u5q+XA6xVraGgoqaqqosFiA+Niuau1wbz4KbDdqKWFTqfTCmxHN28w  r7PgjOdwW7BgQcX58+drBOARAPlUGWe8XnG1rfHx8ZfwtFkAHo/vbDR306V+yO6//35+Zqw3X2xx  2HL5qbDOMjIyuKu1h8h140MpPMbrI6vip8A2+38BBgCoeF1k5svoMAAAAABJRU5ErkJggg==',
			rotateIndicatorPointer:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACIAAADECAYAAAD6WvNdAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJ  bWFnZVJlYWR5ccllPAAAC7NJREFUeNrMXctvG8cZ3x0+RfFNSpUVWbXjBoVb14gPRoHCgPO4tI2A  BOkl9/wLORXIoccU+QfaIj0WuRQoECNogR4cGC0SuDkYdZHURpBUUvSkZPEhiuTuzvRbapecHe7s  zs7OUhlgrSVFLn/8fd/ve8xHWjohRPsurLT9D37ppchPHL31VjX74YcnMi+K7t/3ByKzRq+/Xk/f  uVNL37jxtQpGkOwTSS5XJ9euvajKNNJAtFSqDMeP7NN79+5lozwVHj854gPRtLqO0HXnvAEXzV0M  I5rWhOOqc151jgsBUoFj3TkvwlGOLd+oa/j22/a7X4Bj2bmrrCSORF3Gq69WnNOscXDw47hmkQYC  0p0yUC7ftAFdjHx1ve6eYk2zY0kurnmQZAyZALEwvuacZkDCi/NWTYU6v0qdl+cNpE6dP0edV+cG  BLKuJ2bolL848WQ+QEC6nheDeibTrFQuzd00uF6vMkC0Sr2+NnfTgC2aLJDC4uJz83dWO/1TIMbh  NZdbjithFEcxEyDZbDOuhGWANFgg6XS6GlfCKKJ00/Q7doGkUqlSStfTc2PEuHvXfrcpFoh9nWa9  vjo3RvDSUs1zG+OpY9Tr6/PzEYQqrHTdtbCw8D03D4Fy9GSBpFITRizL8tQguVxuhbpmMWnVNCkg  efoXmUymHkc5UYFUKP/IeslK1eLEEiQbzICRHAOkkE+l8okz0n/vvTpdmwIjeTYLNZvN9cQZwZcv  lxjpzhTMi9NyIDlGSD7PxpCZFjOXz7sSLoKEUTI+QhXMACJDR1hKwkuumZi6VqmzVngxhCPhclJA  6kFm8ZFwKSkg3GDGkbB60ziV+0KQYuJKWAzIa6+VwxQTV8JCQEih0GCA5HmPhSy8KiNhsQfqeoVK  /QgO7i5CVlLCSDCG1Hg5xkfCUoW0KHWNMMVQyinLlAMoajALUIxTxKGFUipVUc4ISDfLAAndxqxe  urSqnBFouuv048JMMw6ppdKackZwrRaa/n2ysFu/LoKEM2p8BCE6kekg3VAg0IIuR1UOEpDuRDGm  aeac+KCFSLgWVTlIpWIoCVfUMxJQMPMDsZ6tZrMNZYw4TXddJMewq7ayclkZI+atW2W6JBQ1zTj5  LS4uKWMEr69XRdN/gIRzIrOcQCD2uEw0/YdIuBrPWakE5lTuwl0+I+FiXNVEVoyshMOAhBbMqiSM  VAczWQlzgVDjssiKcVehWFyNzYjxyiuerBvVNFEljAKabnbPPbJpmI3gqpyPUOMPAJEKqtwDJCzc  CyORyh3Sf2SzOPVrKT4j1BNlFONIOC06y0FJBDOP/gVnOYiT/gv0O4iSY2YkLDjLQZzKvRy1YA5o  QYVmOb5A2HGZTDDjSLgczUe80kUyMcRdorMcxJFuNWy/LEIWFprlINn9sijhRGSWgwSkm48JRCsK  xBLEqdwrKhQzkXCh4ALhznJmgLDjMgWmoSXMneXMAMFLS9W46T9EwiUxH0EodvoPkXBFDMjsuEyP  C0REwihpxYhK2A9ITaViJrE9ZBwbxkhOFRB6HOtnbg+Qs3fftdnIqkj/M4V0yDjWA8S6fl1Z+g+p  X6uBQETGZTGUEziORTzp8sZlMYAEjmMRr2COm/79qpygWQ5KMP3PrKBZDppDMKMlvErtlyBfIM64  bDEJxVBZmDvLmbSRIuMySIBWp9P5utduH7bb7WOs6x9dXlu7Xi6Xr9YbjbspqsTkSJgtpJ/NACGF  Qi1ov2wwGBzubm4+Ph2Nek6BPf6xtb39Bfywj49/cuPGG41m8+e8ROkzy/nfrI/oeo2p3NMUiNY3  T5/+awKCs/79+PFfdnZ2/mRfgtMLc2c5iJP+cxQzo52nTx+Zum4y17VvP4LjIzj+sLGx8Xv4+ecn  T578pt/v/5Pbgi4vr/gpJx2mmPbJyVd9Xe8z19uG4wG8eJe+E24fwY8j8+HDX1k3b24ZhjEzIlks  lVa03d3/8hnhdP8nrdYec60dOP76y/ff73Irstu398EfHkKJGCRhW6EZDxDeuAz8xGT8YgjH3wEE  DpMqwfgL8Am7TORJ2FO/Ime/rKb5jMsAkMFc/xGAGAiGja5TrwZJ2Ask/dlnQ7/0D+8oB/KhzfeV  cGJBaIWSLR2LDD93GMPNffDBCRxntgmJruuDK1dc46LGrVvNw+efP7CJC/KLGT958OCnxIk18M40  3bLOA6dptv3KAfrdtsZmyWY947LG1pa74zMSBUHu338DQFz13QTStEM/Rmggx+M7TNPjF6Wjo9X6  9rbtQwsfv/NOaGtBPvlkAR70WyY1TM7756qjY9EMkKPxHeCpOsYmdRX9yuef367s7dno10J9A+O/  wcu+4PE5CkgP433qVz2/gHY8cS7THJjZbJG6nfvBp5/+rLO0dAo3f6eNv6kww8QdnZA/gkleYNmg  GQH7b1G/7vgBaU1oMs2hRgFxmMpU9/Z+MSgWl/O9nh3at8AX3tTPvzthf6Pk+34JxnCc1GHmrE/I  KfXrk2BGDIMXK/Reo/EiMFTIDAY2gF8HfcvPBkGzgSlTsKZBXoc+pyplM8JzRoTS7ZWVH/ar1SXu  Y+DFQaaeD96OgRHyjHmor2lcVsrp0SgweoIfpE5rtfWMYdiBS0s58cJ2Ssz4BL2GGB9QN20TGbya  dawcADIUihfnUXhsAvuw4DzoK5kjQo78zOIHZN+RIAbnFA5goqtHyLd+ZvEDcuxRjuLVIuQbP8Vw  TePGEpUg7JICKGiLmsZ+oOX4yZlKIJZTFoiaBrvmgVii1DQg3WPmrpOwjZpjhxGlpjEJoV/YcKq9  QCAth5ERry2QWUwM6YhsXR0n4bCnhGzzzMIDcpSEhLuE7PMUE84IP/lFXbZddqKapuOWhaqUYxHS  xU5YiGKaqXIUMQKK6fLSfxiQlkpGmBiCowBxg5oB5Z8VW7qE7DHRm4gCOVCpnIE3hvhubQSaRlUs  gVfeDVJMqGnCykbRxAsBZDNIMUFApvVrzCwM0j2DymzENueiQJQlP5/0HxlIpPqVG0Msq8WUuW0p  RuLWryMqd9m5b2NjA0cF0lIhYYghB2FmEWIkroTbhGyFKUYECI4r4WeE7MRlxHIdKyWpHHgXo643  gEkBmSpHMvlB+9kOKpijADl2GBnK1K/GLBBpRsbKsT8MLyNhw9vrDkG6I1kgh3HKRsi6eyJmEfYR  2VjS17Q9EbOIAJnUrzJl4wnG36oCQldrkYDYTXfL2eZQYZqJw0bNwtZsJaaMkUj1qzmbZWMDkXJY  A2M6/Rsg3VMljERNfkMvkNBhgrCPRE1+Z95eVwmQM+eIlPwg/W+KKkYUiEznR5imu6sKSKRCGir3  PtN0KwPiP0LhN93PRNO/FCOiymH2ywivzZQBchgllkD6p6XbgxhCVDorFs05zLhM6H8aFAUyrV8F  GOl565CuSiB05zcQoG87SSDnEh4OB0H1a9C4TBUQofrVZ78sGUbCHNaaZSAZHwmTMDsuA+kaqoFM  RygBjIg23XGACI1QTr07iIkAEUp+QeMylUACRyhAmcGMy5JlhJf8IIb0ZBQjAyRQOWHjMuWm4cUS  JuuOQLrDpID0JvWrj3JGGB/LmEUGyLTz82EkbFymGgg3ljzzbtx1kgZy5LagrGiOKR8SKQ+VMDLO  xLpOV+6h47JEfIQFYsy+cGdujCAKiIlxm8lL/aSBTEYoNCPsuEykco8LZMIKDaTvLZg7US8oC2Ss  HN3bQuzLKiY2IxQYoXFZEkCm8QLMYzfdzLisM3dGbOVYAR90mwcQ7Dqs6LgsCSAW7bDMZ1R7vHFZ  EkA8Eh4y3b/MxeIAablAou6XJcLIOP1r2uM4iokL5Mjphftd79yudzGM6PouY465m6ajnyfAbcYc  czeNvQ4cIC4LQ9GmWzWQTXL+JZ9OHLOoAGL/FY7/OJMHQ9YssYGM2SDkS8o3ehfDCCH/0F9++UvK  LNKm0dnPKNN/piPiuq2d1yT7UZ4EZlXiI2zD3bsoZ2Uj7aky01zUQtp3ZP1fgAEAu7XPVBB4Ev8A  AAAASUVORK5CYII=',
		};

			//各网站规则;
		var siteInfo=[
			{siteName:"google图片搜索",
				siteExample:"http://www.google.com.hk/search?q=opera&tbm=isch",					//网址例子..(方便测试.查看.之类的)
				enabled:true,		//是否启用..(是否启用这条规则)
				clickToOpen:{		//(功能未完成)接管鼠标左键点击..(是否点击 鼠标 左键直接用本JS打开图片)
					enabled:true,//启用
					type:'original',//默认的打开方式: 'original'(弹出,原始图片) 'magnifier'(放大镜) 'current'(弹出,当前图片)
				},
				url:/https?:\/\/www.google(\.\w{1,3}){1,3}\/search\?.*&tbm=isch/,				//站点正则..
				getImage:function(img,a){																								//获取图片实际地址的处理函数,this 为当前鼠标悬浮图片的引用..另外传入的第一个参数为当前图片的引用,第二个参数为包裹当前图片的第一个a元素.
					return a.href.match(/imgurl=(.*?\.\w{1,5})&/i)[1];
				},
			},
			{sitename:"豆瓣",
				siteExample:"http://movie.douban.com/photos/photo/1000656155/",
				enabled:true,
				url:/^https?:\/\/[^.]*\.douban\.com/i,
				getImage:function(){
					var oldsrc=this.src;
					var newsrc=oldsrc.replace(/\/view\/photo\/photo\/public\//i,'/view/photo/raw/public/');
					if(newsrc!=oldsrc)return newsrc;
				}
			},
			{sitename:"deviantart",
				enabled:true,
				url:/^http:\/\/www\.deviantart\.com/i,
				siteExample:"http://www.deviantart.com",
				getImage:function(){
					var oldsrc=this.src;
					var newsrc=oldsrc.replace(/(http:\/\/[^\/]*\/fs\d*\/)150\/(.*)/i,'$1$2');
					return newsrc==oldsrc? '' : newsrc;
				},
			},
			{sitename:"opera官方论坛",
				enabled:true,
				url:/^http:\/\/bbs\.operachina\.com/i,
				siteExample:"http://bbs.operachina.com",
				getImage:function(){
					return this.src.match(/(.*)&t=1$/i)[1]+'&mode=view';
				},
			},
			{sitename:"QQ微博",
				enabled:true,
				url:/^http:\/\/t\.qq\.com\//i,
				siteExample:"http://t.qq.com/p/news",
				getImage:function(img,a){
						var pic=/(\.qpic\.cn\/mblogpic\/\w+)\/\d+/i;//图片
						var head=/(\.qlogo\.cn\/mbloghead\/\w+)\/\d+/i;//头像.
						var oldsrc=this.src;
						var newsrc;
						if(pic.test(oldsrc)){
							newsrc=oldsrc.replace(pic,'$1/2000');
							return newsrc==oldsrc? '' : newsrc;;
						}else if(head.test(oldsrc)){
							newsrc=oldsrc.replace(head,'$1/0');
							return newsrc==oldsrc? '' : newsrc;;
						};
				},
			},
			{sitename:"新浪微博",
				enabled:true,
				url:/^http:\/\/weibo\.com/i,
				siteExample:"http://weibo.com/pub/?source=toptray",
				getImage:function(img,a){
						var oldsrc=this.src;
						var pic=/(\.sinaimg\.cn\/)(?:bmiddle|thumbnail)/i;//图片.
						var head=/(\.sinaimg\.cn\/\d+)\/50\//i;//头像.
						if(pic.test(oldsrc)){
							var newsrc=oldsrc.replace(pic,'$1large');
							return newsrc==oldsrc? '' : newsrc;
						}else if(head.test(oldsrc)){
							var newsrc=oldsrc.replace(head,'$1/180/');
							return newsrc==oldsrc? '' : newsrc;
						};
				},
			},
			{sitename:"pixiv",
				enabled:true,
				url:/^http:\/\/www\.pixiv\.net/i,
				getImage:function(img,a){
						var oldsrc=this.src;
						var reg=/(\d+)(_\w)(\.\w{2,5})$/i
						if(reg.test(oldsrc)){
							//alert(oldsrc.replace(reg,'$1$3'));
							return oldsrc.replace(reg,'$1$3');
						};
				},
			},
		];

		//通配型规则,无视站点.
		var tprules=[
			function(img,a){//解决新的dz论坛的原图获取方式.
				var reg=/(.+\/attachments?\/.+)\.thumb\.\w{2,5}$/i;
				var oldsrc=this.src;
				var newsrc=oldsrc.replace(reg,'$1');
				if(oldsrc!=newsrc)return newsrc;
			},
		];

//=====================================
//=====================================
//=====================================



		var nullFn=function(){};
		var C={
			log:nullFn,
			err:nullFn,
		};


		if(prefs.debug){
			if(envir.opera && window.opera.version()<10.5){
				C.log=C.err=function(){
					opera.postError.apply(opera,arguments);
				};
			}else{
				var G_window=topObject.unsafeWindow || window;
				var _console=G_window.console;
				if(_console){
					C.log=function(){
						_console.log.apply(_console,arguments);
					};
					C.err=_console.error? function(){
						_console.error.apply(_console,arguments);;
					} : C.log;
				};
			};
		};


		//获取滚动的距离.
		function getWindowScrollXY(){
			var ret;
			if(support.winScrollXY){
				ret={
					x:window.scrollX,
					y:window.scrollY,
				};
			}else{
				ret={
					x:window.pageXOffset,
					y:window.pageYOffset,
				};
			};
			return ret;
		};

		//事件支持检测.
		function eventSupported( eventName,el ){
			el = el || document.createElement("div");
			eventName = "on" + eventName;
			var isSupported = (eventName in el);
			if (el.setAttribute && !isSupported ) {
				el.setAttribute(eventName, "return;");
				isSupported = typeof el[eventName] === "function";
			};
			el = null;
			return isSupported;
		};

		//属性支持.
		function proSupported(proName,el){
			el = el || document.createElement("div");
			var isSupported = (proName in el);
			el=null;
			return isSupported;
		};

		//css属性支持
		function cssProSupported(proName,el){
			el = el || document.createElement("div");
			el=el.style;
			var isSupported = (proName in el);
			el=null;
			return isSupported;
		};

		//支持情况.
		var support={
			mouseenter:eventSupported('mouseenter'),
			mouseleave:eventSupported('mouseleave'),
			naturalWHS:proSupported('naturalWidth',new Image()),
			wheelEvent:eventSupported('mousewheel')? 'mousewheel' : 'DOMMouseScroll',
			transform:(function(){
				var t=['MozTransform','OTransform','WebkitTransform','transform'];
				for(var i=t.length-1,t_i;i>=0;i--){
					t_i=t[i];
					if(cssProSupported(t_i)){
						return t_i;
					};
				};
			})(),
			canvas:(function(){
				try{
					if(document.createElement("canvas").getContext("2d")){
						return true;
					};
				}catch(e){};
			})(),
			winScrollXY:window.scrollX!==undefined,
		};

		C.log('浏览器的一些对象支持情况:',support);

		var addCustomEvent={
			_contains:function(parent,child){
				if(parent && child)return !!(parent.compareDocumentPosition(child) & 16);
			},
			mouseenter:function(ele,fn){
				var self=this;
				ele.addEventListener('mouseover',function(e){
					//如果来自的元素是外面的.
					var relatedTarget=e.relatedTarget;
					if(relatedTarget!=this && !self._contains(this,relatedTarget)){
						fn.call(this,e);
					};
				},false);
			},
			mouseleave:function(ele,fn){
				var self=this;
				ele.addEventListener('mouseout',function(e){
					//如果去往的元素,不是自己的子元素,或者自己本身.
					var relatedTarget=e.relatedTarget;
					if(relatedTarget!=this && !self._contains(this,relatedTarget)){
						fn.call(this,e);
					};
				},false);
			},
		};

		var classList={
			add:function(name,obj){
				if(obj.classList && obj.classList.add){
					obj.classList.add(name);
				}else{
					var cn=obj.className.split(/\s+/);
					if(cn.indexOf(name)!=-1)return;//已存在.
					cn.push(name);
					obj.className=cn.join(' ');
				};
			},
			remove:function(name,obj){
				if(obj.classList && obj.classList.remove){
					obj.classList.remove(name);
				}else{
					var cn=obj.className.split(/\s+/);
					var index=cn.indexOf(name);
					if(index==-1)return;//不存在.
					cn.splice(index,1);
					obj.className=cn.join(' ');
				};
			},
			toggle:function(name,obj){
				if(obj.classList && obj.classList.toggle){
					obj.classList.toggle(name);
				}else{
					var cn=obj.className.split(/\s+/);
					var index=cn.indexOf(name);
					if(index==-1){
						cn.push(name);
						obj.className=cn.join(' ');
					}else{
						cn.splice(index,1);
						obj.className=cn.join(' ');
					};
				};
			},
			item:function(index,obj){
				if(obj.classList && obj.classList.item){
					return obj.classList.item(index);
				}else{
					var cn=obj.className.split(/\s+/);
					var value=cn[index];
					return value;
				};
			},
			contains:function(name,obj){
				if(obj.classList && obj.classList.contains){
					return obj.classList.contains(name);
				}else{
					var cn=obj.className.split(/\s+/);
					return cn.indexOf(name)!=-1;
				};
			},
		};


		function wheelEventObjectFix(e){
			var delta;
			if(e.wheelDelta){//w3c 
				delta = e.wheelDelta/120; 
			}else if(e.detail){
				delta = -e.detail/3;
			};
			if(delta>0){//向上滚.放大.
				return 'zoomIn';
			}else{//向下滚.缩小
				return 'zoomOut'
			};
		};

		var G_container=document.documentElement;

		//打开的图片对象.
		function PicObj(src,img,naturalSize){
			this.src=src;
			this.naturalSize=naturalSize;
			this.img=img;
			this.init();
		};

		PicObj.all=[];
		PicObj.zIndex=PicObj.iniZIndex=110000;
		PicObj.blurAll=function(e){//当点击页面的任何地方时,blur所有的图片窗口.
			var currentFocused=PicObj.currentFocused;
			if(currentFocused){
				currentFocused.blur();
			};
		};
		PicObj.focusNext=function(){
			var all=PicObj.all;
			var max;
			for(var i=0,ii=all.length,all_i;i<ii;i++){
				all_i=all[i];
				if(!max){
					max=all_i;
					continue;
				}else{
					if(all_i.zIndex > max.zIndex){
						max=all_i;
					}
				};
			};
			if(max){
				max.focus();
			};
		};
		PicObj.escRemoveFocused=function(e){
			if(e.keyCode!==27)return;
			var currentFocused=PicObj.currentFocused;
			if(currentFocused){
				currentFocused.remove();
			};
		},
		PicObj.mode=(function(){
			var mode;
			if(support.transform && support.canvas){
				if(prefs.mode=='auto' || prefs.mode=='css3'){
					mode='css3';
				}else{
					mode='canvas'
				};
			}else{
				if(support.transform){
					mode='css3';
				}else if(support.canvas){
					mode='canvas';
				}else{
					mode=false;
				};
			};
			return mode;
		})();

		PicObj.prototype={
			remove:function(closeAll){
				PicObj.all.splice(PicObj.all.indexOf(this),1);//移除自己.
				if(PicObj.all.length==0){//没有对象的时候.
					document.removeEventListener('keydown',PicObj.escRemoveFocused,false);
					document.removeEventListener('mousedown',PicObj.blurAll,false);
					PicObj.zIndex=PicObj.iniZIndex;
					if(PicObj.overlayer){
						PicObj.overlayer.style.display='none';
					};
				};
				if(!closeAll && this.isFocused){//如果关闭的是最前面的图片,那么聚焦下一张图片.
					PicObj.focusNext();
				};
				this.closed=true;
				if(!this.img.complete)this.img.src='';//如果图片还米有载入完,直接取消.
				this.container.parentNode.removeChild(this.container);
			},
			blur:function(){
				if(!this.isFocused)return;
				this.isFocused=false;
				PicObj.currentFocused=null;
				if(!this.closed){//如果对象没有被关闭.
					this.container.title='点击激活';
					classList.add('pv_pic-container-blur',this.container);
					classList.remove('pv_pic-container-focus',this.container);
					classList.remove('pv_close-pic-focus',this.close_pic);
					classList.remove('pv_pic-tools-container-focus',this.pic_tools_container);
				};
			},
			focus:function(){
				if(this.isFocused){
					return;
				};
				var currentFocused=PicObj.currentFocused;//当前的焦点
				if(currentFocused){//移除focus样式.
					currentFocused.blur();
				};
				PicObj.currentFocused=this;
				this.container.removeAttribute('title');
				classList.remove('pv_pic-container-blur',this.container);
				classList.add('pv_pic-container-focus',this.container);
				classList.add('pv_close-pic-focus',this.close_pic);
				classList.add('pv_pic-tools-container-focus',this.pic_tools_container);
				this.isFocused=true;
				PicObj.zIndex+=1;
				this.zIndex=PicObj.zIndex;
				this.container.style.zIndex=this.zIndex;
			},
			overlayer:function(){
				if(!prefs.overlayer.show)return;
				var overlayer=PicObj.overlayer;
				if(!overlayer){
					overlayer=document.createElement('span');
					PicObj.overlayer=overlayer;
					overlayer.id='pv_overlayer';
					if(prefs.overlayer.dbcCloseAll){
						overlayer.addEventListener('dblclick',function(e){
							e.preventDefault();
							e.stopPropagation();
							var all=PicObj.all;
							for(var i=all.length-1;i>=0;i--){
								all[i].remove(true);
							};
						},false);
					};
					G_container.appendChild(overlayer);
				};
				var oStyle=overlayer.style;
				var fullPS=this.getFullPageSize();
				oStyle.width=fullPS.w+'px';
				oStyle.height=fullPS.h+'px';
				oStyle.display='block';
			},
			fitToScreen:function(){
				var containerSize=this.getContainerSize();
				var windowSize=this.getWindowSize();
				var floor=Math.floor;

				var imgSize=this.getRotatedImgRectSize();
				var h,w;
				var scale=containerSize.h/containerSize.w;
				if(scale >= windowSize.h/windowSize.w){
					h =imgSize.h-(containerSize.h - windowSize.h);
					w= h/scale;
				}else{
					w =imgSize.w-(containerSize.w-windowSize.w);
					h= w * scale;
				};

				var newPicSize=this.getRotatedImgCliSize({w:w,h:h});
				newPicSize.h-=10;//留点边距.
				newPicSize.w-=10;

				var zoom=Number((newPicSize.h/this.naturalSize.h).toFixed(2));
				//alert(zoom);
				if(zoom<1 && zoom != this.zoom){
					this.zoomIO(zoom > this.zoom,zoom);
				};
			},
			keepScreenInside:function(){//保持按钮在屏幕里面.
				var containerSize=this.getContainerSize();
				var windowSize=this.getWindowSize();
				var pInt=parseInt;

				function keepSI(obj,offsetDirection,defaultValue){
					var rect=obj.getBoundingClientRect();
					var objStyle=obj.style;

					while(offsetDirection.length!=0){
						var oD=offsetDirection[0];
						var oDV=defaultValue[0];
						offsetDirection.shift();
						defaultValue.shift();
						var oValue=pInt(objStyle[oD]);
						var newValue;
						switch(oD){
							case 'top':{
								newValue=oValue - rect.top;
								if(rect.top<0){
									newValue=Math.min(newValue,containerSize.h);
								}else{
									newValue=Math.max(newValue,oDV);
								};
							}break;
							case 'right':{//屏幕外
								newValue=oValue + (rect.right - windowSize.w);
								if(rect.right > windowSize.w){
									newValue=Math.min(newValue,containerSize.w);
								}else{
									newValue=Math.max(newValue,oDV);
								};
							}break;
							case 'bottom':{
								newValue=oValue + (rect.bottom - windowSize.h);
								if(rect.bottom > windowSize.h){//屏幕外
									newValue=Math.min(newValue,containerSize.h);
								}else{
									newValue=Math.max(newValue,oDV);
								};
							}break;
							case 'left':{
								newValue=oValue - rect.left;
								if(rect.left<0){
									newValue=Math.min(newValue,containerSize.w);
								}else{
									newValue=Math.max(newValue,oDV);
								}
							}break;
						};
						objStyle[oD]=newValue + 'px';
					};
				};

				keepSI(this.close_pic,['top','right'],[-15,-15]);
				keepSI(this.pic_tools_container,['top','left'],[1,-40]);
				keepSI(this.statusBar,['bottom','left'],[3,3]);
			},
			getWindowSize:getWindowSize,
			getFullPageSize:function(){
				return {
					h:Math.max(document.documentElement.scrollHeight,document.body.scrollHeight),
					w:Math.max(document.documentElement.scrollWidth,document.body.scrollWidth),
				};
			},
			getContainerSize:function(){
				var container=this.container;
				return {
					h:container.offsetHeight,
					w:container.offsetWidth,
				};
			},
			verticalCenter:function(){
				var containerSize=this.getContainerSize();
				var windowSize=this.getWindowSize();
				var floor=Math.floor;
				var cStyle=this.container.style;
				var scrollXY=getWindowScrollXY();
				cStyle.top=floor((windowSize.h - containerSize.h)/2) + scrollXY.y +'px';
				cStyle.left=floor((windowSize.w - containerSize.w)/2) + scrollXY.x +'px';
			},
			borderFlashRun:function(){
				var colorArray=this.borderFlashColorArray;
				var color=colorArray[0];
				var cStyle=this.container.style;
				cStyle.borderColor=color;
				colorArray.shift();
				if(colorArray.length==0){
					cStyle.removeProperty('border-color')
					return;
				};
				var self=this;
				setTimeout(function(){
					self.borderFlashRun();
				},200);
			},
			borderFlash:function(){
				this.borderFlashColorArray=['red','green','blue'];
				this.borderFlashRun();
			},
			resetRotate:function(){
				if(this.mode=='canvas'){//判断还没有开始旋转的情况.
					if(!this.isCanvasMode()){
						//alert('还没开始旋转呢.');
						return;
					};
				}else{
					if(this.rotatedRadian==0)return;
				};
				//.........
				var cStyle=this.container.style;
				var cSize_bef=this.getContainerSize();
				var pInt=parseInt;
				var cOffset={
					top:pInt(cStyle.top),
					left:pInt(cStyle.left),
				};
				this.mRadian=this.rotatedRadian=this.preRadian=0;//旋转重置为0;
				if(this.mode=='canvas'){
					if(this.ableToRestoreToImg()){
						this.restoreToImg();
					}else{
						var rotatedSize=this.getRotatedImgRectSize();//旋转后图片大小
						this.draw(rotatedSize);
					};
				}else{
					var imgStyle=this.img.style;
					imgStyle.top=0;
					imgStyle.left=0;
					var transform=imgStyle[support.transform];
					imgStyle[support.transform]=transform.replace(/rotate\s*\([^)]+\)\s*/i,'');
					cStyle.width='auto';
					cStyle.height='auto';
				};
				var cSize_aft=this.getContainerSize();
				cStyle.top=cOffset.top - (cSize_aft.h - cSize_bef.h)/2 +'px';
				cStyle.left=cOffset.left - (cSize_aft.w - cSize_bef.w)/2 +'px';
			},
			getCurImgSize:function(){
				var img=this.img;
				if(this.isCanvasMode()){
					return this.imgCanvasRalatived.imgClient;
				};
				var ret={};
				if(envir.opera){
					ret.w=img.clientWidth;
					ret.h=img.clientHeight;
				}else{
					ret.w=img.width;
					ret.h=img.height;
				};
				return ret;
			},
			getRotatedImgCliSize:function(rectSize){//通过旋转角度和虚拟矩形长宽,求图片的长宽.
				var a=this.mRadian;
				if(a==0){
					return rectSize;
				};
				//下面的计算公式,通过解 getRotatedImgRectSize 中的二元一次方程式等到..
				var h=(rectSize.h-rectSize.w * Math.tan(a))/(Math.cos(a)-Math.sin(a)*Math.tan(a));
				var w=(rectSize.h - h*Math.cos(a))/Math.sin(a);
				return {
					h:h,
					w:w,
				};
			},
			getRotatedImgRectSize:function(){//通过旋转角度和图片长宽,求虚拟矩形的长宽.
				var mRadian=this.mRadian;
				var imgSize=this.getCurImgSize();
				if(!mRadian)return imgSize;
				return {
					h:imgSize.h* Math.cos(mRadian) + imgSize.w * Math.sin(mRadian),
					w:imgSize.h* Math.sin(mRadian) + imgSize.w * Math.cos(mRadian),
				};
			},
			loadIntoCanvas:function(){
				if(!this.img.complete){
					this.statusBarMessage('canvas模式必须等待图片完全载入完!!');
					return false;
				};
				var cas=this.imgCanvas;
				var ctx=this.imgCasCtx;
				var img=this.img;
				if(!cas){
					cas=document.createElement('canvas');
					this.imgCanvas=cas;
					cas.className='pv_pic_canvas';
					ctx=cas.getContext('2d');
					this.imgCasCtx=ctx;
					img.parentNode.insertBefore(cas,img);
				};
				if(img.style.display!='none'){
					var imgSize=this.getCurImgSize();
					cas.width=imgSize.w;
					cas.height=imgSize.h;
					this.imgCanvasRalatived.imgClient=imgSize;//放在canvas里面的图片,我们无法得到图片的 clientWH,所以必须缓存他.
					this.imgCanvasRalatived.zoom=this.zoom;//保存缩放比.
					ctx.save();
					ctx.translate(cas.width/2,cas.height/2);
					ctx.scale(this.flipHori? -this.zoom : this.zoom,this.flipVert? -this.zoom : this.zoom);
					ctx.drawImage(img,-this.naturalSize.w/2,-this.naturalSize.h/2);
					ctx.restore();
					img.style.display='none';
					cas.style.display='block';
				};
			},
			ableToRestoreToImg:function(){
				return !this.flipHori && !this.flipVert && !this.rotatedRadian;
			},
			restoreToImg:function(){
				if(!this.isCanvasMode())return;
				this.imgCanvas.style.display='none';
				this.img.style.display='block';
				if(this.imgCanvasRalatived.zoom!=this.zoom){
					this.zoomIO(this.zoom>this.imgCanvasRalatived.zoom,this.zoom);
				};
			},
			draw:function(newSize){
				var imgCasCtx=this.imgCasCtx;
				var imgCanvas=this.imgCanvas;
				if(newSize){
					imgCanvas.width=newSize.w;
					imgCanvas.height=newSize.h;
				};
				imgCasCtx.save();
				imgCasCtx.clearRect(0,0,imgCanvas.width,imgCanvas.height);
				imgCasCtx.translate(imgCanvas.width/2,imgCanvas.height/2);
				imgCasCtx.rotate(this.rotatedRadian);
				imgCasCtx.scale(this.flipHori? -this.zoom : this.zoom , this.flipVert? -this.zoom : this.zoom);
				imgCasCtx.drawImage(this.img,-this.naturalSize.w/2,-this.naturalSize.h/2);
				imgCasCtx.restore();
			},
			flip:function(hori){
				if(!this.mode)return;//不支持翻转.
				if(this.mode=='canvas'){
					if(this.loadIntoCanvas()===false)return;
					if(this.ableToRestoreToImg()){
						var cStyle=this.container.style;
						var cOffset={
							top:cStyle.top,
							left:cStyle.left,
						};
						this.restoreToImg();
						cStyle.top=cOffset.top;
						cStyle.left=cOffset.left;
						this.keepScreenInside();
					}else{
						this.draw();
					};
					return;
				};

				var imgStyle=this.img.style;
				if(hori){//水平翻转.
					if(this.flipHori){//翻转
						imgStyle[support.transform]+=' scaleX(-1)';
					}else{//取消
						var transform=imgStyle[support.transform];
						imgStyle[support.transform]=transform.replace(/scaleX\s*\([^)]+\)\s*/i,'');
					};
				}else{//垂直翻转
					if(this.flipVert){//翻转
						imgStyle[support.transform]+=' scaleY(-1)';
					}else{//取消
						var transform=this.img.style[support.transform];
						imgStyle[support.transform]=transform.replace(/scaleY\s*\([^)]+\)\s*/i,'');
					};
				};
			},
			containerClickHandler:function(e){
				if(e.button!=0)return;//左键点击.
				e.preventDefault();
				e.stopPropagation();
				var target=e.target;
				if(target==this.close_pic){//点击关闭按钮
					this.remove();
				}else if(target==this.img || target==this.container || target==this.imgCanvas){//处理 适应屏幕--100%
					if(this.moveORrotate)return;
					//this.fitToScreen();
					//this.verticalCenter();
				};
			},
			isCanvasMode:function(){
				return this.img.style.display=='none';
			},
			getZoomSize:function(next){
				var range=PicObj.zoomRange;
				var cur=this.zoom;
				var i,ii,range_i;
				var ret;
				if(next){
					for(i=0,ii=range.length,range_i;i<ii;i++){
						range_i=range[i];
						if(range_i>cur){
							ret=range_i;
							break;
						}
					};
				}else{
					for(i=range.length-1;i>=0;i--){
						range_i=range[i];
						if(range_i<cur){
							ret=range_i;
							break;
						};
					};
				};
				return ret;
			},
			zoomIO:function(zoomIn,zoom){
				zoom = zoom || this.getZoomSize(zoomIn);
				if(!zoom || zoom<0){
					return;
				};

				var curImgSize=this.getCurImgSize();
				var minSizeL=this.minSizeL;
				if((curImgSize.w<=minSizeL.w || curImgSize.h<=minSizeL.h) && !zoomIn){//到达最小限度,不允许缩放.
					return;
				};

				var floor=Math.floor;
				var nextSize={
					w:floor(this.naturalSize.w * zoom),
					h:floor(this.naturalSize.h * zoom),
				};

				if(!zoomIn){//缩小,超过最小限度,那么强制最小高宽.
					if(nextSize.w < minSizeL.w || nextSize.h < minSizeL.h){
						var scale=nextSize.w/nextSize.h;
						if(scale < minSizeL.w/minSizeL.h){
							nextSize.w=minSizeL.w;
							nextSize.h=floor(nextSize.w/scale);
						}else{
							nextSize.h=minSizeL.h;
							nextSize.w=floor(nextSize.h * scale);
						};
						zoom=Number((nextSize.w/this.naturalSize.w).toFixed(2));
					};
				};

				var minLimit;
				if(nextSize.w == minSizeL.w || nextSize.h == minSizeL.h){
					minLimit=true;
				};

				this.zoom=zoom;

				var cSize_bef=this.getContainerSize();//变换之前div大小..

				var cStyle=this.container.style;

				if(this.isCanvasMode()){
					this.imgCanvasRalatived.imgClient=nextSize;
					var rotatedSize=this.getRotatedImgRectSize();//变换之后图片矩形的大小
					cStyle.width='auto';
					cStyle.height='auto';
					this.draw(rotatedSize);
				}else{
					var imgStyle=this.img.style;
					if(zoom==1){
						imgStyle.height='auto';
						imgStyle.width='auto';
					}else{
						imgStyle.height=nextSize.h + 'px';
						imgStyle.width=nextSize.w + 'px';
					};
					var rotatedSize=this.getRotatedImgRectSize();//变换之后图片矩形的大小
					var rotatedCliSize=this.getCurImgSize();//图片的client
					imgStyle.top=(rotatedSize.h - rotatedCliSize.h)/2 + 'px';
					imgStyle.left=(rotatedSize.w - rotatedCliSize.w)/2 + 'px';
					cStyle.width=rotatedSize.w + 'px';
					cStyle.height=rotatedSize.h + 'px';
				};

				var cSize_aft=this.getContainerSize();//变换之后div大小..

				var pInt=parseInt;
				var divOffset={
					top:pInt(cStyle.top),
					left:pInt(cStyle.left),
				};


				cStyle.top=floor(divOffset.top - (cSize_aft.h - cSize_bef.h)/2) +'px';
				cStyle.left=floor(divOffset.left - (cSize_aft.w - cSize_bef.w)/2) +'px';

				this.keepScreenInside();
				this.statusBarMessage('比例:' + zoom +'x'+ (minLimit? '(最小缩放极限)' : ''));
			},
			wheelHandler:function(e){
				if(!this.isFocused)return;//不是焦点,不处理.
				e.preventDefault();
				e.stopPropagation();
				var zoom=wheelEventObjectFix(e);
				if(zoom=='zoomIn'){
					this.zoomIO(true);
				}else{
					this.zoomIO();
				};
			},
			toolsContainerMouseDownHandler:function(e){
				if(e.button!=0)return;//左键点击.
				e.preventDefault();
				e.stopPropagation();
				var target=e.target;
				//法克 firefox 3.6 switch语句的对比对象时 居然不能正常工作...
				if(target==this.tool_move){
					if(this.selectedTool=='move')return;
					this.selectedTool='move';
					classList.add('pv_pic-tool-selected',this.tool_move);
					classList.remove('pv_pic-tool-selected',this.tool_rotate);
					this.container.style.cursor='move';
				}else if(target==this.tool_rotate){
					if(this.selectedTool=='rotate')return;
					this.selectedTool='rotate';
					classList.add('pv_pic-tool-selected',this.tool_rotate);
					classList.remove('pv_pic-tool-selected',this.tool_move);
					this.container.style.cursor='default';
				}else if(target==this.tool_flipHori){
					this.flipHori=!this.flipHori;
					if(this.flipHori){
						classList.add('pv_pic-tool-selected',this.tool_flipHori);
					}else{
						classList.remove('pv_pic-tool-selected',this.tool_flipHori);
					};
					this.flip(true);
				}else if(target==this.tool_flipVert){
					this.flipVert=!this.flipVert;
					if(this.flipVert){
						classList.add('pv_pic-tool-selected',this.tool_flipVert);
					}else{
						classList.remove('pv_pic-tool-selected',this.tool_flipVert);
					};
					this.flip(false);
				};
			},
			toolsContainerDblClickHandler:function(e){
				if(e.button!=0)return;//左键点击.
				e.preventDefault();
				e.stopPropagation();
				var target=e.target;
				if(target==this.tool_move){
					this.verticalCenter();
					this.statusBarMessage('垂直居中');
					this.keepScreenInside();
				}else if(target==this.tool_rotate){
					this.resetRotate();
					this.statusBarMessage('重置旋转');
					this.keepScreenInside();
				};
			},
			rotateIndicatorDraw:function(){
				var canvas=PicObj.rotateIndicator;
				var ctx=PicObj.rotateIndicatorCtx;
				ctx.clearRect(0,0,canvas.width,canvas.height);
				ctx.save();
				ctx.translate(canvas.width/2,canvas.height/2);
				var img=PicObj.rotateIndicatorImgBG;
				ctx.drawImage(img,-img.width/2,-img.height/2);
				ctx.rotate(this.rotatedRadian);
				img=PicObj.rotateIndicatorImgP;
				ctx.drawImage(img,-img.width/2,-img.height/2);
				ctx.restore();
			},
			rotateIndicatorHide:function(){
				var indicator=PicObj.rotateIndicator;
				if(indicator){
					indicator.style.display='none';
				};
			},
			rotateIndicator:function(offset){
				var indicator=PicObj.rotateIndicator;
				if(!indicator){
					indicator=document.createElement('canvas');
					indicator.id='pv-rotate-indicator';
					PicObj.rotateIndicator=indicator;
					PicObj.rotateIndicatorCtx=indicator.getContext('2d');
					indicator.width=indicator.height=200;
					var img=new Image();
					img.src=prefs.icons.rotateIndicatorBG;
					PicObj.rotateIndicatorImgBG=img;
					img=new Image();
					img.src=prefs.icons.rotateIndicatorPointer;
					PicObj.rotateIndicatorImgP=img;
					G_container.appendChild(indicator);
				};
				indicator.style.top=offset.y-indicator.height/2 + 'px';
				indicator.style.left=offset.x-indicator.width/2 + 'px';
				indicator.style.display='block';
				this.rotateIndicatorDraw();
			},
			statusBarMessage:function(textContent){
				var statusBar=this.statusBar;
				statusBar.textContent=textContent;
				var sbStyle=statusBar.style;
				sbStyle.visibility='visible';
				clearTimeout(this.statusBarMessageTimer);
				this.statusBarMessageTimer=setTimeout(function(){
					sbStyle.visibility='hidden';
				},2000);
			},
			addStyle:function(){
				if(PicObj.style)return;
				var style=document.createElement('style');
				PicObj.style=style;
				style.type='text/css';
				style.textContent='\
					.pv_pic,\
					.pv_pic_canvas,\
					.pv_pic-container\
					#pv_overlayer,\
					#pv-rotate-indicator{\
						margin:0;\
						padding:0;\
						border:none;\
						max-width:99999999px;/*搜狗浏览器牛B闪闪的,如果设置为none,会被限制在100%大小.*/\
						min-width:none;\
						max-height:none;\
						min-height:none;\
						width:auto;\
						height:auto;\
					}\
					#pv_overlayer{\
						position:absolute;\
						top:0;\
						left:0;\
						z-index:109999;\
						background:none;\
						background-color:'+prefs.overlayer.color+';\
					}\
					.pv_pic-container{\
						position:absolute;\
						padding:6px;\
						border:1px solid transparent;\
						background:none;\
						background-color:rgba(0,0,0,0.7);\
						opacity:1;\
						line-height:1.5;\
						-moz-border-radius:5px;\
						-webkit-border-radius:5px;\
						border-radius:5px;\
					}\
					#pv-rotate-indicator{\
						position:absolute;\
						z-index:999999;\
					}\
					.pv_pic{\
						position:relative;\
						top:0;\
						left:0;\
						/*display:block;去掉line-height的影响,会让opera 11.5造成严重的渲染问题*/\
						vertical-align:middle;\
						image-rendering:optimizeQuality;\
					}\
					.pv_close-pic{\
						cursor:pointer;\
						position:absolute;\
						width:30px;\
						height:30px;\
						margin:0;\
						border:none;\
						padding:0;\
						background:transparent url("'+prefs.icons.close+'") no-repeat scroll center center;\
						opacity:0;\
						-o-transition:opacity 0.2s ease-in-out;\
						-moz-transition:opacity 0.2s ease-in-out;\
						-webkit-transition:opacity 0.2s ease-in-out;\
						transition:opacity 0.2s ease-in-out;\
					}\
					.pv_close-pic-focus{\
						opacity:0.7;\
					}\
					.pv_pic-container-blur:hover .pv_close-pic{\
						opacity:0.8;\
					}\
					.pv_pic-container-focus{\
						-moz-box-shadow:0 0 8px 0px rgba(0,0,0,0.9);\
						-webkit-box-shadow:0 0 8px 0px rgba(0,0,0,0.9);\
						box-shadow:0 0 8px 0px rgba(0,0,0,0.8);\
						border:1px solid rgba(250,250,250,0.9);\
					}\
					.pv_close-pic:hover{\
						opacity:0.98!important;\
					}\
					.pv_pic-tools-container{\
						position:absolute;\
						border:1px solid white;\
						background:none;\
						background-color:rgba(0,0,0,0.8);\
						margin:0;\
						padding:3px;\
						-moz-border-radius:6px;\
						-webkit-border-radius:6px;\
						border-radius:6px;\
						opacity:0;\
						cursor:default;\
						-moz-box-shadow:0 0 8px 0px rgba(0,0,0,0.9);\
						-webkit-box-shadow:0 0 8px 0px rgba(0,0,0,0.9);\
						box-shadow:0 0 8px 0px rgba(0,0,0,0.8);\
						-o-transition:opacity 0.2s ease-in-out;\
						-moz-transition:opacity 0.2s ease-in-out;\
						-webkit-transition:opacity 0.2s ease-in-out;\
						transition:opacity 0.2s ease-in-out;\
					}\
					.pv_pic-tools-container-focus{\
						opacity:0.7;\
					}\
					.pv_pic-container-blur:hover .pv_pic-tools-container{\
						opacity:0.8;\
					}\
					.pv_pic-tools-container:hover{\
						opacity:0.96!important;\
					}\
					.pv_pic-tool{\
						display:block;\
						margin:0 2px 3px;\
						cursor:pointer;\
						color:white;\
						font-size:12px;\
						border:1px solid transparent;\
					}\
					.pv_pic-tool:hover{\
						background-color:#5D0300;\
					}\
					.pv_pic-tool:active{\
						border-top-width:2px;\
						border-left-width:2px;\
						border-right-width:0;\
						border-bottom-width:0;\
					}\
					.pv_pic-tool-selected{\
						background-color:red!important;\
					}\
					.pv_pic-tools-separator{\
						display:block;\
						width:100%\
						height:0;\
						border:none;\
						padding:0;\
						margin:3px 0;\
						border-top:1px solid white;\
					}\
					.pv_status-bar{\
						position:absolute;\
						margin:0;\
						border:none;\
						padding:0 10px 0 2px;\
						font-size:13px;\
						background:none;\
						background-color:rgba(0,0,0,0.7);\
						color:white;\
						visibility:hidden;\
						line-height:22px;\
						-moz-box-shadow:0 0 8px 0px rgba(0,0,0,0.8);\
						-webkit-box-shadow:0 0 8px 0px rgba(0,0,0,0.8);\
						box-shadow:0 0 8px 0px rgba(0,0,0,0.8);\
						-moz-border-radius:0 5px 0 0;\
						-webkit-border-radius:0 5px 0 0;\
						border-radius:0 5px 0 0;\
					}\
				';
				G_container.appendChild(style);
			},
			init:function(){
				this.addStyle();
				var self=this;

				var container=document.createElement('span');
				this.container=container;
				container.className='pv_pic-container';
				container.style.cssText='\
					top:-99999px;\
					left:-99999px;\
					cursor:move;\
				';

				var mode=PicObj.mode;
				this.mode=mode;

				this.moveORrotate=false;//判断是否是做完移动或者旋转后,触发的click事件.

				var oriOffset;
				var oriMouseCoor;
				function boxMove(e){
					self.moveORrotate=true;
					var mouseCoor={
						x:e.pageX,
						y:e.pageY,
					};
					var cStyle=container.style;
					cStyle.top=mouseCoor.y-oriMouseCoor.y + oriOffset.top +'px';
					cStyle.left=mouseCoor.x-oriMouseCoor.x + oriOffset.left +'px';
				};

				function moveOver(){
					if(self.moveORrotate)self.keepScreenInside();
					document.removeEventListener('mousemove',boxMove,false);
					document.removeEventListener('mouseup',moveOver,false);
				};

				var iniBoxSize;
				var shiftKey;
				this.rotatedRadian=this.preRadian=this.mRadian=0;
				var shiftRotateStep=prefs.shiftRotateStep * Math.PI/180;
				function boxRotate(e){
					self.moveORrotate=true;
					var mouseCoor={
						x:e.pageX,
						y:e.pageY,
					};
					var radian=Math.atan2(mouseCoor.y - oriMouseCoor.y,mouseCoor.x - oriMouseCoor.x);
					radian += self.preRadian;//加上 上一回旋转时的旋转角度

					/////////////
					var PI=Math.PI;

					if(radian>0){// 减去360度的重复.
						while(radian>=2*PI){
							radian-=2*PI;
						};
					}else if(radian<0){
						while(radian<0){
							radian+=2*PI;
						};
					};

					if(shiftKey){
						var mo=radian % shiftRotateStep;
						radian-=mo;
						if(radian==self.rotatedRadian){
							return;
						};
					};

//////////////////////
					var mRadian=radian;
					if(mRadian<0){
						mRadian+=2*PI;
					};
					if(mRadian>PI){
						mRadian=2*PI-mRadian;
					};
					if(mRadian>1/2*PI){
						mRadian=PI-mRadian;
					};

					self.mRadian=mRadian;//保存,用来计算图片旋转上,所等同的矩形大小.

					var rotatedSize=self.getRotatedImgRectSize();//旋转后图片大小



					var cStyle=container.style;
					var pInt=parseInt;

					self.rotatedRadian=radian;//保存已经旋转的角度
					if(mode=='canvas'){
						cStyle.width='auto';
						cStyle.height='auto';
						self.draw(rotatedSize);
					}else{
						cStyle.width=rotatedSize.w+'px';
						cStyle.height=rotatedSize.h+'px';
						var rotatedCliSize=self.getCurImgSize();//旋转后的图片clent size
						var imgStyle=self.img.style;
						imgStyle.top= (rotatedSize.h-rotatedCliSize.h)/2 + 'px';
						imgStyle.left= (rotatedSize.w-rotatedCliSize.w)/2 + 'px';
						var transform=imgStyle[support.transform];
						transform=transform.replace(/rotate\s*\([^)]+\)\s*/i,'');
						imgStyle[support.transform]=' rotate(' + radian + 'rad) '+transform;
					};
					self.rotateIndicatorDraw();

					var containerSize=self.getContainerSize();

					var nOffset={
						top:oriOffset.top-(containerSize.h-iniBoxSize.h)/2,
						left:oriOffset.left-(containerSize.w-iniBoxSize.w)/2,
					};

					cStyle.top=nOffset.top + 'px';
					cStyle.left=nOffset.left + 'px';
				};

				function rotateOver(){
					if(self.moveORrotate)self.keepScreenInside();
					self.statusBarMessage('已旋转:' + Math.round(self.rotatedRadian * 180 /Math.PI) + '°');
					self.preRadian=self.rotatedRadian;
					self.rotateIndicatorHide();
					document.removeEventListener('mousemove',boxRotate,false);
					document.removeEventListener('mouseup',rotateOver,false);
				};

				var pInt=parseInt;

				this.imgCanvasRalatived={};

				container.addEventListener('mousedown',function(e){//处理,旋转和平移
					e.preventDefault();
					e.stopPropagation();
					var target=e.target;
					var imgCanvas=self.imgCanvas;
					if(target!=container && target!=img && target!=imgCanvas)return;
					if(!self.isFocused){//没有聚焦,那么先聚焦.
						self.focus();
						self.keepScreenInside();
					};

					if(e.button!=0)return;//左键点击,才开始工作.
					self.moveORrotate=false;
					var cStyle=container.style;
					oriMouseCoor={//记录当前的鼠标位置.
						x:e.pageX,
						y:e.pageY,
					};
					oriOffset={//记录当前的容器定位的偏移值.
						top:pInt(cStyle.top),
						left:pInt(cStyle.left),
					};
					switch(self.selectedTool){
						case 'move':{
							document.addEventListener('mousemove',boxMove,false);
							document.addEventListener('mouseup',moveOver,false);
						}break;
						case 'rotate':{
							if(!mode)return;//不支持旋转
							if(mode=='canvas'){//第一次旋转的时候,为不支持css3 transform的浏览器 启动canvas,canvas旋转gif不会动.
								if(self.loadIntoCanvas()===false)return;
							};
							oriMouseCoor.x -=30;//向左偏移点.
							self.rotateIndicator(oriMouseCoor);
							shiftKey=e.shiftKey;//是否按住了 shift 键
							iniBoxSize=self.getContainerSize();
							document.addEventListener('mousemove',boxRotate,false);
							document.addEventListener('mouseup',rotateOver,false);
						}break;
					};
				},false);

				container.addEventListener('mouseover',function(e){//非聚焦图片,悬浮时,调整关闭按钮位置.
					if(self.isFocused)return;
					self.keepScreenInside();
				},false);

				container.addEventListener('click',function(e){//处理,放大/适应屏幕.关闭等等.
					self.containerClickHandler(e);
				},false);


				var close_pic=document.createElement('span');
				this.close_pic=close_pic;
				close_pic.title='关闭';
				close_pic.className='pv_close-pic';
				close_pic.style.cssText='\
					right:-15px;\
					top:-15px;\
				';


				var img=this.img;
				img.className='pv_pic';
				container.appendChild(img);
				container.appendChild(close_pic);

				//状态栏.
				var statusBar=document.createElement('span');
				this.statusBar=statusBar;
				statusBar.style.cssText='\
					bottom:3px;\
					left:3px;\
				';
				statusBar.className='pv_status-bar';
				container.appendChild(statusBar);


				if(!PicObj.zoomRange){//排列下数组,从小到大.
					PicObj.zoomRange=prefs.wheelZoom.range.sort(function(a,b){
						return a-b;
					});
				};

				container.addEventListener(support.wheelEvent,function(e){
					self.wheelHandler(e);
				},false)


				//工具栏部分操作.
				var pic_tools_container=document.createElement('span');
				pic_tools_container.className='pv_pic-tools-container';
				this.pic_tools_container=pic_tools_container;
				pic_tools_container.style.cssText='\
					top:0;\
					left:-40px;\
				';

				this.flipHori=this.flipVert=false;//翻转状态.

				pic_tools_container.addEventListener('mousedown',function(e){
					self.toolsContainerMouseDownHandler(e);
				},false);

				pic_tools_container.addEventListener('dblclick',function(e){
					self.toolsContainerDblClickHandler(e);
				},false);


				var tool_move=document.createElement('span');
				this.tool_move=tool_move;
				tool_move.className='pv_pic-tool pv_pic-tools-move';
				tool_move.title='移动,双击居中';
				tool_move.textContent='移动';

				this.selectedTool='move';
				classList.add('pv_pic-tool-selected',tool_move);

				var tool_rotate=document.createElement('span');
				this.tool_rotate=tool_rotate;
				tool_rotate.className='pv_pic-tool pv_pic-tools-rotate';
				tool_rotate.title='旋转,双击还原';
				tool_rotate.textContent='旋转';

				var tool_flipHori=document.createElement('span');
				this.tool_flipHori=tool_flipHori;
				tool_flipHori.className='pv_pic-tool pv_pic-tools-flip-hori';
				tool_flipHori.title='水平翻转';
				tool_flipHori.textContent='水翻';

				var tool_flipVert=document.createElement('span');
				this.tool_flipVert=tool_flipVert;
				tool_flipVert.className='pv_pic-tool pv_pic-tools-flip-vert';
				tool_flipVert.title='垂直翻转';
				tool_flipVert.textContent='垂翻';

				var tool_separator=document.createElement('span');
				tool_separator.className='pv_pic-tools-separator';

				pic_tools_container.appendChild(tool_move);
				pic_tools_container.appendChild(tool_rotate);
				pic_tools_container.appendChild(tool_separator);
				pic_tools_container.appendChild(tool_flipHori);
				pic_tools_container.appendChild(tool_flipVert);


				container.appendChild(pic_tools_container);
				G_container.appendChild(container);


				PicObj.all.push(this);//放入对象集合中.

				if(PicObj.all.length==1){
					document.addEventListener('keydown',PicObj.escRemoveFocused,false);//chrome keypress 不响应esc
					document.addEventListener('mousedown',PicObj.blurAll,false);
				};


				var minSizeL;//计算最小允许的缩放值
				minSizeL=prefs.wheelZoom.minZoomSizeLimit;
				if(this.naturalSize.w <= minSizeL.w || this.naturalSize.h <= minSizeL.h){
					minSizeL=this.naturalSize;
				};
				this.minSizeL=minSizeL;

				this.zoom=1;

				setTimeout(function(){
					if(prefs.firstOpenFTS)self.fitToScreen();//适应屏幕
					self.verticalCenter();//垂直居中
					self.focus();//聚焦
					self.overlayer();//覆盖层
					self.keepScreenInside();//工具栏,关闭按钮,状态栏,屏幕里面显示.
				},0);
			},
		};


		//放大镜类
		function MagnifierObj(img,naturalSize,target){
			this.img=img;
			this.naturalSize=naturalSize;
			this.target=target;
			this.init();
		};

		MagnifierObj.all=[];
		MagnifierObj.moveHandler=function(e){//放大镜的move事件处理函数.
			var all=MagnifierObj.all;
			for(var i=all.length-1;i>=0;i--){
				var self=all[i];
				var pageXY={
					x:e.pageX,
					y:e.pageY,
				};
				var range=self.range;
				if(pageXY.x >= range.ab.x && pageXY.x <= range.bb.x && pageXY.y >= range.ab.y && pageXY.y <= range.bb.y){//如果在某些范围内.
					var lastPP=self.lastPP;
					var diameter=self.diameter;
					if(self.pause)return;
					if(pageXY.x < range.a.x){
						pageXY.x=range.a.x;
					}else if(pageXY.x > range.b.x){
						pageXY.x = range.b.x
					};
					if(pageXY.y < range.a.y){
						pageXY.y=range.a.y;
					}else if(pageXY.y > range.b.y){
						pageXY.y = range.b.y
					};
					lastPP={
						ratioW:(pageXY.x-range.a.x)/range.size.w,
						ratioH:(pageXY.y-range.a.y)/range.size.h,
					};
					self.move(pageXY);
					self.lastPP=lastPP;
					self.draw();
					//break;
				};
			};
		};

		MagnifierObj.prototype={
			remove:function(){
				MagnifierObj.all.splice(MagnifierObj.all.indexOf(this),1);//从全局数组删除自己的存在.
				if(MagnifierObj.all.length == 0){//如果没有被放大镜监视的图片了,那么移除全局move监听.
					document.removeEventListener('mousemove',MagnifierObj.moveHandler,true);
				};
				window.removeEventListener('resize',this.resizeHandler,false);
				this.canvas.parentNode.removeChild(this.canvas);//移除dom
			},
			move:function(coor){
				var canvas=this.canvas;
				coor=coor || this.lastCoor || this.range.a;
				var canvasRadius=this.canvasRadius;
				var cstyle=canvas.style;
				cstyle.left=coor.x - canvasRadius + 'px';
				cstyle.top=coor.y - canvasRadius + 'px';
				this.lastCoor=coor;
			},
			draw:function(offset){
				var diameter=this.diameter;
				var radius=diameter/2;

				offset=offset || {
					x:-Math.floor((this.lastPP.ratioW * (Math.max(this.naturalSize.w - diameter,0)))),
					y:-Math.floor((this.lastPP.ratioH * (Math.max(this.naturalSize.h - diameter,0)))),
				};

				var coorCenter=this.coorCenter;

				var canvasDia=this.canvasDia;
				var canvas=this.canvas;

				canvas.width=canvas.height=this.canvasDia;

				var expand=this.expand;
				var halfExpand=expand/2;

				var mg=prefs.magnifier;

				var border1=mg.borderWidth[0];
				var border2=mg.borderWidth[1];

				var firstBorderRadius=radius + border1;
				var secondBorderRadius=firstBorderRadius + border2;

				if(diameter >= this.naturalSize.w){
					offset.x=Math.floor((diameter-this.naturalSize.w)/2);
				};
				if(diameter >= this.naturalSize.h){
					offset.y=Math.floor((diameter-this.naturalSize.h)/2);
				};

				var context=this.context;
				context.save();
				context.clearRect(0,0,canvasDia,canvasDia);//清除画布.

				if(mg.shape=='circle'){
					context.beginPath();//绘制一个圆,作为遮罩.
					context.arc(coorCenter.x, coorCenter.y , radius , 0 , 2*Math.PI, true);
					context.fillStyle ='#000';
					context.fill();

					//context.globalCompositeOperation='source-in';//以上图为遮罩,装入图片.
					context.globalCompositeOperation='source-atop';//为了兼容 firefox 3.6

					context.drawImage(this.img, offset.x + halfExpand, offset.y + halfExpand);

					context.beginPath();//第一层边框.
					context.arc(coorCenter.x, coorCenter.y , firstBorderRadius , 0 , 2*Math.PI, true);
					context.globalCompositeOperation='destination-over';
					context.fillStyle =prefs.magnifier.borderColor[0];
					context.fill();

					context.beginPath();//第二层边框.
					context.arc(coorCenter.x, coorCenter.y , secondBorderRadius, 0 , 2*Math.PI, false);
					context.fillStyle =prefs.magnifier.borderColor[1];
					context.fill();
				}else{
					context.fillRect(halfExpand,halfExpand,diameter,diameter);

					context.globalCompositeOperation='source-atop';//为了兼容 firefox 3.6
					context.drawImage(this.img, offset.x + halfExpand, offset.y + halfExpand);

					context.globalCompositeOperation='destination-over';
					context.fillStyle =prefs.magnifier.borderColor[0];
					context.fillRect(halfExpand - border1, halfExpand - border1 ,firstBorderRadius * 2,firstBorderRadius * 2);

					context.fillStyle =prefs.magnifier.borderColor[1];
					context.fillRect(halfExpand - border1 - border2 , halfExpand - border1 - border2 ,secondBorderRadius * 2,secondBorderRadius * 2);
				};

				if(this.pause){
					context.strokeStyle = 'red';
					context.lineWidth=2;
					if(mg.shape=='circle'){
						context.beginPath();//第三层边框.
						context.arc(coorCenter.x, coorCenter.y , secondBorderRadius , 0 , 2*Math.PI, false);
						context.stroke();
					}else{
						context.strokeRect(halfExpand - border1 - border2 -1 , halfExpand - border1 - border2 -1 ,secondBorderRadius * 2 + 2,secondBorderRadius * 2+2);
					};
				};

				context.restore();
			},
			setRange:function(){
				var target=this.target;
				var tOffset=getTargetImgPosition(target);
				var size=getDisIS(target);
				var canvasRadius=this.canvasRadius;
				var range={//根据显示图片的创建,创建一个相应move事件的坐标范围. a 为左上角, b为右下角.
					ab:{
						x:tOffset.left - canvasRadius,
						y:tOffset.top - canvasRadius,
					},
					bb:{
						x:tOffset.left + size.w + canvasRadius,
						y:tOffset.top + size.h + canvasRadius,
					},
					a:{//左上角坐标.
						x:tOffset.left,
						y:tOffset.top,
					},
					b:{//右下角坐标
						x:tOffset.left + size.w,
						y:tOffset.top + size.h,
					},
					size:{//图片大小
						w:size.w,
						h:size.h,
					},
				};
				//C.log('范围',range);
				this.range=range;
				return range;
			},
			zoomIO:function(zoomIn,zoom){
				zoom=zoom || this.getZoomSize(zoomIn);
				if(!zoom || zoom<0){
					return;
				};
				//alert(zoom);
				var curDia=this.diameter;
				if(zoomIn){//放大,已达到最大值.
					if(curDia>=this.maxDiameter)return;
				};
				var nextDia=Math.floor(this.iniDia * zoom);
				if(nextDia % 2 !=0){
					nextDia +=1;
				};
				if(zoomIn){
					nextDia=Math.min(this.maxDiameter,nextDia);
				};
				this.diameter=nextDia;
				this.canvasDia+=nextDia-curDia;
				this.canvasRadius=this.canvasDia/2;
				this.coorCenter={
					x:this.canvasRadius,
					y:this.canvasRadius,
				};
				this.zoom=zoom;
				this.setRange();
				this.move();
				this.draw();
			},
			getZoomSize:function(next){
				var range=MagnifierObj.zoomRange;
				var cur=this.zoom;
				var i,ii,range_i;
				var ret;
				if(next){
					for(i=0,ii=range.length,range_i;i<ii;i++){
						range_i=range[i];
						if(range_i>cur){
							ret=range_i;
							break;
						}
					};
				}else{
					for(i=range.length-1;i>=0;i--){
						range_i=range[i];
						if(range_i<cur){
							ret=range_i;
							break;
						};
					};
				};
				return ret;
			},
			wheelHandler:function(e){
				if(prefs.magnifier.wheelZoom.needToPause && !this.pause)return;
				e.preventDefault();
				e.stopPropagation();
				var zoom=wheelEventObjectFix(e);
				if(zoom=='zoomIn'){
					this.zoomIO(true);
				}else{
					this.zoomIO();
				};
			},
			addStyle:function(){
				if(!MagnifierObj.style){
					var style=document.createElement('style');
					MagnifierObj.style=style;
					style.type='text/css';
					style.textContent='\
						.pv_magnifier-mask{\
							position:absolute;\
							top:-999;\
							left:-999;\
							margin:0;\
							padding:0;\
							border:none;\
							display:block;\
							background:none;\
							z-index:99999;\
						}\
					';
					G_container.appendChild(style);
				};
			},
			init:function(){
				this.addStyle();//样式装载.

				var self=this;
				this.lastPP={//鼠标相对图片的移动距离 和 图片宽高的比例.
					ratioW:0,
					ratioH:0,
				};

				MagnifierObj.all.push(this);

				if(MagnifierObj.all.length==1){//当加载第一个放大镜的时候,挂在全局监听,以后的不能挂.
					document.addEventListener('mousemove',MagnifierObj.moveHandler,true);
				};

				var naturalSize=this.naturalSize;

				var defaultDia=prefs.magnifier.radius * 2;
				var diameter=defaultDia;

				if(prefs.magnifier.autoRadius){
					diameter=Math.min(defaultDia,naturalSize.w,naturalSize.h);//为了遮罩能包裹图片,取最小值.
				};

				if(diameter % 2 !=0){
					diameter +=1;
				};

				this.diameter=this.iniDia=diameter;
				//C.log('mask的直径大小:',diameter);

				var expand= (prefs.magnifier.borderWidth[0] + prefs.magnifier.borderWidth[1])* 2;//画布弄大点,其他的地方用来画边框.
				if(expand % 2 !=0){//扩展,应该弄成个偶数,等下绘制圆的时候,不会移动到1/2像素处.
					expand +=1;
				};
				expand+=4;//用来画暂停的红色边框.
				var canvasDia=diameter + expand;
				this.expand=expand;
				this.canvasDia=canvasDia;

				var canvasRadius=canvasDia/2;
				this.canvasRadius=canvasRadius;

				this.setRange();

				var coorCenter={//画布中心点.
					x:canvasRadius,
					y:canvasRadius,
				};
				this.coorCenter=coorCenter;

				var canvas=document.createElement('canvas');
				this.canvas=canvas;
				canvas.className='pv_magnifier-mask';
				var context=canvas.getContext('2d');
				this.context=context;
				G_container.appendChild(canvas);

				if(prefs.magnifier.wheelZoom.enabled){
					if(!MagnifierObj.zoomRange){//排列下数组,从小到大.
						MagnifierObj.zoomRange=prefs.magnifier.wheelZoom.range.sort(function(a,b){
							return a-b;
						});
					};

					var maxDiameter;//最大直径(可以看到全图,所需要的直径大小)
					if(prefs.magnifier.shape=='circle'){
						maxDiameter=Math.ceil(Math.sqrt(Math.pow(1/2*naturalSize.w,2) + Math.pow(1/2*naturalSize.h,2)) * 2);
					}else{
						maxDiameter=Math.max(naturalSize.w,naturalSize.h);
					};
					if(maxDiameter % 2!=0){
						maxDiameter +=1;
					};
					this.maxDiameter=maxDiameter;

					canvas.addEventListener(support.wheelEvent,function(e){
						self.wheelHandler(e);
					},false)
				};


				this.pause=false;
				canvas.addEventListener('click',function(e){//点击暂停.
					self.pause=!self.pause;
					self.draw();
				},false);


				canvas.addEventListener('dblclick',function(e){//双击自己,进行卸载.
					if(this.closing)return;
					this.closing=true;
					this.pause=true;
					var closeInterval;
					var preZoom=self.zoom;
					closeInterval=setInterval(function(){
						self.zoomIO();
						if(self.zoom==preZoom){
							clearInterval(closeInterval);
							self.remove();
							return;
						};
						preZoom=self.zoom;
					},0);
				},false);

				var resizeTimer;
				this.resizeHandler=function(){//调整窗口大小的时候,重新设定范围,并调整放大镜位置.
					clearTimeout(resizeTimer);
					resizeTimer=setTimeout(function(){
						var range=self.setRange();
						var lastPP=self.lastPP;
						var offset={
							x:range.size.w * lastPP.ratioW + range.a.x,
							y:range.size.h * lastPP.ratioH + range.a.y,
						};
						self.move(offset);
					},100);
				};

				window.addEventListener('resize',this.resizeHandler,false);

				this.zoom=1;

				this.draw();
				this.move();
			},
		};


		//imgReady
		var imgReady=(function(){
			var iRInterval;
			var iRReadyFn=[];
			function imgReady(img,load,ready,error){//4个参数,除了img和load必须,其他可选.
				if(img.complete){
					C.log('读取图片阶段',img,'complete');
					if(img.width && img.height){
						setTimeout(function(){
							load1({
								target:img,
								type:'load',
							});
						},0);
					}else{//尼玛,这不是图片.opera会识别错误.
						setTimeout(function(){
							if(error){
								error1({
									target:img,
									type:'error',
								});
							};
						},0);
					};
				};

				function go(type,e){
					ready1.done=true;
					//C.log(type);
					switch(type){
						case 'load':{
							C.log('读取图片阶段',img,'load');
							img.removeEventListener('load',load1,false);
							if(error){
								img.removeEventListener('error',error1,false);
							};
							load.call(img,e);
							//console.log('load-e',e);
						}break;
						case 'ready':{
							C.log('读取图片阶段',img,'ready');
							ready.call({
								target:img,
								type:'ready',
							});
						}break;
						case 'error':{
							C.log('读取图片阶段',img,'error');
							img.removeEventListener('load',load1,false);
							img.removeEventListener('error',error1,false);
							//console.log('error-e',e);
							error.call(img,e);
						}break;
					};
				};

				function load1(e){
					if(load1.done)return;
					load1.done=true;
					if(ready && !ready1.ready)go('ready');//触发load前,先触发ready
					go('load',e);
				};

				img.addEventListener('load',load1,false);

				function error1(e){
					if(error1.done)return;
					error1.done=true;
					go('error',e);
				};

				if(error){
					img.addEventListener('error',error1,false);
				};

				var ready1=function(){};
				if(ready){
					ready1=function(){//尽快的检测图片大小.
						if(img.width==0)return;
						ready1.ready=true;
						go('ready');
						return true;
					};
					iRReadyFn.push(ready1);

					if(!iRInterval){
						iRInterval=setInterval(function(){
							for(var i=0,ii=iRReadyFn.length,iRReadyFn_i;i<ii;i++){
								iRReadyFn_i=iRReadyFn[i];
								if(iRReadyFn_i.done || iRReadyFn_i()){
									C.log('读取图片阶段',img,'移除ready判断函数');
									iRReadyFn.splice(i,1);
									i--;
									ii--;
								};
							};
							if(iRReadyFn.length==0){
								C.log('读取图片阶段,所有ready函数全部判断完毕,移除interval');
								clearInterval(iRInterval);
								iRInterval=null;
							};
						},22);
					};
				};
			};
			return imgReady;
		})();

		//载入时,读取动画图标对象.
		function LoadingAnim(src,target,type,ctrlKey){
			this.src=src;
			this.target=target;
			this.type=type;
			this.ctrlKey=ctrlKey;
			this.init();
		};

		LoadingAnim.all=[];

		LoadingAnim.prototype={
			remove:function(){
				//从所有对象集合里面移除当前对象.
				LoadingAnim.all.splice(LoadingAnim.all.indexOf(this),1);
				//卸载监听
				window.removeEventListener('resize',this.resizeHandler,false);
				//删除dom
				this.container.parentNode.removeChild(this.container);
			},
			load:function(reload){
				if(reload!='reload')this.remove();
				C.log('成功载入:',this.src);
				var img=this.img;
				if(this.type=='original' || this.type=='current'){
					if(openInTopWindow && reload!='reload'){
						window.top.postMessage('from_pv_frame_window:' + xToString({
							src:this.src,
							waitImgLoad:this.waitImgLoad,
							size:{
								w:img.width,
								h:img.height
							},
						}),'*');

						var self=this;
						if(!topWindowExist){//确认顶层窗口的存在.
							setTimeout(function(){
								if(!topWindowExist){
									self.load('reload');
								};
							},100);
						};
						return;
					};
					new PicObj(this.src,img,{w:img.width,h:img.height});
				}else if(this.type=='magnifier'){
					new MagnifierObj(img,{w:img.width,h:img.height},this.target);
				};
			},
			errorMessage:function(){
				var span=document.createElement('span');
				span.className='pv_load-error-message';
				span.textContent='<load error>';
				G_container.appendChild(span);

				var rect=getTargetImgPosition(this.target);
				span.style.top=rect.top + 3 +'px';
				span.style.left=rect.left + 3 +'px';
				setTimeout(function(){
					G_container.removeChild(span);
				},999);
			},
			error:function(){
				this.remove();
				this.errorMessage();
				C.log('载入错误:',this.src);
			},
			cancle:function(e){
				e.preventDefault();
				this.img.src='';
				this.remove();
				C.log('载入中止:',this.src);
			},
			setPosition:function(){
				var position=getTargetImgPosition(this.target);
				var cStyle=this.container.style;
				cStyle.top=position.top +1 + 'px';
				cStyle.left=position.left +1 + 'px';
				cStyle.visibility='visible';
			},
			addStyle:function(){
				if(LoadingAnim.style)return;
				var style=document.createElement('style');
				LoadingAnim.style=style;
				style.type='text/css';
				style.textContent='\
					.pv_loading-anim-container{\
						width:auto;\
						height:auto;\
						border:none;\
						margin:0;\
						padding:0;\
						position:absolute;\
						z-index:100001;\
						opacity:0.8;\
						visibility:hidden;\
						-o-transition:opacity 0.2s ease-in-out;\
						-moz-transition:opacity 0.2s ease-in-out;\
						-webkit-transition:opacity 0.2s ease-in-out;\
						transition:opacity 0.2s ease-in-out;\
					}\
					.pv_loading-anim-container:hover{\
						opacity:1;\
					}\
					.pv_loading-anim-container > .pv_loading-anim{\
						float:left;\
						height:24px;\
						width:24px;\
						margin:0;\
						border:2px solid black;\
						padding:2px;\
						background-color:white;\
						background-position:center center;\
						background-repeat:no-repeat;\
						background-image:url("'+prefs.icons.loading+'");\
						-webkit-border-radius:20px;\
						-moz-border-radius:20px;\
						border-radius:20px;\
						-moz-box-shadow:1px 2px 3px #ccc;\
						-webkit-box-shadow:1px 2px 3px #ccc;\
						box-shadow:1px 2px 3px #ccc;\
					}\
					.pv_loading-anim-container > .pv_loading-cancle{\
						position:absolute;\
						right:-3px;\
						top:-3px;\
						height:12px;\
						width:12px;\
						margin:0;\
						border:2px solid black;\
						padding:0;\
						cursor:pointer;\
						-webkit-border-radius:20px;\
						-moz-border-radius:20px;\
						border-radius:20px;\
						background-color:white;\
						background-position:center center;\
						background-repeat:no-repeat;\
						background-image:url("'+prefs.icons.loadingCancle+'");\
						visibility:hidden;\
					}\
					.pv_loading-anim-container:hover .pv_loading-cancle{\
						visibility:visible;\
					}\
					.pv_load-error-message{\
						border:1px solid red;\
						background:none;\
						background-color: rgba(0, 0, 0, 0.8);\
						color:white;\
						position:absolute;\
						z-index:99999;\
						font-size:12px;\
						-moz-border-radius:3px;\
						-webkit-border-radius:3px;\
						border-radius:3px;\
						padding:3px;\
						font-style:italic;\
						font-weight:bold;\
						opacity:1;\
					}\
				';
				G_container.appendChild(style);
			},
			init:function(){
				this.addStyle();
				var container=document.createElement('span');
				this.container=container;
				container.className='pv_loading-anim-container';

				var loading_anim=document.createElement('span');
				this.loading_anim=loading_anim;
				loading_anim.className='pv_loading-anim';
				loading_anim.title='正在加载...稍等..';

				var loadingCancle=document.createElement('span');
				this.loadingCancle=loadingCancle;
				loadingCancle.title='取消加载';
				loadingCancle.className='pv_loading-cancle';

				container.appendChild(loading_anim);
				container.appendChild(loadingCancle);

				G_container.appendChild(container);
				this.setPosition();

				var self=this;

				var rstoHandler=function(){
					self.setPosition();
				};

				var resizeTimer;
				this.resizeHandler=function(){
					clearTimeout(resizeTimer);
					resizeTimer=setTimeout(rstoHandler,299);
				};

				window.addEventListener('resize',this.resizeHandler,false);

				//保存当前对象到对象集合里面.
				LoadingAnim.all.push(this);

				//取消加载.
				loadingCancle.addEventListener('click',function(e){
					self.cancle(e);
				},false);


				this.waitImgLoad= this.type=='magnifier' || (this.ctrlKey? !prefs.waitImgLoad : prefs.waitImgLoad);

				//载入失败.
				function errorHandler(e){
					self.error(e);
				};

				var loaded;
				function loadHandler(e){//成功载入
					if(loaded)return;
					loaded=true;
					self.load(e);
				};

				//尝试载入图片.
				var img=new Image();
				this.img=img;
				img.src=this.src;

				imgReady(img,loadHandler , this.waitImgLoad? null : loadHandler , errorHandler);
			},
		};


		//浮动工具栏
		function FloatBarObj(){
			this.init();
		};


		FloatBarObj.prototype={
			buttonSwitch:function(){
				if(this.noZoom){//如果没有缩放的图片上
					this.floatBar_viewOri.style.display='none';
					this.floatBar_magnifier.style.display='none';
					this.floatBar_viewCur.style.display='block';
				}else{
					this.floatBar_viewOri.style.display='block';
					var size=getDisIS(this.target);
					if(size.h < prefs.magnifier.minSizeLimit.height || size.w < prefs.magnifier.minSizeLimit.width){//如果显示的图片太小,就不显示放大镜图标,因为那啥,没有足够的空间移动.
						C.log('目标太小,不显示放大镜',this.target);
						this.floatBar_magnifier.style.display='none';
					}else{
						this.floatBar_magnifier.style.display='block';
					};
					this.floatBar_viewCur.style.display='block';
				};
			},
			setPosition:function(){
				var targetPosi=getTargetImgPosition(this.target);
				var windowSize=getWindowSize();
				var fbs=this.floatBar.style;


				var floatBarPosi=prefs.floatBar.position.toLowerCase().split(/\s+/);

				var offsetX=prefs.floatBar.offset.x;
				var offsetY=prefs.floatBar.offset.y;

				var scrollXY=getWindowScrollXY();

				var setPosition={
					top:function(){
						var top=targetPosi.top;
						if(targetPosi.t < -offsetY){//满足图标被遮住的条件.
							top=scrollXY.y;
							offsetY=0;
						};
						fbs.top=top + offsetY + 'px';
					},
					right:function(){
						var right=windowSize.w - targetPosi.r;
						if(right < offsetX){
							right= -scrollXY.x;
							offsetX=0;
						}else{
							right -=scrollXY.x;
						};
						fbs.right=right - offsetX + 'px';
					},
					bottom:function(){
						var bottom=windowSize.h-targetPosi.b;
						if(bottom <= offsetY){
							offsetY=0;
						};
						bottom -= scrollXY.y;
						fbs.bottom=bottom - offsetY + 'px';
					},
					left:function(){
						var left=targetPosi.left;
						if(targetPosi.l < -offsetX){
							left=scrollXY.x;
							offsetX=0;
						};
						fbs.left=left + offsetX + 'px';
					},
				};

				setPosition[floatBarPosi[0]]();
				setPosition[floatBarPosi[1]]();
			},
			show:function(){
				clearTimeout(this.hideTimer);
				this.setPosition();
				this.floatBar.style.visibility='visible';
				this.preTarget=this.target;//保存一下这个成功显示浮动栏的对象,后台由于检测,是否离开后,立马返回了这个对象.
			},
			showDelay:function(){
				var self=this;
				clearTimeout(this.showTimer);
				this.showTimer=setTimeout(function(){
					self.show();
				},prefs.floatBar.showDelay);
			},
			over:function(target,e,src,noZoom){
				var self=this;
				this.src=src;
				this.noZoom=noZoom;
				this.target=target;
				this.tSrc=target.src;

				var loadingImgs=LoadingAnim.all;
				for(var i=0,ii=loadingImgs.length,value ; i<ii ; i++){//读取中的图片,不显示浮动栏,调整读取图标的位置.
					value=loadingImgs[i];
					if(value.target==target){
						C.log('正在被读取,不显示浮动操作栏',target);
						value.setPosition();
						return;
					};
				};

					var allMagFiles=MagnifierObj.all;//被放大镜盯上的图片,不要显示浮动栏.
					for(var i=0,ii=allMagFiles.length,value ; i<ii ; i++){
						value=allMagFiles[i];
						if(value.target==target){
							C.log('目标被放大镜盯上了,不显示浮动操作栏',target);
							return;
						};
					};

				this.out(target);
				this.buttonSwitch();

				//返回上一个显示的图片上面,并且返回之前工具栏依然显示,那么保持显示.
				if(target==this.preTarget && this.floatBar.style.visibility=='visible'){
					C.log('返回上一次显示的对象:',target);
					this.show();
				}else{
					this.showDelay();
				};
			},
			out:function(target){
				var self=this;
				function imgOut(e){
					this.removeEventListener('mouseout',imgOut,false);
					if(self.floatBar.style.visibility=='hidden'){//如果本来就是隐藏的,那让它继续就那么藏着.
						clearTimeout(self.showTimer);
						return;
					};
					self.hideDelay();//否则启用延时消失.
				};
				target.addEventListener('mouseout',imgOut,false);
			},
			hide:function(){
				this.floatBar.style.visibility='hidden';
			},
			hideDelay:function(){
				var self=this;
				clearTimeout(this.hideTimer);
				this.hideTimer=setTimeout(function(){
					self.hide();
				},prefs.floatBar.hideDelay);
			},
			load:function(type,e){
				this.hide();
				new LoadingAnim(type=='current'? this.tSrc : this.src , this.target , type , e && e.ctrlKey);
			},
			isOpened:function(src){
				if(!prefs.multipleInstance.oneSrcOneInstance)return;
				var all=PicObj.all;
				src=src || this.src;
				for(var i=0,ii=all.length,othis;i<ii;i++){//看看是否已经是打开的图片,检测src是否一样,如果是打开的话,直接带到最前面.
					othis=all[i];
					if(src==othis.src){
						C.log('已经打开了的图片',src);
						othis.focus();
						othis.verticalCenter();
						othis.borderFlash();
						return true;
					};
				};
			},
			addStyle:function(){
				var style=document.createElement('style');
				style.type='text/css';
				style.textContent='\
					#pv_float-bar{\
						width:auto;\
						height:auto;\
						border:none;\
						margin:0;\
						padding:2px;\
						position:absolute;\
						z-index:99999;\
						opacity:0.8;\
						visibility:hidden;\
						-o-transition:opacity 0.2s ease-in-out;\
						-moz-transition:opacity 0.2s ease-in-out;\
						-webkit-transition:opacity 0.2s ease-in-out;\
						transition:opacity 0.2s ease-in-out;\
					}\
					#pv_float-bar:hover{\
						opacity:1;\
					}\
					#pv_float-bar-viewori{\
						background-image:url("'+prefs.icons.actualSize+'");\
					}\
					#pv_float-bar-magnifier{\
						background-image:url("'+prefs.icons.magnifier+'");\
					}\
					#pv_float-bar-viewcur{\
						background-image:url("'+prefs.icons.noZoom+'");\
					}\
					#pv_float-bar > span{\
						cursor:pointer;\
						float:left;\
						height:22px;\
						width:24px;\
						margin:0 5px 0 0;\
						border:none;\
						padding:0;\
						background-position:0 0;\
						background-repeat:no-repeat;\
						-o-transition:background-position 0.2s ease-in-out;\
						-moz-transition:background-position 0.2s ease-in-out;\
						-webkit-transition:background-position 0.2s ease-in-out;\
						transition:background-position 0.2s ease-in-out;\
					}\
					#pv_float-bar > span:last-child{\
						margin-right:0!important;\
					}\
					#pv_float-bar > span:hover{\
						background-position:-25px 0;\
					}\
					#pv_float-bar > span:active{\
						background-position:-50px 0;\
					}\
				';
				G_container.appendChild(style);
			},
			init:function(){
				this.addStyle();
				var floatBar=document.createElement('span');
				this.floatBar=floatBar;
				floatBar.id='pv_float-bar';

				var floatBar_viewOri=document.createElement('span');
				this.floatBar_viewOri=floatBar_viewOri;
				floatBar_viewOri.id='pv_float-bar-viewori';
				floatBar_viewOri.title='查看原始图片';

				var floatBar_magnifier=document.createElement('span');
				this.floatBar_magnifier=floatBar_magnifier;
				floatBar_magnifier.id='pv_float-bar-magnifier';
				floatBar_magnifier.title='放大镜';

				var floatBar_viewCur=document.createElement('span');
				this.floatBar_viewCur=floatBar_viewCur;
				floatBar_viewCur.id='pv_float-bar-viewcur';
				floatBar_viewCur.title='当前图片弹出查看';

				floatBar.appendChild(floatBar_viewOri);
				floatBar.appendChild(floatBar_viewCur);
				floatBar.appendChild(floatBar_magnifier);


				var self=this;

				var mEnterHandler=function(){
					clearTimeout(self.hideTimer);
				};

				if(support.mouseenter){
					floatBar.addEventListener('mouseenter',mEnterHandler,false);
				}else{
					addCustomEvent.mouseenter(floatBar,mEnterHandler);
				};


				var mLeaveHandler=function(){
					self.hideDelay();
				};

				if(support.mouseleave){
					floatBar.addEventListener('mouseleave',mLeaveHandler,false);
				}else{
					addCustomEvent.mouseleave(floatBar,mLeaveHandler);
				};


				floatBar_viewOri.addEventListener('click',function(e){//查看原图
					e.preventDefault();
					if(self.isOpened())return;
					self.load('original',e);//载入图片.
				},false);

				floatBar_magnifier.addEventListener('click',function(e){//放大镜
					e.preventDefault();
					self.load('magnifier',e);//载入图片.
				},false);

				floatBar_viewCur.addEventListener('click',function(e){//弹出当前图片.
					e.preventDefault();
					if(self.isOpened(self.tSrc))return;
					self.load('current',e);//载入图片.
				},false);


				var rstoHandler=function(){
					if(floatBar.style.visibility!='hidden'){
						self.setPosition();
					};
				};

				var resizeTimer;
				window.addEventListener('resize',function(){
					clearTimeout(resizeTimer);
					resizeTimer=setTimeout(rstoHandler,299);
				},false);

/*
				var scrollTimer;
				window.addEventListener('scroll',function(e){
					clearTimeout(scrollTimer);
					scrollTimer=setTimeout(rstoHandler,299);
				},false);
*/
				G_container.appendChild(floatBar);
			},
		};


		//xpath 获取单个元素
		function getElementByXpath(xpath,contextNode,doc){
			doc=doc || document;
			contextNode=contextNode || doc;
			return doc.evaluate(xpath,contextNode,null,9,null).singleNodeValue;
		};


		//获取位置
		function getTargetImgPosition(target){
			var target=target;
			var rect=target.getBoundingClientRect();
			var compStyle=getComputedStyle(target,'');
			var pInt=parseInt;
			var t=rect.top + pInt(compStyle.paddingTop) + pInt(compStyle.borderTopWidth);
			var l=rect.left + pInt(compStyle.paddingLeft) + pInt(compStyle.borderLeftWidth);
			var r=rect.right - pInt(compStyle.paddingRight) - pInt(compStyle.borderRightWidth);
			var b=rect.bottom - pInt(compStyle.paddingBottom) - pInt(compStyle.borderBottomWidth);
			var scrollXY=getWindowScrollXY();
			return {
				t:t,
				l:l,
				r:r,
				b:b,
				top: t + scrollXY.y,
				left: l + scrollXY.x,
				right: r + scrollXY.x,
				bottom: b + scrollXY.y,
			};
		};

		//获取窗口大小.
		function getWindowSize(){
			var de=document.documentElement;
			//windo.innerHeight;window.innerWidth;
			return {
				h:document.compatMode=='BackCompat'? document.body.clientHeight : de.clientHeight,
				w:de.clientWidth,
			};
		};

		//bind fn
		var fnBind=(function(){
			var slice = Array.prototype.slice;
			return {
				bind: function( fun, thisp ) {
					var args = slice.call(arguments, 2);
					return function() {
						return fun.apply(thisp, args.concat(slice.call(arguments)));
					}
				},
				bindAsEventListener: function( fun, thisp ) {
					var args = slice.call(arguments, 2);
					return function(event) {
						return fun.apply(thisp, [event].concat(args));
					}
				}
			};
		})();

		function xToString(x){//任何转字符串.
			function toStr(x){
				//alert(typeof x);
				switch(typeof x){
					case 'undefined':{
						return Str(x);
					}break;
					case 'boolean':{
						return Str(x);
					}break;
					case 'number':{
						return Str(x);
					}break;
					case 'string':{
						return ('"'+
							(x.replace(/(?:\r\n|\n|\r|\t|\\|")/g,function(a){
								var ret; 
								switch(a){//转成字面量
									case '\r\n':{
										ret='\\r\\n'
									}break;
									case '\n':{
										ret='\\n';
									}break;
									case '\r':{
										ret='\\r'
									}break;
									case '\t':{
										ret='\\t'
									}break;
									case '\\':{
										ret='\\\\'
									}break;
									case '"':{
										ret='\\"'
									}break;
									default:{
									}break; 
								};
								return ret;
							}))+'"');
					}break;
					case 'function':{
						/*
						var fnName=x.name;
						if(fnName && fnName!='anonymous'){
							return x.name;
						}else{
							var fnStr=Str(x);
							return fnStr.indexOf('native code')==-1? fnStr : 'function(){}';
						};
						*/
						var fnStr=Str(x);
						return fnStr.indexOf('native code')==-1? fnStr : 'function(){}';
					}break;
					case 'object':{//注,object的除了单纯{},其他的对象的属性会造成丢失..
						if(x===null){
							return Str(x);
						};
						//alert(x.constructor);
						switch(x.constructor){
							case Object:{
								var i;
								var tempArray=[];
								for(i in x){
									//alert(i);
									if(x.hasOwnProperty(i)){//去掉原型链上的属性.
										tempArray.push(toStr(i)+':'+toStr(x[i]));
									};
								};
								return ('{' + tempArray.join(',') + '}');
							}break;
							case Array:{
								var i;
								var tempArray=[];
								for(i in x){
									//alert(i);
									if(x.hasOwnProperty(i)){//去掉原型链上的属性.
										tempArray.push(toStr(x[i]));
									};
								};
								return ('[' + tempArray.join(',') + ']');
							}break;
							case String:{
								return toStr(Str(x));
							}break;
							case RegExp:{
								return Str(x);
							}break;
							case Number:{
								return Str(x);
							}break;
							case Boolean:{
								return Str(x);
							}break;
							default:{
								//alert(x.constructor);//漏了什么类型么?
							}break;
						};
					}break;
					default:break;
				};
			};
			var Str=String;
			return toStr(x);
		};

		var matchedRule;
		var URL=location.href;

		var floatBar;

		function getDisIS(target){//获取页面上显示的图片的宽 高.
			var iCS=getComputedStyle(target,'');
			var pInt=parseInt;
			return {
				h:pInt(iCS.height),
				w:pInt(iCS.width),
			};
		};

		function getIAS(img){//获取显示图片的实际尺寸.
			var ret={};
			if(support.naturalWHS){
				ret.h=img.naturalHeight;
				ret.w=img.naturalWidth;
			}else{
				var cloneImg=new Image();
				cloneImg.src=img.src;
				ret.h=cloneImg.height;
				ret.w=cloneImg.width;
			};
			return ret;
		};

		function moverhandler(e){
			var target=e.target;
			if(target.nodeName!='IMG')return;
			if(target.className=='pv_pic'){//已经打开的图片.
				return;
			};
			var imgPA=getElementByXpath('./ancestor::a[1]',target);//img的第一个父A元素,也就是连接,其实第一个只是针对opera来说的,因为只有在opera上才能有两个以上的a元素,其他浏览器会被当做错误被纠正.-_-!!~

			if(matchedRule===undefined){//找到符合站点的高级规则,并缓存.
				matchedRule=false;
				for(var i=0,ii=siteInfo.length,siteInfo_i;i<ii;i++){
					siteInfo_i=siteInfo[i];
					if(siteInfo_i.enabled && siteInfo_i.url && siteInfo_i.url.test(URL)){
						matchedRule=siteInfo_i;
						C.log('匹配的站点规则:',matchedRule);
						break;
					};
				};
			};

			var src;
			var noZoom;

			if(matchedRule){//通过高级规则获取.
				try{
					src=matchedRule.getImage.call(target,target,imgPA);
				}catch(e){
				};
			};
			if(!src){//遍历统配规则.
				for(var i=0,ii=tprules.length;i<ii;i++){
					try{
						src=tprules[i].call(target,target,imgPA);
					if(src){
						C.log('匹配的统配规则:',tprules[i]);
						break;
					};
					}catch(e){
					};
				};
			};
			if(!src){//链接可能是一张图片...
				if(imgPA){
					var iPASrc=imgPA.href;
					if(/\.(?:jpg|jpeg|png|gif|bmp)$/i.test(iPASrc)){
						src=iPASrc;
					};
				};
			};
			if(!src){//本图片是否被缩放.
				var imgAS=getIAS(target);//实际尺寸
				C.log('图片实际尺寸:',imgAS);
				var imgCS=getDisIS(target);
				C.log('显示尺寸:',imgCS);
				if(!(imgAS.w==imgCS.w && imgAS.h==imgCS.h)){//如果不是两者完全相等,那么被缩放了.
					if(imgAS.h > prefs.zoomShowMinSizeLimit.h || imgAS.w > prefs.zoomShowMinSizeLimit.w){//最小限定判断.
						src=target.src;
					};
				}else{
					if(prefs.floatBarForceShow.enabled && (imgCS.w>=prefs.floatBarForceShow.size.w && imgCS.h>=prefs.floatBarForceShow.size.h)){
						noZoom=true;
						src=target.src;
					};
				};
			};
			if(src){//如果存在src那么现实浮动栏.
				C.log('发现的图片地址:',src);
				if(!floatBar){
					floatBar=new FloatBarObj();
				};
				floatBar.over(target,e,src,noZoom);
			};
		};


		var openInTopWindow;
		var topWindowExist;
		if(window.postMessage && prefs.iframePicOpenInTopWindow){
			if(window==window.parent){//顶层窗口.
				window.addEventListener('message',function(e){
					var data=e.data;
					if(typeof data!='string' || data.indexOf('from_pv_frame_window:')==-1)return;
					e.source.postMessage('from_pv_top_window:'+'get','*');
					data=data.slice(data.indexOf(':')+1);
					data=eval('('+ data +')');
					if(FloatBarObj.prototype.isOpened(data.src))return;
					var img=new Image();
					img.src=data.src;
					var run;
					function load(){
						if(run)return;
						run=true;
						new PicObj(data.src,img,data.size);
					};
					imgReady(img,load,data.waitImgLoad?  null : load);
				},false);
			};

			if(window!=window.parent && window.parent){//chrome中脚本运行在iframe里面时,window.top,window.parent返回undefined
				openInTopWindow=true;
				var messageHandler=function(e){
					var data=e.data;
					if(typeof data!='string' || data.indexOf('from_pv_top_window:')==-1)return;
					window.removeEventListener('message',messageHandler,false);
					topWindowExist=true;
				};
				window.addEventListener('message',messageHandler,false);
			};
		};

		//监听 mouseover
		document.addEventListener('mouseover',moverhandler,true);
	};

	if(envir.opera){
		document.addEventListener('DOMContentLoaded',init,false);
	}else{
		init();
	};


})(this,window,window.document);