// ==UserScript==
// @name            url-addon-bar
// @namespace       url-addon-bar.uc@zbinlin
// @description     将附加组件栏移到地址栏
// @include         chrome://browser/content/browser.xul
// @author          zbinlin
// @homepage        http://www.czcp.co.cc
// @version         0.0.2 将地址栏的附加组件栏背景改为透明
// @version         0.0.1
// ==/UserScript==

if (location == "chrome://browser/content/browser.xul") {
    (function (win) {
        function $(id) {
            return document.getElementById(id);
        }
        var cssStr = (<><![CDATA[
@namespace url(http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul);

#urlbar-icons > #addon-bar > .toolbarbutton-1 > .toolbarbutton-menubutton-dropmarker,
#urlbar-icons > #addon-bar > .toolbarbutton-1 > .toolbarbutton-menu-dropmarker,
#urlbar-icons #mproxy-toolbar-button > .toolbarbutton-menu-dropmarker {
    display: none !important;
}

#urlbar-icons > #addon-bar {
    -moz-appearance: none !important;
    height: 18px !important;
    min-height: 18px !important;
    border-style: none !important;
    background-color: transparent !important;
}

#urlbar-icons > #addon-bar toolbarbutton,
#urlbar-icons > #addon-bar > #status-bar statusbarpanel {
    border-style: none !important;
    height: 18px !important;
    min-width: 18px !important;
    min-height: 18px !important;
    padding: 0 1.5px !important;
    margin: 0 0.5px !important;
}

#urlbar-icons > #addon-bar > #status-bar statusbarpanel:first-child {
    padding-left: 0 !important;
    margin-left: 0 !important;
}
#urlbar-icons > #addon-bar > #status-bar statusbarpanel:last-child {
    padding-right: 0 !important;
    margin-right: 0 !important;
}

#urlbar-icons > #addon-bar > #status-bar {
    padding: 0 1.5px !important;
    margin: 0 0.5px !important;
}

#urlbar-icons > #addon-bar toolbarspring {
    display: none !important;
}
        ]]></>).toString();
        var style = document.createProcessingInstruction("xml-stylesheet", "title=\"url-addon-bar\" type=\"text/css\"" + " href=\"data:text/css;base64," + btoa(cssStr) + "\"");
        var main = $("main-window");
        document.insertBefore(style, main);
        var urlbarIcons = $("urlbar-icons");
        var addonBar = $("addon-bar");
        var browserBottombox = $("browser-bottombox");
        var closeButton = $("addonbar-closebutton");
        win.urlAddonBar = {
            init: function () {
                closeButton.setAttribute("onclick", "urlAddonBar.toggleUA(event);");
                urlbarIcons.insertBefore(addonBar, urlbarIcons.firstChild);
                addonBar.setAttribute("data-inub", "true");
                addonBar.removeAttribute("context");
                addonBar.removeAttribute("toolboxid");
            },
            toggleUA: function (e) {
                if (e.button != 1) return;
                if (addonBar.getAttribute("data-inub") == "true") {
                    browserBottombox.appendChild(addonBar);
                    addonBar.setAttribute("data-inub", "false");
                    addonBar.setAttribute("context", "toolbar-context-menu");
                    addonBar.setAttribute("toolboxid", "navigator-toolbox");
                } else {
                    urlbarIcons.insertBefore(addonBar, urlbarIcons.firstChild);
                    addonBar.setAttribute("data-inub", "true");
                    addonBar.removeAttribute("context");
                    addonBar.removeAttribute("toolboxid");
                }
            }
        };
        win.urlAddonBar.init();
    })(this);
}
