


//
//	The Maria Basic Interpreter Written by Dzinleski Jasenko Jun,2005 and later
//					Copyright (C) 2005 and later Jasenko Dzinleski 
//
//	This source and the mariaBasic interpreter apply to GNU General Public License. 
//					
//
//		This program is free software; you can redistribute it
//	and/or modify it under the terms of the GNU General Public License as
//	published by the Free Software Foundation; either version 2 of the
//	License, or (at your option) any later version. 
//
//	This program is distributed in the hope that it will be useful, but
//	WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
//	General Public License for more details. 
//
//	You should have received a copy of the GNU General Public License along
//	with this program; if not, write to the Free Software Foundation, Inc.,
//	51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.


//  			The MariaBasic Interpreter
//
//     			to my daughter Maria Dzinleska




#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#define		plinel		256
#define		vnaml		64
#define		maxv		300

#define		mc		27

FILE		*fout;
bool		of=false;

//1-string,2-int,3-long int,4-double

int			linen=0;

char			varnl[maxv][vnaml];
int			tarv[maxv][2];						
int			vi=0;

char			cvarv[maxv][plinel];
int			ci=0;

long			nvarv[maxv][2];
int			ni=0;

double			dvarv[maxv];
int			dni=0;

FILE			*fp;
FILE			*fvars[maxv];
long			fvarp[maxv];
int			fvarc[maxv];
char			fvarn[maxv][plinel];
int			fni=0;

//1 ^,2 *,3 /,4 + ,5 -,6 =

double			opa[vnaml][2];
int			opi=0;

char			kw[maxv][vnaml];
char			pf[maxv][plinel];

char			fw[maxv][vnaml];

//0 line number
//1 execution type #1 
//2 execution type #2 
//3 execution type #3 
//4 execution type #4 
//5 execution type #5 

//Execution types:
//1 execute command
//3 inside if block execute command
//2 inside loop block execute command
//4 inside sub block routine execute command
//5 inside loop block execute command

//13 (re)parse if command
//12 (re)parse loop command 
//14 (re)parse sub command 
//15 (re)parse loop command


int			ri[maxv][7];
int			iri=0;
int			eri=0;

//0 - op1, 1 - op2, 2 - loop_oper, 3 - eval line#, 4 - exit line#, 5 - incr/comp1_op_index, 6 - incr/comp1_op_type 7 - comp2_op_index, 8 - comp2_op_type, 9 - nesting sub/type
//loop_oper: 0 =,1 >,2 <,3 >=,4 <=
 
long		nri[maxv][10];
int			inri=0;
long		cv[10];
int			cvi;
long		iv[10][2];

char		rout[10][vnaml];
int			irout=0;

char		csL[plinel];
char		csR[plinel];

//
char	r_s[50][plinel];	int	r_si=0;
//
char	*b_var_n="{[az][09][__][AZ][#&]}{=}{[09][..][--][++][,,]}";
char	*b_var_s="{[az][09][__][AZ][$$]}{=}{['\'''\'']['\"''\"']}{[  ][AZ][az][09][..]}{['\'''\'']['\"''\"']}";
//
char	*b_for="{for}{ }{[az][09][__][AZ][#&]}{=}{[09][..]}{ }{to}{ }{[09][..]}";
char	*b_for_1="{for}{ }{[az][09][__][AZ][#&]}{=}{[az][09][__][AZ][#&]}{ }{to}{ }{[09][..]}";
char	*b_for_2="{for}{ }{[az][09][__][AZ][#&]}{=}{[az][09][__][AZ][#&]}{ }{to}{ }{[az][09][__][AZ][#&]}";
char	*b_for_3="{for}{ }{[az][09][__][AZ][#&]}{=}{[09][..]}{ }{to}{ }{[az][09][__][AZ][#&]}";
//
char	*b_while="{while (}{[az][09][__][AZ][#&]}{[==][>>][<<]}{[09][..]}{)}";
char	*b_while_1="{while (}{[az][09][__][AZ][#&]}{[==][>>][<<]}{[az][09][__][AZ][#&]}{)}";
//
char	*b_if="{if}{ (}{[az][09][__][AZ][#&]}{[==][>>][<<]}{[az][09][__][AZ][#&]}{) }{then}";
char	*b_if_1="{if}{ (}{[az][09][__][AZ][#&]}{[==][>>][<<]}{[09][..]}{) }{then}";
//
char	*b_mid="{[az][09][__][AZ][#&]}{=}{mid$(}{[az][09][__][AZ][#&]}{,}{[az][09][__][AZ]}{[#&]}{,}{[az][09][__][AZ]}{[#&]}{)}";
//
char	*b_trim="{[az][09][__][AZ][#&]}{=}{trim$(}{[az][09][__][AZ][#&]}{)}";
//
char	*b_left="{[az][09][__][AZ][#&]}{=}{left$(}{[az][09][__][AZ][#&]}{,}{[09][..]}{)}";
//
char	*b_right="{[az][09][__][AZ][#&]}{=}{right$(}{[az][09][__][AZ][#&]}{,}{[09][..]}{)}";
//
char	*b_len="{[az][09][__][AZ][#&]}{=}{len$(}{[az][09][__][AZ][#&]}{)}";
//
char	*b_val="{[az][09][__][AZ][#&]}{=}{val$(}{[az][09][__][AZ][#&]}{)}";
//
char	*b_round="{[az][09][__][AZ][#&]}{=}{round$(}{[az][09][__][AZ][#&]}{)}";
//
char	*b_format="{[az][09][__][AZ][#&]}{=}{format$(}{[az][09][__][AZ][#&]}{,}{['\'''\'']['\"''\"']}{[--][#&][  ][09][..][,,]}{['\'''\'']['\"''\"']}{)}";
//
char	*b_fopen_i="{open}{ }{[az][09][__][AZ][$$]}{ }{for input}{ }{as}{ }{#}{[09]}";
char	*b_fopen_o="{open}{ }{[az][09][__][AZ][$$]}{ }{for output}{ }{as}{ }{#}{[09]}";
char	*b_finput="{input}{ }{#}{[09]}{,}{[az][09][__][AZ][#&]}";
char	*b_fprint="{print}{ }{#}{[09]}{,}{[az][09][__][AZ][#&]}";
char	*b_fclose="{close}{ }{#}{[09]}";
//
char	*b_l_exp="{[az][09][__][AZ][#&]}{=(}{[az][09][__][AZ][#&]}{[==][>>][<<]}{[az][09][__][AZ][#&]}{ }{[az]}{ }{[az][09][__][AZ][#&]}{[==][>>][<<]}{[az][09][__][AZ][#&]}{)}";
//
//
char	*p_exp="{[az][09][__][AZ]}{[$$][##][%%][&&]}{[==][((]}{['\'''\'']['\"''\"'][..][az][09][__][AZ][++][--]}{[$$][##][%%][&&]}{[++][--][//][**][^^][==][>>][<<]}";
//


int	c_p(char cl_a[256],int ci,bool tf,char r_a[256])
{

	int		a,b,c,d=0;
	
	for(a=0;a<256;++a){r_a[a]='\0';}

	if(tf)
	{
		for(a=0;a<strlen(cl_a);++a){
			if(cl_a[a]=='{'){++d;for(b=a+1;b<strlen(cl_a);++b){if(cl_a[b]=='}'){if(d==ci){break;}}}}
			if(b!=strlen(cl_a)){break;}
		}

	}else{
		for(a=0;a<strlen(cl_a);++a){
			if(cl_a[a]=='['){++d;for(b=a+1;b<strlen(cl_a);++b){if(cl_a[b]==']'){if(d==ci){break;}}}}
			if(b!=strlen(cl_a)){break;}
		}

	}

	d=0;for(c=a+1;c<b;++c){r_a[d]=cl_a[c];++d;/*printf("%c",cl_a[c]);*/}

	if(b==strlen(cl_a)){return(1);}else{return(0);}

}

int p_syntax_(char i_l[plinel],char c_l[plinel])
{

	int			a,b,c,ci,d;
	int			i,j,k,l,m,r,s;

	char		c_1[256];
	char		c_2[256];

	char		fn[10][2];	int	fi=0;

	int			op=0,si=1,ssi=1,i_li=0;

	
	r_si=0;
	while(si<99)
	{

		ci=si;
		for(i=0;i<256;++i){c_1[i]='\0';}
		s=c_p(c_l,ci,true,c_1);
		//for(i=0;i<strlen(c_1);++i){printf("%c",c_1[i]);}

		for(i=0;i<strlen(c_1);++i){if(c_1[i]=='['){break;}}
		if(i!=strlen(c_1))
		{
			fi=0;
			while(ssi<99)
			{
				ci=ssi;
				for(i=0;i<256;++i){c_2[i]='\0';}
				r=c_p(c_1,ci,false,c_2);
				//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}
				fn[fi][0]=c_2[0];fn[fi][1]=c_2[1];++fi;
				if(r==1){break;}else{++ssi;}
			}

			k=0;ssi=1;
			for(i=0;i<256;++i){r_s[r_si][i]='\0';}
			for(i=i_li;i<strlen(i_l);++i)
			{
				for(j=0;j<fi;++j)
				{
					if(((int)i_l[i]>=(int)fn[j][0])&&((int)i_l[i]<=(int)fn[j][1])){break;}
				}
				if(j!=fi){r_s[r_si][k]=i_l[i];++k;}else{break;}
			}
			++r_si;
			i_li=i;

		}else{

			for(i=0;i<256;++i){r_s[r_si][i]='\0';}
			j=0;for(i=0;i<strlen(c_1);++i){if(i_l[i_li]!=c_1[i]){break;}else{r_s[r_si][j]=c_1[i];++j;}++i_li;}
			++r_si;

		}
		if(s==1){break;}else{++si;}
	}	

	/*
	printf("??%s??\n",r_s[0]);
	printf("??%s??\n",r_s[1]);
	printf("??%s??\n",r_s[2]);
	printf("??%s??\n",r_s[3]);
	printf("??%s??\n",r_s[4]);
	printf("??%s??\n",r_s[5]);
	printf("??%s??\n",r_s[6]);
	printf("??%s??\n",r_s[7]);
	printf("??%s??\n",r_s[8]);
	printf("??%s??\n",r_s[9]);
	printf("??%s??\n",r_s[10]);
	printf("??%s??\n",r_s[11]);
	*/

	return(0);

}

int p_format(double in_n,char fm[plinel],char arr0[plinel])
{

int		sig;
char		arr1[256];
double 		iv,fv;
__int64	lv,rv;
char		fa[256];int	fai=0;
int		i,j,k,l,m,n,e;


	if(in_n<0){sig=1;in_n*=-1.0;iv=in_n;}else{sig=0;iv=in_n;}

	for(i=0;i<256;++i){fa[i]='\0';}fai=0;
	for(j=0;j<plinel;++j){arr0[j]='\0';}

	for(i=1;i<12;++i)
	{
		lv=(long)iv/pow(10,i);//printf("%d %d %d\n",lv,i,(long)pow(10,i));
		if(lv==0){e=i-1;break;}
	}
	if(i==12){printf("Overflow...\n");arr0[0]='0';return(0);}

	if(e-1<0)
	{
		rv=(long)iv/pow(10,e);//printf("!%c",(char)(48+rv));
		fa[fai]=(char)(48+rv);++fai;

	}else{

	rv=(long)iv/pow(10,e);//printf("!%c",(char)(48+rv));
	fa[fai]=(char)(48+rv);++fai;
	rv*=pow(10,e);fv=(long)iv-rv;
	for(i=e-1;i>=0;--i)
	{
		lv=(long)fv/pow(10,i);//printf("!%c",(char)(48+lv));
		fa[fai]=(char)(48+lv);++fai;
		rv+=lv*pow(10,i);fv=iv;fv-=rv;
	}

	}

	//printf("%s\n",fa);

	if(strlen(fm)!=0)
	{

		m=0;l=strlen(fm);
		for(i=strlen(fm)-1;i>=0;--i)
		{if(fm[i]==','||fm[i]=='.'){if(l==strlen(fm)){l=i+1;++m;}else{++m;}}}
		k=(strlen(fm)-((strlen(fm)-l)+m))-strlen(fa);

		if(k>=0)
		{

			j=0;for(i=0;i<k;++i)
			{if(fm[i]=='.'||fm[i]==','){++k;}arr0[j]=fm[i];++j;}n=i;

			for(i=0;i<strlen(fa);++i)
			{
				if(fm[i+n]=='.'||fm[i+n]==','){arr0[j]=fm[i+n];++j;++n;}
				arr0[j]=fa[i];++j;
			}
				
			if(l!=strlen(fm))
			{
				--l;arr0[j]=fm[l];++j;
				for(i=l+1;i<strlen(fm);++i){arr0[j]=fm[i];++j;}

				iv=in_n;
				for(i=0;i<256;++i){fa[i]='\0';}fai=0;

				iv=pow(10,(strlen(fm)-(l+1)))*(iv-(double)((long)iv));

				for(i=1;i<12;++i)
				{
					lv=(long)iv/pow(10,i);//printf("%d %d %d\n",lv,i,(long)pow(10,i));
					if(lv==0){e=i-1;break;}
				}
				if(i==12){printf("Overflow...\n");arr0[0]='0';return(0);}

				if(e-1<0)
				{
					rv=(long)iv/pow(10,e);//printf("!%c",(char)(48+rv));
					fa[fai]=(char)(48+rv);++fai;

				}else{

				rv=(long)iv/pow(10,e);//printf("!%c",(char)(48+rv));
				fa[fai]=(char)(48+rv);++fai;
				rv*=pow(10,e);fv=(long)iv-rv;
				for(i=e-1;i>=0;--i)
				{
					lv=(long)fv/pow(10,i);//printf("!%c",(char)(48+lv));
					fa[fai]=(char)(48+lv);++fai;
					rv+=lv*pow(10,i);fv=iv;fv-=rv;
				}

				}

				//printf("s\n",fa);

				if((strlen(fm)-(l+1))==strlen(fa))
				{

				for(i=strlen(arr0)-1;i>=0;--i)
				{if(arr0[i]=='.'||arr0[i]==','){j=i;break;}}++j;
				for(i=0;i<strlen(fa);++i){arr0[j]=fa[i];++j;}

				}else{

					k=(strlen(fm)-(l+1))-strlen(fa);
					for(i=strlen(arr0)-1;i>=0;--i)
					{if(arr0[i]=='.'||arr0[i]==','){j=i;break;}}++j;
					for(i=0;i<k;++i){arr0[j]='0';++j;}
					for(i=0;i<strlen(fa);++i){arr0[j]=fa[i];++j;}

				}

			}

		}else{

			k=strlen(fa)-(strlen(fm)-((strlen(fm)-l)+m));
			j=0;for(i=0;i<k;++i){arr0[j]=fa[i];++j;}n=i;
			
			for(i=n;i<strlen(fa);++i)
			{
				if(fm[i-n]=='.'||fm[i-n]==','){arr0[j]=fm[i-n];++j;--n;}
				arr0[j]=fa[i];++j;
			}

			if(l!=strlen(fm))
			{
				--l;arr0[j]=fm[l];++j;
				for(i=l+1;i<strlen(fm);++i){arr0[j]=fm[i];++j;}

				iv=in_n;
				for(i=0;i<256;++i){fa[i]='\0';}fai=0;

				iv=pow(10,(strlen(fm)-(l+1)))*(iv-(double)((long)iv));

				for(i=1;i<12;++i)
				{
					lv=(long)iv/pow(10,i);//printf("%d %d %d\n",lv,i,(long)pow(10,i));
					if(lv==0){e=i-1;break;}
				}
				if(i==12){printf("Overflow...\n");arr0[0]='0';return(0);}

				if(e-1<0)
				{
					rv=(long)iv/pow(10,e);//printf("!%c",(char)(48+rv));
					fa[fai]=(char)(48+rv);++fai;

				}else{

				rv=(long)iv/pow(10,e);//printf("!%c",(char)(48+rv));
				fa[fai]=(char)(48+rv);++fai;
				rv*=pow(10,e);fv=(long)iv-rv;
				for(i=e-1;i>=0;--i)
				{
					lv=(long)fv/pow(10,i);//printf("!%c",(char)(48+lv));
					fa[fai]=(char)(48+lv);++fai;
					rv+=lv*pow(10,i);fv=iv;fv-=rv;
				}

				}

				//printf("s\n",fa);

				if((strlen(fm)-(l+1))==strlen(fa))
				{

				for(i=strlen(arr0)-1;i>=0;--i)
				{if(arr0[i]=='.'||arr0[i]==','){j=i;break;}}++j;
				for(i=0;i<strlen(fa);++i){arr0[j]=fa[i];++j;}

				}else{

					k=(strlen(fm)-(l+1))-strlen(fa);
					for(i=strlen(arr0)-1;i>=0;--i)
					{if(arr0[i]=='.'||arr0[i]==','){j=i;break;}}++j;
					for(i=0;i<k;++i){arr0[j]='0';++j;}
					for(i=0;i<strlen(fa);++i){arr0[j]=fa[i];++j;}

				}
				
			}

		}

	}else{

		j=0;for(i=0;i<strlen(fa);++i){arr0[j]=fa[i];++j;}

	}

	for(i=0;i<strlen(arr0);++i){if(arr0[i]=='#'){arr0[i]=' ';}}
	for(i=0;i<strlen(arr0)-1;++i){if((arr0[i]==' ')&&(arr0[i+1]==','||arr0[i+1]=='.')){arr0[i+1]=' ';}}

	if(sig==1)
	{
		for(i=0;i<256;++i){arr1[i]='\0';}
		j=0;arr1[j]='-';++j;
		for(i=0;i<strlen(arr0);++i){arr1[j]=arr0[i];++j;}
		for(i=0;i<256;++i){arr0[i]='\0';}
		j=0;for(i=0;i<strlen(arr1);++i){arr0[j]=arr1[i];++j;}
	}

	//printf("%s\n",arr0);

	return(0);
}

double p_val(char arr0[256])
{
	int	sig=0;
	int	j=0,k=0,l;

	long		fr;
	int		rvi;
	long		rvl;
	__int64	rvd;
	double		rvd_;

	char 		arr1[256];

	for(j=0;j<strlen(arr0);++j){if(arr0[j]=='-'){sig=1;break;}}

	for(j=0;j<256;++j){arr1[j]='\0';}
	l=0;for(j=0;j<strlen(arr0);++j){if((arr0[j]>='0'&&arr0[j]<='9')||(arr0[j]=='.'||arr0[j]==',')){arr1[l]=arr0[j];++l;}}

	for(j=0;j<256;++j){arr0[j]='\0';}l=0;for(j=0;j<strlen(arr1);++j){arr0[l]=arr1[j];++l;}

	for(j=0;j<strlen(arr0);++j){if(arr0[j]=='.'){break;}}

	if(j==strlen(arr0))
	{
		rvl=0;l=-1;
		for(j=-1+strlen(arr0);j>=0;--j)
		{
			++l;rvl+=(long)(-48+arr0[j])*pow(10,l);
		}
		rvi=(int)rvl;
		rvd_=(double)rvl;

	}else{

			fr=0;l=-1;
			for(k=-1+strlen(arr0);k>j;--k)
			{
				++l;fr+=(long)(-48+arr0[k])*pow(10,l);
			}

			rvd=0;l=-1;
			for(k=j-1;k>=0;--k)
			{
				++l;rvd+=(__int64)(-48+arr0[k])*pow(10,l);

			}rvd*=(__int64)pow(10,strlen(arr0)-j-1);

			rvd_=(double)(rvd+(__int64)fr)/(__int64)pow(10,strlen(arr0)-j-1);
				
	}

	if(sig==0){return(rvd_);}else{return(-1.0*rvd_);}

}

double p_round(double basev)
{

	bool	df=false;
	int		ni;

	int		i,j,k,l;

	double	n;

	double	p1,p2,p3,p4;

	char	p_s[plinel];


	n=basev;

	if(df){printf("\n%e\n",n);}

	p_format(n,"0.000000",p_s);

	p1=p_val(p_s);

	p_format(n,"0.00000",p_s);

	for(i=0;i<strlen(p_s);++i){if(p_s[i]=='.'){break;}}
	ni=0;l=2;for(j=i+1+2;j<(i+1+2)+3;++j){ni+=(-48+p_s[j])*pow(10,l);--l;}

	if(df){printf("\nni(1):%d\n",ni);}
	
	if(ni>=500)
	{
		if(p_s[i+1+1]!=9){p_s[i+1+1]+=-48+1;p_s[i+1+1]+=48;for(j=i+1+1+1;j<plinel;++j){p_s[j]='\0';}p_s[i+1+1+1]='0';}else{for(j=i+1+1+1;j<plinel;++j){p_s[j]='\0';}n=((double)1/(double)100)+p_val(p_s);p_format(n,"0.00000",p_s);}
		
	}else{for(j=i+1+1+1;j<plinel;++j){p_s[j]='\0';}p_s[i+1+1+1]='0';}

	if(df){printf("\n%s\n",p_s);}

	for(i=0;i<strlen(p_s);++i){if(p_s[i]=='.'){break;}}
	ni=0;l=1;for(j=i+1;j<(i+1)+2;++j){ni+=(-48+p_s[j])*pow(10,l);--l;}

	if(df){printf("\nni(2):%d\n",ni);}

	if(ni>=50)
	{
		if(p_s[-1+i]!='9'){p_s[-1+i]+=-48+1;p_s[-1+i]+=48;for(j=i+1;j<plinel;++j){p_s[j]='\0';}p_s[i+1]='0';}else{for(j=i+1;j<plinel;++j){p_s[j]='\0';}n=1+p_val(p_s);p_format(n,"0.00000",p_s);}
		
	}else{for(j=i+1;j<plinel;++j){p_s[j]='\0';}p_s[i+1]='0';}

	if(df){printf("\n%s\n",p_s);}

	p2=p_val(p_s);

	return(p2);

}

int p_len(char arr0[plinel])
{
	int		i,j,k=0;

	for (i=-1+plinel;i>=0&&arr0[i]=='\0';--i){}
	for (j=0;j<=i;++j){if(arr0[j]=='\''||arr0[j]=='\"'){++k;}}++i;
	return(i-k);
}

int p_left(char arr0[plinel],int b,char arr1[plinel])
{
	int	i,j,k=0;

	for(i=0;i<plinel;++i){arr1[i]='\0';}
	j=p_len(arr0);
	if((arr0[0]=='\''||arr0[0]=='\"'))
	{
		arr1[k]=arr0[k];++k;
		for (i=1;k-1<b&&i<j;++i){arr1[k]=arr0[i];++k;}arr1[k]='\'';++k;
		if(arr1[-1+k]=='\''){}else{arr1[k]='\'';++k;}
	}else{
		arr1[k]='\'';++k;
		for (i=0;k-1<b&&i<j;++i){arr1[k]=arr0[i];++k;}
		if(arr1[-1+k]=='\''){}else{arr1[k]='\'';++k;}
	}
	return(0);
}

int p_right(char arr0[plinel],int b,char arr1[plinel])
{
	int	i,j,k=0,l;

	for(i=0;i<plinel;++i){arr1[i]='\0';}
	j=p_len(arr0);l=j-b+1;
	if((arr0[0]=='\''||arr0[0]=='\"'))
	{
		arr1[k]=arr0[k];++k;
		for (i=l;k-1<b;++i){arr1[k]=arr0[i];++k;}
		if(arr1[-1+k]=='\''){}else{arr1[k]='\'';++k;}
	}else{
		arr1[k]='\'';++k;
		for (i=l-1;k-1<b;++i){arr1[k]=arr0[i];++k;}
		if(arr1[-1+k]=='\''){}else{arr1[k]='\'';++k;}
	}
	return(0);
}

int p_mid(char arr0[plinel],int a,int b,char arr1[plinel])
{
	char 	p0[plinel];
	char 	p1[plinel];

	int	i,j,k=0,l;

	for(i=0;i<plinel;++i){p0[i]='\0';}
	k=0;for(i=0;i<strlen(arr0);++i){p0[k]=arr0[i];++k;}
	j=p_len(p0);l=j-a+1;
	for(i=0;i<plinel;++i){p1[i]='\0';}
	p_right(p0,l,p1);
	for(i=0;i<plinel;++i){p0[i]='\0';}
	k=0;for(i=0;i<strlen(p1);++i){p0[k]=p1[i];++k;}
	for(i=0;i<plinel;++i){p1[i]='\0';}
	j=p_len(p0);l=j-(j-b);
	p_left(p0,l,p1);
	for(i=0;i<plinel;++i){arr1[i]='\0';}
	k=0;for(i=0;i<strlen(p1);++i){arr1[k]=p1[i];++k;}
	return(0);
}

int p_trim(char arr0[plinel],char arr1[plinel])
{
	int	i,j,k=0,l;
	int	a=0,b=0;

	for(j=0;j<plinel;++j){arr1[j]='\0';}
	j=p_len(arr0);

	if((arr0[0]=='\''||arr0[0]=='\"'))
	{
		k=0;for (i=1;k<j;++i){++k;if(arr0[i]==' '||arr0[i]==(char)9){}else{a=i;break;}}
		k=0;arr1[k]=arr0[k];++k;
	}else{
		k=0;for (i=0;k<j;++i){++k;if(arr0[i]==' '||arr0[i]==(char)9){}else{a=i;break;}}
		k=0;arr1[k]=='\'';++k;
	}

	if(arr0[-1+strlen(arr0)]=='\''||arr0[-1+strlen(arr0)]=='\"')
	{
		for (i=-1+(-1+strlen(arr0));i>=0;--i){if(arr0[i]==' '||arr0[i]==(char)9){}else{b=i;break;}}
		for (i=a;k-1<b-a+1;++i){arr1[k]=arr0[i];++k;}
		if(arr1[-1+k]=='\''){}else{arr1[k]='\'';++k;}
	}else{
		for (i=(-1+strlen(arr0));i>=0;--i){if(arr0[i]==' '||arr0[i]==(char)9){}else{b=i;break;}}
		for (i=a;k-1<b-a+1;++i){arr1[k]=arr0[i];++k;}
		if(arr1[-1+k]=='\''){}else{arr1[k]='\'';++k;}
	}
	return(0);
}

int r_strlen(char arr0[plinel])
{
	int		i,j=0,k=0;

	for (i=0;i<strlen(arr0);++i)
	{
		if 
		(
			(int)arr0[i]>=32&&
			(int)arr0[i]<=255
		)
		{if ((int)arr0[i]==32){++j;}else{++k;}}else{break;}
	}
	return(k+j);
}

int p_strlen(char arr0[plinel])
{
	int	i,j=0,k=0;

	for (i=0;i<strlen(arr0);++i)
	{
		if 
		(
			(int)arr0[i]>=32&&
			(int)arr0[i]<=255
		)
		{if ((int)arr0[i]==32){++j;}else{++k;}}else{break;}
	}
	return(k);
}

int p_comp(char arr1[plinel],char arr2[plinel])
{
	int	i,l1,l2;
	int	rv=0;

	if ((l1=p_strlen(arr1))!=(l2=p_strlen(arr2)))
	{
		if (l1>l2)
		{
			for (i=0;i<l2;++i)
			{
				if (arr1[i]!=arr2[i])
				{
					if (arr1[i]>arr2[i]){rv=3;return(rv);}
					if (arr1[i]<arr2[i]){rv=2;return(rv);}
				}
			}
			return(i);							
		}else{
			for (i=0;i<l1;++i)
			{
				if (arr1[i]!=arr2[i])
				{
					if (arr1[i]>arr2[i]){rv=3;return(rv);}
					if (arr1[i]<arr2[i]){rv=2;return(rv);}
				}
			}
			return(i);					
		}
	}else{
		for (i=0;i<l1;++i)
		{
			if (arr1[i]!=arr2[i])
			{
				if (arr1[i]>arr2[i]){rv=3;return(rv);}
				if (arr1[i]<arr2[i]){rv=2;return(rv);}
			}
		}
		return(1);
	}
}

int p_ccomp(char arr1[plinel],char arr2[plinel],char c_o1,char c_o2)
{
	int	i,l1,l2;
	int	rv=0;

	if ((l1=p_strlen(arr1))!=(l2=p_strlen(arr2)))
	{
		if(c_o1=='<'&&c_o2=='>'){return(1);}
		if(c_o1=='='){return(0);}

		if (l1>l2)
		{
			for (i=0;i<l2;++i)
			{
				if ((int)arr1[i]!=(int)arr2[i])
				{
				if ((int)arr1[i]>(int)arr2[i])
				{
					if(c_o1=='>'){return(1);}else{return(0);}
				}
				if ((int)arr1[i]<(int)arr2[i])
				{
					if(c_o1=='<'){return(1);}else{return(0);}
				}
				}
			}
			if(c_o1=='>'){return(1);}else{return(0);}
						
		}else{
			for (i=0;i<l1;++i)
			{
				if ((int)arr1[i]!=(int)arr2[i])
				{
				if ((int)arr1[i]>(int)arr2[i])
				{
					if(c_o1=='>'){return(1);}else{return(0);}
				}
				if ((int)arr1[i]<(int)arr2[i])
				{
					if(c_o1=='<'){return(1);}else{return(0);}
				}
				}
			}
			if(c_o1=='<'){return(1);}else{return(0);}
	
		}
	}else{
		for (i=0;i<l1;++i)
		{
			if ((int)arr1[i]!=(int)arr2[i])
			{
			if ((int)arr1[i]>(int)arr2[i])
			{
				if(c_o1=='>'){return(1);}else{return(0);}
			}
			if ((int)arr1[i]<(int)arr2[i])
			{
				if(c_o1=='<'){return(1);}else{return(0);}
			}
			}
		}
		if(c_o1=='<'&&c_o2=='>'){return(0);}
		if(c_o1=='='){return(1);}
	}

}

int p_r_s_(int rs_i)
{

int		i,j,k;

char		tvarnl[vnaml];
int		rvi=0;

	for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
	k=0;
	for(j=0;j<strlen(r_s[rs_i]);++j)
	{

		if
		(
			r_s[rs_i][j]=='#'||
			r_s[rs_i][j]=='%'||
			r_s[rs_i][j]=='&'||
			r_s[rs_i][j]=='$'
		)
		{}else{tvarnl[k]=r_s[rs_i][j];++k;}
	
	}
	for(j=0;j<vi;++j)
	{
		if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
	}
	if(j==vi){printf("reference err...%s\n",tvarnl);return(-1);}

	return(rvi);
}

int p_r_s_iv_(int rs_i,int pvi,long pvl,double pvd)
{

int		i,j,k;

char		tvarnl[vnaml];
int		rvi=0;

	for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
	k=0;
	for(j=0;j<strlen(r_s[rs_i]);++j)
	{

		if
		(
			r_s[rs_i][j]=='#'||
			r_s[rs_i][j]=='%'||
			r_s[rs_i][j]=='&'||
			r_s[rs_i][j]=='$'
		)
		{}else{tvarnl[k]=r_s[rs_i][j];++k;}
	
	}
	for(j=0;j<vi;++j)
	{
		if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
	}
	if(j==vi){printf("reference err...%s\n",tvarnl);return(-1);}

	if(tarv[j][1]==2)
	{
		nvarv[tarv[j][0]][0]=pvi;

	}else{
		if(tarv[j][1]==3)
		{
			nvarv[tarv[j][0]][0]=((long)pvl&0xffff0000)>>16;
			nvarv[tarv[j][0]][1]=(long)pvl&0x0000ffff;

		}else{
			if(tarv[j][1]==4)
			{
				dvarv[tarv[j][0]]=(double)pvd;
			}
		}
	}

	return(0);

}

int p_ex(char arr11[plinel],char arr12[plinel])
{
		int		i,j,k,l;
		char		ca[plinel];

		for (i=0;i<strlen(arr11);++i)
		{
			for (k=0;k<plinel;++k){ca[k]='\0';}
			k=0;for (j=i;j<i+strlen(arr12);++j){ca[k]=arr11[j];++k;}
			for (l=0;l<strlen(arr12);++l){if(ca[l]==arr12[l]){}else{break;}}
			if (l==strlen(arr12)){break;}
		}
		if (i!=strlen(arr11)){return(i+strlen(arr12));}
		return(0);
}

void cmput()
{

	int			i,j,k,l;
	double		m;
	double		topa[vnaml][2];
	int			topi=0;


	for(i=0;i<opi-1;++i)
	{
		if(opa[i][1]==5)
		{
			opa[i+1][0]=-1*opa[i+1][0];
			opa[i][1]=4;
		}
	}

	while(opi>1)
	{

		m=-1;for(i=0;i<opi-1;++i){if(m==-1){m=opa[i][1];l=i;}else{if(m>opa[i][1]){m=opa[i][1];l=i;}}}i=l;

		if(m==1)
		{
			opa[i][0]=pow(opa[i][0],opa[i+1][0]);opa[i][1]=opa[i+1][1];opa[i+1][0]=0;opa[i+1][1]=0;
		}

		if(m==2)
		{
			opa[i][0]=opa[i][0]*opa[i+1][0];opa[i][1]=opa[i+1][1];opa[i+1][0]=0;opa[i+1][1]=0;
		}

		if(m==3)
		{
			opa[i][0]=opa[i][0]/opa[i+1][0];opa[i][1]=opa[i+1][1];opa[i+1][0]=0;opa[i+1][1]=0;
		}

		if(m==4)
		{
			opa[i][0]=opa[i][0]+opa[i+1][0];opa[i][1]=opa[i+1][1];opa[i+1][0]=0;opa[i+1][1]=0;
		}

		//if(m==5)
		//{
		//	opa[i][0]=opa[i][0]-opa[i+1][0];opa[i][1]=opa[i+1][1];opa[i+1][0]=0;opa[i+1][1]=0;
		//}

		if(m==6)
		{
			opa[i][0]=opa[i+1][0];opa[i][1]=opa[i+1][1];opa[i+1][0]=0;opa[i+1][1]=0;
		}

		topi=0;
		for(j=0;j<opi;++j)
		{
			if(opa[j][1]!=0)
			{
				topa[topi][0]=opa[j][0];
				topa[topi][1]=opa[j][1];
				++topi;
			}
		}
		opi=topi;
		for(j=0;j<opi;++j)
		{
			opa[j][0]=topa[j][0];
			opa[j][1]=topa[j][1];
		}
	}

	//printf("%d\n",opa[0][0]);

}

int exc(int linn)
{
	int			i,j,k,l,m,p1,p2;
	int			fbyte;
	int			rvi;
	int			fvi;

	int			lcL,lcR;
	int			ll,lr;
	int			ciL;
	int			ciR;

	long		clL;
	long		clR;

	double		cdL;
	double		cdR;

	char		il[plinel];int	ili=0;
	
	char		tvarnl[vnaml];
	char		svarnl[plinel];
	int			cp[50][3];int cpi=0;

	char		rvarnl[vnaml];

	long		t,tv;
	bool		el,cl;
	bool		bf;
	int			lc=1;
	double		dtv,fr;
	char		rsvarnl[plinel];int	rsvarnli=0;


	for(i=0;i<plinel;++i){rsvarnl[i]='\0';}rsvarnli=0;
	for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
	for(i=0;i<r_strlen(pf[linn]);++i){il[ili]=pf[linn][i];++ili;}

	cl=false;
	if 
	(

			(
				1<=p_ex(il,"print ")   ||
				1<=p_ex(il,"=mid$(")   ||
				1<=p_ex(il,"=trim$(")  ||
				1<=p_ex(il,"=left$(")  ||
				1<=p_ex(il,"=right$(") ||
				1<=p_ex(il,"=len$(")   ||
				1<=p_ex(il,"=val$(")   ||
				1<=p_ex(il,"=format$(")||
				1<=p_ex(il,"=round$(")
			)
			||
			(
				1<=p_ex(il,"input #")       ||
				1<=p_ex(il,"for input as")  ||
				1<=p_ex(il,"for output as") ||
				1<=p_ex(il,"close #")
			)

	){cl=true;}

	if (cl)
	{
		if (1<=(l=p_ex(il,"print")))
		{
			if (1<=p_ex(il,"print #"))
			{
				i=p_syntax_(il,b_fprint);

				if(r_s[2][0]=='#')
				{
					p1=0;l=-1;
					for(j=-1+strlen(r_s[3]);j>=0;--j)
					{
						++l;p1+=(-48+r_s[3][j])*pow(10,l);
					}
					
					for(j=0;j<fni;++j)
					{
						if(p1==fvarc[j]){fvi=j;break;}
					}
					if(j==fni){printf("reference err...%d\n",p1);return(0);}

					l=p_ex(il,"print #");
				}
			}

			cp[cpi][0]=l;
			for(i=l;i<ili;++i)
			{
				if(il[i]==','){cp[cpi][1]=i;++cpi;cp[cpi][0]=i;}
			}
			if(i==ili){if(il[ili-1]==';'){cp[cpi][1]=ili-1;++cpi;}else{cp[cpi][1]=ili;++cpi;}}

			for (i=0;i<cpi;++i)
			{
				for(j=0;j<plinel;++j){svarnl[j]='\0';}
				k=0;for (j=cp[i][0]+1;j<cp[i][1];++j){svarnl[k]=il[j];++k;}
				k=0;
				for(j=0;j<strlen(svarnl);++j)
				{
					if((svarnl[j]=='\'')||(svarnl[j]=='"')){k=0;break;}
					if
					(
						svarnl[j]=='#'||
						svarnl[j]=='%'||
						svarnl[j]=='$'||
						svarnl[j]=='&'
					){++k;}
				}
				if(k!=0)
				{
					for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
					k=0;
					for(j=0;j<strlen(svarnl);++j)
					{
						if
						(
							svarnl[j]=='#'||
							svarnl[j]=='%'||
							svarnl[j]=='&'||
							svarnl[j]=='$'
						){}else{tvarnl[k]=svarnl[j];++k;}
					}

					for(j=0;j<vi;++j)
					{
						if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
					}
					if(j!=vi)
					{
						if (tarv[rvi][1]==2)
						{
							if(r_s[2][0]=='#')
							{
								fprintf(fvars[fvi],"%d",nvarv[tarv[rvi][0]][0]);
							}else{
									if(!of)
									{
										printf("%d",nvarv[tarv[rvi][0]][0]);
									}else{
										fprintf(fout,"%d",nvarv[tarv[rvi][0]][0]);
									}
							}
							//printf("%d",nvarv[tarv[rvi][0]][0]);
							continue;
						}
						if(tarv[rvi][1]==3)
						{

							if(r_s[2][0]=='#')
							{
								fprintf(fvars[fvi],"%d",(nvarv[tarv[rvi][0]][0]<<16)|nvarv[tarv[rvi][0]][1]);
							}else{
								if(!of)
								{
									printf("%d",(nvarv[tarv[rvi][0]][0]<<16)|nvarv[tarv[rvi][0]][1]);
								}else{
									fprintf(fout,"%d",(nvarv[tarv[rvi][0]][0]<<16)|nvarv[tarv[rvi][0]][1]);
								}
							}
							//printf("%d",(nvarv[tarv[rvi][0]][0]<<16)|nvarv[tarv[rvi][0]][1]);
							continue;
						}
						if(tarv[rvi][1]==4)
						{

							if(r_s[2][0]=='#')
							{
								fprintf(fvars[fvi],"%e",dvarv[tarv[rvi][0]]);
							}else{
								if(!of)
								{
									printf("%e",dvarv[tarv[rvi][0]]);
								}else{
									fprintf(fout,"%e",dvarv[tarv[rvi][0]]);
								}
							}
							//printf("%e",dvarv[tarv[rvi][0]]);
							continue;
						}
						if (tarv[rvi][1]==1)
						{
							for(j=0;j<strlen(cvarv[tarv[rvi][0]]);++j)
							{
								if
								(
									cvarv[tarv[rvi][0]][j]=='\''||
									cvarv[tarv[rvi][0]][j]=='"'
								)
								{}else{
									if(r_s[2][0]=='#')
									{
										fprintf(fvars[fvi],"%c",cvarv[tarv[rvi][0]][j]);
									}else{
											if(!of)
											{
												printf("%c",cvarv[tarv[rvi][0]][j]);
											}else{
												fprintf(fout,"%c",cvarv[tarv[rvi][0]][j]);
											}
									}
									//printf("%c",cvarv[tarv[rvi][0]][j]);
								}
							}
							continue;
						}

					}else{printf("reference err...%s\n",tvarnl);return(0);}

				}else{
					for(j=0;j<strlen(svarnl);++j)
					{
						if
						(
							svarnl[j]=='\''||
							svarnl[j]=='"'
						)
						{}else{
							if(r_s[2][0]=='#')
							{
								fprintf(fvars[fvi],"%c",svarnl[j]);
							}else{

								if(!of)
								{
									printf("%c",svarnl[j]);
								}else{
									fprintf(fout,"%c",svarnl[j]);
								}
							}
							//printf("%c",svarnl[j]);
						}
					}
				}
			}
			if (il[strlen(il)-1]==';'){}else{
				if(r_s[2][0]=='#')
				{
					fprintf(fvars[fvi],"%c%c",(char)13,(char)10);
				}else{

					if(!of)
					{
						printf("\n");
					}else{
						fprintf(fout,"\n");
					}
				}
			}

			return(0);

		}else{

			if(1<=p_ex(il,"=mid$("))
			{
				i=p_syntax_(il,b_mid);

				if
				(
					(r_s[6][0]=='%'||r_s[6][0]=='&')&&
					(r_s[9][0]=='%'||r_s[9][0]=='&')
				)
				{
					r_s[5][strlen(r_s[5])]=r_s[6][0];
					r_s[8][strlen(r_s[8])]=r_s[9][0];

					p1=(int)nvarv[tarv[p_r_s_(5)][0]][0]&0x00ff;
					p2=(int)nvarv[tarv[p_r_s_(8)][0]][0]&0x00ff;
					
					p_mid(cvarv[tarv[p_r_s_(3)][0]],p1,p2,svarnl);
					i=p_r_s_(0);k=0;
					for(j=0;j<plinel;++j)
					{cvarv[tarv[i][0]][k]=svarnl[j];++k;}

					return(0);
				}

				if
				(
					(strlen(r_s[6])==0)&&(strlen(r_s[9])==0)
				)
				{

					p1=(int)p_val(r_s[5]);
					p2=(int)p_val(r_s[8]);
					
					p_mid(cvarv[tarv[p_r_s_(3)][0]],p1,p2,svarnl);
					i=p_r_s_(0);k=0;
					for(j=0;j<plinel;++j){cvarv[tarv[i][0]][k]=svarnl[j];++k;}

					return(0);
				}

				if
				(
					(strlen(r_s[6])==0)&&
					(r_s[9][0]=='%'||r_s[9][0]=='&')
				)
				{

					r_s[8][strlen(r_s[8])]=r_s[9][0];

					p1=(int)p_val(r_s[5]);
					p2=(int)nvarv[tarv[p_r_s_(8)][0]][0]&0x00ff;
					
					p_mid(cvarv[tarv[p_r_s_(3)][0]],p1,p2,svarnl);
					i=p_r_s_(0);k=0;
					for(j=0;j<plinel;++j){cvarv[tarv[i][0]][k]=svarnl[j];++k;}

					return(0);
				}

				if
				(
					(strlen(r_s[9])==0)&&
					(r_s[6][0]=='%'||r_s[6][0]=='&')
				)
				{
					r_s[5][strlen(r_s[5])]=r_s[6][0];

					p1=(int)nvarv[tarv[p_r_s_(5)][0]][0]&0x00ff;
					p2=(int)p_val(r_s[8]);
					
					p_mid(cvarv[tarv[p_r_s_(3)][0]],p1,p2,svarnl);
					i=p_r_s_(0);k=0;
					for(j=0;j<plinel;++j){cvarv[tarv[i][0]][k]=svarnl[j];++k;}

					return(0);
				}

				return(0);

			}else{
//===============================
			if(1<=p_ex(il,"=left$("))
			{
				i=p_syntax_(il,b_left);

				p1=(int)p_val(r_s[5]);
					
				p_left(cvarv[tarv[p_r_s_(3)][0]],p1,svarnl);
				i=p_r_s_(0);k=0;
				for(j=0;j<plinel;++j){cvarv[tarv[i][0]][k]=svarnl[j];++k;}

				return(0);
			}else{
//===============================
			if(1<=p_ex(il,"=right$("))
			{

				i=p_syntax_(il,b_right);

				p1=(int)p_val(r_s[5]);
					
				p_right(cvarv[tarv[p_r_s_(3)][0]],p1,svarnl);
				i=p_r_s_(0);k=0;
				for(j=0;j<plinel;++j){cvarv[tarv[i][0]][k]=svarnl[j];++k;}

				return(0);

			}else{
//===============================
			if(1<=p_ex(il,"=trim$("))
			{
				i=p_syntax_(il,b_trim);

				p_trim(cvarv[tarv[p_r_s_(3)][0]],svarnl);
				i=p_r_s_(0);k=0;
				for(j=0;j<plinel;++j){cvarv[tarv[i][0]][k]=svarnl[j];++k;}

				return(0);
			}else{
//===============================
			if(1<=p_ex(il,"=len$("))
			{
				i=p_syntax_(il,b_len);

				l=p_len(cvarv[tarv[p_r_s_(3)][0]]);
				p_r_s_iv_(0,l,(long)l,(double)l);

				return(0);
			}else{
//===============================
			if(1<=p_ex(il,"=val$("))
			{
				i=p_syntax_(il,b_val);

				dtv=p_val(cvarv[tarv[p_r_s_(3)][0]]);
				p_r_s_iv_(0,(int)dtv,(long)dtv,dtv);

				return(0);

			}else{
//===============================
			if(1<=p_ex(il,"=round$("))
			{
				i=p_syntax_(il,b_round);

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				k=0;
				for(j=0;j<strlen(r_s[3]);++j)
				{
					if
					(
						r_s[3][j]=='#'||
						r_s[3][j]=='%'||
						r_s[3][j]=='&'||
						r_s[3][j]=='$'

					){}else{tvarnl[k]=r_s[3][j];++k;}
				}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					if(tarv[rvi][1]==2)
					{
						dtv=(double)nvarv[tarv[rvi][0]][0];

					}else{
						if(tarv[rvi][1]==3)
						{
							dtv=(double)(nvarv[tarv[rvi][0]][0]<<16);
							dtv+=(double)nvarv[tarv[rvi][0]][1];

						}else{
							if(tarv[rvi][1]==4)
							{
								dtv=dvarv[tarv[rvi][0]];
							}
						}
					}

				}else{printf("reference err...%s\n",tvarnl);return(0);}

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				k=0;
				for(j=0;j<strlen(r_s[0]);++j)
				{
					if
					(
						r_s[3][j]=='#'||
						r_s[3][j]=='%'||
						r_s[3][j]=='&'||
						r_s[3][j]=='$'

					){}else{tvarnl[k]=r_s[0][j];++k;}
				}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					if(tarv[rvi][1]==2)
					{
						nvarv[tarv[rvi][0]][0]=(int)p_round(dtv);

					}else{
						if(tarv[rvi][1]==3)
						{
							nvarv[tarv[rvi][0]][0]=(((long)p_round(dtv))&0xffff0000)<<16;
							nvarv[tarv[rvi][0]][1]=((long)p_round(dtv))&0x0000ffff;

						}else{
							if(tarv[rvi][1]==4)
							{
								dvarv[tarv[rvi][0]]=p_round(dtv);
							}
						}
					}

				}else{printf("reference err...%s\n",tvarnl);return(0);}

				return(0);

			}else{
//===============================
			if(1<=p_ex(il,"=format$("))
			{
				i=p_syntax_(il,b_format);

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				k=0;
				for(j=0;j<strlen(r_s[3]);++j)
				{
					if
					(
						r_s[3][j]=='#'||
						r_s[3][j]=='%'||
						r_s[3][j]=='&'||
						r_s[3][j]=='$'

					){}else{tvarnl[k]=r_s[3][j];++k;}
				}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					if(tarv[rvi][1]==2)
					{
						dtv=(double)nvarv[tarv[rvi][0]][0];

					}else{
						if(tarv[rvi][1]==3)
						{
							dtv=(double)(nvarv[tarv[rvi][0]][0]<<16);
							dtv+=(double)nvarv[tarv[rvi][0]][1];

						}else{
							if(tarv[rvi][1]==4)
							{
								dtv=dvarv[tarv[rvi][0]];
							}
						}
					}

				}else{printf("reference err...%s\n",tvarnl);return(0);}

				for(j=0;j<plinel;++j){svarnl[j]='\0';}k=0;
				for(j=0;j<strlen(r_s[6]);++j){svarnl[k]=r_s[6][j];++k;}

				p_format(dtv,svarnl,rsvarnl);

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				k=0;
				for(j=0;j<strlen(r_s[0]);++j)
				{
					if
					(
						r_s[0][j]=='#'||
						r_s[0][j]=='%'||
						r_s[0][j]=='&'||
						r_s[0][j]=='$'
	
					){}else{tvarnl[k]=r_s[0][j];++k;}
				}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					for(j=0;j<plinel;++j){cvarv[tarv[rvi][0]][j]='\0';}
					k=0;
					for(j=0;j<plinel;++j){cvarv[tarv[rvi][0]][k]=rsvarnl[j];++k;}

				}else{printf("reference err...%s\n",tvarnl);return(0);}

				return(0);

			}else{
//===============================
			if(1<=p_ex(il,"for input as")||1<=p_ex(il,"for output as"))
			{
				if(1<=p_ex(il,"for input as")){i=p_syntax_(il,b_fopen_i);}
				if(1<=p_ex(il,"for output as")){i=p_syntax_(il,b_fopen_o);}

				p1=0;l=-1;
				for(j=-1+strlen(r_s[9]);j>=0;--j)
				{
					++l;p1+=(-48+r_s[9][j])*pow(10,l);
				}

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				k=0;
				for(j=0;j<strlen(r_s[2]);++j)
				{
					if
					(
						r_s[2][j]=='#'||
						r_s[2][j]=='%'||
						r_s[2][j]=='&'||
						r_s[2][j]=='$'

					){}else{tvarnl[k]=r_s[2][j];++k;}
				}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					for(j=0;j<fni;++j)
					{
						if (fvarc[j]==p1)
						{
							if (1==p_comp(fvarn[j],cvarv[tarv[rvi][0]])){rvi=j;break;}else{

								printf("reference err...\n",fvarn[j]);
								return(0);
							}
						}
					}
					if(j!=fni)
					{
						if(1<=p_ex(il,"for input as")){fp=fopen(fvarn[rvi],"r");}
						if(1<=p_ex(il,"for output as")){fp=fopen(fvarn[rvi],"wb");}

						if(fp==NULL)
						{printf("reference err...\n",fvarn[rvi]);return(0);}else{fclose(fp);}

						if(1<=p_ex(il,"for input as")){fvars[rvi]=fopen(fvarn[rvi],"r");}
						if(1<=p_ex(il,"for output as")){fvars[rvi]=fopen(fvarn[rvi],"wb");}

						fvarp[rvi]=0;
						fvarc[rvi]=p1;

					}else{
						k=0;
						for(j=0;j<strlen(cvarv[tarv[rvi][0]]);++j)
						{
							if
							(
								cvarv[tarv[rvi][0]][j]=='\''||
								cvarv[tarv[rvi][0]][j]=='\"'
							){}else{fvarn[fni][k]=cvarv[tarv[rvi][0]][j];++k;}
						}

						if(1<=p_ex(il,"for input as")){fp=fopen(fvarn[fni],"r");}
						if(1<=p_ex(il,"for output as")){fp=fopen(fvarn[fni],"wb");}

						if(fp==NULL)
						{printf("reference err...\n",fvarn[fni]);return(0);}else{fclose(fp);}

						if(1<=p_ex(il,"for input as")){fvars[fni]=fopen(fvarn[fni],"r");}
						if(1<=p_ex(il,"for output as")){fvars[fni]=fopen(fvarn[fni],"wb");}
						
						fvarp[fni]=0;
						fvarc[fni]=p1;
						++fni;
					}

				}else{printf("reference err...\n",tvarnl);return(0);}

				return(0);
			}else{
//===============================
			if(1<=p_ex(il,"input #"))
			{
				i=p_syntax_(il,b_finput);

				p1=0;l=-1;
				for(j=-1+strlen(r_s[3]);j>=0;--j)
				{
					++l;p1+=(-48+r_s[3][j])*pow(10,l);
				}

				for(j=0;j<fni;++j)
				{
					if(p1==fvarc[j]){rvi=j;break;}
				}
				if(j==fni){printf("reference err...%d\n",p1);return(0);}

				if(fvarp[rvi]!=-1)
				{
					fseek(fvars[rvi],fvarp[rvi],SEEK_SET);
					for(j=0;j<plinel;++j){svarnl[j]='\0';}k=0;
					fbyte=getc(fvars[rvi]);
					while(!feof(fvars[rvi])&&fbyte!=13&&fbyte!=10){svarnl[k]=fbyte;++k;fbyte=getc(fvars[rvi]);}
					while(!feof(fvars[rvi])&&(fbyte==13||fbyte==10)){fbyte=getc(fvars[rvi]);}
					if(!feof(fvars[rvi])){fvarp[rvi]=ftell(fvars[rvi])-1;}else{fvarp[rvi]=-1;}

				}else{
					for(j=0;j<plinel;++j){svarnl[j]='\0';}
				}

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				k=0;
				for(j=0;j<strlen(r_s[5]);++j)
				{
					if
					(
						r_s[5][j]=='#'||
						r_s[5][j]=='%'||
						r_s[5][j]=='&'||
						r_s[5][j]=='$'

					){}else{tvarnl[k]=r_s[5][j];++k;}
				}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					for(j=0;j<plinel;++j){cvarv[tarv[rvi][0]][j]='\0';}
					k=0;
					for(j=0;j<strlen(svarnl);++j)
					{cvarv[tarv[rvi][0]][k]=svarnl[j];++k;}

				}else{printf("reference err...%s\n",tvarnl);return(0);}

				return(0);
			}else{
//===============================
			if(1<=p_ex(il,"close #"))
			{
				i=p_syntax_(il,b_fclose);

				p1=0;l=-1;
				for(j=-1+strlen(r_s[3]);j>=0;--j)
				{
					++l;p1+=(-48+r_s[3][j])*pow(10,l);
				}

				for(j=0;j<fni;++j)
				{
					if(p1==fvarc[j]){rvi=j;break;}
				}
				if(j==fni){printf("reference err...%d\n",p1);return(0);}

				fclose(fvars[rvi]);

				fvars[rvi]=NULL;
				fvarc[rvi]=-1;
				fvarp[rvi]=-1;
				fvarn[rvi][0]='\0';
				
				return(0);

				}
				}
				}
				}
				}
				}
				}
				}
				}
				}
				}
		}

	}else{

//===================================
		
	p_syntax_(il,p_exp);

	if
	(
			r_s[2][0]=='='&&
			r_s[2][1]=='('&&
			(
				r_s[5][0]=='=' ||
				r_s[5][0]=='>' ||
				r_s[5][0]=='<'
			)
	)
	{

				i=p_syntax_(il,b_l_exp);

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				for(j=0;j<-1+strlen(r_s[2]);++j){tvarnl[j]=r_s[2][j];}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					if (tarv[rvi][1]==2)
					{
						ciL=nvarv[tarv[rvi][0]][0];
						lcL=2;
					}else{
							if (tarv[rvi][1]==3)
							{
								clL=nvarv[tarv[rvi][0]][0]<<16;
								clL+=nvarv[tarv[rvi][0]][1];
								lcL=3;

							}else{
									if (tarv[rvi][1]==1)
									{
										k=0;
										for(j=0;j<strlen(cvarv[tarv[rvi][0]]);++j)
										{
											if
											(
												cvarv[tarv[rvi][0]][j]=='\''||
												cvarv[tarv[rvi][0]][j]=='"'
											)
											{}else{csL[k]=cvarv[tarv[rvi][0]][j];++k;}
										}for(j=k;j<plinel;++j){csL[k]='\0';++k;}
										lcL=1;
									}
							}
					}

				}else{printf("reference err...%s\n",tvarnl);}

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				for(j=0;j<-1+strlen(r_s[4]);++j){tvarnl[j]=r_s[4][j];}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					if (tarv[rvi][1]==2)
					{
						ciR=nvarv[tarv[rvi][0]][0];
						lcR=2;
					}else{
							if (tarv[rvi][1]==3)
							{
								clR=nvarv[tarv[rvi][0]][0]<<16;
								clR+=nvarv[tarv[rvi][0]][1];
								lcR=3;
							}else{
								if (tarv[rvi][1]==1)
								{
									k=0;
									for(j=0;j<strlen(cvarv[tarv[rvi][0]]);++j)
									{
										if
										(
											cvarv[tarv[rvi][0]][j]=='\''||
											cvarv[tarv[rvi][0]][j]=='"'
										)
										{}else{csR[k]=cvarv[tarv[rvi][0]][j];++k;}
									}for(j=k;j<plinel;++j){csR[k]='\0';++k;}
									lcR=1;
								}
							}
					}

				}else{printf("reference err...%s\n",tvarnl);}



				if (r_s[3][0]=='='&&r_s[3][1]=='\0')
				{
					if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[3][0],r_s[3][1]);}
					if(lcL==2&&lcR==2){if (ciL==ciR){ll=1;}else{ll=0;}}
					if(lcL==3&&lcR==3){if (clL==clR){ll=1;}else{ll=0;}}
				}

				if (r_s[3][0]=='<'&&r_s[3][1]=='>')
				{
					if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[3][0],r_s[3][1]);}
					if(lcL==2&&lcR==2){if (ciL!=ciR){ll=1;}else{ll=0;}}
					if(lcL==3&&lcR==3){if (clL!=clR){ll=1;}else{ll=0;}}
				}

				if(r_s[3][0]=='>'&&r_s[3][1]=='\0')
				{
					if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[3][0],r_s[3][1]);}
					if(lcL==2&&lcR==2){if (ciL>ciR){ll=1;}else{ll=0;}}
					if(lcL==3&&lcR==3){if (clL>clR){ll=1;}else{ll=0;}}
				}

				if (r_s[3][0]=='<'&&r_s[3][1]=='\0')
				{
					if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[3][0],r_s[3][1]);}
					if(lcL==2&&lcR==2){if (ciL<ciR){ll=1;}else{ll=0;}}
					if(lcL==3&&lcR==3){if (clL<clR){ll=1;}else{ll=0;}}
				}

				if (r_s[3][0]=='>'&&r_s[3][1]=='=')
				{
					if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[3][0],r_s[3][1]);}
					if(lcL==2&&lcR==2){if (ciL>=ciR){ll=1;}else{ll=0;}}
					if(lcL==3&&lcR==3){if (clL>=clR){ll=1;}else{ll=0;}}
				}

				if (r_s[3][0]=='<'&&r_s[3][1]=='=')
				{
					if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[3][0],r_s[3][1]);}
					if(lcL==2&&lcR==2){if (ciL<=ciR){ll=1;}else{ll=0;}}
					if(lcL==3&&lcR==3){if (clL<=clR){ll=1;}else{ll=0;}}
				}
			
//==============================

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				for(j=0;j<-1+strlen(r_s[8]);++j){tvarnl[j]=r_s[8][j];}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					if (tarv[rvi][1]==2)
					{
						ciL=nvarv[tarv[rvi][0]][0];
						lcL=2;
					}else{
							if (tarv[rvi][1]==3)
							{
								clL=nvarv[tarv[rvi][0]][0]<<16;
								clL+=nvarv[tarv[rvi][0]][1];
								lcL=3;

							}else{
									if (tarv[rvi][1]==1)
									{
										k=0;
										for(j=0;j<strlen(cvarv[tarv[rvi][0]]);++j)
										{
											if
											(
												cvarv[tarv[rvi][0]][j]=='\''||
												cvarv[tarv[rvi][0]][j]=='"'
											)
											{}else{csL[k]=cvarv[tarv[rvi][0]][j];++k;}
										}for(j=k;j<plinel;++j){csL[k]='\0';++k;}
										lcL=1;
									}
							}
					}

				}else{printf("reference err...%s\n",tvarnl);}

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				for(j=0;j<-1+strlen(r_s[10]);++j){tvarnl[j]=r_s[10][j];}
	
				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					if (tarv[rvi][1]==2)
					{
						ciR=nvarv[tarv[rvi][0]][0];
						lcR=2;
					}else{
							if (tarv[rvi][1]==3)
							{
								clR=nvarv[tarv[rvi][0]][0]<<16;
								clR+=nvarv[tarv[rvi][0]][1];
								lcR=3;
							}else{
									if (tarv[rvi][1]==1)
									{
										k=0;
										for(j=0;j<strlen(cvarv[tarv[rvi][0]]);++j)
										{
											if
											(
												cvarv[tarv[rvi][0]][j]=='\''||
												cvarv[tarv[rvi][0]][j]=='"'
											)
											{}else{csR[k]=cvarv[tarv[rvi][0]][j];++k;}
										}for(j=k;j<plinel;++j){csR[k]='\0';++k;}
										lcR=1;
									}
							}
					}

				}else{printf("reference err...%s\n",tvarnl);}



				if (r_s[9][0]=='='&&r_s[9][1]=='\0')
				{
					if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[9][0],r_s[9][1]);}
					if(lcL==2&&lcR==2){if (ciL==ciR){lr=1;}else{lr=0;}}
					if(lcL==3&&lcR==3){if (clL==clR){lr=1;}else{lr=0;}}
				}

				if (r_s[9][0]=='<'&&r_s[9][1]=='>')
				{
					if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[9][0],r_s[9][1]);}
					if(lcL==2&&lcR==2){if (ciL!=ciR){lr=1;}else{lr=0;}}
					if(lcL==3&&lcR==3){if (clL!=clR){lr=1;}else{lr=0;}}
				}

				if(r_s[9][0]=='>'&&r_s[9][1]=='\0')
				{
					if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[9][0],r_s[9][1]);}
					if(lcL==2&&lcR==2){if (ciL>ciR){lr=1;}else{lr=0;}}
					if(lcL==3&&lcR==3){if (clL>clR){lr=1;}else{lr=0;}}
				}

				if (r_s[9][0]=='<'&&r_s[9][1]=='\0')
				{
					if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[9][0],r_s[9][1]);}
					if(lcL==2&&lcR==2){if (ciL<ciR){lr=1;}else{lr=0;}}
					if(lcL==3&&lcR==3){if (clL<clR){lr=1;}else{lr=0;}}
				}

				if (r_s[9][0]=='>'&&r_s[9][1]=='=')
				{
					if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[9][0],r_s[9][1]);}
					if(lcL==2&&lcR==2){if (ciL>=ciR){lr=1;}else{lr=0;}}
					if(lcL==3&&lcR==3){if (clL>=clR){lr=1;}else{lr=0;}}
				}

				if (r_s[9][0]=='<'&&r_s[9][1]=='=')
				{
					if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[9][0],r_s[9][1]);}
					if(lcL==2&&lcR==2){if (ciL<=ciR){lr=1;}else{lr=0;}}
					if(lcL==3&&lcR==3){if (clL<=clR){lr=1;}else{lr=0;}}
				}

//==============================

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				for(j=0;j<-1+strlen(r_s[0]);++j){tvarnl[j]=r_s[0][j];}
	
				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					if (tarv[rvi][1]==2)
					{
						nvarv[tarv[rvi][0]][0]=0;

						if(1<=p_ex(r_s[6],"xor")){if(((ll^lr)&0x01)==1){nvarv[tarv[rvi][0]][0]=1;}}else{
						
							if(1<=p_ex(r_s[6],"and")){if(((ll&lr)&0x01)==1){nvarv[tarv[rvi][0]][0]=1;}}else{
							
								if(1<=p_ex(r_s[6],"or")) {if(((ll|lr)&0x01)==1){nvarv[tarv[rvi][0]][0]=1;}}}}
					
					}else{
							if (tarv[rvi][1]==3)
							{
								nvarv[tarv[rvi][0]][0]=0;
								nvarv[tarv[rvi][0]][1]=0;

								if(1<=p_ex(r_s[6],"xor")){if(((ll^lr)&0x01)==1){nvarv[tarv[rvi][0]][1]=1;}}else{
						
									if(1<=p_ex(r_s[6],"and")){if(((ll&lr)&0x01)==1){nvarv[tarv[rvi][0]][1]=1;}}else{
							
										if(1<=p_ex(r_s[6],"or")) {if(((ll|lr)&0x01)==1){nvarv[tarv[rvi][0]][1]=1;}}}}
							}
					}
					
				}else{printf("reference err...%s\n",tvarnl);}
		
	
		return(0);	
	}
	
//===================================
		
		for(j=0;j<mc;++j){if (1<=p_ex(il,kw[j])){break;}}if(j!=mc){return(0);}

		opi=0;
		for(i=0;i<ili;++i){if (il[i]=='='){l=i;break;}}if(i==ili){return(0);}
		for(i=l;i<ili;++i)
		{
			if
			(
				il[i]=='='||
				il[i]=='+'||
				il[i]=='-'||
				il[i]=='/'||
				il[i]=='*'||
				il[i]=='^'
			)
			{
				cp[cpi][0]=i;
				for(j=i+1;il[j]!='\0';++j)
				{
					if(il[j]=='^'||il[j]=='+'||il[j]=='-'||il[j]=='/'||il[j]=='*')
					{
						if(il[j]=='^'){cp[cpi][2]=1;}
						if(il[j]=='*'){cp[cpi][2]=2;}
						if(il[j]=='/'){cp[cpi][2]=3;}
						if(il[j]=='+'){cp[cpi][2]=4;}
						if(il[j]=='-'){cp[cpi][2]=5;}
						cp[cpi][1]=j;
						++cpi;
						cp[cpi][0]=cp[-1+cpi][1];
						i=j-1;
						break;
					}
				}
				if(il[j]=='\0'){cp[cpi][1]=ili;cp[cpi][2]=6;++cpi;break;}	
			}
		}

		for(j=0;j<vnaml;++j){rvarnl[j]='\0';}
		for (i=0;i<cpi;++i)
		{

			for(j=0;j<plinel;++j){svarnl[j]='\0';}
			k=0;for (j=cp[i][0]+1;j<cp[i][1];++j){svarnl[k]=il[j];++k;}
			k=0;l=0;
			for(j=0;j<strlen(svarnl);++j)
			{
				if
				(
					svarnl[j]=='#'||
					svarnl[j]=='%'||
					svarnl[j]=='&'
				){++k;}
				if
				(
					svarnl[j]=='$'
				){++l;}
			}
			if(k!=0&&l==0)
			{
				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				k=0;
				for(j=0;j<strlen(svarnl);++j)
				{
					if
					(
						svarnl[j]=='#'||
						svarnl[j]=='%'||
						svarnl[j]=='&'
					)
					{}else{tvarnl[k]=svarnl[j];++k;}
				}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					if(tarv[rvi][1]==2)
					{
						opa[opi][0]=(double)nvarv[tarv[rvi][0]][0];
						opa[opi][1]=cp[i][2];
						++opi;
					}else{
						if(tarv[rvi][1]==3)
						{
							opa[opi][0]=(double)(nvarv[tarv[rvi][0]][0]<<16);
							opa[opi][0]+=(double)nvarv[tarv[rvi][0]][1];
							opa[opi][1]=cp[i][2];
							++opi;
						}else{
							if(tarv[rvi][1]==4)
							{
								opa[opi][0]=dvarv[tarv[rvi][0]];
								opa[opi][1]=cp[i][2];
								++opi;
							}
						}
					}

				}else{printf("reference err...%s\n",tvarnl);return(0);}

			}else{
				if(l==0)
				{
					for(j=0;j<strlen(svarnl);++j)
					{if(svarnl[j]=='.'||svarnl[j]>='0'&&svarnl[j]<='9'){}else{break;}}
					if(j==strlen(svarnl))
					{
						for(j=0;j<strlen(svarnl);++j){if(svarnl[j]=='.'){break;}}

						if(j==strlen(svarnl))
						{
							fr=0;tv=0;l=-1;
							for(j=-1+strlen(svarnl);j>=0;--j)
							{
								++l;tv+=(-48+svarnl[j])*pow(10,l);
							}
							dtv=(double)tv;

							opa[opi][0]=dtv;
							opa[opi][1]=cp[i][2];
							++opi;
						}else{
							fr=0;l=-1;
							for(k=-1+strlen(svarnl);k>j;--k)
							{
								++l;fr+=(-48+svarnl[k])*(long)pow(10,l);
							}

							dtv=0;l=-1;
							for(k=j-1;k>=0;--k)
							{
								++l;dtv+=(double)(-48+svarnl[k])*pow(10,l);
							}dtv*=pow(10,strlen(svarnl)-j-1);
				
							opa[opi][0]=(dtv+fr)/pow(10,strlen(svarnl)-j-1);
							opa[opi][1]=cp[i][2];
							++opi;
						}

					}

				}else{

					for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
					k=0;
					for(j=0;j<strlen(svarnl);++j)
					{
						if
						(
							svarnl[j]=='$'
						)
						{}else{tvarnl[k]=svarnl[j];++k;}
					}
					for(j=0;j<vi;++j)
					{
						if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
					}
					if(j!=vi)
					{
						for(j=0;j<strlen(cvarv[tarv[rvi][0]]);++j)
						{
							if
							(
								cvarv[tarv[rvi][0]][j]=='\''||
								cvarv[tarv[rvi][0]][j]=='"'
							)
							{}else{rsvarnl[rsvarnli]=cvarv[tarv[rvi][0]][j];++rsvarnli;}
						}

					}else{printf("reference err...%s\n",tvarnl);return(0);}

				}
			}
		}

//===================================

		if(opi>0)
		{
			//for(i=0;i<opi;++i){printf("%d %d\n",opa[i][0],opa[i][1]);}

			cmput();
			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			k=0;
			for(i=0;i<strlen(il);++i)
			{
				if
				(
					il[i]!='='&&
					il[i]!='%'&&
					il[i]!='&'&&
					il[i]!='#'
				){tvarnl[k]=il[i];++k;}else{break;}
			}

			for(j=0;j<vi;++j){if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}}

			if (j!=vi)
			{
				if(tarv[rvi][1]==2)
				{
					nvarv[tarv[rvi][0]][0]=opa[0][0];
				}else{
					if(tarv[rvi][1]==3)
					{
						nvarv[tarv[rvi][0]][0]=(((long)opa[0][0]&0xffff0000)>>16);
						nvarv[tarv[rvi][0]][1]=((long)opa[0][0]&0x0000ffff);
					}else{
						if(tarv[rvi][1]==4)
						{
							dvarv[tarv[rvi][0]]=opa[0][0];
						}
					}
				}

			}else{printf("reference err...%s\n",tvarnl);}

			for(j=0;j<vnaml;++j){opa[j][0]=0;opa[j][1]=0;}
			opi=0;
		}else{
			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			k=0;
			for(i=0;i<strlen(il);++i)
			{
				if
				(
					il[i]!='='&&
					il[i]!='$'
				){tvarnl[k]=il[i];++k;}else{break;}
			}

			for(j=0;j<vi;++j){if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}}

			if (j!=vi)
			{
				for(j=0;j<plinel;++j){cvarv[tarv[rvi][0]][j]='\0';}
				k=0;
				for(j=0;j<strlen(rsvarnl);++j)
				{cvarv[tarv[rvi][0]][k]=rsvarnl[j];++k;}

			}else{printf("reference err...%s\n",tvarnl);}
		}
	}
}

//!!!

int vdcl_(int iline)
{	
	int	i,j,k,l,l1,m;

	int	sig=0;
	int	rvi;
	bool	mp=false;
	char	il[plinel];int	ili=0;

	char	tvarnl[vnaml];
	double	fr=0;
	long	tv=0;
	long	dtv=0;

	linen=iline;
	for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
	for(i=0;i<r_strlen(pf[linen]);++i){il[ili]=pf[linen][i];++ili;}

	for(j=0;j<mc;++j){if (1<=p_ex(il,kw[j])){break;}}if(j!=mc){return(0);}
	
	//printf("%s\n",il);

	p_syntax_(il,p_exp);


	if(r_s[1][0]=='$'&&r_s[4][0]=='\0'&&r_s[5][0]=='\0')
	{

			i=p_syntax_(il,b_var_s);

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[0]);++j){tvarnl[j]=r_s[0][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j==vi)
			{
				for(j=0;j<-1+strlen(r_s[0]);++j){varnl[vi][j]=r_s[0][j];}

				for(i=0;i<plinel;++i){cvarv[ci][i]='\0';}

				i=0;cvarv[ci][0]=r_s[2][0];++i;
				for(j=0;j<strlen(r_s[3]);++j)
				{
					if
					(
						r_s[3][j]=='\''||
						r_s[3][j]=='"'
					)
					{}else{cvarv[ci][i]=r_s[3][j];++i;}
				}
				cvarv[ci][i]=r_s[4][0];++i;

				tarv[vi][0]=ci;
				tarv[vi][1]=1;
				++ci;
				++vi;
			}else{

				for(i=0;i<plinel;++i){cvarv[rvi][i]='\0';}

				i=0;cvarv[rvi][0]=r_s[2][0];++i;
				for(j=0;j<strlen(r_s[3]);++j)
				{
					if
					(
						r_s[3][j]=='\''||
						r_s[3][j]=='"'
					)
					{}else{cvarv[rvi][i]=r_s[3][j];++i;}
				}
				cvarv[rvi][i]=r_s[4][0];++i;
			}	
			return(0);
		
	}else{

		if((r_s[1][0]=='%'||r_s[1][0]=='&'||r_s[1][0]=='#')&&(r_s[4][0]=='\0'||r_s[4][0]=='-'||r_s[4][0]=='+')&&(r_s[5][0]=='\0'||r_s[5][0]=='-'||r_s[5][0]=='+'))
		{

		i=p_syntax_(il,b_var_n);

		for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
		for(j=0;j<-1+strlen(r_s[0]);++j){tvarnl[j]=r_s[0][j];}

		for(j=0;j<vi;++j)
		{
			if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
		}
		if(j==vi)
		{

			for(j=0;j<-1+strlen(r_s[0]);++j){varnl[vi][j]=r_s[0][j];}

			if(r_s[2][0]=='-')
			{
				l=0;for(i=0+1;i<strlen(r_s[2]);++i)
				{r_s[2][l]=r_s[2][i];++l;}
				sig=1;
			}
			if(r_s[2][strlen(r_s[2])-1]=='-')
			{
				r_s[2][strlen(r_s[2])-1]='\0';
				sig=1;
			}

			if(r_s[2][0]=='+')
			{
				l=0;for(i=0+1;i<strlen(r_s[2]);++i)
				{r_s[2][l]=r_s[2][i];++l;}
				sig=0;
			}
			if(r_s[2][strlen(r_s[2])-1]=='+')
			{
				r_s[2][strlen(r_s[2])-1]='\0';
				sig=0;
			}

			k=strlen(r_s[2]);
			for(j=0;j<k;++j)
			{
				if(r_s[2][j]==',')
				{
				l=j;for(i=j+1;i<strlen(r_s[2]);++i)
				{r_s[2][l]=r_s[2][i];++l;}
				k=strlen(r_s[2]);
				}
			}

			for(j=0;j<strlen(r_s[2]);++j){if(r_s[2][j]=='.'){break;}}

			if(j==strlen(r_s[2]))
			{
				tv=0;l=-1;
				for(j=-1+strlen(r_s[2]);j>=0;--j)
				{
					++l;tv+=(-48+r_s[2][j])*pow(10,l);
				}
				dtv=(double)tv;
			}else{
				fr=0;l=-1;
				for(k=-1+strlen(r_s[2]);k>j;--k)
				{
					++l;fr+=(double)(-48+r_s[2][k])*pow(10,l);
				}

				dtv=0;l=-1;
				for(k=j-1;k>=0;--k)
				{
					++l;dtv+=(double)(-48+r_s[2][k])*pow(10,l);
				}dtv*=pow(10,strlen(r_s[2])-j-1);
				
			}
			if(sig==1){dtv*=-1.0;tv*=-1;}

			if(r_s[0][-1+strlen(r_s[0])]=='%')
			{
				nvarv[ni][0]=tv;
				nvarv[ni][1]=0;
				tarv[vi][0]=ni;
				tarv[vi][1]=2;
				++ni;
				++vi;
			}
			if(r_s[0][-1+strlen(r_s[0])]=='&')
			{
				nvarv[ni][0]=(long)tv&0xffff0000>>16;
				nvarv[ni][1]=(long)tv&0x0000ffff;
				tarv[vi][0]=ni;					
				tarv[vi][1]=3;					
				++ni;
				++vi;				

			}
			if(r_s[0][-1+strlen(r_s[0])]=='#')
			{
				dvarv[dni]=(dtv+fr)/pow(10,strlen(r_s[2])-j-1);
				tarv[vi][0]=dni;					
				tarv[vi][1]=4;
				++dni;
				++vi;
			}

		}else{

			if(r_s[2][0]=='-')
			{
				l=0;for(i=0+1;i<strlen(r_s[2]);++i)
				{r_s[2][l]=r_s[2][i];++l;}
				sig=1;
			}
			if(r_s[2][strlen(r_s[2])-1]=='-')
			{
				r_s[2][strlen(r_s[2])-1]='\0';
				sig=1;
			}

			if(r_s[2][0]=='+')
			{
				l=0;for(i=0+1;i<strlen(r_s[2]);++i)
				{r_s[2][l]=r_s[2][i];++l;}
				sig=0;
			}
			if(r_s[2][strlen(r_s[2])-1]=='+')
			{
				r_s[2][strlen(r_s[2])-1]='\0';
				sig=0;
			}

			k=strlen(r_s[2]);
			for(j=0;j<k;++j)
			{
				if(r_s[2][j]==',')
				{
				l=j;for(i=j+1;i<strlen(r_s[2]);++i)
				{r_s[2][l]=r_s[2][i];++l;}
				k=strlen(r_s[2]);
				}
			}

			for(j=0;j<strlen(r_s[2]);++j){if(r_s[2][j]=='.'){break;}}

			if(j==strlen(r_s[2]))
			{
				tv=0;l=-1;
				for(j=-1+strlen(r_s[2]);j>=0;--j)
				{
					++l;tv+=(-48+r_s[2][j])*pow(10,l);
				}
				dtv=(double)tv;
			}else{
				fr=0;l=-1;
				for(k=-1+strlen(r_s[2]);k>j;--k)
				{
					++l;fr+=(double)(-48+r_s[2][k])*pow(10,l);
				}

				dtv=0;l=-1;
				for(k=j-1;k>=0;--k)
				{
					++l;dtv+=(double)(-48+r_s[2][k])*pow(10,l);
				}dtv*=pow(10,strlen(r_s[2])-j-1);
				
			}
			if(sig==1){dtv*=-1.0;tv*=-1;}

			if(r_s[0][-1+strlen(r_s[0])]=='%')
			{
				nvarv[tarv[rvi][0]][0]=tv;
				nvarv[tarv[rvi][0]][1]=0;
			}
			if(r_s[0][-1+strlen(r_s[0])]=='&')
			{
				nvarv[tarv[rvi][0]][0]=(long)tv&0xffff0000>>16;
				nvarv[tarv[rvi][0]][1]=(long)tv&0x0000ffff;
			}
			if(r_s[0][-1+strlen(r_s[0])]=='#')
			{
				dvarv[tarv[rvi][0]]=(dtv+fr)/pow(10,strlen(r_s[2])-j-1);
			}
		}

		}
	}

	return(0);
}

//!!!

int	pif_(int start,int end)
{
	int			i,j,k,l,rvi,lr;

	char			il[plinel];int	ili=0;
	char			tvarnl[vnaml];

	int			lcL,lcR;
	long			cnL,cnR;
	
	double			fr;


	for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
	for(i=0;i<strlen(pf[start]);++i){il[ili]=pf[start][i];++ili;}

	j=0;
	for(i=0;i<ili-1;++i)
	{
		if
		(
			(il[0]=='i'&&il[1]=='f'&&il[i]=='#'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='%'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='&'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='$'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))
			||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='#'&&il[i+1]==')')||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='%'&&il[i+1]==')')||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='&'&&il[i+1]==')')||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='$'&&il[i+1]==')')
		)
		{++j;}
	}

	if(j==1)
	{
			i=p_syntax_(il,b_if_1);

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[2]);++j){tvarnl[j]=r_s[2][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{
				if (tarv[rvi][1]==2||tarv[rvi][1]==4)
				{
					if (tarv[rvi][1]==2)
					{
						cnL=nvarv[tarv[rvi][0]][0];
						lcL=tarv[rvi][1];
					}else{
						cnL=(long)dvarv[tarv[rvi][0]];
						lcL=tarv[rvi][1];
					}
				}else{
					if (tarv[rvi][1]==3)
					{
						cnL=nvarv[tarv[rvi][0]][0]<<16;
						cnL+=nvarv[tarv[rvi][0]][1];
						lcL=tarv[rvi][1];
					}else{
						if (tarv[rvi][1]==1)
						{
							k=0;
							for(j=0;j<strlen(cvarv[tarv[rvi][0]]);++j)
							{
								if
								(
									cvarv[tarv[rvi][0]][j]=='\''||
									cvarv[tarv[rvi][0]][j]=='"'
								)
								{}else{csL[k]=cvarv[tarv[rvi][0]][j];++k;}
							}for(j=k;j<plinel;++j){csL[k]='\0';++k;}
							lcL=tarv[rvi][1];
						}
					}
				}

			}else{printf("reference err...%s\n",tvarnl);}

			cnR=(long)p_val(r_s[4]);
			lcR=2;

	}else{
		if(j==2)
		{

			i=p_syntax_(il,b_if);

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[2]);++j){tvarnl[j]=r_s[2][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{
				if (tarv[rvi][1]==2||tarv[rvi][1]==4)
				{
					if (tarv[rvi][1]==2)
					{
						cnL=nvarv[tarv[rvi][0]][0];
						lcL=tarv[rvi][1];
					}else{
						cnL=(long)dvarv[tarv[rvi][0]];
						lcL=tarv[rvi][1];
					}
				}else{
					if (tarv[rvi][1]==3)
					{
						cnL=nvarv[tarv[rvi][0]][0]<<16;
						cnL+=nvarv[tarv[rvi][0]][1];
						lcL=tarv[rvi][1];
					}else{
						if (tarv[rvi][1]==1)
						{
							k=0;
							for(j=0;j<strlen(cvarv[tarv[rvi][0]]);++j)
							{
								if
								(
									cvarv[tarv[rvi][0]][j]=='\''||
									cvarv[tarv[rvi][0]][j]=='"'
								)
								{}else{csL[k]=cvarv[tarv[rvi][0]][j];++k;}
							}for(j=k;j<plinel;++j){csL[k]='\0';++k;}
							lcL=tarv[rvi][1];
						}
					}
				}
			}else{printf("reference err...%s\n",tvarnl);}

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[4]);++j){tvarnl[j]=r_s[4][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{
				if (tarv[rvi][1]==2||tarv[rvi][1]==4)
				{
					if (tarv[rvi][1]==2)
					{
						cnR=nvarv[tarv[rvi][0]][0];
						lcR=tarv[rvi][1];
					}else{
						cnR=(long)dvarv[tarv[rvi][0]];
						lcR=tarv[rvi][1];
					}
				}else{
					if (tarv[rvi][1]==3)
					{
						cnR=nvarv[tarv[rvi][0]][0]<<16;
						cnR+=nvarv[tarv[rvi][0]][1];
						lcR=tarv[rvi][1];
					}else{
						if (tarv[rvi][1]==1)
						{
							k=0;
							for(j=0;j<strlen(cvarv[tarv[rvi][0]]);++j)
							{
								if
								(
									cvarv[tarv[rvi][0]][j]=='\''||
									cvarv[tarv[rvi][0]][j]=='"'
								)
								{}else{csR[k]=cvarv[tarv[rvi][0]][j];++k;}
							}for(j=k;j<plinel;++j){csR[k]='\0';++k;}
							lcR=tarv[rvi][1];
						}
					}
				}

			}else{printf("reference err...%s\n",tvarnl);}

		}
	}

	lr=-1;
	if (r_s[3][0]=='='&&r_s[3][1]=='\0')
	{
		if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[3][0],r_s[3][1]);}
		if((lcL==2||lcL==4)&&(lcR==2||lcR==4)){if (cnL==cnR){lr=1;}else{lr=0;}}
		if(lcL==3&&lcR==3){if (cnL==cnR){lr=1;}else{lr=0;}}
	}

	if (r_s[3][0]=='<'&&r_s[3][1]=='>')
	{
		if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[3][0],r_s[3][1]);}
		if((lcL==2||lcL==4)&&(lcR==2||lcR==4)){if (cnL!=cnR){lr=1;}else{lr=0;}}
		if(lcL==3&&lcR==3){if (cnL!=cnR){lr=1;}else{lr=0;}}
	}

	if(r_s[3][0]=='>'&&r_s[3][1]=='\0')
	{
		if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[3][0],r_s[3][1]);}
		if((lcL==2||lcL==4)&&(lcR==2||lcR==4)){if (cnL>cnR){lr=1;}else{lr=0;}}
		if(lcL==3&&lcR==3){if (cnL>cnR){lr=1;}else{lr=0;}}
	}

	if (r_s[3][0]=='<'&&r_s[3][1]=='\0')
	{
		if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[3][0],r_s[3][1]);}
		if((lcL==2||lcL==4)&&(lcR==2||lcR==4)){if (cnL<cnR){lr=1;}else{lr=0;}}
		if(lcL==3&&lcR==3){if (cnL<cnR){lr=1;}else{lr=0;}}
	}

	if (r_s[3][0]=='>'&&r_s[3][1]=='=')
	{
		if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[3][0],r_s[3][1]);}
		if((lcL==2||lcL==4)&&(lcR==2||lcR==4)){if (cnL>=cnR){lr=1;}else{lr=0;}}
		if(lcL==3&&lcR==3){if (cnL>=cnR){lr=1;}else{lr=0;}}
	}

	if (r_s[3][0]=='<'&&r_s[3][1]=='=')
	{
		if(lcL==1&&lcR==1){lr=p_ccomp(csL,csR,r_s[3][0],r_s[3][1]);}
		if((lcL==2||lcL==4)&&(lcR==2||lcR==4)){if (cnL<=cnR){lr=1;}else{lr=0;}}
		if(lcL==3&&lcR==3){if (cnL<=cnR){lr=1;}else{lr=0;}}
	}

	//printf("%s %d %d %d %d %d %d %d\n",r_s[3],lcL,lcR,cnL,cnR,lr,start,end);
	if (lr==1){for (j=start+1;j<end;++j){exc(j);}}

	return(0);
}

//!!!

int pwhile_(int start,int end)
{
	int		i,j,k,l,rvi;

	char		il[plinel];int	ili=0;
	char		tvarnl[vnaml];

	int		ci;
	long		tvs[4];
	int		rv0,rvi0,rvt0;
	int		rv1,rvi1,rvt1;

	double		fr;


	for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
	for(i=0;i<strlen(pf[start]);++i){il[ili]=pf[start][i];++ili;}

	j=0;
	for(i=0;i<ili-1;++i)
	{
		if
		(
			(il[0]=='w'&&il[1]=='h'&&il[i]=='#'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))||
			(il[0]=='w'&&il[1]=='h'&&il[i]=='%'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))||
			(il[0]=='w'&&il[1]=='h'&&il[i]=='&'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))
			||
			(il[0]=='w'&&il[1]=='h'&&il[i]=='#'&&il[i+1]==')')||
			(il[0]=='w'&&il[1]=='h'&&il[i]=='%'&&il[i+1]==')')||
			(il[0]=='w'&&il[1]=='h'&&il[i]=='&'&&il[i+1]==')')
		)
		{++j;}
	}

	if(j==1)
	{
		i=p_syntax_(il,b_while);

		if (1<=p_ex(il,">="))
		{
			ci=3;
		}else{
			if (1<=p_ex(il,"<="))
			{
				ci=4;
			}else{
				if (1<=p_ex(il,"="))
				{
					ci=0;
				}else{
					if (1<=p_ex(il,"<>"))
					{
						ci=5;
					}else{
						if (1<=p_ex(il,">"))
						{
							ci=1;
						}else{
							if (1<=p_ex(il,"<"))
							{
								ci=2;
							}
						}
					}
				}
			}
		}

		for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
		for(j=0;j<-1+strlen(r_s[1]);++j){tvarnl[j]=r_s[1][j];}

		for(j=0;j<vi;++j)
		{
			if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
		}
		if(j!=vi)
		{
			rvt0=tarv[rvi][1];
			rvi0=tarv[rvi][0];

			if(tarv[rvi][1]==2)
			{
				tvs[0]=nvarv[tarv[rvi][0]][0];
				tvs[1]=2;
			}else{
				if(tarv[rvi][1]==3)
				{
					tvs[0]=nvarv[tarv[rvi][0]][0]<<16;
					tvs[0]+=nvarv[tarv[rvi][0]][1];
					tvs[1]=3;
				}
			}

		}else{printf("reference err...%s\n",tvarnl);}

		tvs[2]=0;l=-1;
		for(j=-1+strlen(r_s[3]);j>=0;--j)
		{
			++l;tvs[2]+=(-48+r_s[3][j])*pow(10,l);
		}
		tvs[3]=-1;

		rvt1=-1;
		rvi1=-1;

	}else{
		if(j==2)
		{

			i=p_syntax_(il,b_while_1);

			if (1<=p_ex(il,">="))
			{
				ci=3;
			}else{
				if (1<=p_ex(il,"<="))
				{
					ci=4;
				}else{
					if (1<=p_ex(il,"="))
					{
						ci=0;
					}else{
						if (1<=p_ex(il,"<>"))
						{
							ci=5;
						}else{
							if (1<=p_ex(il,">"))
							{
								ci=1;
							}else{
								if (1<=p_ex(il,"<"))
								{
									ci=2;
								}
							}
						}
					}
				}
			}

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[1]);++j){tvarnl[j]=r_s[1][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{
				rvt0=tarv[rvi][1];
				rvi0=tarv[rvi][0];

				if(tarv[rvi][1]==2)
				{
					tvs[0]=nvarv[tarv[rvi][0]][0];
					tvs[1]=2;
				}else{
					if(tarv[rvi][1]==3)
					{
						tvs[0]=nvarv[tarv[rvi][0]][0]<<16;
						tvs[0]+=nvarv[tarv[rvi][0]][1];
						tvs[1]=3;
					}
				}

			}else{printf("reference err...%s\n",tvarnl);}

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[3]);++j){tvarnl[j]=r_s[3][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{
				rvt1=tarv[rvi][1];
				rvi1=tarv[rvi][0];

				if(tarv[rvi][1]==2)
				{
					tvs[2]=nvarv[tarv[rvi][0]][0];
					tvs[3]=2;
				}else{
						if(tarv[rvi][2]==3)
						{
							tvs[2]=nvarv[tarv[rvi][0]][0]<<16;
							tvs[2]+=nvarv[tarv[rvi][0]][1];
							tvs[3]=3;
						}
				}

			}else{printf("reference err...%s\n",tvarnl);}

		}else{return(0);}
	}
	//printf("%d %d %d %d %d %d %d\n",ci,tvs[0],tvs[1],tvs[2],tvs[3],rvi0,rvi1);

	if (ci==0)
	{
		while (tvs[1]==tvs[2])
		{
			for (j=start+1;j<end;++j){exc(j);}
			if(rvt1==2)
			{
				tvs[1]=nvarv[rvi1][0];
			}else{
					if(rvt1==3)
					{
						tvs[1]=nvarv[rvi1][0]<<16;
						tvs[1]+=nvarv[rvi1][1];
					}
			}
			if(rvt0==2)
			{
				tvs[1]=nvarv[rvi0][0];
			}else{
					if(rvt0==3)
					{
						tvs[1]=nvarv[rvi0][0]<<16;
						tvs[1]+=nvarv[rvi0][1];
					}
			}
		}
	}

	if (ci==5)
	{
		while (tvs[0]!=tvs[2])
		{
			for (j=start+1;j<end;++j){exc(j);}
			if(rvt0==2)
			{
				tvs[0]=nvarv[rvi0][0];
			}else{
					if(rvt0==3)
					{
						tvs[0]=nvarv[rvi0][0]<<16;
						tvs[0]+=nvarv[rvi0][1];
					}
			}
			if(rvt1==2)
			{
				tvs[2]=nvarv[rvi1][0];
			}else{
					if(rvt0==3)
					{
						tvs[2]=nvarv[rvi1][0]<<16;
						tvs[2]+=nvarv[rvi1][1];
					}
			}
		}
	}

	if (ci==1)
	{
		while (tvs[0]>tvs[2])
		{
			for (j=start+1;j<end;++j){exc(j);}
			if(rvt0==2)
			{
				tvs[0]=nvarv[rvi0][0];
			}else{
					if(rvt0==3)
					{
						tvs[0]=nvarv[rvi0][0]<<16;
						tvs[0]+=nvarv[rvi0][1];
					}
			}
			if(rvt1==2)
			{
				tvs[2]=nvarv[rvi1][0];
			}else{
					if(rvt0==3)
					{
						tvs[2]=nvarv[rvi1][0]<<16;
						tvs[2]+=nvarv[rvi1][1];
					}
			}
		}
	}

	if (ci==2)
	{
		while (tvs[0]<tvs[2])
		{
			for (j=start+1;j<end;++j){exc(j);}
			if(rvt0==2)
			{
				tvs[0]=nvarv[rvi0][0];
			}else{
					if(rvt0==3)
					{
						tvs[0]=nvarv[rvi0][0]<<16;
						tvs[0]+=nvarv[rvi0][1];
					}
			}
			if(rvt1==2)
			{
				tvs[2]=nvarv[rvi1][0];
			}else{
					if(rvt0==3)
					{
						tvs[2]=nvarv[rvi1][0]<<16;
						tvs[2]+=nvarv[rvi1][1];
					}
			}
		}
	}

	if (ci==3)
	{
		while (tvs[0]>=tvs[2])
		{
			for (j=start+1;j<end;++j){exc(j);}
			if(rvt0==2)
			{
				tvs[0]=nvarv[rvi0][0];
			}else{
					if(rvt0==3)
					{
						tvs[0]=nvarv[rvi0][0]<<16;
						tvs[0]+=nvarv[rvi0][1];
					}
			}
			if(rvt1==2)
			{
				tvs[2]=nvarv[rvi1][0];
			}else{
					if(rvt0==3)
					{
						tvs[2]=nvarv[rvi1][0]<<16;
						tvs[2]+=nvarv[rvi1][1];
					}
			}
		}
	}

	if (ci==4)
	{
		while (tvs[0]<=tvs[2])
		{
			for (j=start+1;j<end;++j){exc(j);}
			if(rvt0==2)
			{
				tvs[0]=nvarv[rvi0][0];
			}else{
					if(rvt0==3)
					{
						tvs[0]=nvarv[rvi0][0]<<16;
						tvs[0]+=nvarv[rvi0][1];
					}
			}
			if(rvt1==2)
			{
				tvs[2]=nvarv[rvi1][0];
			}else{
					if(rvt0==3)
					{
						tvs[2]=nvarv[rvi1][0]<<16;
						tvs[2]+=nvarv[rvi1][1];
					}
			}
		}
	}
	return(0);
}

//!!!

int pfor_(int start,int end)
{
	int		i,j,k,l,rvi;

	int		rv0,rvi0,rvt0;
	long		tvs[4];

	char		il[plinel];int	ili=0;
	char		tvarnl[vnaml];
	

	for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
	for(i=0;i<strlen(pf[start]);++i){il[ili]=pf[start][i];++ili;}

	j=0;
	for(i=0;i<ili;++i)
	{
		if
		(
			(il[0]=='f'&&il[1]=='o'&&il[i]=='#'&&il[i+1]=='=')||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='%'&&il[i+1]=='=')||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='&'&&il[i+1]=='=')
			||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='#'&&il[i+1]==' ')||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='%'&&il[i+1]==' ')||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='&'&&il[i+1]==' ')
			||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='#'&&il[i+1]=='\0')||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='%'&&il[i+1]=='\0')||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='&'&&il[i+1]=='\0')
		)
		{++j;}
	}

	if(j==1)
	{

		i=p_syntax_(il,b_for);

		tvs[0]=0;l=-1;
		for(j=-1+strlen(r_s[4]);j>=0;--j)
		{
			++l;tvs[0]+=(-48+r_s[4][j])*pow(10,l);
		}

		tvs[1]=0;l=-1;
		for(j=-1+strlen(r_s[8]);j>=0;--j)
		{
			++l;tvs[1]+=(-48+r_s[8][j])*pow(10,l);
		}

		for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
		for(j=0;j<-1+strlen(r_s[2]);++j){tvarnl[j]=r_s[2][j];}

		for(j=0;j<vi;++j)
		{
			if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
		}
		if(j!=vi)
		{
			if (tarv[rvi][1]==2||tarv[rvi][1]==3)
			{
				rvi0=rvi;
				if (tarv[rvi][1]==2)
				{
					rv0=nri[inri][0];
					rvt0=2;
				}
				if(tarv[rvi][1]==3)
				{
					rv0=(nri[inri][0]&0xffff0000)>>16;
					rv0+=(nri[inri][0]&0x00ffff)<<0;
					rvt0=3;
				}
			}

		}else{printf("reference err...%s\n",tvarnl);}
	
		for (i=tvs[0];i<=tvs[1];++i)
		{
			for(j=start+1;j<end;++j)
			{
				if(rvt0==2)
				{
					nvarv[rvi0][0]=tvs[0];
				}else{
						if(rvt0==3)
						{
							nvarv[rvi0][0]=((long)tvs[0]&0xffff0000)>>16;
							nvarv[rvi0][1]=(long)tvs[0]&0x0000ffff;
						}
				}
				//printf("%d %d %d %d\n",tvs[0],tvs[1],tvs[2],tvs[3]);
				exc(j);
			}	
			++tvs[0];
		}

		return(0);

	}

	if(j==2)
	{

		j=0;
		for(i=0;i<ili;++i)
		{
			if
			(
				(il[0]=='f'&&il[1]=='o'&&(il[i]>='0'&&il[i]<='9')&&il[i+1]==' ')||
				(il[0]=='f'&&il[1]=='o'&&(il[i]>='0'&&il[i]<='9')&&il[i+1]==' ')||
				(il[0]=='f'&&il[1]=='o'&&(il[i]>='0'&&il[i]<='9')&&il[i+1]==' ')
			){j=2;break;}

			if
			(
				(il[0]=='f'&&il[1]=='o'&&(il[i]>='0'&&il[i]<='9')&&il[i+1]=='\0')||
				(il[0]=='f'&&il[1]=='o'&&(il[i]>='0'&&il[i]<='9')&&il[i+1]=='\0')||
				(il[0]=='f'&&il[1]=='o'&&(il[i]>='0'&&il[i]<='9')&&il[i+1]=='\0')
			){j=1;break;}
		}

		if(j==1)
		{
			i=p_syntax_(il,b_for_1);

			tvs[1]=0;l=-1;
			for(j=-1+strlen(r_s[8]);j>=0;--j)
			{
				++l;tvs[1]+=(-48+r_s[8][j])*pow(10,l);
			}

			tvs[0]=0;
			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[4]);++j){tvarnl[j]=r_s[4][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{
				if (tarv[rvi][1]==2||tarv[rvi][1]==3)
				{
					if (tarv[rvi][1]==2)
					{
						tvs[0]=nvarv[tarv[rvi][0]][0];
					}
					if(tarv[rvi][1]==3)
					{
						tvs[0]=nvarv[tarv[rvi][0]][0]<<16;
						tvs[0]+=nvarv[tarv[rvi][0]][1];
					}
				}

			}else{printf("reference err...%s\n",tvarnl);}

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[2]);++j){tvarnl[j]=r_s[2][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{
				if (tarv[rvi][1]==2||tarv[rvi][1]==3)
				{
					rvi0=rvi;
					if (tarv[rvi][1]==2)
					{
						nvarv[tarv[rvi][0]][0]=tvs[0];
						rv0=tvs[0];
						rvt0=2;
					}
					if(tarv[rvi][1]==3)
					{
						nvarv[tarv[rvi][0]][0]=((long)tvs[0]&0xffff0000)>>16;
						nvarv[tarv[rvi][0]][1]=(long)tvs[0]&0x0000ffff;
						rv0=tvs[0];
						rvt0=3;
					}
				}

			}else{printf("reference err...%s\n",tvarnl);}

			for (i=tvs[0];i<=tvs[1];++i)
			{
				for(j=start+1;j<end;++j)
				{
					if(rvt0==2)
					{
						nvarv[rvi0][0]=tvs[0];
					}else{
							if(rvt0==3)
							{
								nvarv[rvi0][0]=((long)tvs[0]&0xffff0000)>>16;
								nvarv[rvi0][1]=(long)tvs[0]&0x0000ffff;
							}
					}
					//printf("%d %d %d %d\n",tvs[0],tvs[1],tvs[2],tvs[3]);
					exc(j);
				}	
				++tvs[0];
			}

			return(0);

		}else{

				i=p_syntax_(il,b_for_3);

				tvs[0]=0;l=-1;
				for(j=-1+strlen(r_s[4]);j>=0;--j)
				{
					++l;tvs[0]+=(-48+r_s[4][j])*pow(10,l);
				}

				tvs[1]=0;
				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				for(j=0;j<-1+strlen(r_s[8]);++j){tvarnl[j]=r_s[8][j];}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					if (tarv[rvi][1]==2||tarv[rvi][1]==3)
					{
						if (tarv[rvi][1]==2)
						{
							tvs[1]=nvarv[tarv[rvi][0]][0];
						}
						if(tarv[rvi][1]==3)
						{
							tvs[1]=nvarv[tarv[rvi][0]][0]<<16;
							tvs[1]+=nvarv[tarv[rvi][0]][1];
						}
					}

				}else{printf("reference err...%s\n",tvarnl);}

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				for(j=0;j<-1+strlen(r_s[2]);++j){tvarnl[j]=r_s[2][j];}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					if (tarv[rvi][1]==2||tarv[rvi][1]==3)
					{
						rvi0=rvi;
						if (tarv[rvi][1]==2)
						{
							nvarv[tarv[rvi][0]][0]=tvs[0];
							rv0=tvs[0];
							rvt0=2;
						}
						if(tarv[rvi][1]==3)
						{
							nvarv[tarv[rvi][0]][0]=((long)tvs[0]&0xffff0000)>>16;
							nvarv[tarv[rvi][0]][1]=(long)tvs[0]&0x0000ffff;
							rv0=tvs[0];
							rvt0=3;
						}
					}

				}else{printf("reference err...%s\n",tvarnl);}

				for (i=tvs[0];i<=tvs[1];++i)
				{
					for(j=start+1;j<end;++j)
					{
						if(rvt0==2)
						{
							nvarv[rvi0][0]=tvs[0];
						}else{
								if(rvt0==3)
								{
									nvarv[rvi0][0]=((long)tvs[0]&0xffff0000)>>16;
									nvarv[rvi0][1]=(long)tvs[0]&0x0000ffff;
								}
						}
						//printf("%d %d %d %d\n",tvs[0],tvs[1],tvs[2],tvs[3]);
						exc(j);
					}	
					++tvs[0];
				}

				return(0);
		}
	}

	if(j==3)
	{

		i=p_syntax_(il,b_for_2);

		tvs[0];
		for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
		for(j=0;j<-1+strlen(r_s[4]);++j){tvarnl[j]=r_s[4][j];}

		for(j=0;j<vi;++j)
		{
			if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
		}
		if(j!=vi)
		{
			if (tarv[rvi][1]==2||tarv[rvi][1]==3)
			{
				if (tarv[rvi][1]==2)
				{
					tvs[0]=nvarv[tarv[rvi][0]][0];
				}
				if(tarv[rvi][1]==3)
				{
					tvs[0]=nvarv[tarv[rvi][0]][0]<<16;
					tvs[0]+=nvarv[tarv[rvi][0]][1];
				}
			}

		}else{printf("reference err...%s\n",tvarnl);}

		tvs[1]=0;
		for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
		for(j=0;j<-1+strlen(r_s[8]);++j){tvarnl[j]=r_s[8][j];}

		for(j=0;j<vi;++j)
		{
			if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
		}
		if(j!=vi)
		{
			if (tarv[rvi][1]==2||tarv[rvi][1]==3)
			{
				if (tarv[rvi][1]==2)
				{
					tvs[1]=nvarv[tarv[rvi][0]][0];
				}
				if(tarv[rvi][1]==3)
				{
					tvs[1]=nvarv[tarv[rvi][0]][0]<<16;
					tvs[1]+=nvarv[tarv[rvi][0]][1];
				}
			}

		}else{printf("reference err...%s\n",tvarnl);}

		for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
		for(j=0;j<-1+strlen(r_s[2]);++j){tvarnl[j]=r_s[2][j];}

		for(j=0;j<vi;++j)
		{
			if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
		}
		if(j!=vi)
		{
			if (tarv[rvi][1]==2||tarv[rvi][1]==3)
			{
				rvi0=rvi;
				if (tarv[rvi][1]==2)
				{
					nvarv[tarv[rvi][0]][0]=tvs[0];
					rv0=tvs[0];
					rvt0=2;
				}
				if(tarv[rvi][1]==3)
				{
					nvarv[tarv[rvi][0]][0]=((long)tvs[0]&0xffff0000)>>16;
					nvarv[tarv[rvi][0]][1]=(long)tvs[0]&0x0000ffff;
					rv0=tvs[0];
					rvt0=3;
				}
			}

		}else{printf("reference err...%s\n",tvarnl);}
	
		for (i=tvs[0];i<=tvs[1];++i)
		{
			for(j=start+1;j<end;++j)
			{
				if(rvt0==2)
				{
					nvarv[rvi0][0]=tvs[0];
				}else{
						if(rvt0==3)
						{
							nvarv[rvi0][0]=((long)tvs[0]&0xffff0000)>>16;
							nvarv[rvi0][1]=(long)tvs[0]&0x0000ffff;
						}
				}
				//printf("%d %d %d %d\n",tvs[0],tvs[1],tvs[2],tvs[3]);
				exc(j);
			}	
			++tvs[0];
		}

		return(0);

	}

}

//!!!

int p_while_(int start,int end)
{

	int			i,j,k,l,rvi;

	char			il[plinel];int	ili=0;
	char			tvarnl[vnaml];

	double			fr;

	for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
	for(i=0;i<strlen(pf[start]);++i){il[ili]=pf[start][i];++ili;}

	nri[inri][3]=start;
	nri[inri][4]=end;

	j=0;
	for(i=0;i<ili-1;++i)
	{
		if
		(
			(il[0]=='w'&&il[1]=='h'&&il[i]=='#'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))||
			(il[0]=='w'&&il[1]=='h'&&il[i]=='%'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))||
			(il[0]=='w'&&il[1]=='h'&&il[i]=='&'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))
			||
			(il[0]=='w'&&il[1]=='h'&&il[i]=='#'&&il[i+1]==')')||
			(il[0]=='w'&&il[1]=='h'&&il[i]=='%'&&il[i+1]==')')||
			(il[0]=='w'&&il[1]=='h'&&il[i]=='&'&&il[i+1]==')')
		)
		{++j;}
	}

	if(j==1)
	{
		i=p_syntax_(il,b_while);

		if (1<=p_ex(il,">="))
		{
			nri[inri][2]=3;
		}else{
			if (1<=p_ex(il,"<="))
			{
				nri[inri][2]=4;
			}else{
				if (1<=p_ex(il,"="))
				{
					nri[inri][2]=0;
				}else{
					if (1<=p_ex(il,"<>"))
					{
						nri[inri][2]=5;
					}else{
						if (1<=p_ex(il,">"))
						{
							nri[inri][2]=1;
						}else{
							if (1<=p_ex(il,"<"))
							{
								nri[inri][2]=2;
							}
						}
					}
				}
			}
		}

		for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
		for(j=0;j<-1+strlen(r_s[1]);++j){tvarnl[j]=r_s[1][j];}

		for(j=0;j<vi;++j)
		{
			if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
		}
		if(j!=vi)
		{
			nri[inri][6]=tarv[rvi][1];
			nri[inri][5]=tarv[rvi][0];

			if(tarv[rvi][1]==2)
			{
				nri[inri][0]=nvarv[tarv[rvi][0]][0];
			}else{
				if(tarv[rvi][1]==3)
				{
					nri[inri][0]=nvarv[tarv[rvi][0]][0]<<16;
					nri[inri][0]+=nvarv[tarv[rvi][0]][1];
				}
			}

		}else{printf("reference err...%s\n",tvarnl);}

		nri[inri][1]=0;l=-1;
		for(j=-1+strlen(r_s[3]);j>=0;--j)
		{
			++l;nri[inri][1]+=(-48+r_s[3][j])*pow(10,l);
		}
		nri[inri][9]=15;
		++inri;
	}else{
		if(j==2)
		{

			i=p_syntax_(il,b_while_1);

			if (1<=p_ex(il,">="))
			{
				nri[inri][2]=3;
			}else{
				if (1<=p_ex(il,"<="))
				{
					nri[inri][2]=4;
				}else{
					if (1<=p_ex(il,"="))
					{
						nri[inri][2]=0;
					}else{
						if (1<=p_ex(il,"<>"))
						{
							nri[inri][2]=5;
						}else{
							if (1<=p_ex(il,">"))
							{
								nri[inri][2]=1;
							}else{
								if (1<=p_ex(il,"<"))
								{
									nri[inri][2]=2;
								}
							}
						}
					}
				}
			}

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[1]);++j){tvarnl[j]=r_s[1][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{
				nri[inri][6]=tarv[rvi][1];
				nri[inri][5]=tarv[rvi][0];

				if(tarv[rvi][1]==2)
				{
					nri[inri][0]=nvarv[tarv[rvi][0]][0];
				}else{
					if(tarv[rvi][1]==3)
					{
						nri[inri][0]=nvarv[tarv[rvi][0]][0]<<16;
						nri[inri][0]+=nvarv[tarv[rvi][0]][1];
					}
				}

			}else{printf("reference err...%s\n",tvarnl);}

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[3]);++j){tvarnl[j]=r_s[3][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{

				nri[inri][8]=tarv[rvi][1];
				nri[inri][7]=tarv[rvi][0];

				if(tarv[rvi][1]==2)
				{
					nri[inri][1]=nvarv[tarv[rvi][0]][0];
				}else{
					if(tarv[rvi][1]==3)
					{
						nri[inri][1]=nvarv[tarv[rvi][0]][0]<<16;
						nri[inri][1]+=nvarv[tarv[rvi][0]][1];
					}
				}

			}else{printf("reference err...%s\n",tvarnl);}
			nri[inri][9]=15;
			++inri;

		}else{return(0);}
	}
	return(0);

}

//!!!

int	p_for_(int start,int end)
{
	int			i,j,k,l,rvi;

	char			il[plinel];int	ili=0;
	char			tvarnl[vnaml];
	
	for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
	for(i=0;i<strlen(pf[start]);++i){il[ili]=pf[start][i];++ili;}

	j=0;
	for(i=0;i<ili;++i)
	{
		if
		(
			(il[0]=='f'&&il[1]=='o'&&il[i]=='#'&&il[i+1]=='=')||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='%'&&il[i+1]=='=')||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='&'&&il[i+1]=='=')
			||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='#'&&il[i+1]==' ')||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='%'&&il[i+1]==' ')||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='&'&&il[i+1]==' ')
			||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='#'&&il[i+1]=='\0')||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='%'&&il[i+1]=='\0')||
			(il[0]=='f'&&il[1]=='o'&&il[i]=='&'&&il[i+1]=='\0')
		)
		{++j;}
	}

	if(j==1)
	{

		nri[inri][3]=start;
		nri[inri][4]=end;

		i=p_syntax_(il,b_for);

		nri[inri][0]=0;l=-1;
		for(j=-1+strlen(r_s[4]);j>=0;--j)
		{
			++l;nri[inri][0]+=(-48+r_s[4][j])*pow(10,l);
		}
		cv[cvi]=nri[inri][0];
		iv[cvi][0]=-1;
		iv[cvi][1]=-1;
		++cvi;

		nri[inri][1]=0;l=-1;
		for(j=-1+strlen(r_s[8]);j>=0;--j)
		{
			++l;nri[inri][1]+=(-48+r_s[8][j])*pow(10,l);
		}

		for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
		for(j=0;j<-1+strlen(r_s[2]);++j){tvarnl[j]=r_s[2][j];}

		for(j=0;j<vi;++j)
		{
			if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
		}
		if(j!=vi)
		{
			if (tarv[rvi][1]==2||tarv[rvi][1]==3)
			{
				if (tarv[rvi][1]==2)
				{
					nvarv[tarv[rvi][0]][0]=nri[inri][0];
					nri[inri][6]=2;
				}
				if(tarv[rvi][1]==3)
				{
					nvarv[tarv[rvi][0]][0]=(nri[inri][0]&0xffff0000)>>16;
					nvarv[tarv[rvi][0]][1]=(nri[inri][0]&0x0000ffff)<<0;
					nri[inri][6]=3;
				}
			}

		}else{printf("reference err...%s\n",tvarnl);}

		nri[inri][2]=4;
		nri[inri][5]=tarv[rvi][0];
		nri[inri][9]=12;
		++inri;
	
		return(0);
	}

	if(j==2)
	{

		j=0;
		for(i=0;i<ili;++i)
		{
			if
			(
				(il[0]=='f'&&il[1]=='o'&&(il[i]>='0'&&il[i]<='9')&&il[i+1]==' ')||
				(il[0]=='f'&&il[1]=='o'&&(il[i]>='0'&&il[i]<='9')&&il[i+1]==' ')||
				(il[0]=='f'&&il[1]=='o'&&(il[i]>='0'&&il[i]<='9')&&il[i+1]==' ')
			){j=2;break;}

			if
			(
				(il[0]=='f'&&il[1]=='o'&&(il[i]>='0'&&il[i]<='9')&&il[i+1]=='\0')||
				(il[0]=='f'&&il[1]=='o'&&(il[i]>='0'&&il[i]<='9')&&il[i+1]=='\0')||
				(il[0]=='f'&&il[1]=='o'&&(il[i]>='0'&&il[i]<='9')&&il[i+1]=='\0')
			){j=1;break;}
		}

		if(j==1)
		{

			nri[inri][3]=start;
			nri[inri][4]=end;

			i=p_syntax_(il,b_for_1);

			nri[inri][1]=0;l=-1;
			for(j=-1+strlen(r_s[8]);j>=0;--j)
			{
				++l;nri[inri][1]+=(-48+r_s[8][j])*pow(10,l);
			}

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[4]);++j){tvarnl[j]=r_s[4][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{
				if (tarv[rvi][1]==2||tarv[rvi][1]==3)
				{
					if (tarv[rvi][1]==2)
					{
						nri[inri][0]=nvarv[tarv[rvi][0]][0];
						nri[inri][6]=2;
						cv[cvi]=nri[inri][0];
						iv[cvi][0]=tarv[rvi][0];
						iv[cvi][1]=tarv[rvi][1];
						++cvi;
					}
					if(tarv[rvi][1]==3)
					{
						nri[inri][0]=nvarv[tarv[rvi][0]][0]<<16;
						nri[inri][0]+=nvarv[tarv[rvi][0]][1];
						nri[inri][6]=3;
						cv[cvi]=nri[inri][0];
						iv[cvi][0]=tarv[rvi][0];
						iv[cvi][1]=tarv[rvi][1];
						++cvi;
					}
				}

			}else{printf("reference err...%s\n",tvarnl);}

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[2]);++j){tvarnl[j]=r_s[2][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{
				if (tarv[rvi][1]==2||tarv[rvi][1]==3)
				{
					if (tarv[rvi][1]==2)
					{
						nvarv[tarv[rvi][0]][0]=nri[inri][0];
						nri[inri][6]=2;
					}
					if(tarv[rvi][1]==3)
					{
						nvarv[tarv[rvi][0]][0]=(nri[inri][0]&0xffff0000)>>16;
						nvarv[tarv[rvi][0]][1]=(nri[inri][0]&0x0000ffff)<<0;
						nri[inri][6]=3;
					}
				}

			}else{printf("reference err...%s\n",tvarnl);}

			nri[inri][2]=4;
			nri[inri][5]=tarv[rvi][0];
			nri[inri][9]=12;
			++inri;
	
			return(0);

		}else{

				nri[inri][3]=start;
				nri[inri][4]=end;

				i=p_syntax_(il,b_for_3);

				nri[inri][0]=0;l=-1;
				for(j=-1+strlen(r_s[4]);j>=0;--j)
				{
					++l;nri[inri][0]+=(-48+r_s[4][j])*pow(10,l);
				}
				cv[cvi]=nri[inri][0];
				iv[cvi][0]=-1;
				iv[cvi][1]=-1;
				++cvi;

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				for(j=0;j<-1+strlen(r_s[8]);++j){tvarnl[j]=r_s[8][j];}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					if (tarv[rvi][1]==2||tarv[rvi][1]==3)
					{
						if (tarv[rvi][1]==2)
						{
							nri[inri][1]=nvarv[tarv[rvi][0]][0];
						}
						if(tarv[rvi][1]==3)
						{
							nri[inri][1]=nvarv[tarv[rvi][0]][0]<<16;
							nri[inri][1]+=nvarv[tarv[rvi][0]][1];
						}
					}

				}else{printf("reference err...%s\n",tvarnl);}

				for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
				for(j=0;j<-1+strlen(r_s[2]);++j){tvarnl[j]=r_s[2][j];}

				for(j=0;j<vi;++j)
				{
					if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
				}
				if(j!=vi)
				{
					if (tarv[rvi][1]==2||tarv[rvi][1]==3)
					{
						if (tarv[rvi][1]==2)
						{
							nvarv[tarv[rvi][0]][0]=nri[inri][0];
							nri[inri][6]=2;
						}
						if(tarv[rvi][1]==3)
						{
							nvarv[tarv[rvi][0]][0]=(nri[inri][0]&0xffff0000)>>16;
							nvarv[tarv[rvi][0]][1]=(nri[inri][0]&0x0000ffff)<<0;
							nri[inri][6]=3;
						}
					}

				}else{printf("reference err...%s\n",tvarnl);}

				nri[inri][2]=4;
				nri[inri][5]=tarv[rvi][0];
				nri[inri][9]=12;
				++inri;

				return(0);

		}

	}


	if(j==3)
	{
		nri[inri][3]=start;
		nri[inri][4]=end;

		i=p_syntax_(il,b_for_2);

		for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
		for(j=0;j<-1+strlen(r_s[8]);++j){tvarnl[j]=r_s[8][j];}

		for(j=0;j<vi;++j)
		{
			if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
		}
		if(j!=vi)
		{
			if (tarv[rvi][1]==2||tarv[rvi][1]==3)
			{
				if (tarv[rvi][1]==2)
				{
					nri[inri][1]=nvarv[tarv[rvi][0]][0];
				}
				if(tarv[rvi][1]==3)
				{
					nri[inri][1]=nvarv[tarv[rvi][0]][0]<<16;
					nri[inri][1]+=nvarv[tarv[rvi][0]][1];
				}
			}

		}else{printf("reference err...%s\n",tvarnl);}

		for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
		for(j=0;j<-1+strlen(r_s[4]);++j){tvarnl[j]=r_s[4][j];}

		for(j=0;j<vi;++j)
		{
			if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
		}
		if(j!=vi)
		{
			if (tarv[rvi][1]==2||tarv[rvi][1]==3)
			{
				if (tarv[rvi][1]==2)
				{
					nri[inri][0]=nvarv[tarv[rvi][0]][0];
					nri[inri][6]=2;
					cv[cvi]=nri[inri][0];
					iv[cvi][0]=tarv[rvi][0];
					iv[cvi][1]=tarv[rvi][1];
					++cvi;

				}
				if(tarv[rvi][1]==3)
				{
					nri[inri][0]=nvarv[tarv[rvi][0]][0]<<16;
					nri[inri][0]+=nvarv[tarv[rvi][0]][1];
					nri[inri][6]=3;
					cv[cvi]=nri[inri][0];
					iv[cvi][0]=tarv[rvi][0];
					iv[cvi][1]=tarv[rvi][1];
					++cvi;

				}
			}

		}else{printf("reference err...%s\n",tvarnl);}

		for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
		for(j=0;j<-1+strlen(r_s[2]);++j){tvarnl[j]=r_s[2][j];}

		for(j=0;j<vi;++j)
		{
			if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
		}
		if(j!=vi)
		{
			if (tarv[rvi][1]==2||tarv[rvi][1]==3)
			{
				if (tarv[rvi][1]==2)
				{
					nvarv[tarv[rvi][0]][0]=nri[inri][0];
					nri[inri][6]=2;
				}
				if(tarv[rvi][1]==3)
				{
					nvarv[tarv[rvi][0]][0]=(nri[inri][0]&0xffff0000)>>16;
					nvarv[tarv[rvi][0]][1]=(nri[inri][0]&0x0000ffff)<<0;
					nri[inri][6]=3;
				}
			}

		}else{printf("reference err...%s\n",tvarnl);}

		nri[inri][2]=4;
		nri[inri][5]=tarv[rvi][0];
		nri[inri][9]=12;
		++inri;
	
		return(0);
	}

	return(0);
}

//!!!

int	p_if_(int start,int end)
{
	int			i,j,k,l,rvi;

	char			il[plinel];int	ili=0;
	char			tvarnl[vnaml];
	
	double			fr;


	for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
	for(i=0;i<strlen(pf[start]);++i){il[ili]=pf[start][i];++ili;}

	nri[inri][3]=start;
	nri[inri][4]=end;

	j=0;
	for(i=0;i<ili-1;++i)
	{
		if
		(
			(il[0]=='i'&&il[1]=='f'&&il[i]=='#'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='%'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='&'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='$'&&(il[i+1]=='='||il[i+1]=='>'||il[i+1]=='<'))
			||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='#'&&il[i+1]==')')||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='%'&&il[i+1]==')')||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='&'&&il[i+1]==')')||
			(il[0]=='i'&&il[1]=='f'&&il[i]=='$'&&il[i+1]==')')
		)
		{++j;}
	}

	if(j==1)
	{
			i=p_syntax_(il,b_if_1);

			if (1<=p_ex(il,">="))
			{
				nri[inri][2]=3;
			}else{
				if (1<=p_ex(il,"<="))
				{
					nri[inri][2]=4;
				}else{
					if (1<=p_ex(il,"="))
					{
						nri[inri][2]=0;
					}else{
						if (1<=p_ex(il,"<>"))
						{
							nri[inri][2]=5;
						}else{
							if (1<=p_ex(il,">"))
							{
								nri[inri][2]=1;
							}else{
								if (1<=p_ex(il,"<"))
								{
									nri[inri][2]=2;
							}	}
						}
					}
				}
			}

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[2]);++j){tvarnl[j]=r_s[2][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{
				if (tarv[rvi][1]==2||tarv[rvi][1]==4)
				{
					//nri[inri][0]=nvarv[tarv[rvi][0]][0];
					//nri[inri][5]=tarv[rvi][0];
					//nri[inri][6]=2;

					if (tarv[rvi][1]==2)
					{
						nri[inri][0]=nvarv[tarv[rvi][0]][0];
						nri[inri][5]=tarv[rvi][0];
						nri[inri][6]=2;
					}else{
						nri[inri][0]=(long)dvarv[tarv[rvi][0]];
						nri[inri][5]=tarv[rvi][0];
						nri[inri][6]=4;
					}

				}else{
					if (tarv[rvi][1]==3)
					{
						nri[inri][0]=nvarv[tarv[rvi][0]][0]<<16;
						nri[inri][0]+=nvarv[tarv[rvi][0]][1];
						nri[inri][5]=tarv[rvi][0];
						nri[inri][6]=3;
					}else{
						if (tarv[rvi][1]==1)
						{
							k=0;
							for(j=0;j<strlen(cvarv[tarv[rvi][0]]);++j)
							{
								if
								(
									cvarv[tarv[rvi][0]][j]=='\''||
									cvarv[tarv[rvi][0]][j]=='"'
								)
								{}else{csL[k]=cvarv[tarv[rvi][0]][j];++k;}
							}for(j=k;j<plinel;++j){csL[k]='\0';++k;}
							nri[inri][5]=tarv[rvi][0];
							nri[inri][6]=1;
						}
					}
				}

			}else{printf("reference err...%s\n",tvarnl);}

			nri[inri][1]=(long)p_val(r_s[4]);

			nri[inri][7]=nri[inri][1];
			nri[inri][8]=-1;
			nri[inri][9]=13;	

			++inri;

	}else{
		if(j==2)
		{

			i=p_syntax_(il,b_if);

			if (1<=p_ex(il,">="))
			{
				nri[inri][2]=3;
			}else{
				if (1<=p_ex(il,"<="))
				{
					nri[inri][2]=4;
				}else{
					if (1<=p_ex(il,"="))
					{
						nri[inri][2]=0;
					}else{
						if (1<=p_ex(il,"<>"))
						{
							nri[inri][2]=5;
						}else{
							if (1<=p_ex(il,">"))
							{
								nri[inri][2]=1;
							}else{
								if (1<=p_ex(il,"<"))
								{
									nri[inri][2]=2;
								}
							}
						}
					}
				}
			}

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[2]);++j){tvarnl[j]=r_s[2][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{
				if (tarv[rvi][1]==2||tarv[rvi][1]==4)
				{
					//nri[inri][0]=nvarv[tarv[rvi][0]][0];
					//nri[inri][5]=tarv[rvi][0];
					//nri[inri][6]=2;

					if (tarv[rvi][1]==2)
					{
						nri[inri][0]=nvarv[tarv[rvi][0]][0];
						nri[inri][5]=tarv[rvi][0];
						nri[inri][6]=2;
					}else{
						nri[inri][0]=(long)dvarv[tarv[rvi][0]];
						nri[inri][5]=tarv[rvi][0];
						nri[inri][6]=4;
					}

				}else{
					if (tarv[rvi][1]==3)
					{
						nri[inri][0]=nvarv[tarv[rvi][0]][0]<<16;
						nri[inri][0]+=nvarv[tarv[rvi][0]][1];
						nri[inri][5]=tarv[rvi][0];
						nri[inri][6]=3;
					}else{
						if (tarv[rvi][1]==1)
						{
							k=0;
							for(j=0;j<strlen(cvarv[tarv[rvi][0]]);++j)
							{
								if
								(
									cvarv[tarv[rvi][0]][j]=='\''||
									cvarv[tarv[rvi][0]][j]=='"'
								)
								{}else{csL[k]=cvarv[tarv[rvi][0]][j];++k;}
							}for(j=k;j<plinel;++j){csL[k]='\0';++k;}
							nri[inri][5]=tarv[rvi][0];
							nri[inri][6]=1;
						}
					}
				}

			}else{printf("reference err...%s\n",tvarnl);}

			for(j=0;j<vnaml;++j){tvarnl[j]='\0';}
			for(j=0;j<-1+strlen(r_s[4]);++j){tvarnl[j]=r_s[4][j];}

			for(j=0;j<vi;++j)
			{
				if (1==p_comp(varnl[j],tvarnl)){rvi=j;break;}
			}
			if(j!=vi)
			{
				if (tarv[rvi][1]==2||tarv[rvi][1]==4)
				{

					//nri[inri][1]=nvarv[tarv[rvi][0]][0];
					//nri[inri][7]=tarv[rvi][0];
					//nri[inri][8]=2;

					if (tarv[rvi][1]==2)
					{
						nri[inri][1]=nvarv[tarv[rvi][0]][0];
						nri[inri][7]=tarv[rvi][0];
						nri[inri][8]=2;
					}else{
						nri[inri][1]=(long)dvarv[tarv[rvi][0]];
						nri[inri][7]=tarv[rvi][0];
						nri[inri][8]=4;
					}

				}else{
					if (tarv[rvi][1]==3)
					{
						nri[inri][1]=nvarv[tarv[rvi][0]][0]<<16;
						nri[inri][1]+=nvarv[tarv[rvi][0]][1];
						nri[inri][7]=tarv[rvi][0];
						nri[inri][8]=3;
					}else{
						if (tarv[rvi][1]==1)
						{
							k=0;
							for(j=0;j<strlen(cvarv[tarv[rvi][0]]);++j)
							{
								if
								(
									cvarv[tarv[rvi][0]][j]=='\''||
									cvarv[tarv[rvi][0]][j]=='"'
								)
								{}else{csR[k]=cvarv[tarv[rvi][0]][j];++k;}
							}for(j=k;j<plinel;++j){csR[k]='\0';++k;}
							nri[inri][7]=tarv[rvi][0];
							nri[inri][8]=1;
						}
					}
				}

			}else{printf("reference err...%s\n",tvarnl);}

			nri[inri][9]=13;	
			++inri;
		}
	}
	return(0);
}

//!!!

//parse -

int parse_d2(int start,int pid,int eid)
{

		bool	exitF;
		int		i,i0,i1,j,k;
		long	t;

		exitF=false;
		i1=start;i0=pid;
		while(exitF==false)
		{
			if (i1==nri[i0][3])
			{
				if (nri[i0][6]==-1&&nri[i0][5]>=0)
				{
					t=nri[i0][5];
					nri[i0][0]=t;
				}
				if (nri[i0][6]==1&&nri[i0][5]>=0)
				{
					k=0;
					for(j=0;j<strlen(cvarv[nri[i0][5]]);++j)
					{
						if
						(
							cvarv[nri[i0][5]][j]=='\''||
							cvarv[nri[i0][5]][j]=='"'
						)
						{}else{csL[k]=cvarv[nri[i0][5]][j];++k;}
					}for(j=k;j<plinel;++j){csL[k]='\0';++k;}
				if (nri[i0][8]==1&&nri[i0][7]>=0)
				{
					k=0;
					for(j=0;j<strlen(cvarv[nri[i0][7]]);++j)
					{
						if
						(
							cvarv[nri[i0][7]][j]=='\''||
							cvarv[nri[i0][7]][j]=='"'
						)
						{}else{csR[k]=cvarv[nri[i0][7]][j];++k;}
					}for(j=k;j<plinel;++j){csR[k]='\0';++k;}
					if (nri[i0][2]==0)
					{if(1==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==5)
					{if(1!=p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==1)
					{if(3==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==2)
					{if(2==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
				}
				}
				if (nri[i0][6]==2&&nri[i0][5]>=0)
				{
					t=nvarv[nri[i0][5]][0];
					nri[i0][0]=t;
				}
				if (nri[i0][6]==3&&nri[i0][5]>=0)
				{
					t=nvarv[nri[i0][5]][0]<<16;
					t+=nvarv[nri[i0][5]][1];
					nri[i0][0]=t;
				}
				if (nri[i0][8]==-1&&nri[i0][7]>=0)
				{
					t=nri[i0][7];
					nri[i0][1]=t;
				}
				if (nri[i0][8]==2&&nri[i0][7]>=0)
				{
					t=nvarv[nri[i0][7]][0];
					nri[i0][1]=t;
				}
				if (nri[i0][8]==3&&nri[i0][7]>=0)
				{
					t=nvarv[nri[i0][7]][0]<<16;
					t+=nvarv[nri[i0][7]][1];
					nri[i0][1]=t;
				}
				if (nri[i0][2]==0)
				{
					if(nri[i0][0]==nri[i0][1]){++i1;}else{exitF=true;}
				}
				if (nri[i0][2]==5)
				{
					if(nri[i0][0]!=nri[i0][1]){++i1;}else{exitF=true;}
				}
				if (nri[i0][2]==1)
				{	
					if(nri[i0][0]>nri[i0][1]){++i1;}else{exitF=true;}
				}
				if (nri[i0][2]==2)
				{	
					if(nri[i0][0]<nri[i0][1]){++i1;}else{exitF=true;}
				}
				if (nri[i0][2]==3)
				{	
					if(nri[i0][0]>=nri[i0][1]){++i1;}else{exitF=true;}
				}
				if (nri[i0][2]==4)
				{	
					if(nri[i0][0]<=nri[i0][1]){++i1;}else{exitF=true;}
				}			
			}else{
				if (i1==nri[i0][4])
				{
					exitF=true;
				}else{
					exc(i1);
					++i1;
				}
			}
		}

		for (i=0;i<iri;++i){if (nri[pid][4]==ri[i][0]){break;}}
		return(i);
}

int parse_while_2(int start,int pid,int eid)
{
	bool	exitF;
	int		i,i0,i1,j,k;
	long	t;

	exitF=false;
	i1=start;i0=pid;
	while(exitF==false)
	{
		if (i1==nri[i0][3])
		{
			if (nri[i0][6]==-1&&nri[i0][5]>=0)
			{
				t=nri[i0][5];
				nri[i0][0]=t;
			}
			if (nri[i0][6]==1&&nri[i0][5]>=0)
			{
				k=0;
				for(j=0;j<strlen(cvarv[nri[i0][5]]);++j)
				{
					if
					(
						cvarv[nri[i0][5]][j]=='\''||
						cvarv[nri[i0][5]][j]=='"'
					)
					{}else{csL[k]=cvarv[nri[i0][5]][j];++k;}
				}for(j=k;j<plinel;++j){csL[k]='\0';++k;}
				if (nri[i0][8]==1&&nri[i0][7]>=0)
				{
					k=0;
					for(j=0;j<strlen(cvarv[nri[i0][7]]);++j)
					{
						if
						(
							cvarv[nri[i0][7]][j]=='\''||
							cvarv[nri[i0][7]][j]=='"'
						)
						{}else{csR[k]=cvarv[nri[i0][7]][j];++k;}
					}for(j=k;j<plinel;++j){csR[k]='\0';++k;}
					if (nri[i0][2]==0)
					{if(1==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==5)
					{if(1!=p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==1)
					{if(3==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==2)
					{if(2==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
				}
			}
			if (nri[i0][6]==2&&nri[i0][5]>=0)
			{
				t=nvarv[nri[i0][5]][0];
				nri[i0][0]=t;
			}
			if (nri[i0][6]==3&&nri[i0][5]>=0)
			{
				t=nvarv[nri[i0][5]][0]<<16;
				t+=nvarv[nri[i0][5]][1];
				nri[i0][0]=t;
			}
			if (nri[i0][8]==-1&&nri[i0][7]>=0)
			{
				t=nri[i0][7];
				nri[i0][1]=t;
			}			
			if (nri[i0][8]==2&&nri[i0][7]>=0)
			{
				t=nvarv[nri[i0][7]][0];
				nri[i0][1]=t;
			}
			if (nri[i0][8]==3&&nri[i0][7]>=0)
			{
				t=nvarv[nri[i0][7]][0]<<16;
				t+=nvarv[nri[i0][7]][1];
				nri[i0][1]=t;
			}			
			if (nri[i0][2]==0)
			{						
				if(nri[i0][0]==nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==5)
			{						
				if(nri[i0][0]!=nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==1)
			{						
				if(nri[i0][0]>nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==2)
			{						
				if(nri[i0][0]<nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==3)
			{						
				if(nri[i0][0]>=nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==4)
			{						
				if(nri[i0][0]<=nri[i0][1]){++i1;}else{exitF=true;}
			}
		}else{
			if (i1==nri[i0][4])
			{
				i1=nri[i0][3];
			}else{
				for(j=pid+1;j<eid;++j)
				{
					if (i1==nri[j][3])
					{
						if(nri[j][9]==13)
						{
							i1=ri[parse_d2(i1,j,eid)][0];
							++i1;
							break;
						}
					}
				}
				if(j==eid)
				{
					exc(i1);
					++i1;
				}
			}
		}
	}

	for (i=0;i<iri;++i){if (nri[pid][4]==ri[i][0]){break;}}
	return(i);

}

int parse_if_2(int start,int pid,int eid)
{

	bool	exitF;
	int		i,i0,i1,j,k;
	long	t;

	exitF=false;
	i1=start;i0=pid;
	while(exitF==false)
	{
		if (i1==nri[i0][3])
		{
			if (nri[i0][6]==-1&&nri[i0][5]>=0)
			{
				t=nri[i0][5];
				nri[i0][0]=t;
			}
			if (nri[i0][6]==1&&nri[i0][5]>=0)
			{
				k=0;
				for(j=0;j<strlen(cvarv[nri[i0][5]]);++j)
				{
					if
					(
						cvarv[nri[i0][5]][j]=='\''||
						cvarv[nri[i0][5]][j]=='"'
					)
					{}else{csL[k]=cvarv[nri[i0][5]][j];++k;}
				}for(j=k;j<plinel;++j){csL[k]='\0';++k;}
				if (nri[i0][8]==1&&nri[i0][7]>=0)
				{
					k=0;
					for(j=0;j<strlen(cvarv[nri[i0][7]]);++j)
					{
						if
						(
							cvarv[nri[i0][7]][j]=='\''||
							cvarv[nri[i0][7]][j]=='"'
						)
						{}else{csR[k]=cvarv[nri[i0][7]][j];++k;}
					}for(j=k;j<plinel;++j){csR[k]='\0';++k;}
					if (nri[i0][2]==0)
					{if(1==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==5)
					{if(1!=p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==1)
					{if(3==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==2)
					{if(2==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
				}
			}
			if (nri[i0][6]==2&&nri[i0][5]>=0)
			{
				t=nvarv[nri[i0][5]][0];
				nri[i0][0]=t;
			}
			if (nri[i0][6]==3&&nri[i0][5]>=0)
			{
				t=nvarv[nri[i0][5]][0]<<16;
				t+=nvarv[nri[i0][5]][1];
				nri[i0][0]=t;
			}
			if (nri[i0][8]==-1&&nri[i0][7]>=0)
			{
				t=nri[i0][7];
				nri[i0][1]=t;
			}
			if (nri[i0][8]==2&&nri[i0][7]>=0)
			{
				t=nvarv[nri[i0][7]][0];
				nri[i0][1]=t;
			}
			if (nri[i0][8]==3&&nri[i0][7]>=0)
			{
				t=nvarv[nri[i0][7]][0]<<16;
				t+=nvarv[nri[i0][7]][1];
				nri[i0][1]=t;
			}
			if (nri[i0][2]==0)
			{
				if(nri[i0][0]==nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==5)
			{
				if(nri[i0][0]!=nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==1)
			{	
				if(nri[i0][0]>nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==2)
			{	
				if(nri[i0][0]<nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==3)
			{	
				if(nri[i0][0]>=nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==4)
			{	
				if(nri[i0][0]<=nri[i0][1]){++i1;}else{exitF=true;}
			}			
		}else{
			if (i1==nri[i0][4])
			{
				exitF=true;
			}else{
				for(j=pid+1;j<eid;++j)
				{
					if (i1==nri[j][3])
					{
						if(nri[j][9]==13)
						{
							i1=ri[parse_d2(i1,j,eid)][0];
							++i1;
							break;
						}
					}
				}
				if(j==eid)
				{
					exc(i1);
					++i1;
				}
			}
		}
	}

	for (i=0;i<iri;++i){if (nri[pid][4]==ri[i][0]){break;}}
	return(i);
}

int parse_for_2(int start, long cv[10],int pid,int eid)
{

	bool	exitF;
	int	i,j,i0,i1;
	long	t;

	i=-1;for(j=pid;j>=0;--j){if(nri[j][9]==12){++i;}}

	if(iv[i][0]==-1&&iv[i][1]==-1)
	{
		nri[pid][0]=cv[i];
		if (nri[pid][6]==2)
		{
			nvarv[nri[pid][5]][0]=cv[i];
		}
		if (nri[pid][6]==3)
		{
			nvarv[nri[pid][5]][0]=((long)cv[i]&0xffff0000)>>16;
			nvarv[nri[pid][5]][1]=((long)cv[i]&0x0000ffff);
		}
	}else{
		
		if (iv[i][1]==2)
		{
			nri[pid][0]=nvarv[iv[i][0]][0];

			if (nri[pid][6]==2)
			{
				nvarv[nri[pid][5]][0]=nvarv[iv[i][0]][0];
			}
			if (nri[pid][6]==3)
			{
				nvarv[nri[pid][5]][0]=((long)nvarv[iv[i][0]][0]&0xffff0000)>>16;
				nvarv[nri[pid][5]][1]=((long)nvarv[iv[i][0]][0]&0x0000ffff);
			}
		}
		if (iv[i][1]==3)
		{
			nri[pid][0]=nvarv[iv[i][0]][0]<<16;
			nri[pid][0]+=nvarv[iv[i][0]][1];

			if (nri[pid][6]==2)
			{
				nvarv[nri[pid][5]][0]=(int)nri[pid][0];
			}
			if (nri[pid][6]==3)
			{
				nvarv[nri[pid][5]][0]=nvarv[iv[i][0]][0];
				nvarv[nri[pid][5]][1]=nvarv[iv[i][0]][1];
			}
		}

	}

	exitF=false;i1=start;i0=pid;
	while(exitF==false)
	{				
		if (i1==nri[i0][3])
		{
			if (nri[i0][2]==4)
			{						
				if(nri[i0][0]<=nri[i0][1]){++i1;}else{exitF=true;}
			}
		}
		else{
			if (i1==nri[i0][4])
			{
				if (nri[i0][6]==2)
				{
					t=nvarv[nri[i0][5]][0];
					nri[i0][0]=t+1;
					nvarv[nri[i0][5]][0]=t+1;
				}
				if (nri[i0][6]==3)
				{
					t=nvarv[nri[i0][5]][0]<<16;
					t+=nvarv[nri[i0][5]][1];
					++t;
					nri[i0][0]=t;
					nvarv[nri[i0][5]][0]=((long)t&0xffff0000)>>16;
					nvarv[nri[i0][5]][1]=((long)t&0x0000ffff);
				}			
				i1=nri[i0][3];
			}else{
				for(j=pid+1;j<eid;++j)
				{
					if (i1==nri[j][3])
					{
						if(nri[j][9]==13)
						{
							i1=ri[parse_d2(i1,j,eid)][0];
							++i1;
							break;
						}
					}
				}
				if(j==eid)
				{
					exc(i1);
					++i1;
				}
			}
		}
	}

	for (i=0;i<iri;++i){if (nri[pid][4]==ri[i][0]){break;}}
	return(i);
}

int parse_while_1(int start,int pid,int eid)
{
	bool	exitF;
	int		i,i0,i1,j,k;
	long	t;

	exitF=false;
	i1=start;i0=pid;
	while(exitF==false)
	{
		if (i1==nri[i0][3])
		{
			if (nri[i0][6]==-1&&nri[i0][5]>=0)
			{
				t=nri[i0][5];
				nri[i0][0]=t;
			}
			if (nri[i0][6]==1&&nri[i0][5]>=0)
			{
				k=0;
				for(j=0;j<strlen(cvarv[nri[i0][5]]);++j)
				{
					if
					(
						cvarv[nri[i0][5]][j]=='\''||
						cvarv[nri[i0][5]][j]=='"'
					)
					{}else{csL[k]=cvarv[nri[i0][5]][j];++k;}
				}for(j=k;j<plinel;++j){csL[k]='\0';++k;}
				if (nri[i0][8]==1&&nri[i0][7]>=0)
				{
					k=0;
					for(j=0;j<strlen(cvarv[nri[i0][7]]);++j)
					{
						if
						(
							cvarv[nri[i0][7]][j]=='\''||
							cvarv[nri[i0][7]][j]=='"'
						)
						{}else{csR[k]=cvarv[nri[i0][7]][j];++k;}
					}for(j=k;j<plinel;++j){csR[k]='\0';++k;}
					if (nri[i0][2]==0)
					{if(1==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==5)
					{if(1!=p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==1)
					{if(3==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==2)
					{if(2==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
				}
			}
			if (nri[i0][6]==2&&nri[i0][5]>=0)
			{
				t=nvarv[nri[i0][5]][0];
				nri[i0][0]=t;
			}
			if (nri[i0][6]==3&&nri[i0][5]>=0)
			{
				t=nvarv[nri[i0][5]][0]<<16;
				t+=nvarv[nri[i0][5]][1];
				nri[i0][0]=t;
			}
			if (nri[i0][8]==-1&&nri[i0][7]>=0)
			{
				t=nri[i0][7];
				nri[i0][1]=t;
			}			
			if (nri[i0][8]==2&&nri[i0][7]>=0)
			{
				t=nvarv[nri[i0][7]][0];
				nri[i0][1]=t;
			}
			if (nri[i0][8]==3&&nri[i0][7]>=0)
			{
				t=nvarv[nri[i0][7]][0]<<16;
				t+=nvarv[nri[i0][7]][1];
				nri[i0][1]=t;
			}			
			if (nri[i0][2]==0)
			{						
				if(nri[i0][0]==nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==5)
			{						
				if(nri[i0][0]!=nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==1)
			{						
				if(nri[i0][0]>nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==2)
			{						
				if(nri[i0][0]<nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==3)
			{						
				if(nri[i0][0]>=nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==4)
			{						
				if(nri[i0][0]<=nri[i0][1]){++i1;}else{exitF=true;}
			}
		}else{
			if (i1==nri[i0][4])
			{
				i1=nri[i0][3];
			}else{
				for(j=pid+1;j<eid;++j)
				{
					if (i1==nri[j][3])
					{
						if(nri[j][9]==13)
						{
							i1=ri[parse_if_2(i1,j,eid)][0];
							++i1;
							break;
						}
						if(nri[j][9]==12)
						{
							i1=ri[parse_for_2(i1,cv,j,eid)][0];
							++i1;
							break;
						}
						if(nri[j][9]==15)
						{
							i1=ri[parse_while_2(i1,j,eid)][0];
							++i1;
							break;
						}
					}
				}
				if(j==eid)
				{
					exc(i1);
					++i1;
				}
			}
		}
	}

	for (i=0;i<iri;++i){if (nri[pid][4]==ri[i][0]){break;}}
	return(i);
}

int parse_if_1(int start,int pid,int eid)
{

	bool	exitF;
	int		i,i0,i1,j,k;
	long	t;

	exitF=false;
	i1=start;i0=pid;
	while(exitF==false)
	{
		if (i1==nri[i0][3])
		{
			if (nri[i0][6]==-1&&nri[i0][5]>=0)
			{
				t=nri[i0][5];
				nri[i0][0]=t;
			}
			if (nri[i0][6]==1&&nri[i0][5]>=0)
			{
				k=0;
				for(j=0;j<strlen(cvarv[nri[i0][5]]);++j)
				{
					if
					(
						cvarv[nri[i0][5]][j]=='\''||
						cvarv[nri[i0][5]][j]=='"'
					)
					{}else{csL[k]=cvarv[nri[i0][5]][j];++k;}
				}for(j=k;j<plinel;++j){csL[k]='\0';++k;}
				if (nri[i0][8]==1&&nri[i0][7]>=0)
				{
					k=0;
					for(j=0;j<strlen(cvarv[nri[i0][7]]);++j)
					{
						if
						(
							cvarv[nri[i0][7]][j]=='\''||
							cvarv[nri[i0][7]][j]=='"'
						)
						{}else{csR[k]=cvarv[nri[i0][7]][j];++k;}
					}for(j=k;j<plinel;++j){csR[k]='\0';++k;}
					if (nri[i0][2]==0)
					{if(1==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==5)
					{if(1!=p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==1)
					{if(3==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
					if (nri[i0][2]==2)
					{if(2==p_comp(csL,csR)){++i1;}else{i1=nri[i0][4];}continue;}
				}
			}
			if (nri[i0][6]==2&&nri[i0][5]>=0)
			{
				t=nvarv[nri[i0][5]][0];
				nri[i0][0]=t;
			}
			if (nri[i0][6]==3&&nri[i0][5]>=0)
			{
				t=nvarv[nri[i0][5]][0]<<16;
				t+=nvarv[nri[i0][5]][1];
				nri[i0][0]=t;
			}
			if (nri[i0][8]==-1&&nri[i0][7]>=0)
			{
				t=nri[i0][7];
				nri[i0][1]=t;
			}
			if (nri[i0][8]==2&&nri[i0][7]>=0)
			{
				t=nvarv[nri[i0][7]][0];
				nri[i0][1]=t;
			}
			if (nri[i0][8]==3&&nri[i0][7]>=0)
			{
				t=nvarv[nri[i0][7]][0]<<16;
				t+=nvarv[nri[i0][7]][1];
				nri[i0][1]=t;
			}
			if (nri[i0][2]==0)
			{
				if(nri[i0][0]==nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==5)
			{
				if(nri[i0][0]!=nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==1)
			{	
				if(nri[i0][0]>nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==2)
			{	
				if(nri[i0][0]<nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==3)
			{	
				if(nri[i0][0]>=nri[i0][1]){++i1;}else{exitF=true;}
			}
			if (nri[i0][2]==4)
			{	
				if(nri[i0][0]<=nri[i0][1]){++i1;}else{exitF=true;}
			}			
		}else{
			if (i1==nri[i0][4])
			{
				exitF=true;
			}else{
				for(j=pid+1;j<eid;++j)
				{
					if (i1==nri[j][3])
					{
						if(nri[j][9]==13)
						{
							i1=ri[parse_if_2(i1,j,eid)][0];
							++i1;
							break;
						}
						if(nri[j][9]==12)
						{
							i1=ri[parse_for_2(i1,cv,j,eid)][0];
							++i1;
							break;
						}
						if(nri[j][9]==15)
						{
							i1=ri[parse_while_2(i1,j,eid)][0];
							++i1;
							break;
						}
					}
				}
				if(j==eid)
				{
					exc(i1);
					++i1;
				}
			}
		}
	}

	for (i=0;i<iri;++i){if (nri[pid][4]==ri[i][0]){break;}}
	return(i);
}

int parse_for_1(int start, long cv[10],int pid,int eid)
{

	bool	exitF;
	int	i,j,i0,i1;
	long	t;

	nri[pid][0]=cv[pid];
	if (nri[pid][6]==2)
	{
		nvarv[nri[pid][5]][0]=cv[pid];
	}
	if (nri[pid][6]==3)
	{
		nvarv[nri[pid][5]][0]=((long)cv[pid]&0xffff0000)>>16;
		nvarv[nri[pid][5]][1]=((long)cv[pid]&0x0000ffff);
	}

	exitF=false;i1=start;i0=pid;
	while(exitF==false)
	{				
		if (i1==nri[i0][3])
		{
			if (nri[i0][2]==4)
			{						
				if(nri[i0][0]<=nri[i0][1]){++i1;}else{exitF=true;}
			}
		}
		else{
			if (i1==nri[i0][4])
			{
				if (nri[i0][6]==2)
				{
					t=nvarv[nri[i0][5]][0];
					nri[i0][0]=t+1;
					nvarv[nri[i0][5]][0]=t+1;
				}
				if (nri[i0][6]==3)
				{
					t=nvarv[nri[i0][5]][0]<<16;
					t+=nvarv[nri[i0][5]][1];
					++t;
					nri[i0][0]=t;
					nvarv[nri[i0][5]][0]=((long)t&0xffff0000)>>16;
					nvarv[nri[i0][5]][1]=((long)t&0x0000ffff);
				}			
				i1=nri[i0][3];
			}else{
				for(j=pid+1;j<eid;++j)
				{
					if (i1==nri[j][3])
					{
						if(nri[j][9]==13)
						{
							i1=ri[parse_if_2(i1,j,eid)][0];
							++i1;
							break;
						}
						if(nri[j][9]==12)
						{
							i1=ri[parse_for_2(i1,cv,j,eid)][0];
							++i1;
							break;
						}
						if(nri[j][9]==15)
						{
							i1=ri[parse_while_2(i1,j,eid)][0];
							++i1;
							break;
						}
					}
				}
				if(j==eid)
				{
					exc(i1);
					++i1;
				}
			}
		}
	}

	for (i=0;i<iri;++i){if (nri[pid][4]==ri[i][0]){break;}}
	return(i);

}

//parse -

int parse()
{
	int			i,j,k,l,m,n;
	char			il[plinel];int	ili=0;
	int			fbyte;
	bool			cl;
	bool			inb=0;
	int			inbt=0;
	int			inbri=0;
	int			linn=0;
	int			s,e,e1;
	int			forinbt=0;
	int			ifinbt=0;
	int			whileinbt=0;
	int			subinbt=0;
	int			exlin=0;
	bool			in;

	linn=0;
	
	for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
	for(i=0;i<r_strlen(pf[linn]);++i){il[ili]=pf[linn][i];++ili;}

	inb=false;inbt=0;iri=0;eri=1;
	
	ri[iri][1]=0;ri[iri][2]=0;ri[iri][3]=0;
	ri[iri][4]=0;ri[iri][5]=0;ri[iri][6]=0;
	
	vi=0;ci=0;ni=0;dni=0;
	for(i=0;i<maxv;++i){for(j=0;j<vnaml;++j){varnl[i][j]='\0';}}
	for(i=0;i<maxv;++i){for(j=0;j<plinel;++j){cvarv[i][j]='\0';}}

	forinbt=0;ifinbt=0;whileinbt=0;
	subinbt=0;
	
	while(1!=p_comp(il,"end")&&linn<maxv)
	{
//exc
		//printf("%d-%d %d %d %d %d %d\n",linn,ri[iri-1][0],ri[iri-1][1],ri[iri-1][2],ri[iri-1][3],ri[iri-1][4],ri[iri-1][5]);
		if 
		(

			ifinbt>=1||
			forinbt>=1||
			whileinbt>=1

		){inb=true;}else{inb=false;}

		p_syntax_(il,p_exp);

		if
		(
			r_s[2][0]=='='&&
			r_s[2][1]=='\0'&&
			(
				r_s[3][0]=='-'||
				r_s[3][0]=='+'||
				r_s[3][0]=='\''||
				r_s[3][0]=='\"'||
				(r_s[3][0]>='0'&&r_s[3][0]<='9')
			)
			&&
			(
				r_s[4][0]=='\0'||
				r_s[4][0]=='-'||
				r_s[4][0]=='+'
			)
			&&
			(
				r_s[5][0]=='\0'||
				r_s[5][0]=='-'||
				r_s[5][0]=='+'
			)
		)
		{

				if (inb==false)
				{
					ri[iri][0]=linn;
					ri[iri][1]=0;
					ri[iri][2]=0;
					ri[iri][3]=0;
					ri[iri][4]=0;
					ri[iri][5]=0;
					ri[iri][6]=0;
					eri=1;
					ri[iri][eri]=11;
				}else{
						ri[iri][0]=linn;
						ri[iri][1]=ri[iri-1][1];
						ri[iri][2]=ri[iri-1][2];
						ri[iri][3]=ri[iri-1][3];
						ri[iri][4]=ri[iri-1][4];
						ri[iri][5]=ri[iri-1][5];
						ri[iri][6]=ri[iri-1][6];

						j=ifinbt+whileinbt+forinbt;
						if (j==0){j=1;}

						for (i=6;i>j;--i){ri[iri][i]=0;}
					
						if (ri[iri][j]==1)
						{
							eri=j;
						}else{
							if (ri[iri][j]==0)
							{
								ri[iri][j]==11;
								eri=j;
							}else{	
								ri[iri][j+1]=11;
								eri=j+1;
							}
						}
				}
				++iri;

				++linn;
				for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
				for(i=0;i<r_strlen(pf[linn]);++i){il[ili]=pf[linn][i];++ili;}
				continue;
	
		}

		if
		(
			r_s[2][0]=='='&&
			(r_s[2][1]=='\0'||r_s[2][1]=='(')&&
			(
				r_s[5][0]=='+'||
				r_s[5][0]=='-'||
				r_s[5][0]=='*'||
				r_s[5][0]=='/'||
				r_s[5][0]=='^'||
				r_s[5][0]=='>'||
				r_s[5][0]=='<'||
				r_s[5][0]=='='
			)
		)
		{
				if (inb==false)
				{
					ri[iri][0]=linn;
					ri[iri][1]=0;
					ri[iri][2]=0;
					ri[iri][3]=0;
					ri[iri][4]=0;
					ri[iri][5]=0;
					ri[iri][6]=0;
					eri=1;
					ri[iri][eri]=1;
				}else{
					ri[iri][0]=linn;
					ri[iri][1]=ri[iri-1][1];
					ri[iri][2]=ri[iri-1][2];
					ri[iri][3]=ri[iri-1][3];
					ri[iri][4]=ri[iri-1][4];
					ri[iri][5]=ri[iri-1][5];
					ri[iri][6]=ri[iri-1][6];

					j=ifinbt+whileinbt+forinbt;
					if (j==0){j=1;}

					for (i=6;i>j;--i){ri[iri][i]=0;}
					
					if (ri[iri][j]==1)
					{
						eri=j;
					}else{
						if (ri[iri][j]==0)
						{
							ri[iri][j]==1;
							eri=j;
						}else{	
							ri[iri][j+1]=1;
							eri=j+1;
						}
					}
				}
				++iri;

				++linn;
				for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
				for(i=0;i<r_strlen(pf[linn]);++i){il[ili]=pf[linn][i];++ili;}
				continue;
			
		}

		cl=false;k=-1;
		for(j=0;j<mc;++j){if (1<=p_ex(il,kw[j])){cl=true;k=j;break;}}

		if 
		(
			(
				cl&&
				(k!=-1)&&
				(
					1<=p_ex(kw[k],"print ")     ||
					1<=p_ex(kw[k],"=mid$(")     ||
					1<=p_ex(kw[k],"=trim$(")    ||
					1<=p_ex(kw[k],"=left$(")    ||
					1<=p_ex(kw[k],"=right$(")   ||
					1<=p_ex(kw[k],"=len$(")     ||
					1<=p_ex(kw[k],"=val$(")     ||
					1<=p_ex(kw[k],"=format$(")  ||
					1<=p_ex(kw[k],"=round$(")
				)
			)
			||
			(
				cl&&
				(k!=-1)&&
				(
					1<=p_ex(il,"input #")       ||
					1<=p_ex(il,"for input as")  ||
					1<=p_ex(il,"for output as") ||
					1<=p_ex(il,"close #")
				)
			)
		)
		{
			if (inb==false)
			{
				ri[iri][0]=linn;
				ri[iri][1]=0;
				ri[iri][2]=0;
				ri[iri][3]=0;
				ri[iri][4]=0;
				ri[iri][5]=0;
				ri[iri][6]=0;
				eri=1;
				ri[iri][eri]=1;
			}else{
				ri[iri][0]=linn;
				ri[iri][1]=ri[iri-1][1];
				ri[iri][2]=ri[iri-1][2];
				ri[iri][3]=ri[iri-1][3];
				ri[iri][4]=ri[iri-1][4];
				ri[iri][5]=ri[iri-1][5];
				ri[iri][6]=ri[iri-1][6];

				j=ifinbt+whileinbt+forinbt;
				if (j==0){j=1;}

				for (i=6;i>j;--i){ri[iri][i]=0;}
					
				if (ri[iri][j]==1)
				{
					eri=j;
				}else{
					if (ri[iri][j]==0)
					{
						ri[iri][j]==1;
						eri=j;
					}else{	
						ri[iri][j+1]=1;
						eri=j+1;
					}
				}
			}
			++iri;

			++linn;
			for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
			for(i=0;i<r_strlen(pf[linn]);++i){il[ili]=pf[linn][i];++ili;}
			continue;
		}

		if (cl)
		{
			if ((1<=p_ex(il,"for ")&&1<=p_ex(il," to "))||1<=p_ex(il,"next"))
			{
				if (inb==false)
				{
					ri[iri][1]=0;
					ri[iri][2]=0;
					ri[iri][3]=0;
					ri[iri][4]=0;
					ri[iri][5]=0;
					ri[iri][6]=0;
					eri=1;
				}else{
					ri[iri][1]=ri[iri-1][1];
					ri[iri][2]=ri[iri-1][2];
					ri[iri][3]=ri[iri-1][3];
					ri[iri][4]=ri[iri-1][4];
					ri[iri][5]=ri[iri-1][5];
					ri[iri][6]=ri[iri-1][6];
					j=ifinbt+whileinbt+forinbt;
					if (j==0){j=1;}
					for (i=6;i>j;--i){ri[iri][i]=0;}
				}
				ri[iri][0]=linn;
				if (1<=p_ex(il,"for ")&&1<=p_ex(il," to "))
				{
					j=ifinbt+whileinbt+forinbt;
					if (j==0){j=1;}
					for (i=6;i>j;--i){ri[iri][i]=0;}

					if (ri[iri][j]==1)
					{
						ri[iri][j]==12;
						eri=j;
					}else{
						if (ri[iri][j]==0)
						{
							ri[iri][j]=12;
							eri=j;
						}else{
							ri[iri][j+1]=12;
							eri=j+1;
						}
					}
					inb=true;
					++forinbt;
					++iri;

					++linn;
					for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
					for(i=0;i<r_strlen(pf[linn]);++i){il[ili]=pf[linn][i];++ili;}
					continue;
				}
				if (1<=p_ex(il,"next"))
				{
					--forinbt;
					if (forinbt==0)
					{
						if
						(
							ifinbt>=1||
							whileinbt>=1
						)
						{
							ri[iri][ifinbt+whileinbt+1]=12;
							ri[iri][ifinbt+whileinbt+1+1]=0;
							eri=ifinbt+whileinbt;
						}else{
							eri=1;
							ri[iri][1]=12;
							ri[iri][2]=0;
							ri[iri][3]=0;
							ri[iri][4]=0;
							ri[iri][5]=0;
							ri[iri][6]=0;
						}
					}else{
						if
						(
							ifinbt>=1||
							whileinbt>=1
						)
						{
							ri[iri][ifinbt+whileinbt+forinbt+1]=12;
							ri[iri][ifinbt+whileinbt+forinbt+1+1]=0;
							eri=ifinbt+whileinbt+forinbt;
						}else{
							ri[iri][forinbt+1]=12;
							ri[iri][forinbt+1+1]=0;
							eri=forinbt;
						}
					}				
					++iri;

					++linn;
					for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
					for(i=0;i<r_strlen(pf[linn]);++i){il[ili]=pf[linn][i];++ili;}
					continue;
				}
			}
			if 
			(
				1<=p_ex(il,"while (")||
				1<=p_ex(il,"wend")
			)
			{
				if (inb==false)
				{
					ri[iri][1]=0;
					ri[iri][2]=0;
					ri[iri][3]=0;
					ri[iri][4]=0;
					ri[iri][5]=0;
					ri[iri][6]=0;
					eri=1;
				}else{
					ri[iri][1]=ri[iri-1][1];
					ri[iri][2]=ri[iri-1][2];
					ri[iri][3]=ri[iri-1][3];
					ri[iri][4]=ri[iri-1][4];
					ri[iri][5]=ri[iri-1][5];
					ri[iri][6]=ri[iri-1][6];

					j=ifinbt+whileinbt+forinbt;
					if (j==0){j=1;}
					for (i=6;i>j;--i){ri[iri][i]=0;}
				}
				ri[iri][0]=linn;
				if(1<=p_ex(il,"while ("))
				{
					j=ifinbt+whileinbt+forinbt;
					if (j==0){j=1;}
					for (i=6;i>j;--i){ri[iri][i]=0;}
					if (ri[iri][j]==1)
					{
						ri[iri][j]==15;
						eri=j;
					}else{
						if(ri[iri][j]==0)
						{
							ri[iri][j]=15;
							eri=j;
						}else{
							ri[iri][j+1]=15;
							eri=j+1;
						}
					}
					inb=true;
					++whileinbt;
					++iri;

					++linn;
					for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
					for(i=0;i<r_strlen(pf[linn]);++i){il[ili]=pf[linn][i];++ili;}
					continue;
				}
				if(1<=p_ex(il,"wend"))
				{
					--whileinbt;
					if(whileinbt==0)
					{
						if 
						(
							ifinbt>=1||
							forinbt>=1
						)
						{
							ri[iri][ifinbt+forinbt+1]=15;
							ri[iri][ifinbt+forinbt+1+1]=0;
							eri=ifinbt+forinbt;
						}else{
							eri=1;
							ri[iri][1]=15;
							ri[iri][2]=0;
							ri[iri][3]=0;
							ri[iri][4]=0;
							ri[iri][5]=0;
							ri[iri][6]=0;
						}
					}else{
						if (ifinbt>=1||forinbt>=1)
						{
							ri[iri][ifinbt+whileinbt+forinbt+1]=15;
							ri[iri][ifinbt+whileinbt+forinbt+1+1]=0;
							eri=ifinbt+whileinbt+forinbt;
						}else{
							ri[iri][whileinbt+1]=15;
							ri[iri][whileinbt+1+1]=0;
							eri=whileinbt;
						}
					}
					++iri;

					++linn;
					for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
					for(i=0;i<r_strlen(pf[linn]);++i){il[ili]=pf[linn][i];++ili;}
					continue;
				}
			}
			if 
			(
				(1<=p_ex(il,"if (")&&1<=p_ex(il," then"))||
				1<=p_ex(il,"end if")
			)
			{
				if (inb==false)
				{
					ri[iri][1]=0;
					ri[iri][2]=0;
					ri[iri][3]=0;
					ri[iri][4]=0;
					ri[iri][5]=0;
					ri[iri][6]=0;
					eri=1;
				}else{
					ri[iri][1]=ri[iri-1][1];
					ri[iri][2]=ri[iri-1][2];
					ri[iri][3]=ri[iri-1][3];
					ri[iri][4]=ri[iri-1][4];
					ri[iri][5]=ri[iri-1][5];
					ri[iri][6]=ri[iri-1][6];

					j=ifinbt+whileinbt+forinbt;
					if (j==0){j=1;}
					for (i=6;i>j;--i){ri[iri][i]=0;}
				}
				ri[iri][0]=linn;
				if (1<=p_ex(il,"if (")&&1<=p_ex(il," then"))
				{
					j=ifinbt+whileinbt+forinbt;
					if (j==0){j=1;}
					for (i=6;i>j;--i){ri[iri][i]=0;}

					if (ri[iri][j]==1)
					{
						ri[iri][j]==13;
						eri=j;
					}else{
						if (ri[iri][j]==0)
						{
							ri[iri][j]=13;
							eri=j;
						}else{
							ri[iri][j+1]=13;
							eri=j+1;
						}
					}
					inb=true;
					++ifinbt;
					++iri;

					++linn;
					for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
					for(i=0;i<r_strlen(pf[linn]);++i){il[ili]=pf[linn][i];++ili;}
					continue;
				}
				if (1<=p_ex(il,"end if"))
				{
					--ifinbt;
					if (ifinbt==0)
					{	
						if (forinbt>=1||whileinbt>=1)
						{
							ri[iri][forinbt+whileinbt+1]=13;
							ri[iri][forinbt+whileinbt+1+1]=0;
							eri=forinbt+whileinbt;
						}else{
							eri=1;
							ri[iri][1]=13;
							ri[iri][2]=0;
							ri[iri][3]=0;
							ri[iri][4]=0;
							ri[iri][5]=0;
							ri[iri][6]=0;
						}
					}else{
						if (forinbt>=1||whileinbt>=1)
						{
							ri[iri][forinbt+whileinbt+ifinbt+1]=13;
							ri[iri][forinbt+whileinbt+ifinbt+1+1]=0;
							eri=forinbt+whileinbt+ifinbt;
						}else{
							ri[iri][ifinbt+1]=13;
							ri[iri][ifinbt+1+1]=0;
							eri=ifinbt;
						}
					}
					++iri;

					++linn;
					for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
					for(i=0;i<r_strlen(pf[linn]);++i){il[ili]=pf[linn][i];++ili;}
					continue;
				}
	
			}
		}

		++linn;
		for(i=0;i<plinel;++i){il[i]='\0';}ili=0;
		for(i=0;i<r_strlen(pf[linn]);++i){il[ili]=pf[linn][i];++ili;}
	}

//exc
// parse +

	exlin=0;
	for (i=0;i<iri;++i)
	{

		//printf("%d %d %d %d %d %d\n",ri[i][0],ri[i][1],ri[i][2],ri[i][3],ri[i][4],ri[i][5]);

		if (ri[i][1]==1){exc(ri[i][0]);++exlin;}
		if (ri[i][1]==11){vdcl_(ri[i][0]);++exlin;}

		if (ri[i][1]==12&&ri[i][2]==0)
		{

			s=ri[i][0];l=1;
			for (j=i+1;j<iri;++j)
			{
				if 
				(
					ri[j][1]==12&&
					(ri[j][2]==0||ri[j][2]==1)

				){if(ri[j][2]==0){++l;if(l==2){++j;break;}}}else{break;}
			}
			if (l==2)
			{
				e=ri[j-1][0];
				pfor_(s,e);
				exlin+=e-s+1;
				i=j-1;
				continue;
			}else{

				for(l=0;l<maxv;++l)
				{
					nri[l][0]=0;nri[l][1]=0;nri[l][2]=0;nri[l][3]=0;nri[l][4]=0;
					nri[l][5]=0;nri[l][6]=0;nri[l][7]=0;nri[l][8]=0;nri[l][9]=0;
				}inri=0;
				for(l=0;l<10;++l){cv[l]=0;iv[l][0]=-1;iv[l][1]=-1;}cvi=0;
				e=-1;

				for (l=i+1;l<iri;++l)
				{
					if
					(
						ri[i][1]==ri[l][1]&&
						ri[i][2]==ri[l][2]&&
						0==ri[l][2]
					)
					{
						p_for_(s,ri[l][0]);
						e=l;
						break;
					}
				}

				for (k=i+1;k<e;++k)
				{
					if 
					(
						ri[k][1]==12&&
						(ri[k][2]==12||ri[k][2]==13||ri[k][2]==15)&&
						ri[k][3]==0
					)
					{

						for (l=k+1;l<e;++l)
						{
							if
							(
								ri[k][1]==ri[l][1]&&	
								ri[k][2]==ri[l][2]&&
								ri[k][3]==ri[l][3]&&
								0==ri[l][3]
							)
							{
								if(ri[k][2]==12)
								{
									p_for_(ri[k][0],ri[l][0]);

									for (m=k;m<l;++m)
									{
									    if(ri[m][3]==13)
									    {
									       for(n=m+1;n<l;++n)
									       {
									          if
									          (
									             ri[i][1]==ri[n][1]&&	
									             ri[k][2]==ri[n][2]&&
									             ri[m][3]==ri[n][3]&&
										     ri[m][4]==ri[n][4]&&
									             0==ri[n][4]
									          )
									          {
									            p_if_(ri[m][0],ri[n][0]);
									            break;
									          }
									      }
									      m=n;
									   }
							               }
						                }
						
								if(ri[k][2]==13)
								{
									p_if_(ri[k][0],ri[l][0]);

									for (m=k;m<l;++m)
									{
									    if(ri[m][3]==13)
									    {
									       for(n=m+1;n<l;++n)
									       {
									          if
									          (
									             ri[i][1]==ri[n][1]&&	
									             ri[k][2]==ri[n][2]&&
									             ri[m][3]==ri[n][3]&&
										     ri[m][4]==ri[n][4]&&
									             0==ri[n][4]
									          )
									          {
									            p_if_(ri[m][0],ri[n][0]);
									            break;
									          }
									      }
									      m=n;
									   }
							               }

								}
								if(ri[k][2]==15)
								{
									p_while_(ri[k][0],ri[l][0]);

									for (m=k;m<l;++m)
									{
									    if(ri[m][3]==13)
									    {
									       for(n=m+1;n<l;++n)
									       {
									          if
									          (
									             ri[i][1]==ri[n][1]&&	
									             ri[k][2]==ri[n][2]&&
									             ri[m][3]==ri[n][3]&&
										     ri[m][4]==ri[n][4]&&
									             0==ri[n][4]
									          )
									          {
									            p_if_(ri[m][0],ri[n][0]);
									            break;
									          }
									      }
									      m=n;
									   }
							               }

								}

								k=l;
								break;

							}
						}
					}
				}
			}

			//for (n=0;n<inri;++n)
			//{
			//	printf("%d %d %d %d %d %d %d %d %d %d\n",nri[n][0],nri[n][1],nri[n][2],nri[n][3],nri[n][4],nri[n][5],nri[n][6],nri[n][7],nri[n][8],nri[n][9]);
			//}

			if(inri!=0)
			{
				parse_for_1(s,cv,0,inri);
				exlin+=nri[0][4]-s+1;i=e;
				continue;
			}
		}


		if (ri[i][1]==13&&ri[i][2]==0)
		{

			s=ri[i][0];l=1;
			for (j=i+1;j<iri;++j)
			{
				if 
				(
					ri[j][1]==13&&
					(ri[j][2]==0||ri[j][2]==1)

				){if(ri[j][2]==0){++l;if(l==2){++j;break;}}}else{break;}
			}
			if (l==2)
			{
				e=ri[j-1][0];
				pif_(s,e);
				exlin+=e-s+1;
				i=j-1;
				continue;
			}else{

				for(l=0;l<maxv;++l)
				{
					nri[l][0]=0;nri[l][1]=0;nri[l][2]=0;nri[l][3]=0;nri[l][4]=0;
					nri[l][5]=0;nri[l][6]=0;nri[l][7]=0;nri[l][8]=0;nri[l][9]=0;
				}inri=0;
				for(l=0;l<10;++l){cv[l]=0;iv[l][0]=-1;iv[l][1]=-1;}cvi=0;
				e=-1;

				for (l=i+1;l<iri;++l)
				{
					if
					(
						ri[i][1]==ri[l][1]&&
						ri[i][2]==ri[l][2]&&
						0==ri[l][2]
					)
					{
						p_if_(s,ri[l][0]);
						e=l;
						break;
					}
				}

				for (k=i+1;k<e;++k)
				{
					if 
					(
						ri[k][1]==13&&
						(ri[k][2]==12||ri[k][2]==13||ri[k][2]==15)&&
						ri[k][3]==0
					)
					{

						for (l=k+1;l<e;++l)
						{
							if
							(
								ri[k][1]==ri[l][1]&&	
								ri[k][2]==ri[l][2]&&
								ri[k][3]==ri[l][3]&&
								0==ri[l][3]
							)
							{
								if(ri[k][2]==12)
								{
									p_for_(ri[k][0],ri[l][0]);

									for (m=k;m<l;++m)
									{
									    if(ri[m][3]==13)
									    {
									       for(n=m+1;n<l;++n)
									       {
									          if
									          (
									             ri[i][1]==ri[n][1]&&	
									             ri[k][2]==ri[n][2]&&
									             ri[m][3]==ri[n][3]&&
										     ri[m][4]==ri[n][4]&&
									             0==ri[n][4]
									          )
									          {
									            p_if_(ri[m][0],ri[n][0]);
									            break;
									          }
									      }
									      m=n;
									   }
							               }
						                }
						
								if(ri[k][2]==13)
								{
									p_if_(ri[k][0],ri[l][0]);

									for (m=k;m<l;++m)
									{
									    if(ri[m][3]==13)
									    {
									       for(n=m+1;n<l;++n)
									       {
									          if
									          (
									             ri[i][1]==ri[n][1]&&	
									             ri[k][2]==ri[n][2]&&
									             ri[m][3]==ri[n][3]&&
										     ri[m][4]==ri[n][4]&&
									             0==ri[n][4]
									          )
									          {
									            p_if_(ri[m][0],ri[n][0]);
									            break;
									          }
									      }
									      m=n;
									   }
							               }

								}
								if(ri[k][2]==15)
								{
									p_while_(ri[k][0],ri[l][0]);

									for (m=k;m<l;++m)
									{
									    if(ri[m][3]==13)
									    {
									       for(n=m+1;n<l;++n)
									       {
									          if
									          (
									             ri[i][1]==ri[n][1]&&	
									             ri[k][2]==ri[n][2]&&
									             ri[m][3]==ri[n][3]&&
										     ri[m][4]==ri[n][4]&&
									             0==ri[n][4]
									          )
									          {
									            p_if_(ri[m][0],ri[n][0]);
									            break;
									          }
									      }
									      m=n;
									   }
							               }

								}

								k=l;
								break;

							}
						}
					}
				}
			}

			//for (n=0;n<inri;++n)
			//{
			//	printf("%d %d %d %d %d %d %d %d %d %d\n",nri[n][0],nri[n][1],nri[n][2],nri[n][3],nri[n][4],nri[n][5],nri[n][6],nri[n][7],nri[n][8],nri[n][9]);
			//}

			if(inri!=0)
			{
				parse_if_1(s,0,inri);
				exlin+=nri[0][4]-s+1;i=e;
				continue;
			}
		}


		if (ri[i][1]==15&&ri[i][2]==0)
		{

			s=ri[i][0];l=1;
			for (j=i+1;j<iri;++j)
			{
				if 
				(
					ri[j][1]==15&&
					(ri[j][2]==0||ri[j][2]==1)

				){if(ri[j][2]==0){++l;if(l==2){++j;break;}}}else{break;}
			}
			if (l==2)
			{
				e=ri[j-1][0];
				pwhile_(s,e);
				exlin+=e-s+1;
				i=j-1;
				continue;
			}else{

				for(l=0;l<maxv;++l)
				{
					nri[l][0]=0;nri[l][1]=0;nri[l][2]=0;nri[l][3]=0;nri[l][4]=0;
					nri[l][5]=0;nri[l][6]=0;nri[l][7]=0;nri[l][8]=0;nri[l][9]=0;
				}inri=0;
				for(l=0;l<10;++l){cv[l]=0;iv[l][0]=-1;iv[l][1]=-1;}cvi=0;
				e=-1;

				for (l=i+1;l<iri;++l)
				{
					if
					(
						ri[i][1]==ri[l][1]&&
						ri[i][2]==ri[l][2]&&
						0==ri[l][2]
					)
					{
						p_while_(s,ri[l][0]);
						e=l;
						break;
					}
				}

				for (k=i+1;k<e;++k)
				{
					if 
					(
						ri[k][1]==15&&
						(ri[k][2]==12||ri[k][2]==13||ri[k][2]==15)&&
						ri[k][3]==0
					)
					{

						for (l=k+1;l<e;++l)
						{
							if
							(
								ri[k][1]==ri[l][1]&&	
								ri[k][2]==ri[l][2]&&
								ri[k][3]==ri[l][3]&&
								0==ri[l][3]
							)
							{
								if(ri[k][2]==12)
								{
									p_for_(ri[k][0],ri[l][0]);

									for (m=k;m<l;++m)
									{
									    if(ri[m][3]==13)
									    {
									       for(n=m+1;n<l;++n)
									       {
									          if
									          (
									             ri[i][1]==ri[n][1]&&	
									             ri[k][2]==ri[n][2]&&
									             ri[m][3]==ri[n][3]&&
										     ri[m][4]==ri[n][4]&&
									             0==ri[n][4]
									          )
									          {
									            p_if_(ri[m][0],ri[n][0]);
									            break;
									          }
									      }
									      m=n;
									   }
							               }
						                }
						
								if(ri[k][2]==13)
								{
									p_if_(ri[k][0],ri[l][0]);

									for (m=k;m<l;++m)
									{
									    if(ri[m][3]==13)
									    {
									       for(n=m+1;n<l;++n)
									       {
									          if
									          (
									             ri[i][1]==ri[n][1]&&	
									             ri[k][2]==ri[n][2]&&
									             ri[m][3]==ri[n][3]&&
										     ri[m][4]==ri[n][4]&&
									             0==ri[n][4]
									          )
									          {
									            p_if_(ri[m][0],ri[n][0]);
									            break;
									          }
									      }
									      m=n;
									   }
							               }

								}
								if(ri[k][2]==15)
								{
									p_while_(ri[k][0],ri[l][0]);

									for (m=k;m<l;++m)
									{
									    if(ri[m][3]==13)
									    {
									       for(n=m+1;n<l;++n)
									       {
									          if
									          (
									             ri[i][1]==ri[n][1]&&	
									             ri[k][2]==ri[n][2]&&
									             ri[m][3]==ri[n][3]&&
										     ri[m][4]==ri[n][4]&&
									             0==ri[n][4]
									          )
									          {
									            p_if_(ri[m][0],ri[n][0]);
									            break;
									          }
									      }
									      m=n;
									   }
							               }

								}

								k=l;
								break;

							}
						}
					}
				}
			}

			//for (n=0;n<inri;++n)
			//{
			//	printf("%d %d %d %d %d %d %d %d %d %d\n",nri[n][0],nri[n][1],nri[n][2],nri[n][3],nri[n][4],nri[n][5],nri[n][6],nri[n][7],nri[n][8],nri[n][9]);
			//}

			if(inri!=0)
			{
				parse_while_1(s,0,inri);
				exlin+=nri[0][4]-s+1;i=e;
				continue;
			}
		}

	}

	return(exlin);

}


int mariabasic(char infn[vnaml],char outfn[vnaml])
{
	int			i,j,k,l,m,n;
	int			fbyte;
	int			errC=0;

	//char		infn[vnaml]="in.bas";

	FILE		*f1,*f2;

	char		cl[plinel];int	cli=0;
	char		cl1[plinel];int	cl1i=0;

	char		kw0[vnaml]="if (",kw1[vnaml]="else",kw2[vnaml]="end if",kw3[vnaml]="for ";
	char		kw4[vnaml]="next",kw5[vnaml]="while (",kw6[vnaml]="wend",kw7[vnaml]="print ";
	char		kw8[vnaml]="input #",kw9[vnaml]="sub",kw10[vnaml]="end sub",kw11[vnaml]="end";
	char		kw12[vnaml]="=mid$(",kw13[vnaml]="=trim$(",kw14[vnaml]="=left$(",kw15[vnaml]="=right$(";
	char		kw16[vnaml]="=len$(",kw17[vnaml]="open ",kw18[vnaml]="input #",kw19[vnaml]="close #";
	char		kw20[vnaml]="=val$(",kw21[vnaml]=" or ",kw22[vnaml]=" and ",kw23[vnaml]=" xor ";
	char		kw24[vnaml]="=format$(",kw25[vnaml]="print #",kw26[vnaml]="=round$(";

	char		rout0[vnaml]="exc",rout1[vnaml]="pfor",rout2[vnaml]="pwhile",rout3[vnaml]="pif",rout4[vnaml]="psub";	

	char		*to="This Program is Dedicated to Nada Popstefanova and Maria,Dusica,Borce Dzinleski";	

	f1=fopen(infn,"rb");

	if(f1==NULL){printf("Nothing to do!\n");return(0);}else{fclose(f1);}

	for(i=0;i<plinel;++i){cl[i]='\0';}

	if(strlen(outfn)>0){of=true;}
	if(of){fout=fopen(outfn,"w");}
	
	f1=fopen(infn,"rb");
	f2=fopen("code.mar","wb");

	fbyte=getc(f1);
	while(!feof(f1))
	{
		cli=0;for(i=0;i<plinel;++i){cl[i]='\0';}
		while(!feof(f1)&&fbyte!=13&&fbyte!=10){cl[cli]=fbyte;++cli;fbyte=getc(f1);}
		while(!feof(f1)&&(fbyte==13||fbyte==10)){fbyte=getc(f1);}
		if(1<=p_ex(cl,"rem")){continue;}

		cl1i=0;for(i=0;i<plinel;++i){cl1[i]='\0';}
		for(i=0;i<cli;++i){if(cl[i]==' '||cl[i]==(char)9){}else{break;}}
		if((cli-i)>1)
		{
			for(j=i;j<cli;++j){cl1[cl1i]=cl[j];++cl1i;}
			for(i=cl1i-1;i>=0;--i)
			{if(cl1[i]==' '||cl1[i]==(char)9){cl1[i]='\0';}else{break;}}

			//???
			//end
			if(0!=p_ex(cl1,"end")){
				if(1==p_comp(cl1,"end")){fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);continue;}else{
					if(1==p_comp(cl1,"end if")){fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);continue;}else{
						if(1==p_comp(cl1,"wend")){fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);continue;}else{
							//++errC;
							if(of){fprintf(fout,"%s\n(end)Syntax Error...\n",cl1);}else{printf("%s\n(end)Syntax Error...\n",cl1);}
						}
					}
				}
			}

			//next 
			if(strlen("next")==p_ex(cl1,"next")){

					if
					(
						(0!=p_ex(cl1,"$"))||
						(0!=p_ex(cl1,"%"))||
						(0!=p_ex(cl1,"&"))||
						(0!=p_ex(cl1,"#"))

					){fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);continue;}else{
						++errC;if(of){fprintf(fout,"%s\n(next)Syntax Error...\n",cl1);}else{printf("%s\n(next)Syntax Error...\n",cl1);}
					}
			}

			//close #
			if(strlen("close #")==p_ex(cl1,"close #"))
			{
				i=p_ex(cl1,"#");
				if(i!=0){
					if(cl1[i]>='0'&&cl1[i]<='9'){
						fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);continue;}else{
							++errC;if(of){fprintf(fout,"%s\n(close)Syntax Error...\n",cl1);}else{printf("%s\n(close)Syntax Error...\n",cl1);}}
					}else{printf("%s\n(close)Syntax Error...\n",cl1);
				}
			}

			//vdcl
			if
			(!(
				(1<=p_ex(cl1,"if (")		)||
				(1<=p_ex(cl1,"end if")		)||
				(1<=p_ex(cl1,"end")			)||
				(1<=p_ex(cl1,"while (")		)||
				(1<=p_ex(cl1,"wend")		)||
				(1<=p_ex(cl1,"for ")		)||
				(1<=p_ex(cl1,"next ")		)||
				(1<=p_ex(cl1,"open ")		)||
				(1<=p_ex(cl1,"close #")		)||
				(1<=p_ex(cl1,"print ")		)||
				(1<=p_ex(cl1,"print #")		)||
				(1<=p_ex(cl1,"input #")		)||
				(1<=p_ex(cl1,"=mid$(")		)||
				(1<=p_ex(cl1,"=len$(")		)||
				(1<=p_ex(cl1,"=trim$(")		)||
				(1<=p_ex(cl1,"=val$(")		)||
				(1<=p_ex(cl1,"=format$(")	)||
				(1<=p_ex(cl1,"=round$(")	)||
				(1<=p_ex(cl1,"=left$(")		)||
				(1<=p_ex(cl1,"=right$(")	)
			) )
			{
				if
				(
					(0!=p_ex(cl1,"="))&&
					(!(
						(0!=p_ex(cl1,"+"))||
						(0!=p_ex(cl1,"^"))||
						(0!=p_ex(cl1,"*"))||
						(0!=p_ex(cl1,"/"))
					) )
				)
				{

					p_syntax_(cl1,p_exp);

					if(r_s[2][0]=='='){}else{++errC;if(of){fprintf(fout,"%s\n(vdcl)Syntax Error...\n",cl1);}else{printf("%s\n(vdcl)Syntax Error...\n",cl1);}}
					if
					(
						(r_s[1][0]=='$')||
						(r_s[1][0]=='%')||
						(r_s[1][0]=='&')||
						(r_s[1][0]=='#')

						){}else{++errC;if(of){fprintf(fout,"%s\n(vdcl)Syntax Error...\n",cl1);}else{printf("%s\n(vdcl)Syntax Error...\n",cl1);}}

					fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);continue;
				}
			}

			//exp
			if
			(
			(!(
				(1<=p_ex(cl1,"if (")		)||
				(1<=p_ex(cl1,"end if")		)||
				(1<=p_ex(cl1,"end")			)||
				(1<=p_ex(cl1,"while (")		)||
				(1<=p_ex(cl1,"wend")		)||
				(1<=p_ex(cl1,"for ")		)||
				(1<=p_ex(cl1,"next ")		)||
				(1<=p_ex(cl1,"open ")		)||
				(1<=p_ex(cl1,"close #")		)||
				(1<=p_ex(cl1,"print ")		)||
				(1<=p_ex(cl1,"print #")		)||
				(1<=p_ex(cl1,"input #")		)||
				(1<=p_ex(cl1,"=mid$(")		)||
				(1<=p_ex(cl1,"=len$(")		)||
				(1<=p_ex(cl1,"=trim$(")		)||
				(1<=p_ex(cl1,"=val$(")		)||
				(1<=p_ex(cl1,"=format$(")	)||
				(1<=p_ex(cl1,"=round$(")	)||
				(1<=p_ex(cl1,"=left$(")		)||
				(1<=p_ex(cl1,"=right$(")	)
			) )
			)
			{
				if
				(
					(0!=p_ex(cl1,"="))&&
					(
						(0!=p_ex(cl1,"+"))||
						(0!=p_ex(cl1,"^"))||
						(0!=p_ex(cl1,"*"))||
						(0!=p_ex(cl1,"/"))
					)
				)
				{
					p_syntax_(cl1,p_exp);

					if(r_s[2][0]=='='){}else{++errC;if(of){fprintf(fout,"%s\n(exp)Syntax Error...\n",cl1);}else{printf("%s\n(exp)Syntax Error...\n",cl1);}}
					if
					(
						(r_s[1][0]=='$')||
						(r_s[1][0]=='%')||
						(r_s[1][0]=='&')||
						(r_s[1][0]=='#')

						){}else{++errC;if(of){fprintf(fout,"%s\n(exp)Syntax Error...\n",cl1);}else{printf("%s\n(exp)Syntax Error...\n",cl1);}}

					fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);continue;				
				}
			}


			if(strlen("if (")==p_ex(cl1,"if ("))
			{

				p_syntax_(cl1,b_if);

				if(1==p_comp(r_s[1]," (")){}else{++errC;if(of){fprintf(fout,"%s\n(if)Syntax Error...\n",cl1);}else{printf("%s\n(if)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[5],") ")){}else{++errC;if(of){fprintf(fout,"%s\n(if)Syntax Error...\n",cl1);}else{printf("%s\n(if)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[6],"then")){}else{++errC;if(of){fprintf(fout,"%s\n(if)Syntax Error...\n",cl1);}else{printf("%s\n(if)Syntax Error...\n",cl1);}}

				if
				(
					(r_s[2][-1+strlen(r_s[2])]=='$')||
					(r_s[2][-1+strlen(r_s[2])]=='%')||
					(r_s[2][-1+strlen(r_s[2])]=='&')

					){}else{++errC;if(of){fprintf(fout,"%s\n(if)Syntax Error...\n",cl1);}else{printf("%s\n(if)Syntax Error...\n",cl1);}}

				if
				(
					(1==p_comp(r_s[3],"=")	)||
					(1==p_comp(r_s[3],"<")	)||
					(1==p_comp(r_s[3],">")	)||
					(1==p_comp(r_s[3],">=")	)||
					(1==p_comp(r_s[3],"<=")	)||
					(1==p_comp(r_s[3],"<>")	)

					){}else{++errC;if(of){fprintf(fout,"%s\n(if)Syntax Error...\n",cl1);}else{printf("%s\n(if)Syntax Error...\n",cl1);}}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;

			}

			if(strlen("for ")==p_ex(cl1,"for "))
			{
				p_syntax_(cl1,b_for_1);

				if(r_s[1][0]==' '){}else{++errC;if(of){fprintf(fout,"%s\n(for)Syntax Error...\n",cl1);}else{printf("%s\n(for)Syntax Error...\n",cl1);}}
				if(r_s[3][0]=='='){}else{++errC;if(of){fprintf(fout,"%s\n(for)Syntax Error...\n",cl1);}else{printf("%s\n(for)Syntax Error...\n",cl1);}}
				if((r_s[5][0]==' ')&&(1==p_comp(r_s[6],"to"))){}else{++errC;if(of){fprintf(fout,"%s\n(for)Syntax Error...\n",cl1);}else{printf("%s\n(for)Syntax Error...\n",cl1);}}

				if
				(
					(r_s[2][-1+strlen(r_s[2])]=='%')||
					(r_s[2][-1+strlen(r_s[2])]=='&')

					){}else{++errC;if(of){fprintf(fout,"%s\n(for)Syntax Error...\n",cl1);}else{printf("%s\n(for)Syntax Error...\n",cl1);}}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;
			}

			if(strlen("while (")==p_ex(cl1,"while ("))
			{
				p_syntax_(cl1,b_while);

				if(1==p_comp(r_s[0],"while (")){}else{++errC;if(of){fprintf(fout,"%s\n(while)Syntax Error...\n",cl1);}else{printf("%s\n(while)Syntax Error...\n",cl1);}}
				//if(1==p_comp(r_s[4],")")){}else{printf("%s\nSyntax Error...\n",cl1);}

				if
				(
					(1==p_comp(r_s[2],"=")	)||
					(1==p_comp(r_s[2],"<")	)||
					(1==p_comp(r_s[2],">")	)||
					(1==p_comp(r_s[2],"<>")	)||
					(1==p_comp(r_s[2],"=>")	)||
					(1==p_comp(r_s[2],"<=")	)

					){}else{++errC;if(of){fprintf(fout,"%s\n(while)Syntax Error...\n",cl1);}else{printf("%s\n(while)Syntax Error...\n",cl1);}}

				if
				(
					(r_s[1][-1+strlen(r_s[1])]=='$')||
					(r_s[1][-1+strlen(r_s[1])]=='%')||
					(r_s[1][-1+strlen(r_s[1])]=='&')

					){}else{++errC;if(of){fprintf(fout,"%s\n(while)Syntax Error...\n",cl1);}else{printf("%s\n(while)Syntax Error...\n",cl1);}}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;
			}

			if((0==p_ex(cl1,"print #"))&&strlen("print ")==p_ex(cl1,"print "))
			{
				for(j=1+strlen("print ");j<strlen(cl1);++j)
				{
					if(cl1[j]==','||cl1[j]==';')
					{
						if
						(
							(cl1[-1+j]=='\'')	||
							(cl1[-1+j]=='\"')	||
							(cl1[-1+j]=='$')	||
							(cl1[-1+j]=='%')	||
							(cl1[-1+j]=='&')	||
							(cl1[-1+j]=='#')	
							){}else{
							//++errC;
							if(of){fprintf(fout,"%s\n(print1)Syntax Error...\n",cl1);}else{printf("%s\n(print1)Syntax Error...\n",cl1);}}
					}
				}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;
			}
			
			if(1<=p_ex(cl1,"=mid$("))
			{
				p_syntax_(cl1,b_mid);

				if(r_s[0][-1+strlen(r_s[0])]=='$'){}else{++errC;if(of){fprintf(fout,"%s\n(mid$)Syntax Error...\n",cl1);}else{printf("%s\n(mid$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[1],"=")){}else{++errC;if(of){fprintf(fout,"%s\n(mid$)Syntax Error...\n",cl1);}else{printf("%s\n(mid$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[2],"mid$(")){}else{++errC;if(of){fprintf(fout,"%s\n(mid$)Syntax Error...\n",cl1);}else{printf("%s\n(mid$)Syntax Error...\n",cl1);}}
				if(r_s[3][-1+strlen(r_s[3])]=='$'){}else{++errC;if(of){fprintf(fout,"%s\n(mid$)Syntax Error...\n",cl1);}else{printf("%s\n(mid$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[4],",")){}else{++errC;if(of){fprintf(fout,"%s\n(mid$)Syntax Error...\n",cl1);}else{printf("%s\n(mid$)Syntax Error...\n",cl1);}}

				if
				(
					(
						(r_s[5][-1+strlen(r_s[5])]>='0')&&
						(r_s[5][-1+strlen(r_s[5])]<='9')
					)
					||
					(r_s[6][-1+strlen(r_s[6])]=='%')
					||
					(r_s[6][-1+strlen(r_s[6])]=='&')


					){}else{++errC;if(of){fprintf(fout,"%s\n(mid$)Syntax Error...\n",cl1);}else{printf("%s\n(mid$)Syntax Error...\n",cl1);}}

				if(1==p_comp(r_s[7],",")){}else{++errC;if(of){fprintf(fout,"%s\n(mid$)Syntax Error...\n",cl1);}else{printf("%s\n(mid$)Syntax Error...\n",cl1);}}

				if
				(
					(
						(r_s[8][-1+strlen(r_s[8])]>='0')&&
						(r_s[8][-1+strlen(r_s[8])]<='9')
					)
					||
					(r_s[9][-1+strlen(r_s[9])]=='%')
					||
					(r_s[9][-1+strlen(r_s[9])]=='&')


					){}else{++errC;if(of){fprintf(fout,"%s\n(mid$)Syntax Error...\n",cl1);}else{printf("%s\n(mid$)Syntax Error...\n",cl1);}}

				if(1==p_comp(r_s[10],")")){}else{++errC;if(of){fprintf(fout,"%s\n(mid$)Syntax Error...\n",cl1);}else{printf("%s\n(mid$)Syntax Error...\n",cl1);}}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;

			}
			
			if(1<=p_ex(cl1,"=trim$("))
			{
				p_syntax_(cl1,b_trim);

				if(r_s[0][-1+strlen(r_s[0])]=='$'){}else{++errC;if(of){fprintf(fout,"%s\n(trim$)Syntax Error...1\n",cl1);}else{printf("%s\n(trim$)Syntax Error...1\n",cl1);}}
				if(1==p_comp(r_s[1],"=")){}else{++errC;if(of){fprintf(fout,"%s\n(trim$)Syntax Error...2\n",cl1);}else{printf("%s\n(trim$)Syntax Error...2\n",cl1);}}
				if(1==p_comp(r_s[2],"trim$(")){}else{++errC;if(of){fprintf(fout,"%s\n(trim$)Syntax Error...3\n",cl1);}else{printf("%s\n(trim$)Syntax Error...3\n",cl1);}}
				if(r_s[3][-1+strlen(r_s[3])]=='$'){}else{++errC;if(of){fprintf(fout,"%s\n(trim$)Syntax Error...4\n",cl1);}else{printf("%s\n(trim$)Syntax Error...4\n",cl1);}}
				if(1==p_comp(r_s[4],")")){}else{++errC;if(of){fprintf(fout,"%s\n(trim$)Syntax Error...5\n",cl1);}else{printf("%s\n(trim$)Syntax Error...5\n",cl1);}}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;


			}

			if(1<=p_ex(cl1,"=left$("))
			{
				p_syntax_(cl1,b_left);

				if(r_s[0][-1+strlen(r_s[0])]=='$'){}else{++errC;if(of){fprintf(fout,"%s\n(left$)Syntax Error...\n",cl1);}else{printf("%s\n(left$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[1],"=")){}else{++errC;if(of){fprintf(fout,"%s\n(left$)Syntax Error...\n",cl1);}else{printf("%s\n(left$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[2],"left$(")){}else{++errC;if(of){fprintf(fout,"%s\n(left$)Syntax Error...\n",cl1);}else{printf("%s\n(left$)Syntax Error...\n",cl1);}}
				if(r_s[3][-1+strlen(r_s[3])]=='$'){}else{++errC;if(of){fprintf(fout,"%s\n(left$)Syntax Error...\n",cl1);}else{printf("%s\n(left$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[4],",")){}else{++errC;if(of){fprintf(fout,"%s\n(left$)Syntax Error...\n",cl1);}else{printf("%s\n(left$)Syntax Error...\n",cl1);}}
				if
				(
					(r_s[5][-1+strlen(r_s[5])]>='0')&&
					(r_s[5][-1+strlen(r_s[5])]<='9')

					){}else{++errC;if(of){fprintf(fout,"%s\n(left$)Syntax Error...\n",cl1);}else{printf("%s\n(left$)Syntax Error...\n",cl1);}}

				if(1==p_comp(r_s[6],")")){}else{++errC;if(of){fprintf(fout,"%s\n(left$)Syntax Error...\n",cl1);}else{printf("%s\n(left$)Syntax Error...\n",cl1);}}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;

			}

			if(1<=p_ex(cl1,"=right$("))
			{
				p_syntax_(cl1,b_right);

				if(r_s[0][-1+strlen(r_s[0])]=='$'){}else{++errC;if(of){fprintf(fout,"%s\n(right$)Syntax Error...\n",cl1);}else{printf("%s\n(right$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[1],"=")){}else{++errC;if(of){fprintf(fout,"%s\n(right$)Syntax Error...\n",cl1);}else{printf("%s\n(right$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[2],"right$(")){}else{++errC;if(of){fprintf(fout,"%s\n(right$)Syntax Error...\n",cl1);}else{printf("%s\n(right$)Syntax Error...\n",cl1);}}
				if(r_s[3][-1+strlen(r_s[3])]=='$'){}else{++errC;if(of){fprintf(fout,"%s\n(right$)Syntax Error...\n",cl1);}else{printf("%s\n(right$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[4],",")){}else{++errC;if(of){fprintf(fout,"%s\n(right$)Syntax Error...\n",cl1);}else{printf("%s\n(right$)Syntax Error...\n",cl1);}}
				if
				(
					(r_s[5][-1+strlen(r_s[5])]>='0')&&
					(r_s[5][-1+strlen(r_s[5])]<='9')

					){}else{++errC;if(of){fprintf(fout,"%s\n(right$)Syntax Error...\n",cl1);}else{printf("%s\n(right$)Syntax Error...\n",cl1);}}

				if(1==p_comp(r_s[6],")")){}else{++errC;if(of){fprintf(fout,"%s\n(right$)Syntax Error...\n",cl1);}else{printf("%s\n(right$)Syntax Error...\n",cl1);}}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;


			}

			if(1<=p_ex(cl1,"=len$("))
			{
				p_syntax_(cl1,b_len);

				if
				(
					(r_s[0][-1+strlen(r_s[0])]=='%')||
					(r_s[0][-1+strlen(r_s[0])]=='&')

					){}else{++errC;if(of){fprintf(fout,"%s\n(len$)Syntax Error...\n",cl1);}else{printf("%s\n(len$)Syntax Error...\n",cl1);}}

				if(1==p_comp(r_s[1],"=")){}else{++errC;if(of){fprintf(fout,"%s\n(len$)Syntax Error...\n",cl1);}else{printf("%s\n(len$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[2],"len$(")){}else{++errC;if(of){fprintf(fout,"%s\n(len$)Syntax Error...\n",cl1);}else{printf("%s\n(len$)Syntax Error...\n",cl1);}}
				if(r_s[3][-1+strlen(r_s[3])]=='$'){}else{++errC;if(of){fprintf(fout,"%s\n(len$)Syntax Error...\n",cl1);}else{printf("%s\n(len$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[4],")")){}else{++errC;if(of){fprintf(fout,"%s\n(len$)Syntax Error...\n",cl1);}else{printf("%s\n(len$)Syntax Error...\n",cl1);}}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;


			}

			if(1<=p_ex(cl1,"=round$("))
			{
				p_syntax_(cl1,b_round);

				if
				(
					(r_s[0][-1+strlen(r_s[0])]=='%')||
					(r_s[0][-1+strlen(r_s[0])]=='&')||
					(r_s[0][-1+strlen(r_s[0])]=='#')

					){}else{++errC;if(of){fprintf(fout,"%s\n(round$)Syntax Error...\n",cl1);}else{printf("%s\n(round$)Syntax Error...\n",cl1);}}

				if(1==p_comp(r_s[1],"=")){}else{++errC;if(of){fprintf(fout,"%s\n(round$)Syntax Error...\n",cl1);}else{printf("%s\n(round$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[2],"round$(")){}else{++errC;if(of){fprintf(fout,"%s\n(round$)Syntax Error...\n",cl1);}else{printf("%s\n(round$)Syntax Error...\n",cl1);}}
				if
				(
					(r_s[3][-1+strlen(r_s[3])]=='%')||
					(r_s[3][-1+strlen(r_s[3])]=='&')||
					(r_s[3][-1+strlen(r_s[3])]=='#')

					){}else{++errC;if(of){fprintf(fout,"%s\n(round$)Syntax Error...\n",cl1);}else{printf("%s\n(round$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[4],")")){}else{++errC;if(of){fprintf(fout,"%s\n(round$)Syntax Error...\n",cl1);}else{printf("%s\n(round$)Syntax Error...\n",cl1);}}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;


			}


			if(1<=p_ex(cl1,"=val$("))
			{
				p_syntax_(cl1,b_val);

				if
				(
					(r_s[0][-1+strlen(r_s[0])]=='%')||
					(r_s[0][-1+strlen(r_s[0])]=='&')||
					(r_s[0][-1+strlen(r_s[0])]=='#')

					){}else{++errC;if(of){fprintf(fout,"%s\n(val$)Syntax Error...\n",cl1);}else{printf("%s\n(val$)Syntax Error...\n",cl1);}}

				if(1==p_comp(r_s[1],"=")){}else{++errC;if(of){fprintf(fout,"%s\n(val$)Syntax Error...\n",cl1);}else{printf("%s\n(val$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[2],"val$(")){}else{++errC;if(of){fprintf(fout,"%s\n(val$)Syntax Error...\n",cl1);}else{printf("%s\n(val$)Syntax Error...\n",cl1);}}
				if(r_s[3][-1+strlen(r_s[3])]=='$'){}else{++errC;if(of){fprintf(fout,"%s\n(val$)Syntax Error...\n",cl1);}else{printf("%s\n(val$)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[4],")")){}else{++errC;if(of){fprintf(fout,"%s\n(val$)Syntax Error...\n",cl1);}else{printf("%s\n(val$)Syntax Error...\n",cl1);}}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;


			}


			if(1<=p_ex(cl1,"=format$("))
			{
				p_syntax_(cl1,b_format);

				if(r_s[0][-1+strlen(r_s[0])]=='$'){}else{++errC;if(of){fprintf(fout,"%s\n(format$1)Syntax Error...\n",cl1);}else{printf("%s\n(format$1)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[1],"=")){}else{++errC;if(of){fprintf(fout,"%s\n(format$2)Syntax Error...\n",cl1);}else{printf("%s\n(format$2)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[2],"format$(")){}else{++errC;if(of){fprintf(fout,"%s\n(format$3)Syntax Error...\n",cl1);}else{printf("%s\n(format$3)Syntax Error...\n",cl1);}}
				if
				(
					(r_s[3][-1+strlen(r_s[3])]=='%')||
					(r_s[3][-1+strlen(r_s[3])]=='&')||
					(r_s[3][-1+strlen(r_s[3])]=='#')

					){}else{++errC;if(of){fprintf(fout,"%s\n(format$)Syntax Error...\n",cl1);}else{printf("%s\n(format$)Syntax Error...\n",cl1);}}

				if(1==p_comp(r_s[4],",")){}else{++errC;if(of){fprintf(fout,"%s\n(format$)Syntax Error...\n",cl1);}else{printf("%s\n(format$)Syntax Error...\n",cl1);}}

				for(j=0;j<strlen(r_s[5]);++j)
				{
					if
					(
						(r_s[5][j]=='0')	||
						(r_s[5][j]=='.')	||
						(r_s[5][j]==',')	||
						(r_s[5][j]=='-')	||
						(r_s[5][j]=='+')	||
						(r_s[5][j]=='\'')	||
						(r_s[5][j]=='\"')	||
						(r_s[5][j]=='#')	||
						(r_s[5][j]=='$')	
						
						){}else{++errC;if(of){fprintf(fout,"%s\n(format$)Syntax Error...\n",cl1);}else{printf("%s\n(format$)Syntax Error...\n",cl1);}}
					
				}
				//if(1==p_comp(r_s[6],")")){}else{printf("%s\n(format$7)Syntax Error...\n",cl1);}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;

			}

			if(strlen("input ")==p_ex(cl1,"input "))
			{

				p_syntax_(cl1,b_finput);

				if(1==p_comp(r_s[0],"input")){}else{++errC;if(of){fprintf(fout,"%s\n(input)Syntax Error...\n",cl1);}else{printf("%s\n(input)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[1]," ")){}else{++errC;if(of){fprintf(fout,"%s\n(input)Syntax Error...\n",cl1);}else{printf("%s\n(input)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[2],"#")){}else{++errC;if(of){fprintf(fout,"%s\n(input)Syntax Error...\n",cl1);}else{printf("%s\n(input)Syntax Error...\n",cl1);}}
				if
				(
					(r_s[3][-1+strlen(r_s[3])]>='0')&&
					(r_s[3][-1+strlen(r_s[3])]<='9')

					){}else{++errC;if(of){fprintf(fout,"%s\n(input)Syntax Error...\n",cl1);}else{printf("%s\n(input)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[4],",")){}else{++errC;if(of){fprintf(fout,"%s\n(input)Syntax Error...\n",cl1);}else{printf("%s\n(input)Syntax Error...\n",cl1);}}
				if
				(
					(r_s[5][-1+strlen(r_s[5])]=='%')||
					(r_s[5][-1+strlen(r_s[5])]=='&')||
					(r_s[5][-1+strlen(r_s[5])]=='#')||
					(r_s[5][-1+strlen(r_s[5])]=='$')

					){}else{++errC;if(of){fprintf(fout,"%s\n(input)Syntax Error...\n",cl1);}else{printf("%s\n(input)Syntax Error...\n",cl1);}}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;

			}

			if(strlen("print #")==p_ex(cl1,"print #"))
			{
				p_syntax_(cl1,b_fprint);

				if(1==p_comp(r_s[0],"print")){}else{
					//++errC;
					if(of){fprintf(fout,"%s\n(print #)Syntax Error...\n",cl1);}else{printf("%s\n(print #)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[1]," ")){}else{
					//++errC;
					if(of){fprintf(fout,"%s\n(print #)Syntax Error...\n",cl1);}else{printf("%s\n(print #)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[2],"#")){}else{
					//++errC;
					if(of){fprintf(fout,"%s\n(print #)Syntax Error...\n",cl1);}else{printf("%s\n(print #)Syntax Error...\n",cl1);}}
				if
				(
					(r_s[3][-1+strlen(r_s[3])]>='0')&&
					(r_s[3][-1+strlen(r_s[3])]<='9')

					){}else{
					//++errC;
					if(of){fprintf(fout,"%s\n(print #)Syntax Error...\n",cl1);}else{printf("%s\n(print #)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[4],",")){}else{
					//++errC;
					if(of){fprintf(fout,"%s\n(print #)Syntax Error...\n",cl1);}else{printf("%s\n(print #)Syntax Error...\n",cl1);}}
				if
				(
					(r_s[5][-1+strlen(r_s[5])]=='%')||
					(r_s[5][-1+strlen(r_s[5])]=='&')||
					(r_s[5][-1+strlen(r_s[5])]=='#')||
					(r_s[5][-1+strlen(r_s[5])]=='$')

					){}else{
					//++errC;
					if(of){fprintf(fout,"%s\n(print #)Syntax Error...\n",cl1);}else{printf("%s\n(print #)Syntax Error...\n",cl1);}}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;


			}

			if(strlen("open ")==p_ex(cl1,"open "))
			{
				if(0!=p_ex(cl1,"for input")){p_syntax_(cl1,b_fopen_i);}else{
					if(0!=p_ex(cl1,"for output")){p_syntax_(cl1,b_fopen_o);}else{
						++errC;if(of){fprintf(fout,"%s\n(open)Syntax Error...\n",cl1);}else{printf("%s\n(open)Syntax Error...\n",cl1);}
					}
				}

				if(1==p_comp(r_s[0],"open")){}else{++errC;if(of){fprintf(fout,"%s\n(open)Syntax Error...\n",cl1);}else{printf("%s\n(open)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[1]," ")){}else{++errC;if(of){fprintf(fout,"%s\n(open)Syntax Error...\n",cl1);}else{printf("%s\n(open)Syntax Error...\n",cl1);}}
				if(r_s[2][-1+strlen(r_s[2])]=='$'){}else{++errC;if(of){fprintf(fout,"%s\n(open)Syntax Error...\n",cl1);}else{printf("%s\n(open)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[3]," ")){}else{++errC;if(of){fprintf(fout,"%s\n(open)Syntax Error...\n",cl1);}else{printf("%s\n(open)Syntax Error...\n",cl1);}}
				if
				(
					(1==p_comp(r_s[4],"for input"))||
					(1==p_comp(r_s[4],"for output"))
				
				){}else{printf("%s\nSyntax Error...\n",cl1);}
				if(1==p_comp(r_s[5]," ")){}else{++errC;if(of){fprintf(fout,"%s\n(open)Syntax Error...\n",cl1);}else{printf("%s\n(open)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[6],"as")){}else{++errC;if(of){fprintf(fout,"%s\n(open)Syntax Error...\n",cl1);}else{printf("%s\n(open)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[7]," ")){}else{++errC;if(of){fprintf(fout,"%s\n(open)Syntax Error...\n",cl1);}else{printf("%s\n(open)Syntax Error...\n",cl1);}}
				if(1==p_comp(r_s[8],"#")){}else{++errC;if(of){fprintf(fout,"%s\n(open)Syntax Error...\n",cl1);}else{printf("%s\n(open)Syntax Error...\n",cl1);}}
				if
				(
					(r_s[9][-1+strlen(r_s[9])]>='0')&&
					(r_s[9][-1+strlen(r_s[9])]<='9')

				){}else{++errC;if(of){fprintf(fout,"%s\n(open)Syntax Error...\n",cl1);}else{printf("%s\n(open)Syntax Error...\n",cl1);}}

				fprintf(f2,"%s%c%c",cl1,(char)13,(char)10);
				continue;

			}

			++errC;if(of){fprintf(fout,"%s\n(!)Syntax Error...0\n",cl1);}else{printf("%s\n(!)Syntax Error...0\n",cl1);}
			if(errC>=10){printf("\n(!)Too many errors...\n");break;}
		}
	}
	fclose(f1);
	fclose(f2);

	if(errC!=0){printf("\nExecution will not continue...\n");return(0);}

	//if(!of){printf("\n\n\nThe mariaBasic Interpreter\n");}else{fprintf(fout,"\n\n\nThe mariaBasic Interpreter\n");}
	//if(!of){printf("\nWritten by Dzinleski Jasenko Jun,2005\n");}else{fprintf(fout,"\nWritten by Dzinleski Jasenko Jun,2005 and later\n");}
	//if(!of){printf("OS Win32 VRM 2.0.1.0\n\n");}else{fprintf(fout,"OS Win32 VRM 2.0.1.0\n\n");}

	for (j=0;j<r_strlen(rout0);++j){rout[0][j]=rout0[j];}
	for (j=0;j<r_strlen(rout1);++j){rout[1][j]=rout1[j];}
	for (j=0;j<r_strlen(rout2);++j){rout[2][j]=rout2[j];}
	for (j=0;j<r_strlen(rout3);++j){rout[3][j]=rout3[j];}

	for (j=0;j<r_strlen(rout4);++j){rout[4][j]=rout4[j];}
	irout=5;

	for (i=0;i<mc;++i)
	{
		if (i== 0){for(j=0;j<r_strlen(kw0); ++j){kw[i][j]= kw0[j];}}
		if (i== 1){for(j=0;j<r_strlen(kw1); ++j){kw[i][j]= kw1[j];}}
		if (i== 2){for(j=0;j<r_strlen(kw2); ++j){kw[i][j]= kw2[j];}}
		if (i== 3){for(j=0;j<r_strlen(kw3); ++j){kw[i][j]= kw3[j];}}
		if (i== 4){for(j=0;j<r_strlen(kw4); ++j){kw[i][j]= kw4[j];}}
		if (i== 5){for(j=0;j<r_strlen(kw5); ++j){kw[i][j]= kw5[j];}}
		if (i== 6){for(j=0;j<r_strlen(kw6); ++j){kw[i][j]= kw6[j];}}
		if (i== 7){for(j=0;j<r_strlen(kw7); ++j){kw[i][j]= kw7[j];}}
		if (i== 8){for(j=0;j<r_strlen(kw8); ++j){kw[i][j]= kw8[j];}}
		if (i== 9){for(j=0;j<r_strlen(kw9); ++j){kw[i][j]= kw9[j];}}
		if (i==10){for(j=0;j<r_strlen(kw10);++j){kw[i][j]=kw10[j];}}
		if (i==11){for(j=0;j<r_strlen(kw11);++j){kw[i][j]=kw11[j];}}
		if (i==12){for(j=0;j<r_strlen(kw12);++j){kw[i][j]=kw12[j];}}
		if (i==13){for(j=0;j<r_strlen(kw13);++j){kw[i][j]=kw13[j];}}
		if (i==14){for(j=0;j<r_strlen(kw14);++j){kw[i][j]=kw14[j];}}
		if (i==15){for(j=0;j<r_strlen(kw15);++j){kw[i][j]=kw15[j];}}
		if (i==16){for(j=0;j<r_strlen(kw16);++j){kw[i][j]=kw16[j];}}
		if (i==17){for(j=0;j<r_strlen(kw17);++j){kw[i][j]=kw17[j];}}
		if (i==18){for(j=0;j<r_strlen(kw18);++j){kw[i][j]=kw18[j];}}
		if (i==19){for(j=0;j<r_strlen(kw19);++j){kw[i][j]=kw19[j];}}
		if (i==20){for(j=0;j<r_strlen(kw20);++j){kw[i][j]=kw20[j];}}
		if (i==21){for(j=0;j<r_strlen(kw21);++j){kw[i][j]=kw21[j];}}
		if (i==22){for(j=0;j<r_strlen(kw22);++j){kw[i][j]=kw22[j];}}
		if (i==23){for(j=0;j<r_strlen(kw23);++j){kw[i][j]=kw23[j];}}
		if (i==24){for(j=0;j<r_strlen(kw24);++j){kw[i][j]=kw24[j];}}
		if (i==25){for(j=0;j<r_strlen(kw25);++j){kw[i][j]=kw25[j];}}
		if (i==26){for(j=0;j<r_strlen(kw26);++j){kw[i][j]=kw26[j];}}
	}

	f1=fopen("code.mar","rb");
	j=0;fbyte=getc(f1);
	while(!feof(f1))
	{
		for(i=0;i<plinel;++i){pf[j][i]='\0';}i=0;
		while(!feof(f1)&&fbyte!=13&&fbyte!=10){pf[j][i]=fbyte;++i;fbyte=getc(f1);}
		while(!feof(f1)&&(fbyte==13||fbyte==10)){fbyte=getc(f1);}++j;
	}
	fclose(f1);
		
	i=parse();

	if (i>0){if(!of){printf("\n(%d) Lines, (%d) Executed\n",j,i);}else{fprintf(fout,"\n(%d) Lines, (%d) Executed\n",j,i);}}else{if(!of){printf("\n!Error executing at line %d\n",-1*i);}else{fprintf(fout,"\n!Error executing at line %d\n",-1*i);}}

	if(of){fclose(fout);}

	return(0);
}

int main(int argc,char *argv[])
{
	int	i,j,k,l,m;
	char	cmd[plinel];
	char	fn[plinel];
	char	ofn[plinel];

	printf("\n\n\nThe mariaBasic Interpreter\n");
	printf("\nWritten by Dzinleski Jasenko Jun,2005 and later\n");
	printf("OS Win32 VRM 2.0.1.0\n\n");

	for(i=0;i<plinel;++i){cmd[i]='\0';}
	for(i=0;i<plinel;++i){fn[i]='\0';}
	for(i=0;i<plinel;++i){ofn[i]='\0';}

	for(i=1;i<argc;++i)
	{
		if(strlen(argv[i])>0)
		{
			strcpy(cmd,argv[i]);
			if(cmd[0]=='-'&&strlen(cmd)==2)
			{
				if(cmd[1]=='o')
				{
					if(argc>i+1&&strlen(argv[i+1])>0)
					{
						for(j=0;j<plinel;++j){ofn[j]='\0';}
						strcpy(ofn,argv[i+1]);
					}
				}else{
				if(cmd[1]=='e')
				{
					if(argc>i+1&&strlen(argv[i+1])>0)
					{
						for(j=0;j<plinel;++j){fn[j]='\0';}
						strcpy(fn,argv[i+1]);
						
						mariabasic(fn,ofn);

						break;
					}
				}else{
				if(cmd[1]=='h')
				{
					printf("\n\n\nThe mariaBasic Interpreter\n");
					printf("\n\nWritten by Dzinleski Jasenko Jun,2005 and later\n\n");
					printf("OS Win32 VRM 2.0.1.0\n\n");
					printf("\n");
					printf("9901 -e <mariaBasic code filename to execute>\n");
					printf("\n");
					printf("9901 -o <output filename> -e <mariaBasic code filename to execute>\n");
					printf("\n");
					break;
				}else{
				if(cmd[1]=='l')
				{
					printf("\n\n\nThe mariaBasic Interpreter\n");
					printf("\n\nWritten by Dzinleski Jasenko Jun,2005 and later\n\n");
					printf("OS Win32 VRM 2.0.1.0\n\n");
					printf("\n");
					printf("\tThis source and mariaBasic interpreter apply to GNU General Public License.\n");
					printf("\t		Copyright (C) 2005 and later Jasenko Dzinleski \n");
					printf("\n");
					printf("\t	This program is free software; you can redistribute it\n");
					printf("\tand/or modify it under the terms of the GNU General Public License as\n");
					printf("\tpublished by the Free Software Foundation; either version 2 of the\n");
					printf("\tLicense, or (at your option) any later version.\n");
					printf("\n");
					printf("\tThis program is distributed in the hope that it will be useful, but\n");
					printf("\tWITHOUT ANY WARRANTY; without even the implied warranty of\n");
					printf("\tMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n");
					printf("\tGeneral Public License for more details.\n");
					printf("\n");
					printf("\tYou should have received a copy of the GNU General Public License along\n");
					printf("\twith this program; if not, write to the Free Software Foundation, Inc.,\n");
					printf("\t51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.\n");
					printf("\n");
					break;
				}
				}
				}
				}
			}

		}
	}

	for(j=0;j<fni;++j)
	{
		if(fvars[j]!=NULL)
		{
			fclose(fvars[j]);
			fvars[j]=NULL;
			fvarc[j]=-1;
			fvarp[j]=-1;
			fvarn[j][0]='\0';
		}
	}

	return(0);
}
