//************************************************************************************************************************************************************************************
//*** 公用函数
//************************************************************************************************************************************************************************************
//获取URL后的参数值
function get_param(param_name){
	var array = window.location.href.split("?");     
	if ((parseInt(array.length) - parseInt(1)) > 0) {     
		//有参数     
		 var array1 = array[1].split("&");//？号后面参数部分     
		 if (array1.length > 0) {     
			//参数写法正确     
			 for (var i = 0; i < array1.length; i++) {     
				 var array2 = array1[i].split("=");     
				 if (array2.length > 0) {     
					 if (param_name == array2[0]) {     
						 //array2[1] 为对应的paramValue   
						 return array2[1];
					 }                      
				 }     
			 }     
		 }     
	 }
	return '';
}

//获取URL后字符串
function get_query(){
	return decodeURIComponent(window.location.search.substr(1));
}

//滚动到某个层位置
function scrollto(t){
	$("html,body").animate({
		scrollTop:$(t).offset().top
		},1000
	);
}

//得到LOADING字符串
function loadstr(t,a,b,c){
	var h='';var cc=''
	if(typeof(a)!='undefined'){h+=a;}
	if(typeof(c)!='undefined'){cc=c;}else{cc='加载中...';}
	h+='<span class="loadspan"><img src="img/loading.gif" border="0"><span style="font-size:12px;color:#aaa;font-weight:normal;">&nbsp;'+cc+'</span></span>';
	//h+='<span style="float:left;display:block;background:url(img/loading.gif) no-repeat;font-size:12px;color:#aaa;font-weight:normal;height:16px;line-height:16px;">&nbsp;&nbsp;&nbsp;&nbsp;'+cc+'</span>';
	if(typeof(b)!='undefined'){h+=b;}
	t.html(h);
}

//格式化数字，保留N位小数位，没有则补全
function formatNum(str,n){
	str = String(str*100);
	//alert(str.indexOf('.'));return false;
	if(str.indexOf('.')>0){
		var a=str.split('.');
		var b=a[1].substring(0,n)
		for(var i=0;i<n-b.length;i++){
			b+='0';
		}
		str = a[0]+'.'+b;
	}else{
		str+='.';
		for(var i=0;i<n;i++){
			str+='0';
		}
	}
	return str;
}

//时间转换为UNIX时间戳
function unixtime(){
	var dt = new Date();
	var ux = Date.UTC(dt.getFullYear(),dt.getMonth(),dt.getDay(),dt.getHours(),dt.getMinutes(),dt.getSeconds())/1000;
	return ux;
}

//主窗体重画布局
function resize_body(){
	var tw=$(window).width();
	var th=$(window).height();
	if(g_width != tw || g_height != th){
		var w = (tw-5-$('#mainr').offset().left);
		var w2 = (tw-5-$('#mainr').offset().left);
		var h = (th-10);
		$('#opacty').css({'width':tw+'px','height':th+'px'});
		$('#menu').css('height',(h-100)+'px');	//菜单高
		$('#mainr').css('width',w+'px');	//书架宽
		$('#mainr').css('height',h+'px');	//书架高
		$('#bookshelf_bgdiv').css({width:w2+'px','height':(th-10)+'px'});	//书架列表高度

		var h2 = $('#list1').height();
		if(h2<600){h2=600;}
		$('#bookshelf').css({width:(w2-20)+'px','height':h2+'px'});	//书架宽度
		$('#debug').html('书列表区域高度：'+$('#list1').height());
		$('#left_bot').css({'top':(h-60)+'px','left':'0px'});
		g_width=tw;g_height=th;
	}
}

//阅读画窗体函数
function tab_resize_body(){
	var w = $(window).width();
    var h = $(window).height();
	//窗口调整
	if(g_width != w || g_height != h){
		$('#divRight').css({width:w+'px',height:h+'px','display':'block'});
		$('.tab_content').css({width:(w)+'px',height:(h-26)+'px'});
		$('iframe').css({width:(w)+'px',height:(h-26)+'px'});
		$('.tab_content>.content').css({height:(h-26)+'px'});
		$('.jericho_tab>.tab_pages').css({'width':w+'px','overflow':'hidden'});
		g_width=w;g_height=h;
	}
}

//根据书籍数量重设右侧滚动条是否存在
function reset_scroll(){
	if($('#list1').children().length<=14){
		$('#bookshelf_bgdiv').removeClass('autoscroll')
	}else{
		$('#bookshelf_bgdiv').addClass('autoscroll')
	}
}

//重设书架left_m1con高度滚动条
function resize_m(t,h){
	var n_num = t.find('ul').children().length;
	if(n_num>=h){
		t.height(h*t.find('ul li').height()).addClass('autoscroll');
		var tinput = t.find('input');
		if(tinput){
			tinput.width(tinput.width()-25);
		}
	}else{
		t.height((n_num+2)*t.find('ul li').height()).removeClass('autoscroll');
	}
}

//验证类型
function verify_param(param,val){
	if(param=='book_id'){
		if(val==null || val.length==0){return false;}
	}
	if(param=='book_name'){
		if(val==null || val.length==0){return false;}
	}
	if(param=='book_url'){
		if(val==null || val.length==0){return false;}
		if(val.substring(0,7)!='http://'){return false;}
	}
	return true;
}

//仿写alert弹框层
function show_alert(title,content,w,h){
	var c_w=(typeof(w)=='undefined')?300:w;
	var c_h =(typeof(h)=='undefined')?100:h;
	var w = $(window).width();
	var h = $(window).height();
	var c_l = (w-c_w)/2;
	var c_t = (h-c_h)/2;
	$('#apactyalert').css({'display':'block','height':$(window).height()+'px'});
	$('#alertdiv').css({'width':c_w+'px','height':c_h+'px','display':'block','left':c_l+'px','top':c_t+'px'});
	var sdiv= '';
	sdiv += '<p style="width:100%;text-align:center;">'+content+'</p>';
	sdiv += '<p style="width:100%;text-align:center;"><a class="but1" style="display:block;" onclick="hide_alert();">确定</a></p>';
	$('#alertdiv>.ccon').html(sdiv);
	$('#alertdiv>.ctitle>.l').html(title);
}

//显示弹出操作层
function show_confirm(w,h){
	var c_w=(typeof(w)=='undefined')?300:w;
	var c_h =(typeof(h)=='undefined')?130:h;
	var w = $(window).width();
	var h = $(window).height();
	var c_l = (w-c_w)/2;
	var c_t = (h-c_h)/2;
	$('#opacty').css('display','block');
	$('#cofirmdiv').css({'width':c_w+'px','height':c_h+'px','display':'block','left':c_l+'px','top':c_t+'px'});
}

//隐藏弹出操作层
function hide_confirm(){
	$('#cofirmdiv').css('display','none');
	$('#opacty').css('display','none');
	$('#ckbox').attr('checked',false);
}

//隐藏alert弹框层
function hide_alert(){
	$('#alertdiv').css('display','none');
	$('#apactyalert').css('display','none');
}



//************************************************************************************************************************************************************************************
//*** 书籍操作函数
//************************************************************************************************************************************************************************************
//阅读功能键，默认打开书籍目录，可设置为打开最后阅读章节页
function book_read(t){
	external.sicon(0);
	var jsonstr = $(t).attr('jsonstr');//alert(jsonstr);
	var j=eval('('+jsonstr.replace(/\\\'/g,'\'')+')');//alert(j.name);
	var jstrc = $(t).attr('jstrc');
	var a=external.toparam();var b=eval('('+a+')');external.writelog('start---------------------传递JSON：'+jsonstr);
	clear_isupdate(j.bookid);
	if(j.id=='0'){
		external.openurl(j.name,j.url);
	}else{
		if(b.readpos=='0' || jstrc==''){
			external.SetTab(3,"open_tab('"+jsonstr+"');");
		}else{
			external.SetTab(3,"open_tab('"+jsonstr.substr(0,jsonstr.length-1)+','+jstrc.substr(1)+"');");
		}
	}
}

//移动书架层
function book_move(t){
	var book_id = $(t).attr('id');
	var book_name=$(t).attr('book_name');
	verify_param('book_id',book_id);
    show_confirm(300,140);
	var ta=external.booklist('{"act":"getlist"}');
	var tb=eval('('+ta+')');
	var thtml='';
	for(var i=0;i<tb.list.length;i++){
		var tname=tb.list[i].name;
		if(tname!='显示所有'){thtml += '<option value="'+tname+'">'+tname+'</option>';}
	}
	var sdiv= '';
	sdiv += '<p><span class="l tb1">书籍名称：</span><span class="l">'+book_name+'</span></p>';
	sdiv += '<p><span class="l tb1">移动到：</span><span class="l">&nbsp;<select id="book_shelf">'+thtml+'</select></span></p>';
	sdiv += '<p><a class="l but1" onclick="book_move_act(\''+book_id+'\');">确定</a><a class="l but1" onclick="hide_confirm();">取消</a></p>';
	$('#cofirmdiv>.ccon').html(sdiv);
	$('#cofirmdiv>.ctitle>.l').html('操作提示 - 移动书架');
}

//移动书架
function book_move_act(book_id){
	//从原书架中删除
	var newshelf=$('#book_shelf').val();
	var ta=external.booklist('{"act":"getlist"}');
	var tb=eval('('+ta+')');
	for(var i=0;i<tb.list.length;i++){
		var tname=tb.list[i].name;
		var tval=tb.list[i].value;
		if(tval.indexOf(book_id)>=0 && tname!='显示所有'){
			del_shelf(tname,book_id);
		}
	}
	//增加到新书架中
	update_shelf(newshelf,book_id);
	hide_confirm();
	show_shelflist();
	//get_shelfbook(newshelf);
	setpos_shelf(newshelf);
}

//更改图书是否右上角显示更新提示
function book_newtips(t){//alert($(t).html());
	var book_id = $(t).attr('id');
	verify_param('book_id',book_id);
	if($(t).attr('newtips')=='1'){
		var istxupdate=0;
		$(t).find('.isnewtips').removeClass('bnew');
	}else{
		var istxupdate=1;
		$(t).find('.isnewtips').addClass('bnew');
	}
	$(t).attr('newtips',istxupdate);
	external.bookoper('{"act":"update","bookid":"'+book_id+'","istxupdate":'+istxupdate+'}');
}

//更改为已读状态
function clear_isupdate(bookid){
	external.bookoper("{'act':'update','bookid':'"+bookid+"','isupdate':'0'}");
	try{
		var t=$('#'+bookid).find('.isnewtips')
		t.removeClass('bnew');
		if(t.hasClass('bnew_none')==false){
			t.addClass('bnew_none');
		}
	}catch(e){}
	//setpos_shelf('显示所有');
	//external.execjsfunc(2,"setpos_shelf();");
}

//导出电子书
function book_export(t){
	var book_id = $(t).attr('id');
	verify_param('book_id',book_id);
    show_alert('操作提示',book_id);
}

//删除书籍确认层
function book_delete(t){
	var book_id = $(t).attr('id');
	verify_param('book_id',book_id);
    show_confirm(300,100);
	var sdiv= '';
	sdiv += '<p><span class="fred">点击“确定”按钮将永久删除该书</span></p>';
	sdiv += '<p><a class="l but1" onclick="book_delete_act(\''+book_id+'\');">确定</a><a class="l but1" onclick="hide_confirm();">取消</a></p>';
	$('#cofirmdiv>.ccon').html(sdiv);
	$('#cofirmdiv>.ctitle>.l').html('操作提示 - 删除书籍');
}

//删除书籍
function book_delete_act(book_id){
	//从书架中删除
	var newshelf=$('#book_shelf').val();
	var ta=external.booklist('{"act":"getlist"}');
	var tb=eval('('+ta+')');
	for(var i=0;i<tb.list.length;i++){
		var tname=tb.list[i].name;
		var tval=tb.list[i].value;
		if(tval.indexOf(book_id)>=0){
			del_shelf(tname,book_id);
		}
	}
	//删除本书节点
	external.bookoper('{"act":"delete","bookid":"'+book_id+'"}');
	hide_confirm();
	show_shelflist();
	setpos_shelf(g_shelf_name);
	resize_body();
}

//查看书籍属性
function book_attr(t){
	var book_id = $(t).attr('id');
	verify_param('book_id',book_id);
    show_alert('操作提示',book_id);
}

//判断是否重名
function is_book_repeat(book_name,site){
	var a=external.booklist('{"act":"getbook","name":"显示所有"}');//alert(a+shelf_name);
	var b=eval('('+a+')');
	for(var i=0;i<b.list.length;i++){
			var c=b.list[i];
			var name=c.name;
			var book_id=c.bookid;
			if(typeof(site)!='undefined'){
				if(name==book_name && site!=c.site) return book_id;
			}else{
				if(name==book_name) return book_id;
			}
	}
	return '';
}

//加书
function book_add(book_info,r,rbookid){//alert(book_info);
	//alert(r+'\r\n'+rbookid);
	
	if(typeof(book_info)=='undefined'){
		var book_name = $('#book_name').val();
		var book_url = $('#book_url').val();
		if(verify_param('book_name',book_name)==false){
			$('#book_name_alert').html('书籍名称不能为空');$('#book_name').focus();return false;
		}
		if(verify_param('book_url',book_url)==false){
			$('#book_url_alert').html('目录网址必须以 http:// 开头');$('#book_url').focus();return false;
		}
		var pic_url = $('#pic_url').val();
		var book_author = $('#book_author').val();
		var book_shelf = $('#book_shelf').val();
		var istxupdate = ($('#istxupdate').attr('checked')=='checked')?1:0;
		//show_alert('操作提示',book_shelf+'-'+istxupdate);
		var book_id = 'book_'+unixtime()+'_'+(Math.floor(Math.random()*999+1));
		obook_id = is_book_repeat(book_name);
		if(obook_id.length>5 && r!='1'){//alert(book_info.replace(/'/ig,'\\\''));return false;
			book_info = "{'act':'add','bookid':'"+obook_id+"','id':'0','pid':'0','book_name':'"+book_name+"','book_author':'"+book_author+"','book_url':'"+book_url+"','pic_url':'"+pic_url+"','memo':''}";
			book_replace(book_info,obook_id);
			return false;
		}
		if(typeof(rbookid)!='undefined'){
			book_id=rbookid;
		}
		update_shelf(book_shelf,book_id);
		update_shelf('显示所有',book_id);
		var jsonstr = "{'act':'add','bookid':'"+book_id+"','id':'0','pid':'0','name':'"+book_name+"','author':'"+book_author+"','url':'"+book_url+"','pic':'"+pic_url+"','memo':''}";
		external.bookoper(jsonstr);
		hide_confirm();
		show_shelflist();
		//get_shelfbook(book_shelf);
		setpos_shelf(book_shelf);
	}else{
		var a=eval('('+book_info+')');
		var id=a.id;
		var pid=a.pid;if(a.pid=='') pid='0';
		var book_name=a.book_name;
		var book_url=a.book_url;
		var book_author=a.book_author;
		var pic_url=a.pic_url;
		var istxupdate=1;
		var site=a.site
		var book_id = 'book_'+unixtime()+'_'+(Math.floor(Math.random()*999+1));
		obook_id = is_book_repeat(book_name);
		if(obook_id.length>5 && r!='1'){//alert(book_info.replace(/'/ig,'\\\''));return false;
			book_replace(book_info,obook_id);
			return false;
		}
		if(typeof(rbookid)!='undefined'){book_id=rbookid;}
		//alert('添加'+book_id+'\r\n'+rbookid);return false;
		update_shelf('显示所有',book_id);
		//if(parseInt(pid)>0){
		var jsonstr = '{"act":"add","bookid":"'+book_id+'","id":"'+id+'","pid":"'+pid+'","name":"'+book_name+'","author":"'+book_author+'","url":"'+book_url+'","pic":"'+pic_url+'","memo":"","site":"'+site+'"}';
		//}else{
		//	var jsonstr = '{"act":"add","bookid":"'+book_id+'","id":"'+id+'","name":"'+book_name+'","author":"'+book_author+'","url":"'+book_url+'","pic":"'+pic_url+'","memo":"","site":"'+site+'"}';
		//}
		//alert(jsonstr);return false;
		external.bookoper(jsonstr);
		show_shelflist();
		//get_shelfbook('显示所有');
		setpos_shelf('显示所有');
	}
	resize_body();
}

//手工追书输入层
function book_add_user(){
	show_confirm(500,270);
	var ta=external.booklist('{"act":"getlist"}');
	var tb=eval('('+ta+')');
	var thtml='';
	for(var i=0;i<tb.list.length;i++){
		var tname=tb.list[i].name;var select = '';
		if(g_shelf_name==tname){
			select = ' selected'
		}
		if(tname!='显示所有'){
			thtml += '<option value="'+tname+'"'+select+'>'+tname+'</option>';
		}else{
			thtml += '<option value="'+tname+'"'+select+'>不分类</option>';
		}
	}
	var sdiv= '';
	sdiv += '<p><span class="l tb1">书籍名称：</span><span class="l"><input id="book_name" type="text" class="text1" value=""></span><span class="fred" id="book_name_alert">必填</span></p>';
	sdiv += '<p><span class="l tb1">目录网址：</span><span class="l"><input id="book_url" type="text" class="text1" value=""></span><span class="fred" id="book_url_alert">必填</span></p>';
	sdiv += '<p><span class="l tb1">封面图片：</span><span class="l"><input id="pic_url" type="text" class="text1"></span><span>该书封面图片的网址</span></p>';
	sdiv += '<p><span class="l tb1">作者：</span><span class="l"><input id="book_author" type="text" class="text1"></span></p>';
	sdiv += '<p><span class="l tb1">书架分类：</span><span class="l">&nbsp;<select id="book_shelf">'+thtml+'</select></span><span class="l"><input id="istxupdate" type="checkbox" checked></span><span>关注书籍更新</span></p>';
	sdiv += '<p><span class="tips">友情提醒：本方式能有效过滤对方网站大部分广告。当您本地网页和对方服务器网页有差异就会提示有变动，在网络不畅时可能导致误报，所以不推荐使用本方式加书。</span></p>'
	sdiv += '<p><a class="l but1" onclick="book_add();">确定</a><a class="l but1" onclick="hide_confirm();">取消</a></p>';
	$('#cofirmdiv>.ccon').html(sdiv);
	$('#cofirmdiv>.ctitle>.l').html('操作提示 - 手工追书');
}

//添加新书方法选择层
function book_add_div(){
	show_confirm(350,170);
	var sdiv= '';
	sdiv += '<p><span class="l book_addtype1"></span><a class="l addtext" onclick="external.SetTab(1,\'openurl(1);\');hide_confirm();">通过搜索添加新书</a></p>';
	sdiv += '<p><span class="l book_addtype2"></span><a class="l addtext" onclick="external.SetTab(1,\'openurl(2);\');hide_confirm();">通过在线书库添加新书</a></p>';
	sdiv += '<p><span class="l book_addtype3"></span><a class="l addtext" onclick="book_add_user();">通过输入小说目录网址手工追书</a></p>';
	$('#cofirmdiv>.ccon').html(sdiv);
	$('#cofirmdiv>.ctitle>.l').html('操作提示 - 添加新书');
}

//同名替换来源确认层
function book_replace(book_info,obook_id){
	var json=eval('('+book_info+')');
	var book_name=json.book_name;var id=json.id;var pid=json.pid;
	book_info = book_info.replace(/'/ig,'\\\'');
	show_confirm();
	var sdiv= '';
	sdiv += '<p>&nbsp;书名：'+book_name.substring(0,8)+'，该书已经在书架中</p><p>&nbsp;点击“确定”按钮将替换当前来源站点</p>';
	sdiv += '<p><a class="l but1" onclick="book_add(&quot;'+book_info+'&quot;,1,&quot;'+obook_id+'&quot;);hide_confirm();">确定</a>';
	if(id=='0' && pid=='0'){
		sdiv += '<a class="l but1" onclick="hide_confirm();">取消</a></p>';
	}else{
		sdiv += '<a class="l but1" onclick="hide_confirm();external.SetTab(1);">取消</a></p>';
	}
	$('#cofirmdiv>.ccon').html(sdiv);
	$('#cofirmdiv>.ctitle>.l').html('操作提示 - 来源替换');
}

//************************************************************************************************************************************************************************************
//*** 书架操作函数
//************************************************************************************************************************************************************************************
//显示书架列表
function show_shelflist(shelf_name){
	var a=external.booklist('{"act":"getlist"}');
	var b=eval('('+a+')');
	if(typeof(shelf_name)=='undefined'){
		var arr_shelf = new Array();
		for(var i=0;i<b.list.length;i++){
			var sl_name=b.list[i].name;
			var sl_value =b.list[i].value;
			var varr = sl_value.split(',');
			var sl_len = varr.length;
			if(sl_value.length==0){sl_len=0;}
			if(sl_name=='显示所有'){
				arr_shelf.push('<li onclick="get_shelfbook(\'');
				arr_shelf.push(sl_name);
				arr_shelf.push('\')"><span class="icon_a"></span><span class="shelf_name">');
				arr_shelf.push(sl_name);
				arr_shelf.push('</span><span class="icon_num">(');
				arr_shelf.push(sl_len);
				arr_shelf.push(')</span></li>');
			}else{
				arr_shelf.push('<li onclick="get_shelfbook(\'');
				arr_shelf.push(sl_name);
				arr_shelf.push('\')" class="shelfli"><span class="icon_s"></span><span class="shelf_name">');
				arr_shelf.push(sl_name);
				arr_shelf.push('</span><span class="icon_num">(');
				arr_shelf.push(sl_len);
				arr_shelf.push(')</span></li>');
			}
		}
		$('#shelf_list').html(arr_shelf.join(''));
		arr_shelf = null;
		//书架背景切换
		$('#menu_con>div>ul>li').mouseover(function(){
			$(this).css('background','url(img/shelf_bg.gif) no-repeat;');
		}).mouseout(function(){
			$(this).css('background','none;');
		}).click(function(){
			$('#menu_con>div>ul>li').css('background','none;');
			$('#menu_con>div>ul>li').mouseout(function(){
				$(this).css('background','none;');
			});
			$(this).css('background','url(img/shelf_bg.gif) no-repeat;').unbind('mouseout');
			
		});
		//书架右键菜单
		$('#shelf_list>.shelfli').contextMenu('shelf_right_mouse',
			{
				bindings: {
				'shelf_rename':function(t){shelf_rename(t);},
				'shelf_delete':function(t){shelf_delete(t);},
				'shelf_empty':function(t){shelf_empty(t);}
			}
		});
		setpos_shelf('显示所有');
	}else{
		//alert(shelf_name);
		for(var i=0;i<b.list.length;i++){//alert(b.list[i].name.length+'\r\n'+shelf_name.length+'\r\n'+(b.list[i].name==shelf_name));
			if(b.list[i].name==shelf_name){return b.list[i].value;}
		}
		setpos_shelf(shelf_name);
		return '';
	}
}

//设置选中书架
function setpos_shelf(shelf_name){
	//如果shelf_name未定义，则刷新选中的书架
	if(typeof(shelf_name)=='undefined'){//alert($('#list1').html());
		if($('#list1').html()!=null){
			setpos_shelf(g_shelf_name);alert(1);
		}
	}else{//否则点击指定名称的书架
		$('#shelf_list>li').each(function(){
			if($(this).find('.shelf_name').html()==shelf_name){$(this).trigger('click');return false;}
		});
	}
}

//显示书架中的书籍列表
function get_shelfbook(shelf_name,stype){
	if(typeof(stype)=='undefined'){
		var d1=new Date();
		var a=external.booklist('{"act":"getbook","name":"'+shelf_name+'"}');
		var d2=new Date();
		$('#debug').html('点击书架：'+shelf_name+'<br>'+stype+'<br>耗时：'+(d2.getTime()-d1.getTime())+'<br>'+$('#list1').css('display'));
		try{var b=eval('('+a+')');}catch(e){show_alert('操作提示 - 错误','INI文件格式错误');return false;}
		var blen=b.list.length;
		g_shelf_name = shelf_name;
		var arr_book=new Array();
		var c,bookid,id,pid,name,author,url,pic,site,istxupdate,isupdate,pos,dur,jstr,jstrc;
		
		for(var i=0;i<blen;i++){
			c=b.list[i];
			bookid=c.bookid;
			id = c.id;
			pid=c.pid;
			name=c.name;
			author=c.author;
			url=c.url;
			pic=c.pic;
			site=c.site;
			istxupdate=c.istxupdate;
			isupdate=c.isupdate;
			pos=c.readpos.pos;
			dur=c.readpos.dur;
			jstr="{'id':'"+id+"','name':'"+name+"','bookid':'"+bookid+"','url':'"+url+"','gtype':'1','site':'"+site+"','author':'"+author+"','pic':'"+pic+"','pid':'"+pid+"'}";
			jstr=jstr.replace(/\\{1,}/g,'\\\\');
			jstr=jstr.replace(/\'/g,'\\\'');
			//最后阅读位置
			jstrc = '';
			if(pos!='-1'){
				jstrc="{'open_pos':'parent','chapterurl':'"+c.readpos.url+"','cname':'"+c.readpos.cname+"'}"
			}
			jstrc=jstrc.replace(/\\{1,}/g,'\\\\');
			jstrc=jstrc.replace(/\'/g,'\\\'');

			arr_book.push('<li>');
			arr_book.push('<div jsonstr="'+jstr+'" jstrc="'+jstrc+'" id="'+bookid+'" class="lbg" book_name="'+name+'" book_author="'+author+'" newtips="'+istxupdate+'" pos="'+pos+'" dur="'+dur+'">');
			var isnew = '';
			if(isupdate=='1' && istxupdate=='1'){isnew='bnew';}else{isnew='bnew_none';}
			arr_book.push('<a class="book" href="javascript:void(0);">');
			arr_book.push('<div class="adiv">');
			arr_book.push('<div class="bimg">');
			if(pic=='#' || pic.indexOf('http://')>=0 || pic.length==0){
				arr_book.push('<div class="btitle">'+name+'</div>');
				arr_book.push('<div class="bauthor">'+author+'</div>');
				arr_book.push('<div class="mask"><div class="isnewtips '+isnew+'"></div></div>');
			}else{
				arr_book.push('<img class="mpic" src="'+pic+'" onerror="errpic(this,\''+isnew+'\');">');
				arr_book.push('<div class="mask"><div class="isnewtips '+isnew+'"></div></div>');
			}
			arr_book.push('</div>');
			arr_book.push('</div>');
			arr_book.push('</a>');
			arr_book.push('</div>');
			arr_book.push('</li>');
		}
		var bhtml=arr_book.join('');
		arr_book = null;
		if(bhtml.length>0){
			$('#list1').css('display','block');
			document.getElementById('list1').innerHTML=bhtml;
			reset_scroll();
			book_effect();
		}else{
			$('#list1').css('display','none');
		}		
	}else if(stype=='history'){
		var a=external.specialkey('history');
		a=a.replace(/\\{1,}/g,'\\\\');
		if(a.length==0)return;
		try{var b=eval('('+a+')');}catch(e){
			clear_history();return false;
			show_alert('操作提示 - 错误','最近阅读数据错误');return false;
		}
		var arr_history=new Array();
		var jstr = '';var c=null;
		for(var i=0;i<b.length;i++){
			c=b[i];
			jstr="{'id':'"+c.id+"','name':'"+c.name+"','bookid':'"+c.bookid+"','url':'"+c.url+"','gtype':'1','site':'"+c.site+"','author':'"+c.author+"','pic':'"+c.pic+"','pid':'"+c.pid+"','open_pos':'parent','chapterurl':'"+c.chapterurl+"','cname':'"+c.cname+"'}";
			jstr=jstr.replace(/\\{1,}/g,'\\\\');
			jstr=jstr.replace(/\'/g,'\\\'');
			arr_history.push('<li>');
			arr_history.push('<span class="icon_d"></span><span class="icon_chi" title="');
			arr_history.push(c.cname);
			arr_history.push('" jstr="');
			arr_history.push(jstr);
			arr_history.push('">');
			arr_history.push(c.name);
			arr_history.push(' </span><span class="icon_del" onclick="del_history(\'');
			arr_history.push(c.name);
			arr_history.push('\');"></span>');
			arr_history.push('</li>');
		}
		$('#history').html(arr_history.join(''));
		arr_history = null;
		//书架背景切换
		$('#menu_con>div>ul>li').mouseover(function(){
			$(this).css('background','url(img/shelf_bg.gif) no-repeat;');
		}).mouseout(function(){
			$(this).css('background','none;');
		}).click(function(){
			$('#menu_con>div>ul>li').css('background','none;');
			$('#menu_con>div>ul>li').mouseout(function(){
				$(this).css('background','none;');
			});
			$(this).css('background','url(img/shelf_bg.gif) no-repeat;').unbind('mouseout');
			//如果是最近阅读则打开
			if($(this).find('.icon_chi').html()!=null){//alert($(this).find('.icon_chi').attr('jstr'));
				external.SetTab(3,"open_tab('"+$(this).find('.icon_chi').attr('jstr')+"')");
			}
		});

		//最近阅读删除按钮样式
		$('#history>li>.icon_del').mouseover(function(){
			$(this).css('background','url(img/btn_download_close.gif) -16px 0 no-repeat;');
		}).mouseout(function(){
			$(this).css('background','url(img/btn_download_close.gif) 0 0 no-repeat;');
		});
		resize_m($('#left_m3con'),10);
	}else{
	
	}
}

//封面图片出错显示文字层
function errpic(t,isnew){
	var bimg=$(t).parent();
	var attrobj = bimg.parent().parent().parent();
	var nhtml='';
	nhtml += '<div class="btitle">'+attrobj.attr('name')+'</div>';
	nhtml += '<div class="bauthor">'+attrobj.attr('author')+'</div>';
	nhtml += '<div class="mask"><div class="isnewtips '+isnew+'"></div></div>';
	bimg.html(nhtml);
}

//书籍菜单和右键效果
function book_effect(){
	//*******************************
	//图书鼠标滑过效果
	$('#list1>li>.lbg').mouseover(function(){
		$('#bookdesc').css('left',$(this).offset().left-35);
		$('#bookdesc').css('top',$(this).offset().top+105);
		var book_id = $(this).attr('id');
		var book_name=$(this).attr('book_name');
		var pos = $(this).attr('pos');
		var dur = $(this).attr('dur');//alert(dur);
		$('#bookdesc>#mbody>#book_name2').html('书名：'+book_name);
		if(pos=='-1' || pos=='0'){
			$('#bookdesc>#mbody>#book_progress_txt').html('0/0章 (0.00%)');
			$('#bookdesc>#mbody>#book_progress_img>#pimg>#pos').css('width','0px');
		}else{
			var percent=formatNum((pos/dur),2);
			$('#bookdesc>#mbody>#book_progress_txt').html(pos+'/'+dur+'章 ('+percent+'%)');
			$('#bookdesc>#mbody>#book_progress_img>#.pimg>#.pos').css('width',percent+'px');
		}
		$('#pfun>#read').attr({'jsonstr':$('#'+book_id).attr('jsonstr'),'jstrc':$('#'+book_id).attr('jstrc')});
		$('#bookdesc').show();
	}).mousedown(function(){
		if(event.button==1){
			g_bookmousedown=this;g_bookmousedown_s=new Date();
		}else{
			g_bookmousedown = null;
		}
		//$(this).addClass('lbg2');
		//$(this).find('.book').addClass('book2');
		//$(this).find('.adiv').addClass('adiv2');
		//$(this).find('.btitle').addClass('btitle2');
		//$(this).find('.bauthor').addClass('bauthor2');
		//$(this).find('.bimg').addClass('bimg2');
	}).mouseup(function(){
		if(g_bookmousedown!=null){
			if((new Date().getTime()-g_bookmousedown_s.getTime())<200) book_read(g_bookmousedown);
		}
		$('#bookdesc').hide();
		$(this).unbind('mouseover');
	}).mouseout(function(){
		//$(this).removeClass('lbg2');
		//$(this).find('.book').removeClass('book2');
		//$(this).find('.adiv').removeClass('adiv2');
		//$(this).find('.btitle').removeClass('btitle2');
		//$(this).find('.bauthor').removeClass('bauthor2');
		//$(this).find('.bimg').removeClass('bimg2');
		$('#bookdesc').hide();
		//回绑mouseover事件
		$(this).bind('mouseover',function(){
			$('#bookdesc').css('left',$(this).offset().left-35);
			$('#bookdesc').css('top',$(this).offset().top+105);
			var book_id = $(this).attr('id');
			var book_name=$(this).attr('book_name');
			$('#bookdesc>#mbody>#book_name2').html('书名：'+book_name);
			$('#bookdesc').show();
		});
	//}).dblclick(function(){
		
	//图书层右键菜单
	}).contextMenu('book_right_mouse',
		{
			bindings: {
			'book_read':function(t){book_read(t);},
			'book_move':function(t){book_move(t);},
			'book_newtips':function(t){book_newtips(t);},
			'book_export':function(t){book_export(t);},
			'book_delete':function(t){book_delete(t);},
			'book_attr':function(t){book_attr(t);}
		}
	});
	//防止闪烁
	$('#bookdesc').mouseover(function(){
		$('#bookdesc').show();
	}).mouseout(function(){
		$('#bookdesc').hide();
	});
	//点击任意地方消除提示层
	$('body').mousedown(function(){
		//$('#bookdesc').hide();
	});
}

//保存书架排序
function save_sort(str){
	$('#debug').html('书架排序：'+str);
	external.booklist('{"act":"update","name":"'+g_shelf_name+'","value":"'+str+'","delbook":0}');//alert('清空书架');
}

//新增书籍ID到书架中
function update_shelf(shelf_name,book_id){
	//alert(show_shelflist(shelf_name));
	var a = show_shelflist(shelf_name);
	var b = a.split(',');
	for(var i=0;i<b.length;i++){
		if(b[i]==book_id){return false;}
	}
	//如果书架为空，则直接附加，否则以“，”分割附加;
	if(a.length==0){
		var c = book_id;
	}else{
		var c = book_id + ',' + a;
	}//alert(c);return false;
	external.booklist('{"act":"update","name":"'+shelf_name+'","value":"'+c+'","delbook":0}');
}

//删除书架中的书籍ID，可以多个，用“，”分割
function del_shelf(shelf_name,book_idstr){
	var a = show_shelflist(shelf_name);
	var b = book_idstr.split(',');
	for(var i=0;i<b.length;i++){
		a=a.replace(','+b[i],'');
		a=a.replace(b[i]+',','');
		a=a.replace(b[i],'');
	}//alert(a);
	external.booklist('{"act":"update","name":"'+shelf_name+'","value":"'+a+'","delbook":0}');
}

//判断书架是否重名
function shelf_repeatname(val,ids){
	if(val==null || val.length==0){show_alert('操作提示','书架名称不能为空，请重新修改');return true;}
	if(val.length>8){show_alert('操作提示','书架名称不能超过8个字符，请重新修改');return true;}
	var shelf_ul = $('#left_m1con>ul');
	for(var i=1;i<=shelf_ul.children().length;i++){
		var tmpli = $('#left_m1con>ul>li:nth-child('+i+')');
		if(tmpli.find('.shelf_name').html()==val && i!=ids+1){
			show_alert('操作提示','书架名称重复，请重新修改');return true;
		}
	}
	return false;
}

//保存书架
function save_shelf(t,oldname,shelf_num,act){
	var pli = $(t).parent().parent();
	var shelf_name = $(t).val().replace(/[\"\'\s*]/ig,'');
	if(shelf_repeatname(shelf_name,pli.index())){
		$(t).focus().val(oldname).select();
	}else{
		pli.html('<span class="icon_s"></span><span><span class="shelf_name">'+shelf_name+'</span><span class="icon_num">('+shelf_num+')</span>');
		if(act=='rename'){external.booklist('{"act":"rename","oldname":"'+oldname+'","newname":"'+shelf_name+'"}');show_shelflist();setpos_shelf(shelf_name);}
		if(act=='add'){external.booklist('{"act":"add","name":"'+shelf_name+'","value",""}');show_shelflist();setpos_shelf(shelf_name);}
		//alert('修改成功');
	}
}

//书架重命名
function shelf_rename(t){
	var shelf_name=$(t).find('.shelf_name').html();
	var shelf_num=$(t).find('.icon_num').html().replace(/[\(\)]/ig,'');
	if(shelf_name.length>0){
		//置为编辑状态
		$(t).html('<span class="icon_s"></span><span><input type="text" value="'+shelf_name+'"></span>');
		$(t).find('input').focus().select().blur(function(){
			save_shelf(this,shelf_name,shelf_num,'rename');
			//alert(shelf_name+'\r\n'+this.value);
		}).keypress(function(e){
			if(e.keyCode==13){save_shelf(this,shelf_name,shelf_num,'rename');}
		});
	}
}

//删除书架确认层
function shelf_delete(t){
	show_confirm();
	var sdiv= '';
	sdiv += '<p><input type="checkbox" id="ckbox">&nbsp;是否同时删除 "'+$(t).find('.shelf_name').html()+'" 中的书</p><p style="text-indent:25px;color:#555;">勾选此项永久删除该书架中的书（<font color=red>慎重</font>）</p>';
	sdiv += '<p><a class="l but1" onclick="shelf_delete_act('+($(t).index()+1)+',\''+$(t).find('.shelf_name').html()+'\');">确定</a><a class="l but1" onclick="hide_confirm();">取消</a></p>';
	$('#cofirmdiv>.ccon').html(sdiv);
	$('#cofirmdiv>.ctitle>.l').html('操作提示 - 删除书架');
}

//删除书架
function shelf_delete_act(tpos,shelf_name){
	var tmpli = $('#left_m1con>ul>li:nth-child('+tpos+')');
	tmpli.remove();
	if($('#ckbox').attr('checked')=='checked'){
		var book_idstr = show_shelflist(shelf_name);
		external.booklist('{"act":"delete","name":"'+shelf_name+'","delbook":1}');//alert('同时彻底删除书架中的书');
		del_shelf('显示所有',book_idstr);
	}else{
		external.booklist('{"act":"delete","name":"'+shelf_name+'","delbook":0}');//alert('删除书架不删除书');
	}
	resize_m($('#left_m1con'),10);
	hide_confirm();
	show_shelflist();
}

//清空书架确认层
function shelf_empty(t){
	show_confirm();
	var sdiv= '';
	sdiv += '<p><input type="checkbox" id="ckbox">&nbsp;是否同时删除 "'+$(t).find('.shelf_name').html()+'" 中的书</p><p style="text-indent:25px;color:#555;">勾选此项将永久删除该书架中的书（<font color=red>慎重</font>）</p>';
	sdiv += '<p><a class="l but1" onclick="shelf_empty_act('+($(t).index()+1)+',\''+$(t).find('.shelf_name').html()+'\');">确定</a><a class="l but1" onclick="hide_confirm();">取消</a></p>';
	$('#cofirmdiv>.ccon').html(sdiv);
	$('#cofirmdiv>.ctitle>.l').html('操作提示 - 清空书架');
}

//清空书架
function shelf_empty_act(tpos,shelf_name){
	if($('#ckbox').attr('checked')=='checked'){
		var book_idstr = show_shelflist(shelf_name);
		external.booklist('{"act":"update","name":"'+shelf_name+'","value":"","delbook":1}');//alert('同时彻底删除书架中的书');
		del_shelf('显示所有',book_idstr);
	}else{
		external.booklist('{"act":"update","name":"'+shelf_name+'","value":"","delbook":0}');//alert('清空书架');
	}
	hide_confirm();
	show_shelflist();
}


//************************************************************************************************************************************************************************************
//*** 阅读操作函数
//************************************************************************************************************************************************************************************
//新建一个阅读TAB
function new_read(jsonstr){
	var a = eval('('+jsonstr+')');
	var id=a.id;
	var bookid=a.bookid;
	var name=a.name;
	var url=a.url;
	var site=a.site;

	var temp_html='chapter_content.html?'+encodeURIComponent(jsonstr);
	$.fn.jerichoTab.addTab({
	title: name+'-'+site,
	closeable: true,
	iconImg: 'images/default.png',
	data: {
		title: name,
		dataType: 'iframe',
		dataLink: temp_html
	}
	}).showLoader().loadData();
	//g_ifr.books.push(a);
}

//打开阅读TAB
function open_tab(jsonstr){
	jsonstr = jsonstr.replace(/\\{1,}/g,'\\\\');
	try{var a = eval('('+jsonstr+')');}catch(e){
		external.SetTab(2,"show_alert('操作提示 - 错误','书籍数据格式错误，无法打开');");return false;
	}
	var id=a.id;
	var bookid=a.bookid;

	//如果不存在则新建阅读TAB
	var fid=id;if(bookid.length>0){fid=bookid;}
	external.writelog('fid：'+fid);
	var a=$('.tab_pages>div>ul');
	var tabhtml = a.html();//external.writelog('TAB的HTML：'+tabhtml);
	if(tabhtml.indexOf('\'bookid\'%3A\''+fid+'\'')<0 && tabhtml.indexOf('\'id\'%3A\''+fid+'\'')<0){
		new_read(jsonstr);external.writelog('创建新TAB：'+jsonstr);
		tab_resize_body();
	}
	//alert(g_ifr.tabs.length+'\r\n'+g_ifr.books.length);
	//存在则模拟点击阅读TAB
	$('.tab_pages>div>ul>li').each(function(){
		var c=$(this).attr('dataLink');
		if(c.indexOf('\'bookid\'%3A\''+fid+'\'')>=0 || c.indexOf('\'id\'%3A\''+fid+'\'')>=0){external.writelog('找到了TAB并点击：'+$(this).attr('dataLink'));
			$(this).trigger("mouseup");//alert('模拟点击iframe:'+fid);
			return;
		}
	});
	
}

//查找iframe
function find_iframe(jsonstr,ret,url){//alert(jsonstr);
	try{var json = eval('('+jsonstr+')');}catch(e){return false;}
	var id=json.id;
	var bookid=json.bookid;
	
	var fid=id;if(bookid.length>0){fid=bookid;}
	//var date1=new Date();
	$('iframe').each(function(){
		var c=$(this).attr('src');//alert(c);//alert(c.indexOf('\'bookid\':\''+fid+'\'')+'\r\n'+fid+'\r\n'+c);
		if(c.indexOf('\'bookid\'%3A\''+fid+'\'')>=0 || c.indexOf('\'id\'%3A\''+fid+'\'')>=0){
			external.writelog('end---------------------返回结果找IFRAME-jsonstr：'+jsonstr+'-fid：'+fid+'src：'+c);
			try{
				var ifrid=$(this).attr('id');
				var ifr=document.getElementById(ifrid);
				//判断是否是同样的目录，一致则不进行其它操作；
				var json_old=ifr.contentWindow.get_pobj().json_mulu;
				if(json_old!=null){
					var json_new=eval('('+ret+')');//alert(json_old.m.length+'\r\n'+json_new.m.length);
				}
				if(external.IsForeWin()=='1'){
					ifr.contentWindow.focus();
				}
				ifr.contentWindow.iframe_html(jsonstr,ret,url);
				return '';
			}catch(e){
				alert(e.name + "\r\n" + e.message);
				return '';
			}
		}
	});
	//var date2=new Date();
	//alert('b'+(date2.getTime()-date1.getTime()));
}

//取iframe的pobj对象
function get_pobj(){
	return pobj;
}

//软件调用找选中TAB的焦点iframe
function set_iframe(){//alert(jsonstr);
	$('.tab_pages>div>ul>li').each(function(){
		if($(this).attr('class').indexOf('tab_selected')>0){
			var ifrid=$(this).attr('id');
			ifrid=ifrid.replace('_','iframe_');
			var ifr=document.getElementById(ifrid);
			if(external.IsForeWin()=='1'){
				ifr.contentWindow.focus();
			}
		}
	});
}

//刷新指定bookid的iframe里的目录
function refresh_iframe(bookid,rtag){
	var fid=bookid
	$('iframe').each(function(){
		var c=$(this).attr('src');//alert(c);//alert(c.indexOf('\'bookid\':\''+fid+'\'')+'\r\n'+fid+'\r\n'+c);
		if(c!='read_default.html'){
			if(c.indexOf('\'bookid\'%3A\''+fid+'\'')>=0 || c.indexOf('\'id\'%3A\''+fid+'\'')>=0){
				var ifrid=$(this).attr('id');
				if(rtag=='1'){
					$('#'+ifrid).contents().find('#refresh').trigger('click');
				}else{
					//alert('刷新云端数据');
				}
				return '';
			}
		}
	});
}

//操作iframe页面
function iframe_html(jsonstr,ret,rurl){
	//$(document).trigger('focus');
	var json = eval('('+jsonstr+')');
	var id=json.id;
	var bookid=json.bookid;
	var name=json.name;
	var url=json.url;
	var author=json.author;
	var site=json.site;
	var pic=json.pic;
	var pid=json.pid;
	var gtype=json.gtype;
	var open_pos=json.open_pos;
	ret = ret.replace(/[\"]/g,'');//alert('mmm');
	var a = eval('('+ret+')');//alert(gtype);
	
	if(gtype=='1'){//alert(a.s);
		pobj.now_url=url;
		external.setieurl(bookid,url,'');
		//没取到章节列表
		if(parseInt(a.s)==0 && a.m.length==0){
			//$('<span>最新章节获取失败</span>').css('color','red').appendTo('#nsource_new>span');
			$('#nsource_new>span>.loadspan').html('<font color=red>最新章节获取失败</font>');
			$('<li>最新章节获取失败</li>').css('color','red').appendTo('#chapters>ul');
			return false;
		};
		jsonstr=jsonstr.replace("'gtype':'1'","'gtype':'4'");
		jsonstr=jsonstr.replace(/\\{1,}/g,'\\\\');
		jsonstr=jsonstr.replace(/'/g,'\\\'');

		var tmpchar='';
		var arrb = new Array();
		arrb.push('<ul>');
		var ni=0;
		for(var i=0;i<a.m.length;i++){
			var chapter_name=a.m[i].n;
			var chapter_url=a.m[i].u;
			if(chapter_url==''){
				arrb.push('<li class="tit bg_tit">');
				arrb.push(chapter_name);
				arrb.push('</li>');
			}else{
				ni = i;
				arrb.push('<li><a  title="');
				arrb.push(chapter_name);
				arrb.push('" href="javascript:void(0);" onclick="load_chaptercon(\'');
				arrb.push(chapter_url);
				arrb.push('\',\'');
				arrb.push(jsonstr);
				arrb.push('\',\'');
				arrb.push(chapter_name);
				arrb.push('\',\'');
				arrb.push(i);
				arrb.push('\');">');
				arrb.push(chapter_name);
				arrb.push('</a></li>');
			}
		}
		tmpchar='<a  title="'+a.m[ni].n+'" href="javascript:void(0);" onclick="load_chaptercon(\''+a.m[ni].u+'\',\''+jsonstr+'\',\''+a.m[ni].n+'\',\''+ni+'\');">'+a.m[ni].n+'</a>';
		arrb.push('<div class="clear"></div></ul>');
		var b=arrb.join('');
		//alert(pobj.json_mulu.m.length+'\r\n'+a.m.length);
		if(pobj.json_mulu==null || pobj.json_mulu.m.length<a.m.length){
			document.getElementById('chapters').innerHTML=b;//alert('写入章节列表');
		}
		$('#chapters').attr('dur',ni);
		b=null;arrb=null;//alert(tmpchar);
		if(a.s=='0'){
			$('#nsource_new>span').html(tmpchar);
		}else{
			$('#nsource_new>span').html(tmpchar+'&nbsp;<span class="loadspan"><img src="img/loading.gif" border="0"><span style="font-size:12px;color:#aaa;font-weight:normal;">&nbsp;正在在线检测最新章节...</span></span>');
		}
		pobj.json_mulu = a;
		if(open_pos=='parent'){
			var url_pre = get_curl(ni,'pre');
			var url_next = get_curl(ni,'next');
			pobj.chapter_pos.url_pre.nurl=url_pre;
			pobj.chapter_pos.url_next.nurl=url_next;
			pobj.chapter_pos.url_now.npos=ni;
		}
		arrb=null;
		set_style('mulu');
	}

	if(gtype=='4'){
		jsonstr=jsonstr.replace(/'/g,'\\\'');
		if(a.m.length==0){
			$('#chapter_con').html('<div style="font-size:12px;width:100%;text-align:center;margin:30px;"><div style="color:red;">章节内容加载失败！</div><div>您可以尝试：<a href="javascript:void(0);" onclick="reload_chapter(\''+jsonstr+'\');">刷新本页</a></div></div>');
			return false;
		};
		if(rurl==pobj.chapter_pos.url_now.nurl){
			$('#chapter_func').html('<a href="javascript:void(0);" onclick="reload_chapter(\''+jsonstr+'\');" id="refresh_chapter">刷新本页</a>');
			if(a.s=='1'){
				var imghtml='';
				var img=a.m.split('#');
				for(var i=0;i<img.length;i++){
					imghtml+='<div style="text-align:center;width:100%;"><img src="'+img[i]+'" onload="r_imgsize(this);"></div>';
				}
				$('#chapter_con').html(imghtml);
			}else{
				$('#chapter_con').html(a.m);
			}
			var rname=is_book_repeat(name);
			var rname_stie=is_book_repeat(name,site);
			if(rname!=rname_stie){
				var nurl = pobj.chapter_pos.url_next.nurl;
				var pa=external.toparam();var pb=eval('('+pa+')');
				if(nurl!='' && pb.cache=='1'){
					external.OperBook(bookid,4,nurl,'');
				}
			}
		}
	}
	
}

//重设图片大小
function r_imgsize(t){
	var a=external.toparam();var b=eval('('+a+')');
	var img=$(t);
	var win_width=$(window).width()-20;	//窗口宽度
	var img_width=img.width();	//原图宽度
	var new_width=img_width*(b.img_width/100);	//新图宽度
	if(new_width>win_width){new_width=win_width;}

	img.css('width',new_width+'px');
	img.parent().parent().parent().parent().css('width','100%');
}

//图片右键功能
function fimg(s){
	external.toparam_img_width(s,1)
	//$('#refresh_chapter').trigger('click');
}

//刷新章节内容
function reload_chapter(jsonstr){
	load_chaptercon(pobj.chapter_pos.url_now.nurl,jsonstr,pobj.chapter_pos.url_now.cname,pobj.chapter_pos.url_now.npos);
}

//判断上一章和下一章URL
function get_curl(pos,type){
	try{
	pos=parseInt(pos);
	var a = pobj.json_mulu;
	if(a==null){return '';}
	if(type=='pre'){
		if(pos>0){
			var tmp_url=a.m[pos-1].u;
			if(tmp_url==''){
				get_curl(pos-1,'pre');
			}else{
				pobj.chapter_pos.url_pre.npos=pos-1;
				pobj.chapter_pos.url_pre.cname=a.m[pos-1].n;
				return tmp_url;
			}
		}else{
			pobj.chapter_pos.url_pre.nurl='';
			return '';
		}
	}

	if(type=='next'){
		if(pos<a.m.length-1){//alert(a.m[1].u);
			var tmp_url=a.m[pos+1].u;
			if(tmp_url==''){
				get_curl(pos+1,'next');
			}else{
				pobj.chapter_pos.url_next.npos=pos+1;
				pobj.chapter_pos.url_next.cname=a.m[pos+1].n;
				return tmp_url;
			}
		}else{
			pobj.chapter_pos.url_next.nurl='';
			return '';
		}
	}
	}catch(e){return '';}
}

//载入章节内容
function load_chaptercon(url,jsonstr,cname,npos){
	npos=parseInt(npos);
	jsonstr=jsonstr.replace("'gtype':'1'","'gtype':'4'");
	jsonstr=jsonstr.replace(/\\{1,}/g,'\\\\');
	var a=eval('('+jsonstr+')');
	var url_pre = get_curl(npos,'pre');
	var url_next = get_curl(npos,'next');
	pobj.chapter_pos.url_pre.nurl=url_pre;
	pobj.chapter_pos.url_next.nurl=url_next;
	pobj.chapter_pos.url_now.npos=npos;
	pobj.chapter_pos.url_now.cname=cname;
	pobj.chapter_pos.url_now.nurl=url;
	//滚动到最上面
	$("html,body").animate({scrollTop:$('#topdiv').offset().top},0);//alert(g_postion);
	//如果在目录页，则层显隐
	if(g_postion==0){
		$('#mulu').css('display','none');
		$('#chapter').css('display','block');
	}
	g_postion = 1;
	//最后阅读位置
	var readpos='{"pos":'+npos+',"dur":'+$('#chapters').attr('dur')+',"cname":"'+cname+'","url":"'+url+'"}';//alert("{'act':'update','bookid':'"+a.bookid+"','readpos':'"+readpos+"'}");
	external.bookoper("{'act':'update','bookid':'"+a.bookid+"','readpos':'"+readpos+"'}");
	//同步软件IE地址
	pobj.now_url=url;
	pobj.cname=cname;
	external.setieurl(a.bookid,url,cname);
	//更新历史记录
	update_history(a.id,a.name,a.bookid,a.url,a.site,a.author,a.pic,url,cname,a.pid);
	//设置为Loading
	loadstr($('#chapter_con'),'<div style="width:100%;text-align:center;margin:30px;">','</div>');
	//显示章节名
	$('#chapter_name').html(cname);

	clearTimeout(t_req_chapter);
	t_req_chapter=setTimeout(function(){
		//发送章节请求
		var n_jsonstr="{'chaptername':'"+cname+"',"+jsonstr.substr(1);
		//alert(n_jsonstr);
		get(a.bookid,a.gtype,url,n_jsonstr);
	},200);
	clear_isupdate(a.bookid);
	//统计PV
	external.t_pv('?bookname='+a.name);
	//清空最末章检测云端计时器
	window.clearInterval(g_lastcheck);
}

//记录最近阅读数据 
function update_history(id,name,bookid,url,site,author,pic,chapterurl,cname,pid){
	var v="{\'id\':\'"+id+"\',\'name\':\'"+name+"\',\'bookid\':\'"+bookid+"\',\'url\':\'"+url+"\',\'gtype\':\'1\',\'site\':\'"+site+"\',\'author\':\'"+author+"\',\'pic\':\'"+pic+"\',\'pid\':\'"+pid+"\',\'open_pos\':\'parent\',\'chapterurl\':\'"+chapterurl+"\',\'cname\':\'"+cname+"\'}";
	v = v.replace(/\\{1,}/g,'\\\\');
	var h=external.specialkey('history');//alert(h);
	if(h.length==0){
		hstr='['+v+']';
	}else{
		try{var a=eval('('+h+')');}catch(e){show_alert('操作提示 - 错误','最近阅读数据格式错误');return false;}
		hstr='';
		var si=null;
		for(var i=0;i<a.length;i++){
			//最近阅读保存N本，如果N=2则，break为1
			if(i>=9){break;}
			var t="{\'id\':\'"+a[i].id+"\',\'name\':\'"+a[i].name+"\',\'bookid\':\'"+a[i].bookid+"\',\'url\':\'"+a[i].url+"\',\'gtype\':\'1\',\'site\':\'"+a[i].site+"\',\'author\':\'"+a[i].author+"\',\'pic\':\'"+a[i].pic+"\',\'pid\':\'"+pid+"\',\'open_pos\':\'parent\',\'chapterurl\':\'"+a[i].chapterurl+"\',\'cname\':\'"+a[i].cname+"\'}";
			t = t.replace(/\\{1,}/g,'\\\\');
			if(a[i].name==name){//同一书名则替换
				t=v;si=i;
			}
			hstr+=','+t
		}
		if(si==null){
			hstr='['+v+','+hstr.substr(1)+']';
		}else{
			hstr='['+hstr.substr(1)+']';
		}
		hstr=hstr.replace('\\','\\');
		//alert(si+'\r\n'+hstr);
	}
	external.specialkey('history',hstr);
	external.execjsfunc(2,"get_shelfbook('最近阅读','history');");
}

//删除某条最近阅读数据
function del_history(name){
	var h=external.specialkey('history');
	var a=eval('('+h+')');
	hstr='';
	for(var i=0;i<a.length;i++){
		var t="{\'id\':\'"+a[i].id+"\',\'name\':\'"+a[i].name+"\',\'bookid\':\'"+a[i].bookid+"\',\'url\':\'"+a[i].url+"\',\'gtype\':\'1\',\'site\':\'"+a[i].site+"\',\'author\':\'"+a[i].author+"\',\'pic\':\'"+a[i].pic+"\',\'pid\':\'0\',\'open_pos\':\'parent\',\'chapterurl\':\'"+a[i].chapterurl+"\',\'cname\':\'"+a[i].cname+"\'}";
		t = t.replace(/\\{1,}/g,'\\\\');
		if(a[i].name!=name){//同一书名则替换
			hstr+=','+t;
		}
	}
	hstr='['+hstr.substr(1)+']';
	external.specialkey('history',hstr);
	get_shelfbook('最近阅读','history');
}

//清空最近阅读确认层
function clear_history(){
	show_confirm(300,100);
	var sdiv= '';
	sdiv += '<p>确定要删除所有最近阅读的记录吗？（<font color=red>慎重</font>）</p>';
	sdiv += '<p><a class="l but1" onclick="clear_history_act();">确定</a><a class="l but1" onclick="hide_confirm();">取消</a></p>';
	$('#cofirmdiv>.ccon').html(sdiv);
	$('#cofirmdiv>.ctitle>.l').html('操作提示 - 清空最近阅读');
}

//清空最近阅读
function clear_history_act(){
	external.specialkey('history','');
	get_shelfbook('最近阅读','history');
	hide_confirm();
}

//回目录
function go_mulu(){
	g_postion = 0;
	$('#mulu').css('display','block');
	$('#chapter').css('display','none');
	try{
		var a=pobj.jsonstr;
		pobj.now_url=a.url;
		external.setieurl(a.bookid,a.url,'');
	}catch(e){}
	$("html,body").animate({scrollTop:$('#topdiv').offset().top},0);
}

//上一章下一章
function go_curl(t){
	var curl='';var cname='';var npos='';var ncon='';
	var o1,o2;
	if(t=='pre'){
		o1=pobj.chapter_pos.url_pre;
		curl=o1.nurl;
		cname=o1.cname;
		npos=o1.npos;
		ncon='no';
	}
	if(t=='next'){
		o2=pobj.chapter_pos.url_next;
		curl=o2.nurl;
		cname=o2.cname;
		npos=o2.npos;
		ncon='';
	}
	o1=null;o2=null;
	var a=pobj.jsonstr;
	if(curl==''){
		if(ncon=='no') return false;
		if(pobj.json_mulu==null) return false;
		var server_html=$('#server_source>ul').html();
		$('#chapter_name').html('当前源没有新章节');
		pobj.chapter_pos.url_pre.nurl=get_curl(pobj.json_mulu.m.length,'pre');
		pobj.chapter_pos.url_pre.cname=pobj.cname;
		//pobj.chapter_pos.url_pre.npos=pobj.chapter_pos.url_next.npos;
		g_lastcheck=window.setInterval(function(){
			$('#chapter_con').html('<div id="last" style="font-size:12px;color:#8c8c8c;"><div style="width:100%;height:40px;font-weight:bold;text-align:center;">您还可以查看下面其它来源是否有最新章节</div><ul>'+server_html+'</ul></div>');
			if(server_html.indexOf('加载中')>0){
				server_html=$('#server_source>ul').html();
			}else{
				window.clearInterval(g_lastcheck);
			}
		},100);
	}else{
		load_chaptercon(curl,jsonstr,cname,npos)
		//get(a.bookid,a.gtype,curl,jsonstr);
	}
}

//发送请求取章节目录或者章节内容
function get(bookid,gtype,url,str){//alert(str);
	//param1：bookid
	//param2：值1，4，1获取章节目录4获取章节内容
	//param3：URL
	//param4：预留参数
	pobj.jsonstr=eval('('+str+')');
	external.OperBook(bookid,gtype,url,str);
}

//取到章节目录或者内容后回调函数
function t_operbook(bookid,gtype,url,str,nr){
	//alert('阅读返回目录/内容结果：'+nr);
	if(gtype=='1'){nr=nr.replace(/(><)/g,'');}//alert(url);
	find_iframe(str,nr,url);
}

//接收云端数据并回传到IFRAME
function t_serverdata(bookid,v){
	var fid=bookid
	$('iframe').each(function(){
		var c=$(this).attr('src');//alert(c);//alert(c.indexOf('\'bookid\':\''+fid+'\'')+'\r\n'+fid+'\r\n'+c);
		if(c!='read_default.html'){
			if(c.indexOf('\'bookid\'%3A\''+fid+'\'')>=0 || c.indexOf('\'id\'%3A\''+fid+'\'')>=0){
				var ifrid=$(this).attr('id');
				var ifr=document.getElementById(ifrid);
				ifr.contentWindow.load_server(v);
				return '';
			}
		}
	});

}

//设置阅读风格
function set_style(s){
	//读取系统参数
	var a=external.toparam();
	var b=eval('('+a+')');//alert(a);
	var read_theme=b.read_theme;
	var read_font=b.read_font;
	var read_size=b.read_size;

	 //主题
	 var theme=[
		  //灰色经典
		 {"font_family":"宋体","font_size":"18px","font_color":"#3f2a18","bg_body":"#f8f8f8","bg_mdiv":"#fcfcfc","border_color":"#ebebeb","bg_tit":"#f7f7f7","a_color":"#000000","a_hcolor":"red"},
		 //明黄清俊
		 {"font_family":"宋体","font_size":"18px","font_color":"#3f2a18","bg_body":"#FFFFDD","bg_mdiv":"#ffffef","border_color":"#E3E197","bg_tit":"#faf8b6","a_color":"#9c662a","a_hcolor":"red"},
		//绿意淡雅
		 {"font_family":"宋体","font_size":"18px","font_color":"#3f2a18","bg_body":"#F2FDDB","bg_mdiv":"#ffffff","border_color":"#ADCD3C","bg_tit":"#d8efbc","a_color":"#529602","a_hcolor":"red"},
		//红粉世家
		 {"font_family":"宋体","font_size":"18px","font_color":"#3f2a18","bg_body":"#FFF5FA","bg_mdiv":"#fef8fb","border_color":"#F8B3D0","bg_tit":"#fecee2","a_color":"#d63579","a_hcolor":"red"},
		//夜晚模式
		 {"font_family":"宋体","font_size":"18px","font_color":"#8c8c8c","bg_body":"#000000","bg_mdiv":"#808080","border_color":"#585858","bg_tit":"#6f6f6f","a_color":"#353535","a_hcolor":"#c9c9c9"}
	];

	var style=read_theme;//alert(style);
	var bg_body=theme[style].bg_body;
	var border_color=theme[style].border_color;
	var bg_tit=theme[style].bg_tit;
	var bg_mdiv=theme[style].bg_mdiv;
	var font_family=theme[style].font_family;
	var font_size=theme[style].font_size;
	var font_color=theme[style].font_color;
	var a_color=theme[style].a_color;
	var a_hcolor=theme[style].a_hcolor;
	var rfont,rsize;
	if(read_font.length>0){rfont=read_font;}else{rfont=font_family;}
	if(read_size.length>0){rsize=read_size;}else{rsize=font_size;}
	
	if(s=='server_source' || s=='mulu'){
		$('.bg_tit').css({'background':bg_tit});
	}else{
		$('.bg_tit').css({'background':bg_tit});

		$('#body').css({'background':bg_body,'font-family':font_family});

		$('#book_desc').css({'border':'1px solid '+border_color,'background':bg_mdiv});
		$('#server_source').css({'border':'1px solid '+border_color,'background':bg_mdiv});
		$('#chapters').css({'border':'1px solid '+border_color,'background':bg_mdiv});
		
		$('#chapter').css({'color':font_color});
		$('#chapter_name').css('font-family',rfont);
		$('#chapter_con').css({'font-family':rfont,'font-size':rsize});
		$('#bot_func').css('font-family',rfont);
	}
	//清除所有超链样式
	var book_read_main = $('#book_read_main')
	for(var i=0;i<theme.length;i++){
		if(book_read_main.hasClass('theme_a'+i)){
			book_read_main.removeClass('theme_a'+i);
		}
	}
	//新增超链样式
	book_read_main.addClass('theme_a'+style);
	//alert(book_read_main.hasClass('theme_a'+style));
}
//external.message_pop('{"bookid":"book_1325762454_346"}');
//更新检测
function t_askhaveupdate(bookid,rtag){
	//alert('检测更新返回BOOKID'+bookid);
	if($('#list1').html()!=null){
		setpos_shelf(g_shelf_name);
		//查找是否有打开的iframe，并且刷新目录
		external.execjsfunc(3,"refresh_iframe('"+bookid+"','"+rtag+"');");
		//弹出气泡
		var a=external.toparam();var b=eval('('+a+')');var pop=b.pop;var spop=b.spop;
		var c=external.bookoper("{'act':'get','bookid':'"+bookid+"'}");var d=eval('('+c+')');var updatetime=d.updatetime;
		if(pop=='1'){
			external.message_pop('{"bookid":"'+bookid+'"}');
		}
		//闪烁托盘图标
		if(spop=='1'){
			external.sicon(1);
		}
	}
}

//设置改变
function t_changeparam(){
	var a=external.toparam();
	var b=eval('('+a+')');//alert(a);
	var read_theme=b.read_theme;
	var read_font=b.read_font;
	var read_size=b.read_size;
	//alert('保存设置\r\n'+$('iframe').length);
	var i=0;
	$('iframe').each(function(){
		var c=$(this).attr('src');
		if(i>0){
			var ifrid=$(this).attr('id');
			var ifr=document.getElementById(ifrid);
			ifr.contentWindow.set_style();
			if($('#'+ifrid).contents().find('#chapter').css('display')=='block'){
				$('#'+ifrid).contents().find('#refresh_chapter').trigger('click');
			}
		}
		i++;
	});
}

