/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.ashxml;

import java.io.IOException;
import java.io.InputStream;

public class BufferedCharReader {
    private InputStream inStream = null;
    private byte[] buffer = null;
    private int currentBufferSize = 0;
    private int currentBufferIndex = 0;
    private char nextChar = (char)32;
    private boolean eof = false;
    private boolean moreChars = true;

    public BufferedCharReader(InputStream inStream) {
        this.init(inStream, 512);
    }

    public BufferedCharReader(InputStream inStream, int bufferSize) {
        this.init(inStream, bufferSize);
    }

    private void init(InputStream inStream, int bufferSize) {
        this.inStream = inStream;
        this.buffer = new byte[bufferSize];
        this.getNextChar();
    }

    public String peekString(int length) {
        if (length >= this.currentBufferSize) {
            return null;
        }
        if (this.currentBufferSize - this.currentBufferIndex - 1 >= length) {
            return this.nextChar + new String(this.buffer, this.currentBufferIndex, length - 1);
        }
        int j = 0;
        for (int i = this.currentBufferIndex; i < this.currentBufferSize; ++i) {
            this.buffer[j] = this.buffer[i];
            ++j;
        }
        try {
            int readen = this.inStream.read(this.buffer, j, this.buffer.length - j);
            if (readen < 0) {
                this.eof = true;
            }
            this.currentBufferSize = j + readen;
            this.currentBufferIndex = 0;
            return this.nextChar + new String(this.buffer, 0, length - 1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean hasMoreChars() {
        return this.moreChars;
    }

    public char peekChar() {
        return this.nextChar;
    }

    public char popChar() {
        char result = this.nextChar;
        this.getNextChar();
        return result;
    }

    private void getNextChar() {
        this.fillBuffer();
        if (!this.eof) {
            this.nextChar = (char)this.buffer[this.currentBufferIndex];
            ++this.currentBufferIndex;
        } else {
            this.moreChars = false;
            this.nextChar = (char)32;
        }
    }

    private void fillBuffer() {
        if (this.currentBufferIndex < this.currentBufferSize) {
            return;
        }
        try {
            this.currentBufferSize = this.inStream.read(this.buffer);
            if (this.currentBufferSize < 0) {
                this.eof = true;
            }
            this.currentBufferIndex = 0;
        }
        catch (IOException ex) {
            this.eof = true;
        }
    }
}

